<%
/*
 *       Name            :      Egconfigudconfigtestp.jsp
 *       Purpose         :		IC - Component - Config Test (Configuration tests) - process page
 *       CreationDate    :      01/10/2001
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import="net.sf.json.JSONObject"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	egurkha.ServiceBean serviceBean = new egurkha.ServiceBean();
	String server = request.getParameter("server");
	String configTestList = request.getParameter("fassociate");
	String oldConfigTestList = request.getParameter("configtestlist");
	String oldTestList = request.getParameter("testlist");
	
	if(configTestList==null) configTestList="";
	if(oldConfigTestList==null) oldConfigTestList="";
	if(oldTestList==null) oldTestList="";

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Component");

	boolean associated = false;
	boolean disassociated = false;

	ArrayList currentList = new ArrayList();
	if(configTestList !=null && !configTestList.equals("null") && configTestList.trim().length()>0)
	{
		if(configTestList.endsWith(","))
		{
			configTestList = configTestList.substring(0,configTestList.length()-1);
		}
		StringTokenizer tokens = new StringTokenizer(configTestList,",");
		while(tokens.hasMoreTokens())
		{
			String test = ((String)tokens.nextToken()).trim();
			if(test.length()>0)
			{
				if(!currentList.contains(test))
					currentList.add(test);
			}
		}
	}
	if(oldConfigTestList !=null && !oldConfigTestList.equals("null") && oldConfigTestList.trim().length()>0)
	{
		StringTokenizer tokens = new StringTokenizer(oldConfigTestList,",");
		while(tokens.hasMoreTokens())
		{
			String test = ((String)tokens.nextToken()).trim();
			if(test.length()>0 && !currentList.contains(test))
			{
				auditLogThread.setCurrentValue("Disassociated Test(s)","$test$:"+test);
				disassociated = true;
			}
			else
				currentList.remove(test);
		}
	}
	if(currentList.size()>0)
	{
		for(int i=0;i<currentList.size();i++)
		{
			auditLogThread.setCurrentValue("Associated Test(s)","$test$:"+currentList.get(i));
			associated = true;
		}
	}
	if(associated && disassociated) 
	{
		auditLogThread.setValue("Description","Tests have been associated and disassociated for server "+"$ctype$:"+server);
		auditLogThread.sendItToDB();
	}
	else if(associated)
	{
		auditLogThread.setValue("Description","Tests have been associated to server "+"$ctype$:"+server);
		auditLogThread.sendItToDB();
	}
	else if(disassociated)
	{
		auditLogThread.setValue("Description","Tests have been disassociated from server "+"$ctype$:"+server);
		auditLogThread.sendItToDB();
	}
	/* code for auditlog ends */
	String testList="";
	String tmpOldTestList="";
	
	if(oldTestList.length()==0)
	{
		if(configTestList.trim().length()!=0)
		{
			testList=configTestList;
		}
		if(oldConfigTestList.trim().length()!=0)
		{
			tmpOldTestList=oldConfigTestList;
		}
	}
	else
	{
		if(configTestList.trim().length()!=0)
		{
			String tempTestList=null;
			StringTokenizer st=new StringTokenizer(oldTestList,",");
			int count=st.countTokens();
			for(int n=0;n<count;n++)
			{
				String testName=st.nextToken();
				if(!EgInstallInfo.isConfigTest(testName))
				{
					if(tempTestList==null)
					{
						tempTestList=testName;
					}
					else
					{
						tempTestList=tempTestList+","+testName;
					}
				}
			}
			if(tempTestList==null)
			{
				testList=configTestList;
			}
			else
				testList=tempTestList+","+configTestList;
		}
		else
		{
			String tempTestList=null;
			StringTokenizer st=new StringTokenizer(oldTestList,",");
			int count=st.countTokens();
			for(int n=0;n<count;n++)
			{
				String testName=st.nextToken();
				if(!EgInstallInfo.isConfigTest(testName))
				{
					if(tempTestList==null)
					{
						tempTestList=testName;
					}
					else
					{
						tempTestList=tempTestList+","+testName;
					}
				}
			}
			if(tempTestList==null)
				testList="";
			else
				testList=tempTestList;
		}
		if(oldConfigTestList.trim().length()!=0)
			tmpOldTestList=oldTestList+","+oldConfigTestList;
		else
			tmpOldTestList=oldTestList;
	}


	//String ur = "EgConfigUDServer.jsp?server=" + server;
	rootJSON.put("server",server);
	if(testList == null || testList.length() == 0)
	{
		rootJSON.put("loadConfigLayerPage",true);
		out.println(rootJSON);
		return;
	}

	//Fix-starts
	IniFile specs = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_specs.ini"); 
	String testMapVal = specs.getValue("TEST_MAPPING",server);
	ArrayList testMapList = StringUtils.egTokenizer(testMapVal,",");
	
	ArrayList newAssoList = StringUtils.egTokenizer(testList,",");
	ArrayList oldAssoList = StringUtils.egTokenizer(tmpOldTestList,",");
	newAssoList = (newAssoList == null)?new ArrayList():newAssoList;
	oldAssoList = (oldAssoList == null)?new ArrayList():oldAssoList;
	testMapList = (testMapList == null)?new ArrayList():testMapList;

	//newAssoList.removeAll(oldAssoList);
	List removedTests = new ArrayList();
	List addedTests = new ArrayList();
	for (int i=0; i<oldAssoList.size(); i++)
	{
		String oldTest = (String)oldAssoList.get(i);
		if (!newAssoList.contains(oldTest))
		{
			removedTests.add(oldTest);
		}
	}
	for (int i=0; i<newAssoList.size(); i++)
	{
		String newTest = (String)newAssoList.get(i);
		if (!oldAssoList.contains(newTest))
		{
			addedTests.add(newTest);
		}
	}
	testMapList.addAll(addedTests);
	testMapList.removeAll(removedTests);
	String testMapResult = "";
	for (int t=0; t<testMapList.size(); t++)
	{
		String tmp = (String)testMapList.get(t);
		testMapResult += tmp+",";
	}
	if (testMapResult.endsWith(","))
	{
		testMapResult = testMapResult.substring(0,testMapResult.length()-1);
	}

	//Ends

	egurkha.TestBean testBean = new egurkha.TestBean(true);
	testBean.setTestsForServer(server, testList, tmpOldTestList,testMapResult);
	//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
	IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
	serviceBean.stopDiscovery();
	serviceBean.startDiscovery("1");
	EgConfigFilesSync.releaseInstance(infraIni);
	//response.sendRedirect("EgConfigUDTest.jsp?server=" + server);
	//String url = "EgConfigUDConfigTest.jsp?server=" + server;

	rootJSON.put("AlertType","Result");
	rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Integration Console - Component"));
	rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Tests have been configured successfully"));
	out.println(rootJSON);
%>








