<%
/*
 *   File		:	EgEnableDisableTestsp.jsp
 *   Purpose	:	Processing page
*/
%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.admin.EnableDisableTests" %>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	String enabledTestsListOnly = "";
	String disabledTestsListOnly = "";
	
	String enabledTests = request.getParameter("enabledTestList");
	String disabledTests = request.getParameter("disabledTestList");
	String componentType = request.getParameter("componentType");
	String testType = request.getParameter("testType");
	String enableTests_Only = request.getParameter("enableTests_Only");
	String disableTests_Only = request.getParameter("disableTests_Only");
	
	if (!StringUtils.isNull(disableTests_Only))
	{
		StringTokenizer stnDisables = new StringTokenizer(disableTests_Only,",");
		while(stnDisables.hasMoreTokens())
		{
			disabledTests += ","+stnDisables.nextToken();
		}
		if(disabledTests.startsWith(","))
		{
			disabledTests = disabledTests.substring(1);
		}			
	}

	if (testType == null || testType.length() == 0)
	{
		testType = "PerformanceTest";
	}
	
	EnableDisableTests objEnabDisableTest = new EnableDisableTests(_user.getLoginID(),_user.getUserIP(session.getId()),session.getId()) ;

	//tell whether _cf test enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);

		objEnabDisableTest.setConfigSupported(isConfigSupported);
	}

	objEnabDisableTest.setParams(
		componentType,
		enabledTests,
		disabledTests,
		testType
	);

	String updatedResult = objEnabDisableTest.doProcess();

	if (!StringUtils.isNull(componentType)) 
	{
		if (!StringUtils.isNull(disableTests_Only) )
		{
			IniFile mgrMiscObj = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
			String[] allVariablesArr = mgrMiscObj.getVariables("ASSOCIATED_CORRECTIVE_SCRIPTS");
			ArrayList disableTestList = StringUtils.egTokenizer(disableTests_Only,",");
			Vector delVariableVector = new Vector();
			if (allVariablesArr != null && allVariablesArr.length > 0)
			{
				for (int a=0; a<allVariablesArr.length; a++)
				{
					String miscFileVariable = (String) allVariablesArr[a];
					if (miscFileVariable.startsWith(componentType))
					{
						for (int c=0; c<disableTestList.size(); c++)
						{
							String disableTestStr = (String) disableTestList.get(c);
							if (miscFileVariable.indexOf(":"+disableTestStr) > -1)
							{
								delVariableVector.add(miscFileVariable);
							}
						}
					}
				}
			}
			if (delVariableVector != null && delVariableVector.size() > 0)
			{
				mgrMiscObj.deleteValues("ASSOCIATED_CORRECTIVE_SCRIPTS", delVariableVector);
			}
			mgrMiscObj.saveFile();
			EgConfigFilesSync.releaseInstance(mgrMiscObj);
		}
	}
	rootJson.put("requestStatus","success");
	JSONObject resultMsg = new JSONObject();
	resultMsg.put("title",_mapping.getTextDescription("admin.title.ENABLE/DISABLE TESTS"));
	resultMsg.put("message1",_mapping.getTextDescription("admin.test.Tests have been enabled/disabled successfully")+".");
	rootJson.put("result",resultMsg);

	//System.out.println("rootJson_____"+rootJson);
	out.println(rootJson.toString());
%>



