<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "java.util.*"%>
<%@ page import = "net.sf.json.JSONObject"%>
<jsp:useBean id="serviceBean" scope="page" class="egurkha.ServiceBean"/>

<%
	JSONObject rootObj = new JSONObject();
	rootObj.put("success","true");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	/* code for auditlog starts */
	boolean auditFlag = false;
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Discover");
	/* code for auditlog ends */

	
	String servivesFile = "eg_services.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	IniFile servicesIniFile = new IniFile(s_iniFile_dir + servivesFile);
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	IniFile servicesIniFileWr = null;
	String agFile = "eg_agents.ini";
	String agFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";

	String sub = "ORACLE_VM_MANAGER";
	String[] allKeys = servicesIniFile.getVariables(sub);

	/* code for audit log starts */
	String selCtxXenPoolIP = request.getParameter("ipAdd");
	/* code for audit log ends */

	String server = "Oracle VM Manager";
	
	String from = request.getParameter("from"); 
	String ipAddress = selCtxXenPoolIP;
	String UName = request.getParameter("uname");
	UName = egurkha.EgUIUtils.decodeSecurityChar(UName);
	String UPass = request.getParameter("pass");
	UPass = egurkha.EgUIUtils.decodeSecurityChar(UPass);
	String curPwd = UPass;
	//String hName = request.getParameter("hName");
	String ssl = request.getParameter("ssl");
	String isDis = request.getParameter("isDiscovery");
	String webPort = request.getParameter("webport");
	String refferalURL = request.getParameter("refferalURL");
	if (refferalURL == null)
	{
		refferalURL = "";
	}
	
	if(ipAddress != null && UName != null && UPass != null && ssl != null && isDis != null && webPort != null)
	{
		UPass = EgCrypt.encrypt(UPass);
		boolean ipExists=false;
		for(int i=0;i<allKeys.length;i++)
		{
			String s=allKeys[i];
			if(ipAddress.equalsIgnoreCase(s))
			{
				ipExists = true;
			}
		}
		String subVal = "";
		if(from.equalsIgnoreCase("oracleVMAdd") || from.equalsIgnoreCase("oracleVMAddDiscovery"))
		{
			if(ipExists)
			{
				auditLogThread.setValue("Activity","Existing IP");
				ipExists = false;
				rootObj.put("requestStatus","failed");
				JSONObject errorObj = new JSONObject();
				errorObj.put("title",_mapping.getTextDescription("admin.discovery.Add new"));
				errorObj.put("message1",ipAddress +" - "+_mapping.getTextDescription("admin.discovery.is already exists")+". "+_mapping.getTextDescription("admin.discovery.try to discover with another"));
				auditLogThread.setValue("Description",ipAddress+" already exists.Update another "+ server);
				auditLogThread.sendItToDB();
				rootObj.put("errors",errorObj);
				out.println(rootObj.toString());
				return ;
			}
			else
			{
				subVal = ssl+"#"+UName+"#"+UPass+"#"+isDis+"#"+webPort;
				servicesIniFileWr = EgConfigFilesSync.getInstance(s_iniFile_dir + servivesFile);
				servicesIniFileWr.setValue(sub,ipAddress,subVal);
				servicesIniFileWr.saveFile();
				EgConfigFilesSync.releaseInstance(servicesIniFileWr);
				servicesIniFile = new IniFile(s_iniFile_dir + servivesFile);
				if(from.equalsIgnoreCase("oracleVMAdd"))
				{
					String conSSL = ssl.equalsIgnoreCase("True")?"Yes":"No";
					
					//AuditLog - Code starts
					auditLogThread.setValue("Activity","Add Oracle VM Manager discovery");
					auditLogThread.setCurrentValue("ColumnName","Oracle VM Manager Added");
					auditLogThread.setCurrentValue("00~~IP address of Oracle VM Manager",ipAddress);
					auditLogThread.setCurrentValue("01~~Use SSL to connect to Oracle VM Manager",conSSL);
					auditLogThread.setCurrentValue("02~~Discover Oracle VM Servers using this Citrix XenServer",isDis);
					auditLogThread.setCurrentValue("03~~Username to connect to Oracle VM Servers",UName);
					auditLogThread.setCurrentValue("04~~Password for the user","*****");
					auditLogThread.setValue("Description","Oracle VM Manager preferences have been added successfully");
					auditLogThread.sendItToDB();

					rootObj.put("requestStatus","success");
					JSONObject resultMsg = new JSONObject();
					resultMsg.put("title",_mapping.getTextDescription("admin.discovery.Add new"));
					resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Details have been added successfully"));
					rootObj.put("result",resultMsg);

					out.println(rootObj.toString());
					return ;
				}
			}
		}
		else if(from.equalsIgnoreCase("oracleVMModify") || from.equalsIgnoreCase("oracleVMModifyDisovery"))
		{
			/* code for audit log starts */
			String curSSL = ssl;
			String curisDiscovery = isDis;
			String curUname = UName;
			String checkSSL = curSSL.equalsIgnoreCase("True")?"Yes":"No";
			String preSSL = request.getParameter("$_ssl");
			String preisDiscovery = request.getParameter("$_isDiscovery");
			String preUname = request.getParameter("$_uname");
			preUname = egurkha.EgUIUtils.decodeSecurityChar(preUname);
			String preUPass = request.getParameter("$_confpasswd");
			preUPass = egurkha.EgUIUtils.decodeSecurityChar(preUPass);

			String preWebPort = request.getParameter("$_webport");
			/*code for audit log ends*/

			subVal = ssl+"#"+UName+"#"+UPass+"#"+isDis+"#"+webPort;
			String checkOldEntry = servicesIniFile.getValue(sub,ipAddress);
			if (checkOldEntry == null || !checkOldEntry.equalsIgnoreCase(subVal))
			{
				servicesIniFileWr = EgConfigFilesSync.getInstance(s_iniFile_dir + servivesFile);
				servicesIniFileWr.setValue(sub,ipAddress,subVal);
				servicesIniFileWr.saveFile();
				EgConfigFilesSync.releaseInstance(servicesIniFileWr);
				servicesIniFile = new IniFile(s_iniFile_dir + servivesFile);
			}
	
			if(!(checkSSL.equals(preSSL) && curisDiscovery.equals(preisDiscovery) && curUname.equals(preUname) && curPwd.equals(preUPass)))
			{
				auditFlag = true;
			}
			auditLogThread.setValue("Activity","Modify Oracle VM Manager discovery");
			auditLogThread.setPreviousValue("00~~Use SSL to connect to Oracle VM Manager",preSSL);
			auditLogThread.setCurrentValue("00~~Use SSL to connect to  Oracle VM Manager",ssl.equalsIgnoreCase("True")?"Yes":"No");
			auditLogThread.setPreviousValue("01~~Discover servers using this  Oracle VM Manager",preisDiscovery);
			auditLogThread.setCurrentValue("01~~Discover servers using this  Oracle VM Manager",isDis);
			auditLogThread.setPreviousValue("02~~Username to connect to  Oracle VM Manager",preUname);
			auditLogThread.setCurrentValue("02~~Username to connect to  Oracle VM Manager",UName);
			
			if(!(preUPass.equals(curPwd)))
			{
				auditLogThread.setPreviousValue("04~~Password for the user ","*****");
				auditLogThread.setCurrentValue("04~~Password for the user ","******");
			}
			auditLogThread.setValue("Description","Oracle VM Manager for "+ selCtxXenPoolIP +" preferences have been modified successfully");
			
			if(auditFlag)
				auditLogThread.sendItToDB();
			/*code for audit log ends*/
			// We don't have Ctx xen pool param in test params to know which component discovered/assoicated using which xen pool. 
			// So going to get the mapping details from eg_oraclevmmapping.ini.If the component has been managed exactly then change the eg_agents.ini details.
			IniFile agIniFile = EgConfigFilesSync.getInstance(agFile_dir + agFile);
			IniFile ctxxenmappingIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_oraclevmmapping.ini");
			IniFile discoverIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_discover.ini");
			String[] allVars = ctxxenmappingIni.getVariables(ipAddress);
			EgServicesInfo servicesInfo = new EgServicesInfo("manager");
			String[] credentials = servicesInfo.getCredentialsOfOracleVmServer(ipAddress);
			ArrayList ctxXenDiscoverComps = new ArrayList(Arrays.asList(allVars));
			ArrayList typeList = new ArrayList();
			typeList.add("Oracle_vm_mgr");
			typeList.add("Oracle_vm_server");

			ArrayList testListForAuditlog = new ArrayList();
			ArrayList compListForAuditlog = new ArrayList();
			
			String isSSL = credentials[0];
			String userName = credentials[1];
			String pwd = credentials[2];
			String port = credentials[3];
			for(int h=0;h<typeList.size();h++)
			{
				Hashtable nickAgentMap = new Hashtable();
				String xenType = (String)typeList.get(h);
				String[] servers = discoverIni.getVariables(xenType);
				for (int s=0; s<servers.length; s++)
				{
					if (ctxXenDiscoverComps.contains(servers[s]))
					{
						String nickName = servers[s];
						nickName = nickName.substring(nickName.indexOf(":")+1);
						//nickName = nickName.substring(0,nickName.indexOf(":"));

						List agentList = getAgents(xenType, nickName);
						if(agentList != null && agentList.size() >0)
						{
							for(int k=0;k<agentList.size();k++)
							{
								ArrayList agentNameList = new ArrayList();
								agentNameList.add(nickName);
								String thisSubject = (String) agentList.get(k);
								if(nickAgentMap.containsKey(thisSubject))
								{
									ArrayList lst = (ArrayList) nickAgentMap.get(thisSubject);
									if(!lst.contains(nickName))
										lst.add(nickName);
									nickAgentMap.put(thisSubject, lst);
								}
								else
								{
									nickAgentMap.put(thisSubject, agentNameList);
								}
							}
						}						
					}
					String[] strTests = egSpecs.getTestsForServer(xenType);
					ArrayList testEnabled = new ArrayList();
					if (strTests != null && strTests.length > 0)
					{
						testEnabled = new ArrayList(Arrays.asList(strTests));
					}
					Enumeration ee = nickAgentMap.keys();
					while(ee.hasMoreElements())
					{
						String thisElement = (String) ee.nextElement();
						String [] variables = agIniFile.getVariables(thisElement);
						ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
						for(int j=0;nickList != null && j<nickList.size();j++)
						{
							String thisNick = (String) nickList.get(j);
							for (int k=0;k<testEnabled.size();k++)
							{
								String thisTest = (String) testEnabled.get(k);
								String thisPattern = getResultantPattern(xenType,thisNick,thisTest,variables);
								if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
								{
									String value = agIniFile.getValue(thisElement,thisPattern);
									String tmpStr1 = "";
									String tmpStr2 = "";
									int xenUserIndex = value.toLowerCase().indexOf("-Oracle_vm_mgr");
									if (xenUserIndex > -1)
									{
										int len = "-Oracle_vm_mgr".length();
										tmpStr1 = value.substring(0,xenUserIndex + len).trim();
										tmpStr2 = value.substring(xenUserIndex + len).trim();
										tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
										value = tmpStr1 + " "+UName+ " "+tmpStr2;
									}
									int xenPwdIndex = value.toLowerCase().indexOf("-Oracle_vm_mgr_user");
									if(xenPwdIndex > -1)
									{
										int len = "-Oracle_vm_mgr_user".length();
										tmpStr1 = value.substring(0,xenPwdIndex + len).trim();
										tmpStr2 = value.substring(xenPwdIndex + len).trim();
										tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
										value = tmpStr1 + " "+UPass+ " "+tmpStr2;
									}
									int sslIndex = value.toLowerCase().indexOf("-ssl");
									if (sslIndex > -1)
									{
										tmpStr1 = value.substring(0,sslIndex + 4).trim();
										tmpStr2 = value.substring(sslIndex + 4).trim();
										tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
										value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
									}
									int OracleVMPort = tmpStr1.toLowerCase().indexOf("-webport");
									int OracleVMPortLen = "-webPort".length();
									if (OracleVMPort > 0)
									{
										tmpStr1 = value.substring(0,OracleVMPort + OracleVMPortLen).trim();
										tmpStr2 = value.substring(OracleVMPort + OracleVMPortLen).trim();
										tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
										value = tmpStr1 + " "+port.toLowerCase()+ " "+tmpStr2;
									}
									agIniFile.setValue(thisElement,thisPattern,value);
									if (!testListForAuditlog.contains(thisTest))
										testListForAuditlog.add(thisTest);

									if (!compListForAuditlog.contains(thisNick))
										compListForAuditlog.add(thisNick);
								}
							}
							agIniFile.saveFile();
						}
					}
				}
			}
			if(testListForAuditlog != null && testListForAuditlog.size() > 0)
			{
				for(int i=0; i<testListForAuditlog.size(); i++)
				{
					String auditStr = (String) testListForAuditlog.get(i);
					if(auditStr != null && auditStr.length() > 0 && auditFlag)
					{
						auditLogThread.setCurrentValue("05~~Auto configured test(s)","$test$:"+auditStr);
					}
				}
			}
			if(compListForAuditlog != null && compListForAuditlog.size() > 0)
			{
				Server serverName = new Server();
				for(int i=0; i<compListForAuditlog.size(); i++)
				{
					String auditStr = (String) compListForAuditlog.get(i);
					auditStr = auditStr.substring(0,auditStr.indexOf(":"));
					if(auditStr != null && auditStr.length() > 0 && auditFlag)
					{
						auditLogThread.setCurrentValue("06~~Auto configured host(s)",auditStr);
					}
				}
			}
			if (from.equalsIgnoreCase("oracleVMModify"))
			{
				rootObj.put("requestStatus","success");
				JSONObject resultMsg = new JSONObject();
				resultMsg.put("title",_mapping.getTextDescription("admin.discovery.Modify Oracle VM Manager"));
				resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Details have been modified successfully"));
				rootObj.put("result",resultMsg);
				out.println(rootObj.toString());
				return ;
			}
		}
	}

	if (from.equalsIgnoreCase("oracleVMDelete"))
	{
		String oracleVM = request.getParameter("oracleVM");

		ArrayList xenServsList = new ArrayList();
		ArrayList xenVdisList = new ArrayList();
		ArrayList totalCtxXenPoolsToDel = new ArrayList();
		ArrayList dontDeleteList = new ArrayList();

		String[] xenServs = discInfo.getAllServersOfType("Oracle_vm_mgr");
		String[] xenVdis = discInfo.getAllServersOfType("Oracle_vm_server");
		IniFile agIniFile = new IniFile(agFile_dir + agFile);
		if (xenServs != null)
		{
			xenServsList = new ArrayList(Arrays.asList(xenServs));
		}
		if (xenVdis != null)
		{
			xenVdisList = new ArrayList(Arrays.asList(xenVdis));
		}
		StringTokenizer stt = new StringTokenizer(oracleVM,",");
		while (stt.hasMoreTokens())
		{
			totalCtxXenPoolsToDel.add(stt.nextToken());
		}
		if (xenServsList.size() != 0 || xenVdisList.size() != 0)
		{
			IniFile ctxxenmappingIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_oraclevmmapping.ini");
			StringTokenizer ss=new StringTokenizer(oracleVM,",");
			while(ss.hasMoreTokens())
			{
				String ctxXenPoolIp=ss.nextToken();
				String[] allVars = ctxxenmappingIni.getVariables(ipAddress);
				if (allVars != null)
				{
					for (int a=0; a<allVars.length; a++) 
					{
						String comp = allVars[a];
						if (xenServsList.contains(comp) || xenVdisList.contains(comp))
						{
							if (!dontDeleteList.contains(ctxXenPoolIp))
							{
								dontDeleteList.add(ctxXenPoolIp);
							}
						}						
					}
				}
			}
		}

		if (from.equalsIgnoreCase("oracleVMDelete"))
		{
			auditLogThread.setValue("Activity","Delete Oracle VM Manager discovery");
			String name = "";
			String ctxXenPoolMap = "eg_oraclevmmapping.ini";
	
			String dontDeleteCtxXenPools = dontDeleteList.toString();
			dontDeleteCtxXenPools = dontDeleteCtxXenPools.substring(1,dontDeleteCtxXenPools.length() -1);
			totalCtxXenPoolsToDel.removeAll(dontDeleteList);
			servicesIniFileWr = EgConfigFilesSync.getInstance(s_iniFile_dir + servivesFile);
			IniFile ctxXenPoolFile = EgConfigFilesSync.getInstance(agFile_dir + ctxXenPoolMap);
			for (int i=0; i<totalCtxXenPoolsToDel.size(); i++)
			{
				String ctxXenPoolDelete = (String)totalCtxXenPoolsToDel.get(i);
				servicesIniFileWr.deleteValue(sub,ctxXenPoolDelete);
				ctxXenPoolFile.deleteSubject(ctxXenPoolDelete);				
			}
			servicesIniFileWr.saveFile();
			ctxXenPoolFile.saveFile();
			EgConfigFilesSync.releaseInstance(servicesIniFileWr);
			EgConfigFilesSync.releaseInstance(ctxXenPoolFile);

			String ctxXenPoolDeleted = totalCtxXenPoolsToDel.toString();
			ctxXenPoolDeleted = ctxXenPoolDeleted.substring(1,ctxXenPoolDeleted.length() - 1);

			if (totalCtxXenPoolsToDel.size() > 0)
			{
				auditFlag = true;
				auditLogThread.setCurrentValue("ColumnName","Oracle VM Manager Deleted");
				auditLogThread.setCurrentValue("00~~IP address of Oracle VM Manager","" +ctxXenPoolDeleted);
				if(ctxXenPoolDeleted.indexOf(",")>0)
				{
					auditLogThread.setValue("Description","Oracle VM Manager IPs have been deleted");
				}
				else
				{
					auditLogThread.setValue("Description","Oracle VM Manager IP has been deleted");
				}
				rootObj.put("requestStatus","success");
				JSONObject resultMsg = new JSONObject();
				resultMsg.put("title",_mapping.getTextDescription("admin.discovery.Oracle VM Manager Delete"));
				resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Details have been deleted successfully"));
				rootObj.put("result",resultMsg);
				auditLogThread.sendItToDB();
			}

			if(dontDeleteList.size() > 0)
			{
				AuditLogThread auditlog = new AuditLogThread();
				auditlog.setValue("Category","Admin");
				auditlog.setValue("User_id",_user.getLoginID());
				auditlog.setValue("Host_ip",_user.getUserIP(session.getId()));
				auditlog.setValue("Session_id",session.getId());
				auditlog.setValue("Module","Discover");
				auditLogThread.setCurrentValue("ColumnName","Oracle VM Manager Deleted");
				auditlog.setCurrentValue("00~~IP address of Oracle VM Manager","" +dontDeleteCtxXenPools);
				auditlog.setValue("Activity","Delete Oracle VM Manager discovery");
				auditlog.setValue("Description"," One/more tests have been configured to use on this "+server+".");
				auditlog.sendItToDB();
				rootObj.put("requestStatus","failed");
				JSONObject errorMsg = new JSONObject();
				errorMsg.put("title",_mapping.getTextDescription("admin.discovery.Oracle VM Manager Delete"));
				errorMsg.put("message1",_mapping.getTextDescription("admin.discovery.You cannot delete the following")+" "+server+" "+dontDeleteCtxXenPools+". "+_mapping.getTextDescription("admin.discovery.One/more tests have been configured to use on this Oracle VM Manager"));
				rootObj.put("errors",errorMsg);
			}
			out.println(rootObj.toString());
			return ;
		}
	}

	if(from.equalsIgnoreCase("oracleVMAddDiscovery") || from.equalsIgnoreCase("oracleVMModifyDisovery"))
	{
		if(from.equalsIgnoreCase("oracleVMAddDiscovery") && auditFlag)
		{
			String conSSL = ssl.equalsIgnoreCase("True")?"Yes":"No";
			// code for audit log starts 
			auditLogThread.setValue("Activity","Add Oracle VM Manager discovery");
			auditLogThread.setCurrentValue("ColumnName","Oracle VM Manager Added");
			auditLogThread.setCurrentValue("00~~IP address of Oracle VM Manager",ipAddress);
			auditLogThread.setCurrentValue("01~~Use SSL to connect to Oracle VM Manager",conSSL);
			auditLogThread.setCurrentValue("02~~Discover Oracle VM Servers using this Citrix XenServer",isDis);
			auditLogThread.setCurrentValue("03~~Username to connect to Oracle VM Manager",UName);
			auditLogThread.setCurrentValue("04~~Password for the user","*****");
			auditLogThread.setValue("Description","Oracle VM Manager details have been added and Oracle VM Managers discovery started successfully ");
			auditLogThread.sendItToDB();
			// code for audit log ends 
		}

		serviceBean.createAdmin();
		String autoManage = serviceBean.getAutomanage();
		autoManage = (autoManage == null || autoManage.length() == 0)?"No":autoManage;
		EgDiscoveryAutoManager autoManagerDisc = new EgDiscoveryAutoManager();
		//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
		IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
		serviceBean.stopDiscovery();
		serviceBean.startDiscovery("13", true);
		EgConfigFilesSync.releaseInstance(infraIni);
		if (autoManage.equalsIgnoreCase("yes") || autoManage.equalsIgnoreCase("true"))
		{
			DiscoveryLicenseController.sesstionID = request.getSession().getId();
			DiscoveryLicenseController.userID = _user.getLoginID();
			autoManagerDisc.startAutoManager();
		}

		rootObj.put("requestStatus","success");
		JSONObject resultMsg = new JSONObject();
		resultMsg.put("title",_mapping.getTextDescription("admin.discovery.Add/Modify Oracle VM Manager"));
		resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Details have been updated successfully"));
		rootObj.put("result",resultMsg);
		out.println(rootObj.toString());
		return ;
	}
%>
<%!
	EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
	//provide a set of agents(internal or remote agent,external agent(s)) for a component
	private List getAgents(String componentType,String componentName)
	{
		List agentsList = new ArrayList();
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String tempCompType = new String(componentType);
		String tempCompName = new String(componentName);
		String agentNickName = "";
		boolean isRemote = false;
		if (tempCompName.indexOf(":") > -1)
		{
			if (tempCompType.equalsIgnoreCase("Oracle_server"))
			{
				tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
			else
			{
				tempCompName = tempCompName.substring(0,tempCompName.lastIndexOf(":"));
			}
		}
		// To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(tempCompName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(tempCompName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(tempCompName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = tempCompName;
			}
		}
		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		// To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(tempCompName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(tempCompName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends
		return agentsList;
	}

	private String getResultantPattern(String componentType, String compName, String testName, String[] testVariables)
	{
		String tempResultantPattern = null;
		String specificPattern_A = testName + ":" + componentType + ":" + compName;
		String specificPattern_B = testName + ":" + componentType + ":" + compName.substring(0,compName.indexOf(":"));
		String defaultPattern_A = testName + "::" + compName;
		String defaultPattern_B = testName + "::" + compName.substring(0,compName.indexOf(":"));
		List listTestVariables = Arrays.asList(testVariables);
		if(listTestVariables.contains(specificPattern_A))
		{
			tempResultantPattern = specificPattern_A;
		}
		else if(listTestVariables.contains(specificPattern_B))
		{
			tempResultantPattern = specificPattern_B;
		}
		else if(listTestVariables.contains(defaultPattern_A))
		{
			tempResultantPattern = defaultPattern_A;
		}
		else if(listTestVariables.contains(defaultPattern_B))
		{
			tempResultantPattern = defaultPattern_B;
		}
		return tempResultantPattern;
	}
%>