<%@ include file="../../EgTrackerAJSON.jsp"%>

<%@ page import = "egurkha.ServiceBean"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "net.sf.json.JSONObject"%>

<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<jsp:useBean id="DiscBean" scope="page" class="egurkha.ServiceBean"/>

<%
/*
*	Processing page for Netscaler node in Discovery tree.
*	ini File : eg_services.ini, subject : NETSCALER
*/
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();

	EgDiscInfo discInfo = new EgDiscInfo("manager");

	String netScaler = "NETSCALER";

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Discovery");

	String ipLabel = "NetScaler identity(IP or Hostname)";
	String sslLabel = "Use SSL to connect to NetScaler";
	String discoverLabel = "Discover hosts using this NetScaler";
	String userLabel = "Username to connect to Netscaler";
	String pwdLabel = "Password for the user";

	String from = request.getParameter("from");

	String ip = request.getParameter("ip");
	String ssl = request.getParameter("ssl");
	String discover = request.getParameter("discover");
	String user = request.getParameter("user");
	String pwd = request.getParameter("pwd");

	rootJson.put("success","false");
	
	if(from != null && from.equalsIgnoreCase("addNetScaler"))
	{
		auditLogThread.setValue("Activity","Add NetScaler discovery");
		if(ip != null && ip.length() > 0)
		{
			ssl = (ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))? "Yes" :"No";
			discover = (discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))? "Yes" :"No";

			pwd = EgCrypt.encrypt(pwd);

			String value = ssl + "#" +  user + "#" + pwd + "#" + discover;

			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			services.setValue(netScaler,ip,value);
			services.saveFile();
			EgConfigFilesSync.releaseInstance(services);

			auditLogThread.setCurrentValue("00~~"+ipLabel,ip);
			auditLogThread.setCurrentValue("01~~"+sslLabel,ssl);
			auditLogThread.setCurrentValue("02~~"+discoverLabel,discover);
			auditLogThread.setCurrentValue("03~~"+userLabel,user);
			auditLogThread.setCurrentValue("04~~"+pwdLabel,"*****");

			auditLogThread.setValue("Description","NetScaler preferences have been added successfully");
			auditLogThread.sendItToDB();

			DiscBean.createAdmin();
			String autoManage = DiscBean.getAutomanage();
			autoManage = (autoManage == null || autoManage.length() == 0)?"No":autoManage;
			EgDiscoveryAutoManager autoManagerDisc = new EgDiscoveryAutoManager();
			String discovery = request.getParameter("discovery");
			if(discovery != null && discovery.equalsIgnoreCase("true"))
			{
				//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
				IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
				ServiceBean serviceBean = new ServiceBean();
				serviceBean.stopDiscovery();
				serviceBean.startDiscovery("7",true);
				EgConfigFilesSync.releaseInstance(infraIni);
				if (autoManage.equalsIgnoreCase("yes") || autoManage.equalsIgnoreCase("true"))
				{
					DiscoveryLicenseController.sesstionID = request.getSession().getId();
					DiscoveryLicenseController.userID = _user.getLoginID();
					autoManagerDisc.startAutoManager();
				}
			}

			rootJson.put("success","true");

		}
	}
	else if(from != null && from.equalsIgnoreCase("modifyNetScaler"))
	{
		auditLogThread.setValue("Activity","Modify NetScaler discovery");
		if(ip != null && ip.length() > 0)
		{
			String $_ssl = request.getParameter("$_ssl");
			String $_discover = request.getParameter("$_discover");
			String $_user = request.getParameter("$_user");
			String $_pwd = request.getParameter("$_pwd");

			boolean setAudit = false;
			boolean updateAgents = false;

			if($_ssl != null && !$_ssl.equalsIgnoreCase(ssl))
			{
				auditLogThread.setPreviousValue("00~~"+sslLabel,$_ssl);
				auditLogThread.setCurrentValue("00~~"+sslLabel,ssl);
				setAudit = true;
				updateAgents = true;
			}

			if($_discover != null && !$_discover.equalsIgnoreCase(discover))
			{
				auditLogThread.setPreviousValue("01~~"+discoverLabel,$_discover);
				auditLogThread.setCurrentValue("01~~"+discoverLabel,discover);
				setAudit = true;
			}

			if($_user != null && !$_user.equalsIgnoreCase(user))
			{
				auditLogThread.setPreviousValue("02~~"+userLabel,$_user);
				auditLogThread.setCurrentValue("02~~"+userLabel,user);
				setAudit = true;
				updateAgents= true;
			}

			if($_pwd != null && !$_pwd.equalsIgnoreCase(pwd))
			{
				auditLogThread.setPreviousValue("03~~"+pwdLabel,"*****");
				auditLogThread.setCurrentValue("03~~"+pwdLabel,"********");
				setAudit = true;
				updateAgents = true;
			}

			ssl = (ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))? "Yes" :"No";

			discover = (discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))? "Yes" :"No";

			pwd = EgCrypt.encrypt(pwd);

			String value = ssl + "#" +  user + "#" + pwd + "#" + discover;
			
			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			services.setValue(netScaler,ip,value);
			services.saveFile();
			EgConfigFilesSync.releaseInstance(services);

			auditLogThread.setValue("Description","NetScaler for "+ip+" preferences have been modified successfully");
			auditLogThread.sendItToDB();

			if(updateAgents)
			{
				boolean managedState = false;
				String[] netScalerComps = discInfo.getAllServersOfType("Citrix_NetScaler");
				for (int i = 0; i < netScalerComps.length; i++)
				{
					String nsComp = netScalerComps[i];
					if(nsComp.startsWith("Format") || nsComp.startsWith("#"))
						continue;
					String nsCompValue[] = discInfo.getFieldValuesForServer("Citrix_NetScaler",nsComp);
					ArrayList ncCompValueList = new ArrayList();
					for (int j = 0; j < nsCompValue.length; j++)
					{
						ncCompValueList.add(nsCompValue[j].toLowerCase());
					}
					if(ncCompValueList.contains(ip.toLowerCase()))
					{
						EgExternalInfo externalInfo = new EgExternalInfo("manager");
						String ns = nsComp.substring(nsComp.indexOf(":")+1);
						ns = ns.substring(0,ns.indexOf(":"));
						List agents = externalInfo.getAgentsForHost(ns);
						if(agents != null)
						{
							IniFile agentIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
							for(int k = 0; k < agents.size(); k++)
							{
								String agent = (String) agents.get(k);
								String[] agentTests = agentIni.getVariables(agent);
								if(agentTests != null)
								{
									for(int l = 0; l < agentTests.length; l++)
									{
										String testNameVar = agentTests[l];
										String testValue = agentIni.getValue(agent,testNameVar);

										if(testValue.indexOf("-NetScaler_username") > -1)
										{
											String host = testValue.substring(testValue.indexOf("-host")+5).trim();
											host = host.substring(0,host.indexOf(" -NetScaler_username")).trim();
											String testVarLower = testNameVar.toLowerCase();

											if(testVarLower.indexOf(":"+ip.toLowerCase()+":") > 0 || 
												testVarLower.endsWith(":"+ip.toLowerCase()) || 
												host.equalsIgnoreCase(ip))
											{
												int unLen = "-NetScaler_username".length();
												if(testValue.indexOf("-NetScaler_username") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-NetScaler_username")+unLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-NetScaler_username")+unLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													testValue = value1+" "+user+" "+value2;
												}

												int pwdLen = "-NetScaler_password".length();
												if(testValue.indexOf("-NetScaler_password") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-NetScaler_password")+pwdLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-NetScaler_password")+pwdLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													testValue = value1+" "+pwd+" "+value2;
												}

												int sslLen = "-ssl".length();
												if(testValue.indexOf("-ssl") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-ssl")+sslLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-ssl")+sslLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													ssl = (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True"))? "true" :"false";
													testValue = value1+" "+ssl+" "+value2;
												}
												agentIni.setValue(agent,testNameVar,testValue);
											}
										}
									}
								}
							}
							agentIni.saveFile();
							EgConfigFilesSync.releaseInstance(agentIni);
						}
					}
				}
			}

			DiscBean.createAdmin();
			String autoManage = DiscBean.getAutomanage();
			autoManage = (autoManage == null || autoManage.length() == 0)?"No":autoManage;
			EgDiscoveryAutoManager autoManagerDisc = new EgDiscoveryAutoManager();
			String discovery = request.getParameter("discovery");
			if(discovery != null && discovery.equalsIgnoreCase("true"))
			{
				//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
				IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
				ServiceBean serviceBean = new ServiceBean();
				serviceBean.stopDiscovery();
				serviceBean.startDiscovery("7",true);
				EgConfigFilesSync.releaseInstance(infraIni);
				if (autoManage.equalsIgnoreCase("yes") || autoManage.equalsIgnoreCase("true"))
				{
					DiscoveryLicenseController.sesstionID = request.getSession().getId();
					DiscoveryLicenseController.userID = _user.getLoginID();
					autoManagerDisc.startAutoManager();
				}
			}

			rootJson.put("success","true");
		}
	}
	else if(from != null && from.equalsIgnoreCase("delNetScaler"))
	{
		auditLogThread.setValue("Activity","Delete NetScaler discovery");

		boolean success = false;
		boolean managedState = false;

		String netScalerIPs = request.getParameter("netScalers");
		ArrayList allCompFieldLists = new ArrayList();
		ArrayList dontDelete = new ArrayList();
		if(netScalerIPs != null && netScalerIPs.length() > 0)
		{
			IniFile discFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini");
			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			IniFile netscalerMapping = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_netscalermapping.ini");

			String[] netScalers = discFile.getVariables("Citrix_NetScaler");
			if(netScalers != null)
			{
				for(int i = 0; i < netScalers.length; i++)
				{
					String netScal = netScalers[i];
					if(netScal.startsWith("#") || netScal.startsWith("Format"))
						continue;
					String fieldValue = discFile.getValue("Citrix_NetScaler",netScal);
					StringTokenizer st = new StringTokenizer(fieldValue,",");
					while(st.hasMoreTokens())
					{
						allCompFieldLists.add(st.nextToken());
					}
				}
			}

			StringTokenizer st = new StringTokenizer(netScalerIPs,",");
			while(st.hasMoreTokens())
			{
				String netIP = st.nextToken();

				if(allCompFieldLists.contains(netIP))
				{
					dontDelete.add(netIP);
				}
				else
				{
					services.deleteValue(netScaler,netIP);
					netscalerMapping.deleteSubject(netIP);

					auditLogThread.setCurrentValue("Deleted NetScaler IP/Host",netIP);
					success = true;
				}
			}
			services.saveFile();
			netscalerMapping.saveFile();

			EgConfigFilesSync.releaseInstance(services);
			EgConfigFilesSync.releaseInstance(netscalerMapping);

			if(success)
			{
				auditLogThread.setCurrentValue("ColumnName","Deleted NetScaler");
				auditLogThread.setValue("Description","The NetScaler IP/Hosts have been deleted");
				auditLogThread.sendItToDB();
			}

			if(dontDelete.size() == 0)
			{
				if(success)
				{
					rootJson.put("requestStatus","success");

					JSONObject resultMsg = new JSONObject();
					resultMsg.put("title",_mapping.getTextDescription("admin.discovery.NetScaler Settings"));
					resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.NetScaler(s) deleted successfully"));
					rootJson.put("result",resultMsg);
				}
				else
				{
					rootJson.put("requestStatus","failed");

					JSONObject errorObj = new JSONObject();
					errorObj.put("title",_mapping.getTextDescription("admin.discovery.NetScaler Settings"));
					errorObj.put("message1",_mapping.getTextDescription("admin.discovery.Error in NetScaler(s) deletion"));
					rootJson.put("errors",errorObj);
				}
			}
			else
			{
				String dontDeleteStr = dontDelete.toString();
				dontDeleteStr = dontDeleteStr.substring(1,dontDeleteStr.length() -1);
				rootJson.put("requestStatus","failed");

				JSONObject errorObj = new JSONObject();
				errorObj.put("title",_mapping.getTextDescription("admin.discovery.NetScaler Settings"));
				errorObj.put("message1",_mapping.getTextDescription("admin.discovery.You cannot delete the following")+" NetScalers "+dontDeleteStr+". "+_mapping.getTextDescription("admin.discovery.One/more tests have been configured to use on this NetScaler Server"));
				rootJson.put("errors",errorObj);
			}
		}
	}

	out.println(rootJson.toString());

%>

