<%
/*******************************************************************************
*
*	Name			:	EgReplicateUserJSONp.jsp
*	Purpose			:	This jsp is used for processing replicating users.
*	Version			:	
*	CreationDate	:	12/05/2012
*	LastModified	:	
*	Author			:	Abdul Khader
*	Design Changes	:	
*******************************************************************************/
%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "egurkha.UserBean"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.AuditLogHashtable"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import="net.sf.json.*" %>
<%@ page import = "com.eg.EgCrypt"%>

<%@ page import="com.egurkha.admin.mfa.EgMailHelper"%>
<%@ page import="com.egurkha.admin.mfa.GoogleAuthenticator"%>

<%
	JSONObject rootJson = new JSONObject();

	String uname = request.getParameter("uname");
	String password = request.getParameter("passwordField");

	uname = com.egurkha.util.StringUtils.decodeSecurityChar(uname);
	password = com.egurkha.util.StringUtils.decodeSecurityChar(password);

	String expiry_date = request.getParameter("dateforpro");
	String never = request.getParameter("never");
	String tomailid = request.getParameter("mailidormobile");
	String mailid = "";
	if(tomailid != null && !tomailid.equals(""))
	{
		mailid = "To:" + tomailid;
	}
	else
	{
		tomailid = "&nbsp";
	}
	String timezone = request.getParameter("timeZone");
	String dateFormat = request.getParameter("userDateFormat");
	String language = request.getParameter("languageName");
	String userAuthentication = request.getParameter("authentication");
	String operationType = request.getParameter("operation");
	String grpName = request.getParameter("grpname");
	String domainName = request.getParameter("domain");
	String idpName = request.getParameter("idp");
	String existingUser = request.getParameter("uid");
	existingUser = com.egurkha.util.StringUtils.decodeSecurityChar(existingUser);

	String existUserDispVal = existingUser;
	String dispUserName = uname;
	String mappedUI = "";
	String languageName = "";
	String timezoneForAudit = "";

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	IniFile egUI  = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT", "selectedDateFormat");
	String curdate = "";
	boolean error = false;

	if (expiry_date != null && !expiry_date.equals("Never"))
	{
		String comFormat = "MM/dd/yyyy";
		curdate = DateUtil.changeDateFormat(expiry_date, currentDateFormat, currentDateFormat);
	}

	int usersCount = 1;
	if (grpName != null && grpName.indexOf("|#|") > 0)
	{
		ArrayList usersToAdd = StringUtils.myTokenizer(grpName,"|#|");
		usersCount = usersToAdd.size();
	}

	timezoneForAudit = timezone;
	if (timezone != null && dateFormat != null && !timezone.equalsIgnoreCase("default"))
	{
		timezone = timezone+"$@$"+dateFormat;
	}

	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	Object langCodes[] = egUi.getVariables("COUNTRY_AND_LANGUAGE_CODE");
	for(int i=0;i<langCodes.length;i++)
	{
		String countryName=egUi.getValue("COUNTRY_AND_LANGUAGE_CODE",(String)langCodes[i]);
		if (language.equals(countryName))
		{
			languageName = (String)langCodes[i];
		}
	}

	ArrayList aListUserAttributes = new ArrayList();
	ArrayList aListCategoriesForReplication = new ArrayList();
	HashMap mapToUI = new HashMap();

	if ((never != null) && (never.equals("Never")))
	{
		expiry_date = "12/12/9999";
	}

	if ((expiry_date != null) && (expiry_date.equals("Never")))
	{
		expiry_date = "12/12/9999";
	}

	if (domainName==null || domainName.equals("null"))
	{
		domainName="";
	}

	if (userAuthentication==null || userAuthentication.equalsIgnoreCase("Eg"))
	{
		domainName="";
		if (existingUser.indexOf("(Group)") != -1)
		{
			String modifiedGroup = existingUser.substring(0,existingUser.indexOf('/'))+"/Grp";
			String onlyName = (existingUser.substring(existingUser.indexOf('/'),existingUser.indexOf("(Group)"))).trim();
			existingUser = modifiedGroup+onlyName;
		}
		else if (existingUser.startsWith("samlsso/"))
		{
			String tmp = existingUser;
			int idx = tmp.indexOf("/");
			existUserDispVal = tmp.substring(idx+1);
			existUserDispVal = existUserDispVal + " (SAML)";
		}
	}
	else if (userAuthentication.equalsIgnoreCase("SAML"))
	{
		password="NONE";
		if (!com.egurkha.util.StringUtils.isNull(idpName))
		{
			uname = "samlsso/"+idpName +"/"+uname;
		}

		domainName="";
		if (existingUser.indexOf("(Group)") != -1)
		{
			String modifiedGroup = existingUser.substring(0,existingUser.indexOf('/'))+"/Grp";
			String onlyName = (existingUser.substring(existingUser.indexOf('/'),existingUser.indexOf("(Group)"))).trim();
			existingUser = modifiedGroup+onlyName;
		}
		else if (existingUser.startsWith("samlsso/"))
		{
			String tmp = existingUser;
			int idx = tmp.indexOf("/");
			existUserDispVal = tmp.substring(idx+1);
			existUserDispVal = existUserDispVal + " (SAML)";
		}
	}
	else
	{
		password="NONE";
		if (operationType != null && operationType.equalsIgnoreCase("Group"))
		{
			if (grpName != null && grpName.length() > 0)
			{
				//uname = domainName + "/Grp/" + grpName;
				if (existingUser.indexOf("(Group)") != -1)
				{
					String modifiedGroup = existingUser.substring(0,existingUser.indexOf('/'))+"/Grp";
					String onlyName = (existingUser.substring(existingUser.indexOf('/'),existingUser.indexOf("(Group)"))).trim();
					existingUser = modifiedGroup+onlyName;
				}
				else if (existingUser.startsWith("samlsso/"))
				{
					String tmp = existingUser;
					int idx = tmp.indexOf("/");
					existUserDispVal = tmp.substring(idx+1);
					existUserDispVal = existUserDispVal + " (SAML)";
				}
			}
		}
		else
		{
			if (!com.egurkha.util.StringUtils.isNull(domainName))
			{
				uname=domainName+"/"+uname;
			}
			if (existingUser.indexOf("(Group)") != -1)
			{
				String modifiedGroup = existingUser.substring(0,existingUser.indexOf('/'))+"/Grp";
				String onlyName = (existingUser.substring(existingUser.indexOf('/'),existingUser.indexOf("(Group)"))).trim();
				existingUser = modifiedGroup+onlyName;
			}
			else if (existingUser.startsWith("samlsso/"))
			{
				String tmp = existingUser;
				int idx = tmp.indexOf("/");
				existUserDispVal = tmp.substring(idx+1);
				existUserDispVal = existUserDispVal + " (SAML)";
			}
		}
	}
	String categoryArray[] = {"User Info & Preference","Infrastructure Elements","Live Graph","Quick Insights","Favorite Measures","Favorites","Schedules","Configuration","Custom Dashboards","Quick Menus","Mail Alerts(Exclude)","User Experience Dashboard","Business Dashboard","User Reports","Maintenance Policies","Booklets","Background Reports","Citrix Dashboards"};
	
	mapToUI.put("User_Preferences","User Information & Preferences");
	mapToUI.put("Infrastructure_Elements","Infrastructure Elements");
	mapToUI.put("Exclude_Mail_Alerts","Exclude Mail Alerts");
	mapToUI.put("Live_Graph","Live Graph");
	mapToUI.put("Quick_Insights","Quick Insights");
	mapToUI.put("Favorite_Measures","Favorite Measures");
	mapToUI.put("Custom_Dashboards","Custom Dashboards");
	mapToUI.put("Favorites","Favorites");
	mapToUI.put("Schedules","Schedules");
	mapToUI.put("Configuration_Data","Configuration Settings");
	mapToUI.put("Quick_Menus","Quick Links");
	mapToUI.put("User_Experience_Dashboard","User Experience Dashboard");
	mapToUI.put("Business_Dashboards","Business Dashboard");
	//mapToUI.put("Fix_FeedbackAndHistory","Fix Feedback & History");
	mapToUI.put("User_Reports","User Reports");
	mapToUI.put("Maintenance_Policies","Maintenance Policies");
	mapToUI.put("Booklets","Booklets");
	mapToUI.put("Background_Reports","Background Reports");
	mapToUI.put("Citrix_Dashboards","Citrix Dashboards");

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","User Management");

	// License check starts
	UserBean userBean = new UserBean();
	String str_usercon = "";
	boolean userFlag = false;
	Vector sess_vec = new Vector();
	try
	{
		str_usercon=userBean.setConnection();
		userFlag=userBean.checkMonitorUser(usersCount);
		if(!userFlag)
		{
			userBean.releaseConnection(false);
			sess_vec.removeAllElements();
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Delete User Page"));
			sess_vec.addElement("EgDeleteUser.jsp");
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Add new user"));
			sess_vec.addElement(_mapping.getTextDescription("admin.error.You have exceeded the number of users allowed by your license")+".<BR>");
			sess_vec.addElement(_mapping.getTextDescription("admin.error.To support additional users")+", "+_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>");
			session.putValue("vec_Errors",sess_vec);

			auditLogThread.setValue("Description","You have exceeded the number of users allowed by your license!");
			auditLogThread.setValue("Activity","Clone User");		
			auditLogThread.sendItToDB();

			error = true;
			JSONObject errorObj = new JSONObject();
			errorObj.put("message1",_mapping.getTextDescription("admin.error.You have exceeded the number of users allowed by your license"));
			errorObj.put("message2",_mapping.getTextDescription("admin.error.To support additional users")+", "+_mapping.getTextDescription("admin.error.please contact")+" <b class='font_bold'>license@eginnovations.com</b>");
			rootJson.put("errorMsg",errorObj);
//			return;
		}
	}
	catch(Exception ee)
	{
		/* code for auditlog starts */
		auditLogThread.setValue("Description","Problem while adding user");
		auditLogThread.setValue("Activity","Clone User");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */

		ee.printStackTrace();


		if(!(str_usercon.equals("CONNECTED")))
		{
		}
		out.println(ee.getMessage());
		
	}finally
	{
		try
		{
			if (userBean != null)
			userBean.releaseConnection(true);
		}
		catch(Exception ec)
		{}
	}

	IniFile eguuid = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_uuid.ini");
	String orgName = eguuid.getValue("ORGANIZATION_MAPPING",existingUser);
	int usrLicStatus = 0;
	if (orgName != null && orgName.trim().length() > 0)
	{
		EgUuidInfo egUuidInfo = new EgUuidInfo();
		List orgList = egUuidInfo.getOrgNames(orgName);
		int orgListLen = (orgList != null) ? orgList.size() : 0;
		for (int y=0; y<orgListLen; y++)
		{
			String org_id = orgList.get(y).toString().trim();
			GroupCertValidator grpCert = new GroupCertValidator(org_id);
			usrLicStatus = grpCert.checkUser(org_id,orgName,"");
			
			if (usrLicStatus != 1)
			{
				error = true;
				JSONObject errorObj = new JSONObject();
				errorObj.put("message1",_mapping.getTextDescription("admin.error.You have exceeded the number of users allowed by your license"));
				errorObj.put("message2",_mapping.getTextDescription("admin.error.To support additional users")+", "+_mapping.getTextDescription("admin.error.please contact")+" <b class='font_bold'>license@eginnovations.com</b>");
				rootJson.put("errorMsg",errorObj);
				break;
			}
		}
	}
	//License check ends

	if (!error)
	{
		/* for 2fa - code starts here */
		boolean is2faCFlagEnabled = false;

		IniFile egMFAIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mfa.ini");

		String is2FAEnabled = egMFAIniFile.getValue("2FA_SETTINGS","Is2FAEnabled");

		if (is2FAEnabled != null && (is2FAEnabled.equalsIgnoreCase("yes") || is2FAEnabled.equalsIgnoreCase("true")))
		{
			String twoFAOptionFlag = egMFAIniFile.getValue("2FA_SETTINGS","TwoFAOptionFlag");

			if (twoFAOptionFlag != null && twoFAOptionFlag.equalsIgnoreCase("c"))
			{
				is2faCFlagEnabled = true;
			}
		}

		boolean isSSOSelected = false;
		if (userAuthentication == null || userAuthentication.equalsIgnoreCase("Domain") || userAuthentication.equalsIgnoreCase("Eg"))
		{
			isSSOSelected = false;
		}
		else if (userAuthentication != null && userAuthentication.equalsIgnoreCase("SAML"))
		{
			isSSOSelected = true;
		}
		/* for 2fa - code ends here */

		auditLogThread.setCurrentValue("01~~Existing User",existUserDispVal);

		if (operationType != null && operationType.equalsIgnoreCase("Group"))
		{
			if (grpName != null && grpName.length() > 0)
			{
				IniFile ini_write = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini",true);
				ArrayList tempList = StringUtils.myTokenizer(grpName,"|#|");
				Iterator it = tempList.iterator();
				while(it.hasNext())
				{
					AuditLogHashtable currentAuditValue = new AuditLogHashtable();

					String tempGrpName = (String)it.next();
					if (tempGrpName == null || tempGrpName.equals(""))
					{
						continue;
					}
					
					uname = domainName + "/Grp/" + tempGrpName.trim();
					dispUserName = domainName + "/" + tempGrpName.trim() + " (Group)";
					if (uname != null && uname.indexOf("'") != -1)
					{
						String tempUser = uname;
						uname = StringUtils.replace(uname,"'","^");
						ini_write.setValue("USER_DBUSER_MAP",tempUser,uname);
						ini_write.setValue("DBUSER_USER_MAP",uname,tempUser); // reverse user mapping
					}

					if(userAuthentication == null || userAuthentication.equals("Eg"))
					{
						ArrayList list = new ArrayList();
						list.add("Local");
						currentAuditValue.put("02~~User Authentication",list);
					}
					else if(userAuthentication.equals("SAML"))
					{
						ArrayList list = new ArrayList();
						list.add("SAML");
						currentAuditValue.put("02~~User Authentication",list);
					}
					else
					{
						ArrayList domainList = new ArrayList();
						domainList.add("Domain");
						ArrayList domainNameList = new ArrayList();
						domainNameList.add(domainName);
						currentAuditValue.put("02~~User Authentication",domainList);
						currentAuditValue.put("03~~Domain",domainNameList);
					}

					ArrayList unameList = new ArrayList();
					unameList.add(dispUserName);
					currentAuditValue.put("04~~New User ID",unameList);

					if(never != null && never.equals("Never"))
					{
						ArrayList expiryList = new ArrayList();
						expiryList.add("Never");
						currentAuditValue.put("05~~Expiry Date",expiryList);
					}
					else
					{
						String expiryDate = (String) request.getParameter("dateforpro");
						ArrayList expiryList = new ArrayList();
						expiryList.add(curdate);
						currentAuditValue.put("05~~Expiry Date",expiryList);
					}

					ArrayList tomailidList = new ArrayList();
					tomailidList.add(tomailid);
					currentAuditValue.put("06~~Mail ID/Mobile Number",tomailidList);

					ArrayList timeZoneList = new ArrayList();
					timeZoneList.add(timezoneForAudit);
					currentAuditValue.put("07~~Time Zone",timeZoneList);

					ArrayList languageList = new ArrayList();
					languageList.add(languageName);
					currentAuditValue.put("08~~Language",languageList);

					aListUserAttributes.add(uname);
					aListUserAttributes.add(password);
					aListUserAttributes.add(expiry_date);
					aListUserAttributes.add(mailid);
					aListUserAttributes.add(timezone);
					aListUserAttributes.add(language);

					String categories = request.getParameter("categoryCheck");

					ArrayList mappedListForAudit = new ArrayList();
					if (categories != null)
					{
						StringTokenizer st = new StringTokenizer(categories,",");

						while(st.hasMoreTokens())
						{
							String aCategory = (String) st.nextToken();
							aListCategoriesForReplication.add(aCategory);
							mappedUI = (String)mapToUI.get(aCategory);
							mappedListForAudit.add(mappedUI);
						}
					}
					currentAuditValue.put("09~~Categories for Replication",mappedListForAudit);

					aListUserAttributes.add(existingUser);

					EgCloneUser EgCloneUserObj = new EgCloneUser(existingUser,uname,password);
					EgCloneUserObj.setAttributes(aListUserAttributes,aListCategoriesForReplication);
					ArrayList clonedResults = EgCloneUserObj.cloneUser();

					String descStr = "User "+dispUserName+" has been cloned from existing user "+ existUserDispVal;
					String cloneStr = "Clone User";

					auditLogThread.setValue("Activity",cloneStr);
					auditLogThread.setValue("Description",descStr);

					auditLogThread.setObjectValue("Current_Value",currentAuditValue);

					aListUserAttributes = new ArrayList();
					aListCategoriesForReplication = new ArrayList();

					auditLogThread.sendItToDB();

					/* code for 2fa starts here */
					if (!isSSOSelected && is2faCFlagEnabled)
					{
						IniFile egMFAIniFilePtr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_mfa.ini",true);

						String twofaOTPModeFlagVal = "";
						if (is2faCFlagEnabled)
						{
							twofaOTPModeFlagVal = egMFAIniFilePtr.getValue("2FA_SETTINGS","TwoFAOTPModeFlag");
						}

						String secretKey = GoogleAuthenticator.getRandomSecretKey();
						String encryptedSecretKey = EgCrypt.encrypt(secretKey);

						String usrMailid = request.getParameter("mailIDVal");
						String encryptedUserID = EgCrypt.encrypt(uname);

						egMFAIniFilePtr.setValue("2FAEnabledUsers",encryptedUserID,encryptedUserID);
						egMFAIniFilePtr.setValue(encryptedUserID,"EnabledMode",EgCrypt.encrypt(twofaOTPModeFlagVal));
						egMFAIniFilePtr.setValue(encryptedUserID,"SecretKey",encryptedSecretKey);

						if (twofaOTPModeFlagVal != null && twofaOTPModeFlagVal.equalsIgnoreCase("ga") && usrMailid != null && usrMailid.trim().length() > 0)
						{
							String mailSubject = "Secret Key to register Google Authenticator";
							String bodyContent = "The secret key for '"+uname+"' is <b>"+secretKey+"</b>. Please refer the attached document to register the secret key in Google Authenticator app for generating time based one-time password.";

							EgMailHelper mailObj = new EgMailHelper(usrMailid);
							mailObj.setAttachmentFile(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/docs/Google Authenticator Guide.docx");
							int mailStatus = mailObj.sendMail(mailSubject, bodyContent);

							if (mailStatus == 0)
							{
								rootJson.put("TwoFAMailSend","success");
							}
							else if (mailStatus == 1 || mailStatus == 2 || mailStatus == 3 || mailStatus == 4)
							{
								String errorMsg = "Problem occured while sending verification code to the user/group mail address.";
								rootJson.put("TwoFAMailSend","failed");
								rootJson.put("MailSendErrMsg",errorMsg);
							}
						}
						egMFAIniFilePtr.saveFile();
						EgConfigFilesSync.releaseInstance(egMFAIniFilePtr);
					}
					/* for 2fa - ends here */
				}
				ini_write.saveFile();
				EgConfigFilesSync.releaseInstance(ini_write);
			}
		}
		else
		{
			if (uname != null && uname.indexOf("'") != -1)
			{
				String tempUser = uname;
				uname = StringUtils.replace(uname,"'","^");
				IniFile ini_write = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini",true);
				ini_write.setValue("USER_DBUSER_MAP",tempUser,uname);
				ini_write.setValue("DBUSER_USER_MAP",uname,tempUser); // reverse user mapping
				ini_write.saveFile();
				EgConfigFilesSync.releaseInstance(ini_write);
			}
			/* User Password History Storage - STARTS 
			 * by Meena.V
			 */
			if(userAuthentication == null || userAuthentication.equalsIgnoreCase("Eg"))
			{
				String isPwdHistoryEnabled = egUI.getValue("MISC_ARGS","PwdMinHistoryEnable");
				if(isPwdHistoryEnabled != null && (isPwdHistoryEnabled.equalsIgnoreCase("yes") || isPwdHistoryEnabled.equalsIgnoreCase("true")))
				{
					String userPass = request.getParameter("passwordField");
					if(userPass != null && userPass.length()>0)
					{
						String userFinalPwdHistoryVal = EgCrypt.encrypt(userPass);
						IniFile egMgrMiscWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini",true);
						egMgrMiscWr.setValue("Password_History",uname,userFinalPwdHistoryVal);
						egMgrMiscWr.saveFile();
						EgConfigFilesSync.releaseInstance(egMgrMiscWr);
					}
				}
			}
			/* User Password History Storage - ENDS */

			dispUserName = uname;
			if (uname.startsWith("samlsso/"))
			{
				String tmp = uname;
				int idx = tmp.indexOf("/");
				dispUserName = tmp.substring(idx+1);
				dispUserName = dispUserName + " (SAML)";
			}

			if(userAuthentication == null || userAuthentication.equals("Eg"))
			{
				auditLogThread.setCurrentValue("02~~User Authentication","Local");
			}
			else if (userAuthentication.equals("SAML"))
			{
				auditLogThread.setCurrentValue("02~~User Authentication","SAML");
			}
			else
			{
				auditLogThread.setCurrentValue("02~~User Authentication","Domain");
				auditLogThread.setCurrentValue("03~~Domain",domainName);
			}
			
			auditLogThread.setCurrentValue("04~~New User ID",dispUserName);

			if(never != null && never.equals("Never"))
			{
				auditLogThread.setCurrentValue("05~~Expiry Date","Never");
			}
			else
			{
				auditLogThread.setCurrentValue("05~~Expiry Date",curdate);
				//auditLogThread.setCurrentValue("05~~Expiry Date",request.getParameter("dateforpro"));
			}

			auditLogThread.setCurrentValue("06~~Mail ID/Mobile Number",tomailid);
			auditLogThread.setCurrentValue("07~~Time Zone",timezoneForAudit);
			auditLogThread.setCurrentValue("08~~Language",languageName);

			aListUserAttributes.add(uname);
			aListUserAttributes.add(password);
			aListUserAttributes.add(expiry_date);
			aListUserAttributes.add(mailid);
			aListUserAttributes.add(timezone);
			aListUserAttributes.add(language);

			String categories = request.getParameter("categoryCheck");

			if (categories != null)
			{
				StringTokenizer st = new StringTokenizer(categories,",");

				while(st.hasMoreTokens())
				{
					String aCategory = (String) st.nextToken();
					aListCategoriesForReplication.add(aCategory);
					mappedUI = (String)mapToUI.get(aCategory);
					auditLogThread.setCurrentValue("09~~Categories for Replication",mappedUI);
				}
			}
			
			aListUserAttributes.add(existingUser);

			EgCloneUser EgCloneUserObj = new EgCloneUser(existingUser,uname,password);
			EgCloneUserObj.setAttributes(aListUserAttributes,aListCategoriesForReplication);
			ArrayList clonedResults = EgCloneUserObj.cloneUser();

			auditLogThread.setValue("Description","User "+dispUserName+" has been cloned from existing user "+ existUserDispVal);
			auditLogThread.setValue("Activity","Clone User");
			auditLogThread.sendItToDB();

			/* code for 2fa starts here */
			if (!isSSOSelected && is2faCFlagEnabled)
			{
				IniFile egMFAIniFilePtr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_mfa.ini",true);
				String twofaOTPModeFlagVal = "";
				if (is2faCFlagEnabled)
				{
					twofaOTPModeFlagVal = egMFAIniFilePtr.getValue("2FA_SETTINGS","TwoFAOTPModeFlag");
				}
				String secretKey = GoogleAuthenticator.getRandomSecretKey();
				String encryptedSecretKey = EgCrypt.encrypt(secretKey);

				String usrMailid = request.getParameter("mailIDVal");
				String encryptedUserID = EgCrypt.encrypt(uname);

				egMFAIniFilePtr.setValue("2FAEnabledUsers",encryptedUserID,encryptedUserID);
				egMFAIniFilePtr.setValue(encryptedUserID,"EnabledMode",EgCrypt.encrypt(twofaOTPModeFlagVal));
				egMFAIniFilePtr.setValue(encryptedUserID,"SecretKey",encryptedSecretKey);

				if (twofaOTPModeFlagVal != null && twofaOTPModeFlagVal.equalsIgnoreCase("ga") && usrMailid != null && usrMailid.trim().length() > 0)
				{
					String mailSubject = "Secret Key to register Google Authenticator";
					String bodyContent = "The secret key for '"+uname+"' is <b>"+secretKey+"</b>. Please refer the attached document to register the secret key in Google Authenticator app for generating time based one-time password.";

					EgMailHelper mailObj = new EgMailHelper(usrMailid);
					mailObj.setAttachmentFile(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/docs/Google Authenticator Guide.docx");
					int mailStatus = mailObj.sendMail(mailSubject, bodyContent);

					if (mailStatus == 0)
					{
						rootJson.put("TwoFAMailSend","success");
					}
					else if (mailStatus == 1 || mailStatus == 2 || mailStatus == 3 || mailStatus == 4)
					{
						String errorMsg = "Problem occured while sending verification code to the user/group mail address.";
						rootJson.put("TwoFAMailSend","failed");
						rootJson.put("MailSendErrMsg",errorMsg);
					}
				}
				egMFAIniFilePtr.saveFile();
				EgConfigFilesSync.releaseInstance(egMFAIniFilePtr);
			}
			/* for 2fa - ends here */
		}
		IniFile uuuidIni_write = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_uuid.ini",true);
		String org = uuuidIni_write.getValue("ORGANIZATION_MAPPING",existingUser);
		String compTypePref = uuuidIni_write.getValue("COMPONENT_TYPE_PREFERENCES",existingUser);
		uuuidIni_write.setValue("ORGANIZATION_MAPPING",uname,org);
		if (compTypePref != null && compTypePref.trim().length() > 0)
		{
			uuuidIni_write.setValue("COMPONENT_TYPE_PREFERENCES",uname,compTypePref);
		}
		uuuidIni_write.saveFile();
		EgConfigFilesSync.releaseInstance(uuuidIni_write);

		Vector sessVec = new Vector();
		sessVec.add(_mapping.getTextDescription("admin.user.Add new user"));
		sessVec.add("EgAddUser.jsp");
		sessVec.add(_mapping.getTextDescription("admin.user.Clone user"));
		sessVec.add(_mapping.getTextDescription("admin.user.The user(s) has been cloned successfully")+".");
		session.putValue("vec_Results", sessVec);
		String url = "EgResults.jsp";
	}
	rootJson.put("error",error);
	rootJson.put("success","true");
	out.println(rootJson.toString());

%>



