<%
/**
 *	File name       :	EgRHEVDiscovery.jsp
 *  Purpose			:	To Discover the Redhat Hypervisor Manager and its associated Hypervisors.
 *	Creation Date	:	Nov 30 2011
 *	Author			:	Gandhiraj. N
 *	Design Changes	:	
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.eg.*"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);
%>
<%
	String from = request.getParameter("from");
	String refferalURL = request.getParameter("refferalURL");
	String showModify = request.getParameter("showModify");
	String actionType = request.getParameter("actionType");
	String platform = request.getParameter("platform");
	String frmLocation = request.getParameter("frmLocation");
	String sub = "RHEV";
	IniFile testIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String[] allValues = testIniFile.getLinesUnderSubject(sub);
	String[] allRHEVs = testIniFile.getVariables(sub);
	String un = "";
	String pw = "";
	String hn = "";
	String ssl = "";
	String isdis = "";
	String ip="";
	String isSsl="";
	String isDiscovery="";
	String uName="";
	String uPass="";
	String webPort = "";
	String hName = "";
	String domainTmp = "";
	String domain = "";
	Hashtable allData = new Hashtable();
	if(from != null && (from.equals("rhevAdd")||from.equals("rhevDelete")||from.equals("rhevModify") || from.equals("rhevView")))
	{
		ip=request.getParameter("ipAdd");
		StringTokenizer st = null;
		StringTokenizer st1 = null;
		if(allValues!=null && allValues.length>0)
		{
			for(int i=0;i<allValues.length;i++)
			{
				String str = allValues[i];
				st = new StringTokenizer(str,"=");
				String s1 = st.nextToken();
				String s2 = st.nextToken();
				ArrayList content =new ArrayList();
				if(s2!=null)
				{
					st1 = new StringTokenizer(s2,"#");
					if (st1.hasMoreTokens() && st1.countTokens() == 6)
					{
						ssl = st1.nextToken();
						un = st1.nextToken();
						pw = st1.nextToken();
						isdis = st1.nextToken();
						webPort = st1.nextToken();
						domainTmp = st1.nextToken();
					}
				}
				pw = EgCrypt.decrypt(pw);
				content.add(ssl);
				content.add(isdis);
				content.add(un);
				content.add(pw);
				content.add(webPort);
				content.add(domainTmp);
				allData.put(s1,content);
			}
		}

		if(ip!=null && !from.equals("rhevAdd"))
		{
			ArrayList content = (ArrayList)allData.get(ip);
			isSsl=(String)content.get(0);
			isDiscovery=(String)content.get(1);
			uName=(String)content.get(2);
			uPass=(String)content.get(3);
			webPort = (String)content.get(4);
			domain = (String)content.get(5);
		}
	}
	if (uPass != null && uPass.length() > 0)
	{
		uPass = StringUtils.replace(uPass,"\"","&#34;");
	}
%>

<html>
<head>
<title>RHEV Discovery</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui="admin"/>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="eg_scripts/eg_configtest.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="Javascript1.2">

function isNetscape() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 

	// check for Navigator ver 4+. 
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 

	// check for IE ver 4+. 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function validateForm(check)
{
	var thisForm = document.rhevDiscovery;
	var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
	var webPortValue = thisForm.webport.value;
	var where='<%=from%>';
	if(thisForm.ipAdd.value == 'Choose RHEV Manager')
	{
		alert('<egui:intnl text="admin.discovery.Please choose a RHEV Manager identity"/>');
		thisForm.ipAdd.focus();
		return;
	}
	if(!checkblank(thisForm.ipAdd)||thisForm.ipAdd.value == 'none'||thisForm.ipAdd.value == 'None'||thisForm.ipAdd.value == 'other'||thisForm.ipAdd.value == 'Other')
	{
		alert('<egui:intnl text="admin.discovery.Please enter the RHEV Manager identity"/>');
		thisForm.ipAdd.focus();
		return;
	}
	if (where != "rhevModify")
	{
		if(!validateIpOrHName(thisForm.ipAdd.value))
		{
			thisForm.ipAdd.focus();
			return;
		}
	}
	var hostLen = thisForm.ipAdd.value;
	if (hostLen != null && hostLen.length > 24)
	{
		alert('<egui:intnl text="admin.discovery.Maximum host name length is 24 characters"/>');
		thisForm.ipAdd.focus();
		return;
	}
	if(!checkblank(thisForm.uname))
	{
		alert('<egui:intnl text="admin.discovery.Please enter the username"/>');
		thisForm.uname.focus();
		return;
	}
	else if(!checkspecial(thisForm.uname,"	@#$%^&*+={}|:;\"\'<>,\/"))
	{
		thisForm.uname.focus();
		return;
	}
	else if(!checkHyphenText(thisForm.uname.value,thisForm.uname.name))
	{
		thisForm.uname.focus();
		return;
	}

	if(thisForm.pass.value == "")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the password"/>');
		thisForm.pass.focus();
		sub = false;
		return;
	}
	else if(!checkspecialnomess(thisForm.pass,"|"))
	{
		alert("<egui:intnl text='admin.test.Password data should not contain pipe'/>");
		thisForm.pass.focus();
		sub = false;
		return;
	}
	else if(!checkForPassValidity(thisForm.pass.value))
	{
		thisForm.pass.focus();
		sub = false;
		return;
	}
	else if(thisForm.confpasswd.value == "")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the confirm password"/>');
		thisForm.confpasswd.focus();
		sub = false;
		return;
	}
//	else if(!checkloginpass(thisForm.confpasswd))
//	{
//		thisForm.confpasswd.focus();
//		sub = false;
//		return;
//	}
	else if(!checkspace(thisForm.confpasswd))
	{
		thisForm.confpasswd.focus();
		sub = false;
		return;
	}
	else if(thisForm.pass.value != thisForm.confpasswd.value)
	{
		alert('<egui:intnl text="admin.discovery.Passwords do not match"/>');
		thisForm.confpasswd.focus();
		sub = false;
		return;
	}
	else if(!checkblank(thisForm.webport))
	{
		alert('<egui:intnl text="admin.discovery.Blank values are not allowed"/>');
		thisForm.webport.focus();
		sub = false;
		return;
	}
	else if(!checkspace(thisForm.webport))
	{
		thisForm.webport.focus();
		sub = false;
		return;
	}
	else if (thisForm.webport.value > 99999)
	{
		alert('<egui:intnl text="admin.discovery.Manager port should be less than 99999"/>');
		thisForm.webport.focus();
		sub = false;
		return;
	}
	else if(!checkcomma(thisForm.webport))
	{
		alert('<egui:intnl text="admin.discovery.Please enter a port number"/>');
		thisForm.webport.focus();
		sub = false;
		return;
	}
	else if (((!checknumber("+",thisForm.webport) && webPortValue.indexOf(',') == -1) || webPortValue == 0 || webPortValue.indexOf('.') > -1) && (webPortValue == 'NULL') || (webPortValue.indexOf(',') > -1))
	{
		alert('<egui:intnl text="admin.discovery.Port number can consist of only valid numbers"/>');
		thisForm.webport.focus();
		sub = false;
		return;
	}
	else if(!checkspecialnomess(thisForm.webport,splChar) && (webPortValue != 'NULL'))
	{
		alert('<egui:intnl text="admin.discovery.Special characters not allowed"/>');
		thisForm.webport.focus();
		sub = false;
		return;
	}

	var valFrom = '<%=from%>';
	if(thisForm.isDiscovery.value == 'Yes')
	{
		if ("<%=refferalURL%>" == "EgFrame")
		{
			thisForm.action = "./EgRHEVdiscoveryp.jsp?from="+valFrom;
			thisForm.submit();
		}
		else
		{
			var ans = confirm('<egui:intnl text="admin.discovery.Do you want to discover the RHEV Hypervisor servers"/>?');
			if(ans == true)
			{
				thisForm.StartDiscovery.value = '<egui:intnl text="admin.discovery.Discovery"/>'+"...";
				var checkVal = valFrom+'RhevDiscovery';
				thisForm.action = "./EgRHEVdiscoveryp.jsp?from="+checkVal;
				thisForm.submit();
			}
			else
			{
				thisForm.action = "./EgRHEVdiscoveryp.jsp?from="+valFrom;
				thisForm.submit();
			}
		}
		
	}
	else
	{
		thisForm.action = "./EgRHEVdiscoveryp.jsp?from="+valFrom;
		thisForm.submit();
	}
}


function clearForm()
{
	var thisForm ="";
	if ('<%=from%>'=='rhevAdd')
		thisForm=window.document.rhevDiscovery;
	thisForm.ipAdd.value="";
	thisForm.uname.value="";
	thisForm.pass.value="";
	thisForm.confpasswd.value="";
	thisForm.domain.value="";
}

function rhevOnChange()
{
	var value=document.rhevDiscovery.ipAdd.options[document.rhevDiscovery.ipAdd.selectedIndex].value;
	if(value=='Choose RHEV Manager')
	{
		//document.rhevDiscovery.uname.value="$unconfigured";
		//document.rhevDiscovery.pass.value="$unconfigured";
		//document.rhevDiscovery.confpasswd.value="$unconfigured";

		document.rhevDiscovery.uname.value="";
		document.rhevDiscovery.pass.value="";
		document.rhevDiscovery.confpasswd.value="";
		document.rhevDiscovery.ssl.value='True';
		document.rhevDiscovery.webport.value="8443";
		document.rhevDiscovery.domain.value="internal";
		return;
	}
	var valFrom = '<%=from%>';
	if ("<%=refferalURL%>" == "EgFrame")
	{
		window.location.href = "EgDiscServers.jsp?ipAdd="+value+"&from="+valFrom+"&opt=RHEV&action=modify";
	}
	else
	{
		window.location.href = "EgRHEVDiscovery.jsp?ipAdd="+value+"&from="+valFrom;
	}
}

function checkAll()
{
	var thisForm ="";
	if ('<%=from%>'=='rhevDelete')
		thisForm=window.document.rhevDiscoveryDel;
	var select = thisForm.vcAll.checked;
	for(i=0;i<thisForm.elements.length;i++)
	{
		if(thisForm[i].type=="checkbox" && thisForm[i].name!="vcAll")
			thisForm[i].checked =select;
		
	}
}

function checkAllSelected(thisForm)
{
	for(i=0;i<thisForm.elements.length;i++)
	{
		
		if(thisForm[i].type=="checkbox" && thisForm[i].name!="vcAll" && !thisForm[i].checked)
			return false;
	}
	return true;
}

function checkAnySelected(thisForm)
{
	var thisForm ="";
	if ('<%=from%>'=='rhevDelete')
		thisForm=window.document.rhevDiscoveryDel;
	for(i=0;i<thisForm.elements.length;i++)
	{
		if(thisForm[i].type == "checkbox" && thisForm[i].checked)
			return true;
	}
	return false;
}

function checkItem(ctrl)
{
	var thisForm ="";
	if ('<%=from%>'=='rhevDelete')
		thisForm=window.document.rhevDiscoveryDel;
	var flag = ctrl.checked;
	if(flag)
	{
		thisForm.vcAll.checked = checkAllSelected(thisForm);
	}
	else
		thisForm.vcAll.checked = false;
}

function validateFormDelete(entity)
{
	var thisForm ="";
	if (entity=='rhevDelete')
		thisForm=window.document.rhevDiscoveryDel;
	if(!checkAnySelected(thisForm))
	{
		alert('<egui:intnl text="admin.discovery.No Items selected!"/>');
		return;
	}
	else if('<%=from%>' == 'rhevDelete' && !confirm('<egui:intnl text="admin.discovery.Are you sure you want to delete this RHVM Manager"/> ?'))
	{
		return;
	}

	var str="";
	var len=thisForm.vc.length;
	
	if(len==undefined)
	{
		if(thisForm.$vc.value!=null)
		{
			var xxx=thisForm.$vc.value;
			str+=xxx+",";
		}
	}
	else
	{
		for (var i=0; i<len;i++) 
		{
			if(thisForm.vc[i].checked)
			{
				var xxx=thisForm.$vc[i].value;
				str+=xxx+",";
			}
		}
	}
	var s='<%=from%>';
	if (entity=='rhevDelete')
		thisForm.action = "EgRHEVdiscoveryp.jsp?from="+s+"&rhev="+str;
	thisForm.submit();
}

//function init()
//{
//	var from='<%=from%>';
//	if(from=="rhevAdd" || from=="rhevModify" || from=="rhevDelete")
//	{
//		var treeIframe=window.parent.document.getElementById("DiscoveryTree");
//		if(treeIframe!=null)
//		{
//			treeIframe.src="/final/admin/EgDiscoveryTreeUI.jsp?linkFrom=<%=from%>";
//		}
//	}
//}

function setPort(obj)
{
	var thisForm = document.rhevDiscovery;
	if (obj != null)
	{
		if (obj.value == 'True')
		{
			thisForm.webport.value="8443";
		}
		else
		{
			thisForm.webport.value="8080";
		}
	}
}

function Modify()
{
	window.location.href = "EgDiscServers.jsp?autoRefresh=false&startDiscThread=no&showComponent=no&opt=RHEV&action=rhevModify";
}

function changeAction(val)
{
	var eleId = document.getElementById("discoverAct");
	if (eleId != null && eleId != 'undefined')
	{
		if (val == "No" || val == "no")
		{
			eleId.value = "Update";
		}
		else
		{
			eleId.value = "Discover";
		}
	}
}


function showResultSets(platform,frmlocation)
{
	frmlocation = frmlocation.toUpperCase();
	if (platform == "virtual")
	{
		var resultContainer = window.parent.document.getElementById("resultContainer2");
		resultContainer.innerHTML = "<i><b>The virtual platform settings of your environment for discovery have been updated successfully.</b></i>";
		if (frmlocation.indexOf("MODIFY") != -1)
		{
			var rowID1 = window.parent.document.getElementById("rowID1");
			var rowID2 = window.parent.document.getElementById("rowID2");
			if (!isNetscape())
			{
				rowID1.style.display = "none";
				rowID2.style.display = "block";
			}
			else
			{
				rowID1.style.display = "none";
				rowID2.style.display = "table-row";
			}
		}
		else
		{
			var rowID1 = window.parent.document.getElementById("rowID1");
			var rowID2 = window.parent.document.getElementById("rowID2");
			if (!isNetscape())
			{
				rowID1.style.display = "block";
				rowID2.style.display = "none";
			}
			else
			{
				rowID1.style.display = "table-row";
				rowID2.style.display = "none";
			}
		}
	}
	var divID = window.parent.document.getElementById("resultDiv");
	divID.style.display = "block";
}

</script>
</head>

<!-- <body leftmargin="0" topmargin="20" marginwidth="0" marginheight="20" bgcolor="#FFFFFF"> -->
<!-- <body style="overflow:auto" id="space6" onload="javascript:init()"> -->
<body style="overflow:auto" id="space6" >
<%
String title=egMappingInfo.getTextDescription("admin.title.DISCOVERY >> RHEV MANAGER DISCOVERY");
String Qs="";
if(from.equals("rhevAdd")||from.equals("rhevModify") || from.equals("rhevDelete") || from.equals("rhevView"))
{
	Qs="&from=rhevSettings";
}
%>
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
<%
	if (refferalURL == null || !refferalURL.equalsIgnoreCase("EgFrame"))
	{
%>
		<jsp:include page='<%="listSearch.jsp?title="+title+"&leftString=Add User&backButton=false&subtitle=false"+Qs%>'/>
<%
	}
if(from.equals("rhevAdd")|| (from.equals("rhevModify") && allRHEVs.length > 0))
{
%>
	<tr>
		<td>
		<FORM name="rhevDiscovery" method="post" style="margin:0px" >
			<input type="hidden" name="refferalURL" value="<%=refferalURL%>" />
			<div class="div_scroll" style="height:320px; border:0px solid #ff0000;">
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
								
<%
		if (refferalURL != null && refferalURL.equalsIgnoreCase("EgFrame"))
		{
%>
								<egui:intnl text="admin.discovery.RHEV Manager Preferences"/>
<%
		}
		else
		{
%>
								<egui:intnl text="admin.discovery.Red Hat Hypervisor Manager Discovery"/>


<%
		}

%>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td  align="center">
						<table  width="100%" cellspacing="0" cellpadding="0" border="0" >
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.RHEV Manager identity (IP or Host name)"/></th>
								<td class="form_border eg_subcontentbg">:</td>
<%
		if(from.equals("rhevAdd"))
		{
%>
								<td class="form_border eg_subcontentbg"><input type="text" name="ipAdd" value="" style="width:150px"></td>
<%
		}
		else if(from.equals("rhevModify"))
		{
%>
								<td class="form_border eg_subcontentbg">
									<SELECT name=ipAdd style="width:150px;" onChange="javascript:rhevOnChange()">
									<option value="Choose RHEV Manager"><egui:intnl text="admin.discovery.Choose RHEV Manager"/></option>
<%
			if(allRHEVs!=null&&allRHEVs.length>0)
			{
				for(int i=0;i<allRHEVs.length;i++)
				{
%>
									<option value="<%=allRHEVs[i]%>"<%=allRHEVs[i].equals(ip)?"selected":""%>><%=allRHEVs[i]%> </option>
<%
				}
			}
%>
									</SELECT>
								</td>
<%
		}
%>
							</tr>
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Use SSL to connect to RHEV Manager"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg">
									<SELECT name=ssl onChange="javaScript:setPort(this)">
									<option value="True" <%=isSsl.equalsIgnoreCase("True")?"selected":""%>><egui:intnl text="admin.discovery.Yes"/></option>
									<option value="False" <%=isSsl.equalsIgnoreCase("False")?"selected":""%>><egui:intnl text="admin.discovery.No"/></option>
									</SELECT>
									<input type = "hidden" name="$_ssl" value="<%=isSsl.equalsIgnoreCase("True")?"Yes":"No"%>">
								</td>
							</tr>
<%
		if (webPort != null)//For Initial loading
		{
			if (isSsl != null && isSsl.equals(""))
			{
				webPort = "8443";
			}
		}
		if (domain != null && domain.equals(""))
		{
			domain = "internal";
		}
%>
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Manager Port"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="text" name="webport" value="<%=webPort%>" style="width:150px"></td>
								<input type="hidden" name="$_webport" value="<%=webPort%>"></td>
							</tr>
							<!-- Webport -->
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Discover RHEV Hypervisors using this RHEV Manager"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg">
									<SELECT name=isDiscovery>
									<option value="Yes" <%=isDiscovery.equalsIgnoreCase("Yes")?"selected":""%>><egui:intnl text="admin.discovery.Yes"/></option>
									<option value="No" <%=isDiscovery.equalsIgnoreCase("No")?"selected":""%>><egui:intnl text="admin.discovery.No"/></option>
									</SELECT>
									<input type = "hidden" name="$_isDiscovery" value = "<%=isDiscovery.equalsIgnoreCase("Yes")?"Yes":"No"%>">
								</td>
							</tr>
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Username to connect to RHEV Manager"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="text" name="uname" value="<%=uName%>" style="width:150px">
								<input type="hidden" name="$_uname" value="<%=uName%>"></td>
							</tr>
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Password for the user"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="password" name="pass" value="<%=uPass%>" style="width:150px"></td>
							</tr>
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Confirm password for the user"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="password" name="confpasswd" value="<%=uPass%>" style="width:150px">
								<input type="hidden" name="$_confpasswd" value="<%=uPass%>">
								</td>
							</tr>
							<tr>
								<th class="form_spacing eg_subcontentbg"><egui:intnl text="admin.discovery.Domain name for the RHEV Manager"/></th>
								<td class="form_spacing eg_subcontentbg">:</td>
								<td class="form_spacing eg_subcontentbg"><input type="text" name="domain" value="<%=domain%>" style="width:150px">
								<input type="hidden" name="$_domain" value="<%=domain%>">
								</td>
							</tr>
							<tr>
								<td colspan="3">
									<table width="100%" cellpadding="0" cellspacing="0" border="0">
										<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
										<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
										<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" class="eg_whitebg" height="10" nowrap>&nbsp;</td>
				</tr>
				<tr>
<%
		if (refferalURL != null && refferalURL.equalsIgnoreCase("EgFrame"))
		{
%>
				<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
				<input type="button" name = 'StartDiscovery' id="discoverAct" value='<egui:intnl text="admin.common.Update"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateForm('update');">&nbsp;&nbsp;
<%
		}
		else
		{
%>
					<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
					<input type="button" name = 'StartDiscovery' value='<egui:intnl text="admin.common.Update"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateForm('update');">&nbsp;&nbsp;
<%	
		}
		if(from.equalsIgnoreCase("rhevAdd"))
		{
%>
					<input type="button" value='<egui:intnl text="admin.common.Clear"/>' style="width: 90px;" class="eg_back" onClick="javascript:clearForm();" >&nbsp;&nbsp;
<%		
		}
%>
					
					</td>
				</tr>
			</table>
			</div>
			</FORM>
		</td>
	</tr>
<%
}
if((from.equalsIgnoreCase("rhevView") || from.equalsIgnoreCase("rhevDelete")) && allRHEVs.length>0)
{
%>
	<tr>
		<td>
			<FORM name="rhevDiscoveryDel" method="post" style="margin:0px" >
			<input type="hidden" name="refferalURL" value="<%=refferalURL%>" />
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><egui:intnl text="admin.discovery.Red Hat Hypervisor Managers"/>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td class="eg_subcontentbg">
						<table  width="100%" cellspacing="0" cellpadding="4" border="0" height="22" >
<%
	if (from.equalsIgnoreCase("rhevDelete"))
	{

%>
						<col width=30><col width=250><col width=120><col width=120><col width=100>
							<tr>
<%
	}else
	{
%>
						<col width=250><col width=120><col width=120><col width=100>
							<tr>
<%
	}
	if (from.equalsIgnoreCase("rhevDelete"))
	{
%>

								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><input type="checkbox" id="eg_input" name="vcAll" onClick="javascript:checkAll()"> </td>
<%
	}
%>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.RHEV Manager IP/Host"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.SSL"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.RHEV Manager Port"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.Discovery"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;"><b><egui:intnl text="admin.discovery.User"/></b></td>
								<td id="cell_border3" style=""><b><egui:intnl text="admin.discovery.Domain"/></b></td>
							</tr>
<%
	for(int v=0;v<allRHEVs.length;v++)
	{
		String rhevIP=allRHEVs[v];
		ArrayList content = (ArrayList)allData.get(rhevIP);
		isSsl= (String)content.get(0);
		if(isSsl.equalsIgnoreCase("True"))
			isSsl="Yes";
		else
			isSsl="No";
		isDiscovery=(String)content.get(1);
		uName=(String)content.get(2);
		webPort = (String)content.get(4);
		domain = (String)content.get(5);
%>
							<tr>
<%
		if (from.equalsIgnoreCase("rhevDelete"))
		{
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><input type="checkbox" id="eg_input" name="vc" onClick="javascript:checkItem(this)"> </td>
<%
		}
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><%=rhevIP%> </td>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><%=isSsl%></td>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><%=webPort%></td>
<%
		if(isDiscovery.equalsIgnoreCase("yes"))
		{
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;" ><img src="/final/admin/eg_images/right.gif">
								</td>
								
<%
		}
		else
		{
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;" ><img src="/final/admin/eg_images/wrong.gif">
								</td>
<%
		}
%>
								<td id="cell_border4" style="border-left-width:1px;"><%=uName%></td>
								<td id="cell_border4" style=""><%=domain%></td>
									<input type="hidden" id="eg_input" name="$vc" value='<%=rhevIP%>'>
							</tr>
<%
	}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td  id="eg_blankspace" class="eg_whitebg" height="10" nowrap>&nbsp;</td>
				</tr>
<%
	if (from.equalsIgnoreCase("rhevDelete"))
	{
%>
				<tr>
					<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
					<input type="button" value='<egui:intnl text="admin.common.Delete"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateFormDelete('rhevDelete');">&nbsp;&nbsp
					</td>
				</tr>
<%
	}
%>
			</table>
			</FORM>
		</td>
	</tr>
<%
}
if(allRHEVs.length==0&&(from.equalsIgnoreCase("rhevDelete")||from.equalsIgnoreCase("rhevView")||from.equalsIgnoreCase("rhevModify")))
{
%>
	<tr>
		<td>
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td  align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><egui:intnl text="admin.discovery.Red Hat Hypervisor Managers"/>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" align="center">&nbsp;</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" align="center" valign="middle"><img src="/final/admin/eg_images/exclamation-icon.gif" border="0"><br><egui:intnl text="admin.discovery.No Red Hat Hypervisor Manager servers are available currently"/></td>
				</tr>
				<tr>
					<td>
						<table width="100%" cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
<%
		if (refferalURL != null && refferalURL.equalsIgnoreCase("EgFrame"))
		{
%>
				<tr>
					<td align="center"><BR>
						<a href="EgDiscServers.jsp?autoRefresh=false&startDiscThread=no&showComponent=no&opt=RHEV&action=add" class="eg_monlink" id="mouse"><b><egui:intnl text="admin.discovery.Click here"/></b></a>
							to add a new RHEV manager.
					</td>
				</tr>
<%
		}
%>
		
			</table>
		</td>
	</tr>
<%
}	
%>

	<input type="hidden" id="platform" value="<%=platform%>">
	<input type="hidden" id="frmLocation" value="<%=frmLocation%>">
<%
	String isRedirected = request.getParameter("isRedirected");
	if (isRedirected != null && isRedirected.equalsIgnoreCase("true"))
	{
%>
		<script type="text/javascript">
			showResultSets('<%=platform%>','<%=frmLocation%>');
		</script>
<%
	}
%>

</table>
</body>
</html>
<%
session.setAttribute("adminLastAccessedURL","/final/admin/EgDiscoveryTree.jsp?treeViewSrc="+from+"&showtree=discoverytree");
%>



