<%
/*****************************************************************************
*  File			: 	EgFileUpload.jsp
*  Purpose		: 	Uploading files to server
*  Version		: 	1.0
*  Creation Date: 	03/02/2005
*
*  Author		: 	Solomon.S, Murugapandian R
******************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="java.io.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.egurkha.util.multipart.*" %>
<%@ page import="javax.servlet.*" %>
<%@ page import="javax.servlet.http.*" %>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.*"%>

<%!
	//Stack page(EgStack.jsp) file uploading...(Start)
	public String installDir = EgInstallInfo.getInstallDir();
	String mgrFlag = "";
	ArrayList uploadedFilesList = null;

	//this redirect() method shows the uploaded file information in UI
	public void redirect(PrintWriter pw, HttpServletRequest request)
	{
		HttpSession session = request.getSession();
		String sessionid = session.getId();
		User user=null;
		String adminSkin=null;
		try
		{
			user = UserRegistry.getInstance().getUser(sessionid);
			adminSkin = user.getAdminSkin();
		}
		catch(Exception e)
		{
			adminSkin ="blue";
		}
		pw.println("<html><head><title>Files Uploaded</title><link rel='stylesheet' href='/final/admin/eg_styles/adminstyle_"+adminSkin+".css' />");
		pw.println("<script type=\"text/javascript\">");
		if(mgrFlag != null && mgrFlag.equals("true"))
			pw.println("function myfunction() { window.close();}");
		else if(mgrFlag != null && mgrFlag.equals("startDiscovery"))
		{
			pw.println("function myfunction() { window.opener.startDiscovery('2'); window.close();}");
		}
		else
		{
			pw.println("function myfunction() { window.close(); window.open(\"/final/misc/EgStack.jsp?sessionInUse=true&from=file\",\"oldwin\"); }");
		}
		pw.println("</script></head>");
		pw.println("<body leftmargin='10' topmargin='10' marginwidth='0' marginheight='0' class='body_text'>");
		pw.println("<form name='fileupload'>");
		pw.println("<center><br><br><font face='verdana' size='1'><b>Request has been processed successfully</b>.</font><br><br>");
			pw.println("<input type='button' name='closewin' class='eg_back' value='Close' style='width: 80px;' onClick='javascript:myfunction()'>");
		pw.println("</center></form></body></html>");
	}

	//this uploadFile() method for reading and writing of a file into specified directory
	public void uploadFile(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
	{
		Hashtable ht_parampart=new Hashtable();
		Hashtable ht_filepart=new Hashtable();
		PrintWriter out=response.getWriter();
		String fileName="";

		try
		{
			MultipartParser mp = new MultipartParser(request, 10*1024*1024); // 10MB
			com.egurkha.util.multipart.Part part;
			String folder="";
			
			while ((part = mp.readNextPart()) != null)
			{
				String name = part.getName();
				if (part.isParam())
				{
					ParamPart paramPart=(ParamPart)part;
					ht_parampart.put(name,paramPart.getStringValue());
				}
				else if (part.isFile())
				{
					FilePart filePart=(FilePart)part;
					ht_parampart.put("#"+name, name);
					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					filePart.writeTo(baos);
					byte[] fileContent = baos.toByteArray();
					baos.close();
					if(fileContent.length>0)
					{
						ht_parampart.put(name+"_name", filePart.getFileName());
						ht_filepart.put(name, fileContent);
					}
				}
			}

			Iterator itr = ht_filepart.keySet().iterator();
			byte[] thisFileContent=null;
			String s_dstFile="";
			while(itr.hasNext())
			{
				String key = (String)itr.next();
				fileName=(String)ht_parampart.get(key+"_name");
				s_dstFile = ((String)ht_parampart.get(key + "_dstFile"));
				thisFileContent = (byte[])ht_filepart.get(key);
				File thisFile=null;
				if(s_dstFile==null)
				{
					thisFile=new File(installDir+"/tmp/"+fileName);
				}else
				{
					File targetFile = new File(installDir+"/"+s_dstFile);
	
					if (targetFile.isDirectory())
					{
						thisFile=new File(installDir+"/"+s_dstFile+"/"+fileName);
					}else
					{
						thisFile=new File(installDir+"/"+s_dstFile);
					}
				}

				FileOutputStream fos = new FileOutputStream(thisFile);
				fos.write(thisFileContent);
				fos.close();
			}
			if(EgInstallInfo.isClusterSupported)
			{
				//If clustering is supported inform other managers about the new Image.
				UploadCustomImage customImage = new UploadCustomImage();
				customImage.getCustomImage(s_dstFile,thisFileContent);
				customImage = null;
			}

			this.redirect(out,request);
		}
		catch (IOException lEx)
		{
			this.getServletContext().log(lEx, "error reading or saving file");
			lEx.printStackTrace();
		}catch (Exception e)
		{
			e.printStackTrace();
		}
	}
%>

<%
	/* Store the uploaded files information into eg_udtests.ini file ... Start*/
	mgrFlag=request.getParameter("mgrLog");
	String test=request.getParameter("test");
	String mbeanFile=request.getParameter("mbeanFile");
	if(mbeanFile != null && mbeanFile.length() > 0 && test != null)
	{
		IniFile egUDTestFile = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_udtests.ini");
		String val = egUDTestFile.getValue("UPLOADED_FILES",test);
		ArrayList tokList = new ArrayList();
		if(val != null && val.length() > 0)
		{
			StringTokenizer str= new StringTokenizer(val,",");
			while(str.hasMoreTokens())
			{
				String tok = str.nextToken();
				tokList.add(tok);
			}
			if(!tokList.contains(mbeanFile))
				val = val+","+mbeanFile;
		}
		else
			val = mbeanFile;

		egUDTestFile.setValue("UPLOADED_FILES",test,val);
		egUDTestFile.saveFile();
		EgConfigFilesSync.releaseInstance(egUDTestFile);
	}
	/* Store the uploaded files information into eg_udtests.ini file ... Eng*/

	String fileToUpload=request.getParameter("fileUpload");
	if(fileToUpload != null && fileToUpload.equals("yes"))
	{
		uploadFile(request, response);
		return;
	}
	//Stack page(EgStack.jsp) file uploading...(End)

	String windowTitle=request.getParameter("title");
	if(windowTitle==null)
		windowTitle="File Upload";
	String captions=request.getParameter("dispCaption");
	String uploadfiles=request.getParameter("uploadDir");
	String fileExt=request.getParameter("fileExt");
	StringUtils stringutil=new StringUtils();
	String [] caption_array=stringutil.getTokens(captions, ":");
	String [] file_array=stringutil.getTokens(uploadfiles, ":");
	int captions_length=caption_array.length;
	int uploadfiles_length=file_array.length;

	//Only for upload logo and alert sound settings (EgConfigLogoMsg.jsp) starts - Anand
	String from=request.getParameter("from");
	from=(from==null)?"":from;
	EgDbInfo egdbInfo=new EgDbInfo("manager");
	boolean isDouble=egdbInfo.isDoubleByteEnabled();
	File ff = new File(installDir+"/tmp");
	File []fileList = ff.listFiles();
	uploadedFilesList = new ArrayList();

	for(int x=0;x<fileList.length;x++)
	{
		if(fileList[x].isFile())
		{
			String name = fileList[x].getName();
			uploadedFilesList.add(name);
		}
	}
%>
<html>
<head>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="javascript">
function valform()
{
	var thisForm = document.fileupload;
	var fileExt="<%=fileExt%>";
	var isUpload=false;

	for (i=0; i<=(thisForm.length-1); i++)
	{
		if (thisForm[i].type==("file"))
		{
			if('<%=isDouble%>'=="false")
			{
				if(!validateSingleByte(thisForm[i].value))
				{
					alert('<egui:intnl text="admin.logo.File name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
					thisForm[i].focus();
					return false;
				}
			}
			if (thisForm[i].value.length>0)
				isUpload=true;
			if ((thisForm[i].value.toLowerCase().indexOf(fileExt))==-1)
			{
				//alert("One of the field is empty or the selected File does not have '" +fileExt + "' extension.");
				if ('<%=caption_array.length%>' > 1)
				{
					alert('<egui:intnl text="admin.logo.One of the field is empty or the selected File does not have the extension"/>'+", '" +fileExt+ "'" );
					thisForm[i].focus();
					return;
				}
				else
				{
					alert('<egui:intnl text="admin.logo.Field is empty or the selected File does not have the extension"/>'+", '" +fileExt+ "'" );
					thisForm[i].focus();
					return;
				}
			}
		}
	}

	if (isUpload)
	{
		thisForm.action="/final/admin/EgFileUploadForStack.jsp?fileUpload=yes";
		thisForm.submit();
		//this.window.close();
	}
	else
	{
		alert('<egui:intnl text="admin.logo.no files selected"/>');
	}
}

</script>
<title><%=windowTitle%></title>
<link rel=stylesheet href="styles/egadmin.css">
<link rel="stylesheet" href="eg_styles/eg_adminstyle.css" />
</head>
<body leftmargin="10" topmargin="10" marginwidth="0" marginheight="0">
<form name="fileupload" method="post" action="../servlet/com.eg.EgFileUpload" ENCTYPE="multipart/form-data">
<table cellpadding="1" cellspacing="1" align="center" border="1">
	<tr>
		<td nowrap height="10" id="eg_blankspace">&nbsp;</td>
	</tr>
	<tr>
		<td>
			<table width="440" cellpadding="0" cellspacing="0" align="center" border="0" id="table_outer_border" style="padding:0px">
				<tr>
					<td  colspan="2" align="left" id="eg_subheadbg" class="head_padding4"><b><egui:intnl text="admin.logo.Files to be uploaded"/>:</b></td>
				</tr>
<%
	int ctrl=0;
	for (ctrl=0; ctrl<caption_array.length; ctrl++)
	{
		String adminLogo="admin.logo.";
%>
				<tr>
					<td id="head_padding4"><b><egui:intnl text="<%=adminLogo+caption_array[ctrl]%>"/></b></td>
					<td id="head_padding4">:
<%
		// if the uploadfiles is less than captions, this file will be uploaded in eginstall/tmp with its original name
		if (ctrl<uploadfiles_length)
		{
%>
						<input type="hidden" name="FILE_<%=ctrl%>_dstFile" value="<%= file_array[ctrl]%>" >
<%
		}
%>
						<input id="file" type="FILE" name="FILE_<%=ctrl%>" <%=(from.equals("addlogo")?"accept='image/gif'":"")%> >
					</td>
				</tr>
<%
	}
%>
			</table>
		</td>
	</tr>
	<tr>
		<td colspan="2" align="center"><br/>
			<input type="button" name="upload" class="eg_back" value='<egui:intnl text="admin.common.Upload"/>' style="width: 80px;" onClick="javascript:valform()">
		</td>
	</tr>
</table>
</form>
</body>
</html>



