<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<html>
<head>
	<meta charset="utf-8">
	<title>Export/Import configuration</title>

	<!--Skin color--------->
	<egui:skin ui = "admin"/>

	<!---Components, icons, skin and Core ext script--->
	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>

	<!-- Application folder -->
	<script src="ExportImport/app/app.js"></script>
</head>
<body>
<script language="javascript">
var csrfToken = '<%=strCsrfToken%>';
var pageDesc = '<egui:intnl description="EgExportImportMainPage.jsp"/>';
var pageName = '<egui:intnl text="admin.title.EXPORT/IMPORT CONFIGURATION"/>'
var exportTitle = '<egui:intnl text="admin.title.Export configuration"/>'
var importTitle = '<egui:intnl text="admin.title.Import configuration"/>'
var alert1 = '<egui:intnl text="admin.export.Field is empty or the selected file does not have the extension"/>';
var alert2 = '<egui:intnl text="admin.export.Invalid file" />'+'! '+'<egui:intnl text="admin.export.File may be corrupt or you may have chosen the wrong file"/>';
var alert3 = '<egui:intnl text="admin.export.Configuration has been imported successfully"/>';
var alert4 = '<egui:intnl text="admin.export.Please select atleast one option to import"/>';
var alert5 = '<egui:intnl text="admin.export.Please select atleast one option to export"/>';
var alert6 = '<egui:intnl text="admin.export.The manager version of the import file is different" />'+'. <egui:intnl text="admin.export.You may lose some of your configuration while import" />'+'. <egui:intnl text="admin.export.Do you want to proceed anyway"/>?';
var exportTxt = '<egui:intnl text="admin.export.Export"/>';
var importTxt = '<egui:intnl text="admin.export.Import"/>';
var labelTxt = '<egui:intnl text="admin.export.Configuration zip file"/>';
var selectTxt = '<egui:intnl text="admin.common.Select all"/>';
var deSelectTxt = '<egui:intnl text="admin.common.Deselect all"/>';
var browseTxt = '<egui:intnl text="admin.common.Browse"/>';
var uploadTxt = '<egui:intnl text="admin.common.Upload"/>';
var cancelTxt = '<egui:intnl text="admin.common.Cancel"/>';
var alertZipMsg = '<egui:intnl text="admin.export.Please upload a valid configuration file"/>.';
var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
var errorTitle = '<egui:intnl text="admin.user.Error"/>';

var $j = jQuery.noConflict();
var publicJson = '';

Ext.onReady(function(){
	Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
	Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
	Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

	Ext.Ajax.on('requestexception', function (conn, response, options) {
		var errorStr = response.responseText;
		if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
		{
			if (errorStr.indexOf("user-session-invalid") != -1)
			{
				callWindow(1);
			}
			else if (errorStr.indexOf("user-deleted") != -1)
			{
				callWindow(2);
			}
			else if (errorStr.indexOf("user-timedout") != -1)
			{
				callWindow(3);
			}
		}
		else
		{
			if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
			{
				Ext.Msg.show({
					title : errorTitle,
					msg : requestTimeOut,
					buttons : Ext.Msg.OK,
					icon : 'iconError'
				});
			}
			else
			{
				console.log(response.responseText);
				Ext.Msg.show({
					title : errorTitle,
					msg : probsErrorMessage,
					buttons : Ext.Msg.OK,
					icon : 'iconError'
				});
			}
		}
	});
});
</script>
</body>
</html>

<%
	session.setAttribute("adminLastAccessedURL","/final/admin/EgExportImport.jsp?"+request.getQueryString());
%>



