<%
/*************************************************************************************************************
 *      File name               :       EgDiscovery.jsp
 *      Purpose                 :       To serve as a template for
                                        all the jsp's to be written
                                        in the project
 *      Version                 :       0.1
 *      Creation Date           :       25-07-2000
 *      Last Modified Date      :      
			02/12/2003	Arun	Removed unnecessary whitespace in the IP Range textarea
			03/11/2003 //Saravanan -removed  the Automanage yes/no option
			13/11/2002 //sandhya	
			16/10/2002 //sandhya - License check	
			09-06-2001 // kk ip range validation.
			28-05-2001 // kk alert the user to choose at least one server type for discovery process.
			26-05-2001 //Sandhya - Layout	
			23-05-2001 //Sandhya - Layout 
			15-05-2001 //Bala - To add 'None' to Re-Discovery Period
			16-03-2001 // kk - Added Type of Network & ICMP enabled options
			29-01-2001 // Bala - Incorporated select val retention thru script
			16-12-2000 //Bala - Took away the alert
			19-09-2000 //sandhya
 *      Author                  :       Ravi.N
*		Design Changes			:		Jaiwin
*								:	Design Changed by Vijaykumar 04/01/2007
*************************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "javax.servlet.*"%>
<%@ page import = "javax.servlet.http.*"%>
<%@ page import = "java.util.*"%>	
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgAggregateInfo"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.ADDiscoveryHelperServlet"%>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<jsp:useBean id="DiscBean" scope="page" class="egurkha.ServiceBean"/>
<jsp:useBean id="user" scope="page" class="egurkha.UserBean"/>
<%
	String discovery_state ="";
	String s_iprange="";
	String autoIndex;
	String checked = null;
	discovery_state = (String) session.getValue("discovery_state");
	DiscBean.createAdmin();
	String[] ipranges=DiscBean.getIpranges();

	autoIndex = DiscBean.getAutomanage();
	int monTargets = user.getMonitoredTargets();
	int basicAgents = user.getBasicAgents();
	/*-----------This code for single and double byte language support------start-------*/
	String discoveryButtonwidth="";
	
	if(trackerLanguage!=null && (trackerLanguage.equals("en_US") || trackerLanguage.equals("de_DE") || trackerLanguage.equals("ch_CH") || trackerLanguage.equals("ja_JP") || trackerLanguage.equals("ko_KR") || trackerLanguage.equals("th_TH")))
	{
		discoveryButtonwidth="width:140px;";
	}
	else if(trackerLanguage!=null && (trackerLanguage.equals("fr_FR") || trackerLanguage.equals("es_ES") || trackerLanguage.equals("it_IT") || trackerLanguage.equals("pt_BR")))
	{
		discoveryButtonwidth="width:150px;";
	}
	/*-----------This code for single and double byte language support-----End--------*/

	IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_authenticate.ini");
	String[] domains=iniFile.getSubjects();
	String useADDiscovery = "no";
	useADDiscovery = request.getParameter("useADDiscovery");
	String actDomain = request.getParameter("sDomain");
	String actSite = request.getParameter("sSite");
	String actSubnet = request.getParameter("sSubnet");
	if(useADDiscovery == null || useADDiscovery.length() == 0)
	{
		useADDiscovery = "no";
	}
	boolean isDomainConfigured = false;
	if(domains.length == 0)
	{
		isDomainConfigured = false;
	}
	else
	{
		isDomainConfigured = true;
	}
	
	boolean usingADDiscovery = (useADDiscovery.equals("yes"));
%>
<html>
<head>
<title>Discovery Module</title>
<META HTTP-EQUIV="expires" CONTENT="0">
<meta name="created" content="28/6/2k">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui="admin"/>
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css" />  -->
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript1.2">

function discoveryCheck(val)
{
	if(val=="<%=useADDiscovery%>")
	{
		return;
	}
	
	window.location.href = "./EgDiscovery.jsp?useADDiscovery="+val;
}

function populate(selectedItem)
{
	var url;
	var thisForm = document.discovery;
	var isDomainEmpty = false;
	var isSiteEmpty = false;
	var isSubnetEmpty = false;
	selectedDomainName = thisForm.ADdomain.options[thisForm.ADdomain.selectedIndex].value;
	selectedSiteName = thisForm.ADSite.options[thisForm.ADSite.selectedIndex].value;
	selectedSubnets = "";
	if(thisForm.ADSubnet != null)
	{
		for(i=0;i<thisForm.ADSubnet.length;i++)
		{
			if(thisForm.ADSubnet.options[i].selected)
			{
				if(selectedSubnets.length==0)
				{
					selectedSubnets = thisForm.ADSubnet.options[i].value;
				}
				else
				{
					selectedSubnets += ","+ thisForm.ADSubnet.options[i].value;
				}
			}
		}
	}

	if (selectedItem == 'domain')
	{
		if (selectedDomainName == null || selectedDomainName == "none" || selectedDomainName == "undefined")
		{
			isDomainEmpty = true;
		}
		else
		{
			url = '/final/servlet/com.eg.ADDiscoveryHelperServlet?selectedItem=domain&domainName='+selectedDomainName;
		}
	}
	else if (selectedItem == 'site')
	{
		if (selectedSiteName == null || selectedSiteName == "none" || selectedSiteName == "undefined")
		{
			isSiteEmpty = true;
		}
		else
		{
			url = '/final/servlet/com.eg.ADDiscoveryHelperServlet?selectedItem=site&siteName='+selectedSiteName;
			
		}
	}
	else if (selectedItem == 'subnet')
	{
		if (selectedSubnets == null || selectedSubnets == "none" || selectedSubnets == "undefined")
		{
			isSubnetEmpty = true;
		}
		else
		{
			url = '/final/servlet/com.eg.ADDiscoveryHelperServlet?selectedItem=subnet&subnet='+selectedSubnets;
		}
	}
	
	var httpObj = createRequestObject();
	if(httpObj == null)
	{
		alert('error : request object is null');
	}
	else
	{
		httpObj.open("GET", url,true);
		httpObj.onreadystatechange =function()
		{
			if(httpObj.readyState == 4)
			{
				var response = httpObj.responseText;
				if (selectedItem == 'domain')
				{
					if (!isDomainEmpty && response.length>0)
					{
						var arrOptions = response.split(',');
						thisForm.ADSite.options[0] = new Option('<egui:intnl text="admin.discovery.Choose a site"/>','none');
						var i=1;
						for (var k=0;k<arrOptions.length;k++)
						{
							thisForm.ADSite.options[i] = new Option(arrOptions[k],arrOptions[k]);
							i++;
						}
					}
					else
					{
						thisForm.ADSite.options.length=0;
						thisForm.ADSite.options[0] = new Option('<egui:intnl text="admin.discovery.Not Applicable"/>','none');
						isDomainEmpty = true;
						isSiteEmpty = true;
					}
					thisForm.ADSubnet.options.length=0;
					thisForm.ADSubnet.options[0] = new Option('<egui:intnl text="admin.discovery.Not Applicable"/>','none');
					thisForm.ADSubnet.options[0].selected=true;
					document.getElementById("iprange").innerHTML='<egui:intnl text="admin.discovery.Not Applicable"/>';
				}
				else if (selectedItem == 'site')
				{
					if (!isSiteEmpty && response.length>0)
					{
						var arrOptions = response.split(',');
						for (var k=0;k<arrOptions.length;k++)
						{
							thisForm.ADSubnet.options[k] = new Option(arrOptions[k],arrOptions[k]);
						}
					}
					else if(isDomainEmpty || isSiteEmpty)
					{
						thisForm.ADSubnet.options.length=0;
						thisForm.ADSubnet.options[0] = new Option('<egui:intnl text="admin.discovery.Not Applicable"/>','none');
						thisForm.ADSubnet.options[0].selected=true;
					}
					document.getElementById("iprange").innerHTML='<egui:intnl text="admin.discovery.Not Applicable"/>';
				}
				else if (selectedItem == 'subnet')
				{
					if (!isSubnetEmpty && response.length>0)
					{
						document.getElementById("iprange").innerHTML=response;
					}
					else 
					{
						document.getElementById("iprange").innerHTML='<egui:intnl text="admin.discovery.Not Applicable"/>';
					}
				}
			}
		}
		httpObj.send(null);
	}
}

function createRequestObject()
{
	var req = null;
	if(window.XMLHttpRequest)
	{
		req = new XMLHttpRequest();
	}
	else if (window.ActiveXObject)
	{
		try
		{
			req = new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch(e)
		{
			req=null;
		}
	}
	if(req == null)
	{
		var browser = navigator.appName;
		if(browser == "Microsoft Internet Explorer")
		{
			alert('ActiveXObject is not initialized');
		}
		else
		{
			alert('XMLHttpRequest object is not initialized');
		}
	}
	return req;
}

function isNetscape() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for Navigator ver 4+.
	if ((appName == "Netscape") && (appVer >= 4)) return true;
		return false;
}

function isIE() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for IE ver 4+.
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
		return false;
}

function valform()
{
	var thisForm = document.discovery;
	var flag ="<%=discovery_state%>";
	var list = thisForm.ServerTypes;
	var listlen = thisForm.ServerTypes.options.length;
	var selectflag = "false";
	var ipr = thisForm.iprange.value;

	while (ipr.charAt(0) == ' ')
	{
		ipr = ipr.substring(1,ipr.length);
	}

	while (ipr.charAt(ipr.length-1)==' ')
	{
		ipr = ipr.substring(0,ipr.length-1);
	}

	var allowToUpdate = true;
	thisForm.iprange.value = ipr;
	if (ipr == "")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the IP range"/>');
		thisForm.iprange.focus();
		return;
	}
	else if (!checkspecialnomess(thisForm.iprange,"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz~!@#$%^&*()'<>"))
	{
		alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>');
		thisForm.iprange.focus();
		return;
	}
	else if (ipr.indexOf(" ") > -1)
	{
		alert('<egui:intnl text="admin.discovery.Space is not allowed"/>');
		thisForm.iprange.focus();
		return;
	}
	else if (ipr.indexOf("..") > -1 || 
			ipr.indexOf(".,") > -1 || 
			ipr.indexOf(",.") > -1 || 
			ipr.charAt(0) == "," || 
			ipr.charAt(0) == "-" || 
			ipr.charAt(ipr.length - 1) == "-" || 
			ipr.indexOf("--") > -1 || 
			ipr.indexOf('-') < 0)
	{
		alert('<egui:intnl text="admin.discovery.IP range is not valid"/>');
		thisForm.iprange.focus();
		return;
	}
	else if(ipr.charAt(ipr.length - 1) == ",")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the next IP range"/>');
		thisForm.iprange.focus();
		return;
	}
	else if(!validateSingleByte(ipr))
	{
		alert('<egui:intnl text="admin.discovery.IP range not allowed in DBL(Chinese,Korean,Japanese)"/>');
		thisForm.iprange.focus();
		return;
	}
	else
	{
		var singleIp = false;
		if (ipr.indexOf(',') == -1)
		{
			singleIp = true;
		}

		var comma_array = ipr.split(',');
		for(var i =0;i < comma_array.length;i++)
		{
			var hypen_array = comma_array[i].split('-');
			var caughtInvalidData = false;
			if(hypen_array.length != 2)
			{
				if (singleIp)
				{
					alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>');
				}
				else
				{
					alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>'+" "+(i+1));
				}
				thisForm.iprange.focus();
				caughtInvalidData = true;
				break;
			}
			else
			{
				var ipValid = true;
				var checkIpStatus = checkIp(hypen_array[0]);
				if (checkIpStatus != "success")
				{
					if (singleIp)
					{
						alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>');
					}
					else
					{
						alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>'+" "+(i+1));
					}
					thisForm.iprange.focus();
					caughtInvalidData = true;
					ipValid = false;
					break;
				}

				checkIpStatus = checkIp(hypen_array[1]);
				if (checkIpStatus != "success")
				{
					if (singleIp)
					{
						alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>');
					}
					else
					{
						alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>'+" "+(i+1));
					}
					thisForm.iprange.focus();
					caughtInvalidData = true;
					ipValid = false;
					break;
				}

				if (ipValid)
				{
					var colon_array1 = hypen_array[0].split('.');
					var colon_array2 = hypen_array[1].split('.');
					var colonArr1, colonArr2;
					
					for(var m=0;m < colon_array1.length;m++)
					{
						colonArr1 = parseInt(colon_array1[m],10);
						colonArr2 = parseInt(colon_array2[m],10); 
						
						if ( colonArr2 > colonArr1 )
						{
							break;
						}
						else if( colonArr2 < colonArr1 )
						{
							if (singleIp)
							{
								alert('<egui:intnl text="admin.discovery.Second IP should be greater than the first IP"/>');
							}
							else
							{
								alert('<egui:intnl text="admin.discovery.Second IP should be greater than the first IP in IP range "/> '+ (i + 1));
							}
							thisForm.iprange.focus();
							caughtInvalidData = true;
							break;
						}
					}
					if (caughtInvalidData)
					{
						break;
					}
				}
			}
		}

		if (caughtInvalidData)
		{
			allowToUpdate = false;
		}
	}

	for(var k=0;k < listlen;k++)
	{
		if(list.options[k].selected == true)
		{
			selectflag = "true";
			break;
		}
	}

	if(!flag)
	{
		return true;
	}
	else if(selectflag == "false")
	{
		alert('<egui:intnl text="admin.discovery.Please choose a component type for discovery"/>.');
		return;
	}
	else
	{
		if (allowToUpdate)
		{
			if (isNetscape()) targetObj = document.discovery.startdisc.disabled=true;
			if (isIE()) targetObj = document.discovery.startdisc.disabled=true;
			thisForm.startdisc.value='<egui:intnl text="admin.discovery.In Progress"/>'+"...";
			document.discovery.submit();
		}
	}
}

function setVals()
{

	var treeIframe=window.parent.document.getElementById("DiscoveryTree");
	if(treeIframe!=null)
	{
		treeIframe.src="/final/admin/EgDiscoveryTreeUI.jsp?linkFrom=start";
	}
	/*
	var auto = "";
	var monTargets = thisForm.monTargets.value;
	var basicAgents = thisForm.basicAgents.value;
	if(monTargets == "-1")
	{
		if(basicAgents == "-1")
		{
			auto = thisForm.automanage;
			for(var j=0;j<auto.options.length;j++)
			{
				if(auto.options[j].value == '<%=autoIndex%>')
				{
					auto.selectedIndex = j;
				}
			}
		}
	}
	*/
}

</script>
</head>
<!-- <body leftmargin="0" topmargin="20" marginwidth="0" marginheight="20" bgcolor="#FFFFFF" > -->
<body style="overflow:auto" id="space6" onLoad="setVals()">
<form name="discovery" method=post action="Egdiscoveryp.jsp" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
	<jsp:include page="listSearch.jsp?title=START DISCOVERY&leftString=Add User&subtitle=false"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
<%
	//out.println((!isDomainConfigured && usingADDiscovery));
	if(!isDomainConfigured && usingADDiscovery)
	{
%>
			<table border="0" width="90%" align="center" height="100%" cellpadding="0" cellspacing="0">
				<tr>
					<td width="100%" align="center" valign="middle" height="100%">
						<img src="/final/admin/eg_images/exclamation-icon.gif"></br>
						<egui:intnl text="No domains are configured currently"/>.&nbsp;&nbsp;
						<a href="EgAuthenticationTree.jsp?showBackButton=true" class="eg_monlink" target="_parent">
						<b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img 	src="/final/admin/eg_images/icon_click.gif" border="0"></a>
						<egui:intnl text="admin.test.to configure Windows Domains"/>
					</td>
				</tr>
			</table>
<%
	}
	else
	{
%>
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<th id="eg_subcontentbg" class="form_border" width="300" nowrap valign="top">
						<egui:intnl text="admin.discovery.Discover infrastructure components using"/><br/><egui:intnl text="admin.discovery.Active Directory"/>
					</th>
					<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
					<td id="eg_subcontentbg" class="form_border" width="100%" valign="top">
						<table cellspacing="0" cellpadding="0" border="0" width="30%">
							<tr>
								<td id="eg_subcontentbg"  nowrap width="10"><input class="eg_input" type="radio" value="Domain" name="ADDiscovery" class="eg_input" onClick="javascript:discoveryCheck('yes');" <%=useADDiscovery.equals("yes")?"checked":""%>></td>
								<td id="eg_subcontentbg"  nowrap width="80" >&nbsp;<egui:intnl text="admin.common.Yes" /></td>
								<td id="eg_subcontentbg" width="10"><input class="eg_input" type="radio" value="Eg" name="ADDiscovery" onClick="javascript:discoveryCheck('no');" <%=useADDiscovery.equals("no")?"checked":""%>></td></td>
								<td id="eg_subcontentbg" >&nbsp;<egui:intnl text="admin.common.No"/></td>
							</tr>
						</table>
					</td>
					<td id="eg_subcontentbg" class="form_border">&nbsp;</td>
				<tr>
<%
	if(usingADDiscovery)
	{
%>
				</tr>
					<th id="eg_subcontentbg" class="form_border" width="300" nowrap valign="top">
						<egui:intnl text="admin.discovery.Active Directory Domain"/>
					</th>
					<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
					<td id="eg_subcontentbg" class="form_border" width="100%">
						<select name="ADdomain" onChange="javascript:populate('domain')" width=250 style="width:260px">
<%
		
		ArrayList allDomains=new ArrayList();
		if(domains!=null)
		{
%>
							<option value="none" selected><egui:intnl text="admin.user.Choose a domain"/></option>
<%	
			for(int i=0;i<domains.length;i++)
			{
				String domain = domains[i];
				allDomains.add(domain);
				
			}
		}
		Collections.sort(allDomains,String.CASE_INSENSITIVE_ORDER);
		if(allDomains!=null && allDomains.size() > 0)
		{
			for(int i=0;i<allDomains.size();i++)
			{
				//String strSelect = "";
				String domain = (String) allDomains.get(i);
				
%>
							<option value="<%=domain%>" ><%=domain%></option>
<%
			}
%>
						</select>
					</td>
					<td id="eg_subcontentbg" class="form_border">&nbsp;</td>
				</tr>
<%
		}
%>
				</tr>
					<th id="eg_subcontentbg" class="form_border" width="300" nowrap valign="top">
						<egui:intnl text="admin.discovery.Select an Active Directory Site"/>
					</th>
					<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
					<td id="eg_subcontentbg" class="form_border" width="100%">
						<select name='ADSite' onChange="javascript:populate('site')" width=250 style="width:260px">
							<option value="none" ><egui:intnl text="admin.user.Not Applicable"/></option>
						</select>
					</td>
					<td id="eg_subcontentbg" class="form_border">&nbsp;</td>
				</tr>
				</tr>
					<th id="eg_subcontentbg" class="form_border" width="300" nowrap valign="top">
						<egui:intnl text="admin.discovery.Select Subnets(s) From Site"/>
					</th>
					<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
					<td id="eg_subcontentbg" class="form_border" width="100%">
						<select name="ADSubnet" onChange="javascript:populate('subnet')" size="5" multiple width=250 style="width:260px">
							<!-- <option value="subnet" ><egui:intnl text="admin.user.Choose a subnet(s)"/></option> -->
							<option value="none" selected><egui:intnl text="admin.user.Not Applicable"/></option>
						</select>
					</td>
					<td id="eg_subcontentbg" class="form_border">&nbsp;</td>
				</tr>
<%
	}
%>
				<tr>
					<th id="eg_subcontentbg" class="form_border" width="300" nowrap valign="top">
						<egui:intnl text="admin.discovery.IP range"/><br><span id="eg_7"><i>&nbsp; eg&nbsp;:&nbsp;(172.15.16.1-172.15.16.30,<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;192.68.10.1-192.68.10.30)</i></span>
					</th>
					<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
					<td id="eg_subcontentbg" class="form_border" width="100%">
<%
	StringBuffer ipRange = new StringBuffer(ipranges.length*30);
	String range = null;
	String readOnly = "";
	if (!usingADDiscovery)
	{
		if(ipranges.length > 2)
		{
			//String s_tmp = "";
			for(int x=1;x<ipranges.length;x++)
			{
				//s_tmp = s_tmp + ipranges[x].trim() + ",";
				ipRange.append(ipranges[x].trim());
				ipRange.append(",");
			}

			//s_tmp = s_tmp.substring(0, s_tmp.length() -1);
			//out.println(s_tmp.trim());
		}
		else if(ipranges.length > 1)
		{
			ipRange.append(ipranges[1].trim());
			//out.println(ipranges[1].trim());
		}

		range = ipRange.toString();

		if (range.endsWith(","))
		{
			range = range.substring(0, range.length()-1);
		}
	}
	else
	{
		range = "Not Applicable";
		readOnly = "readonly";
	}
%>
					<textarea name="iprange" id="iprange" rows="6" style="width:260px;" <%=readOnly%>><%=range%></textarea> <!-- <br><br> -->
					</td>
					<td id="eg_subcontentbg" class="form_border">&nbsp;</td>
				</tr>
				<tr>
					<td class="eg_subcontentbg" colspan="4">&nbsp;</td>
				</tr>
				<tr>
					<th id="eg_subcontentbg" width="300" nowrap valign="top"><egui:intnl text="admin.discovery.Components"/></th>
					<td id="eg_subcontentbg" width="20" align="center" nowrap valign="top">:</td>
					<td id="eg_subcontentbg" width="100%">
<%
	String[] servertypes=DiscBean.getValidServerTypesForDiscovery();
	ArrayList tmpList =  new ArrayList();
	ArrayList serverList = new ArrayList();

	for(int j=1;j<servertypes.length;j++)
	{
		if(servertypes[j].startsWith("#"))
		{
			tmpList.add(servertypes[j].substring(1));
			serverList.add(servertypes[j].substring(1));
		}
		else
		{
			serverList.add(servertypes[j]);
		}
	}
	String userLanguage = _user.getLanguage();
	IniUI  iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();

	// To remove the aggregate comp types from the servers List
	EgAggregateInfo aggInfo = new EgAggregateInfo("manager");
	Vector aggTypes = aggInfo.getAggregateTypes();
	if(aggTypes != null && serverList != null)
	{
		serverList.removeAll(aggTypes);
	}
	aggInfo = null;

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	serverList = sorter.getSortedCompTypeList(serverList);
%>
						<select name="ServerTypes" size="10" multiple style="width:260px">
<%
	for(int k=0;k<serverList.size();k++)
	{
		EgName nameObj = (EgName)serverList.get(k);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		if(tmpList.contains(tmpVal))
		{
%>
							<OPTION VALUE='<%=tmpVal%>'><%=tmpDis%></OPTION>
<%
		}
		else
		{
%>
							<OPTION VALUE='<%=tmpVal%>' SELECTED ><%=tmpDis%></OPTION>
<%
		}
	}
%>
						</select><!-- <br><br> -->
					</td>
					<td id="eg_subcontentbg" >&nbsp;</td>
				</tr>
				<tr>
					<td width="5" class="eg_subcontentbg" colspan="4">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td colspan="4" id="eg_blankspace" height="10" nowrap>&nbsp;<input type="hidden" name="automanage" value= "No"></td>
				</tr>

		<!-- Automanage option can be only "No". User cannot change this parameter-->
				<tr>
					<td height="30" valign="bottom" colspan="4" align="center">&nbsp;
				<!--
						<SPAN ID="updateImg" STYLE="position:relative; visibility:visible;">
				-->
					<input type="button" name="startdisc" value='<egui:intnl text="admin.discovery.Start Discovery"/>' style="<%=discoveryButtonwidth%>" class="eg_back" onClick="javascript:valform()" >&nbsp; &nbsp;
					<!-- <input type="button" name="changepref" value='<egui:intnl text="admin.discovery.Change Preferences"/>' style="width: 150px;" class="eg_back" onClick="javascript:window.location.href='EgDiscoveryTree.jsp'"> -->
				<!--
						</SPAN>
				-->
					</td>
				</tr>
			</table>
<%
	}
%>
		</td>
	</tr>
</table>

<input type = "hidden" name="monTargets" value="<%=monTargets%>">
<input type = "hidden" name="basicAgents" value="<%=basicAgents%>">

</form>
</body>
<%
/*
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDiscovery.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDiscovery.jsp");
	}
	*/
%>
</html>
<%
session.setAttribute("adminLastAccessedURL","/final/admin/EgDiscoveryTree.jsp?treeViewSrc=start&showtree=discoverytree");
%>





