<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgName" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "egurkha.TransactionBean" %>
<%@ page import = "egurkha.EgUIUtils" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setContentType("application/json");
	JSONObject rootJson = new JSONObject();
	JSONObject compTypesJson = new JSONObject();
	JSONObject searchJson = new JSONObject();
	JSONArray measuresJson = new JSONArray();
	JSONArray componentList = new JSONArray();
	JSONArray testsJson = new JSONArray();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	egTitleSearchStr = EgUIUtils.decodeSecurityChar(egTitleSearchStr);
	boolean isSearchResult = (egTitleSearchStr != null);
	ArrayList searchList = new ArrayList();
	boolean searchItemFound = false;

	TransactionBean dbcleanup = new TransactionBean();

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}

	String componentType = request.getParameter("componentType");
	componentType = (componentType != null)?componentType:"allTests";

	String testType = request.getParameter("testType");

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	dbcleanup.createFile("eg_db.ini");

	String dbTests[] = dbcleanup.getVariables("TABLE_DELETE_PERIODS");
	ArrayList aListDbTest = new ArrayList(Arrays.asList(dbTests));
	ArrayList aListResultantCtype = new ArrayList();
	ArrayList aListTests = new ArrayList();
	ArrayList aListTempDbTest = new ArrayList();

	IniFile egSpecsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
	
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());

	// To list those component types only which has associated tests with it in eg_db.ini
	for(int i=0;i<listComponentTypes.size();i++)
	{
		String strComponentType = (String)listComponentTypes.get(i);
		String strTests = egSpecsIni.getValue("DEFAULT_TEST_MAPPING",strComponentType);

		if (strTests != null)
		{
			ArrayList aListTempTests = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer(strTests,",");
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				aListTempTests.add(strToken);
			}
			for (int j=0;j<aListTempTests.size();j++)
			{
				String strTest = (String)aListTempTests.get(j);
				if (aListDbTest.contains(strTest)) 
				{
					if(!aListResultantCtype.contains(strComponentType))
					{
						aListResultantCtype.add(strComponentType);
					}
					if(!aListTempDbTest.contains(strTest))
					{
						aListTempDbTest.add(strTest);
					}
				}
			}
		}
	}
	
	aListDbTest = aListTempDbTest; // Assigns Clubbed Tests of Managed Comp Types
	listComponentTypes = sorter.getSortedCompTypeList(aListResultantCtype);

	// To list the tests for the selected component type 
	ArrayList aListShowTests = new ArrayList();
	if (!componentType.equals("") && !componentType.equalsIgnoreCase("All"))
	{
		String strTests = egSpecsIni.getValue("DEFAULT_TEST_MAPPING",componentType);
		StringTokenizer strTokens = new StringTokenizer(strTests,",");
		while (strTokens.hasMoreTokens())
		{
			String strToken = strTokens.nextToken().trim();
			aListTests.add(strToken);
		}
		for (int i=0;i<aListDbTest.size();i++)
		{
			String strTest = (String)aListDbTest.get(i);
			if (aListTests.contains(strTest)) 
			{
				aListShowTests.add(strTest);
			}
		}
		aListDbTest = aListShowTests;
	}
	// Ends

	//Added For Search Button
	ArrayList searchList_final=new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals("")) continue;
			searchList.add(thisToken);
		}
		for(int i=0;i<aListDbTest.size();i++)
		{
			String dbDisplay_test = (String)aListDbTest.get(i);
			String label = _mapping.getTestDescription(dbDisplay_test);
			for (int j=0;j<searchList.size();j++)
			{
				String search_String=(String)searchList.get(j);
				if (label != null && label.toLowerCase().indexOf(search_String.toLowerCase()) != -1)
				{
					if (!searchList_final.contains(dbDisplay_test))
					{
						searchList_final.add(dbDisplay_test);
					}
				}
			}
		}
		if (searchList_final != null && searchList_final.size() >0)
		{
			aListDbTest=searchList_final;
			searchItemFound = true;
		}
		else
		{
			searchItemFound = false;
		}
	}
	// Ends
	String temp_Testname = request.getParameter("testName");
	if (aListDbTest.contains(temp_Testname)) 
	{
		aListDbTest.remove(temp_Testname);
	}

	aListDbTest = sorter.getSortedTestList(aListDbTest);
	
	String strFromPage = request.getParameter("strFromPage");
	if (strFromPage == null)
	{
		strFromPage = "";
	}
	
	// Getting the testname and testvalue which is chosen in EgDBPurge.jsp page
	temp_Testname = (temp_Testname != null)?temp_Testname:"";
	String temp_Testvalue = request.getParameter("testValue");
	temp_Testvalue = (temp_Testvalue != null)?temp_Testvalue:"";
	// Ends

	String label = _mapping.getTestDescription(temp_Testname);
	String db_Test = label;
	String db_Value = temp_Testvalue;

	rootJson.put("aListDbTest",aListDbTest);
	rootJson.put("temp_Testname",temp_Testname);
	rootJson.put("temp_TestnameLabel",label);
	rootJson.put("temp_Testvalue",temp_Testvalue);
	rootJson.put("componentType",componentType);
	rootJson.put("testType",testType);

	rootJson.put("db_Test",db_Test);
	rootJson.put("db_Value",db_Value);

	if (listComponentTypes != null && listComponentTypes.size() > 0)
	{
		JSONObject jObj = new JSONObject();
		jObj.put("displayField","All");
		jObj.put("valueField","All");
		componentList.add(jObj);
		for (int j=0; j<listComponentTypes.size(); j++)
		{
			JSONObject jObjOne = new JSONObject();
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			jObjOne.put("displayField",localname);
			jObjOne.put("valueField",actualname);
			componentList.add(jObjOne);
		}
	}

	//Added to display message when component type has only one test
	int aListDDDTestSize = aListDbTest.size();
	for (int j=0;j<aListDDDTestSize;j++)
	{
		JSONObject jObjMeasure = new JSONObject();
		JSONObject jObjTests = new JSONObject();
		EgName name = (EgName)aListDbTest.get(j);
		String dbValue = name.getActualName();
		String dbDisplay = name.getLocalName();
		String strVal = dbcleanup.getStrValue("TABLE_DELETE_PERIODS",dbValue);
		jObjMeasure.put("dddCleanupValue",strVal);
		jObjTests.put("displayField",dbDisplay);
		jObjTests.put("valueField",dbValue);
		measuresJson.add(jObjMeasure);
		testsJson.add(jObjTests);
		if(dbValue != null && dbValue.equals(temp_Testname))
		{
			continue;
		}
	}

	if (!searchItemFound && egTitleSearchStr != null && !egTitleSearchStr.equals(""))
	{
		searchJson.put("Test","No Search Data Found");
	}
	else
	{
		searchJson.put("Test","Search Data Found");
	}

	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbSettings.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbSettings.jsp");
	}

	rootJson.put("searchJson",searchJson);
	rootJson.put("measuresJson",measuresJson);
	rootJson.put("componentList",componentList);
	rootJson.put("testsJson",testsJson);
	out.println(rootJson);
%>



