<%
/*************************************************************************************************
*	Name			:	EgApplyToOtherTestsJSON.jsp
*	Purpose			:	To Change Detailed Diagnosis data purge periods to selected Tests.
*	Version			:	6.0
*	CreationDate	:	04/07/2013
*	Author			:	Abdul Khader
**************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgName" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.eg.EgMemInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "egurkha.TransactionBean" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setContentType("application/json");
	JSONObject rootJson = new JSONObject();
	JSONObject compTypesJson = new JSONObject();
	JSONObject searchJson = new JSONObject();
	JSONArray measuresJson = new JSONArray();
	JSONArray componentList = new JSONArray();
	JSONArray testsJson = new JSONArray();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult = (egTitleSearchStr != null);
	ArrayList searchList = new ArrayList();
	boolean searchItemFound = false;

	TransactionBean dddcleanup = new TransactionBean();
	TransactionBean disabledd = new TransactionBean();
%>

<%
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}

	String componentType = request.getParameter("componentType");
	componentType = (componentType != null)?componentType:"allTests";

	String testType = request.getParameter("testType");

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	dddcleanup.createFile("eg_format.ini");
	disabledd.createFile("eg_testinfo.ini");

	String dddTests[] = dddcleanup.getVariables("DDD_CLEANUP");
	String disableDDTests[] = disabledd.getVariables("Disable_DD");
	ArrayList aListDDDisabledTests = new ArrayList(Arrays.asList(disableDDTests));
	ArrayList aListDDDTest = new ArrayList(Arrays.asList(dddTests));
	ArrayList aListResultantCtype = new ArrayList();
	ArrayList aListTests = new ArrayList();
	ArrayList aListTempDDDTest = new ArrayList();

	IniFile egSpecsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
	//EgDiscInfo egDisc = new EgDiscInfo("manager");	
	//List listComponentTypes = Arrays.asList(egDisc.getComponentTypes());
	
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());

	// To list those component types only which has associated tests with it in eg_format.ini
	for(int i=0;i<listComponentTypes.size();i++)
	{
		String strComponentType = (String)listComponentTypes.get(i);
		//EgSpecsInfo egspecsInfo = new EgSpecsInfo("manager");
		//String strTests []= egspecsInfo.getDefaultTestsForServer(strComponentType);
		String strTests = egSpecsIni.getValue("DEFAULT_TEST_MAPPING",strComponentType);
		
		if (strTests != null)
		{
			//ArrayList aListTempTests = new ArrayList(Arrays.asList(strTests));
			ArrayList aListTempTests = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer(strTests,",");
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				aListTempTests.add(strToken);
			}

			for (int j=0;j<aListTempTests.size();j++)
			{
				String strTest = (String)aListTempTests.get(j);
				if (aListDDDTest.contains(strTest)) 
				{
					if(!aListResultantCtype.contains(strComponentType))
					{
						aListResultantCtype.add(strComponentType);
					}
					if(!aListTempDDDTest.contains(strTest))
					{
						aListTempDDDTest.add(strTest);
					}
				}
			}
		}
	}
	
	aListDDDTest = aListTempDDDTest; // Assigns Clubbed Tests of Managed Comp Types
	listComponentTypes = sorter.getSortedCompTypeList(aListResultantCtype);
	// Ends

	// To list the tests for the selected component type 
	ArrayList aListShowTests = new ArrayList();
	if (!componentType.equals("") && !componentType.equalsIgnoreCase("All"))
	{
		String strTests = egSpecsIni.getValue("DEFAULT_TEST_MAPPING",componentType);
		StringTokenizer strTokens = new StringTokenizer(strTests,",");
		while (strTokens.hasMoreTokens())
		{
			String strToken = strTokens.nextToken().trim();
			aListTests.add(strToken);
		}

		for (int i=0;i<aListDDDTest.size();i++)
		{
			String strTest = (String)aListDDDTest.get(i);
			if (aListTests.contains(strTest)) 
			{
				aListShowTests.add(strTest);
			}
		}

		aListDDDTest = aListShowTests;
	}
	// Ends

	//Added For Search Button
	ArrayList searchList_final=new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals("")) continue;
			searchList.add(thisToken);
		}
		for(int i=0;i<aListDDDTest.size();i++)
		{
			String dddDisplay_test = (String)aListDDDTest.get(i);
			String label = _mapping.getTestDescription(dddDisplay_test);
			for (int j=0;j<searchList.size();j++)
			{
				String search_String=(String)searchList.get(j);
				if (label != null && label.toLowerCase().indexOf(search_String.toLowerCase()) != -1)
				{
					if (!searchList_final.contains(dddDisplay_test))
					{
						searchList_final.add(dddDisplay_test);
					}
				}
			}
		}
		if (searchList_final != null && searchList_final.size() >0)
		{
			aListDDDTest=searchList_final;
			searchItemFound = true;
		}
		else
		{
			searchItemFound = false;
		}
	}
	// Ends

	aListDDDTest.removeAll(aListDDDisabledTests);
	String temp_Testname = request.getParameter("testName");
	if (aListDDDTest.contains(temp_Testname)) 
	{
		aListDDDTest.remove(temp_Testname);
	}

	aListDDDTest = sorter.getSortedTestList(aListDDDTest);
	
	String strFromPage = request.getParameter("strFromPage");
	if (strFromPage == null)
	{
		strFromPage = "";
	}
	
	// Getting the testname and testvalue which is chosen in EgDDDPurge.jsp page
	temp_Testname = (temp_Testname != null)?temp_Testname:"";
	String temp_Testvalue = request.getParameter("testValue");
	temp_Testvalue = (temp_Testvalue != null)?temp_Testvalue:"";
	// Ends

	String label = _mapping.getTestDescription(temp_Testname);
	String ddd_Test = label;
	String ddd_Value = temp_Testvalue;

	rootJson.put("aListDDDTest",aListDDDTest);
	rootJson.put("temp_Testname",temp_Testname);
	rootJson.put("temp_TestnameLabel",label);
	rootJson.put("temp_Testvalue",temp_Testvalue);
	rootJson.put("componentType",componentType);
	rootJson.put("testType",testType);

	rootJson.put("ddd_Test",ddd_Test);
	rootJson.put("ddd_Value",ddd_Value);

	if (listComponentTypes != null && listComponentTypes.size() > 0)
	{
		JSONObject jObj = new JSONObject();
		jObj.put("displayField","All");
		jObj.put("valueField","All");
		componentList.add(jObj);
		for (int j=0; j<listComponentTypes.size(); j++)
		{
			JSONObject jObjOne = new JSONObject();
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			jObjOne.put("displayField",localname);
			jObjOne.put("valueField",actualname);
			componentList.add(jObjOne);
		}
	}
	//Added to display message when component type has only one test
	int aListDDDTestSize = aListDDDTest.size();
	for (int j=0;j<aListDDDTestSize;j++)
	{
		JSONObject jObjMeasure = new JSONObject();
		JSONObject jObjTests = new JSONObject();
		EgName name = (EgName)aListDDDTest.get(j);
		String dddValue = name.getActualName();
		String dddDisplay = name.getLocalName();
		String strVal = dddcleanup.getStrValue("DDD_CLEANUP",dddValue);
		jObjMeasure.put("dddCleanupValue",strVal);
		jObjTests.put("displayField",dddDisplay);
		jObjTests.put("valueField",dddValue);
		measuresJson.add(jObjMeasure);
		testsJson.add(jObjTests);
		if(dddValue != null && dddValue.equals(temp_Testname))
		{
			continue;
		}
	}
	if (!searchItemFound && egTitleSearchStr != null && !egTitleSearchStr.equals(""))
	{
		searchJson.put("Test","No Search Data Found");
	}
	else
	{
		searchJson.put("Test","Search Data Found");
	}
	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbSettings.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbSettings.jsp");
	}
	rootJson.put("searchJson",searchJson);
	rootJson.put("measuresJson",measuresJson);
	rootJson.put("componentList",componentList);
	rootJson.put("testsJson",testsJson);
	//System.out.println("rootJson__________" + " " + rootJson);
	out.println(rootJson);
%>


