<%
/**
 *	Name        :	EgConfigExclude.jsp
 *	Purpose     :   Configure Test Topology
 *	Version     :   0.1
 *	Created		:   28/09/2000
 *	Modified	:   
 *			22/06/2004	Arun		Weblogic tests have use a "server" parameter which is also used by 
 *									the JSP to send the server type. Change the query parameter to 
 *									typeOfServer to remove ambiguity.
 *			20/08/2002 //sandhya	bug in disabling multiple tests for a server. Only one test gets 
 *									written. Especially if those servers are created using IC.
 *			30/08/2001 //sandhya	to stop discovery before deleting from eg_agents.ini and to start 
 *									discovery after deleting from eg_agents.ini.	
 *			04/08/2001 //sandhya	To include 'break' in if(serverFlag == 1) 
 *			06:06:2001 // Bala		IniFile save	
 *			21/03/2001 //Sandhya	
 *			24/01/2001 // Sandhya	To delete test from eg_egents.ini 
 *	Author		:	Sridevi.T
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page buffer ="16kb" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>
<jsp:useBean id="sBean" scope="page" class="egurkha.ServiceBean"/>

<%
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	String arrSubject[];
	int serverFlag = 0;
	String strVar[];
	String strVal = "";
	String testName = request.getParameter("t_name");
	String strTok = "";
	String str_comp_type = request.getParameter("comptype");
	String serverName = request.getParameter("comptype");
	String componentsForExclusion = request.getParameter("ComponentsForExclusion");
	boolean isExternalTest = egSpecs.isExternalTest(testName,serverName);

	//to add a test whose server+hostname is excluded in eg_disable.ini
	//prgBean.createFile("eg_disable.ini","save");//-- open the file onlyonce in RW mode - pandian
	prgBean.createSyncFile("eg_disable.ini","save");
	String subTestParam = str_comp_type;

	//get a list of all subjects and check whether that subject exists
	arrSubject = prgBean.getSubject();
	for(int i=0; i<arrSubject.length; i++)
	{
		if(arrSubject[i].equals(subTestParam))
			serverFlag = 1;
	}
	StringTokenizer st = new StringTokenizer(componentsForExclusion,",");
	while (st.hasMoreTokens())
	{
		String str_host_name = st.nextToken();
		if ((str_host_name.equals("")) || (str_host_name.equals(" ")))
			continue;

		String stringTemp = subTestParam + ":" + str_host_name;

		/* to write into eg_disable.ini */ 
		//if server exist then append testname to the existing server
		if(serverFlag == 1)
		{
			strVar = prgBean.getVariables(subTestParam);
			List serverList = Arrays.asList(strVar);
			boolean serverFound = false;
			for(int j=0; j<strVar.length; j++)
			{
				strVal = prgBean.getStrValue(subTestParam, strVar[j]);
				if((strVar[j].equals(stringTemp)) & strVal != null)
				{
					serverFound=true;
					if (strVal.equals(testName) 
						|| (strVal.startsWith(testName+",")) 
						|| (strVal.endsWith(","+testName)) 
						|| (strVal.indexOf(","+testName+",")>0))
						continue;

					prgBean.setValues(subTestParam,stringTemp,strVal+","+testName);
					break;
				}
			}

			if (!serverFound)
			{
				prgBean.setValues(subTestParam,stringTemp, testName);
			}
		}
		else
		{
			prgBean.setValues(subTestParam, stringTemp, testName);
		}
	}
	prgBean.saveFile();
	prgBean.releaseInstance();
	serverFlag = 0;

	/* to remove tests from eg_agents.ini */
	//prgBean.createFile("eg_agents.ini","save");
	prgBean.createSyncFile("eg_agents.ini","save");
	
	/* before deleting entries from eg_agents.ini, stop discovery */
	sBean.stopDiscovery();

	st = new StringTokenizer(componentsForExclusion,",");
	while (st.hasMoreTokens())
	{
		String str_host_name = st.nextToken();
		if ((str_host_name.equals("")) || (str_host_name.equals(" "))) continue;

		String testName1 = testName.trim() + ":" + serverName + ":" + str_host_name;
		testName1 = testName1.trim();
		String testName2 = testName.trim() + "::" + str_host_name;
		testName2 = testName2.trim();

		List aListAgents = getAgents(str_host_name);
		List aListTempAgents = null;
		if (isExternalTest)
		{
			aListTempAgents = aListAgents.subList(1,aListAgents.size());
		}
		else
		{
			aListTempAgents = aListAgents.subList(0,1);
		}

		for(int i=0; i<aListTempAgents.size(); i++)
		{
			String tempAgentName = (String)aListTempAgents.get(i);
			String iniVars[] = prgBean.getVariables(tempAgentName);
			List listIniVars = Arrays.asList(iniVars);
			String resultantPattern = "";
			if (listIniVars.contains(testName1))
			{
				resultantPattern = testName1;
			}
			else if (listIniVars.contains(testName2))
			{
				resultantPattern = testName2;
			}
			if (resultantPattern.equals("")) continue;
			prgBean.deleteValues(tempAgentName,resultantPattern);
		}
	}
	prgBean.saveFile();
	prgBean.releaseInstance();

	/* after deleting entries from eg_agents.ini, start discovery */
	String step = "1";
	sBean.startDiscovery(step, true);

	testName = request.getParameter("t_name");
	String ur = "EgConfigTest.jsp?t_name="+testName+"&qctr=1&rctr=0&compname=undefined&comptype="+str_comp_type+"&typeOfServer=" + serverName;

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Tests");
	auditLogThread.setValue("Activity","Test Configuration");
	auditLogThread.setCurrentValue("Test Name",request.getParameter("t_name"));
	auditLogThread.setCurrentValue("Component Type",request.getParameter("comptype"));

	String hostNames = request.getParameter("ComponentsForExclusion");
	String hostNamesArray[] = null;
	if(hostNames != null && !hostNames.equals("null"))
	{
		StringTokenizer tokens = new StringTokenizer(hostNames,",");
		while(tokens.hasMoreTokens())
		{
			String token = tokens.nextToken().toString();
			int index = token.indexOf(":");
			if(index != -1)
				auditLogThread.setCurrentValue("Excluded Component(s)",token.substring(0,index));
			else
				auditLogThread.setCurrentValue("Excluded Component(s)",token);
		}
	}
	auditLogThread.setValue("Description","Component(s) have been excluded from test configuration");
	auditLogThread.sendItToDB();
	/* code for auditlog ends */
%>

<jsp:forward page="<%=ur%>" />

<%!
	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String tempCompName = new String(componentName);
		String agentNickName = "";

		boolean isRemote = false;
		if (tempCompName.indexOf(":") > -1)
		{
			tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
		}

		// To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(tempCompName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(tempCompName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(tempCompName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = tempCompName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		// To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(tempCompName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(tempCompName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}
%>



