<%
/***********************************************************************************
*	Name			:EgMonitorTreeUI.jsp
*	Purpose			:This is the part of the Home page to show Monitor Settings
*	Version			:4.3
*	CreationDate	:9/2/2009
*	Author			:Nehru.C
***********************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.egurkha.util.StringUtils" %>

<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String highLightNode=request.getParameter("highLightNode");
	if(StringUtils.isNull(highLightNode))
	{
		highLightNode="Components";
	}
	

	EgGroupInfo groupInfo = new EgGroupInfo();
	EgTopoInfo topoInfo = new EgTopoInfo("manager");

	String[] groups = groupInfo.getGroupNames();
	String[] segments = topoInfo.getSegmentNames();
	String[] services = topoInfo.getVariables("SERVICE");
	String[] zones = groupInfo.getZoneNames();

	if(groups == null) groups = new String[0];
	if(segments == null) segments = new String[0];
	if(services == null) services = new String[0];
	if(zones == null) zones = new String[0];

	ArrayList validGroups = new ArrayList();
	for(int i=0;i<groups.length;i++)
	{
		Vector typeList = groupInfo.getComponentTypes("group",groups[i]);
		for(int k=0;k<typeList.size();k++)
		{
			if(!typeList.get(k).toString().startsWith("Agg_") && !typeList.get(k).toString().endsWith("_ex"))
			{
				validGroups.add(groups[i]);
				break;
			}
		}
		Collections.sort(validGroups,String.CASE_INSENSITIVE_ORDER);
	}

	ArrayList validSegments = new ArrayList();
	for(int i=0;i<segments.length;i++)
	{
		Vector typeList = groupInfo.getComponentTypes("segment",segments[i]);
		for(int k=0;k<typeList.size();k++)
		{
			if(!typeList.get(k).toString().startsWith("Agg_") && !typeList.get(k).toString().endsWith("_ex"))
			{
				validSegments.add(segments[i]);
				break;
			}
		}
		Collections.sort(validSegments,String.CASE_INSENSITIVE_ORDER);
	}

	ArrayList validServices = new ArrayList();
	for(int i=0;i<services.length;i++)
	{
		Vector typeList = groupInfo.getComponentTypes("service",services[i]);
		for(int k=0;k<typeList.size();k++)
		{
			if(!typeList.get(k).toString().startsWith("Agg_") && !typeList.get(k).toString().endsWith("_ex"))
			{
				validServices.add(services[i]);
				break;
			}
		}
		Collections.sort(validServices,String.CASE_INSENSITIVE_ORDER);
	}

	ArrayList validZones = new ArrayList();
	for(int i=0;i<zones.length;i++)
	{
		Vector typeList = groupInfo.getComponentTypes("zone",zones[i]);
		for(int k=0;k<typeList.size();k++)
		{
			if(!typeList.get(k).toString().startsWith("Agg_") && !typeList.get(k).toString().endsWith("_ex"))
			{
				validZones.add(zones[i]);
				break;
			}
		}
		Collections.sort(validZones,String.CASE_INSENSITIVE_ORDER);
	}

	groups = (String[]) validGroups.toArray(new String[validGroups.size()]);
	segments = (String[]) validSegments.toArray(new String[validSegments.size()]);
	services = (String[]) validServices.toArray(new String[validServices.size()]);
	zones = (String[]) validZones.toArray(new String[validZones.size()]);

	int count = 5;

	String pixels = "575px";
	String browser = request.getHeader("User-Agent");
	browser = browser.toLowerCase();
	if(browser.contains("msie"))
	{
		//browser = "IE";
		pixels = "570px";
	}
	else if(browser.contains("chrome"))
	{
		//browser = "Chrome";
		pixels = "573px";
	}
	else if(browser.contains("firefox"))
	{
		//browser = "Firefox";
		pixels = "575px";
	}
	/*else if(browser.contains("opera"))
	{
		//browser = "Opera";
	}
	else if(browser.contains("safari") && browser.contains("version"))
	{
		//browser = "Safari";
	}*/
%>

<html>
<head>
<title>
</title>
<egui:skin ui="admin"/>
<script language="javascript" src="../scripts/<%=script_src%>"></script>
<script language="javascript" src="/final/admin/eg_scripts/AggregateTree.js"></script>
</head>
<body>
	<div id="treeDiv" class="div_scroll"  style="overflow-x: auto; overflow-y:auto; width:200px;height:<%=pixels%>">
		<script type="text/javascript">
		var d = new dTree('d');
		d.add('0','-1',"ADD/MODIFY AGGREGATES",'','ADD/MODIFY AGGREGATES','MonitorView','','',true,-1);
		d.add('1','0','Components','EgDispServer.jsp?qctr=0&reqfrom=navlink&isAggregateLink=true','Components','MonitorView');
<%
	int groupIndex = 2;
	int segmentIndex = 3;
	int serviceIndex = 4;
	int zoneIndex = 5;
	if(groups != null && groups.length>0)
	{
%>
		d.add('<%=groupIndex%>','0','Groups','aggShowDetails.jsp?elementType=group','Groups','MonitorView');
<%
	}
	else
	{
		--segmentIndex;
		--serviceIndex;
		--zoneIndex;
	}
	if(segments != null && segments.length>0)
	{
%>
		
		d.add('<%=segmentIndex%>','0','Segments','aggShowDetails.jsp?elementType=segment','Segments','MonitorView');
<%
	}
	else
	{
		--serviceIndex;
		--zoneIndex;
	}
	if(services != null && services.length>0)
	{
%>
		d.add('<%=serviceIndex%>','0','Services','aggShowDetails.jsp?elementType=service','Services','MonitorView');
<%
	}
	else
	{
		--zoneIndex;
	}
	if(zones != null && zones.length>0)
	{
%>
		d.add('<%=zoneIndex%>','0','Zones','aggShowDetails.jsp?elementType=zone','Zones','MonitorView');
<%
	}
	for(int i=0;i<groups.length;i++)
	{
%>
		d.add('<%=(++count)%>','<%=groupIndex%>','<%=groups[i]%>','aggShowTypes.jsp?operation=add&element=group&name=<%=EgURLEncoder.encode(groups[i],"UTF-8")%>','<%=groups[i]%>','MonitorView');
<%
	}
	for(int i=0;i<segments.length;i++)
	{
%>
		d.add('<%=(++count)%>','<%=segmentIndex%>','<%=segments[i]%>','aggShowTypes.jsp?operation=add&element=segment&name=<%=EgURLEncoder.encode(segments[i],"UTF-8")%>','<%=segments[i]%>','MonitorView');
<%
	}
	for(int i=0;i<services.length;i++)
	{
%>
		d.add('<%=(++count)%>','<%=serviceIndex%>','<%=services[i]%>','aggShowTypes.jsp?operation=add&element=service&name=<%=EgURLEncoder.encode(services[i],"UTF-8")%>','<%=services[i]%>','MonitorView');
<%
	}
	for(int i=0;i<zones.length;i++)
	{
%>
		d.add('<%=(++count)%>','<%=zoneIndex%>','<%=zones[i]%>','aggShowTypes.jsp?operation=add&element=zone&name=<%=EgURLEncoder.encode(zones[i],"UTF-8")%>','<%=zones[i]%>','MonitorView');
<%
	}
%>
		document.write(d);
		d.openAll();
		d.highlightNodeByProcess("<%=highLightNode%>");
		</script>
		<table border="0" cellpadding="2" cellspacing="0">
			<tr>
				<td><a class="eg_adminlink" href="javascript:void(0);" onclick="d.oAll(true);">Expand All</a></td>
				<td>&nbsp;|&nbsp;</td>
				<td><a class="eg_adminlink" href="javascript:void(0);" onclick="d.oAll(false);">Close All</a></td>
			</tr>
		</table>
	</div>
</body>
</html>



