<%
/*************************************************************************************
 *	File name			:	EgAgentDiscoverp.jsp
 *  Purpose				:	Processing page for agent discovery settings
 *	Version				:	4.2.1
 *	Creation Date		:	18-02-2009 
 *  Last Modified		:	26-02-2009 
 *	Author				:	Nehru.C
 **************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<jsp:useBean id="change" scope="page" class="egurkha.ServiceBean"/>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	String uiFile = "eg_tests.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	//IniFile testIniFile = new IniFile(s_iniFile_dir + uiFile,true);
	String tableWidth = request.getParameter("tableWidth");

	/* code for audit log starts */
	boolean auditFlag = false;
	String preAgentDis = request.getParameter("$_AgentDiscover");
	String preStartUpDelay = request.getParameter("$_AgentDiscDelay");
	String preReDisPeriod = request.getParameter("$_AgentReDiscoverPeriod");
	String preDisTimeOut = request.getParameter("$_DiscTimeout");
	String curAgentDis = request.getParameter("AgentDiscover");
	String curStartUpDelay = request.getParameter("AgentDiscDelay");
	String curReDisPeriod = request.getParameter("AgentReDiscoverPeriod");
	String curDisTimeOut = request.getParameter("DiscTimeout");
	String convert = curAgentDis.equalsIgnoreCase("True")?"Yes":"No";

	// Topology settings (Begin) 
	String preTopoDis = request.getParameter("$_TopologyDiscover");
	String preTopoDelay = request.getParameter("$_TopologySleepTime");
	String preTopoReDiscover = request.getParameter("$_TopologyReDiscoverPeriod");
	String preSendBox = request.getParameter("$_SendBox");
	String preTotalBox = request.getParameter("$_TotalBox");
	//String preSendFreq = preSendBox+" out of "+preTotalBox;

	String curTopoDis = request.getParameter("TopologyDiscover");
	String curTopoDelay = request.getParameter("TopologySleepTime");
	String curTopoReDiscover = request.getParameter("TopologyReDiscoverPeriod");
	String curSendBox = request.getParameter("SendBox");
	String curTotalBox = request.getParameter("TotalBox");
	String topoConvert = curTopoDis.equalsIgnoreCase("true")?"Yes":"No";
	String from = request.getParameter("from");

if (from != null && from.equalsIgnoreCase("general"))
{
	// Discovery settings starts
	if (convert != null && convert.equalsIgnoreCase("yes"))
	{
		String currentDiscBase = request.getParameter("discbase");
		String previousDiscBase = request.getParameter("$_discBase");
		String[] c_types = request.getParameterValues("c_types");

		change.createAdmin();
		change.setDiscBase(currentDiscBase);
		change.setServertypes(c_types);
		ArrayList newList = null;
		ArrayList oldList = new ArrayList();

		String newPortValues[] = request.getParameterValues("Ports"); 
		newList = new ArrayList(Arrays.asList(newPortValues));
		String oldPortValues[] = request.getParameterValues("$_Ports");

		if(oldPortValues != null && oldPortValues.length>0 && newPortValues != null && newPortValues.length>0)
		{
			for(int i=0;i<oldPortValues.length;i++)
			{
				String previousValue = oldPortValues[i];
				int $Index = previousValue.indexOf("$");
				String label = previousValue.substring(0,$Index);
				String value = previousValue.substring($Index+1);
				oldList.add(value);
			}
		}
		if(newList.removeAll(oldList))
		{
			if(newList.size()>0)
			{
				auditFlag = true;
			}
		}

		if(newList.size()>0)
		{
			String[] newportvals=request.getParameterValues("Ports"); 
			String[] servers = request.getParameterValues("serverName");

			for(int i=0; i<newportvals.length; i++)
			{
				if(newportvals[i] != null && newportvals[i].indexOf(",")>=0)
				{
					newportvals[i] = newportvals[i].replace(',',':');
				}
			}
			change.setPortvals(servers,newportvals);
		}
		change.commitChanges();
		change.createAdmin();
	}
	// Discovery settings ends

	if (!(preAgentDis.equals(convert) && 
		preStartUpDelay.equals(curStartUpDelay) && 
		preReDisPeriod.equals(curReDisPeriod) && 
		preDisTimeOut.equals(curDisTimeOut) && 
		preTopoDis.equals(topoConvert) && 
		preTopoDelay.equals(curTopoDelay) && 
		preTopoReDiscover.equals(curTopoReDiscover) && 
		preSendBox.equals(curSendBox) &&
		preTotalBox.equals(curTotalBox)))
		auditFlag = true;
	/* code for audit log ends */
	IniFile testIniFile = EgConfigFilesSync.getInstance(s_iniFile_dir + uiFile,true);
	testIniFile.setValue("AGENT_SETTINGS","AgentDiscover",curAgentDis);
	testIniFile.setValue("AGENT_SETTINGS","AgentDiscDelay",curStartUpDelay);
	testIniFile.setValue("AGENT_SETTINGS","AgentReDiscoverPeriod",curReDisPeriod);
	testIniFile.setValue("AGENT_SETTINGS","DiscTimeout",curDisTimeOut);
	testIniFile.setValue("AGENT_SETTINGS","TopoDiscoveryEnabled",curTopoDis);
	testIniFile.setValue("AGENT_SETTINGS","TopoDiscoverySendFreqeuncy",curSendBox+"/"+curTotalBox);
	testIniFile.setValue("AGENT_SETTINGS","TopoDiscoveryFrequency",curTopoDelay);
	testIniFile.setValue("AGENT_SETTINGS","TopoReDiscoverPeriod",curTopoReDiscover);
	testIniFile.saveFile();
	EgConfigFilesSync.releaseInstance(testIniFile);

	long currenttime = System.currentTimeMillis();
	String str = String.valueOf(currenttime);
	String newIni = "eg_DiscoveryHelper.ini";
	IniFile newIniFile = EgConfigFilesSync.getInstance(s_iniFile_dir + newIni,true);
	newIniFile.setValue("DISCOVERY_SETTINGS","AgentDiscoveryEnabled",curAgentDis);
	newIniFile.setValue("DISCOVERY_SETTINGS","TopologyDiscoveryEnabled",curTopoDis);
	newIniFile.setValue("DISCOVERY_SETTINGS","UpdatedTime",str);
	newIniFile.saveFile();
	EgConfigFilesSync.releaseInstance(newIniFile);

	/* code for audit log starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Agents");
	auditLogThread.setValue("Activity","Agent discovery settings");

	auditLogThread.setPreviousValue("00~~Enable agent discovery",preAgentDis);
	auditLogThread.setCurrentValue("00~~Enable agent discovery", curAgentDis.equalsIgnoreCase("True")?"Yes":"No");
	auditLogThread.setPreviousValue("01~~Agent discovery startup delay (Mins) ",preStartUpDelay);
	auditLogThread.setCurrentValue("01~~Agent discovery startup delay (Mins) ",curStartUpDelay);
	auditLogThread.setPreviousValue("02~~Agent rediscovery period (Mins)",preReDisPeriod);
	auditLogThread.setCurrentValue("02~~Agent rediscovery period (Mins)",curReDisPeriod);
	auditLogThread.setPreviousValue("03~~Discovery timeout (Millisecs) ",preDisTimeOut);
	auditLogThread.setCurrentValue("03~~Discovery timeout (Millisecs) ",curDisTimeOut);

	auditLogThread.setPreviousValue("04~~Enable topology discovery?",preTopoDis);
	auditLogThread.setCurrentValue("04~~Enable topology discovery?",curTopoDis.equalsIgnoreCase("True")?"Yes":"No");
	auditLogThread.setPreviousValue("05~~Topology rediscovery period (Mins)",preTopoReDiscover);
	auditLogThread.setCurrentValue("05~~Topology rediscovery period (Mins)",curTopoReDiscover);
	auditLogThread.setPreviousValue("06~~Dependencies must be present",preSendBox);
	auditLogThread.setCurrentValue("06~~Dependencies must be present",curSendBox);
	auditLogThread.setPreviousValue("07~~Number of dependency discovery attempts",preTotalBox);
	auditLogThread.setCurrentValue("07~~Number of dependency discovery attempts",curTotalBox);
	auditLogThread.setPreviousValue("08~~Delay between successive dependency discovery attempts (Mins)",preTopoDelay);
	auditLogThread.setCurrentValue("08~~Delay between successive dependency discovery attempts (Mins)",curTopoDelay);
	
	
	auditLogThread.setValue("Description","Agent discovery settings have been configured successfully");
	if(auditFlag)
		auditLogThread.sendItToDB();
	/* code for audit log ends */

}
else
{
	IniFile testIniFile = EgConfigFilesSync.getInstance(s_iniFile_dir + uiFile,true);
	testIniFile.setValue("AGENT_SETTINGS","AgentDiscover",curAgentDis);
	testIniFile.setValue("AGENT_SETTINGS","TopoDiscoveryEnabled",curTopoDis);
	testIniFile.saveFile();
	EgConfigFilesSync.releaseInstance(testIniFile);

	long currenttime = System.currentTimeMillis();
	String str = String.valueOf(currenttime);
	String newIni = "eg_DiscoveryHelper.ini";
	IniFile newIniFile = EgConfigFilesSync.getInstance(s_iniFile_dir + newIni,true);
	newIniFile.setValue("DISCOVERY_SETTINGS","AgentDiscoveryEnabled",curAgentDis);
	newIniFile.setValue("DISCOVERY_SETTINGS","TopologyDiscoveryEnabled",curTopoDis);
	newIniFile.setValue("DISCOVERY_SETTINGS","UpdatedTime",str);
	newIniFile.saveFile();
	EgConfigFilesSync.releaseInstance(newIniFile);
}

Vector sess_vec = new Vector();
sess_vec.addElement(_mapping.getTextDescription("admin.ui.Agent Discovery settings"));
sess_vec.addElement("EgAgentDiscover.jsp?tableWidth="+tableWidth+"&from="+from);
sess_vec.addElement(_mapping.getTextDescription("admin.ui.Agent Discovery settings")+".");
sess_vec.addElement(_mapping.getTextDescription("admin.ui.Agent Discovery settings have been configured successfully")+"...");
session.setAttribute("vec_Results",sess_vec);
%>
<jsp:forward page="EgResults.jsp?location=EgStopDiscovery"/>