<%
/*
 *   File		:	EgConfigureDefaultTestParams.jsp
 *   Purpose	:	Default page for test configuration
 *   Author		:	S.Anand (2009)
 *   UI Design	:	Jaiwin & Krishnamurthi
*/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgUtils" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgURLDecoder" %>
<%@ page import="java.net.URLDecoder" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgUtils" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgCrypt" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgName" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import="com.eg.EgUsersInfo"%>
<%@ page import= "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String pr_test = null;
	JSONObject prMeasureObject = new JSONObject();
	JSONArray prMeasureArray = new JSONArray();
	JSONArray prMeasureDispnameArray = new JSONArray();
	EgMappingInfo _mappingInfo = null;

	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	//param to continue globally
	String[] paramToContinue = {"host","port","mCount","rptName","agentless","Hyperv","isLdoms","isPassive","serverType"};

	//param to be continued for snmpV1 and snmpV2
	String[] snmpV1V2ParamToContinue = {"username","authpass","authtype","encryptflag","encrypttype","encryptpassword"};

	//param to be continued in snmpV3 when encrypt param is false
	String[] snmpV3ParamToContinue = {"encrypttype","encryptpassword"};

	//param to continue when mode is true.(applicable to java application component type)
	String[] modeTrueToContinue = {"Jmx_Remote_Port","Jndi_Name","Jmx_user","Jmx_password","user","password"};

	//param to continue when mode is false.(applicable to java application component type)
	String[] modeFalseToContinue = {"snmpversion","snmpcommunity","snmpPort","authtype","authpass","username","encryptflag","encryptpassword","encrypttype"};

	String[] targetDiskIORateLabel = {"Equals","Less Than","Less Than or Equal To","Greater Than","Greater Than or Equal To"};

	String[] targetDiskIORateValue = {"EQ","LT","LE","GT","GE"};

	//param to set in read-only mode when the test is set to have muti-user enabled
	String[] multiUserReadOnlyParam = {"user","admin_user","domain","password","admin_password","published_resources","User_name","Password","Domain_name","Connection_server_name"};

	String[] multiNameReadOnlyParam = {"name","pattern","threshold_value"};
	ArrayList aListPages = new ArrayList();

	public boolean isParameter(String encryptParam)
	{
		String decryptParam = EgCrypt.decrypt(encryptParam);
		if (decryptParam.equals(encryptParam)) // not password
		{
			return (true);
		}
		return false;
	}
	private ArrayList getParameterList(String str,boolean needLowerCaseKey)
	{
		String delimiter = " -";
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		str = str.substring(str.indexOf("-"));
		int spaceHyphenIdx = str.indexOf(delimiter);
		while (spaceHyphenIdx != -1)
		{
			String cutString = str.substring(0,spaceHyphenIdx);

			//This check will be carried out when the cutString contains only the key
			//for e.g.:-
			//str : -admin_password -103:98:88:90:79:76:81:-110:52 -ssl false
			//cutString : -admin_password
			if (cutString.trim().indexOf(" ") == -1)
			{
				String strPart1 = str.substring(cutString.length()+1);
				String strPart2 = strPart1.substring(0,strPart1.indexOf(delimiter));
				cutString = cutString+" "+strPart2;
				spaceHyphenIdx = cutString.length();
			}

			if (cutString.indexOf("\"") != -1)
			{
				String strAfterDoubleQuotes = str.substring(spaceHyphenIdx);
				String remainingPiece = strAfterDoubleQuotes.substring(0,strAfterDoubleQuotes.indexOf("\"")+1);
				cutString = cutString + remainingPiece;

				String key = cutString.substring(0,cutString.indexOf(" "));
				String value = cutString.substring(cutString.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(key.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(key.trim());
				}
				aListResultant.add(value.trim());

				String remainingString = strAfterDoubleQuotes.substring(strAfterDoubleQuotes.indexOf("\"")+1);
				str = remainingString.trim();
				if (str.length() == 0)
				{
					spaceHyphenIdx = -1;
				}
				else
				{
					spaceHyphenIdx = str.indexOf(delimiter);
				}
			}
			else
			{
				if (cutString.startsWith("- "))
				{
					int idx = aListResultant.indexOf(prevKey);
					String strValue = (String)aListResultant.get(idx+1);
					strValue = strValue + " " + cutString;
					aListResultant.remove(idx+1);
					aListResultant.add(strValue);

					str = str.substring(cutString.length()+1);
				}
				else
				{
					String key = cutString.substring(0,cutString.indexOf(" "));
					String value = cutString.substring(cutString.indexOf(" ")+1);
					if (needLowerCaseKey)
					{
						aListResultant.add(key.trim().toLowerCase());
						prevKey = key.trim().toLowerCase();
					}
					else
					{
						aListResultant.add(key.trim());
						prevKey = key.trim();
					}
					aListResultant.add(value.trim());

					str = str.substring(spaceHyphenIdx+1);
				}
				spaceHyphenIdx = str.indexOf(delimiter);
			}
		}

		if (str.length() > 0)
		{
			if (str.startsWith("- "))
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + " " + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
			else
			{
				String lastKey = str.substring(0,str.indexOf(" "));
				String lastValue = str.substring(str.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(lastKey.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(lastKey.trim());
				}
				aListResultant.add(lastValue.trim());
			}
		}

		return aListResultant;
	}

	public static String getString(List list)
	{
		StringBuffer buffer = new StringBuffer(32);

		if (list != null && list.size() > 0)
		{
			for (Iterator i=list.iterator(); i.hasNext(); )
			{
				String line = (String)i.next();
				buffer.append(line);
				buffer.append("^&^");
			}
		}

		/*
		 * Take out the last comma and return the string
		 */
		String string = buffer.toString();
		return string.substring(0, string.length()-3);
	}
%>

<%
	JSONObject rootJson = new JSONObject();

	Object encodeParamObj= session.getAttribute("encodeParamJsonList");
	if(encodeParamObj == null)
	{
		JSONArray encodeParamArr = new JSONArray();
		IniFile testParamFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testParam.ini");
		String[] encodeParamList = testParamFile.getVariables("TC_SECURITY_SUSPICIOUS_PARAMS");
		if(encodeParamList != null && encodeParamList.length >0)
		{
			for(int i=0;i<encodeParamList.length;i++)
			{
				String paramName = encodeParamList[i];
				encodeParamArr.add(paramName);
			}
		}
		session.setAttribute("encodeParamJsonList",encodeParamArr);
		rootJson.put("encodeParamList",encodeParamArr);
	}
	else
	{
		rootJson.put("encodeParamList",(JSONArray)encodeParamObj);
	}

	JSONObject hiddenObj = new JSONObject();
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	EgUsersInfo usersInfo = new EgUsersInfo();

	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	listComponentTypes = sorter.getSortedCompTypeList(listComponentTypes);
	com.eg.IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String selectedCompType = "";

	IniFile egTestParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");

	Arrays.sort(paramToContinue, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(snmpV1V2ParamToContinue, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(snmpV3ParamToContinue, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(modeTrueToContinue, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(modeFalseToContinue, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(multiUserReadOnlyParam, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(multiNameReadOnlyParam, String.CASE_INSENSITIVE_ORDER);

	List tmpParamContinue2 = Arrays.asList(snmpV1V2ParamToContinue);
	String snmpV1V2ParamToContinue2 = StringUtils.getString(tmpParamContinue2);
	rootJson.put("snmpV1V2ParamToContinue",snmpV1V2ParamToContinue2);

	List tmpParamContinue3 = Arrays.asList(snmpV3ParamToContinue);
	String snmpV3ParamToContinue3 = StringUtils.getString(tmpParamContinue3);
	rootJson.put("snmpV3ParamToContinue",snmpV3ParamToContinue3);

	List tmpParamContinue4 = Arrays.asList(multiUserReadOnlyParam);
	String multiUserReadOnlyParam4 = StringUtils.getString(tmpParamContinue4);
	rootJson.put("multiUserReadOnlyParam",multiUserReadOnlyParam4);
	
	List tmpParamContinue5 = Arrays.asList(multiNameReadOnlyParam);
	String multiNameReadOnlyParam5 = StringUtils.getString(tmpParamContinue5);
	rootJson.put("multiNameReadOnlyParam",multiNameReadOnlyParam5);

	List tmpParamContinue6 = Arrays.asList(modeTrueToContinue);
	String modeTrueToContinue6 = StringUtils.getString(tmpParamContinue6);
	rootJson.put("modeTrueToContinue",modeTrueToContinue6);
	
	List tmpParamContinue7 = Arrays.asList(modeFalseToContinue);
	String modeFalseToContinue7 = StringUtils.getString(tmpParamContinue7);
	rootJson.put("modeFalseToContinue",modeFalseToContinue7);


	List tmpParamContinue12 = Arrays.asList(targetDiskIORateLabel);
	String targetDiskIORateLabel12 = StringUtils.getString(tmpParamContinue12);
	rootJson.put("targetDiskIORateLabel",targetDiskIORateLabel12);

	List tmpParamContinue14 = Arrays.asList(targetDiskIORateValue);
	String targetDiskIORateValue14 = StringUtils.getString(tmpParamContinue14);
	rootJson.put("targetDiskIORateValue",targetDiskIORateValue14);

	List tmpParamContinue = Arrays.asList(paramToContinue);
	String strParamContinue = StringUtils.getString(tmpParamContinue);
	rootJson.put("paramToContinue",strParamContinue);

	ArrayList aListParamNamesValues = new ArrayList();
	ArrayList aListDisplay = new ArrayList();

	String componentType = request.getParameter("componentType");
	componentType = (componentType != null)?componentType:"";

	String previousComponentType = request.getParameter("previousComponentType");
	previousComponentType = (previousComponentType != null)?previousComponentType:"";

	String testType = testType = request.getParameter("testType");
	testType = (StringUtils.isNull(testType))?"PerformanceTest":testType;

	String perviousTestType = request.getParameter("previousTestType");
	perviousTestType = (StringUtils.isNull(perviousTestType))?"PerformanceTest":perviousTestType;

	//password profile params
	EgPwdProfile pwdProf = new EgPwdProfile();
	boolean isEnablePwdProfile = false;
	ArrayList pwdProfileParamList = new ArrayList();
	TreeMap pwdProfileParamMap = new TreeMap();
	Hashtable selectedParamsSet = new Hashtable();
	JSONObject pwdParamSetList = new JSONObject(); // final selected list json object

	IniFile pwdProfileIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_pwdprofile.ini");
	List testSpecsVarList = Arrays.asList(egSpecs.getTestSpecVar());

	String pfSelected = "";
	String cfSelected = "";
	if (testType.equalsIgnoreCase("PerformanceTest"))
	{
		pfSelected = "selected";
	}
	else
	{
		cfSelected = "selected";
	}

	String testName = "";
	if (previousComponentType.equals(componentType) && testType.equals(perviousTestType))
	{
		testName = request.getParameter("testName");
		testName = (testName != null)?testName:"";
		testName = testName.trim();
	}

	pr_test=(testName.endsWith("_rx"))?testName:"";
	String previousTestName = request.getParameter("previousTestName");
	previousTestName = (previousTestName != null)?previousTestName:"";
	rootJson.put("componentType",componentType);
	rootJson.put("testName",testName);
	rootJson.put("previousTestName",previousTestName);

	String allowedParams = "";
	String strTcKeywords = "";
	String[] tcKeywords = new String[0];
	ArrayList aListTcKeywordsLowerCase = new ArrayList();

	ArrayList aListParamsWithDoubleQuotes = null;
	String strDoubleQuotesParams = "";

	String strDelimiter = "";
	String strDelimiterMask = "";
	String[] arrDelimiterMasks = new String[0];

	ArrayList aResultant = new ArrayList();
	ArrayList aListResultantTempInLowerCase = new ArrayList();
	ArrayList aListResultantInLowerCase = new ArrayList();

	ArrayList aListEnabledTestForCompType = new ArrayList();

	//for testperiod
	TreeMap periodMap = new TreeMap();
	String testPeriod = "";

	boolean isCorrectiveScriptEnabled = false;
	boolean isCorrectParamExist = false;

	//For SNMP - Start
	boolean isSnmp=false;
	boolean isSnmpV1V2 = false;
	String[] versions = {"v1","v2","v3"};
	String[] authTypes = {"MD5","SHA"};
	String[] encryptTypes = {"DES","AES","AES128","AES192","AES256"};
	String snmpVer = "";
	String encryptValue = "";
	String encryptFlag = "";
	boolean isOldSnmp = false;

	boolean isModeParamExist =false;
	boolean isMeasureModeParamExist =false;

	//policy filter start
	boolean isPolicyParamExists = false;
	ArrayList aPolicyFilter = new ArrayList();
	String tPolicyFilter = "";
	//policy filter end

	//show_alias_and_interface_name - starts
	boolean hasShowAliasParam = false;
	String useAliasValue = "";
	//show_alias_and_interface_name - ends

	boolean isWsdlUrlExist=false;
	boolean isUrlParamExist = false;
	ArrayList aUrlCredentialVal = new ArrayList();
	boolean isCredentialParamExist = false;
	boolean isPrivateKeyParamExist = false;
	boolean isSystemPropKeyParamExist = false;

	ArrayList aListContentValues = new ArrayList();
	ArrayList aListEncodingValues = new ArrayList();
	ArrayList aListFilePathValues = new ArrayList();
	ArrayList aListSystemPropKeys = new ArrayList();
	ArrayList aListSystemPropValues = new ArrayList();

	ArrayList aListDynamicSelectOptionNameAndValue = new ArrayList();
	ArrayList aListDynamicRadioOptionNameAndValue = new ArrayList();

	//contains multiple user enabled test - starts
	List listMultipleUserSupportTest = null;
	//for tests which is mutiple user enabled
	boolean multiUserMode = false;
	boolean multiNamePatternMode = false;
	//contains multiple user enabled test - starts

	//EMC_XtremIO_4x
	String[] emcXMSIPs = null;

	//virtual center
	String[] virtualCenters = null;
	//RHEV
	String[] rhevs = null;
	//HMC
	String[] hmcs = null;
	boolean isHMC = false;
	String resIsManagedByValue = "";

	//nutanix server
	String[] nutanixPrisms = null;

	//url parameter(Http or HttpPost Test)
	String previousUrl = null;

	//showAllOnly - starts
	boolean hasShowAllOnlyParam = false;
	String showAllEventsValue = "";
	//showAllOnly - ends

	//Report_only_total - starts
	boolean hasReportOnlyTotalParam = false;
	String reportTotalValue = "";
	//Report_only_total - ends

	boolean isSystemPropertyParamTests = false; // for system property works

	String strSpecificPattern = "false";
	//contains enabled test for a component type
	ArrayList aListTempEnabledTests = null;
	if (!componentType.equals("") && !componentType.equals("-1"))
	{
		if (testType.equals("PerformanceTest"))
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		}
		else
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,true);
		}
		aListTempEnabledTests = new ArrayList(aListEnabledTestForCompType);
		aListEnabledTestForCompType = sorter.getSortedTestList(aListEnabledTestForCompType);
	}

	boolean viewAccessOnly = false;
	boolean userBasedLicense = usersInfo.isUserBasedLicense();

	if (!componentType.equals("") && !componentType.equals("-1") && 
		!testName.equals("") && !testName.equals("-1") && 
		!testType.equals(""))
	{
		ArrayList aListPasswordParameters = null;
		boolean hasPasswordParameters = false;
		String[] passwordTests = egTestParamIni.getVariables("PASSWORD");
		List listPasswordTests = Arrays.asList(passwordTests);
		for (int i=0;i<aListTempEnabledTests.size();i++)
		{
			String strTest = (String)aListTempEnabledTests.get(i);
			if (listPasswordTests.contains(strTest))
			{
				String strPasswordParams = egTestParamIni.getValue("PASSWORD",strTest);
				StringTokenizer stPasswordParams = new StringTokenizer(strPasswordParams,",");
				while (stPasswordParams.hasMoreTokens())
				{
					String tempParam = stPasswordParams.nextToken();
					tempParam = "-" + tempParam;
					if (aListPasswordParameters == null)
					{
						aListPasswordParameters = new ArrayList();
						hasPasswordParameters = true;
					}

					if (aListPasswordParameters.contains(tempParam)) continue;

					aListPasswordParameters.add(tempParam);
				}
			}
		}
		session.setAttribute("aListPasswordParameters",aListPasswordParameters);

		String[] defaultControl = egTestParamIni.getVariables("PARAM-CONTROL");
		ArrayList aListDefaultPasswordParameters = null;
		if (defaultControl != null && defaultControl.length > 0)
		{
			for (int i=0;i<defaultControl.length;i++)
			{
				String tempParamName = defaultControl[i];
				String tempParamValue = egTestParamIni.getValue("PARAM-CONTROL",tempParamName);
				if (tempParamValue.equalsIgnoreCase("password"))
				{
					if (aListDefaultPasswordParameters == null)
					{
						aListDefaultPasswordParameters = new ArrayList();
					}

					aListDefaultPasswordParameters.add("-"+tempParamName.toLowerCase());
				}
			}
		}
		session.setAttribute("aListDefaultPasswordParameters",aListDefaultPasswordParameters);

		//String[] paramsWithDoubleQuotes = egTestParamIni.getVariables("ENCLOSE_WITH_DOUBLEQUOTES");
		String[] paramsWithDoubleQuotes = null;
		if (paramsWithDoubleQuotes != null && paramsWithDoubleQuotes.length > 0)
		{
			for (int i=0;i<paramsWithDoubleQuotes.length;i++)
			{
				String tempParamName = paramsWithDoubleQuotes[i];
				if (aListParamsWithDoubleQuotes == null)
				{
					aListParamsWithDoubleQuotes = new ArrayList();
				}
				aListParamsWithDoubleQuotes.add(tempParamName.toLowerCase());
			}

			strDoubleQuotesParams = aListParamsWithDoubleQuotes.toString();
			strDoubleQuotesParams = strDoubleQuotesParams.substring(1,strDoubleQuotesParams.length()-1);
			strDoubleQuotesParams = StringUtils.replace(strDoubleQuotesParams,", ",",");
		}

		String port = "";
		//rootJson.put("isRemote",isRemote);

		if (componentType.equals("Oracle_server"))
		{
			port = "$portNo:$sid";
		}
		else
		{
			port = "$portNo";
		}

		String patternA = testName + ":" + componentType + ":" + "$hostName" + ":" + port;
		String patternB = testName + ":" + componentType + ":" + "$hostName";
		String patternC = testName + "::" + "$hostName" + ":" + port;
		String patternD = testName + "::" + "$hostName";

		List listSpecficationVariables = Arrays.asList(egSpecs.getTestSpecVar());
		String resultantPattern = "";
		if (listSpecficationVariables.contains(patternA))
		{
			resultantPattern = patternA;
			strSpecificPattern = "true";
		}
		else if (listSpecficationVariables.contains(patternB))
		{
			resultantPattern = patternB;
			strSpecificPattern = "true";
		}
		else if (listSpecficationVariables.contains(patternC))
		{
			resultantPattern = patternC;
		}
		else if (listSpecficationVariables.contains(patternD))
		{
			resultantPattern = patternD;
		}

		session.setAttribute("strSpecificPattern",strSpecificPattern);
		String defaultTestParams = egSpecs.getArgsForTest(resultantPattern);
		if (defaultTestParams == null || defaultTestParams.equals(""))
		{
			Vector sess_vec = new Vector();
			sess_vec.addElement(_mapping.getTextDescription("admin.test.Configure Agents!"));
			sess_vec.addElement("EgConfigureDefaultTestParams.jsp?qctr=1&componentType=" + componentType);
			sess_vec.addElement(_mapping.getTextDescription("admin.test.TEST NOT AVAILABLE FOR CONFIGURATION"));
			sess_vec.addElement("<b>"+_mapping.getTestDescription(testName)+"</b> "+_mapping.getTextDescription("admin.test.for")+" <b>"+_mapping.getComponentTypeDescription(componentType)+"</b> "+_mapping.getTextDescription("admin.test.is currently not available for configuration")+". ");
			sess_vec.addElement("<br>"+_mapping.getTextDescription("admin.test.Please contact System administrator")+".");
			session.setAttribute("vec_Errors",sess_vec);
		}

		StringTokenizer stParamTokens = new StringTokenizer(defaultTestParams,",");
		stParamTokens.nextToken();
		stParamTokens.nextToken();
		String testParams = stParamTokens.nextToken();
		testPeriod = stParamTokens.nextToken().trim();

		allowedParams = egTestParamIni.getValue("SPECIAL_CHARACTERS","Parameters");

		tcKeywords=egTestParamIni.getVariables("TEST_CONFIGURATION_PARAM_VALUE_KEYWORDS");
		List listTcKeywords = Arrays.asList(tcKeywords);
		strTcKeywords = listTcKeywords.toString();
		strTcKeywords = strTcKeywords.substring(1,strTcKeywords.length()-1);
		strTcKeywords = StringUtils.replace(strTcKeywords,", ",",");
		for (int i=0;i<listTcKeywords.size();i++)
		{
			String strKeyword = (String)listTcKeywords.get(i);
			strKeyword = strKeyword.trim();
			strKeyword = strKeyword.toLowerCase();
			aListTcKeywordsLowerCase.add(strKeyword);
		}

		HashMap hmapTestParamDetails = new HashMap();

		//radio
		String testRadioValue = egTestParamIni.getValue("RADIO",testName);
		StringTokenizer radioTokens = new StringTokenizer(testRadioValue,",");
		while (radioTokens.hasMoreTokens())
		{
			String eachRadioToken = radioTokens.nextToken();
			if (eachRadioToken.indexOf("(") > -1 && eachRadioToken.indexOf(")") > -1)
			{
				String tempStrs = eachRadioToken.substring(eachRadioToken.indexOf("(")+1,eachRadioToken.indexOf(")"));
				eachRadioToken = eachRadioToken.substring(0,eachRadioToken.indexOf("("));
				if (!aListDynamicRadioOptionNameAndValue.contains(eachRadioToken))
				{
					aListDynamicRadioOptionNameAndValue.add(eachRadioToken);//param name
					aListDynamicRadioOptionNameAndValue.add(tempStrs);//param value
				}
			}
			hmapTestParamDetails.put(eachRadioToken.toLowerCase(),"radio");
		}

		//select
		String testSelectValue = egTestParamIni.getValue("SELECT",testName);
		StringTokenizer selectTokens = new StringTokenizer(testSelectValue,",");
		while (selectTokens.hasMoreTokens())
		{
			String eachSelectToken = selectTokens.nextToken();
			if (eachSelectToken.indexOf("(") > -1 && eachSelectToken.indexOf(")") > -1)
			{
				String tempStrs = eachSelectToken.substring(eachSelectToken.indexOf("(")+1,eachSelectToken.lastIndexOf(")"));
				eachSelectToken = eachSelectToken.substring(0,eachSelectToken.indexOf("("));
				if (!aListDynamicSelectOptionNameAndValue.contains(eachSelectToken))
				{
					aListDynamicSelectOptionNameAndValue.add(eachSelectToken);//param name
					aListDynamicSelectOptionNameAndValue.add(tempStrs);//param value
				}
			}
			hmapTestParamDetails.put(eachSelectToken.toLowerCase(),"select");
		}

		//password
		String testPwdValue = egTestParamIni.getValue("PASSWORD",testName);
		StringTokenizer pwdTokens = new StringTokenizer(testPwdValue,",");
		while (pwdTokens.hasMoreTokens())
		{
			String eachPwdToken = pwdTokens.nextToken();
			hmapTestParamDetails.put(eachPwdToken.toLowerCase(),"password");
		}

		//textarea
		String testTextAreaValue = egTestParamIni.getValue("TEXTAREA",testName);
		if(testName.endsWith("_rx"))
		{
			testTextAreaValue = "min_max_values";
		}
		StringTokenizer txtAreaTokens = new StringTokenizer(testTextAreaValue,",");
		while (txtAreaTokens.hasMoreTokens())
		{
			String eachTxtAreaCount = txtAreaTokens.nextToken();
			hmapTestParamDetails.put(eachTxtAreaCount.toLowerCase(),"textarea");
		}

		List listDefaultControls = new ArrayList();
		if (defaultControl != null && defaultControl.length > 0)
		{
			for (int i=0;i<defaultControl.length;i++)
			{
				String tempParamName = defaultControl[i].toLowerCase();
				listDefaultControls.add(tempParamName);
			}
		}
		_mappingInfo = _mapping;
		prMeasureObject.clear();
		prMeasureArray.clear();
		prMeasureDispnameArray.clear();

		ArrayList aListTemp = getParameterList(testParams.trim(),false);
		for (int i=0;i<aListTemp.size();i=i+2)
		{
			String strParamName = (String)aListTemp.get(i);
			String strSearch = strParamName.substring(1);
			strSearch = strSearch.toLowerCase();
			String strParamValue = (String)aListTemp.get(i+1);
			String controlName = null;
			if(strParamName.equals("-min_max_values"))
			{
				rootJson.put("viewLabel",_mapping.getTextDescription("admin.common.Configure Minimum and Maximum values for computing performance rating"));
				String value = strParamValue;
				EgTablesInfo tablesInfo = new EgTablesInfo("manager");
				EgCompositeInfo compInfo = new EgCompositeInfo("manager");
				Hashtable ht = compInfo.getThresholdsForMeasures(pr_test);
				if(ht != null && !ht.isEmpty())
				{
					String new_value_rx = "";
					if(value.equalsIgnoreCase("none"))
					{
						ArrayList measureList = new ArrayList();
						measureList.addAll(ht.keySet());
						Collections.sort(measureList,String.CASE_INSENSITIVE_ORDER);
						Iterator itr = measureList.iterator();
						while(itr.hasNext())
						{
							JSONArray lowerRowDataArray = new JSONArray();
							String compMeasure = (String)itr.next();
							prMeasureArray.add(compMeasure);
							System.out.println("defafult tc pr_test name " + pr_test);
							System.out.println("defafult tc compMeasure name " + compMeasure);
							prMeasureDispnameArray.add(_mappingInfo.getMeasureDescription(pr_test,compMeasure));
							Hashtable ht1 = (Hashtable)ht.get(compMeasure);
							Iterator itr1 = ht1.keySet().iterator();
							while(itr1.hasNext())
							{
								JSONObject lowerRowData = new JSONObject();
								String tm = (String)itr1.next();
								int idx = tm.indexOf(":");
								String t = tm.substring(0,idx);									
								String m = tm.substring(idx+1);
								String thresholds = (String)ht1.get(tm);
								idx = thresholds.indexOf(":");
								String min = thresholds.substring(0,idx);
								String max = thresholds.substring(idx+1);
								new_value_rx+="~~"+compMeasure+"~"+t+"~"+m+"~"+min+"~"+max;
								lowerRowData.put("pr_measure_name",compMeasure);										
								lowerRowData.put("associated_test_name",t);
								lowerRowData.put("associated_test_description",_mappingInfo.getTestDescription(t));
								lowerRowData.put("associated_measure_name",m);
								lowerRowData.put("associated_measure_description",_mappingInfo.getMeasureDescription(t,m) +" ("+tablesInfo.getUnitForMeasure(t,m)+")");
								if(min.equals("-1"))
								{
									lowerRowData.put("associated_measure_min_threshold","None");
								}
								else
								{
									lowerRowData.put("associated_measure_min_threshold",min);
								}
								if(max.equals("-1"))
								{
									lowerRowData.put("associated_measure_max_threshold","None");
								}
								else
								{
									lowerRowData.put("associated_measure_max_threshold",max);
								}
								lowerRowDataArray.add(lowerRowData);
							}
							prMeasureObject.put(compMeasure,lowerRowDataArray);
						}
					}
					else
					{
						String arrayOut[] = StringUtils.getTokens(value.trim(),"~~");
						for(int j=0;j<arrayOut.length;j++)
						{
							String str1 = arrayOut[j].trim();
							String array[] = StringUtils.getTokens(str1,"~");
							if(array != null && array.length==5)
							{
								String prm = array[0].trim();
								String t = array[1].trim();
								String m = array[2].trim();
								String min = array[3].trim();
								String max = array[4].trim();
								if(min.equals("-1"))
									min="None";
								if(max.equals("-1"))
									max="None";
								if(ht.containsKey(prm))
								{
									Hashtable ht1 = (Hashtable)ht.get(prm);
									ht1.put((t+":"+m),min+":"+max);
								}
							}
						}
						ArrayList measureList = new ArrayList();
						measureList.addAll(ht.keySet());
						Collections.sort(measureList,String.CASE_INSENSITIVE_ORDER);
						Iterator itr = measureList.iterator();
						while(itr.hasNext())
						{
							JSONArray lowerRowDataArray = new JSONArray();
							String compMeasure = (String)itr.next();
							prMeasureArray.add(compMeasure);
							prMeasureDispnameArray.add(_mappingInfo.getMeasureDescription(pr_test,compMeasure));
							Hashtable ht1 = (Hashtable)ht.get(compMeasure);
							Iterator itr1 = ht1.keySet().iterator();
							while(itr1.hasNext())
							{
								JSONObject lowerRowData = new JSONObject();
								String tm = (String)itr1.next();
								int idx = tm.indexOf(":");
								String t = tm.substring(0,idx);									
								String m = tm.substring(idx+1);
								String thresholds = (String)ht1.get(tm);
								idx = thresholds.indexOf(":");
								String min = thresholds.substring(0,idx);
								String max = thresholds.substring(idx+1);
								new_value_rx+="~~"+compMeasure+"~"+t+"~"+m+"~"+min+"~"+max;
								lowerRowData.put("pr_measure_name",compMeasure);										
								lowerRowData.put("associated_test_name",t);
								lowerRowData.put("associated_test_description",_mappingInfo.getTestDescription(t));
								lowerRowData.put("associated_measure_name",m);
								lowerRowData.put("associated_measure_description",_mappingInfo.getMeasureDescription(t,m) +" ("+tablesInfo.getUnitForMeasure(t,m)+")");
								if(min.equals("-1")) {
									lowerRowData.put("associated_measure_min_threshold","None");
								}
								else {
									lowerRowData.put("associated_measure_min_threshold",min);
								}
								if(max.equals("-1")) {
									lowerRowData.put("associated_measure_max_threshold","None");
								}
								else {
									lowerRowData.put("associated_measure_max_threshold",max);
								}
								lowerRowDataArray.add(lowerRowData);
							}
							prMeasureObject.put(compMeasure,lowerRowDataArray);
						}
					}
					if(new_value_rx.startsWith("~~"))
					{
						value = new_value_rx.substring(2);
					}
				}
				if(prMeasureObject.size()>0)
				{
					rootJson.put("prMeasureObject",prMeasureObject);
					rootJson.put("prMeasureArray",prMeasureArray);
					rootJson.put("prMeasureDispnameArray",prMeasureDispnameArray);
				}
				strParamValue=value;
			}

			boolean isParamExist = hmapTestParamDetails.containsKey(strSearch);
			if (strSearch.equalsIgnoreCase("Script_location"))
			{
				isParamExist = false;
			}
			if (isParamExist)
			{
				controlName = hmapTestParamDetails.get(strSearch).toString();
			}
			else if (listDefaultControls.contains(strSearch))
			{
				String tempName = strParamName.substring(1);
				controlName = egTestParamIni.getValue("PARAM-CONTROL",tempName.toLowerCase());
				if (controlName.indexOf("(") > -1 && controlName.indexOf(")") > -1)
				{
					String tempStrs = controlName.substring(controlName.indexOf("(")+1,controlName.length()-1);
					controlName = controlName.substring(0,controlName.indexOf("("));
					if (controlName.equals("select") && 
						!aListDynamicSelectOptionNameAndValue.contains(tempName))
					{
						aListDynamicSelectOptionNameAndValue.add(tempName);
						aListDynamicSelectOptionNameAndValue.add(tempStrs);
					}
					if (controlName.equals("radio") && 
						!aListDynamicRadioOptionNameAndValue.contains(tempName))
					{
						aListDynamicRadioOptionNameAndValue.add(tempName);
						aListDynamicRadioOptionNameAndValue.add(tempStrs);
					}
				}
			}
			else
			{
				controlName = "text";
			}

			aResultant.add(strParamName);
			aResultant.add(strParamValue);
			aResultant.add(controlName);
		}

		for (int i=0;i<aResultant.size();i++)
		{
			aListResultantTempInLowerCase.add(aResultant.get(i).toString().toLowerCase());
		}

		if (aListResultantTempInLowerCase.contains("-usealias") && 
			aListResultantTempInLowerCase.contains("-show_alias_and_interface_name"))
		{
			hasShowAliasParam = true;
			int useAliasIdx = aListResultantTempInLowerCase.indexOf("-usealias");
			String useAliasCase = (String)aResultant.get(useAliasIdx);
			useAliasCase = useAliasCase.substring(1);
			useAliasValue = request.getParameter(useAliasCase);
			if (useAliasValue == null || useAliasValue.length() == 0)
			{
				useAliasValue = (String)aResultant.get(useAliasIdx+1);
			}
		}

		isSnmp = aListResultantTempInLowerCase.contains("-snmpport");
		rootJson.put("hasShowAliasParam",hasShowAliasParam);
		rootJson.put("isSnmp",isSnmp);
		//java application
		if(isSnmp)
		{
			if (aListResultantTempInLowerCase.contains("-mode"))
			{
				if(aListResultantTempInLowerCase.contains("-jmx_remote_port") || aListResultantTempInLowerCase.contains("-service_url_path"))
				{
					isModeParamExist = true;
				}
			}
			 
		}
		rootJson.put("isModeParamExist",isModeParamExist);
		boolean isLogFile = (aListResultantTempInLowerCase.contains("-jrehome") && 
				aListResultantTempInLowerCase.contains("-logfilename"));
		if(isLogFile)
		{
			if (aListResultantTempInLowerCase.contains("-measure_mode"))
			{
				if(aListResultantTempInLowerCase.contains("-jmx_remote_port") || aListResultantTempInLowerCase.contains("-service_url_path"))
				{
					isMeasureModeParamExist = true;
				}
			}
			 
		}
		rootJson.put("isMeasureModeParamExist",isMeasureModeParamExist);

		if (isSnmp)
		{
			int portIdx = aListResultantTempInLowerCase.indexOf("-port");
			String portCase = null;
			if (portIdx != -1)
			{
				portCase = (String)aResultant.get(portIdx);
			}

			int timeOutIdx = aListResultantTempInLowerCase.indexOf("-timeout");
			String timeOutCase = null;
			if (timeOutIdx != -1)
			{
				timeOutCase = (String)aResultant.get(timeOutIdx);
			}

			int modeIdx = aListResultantTempInLowerCase.indexOf("-mode");
			String modeCase = null;
			if (modeIdx != -1)
			{
				modeCase = (String)aResultant.get(modeIdx);
			}

			int snmpComIdx=aListResultantTempInLowerCase.indexOf("-snmpcommunity");

			//for older version of snmp not having snmpversion
			String selectToAdd = "";
			if (!aListResultantTempInLowerCase.contains("-snmpversion"))
			{
				aResultant.add(snmpComIdx+3,"-snmpversion");
				aResultant.add(snmpComIdx+4,"v1");
				aResultant.add(snmpComIdx+5,"select");

				aListResultantTempInLowerCase.add(snmpComIdx+3,"-snmpversion");
				aListResultantTempInLowerCase.add(snmpComIdx+4,"v1");
				aListResultantTempInLowerCase.add(snmpComIdx+5,"select");

				selectToAdd = selectToAdd + ",snmpversion";
				isOldSnmp = true;


				String[] tmpVersions = {"v1","v2"};
				versions = tmpVersions;
			}

			if (aListResultantTempInLowerCase.contains("-snmpversion") && !aListResultantTempInLowerCase.contains("-authtype") && !aListResultantTempInLowerCase.contains("-encrypttype"))
			{
				isOldSnmp = true;

				String[] tmpVersions = {"v1","v2"};
				versions = tmpVersions;
			}

			if (selectToAdd.length() > 0)
			{
				IniFile egTestParamIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_testparam.ini");
				egTestParamIniSync.setValue("SELECT",testName,selectToAdd.substring(1));
				egTestParamIniSync.saveFile();
				EgConfigFilesSync.releaseInstance(egTestParamIniSync);
			}

			int snmpVerIdx = aListResultantTempInLowerCase.indexOf("-snmpversion");

			if (testName.equals(previousTestName))
			{
				String originalSnmpParam = ((String)aResultant.get(snmpVerIdx)).substring(1);
				snmpVer = request.getParameter(originalSnmpParam);
				snmpVer = (snmpVer!=null)?snmpVer:"";
			}

			//displaying snmp community afer snmp version -starts
			String moveSnmpCommParam = (String)aResultant.remove(snmpComIdx);
			String moveSnmpCommValue = (String)aResultant.remove(snmpComIdx);
			String moveSnmpCommDisplayControl = (String)aResultant.remove(snmpComIdx);

			aResultant.add(snmpVerIdx,moveSnmpCommDisplayControl);
			aResultant.add(snmpVerIdx,moveSnmpCommValue);
			aResultant.add(snmpVerIdx,moveSnmpCommParam);
			//displaying snmp community afer snmp version -ends

			isSnmpV1V2 = (aListResultantTempInLowerCase.contains("v1") || aListResultantTempInLowerCase.contains("v2"))?true:false;

			if (snmpVer!="")
			{
				isSnmpV1V2 = (snmpVer.equalsIgnoreCase("v1") || snmpVer.equalsIgnoreCase("v2"))?true:false;
			}

			if(!isSnmpV1V2)
			{
				int encryptFlagIdx = aListResultantTempInLowerCase.indexOf("-encryptflag");
				if (encryptFlagIdx > -1)
				{
					if (testName.equals(previousTestName))
					{
						encryptFlag = request.getParameter(((String)aResultant.get(encryptFlagIdx)).substring(1));
						encryptFlag = (encryptFlag!=null)?encryptFlag:"";
					}
				}

				encryptValue = (String)aResultant.get(aListResultantTempInLowerCase.indexOf("-encryptflag")+1);
			}

			if (isModeParamExist)
			{	
				String moveJmxOptionParam = null;
				String moveJmxOptionValue = null;
				String moveJmxDisplayControl = null;
				boolean jmxOption = aListResultantTempInLowerCase.contains("-metric_collection_type");
				int jmxOptionIdx = aListResultantTempInLowerCase.indexOf("-metric_collection_type");
				String jmxOptionCase = null;
				int tempJmxOptionIdx = -1;
				if(jmxOption)
				{
					if (jmxOptionIdx != -1)
					{
						jmxOptionCase = (String)aResultant.get(jmxOptionIdx);
					}
					tempJmxOptionIdx = aResultant.indexOf(jmxOptionCase);
					moveJmxOptionParam = (String)aResultant.remove(tempJmxOptionIdx);
					moveJmxOptionValue = (String)aResultant.remove(tempJmxOptionIdx);
					moveJmxDisplayControl = (String)aResultant.remove(tempJmxOptionIdx);
				}
				if (timeOutIdx == -1)
				{
					//put mode after port
					//-host,-port,-mode
					int tempModeIdx = aResultant.indexOf(modeCase);
					String moveModeParam = (String)aResultant.remove(tempModeIdx);
					String moveModeValue = (String)aResultant.remove(tempModeIdx);
					String moveModeDisplayControl = (String)aResultant.remove(tempModeIdx);

					int tempPortIdx = aResultant.indexOf(portCase);
					if(jmxOption)
					{
						aResultant.add(tempPortIdx+3,moveJmxOptionParam);
						aResultant.add(tempPortIdx+4,moveJmxOptionValue);
						aResultant.add(tempPortIdx+5,moveJmxDisplayControl);
						aResultant.add(tempPortIdx+6,moveModeParam);
						aResultant.add(tempPortIdx+7,moveModeValue);
						aResultant.add(tempPortIdx+8,moveModeDisplayControl);
					}
					else
					{
						aResultant.add(tempPortIdx+3,moveModeParam);
						aResultant.add(tempPortIdx+4,moveModeValue);
						aResultant.add(tempPortIdx+5,moveModeDisplayControl);
					}
					/*aResultant.add(tempPortIdx+3,moveModeParam);
					aResultant.add(tempPortIdx+4,moveModeValue);
					aResultant.add(tempPortIdx+5,moveModeDisplayControl);*/
				}
				else
				{
					int tempTimeOutCaseIdx = aResultant.indexOf(timeOutCase);
					String moveTimeOutParam = (String)aResultant.remove(tempTimeOutCaseIdx);
					String moveTimeOutValue = (String)aResultant.remove(tempTimeOutCaseIdx);
					String moveTimeOutDisplayControl = (String)aResultant.remove(tempTimeOutCaseIdx);

					//-host,-port,-timeout,-mode
					//put timeout after port
					int tempPortIdx = aResultant.indexOf(portCase);
					aResultant.add(tempPortIdx+3,moveTimeOutParam);
					aResultant.add(tempPortIdx+4,moveTimeOutValue);
					aResultant.add(tempPortIdx+5,moveTimeOutDisplayControl);

					int tempModeCaseIdx = aResultant.indexOf(modeCase);
					String moveModeParam = (String)aResultant.remove(tempModeCaseIdx);
					String moveModeValue = (String)aResultant.remove(tempModeCaseIdx);
					String moveModeDisplayControl = (String)aResultant.remove(tempModeCaseIdx);

					//put mode after timeout
					int tempTimeOutCaseIdx1 = aResultant.indexOf(timeOutCase);
					if(jmxOption)
					{
						aResultant.add(tempTimeOutCaseIdx1+3,moveJmxOptionParam);
						aResultant.add(tempTimeOutCaseIdx1+4,moveJmxOptionValue);
						aResultant.add(tempTimeOutCaseIdx1+5,moveJmxDisplayControl);
						aResultant.add(tempTimeOutCaseIdx1+6,moveModeParam);
						aResultant.add(tempTimeOutCaseIdx1+7,moveModeValue);
						aResultant.add(tempTimeOutCaseIdx1+8,moveModeDisplayControl);
					}
					else
					{
						aResultant.add(tempTimeOutCaseIdx1+3,moveModeParam);
						aResultant.add(tempTimeOutCaseIdx1+4,moveModeValue);
						aResultant.add(tempTimeOutCaseIdx1+5,moveModeDisplayControl);
					}
					/*aResultant.add(tempTimeOutCaseIdx1+3,moveModeParam);
					aResultant.add(tempTimeOutCaseIdx1+4,moveModeValue);
					aResultant.add(tempTimeOutCaseIdx1+5,moveModeDisplayControl);*/
				}
			}
		}

		if (aListResultantTempInLowerCase.contains("-showallevents") && 
			aListResultantTempInLowerCase.contains("-showallonly"))
		{
			hasShowAllOnlyParam = true;
			int showAllEventsIdx = aListResultantTempInLowerCase.indexOf("-showallevents");
			String showAllEventsCase = (String)aResultant.get(showAllEventsIdx);
			showAllEventsCase = showAllEventsCase.substring(1);
			showAllEventsValue = request.getParameter(showAllEventsCase);
			if (showAllEventsValue == null || showAllEventsValue.length() == 0)
			{
				showAllEventsValue = (String)aResultant.get(showAllEventsIdx+1);
			}
		}
		rootJson.put("hasShowAllOnlyParam",hasShowAllOnlyParam);
		if (aListResultantTempInLowerCase.contains("-report_total") && 
			aListResultantTempInLowerCase.contains("-report_only_total"))
		{
			hasReportOnlyTotalParam = true;
			int reportTotalIdx = aListResultantTempInLowerCase.indexOf("-report_total");
			String reportTotalCase = (String)aResultant.get(reportTotalIdx);
			reportTotalCase = reportTotalCase.substring(1);
			reportTotalValue = request.getParameter(reportTotalCase);
			if (reportTotalValue == null || reportTotalValue.length() == 0)
			{
				reportTotalValue = (String)aResultant.get(reportTotalIdx+1);
			}
		}
		rootJson.put("hasReportOnlyTotalParam",hasReportOnlyTotalParam);

		IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");

		//contains multiple user enabled test
		listMultipleUserSupportTest = Arrays.asList(testsIni.getVariables("MULTIPLE_USERS"));

		//policy filter work starts here
		isPolicyParamExists = aListResultantTempInLowerCase.contains("-policyfilter") && aListResultantTempInLowerCase.contains("-filter");
		rootJson.put("isPolicyParamExists",isPolicyParamExists);

		String tLogType = "";
		int tLogTypeIdx = aListResultantTempInLowerCase.indexOf("-logtype");
		if (tLogTypeIdx > -1)
		{
			//if (testName.equals(previousTestName))
			{
				//tLogType = request.getParameter(((String)aResultant.get(tLogTypeIdx)).substring(1));
				tLogType = (String) aResultant.get(tLogTypeIdx+1);

				tLogType = (tLogType != null && tLogType.length() > 0)?tLogType:"";
			}
		}

		int tPolicyFilterIdx = aListResultantTempInLowerCase.indexOf("-policyfilter");
		if (tPolicyFilterIdx > -1)
		{
			if (testName.equals(previousTestName))
			{
				tPolicyFilter = request.getParameter(((String)aResultant.get(tPolicyFilterIdx)).substring(1));
				tPolicyFilter = (tPolicyFilter != null && tPolicyFilter.length() > 0)?tPolicyFilter:"";
			}
		}

		if (isPolicyParamExists)
		{
			int policyFilterIdx = aListResultantTempInLowerCase.indexOf("-policyfilter");
			String policyFilterValue = (String)aResultant.get(policyFilterIdx+1);

			if ((policyFilterValue.equalsIgnoreCase("true") && (tPolicyFilter.length()==0 || tPolicyFilter.equalsIgnoreCase("true"))) || tPolicyFilter.equalsIgnoreCase("true"))
			{
				String testParam[] = testsIni.getVariables("EVENTLOG_POLICIES");
				for(int i = 0;i<testParam.length;i++)
				{
					String strTestParamVars = testParam[i];
					String strTestParamTest = strTestParamVars.substring(0,strTestParamVars.indexOf(":"));
					strTestParamVars = strTestParamVars.substring(strTestParamVars.indexOf(":")+1);
					String strTestParamLogType = strTestParamVars.substring(0,strTestParamVars.indexOf(":"));

					if(!(strTestParamTest+":"+strTestParamLogType).equalsIgnoreCase(testName+":"+tLogType)) continue;
					String str = testParam[i].substring(testParam[i].lastIndexOf(":")+1,testParam[i].length());
					if (aPolicyFilter != null && !aPolicyFilter.contains(str))
					{
						aPolicyFilter.add(str);
					}
				}
			}

			if(tPolicyFilter.equalsIgnoreCase("false"))
			{
				ArrayList aListPolicy = new ArrayList();
				int filterIdx = aListResultantTempInLowerCase.indexOf("-filter");
				String filterValue = (String)aResultant.get(filterIdx+1);

				if(filterValue.indexOf(":") > -1)
				{
					if(filterValue.indexOf(";") > -1)
					{
						StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
						while(policyTokens.hasMoreTokens())
						{
							String tempPolicy = policyTokens.nextToken();
							tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
							aListPolicy.add(tempPolicy);
						}
					}
					else if (filterValue.indexOf("~#~") > -1)
					{
						StringTokenizer policyTokens = new StringTokenizer(filterValue,"~#~");
						while(policyTokens.hasMoreTokens())
						{
							String tempPolicy = policyTokens.nextToken();
							tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
							aListPolicy.add(tempPolicy);
						}
					}
					else
					{
						aListPolicy.add(filterValue.substring(0,filterValue.indexOf(":")));
					}
				}
				else
				{
					if(filterValue.indexOf(";")>-1)
					{
						//more than one policy name i.e -filter IISEvents;CitrixEvents;XchgEvents
						StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
						while(policyTokens.hasMoreTokens())
						{
							aListPolicy.add(policyTokens.nextToken());
						}
					}
					else if (filterValue.indexOf("~#~") > -1)
					{
						StringTokenizer policyTokens = new StringTokenizer(filterValue,"~#~");
						while(policyTokens.hasMoreTokens())
						{
							String tempPolicy = policyTokens.nextToken();
							tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
							aListPolicy.add(tempPolicy);
						}
					}
					else
					{
						//one policy name i.e -filter IISEvents
						aListPolicy.add(filterValue);
					}
				}

				for(int c=0;c<aListPolicy.size();c++)
				{
					String pattern = testName+":"+tLogType+":"+aListPolicy.get(c);
					String strVal = testsIni.getValue("EVENTLOG_POLICIES",pattern);
					if (!StringUtils.isNull(strVal))
					{
						strVal = (aListPolicy.get(c)).toString()+":"+strVal;
						aPolicyFilter.add(strVal);
					}
				}
			}

			if (aPolicyFilter != null && (aPolicyFilter.isEmpty() || !aPolicyFilter.contains("all")))
			{
				aPolicyFilter.add("all");
				IniFile egTestsIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
				String strEvtPolVar = testName+":"+tLogType.toLowerCase()+":all";
				String strEvtPolVal = "all:none:all:none:all:none";
				egTestsIni.setValue("EVENTLOG_POLICIES",strEvtPolVar,strEvtPolVal);
				egTestsIni.saveFile();
				EgConfigFilesSync.releaseInstance(egTestsIni);
			}

			if (aPolicyFilter.size() > 0)
			{
				if (aPolicyFilter.contains("all"))
				{
					aPolicyFilter.remove("all");
					Collections.sort(aPolicyFilter,String.CASE_INSENSITIVE_ORDER);
					aPolicyFilter.add(0,"all");
				}
				else
				{
					Collections.sort(aPolicyFilter,String.CASE_INSENSITIVE_ORDER);
				}
			}
		}

		if (isPolicyParamExists)
		{
			String jsonLogType = "";
			for (int i=0;i< aListResultantTempInLowerCase.size();i++)
			{
				String tempLogType = (String) aListResultantTempInLowerCase.get(i);
				if (!StringUtils.isNull(tempLogType) && tempLogType.equals("-logtype"))
				{
					jsonLogType = (String) aListResultantTempInLowerCase.get(i+1);
					break;
				}
			}
			ArrayList jsonPolicyFilter = new ArrayList();
			String testParam[] = testsIni.getVariables("EVENTLOG_POLICIES");
			ArrayList specificTestsEventLogPolicyList = new ArrayList();

			for(int i = 0;i<testParam.length;i++)
			{
				String strTestParamVars = testParam[i];
				String strTestParamTest = strTestParamVars.substring(0,strTestParamVars.indexOf(":"));
				strTestParamVars = strTestParamVars.substring(strTestParamVars.indexOf(":")+1);
				String strTestParamLogType = strTestParamVars.substring(0,strTestParamVars.indexOf(":"));
				if(!((strTestParamTest+":"+strTestParamLogType).equalsIgnoreCase(testName+":"+jsonLogType)))
				{
					continue;
				}
				String str = testParam[i].substring(testParam[i].lastIndexOf(":")+1,testParam[i].length());
				jsonPolicyFilter.add(str);
				specificTestsEventLogPolicyList.add(testParam[i]);
			}
			if (jsonPolicyFilter.size() > 0)
			{
				if (jsonPolicyFilter.contains("all"))
				{
					jsonPolicyFilter.remove("all");
					Collections.sort(jsonPolicyFilter,String.CASE_INSENSITIVE_ORDER);
					jsonPolicyFilter.add(0,"all");
				}
				else
				{
					Collections.sort(jsonPolicyFilter,String.CASE_INSENSITIVE_ORDER);
				}
			}
			if (jsonPolicyFilter != null && jsonPolicyFilter.size() > 0)
			{
				String strPolTrue = StringUtils.getString(jsonPolicyFilter);
				rootJson.put("isPolicyFilterTrue",strPolTrue);
			}

			jsonPolicyFilter = new ArrayList();
			ArrayList tmpAListPolicy = new ArrayList();
			int filterIdx = aListResultantTempInLowerCase.indexOf("-filter");
			String filterValue = (String)aResultant.get(filterIdx+1);
			if(filterValue.indexOf(":") > -1)
			{
				if(filterValue.indexOf(";") > -1)
				{
					StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
					while(policyTokens.hasMoreTokens())
					{
						String tempPolicy = policyTokens.nextToken();
						tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
						tmpAListPolicy.add(tempPolicy);
					}
				}
				else if(filterValue.indexOf("~#~") > -1)
				{
					StringTokenizer policyTokens = new StringTokenizer(filterValue,"~#~");
					while(policyTokens.hasMoreTokens())
					{
						String tempPolicy = policyTokens.nextToken();
						tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
						tmpAListPolicy.add(tempPolicy);
					}
				}
				else
				{
					tmpAListPolicy.add(filterValue.substring(0,filterValue.indexOf(":")));
				}
			}
			else
			{
				if(filterValue.indexOf(";")>-1)
				{
					//more than one policy name i.e -filter IISEvents;CitrixEvents;XchgEvents
					StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
					while(policyTokens.hasMoreTokens())
					{
						tmpAListPolicy.add(policyTokens.nextToken());
					}
				}
				else if(filterValue.indexOf("~#~") > -1)
				{
					StringTokenizer policyTokens = new StringTokenizer(filterValue,"~#~");
					while(policyTokens.hasMoreTokens())
					{
						String tempPolicy = policyTokens.nextToken();
						//tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
						tmpAListPolicy.add(tempPolicy);
					}
				}
				else
				{
					//one policy name i.e -filter IISEvents
					tmpAListPolicy.add(filterValue);
				}
			}

			for(int c=0;c<tmpAListPolicy.size();c++)
			{
				String pattern = testName+":"+jsonLogType+":"+tmpAListPolicy.get(c);
				if (specificTestsEventLogPolicyList != null && !specificTestsEventLogPolicyList.isEmpty())
				{
					for (int j=0;j<specificTestsEventLogPolicyList.size();j++)
					{
						String strCorrectVariable = (String) specificTestsEventLogPolicyList.get(j);
						
						if (!com.egurkha.util.StringUtils.isNull(strCorrectVariable) && strCorrectVariable.equalsIgnoreCase(pattern))
						{
							pattern= strCorrectVariable;
							break;
						}
					}
				}
				String strVal = testsIni.getValue("EVENTLOG_POLICIES",pattern);
				if (!StringUtils.isNull(strVal))
				{
					strVal = (tmpAListPolicy.get(c)).toString()+":"+strVal;
					jsonPolicyFilter.add(strVal);
				}
				else
				{
					//all:all:none:all:none:all:none
					String polFilterName = tmpAListPolicy.get(c).toString();
					if (polFilterName.equals("all") && StringUtils.isNull(strVal))
					{
						strVal = "all:all:none:all:none:all:none";
						jsonPolicyFilter.add(strVal);
					}
				}
			}

			if (jsonPolicyFilter.size() > 0)
			{
				if (jsonPolicyFilter.contains("all"))
				{
					jsonPolicyFilter.remove("all");
					Collections.sort(jsonPolicyFilter,String.CASE_INSENSITIVE_ORDER);
					jsonPolicyFilter.add(0,"all");
				}
				else
				{
					Collections.sort(jsonPolicyFilter,String.CASE_INSENSITIVE_ORDER);
				}
			}

			if (jsonPolicyFilter != null && jsonPolicyFilter.size() > 0)
			{
				String strPolFalse = "";
				if (jsonPolicyFilter.size() == 1)
				{
					strPolFalse = jsonPolicyFilter.get(0).toString();
				}
				else
				{
					for (int p=0;p<jsonPolicyFilter.size();p++)
					{
						String strPolicyDetails = jsonPolicyFilter.get(p).toString();
						strPolFalse += ";" + strPolicyDetails;
					}

					if (strPolFalse.startsWith(";"))
					{
						strPolFalse = strPolFalse.substring(1);
					}
				}
				rootJson.put("isPolicyFilterFalse",strPolFalse);
			}
		}
		//policy filter work ends here

		//credential work starts here(http test)
		String moreUrl = "";
		if (testName.equals(previousTestName))
		{
			moreUrl = request.getParameter("moreurl");
			moreUrl = (moreUrl!=null)?moreUrl:"";
		}
		isCredentialParamExist = aListResultantTempInLowerCase.contains("-credentials");
		isUrlParamExist = aListResultantTempInLowerCase.contains("-url");
		isWsdlUrlExist = aListResultantTempInLowerCase.contains("-wsdl_url");
		isPrivateKeyParamExist = aListResultantTempInLowerCase.contains("-privatekey");
		isSystemPropKeyParamExist = aListResultantTempInLowerCase.contains("-systempropertykey");

		ArrayList aTempUrl = new ArrayList();
		rootJson.put("moreUrl",moreUrl);
		rootJson.put("isCredentialParamExist",isCredentialParamExist);
		rootJson.put("isWsdlUrlExist",isWsdlUrlExist);
		rootJson.put("isUrlParamExist",isUrlParamExist);
		rootJson.put("isPrivateKeyParamExist",isPrivateKeyParamExist);
		rootJson.put("isSystemPropKeyParamExist",isSystemPropKeyParamExist);

		if (isCredentialParamExist)
		{
			int urlIdx=0;
			if(isUrlParamExist)
				urlIdx = aListResultantTempInLowerCase.indexOf("-url");
			else if(isWsdlUrlExist)
				urlIdx = aListResultantTempInLowerCase.indexOf("-wsdl_url");
			String urls = aResultant.get(urlIdx+1).toString();
			previousUrl = urls;
			StringTokenizer urlTokens = new StringTokenizer(urls,"|");
			int urlCount = urlTokens.countTokens();
			int credentialIdx = aListResultantTempInLowerCase.indexOf("-credentials");
			String credentialValues = aResultant.get(credentialIdx+1).toString();
			StringTokenizer credentialValuesTokens = new StringTokenizer(credentialValues,"|");
			int credentialTokens = credentialValuesTokens.countTokens();

			int contentIdx = aListResultantTempInLowerCase.indexOf("-content");
			String contentValues = aResultant.get(contentIdx+1).toString();
			if (aListParamsWithDoubleQuotes != null && aListParamsWithDoubleQuotes.contains("content"))
			{
				if (contentValues.startsWith("\"") && contentValues.endsWith("\""))
				{
					contentValues = contentValues.substring(1,contentValues.length()-1);
				}
			}

			StringTokenizer contentValuesTokens = new StringTokenizer(contentValues,"|");
			int contentTokens = contentValuesTokens.countTokens();

			int encodingIdx = aListResultantTempInLowerCase.indexOf("-encoding");
			String encodingValues = aResultant.get(encodingIdx+1).toString();
			StringTokenizer encodingValuesTokens = new StringTokenizer(encodingValues,"|");
			int encodingTokens = encodingValuesTokens.countTokens();
			
			String filePathValues ="";
			StringTokenizer filePathValuesTokens =null;
			int filePathTokens =0;
			if(isPrivateKeyParamExist)
			{
				int filePathIdx = aListResultantTempInLowerCase.indexOf("-privatekey");
				filePathValues = aResultant.get(filePathIdx+1).toString();
				filePathValuesTokens = new StringTokenizer(filePathValues,"|");
				filePathTokens = filePathValuesTokens.countTokens();
			}

			String systemPropKeys = "";
			StringTokenizer systemPropKeyTokens = null;
			int propKeyTokens = 0;

			String systemPropValues = "";
			StringTokenizer systemPropValuesTokens = null;
			int propValTokens = 0;

			if (isSystemPropKeyParamExist)
			{

				int systemPropKeyIdx = aListResultantTempInLowerCase.indexOf("-systempropertykey");
				systemPropKeys = aResultant.get(systemPropKeyIdx+1).toString();
				systemPropKeyTokens = new StringTokenizer(systemPropKeys,"|");
				propKeyTokens = systemPropKeyTokens.countTokens();

				int systemPropValIdx = aListResultantTempInLowerCase.indexOf("-systempropertyvalue");
				systemPropValues = aResultant.get(systemPropValIdx+1).toString();
				systemPropValuesTokens = new StringTokenizer(systemPropValues,"|");
				propValTokens = systemPropValuesTokens.countTokens();


				if (urlCount != propKeyTokens)
				{
					if (urlCount > propKeyTokens)
					{
						int difference = urlCount - propKeyTokens;
						for (int i=0;i<difference;i++)
						{
							systemPropKeys = systemPropKeys + "|" + "none";
						}
					}
					if (urlCount < propKeyTokens)
					{
						int difference = propKeyTokens - urlCount;
						for (int i=0;i<difference;i++)
						{
							systemPropKeys = systemPropKeys.substring(0,systemPropKeys.lastIndexOf("|"));
						}
					}
					systemPropKeyTokens = new StringTokenizer(systemPropKeys,"|");
				}

				if (urlCount != propValTokens)
				{
					if (urlCount > propValTokens)
					{
						int difference = urlCount - propValTokens;
						for (int i=0;i<difference;i++)
						{
							systemPropValues = systemPropValues + "|" + "none";
						}
					}
					if (urlCount < propValTokens)
					{
						int difference = propValTokens - urlCount;
						for (int i=0;i<difference;i++)
						{
							systemPropValues = systemPropValues.substring(0,systemPropValues.lastIndexOf("|"));
						}
					}
					systemPropValuesTokens = new StringTokenizer(systemPropValues,"|");
				}
			}

			while(urlTokens.hasMoreTokens())
			{
				String s = urlTokens.nextToken();
				if (s.indexOf(":") > -1)
				{
					//URL Format->$name:$url
					aUrlCredentialVal.add(s.substring(0,s.indexOf(":")));
					String s1 = credentialValuesTokens.nextElement().toString();
					aUrlCredentialVal.add(s1.substring(0,s1.indexOf(":")));
					//decrypting the password
					String s2 = s1.substring(s1.indexOf(":")+1);
					s2 = EgCrypt.decrypt(s2);
					if (!aListTcKeywordsLowerCase.contains(s2.toLowerCase()))
					{
						s2 += "~EG~"; // salt for pwd
						s2 = EgCrypt.encrypt(s2); 
					}

					aUrlCredentialVal.add(s2);

					String s3 = contentValuesTokens.nextElement().toString();
					aListContentValues.add(s3);
					String s4 = encodingValuesTokens.nextElement().toString();
					aListEncodingValues.add(s4);
					
					if(isPrivateKeyParamExist)
					{
						String s5 = filePathValuesTokens.nextElement().toString();
						if(s5 != null && s5.startsWith("none"))
						{
							if(s5.indexOf(":")>-1)
							{
								aListFilePathValues.add(s5.substring(0,s5.indexOf(":")));
								//decrypting the password
								String s6 = s5.substring(s5.indexOf(":")+1);
								s6 = EgCrypt.decrypt(s6);
								if (!aListTcKeywordsLowerCase.contains(s6.toLowerCase()))
								{
									s6 += "~EG~"; // salt for pwd
									s6 = EgCrypt.encrypt(s6); 
								}

								aListFilePathValues.add(s6);
							}
						}
						else
						{
							if(s5.indexOf(":")>-1)
							{
								String start = s5.substring(0,s5.indexOf(":"));
								String remaining = s5.substring(s5.indexOf(":")+1);
								String end = "";
								String passStr = "";
								if(s5.indexOf(":/")> -1 || s5.indexOf(":\\")> -1)
								{
									end = remaining.substring(0, remaining.indexOf(":"));
									passStr = remaining.substring(remaining.indexOf(":")+1);
								}
								else
								{
									passStr = remaining;
								}
								if(end.length() > 0)
								{
									aListFilePathValues.add(start+":"+end);
								}
								else
								{
									aListFilePathValues.add(start);
								}
								//decrypting the password

								passStr = EgCrypt.decrypt(passStr);
								if (!aListTcKeywordsLowerCase.contains(passStr.toLowerCase()))
								{
									passStr += "~EG~"; // salt for pwd
									passStr = EgCrypt.encrypt(passStr); 
								}
								aListFilePathValues.add(passStr);
							}
						}
					}

					if (isSystemPropKeyParamExist)
					{
						String s6 = systemPropKeyTokens.nextElement().toString();
						aListSystemPropKeys.add(s6);

						String s7 = systemPropValuesTokens.nextElement().toString();
						aListSystemPropValues.add(s7);
					}
				}
				else
				{
					//URL Format->$unconfigured
					aUrlCredentialVal.add("$unconfigured");
					aUrlCredentialVal.add("none");
					aUrlCredentialVal.add("none");

					aListContentValues.add("none:none");
					aListEncodingValues.add("none");
					
					if(isPrivateKeyParamExist)
					{
						aListFilePathValues.add("none");
						aListFilePathValues.add("none");
					}

					if (isSystemPropKeyParamExist)
					{
						aListSystemPropKeys.add("none");
						aListSystemPropValues.add("none");
					}
				}
			}

			if (moreUrl.equals("true"))
			{
				String reqUrlVal = "";
				if(isUrlParamExist)
					reqUrlVal = request.getParameter("url");
				else if(isWsdlUrlExist)
					reqUrlVal = request.getParameter("WSDL_URL");
				StringTokenizer reqUrlTokens = new StringTokenizer(reqUrlVal,",");
				while (reqUrlTokens.hasMoreTokens())
				{
					String s3 = reqUrlTokens.nextToken();
					String s4 = s3.substring(0,s3.indexOf(":"));
					aTempUrl.add(s4);
					boolean urlExist = aUrlCredentialVal.contains(s4);
					if(urlExist)
					{
						int urlIndex = aUrlCredentialVal.indexOf(s4);
						String urlUsername = (String)aUrlCredentialVal.get(urlIndex+1);
						String urlUserpass = (String)aUrlCredentialVal.get(urlIndex+2);
						aTempUrl.add(urlUsername);
						aTempUrl.add(urlUserpass);
					}
					else
					{
						aTempUrl.add("none");
						aTempUrl.add("none");
					}
				}
				aUrlCredentialVal = aTempUrl;
			}
		}
		//credential work ends here

		isCorrectParamExist = (aListResultantTempInLowerCase.contains("-correct") && aListResultantTempInLowerCase.contains("-alarmtype") && aListResultantTempInLowerCase.contains("-userparams") && aListResultantTempInLowerCase.contains("-correctivescript"));
		rootJson.put("isCorrectParamExist",isCorrectParamExist);
		String reqCorrectValue = "";
		if (testName.equals(previousTestName))
		{
			reqCorrectValue = request.getParameter("correct");
			reqCorrectValue = (reqCorrectValue!=null)?reqCorrectValue:"";
		}

		if (isCorrectParamExist)
		{
			int correctiveIdx = aListResultantTempInLowerCase.indexOf("-correct");
			String correctVal = (String)aResultant.get(correctiveIdx+1);
			if((correctVal.equals("true") && reqCorrectValue.length()==0) || reqCorrectValue.equals("true"))
			{
				isCorrectiveScriptEnabled = true;
			}
		}

		rootJson.put("isCorrectiveScriptEnabled",isCorrectiveScriptEnabled);

		//To do the following
		//1.Configure value for virtual centers 
		//2.Change webport value,when its value is default - starts
		if (aListResultantTempInLowerCase.contains("-webport") && 
			aListResultantTempInLowerCase.contains("-ssl"))
		{
			if (aListResultantTempInLowerCase.contains("-virtual_center"))
			{
				//To configure value for virtual centers - starts
				int tempVirtual_centerIdx = aListResultantTempInLowerCase.indexOf("-virtual_center");
				String tempVirtual_centerValue = ((String)aResultant.get(tempVirtual_centerIdx+1)).trim();

				virtualCenters = servicesIniFile.getVariables("VIRTUAL_CENTER");
				String selectedVirtualCenter = "";
				if (testName.equals(previousTestName))
				{
					selectedVirtualCenter = request.getParameter("virtual_center");
					selectedVirtualCenter = (selectedVirtualCenter != null)?selectedVirtualCenter:"";
				}
				if (!selectedVirtualCenter.equals(""))
				{
					String sslValue = "";
					String esx_UserValue = "";
					String esx_PassWord = "";
					String webPort = "";
					String selectedVirtualCenterValue = "";
					if (selectedVirtualCenter.equalsIgnoreCase("none"))
					{
						if (tempVirtual_centerValue.equalsIgnoreCase("none"))
						{
							int tempIdx = aListResultantTempInLowerCase.indexOf("-esx_user");
							esx_UserValue = ((String)aResultant.get(tempIdx+1)).trim();

							tempIdx = aListResultantTempInLowerCase.indexOf("-esx_password");
							esx_PassWord = ((String)aResultant.get(tempIdx+1)).trim();

							tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
							sslValue = ((String)aResultant.get(tempIdx+1)).trim();

							tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
							webPort = ((String)aResultant.get(tempIdx+1)).trim();

							if (webPort.equalsIgnoreCase("default"))
							{
								if (sslValue.equalsIgnoreCase("true") || 
								sslValue.equalsIgnoreCase("yes"))
								{
									webPort = "443";
								}
								else
								{
									webPort = "80";
								}
							}
						}
						else
						{
							esx_UserValue = "$unconfigured";
							esx_PassWord = "$unconfigured";
							sslValue = "true";
							webPort = "443";
						}
					}
					else
					{
						selectedVirtualCenterValue = servicesIniFile.getValue("VIRTUAL_CENTER",selectedVirtualCenter);
						selectedVirtualCenterValue = (selectedVirtualCenterValue != null)?selectedVirtualCenterValue:"";
						if (!selectedVirtualCenterValue.equals(""))
						{
							StringTokenizer stVirtualCenterTokens = null;
							stVirtualCenterTokens = new StringTokenizer(selectedVirtualCenterValue,"#");
							sslValue = stVirtualCenterTokens.nextToken();
							esx_UserValue = stVirtualCenterTokens.nextToken();
							esx_PassWord = stVirtualCenterTokens.nextToken();
							stVirtualCenterTokens.nextToken();
							webPort = stVirtualCenterTokens.nextToken();
						}
					}

					int virtual_centerIdx = aListResultantTempInLowerCase.indexOf("-virtual_center");
					aResultant.remove(virtual_centerIdx+1);
					aResultant.add(virtual_centerIdx+1,selectedVirtualCenter);

					int sslIdx = aListResultantTempInLowerCase.indexOf("-ssl");
					aResultant.remove(sslIdx+1);
					aResultant.add(sslIdx+1,sslValue.toLowerCase());

					int esx_userIdx = aListResultantTempInLowerCase.indexOf("-esx_user");
					aResultant.remove(esx_userIdx+1);
					aResultant.add(esx_userIdx+1,esx_UserValue);

					int esx_PassWordIdx = aListResultantTempInLowerCase.indexOf("-esx_password");
					aResultant.remove(esx_PassWordIdx+1);
					aResultant.add(esx_PassWordIdx+1,esx_PassWord);

					int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
					aResultant.remove(webPortIdx+1);
					aResultant.add(webPortIdx+1,webPort);
				}
				else
				{
					if (tempVirtual_centerValue.equalsIgnoreCase("none"))
					{
						int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
						String webPort = ((String)aResultant.get(tempIdx+1)).trim();
						if (webPort.equalsIgnoreCase("default"))
						{
							tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
							String sslValue = ((String)aResultant.get(tempIdx+1)).trim();
							if (sslValue.equalsIgnoreCase("true") || 
								sslValue.equalsIgnoreCase("yes"))
							{
								webPort = "443";
							}
							else
							{
								webPort = "80";
							}

							int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
							aResultant.remove(webPortIdx+1);
							aResultant.add(webPortIdx+1,webPort);
						}
					}
				}
				//To configure value for virtual centers - ends
			}
			else if (aListResultantTempInLowerCase.contains("-prism_ip"))
			{
				//To configure value for virtual centers - starts
				int tempCVM_IPIdx = aListResultantTempInLowerCase.indexOf("-prism_ip");
				String tempCVM_IPValue = ((String)aResultant.get(tempCVM_IPIdx+1)).trim();

				nutanixPrisms = servicesIniFile.getVariables("NUTANIX");
				String selectedCVMIP = "";
				if (testName.equals(previousTestName))
				{
					selectedCVMIP = request.getParameter("Prism_IP");
					selectedCVMIP = (selectedCVMIP != null)?selectedCVMIP:"";
				}

				if (!selectedCVMIP.equals(""))
				{
					String sslValue = "";
					String cvm_UserValue = "";
					String cvm_PassWord = "";
					String webPort = "";
					String selectedCVMIPValue = "";
					if (selectedCVMIP.equalsIgnoreCase("none"))
					{
						if (tempCVM_IPValue.equalsIgnoreCase("none"))
						{
							int tempIdx = aListResultantTempInLowerCase.indexOf("-prism_user");
							cvm_UserValue = ((String)aResultant.get(tempIdx+1)).trim();

							tempIdx = aListResultantTempInLowerCase.indexOf("-prism_password");
							cvm_PassWord = ((String)aResultant.get(tempIdx+1)).trim();

							tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
							sslValue = ((String)aResultant.get(tempIdx+1)).trim();

							tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
							webPort = ((String)aResultant.get(tempIdx+1)).trim();

							if (webPort.equalsIgnoreCase("default"))
							{
								webPort = "9440";
							}
						}
						else
						{
							cvm_UserValue = "$unconfigured";
							cvm_PassWord = "$unconfigured";
							sslValue = "true";
							webPort = "9440";
						}
					}
					else if (selectedCVMIP.equalsIgnoreCase("other"))
					{
						cvm_UserValue = "none";
						cvm_PassWord = "none";
						sslValue = "true";
						webPort = "9440";
					}
					else
					{
						selectedCVMIPValue = servicesIniFile.getValue("NUTANIX",selectedCVMIP);
						selectedCVMIPValue = (selectedCVMIPValue != null)?selectedCVMIPValue:"";
						if (!selectedCVMIPValue.equals(""))
						{
							StringTokenizer stCVMTokens = null;
							stCVMTokens = new StringTokenizer(selectedCVMIPValue,"#");
							sslValue = stCVMTokens.nextToken();
							cvm_UserValue = stCVMTokens.nextToken();
							cvm_PassWord = stCVMTokens.nextToken();
							stCVMTokens.nextToken();
							webPort = stCVMTokens.nextToken();
						}
					}

					int cvm_ipIdx = aListResultantTempInLowerCase.indexOf("-prism_ip");
					aResultant.remove(cvm_ipIdx+1);
					aResultant.add(cvm_ipIdx+1,selectedCVMIP);

					int sslIdx = aListResultantTempInLowerCase.indexOf("-ssl");
					aResultant.remove(sslIdx+1);
					aResultant.add(sslIdx+1,sslValue.toLowerCase());

					int esx_userIdx = aListResultantTempInLowerCase.indexOf("-prism_user");
					aResultant.remove(esx_userIdx+1);
					aResultant.add(esx_userIdx+1,cvm_UserValue);

					int esx_PassWordIdx = aListResultantTempInLowerCase.indexOf("-prism_password");
					aResultant.remove(esx_PassWordIdx+1);
					aResultant.add(esx_PassWordIdx+1,cvm_PassWord);

					int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
					aResultant.remove(webPortIdx+1);
					aResultant.add(webPortIdx+1,webPort);
				}
				else
				{
					ArrayList aListTempNutanixPrisms = null;
					boolean hasNutanixPrisms = false;
					if (nutanixPrisms != null && nutanixPrisms.length > 0)
					{
						aListTempNutanixPrisms = new ArrayList(Arrays.asList(nutanixPrisms));
						hasNutanixPrisms = true;
					}

					if (tempCVM_IPValue.equalsIgnoreCase("none"))
					{
						int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
						String webPort = ((String)aResultant.get(tempIdx+1)).trim();
						if (webPort.equalsIgnoreCase("default"))
						{
							tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
							String sslValue = ((String)aResultant.get(tempIdx+1)).trim();
							webPort = "9440";

							int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
							aResultant.remove(webPortIdx+1);
							aResultant.add(webPortIdx+1,webPort);
						}
					}
					else if ((aListTempNutanixPrisms == null) || (hasNutanixPrisms && !aListTempNutanixPrisms.contains(tempCVM_IPValue)))
					{
						//upgrade issue
						int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
						String webPort = ((String)aResultant.get(tempIdx+1)).trim();
						if (webPort.equalsIgnoreCase("default"))
						{
							webPort = "9440";

							int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
							aResultant.remove(webPortIdx+1);
							aResultant.add(webPortIdx+1,webPort);
						}
					}
				}
				//To configure value for nutanix prisms - ends
			}
			else
			{
				int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
				String webPort = ((String)aResultant.get(webPortIdx+1)).trim();
				if (webPort.equalsIgnoreCase("default"))
				{
					int sslIdx = aListResultantTempInLowerCase.indexOf("-ssl");
					String tempSslValue = (String)aResultant.get(sslIdx+1);
					if (tempSslValue.equalsIgnoreCase("true") || 
						tempSslValue.equalsIgnoreCase("yes"))
					{
						webPort = "443";
					}
					else
					{
						webPort = "80";
					}
					aResultant.remove(webPortIdx+1);
					aResultant.add(webPortIdx+1,webPort);
				}
			}
		}
		//ends

		////////RHEV- Code Starts
		if (aListResultantTempInLowerCase.contains("-rhel_mgr_host"))
		{
			rhevs = servicesIniFile.getVariables("RHEV");
			if (testName.equals(previousTestName))
			{
				String rhevManager = request.getParameter("Rhel_mgr_host");
				if (rhevManager == null)
				{
						rhevManager = "none";
				}
		
				String strRhevUser = "";
				String strRhevPassword = "";
				String strRhevPort = "";
				String strRhevDomain = "";
				if (rhevManager.equalsIgnoreCase("none"))
				{
					strRhevUser = "$unconfigured";
					strRhevPassword = "$unconfigured";
					strRhevPort = "8443";
					strRhevDomain = "internal";
				}
				else
				{
					String strTemp = servicesIniFile.getValue("RHEV",rhevManager);
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);

					strRhevUser = strTemp.substring(0,strTemp.indexOf("#"));
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);

					strRhevPassword = strTemp.substring(0,strTemp.indexOf("#"));
					strRhevPassword = EgCrypt.decrypt(strRhevPassword);
					if (!aListTcKeywordsLowerCase.contains(strRhevPassword.toLowerCase()))
					{
						strRhevPassword += "~EG~"; // salt for pwd
						strRhevPassword = EgCrypt.encrypt(strRhevPassword); 
					}
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);
					strRhevPort = strTemp.substring(0,strTemp.indexOf("#"));
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);
					strRhevDomain = strTemp;

				}
				int userIdx = aListResultantTempInLowerCase.indexOf("-rhel_mgr_user");
				aResultant.remove(userIdx+1);
				aResultant.add(userIdx+1,strRhevUser);

				int pwdIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_password");
				aResultant.remove(pwdIndex+1);
				aResultant.add(pwdIndex+1,strRhevPassword);

				int portIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_port");
				aResultant.remove(portIndex+1);
				aResultant.add(portIndex+1,strRhevPort);

				int domainIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_domain");
				aResultant.remove(domainIndex+1);
				aResultant.add(domainIndex+1,strRhevDomain);
			}
		}
		////////RHEV - Code Ends

		////////EMC_XtremIO_4x- Code Starts
		if (aListResultantTempInLowerCase.contains("-xms_ip"))
		{
			emcXMSIPs = servicesIniFile.getVariables("EMC_XtremIO_4x");
			if (testName.equals(previousTestName))
			{
				String xmsIP = request.getParameter("xms_ip");
				if (xmsIP == null)
				{
					xmsIP = "none";
				}
	
				String strEmcIOUser = "";
				String strEmcIOPassword = "";
				String strSSL = "";
				if (xmsIP.equalsIgnoreCase("none"))
				{
					strEmcIOUser = "$unconfigured";
					strEmcIOPassword = "$unconfigured";
					strSSL = "false";
				}
				else
				{
					String strTemp = servicesIniFile.getValue("EMC_XtremIO_4x",xmsIP);
					strSSL = strTemp.substring(0,strTemp.indexOf("#"));
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);

					strEmcIOUser = strTemp.substring(0,strTemp.indexOf("#"));
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);

					strEmcIOPassword = strTemp.substring(0,strTemp.indexOf("#"));
					strEmcIOPassword = EgCrypt.decrypt(strEmcIOPassword);
					if (!aListTcKeywordsLowerCase.contains(strEmcIOPassword.toLowerCase()))
					{
						strEmcIOPassword += "~EG~"; // salt for pwd
						strEmcIOPassword = EgCrypt.encrypt(strEmcIOPassword); 
					}

				}
				int userIdx = aListResultantTempInLowerCase.indexOf("-XtremIO_user");
				aResultant.remove(userIdx+1);
				aResultant.add(userIdx+1,strEmcIOUser);

				int pwdIndex = aListResultantTempInLowerCase.indexOf("-XtremIO_password");
				aResultant.remove(pwdIndex+1);
				aResultant.add(pwdIndex+1,strEmcIOPassword);

				int sslIndex = aListResultantTempInLowerCase.indexOf("-ssl");
				aResultant.remove(sslIndex+1);
				aResultant.add(sslIndex+1,strSSL);
			}
		}
		////////EMC_XtremIO_4x - Code Ends

		//To do the following
		//1.Configure value for HMCs
		if (aListResultantTempInLowerCase.contains("-is_managed_by") && 
			aListResultantTempInLowerCase.contains("-management_server"))
		{
			hmcs = servicesIniFile.getVariables("HMC");
			isHMC = true;

			if (testName.equals(previousTestName))
			{
				String strIsManagedByChanged = request.getParameter("isManagedByChanged");
				if (strIsManagedByChanged == null)
				{
					String hmcMgmtServer = request.getParameter("management_server");
					if (hmcMgmtServer == null)
					{
						hmcMgmtServer = "none";
					}

					String strMgmtUser = "";
					String strMgmtPassword = "";
					if (hmcMgmtServer.equalsIgnoreCase("none"))
					{
						strMgmtUser = "$unconfigured";
						strMgmtPassword = "$unconfigured";
					}
					else
					{
						String strTemp = servicesIniFile.getValue("HMC",hmcMgmtServer);
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);

						strMgmtUser = strTemp.substring(0,strTemp.indexOf("#"));
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);

						strMgmtPassword = strTemp.substring(0,strTemp.indexOf("#"));
						strMgmtPassword = EgCrypt.decrypt(strMgmtPassword);
					}

					int managementUserIdx = aListResultantTempInLowerCase.indexOf("-management_user");
					aResultant.remove(managementUserIdx+1);
					aResultant.add(managementUserIdx+1,strMgmtUser);

					int managementPasswordIdx = aListResultantTempInLowerCase.indexOf("-management_password");
					aResultant.remove(managementPasswordIdx+1);
					aResultant.add(managementPasswordIdx+1,strMgmtPassword);
				}
				else
				{
					String tempManagedBy = request.getParameter("is_managed_by");
					if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("hmc"))
					{
						request.setAttribute("management_server","none");
						request.setAttribute("management_user","none");
						request.setAttribute("management_password","none");
					}
					else if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("ivm"))
					{
						request.setAttribute("management_server","$unconfigured");
						request.setAttribute("management_user","$unconfigured");
						request.setAttribute("management_password","$unconfigured");
					}
				}

				resIsManagedByValue = request.getParameter("is_managed_by");
			}
			else
			{
				int isManagedByIdx = aListResultantTempInLowerCase.indexOf("-is_managed_by");
				resIsManagedByValue = (String)aResultant.get(isManagedByIdx+1);
			}
		}

		// filter test period for BTM test starts here...
		IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
		Vector defaultTestPeriods = uiIni.getAllValues("TEST_FREQUENCY");

		boolean hasFilterTestPeriod = false;
		ArrayList filterTestPeriodList = new ArrayList();
		com.eg.IniFile egMgrMiscIni = new com.eg.IniFile (EgInstallInfo.getInstallDir()+"/manager/config/eg_mgrmisc.ini");
		String[] testPeriodTestVars = egMgrMiscIni.getVariables("Test_Period_Filter");
		String startTimePeriod = "";
		ArrayList testPeriodFinalList = new ArrayList();
		if (testPeriodTestVars != null && testPeriodTestVars.length > 0)
		{
			ArrayList testPeriodFilterTests = new ArrayList(Arrays.asList(testPeriodTestVars));
			if (testPeriodFilterTests != null && testPeriodFilterTests.contains(testName))
			{
				startTimePeriod = egMgrMiscIni.getValue("Test_Period_Filter",testName);

				if (!StringUtils.isNull(startTimePeriod) && defaultTestPeriods != null && defaultTestPeriods.size() > 0 && defaultTestPeriods.contains(startTimePeriod))
				{
					hasFilterTestPeriod = true;
					for (int t=0;t<defaultTestPeriods.size();t++)
					{
						String strTestPeriod = (String) defaultTestPeriods.get(t);
						if (startTimePeriod != null && startTimePeriod.equals(strTestPeriod))
						{
							break;
						}
						filterTestPeriodList.add(strTestPeriod);
					}
				}
			}
		}

		String[] testFormatPeriod = uiIni.getVariables("TEST_FREQUENCY");
		if (!EgUtils.isNull((Object)testFormatPeriod))
		{
			for (int i=0;i<testFormatPeriod.length;i++)
			{
				String prdStr = uiIni.getValue("TEST_FREQUENCY", testFormatPeriod[i]);
				if (hasFilterTestPeriod && filterTestPeriodList != null && filterTestPeriodList.contains(prdStr))
				{
					continue;
				}
				testPeriodFinalList.add(prdStr);
				long lngVal = Long.parseLong(prdStr);
				periodMap.put(new Long(lngVal), testFormatPeriod[i]);
			}
			
			if (testPeriodFinalList != null && !testPeriodFinalList.contains(testPeriod))
			{
				testPeriod = startTimePeriod;
			}
		}
		// filter test period for BTM test ends here...

		String pwdParamStartPlace = null;
		ArrayList pwdProfileList = pwdProf.getPwdProfiles();

		for (int i=0;i<aResultant.size();i++)
		{
			String strResult = aResultant.get(i).toString();
			aListResultantInLowerCase.add(strResult.toLowerCase());
		}

		if (pwdProfileList != null && pwdProfileList.size() > 0)
		{
			ArrayList specificParamSets = pwdProf.getSpecificParamSets(componentType);
			if (specificParamSets != null && specificParamSets.size() > 0)
			{
				int paramSize = specificParamSets.size();
				for (int p=0;p<paramSize;p++)
				{
					String pwdProfileParams = (String) specificParamSets.get(p);
					StringTokenizer st = new StringTokenizer(pwdProfileParams,",");
					int totalPwdParams = st.countTokens();
					int paramCnt = 0;
					ArrayList chkParamsIdx = new ArrayList();
					while(st.hasMoreTokens())
					{
						String token = (String) st.nextToken();
						int tokenIdx = aResultant.indexOf("-"+token);
						if (tokenIdx != -1)
						{
							paramCnt++;
						}
					}

					if (paramCnt == totalPwdParams)
					{
						isEnablePwdProfile = true;
						if (!com.egurkha.util.StringUtils.isNull(pwdProfileParams))
						{
							ArrayList tmpList = com.egurkha.util.StringUtils.egTokenizer(pwdProfileParams,",");
							tmpList = arrangeKeyAgentIniOrder(tmpList,aListResultantTempInLowerCase);
							pwdProfileParams = com.egurkha.util.StringUtils.getString(tmpList);
						}

						String startParamPosition = pwdProfileParams.substring(0,pwdProfileParams.indexOf(","));
						selectedParamsSet.put(startParamPosition,pwdProfileParams);
						if (hiddenObj.containsKey("pwdProfileParams"))
						{
							String existPwdParams = hiddenObj.get("pwdProfileParams").toString();
							if (!com.egurkha.util.StringUtils.isNull(existPwdParams))
							{
								StringTokenizer existPwdProf = new StringTokenizer(existPwdParams,",");
								int totalExistPwdParams = existPwdProf.countTokens();
								if (totalPwdParams > totalExistPwdParams)
								{
									pwdProfileParamList = StringUtils.egTokenizer(pwdProfileParams,",");
									rootJson.put("totalPwdParams",totalPwdParams);
									hiddenObj.put("pwdProfileParams",StringUtils.getString(pwdProfileParamList));
									continue;
								}
							}
						}
						else
						{
							pwdProfileParamList = StringUtils.egTokenizer(pwdProfileParams,",");
							rootJson.put("totalPwdParams",totalPwdParams);
							hiddenObj.put("pwdProfileParams",StringUtils.getString(pwdProfileParamList));
							//break;
						}
					}
				}
			}
		}
		rootJson.put("isEnablePwdProfile",isEnablePwdProfile);

		if (isEnablePwdProfile)
		{
			JSONArray pwdProfileArr = new JSONArray();
			JSONObject pwdProfileObj = new JSONObject();
			if (pwdProfileList.size() > 0)
			{
				pwdProfileObj.put("valueField","none");
				pwdProfileObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a password profile"));
				pwdProfileArr.add(pwdProfileObj);
			}
			else
			{
				pwdProfileObj.put("valueField","none");
				pwdProfileObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
				pwdProfileArr.add(pwdProfileObj);
			}

			JSONObject pwdProfileIniVal = new JSONObject();
			Collections.sort(pwdProfileList,String.CASE_INSENSITIVE_ORDER);
			for (int p=0; p<pwdProfileList.size(); p++)
			{
				String actualname = (String) pwdProfileList.get(p);
				String profileValue = pwdProfileIni.getValue("Password_Profiles",actualname);
				if (!com.egurkha.util.StringUtils.isNull(profileValue)) 
				{
					String profUserName = null;
					String profPwd = null;
					String profDomName = null;


					if ( profileValue.indexOf("|") != -1)
					{
						ArrayList multiEntryProfile = StringUtils.egTokenizer(profileValue,"|");
						int tokens = multiEntryProfile.size();
						if (multiEntryProfile != null && multiEntryProfile.size() > 0)
						{
							ArrayList tmpProfValList = new ArrayList();
							for (int m=0;m<multiEntryProfile.size();m++)
							{
								String strValue = (String) multiEntryProfile.get(m);
								if (com.egurkha.util.StringUtils.isNull(strValue))
								{
									continue;
								}

								ArrayList profileDatas = StringUtils.egTokenizer(strValue,"~Hash~");
								int toknsSize = profileDatas.size();
								if (!StringUtils.isNull(profUserName))
								{
									profUserName = profUserName +","+ profileDatas.get(0).toString();
								}
								else
								{
									profUserName = profileDatas.get(0).toString();
								}
								String password = "none";
								String domainName = "none";
								
								if (toknsSize > 1)
								{
									password = EgCrypt.decrypt(profileDatas.get(1).toString());
									if (!aListTcKeywordsLowerCase.contains(password.toLowerCase()))
									{
										password += "~EG~"; 
										password = EgCrypt.encrypt(password); 
									}
								}

								if (!StringUtils.isNull(profPwd))
								{
									profPwd = profPwd +"#~#"+ password;
								}
								else
								{
									profPwd = password;
								}

								if (toknsSize > 2)
								{
									domainName = profileDatas.get(2).toString();
								}

								if (!StringUtils.isNull(profDomName))
								{
									profDomName = profDomName +","+ domainName;
								}
								else
								{
									profDomName = domainName;
								}
							}
							profileValue = profUserName+"~Hash~"+profPwd+"~Hash~"+profDomName;
						}
					}
					else
					{
						ArrayList profileEntry = StringUtils.egTokenizer(profileValue,"~Hash~");
						int toknsSize = profileEntry.size();
						profUserName = profileEntry.get(0).toString();
						profPwd = "none";
						profDomName = "none";
						// A profile may not have all 3(user name, pwd, domain) values
						if (toknsSize > 1)
						{
							profPwd = EgCrypt.decrypt(profileEntry.get(1).toString());
							if (!aListTcKeywordsLowerCase.contains(profPwd.toLowerCase()))
							{
								profPwd += "~EG~"; 
								profPwd = EgCrypt.encrypt(profPwd); 
							}
						}
						if (toknsSize > 2)
						{
							profDomName = profileEntry.get(2).toString();
						}

						profileValue = profUserName+"~Hash~"+profPwd+"~Hash~"+profDomName;
					}

					pwdProfileIniVal.put(actualname,profileValue);
				}
				pwdProfileObj.put("valueField",actualname);
				pwdProfileObj.put("displayField",actualname);
				pwdProfileArr.add(pwdProfileObj);
			}

			rootJson.put("pwdProfileArr",pwdProfileArr);
			rootJson.put("pwdProfileIniVal",pwdProfileIniVal);

			String pwdProfport = "";
			if (componentType.equals("Oracle_server"))
			{
				pwdProfport = "$portNo:$sid";
			}
			else
			{
				pwdProfport = "$portNo";
			}

			String testSpecPatternA = testName + ":" + componentType + ":" + "$hostName" + ":" + pwdProfport;
			String testSpecPatternB = testName + ":" + componentType + ":" + "$hostName";
			String testSpecPatternC = testName + "::" + "$hostName" + ":" + pwdProfport;
			String testSpecPatternD = testName + "::" + "$hostName";

			if (selectedParamsSet != null)
			{
				Set paramSetKeysSet = selectedParamsSet.keySet();
				ArrayList paramSetKeys = new ArrayList();
				paramSetKeys.addAll(paramSetKeysSet);

				if (paramSetKeys != null && paramSetKeys.size() > 1)
				{
					paramSetKeys = arrangeKeyAgentIniOrder(paramSetKeys,aListResultantTempInLowerCase);
				}

				ArrayList updatedParamList = new ArrayList(aListResultantTempInLowerCase);
				ArrayList strHiddenProfileList = getHiddenPwdProfile(updatedParamList);
				String strHiddenProfileParam = "";
				String strHiddenProfile = "";
				JSONArray pwdProfileSelectedList = new JSONArray();
				JSONArray pwdProfileAllList = new JSONArray();
				JSONObject pwdProfileProperties = new JSONObject();
				if (paramSetKeys.size() == 1)
				{
					if (strHiddenProfileList != null && strHiddenProfileList.size() > 0)
					{
						strHiddenProfileParam = strHiddenProfileList.get(0).toString();
						strHiddenProfile = strHiddenProfileList.get(1).toString();
					}

					String strFirstParamOfSet = paramSetKeys.get(0).toString();
					String strSelectedParamSet = (String) selectedParamsSet.get(strFirstParamOfSet);
					int pwdProfBeforeParamIdx = updatedParamList.indexOf("-"+strFirstParamOfSet.toLowerCase());
					String findPosition = null;
					if (pwdProfBeforeParamIdx != -1)
					{
						findPosition = (String)aResultant.get(pwdProfBeforeParamIdx);
					}

					boolean isSpecificProfSet = false;
					boolean isDefaultProfSet = false;
					String mergeString = componentType+"#^#"+strSelectedParamSet;
					String defaultMergeStr = componentType+"#^#"+strSelectedParamSet;
					if (findPosition != null)
					{
						String strPwdProfKey = "-password_profile"+0;
						int tempPositionIdx = aResultant.indexOf(findPosition);
						aResultant.add(tempPositionIdx,strPwdProfKey);
						aResultant.add(tempPositionIdx+1,"none");
						aResultant.add(tempPositionIdx+2,"select");

						pwdParamSetList.put(strPwdProfKey.substring(1),strSelectedParamSet);
						String strGetProfValue = pwdProf.getProfNameForSpecificConfiguration(mergeString,testName);
						if (StringUtils.isNull(strGetProfValue))
						{
							strGetProfValue = pwdProf.getProfNameForDefaultConfiguration(defaultMergeStr,testName);
						}
						
						ArrayList pwdProfileParamSetList = StringUtils.egTokenizer(strSelectedParamSet,",");
						rootJson.put("password_profile"+0+"_totalPwdParams",pwdProfileParamSetList.size());
						if(!StringUtils.isNull(strGetProfValue) && !strGetProfValue.equals("none"))
						{
							ArrayList selectProfList = pwdProf.getProfileMultiValues(strGetProfValue);
							if (selectProfList != null && selectProfList.size() > 0)
							{
								for(int s=0;s< pwdProfileParamSetList.size();s++)
								{
									String profileUsingParamName = pwdProfileParamSetList.get(s).toString();
									String profileUsingParamValue = "";
									if (!StringUtils.isNull(profileUsingParamName))
									{
										if(checkParamIsUserField(profileUsingParamName))
										{
											profileUsingParamValue = selectProfList.get(0).toString();
										}
										else if(checkParamIsPasswordField(profileUsingParamName))
										{
											profileUsingParamValue = selectProfList.get(1).toString();
										}
										else if(checkParamIsDomainField(profileUsingParamName))
										{
											profileUsingParamValue = selectProfList.get(2).toString();
										}
									}

									if (!StringUtils.isNull(profileUsingParamName))
									{
										pwdProfileParamMap.put(profileUsingParamName,profileUsingParamValue);
									}
								}
							}
						}

						if (!StringUtils.isNull(strHiddenProfile))
						{
							if (strHiddenProfile.equals(strFirstParamOfSet))
							{
								pwdProfileSelectedList.add(strPwdProfKey.substring(1));
								pwdProfileProperties.put(strPwdProfKey.substring(1)+"_isShow",true);
							}
							else
							{
								pwdProfileAllList.add(strPwdProfKey.substring(1));
								pwdProfileProperties.put(strPwdProfKey.substring(1)+"_isShow",false);
							}
						}
						
						JSONArray paramsArray = new JSONArray();
						for(int a=0;a< pwdProfileParamSetList.size();a++)
						{
							String strParams = (String) pwdProfileParamSetList.get(a);
							JSONObject paramsObj = new JSONObject();
							paramsObj.put("profileParams"+a,strParams);
							paramsArray.add(paramsObj);
						}
						rootJson.put("password_profile"+0+"_paramsArray",paramsArray);

						updatedParamList = getUpdatedResultantListInLowercase(aResultant);
					}
				}
				else
				{
					if (strHiddenProfileList != null && strHiddenProfileList.size() > 0)
					{
						strHiddenProfileParam = strHiddenProfileList.get(0).toString();
						strHiddenProfile = strHiddenProfileList.get(1).toString();
					}

					for (int key=0;key<paramSetKeys.size();key++)
					{
						String strFirstParamOfSet = paramSetKeys.get(key).toString();
						String strSelectedParamSet = (String) selectedParamsSet.get(strFirstParamOfSet);
						int pwdProfBeforeParamIdx = updatedParamList.indexOf("-"+strFirstParamOfSet.toLowerCase());

						String findPosition = null;
						if (pwdProfBeforeParamIdx != -1)
						{
							findPosition = (String)aResultant.get(pwdProfBeforeParamIdx);
						}

						boolean isSpecificProfSet = false;
						boolean isDefaultProfSet = false;

						String mergeString = componentType+"#^#"+strSelectedParamSet;
						String defaultMergeStr = componentType+"#^#"+strSelectedParamSet;
						if (findPosition != null)
						{
							String strPwdProfKey = "-password_profile"+key;
							int tempPositionIdx = aResultant.indexOf(findPosition);
							aResultant.add(tempPositionIdx,strPwdProfKey);
							aResultant.add(tempPositionIdx+1,"none");
							aResultant.add(tempPositionIdx+2,"select");

							pwdParamSetList.put(strPwdProfKey.substring(1),strSelectedParamSet);
							String strGetProfValue = pwdProf.getProfNameForSpecificConfiguration(mergeString,testName);
							if (StringUtils.isNull(strGetProfValue))
							{
								strGetProfValue = pwdProf.getProfNameForDefaultConfiguration(defaultMergeStr,testName);
							}

							if (!StringUtils.isNull(strHiddenProfile))
							{
								if (strHiddenProfile.equals(strFirstParamOfSet))
								{
									pwdProfileSelectedList.add(strPwdProfKey.substring(1));
									pwdProfileProperties.put(strPwdProfKey.substring(1)+"_isShow",true);
								}
								else
								{
									pwdProfileAllList.add(strPwdProfKey.substring(1));
									pwdProfileProperties.put(strPwdProfKey.substring(1)+"_isShow",false);
								}
							}

							ArrayList pwdProfileParamSetList = StringUtils.egTokenizer(strSelectedParamSet,",");
							rootJson.put("password_profile"+key+"_totalPwdParams",pwdProfileParamSetList.size());
							if(!StringUtils.isNull(strGetProfValue) && !strGetProfValue.equals("none"))
							{
								ArrayList selectProfList = pwdProf.getProfileMultiValues(strGetProfValue);
								if (selectProfList != null && selectProfList.size() > 0)
								{
									for(int s=0;s< pwdProfileParamSetList.size();s++)
									{
										String profileUsingParamName = pwdProfileParamSetList.get(s).toString();
										String profileUsingParamValue = "";
										if (!StringUtils.isNull(profileUsingParamName))
										{
											if(checkParamIsUserField(profileUsingParamName))
											{
												profileUsingParamValue = selectProfList.get(0).toString();
											}
											else if(checkParamIsPasswordField(profileUsingParamName))
											{
												profileUsingParamValue = selectProfList.get(1).toString();
											}
											else if(checkParamIsDomainField(profileUsingParamName))
											{
												profileUsingParamValue = selectProfList.get(2).toString();
											}
										}

										if (!StringUtils.isNull(profileUsingParamName))
										{
											pwdProfileParamMap.put(profileUsingParamName,profileUsingParamValue);
										}
									}
								}
							}

							JSONArray paramsArray = new JSONArray();
							for(int a=0;a< pwdProfileParamSetList.size();a++)
							{
								String strParams = (String) pwdProfileParamSetList.get(a);
								JSONObject paramsObj = new JSONObject();
								paramsObj.put("profileParams"+a,strParams);
								paramsArray.add(paramsObj);
							}

							rootJson.put("password_profile"+key+"_paramsArray",paramsArray);
							updatedParamList = getUpdatedResultantListInLowercase(aResultant);
						}
					}
				}

				if (!StringUtils.isNull(strHiddenProfileParam))
				{
					if (strHiddenProfileParam.endsWith("true"))
					{
						rootJson.put("showPwdParams",pwdProfileSelectedList);
						rootJson.put("hidePwdParams",pwdProfileAllList);
					}
					else
					{
						rootJson.put("showPwdParams",pwdProfileAllList);
						rootJson.put("hidePwdParams",pwdProfileSelectedList);
					}

				}
				rootJson.put("pwdProfileProperties",pwdProfileProperties);
				rootJson.put("pwdParamSetList",pwdParamSetList);
				session.setAttribute("pwdParamSetList",pwdParamSetList);
				aListResultantTempInLowerCase = new ArrayList(updatedParamList);
			}
		}

		ArrayList aListDesktopInfrastructures = usersInfo.getAllUserBasedCompTypes();
		if (userBasedLicense && aListDesktopInfrastructures != null && aListDesktopInfrastructures.contains(componentType))
		{
			viewAccessOnly = true;
		}
		rootJson.put("viewAccessOnly",viewAccessOnly);

		// for system property params works - starts...
		String systemPropTest = testsIni.getValue("SYSTEM_PROPERTY_PARAM_TESTS",testName);
		if (!StringUtils.isNull(systemPropTest) && systemPropTest.equalsIgnoreCase("true"))
		{
			isSystemPropertyParamTests = true;
		}
		rootJson.put("isSystemPropertyParamTests",isSystemPropertyParamTests);
		// for system property params works - ends...
	}

	//tell whether _cf test enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}
	rootJson.put("isConfigSupported",isConfigSupported);

	if (isConfigSupported)
	{
		if (componentType!=null && !componentType.equals("") && !componentType.equals("-1"))
		{
			String tempLbl = null;
			if (testType.equalsIgnoreCase("PerformanceTest"))
			{
				tempLbl = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'>&nbsp;</a><span>"+_mapping.getTextDescription("admin.test.to enable and disable performance tests for ")+"&nbsp;"+_mapping.getComponentTypeDescription(componentType)+"</span> </td></tr></table>";
			}
			else
			{
				tempLbl = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'>&nbsp;</a><span>"+_mapping.getTextDescription("admin.test.to enable and disable configuration tests for ")+"&nbsp;"+_mapping.getComponentTypeDescription(componentType)+"</span> </td></tr></table>";
			}
			String edUrl = "EgEnableDisableTests.jsp?componentType="+componentType+"&testType="+testType+"&showBackButton=true&from=DefaultTestConfig"; 
			rootJson.put("enableDisableTestPageLink",edUrl);
			rootJson.put("enableDisableTestPageLabel",tempLbl);
		}
		else
		{
			String tempLbl = null;
			if (testType.equalsIgnoreCase("PerformanceTest"))
			{
				tempLbl = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'>&nbsp;</a><span>"+_mapping.getTextDescription("admin.test.to enable and disable performance tests")+"</span> </td></tr></table>";
			}
			else
			{
				tempLbl = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'>&nbsp;</a><span>"+_mapping.getTextDescription("admin.test.to enable and disable configuration tests")+"</span> </td></tr></table>";
			}
			String edUrl = "EgEnableDisableTests.jsp?showBackButton=true&from=DefaultTestConfig"; 
			rootJson.put("enableDisableTestPageLink",edUrl);
			rootJson.put("enableDisableTestPageLabel",tempLbl);
		}

		JSONObject compTypeObj = new JSONObject();
		JSONArray compTypeArr = new JSONArray();
		if (listComponentTypes.size() > 0)
		{
			compTypeObj.put("valueField","-1");
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a component type"));
			compTypeArr.add(compTypeObj);
		}
		else
		{
			compTypeObj.put("valueField","-1");
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			compTypeArr.add(compTypeObj);
		}

		//EgName class is used to hold name and its localised name.
		for (int j=0; j<listComponentTypes.size(); j++)
		{
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			compTypeObj.put("valueField",actualname);
			compTypeObj.put("displayField",localname);
			compTypeArr.add(compTypeObj);

			if (actualname.equals(componentType))
			{
				selectedCompType = localname;
				rootJson.put("selectedCompType",actualname);
			}
		}
		rootJson.put("compTypeArr",compTypeArr);

		JSONObject testTypeObj = new JSONObject();
		JSONArray testTypeArr = new JSONArray();
		testTypeObj.put("valueField","PerformanceTest");
		testTypeObj.put("displayField",_mapping.getTextDescription("admin.server.Performance"));
		testTypeArr.add(testTypeObj);
		testTypeObj.put("valueField","ConfigurationTest");
		testTypeObj.put("displayField",_mapping.getTextDescription("admin.server.Configuration"));
		testTypeArr.add(testTypeObj);
		if (!StringUtils.isNull(pfSelected) && pfSelected.equals("selected"))
		{
			rootJson.put("selectedTestType","PerformanceTest");
		}
		else
		{
			rootJson.put("selectedTestType","ConfigurationTest");
		}
		rootJson.put("testTypeArr",testTypeArr);

		JSONObject testNameObj = new JSONObject();
		JSONArray testNameArr = new JSONArray();

		if (aListEnabledTestForCompType.size() > 0)
		{
			testNameObj.put("valueField","-1");
			testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a test name"));
			testNameArr.add(testNameObj);
		}
		else
		{
			testNameObj.put("valueField","-1");
			testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			testNameArr.add(testNameObj);
		}

		for (int i=0; i<aListEnabledTestForCompType.size(); i++)
		{
			EgName nameObj = (EgName)aListEnabledTestForCompType.get(i);
			String strTestName = nameObj.getActualName();
			String strTestDisplayValue = nameObj.getLocalName();
			testNameObj.put("valueField",strTestName);
			testNameObj.put("displayField",strTestDisplayValue);
			testNameArr.add(testNameObj);
			if (testName != null && strTestName.equals(testName))
			{
				rootJson.put("selectedTestName",strTestName);
			}
		}
		rootJson.put("testNameArr",testNameArr);
	}
	else
	{
		JSONObject compTypeObj = new JSONObject();
		JSONArray compTypeArr = new JSONArray();

		if (listComponentTypes.size() > 0)
		{
			compTypeObj.put("valueField","-1");
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Choose one"));
			compTypeArr.add(compTypeObj);
		}
		else
		{
			compTypeObj.put("valueField","-1");
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			compTypeArr.add(compTypeObj);
		}

		//EgName class is used to hold name and its localised name.
		for (int j=0; j<listComponentTypes.size(); j++)
		{
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			compTypeObj.put("valueField",actualname);
			compTypeObj.put("displayField",localname);
			compTypeArr.add(compTypeObj);

			if (actualname.equals(componentType))
			{
				selectedCompType = localname;
				rootJson.put("selectedCompType",actualname);
			}
		}
		rootJson.put("compTypeArr",compTypeArr);

		JSONObject testNameObj = new JSONObject();
		JSONArray testNameArr = new JSONArray();

		if (aListEnabledTestForCompType.size() > 0)
		{
			testNameObj.put("valueField","-1");
			testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Choose one"));
			testNameArr.add(testNameObj);
		}
		else
		{
			testNameObj.put("valueField","-1");
			testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			testNameArr.add(testNameObj);
		}

		for (int i=0; i<aListEnabledTestForCompType.size(); i++)
		{
			EgName nameObj = (EgName)aListEnabledTestForCompType.get(i);
			String strTestName = nameObj.getActualName();
			String strTestDisplayValue = nameObj.getLocalName();
			testNameObj.put("valueField",strTestName);
			testNameObj.put("displayField",strTestDisplayValue);
			testNameArr.add(testNameObj);
			if (testName != null && strTestName.equals(testName))
			{
				rootJson.put("selectedTestName",strTestName);
			}
		}
		rootJson.put("testNameArr",testNameArr);
	}

	if (!componentType.equals("") && !componentType.equals("-1") && 
		!testName.equals("") && !testName.equals("-1") && 
		!testType.equals(""))
	{
		boolean isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);

		if (listMultipleUserSupportTest != null && 
			listMultipleUserSupportTest.contains(testName))
		{
			multiUserMode = true;
			rootJson.put("multiUserMode",multiUserMode);
			String tempLabel = "<table width='100%' height='5px' class='font_normal11'><tr><td  align='left' valign='bottom'>"+_mapping.getTextDescription("admin.test.To configure users for this test")+"<a href='javascript:void(0)' onclick='me.clickToExternalPage();'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/icon_click.png' border='0'></a></td></tr></table>";
			String strMultiUserLink = "./VmgUsers.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname=,";
			rootJson.put("vmgUsersPage","true");
			rootJson.put("externalPageLink",strMultiUserLink);
			rootJson.put("externalPageLabel",tempLabel);
			rootJson.put("viewExternalLink",true);
		}
		else if (testName.equalsIgnoreCase("SlowTransTest"))
		{
			multiNamePatternMode = true;
			rootJson.put("multiNamePatternMode",multiNamePatternMode);
			String strUrlPatternLink = "./EgConfigureNamePattern.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname=,'','scrollbars=yes,width=900,height=380,top=150,left=50";
			rootJson.put("externalPageLink",strUrlPatternLink);
			String tempLabel = "<table width='100%' height='5px' class='font_normal11'><tr><td  align='left' valign='bottom'>"+_mapping.getTextDescription("admin.test.To configure url patterns for this test")+"<a href='javascript:void(0)' onclick='me.clickToExternalPage();'><span>Click here</b>&nbsp;<img src='/final/images/icon_click.png' border='0'></a></td></tr></table>";
			rootJson.put("configurenamePattern","true");
			rootJson.put("externalPageLabel",tempLabel);
			rootJson.put("viewExternalLink",true);
		}
		else if (testName.equalsIgnoreCase("CtxAuthTest") || 
				testName.equalsIgnoreCase("WinAuthTest") || 
				testName.equalsIgnoreCase("TermAuthTest"))
		{
			multiUserMode = true;
			rootJson.put("multiUserMode",multiUserMode);
			String strUserConfigLink = "./EgConfigureMultipleUsers.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname=,'','scrollbars=yes,width=900,height=380,top=150,left=50";
			rootJson.put("externalPageLink",strUserConfigLink);
			String tempLabel = "<table width='100%' height='5px' class='font_normal11'><tr><td  align='left' valign='bottom'>"+_mapping.getTextDescription("admin.test.To configure users for this test")+"<a href='javascript:void(0)' onclick='me.clickToExternalPage();'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/icon_click.png' border='0'></a></td></tr></table>";
			rootJson.put("externalPageLabel",tempLabel);
			rootJson.put("viewExternalLink",true);

		}
		else if (isPolicyParamExists)
		{
			int logTypeIdx = aListResultantInLowerCase.indexOf("-logtype");
			String logTypeVal = (String)aResultant.get(logTypeIdx+1);
			int policyFilterIdx = aListResultantInLowerCase.indexOf("-policyfilter");
			String policyFilterVal = (String)aResultant.get(policyFilterIdx+1);

			if ((policyFilterVal.equalsIgnoreCase("true") && tPolicyFilter.length() == 0) || tPolicyFilter.equalsIgnoreCase("true"))
			{
				rootJson.put("viewExternalLink",true);
			}
			else
			{
				rootJson.put("viewExternalLink",false);
			}
			String strPolicyLink = "DefaultTestConfiguration/data/ViewPolicyJson.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&showAll=no&logtype="+logTypeVal+"&requestFrom=EgConfigureDefaultTestParams.jsp&testType="+testType;
			rootJson.put("externalPageLink",strPolicyLink);
			String tempLabel = "<table width='100%' height='5px'><tr><td  align='left' valign='bottom'>"+_mapping.getTextDescription("admin.test.To add/modify Policy")+"<a href='javascript:void(0)' onclick='me.clickToExternalPage();'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/icon_click.png' border='0'></a></td></tr></table>";
			rootJson.put("externalPageLabel",tempLabel);
		}
		else if (isUrlParamExist && isCredentialParamExist)
		{
			rootJson.put("isPrivateKeyParamExist",isPrivateKeyParamExist);
			String strViewUrlCredentialLink = "./EgConfigureUrlAndCredentials.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&isPrivateKeyParamExist="+isPrivateKeyParamExist+"&isSystemPropKeyParamExist="+isSystemPropKeyParamExist+",'','scrollbars=yes,width=900,height=380,top=150,left=50";
			rootJson.put("externalPageLink",strViewUrlCredentialLink);
			String tempLabel = "<table width='100%' height='5px'><tr><td  align='left' valign='bottom'>"+_mapping.getTextDescription("admin.test.To view/configure URL and credentials for this test")+"<a href='javascript:void(0)' onclick='me.clickToExternalPage();'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/icon_click.png' border='0'></a></td></tr></table>";
			rootJson.put("externalPageLabel",tempLabel);
			rootJson.put("configurlcredentials","true");
			rootJson.put("viewExternalLink",true);
		}

		String paramsTestTitle = _mapping.getTextDescription("admin.test.Parameters to be configured for")+"&nbsp;"+_mapping.getTestDescription(testName);
		if (isPortRelevantForTest)
		{
			paramsTestTitle += "&nbsp;of&nbsp;"+_mapping.getComponentTypeDescription(componentType);
		}

		rootJson.put("multiUserMode",multiUserMode);
		rootJson.put("multiNamePatternMode",multiNamePatternMode);
		rootJson.put("configuredTestTitle",paramsTestTitle);
		rootJson.put("testPeriodLabel",_mapping.getTextDescription("admin.test.TEST PERIOD"));

		JSONArray testPeriodArr = new JSONArray();
		JSONObject testPeriodObj = new JSONObject();

		//testPeriod
		String testPeriodVal = "";
		if (testName.equals(previousTestName))
		{
			testPeriodVal = request.getParameter("testPeriod");
			testPeriodVal = (testPeriodVal != null)?testPeriodVal:"";
		}

		Iterator itr = periodMap.keySet().iterator();
		boolean b = true;
		for (int i=0; i<periodMap.size(); i++)
		{
			Long lngperiod = (Long)itr.next();
			String periodVal = lngperiod.toString();
			String periodStr = (String)periodMap.get(lngperiod);
			testPeriodObj.put("displayField",periodStr);
			testPeriodObj.put("valueField",periodVal);
			testPeriodArr.add(testPeriodObj);
			if (periodVal.equals(testPeriodVal))
			{
				b = false;
				rootJson.put("selectedTimePeriod",testPeriodVal);

			}
			else if (periodVal.equals(testPeriod) && b)
			{
				rootJson.put("selectedTimePeriod",testPeriod);
			}
		}
		rootJson.put("testPeriodArr",testPeriodArr);

		String tempSnmpVersion = "";
		boolean hasMultipleUsers = false;
		boolean hasMultipleNames = false;
		boolean isCompTypeOracleClusterService = componentType.equals("Oracle_cluster_service");
		String testInfoDelimiter = egSpecs.getTestInfoDelimiter(testName);
		if (testInfoDelimiter.trim().length() == 0)
		{
			testInfoDelimiter = "#";
		}
		strDelimiter = testInfoDelimiter;
		IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
		arrDelimiterMasks = testsIni.getVariables("TEST_INFO_DELIMITER_MASK");
		List delimiterMasksList = new ArrayList();
		if (arrDelimiterMasks != null &&  arrDelimiterMasks.length > 0)
		{
			delimiterMasksList = new ArrayList(Arrays.asList(arrDelimiterMasks));
		}
		if (strDelimiterMask.trim().length() == 0)
		{
			strDelimiterMask = "0egHash1";
		}

		rootJson.put("isExecutionTimeParam",false);
		String straResultant = getString(aResultant);
		rootJson.put("aResultant",straResultant);
		JSONObject paramNameObj = new JSONObject();
		for (int i=0;i<aResultant.size();i=i+3)
		{
			String paramName = (String)aResultant.get(i);
			aListParamNamesValues.add(paramName);
			paramName = paramName.substring(1).trim();
			if(delimiterMasksList.contains(testName+":"+paramName+":"+testInfoDelimiter))
			{
				strDelimiterMask = testsIni.getValue("TEST_INFO_DELIMITER_MASK",testName+":"+paramName+":"+testInfoDelimiter);
			}
			String paramValue = (String)aResultant.get(i+1);
			String displayControl = (String)aResultant.get(i+2);
			displayControl = displayControl.trim();
			//if (aListParamsWithDoubleQuotes != null && 
			//	!aListParamsWithDoubleQuotes.contains(paramName.toLowerCase()) && !displayControl.equalsIgnoreCase("password"))
			if (!displayControl.equalsIgnoreCase("password"))
			{
				paramValue = paramValue.trim();

				if (paramValue.startsWith("\"") && paramValue.endsWith("\""))
				{
					paramValue = paramValue.substring(1,paramValue.length()-1);
				}
			}
			aListParamNamesValues.add(paramValue);

			//if(componentType.equals("Client_desktop") && (testName.equals("ClientServiceTest") || testName.equals("ClientTcpTest")))
			//{
				//if(paramName.equalsIgnoreCase("adapter_device_selection") || paramName.equalsIgnoreCase("device_name") || paramName.equalsIgnoreCase("device_id"))
				//{
					//continue;
				//}
			//}

			int elementIdx = Arrays.binarySearch(paramToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
			if (elementIdx > -1) continue;

			//parameter value comes only for component type called "web" for the parameter "site"
			if (paramValue.equalsIgnoreCase("noteditable")) continue;

			//hide the parameter info
			if (!isCompTypeOracleClusterService && paramName.equalsIgnoreCase("info"))
			{
				continue;
			}

			//if (isCorrectParamExist && !isCorrectiveScriptEnabled)
			//{
				//if (paramName.equalsIgnoreCase("alarmtype") || 
					//paramName.equalsIgnoreCase("userparams") || 
					//paramName.equalsIgnoreCase("correctivescript"))
				//{
					//continue;
				//}
			//}

			if (isSnmp)
			{
				//hiding some parameters to the ui for snmpV1 and snmpV2 only.
				//int snmpParamIdx = Arrays.binarySearch(snmpV1V2ParamToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				//if (snmpVer.length() == 0)
				//{
					//if (isSnmpV1V2)
					//{
						//if (snmpParamIdx > -1) continue;
					//}
				//}
				//else if(snmpVer.equals("v1") || snmpVer.equals("v2"))
				//{
					//if (snmpParamIdx > -1) continue;
				//}

				////for snmpV3
				//if (paramName.equalsIgnoreCase("snmpversion"))
				//{
					//tempSnmpVersion = paramValue;
				//}

				//if (paramName.equalsIgnoreCase("snmpcommunity"))
				//{
					//if (snmpVer.length() == 0)
					//{
						//if (tempSnmpVersion.equalsIgnoreCase("v3")) continue;
					//}
					//else
					//{
						//if (snmpVer.equalsIgnoreCase("v3")) continue;
					//}
				//}

				////in snmpV3 hiding encrypt type and encrypt password when its value is false.
				//int snmpV3ParamIdx = Arrays.binarySearch(snmpV3ParamToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				//if (!isSnmpV1V2)
				//{
					//if (encryptFlag.length() == 0)
					//{
						//if (encryptValue.equalsIgnoreCase("false"))
						//{
							//if (snmpV3ParamIdx > -1) continue;
						//}
					//}
					//else if(encryptFlag.equalsIgnoreCase("false"))
					//{
						//if (snmpV3ParamIdx > -1) continue;
					//}
				//}

				if (isModeParamExist)
				{
					//int modeIdx = aListResultantInLowerCase.indexOf("-mode");
					//String modeValue = ((String)aResultant.get(modeIdx+1)).trim();

					//if (testName.equals(previousTestName))
					//{
						//String requestModeValue = request.getParameter(((String)aResultant.get(modeIdx)).substring(1));
						//requestModeValue = (requestModeValue==null)?"":requestModeValue;
						//if (!requestModeValue.equals("")) modeValue = requestModeValue;
					//}

					//if (modeValue.equalsIgnoreCase("true"))
					//{
						//int modeTrueParamIdx = Arrays.binarySearch(modeTrueToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
						//if (modeTrueParamIdx > -1) continue;
					//}
					//else
					//{
						//int modeFalseParamIdx = Arrays.binarySearch(modeFalseToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
						//if (modeFalseParamIdx > -1) continue;
					//}

					//int profilerIdx = aListResultantInLowerCase.indexOf("-profiler");
					//if (profilerIdx > -1)
					//{
						//String profilerValue = ((String)aResultant.get(profilerIdx+1)).trim();
						//if (testName.equals(previousTestName))
						//{
							//String requestProfilerValue = request.getParameter(((String)aResultant.get(profilerIdx)).substring(1));
							//requestProfilerValue = (requestProfilerValue==null)?"":requestProfilerValue;
							//if (!requestProfilerValue.equals("")) profilerValue = requestProfilerValue;
						//}

						//if (paramName.equalsIgnoreCase("profiler_home") && 
							//profilerValue.equalsIgnoreCase("false"))
						//{
							//continue;
						//}
					//}

					//int heapAnalysisIdx = aListResultantInLowerCase.indexOf("-heap_analysis");
					//if (heapAnalysisIdx > -1)
					//{
						//String heapAnalysisValue = ((String)aResultant.get(heapAnalysisIdx+1)).trim();

						//String requestHeapAnalysisValue = "";
						//if (testName.equals(previousTestName))
						//{
							//requestHeapAnalysisValue = request.getParameter(((String)aResultant.get(heapAnalysisIdx)).substring(1));
							//requestHeapAnalysisValue = (requestHeapAnalysisValue == null)?"":requestHeapAnalysisValue;
						//}

						//if (!requestHeapAnalysisValue.equals("")) 
						//{
							//heapAnalysisValue = requestHeapAnalysisValue;
						//}

						//if ((paramName.equalsIgnoreCase("java_home") ||  
							 //paramName.equalsIgnoreCase("include_packages") || 
							 //paramName.equalsIgnoreCase("exclude_packages")) && 
							//heapAnalysisValue.equalsIgnoreCase("false"))
						//{
							//continue;
						//}
					//}
				}
			}
			//For virtual center component type only
			/*if(componentType.equals("Virtual_center") && paramName.equalsIgnoreCase("hosted_vm_type"))
			{
				continue;
			}*/

			int readOnlyParamIdx = Arrays.binarySearch(multiUserReadOnlyParam,paramName,String.CASE_INSENSITIVE_ORDER);
			if(readOnlyParamIdx <= -1)
			{
				readOnlyParamIdx = Arrays.binarySearch(multiNameReadOnlyParam,paramName,String.CASE_INSENSITIVE_ORDER);
			}

			if (readOnlyParamIdx > -1)
			{
				if (paramName.equalsIgnoreCase("domain") || 
					paramName.equalsIgnoreCase("user") || 
					paramName.equalsIgnoreCase("admin_user") ||
					paramName.equalsIgnoreCase("published_resources"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						hasMultipleUsers = true;
					}
				}
				else if (paramName.equalsIgnoreCase("name") || 
					paramName.equalsIgnoreCase("pattern") || 
					paramName.equalsIgnoreCase("threshold_value"))
					{
						if (paramValue.indexOf("|") > -1)
						{
							hasMultipleNames = true;
						}
					}
			}

			//if (hasShowAliasParam)
			//{
				//if (paramName.equalsIgnoreCase("show_alias_and_interface_name") && useAliasValue.equalsIgnoreCase("false"))
				//{
					//continue;
				//}
			//}

			//if (hasShowAllOnlyParam)
			//{
				//if (paramName.equalsIgnoreCase("showAllOnly") && showAllEventsValue.equalsIgnoreCase("false"))
				//{
					//continue;
				//}
			//}

			//if (hasReportOnlyTotalParam)
			//{
				//if (paramName.equalsIgnoreCase("Report_only_total") && reportTotalValue.equalsIgnoreCase("false"))
				//{
					//continue;
				//}
			//}

			if (paramName.equalsIgnoreCase("credentials"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aUrlCredentialVal.size();k=k+3)
				{
					if (k >= 3)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aUrlCredentialVal.get(k+1));
					strBuffer.append(":");
					strBuffer.append(aUrlCredentialVal.get(k+2));
				}
				hiddenObj.put(paramName,strBuffer.toString());

				continue;
			}

			if (paramName.equalsIgnoreCase("content"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListContentValues.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListContentValues.get(k));
				}
				hiddenObj.put(paramName,strBuffer.toString());


				continue;
			}

			if (paramName.equalsIgnoreCase("encoding"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListEncodingValues.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListEncodingValues.get(k));
				}
				hiddenObj.put(paramName,strBuffer.toString());

				continue;
			}

			if (paramName.equalsIgnoreCase("privateKey"))
			{
				StringBuffer strBuffer = new StringBuffer();				
				for (int k=0;k<aListFilePathValues.size();k=k+2)
				{
					if (k >= 2)
					{
						strBuffer.append(",");
					}					
					strBuffer.append(aListFilePathValues.get(k));
					strBuffer.append("#~~#");
					strBuffer.append(aListFilePathValues.get(k+1));
				}
				hiddenObj.put(paramName,strBuffer.toString());

				continue;
			}

			if (paramName.equalsIgnoreCase("systempropertykey"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListSystemPropKeys.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListSystemPropKeys.get(k));
				}
				hiddenObj.put(paramName,strBuffer.toString());
				continue;
			}

			if (paramName.equalsIgnoreCase("systempropertyvalue"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListSystemPropValues.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListSystemPropValues.get(k));
				}
				hiddenObj.put(paramName,strBuffer.toString());
				continue;
			}

			if ((testName.equalsIgnoreCase("WindowshareTest") ||
				testName.equalsIgnoreCase("UNCCheckTest")) && 
				(paramName.equalsIgnoreCase("domainname") || 
				paramName.equalsIgnoreCase("shareusername") || 
				paramName.equalsIgnoreCase("password")))
			{
				if (displayControl.equalsIgnoreCase("password"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						String tempStr = "";
						StringTokenizer st1 = new StringTokenizer(paramValue,"|");
						while(st1.hasMoreTokens())
						{
							String pwdWinShareAndSome = EgCrypt.decrypt(st1.nextToken());
							if (pwdWinShareAndSome.indexOf("@") != -1)
							{
								String strTokenGetDomain =  pwdWinShareAndSome.substring(0,pwdWinShareAndSome.indexOf("@"));
								String strTokenGetPass =  pwdWinShareAndSome.substring(pwdWinShareAndSome.indexOf("@")+1);
								if (strTokenGetPass.indexOf("~EG~") != -1)
								{
									strTokenGetPass = strTokenGetPass.substring(0,strTokenGetPass.indexOf("~EG~"));
								}

								if (!aListTcKeywordsLowerCase.contains(strTokenGetPass.toLowerCase()))
								{
									strTokenGetPass += "~EG~"; // salt for pwd
									strTokenGetPass = EgCrypt.encrypt(strTokenGetPass); 
								}

								pwdWinShareAndSome = strTokenGetDomain + "@" +  strTokenGetPass;
							}
							else
							{
								if(!aListTcKeywordsLowerCase.contains(pwdWinShareAndSome.toLowerCase()))
								{
									pwdWinShareAndSome += "~EG~"; // salt for pwd
									pwdWinShareAndSome = EgCrypt.encrypt(pwdWinShareAndSome); 
								}
							}
							tempStr += pwdWinShareAndSome + "#~#";
						}
						paramValue = tempStr.substring(0, tempStr.length()-3);
					}
					else
					{
						paramValue = EgCrypt.decrypt(paramValue);
						if (paramValue.indexOf("@") != -1)
						{
							//paramValue =  paramValue.substring(paramValue.indexOf("@")+1);
							String strSingleTokenGetDomain =  paramValue.substring(0,paramValue.indexOf("@"));
							String strSingleTokenGetPass =  paramValue.substring(paramValue.indexOf("@")+1);
							if (strSingleTokenGetPass.indexOf("~EG~") != -1)
							{
								strSingleTokenGetPass = strSingleTokenGetPass.substring(0,strSingleTokenGetPass.indexOf("~EG~"));
							}

							if (!aListTcKeywordsLowerCase.contains(strSingleTokenGetPass.toLowerCase()))
							{
								strSingleTokenGetPass += "~EG~"; // salt for pwd
								strSingleTokenGetPass = EgCrypt.encrypt(strSingleTokenGetPass); 
							}
							paramValue = strSingleTokenGetDomain + "@" +  strSingleTokenGetPass;
						}
						else
						{
							if (!aListTcKeywordsLowerCase.contains(paramValue.toLowerCase()))
							{
								paramValue += "~EG~"; // salt for pwd
								paramValue = EgCrypt.encrypt(paramValue); 
							}
						}
					}
				}
				else
				{
					if (paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
				}
				hiddenObj.put(paramName,paramValue);
				continue;
			}

			String readOnly = "";
			boolean showStar = false;
			String tempNewValue = null;
			if (paramValue.startsWith("$") && aListTcKeywordsLowerCase.contains(paramValue.toLowerCase()))
			{
				showStar = true;
				if (testName.equals(previousTestName))
				{
					tempNewValue = request.getParameter(paramName);
					if (tempNewValue != null)
					{
						tempNewValue = tempNewValue.toLowerCase();
						if (!aListTcKeywordsLowerCase.contains(tempNewValue))
						{
							showStar = false;
						}
					}
				}

				if (showStar)
				{
					paramNameObj.put(paramName,"*"+_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
				}
				else
				{
					paramNameObj.put(paramName,_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
				}
			}
			else
			{
				paramNameObj.put(paramName,_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
			}
			
			boolean pwdParamReadOnly = false;
			List password_param = new ArrayList();
			if(isEnablePwdProfile)
			{
				if (pwdProfileParamMap != null && pwdProfileParamMap.size() > 0)
				{
					String tmpParamValue = (String) pwdProfileParamMap.get(paramName);
					if (!StringUtils.isNull(tmpParamValue))
					{
						password_param.add(paramName);
					    	pwdParamReadOnly = true;
						paramValue = tmpParamValue;
						rootJson.put(paramName+"isPwdProfile",true);
					}
				}
			}

			if (displayControl.equalsIgnoreCase("radio"))
			{
				String enabled = "";
				String disabled = "";

				//Dependent Parameter - Having relationship with other parameters
				//For e.g., correct which has relations with alarmtype,userparams,correctivescript
				//Independent Parameter - Does not have relationship with other parameters
				//For e.g., isPassive
				//ProcessTest=wide(Yes:true#No:false) - Independent param
				//parameter value definition = (Yes:true#No:false)
				//Independent parameter having values true (or) false,yes (or) no,y (or) n doesnt 
				//need to define parameter value definition.
				//so ProcessTest=wide(Yes:true#No:false) can also be called as ProcessTest=wide
				//This will be handled in else block

				boolean isIndependentParam = aListDynamicRadioOptionNameAndValue.contains(paramName);
				rootJson.put("isIndependentParam"+paramName,isIndependentParam);
				if (isIndependentParam)
				{
					//block fires when the user put corresponding value to the isolated
					//radio parameter.
					int paramIdx = aListDynamicRadioOptionNameAndValue.indexOf(paramName);
					String tempParamValue = (String)aListDynamicRadioOptionNameAndValue.get(paramIdx+1);
					StringTokenizer st = new StringTokenizer(tempParamValue,"#");
					String tempParam = st.nextToken();
					String tempName1 = tempParam.substring(0,tempParam.indexOf(":"));
					String tempValue1 = tempParam.substring(tempParam.indexOf(":")+1,tempParam.length());
					String tempParam1 = st.nextToken();
					String tempName2 = tempParam1.substring(0,tempParam1.indexOf(":"));
					String tempValue2 = tempParam1.substring(tempParam1.indexOf(":")+1,tempParam1.length());
					boolean isIndependentParamEnabled = false;
					boolean isIndependentParamDisabled = false;

					String selectedParamValue = "";
					if (testName.equals(previousTestName))
					{
						selectedParamValue = request.getParameter(paramName);
						selectedParamValue = (selectedParamValue!=null)?selectedParamValue:"";
					}

					if (paramValue.equalsIgnoreCase("yes"))
					{
						paramValue = "true";
					}
					else if (paramValue.equalsIgnoreCase("no"))
					{
						paramValue = "false";
					}

					if (selectedParamValue.equalsIgnoreCase("") && 
						tempValue1.equalsIgnoreCase(paramValue))
					{
						enabled = "checked";
						disabled = "";
						isIndependentParamEnabled = true;
						isIndependentParamDisabled = false;

					}
					else if (selectedParamValue.equalsIgnoreCase("") && 
						tempValue2.equalsIgnoreCase(paramValue))
					{
						enabled = "";
						disabled = "checked";
						isIndependentParamEnabled = false;
						isIndependentParamDisabled = true;

					}
					else if (selectedParamValue.equalsIgnoreCase(tempValue1))
					{
						enabled = "checked";
						disabled = "";
						isIndependentParamEnabled = true;
						isIndependentParamDisabled = false;

					}
					else if (selectedParamValue.equalsIgnoreCase(tempValue2))
					{
						enabled = "";
						disabled = "checked";
						isIndependentParamEnabled = false;
						isIndependentParamDisabled = true;
					}
					rootJson.put("enabled"+paramName,isIndependentParamEnabled);
					rootJson.put("disabled"+paramName,isIndependentParamDisabled);
					rootJson.put("independentParamName"+paramName+"1",tempName1);
					rootJson.put("independentParamName"+paramName+"2",tempName2);
					rootJson.put("independentParamValue"+paramName+"1",tempValue1);
					rootJson.put("independentParamValue"+paramName+"2",tempValue2);

					aListDisplay.add(paramName+"#"+tempValue1);
					aListDisplay.add(tempName1);

					aListDisplay.add(paramName+"#"+tempValue2);
					aListDisplay.add(tempName2);

				}
				else
				{
					boolean isEncryptEnabled = false;
					boolean isEncryptDisabled = false;

					if (paramName.equalsIgnoreCase("encryptflag") && isSnmp)
					{
						String encryptFlagVal = "";
						if (testName.equals(previousTestName))
						{
							encryptFlagVal = request.getParameter(paramName);
							encryptFlagVal = (encryptFlagVal!=null)?encryptFlagVal:"";
						}

						if (paramValue.equalsIgnoreCase("true") && encryptFlagVal.length()==0)
						{
							enabled = "checked";
							disabled = "";
							isEncryptEnabled = true;
							isEncryptDisabled = false;

						}
						else if (paramValue.equalsIgnoreCase("false") && encryptFlagVal.length()==0)
						{
							enabled = "";
							disabled = "checked";
							isEncryptEnabled = false;
							isEncryptDisabled = true;

						}
						else if (encryptFlagVal.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
							isEncryptEnabled = true;
							isEncryptDisabled = false;

						}
						else if (encryptFlagVal.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
							isEncryptEnabled = false;
							isEncryptDisabled = true;
						}
						rootJson.put("enabledEncryptFlag",isEncryptEnabled);
						rootJson.put("disabledEncryptFlag",isEncryptDisabled);
					}
					else if (paramName.equalsIgnoreCase("policyfilter") && isPolicyParamExists)
					{
						String policyFilterValue = "";
						boolean policyFilterEnabled = false;
						boolean policyFilterDisabled = false;

						if (testName.equals(previousTestName))
						{
							policyFilterValue = request.getParameter(paramName);
							policyFilterValue = (policyFilterValue != null && policyFilterValue.length() > 0)?policyFilterValue:"";
						}

						if(paramValue.equalsIgnoreCase("true") && policyFilterValue.length()==0)
						{
							enabled = "checked";
							disabled = "";
							policyFilterEnabled = true;
							policyFilterDisabled = false;

						}
						if (paramValue.equalsIgnoreCase("false") && policyFilterValue.length()==0)
						{
							enabled = "";
							disabled = "checked";
							policyFilterEnabled = false;
							policyFilterDisabled = true;
						}
						else if(policyFilterValue.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
							policyFilterEnabled = true;
							policyFilterDisabled = false;

						}
						else if(policyFilterValue.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
							policyFilterEnabled = false;
							policyFilterDisabled = true;
						}
						rootJson.put("enabled"+paramName,policyFilterEnabled);
						rootJson.put("disabled"+paramName,policyFilterDisabled);

					}
					else if (paramName.equalsIgnoreCase("correct") && isCorrectParamExist)
					{
						String correctVal = "";
						boolean isEnabled = false;
						boolean isDisabled = false;

						if (testName.equals(previousTestName))
						{
							correctVal = request.getParameter(paramName);
							correctVal = (correctVal != null && correctVal.length() > 0)?correctVal:"";
						}

						if(paramValue.equalsIgnoreCase("false") && correctVal.length()==0)
						{
							enabled = "";
							disabled = "checked";
							isDisabled = true;
						}
						else if(paramValue.equalsIgnoreCase("true") && correctVal.length()==0)
						{
							enabled = "checked";
							disabled = "";
							isEnabled = true;
						}
						else if(correctVal.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
							isEnabled = true;
						}
						else if(correctVal.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
							isDisabled = true;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
					}
					else if(paramName.equalsIgnoreCase("metric_collection_type"))
					{
						String jmxOptionsShow = "";
						String jmxOptionsHide = "";
						String optionsTempVal = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestModeValue = "";
						if (testName.equals(previousTestName))
						{
							requestModeValue = request.getParameter(paramName);
							requestModeValue = (requestModeValue==null)?"":requestModeValue;
						}

						if (!requestModeValue.equals(""))
						{
							optionsTempVal = requestModeValue;
						}

						if (optionsTempVal.equalsIgnoreCase("true"))
						{
							jmxOptionsShow = "checked";
							isEnabled = true;
						}
						else
						{
							jmxOptionsHide = "checked";
							isDisabled = true;
						}
						rootJson.put("jmxOptionsShow",isEnabled);
						rootJson.put("jmxOptionsHide",isDisabled);

						String lableString = "Others";
						if(testName.equalsIgnoreCase("jvmfiledescriptortest") || testName.equalsIgnoreCase("jmxconnectortest")){
							lableString = "JMX";
						}
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add(lableString);
						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("JAR");
						rootJson.put(paramName+"#"+"false" , "JAR");
						rootJson.put(paramName+"#"+"true" , lableString);
					}
					else if(paramName.equalsIgnoreCase("mode") && isModeParamExist)
					{
						String snmpSelected = "";
						String jmxSelected = "";
						String modeTempVal = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestModeValue = "";
						if (testName.equals(previousTestName))
						{
							requestModeValue = request.getParameter(paramName);
							requestModeValue = (requestModeValue==null)?"":requestModeValue;
						}

						if (!requestModeValue.equals(""))
						{
							modeTempVal = requestModeValue;
						}

						if (modeTempVal.equalsIgnoreCase("true"))
						{
							snmpSelected = "checked";
							isEnabled = true;
						}
						else
						{
							jmxSelected = "checked";
							isDisabled = true;
						}
						rootJson.put("modeEnabled",isEnabled);
						rootJson.put("modeDisabled",isDisabled);

						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("SNMP");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("JMX");
					}
					//else if(paramName.equalsIgnoreCase("profiler") && isModeParamExist)
					//{
						//String profilerOn = "";
						//String profilerOff = "";
						//String profilerValue = new String(paramValue);
						//boolean isEnabled = false;
						//boolean isDisabled = false;

						//String requestProfilerValue = "";
						//if (testName.equals(previousTestName))
						//{
							//requestProfilerValue = request.getParameter(paramName);
							//requestProfilerValue = (requestProfilerValue==null)?"":requestProfilerValue;
						//}

						//if (!requestProfilerValue.equals(""))
						//{
							//profilerValue = requestProfilerValue;
						//}

						//if (profilerValue.equalsIgnoreCase("true"))
						//{
							//profilerOn = "checked";
						//}
						//else
						//{
							//profilerOff = "checked";
						//}
						//aListDisplay.add(paramName+"#"+"true");
						//aListDisplay.add("On");

						//aListDisplay.add(paramName+"#"+"false");
						//aListDisplay.add("Off");
					//}
					else if(paramName.equalsIgnoreCase("heap_analysis") && isModeParamExist)
					{
						String heapAnalysisYes = "";
						String heapAnalysisNo = "";
						String heapAnalysisValue = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestHeapAnalysisValue = "";
						if (testName.equals(previousTestName))
						{
							requestHeapAnalysisValue = request.getParameter(paramName);
							requestHeapAnalysisValue = (requestHeapAnalysisValue==null)?"":requestHeapAnalysisValue;
						}

						if (!requestHeapAnalysisValue.equals(""))
						{
							heapAnalysisValue = requestHeapAnalysisValue;
						}

						if (heapAnalysisValue.equalsIgnoreCase("true"))
						{
							heapAnalysisYes = "checked";
							isEnabled = true;
						}
						else
						{
							heapAnalysisNo = "checked";
							isDisabled = true;
						}
						rootJson.put("enabledHeapAnalysis",isEnabled);
						rootJson.put("disabledHeapAnalysis",isDisabled);

						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if(paramName.equalsIgnoreCase("useAlias") && hasShowAliasParam)
					{
						String usealiasYes = "";
						String usealiasNo = "";
						String usealiasValue = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestusealiasValue = "";
						if (testName.equals(previousTestName))
						{
							requestusealiasValue = request.getParameter(paramName);
							requestusealiasValue = (requestusealiasValue==null)?"":requestusealiasValue;
						}

						if (!requestusealiasValue.equals(""))
						{
							usealiasValue = requestusealiasValue;
						}

						if (usealiasValue.equalsIgnoreCase("true") || usealiasValue.equalsIgnoreCase("yes"))
						{
							usealiasYes = "checked";
							isEnabled = true;
						}
						else
						{
							usealiasNo = "checked";
							isDisabled = true;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("showAllEvents") && hasShowAllOnlyParam)
					{
						String showalleventsYes = "";
						String showalleventsNo = "";
						String showalleventsValue = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestshowalleventsValue = "";
						if (testName.equals(previousTestName))
						{
							requestshowalleventsValue = request.getParameter(paramName);
							requestshowalleventsValue = (requestshowalleventsValue==null)?"":requestshowalleventsValue;
						}

						if (!requestshowalleventsValue.equals(""))
						{
							showalleventsValue = requestshowalleventsValue;
						}
						if (showalleventsValue.equalsIgnoreCase("true") || showalleventsValue.equalsIgnoreCase("yes"))
						{
							showalleventsYes = "checked";
							isEnabled = true;
						}
						else
						{
							showalleventsNo = "checked";
							isDisabled = true;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);

						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("Report_total") && hasReportOnlyTotalParam)
					{
						String reporttotalYes = "";
						String reporttotalNo = "";
						String reporttotalValue = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestreporttotalValue = "";
						if (testName.equals(previousTestName))
						{
							requestreporttotalValue = request.getParameter(paramName);
							requestreporttotalValue = (requestreporttotalValue==null)?"":requestreporttotalValue;
						}

						if (!requestreporttotalValue.equals(""))
						{
							reporttotalValue = requestreporttotalValue;
						}
						if (reporttotalValue.equalsIgnoreCase("true") || reporttotalValue.equalsIgnoreCase("yes"))
						{
							reporttotalYes = "checked";
							isEnabled = true;
						}
						else
						{
							reporttotalNo = "checked";
							isDisabled = true;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);

						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("use_sapcontrol"))
					{
						boolean isEnabled = true;
						boolean isDisabled = true;

						if(paramValue == null ||  paramValue.equalsIgnoreCase("true"))
						{
							isDisabled = false;
						}
						else
						{
							isEnabled = false;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else
					{
						//handling independent parameter for radio - starts
						//handled yes,no,true,false,y and n only
						//block fires when the user forgets to put corresponding value
						//to the isolated radio parameter.Parameter are handled to their
						//default values.
						String value1 = "";
						String value2 = "";
						boolean isIndepParamEnabled = false;
						boolean isIndepParamDisabled = false;

						if (paramValue.equalsIgnoreCase("yes") || paramValue.equalsIgnoreCase("no"))
						{
							value1 = "yes";
							value2 = "no";
						}
						else if (paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("false"))
						{
							value1 = "true";
							value2 = "false";
						}
						else
						{
							value1 = "y";
							value2 = "n";
						}

						String selectedParamValue = "";
						if (testName.equals(previousTestName))
						{
							selectedParamValue = request.getParameter(paramName);
							selectedParamValue = (selectedParamValue!=null)?selectedParamValue:"";
						}

						if (selectedParamValue.equals(""))
						{
							if (paramValue.equalsIgnoreCase("n") || 
								paramValue.equalsIgnoreCase("no") || 
								paramValue.equalsIgnoreCase("false"))
							{
								enabled = "";
								disabled = "checked";
								isIndepParamEnabled = false;
								isIndepParamDisabled = true;

							}
							else
							{
								enabled = "checked";
								disabled = "";
								isIndepParamEnabled = true;
								isIndepParamDisabled = false;
							}
						}
						else
						{
							if (selectedParamValue.equalsIgnoreCase("n") || 
								selectedParamValue.equalsIgnoreCase("no") || 
								selectedParamValue.equalsIgnoreCase("false"))
							{
								enabled = "";
								disabled = "checked";
								isIndepParamEnabled = false;
								isIndepParamDisabled = true;

							}
							else
							{
								enabled = "checked";
								disabled = "";
								isIndepParamEnabled = true;
								isIndepParamDisabled = false;
							}
						}
						rootJson.put("enabled"+paramName,isIndepParamEnabled);
						rootJson.put("disabled"+paramName,isIndepParamDisabled);
						rootJson.put("value1"+paramName,value1);
						rootJson.put("value2"+paramName,value2);

					//handling independent parameter for radio - ends
					}
				}
			}
			else if (displayControl.equalsIgnoreCase("select"))
			{
				//Dependent Parameter - Having relationship with other parameters
				//For e.g., snmpVersion which has relations with snmpCommunity,AuthType,AuthPass,EncryptType,EncryptPass
				//Independent Parameter - Does not have relationship with other parameters
				//For e.g., alarmtype
				boolean isIndependentParam = aListDynamicSelectOptionNameAndValue.contains(paramName);
				rootJson.put("isIndependentParam"+paramName,isIndependentParam);

				if (isIndependentParam)
				{
					JSONArray independentParamArr = new JSONArray();
					JSONObject independentParamObj = new JSONObject();

					int strParamIdx = aListDynamicSelectOptionNameAndValue.indexOf(paramName);
					String strParamValue = (String)aListDynamicSelectOptionNameAndValue.get(strParamIdx+1);
					String selectedParamValue = "";
					if (testName.equals(previousTestName))
					{
						selectedParamValue = request.getParameter(paramName);
						selectedParamValue = (selectedParamValue != null)?selectedParamValue:"";
					}
					StringTokenizer st = new StringTokenizer(strParamValue,"#");
					while (st.hasMoreTokens())
					{
						String s = st.nextToken();
						String strText = s.substring(0,s.indexOf(":"));
						String strValue = s.substring(s.indexOf(":")+1,s.length());
						independentParamObj.put("displayField",strText);
						independentParamObj.put("valueField",strValue);

						aListDisplay.add(paramName+"#"+strValue);
						aListDisplay.add(strText);
						if (paramValue.equals(strValue))
						{
							rootJson.put("selectedIndParamValue"+paramName, paramValue);
						}
						else if (selectedParamValue.equals(strValue))
						{
							rootJson.put("selectedIndParamValue"+paramName, selectedParamValue);
						}
						independentParamArr.add(independentParamObj);
					}

					if (paramName.equalsIgnoreCase("pageTypesToBeincludedindashboard"))
					{
						if (paramValue.indexOf("~#~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~#~",",");
						}

						rootJson.put("selectedIndParamValue"+paramName, paramValue);
						rootJson.put("fieldLabel"+paramName,_mapping.getTextDescription("admin.test."+paramName));
					}

					rootJson.put("independentParamArr"+paramName,independentParamArr);
				}
				else
				{
					if (paramName.startsWith("password_profile") && isEnablePwdProfile)
					{
						String temp = paramValue;
						String strVal = "";
						if (testName.equals(previousTestName))
						{
							strVal = request.getParameter(paramName);
						}

						paramValue = (strVal == null || strVal.equals(""))?temp:strVal;
						boolean isSpecificProfSet = false;
						boolean isDefaultProfSet = false;

						String strSelectedParamSet = pwdParamSetList.get(paramName).toString();
						String mergeString = componentType+"#^#"+strSelectedParamSet;
						isSpecificProfSet = pwdProf.isTestHasDefaultPwdProfile(mergeString,testName);

						String defaultMergeStr = testName+"#^#"+strSelectedParamSet;
						isDefaultProfSet = pwdProf.isTestHasDefaultPwdProfile(defaultMergeStr);

						rootJson.put("selectedProfile"+paramName,"none");
						String selectedProfile = "none";
						if (isSpecificProfSet)
						{
							selectedProfile = pwdProf.getProfNameForDefaultConfiguration(mergeString,testName);
							rootJson.put("selectedProfile"+paramName,selectedProfile);
						}
						else
						{
							if (isDefaultProfSet)
							{
								selectedProfile = pwdProf.getProfNameForDefaultConfiguration(defaultMergeStr);
								rootJson.put("selectedProfile"+paramName,selectedProfile);
							}
						}

						String[] checkMultiUserParams = {"Published_resources","Connection_server_name"};
						if (isMultiUserParamExists(aResultant,checkMultiUserParams))
						{
							rootJson.put("isMultiUserParamExists",true);
						}
					}
					else if (paramName.equalsIgnoreCase("snmpversion") && isSnmp)
					{
						JSONArray snmpVersionArr = new JSONArray();
						JSONObject snmpVersionObj = new JSONObject();

						if (testName.equals(previousTestName))
						{
							String strVal = request.getParameter(paramName);
							paramValue = (strVal==null)?paramValue:strVal;
						}
						for(int k=0;k<versions.length;k++)
						{
							if(versions[k].equalsIgnoreCase(paramValue))
							{
								rootJson.put("selectedSnmpVersion",paramValue);
							}
							snmpVersionObj.put("displayField",versions[k]);
							snmpVersionObj.put("valueField",versions[k]);
							snmpVersionArr.add(snmpVersionObj);
						}
						rootJson.put("snmpVersionArr",snmpVersionArr);
					}
					else if (paramName.equalsIgnoreCase("authtype") && isSnmp)
					{
						JSONArray snmpAuthTypeArr = new JSONArray();
						JSONObject snmpAuthTypeObj = new JSONObject();

						if (testName.equals(previousTestName))
						{
							String authTypeVal = request.getParameter(paramName);
							paramValue = (authTypeVal==null)?paramValue:authTypeVal;
						}
						for(int k=0;k<authTypes.length;k++)
						{
							if(paramValue.equals(authTypes[k]))
							{
								rootJson.put("selectedSnmpAuthType",paramValue);
							}
							
							snmpAuthTypeObj.put("displayField",authTypes[k]);
							snmpAuthTypeObj.put("valueField",authTypes[k]);
							snmpAuthTypeArr.add(snmpAuthTypeObj);
						}
						rootJson.put("snmpAuthTypeArr",snmpAuthTypeArr);
					}
					else if (paramName.equalsIgnoreCase("encrypttype") && isSnmp)
					{
						JSONArray snmpEncTypeArr = new JSONArray();
						JSONObject snmpEncTypeObj = new JSONObject();

						if (testName.equals(previousTestName))
						{
							String encryptTypeVal = request.getParameter(paramName);
							paramValue = (encryptTypeVal==null)?paramValue:encryptTypeVal;
						}
						for(int k=0;k<encryptTypes.length;k++)
						{
							if(paramValue.equals(encryptTypes[k]))
							{
								rootJson.put("selectedSnmpEncType",paramValue);
							}
							
							snmpEncTypeObj.put("displayField",encryptTypes[k]);
							snmpEncTypeObj.put("valueField",encryptTypes[k]);
							snmpEncTypeArr.add(snmpEncTypeObj);
						}
						rootJson.put("snmpEncTypeArr",snmpEncTypeArr);
					}
					else if(paramName.equalsIgnoreCase("filter") && isPolicyParamExists)
					{
						String policyFilterValue = "";
						int policyFilterIdx = aListResultantTempInLowerCase.indexOf("-policyfilter");

						if (testName.equals(previousTestName))
						{
							policyFilterValue = request.getParameter(((String)aResultant.get(policyFilterIdx)).substring(1));
							policyFilterValue = (policyFilterValue != null && policyFilterValue.length() > 0)?policyFilterValue:"";
						}

						if (policyFilterValue.equalsIgnoreCase("true"))
						{
							JSONArray filterArr = new JSONArray();
							JSONObject filterObj = new JSONObject();
							rootJson.put("isPolicyFilterValue","combo");
							ArrayList aListPolicy = new ArrayList();
							String select = "";
							String filterName = paramValue;
							if(filterName.indexOf(":") > -1)
							{
								if(filterName.indexOf(";") > -1)
								{
									StringTokenizer policyTokens = new StringTokenizer(filterName,";");
									while(policyTokens.hasMoreTokens())
									{
										String tempPolicy = policyTokens.nextToken();
										tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
										aListPolicy.add(tempPolicy);
									}
								}
								if(filterName.indexOf("~#~") > -1)
								{
									StringTokenizer policyTokens = new StringTokenizer(filterName,"~#~");
									while(policyTokens.hasMoreTokens())
									{
										String tempPolicy = policyTokens.nextToken();
										tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
										aListPolicy.add(tempPolicy);
									}
								}
								else
								{
									aListPolicy.add(filterName.substring(0,filterName.indexOf(":")));
								}
							}
							else if (filterName.indexOf(";") > -1)
							{
								StringTokenizer policyTokens = new StringTokenizer(filterName,";");
								while(policyTokens.hasMoreTokens())
								{
									String tempPolicy = policyTokens.nextToken();
									aListPolicy.add(tempPolicy);
								}
							}
							else if (filterName.indexOf("~#~") > -1)
							{
								StringTokenizer policyTokens = new StringTokenizer(filterName,"~#~");
								while(policyTokens.hasMoreTokens())
								{
									String tempPolicy = policyTokens.nextToken();
									aListPolicy.add(tempPolicy);
								}
							}
							else
							{
								aListPolicy.add(filterName);
							}
							String selectedPolicyFilter = "";
							for(int k=0;k<aPolicyFilter.size();k++)
							{
								filterObj.put("displayField",aPolicyFilter.get(k));
								filterObj.put("valueField",aPolicyFilter.get(k));
								filterArr.add(filterObj);

								if(aListPolicy.contains(aPolicyFilter.get(k)))
								{
									select = "selected";
									selectedPolicyFilter += ","+aPolicyFilter.get(k);
								}
							}
							if (!StringUtils.isNull(selectedPolicyFilter))
							{
								selectedPolicyFilter = selectedPolicyFilter.substring(1);
							}
							rootJson.put("selectedPolicyFilter",selectedPolicyFilter);
							rootJson.put("filterArr",filterArr);
							rootJson.put("policyFilterValue",paramValue);

						}
						else if(policyFilterValue.length()==0 && paramValue.indexOf(":") > -1)
						{
							//called while loading the page when policy filter value is "no"
							paramValue = StringUtils.replace(paramValue,"|",",");
							rootJson.put("isPolicyFilterValue","fieldContainer");
							rootJson.put("policyFilterValue",paramValue);
							rootJson.put("btnLabel",_mapping.getTextDescription("admin.common.View"));
						}
						else if(policyFilterValue.length()==0 && paramValue.indexOf(":") == -1)
						{
							rootJson.put("isPolicyFilterValue","combo");
							JSONArray filterArr = new JSONArray();
							JSONObject filterObj = new JSONObject();

							ArrayList aTemp = new ArrayList();
							if (paramValue.indexOf(";") > -1)
							{
								StringTokenizer st = new StringTokenizer(paramValue,";");
								while (st.hasMoreTokens())
								{
									aTemp.add(st.nextToken().trim());
								}
							}
							if (paramValue.indexOf("~#~") > -1)
							{
								StringTokenizer st = new StringTokenizer(paramValue,"~#~");
								while (st.hasMoreTokens())
								{
									aTemp.add(st.nextToken().trim());
								}
							}
							else
							{
								aTemp.add(paramValue);
							}
							String selectedPolicyFilter = "";
							for(int k=0;k<aPolicyFilter.size();k++)
							{
								filterObj.put("displayField",aPolicyFilter.get(k));
								filterObj.put("valueField",aPolicyFilter.get(k));
								filterArr.add(filterObj);
								if(aTemp.contains((String)aPolicyFilter.get(k)))
								{
									selectedPolicyFilter += ","+aPolicyFilter.get(k);
								}
							}
							if (!StringUtils.isNull(selectedPolicyFilter))
							{
								selectedPolicyFilter = selectedPolicyFilter.substring(1);
							}
							rootJson.put("selectedPolicyFilter",selectedPolicyFilter);
							rootJson.put("filterArr",filterArr);
							rootJson.put("policyFilterValue",paramValue);
						}
						else if (policyFilterValue.equalsIgnoreCase("false"))//special case
						{
							rootJson.put("isPolicyFilterValue","fieldContainer");
							String tempPolicyFilterValue = "";
							for(int z=0;z<aPolicyFilter.size();z++)
							{
								if (z>0)
								{
									tempPolicyFilterValue = tempPolicyFilterValue + ";";
								}
								tempPolicyFilterValue = tempPolicyFilterValue + (aPolicyFilter.get(z)).toString();
							}
							rootJson.put("policyFilterValue",tempPolicyFilterValue);
							rootJson.put("btnLabel",_mapping.getTextDescription("admin.common.View"));
						}
					}
					/////////RHEV - Starts
					else if (paramName.equalsIgnoreCase("Rhel_mgr_host"))
					{
						JSONArray rhelMgrHostArr = new JSONArray();
						JSONObject rhelMgrHostObj = new JSONObject();
						JSONObject rhevComboObj = new JSONObject();

						String selectedRhevMgr = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedRhevMgr = request.getParameter(paramName);
						}
						selectedRhevMgr = (selectedRhevMgr!=null)?selectedRhevMgr:paramValue;
						if (selectedRhevMgr.equalsIgnoreCase("$unconfigured"))
						{
							selectedRhevMgr = "None";
						}
						if (selectedRhevMgr.equalsIgnoreCase("none"))
						{
							rootJson.put("selectedRhelMgrHost","None");
						}
						else if (selectedRhevMgr.equalsIgnoreCase("other"))
						{
							rootJson.put("selectedRhelMgrHost","Other");
						}
						rootJson.put("selectedRhelMgrHost",selectedRhevMgr);
						rhelMgrHostObj.put("displayField",_mapping.getTextDescription("admin.test.Choose an RHEV Manager"));
						rhelMgrHostObj.put("valueField","None");
						rhelMgrHostArr.add(rhelMgrHostObj);

						if (rhevs != null && rhevs.length > 0)
						{
							for (int k=0;k<rhevs.length;k++)
							{
								String eachRhev=rhevs[k];
								if (selectedRhevMgr.equalsIgnoreCase(eachRhev))
								{
									rootJson.put("selectedRhelMgrHost",selectedRhevMgr);
								}
								rhelMgrHostObj.put("displayField",eachRhev);
								rhelMgrHostObj.put("valueField",eachRhev);
								rhelMgrHostArr.add(rhelMgrHostObj);
								String rhevValue = servicesIniFile.getValue("RHEV",eachRhev);
								ArrayList tmpRHEVList  = StringUtils.egTokenizer(rhevValue,"#");
								if (tmpRHEVList != null && !tmpRHEVList.isEmpty())
								{
									String replaceRHEVStr = "";
									for (int v = 0; v< tmpRHEVList.size();v++)
									{
										String tmpRHEVListStr = (String) tmpRHEVList.get(v);
										if (v == 2)
										{
											if (!tmpRHEVListStr.equals("$unconfigured"))
											{
												tmpRHEVListStr = EgCrypt.decrypt(tmpRHEVListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpRHEVListStr.toLowerCase()))
												{
													tmpRHEVListStr += "~EG~"; // salt for pwd
													tmpRHEVListStr = EgCrypt.encrypt(tmpRHEVListStr); 
												}

												if (!StringUtils.isNull(tmpRHEVListStr) && tmpRHEVListStr.indexOf("#") != -1)
												{
													tmpRHEVListStr = StringUtils.replace(tmpRHEVListStr, EgConstants.HASH, "~HASH~");
												}
											}

										}
										replaceRHEVStr += tmpRHEVListStr +"#";
									}
									if (replaceRHEVStr.endsWith("#"))
									{
										rhevValue = replaceRHEVStr.substring(0,replaceRHEVStr.lastIndexOf("#"));
									}
								}
								rhevComboObj.put(eachRhev,rhevValue);
							}
						}
						else
						{
							if (!selectedRhevMgr.equalsIgnoreCase("none") && !selectedRhevMgr.equalsIgnoreCase("other"))
							{
								rhelMgrHostObj.put("displayField",selectedRhevMgr);
								rhelMgrHostObj.put("valueField",selectedRhevMgr);
								rhelMgrHostArr.add(rhelMgrHostObj);
								rootJson.put("selectedRhelMgrHost",selectedRhevMgr);
								String rhevValue = servicesIniFile.getValue("RHEV",selectedRhevMgr);
								ArrayList tmpRHEVList  = StringUtils.egTokenizer(rhevValue,"#");
								if (tmpRHEVList != null && !tmpRHEVList.isEmpty())
								{
									String replaceRHEVStr = "";
									for (int v = 0; v< tmpRHEVList.size();v++)
									{
										String tmpRHEVListStr = (String) tmpRHEVList.get(v);
										if (v == 2)
										{
											if (!tmpRHEVListStr.equals("$unconfigured"))
											{
												tmpRHEVListStr = EgCrypt.decrypt(tmpRHEVListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpRHEVListStr.toLowerCase()))
												{
													tmpRHEVListStr += "~EG~"; // salt for pwd
													tmpRHEVListStr = EgCrypt.encrypt(tmpRHEVListStr); 
												}

												if (!StringUtils.isNull(tmpRHEVListStr) && tmpRHEVListStr.indexOf("#") != -1)
												{
													tmpRHEVListStr = StringUtils.replace(tmpRHEVListStr, EgConstants.HASH, "~HASH~");
												}
											}

										}
										replaceRHEVStr += tmpRHEVListStr +"#";
									}
									if (replaceRHEVStr.endsWith("#"))
									{
										rhevValue = replaceRHEVStr.substring(0,replaceRHEVStr.lastIndexOf("#"));
									}
								}
								rhevComboObj.put(selectedRhevMgr,rhevValue);
							}
						}
						rhelMgrHostObj.put("displayField",_mapping.getTextDescription("admin.test.Other"));
						rhelMgrHostObj.put("valueField","Other");
						rhelMgrHostArr.add(rhelMgrHostObj);
						rootJson.put("rhelMgrHostArr",rhelMgrHostArr);
						rootJson.put("rhevComboObj",rhevComboObj);
					}
					/////////RHEV - Ends
					else if (paramName.equalsIgnoreCase("virtual_center"))
					{
						JSONArray virtualCenterArr = new JSONArray();
						JSONObject virtualCenterObj = new JSONObject();
						JSONObject virtualComboObj = new JSONObject();

						String selectedVirtualCenter = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedVirtualCenter = request.getParameter(paramName);
						}
						selectedVirtualCenter = (selectedVirtualCenter!=null)?selectedVirtualCenter:paramValue;
						if (selectedVirtualCenter.equalsIgnoreCase("none"))
						{
							rootJson.put("selectedVirtualCenter","None");
						}
						else if (selectedVirtualCenter.equalsIgnoreCase("other"))
						{
							rootJson.put("selectedVirtualCenter","Other");
						}
						virtualCenterObj.put("displayField",_mapping.getTextDescription("admin.test.None"));
						virtualCenterObj.put("valueField","None");
						virtualCenterArr.add(virtualCenterObj);
						if (virtualCenters != null && virtualCenters.length > 0)
						{
							for (int k=0;k<virtualCenters.length;k++)
							{
								String eachVirtualCenter=virtualCenters[k];
								if (selectedVirtualCenter.equalsIgnoreCase(eachVirtualCenter))
								{
									rootJson.put("selectedVirtualCenter",selectedVirtualCenter);
								}
								virtualCenterObj.put("displayField",eachVirtualCenter);
								virtualCenterObj.put("valueField",eachVirtualCenter);
								virtualCenterArr.add(virtualCenterObj);
								String vCenterValue = servicesIniFile.getValue("VIRTUAL_CENTER",eachVirtualCenter);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int v = 0; v< tmpVCenterList.size();v++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(v);
										if (v == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}

												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}

										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								virtualComboObj.put(eachVirtualCenter,vCenterValue);
							}
						}
						else
						{
							if (!selectedVirtualCenter.equalsIgnoreCase("none") && !selectedVirtualCenter.equalsIgnoreCase("other"))
							{
								virtualCenterObj.put("displayField",selectedVirtualCenter);
								virtualCenterObj.put("valueField",selectedVirtualCenter);
								virtualCenterArr.add(virtualCenterObj);
								rootJson.put("selectedVirtualCenter",selectedVirtualCenter);
								String vCenterValue = servicesIniFile.getValue("VIRTUAL_CENTER",selectedVirtualCenter);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int j = 0; j< tmpVCenterList.size();j++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(j);
										if (j == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}

												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}
										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								virtualComboObj.put(selectedVirtualCenter,vCenterValue);
							}
						}
						virtualCenterObj.put("displayField",_mapping.getTextDescription("admin.test.Other"));
						virtualCenterObj.put("valueField","Other");
						virtualCenterArr.add(virtualCenterObj);
						rootJson.put("virtualCenterArr",virtualCenterArr);
						rootJson.put("virtualComboObj",virtualComboObj);
					}
					else if (paramName.equalsIgnoreCase("xms_ip"))
					{
						JSONArray xmsIPArr = new JSONArray();
						JSONObject xmsIPObj = new JSONObject();
						JSONObject xmsIPComboObj = new JSONObject();
						String selectedXMSIP = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedXMSIP = request.getParameter(paramName);
						}
						selectedXMSIP = (selectedXMSIP!=null)?selectedXMSIP:paramValue;
						if (selectedXMSIP.equalsIgnoreCase("none"))
						{
							rootJson.put("selectedXMSIP","None");
						}
						else if (selectedXMSIP.equalsIgnoreCase("other"))
						{
							rootJson.put("selectedXMSIP","Other");
						}
						xmsIPObj.put("displayField",_mapping.getTextDescription("admin.test.None"));
						xmsIPObj.put("valueField","None");
						xmsIPArr.add(xmsIPObj);

						if (emcXMSIPs != null && emcXMSIPs.length > 0)
						{
							for (int k=0;k<emcXMSIPs.length;k++)
							{
								String eachVirtualCenter=emcXMSIPs[k];
								if (selectedXMSIP.equalsIgnoreCase(eachVirtualCenter))
								{
									rootJson.put("selectedXMSIP",selectedXMSIP);
								}
								xmsIPObj.put("displayField",eachVirtualCenter);
								xmsIPObj.put("valueField",eachVirtualCenter);
								xmsIPArr.add(xmsIPObj);
								String vCenterValue = servicesIniFile.getValue("EMC_XtremIO_4x",eachVirtualCenter);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int v = 0; v< tmpVCenterList.size();v++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(v);
										if (v == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}

												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}

										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								xmsIPComboObj.put(eachVirtualCenter,vCenterValue);
							}
						}
						else
						{
							if (!selectedXMSIP.equalsIgnoreCase("none") && !selectedXMSIP.equalsIgnoreCase("other"))
							{
								xmsIPObj.put("displayField",selectedXMSIP);
								xmsIPObj.put("valueField",selectedXMSIP);
								xmsIPArr.add(xmsIPObj);
								rootJson.put("selectedXMSIP",selectedXMSIP);
								String vCenterValue = servicesIniFile.getValue("EMC_XtremIO_4x",selectedXMSIP);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int j = 0; j< tmpVCenterList.size();j++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(j);
										if (j == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}

												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}
										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								xmsIPComboObj.put(selectedXMSIP,vCenterValue);
							}
						}
						xmsIPObj.put("displayField",_mapping.getTextDescription("admin.test.Other"));
						xmsIPObj.put("valueField","Other");
						xmsIPArr.add(xmsIPObj);

						rootJson.put("xmsIPComboObj",xmsIPComboObj);
						rootJson.put("xmsIPArr",xmsIPArr);
					}
					else if (paramName.equalsIgnoreCase("prism_ip"))
					{
						JSONArray prismArr = new JSONArray();
						JSONObject virtualCenterObj = new JSONObject();
						JSONObject virtualComboObj = new JSONObject();
						String selectedPrism = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedPrism = request.getParameter(paramName);
						}
						selectedPrism = (selectedPrism!=null)?selectedPrism:paramValue;
						if (selectedPrism.equalsIgnoreCase("none"))
						{
							rootJson.put("selectedPrism","None");
						}
						else if (selectedPrism.equalsIgnoreCase("other"))
						{
							rootJson.put("selectedPrism","Other");
						}
						virtualCenterObj.put("displayField",_mapping.getTextDescription("admin.test.None"));
						virtualCenterObj.put("valueField","None");
						prismArr.add(virtualCenterObj);

						if (nutanixPrisms != null && nutanixPrisms.length > 0)
						{
							for (int k=0;k<nutanixPrisms.length;k++)
							{
								String eachVirtualCenter=nutanixPrisms[k];
								if (selectedPrism.equalsIgnoreCase(eachVirtualCenter))
								{
									rootJson.put("selectedPrism",selectedPrism);
								}
								virtualCenterObj.put("displayField",eachVirtualCenter);
								virtualCenterObj.put("valueField",eachVirtualCenter);
								prismArr.add(virtualCenterObj);
								String vCenterValue = servicesIniFile.getValue("NUTANIX",eachVirtualCenter);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int v = 0; v< tmpVCenterList.size();v++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(v);
										if (v == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}

												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}

										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								virtualComboObj.put(eachVirtualCenter,vCenterValue);
							}
						}
						else
						{
							if (!selectedPrism.equalsIgnoreCase("none") && !selectedPrism.equalsIgnoreCase("other"))
							{
								virtualCenterObj.put("displayField",selectedPrism);
								virtualCenterObj.put("valueField",selectedPrism);
								prismArr.add(virtualCenterObj);
								rootJson.put("selectedPrism",selectedPrism);
								String vCenterValue = servicesIniFile.getValue("NUTANIX",selectedPrism);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int j = 0; j< tmpVCenterList.size();j++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(j);
										if (j == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}

												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}
										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								virtualComboObj.put(selectedPrism,vCenterValue);
							}
						}
						virtualCenterObj.put("displayField",_mapping.getTextDescription("admin.test.Other"));
						virtualCenterObj.put("valueField","Other");
						prismArr.add(virtualCenterObj);

						rootJson.put("virtualComboObj",virtualComboObj);
						rootJson.put("prismArr",prismArr);
					}
					else if (paramName.equalsIgnoreCase("management_server"))
					{
						String selectedHMC = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedHMC = request.getParameter(paramName);
						}
						selectedHMC = (selectedHMC!=null)?selectedHMC:paramValue;

						boolean showTextBox = false;
						String strIsManagedByChanged = request.getParameter("isManagedByChanged");
						if (strIsManagedByChanged == null)
						{
							if (resIsManagedByValue.equalsIgnoreCase("ivm"))
							{
								showTextBox = true;
							}
						}
						else if (strIsManagedByChanged != null && strIsManagedByChanged.equalsIgnoreCase("true"))
						{
							String tempManagedBy = request.getParameter("is_managed_by");
							String tempMgmtServerVal = (String)request.getAttribute("management_server");
							if (tempMgmtServerVal != null)
							{
								paramValue = tempMgmtServerVal;
							}

							if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("ivm"))
							{
								showTextBox = true;
							}
						}
						rootJson.put("showTextBox"+paramName,showTextBox);

						//if (showTextBox)
						{
							rootJson.put("mgmtTextValue",paramValue);
						}
						//else
						{
							JSONArray mgmtServerArr = new JSONArray();
							JSONObject mgmtServerObj = new JSONObject();
							JSONObject hmcComboObj = new JSONObject();

							if (selectedHMC.equalsIgnoreCase("none"))
							{
								rootJson.put("selectedHMC","None");
							}
							else if (selectedHMC.equalsIgnoreCase("other"))
							{
								rootJson.put("selectedHMC","Other");
							}
							mgmtServerObj.put("displayField",_mapping.getTextDescription("admin.test.None"));
							mgmtServerObj.put("valueField","none");
							mgmtServerArr.add(mgmtServerObj);

							if (hmcs != null && hmcs.length > 0)
							{
								for (int k=0;k<hmcs.length;k++)
								{
									String eachHMC=hmcs[k];
									if (selectedHMC.equalsIgnoreCase(eachHMC))
									{
										rootJson.put("selectedHMC",eachHMC);
									}
									mgmtServerObj.put("displayField",eachHMC);
									mgmtServerObj.put("valueField",eachHMC);
									mgmtServerArr.add(mgmtServerObj);
									String hmcValue = servicesIniFile.getValue("HMC",eachHMC);
									ArrayList tmpHMCList  = StringUtils.egTokenizer(hmcValue,"#");
									if (tmpHMCList != null && !tmpHMCList.isEmpty())
									{
										String replaceHMCStr = "";
										for (int v = 0; v< tmpHMCList.size();v++)
										{
											String tmpHMCListStr = (String) tmpHMCList.get(v);
											if (v == 2)
											{
												if (!tmpHMCListStr.equals("$unconfigured"))
												{
													tmpHMCListStr = EgCrypt.decrypt(tmpHMCListStr);
													if (!aListTcKeywordsLowerCase.contains(tmpHMCListStr.toLowerCase()))
													{
														tmpHMCListStr += "~EG~"; // salt for pwd
														tmpHMCListStr = EgCrypt.encrypt(tmpHMCListStr); 
													}

													if (!StringUtils.isNull(tmpHMCListStr) && tmpHMCListStr.indexOf("#") != -1)
													{
														tmpHMCListStr = StringUtils.replace(tmpHMCListStr, EgConstants.HASH, "~HASH~");
													}
												}

											}
											replaceHMCStr += tmpHMCListStr +"#";
										}
										if (replaceHMCStr.endsWith("#"))
										{
											hmcValue = replaceHMCStr.substring(0,replaceHMCStr.lastIndexOf("#"));
										}
									}
									hmcComboObj.put(eachHMC,hmcValue);
								}
							}
							else
							{
								if (!selectedHMC.equalsIgnoreCase("none") && !selectedHMC.equalsIgnoreCase("other"))
								{
									mgmtServerObj.put("displayField",selectedHMC);
									mgmtServerObj.put("valueField",selectedHMC);
									mgmtServerArr.add(mgmtServerObj);
									rootJson.put("selectedHMC",selectedHMC);
									String hmcValue = servicesIniFile.getValue("HMC",selectedHMC);
									ArrayList tmpHMCList  = StringUtils.egTokenizer(hmcValue,"#");
									if (tmpHMCList != null && !tmpHMCList.isEmpty())
									{
										String replaceHMCStr = "";
										for (int v = 0; v< tmpHMCList.size();v++)
										{
											String tmpHMCListStr = (String) tmpHMCList.get(v);
											if (v == 2)
											{
												if (!tmpHMCListStr.equals("$unconfigured"))
												{
													tmpHMCListStr = EgCrypt.decrypt(tmpHMCListStr);
													if (!aListTcKeywordsLowerCase.contains(tmpHMCListStr.toLowerCase()))
													{
														tmpHMCListStr += "~EG~"; // salt for pwd
														tmpHMCListStr = EgCrypt.encrypt(tmpHMCListStr); 
													}

													if (!StringUtils.isNull(tmpHMCListStr) && tmpHMCListStr.indexOf("#") != -1)
													{
														tmpHMCListStr = StringUtils.replace(tmpHMCListStr, EgConstants.HASH, "~HASH~");
													}
												}

											}
											replaceHMCStr += tmpHMCListStr +"#";
										}
										if (replaceHMCStr.endsWith("#"))
										{
											hmcValue = replaceHMCStr.substring(0,replaceHMCStr.lastIndexOf("#"));
										}
									}
									hmcComboObj.put(selectedHMC,hmcValue);
								}
							}
							mgmtServerObj.put("displayField",_mapping.getTextDescription("admin.test.Other"));
							mgmtServerObj.put("valueField","Other");
							mgmtServerArr.add(mgmtServerObj);
							rootJson.put("mgmtServerArr",mgmtServerArr);
							rootJson.put("hmcComboObj",hmcComboObj);
						}
					}
					else if (paramName.equalsIgnoreCase("executiontime"))
					{
						JSONArray execTimeArr = new JSONArray();
						JSONObject execTimeObj = new JSONObject();
						boolean isTimeComboHide = false;

						rootJson.put("isExecutionTimeParam",true);
						String selectedOption = "";
						if (testName.equals(previousTestName))
						{
							selectedOption = request.getParameter(paramName);
							selectedOption = (selectedOption != null && selectedOption.length() > 0)?selectedOption:"";
						}
						String hourlySelected = "";
						String dailySelected = "";
						if (selectedOption.equals("") && paramValue.equalsIgnoreCase("hourly"))
						{
							hourlySelected = "selected";
							rootJson.put("selectedExecTime","hourly");
							isTimeComboHide = true;
						}
						else if(!selectedOption.equals("") && selectedOption.equalsIgnoreCase("hourly"))
						{
							hourlySelected = "selected";
							rootJson.put("selectedExecTime","hourly");
							isTimeComboHide = true;
						}
						else
						{
							dailySelected = "selected";
							rootJson.put("selectedExecTime","daily");
							isTimeComboHide = false;
						}

						ArrayList hours = new ArrayList();
						for (int m=0;m<24;m++)
						{
							if (m < 10)
							{
								hours.add("0"+String.valueOf(m));
							}
							else
							{
								hours.add(String.valueOf(m));
							}
						}

						ArrayList minutes = new ArrayList();
						for (int m=0;m<60;m++)
						{
							if (m < 10)
							{
								minutes.add("0"+String.valueOf(m));
							}
							else
							{
								minutes.add(String.valueOf(m));
							}
						}
						execTimeObj.put("displayField",_mapping.getTextDescription("admin.test.Hourly"));
						execTimeObj.put("valueField","hourly");
						execTimeArr.add(execTimeObj);
						execTimeObj.put("displayField",_mapping.getTextDescription("admin.test.Daily"));
						execTimeObj.put("valueField","daily");
						execTimeArr.add(execTimeObj);
						rootJson.put("execTimeArr",execTimeArr);
						rootJson.put("isTimeComboHide",isTimeComboHide);

						if (true) //dailySelected.equals("selected"))
						{
							JSONArray execTimeHrsArr = new JSONArray();
							JSONObject execTimeHrsObj = new JSONObject();
							JSONArray execTimeMinsArr = new JSONArray();
							JSONObject execTimeMinsObj = new JSONObject();

							if (!(paramValue.indexOf(":")>-1)) paramValue="00:00";
							String selectedHr = paramValue.substring(0,paramValue.indexOf(":"));
							String selectedMin = paramValue.substring(paramValue.indexOf(":")+1,paramValue.length());
							for (int m=0;m<hours.size();m++)
							{
								String hrs = ((String)hours.get(m)).trim();
								execTimeHrsObj.put("displayField",hrs);
								execTimeHrsObj.put("valueField",hrs);
								execTimeHrsArr.add(execTimeHrsObj);

								if (selectedHr.equals(hrs))
								{
									rootJson.put("selectedHrs",hrs);
								}
							}
							rootJson.put("execTimeHrsArr",execTimeHrsArr);

							for (int m=0;m<minutes.size();m++)
							{
								String mins = ((String)minutes.get(m)).trim();
								execTimeMinsObj.put("displayField",mins);
								execTimeMinsObj.put("valueField",mins);
								execTimeMinsArr.add(execTimeMinsObj);

								if (selectedMin.equals(mins))
								{
									rootJson.put("selectedMins",mins);
								}
							}
							rootJson.put("execTimeMinsArr",execTimeMinsArr);
						}
					}
					else if (paramName.equalsIgnoreCase("Inside_view_using"))
					{
						JSONArray insideViewUsingArr = new JSONArray();
						JSONObject insideViewUsingObj = new JSONObject();

						rootJson.put("selectedInsideViewUsing",paramValue);
						insideViewUsingObj.put("displayField",_mapping.getTextDescription("admin.test.Netbios (Windows)"));
						insideViewUsingObj.put("valueField","exe");
						insideViewUsingArr.add(insideViewUsingObj);
						insideViewUsingObj.put("displayField",_mapping.getTextDescription("admin.test.TCP/WMI (Windows)"));
						insideViewUsingObj.put("valueField","tcp");
						insideViewUsingArr.add(insideViewUsingObj);
						rootJson.put("insideViewUsingArr",insideViewUsingArr);
					}
					else if (paramName.equalsIgnoreCase("is_managed_by"))
					{
						JSONArray managedByArr = new JSONArray();
						JSONObject managedByObj = new JSONObject();

						if (testName.equals(previousTestName))
						{
							String strManagedBy = request.getParameter(paramName);
							if (strManagedBy != null)
							{
								paramValue = strManagedBy;
							}
						}

						rootJson.put("selectedIsManagedBy",paramValue);
						managedByObj.put("displayField",_mapping.getTextDescription("admin.test.HMC"));
						managedByObj.put("valueField","hmc");
						managedByArr.add(managedByObj);
						managedByObj.put("displayField",_mapping.getTextDescription("admin.test.IVM"));
						managedByObj.put("valueField","ivm");
						managedByArr.add(managedByObj);
						rootJson.put("managedByArr",managedByArr);
					}
					else
					{
						JSONArray lastComboArr = new JSONArray();
						JSONObject lastComboObj = new JSONObject();
						lastComboObj.put("displayField",paramValue);
						lastComboObj.put("valueField",paramValue);
						lastComboArr.add(lastComboObj);
						rootJson.put("selectedLastCombo",paramValue);
						rootJson.put("lastComboArr",lastComboArr);
					}
				}
			}
			else if (displayControl.equalsIgnoreCase("password"))
			{
				boolean isEditable = false;

				if (isSnmp)
				{
					String tempValue = paramValue;
					String strVal = null;
					if (testName.equals(previousTestName))
					{
						strVal = request.getParameter(paramName);
					}
					paramValue = (strVal==null)?tempValue:strVal;
				}
				else if (paramName.equalsIgnoreCase("management_password"))
				{
					String strIsManagedByChanged = request.getParameter("isManagedByChanged");
					if (strIsManagedByChanged != null && strIsManagedByChanged.equals("true"))
					{
						String tempPassValue = (String)request.getAttribute("management_password");
						if (tempPassValue != null)
						{
							paramValue = tempPassValue;
							rootJson.put("isStrMangedByChanged",true);
						}
					}

					String strMgtPwd = EgCrypt.decrypt(paramValue);
					if (!aListTcKeywordsLowerCase.contains(strMgtPwd.toLowerCase()))
					{
						strMgtPwd += "~EG~"; // salt for pwd
						strMgtPwd = EgCrypt.encrypt(strMgtPwd); 
					}

					rootJson.put("tempPassValue",strMgtPwd);
				}

				if(paramValue.indexOf("|") > -1)
				{
					String tempStrs = "";
					StringTokenizer st1 = new StringTokenizer(paramValue,"|");
					while(st1.hasMoreTokens())
					{
						String strMultiPwd = EgCrypt.decrypt(st1.nextToken());
						if (!aListTcKeywordsLowerCase.contains(strMultiPwd.toLowerCase()))
						{
							strMultiPwd += "~EG~"; // salt for pwd
							strMultiPwd = EgCrypt.encrypt(strMultiPwd); 
						}

						tempStrs += strMultiPwd + "#~#";
					}
					paramValue = tempStrs.substring(0, tempStrs.length()-3);
				}
				else
				{
					paramValue = EgCrypt.decrypt(paramValue);

					if(paramValue.indexOf("#~#") > -1)
					{
						String tempStr = "";
						ArrayList st1 = StringUtils.myTokenizer(paramValue, "#~#");
						for(int m=0;m<st1.size();m++)
						{
							String tmpPwd =  EgCrypt.decrypt(st1.get(m).toString());

							if (paramName.equals("Two_factor_auth_password") && tmpPwd.equalsIgnoreCase("none"))
							{
								tmpPwd = tmpPwd.toLowerCase();
							}

							tmpPwd += "~EG~"; 
							tmpPwd = EgCrypt.encrypt(tmpPwd); 
							tempStr += tmpPwd + "#~#";
						}
						paramValue = tempStr.substring(0, tempStr.length()-3);
					}
					else if (!aListTcKeywordsLowerCase.contains(paramValue.toLowerCase()))
					{
						if (paramName.equals("Two_factor_auth_password") && paramValue.equalsIgnoreCase("none"))
						{
							paramValue = paramValue.toLowerCase();
						}
						paramValue += "~EG~"; // salt for pwd
						paramValue = EgCrypt.encrypt(paramValue); 
					}
				}

		//		if (paramValue.indexOf("\"") > -1)
		//		{
		//			paramValue = StringUtils.replace(paramValue,"\"","&#34;");
		//		}

				if (readOnlyParamIdx > -1 && multiUserMode && hasMultipleUsers)
				{
					readOnly = "readOnly";
					isEditable = true;
				}
				if (readOnlyParamIdx > -1 && multiNamePatternMode && hasMultipleNames)
				{
					readOnly = "readOnly";
					isEditable = true;
				}
				rootJson.put("password"+paramName,paramValue);
				rootJson.put("isEditable"+paramName,isEditable);

				String confirmPassLabel=egTestParamIni.getValue("CONFIRM_PASSWORD_LABEL",paramName);
				String confPassTxt = _mapping.getTextDescription("CONFIRM PASSWORD");
				if (!StringUtils.isNull(confirmPassLabel) && confirmPassLabel.length() > 0)
				{
					confPassTxt = confirmPassLabel;
				}

				if (!readOnly.equals("readOnly"))
				{
					if (showStar)
					{
						paramNameObj.put(paramName+"confirmpassword","*"+confPassTxt);
					}
					else
					{
						paramNameObj.put(paramName+"confirmpassword",confPassTxt);
					}
				}
				else
				{
					paramNameObj.put(paramName+"confirmpassword",confPassTxt);
				}

			}
			else if (displayControl.equalsIgnoreCase("textarea"))
			{
				boolean isEnableButton = false;
				String temp = paramValue;
				String strVal = null;
				if (testName.equals(previousTestName))
				{
					strVal = request.getParameter(paramName);
				}
				paramValue = (strVal==null)?temp:strVal;

				if (testInfoDelimiter.length() > 0 && paramValue.indexOf(testInfoDelimiter) > -1)
				{
					paramValue = StringUtils.replace(paramValue, testInfoDelimiter, EgConstants.COMMA);
				}
				else if (paramValue.indexOf(EgConstants.PIPE) > -1)
				{
					paramValue = StringUtils.replace(paramValue, EgConstants.PIPE, EgConstants.COMMA);
					rootJson.put("pipeParamValue",paramValue);
				}
				if (strDelimiterMask.length() > 0 && paramValue.indexOf(strDelimiterMask) != -1)
				{
					paramValue = StringUtils.replace(paramValue,strDelimiterMask,testInfoDelimiter);
				}
				if ((paramName.equalsIgnoreCase("process") || paramName.equalsIgnoreCase("serviceName")) && paramValue.equalsIgnoreCase("(EG_RUNTIME)"))
				{
					isEnableButton = true;
					rootJson.put("btnLink","javascript:configureOSPattern('"+componentType+"','"+testName+"','"+paramName+"');");
				}
				rootJson.put("isEnableButton",isEnableButton);
				rootJson.put("textArea"+paramName,paramValue);
			}
			else
			{
				if (isSnmp || isPolicyParamExists || isUrlParamExist || isWsdlUrlExist || paramName.equalsIgnoreCase("real_ServerName"))
				{
					String tempValue = paramValue;
					String strVal = null;
					if (testName.equals(previousTestName))
					{
						strVal = request.getParameter(paramName);
					}
					paramValue = (strVal==null)?tempValue:strVal;
				}

				if(paramName.equalsIgnoreCase("url"))
				{
					String fullURLValue = "";
					if (isCredentialParamExist)
					{
						fullURLValue = paramValue.trim();
						previousUrl = (previousUrl == null)?"":previousUrl;
						if (previousUrl.equals(paramValue))
						{
							//paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
							paramValue = paramValue.trim();
							if (paramValue.indexOf("|") > -1)
							{
								String decodedUrl = "";
								String strUrlName = "";
								StringTokenizer st12 = new StringTokenizer(paramValue,"|");
								String tempUrl = "";
								while (st12.hasMoreTokens())
								{
									tempUrl = st12.nextToken();
									if (tempUrl.indexOf("?") > -1)
									{
										int urlIndex = tempUrl.indexOf("?");
										tempUrl = tempUrl.substring(0, urlIndex) + "?" + URLDecoder.decode(tempUrl.substring(urlIndex + 1));
									}

									
									if (decodedUrl != null && !decodedUrl.equals(""))
									{
										decodedUrl = decodedUrl + "|" + tempUrl;
									}
									else
									{
										decodedUrl = tempUrl;
									}
									
									if (strUrlName != null && !strUrlName.equals(""))
									{
										strUrlName = strUrlName + "|" + tempUrl.substring(0,tempUrl.indexOf(":"));
									}
									else
									{
										strUrlName = tempUrl.substring(0,tempUrl.indexOf(":"));
									}
								}
								//paramValue = decodedUrl;

								if (testName.equals("HttpTest") || 
									testName.equals("HttpPostTest") || 
									testName.equals("SMHttpTest") || 
									testName.equals("AzureWebAcsTest") || 
									testName.equals("DownSpeedTest"))
								{
									paramValue = strUrlName;
								}
								else
								{
									paramValue = decodedUrl;
								}
							}
							else
							{
								if (paramValue.indexOf("?") > -1)
								{
									int vecValIndex = paramValue.indexOf("?");
									paramValue = paramValue.substring(0, vecValIndex) + "?" + URLDecoder.decode(paramValue.substring(vecValIndex + 1));
								}

								if (testName.equals("HttpTest") || 
									testName.equals("HttpPostTest") || 
									testName.equals("SMHttpTest") || 
									testName.equals("AzureWebAcsTest") || 
									testName.equals("DownSpeedTest"))
								{
									paramValue = paramValue.substring(0, paramValue.indexOf(":"));
								}
							}
						}

						if(paramValue.indexOf("|") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"|",",");
						}

						if (paramValue.indexOf("~egHash~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~egHash~","#");
						}
						hiddenObj.put("hiddenURLs",EgURLDecoder.decode(fullURLValue,"UTF-8"));
						rootJson.put("urlParamValue",paramValue);
						rootJson.put("isPrivateKeyParamExist",isPrivateKeyParamExist);
						rootJson.put("urlLink","config_popup('./EgConfigureUrlAndCredentials.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&isPrivateKeyParamExist="+isPrivateKeyParamExist+"&isSystemPropKeyParamExist="+isSystemPropKeyParamExist+"','','scrollbars=yes,width=900,height=500,top=150,left=50')");
						rootJson.put("imageTitle",_mapping.getTextDescription("admin.test.Click here to view/configure URL and credentials"));

						rootJson.put("isHiddenUrls",false);
						if (testName.equals("HttpTest") || 
						testName.equals("HttpPostTest") || 
						testName.equals("SMHttpTest") || 
						testName.equals("AzureWebAcsTest") || 
						testName.equals("DownSpeedTest"))
						{
							rootJson.put("isHiddenUrls",true);
						}

					}
					else
					{
						paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
						rootJson.put("urlParamValue",paramValue);
						rootJson.put("urlLink","javascript:openSmallWindow('"+paramName+"')");
					}
				}
				else if(paramName.equalsIgnoreCase("WSDL_URL"))
				{
					if (isCredentialParamExist)
					{
						previousUrl = (previousUrl == null)?"":previousUrl;
						if (previousUrl.equals(paramValue))
						{
							paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
						}

						if(paramValue.indexOf("|") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"|",",");
						}

						if (paramValue.indexOf("~egHash~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~egHash~","#");
						}
						rootJson.put("wsdlUrlParamValue",paramValue);
						rootJson.put("wsdlLink","config_popup('./EgConfigureWsdlUrlAndCredentials.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"','','scrollbars=yes,width=900,height=500,top=150,left=50')");
						rootJson.put("wsdlUrlImgTitle",_mapping.getTextDescription("amin.test.Click here to view/configure URL and credentials"));

					}
					else
					{
						paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
						rootJson.put("wsdlUrlParamValue",paramValue);
						rootJson.put("wsdlLink","javascript:openSmallWindow('"+paramName+"')");
					}
				}
				else if (paramName.equalsIgnoreCase("management_user"))
				{
					String strIsManagedByChanged = request.getParameter("isManagedByChanged");
					rootJson.put("isManagedByChanged",strIsManagedByChanged);
					if (strIsManagedByChanged == null)
					{
						rootJson.put("tempUser",paramValue);
					}
					else
					{
						String tempUser = (String)request.getAttribute("management_user");
						if (tempUser != null)
						{
							paramValue = tempUser;
						}
						rootJson.put("tempUser",paramValue);
					}
				}
				else if(paramName.equalsIgnoreCase("Target_DiskIO_Rate"))
				{
					String tempTargetDiskIORate = "";
					String tempTargetDiskIORateValue = "";

					if (paramValue.equalsIgnoreCase("$unconfigured"))
					{
						tempTargetDiskIORateValue = paramValue;
					}
					else
					{
						tempTargetDiskIORate = paramValue.substring(0,paramValue.indexOf("_"));
						tempTargetDiskIORateValue = paramValue.substring(paramValue.indexOf("_")+1,paramValue.length());
						paramValue = tempTargetDiskIORateValue;
					}

					JSONArray targetDiskIORateLabelArr = new JSONArray();
					JSONObject targetDiskIORateLabelObj = new JSONObject();

					for (int k=0;k<targetDiskIORateLabel.length;k++)
					{
						String strTargetDiskIORateLabel = targetDiskIORateLabel[k];
						String strTargetDiskIORateValue = targetDiskIORateValue[k];
						targetDiskIORateLabelObj.put("displayField",strTargetDiskIORateLabel);
						targetDiskIORateLabelObj.put("valueField",strTargetDiskIORateValue);

						if (strTargetDiskIORateValue.equalsIgnoreCase(tempTargetDiskIORate))
						{
							rootJson.put("targetDiskIORateSelect",tempTargetDiskIORate);
						}
						targetDiskIORateLabelArr.add(targetDiskIORateLabelObj);
					}
					rootJson.put("targetDiskIORateLabelArr",targetDiskIORateLabelArr);
					rootJson.put("targetDiskIOParamValue",paramValue);
				}
				else if ((testName.equalsIgnoreCase("WindowshareTest") || testName.equalsIgnoreCase("UNCCheckTest")) && 
					paramName.equalsIgnoreCase("sharename"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
					hiddenObj.put(paramName,paramValue);
					rootJson.put("shareNameParamValue",paramValue);
					rootJson.put("shareNameLink","config_popup('./EgConfigureWinSharedFolders.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"','','scrollbars=yes,width=900,height=500,top=150,left=50')");
					rootJson.put("btnLabel"+paramName,_mapping.getTextDescription("admin.test.To view/configure shared folders for monitoring")+",&nbsp;"+_mapping.getTextDescription("admin.common.click here"));
				}
				else if (isSystemPropertyParamTests && (paramName.equalsIgnoreCase("system_property_key") || paramName.equalsIgnoreCase("system_property_value")))
				{
					if (paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
					if (paramName.equalsIgnoreCase("system_property_key"))
					{
						rootJson.put("sysPropKey",paramValue);
					}
					else if (paramName.equalsIgnoreCase("system_property_value"))
					{
						hiddenObj.put(paramName,paramValue);
					}
				}
				else
				{
					String destinationPage = "";
					String plusButton = "";
					String onBlurStr  = "";
					String onFocusStr = "";
					String onChangeStr = "";
					if (multiUserMode && readOnlyParamIdx>-1)
					{
						if (hasMultipleUsers)
						{
							readOnly = "readOnly";
						}
						if (paramName.equalsIgnoreCase("user"))
						{
							destinationPage = "EgConfigureMultipleUsers.jsp";
						}
						else
						{
							destinationPage = "VmgUsers.jsp";
						}
						if (paramName.equalsIgnoreCase("admin_user") || paramName.equalsIgnoreCase("user") ||		paramName.equalsIgnoreCase("connection_server_name"))
						{
							rootJson.put("destinationPage",destinationPage);
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./"+destinationPage+"?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname=\',\'\',\'scrollbars=yes,width=900,height=380,top=150,left=50\')\">";

						}
						onBlurStr =  "javascript:checkMultipleUser('"+paramName+"','"+paramValue+"')";
						onFocusStr = "javascript:getUserValue('"+paramName+"')"; 
						onChangeStr = "javascript:getUserChangedValue('"+paramName+"')";

						if (paramName.equalsIgnoreCase("published_resources"))
						{
							hiddenObj.put("hiddenPublishedResource",paramValue);
						}

					}
					if (multiNamePatternMode && readOnlyParamIdx>-1)
					{
						if (hasMultipleNames)
						{
							readOnly = "readOnly";
						}
						if (paramName.equalsIgnoreCase("name"))
						{
							destinationPage = "EgConfigureNamePattern.jsp";
							rootJson.put("destinationPage",destinationPage);
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure url pattern(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./"+destinationPage+"?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname=\',\'\',\'scrollbars=yes,width=900,height=380,top=150,left=50\')\">";
						}
						
						onBlurStr =  "javascript:checkMultipleNamePattern('"+paramName+"','"+paramValue+"')";
						onFocusStr = "javascript:getNamePatternValue('"+paramName+"')"; 
						onChangeStr = "javascript:getNamePatternChangedValue('"+paramName+"')";
					}

					if(paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
					if (paramValue.indexOf("~#~") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"~#~",";");
					}

					if (paramName.equalsIgnoreCase("published_resources") && paramValue.indexOf(";") != -1)
					{
						paramValue = StringUtils.replace(paramValue,";",",");
					}

					boolean isReadOnly = false;
					if (!StringUtils.isNull(readOnly) && readOnly.equals("readOnly"))
					{
						isReadOnly = true;
					}

					if(pwdParamReadOnly)
					{
						String password_para[] = (String[])password_param.toArray(new String[0]);
						for(int m=0; m<password_para.length; m++)
						{
							isReadOnly = true;
						}
					}
					rootJson.put("readOnly"+paramName,isReadOnly);
					if (multiUserMode || multiNamePatternMode)
					{
						if (readOnlyParamIdx > -1)
						{
							rootJson.put("multiUserOrNameParamValue"+paramName,paramValue);
							rootJson.put("onBlurStr"+paramName,onBlurStr);
							rootJson.put("onFocusStr"+paramName,onFocusStr);
							rootJson.put("onChangeStr"+paramName,onChangeStr);
							rootJson.put("plusButton"+paramName,plusButton);
						}
						else
						{
							rootJson.put("multiUserOrNameParamValue"+paramName,paramValue);
							if (paramValue.length() > 20 && readOnly.equals(""))
							{
								String tmpViewLink = "javascript:openSmallWindow('"+paramName+"')";
								rootJson.put("viewBtnLink"+paramName,tmpViewLink);
							}
						}
					}
					else
					{
						rootJson.put("remainParamValue"+paramName,paramValue);
						if (paramValue.length() > 20)
						{
							rootJson.put("viewLink"+paramName,"javascript:openSmallWindow('"+paramName+"')" );
						}
					}
				}
			}
		}
		rootJson.put("paramNameObj",paramNameObj);

		session.setAttribute("aListParamNamesValues",aListParamNamesValues);
		session.setAttribute("aListDisplay",aListDisplay);
		session.setAttribute("aListParamsWithDoubleQuotes",aListParamsWithDoubleQuotes);
		session.setAttribute("isOldSnmp",new Boolean(isOldSnmp));

		hiddenObj.put("allowedParams",allowedParams);
		hiddenObj.put("strTcKeywords",strTcKeywords);
		hiddenObj.put("strDoubleQuotesParams",strDoubleQuotesParams);
	}

	hiddenObj.put("previousTestType",testType);
	hiddenObj.put("previousComponentType",componentType);
	hiddenObj.put("previousTestName",testName);
	hiddenObj.put("isCredentialParamExist",isCredentialParamExist);
	hiddenObj.put("delimiter",strDelimiter);
	hiddenObj.put("delimiterMask",strDelimiterMask);

	session.setAttribute("adminLastAccessedURL","/final/admin/EgDefaultTestConfiguration.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&previousComponentType="+EgURLEncoder.encode(previousComponentType,"UTF-8")+"&testType="+testType+"&previousTestType="+testType+"&testName="+EgURLEncoder.encode(testName,"UTF-8"));

	//used for help page support.when data.jsp is clicked
	aListPages.add("/final/admin/EgDefaultTestConfiguration.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&previousComponentType="+EgURLEncoder.encode(previousComponentType,"UTF-8")+"&testType="+testType+"&previousTestType="+testType+"&testName="+EgURLEncoder.encode(testName,"UTF-8"));
	if (aListPages.size() > 2)
	{
		aListPages.remove(0);
	}
	session.setAttribute("aListPages",aListPages);
	rootJson.put("hiddenObj",hiddenObj);
	out.println(rootJson.toString());
%>

<%!

	private ArrayList arrangeKeyAgentIniOrder(ArrayList paramSetKeys,ArrayList aListResultantTempInLowerCase)
	{
		if (aListResultantTempInLowerCase == null || aListResultantTempInLowerCase.isEmpty())
		{
			return paramSetKeys;
		}

		ArrayList resultList = new ArrayList();
		for (int i=0;i<paramSetKeys.size();i++)
		{
			String strParam = paramSetKeys.get(i).toString();
			if (resultList != null && !resultList.isEmpty())
			{
				ArrayList tmpList = new ArrayList();
				tmpList.addAll(resultList);

				int size = resultList.size();
				boolean isArragePerformed = false;
				for( int res=0;res<size;res++)
				{
					String prevParam = resultList.get(res).toString();
					int prevParamIdx = aListResultantTempInLowerCase.indexOf("-"+prevParam.toLowerCase());
					int currParamIdx = aListResultantTempInLowerCase.indexOf("-"+strParam.toLowerCase());
					if (prevParamIdx == -1 && currParamIdx == -1)
					{
						continue;
					}
					else if (currParamIdx == -1)
					{
						continue;
					}
					else if (prevParamIdx == -1)
					{
						isArragePerformed = true;
						if (!tmpList.contains(strParam))
						{
							tmpList.add(res,strParam);
						}
						continue;
					}

					if (prevParamIdx > currParamIdx)
					{
						isArragePerformed = true;
						if (!tmpList.contains(strParam))
						{
							tmpList.add(res,strParam);
						}
					}
				}

				if (isArragePerformed)
				{
					resultList = new ArrayList();
					resultList.addAll(tmpList);
				}
				else
				{
					if (!resultList.contains(strParam))
					{
						resultList.add(strParam);
					}
				}
			}
			else
			{
				resultList.add(strParam);
			}
		}
		return resultList;
	}

	private ArrayList getUpdatedResultantListInLowercase(ArrayList aResultant)
	{
		ArrayList returnList = new ArrayList();
		if (aResultant == null || aResultant.isEmpty())
		{
			return returnList;
		}

		for (int i=0;i<aResultant.size();i++)
		{
			String strResult = aResultant.get(i).toString();
			returnList.add(strResult.toLowerCase());
		}
		return returnList;
	}

	private ArrayList getHiddenPwdProfile(ArrayList aResultant)
	{
		ArrayList returnList = new ArrayList();
		if (aResultant == null || aResultant.isEmpty())
		{
			return returnList;
		}

		boolean modeParamProcess = false;
		boolean measureModeParamProcess = false;
		boolean measurementModeParamProcess = false;
		boolean useSapControlProcess = false;
		int condParamIdx = aResultant.indexOf("-mode");
		if (condParamIdx != -1)
		{
			String modeValue = ((String)aResultant.get(condParamIdx+1)).trim();
			if (modeValue.equalsIgnoreCase("true"))
			{
				returnList.add("mode_true");
				returnList.add("username");
			}
			else
			{
				returnList.add("mode_false");
				returnList.add("Jmx_user");
			}
			return returnList;
		}

		condParamIdx = aResultant.indexOf("-measurement_mode");
		if (condParamIdx != -1)
		{
			String modeValue = ((String)aResultant.get(condParamIdx+1)).trim();
			if (modeValue.equalsIgnoreCase("true"))
			{
				//int modeTrueParamIdx = Arrays.binarySearch(modeTrueToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				//if (modeTrueParamIdx > -1) continue;
				returnList.add("measurement_mode_true");
				returnList.add("username");


			}
			else
			{
				returnList.add("measurement_mode_false");
				returnList.add("Jmx_user");
			}
			return returnList;
		}

		condParamIdx = aResultant.indexOf("-measure_mode");
		if (condParamIdx != -1)
		{
			String modeValue = ((String)aResultant.get(condParamIdx+1)).trim();
			if (modeValue.equalsIgnoreCase("true"))
			{
				//int modeTrueParamIdx = Arrays.binarySearch(modeTrueToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				//if (modeTrueParamIdx > -1) continue;
				returnList.add("measure_mode_true");
				returnList.add("JREHome");
			}
			else
			{
				returnList.add("measure_mode_false");
				returnList.add("Jmx_user");
			}
		}

		condParamIdx = aResultant.indexOf("-use_sapcontrol");
		if (condParamIdx != -1)
		{
			String modeValue = ((String)aResultant.get(condParamIdx+1)).trim();
			if (modeValue.equalsIgnoreCase("true"))
			{
				returnList.add("use_sapcontrol_true");
				returnList.add("os_password");
			}
			else
			{
				returnList.add("use_sapcontrol_false");
				returnList.add("sapuser");
			}
		}

		condParamIdx = aResultant.indexOf("-snmpversion");
		if (condParamIdx != -1)
		{
			String snmpVersion = ((String)aResultant.get(condParamIdx+1)).trim();
			if (snmpVersion.equalsIgnoreCase("v3"))
			{
				returnList.add("snmpversion_true");
				returnList.add("username");
			}
			else
			{
				returnList.add("snmpversion_false");
				returnList.add("snmpcommunity");
			}
		}

		return returnList;
	}

	private boolean isMultiUserParamExists(ArrayList aResultant, String[] multiUserReadOnlyParam)
	{
		boolean isParamExists = false;
		if (aResultant == null || multiUserReadOnlyParam == null)
		{
			return isParamExists;
		}

		if (multiUserReadOnlyParam != null && multiUserReadOnlyParam.length > 0)
		{
			for (int mul=0;mul<multiUserReadOnlyParam.length ;mul++ )
			{
				String strMultiUserParam = multiUserReadOnlyParam[mul];
				if (aResultant.contains("-"+strMultiUserParam))
				{
					isParamExists = true;
					break;
				}
			}
		}
		return isParamExists;
	}

	private boolean checkParamIsUserField(String paramName)
	{
		boolean isUserNameParamExists = false;

		if (paramName == null)
		{
			return isUserNameParamExists;
		}

		if (paramName.toLowerCase().equals("user") ||  
			paramName.toLowerCase().equals("username") ||
			paramName.toLowerCase().equals("user_name") ||
			paramName.toLowerCase().endsWith("user") ||
			paramName.toLowerCase().endsWith("username") ||
			paramName.toLowerCase().endsWith("user_name") ||
			paramName.toLowerCase().indexOf("user") != -1)
		{
			isUserNameParamExists = true;
		}
		return isUserNameParamExists;
	}

	private boolean checkParamIsDomainField(String paramName)
	{
		boolean isDomainParamExists = false;

		if (paramName == null)
		{
			return isDomainParamExists;
		}

		if (paramName.toLowerCase().equals("domain") ||  
			paramName.toLowerCase().equals("domainname") ||
			paramName.toLowerCase().equals("domain_name") ||
			paramName.toLowerCase().endsWith("domain") ||
			paramName.toLowerCase().endsWith("domain_name") ||
			paramName.toLowerCase().endsWith("domainname"))
		{
			isDomainParamExists = true;
		}
		return isDomainParamExists;
	}

	private boolean checkParamIsPasswordField(String paramName)
	{
		boolean isPasswordParamExists = false;

		if (paramName == null)
		{
			return isPasswordParamExists;
		}

		if (paramName.toLowerCase().equals("password") ||  
			paramName.toLowerCase().endsWith("password") ||
			paramName.toLowerCase().indexOf("pass") != -1 ||
			paramName.toLowerCase().indexOf("password") != -1)
		{
			isPasswordParamExists = true;
		}
		return isPasswordParamExists;
	}


%>



