<%
/*****************************************************************************
*	Name			:	ConfigureGlobalThreshTestsp.jsp
*	Purpose			:	Process page for Fixed Thresholds Tests
*	Version         :   4.0
*	CreationDate	:	10/07/2007
*	Last Modified	:	13/07/2007 by Saravanan.A
*	Author			:	Saravanan.A
******************************************************************************/
%>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.IniHelper"%>
<%@ page import="com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgThresholdInfo"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%
     response.setHeader("Cache-Control","no-store");
     response.setHeader("Pragma","no-cache");
     response.setDateHeader("Expires", -1);
%>
<%
	String currentlyManaged = request.getParameter("currentValue");
	String previouslyManaged = request.getParameter("pfmanage");
	String mServers = request.getParameter("fmanage");
	EgThresholdInfo threshInfo = new EgThresholdInfo("manager");
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Thresholds");
	auditLogThread.setValue("Activity","Global Thresholds");

	int count = 0;
	Vector cVector = new Vector();
	if(currentlyManaged !=null && !currentlyManaged.equalsIgnoreCase("null") && currentlyManaged.trim().length() >0)
	{
		StringTokenizer st = new StringTokenizer(currentlyManaged,",");
		if(st.countTokens()>0)
			while(st.hasMoreTokens())
				cVector.add(st.nextToken());
	}

	if(previouslyManaged !=null && !previouslyManaged.equalsIgnoreCase("null") && previouslyManaged.trim().length() >0)
	{
		StringTokenizer st = new StringTokenizer(previouslyManaged,",");
		if(st.countTokens()>0)
		{
			while(st.hasMoreTokens())
			{
				String temp = (String) st.nextToken();
				if(!cVector.contains(temp))
				{
					count++;
					auditLogThread.setCurrentValue("Disassociated Tests","$test$:"+temp);
				}
				else
					cVector.remove(temp);
			}
			if(count > 1)
				auditLogThread.setValue("Description","Tests have been disassociated from global thresholds");
			else
				auditLogThread.setValue("Description","Test has been disassociated from global thresholds");
		}
	}
	
	if(cVector.size()>0)
	{
		for(int i=0;i<cVector.size();i++)
			auditLogThread.setCurrentValue("Associated Tests","$test$:"+(String)cVector.get(i));		
		if(cVector.size()>1)
			auditLogThread.setValue("Description","Tests have been associated to global thresholds");
		else
			auditLogThread.setValue("Description","Test has been associated to global thresholds");
	}
	auditLogThread.sendItToDB();
	/* code for auditlog ends */


	String key = "";
	String value = "";
	String testName = "";

	ArrayList iniEntries = new ArrayList();
	ArrayList testsToAssociate = new ArrayList();
	Enumeration e = request.getParameterNames();
	while(e.hasMoreElements())
	{
		key =(String) e.nextElement();
		value = request.getParameter(key);
		if (value != null && !value.equals(""))
		{
			StringTokenizer st = new StringTokenizer(value, "$$");
			while(st.hasMoreTokens())
			{
				testName = st.nextToken();
				int index = testName.indexOf("(");
				if(index != -1)
				{
					testName = testName.substring(0,index);
				}
				if(key != null && key.trim().equals("fmanage"))
				{
					iniEntries.add(new IniHelper(IniHelper.SET,"GLOBAL_THRESHOLDS",testName,"yes"));
					testsToAssociate.add(testName);
				}
				if(key != null && key.trim().equals("funmanage"))
				{
					iniEntries.add(new IniHelper(IniHelper.DELETE,"GLOBAL_THRESHOLDS",testName,""));
				}
			}
		}
	}

	HashMap nonSQCEntries = threshInfo.getNonSQCvaluesForGlobalThreshold(testsToAssociate);
	
	IniFile fileSyncThresh = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egThresholdConfigFile);
	IniFile fileSyncTests = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egTestConfigFile); //eg_tests.ini
	for (int i=0; i<iniEntries.size(); i++)
	{
		IniHelper ini = (IniHelper)iniEntries.get(i);
		String action = ini.getAction();
		String sub = ini.getSubject();
		String var = ini.getVariable();
		String val = ini.getValue();
		if (action != null && action.equals(IniHelper.SET))
		{
			fileSyncTests.setValue(sub,var,val);
			String nonSQCEntry = (String)nonSQCEntries.get(var);
			if (nonSQCEntry != null && nonSQCEntry.length() > 0)
			{
				fileSyncThresh.setValue("DEFAULT_THRESHOLDS",var,nonSQCEntry);
			}
		}
		else if (action != null && action.equals(IniHelper.DELETE))
		{
			fileSyncTests.deleteValue(sub,var);
		}
	}
	fileSyncThresh.saveFile();
	fileSyncTests.saveFile();
	EgConfigFilesSync.releaseInstance(fileSyncTests);
	EgConfigFilesSync.releaseInstance(fileSyncThresh);
	
	String ur = "ConfigureGlobalThreshTests.jsp";
%>
	<jsp:forward page="<%=ur%>"/>


