<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgURLDecoder"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "java.util.*"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="java.io.*"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("text/html;charset=UTF-8");
	JSONObject rootJson = new JSONObject();

	String operationCompMeasure = request.getParameter("operationCompMeasure");
	Hashtable compTestDetails = (Hashtable)session.getAttribute("compTestDetails");
	Vector compMeasureExist = null;
	if(compTestDetails.containsKey("MEASURE_NAMES"))
	{
		compMeasureExist = (Vector)compTestDetails.get("MEASURE_NAMES");
	}
	//don't move the below block anywhere
	//block starts
	String measure = request.getParameter("measure");
	if(operationCompMeasure.equalsIgnoreCase("addCompMeasure"))
	{
		int max_idx = 0;
		if(compMeasureExist != null && !compMeasureExist.isEmpty())
		{
			for(int i=0;i<compMeasureExist.size();i++)
			{
				String existingMeasure = (String)compMeasureExist.get(i);
				try
				{
					int idx = existingMeasure.lastIndexOf("_");
					if(idx>0)
					{
						int this_idx = Integer.parseInt(existingMeasure.substring(idx+1));
						if(max_idx<this_idx)
						{
							max_idx=this_idx;
						}
					}
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
			}
		}
		measure = "m_"+(max_idx+1);
	}
	rootJson.put("measureName",measure);
	//block ends
	String compTest = request.getParameter("test");
	String displayName = egurkha.EgUIUtils.decodeSecurityChar(request.getParameter("displayName"));
	if(displayName != null && (displayName=displayName.trim()).length()>0 && !displayName.equalsIgnoreCase("null"))
	{
		displayName = EgURLDecoder.decode(displayName,"UTF-8");
	}
	String alarmDisplayString = egurkha.EgUIUtils.decodeSecurityChar(request.getParameter("alarmDisplayString"));
	if(alarmDisplayString != null && (alarmDisplayString=alarmDisplayString.trim()).length()>0 && !alarmDisplayString.equalsIgnoreCase("null"))
	{
		alarmDisplayString = EgURLDecoder.decode(alarmDisplayString,"UTF-8");
	}
	String s_measure_details = request.getParameter("s_measure_details");
	String compTestAndMeasure=compTest+":"+measure;
	IniFile compMetrixLang = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_composite_lang_en_US.ini");
	Vector vars = compMetrixLang.getVariables("MEASURE_NAME_MAPPING",true);
	Vector vals = compMetrixLang.getAllValues("MEASURE_NAME_MAPPING");
	ArrayList existingNames = new ArrayList();
	if(vars != null)
	{
		String key = compTest+":";
		for(int i=0;i<vars.size();i++)
		{
			String var = (String)vars.get(i);
			if(var.equals(compTestAndMeasure))
				continue;
			if(var.startsWith(key))
			{
				String val = (String)vals.get(i);
				if(val.equalsIgnoreCase(displayName))
				{
					existingNames.add(val.toLowerCase());
				}
			}
		}
	}
	
	Vector avars = compMetrixLang.getVariables("ALARM_DISPLAY_STRING",true);
	Vector avals = compMetrixLang.getAllValues("ALARM_DISPLAY_STRING");
	ArrayList existingADSNames = new ArrayList();
	if(avars != null)
	{
		String key = compTest+":";
		for(int i=0;i<avars.size();i++)
		{
			String avar = (String)avars.get(i);
			if(avar.equals(compTestAndMeasure))
				continue;
			if(avar.startsWith(key))
			{
				String aval = (String)avals.get(i);
				if(aval.equalsIgnoreCase(alarmDisplayString))
				{
					existingADSNames.add(aval.toLowerCase());
				}
			}
		}
	}

	boolean isNewMeasureDisplayInMemory = false;
	if(operationCompMeasure.equalsIgnoreCase("addCompMeasure") && compTestDetails.containsKey("MEASURE_NAME_MAPPING"))
	{
		Hashtable mnm = (Hashtable)compTestDetails.get("MEASURE_NAME_MAPPING");
		Iterator itr1 = mnm.keySet().iterator();
		while(itr1.hasNext())
		{
			String key = (String)itr1.next();
			String exVal = (String)mnm.get(key);
			if(displayName.equalsIgnoreCase(exVal))
			{
				isNewMeasureDisplayInMemory=true;
			}
		}
	}
	boolean isNewAlarmDisplayInMemory = false;
	if(operationCompMeasure.equalsIgnoreCase("addCompMeasure") && compTestDetails.containsKey("ALARM_DISPLAY_STRING"))
	{
		Hashtable mnm = (Hashtable)compTestDetails.get("ALARM_DISPLAY_STRING");
		Iterator itr1 = mnm.keySet().iterator();
		while(itr1.hasNext())
		{
			String key = (String)itr1.next();
			String exVal = (String)mnm.get(key);
			if(alarmDisplayString.equalsIgnoreCase(exVal))
			{
				isNewAlarmDisplayInMemory=true;
			}
		}
	}
	if(operationCompMeasure.equalsIgnoreCase("addCompMeasure") && compMeasureExist != null && compMeasureExist.contains(measure))
	{
		rootJson.put("messageType","Alert");
		String msg = _mapping.getTextDescription("admin.ic.You are trying to add a measure name which already exists");
		msg += ".<br>" + _mapping.getTextDescription("admin.ic.Please enter a new measure name");
		rootJson.put("message",msg);
	}
	else if(existingNames.contains(displayName.toLowerCase()))
	{
		rootJson.put("messageType","Alert");
		String msg = _mapping.getTextDescription("admin.ic.You are trying to add a measure display name which already exists");
		msg += ".<br>" + _mapping.getTextDescription("admin.ic.Please enter a new measure display name");
		rootJson.put("message",msg);
	}
	else if(operationCompMeasure.equalsIgnoreCase("addCompMeasure") && isNewMeasureDisplayInMemory)
	{
		rootJson.put("messageType","Alert");
		String msg = _mapping.getTextDescription("admin.ic.You are trying to add a measure display name which already exists");
		msg += ".<br>" + _mapping.getTextDescription("admin.ic.Please enter a new measure display name");
		rootJson.put("message",msg);
	}
	else if(existingADSNames.contains(alarmDisplayString.toLowerCase()))
	{
		rootJson.put("messageType","Alert");
		String msg = _mapping.getTextDescription("admin.ic.You are trying to add an alarm display string which already exists");
		msg += ".<br>" + _mapping.getTextDescription("admin.ic.Please enter a new alarm display string");
		rootJson.put("message",msg);
	}
	else if(operationCompMeasure.equalsIgnoreCase("addCompMeasure") && isNewAlarmDisplayInMemory)
	{
		rootJson.put("messageType","Alert");
		String msg = _mapping.getTextDescription("admin.ic.You are trying to add an alarm display string which already exists");
		msg += ".<br>" + _mapping.getTextDescription("admin.ic.Please enter a new alarm display string");
		rootJson.put("message",msg);
	}
	else if(operationCompMeasure.equalsIgnoreCase("addCompMeasure") && (s_measure_details == null || s_measure_details.trim().indexOf("~")==-1))
	{
		rootJson.put("messageType","Alert");
		String msg = _mapping.getTextDescription("admin.ic.You are trying to add a performance rating test measure with out associated measure(s)");
		msg += ".<br>" + _mapping.getTextDescription("admin.ic.Please associate measure(s) and try again");
		rootJson.put("message",msg);
	}
	else
	{
		boolean updateCompIni=true;
		String forwardURL=null;
		String buttonClicked = request.getParameter("buttonClicked");
		if(s_measure_details != null)
		{
			if(compTestDetails.containsKey("MEASURE_NAME_MAPPING"))
			{
				Hashtable mnm = (Hashtable)compTestDetails.get("MEASURE_NAME_MAPPING");
				mnm.put(compTestAndMeasure,displayName);
			}
			else
			{
				Hashtable mnm = new Hashtable();
				mnm.put(compTestAndMeasure,displayName);
				compTestDetails.put("MEASURE_NAME_MAPPING",mnm);
			}
			if(compTestDetails.containsKey("ALARM_DISPLAY_STRING"))
			{
				Hashtable mnm = (Hashtable)compTestDetails.get("ALARM_DISPLAY_STRING");
				mnm.put(compTestAndMeasure,alarmDisplayString);
			}
			else
			{
				Hashtable mnm = new Hashtable();
				mnm.put(compTestAndMeasure,alarmDisplayString);
				compTestDetails.put("ALARM_DISPLAY_STRING",mnm);
			}
			// below block is updating the measure display name in lang file with out regenerating this performance rating test, provided this test is already created and this composite measure is in eg_thresholds.ini file.
			//block starts
			EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
			String existingMeasures[] = thresholdInfo.getMeasurementsForTest(compTest);
			if(existingMeasures != null)
			{
				for(int i=0;i<existingMeasures.length;i++)
				{
					if(existingMeasures[i].equals(measure))
					{
						IniFile compLangIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_composite_lang_en_US.ini", true);
						compLangIni.setValue("MEASURE_NAME_MAPPING",compTestAndMeasure,displayName);
						compLangIni.setValue("ALARM_DISPLAY_STRING",compTestAndMeasure,alarmDisplayString);
						compLangIni.saveFile();
						EgConfigFilesSync.releaseInstance(compLangIni);
						break;
					}
				}
			}
			//block ends

			String test = request.getParameter("test_associated");
			String includeStr = request.getParameter("include_desc");
			String excludeStr = request.getParameter("exclude_desc");

			if(compMeasureExist == null || compMeasureExist.isEmpty() || !compMeasureExist.contains(measure))
			{
				if(compTestDetails.containsKey("MEASURE_NAMES"))
				{
					Vector measures = (Vector)compTestDetails.get("MEASURE_NAMES");
					if(!measures.contains(measure))
						measures.add(measure);
				}
				else
				{
					Vector measures = new Vector();
					measures.add(measure);
					compTestDetails.put("MEASURE_NAMES",measures);
				}
			}
			LinkedHashMap tmas =null;
			if(compTestDetails.containsKey("TEST_MEASURES"))
			{
				tmas = (LinkedHashMap)compTestDetails.get("TEST_MEASURES");
			}
			if(tmas == null || !tmas.containsKey(compTestAndMeasure))
			{
				Hashtable htmp = new Hashtable();
				String arr[] = StringUtils.getTokens(s_measure_details,",");
				for(int i=0;i<arr.length;i++)
				{
					String atestd = arr[i];
					String atest = atestd.substring(0,atestd.indexOf(":"));
					if(!htmp.isEmpty() && htmp.containsKey(atest))
					{
						ArrayList alist = (ArrayList)htmp.get(atest);
						alist.add(atestd);
					}
					else
					{
						ArrayList alist = new ArrayList();
						alist.add(atestd);
						htmp.put(atest,alist);
					}
				}
				s_measure_details="";
				Iterator itr = htmp.keySet().iterator();
				while(itr.hasNext())
				{
					String key = (String)itr.next();
					ArrayList alist = (ArrayList)htmp.get(key);
					for(int i=0;i<alist.size();i++)
					{
						if((i+1)==alist.size())
						{
							s_measure_details += (String)alist.get(i);
						}
						else
						{
							s_measure_details += (String)alist.get(i) + ",";
						}
					}
					if(itr.hasNext())
					{
						s_measure_details += "|";
					}
				}
			}
			if(tmas == null)
			{
				LinkedHashMap temp = new LinkedHashMap();
				temp.put(compTestAndMeasure,s_measure_details);
				compTestDetails.put("TEST_MEASURES",temp);
			}
			else if(!tmas.containsKey(compTestAndMeasure))
			{
				tmas.put(compTestAndMeasure,s_measure_details);
			}
			else
			{
				String value_exist = (String)tmas.get(compTestAndMeasure);
				Hashtable ht_exist = null;
//				String arr_exist[] = StringUtils.getTokens(value_exist,"|");
//				if(arr_exist != null)
//				{
//					String removeKey = test + ":";
//					ht_exist = new Hashtable();
//					for(int i=0;i<arr_exist.length;i++)
//					{
//						String tma[] = StringUtils.getTokens(arr_exist[i],",");
//						for(int j=0;j<tma.length;j++)
//						{
//							String tmd = tma[j];
//							int tilda = tmd.indexOf("~");
//							if(tilda>0)
//							{
//								String tm = tmd.substring(0,tmd.indexOf("~"));
//								if(tm.startsWith(removeKey))
//									continue;
//								ht_exist.put(tm,tmd);
//							}
//						}
//					}
//				}
				String newStr = "";
				Hashtable ht_now = new Hashtable();
				if(s_measure_details.trim().length()>0 && s_measure_details.indexOf("~")>0)
				{
					String arr_now[] = StringUtils.getTokens(s_measure_details,",");
					for(int i=0;i<arr_now.length;i++)
					{
						String tmd = arr_now[i];
						String tm = tmd.substring(0,tmd.indexOf("~"));
						ht_now.put(tm,tmd);
					}
				}
				if(ht_exist != null)
				{
					ht_now.putAll(ht_exist);
				}
				if(!ht_now.isEmpty())
				{
					ArrayList keyList = new ArrayList();
					keyList.addAll(ht_now.keySet());
					Collections.sort(keyList,String.CASE_INSENSITIVE_ORDER);

					String previousTest = null;
					for(int i=0;i<keyList.size();i++)
					{
						String key = (String)keyList.get(i);
						String val = (String)ht_now.get(key);
						String testName = key.substring(0,key.indexOf(":"));
						if(previousTest==null)
						{
							newStr = val;
							previousTest = testName;
						}
						else if(!previousTest.equals(testName))
						{
							previousTest = testName;
							newStr+="|"+val;
						}
						else
						{
							newStr+=","+val;
						}
					}
				}
				if(newStr.length()==0)
				{
					updateCompIni=false;
				}
				else
				{
					tmas.put(compTestAndMeasure,newStr);
				}
			}
			if(updateCompIni)
			{
				Hashtable inht = null;
				if(compTestDetails.containsKey("INCLUDE_DESCRIPTORS"))
				{
					inht = (Hashtable)compTestDetails.get("INCLUDE_DESCRIPTORS");
				}
				else
				{
					inht = new Hashtable();
					compTestDetails.put("INCLUDE_DESCRIPTORS",inht);
				}
				Hashtable exht = null;
				if(compTestDetails.containsKey("EXCLUDE_DESCRIPTORS"))
				{
					exht = (Hashtable)compTestDetails.get("EXCLUDE_DESCRIPTORS");
				}
				else
				{
					exht = new Hashtable();
					compTestDetails.put("EXCLUDE_DESCRIPTORS",exht);
				}
				if(inht.containsKey(compTestAndMeasure))
				{
					Hashtable ht1 = (Hashtable)inht.get(compTestAndMeasure);
					if(ht1.containsKey(test))
					{
						ArrayList al = (ArrayList)ht1.get(test);
						al.clear();
						al.add(includeStr);
					}
					else
					{
						ArrayList al = new ArrayList();
						al.add(includeStr);
						ht1.put(test,al);
					}
				}
				else
				{
					Hashtable ht1 = new Hashtable();
					ArrayList al = new ArrayList();
					al.add(includeStr);
					ht1.put(test,al);
					inht.put(compTestAndMeasure,ht1);
				}
				if(exht.containsKey(compTestAndMeasure))
				{
					Hashtable ht1 = (Hashtable)exht.get(compTestAndMeasure);
					if(ht1.containsKey(test))
					{
						ArrayList al = (ArrayList)ht1.get(test);
						al.clear();
						al.add(excludeStr);
					}
					else
					{
						ArrayList al = new ArrayList();
						al.add(excludeStr);
						ht1.put(test,al);
					}
				}
				else
				{
					Hashtable ht1 = new Hashtable();
					ArrayList al = new ArrayList();
					al.add(excludeStr);
					ht1.put(test,al);
					exht.put(compTestAndMeasure,ht1);
				}
				
			}
			forwardURL="EgConfigMeasureJson.jsp?test="+compTest;
		}
		rootJson.put("forwardURL",forwardURL);
		if(updateCompIni)
		{
			rootJson.put("messageType","Result");
			if(buttonClicked.equals("addMeasures"))
			{
				rootJson.put("message",_mapping.getTextDescription("admin.common.Measures have been associated successfully")+". "+_mapping.getTextDescription("admin.common.Do you want to associate any other test measures"));
			}
			else
			{
				rootJson.put("message",_mapping.getTextDescription("admin.common.Measures have been updated successfully")+". "+_mapping.getTextDescription("admin.common.Do you want to update any other associated test measures"));
			}
		}
		else
		{
			rootJson.put("messageType","Alert");
			rootJson.put("message",_mapping.getTextDescription("admin.common.Performance rating test measure should be associated with atleast one measure of a test"));
		}
	}
	session.setAttribute("compTestDetails",compTestDetails);
	rootJson.put("hideMeasureField",true);
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>

