<%
/*
 *
 *	Name			:	EgChangeIPJson.jsp
 *	Purpose			:	To modify component IP
 *	CreationDate	:	04/06/08
 */
%>
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "java.util.Vector"%>
<%@ page import = "java.util.List"%>
<%@ page import = "java.util.ArrayList"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "egurkha.EgUIUtils"%>

<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	JSONObject hiddens = new JSONObject();

	String hostIP = request.getParameter("hostip");
	String hostName = request.getParameter("hostname");
	String serverType = request.getParameter("servertype");
	String port = request.getParameter("port");
	String selCategory = request.getParameter("selCategory");
	hostIP = (hostIP != null && hostIP.length()>0)?hostIP:"";
	hostName = (hostName != null && hostName.length()>0)?hostName:"";
	port = (port != null && port.length()>0)?port:"";
	serverType = (serverType != null && serverType.length()>0)?serverType:"";
	selCategory = (selCategory != null && selCategory.length()>0)?selCategory:"-1";

	hiddens.put("servertype",serverType);
	hiddens.put("hostip",hostIP);
	hiddens.put("hostname",hostName);
	hiddens.put("port",port);
	hiddens.put("selCategory",selCategory);

	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),_user.getLoginID());
	boolean isLimitedAdmin = !egRoleInfo.hasAllComponentAccess();
	ArrayList allCompNicks = egRoleInfo.getAllServerNicks();

	boolean allExternalTests = true;
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	String[] testsForServer = specsInfo.getTestsForServer(serverType);
	if (testsForServer != null)
	{
		for (int a=0; a<testsForServer.length; a++)
		{
			if (!specsInfo.isTestExternal(testsForServer[a]))
			{
				allExternalTests = false;
				break;
			}
		}
	}

	Vector hostsForIP = new Vector();
	ArrayList tmpList = new ArrayList();
	EgUIUtils uiUtils = new EgUIUtils();
	EgDiscInfo discInfo = new EgDiscInfo("manager");

	// If old IP is already associated to any host(s)/comp(s), get those host(s)
	hostsForIP = uiUtils.getAllHostsForIp(hostIP,hostName);
	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String defExtAgent = specsInfo.getEGServer();
	String defExtAgentIp = extInfo.getIpForAgent(defExtAgent);
	for (int i=0; i<hostsForIP.size(); i+=2)
	{
		String host = (String)hostsForIP.get(i);
		//To avoid modifying default external/remote agent IP, while modifying combination of this IP with different nick name.
		if (defExtAgent.equalsIgnoreCase(host) && defExtAgentIp.equalsIgnoreCase(hostIP))
		{
			continue;
		}
		String tmpFlag = (String)hostsForIP.get(i+1);
		if (tmpFlag.equals("true"))
		{
			List serverTypes = discInfo.getServerTypesForNick(host);
			if (serverTypes != null && serverTypes.size() > 0)
			{
				for (int j=0;j<serverTypes.size();j++)
				{
					String tmpSType = (String)serverTypes.get(j);
					if (!host.equals(hostName))
					{
						tmpList.add(host+"|"+tmpSType);
					}
				}
			}
		}
	}
	
	List compTypes = discInfo.getServerTypesForNick(hostName);
	
	if (tmpList.size()>0 || compTypes.size()>1)
	{
		String hostList = "";
		TreeMap compAndType = new TreeMap();
		for (int j=0 ; j<tmpList.size(); j++)
		{
			hostList = (String)tmpList.get(j);
			String comp = "";
			String compType = "";
			if (hostList.indexOf("|") > 0)
			{
				comp = hostList.substring(0,hostList.indexOf("|"));
				compType = hostList.substring(hostList.indexOf("|")+1);
				if (!compAndType.containsKey(comp))
				{
					compAndType.put(comp,compType);
				}
				else
				{
					String tmpType = (String)compAndType.get(comp);
					tmpType += ","+compType;
					compAndType.put(comp,tmpType);
				}
			}
		}
		if (compAndType.size() > 0)
		{
			rootJSON.put("showGrid",true);

			Iterator it = compAndType.keySet().iterator();
			int j=0;
			int colsPerRow = 3;
			float cellWidth =100/colsPerRow;
			JSONArray gridArr =  new JSONArray();
			while (it.hasNext())
			{
				String tmpHostName = (String)it.next();
				String tmpHostType = (String)compAndType.get(tmpHostName);
				String mappHostType = "";
				if(tmpHostType.indexOf(",") > 0)
				{
						StringTokenizer strToken = new StringTokenizer(tmpHostType,",");
						List tmp = new ArrayList();
						while(strToken.hasMoreTokens())
						{
							tmp.add(_mapping.getComponentTypeDescription(strToken.nextToken()));
						}
						Collections.sort(tmp,String.CASE_INSENSITIVE_ORDER);
						for (int t=0; t<tmp.size(); t++)
						{
							mappHostType += " "+tmp.get(t).toString()+",";
						}
						mappHostType = mappHostType.substring(0,mappHostType.length()-1).trim();
				}
				else
				{
					mappHostType = _mapping.getComponentTypeDescription(tmpHostType);
				}

				String tmpValue = tmpHostName+"|"+tmpHostType;
				JSONObject gridRowVal = new JSONObject();
				gridRowVal.put("nickWithType",tmpHostName+" ("+mappHostType+")");
				gridRowVal.put("actualValue",tmpValue);
				String isSharedIP = "no";
				if(isLimitedAdmin && !allCompNicks.contains(tmpHostName))
				{
					isSharedIP = "yes";
				}
				if(isSharedIP.equals("no"))
					gridArr.add(gridRowVal);
			}
			rootJSON.put("gridData",gridArr);
		}
		else
		{
			rootJSON.put("showGrid",false);
		}


		if(compTypes != null && compTypes.size()>1)
		{
			Collections.sort(compTypes,String.CASE_INSENSITIVE_ORDER);
			String sTypes = "";
			for(int i=0;i<compTypes.size();i++)
			{
				String tmp = (String)compTypes.get(i);
				if (!tmp.equals(serverType))
				{
					sTypes +=_mapping.getComponentTypeDescription(tmp)+", ";
				}
			}
			if (sTypes.endsWith(", "))
				sTypes = sTypes.substring(0,sTypes.length()-2);
			rootJSON.put("sameNickCompsAlert",true);
			rootJSON.put("sameNickIPCompTypes",sTypes);
		}
		else
		{
			rootJSON.put("sameNickCompsAlert",false);
		}
	}
	rootJSON.put("hiddenVals",hiddens);
	out.println(rootJSON);

%>



