<%
/*************************************************************************************************/
/*                 Name          : TopologySettingsJson.jsp                                        */
/*                 Purpose       : This page is used to specify topology options or settings     */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
try
{
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	IniUI iniUI = IniUI.getInstance();
	String TOPOLOGY_OPTIONS = "TOPOLOGY_OPTIONS";
	String AUTO_TOPOLOGY_OPTIONS = "AUTO_TOPOLOGY_OPTIONS";
	String rs =	iniUI.getValue(TOPOLOGY_OPTIONS,"Row_space");
	String cs = iniUI.getValue(TOPOLOGY_OPTIONS,"Column_space");
	String showSingleTopology = iniUI.getValue(AUTO_TOPOLOGY_OPTIONS,"ShowSingleTopology");

	if(showSingleTopology==null || showSingleTopology=="") 
		showSingleTopology = "Yes";
	String checkYes="";
	String checkNo="";
	if(showSingleTopology.equalsIgnoreCase("yes") || showSingleTopology.equalsIgnoreCase("true"))
	{
		checkNo = "checked";
	}
	else
	{
		checkYes = "checked";
	}
	rootJson.put("showSingleTopology",showSingleTopology);
	rootJson.put("checkNo",checkNo);
	rootJson.put("checkYes",checkYes);

	JSONObject vgapObj = new JSONObject();
	JSONArray vgapArr = new JSONArray();

	JSONObject hgapObj = new JSONObject();
	JSONArray hgapArr = new JSONArray();

	for(int k=50;k<=120;k=k+5)
	{
		String value = Integer.toString(k);
		String selected = "";
		if(value.equals(rs))
		{
			selected = "selected";
			rootJson.put("SelectedVGap",rs);
		}

		vgapObj.put("displayField",value);
		vgapObj.put("valueField",value);
		vgapArr.add(vgapObj);
	}

	for(int k=50;k<=120;k=k+5)
	{
		String value = Integer.toString(k);
		String selected = "";
		if(value.equals(cs))
		{
			selected = "selected";
			rootJson.put("SelectedHGap",cs);
		}

		hgapObj.put("displayField",value);
		hgapObj.put("valueField",value);
		hgapArr.add(hgapObj);
	}

	rootJson.put("VerticalGapEntries",vgapArr);
	rootJson.put("HorizontalGapEntries",hgapArr);
	out.println(rootJson.toString());
}
catch(Exception e)
{
	System.out.println("Exception Occured in EgTopologySettings.jsp....");
	e.printStackTrace();
}
%>
