#!/bin/sh

currentUser=`whoami`
if [ "$currentUser" != "root" ]
then
        echo "******************************************************************************"
        echo "This script can only be run by the root user. Exiting ..."
        echo "******************************************************************************"
        exit
fi

if [ -f "/opt/egurkha/lib/eg_agent.jar" ]
then
        echo "******************************************************************************"
        echo "The eG Agent is already installed. Exiting..."
        echo "******************************************************************************"
        exit
fi

if [ -z "$1" ] 
then
    eGuser=egurkha
else
    eGuser=$1
fi

if [ -z "$2" ] 
then
    eGgroup=egurkha
else
    eGgroup=$2
fi

#eGuser=egurkha
#eG user - please make sure that the user account exists

#eGgroup=egurkha
#eG user's group

serviceaccount=no
#whether the user we are going to create is a service account or a normal account

eGInstallDir=/opt
#eG install directory

autoRestart=y
#whether the agent should auto-restart

licenseAcceptance=y
#licenseAcceptance the license

eGManager=$MANAGER_IP
#eG manager host

eGManagerPort=$MANAGER_PORT
#eG manager port

useProxy=n
#use Proxy?

proxyHost=xxx
#proxy server

proxtPort=8080
#proxy port

setAuthentication=n
#use auhentication for proxy?

proxyUsername=none
#user name for proxy access - none

proxyPassword=none
#password for proxy access

useSSL=y
#use SSL for communication with the manager? y/n

trustedCertificates=n
#use trusted certificates for SSL communication with the manager? y/n

setNickName=n
#set the nickname for the agent - y/n

nickNameToUse=`hostname`
#the nick name to set for this agent

count=`grep "^$eGgroup:" /etc/group | wc -l`
if [ $count -eq 0 ]
then
	if [ ! -f /usr/sbin/groupadd ]
	then
	echo "/usr/sbin/groupadd does not exist. User creation will fail! Exiting ..."
	exit 0
	fi
	/usr/sbin/groupadd $eGgroup
fi

count=`grep "^$eGuser:" /etc/passwd | wc -l`
if [ $count -eq 0 ]
then
	if [ ! -f /usr/sbin/useradd ]
	then
	echo "/usr/sbin/useradd does not exist. User creation will fail! Exiting ..."
	exit 0
	fi
	if [ "$serviceaccount" = "yes" ]
	then
		/usr/sbin/useradd -r -G $eGgroup -g $eGgroup -d $eGInstallDir/egurkha $eGuser 
	else
		/usr/sbin/useradd -m -p sa3tHJ3/KuYvI -G $eGgroup -g $eGgroup -d $eGInstallDir/egurkha $eGuser 
	fi
fi

#run iAgent first
if [ ! -f "iAgent_linux" ]
then
        if [ -f "iAgent_linux.sh" ]
        then
                cp -f iAgent_linux.sh iAgent_linux
                chmod 755 iAgent_linux
        fi
fi


chmod +x iAgent_linux
`pwd`/iAgent_linux $eGuser $eGgroup $eGInstallDir $autoRestart $serviceaccount >/dev/null 

monitorColdfusion=n
#monitor coldfusion servers?
monitorSybase=n
#monitor sybase servers?
# silent install for coldfusion and sybase is not handled here - pls manually configure these servers

#run setup_agent next
chmod +x /opt/egurkha/bin/setup_agent
su - $eGuser -c "/opt/egurkha/bin/setup_agent $licenseAcceptance $eGManager $eGManagerPort $useProxy $proxyHost $proxtPort $setAuthentication $proxyUsername $proxyPassword $useSSL $trustedCertificates $setNickName $monitorColdfusion $monitorSybase $eGuser $eGgroup $nickNameToUse" > /dev/null

if [ -f "eg_uaid.ini" ]
then
mkdir -p /opt/egurkha/agent/config && cp eg_uaid.ini /opt/egurkha/agent/config
fi

CLASSPATH=.:/opt/egurkha/lib/eg_agent.jar:$CLASSPATH
export CLASSPATH
isJRE16=`/opt/egurkha/jre/bin/java -version 2>&1 | grep "1.6" | wc -l`
isJRE17=`/opt/egurkha/jre/bin/java -version 2>&1 | grep "1.7" | wc -l`
export isJRE16
export isJRE17

javaCmd="java "
if [ "$isJRE16" -ge "1" ]
then
        javaCmd="java -XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null "
fi
if [ "$isJRE17" -ge "1" ]
then
        javaCmd="java -XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null "
 fi

/opt/egurkha/jre/bin/$javaCmd EgConfigureAgent -setAgentType $AgentType -setXmx $Xmx -isMgrDefaultAgent $MgrDefaultAgent -isCliEmu $CliEmu > /dev/null

#now start the agent
su - $eGuser -c /opt/egurkha/bin/start_agent

echo "eG Agent installation and start-up completed."



