#!/bin/sh
curDir=`pwd`
EG_HOME=/opt/egurkha
export EG_HOME
TOMCAT_HOME=/opt/egurkha/manager/tomcat
BACKUPDIR=eG_Patch_Backup
export BACKUPDIR

#### - set java path to the PATH variable and set the CLASSPATH variable

JAVA_HOME=`grep "JAVASTART_HOME=" /opt/egurkha/bin/start_manager | cut -d "=" -f2`
export JAVA_HOME
if [ -z "$JAVA_HOME" ]
then
	JAVA_HOME=`grep "JAVA_HOME=" /opt/egurkha/bin/start_manager | cut -d "=" -f2`
	export JAVA_HOME
fi
PATH=$JAVA_HOME/bin:$EG_HOME/bin:/sbin:/usr/bin:/usr/sbin:/bin:$PATH:/usr/local/bin:/usr/ucb
export PATH

CLASSPATH=.:$EG_HOME/lib/eg_manager.jar:$EG_HOME/lib/eg_util.jar:$EG_HOME/lib/classes111.zip:$EG_HOME/lib/TwFreeTds.jar:$EG_HOME/lib/jtds.jar:$JAVA_HOME/lib/tools.jar:/opt/egurkha/lib/xmlParserAPIs.jar:/opt/egurkha/manager/tomcat/webapps/final/WEB-INF/classes:$CLASSPATH:$EG_HOME/lib/xmlParserAPIs.jar:$EG_HOME/lib/xml-apis.jar:$EG_HOME/lib/parser.jar:$EG_HOME/manager/lib/apache-commons-lang.jar:$EG_HOME/manager/lib/commons-lang-2.4.jar
export CLASSPATH

####Check if the user executing this script is the install user of eG

legalUser=`ls -l /opt/egurkha/manager/config/eg_agents.ini|grep -v "total" |awk '{ print $3}'`
export legalUser
GROUP=`ls -l /opt/egurkha/bin/start_manager|awk '{ print $4}'`
export GROUP

currentUser=`whoami`


if [ "$currentUser" = "$legalUser" ]
then
	echo "">/dev/null
else
	if [ "$currentUser" = "root" ]
	then
		echo "You are executing this script as root user."
		echo "****************************************************"
		echo "Please login as \"$legalUser\" and run this script!"
		echo "****************************************************"
		exit
	else
		echo "****************************************************"
		echo "Please login as '$legalUser' and run this script!"
		echo "****************************************************"
		exit
	fi
fi


if [ -f /opt/egurkha/tmp/logging ]
then 
	rm -f /opt/egurkha/tmp/logging
fi

PURPOSE=$1

case $PURPOSE in
-a|-A)
	if [ -f $EG_HOME/manager/logs/upgrade_event ]
	then
		echo "Applying Patch eG_Patch on eG Manager started on `date`">>$EG_HOME/manager/logs/upgrade_event
	else
		echo "Applying Patch eG_Patch on eG Manager started on `date`">$EG_HOME/manager/logs/upgrade_event
	fi

echo 
echo "*********************************************************"
echo  "Applying Patch eG_Patch might take several minutes to complete."
echo  "PLEASE DO NOT INTERRUPT THIS PROCESS."
echo "*********************************************************"
echo 
echo "Applying Patch eG_Patch on the eG Manager ..."
echo "Applying Patch eG_Patch on the eG Manager ..." >>$EG_HOME/manager/logs/upgrade_event
echo 

# stop the eGmanager 

echo "Stopping the eG Manager ..."
echo "Stopping the eG Manager ..." >>$EG_HOME/manager/logs/upgrade_event
echo 
/opt/egurkha/bin/stop_manager >/dev/null 2>/dev/null 

echo "The eG Manager has been successfully stopped ..." 
echo "The eG Manager has been successfully stopped ..." >>$EG_HOME/manager/logs/upgrade_event

echo "The eG Manager  have been stopped at `date`">>$EG_HOME/manager/logs/upgrade_event
echo 
cd $curDir


#:*******************************************************************************************************************	
#:UPGRADE operation Starts.....................................
#:*******************************************************************************************************************

echo "Extracting the files required for Patch ..."
echo "Extracting the files required for Patch ..." >>$EG_HOME/manager/logs/upgrade_event

jar -xvf ./eG_Patch.zip >>$EG_HOME/manager/logs/upgrade_event 2>/opt/egurkha/tmp/logging

	status=$?
	if [ $status -ne 0 ]
	then
		cat /opt/egurkha/tmp/logging >>$EG_HOME/manager/logs/upgrade_event
		echo "ERROR : Unable to extract eG_Patch.zip "
		echo "Patch eG_Patch process failed!!!..."
		echo "Please refer to file $EG_HOME/manager/logs/upgrade_event for further details"
                echo "ERROR : Unable to extract eG_Patch.zip" >>$EG_HOME/manager/logs/upgrade_event
		echo "Patch eG_Patch process failed!!!... ">>$EG_HOME/manager/logs/upgrade_event
		exit 1
	fi

	c=`wc -l /opt/egurkha/tmp/logging|awk '{print $1}'`
	if [ `expr $c` -ne 0 ]
	then
		cat /opt/egurkha/tmp/logging >>$EG_HOME/manager/logs/upgrade_event
		echo "ERROR : Unable to extract eG_Patch.zip "
		exit 1
	fi


################################################## BACKUP STARTS #############################

# If the Backup directory is not present create it...................
# Create the sub directories to take the backup......................

echo "Backup of the eG Manager started ..."
echo "Backup of the eG Manager started ..." >>$EG_HOME/manager/logs/upgrade_event
echo 


	if [ ! -d $EG_HOME/$BACKUPDIR ]
	then
	mkdir $EG_HOME/$BACKUPDIR
	if [ $? -ne 0 ]
	then
		echo "Failed to make directory $EG_HOME/$BACKUPDIR"
		echo "No changes made to the system"
		exit 1
	fi

	mkdir $EG_HOME/$BACKUPDIR/bin
	if [ $? -ne 0 ]
	then
		echo "Failed to make directory $EG_HOME/$BACKUPDIR/bin"
		# rm -rf $EG_HOME/$BACKUPDIR
		echo "No changes made to the system"
		exit 1
	fi

	mkdir $EG_HOME/$BACKUPDIR/lib
	if [ $? -ne 0 ]
	then
		echo "Failed to make directory $EG_HOME/$BACKUPDIR/lib"
		# rm -rf $EG_HOME/$BACKUPDIR
		echo "No changes made to the system"
		exit 1
	fi
	
	mkdir $EG_HOME/$BACKUPDIR/manager
	if [ $? -ne 0 ]
	then
		echo "Failed to make directory $EG_HOME/$BACKUPDIR/manager"
		# rm -rf $EG_HOME/$BACKUPDIR
		echo "No changes made to the system"
		exit 1
	fi
	
	mkdir $EG_HOME/$BACKUPDIR/manager/lib
	if [ $? -ne 0 ]
	then
		echo "Failed to make directory $EG_HOME/$BACKUPDIR/manager"
		# rm -rf $EG_HOME/$BACKUPDIR
		echo "No changes made to the system"
		exit 1
	fi
	
	mkdir $EG_HOME/$BACKUPDIR/manager/config
	if [ $? -ne 0 ]
	then
		echo "Failed to make directory $EG_HOME/$BACKUPDIR/manager/config"
		echo "No changes made to the system"
		# rm -rf $EG_HOME/$BACKUPDIR
		exit 1
	fi

	mkdir $EG_HOME/$BACKUPDIR/manager/tomcat
	if [ $? -ne 0 ]
	then
		echo "Failed to make directory $EG_HOME/$BACKUPDIR/manager/tomcat/"
		echo "No changes made to the system"
		# rm -rf $EG_HOME/$BACKUPDIR
		exit 1
	fi
	
	mkdir $EG_HOME/$BACKUPDIR/manager/tomcat/webapps
	if [ $? -ne 0 ]
	then
		echo "Failed to make directory $EG_HOME/$BACKUPDIR/manager/tomcat/"
		echo "No changes made to the system"
		# rm -rf $EG_HOME/$BACKUPDIR
		exit 1
	fi
	
	
	mkdir $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/final
	if [ $? -ne 0 ]
	then
		echo "Failed to make directory $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/final"
		echo "No changes made to the system"
		# rm -rf $EG_HOME/$BACKUPDIR
		exit 1
	fi

	mkdir $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/final/WEB-INF
	if [ $? -ne 0 ]
	then
		echo "Failed to make directory $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/final/WEB-INF"
		echo "No changes made to the system"
		# rm -rf $EG_HOME/$BACKUPDIR
		exit 1
	fi


# ************* Coping the corresponding files ************* 

	
	if [ -f $EG_HOME/manager/tomcat/webapps/rumcollector.war ]
	then 
		cp -rf $EG_HOME/manager/tomcat/webapps/rumcollector.war $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/ 2>/opt/egurkha/tmp/logging
		if [ $? -ne 0 ]
		then
			echo "Unable to take the backup of rumcollector.war"
			echo "Please refer to file /opt/egurkha/manager/logs/upgrade_event for further details"
			echo "Use the command 'eGupgrade.sh -R' to revert to the original config."
			exit 1
		fi
	fi

	if [ -f $EG_HOME/lib/log4j.jar ]
	then 
		cp -rf $EG_HOME/lib/log4j.jar $EG_HOME/$BACKUPDIR/lib/ 2>/opt/egurkha/tmp/logging
		if [ $? -ne 0 ]
		then
			echo "Unable to take the backup of lib/log4j.jar"
			echo "Please refer to file /opt/egurkha/manager/logs/upgrade_event for further details"
			echo "Use the command 'eGupgrade.sh -R' to revert to the original config."
			exit 1
		fi
	fi

	if [ -f $EG_HOME/bin/log4j.jar ]
	then 
		cp -rf $EG_HOME/bin/log4j.jar $EG_HOME/$BACKUPDIR/bin/ 2>/opt/egurkha/tmp/logging
		if [ $? -ne 0 ]
		then
			echo "Unable to take the backup of bin/log4j.jar"
			echo "Please refer to file /opt/egurkha/manager/logs/upgrade_event for further details"
			echo "Use the command 'eGupgrade.sh -R' to revert to the original config."
			exit 1
		fi
	fi
	
	if [ -f $EG_HOME/manager/lib/log4j.jar ]
	then 
		cp -rf $EG_HOME/manager/lib/log4j.jar $EG_HOME/$BACKUPDIR/manager/lib/ 2>/opt/egurkha/tmp/logging
		if [ $? -ne 0 ]
		then
			echo "Unable to take the backup of manager/lib/log4j.jar"
			echo "Please refer to file /opt/egurkha/manager/logs/upgrade_event for further details"
			echo "Use the command 'eGupgrade.sh -R' to revert to the original config."
			exit 1
		fi
	fi
	
	if [ -d $EG_HOME/manager/tomcat/webapps/rumcollector ]
	then 
		cp -rp $EG_HOME/manager/tomcat/webapps/rumcollector $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/ 2>/opt/egurkha/tmp/logging
		if [ $? -ne 0 ]
		then
			echo "Failed to Copy $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/rumcollector"
			rm -rf $EG_HOME/$BACKUPDIR
			echo "No changes made to the system"
			exit 1
		fi
	fi

	if [ -d $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/final/WEB-INF ]
	then 
		cp -rp $EG_HOME/manager/tomcat/webapps/final/WEB-INF $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/final 2>/opt/egurkha/tmp/logging
		if [ $? -ne 0 ]
		then
			echo "Failed to Copy $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/final/WEB-INF"
			rm -rf $EG_HOME/$BACKUPDIR
			echo "No changes made to the system"
			exit 1
		fi
	fi

	if [ -d $EG_HOME/$BACKUPDIR/manager/config ]
	then 
		cp -rp $EG_HOME/manager/config $EG_HOME/$BACKUPDIR/manager 2>/opt/egurkha/tmp/logging
		if [ $? -ne 0 ]
		then
			echo "Failed to Copy $EG_HOME/manager/config"
			rm -rf $EG_HOME/$BACKUPDIR
			echo "No changes made to the system"
			exit 1
		fi
	fi
fi

echo "Backup of the eG Manager completed "
echo "Backup of the eG Manager completed " >>$EG_HOME/manager/logs/upgrade_event
echo 
########################################## BACKUP ENDS ########################################

########################### UPGRADE STARTED ###########################################

echo "Start the eG Manager Patch Process   ..."
echo "Start the eG Manager Patch Process   ...">>$EG_HOME/manager/logs/upgrade_event
echo 
cd ./eG_Patch

##echo CURRNET DIRECTORY :::::: `pwd`

if [ -d $EG_HOME/manager/tomcat/webapps/final ]
then
	cp -rf ./final $EG_HOME/manager/tomcat/webapps >>$EG_HOME/manager/logs/upgrade_event 2>/opt/egurkha/tmp/logging
	if [ $? -ne 0 ]
	then
		echo "Copy of $EG_HOME/upgrade/manager/tomcat/webapps/final failed!!!!!!!!!">>/opt/egurkha/manager/logs/upgrade_event
		echo "Copy of $EG_HOME/upgrade/manager/tomcat/webapps/final failed!"
		echo "Please refer to file /opt/egurkha/manager/logs/upgrade_event for further details"
		echo "Use the command 'eGupgrade.sh -R' to revert to the original config."
		exit 1
	fi

fi

java -cp $curDir/eG_Patch/eg_securityUpdate.jar:$CLASSPATH SecurityUpdate $EG_HOME Linux >>$EG_HOME/manager/logs/upgrade_event 2>>$EG_HOME/tmp/logging

if [ -f /opt/egurkha/tmp/logging ]
then
	STATUS=`wc -l /opt/egurkha/tmp/logging|awk '{print $1}'`
else
	STATUS=0
fi


if [ `expr $STATUS` -ne 0 ]
 then
	echo "ERROR : Unable to COPY index queries "
	echo "ERROR : Unable to COPY index queries " >>$EG_HOME/manager/logs/upgrade_event
	cat /opt/egurkha/tmp/logging >>$EG_HOME/manager/logs/upgrade_event
	echo "Please refer to file /opt/egurkha/manager/logs/upgrade_event for further details"
	echo "Use the command 'eG_Patch.sh -R' to revert to the original config."
	exit 1
fi


java -cp $curDir/eG_Patch:$CLASSPATH UpdatePatchInfo SecurityPatch >>$EG_HOME/manager/logs/upgrade_event 2>>$EG_HOME/tmp/logging

if [ -f /opt/egurkha/tmp/logging ]
then
	STATUS=`wc -l /opt/egurkha/tmp/logging|awk '{print $1}'`
else
	STATUS=0
fi


if [ `expr $STATUS` -ne 0 ]
 then
	echo "ERROR : Unable to update the patch information!! "
	echo "ERROR : Unable to update the patch information!! " >>$EG_HOME/manager/logs/upgrade_event
	cat /opt/egurkha/tmp/logging >>$EG_HOME/manager/logs/upgrade_event
	echo "Please refer to file /opt/egurkha/manager/logs/upgrade_event for further details"
	echo "Use the command 'eG_Patch.sh -R' to revert to the original config."
	exit 1
fi

	echo "Patch information has been updated successfully!!! "
	echo "Patch information has been updated successfully!!!" >>$EG_HOME/manager/logs/upgrade_event

echo "eG Manager upgraded successfully  at `date` ">>$EG_HOME/manager/logs/upgrade_event	
echo 
echo "*******************************************************************************"
echo "The eG Manager patch process has been completed successfully!!!" 
echo "Execute the command /opt/egurkha/bin/start_manager to start the eG Manager. "
echo "The eG Manager patch process has been completed successfully!!!"  >>$EG_HOME/manager/logs/upgrade_event
echo "Execute the command /opt/egurkha/bin/start_manager to start the eG Manager. "  >>$EG_HOME/manager/logs/upgrade_event
echo "*******************************************************************************"
echo 
if [ -f /opt/egurkha/tmp/logging ]
then 
	rm -f /opt/egurkha/tmp/logging
fi

;;
-r|-R)
	
	
	if [ -d $EG_HOME/$BACKUPDIR ]
	then
		echo "">/dev/null
	else
		echo "************************************************"
		echo "Sorry! There are no upgrade to revert ... "
		echo "************************************************"
		exit
	fi
		
	
	# stop the eGmanager and eGagent
	echo 
	echo "*************************************************************************"	
	echo "Reverting the eG Manager to its original configuration ..."
	echo "*************************************************************************"
	echo 
	echo "*************************************************************************"
	echo "Revert process might take several minutes to complete."
	echo "PLEASE DO NOT INTERRUPT THIS PROCESS."
	echo "*************************************************************************"
	echo 
	echo "Stopping the eG Manager ..."
	/opt/egurkha/bin/stop_manager >/dev/null 2>/dev/null 
	/opt/egurkha/bin/stop_manager
	
	
	if [ -f $EG_HOME/manager/logs/upgrade_event ]
	then
		echo "Reverting the eG Manager at `date`">>$EG_HOME/manager/logs/upgrade_event
	fi

	echo 

	if [ -d $EG_HOME/$BACKUPDIR/manager/config ]
	then
        rm -rf $EG_HOME/manager/config
		if [ $? -ne 0 ]
		then
			echo "Failed to remove $EG_HOME/manager/config ..."
			echo "Failed to remove $EG_HOME/manager/config ...">>$EG_HOME/manager/logs/upgrade_event
			exit 1
		fi
       cp -rf $EG_HOME/$BACKUPDIR/manager/config $EG_HOME/manager >/dev/null 2>/$EG_HOME/tmp/logging
		if [ $? -ne 0 ]
		then
			cat /opt/egurkha/tmp/logging >>/opt/egurkha/manager/logs/upgrade_event 
			echo "Failed to copy $EG_HOME/$BACKUPDIR/manager/config ..."
			echo "Failed to copy $EG_HOME/$BACKUPDIR/manager/config ...">>/opt/egurkha/manager/logs/upgrade_event 
			exit 1
		fi
	fi

	if [ -f $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/rumcollector.war ]
	then 
		cp -rf $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/rumcollector.war $EG_HOME/manager/tomcat/webapps/ 2>/opt/egurkha/tmp/logging
		if [ $? -ne 0 ]
		then
			echo "Unable to take the backup of rumcollector.war"
			echo "Please refer to file /opt/egurkha/manager/logs/upgrade_event for further details"
			echo "Use the command 'eGupgrade.sh -R' to revert to the original config."
			exit 1
		fi
	fi

	if [ -f $EG_HOME/$BACKUPDIR/lib/log4j.jar ]
	then 
		cp -rf $EG_HOME/$BACKUPDIR/lib/log4j.jar $EG_HOME/lib/ 2>/opt/egurkha/tmp/logging
		if [ $? -ne 0 ]
		then
			echo "Unable to copy the backup of lib/log4j.jar"
			echo "Please refer to file /opt/egurkha/manager/logs/upgrade_event for further details"
			echo "Use the command 'eGupgrade.sh -R' to revert to the original config."
			exit 1
		fi
	fi
	
	if [ -f $EG_HOME/$BACKUPDIR/manager/lib/log4j.jar ]
	then 
		cp -rf $EG_HOME/$BACKUPDIR/manager/lib/log4j.jar $EG_HOME/manager/lib/ 2>/opt/egurkha/tmp/logging
		if [ $? -ne 0 ]
		then
			echo "Unable to take the revert of manager/lib/log4j.jar"
			echo "Please refer to file /opt/egurkha/manager/logs/upgrade_event for further details"
			echo "Use the command 'eGupgrade.sh -R' to revert to the original config."
			exit 1
		fi
	fi
	
	if [ -d $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/rumcollector ]
	then 
		rm -rf $EG_HOME/manager/tomcat/webapps/rumcollector
		##echo :::::::: Remove WEB-INF directory successfully 
		if [ $? -ne 0 ]
		then
			echo "Failed to remove $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/rumcollector..."
			echo "Failed to remove $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/rumcollector ...">>/opt/egurkha/manager/logs/upgrade_event 
			echo "Please contact support@eginnvoations.com for further details ">>$EG_HOME/manager/logs/upgrade_event
			exit 1

		fi

		cp -rp $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/rumcollector $EG_HOME/manager/tomcat/webapps/ 2>/opt/egurkha/tmp/logging
		if [ $? -ne 0 ]
		then
			echo "Failed to Copy $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/rumcollector"
			rm -rf $EG_HOME/$BACKUPDIR
			echo "No changes made to the system"
			exit 1
		fi
	fi

	

	if [ -d $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/final/WEB-INF ]
	then
		rm -rf $EG_HOME/manager/tomcat/webapps/final/WEB-INF
		##echo :::::::: Remove WEB-INF directory successfully 
		if [ $? -ne 0 ]
		then
			echo "Failed to remove $EG_HOME/manager/tomcat/webapps/final/WEB-INF ..."
			echo "Failed to remove $EG_HOME/manager/tomcat/webapps/final/WEB-INF ...">>/opt/egurkha/manager/logs/upgrade_event 
			echo "Please contact support@eginnvoations.com for further details ">>$EG_HOME/manager/logs/upgrade_event
			exit 1

		fi
		cp -rp $EG_HOME/$BACKUPDIR/manager/tomcat/webapps/final/WEB-INF $EG_HOME/manager/tomcat/webapps/final >/dev/null 2>/$EG_HOME/tmp/logging
		##echo :::::::: Copy the WEB-INF directory successfully 
		if [ $? -ne 0 ]
		then
			echo "Failed to copy $EG_HOME/manager/tomcat/webapps/final/WEB-INF ..."
			echo "Failed to copy $EG_HOME/manager/tomcat/webapps/final/WEB-INF ...">>/opt/egurkha/manager/logs/upgrade_event 
			cat /opt/egurkha/tmp/logging >>/opt/egurkha/manager/logs/upgrade_event 
			echo "Please contact support@eginnvoations.com for further details ">>$EG_HOME/manager/logs/upgrade_event
			exit 1
		fi
	fi

	


	if [ -d $EG_HOME/$BACKUPDIR ]
	then
		rm -rf $EG_HOME/$BACKUPDIR
	fi

	
	echo 
	echo "***************************************************************"
 	echo "Successfully reverted the eG Manager to the previous setup!"
	echo "***************************************************************"
	echo 
	echo "***************************************************************">>/opt/egurkha/manager/logs_upgrade_event
 	echo "Successfully reverted the eG Manager to the previous setup!">>/opt/egurkha/manager/logs/upgrade_event
	echo   Please execute the command /opt/egurkha/bin/start_manager 
	echo "***************************************************************">>/opt/egurkha/manager/logs/upgrade_event
	echo 

;;
-c|-C)
	
	if [ -d $EG_HOME/$BACKUPDIR ]
	then
		echo "">/dev/null
	else
		echo "No Upgrades to Commit ... "
		exit
	fi

	echo "This option will commit the eG Manager changes and setup"
	echo 
	if [ -f $EG_HOME/manager/logs/upgrade_event ]
	then
		echo "eG Manager Patch commit started on `date`">>$EG_HOME/manager/logs/upgrade_event
	fi
	
	if [ -d $EG_HOME/$BACKUPDIR ]
	then
		rm -rf $EG_HOME/$BACKUPDIR >>/dev/null
	fi
	
	echo 
	echo "*******************************************************************"
 	echo "Successfully committed the eG Manager patch "
	echo "*******************************************************************"
	echo 
;;

*)
	echo
	echo "Usage : ./eG_Patch.sh OPTION"
        echo
        echo " -a ..... Apply the Patch"
        echo " -r ..... Revert the eG Manager to its previous setup"
        echo " -c ..... Confirm and Commit upgrade changes "
	echo
;;
esac




