/*
 * Decompiled with CFR 0.152.
 */
package eg.syslog.utils;

import eg.syslog.utils.Params;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Resources {
    private ResourceBundle resources;
    private String myName;
    InetAddress localAddress;

    public Resources(String string) {
        this.myName = string;
        try {
            File file = new File(Params.path);
            URL[] uRLArray = new URL[]{file.toURI().toURL()};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            this.resources = ResourceBundle.getBundle("config." + this.myName, Locale.getDefault(), uRLClassLoader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string2 = exception.toString();
            int n = string2.indexOf(": ");
            this.error(n == -1 ? string2 : string2.substring(n + 2));
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resources;
    }

    public void error(String string) {
        System.err.println(this.myName + ".properties: " + string);
        System.exit(2);
    }

    public String getNull(String string) {
        String string2;
        try {
            string2 = this.resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(string + " resource not found in " + this.myName + ".properties");
            string2 = null;
        }
        return string2;
    }

    public String get(String string) {
        String string2 = this.getNull(string);
        return string2;
    }

    public String getAndTrim(String string) {
        String string2 = this.get(string);
        int n = string2.length();
        String string3 = new String();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (Character.isWhitespace(c)) {
                if (bl) continue;
                bl = true;
                string3 = string3 + ' ';
                continue;
            }
            string3 = string3 + c;
            bl = false;
        }
        return string3;
    }

    public char getChar(String string) {
        String string2 = this.getNull(string);
        if (string2 == null) {
            this.error("key '" + string + "' not found");
        }
        if (string2.length() != 1) {
            this.error("key '" + string + "' must have one char value");
        }
        return string2.charAt(0);
    }

    public boolean isTrue(String string) {
        String string2 = this.get(string);
        if (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("on") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("rulez") || string2.equalsIgnoreCase("enable")) {
            return true;
        }
        if (string2.equalsIgnoreCase("no") || string2.equalsIgnoreCase("off") || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("suxx") || string2.equalsIgnoreCase("disable")) {
            return false;
        }
        this.error("key '" + string + "' must be a logical value: yes/on/true/enable/rulez or no/off/false/disable/suxx ");
        return false;
    }

    public int integer(String string) {
        try {
            String string2 = this.get(string);
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.error("key '" + string + "' must be a integer value");
        }
        return 0;
    }

    public int getInterval(String string) {
        char c;
        int n = 0;
        String string2 = this.get(string);
        int n2 = string2.length() - 1;
        if (n2 < 0) {
            this.error("key '" + string + "' cannot be empty");
        }
        if ((c = string2.charAt(n2)) == 'h' || c == 'H') {
            n = 3600;
        } else if (c == 'm' || c == 'M') {
            n = 60;
        } else if (c == 's' || c == 'S') {
            n = 1;
        }
        if (n != 0 && n2 > 0) {
            string2 = string2.substring(0, n2);
        } else {
            n = 1;
        }
        try {
            return Integer.parseInt(string2) * n;
        }
        catch (NumberFormatException numberFormatException) {
            this.error("key '" + string + "' must be a interval value");
            return 0;
        }
    }

    public String getMyHostName() {
        String string = null;
        try {
            if (this.localAddress == null) {
                this.localAddress = InetAddress.getLocalHost();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.localAddress.toString(), "/");
            string = stringTokenizer.nextToken();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Unknown localhost address/name");
            System.exit(2);
        }
        return string;
    }
}

