
Ext.define('DonutAlertModel', {
    extend: 'Ext.data.Model',
    fields: [
      { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'noData', type:'boolean' },
        { name:'value', type:'number' },
        { name:'totalVal', type:'number' },
		{ name:'legend', type:'string' },
		{ name:'valCount', type:'string' },
		{ name:'sessions' },
		{ name:'DataSet' },
		{ name:'graphID', type:'string' }
    ]
});

// .stateIconRumAppFlowHealthy, .stateIconRumAppFlowMinor, .stateIconRumAppFlowMajor, .stateRumAppFlowNotOk
Ext.define('widgets.DonutAlert', {
     extend: 'Ext.container.Container',
	alias:'widget.donutalert',
	//cls:'widgetcon',
	//ui:'uniqueSessions',
	autoDestroy:true,
	//data:'',
	config: {
         data: null
    },
	num:'',
	id:'',
	store:null,
	items:[],
	updateData:function(data){
		var me = this;
		me.items.items[0].store.loadRawData(data);
		var jsonData = getHighChartsJSON(data,me.num,this.id,this);
		$('#donutalert-graph_'+me.num).highcharts(jsonData,
			function(chart) { // on complete
				var textX = chart.plotLeft + (chart.series[0].center[0]);
				var textY = chart.plotTop  + (chart.series[0].center[1]);							
				var span = '<span data-qtip="'+data.value+'" id="pieChartInfoText" style="font-family:Roboto;font-size:22px;z-index:9999999 !important;"><span>'+nFormatter(data.value)+'</span></span>';
				$("#addText_"+me.num).append(span);
				span = $('#pieChartInfoText');
				span.css('position', 'absolute');
				span.css('left', textX + (span.width() * -0.5));
				span.css('top', textY + (span.height() * -0.3));
		});
	},
	listeners:{
		 'afterrender':function(e){

			var me=this;
			var headerCss="";
			var strSkinclr = ( strSkin == 'Dark' )?'#6a6a6a':'#cdcdcd';

			if (me.ifGeo || me.ifOv || me.ifXtra)
			{
				var headerCss="font_normal15 fontStyleRobot";
			}
			else
			{
				headerCss="font_bold12";
			}

			var boxLayout = "c_box";
			var boxLayout1 = "e_box";
			var style1 = "display:none";
			if(!Ext.isEmpty(me.ifSbox) && me.ifSbox){
				boxLayout = "b_box";
				boxLayout1 = "s_box";
				style1="";
			}
			var showAlarm = this.data.showAlarm;
			if (me.ifUx)
			{
					DonutAlertTpl = new Ext.XTemplate(
					'<tpl for=".">',
					'<div class="widgetholders" >',
						'<div class='+boxLayout1+' style='+style1+'>',
							'<div class="fontStyleRobotRegular font_bold12 div_center trim_text" style="float:left;width:65%">',
							'<tpl if="state">',
								'<img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:5px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
							'<tpl else>',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;white-space:normal;" data-qtip="{heading}">{heading}</ span></div>',
							'</tpl>',
							
							 '<div style="float:right;width:35%;text-align:right" class="div_center"><div  class="font_bold20" style="margin-right:3px;text-align:right;display:inline-block;line-height:18px">{value}</div><div class="font_normal10" style="line-height:18px;display:inline-block;text-align:left;vertical-align:top;padding-right:15px">{footer}</div></div>',
							 '<div style="clear:both"></div>',
						 '</div>',
						'<div class='+boxLayout+'>',
						  '<div class="fontStyleRobotRegular font_bold13 title">',
							'<tpl if="state">',
								'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:5px;padding-top:2px;" data-qtip="{heading}" class="'+headerCss+'">{heading}</ span></div>',
							'<tpl else>',
								 '<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;white-space:normal;" data-qtip="{heading}" class="'+headerCss+'">{heading}</ span></div>',
							'</tpl>',
							'<div >',
							 '<tpl  if="noData != undefined && noData">',
								'<td style="text-align:center;"><div style="float:left;border:0px solid blue;margin-left:-10px;margin-top:-5px;width:100px;height:110px" id="donutalert-graph_'+this.num+'"></div>',
								'</td><td style="vertical-align:middle;padding-left:12px">',
									'<div>',
										'<table style="text-align:center;vertical-align:middle" cellspacing="0" cellpadding="0"><tr><td style="font-size:11px;">',
											'No Alerts <br>Found',
										'</td></tr></table>',
								'</div>',
							'<tpl else>',
								 '<div style="float:left;border:0px solid blue;margin-top:-5px;width:100px;height:110px" id="donutalert-graph_'+this.num+'"></div>',
									'<div class="sessions_legends" style="margin-top:0px">',
										'<table style="float:right;margin-right:0px" cellspacing="0" cellpadding="0"><tr>',
											'<tpl for="DataSet">',
												'<tpl for="data">',
													'<tpl if="color !=&quot;#cdcdcd&quot;">',
														'<td ><h3 style="color:{color};">.</h3></td><td class="fontStyleRobotRegular font_normal11" style="padding-right:20px">',
														'<tpl if="value ==&quot;0&quot;">',
															'<a>{text}&nbsp;({value})</a>',
														'<tpl else>',
															'<tpl if="subjectVariable !=&quot;&quot;">',
																'<a href="javascript:openAlarmPopup(\'{text}\',\'{subjectVariable}\')">{text}&nbsp;({value})</a>',
															'<tpl else>',
																'<a href="javascript:openAlarmPopup(\' \',\''+showAlarm+'\',\'{name}\')">{text}&nbsp;({value})</a>',
															'</tpl>',
														'</tpl>',
														'</td>',
														'<tpl if="value ==&quot;-&quot;">',
															'<tpl if="xindex % 2 != 0">',
																'</tr>',
															'</tpl>',
														'<tpl else>',
															'<tpl if="xindex % 2 === 0">',
																'</tr>',
															'</tpl>',
														'</tpl>',	
													'</tpl>',
												'</tpl>',
											'</tpl>',
											
										'</table>',
								'</div>',
							'</tpl>',
							//'</td></tr></table>',
						'</div>',
					'</div>',
				'</tpl>'
				);
			}
			else if (me.ifXtra)
			{
					DonutAlertTpl = new Ext.XTemplate(
					'<tpl for=".">',
					'<div class="widgetholders" >',
						'<div class='+boxLayout1+' style='+style1+'>',
							'<div class="fontStyleRobotRegular font_bold12 div_center trim_text" style="float:left;width:65%">',
							'<tpl if="state">',
								'<img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:5px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
							'<tpl else>',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;white-space:normal;" data-qtip="{heading}">{heading}</ span></div>',
							'</tpl>',
							
							 '<div style="float:right;width:35%;text-align:right" class="div_center"><div  class="font_bold20" style="margin-right:3px;text-align:right;display:inline-block;line-height:18px">{value}</div><div class="font_normal10" style="line-height:18px;display:inline-block;text-align:left;vertical-align:top;padding-right:15px">{footer}</div></div>',
							 '<div style="clear:both"></div>',
						 '</div>',
						'<div class='+boxLayout+'>',
						  '<div class="font_normal15 fontStyleRobot">',
							'<tpl if="state">',
								'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:5px;padding-top:2px;" data-qtip="{heading}" class="'+headerCss+'">{heading}</ span></div>',
							'<tpl else>',
								 '<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;white-space:normal;" data-qtip="{heading}" class="'+headerCss+'">{heading}</ span></div>',
							'</tpl>',
							'<div class="" style="margin-top:5px;padding-bottom:20px;">',
							//'<table style="margin:auto;margin-left:85px;" cellspacing="0" cellpadding="0"><tr><td  style="text-align:center;" >', // This table moved to inside the condition. because of no data view alinment issue fix
							'<tpl  if="noData != undefined && noData">',
								'<table style="margin:auto;" cellspacing="0" cellpadding="0"><tr><td  style="text-align:center;" >',
								'<div style="float:left;border:0px solid blue;margin-left:-10px;margin-top:-5px;width:10px;height:130px" id="donutalert-graph_'+this.num+'"></div>',
								'</td><td style="vertical-align:middle;">',
								 	'<div style="display:table;height:100%;width:100%" class="f12-normal">',
										'<div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Alerts Found</div></div>',
									'</div>',
									//'<div style="display:table;height:100%;width:100%" class="f12-normal">',
									//	'<table style="text-align:center;vertical-align:middle" cellspacing="0" cellpadding="0"><tr><td style="font-size:11px;">',
									//		'No Alerts Found',
									//	'</td></tr></table>',
									//'</div>',
							'<tpl else>',
								'<table style="margin:auto;margin-left:85px;" cellspacing="0" cellpadding="0"><tr><td  style="text-align:center;" >',
								'<div style="margin-left:25px;float:left;border:0px solid red;width:120px;height:125px" id="donutalert-graph_'+this.num+'"></div>',
								//'</td><td style="vertical-align:top;padding-left: 80px;">',
								'</td><td style="vertical-align:middle;width:70%">',
									//'<div class="sessions_legends" style="margin-left:-12px;margin-top:32px">',
									'<div class="sessions_legends">',
										'<table style="float:right;margin-right:0px" cellspacing="0" cellpadding="0"><tr>',
											'<tpl for="DataSet">',
												'<tpl for="data">',
													'<tpl if="color !=&quot;#cdcdcd&quot;">',
														'<td><h3 style="color:{color};">.</h3></td>',
															'<td class="fontStyleRobotRegular font_normal11" style="padding-right:60px !important">',
															'<tpl if="name ==&quot;Total&quot;">',
																'<a>{text} ({valCount})</a>',
															'<tpl elseif="value ==&quot;0&quot;">',
																'<a>{text} ({valCount})</a>',
															'<tpl else>',
																'<tpl if="color ==&quot;#0c9a12&quot;">',
																	'<span>{text} ({valCount})</span>',
																/*'<tpl elseif="color ==&quot;#30a1d9&quot;">',
																	'<span>{text} ({valCount})</span>',*/
																'<tpl elseif="subjectVariable !=&quot;&quot;">',
																	'<a href="javascript:openAlarmPopup(\'{text}\',\'{subjectVariable}\')">{text}</a>',
																'<tpl else>',
																	'<a href="javascript:openAlarmPopup(\' \',\''+showAlarm+'\',\'{name}\')">{text} ({valCount})</a>',
																'</tpl>',
															'</tpl>',
															'</td>',
														'<tpl if="value ==&quot;-&quot;">',
															'<tpl if="xindex % 2 != 0">',
																'</tr>',
															'</tpl>',
														'<tpl else>',
															//'<tpl if="xindex % 2 === 0">',
																'</tr>',
															//'</tpl>',
														'</tpl>',	
													'</tpl>',
												'</tpl>',
											'</tpl>',
											
										'</table>',
								'</div>',
								'</td></tr></table>',
							'</tpl>',
						'</div>',
					'</div>',
				'</tpl>'
				);
			}
			else if (me.ifOv)
			{
					DonutAlertTpl = new Ext.XTemplate(
					'<tpl for=".">',
					'<div class="widgetholders">',
						'<div class='+boxLayout1+' style='+style1+'>',
							'<div class="fontStyleRobotRegular font_bold12 div_center trim_text" style="float:left;width:65%">',
							'<tpl if="state">',
								'<img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:5px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
							'<tpl else>',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;white-space:normal;" data-qtip="{heading}">{heading}</ span></div>',
							'</tpl>',
							
							 '<div style="float:right;width:35%;text-align:right" class="div_center"><div  class="font_bold20" style="margin-right:3px;text-align:right;display:inline-block;line-height:18px">{value}</div><div class="font_normal10" style="line-height:18px;display:inline-block;text-align:left;vertical-align:top;padding-right:15px">{footer}</div></div>',
							 '<div style="clear:both"></div>',
						 '</div>',
						'<div class='+boxLayout+'>',
						  '<div class="font_normal15 fontStyleRobot">',
							'<tpl if="state">',
								'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:5px;padding-top:2px;" data-qtip="{heading}" class="'+headerCss+'">{heading}</ span></div>',
							'<tpl else>',
								 '<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;white-space:normal;" data-qtip="{heading}" class="'+headerCss+'">{heading}</ span></div>',
							'</tpl>',
							'<div class="widgetBottomBorder" style="margin-top:15px;padding-bottom:25px;">',
							'<table style="margin:auto" cellspacing="0" cellpadding="0"><tr><td  style="text-align:center;" >',
							'<tpl  if="noData != undefined && noData">',
								'<div style="float:left;border:0px solid blue;margin-left:-10px;margin-top:-5px;width:120px;height:140px" id="donutalert-graph_'+this.num+'"></div>',
								'</td><td style="vertical-align:middle;padding-left:12px">',
									'<div>',
										'<table style="text-align:center;vertical-align:middle" cellspacing="0" cellpadding="0"><tr><td style="font-size:11px;">',
											'No Alerts Found',
										'</td></tr></table>',
								'</div>',
							'<tpl else>',
								'<div style="float:left;border:0px solid red;margin-top:-5px;width:120px;height:130px" id="donutalert-graph_'+this.num+'"></div>',
								'</td><td style="padding-left:10px;vertical-align:middle;">',
									'<div class="sessions_legends">',
										'<table style="float:right;margin-right:0px" cellspacing="0" cellpadding="0"><tr>',
											'<tpl for="DataSet">',
												'<tpl for="data">',
													'<tpl if="color !=&quot;#cdcdcd&quot;">',
														'<td><h3 style="color:{color};">.</h3></td><td class="fontStyleRobotRegular font_normal11" style="padding-right:20px !important;">',
								 						'<tpl if="name ==&quot;Total&quot;">',
															'<a>{text} ({valCount})</a>',
														'<tpl elseif="value ==&quot;0&quot;">',
															'<a>{text} ({valCount})</a>',
														'<tpl else>',
								 							'<tpl if="color ==&quot;#0c9a12&quot;">',
																'<span>{text} ({valCount})</span>',
								 							'<tpl elseif="color ==&quot;#30a1d9&quot;">',
																'<span>{text} ({valCount})</span>',
															'<tpl elseif="subjectVariable !=&quot;&quot;">',
																'<a href="javascript:openAlarmPopup(\'{text}\',\'{subjectVariable}\')">{text}</a>',
															'<tpl else>',
																'<a href="javascript:openAlarmPopup(\' \',\''+showAlarm+'\',\'{name}\')">{text} ({valCount})</a>',
															'</tpl>',
														'</tpl>',
														'</td>',
														'<tpl if="value ==&quot;-&quot;">',
															'<tpl if="xindex % 2 != 0">',
																'</tr>',
															'</tpl>',
														'<tpl else>',
															//'<tpl if="xindex % 2 === 0">',
																'</tr>',
															//'</tpl>',
														'</tpl>',	
													'</tpl>',
												'</tpl>',
											'</tpl>',
											
										'</table>',
								'</div>',
							'</tpl>',
							'</td></tr></table>',
						'</div>',
					'</div>',
				'</tpl>'
				);
			}
			else if (me.ifSAP)
			{
				DonutAlertTpl = new Ext.XTemplate(
					'<tpl for=".">',
					'<div class="widgetholders" style="width:100%">',
						'<div class='+boxLayout1+' style='+style1+'>',
							'<div class="fontStyleRobotRegular font_bold12 div_center trim_text" style="float:left;width:65%">',
								'<tpl if="state">',
									'<img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
									'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:5px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
								'<tpl else>',
									'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;white-space:normal;" data-qtip="{heading}">{heading}</ span></div>',
								'</tpl>',
							 '<div style="float:right;width:35%;text-align:right" class="div_center"><div  class="font_bold20" style="margin-right:3px;text-align:right;display:inline-block;line-height:18px">{value}</div><div class="font_normal10" style="line-height:18px;display:inline-block;text-align:left;vertical-align:top;padding-right:15px">{footer}</div></div>',
							 '<div style="clear:both"></div>',
						 '</div>',
						'<div class='+boxLayout+'>',
						  '<div class="fontStyleRobotRegular font_bold13">',
							'<tpl if="state">',
								'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:5px;padding-top:2px;" class="newFont_bold14">{heading}</ span></div>',
							'<tpl else>',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;white-space:normal;"  class="newFont_bold14">{heading}</ span></div>',
							'</tpl>',
							'<div >',
							'<table style="margin:auto" cellspacing="0" cellpadding="0"><tr>',
							
						 '<td  style="text-align:center; " ><div style="border:0px solid blue;margin:0px auto 10px; width:100px;height:110px;font-size:24px;" id="donutalert-graph_'+this.num+'"></div></td>',
							
						 '<td style="vertical-align:middle;padding-left:2px">',
							'<div class="sessions_legends" style="margin-top:0px;">',
								'<table style="float:right;margin-right:0px" cellspacing="0" cellpadding="0"><tr>',
								
									'<tpl for="DataSet">',
										'<tpl for="data">',	
											'<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
													'<tpl if="!allZero">',
												'<tr><td style="padding : 0px 0 0px 0 !important"><h3 style="color:{color}; margin-left:0px;">.</h3></td><td class="fontStyleRobotRegular font_normal11" style="padding : 3px 0 5px 0 !important;">{text}&nbsp;({value})</td></tr>',
													'</tpl>',
											'</tpl>',
										'</tpl>',
									'</tpl>',
								'</table>',
							'</div></td></tr></table>',
						'</div>',
					'</div>',
					'</tpl>'
				);
			}
			else if(me.ifVer)
			{
				DonutAlertTpl = new Ext.XTemplate(
					'<tpl for=".">',
					'<div class="widgetholders" style="width:100%">',
						'<div class='+boxLayout1+' style='+style1+'>',
							'<div class="fontStyleRobotRegular font_bold12 div_center trim_text" style="float:left;width:65%">',
								'<tpl if="state">',
									'<img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
									'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:5px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
								'<tpl else>',
									'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;white-space:normal;" data-qtip="{heading}">{heading}</ span></div>',
								'</tpl>',
							 '<div style="float:right;width:35%;text-align:right" class="div_center"><div  class="font_bold20" style="margin-right:3px;text-align:right;display:inline-block;line-height:18px">{value}</div><div class="font_normal10" style="line-height:18px;display:inline-block;text-align:left;vertical-align:top;padding-right:15px">{footer}</div></div>',
							 '<div style="clear:both"></div>',
						 '</div>',
						'<div class='+boxLayout+'>',
						  '<div class="font_normal15 fontStyleRobot">',
							'<tpl if="state">',
								'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:5px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
							'<tpl else>',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;white-space:normal;" data-qtip="{heading}">{heading}</ span></div>',
							'</tpl>',
							'<div >',
							'<table style="margin:auto" cellspacing="0" cellpadding="0"><tr>',
							'<tpl  if="noData != undefined && noData">',
								'<td style="text-align:center;"><div style="float:left;border:0px solid blue;margin-left:-10px;margin-top:-5px;width:100px;height:110px" id="donutalert-graph_'+this.num+'"></div>',
								'</td><td style="vertical-align:middle;padding-left:12px">',
									'<div>',
										'<table style="text-align:center;vertical-align:middle" cellspacing="0" cellpadding="0"><tr><td style="font-size:11px;">',
											'No Alerts <br>Found',
										'</td></tr></table>',
								'</div>',
							'<tpl else>',
								 '<td  style="text-align:center;" ><div id="addText_'+this.num+'" style="border:1px solid red;position:absolute; left:32px; top:13px;"></div><div style="border:0px solid red;margin-top:-5px;width:100px;height:110px" id="donutalert-graph_'+this.num+'"></div></td>',
								'<td style="vertical-align:middle;padding-left:12px">',
									'<div class="sessions_legends">',
										'<table style="float:right;min-width:88px;min-height: 110px;max-height: 110px;height: 60%;align-items: center;width: 100%;margin-right:0px;overflow: auto;display: grid;" cellspacing="0" cellpadding="0"><tr>',
											'<tpl for="DataSet">',
												'<tpl for="data">',
													'<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
														'<tr><td><h3 style="color:{color};">.</h3></td><td class="fontStyleRobotRegular font_normal11">',
														'<tpl if="value ==&quot;0&quot;">',
															'<a>{text}&nbsp;({value})</a>',
														'<tpl else>',
															'<tpl if="subjectVariable !=&quot;&quot;">',
																'<a href="javascript:openAlarmPopup(\'{text}\',\'{subjectVariable}\')">{text}&nbsp;({value})</a>',
															'<tpl else>',
																'<a href="javascript:openAlarmPopup(\' \',\''+showAlarm+'\',\'{name}\')">{text}&nbsp;({value})</a>',
															'</tpl>',
														'</tpl>',
														'</td></tr>',
													'</tpl>',
												'</tpl>',
											'</tpl>',
											
										'</table>',
								'</div></td></tr></table>',
							'</tpl>',
						'</div>',
					'</div>',
					'</tpl>'
				);			
			}
			else if(me.ifMyDash)
						{
				DonutAlertTpl = new Ext.XTemplate(
					'<tpl for=".">',
					'<div class="widgetholders" style="width:100%">',
						'<div class='+boxLayout1+' style='+style1+'>',
							'<div class=" font_bold12 div_center trim_text" style="float:left;width:65%">',
								'<tpl if="state">',
									'<img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
									'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
								'<tpl else>',
									'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
								'</tpl>',
							 '<div style="float:right;width:35%;text-align:right" class="div_center"><div  class="font_bold20" style="margin-right:3px;text-align:right;display:inline-block;line-height:18px">{value}</div><div class="font_normal10" style="line-height:18px;display:inline-block;text-align:left;vertical-align:top;padding-right:15px">{footer}</div></div>',
							 '<div style="clear:both"></div>',
						 '</div>',
						'<div class='+boxLayout+'>',
						  '<div class="">',
							'<tpl if="state">',
								'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
							'<tpl else>',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
							'</tpl>',
							'<div style="margin-top:-3px;border:0px solid orange">',
							'<table style="margin:auto" cellspacing="0" cellpadding="0"><tr>',
							'<tpl  if="noData != undefined && noData">',
								'<td style="text-align:center;"><div style="float:left;border:0px solid blue;margin-left:-10px;margin-top:-5px;width:100px;height:110px" id="donutalert-graph_'+this.num+'"></div>',
								'</td><td style="vertical-align:middle;padding-left:12px">',
									'<div>',
										'<table style="text-align:center;vertical-align:middle" cellspacing="0" cellpadding="0"><tr><td style="font-size:11px;">',
											'No Alerts <br>Found',
										'</td></tr></table>',
								'</div>',
							'<tpl else>',
								 '<td  style="text-align:center;" ><div style="border:0px solid red;margin-top:-11px;width:100px;height:110px" id="donutalert-graph_'+this.num+'"></div></td>',
								'<td>',
									'<div class="sessions_legends">',
																		'</div></td></tr></table>',
							'</tpl>',
						'</div>',
					'</div>',
					'</tpl>'
				);
			}
			else
			{
				DonutAlertTpl = new Ext.XTemplate(
					'<tpl for=".">',
					'<div class="widgetholders" style="width:100%">',
						'<div class='+boxLayout1+' style='+style1+'>',
							'<div class="flexContainerForMini">',
								'<div class="flexItemsForMini trim_text" style="text-align:left">',
									'<tpl if="state">',
										'<img style="position: absolute;top:2px;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol__{state}" />',
										'<span class="f13-bold" style="margin-left:18px;" data-qtip="{heading}">{heading}</ span>',
								'</div>',
									'<tpl else>',
										'<span class="f13-bold" style="white-space:normal;" data-qtip="{heading}">{heading}</ span>',
								'</div>',
									'</tpl>',
									
								'<div style="text-align:center" class="flexItemsForMini">',
									'<div class="f18-bold" style="margin-right:3px;text-align:center;display:inline-block;line-height:18px">{value}</div><br/>',
									'<div class="f11-normal" style="line-height:10px">{footer}</div>',
								'</div>',
							'</div>',
							 '<div style="clear:both"></div>',
						 '</div>',
						'<div class='+boxLayout+'>',
						  '<div class="fontStyleRobotRegular font_bold13 title">',
							'<tpl if="state">',
								'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" />',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:5px;padding-top:2px;" data-qtip="{heading}">{heading}</ span></div>',
							'<tpl else>',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;white-space:normal;" data-qtip="{heading}">{heading}</ span></div>',
							'</tpl>',
							'<div style="margin-top:-3px;border:0px solid orange">',
							'<table style="margin:auto" cellspacing="0" cellpadding="0"><tr>',
							'<tpl  if="noData != undefined && noData">',
								'<td style="text-align:center;"><div style="float:left;border:0px solid blue;margin-left:-10px;margin-top:-5px;width:100px;height:110px" id="donutalert-graph_'+this.num+'"></div>',
								'</td><td style="vertical-align:middle;padding-left:12px">',
									'<div>',
										'<table style="text-align:center;vertical-align:middle;" cellspacing="0" cellpadding="0"><tr><td style="font-size:11px;padding:10px 5px 0px 5px">',
											'No Alerts <br>Found',
										'</td></tr></table>',
								'</div>',
							'<tpl else>',
								 '<td  style="text-align:center;" ><div id="addText_'+this.num+'" style="position:absolute; left:2px; top:20px;"></div><div style="border:0px solid red;margin-top:-5px;width:100px;height:110px" id="donutalert-graph_'+this.num+'"></div></td>',
								'<td>',
									'<div class="sessions_legends">',
										'<table style="float:right;min-width:88px;min-height: 110px;max-height: 110px;height: 60%;align-items: center;width: 100%;margin-right:0px;overflow: auto;display: grid;" cellspacing="0" cellpadding="0"><tr>',
											'<tpl for="DataSet">',
												'<tpl for="data">',
													'<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
														'<tr><td><h3 style="color:{color};">.</h3></td><td class="fontStyleRobotRegular font_normal11">',
														'<tpl if="value ==&quot;0&quot;">',
															'<a>{text}&nbsp;({value})</a>',
														'<tpl else>',
															'<tpl if="subjectVariable !=&quot;&quot;">',
																'<a href="javascript:openAlarmPopup(\'{text}\',\'{subjectVariable}\')">{text}&nbsp;({value})</a>',
															'<tpl else>',
																'<a href="javascript:openAlarmPopup(\' \',\''+showAlarm+'\',\'{name}\')">{text}&nbsp;({value})</a>',
															'</tpl>',
														'</tpl>',
														'</td></tr>',
													'</tpl>',
												'</tpl>',
											'</tpl>',
											
										'</table>',
								'</div></td></tr></table>',
							'</tpl>',
						'</div>',
					'</div>',
					'</tpl>'
				);			
			}
			var g_item = this.getItem(this.data,this.num,this.id,me);
			this.add(g_item);
		}		
	},
	getItem:function(data1,iid,Cid,thisObj){
		var item={
			xtype:'dataview',
			store: Ext.create('Ext.data.Store', {
					id:'Donutalert_model_id',
					model: 'DonutAlertModel',
					autoLoad:true,
					data:data1
				}),
			autoDestroy:true,
			tpl: DonutAlertTpl,
			listeners:
			{
				viewready:function(x)
				{
					var jsonData = '';
					if(!Ext.isEmpty(data1))
					{
						var jsonData = getHighChartsJSON(data1,iid,this.id,thisObj);
					}				

					if(!Ext.isEmpty(data1))
					{
						$('#donutalert-graph_'+iid).highcharts(jsonData,
							function(chart) { // on complete
								var textX = chart.plotLeft + (chart.series[0].center[0]);
								var textY = chart.plotTop  + (chart.series[0].center[1]);							
								var span = '<span data-qtip="'+data1.value+'" id="pieChartInfoText" style="font-family:Roboto;font-size:22px;z-index:999999 !important;"><span>'+nFormatter(data1.value)+'</span></span>';
								$("#addText_"+iid).append(span);
								span = $('#pieChartInfoText');
								span.css('position', 'absolute');
								span.css('left', textX + (span.width() * -0.5));
								span.css('top', textY + (span.height() * -0.3));
						});
					}
				}
			}
		}
		return item;
	},
	
	
 });

function getHighChartsJSON(Jdata,iid,cId,thObj){
	try
	{
		var pieChart = {};
		try
		{
			if (!Ext.isEmpty(thObj.ifXtra)){
				Jdata['innersize']='67%';
				Jdata['outersize']='135%';
			}
			else if (!Ext.isEmpty(thObj.ifOv)){
				Jdata['innersize']='67%';
				Jdata['outersize']='135%';
			}
			else if(!Ext.isEmpty(thObj.ifGeo)){
				Jdata['innersize']='51%';
			}
			else{
				Jdata['innersize']='67%';
				Jdata['outersize']='165%';
			}
			
		}
		catch (er)
		{
			Jdata['innersize']='70%';
		}

		if(!Ext.isEmpty(Ext.get('addText_'+iid)))
			Jdata['title'] = '';

		pieChart = jQuery.extend(true, {}, getDonutChartsInstance1('',null,null), pieChart);
		pieChart.setData(Jdata,'','','donut');
		jsonData = pieChart.highchart;
	}
	catch (er)
	{
		jsonData = null;
	}
	return jsonData;
}
