

Ext.define("utilities.GenericPieChartSlider",{
	extend:"Ext.panel.Panel",
	alias:"widget.genericpiechartslider",
	ui:'egGraphPanel',
	frame: false,
	scroll:false,
	autoScroll:false,
	layout:{
		align:'stretch',
		type:'vbox'
	},
	height:270,

	template:function(){
		var me = this;
		var sliderItems = new Ext.XTemplate(
			'<ul>',
			'<tpl for=".">',
				'<li ><div class="netFlowPieChartRightBorder"><div style="text-align:center;margin:10px 5px 0px 5px;">{COLUMN_0}</div><div id="chartholder{#}" style="margin: 0 auto" >ChartType</div></div></li>',
			'</tpl>',
			'</ul>'
			//'<div class="jcarousel-sider-control-prev"></div><div class="jcarousel-sider-control-next"></div>'
		 );
			return sliderItems;
	},
	
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'left',
		cls:'darkThemeTopBorder',
		items: [
		'->',
		{
			xtype:"button",
			cls:'jcarousel-slider-control-prev',
			iconCls:'iconSliderLeftArrow',
			text:'',
			style:{
				'background':"none",
				'border':"0px",
				'height':"20px !important",
			},
			height:24,
		},'->']
	},{
		xtype: 'toolbar',
		cls:'darkThemeTopBorder',
		dock: 'right',
		items: [
		'->',
		{
			xtype:"button",
			cls:'jcarousel-slider-control-next',
			iconCls:'iconSliderRightArrow',
			text:'',
			style:{
				'background':"none",
				'border':"0px",
				'height':"20px !important",
			},
			height:24,
		},'->']
	}],
	loadChart:function(data){
		var me = this;
		if(!Ext.isEmpty(data)){
			var count =1;
			for (var key in data)
			{
				var counter = count++;
				//me.chart('chartholder'+counter);
				
				  $(window).resize(function(){
						//$("#"+"chartholder"+counter).highcharts().reflow();
				});
				
			}
		}
	},
	sliderContainer:function(){
		var me = this;
		var cont = Ext.create('Ext.view.View', {
								cls:'jcarousel',
								data:me.data,
								tpl:me.template(),
								listeners:{
									viewready:function(){
										me.loadChart(me.data);
										me.loadjCarouselplugin();
									}
								},
								flex:1
		});
		return cont;
	},

	initComponent:function(){
				var me = this;
				me.items = me.sliderContainer();
				me.callParent();
	},
	loadjCarouselplugin:function(){
		var me = this;
		var jcarousel = $('.jcarousel');
				jcarousel.on('jcarousel:reload jcarousel:create', function() {
						var carousel = $(this), screenWidth = carousel.innerWidth();
						var pieCount = me.data.length;
						var chartWidth = me.data[0].width;
						Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-prev"]')[0].setDisabled(true);
						Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(false);

						if (screenWidth >= 2400) {
							if(pieCount == 6)
							{
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
							}
							if (pieCount >= 6)
							{
								var temp = screenWidth /6;
								if(chartWidth > temp){
									screenWidth = screenWidth /5;
									Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(false);
								}
								else {
									screenWidth = screenWidth /6;
								}
							}
							else{
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
								screenWidth = screenWidth /pieCount;
							}
						} else if (screenWidth >= 2000) {
							if(pieCount == 5)
							{
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
							}
							if (pieCount >= 5)
							{
								var temp = screenWidth /5;
								if(chartWidth > temp){
									screenWidth = screenWidth /4;
									Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(false);
								}
								else {
									screenWidth = screenWidth /5;
								}
							}
							else{
								screenWidth = screenWidth /pieCount;
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
							}
						} else if (screenWidth >= 1600) {
							if(pieCount == 4)
							{
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
							}
							if (pieCount >= 4)
							{
								var temp = screenWidth /4;
								if(chartWidth > temp){
									screenWidth = screenWidth /3;
									Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(false);
								}
								else {
									screenWidth = screenWidth /4;
								}
							}
							else{
								screenWidth = screenWidth /pieCount;
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
							}
						} else if (screenWidth >= 1200) {
							if(pieCount == 3)
							{
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
							}
							if (pieCount >= 3)
							{
								var temp = screenWidth /3;
								if(chartWidth > temp){
									screenWidth = screenWidth /2;
									Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(false);
								}
								else {
									screenWidth = screenWidth /2;
								}
							}
							else{
								screenWidth = screenWidth /pieCount;
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
								//Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setStyle("","");
							}
						} else if (screenWidth >= 800) {
							if(pieCount == 2)
							{
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
							}
							if (pieCount >= 2)
							{
								var temp = screenWidth /2;
								if(chartWidth > temp){
									screenWidth = screenWidth /1;
									Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(false);
								}
								else {
									screenWidth = screenWidth /2;
								}
							}
							else{
								screenWidth = screenWidth /pieCount;
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
							}
						} else if (screenWidth >= 600) {
							if (pieCount >= 1)
							{
								screenWidth = screenWidth /1;
							}
							else{
								screenWidth = screenWidth /pieCount;
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
							}
							if(pieCount == 1)
							{
								Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
							}
						}


					carousel.jcarousel('items').css('width', Math.ceil(screenWidth+10) + 'px');

					}).jcarousel({wrap: null});
				if(!Ext.isEmpty($('.jcarousel-slider-control-prev button').jcarouselControl))
					$('.jcarousel-slider-control-prev button').jcarouselControl({target: '-=1'});

				if(!Ext.isEmpty($('.jcarousel-slider-control-next button').jcarouselControl))
					$('.jcarousel-slider-control-next button').jcarouselControl({target: '+=1'});

				$('.jcarousel-slider-control-prev button').click(function() {
					var firstLi = $('.jcarousel').jcarousel('target').selector;
					Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(false);
					firstLi=firstLi.substring(firstLi.lastIndexOf('slice')+6,firstLi.length-3);
					if (firstLi == 0)
					{
						Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-prev"]')[0].setDisabled(true);
					}
				});

				$('.jcarousel-slider-control-next button').click(function() {
					var firstLi = $('.jcarousel').jcarousel('last').selector;
					Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-prev"]')[0].setDisabled(false);
					firstLi=firstLi.substring(firstLi.lastIndexOf('slice')+6,firstLi.length-3);
					if (me.data.length-1 == firstLi)
					{
						Ext.ComponentQuery.query('button[cls="jcarousel-slider-control-next"]')[0].setDisabled(true);
					}
				});
			},
});






