// JavaScript Document

Ext.define('virtualizationmanagerreports.view.VirtualizationManagerForm',{
	extend:'Ext.form.Panel',
	alias:'widget.virtualizationmanagerform',
 	id:'virtualizationmanagerform',
	screenLabels:null,
	hiddenFields:null,
	layout: 'column',
	defaults:{
		labelAlign:'top',
		margin: '0 20 10 0',
		labelSeparator:''
	},
	items:[
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 90,
				editable : false,
				fieldLabel:'Report type',
				name: 'er_type',
				id: 'er_type',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : [
					{
						'displayField':'zone1',
						'valueField':'zone1'
					}]
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local'
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 130,
				editable : false,
				id: 'er_comptype',
				name: 'er_comptype',
				fieldLabel:'Report for',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 130,
				editable : false,
				id: 'select_group',
				name: 'select_group',
				fieldLabel:'Analyze by',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable : true,
				id: 'zones',
				name: 'zones',
				fieldLabel:'Zone',
				listConfig:{
							emptyText:noMatch
						},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: true
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 110,
				editable : false,
				id: 'includezones',
				name: 'includezones',
				fieldLabel:'Include subZone',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: true
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable : true,
				id: 'services',
				name: 'services',
				fieldLabel:'Service',
				listConfig:{
							emptyText:noMatch
						},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: true
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable : true,
				id: 'segments',
				name: 'segments',
				fieldLabel:'Segment',
				listConfig:{
							emptyText:noMatch
						},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: true
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 130,
				editable : false,
				id: 'select_sort',
				name: 'select_sort',
				fieldLabel:'Show Stats for',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable : true,
				id: 'er_measure',
				name: 'er_measure',
				fieldLabel:'Measures',
				listConfig:{
							emptyText:noMeasureMatch
						},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype: 'checkboxgroup',
				fieldLabel: 'Reported By',
				hidden:true,
				width:400,
 				columns: 3,
 				id:'checkboxgroup',
				defaults:{
						cls: 'checkbt',
						margin:'3 0 0 0'
				},
				name:'checkboxgroup',
 				items: [
				{
					boxLabel: vmClustersLabel,
					name: 'rb',
					id:'vmcluster',
					//width:100,
					name:'VM Clusters',
 					inputValue: '2'
				},
				{
					boxLabel: vCenterLabel,
					name: 'rb',
					id:'vcenter',
					name:'vCenters',
					//width:70,
 					inputValue: '1'
				},
				{
					boxLabel: physicalServersLabel,
					name: 'rb',
					id:'physerver',
					//width:100,
					name:'Hypervisors',
 					inputValue: '2'
				}]
			},
			{xtype:'timeline',margin:0,width:''},
			{
				xtype:'button',
				text: submitValue,
				//cls: 'button20',
				ui:'newButtonSmall',
				itemId: 'submit',
 				margin: "20 10 10 0"
			},
			{
				xtype:'button',
				text: "Save",
				//cls: "button20",
				ui:'newButtonSmall',
				itemId: "save",
 				margin: "20 10 10 0"
			}
		],
	loadDefaultData : function(jsonObject){
						var thisForm = this.getForm();
                        this.screenLabels = jsonObject['screenlabels'];

                        this.setComboOptionsInList(thisForm, 'er_type', jsonObject.reporttypecombo, jsonObject.reporttypecombo_value);
                        this.setComboOptionsInList(thisForm, 'er_comptype', jsonObject.reportforCombo, jsonObject.reportforCombo_value);
                        this.setComboOptionsInList(thisForm, 'select_group', jsonObject.analysisby, jsonObject.analysisby_value);

                        if(jsonObject.reporttypecombo_value=="Yes")
                        {
                            this.setComboOptionsInList(thisForm, 'select_sort', jsonObject.showstatusCombo, jsonObject.showstatus_value);
                            this.setComboOptionsInList(thisForm, 'er_measure', jsonObject.measuresCombo, jsonObject.measure_value);

                        }
                        if(jsonObject.analysisby_value=="Component" || jsonObject.analysisby_value=="-1")
                        {
                            var components = Ext.getCmp('components');
							appConstants.rawDataForComponents = jsonObject.components;
                            components.getStore().loadRawData(jsonObject.components);
                            var values = [];

                            components.getStore().each( function( re ) {
                                values.push ( re.get('valueField') );
                            }, this);
                            components.setValue(values);
                            Ext.getCmp('compMultiselect').show();
                            thisForm.findField('includezones').hide();
                            thisForm.findField('zones').hide();
                            thisForm.findField('services').hide();
                        }
                        else if (jsonObject.analysisby_value=="Zone")
                        {
                        	var subz = thisForm.findField('includezones');
                        	subz.show();
                            subz.getStore().loadRawData(jsonObject['subzone']);
                            subz.setValue(subz.getStore().getAt(1));

                            var fieldObj = thisForm.findField('zones');
                            fieldObj.getStore().loadRawData(jsonObject['zone']);
                            if(jsonObject.select_groupName!=undefined)
                            {
                            	fieldObj.setValue(jsonObject.select_groupName);
                            }
                            else
                            {
                             fieldObj.setValue(fieldObj.getStore().getAt(0));
                            }
                            thisForm.findField('services').hide();
                            Ext.getCmp('compMultiselect').hide();
                        }
                        else if(jsonObject.analysisby_value=="Service")
                        {
                        	var fieldObj = thisForm.findField('services');
                        	fieldObj.show();
                            fieldObj.getStore().loadRawData(jsonObject['services']);
                            if(jsonObject.select_groupName!=undefined)
                            {
                                fieldObj.setValue(jsonObject.select_groupName);
                            }
                            else
                            {
                                fieldObj.setValue(fieldObj.getStore().getAt(0));
                            }

                            thisForm.findField('includezones').hide();
                            thisForm.findField('zones').hide();
                            Ext.getCmp('compMultiselect').hide();
                        }

                       var checkboxobj =  thisForm.findField('checkboxgroup');
                       var checkboxjson = jsonObject.checkboxdata;

                       var vcentercheckedvalue = jsonObject.vcentercheckedvalue;
                       var vclustercheckedvalue = jsonObject.vclustercheckedvalue;
                       var physervercheckedvalue = jsonObject.physervercheckedvalue;
						// 0 and 1 interChanged dont revert
                       if(checkboxjson[0]==vcentercheckedvalue)
                            checkboxobj.getComponent(1).setValue(true);

                       if(checkboxjson[1]==vclustercheckedvalue)
                            checkboxobj.getComponent(0).setValue(true);

                       if(checkboxjson[2]==physervercheckedvalue)
                           checkboxobj.getComponent(2).setValue(true);

                        checkboxobj.doLayout();

                        if(jsonObject.reporttypecombo_value=="Yes")
                        {
                        	checkboxobj.hide();					
							if(appConstants.er_report!=undefined && appConstants.er_report=='Cluster')
							{
                        		thisForm.findField('select_sort').hide();
							}
							else
							{
								thisForm.findField('select_sort').show();
							}
                            thisForm.findField('er_measure').show();
                        }
                        else
                        {
                        	checkboxobj.show();
                        	thisForm.findField('select_sort').hide();
                            thisForm.findField('er_measure').hide();
							//alert(jsonObject.reportforCombo_value);
							if (jsonObject.reportforCombo_value == 'Redhat_linux_mgr')
							{
								thisForm.findField('vcenter').getEl().down('label.x-form-cb-label').update('RHEV Manager');
								thisForm.findField('vmcluster').getEl().down('label.x-form-cb-label').update('RHEV Clusters');
								thisForm.findField('physerver').getEl().down('label.x-form-cb-label').update('Hypervisors');
								Ext.getCmp('vcenter').hide();
								Ext.getCmp('physerver').hide();
							}
							else if(jsonObject.reportforCombo_value == 'Nutanix_Cluster' || jsonObject.reportforCombo_value == 'Nutanix_Prism_Center')
							{
								thisForm.findField('vcenter').getEl().down('label.x-form-cb-label').update('Prism Server');
								thisForm.findField('vmcluster').getEl().down('label.x-form-cb-label').update('Prism Cluster');
								thisForm.findField('physerver').getEl().down('label.x-form-cb-label').update('Hypervisors');
								Ext.getCmp('vcenter').hide();
								Ext.getCmp('physerver').hide();
							}
							else 
							{
								thisForm.findField('vcenter').getEl().down('label.x-form-cb-label').update('vCenters');
								thisForm.findField('vmcluster').getEl().down('label.x-form-cb-label').update('VM Clusters');
								thisForm.findField('physerver').getEl().down('label.x-form-cb-label').update('Hypervisors');
								Ext.getCmp('vcenter').show();
								Ext.getCmp('physerver').show();
							}
                        }
						this.loadScreenLabels(thisForm);
						var timeline=jsonObject.timeline;
						this.setComboOptionsInList(thisForm, 'er_timeline', timeline.timelineCombo, timeline.timeline_value);

						thisForm.findField('er_sthr').setValue(timeline.starthourDispvalue);
						thisForm.findField('er_sthr').dataArray = timeline.starthour_value;
						thisForm.findField('er_endhr').setValue(timeline.endhourDsipvalue);
						thisForm.findField('er_endhr').dataArray = timeline.endhour_value;
						thisForm.findField('er_stdate').setValue(timeline.startDateDispValue);
						thisForm.findField('er_stdate').dataArray = timeline.startDateValue;
						thisForm.findField('er_enddate').setValue(timeline.endDateDsipValue);
						thisForm.findField('er_enddate').dataArray = timeline.endDateValue;
						mgr_stmin= timeline.startmin;
						mgr_enmin= timeline.endmin;

					

						this.hiddenFields = jsonObject['hiddenFields'];
						var from_schedule = this.hiddenFields["fromScheduleModify"];
						var fromFavoriteModify = this.hiddenFields["fromFavoriteModify"];
						if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) 
						{
							//Ext.getCmp("submit").hide();
							//Ext.getCmp("save").show();
							Ext.getCmp("favoriteTool").setDisabled(true);
							Ext.getCmp("scheduleTool").setDisabled(true);
						}
						else{
							//Ext.getCmp("submit").show();
							//Ext.getCmp("save").hide();
						}
					},
					loadScreenLabels : function(thisForm) {
						var screenLabels = this.screenLabels;

						thisForm.findField('er_type').setFieldLabel(screenLabels['reporter.common.Report Type']);
                        thisForm.findField('er_comptype').setFieldLabel(screenLabels['reporter.common.Report for']);
                        thisForm.findField('select_group').setFieldLabel(screenLabels['reporter.common.Analysis By']);
                        thisForm.findField('select_sort').setFieldLabel(screenLabels['reporter.common.Show Stats for']);
                        thisForm.findField('er_measure').setFieldLabel(screenLabels['reporter.common.Measures']);
                        thisForm.findField('checkboxgroup').setFieldLabel(screenLabels['reporter.common.Include Stats for']);
                        thisForm.findField('zones').setFieldLabel(screenLabels['reporter.common.Zone']);
                        thisForm.findField('includezones').setFieldLabel(screenLabels['reporter.thin.Include subzone']);

					},
					setComboOptionsInList : function(form, fieldName, list, value){
                        form.findField(fieldName).getStore().loadRawData(list);
                        form.findField(fieldName).suspendEvents(false);
                        var valueAssigned = false;
						if(Ext.isEmpty(value))
						{
							form.findField(fieldName).setValue(form.findField(fieldName).getStore().getAt(0).get('valueField'));
						}
						else
						{
							for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
								if(list[listCounter].valueField == value && value != "" && value != null){
									form.findField(fieldName).setValue(value);
									valueAssigned = true;
								}
							}
						}
                        

                        form.findField(fieldName).resumeEvents();
                    },
                     setComboValue : function(form,fieldName,value){
                         form.findField(fieldName).suspendEvents(false);
                         form.findField(fieldName).setValue(value);
                         form.findField(fieldName).resumeEvents();
                    },
					setNotApplicable : function(form, fieldname, value) {
                        form.findField(fieldname).getStore().removeAll();
                        form.findField(fieldname).getStore().loadRawData([{
                            "displayField" : this.screenLabel['reporter.common.Not Applicable'],
                            "valueField" : "-1"
                        }]);
                        form.findField(fieldname).setValue("-1");
                    }
	})



