$.getScript("/final/scripts/utilities/EgChartTheme.js");
function getHighChartsBarInstance(container_Id,chartHeight,chartWidth){
	var drawChart = true;
	var isDoNut = false;
 	var ErHighStockChart = {
	highchart: null,
	defaults: {
		chart: {
			plotBorderWidth: 0,
			plotBorderColor : '#e5e5e5',
			backgroundColor:'#ffffff',
			plotBackgroundColor: 'white',
			plotShadow: false,
			placeValuesInside:0,
			shadow: false,
			zoomType:'xy',
			align:'center',
			ignoreHiddenSeries:false,
			events: {
				load: function(event) {
					$('.highcharts-legend-item rect').attr('height', '8').attr('y', '6');
					$('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
				}
			}   
		},
		rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		yAxis: {
		    min: 0,
			border :0,
			//tickPixelInterval:75,
			reversedStacks: false,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: true,
			labels: {
				style: {
					color : '#636363',
					fontWeight: 'Normal',
					fontSize: '11px',
				},
			    formatter: function() {
					var val = Highcharts.numberFormat (this.value,4, '.','');
					//var val_ar = val.split('.');
					val = (parseFloat(val));
					/*if(val_ar.length>1)
					{
						if(val_ar[1]=='0000')
							val = val_ar[0];
						else if (val_ar[1].lastIndexOf("000")>-1)
						{
							val = val_ar[0]+"."+val_ar[1].substring(0,1);
						}else if (val_ar[1].lastIndexOf("00")>-1)
						{
							val = val_ar[0]+"."+val_ar[1].substring(0,2);
						}
					}*/
					return val;
				},
			},
			showLastLabel: true,
			tickPositioner: function(min,max){
				var act = min,
				ticks = [];
				this.tickAmount=1;
				var flag=false;
				var interval=this.tickInterval;
				var second=0;
				if(min==max)
				{
					if(max>1)
						max=max+1;
					else if(max==0){
						max=max+1;
						second=0
						flag=true;
					}
					else
					{
						max=max+0.1;
					}
				}
				var cc=1
				while(act <= max){
					if(cc==2 && flag)
						ticks.push(second);
					else
						ticks.push(act);
					act+= interval;
					cc++;
				}
				if(!flag)
					ticks.push(act);
			  return ticks;  
			},
		},
		scrollbar: {
			enabled: false
		},
		legend: {
			verticalAlign: 'top',
			align:'center',
			layout: 'horizontal',
			borderWidth: 0,
			symbolWidth: 14,
			symbolHeight: 6,
			squareSymbol: false,
			symbolRadius: 6,

			//y:5,
			//x:5,
			//width: 300,
			adjustChartSize: false,
			navigation: {
				arrowSize: 5
			},
			itemStyle: {
				color : '#2a292a',
				fontWeight: 'normal',
				fontSize: '10px',
			},
			symbolWidth: 15,
		},
		labels :{
			itemStyle: {
				color : '#2a292a',
				fontWeight: 'Normal',
				fontSize: '10px',
			},
		},
		tooltip: {
			borderColor: 'black',
			valueDecimals: 4,
			style: {
					color : '#2a292a',
					fontWeight: 'Normal',
					fontSize: '10px',
				},
		},
		exporting: {
			enabled: false
		},
		credits: {
			enabled: false
		},
		xAxis: {
			type:'datetime',
			//tickPixelInterval:50,
			min: 0,
			border :1,
			lineWidth: 1,
			minPadding:0.02,
			maxPadding:0.02,
			ordinal: false,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: true,
			labels: {
				style: {
					color : '#636363',
					fontWeight: 'Normal',
					fontSize: '11px',
					whiteSpace: 'nowrap',
				},
				//overflow: 'justify',
				showLastLabel: true,
				endOnTick: true,
				showFirstLabel: true,
				startOnTick: true,
				useHTML: false,
			},
			title: {
				style: {
					color : '#636363',
					fontWeight: 'Bold',
					fontSize: '11px',
				},
			},
		},
		title: {
				text: '',
				style: {
					color : '#2a292a',
					fontWeight: 'Normal',
					fontSize: '12px',
				}
			},
	},
	setData: function(jsonData,currentDateFormat,drilldownurl) {
 		var toolTipFmt = '';
		var chartType = 'bar';
	    var setStacking='normal';
		var isHourWise=false;
		var popUpSeriesClickUrl='';
		var isSharedToolTip=false;
		var enableSeriesClick=false;
		var popUpSeriesClickUrl='';
		var enableChartPopup=false;//dummy
		var setMinPointLength=0;
		var setendOnTick=true;
		var enable_Format=jsonData['enable_Format'];
		var formatForPieChartVal=jsonData['formatForPieChart'];
		var formatForPieChart="";
		if(Ext.isEmpty(enable_Format))
		{
			enable_Format="";
			formatForPieChart='{point.name}';
		}
		else
		{
			formatForPieChart='{point.name}:{point.percentage:.1f} %';
		}
		if(formatForPieChartVal != "" && formatForPieChartVal != 'null' && formatForPieChartVal != 'undefined' && formatForPieChartVal != undefined)
			formatForPieChart='{point.name}'+formatForPieChartVal+'{point.percentage:.1f} %';
		var insidePos= jsonData['inside'];
		fontFamily = jsonData['fontName'];
		fontSize = jsonData['fontsize'];
		yaxisTitle = jsonData['yAxisLabel'];
		LegendPosition = jsonData['LegendPosition'];
		showLegend = jsonData['showlegendFont'];
		xLabel = jsonData['xAxisLabel'];
		xAxisLabelDDArry = jsonData['xAxisLabelDDArry'];//..
		var xLabelText = jsonData['xAxisLabelText'];
		LegendFont = jsonData['LegendFont'];
		chartType = jsonData['chartType'];
		if(jsonData['isHourWise'] != undefined && jsonData['isHourWise'] != 'undefined' && jsonData['isHourWise'] != null && jsonData['isHourWise'] != '')
			isHourWise = jsonData['isHourWise'];
		if(jsonData['isSharedToolTip'] != undefined)
			isSharedToolTip = jsonData['isSharedToolTip'];
		if(jsonData['enableSeriesClick'] != undefined)
			enableSeriesClick = jsonData['enableSeriesClick'];
		//
		if(jsonData['enableChartPopup'] != undefined)
			enableChartPopup = jsonData['enableChartPopup'];
		//
		if(jsonData['popUpSeriesClickUrl'] != undefined && enableChartPopup)
			popUpSeriesClickUrl = jsonData['popUpSeriesClickUrl'];
		if(chartType!=null && chartType=='combinedChart')
		{
			yaxisTitle = jsonData['yAxisLabel1'];
		}
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
		YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
		fontFamily='Arial';
		LegendFont='Arial';		
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['yAxisLabel']:yaxisTitle;
		xLabel =(xLabel == null || xLabel == '')?'':xLabel;
		xLabelText =(xLabelText == null || xLabelText == '')?'':xLabelText;
		titleEnable =(xLabelText == null || xLabelText == '')?false:true;
		fontFamily =(fontFamily == null || fontFamily == '')?'Arial':fontFamily;
		fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
		LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
		LegendFont =(LegendFont == null || LegendFont == '')?'Arial':LegendFont;
		legendWidth = (LegendPosition == 'right')?190:400;
		needLegendFormat = (LegendPosition == 'right')?'true':'false';
		maxLegendHeight = (LegendPosition == 'right')?null:50;
		//valign = (LegendPosition == 'right')?'middle':'top';
		valign=LegendPosition;
		var showLegends =jsonData['legend'];		
		if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
			showLegends=false;
		else if(showLegends == 'true' || showLegends == true)
			showLegends=true;
		else if(showLegends == 'false' || showLegends == false)
			showLegends=false;
		if(insidePos == "" || insidePos == 'null' || insidePos == 'undefined' || insidePos == undefined)
			insidePos=false;
		else if(insidePos == 'true')
			insidePos=true;
		var needDonutTitle =jsonData['needDonutTitle'];
		var chartTitle =jsonData['title'];
		chartTitle=needDonutTitle != undefined && needDonutTitle=='yes'?chartTitle:'';
		//chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
		var chartContObj=document.getElementById(container_Id);
       //var setGroupPadding=-0.1;
		var setGroupPadding=-0.065;
		var setPointPadding=0.1;// default value
		var data=jsonData['DataSet'];
		var rotateDegree=0;
		var dataLabelColor='#FFFFFF';
		var chartSubType=jsonData['chartSubType'];
		var drilDown=jsonData['drildown'];
		var setPointWidth=null;
		var setCursor=null;
		var isUptimeChart=jsonData['uptime'];
		var space =[10, 10, 10, 10];
		var yaixlinewidth=0;
		var xtickwidth=0;
		var ticklength=10;
		var xval=-10;
		var ymax=null;
		var yVal=0;
		var isHypervisorResoucesChart=jsonData['isHypervisorChart'];
		if(chartType!=null && chartType=='stack')
		{
			chartType = 'area',
			chartSubType ='stacked';
		}


		ymax = jsonData['ymax'];
		if(ymax == "" || ymax == 'null' || ymax == 'undefined' || ymax == undefined)
			ymax=null;
		if(!(chartSubType!=null && chartSubType=='stacked'))
				setStacking=null;
		if(!showLegends)
		{
			if(chartSubType!=null && chartSubType=='stacked')
			{
				if(chartType!=null &&chartType=='column')
					if(chartTitle == null || chartTitle == '')
						space=[40, 10, 10, 10];
			}
		}
		var piechartTitleVAlign=null;
		var piechartTitleY=10;
		var pieInnerSize='';
		var subTitleAlign='left';
		if(chartType!=null && chartType=='donut')
		{
			chartType='pie';
			isDoNut = true;
			pieSize=jsonData['pieSize'];
			pieInnerSize=jsonData['innerSize'];
			if(pieSize == "" || pieSize == 'null' || pieSize == 'undefined' || pieSize == undefined)
				pieSize='150%';

			if(pieInnerSize == "" || pieInnerSize == 'null' || pieInnerSize == 'undefined' || pieInnerSize == undefined)
				pieInnerSize='100%';
			showLegends =jsonData['showlegend'];
			if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
				showLegends=false;
			isDataLabelEnable=false;
			mychartheight = jsonData['chartHeight'];
			if(mychartheight == "" || mychartheight == 'null' || mychartheight == 'undefined' || mychartheight == undefined)
				mychartheight='100%';
			subTitleAlign='center',
			piechartTitleVAlign='middle';
			//piechartTitleY=0;
			piechartTitleY=20; //. for donut inner title center alignment
		}
		var cursorStyle='';
		if(drilDown!=null && (drilDown=='sametab'||drilDown=='newtab'))
		{
			setCursor='pointer';
			cursorStyle='pointer';
		}
		var calBarwidth=0;
		var calx=100;
		/*if(data!=null && data.length==1)
			showLegends=false;*///..
		if(data!=null && data.length>=1)
		{
			calx = (chartWidth/data.length)+40;
			var xx=data[0].data;
			calBarwidth=21+((chartHeight-((xx.length*21)+50))/xx.length)/10
			
			var tempchartHeight=((xLabel.length)*24)+45;
			
			if(chartType!=null &&chartType=='bar')
			{
				if(tempchartHeight>chartHeight)
					chartHeight=tempchartHeight;
			}

			if(data.length>1)
			{
				if(xLabel.length>2)
					setPointWidth = 15;
				else
				{
					if(data.length>2)
						setPointWidth = 19;
					else
						setPointWidth = 21;
				}
			}
			else
				setPointWidth = 20;
			
			if(xx.length==1)
			{
				setGroupPadding=0.2;
				setPointPadding=0.4;
			}
			else if(xx.length>1 && xx.length<=4)
			{
				setGroupPadding=0.2;
				setPointPadding=0.3;
			}
			if(data.length>2 && xLabel.length>1)
			{
				setGroupPadding=0.09;
				setPointPadding=0.2;
			}

			

		}
		var allowDecimalInterval=true;
		var decimalInterval=jsonData['decimalInterval'];
		if(decimalInterval != undefined && decimalInterval != "" && decimalInterval=='false')
		{
			allowDecimalInterval=false;//..
		}
		var isDataLabelEnable=jsonData['isDataLabelEnabled'];
		var isCombinationLineChart=jsonData['isCombinationLineChart'];
		var setMarkerEnable=true;
		var isEndOnTick=jsonData['endOnTick'];
		var percentEnableTick=jsonData['percentEnableTick'];
		var tempDataLabelEnable=true;
		if(isDataLabelEnable==false)
		{
			 isDataLabelEnable=false;
			 tempDataLabelEnable=false;
		}
		else if(isDataLabelEnable == "" || isDataLabelEnable == 'null' || isDataLabelEnable == 'undefined' || isDataLabelEnable == undefined)
		{
             isDataLabelEnable=true;
		}
			
		if(chartType!=null && chartType=='pie')
		{
			strpointFormat='';
			dataLabelColor='#2a292a';
			if(strSkin=='Dark' || strSkin=='dark')
					dataLabelColor='#c0c0c0';
		}
		else
		{
			strpointFormat='<b>:{point.y}</b>';
		}
		if(chartType!=null && (chartType=='column' ||chartType=='line' || chartType=='area'|| chartType=='combinedChart'))
		{
			rotateDegree=-45;
			if(chartType=='column')
				rotateDegree=-90;
			yVal=20;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				xtickwidth=1;
				ticklength=5;
				xval=2;
			  strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
			}
			else
			{
			strpointFormat='<b>:{point.y}</b>';
			}
		}
		if(chartType!=null && chartType=='bar')
		{
			yaixlinewidth=1;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				dataLabelColor='#FFFFFF';
				setendOnTick=false;
				if(isUptimeChart!=null && isUptimeChart=='uptimechart')
				{
					setPointWidth=21;
				}
				else
				{
					setPointWidth=20;
				}
			}
			else
			{
				dataLabelColor='#2a292a';
				if(strSkin=='Dark' || strSkin=='dark')
					dataLabelColor='#c0c0c0';
				  setMinPointLength=10;
			}
		}
		if(jsonData['needZeroValue'] != undefined && jsonData['needZeroValue'] == 'yes')
		{
			setMinPointLength=3;
		}
		if(jsonData['pointPadding'] != undefined)
		{
			setPointPadding=jsonData['pointPadding'];
		}
		if(jsonData['groupPadding'] != undefined)
		{
			setGroupPadding=jsonData['groupPadding'];
		}
		if(chartType!=null && chartType=='line')
		{
			yaixlinewidth=1;
			setStacking=null;
			strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
	    }
		var fontweight="Normal";
		var fontsize="11px";
		var fontfamily='Arial';
		if(chartType!=null && chartType=='pie'){
			fontsize="11px"
			fontfamily='Arial';
			fontweight="bold";
		}
		if(isCombinationLineChart==true)
		{
		setStacking=null;
        setMarkerEnable=false;
	    }
		if(yaxisTitle!=null && (yaxisTitle.indexOf('%')>-1 || yaxisTitle.indexOf('(%)')>-1))
		{
			if(ymax==null)
				setendOnTick=true;
		}	
		if(isEndOnTick==false)
		{
			 setendOnTick=false;
		}
		var lablecolor='#2a292a';
		var connColor='#C0C0C0';
		if(strSkin=='Dark' || strSkin=='dark')
		{
			lablecolor='#636363';
			connColor='#9b9fa1';
		}
		var marginbottom=null;
		var marginright=null;
		var mychartwidth=chartWidth;
		var mychartheight=chartHeight;
		var marginTop=20;
		var isTopNReport=jsonData['isTopNReport'];

		if(xLabel.length>=6)
			marginbottom=chartHeight-20-(xLabel.length)*(setPointWidth+1);
		if(chartType!=null && chartType=='column')
		{
			marginbottom=null;
			marginTop=null;
			//if(chartContObj!=null)
			//	chartContObj.style.height = '100%';
			if(xLabel.length>=6)
				marginright=chartWidth-20-(xLabel.length)*(setPointWidth+5);
			if(marginright>150)
				marginright =30;

			if(marginright<0)
				marginright=chartWidth-20-(xLabel.length)*(setPointWidth+3);
			if(setPointWidth==null)
				marginright=30;
		}
		if(chartType!=null && chartType=='bar')
		{
			mychartwidth=null;
			if(chartContObj!=null)
			{
				chartContObj.style.width = '97%';

				if(isTopNReport!=undefined && isTopNReport!=null && isTopNReport==true)
				 chartContObj.style.width = '100%';
			}


			if(chartSubType==null || chartSubType!='stacked')
				setendOnTick=true;
		}
		var xlinewidth=0;
		if(chartType!=null && (chartType=='line'))
		{
			//xlinewidth=1;
			yaixlinewidth=0
			setendOnTick=false;
			marginTop=null;
			marginbottom=null;
			mychartwidth=null;
		//	mychartheight=null;//..
			if(chartContObj!=null)
			{
				chartContObj.style.height = '100%';
				if(chartType=='pie')
					chartContObj.style.width = '100%';
				else
					chartContObj.style.width = '97%';
			}
		}

		if(percentEnableTick==true)
		{
			 setendOnTick=false;
		}
			
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var jsonYval=jsonData['yVal'];
		if(jsonYval != "" && jsonYval != 'null' && jsonYval != 'undefined' && jsonYval != undefined )
		{
			yVal=jsonYval;
		}
		var marginTopVal=jsonData['disablemarginTop'];
		if(marginTopVal != "" && marginTopVal != 'null' && marginTopVal != 'undefined' && marginTopVal != undefined && marginTopVal=="true")
		{
			marginTop=null;
		}
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var pieSize='80%';
		var pieSizeVal=jsonData['pieSize'];
		if(pieSizeVal != "" && pieSizeVal != 'null' && pieSizeVal != 'undefined' && pieSizeVal != undefined )
		{
			pieSize=pieSizeVal;
		}
		var centerlegendPostion=jsonData['centerlegendPostion'];
		if(centerlegendPostion != "" && centerlegendPostion != 'null' && centerlegendPostion != 'undefined' && centerlegendPostion != undefined && centerlegendPostion=="true" )
		{
			calx=(chartWidth/4)+25;			
		}
		var boldYaxisLabel=jsonData['boldYaxisLabel'];
		if(boldYaxisLabel != "" && boldYaxisLabel != 'null' && boldYaxisLabel != 'undefined' && boldYaxisLabel != undefined && boldYaxisLabel=="true" )
		{
			yaxisTitle="<b>"+yaxisTitle+"</b>";
		}
		var tooltipEnable=true
		var enableToolTip=jsonData['enableToolTip'];
		if(enableToolTip != "" && enableToolTip != 'null' && enableToolTip != 'undefined' && enableToolTip != undefined && enableToolTip=="false" )
		{
			tooltipEnable=false;
		}
		var pointRadius=4;
		var pointRadiusVal=jsonData['pointRadius'];
		if(pointRadiusVal != "" && pointRadiusVal != 'null' && pointRadiusVal != 'undefined' && pointRadiusVal != undefined && pointRadiusVal=="false" )
		{
			pointRadius=pointRadiusVal;
		}
		var tooltipPercent=false;
		var enableTooltpPercent=jsonData['enableTooltpPercent'];
		if(enableTooltpPercent != "" && enableTooltpPercent != 'null' && enableTooltpPercent != 'undefined' && enableTooltpPercent != undefined && enableTooltpPercent=="true" )
		{
			tooltipPercent=true;
		}
		if(chartType!=null && chartType=='pie')
			mychartheight = mychartheight-25;
		var chartLegendDatas = jsonData['ShowLegendinTableFormatforUIData'];
		var LegendValues = jsonData['ShowLegendinTableFormatforUI'];
		var enableHtmlforLegend=false;
		if(LegendValues != undefined && chartLegendDatas.length > 0){
			showLegends=false;
			enableHtmlforLegend=true
			if (jsonData['DataSet'] != null && jsonData['DataSet'].length > 0){
				var legCnt=jsonData['DataSet'].length;
				var legvll=chartLegendDatas.length/5;
				if(legvll != undefined && legvll > 0 )
					legCnt=legvll;

				var legVal=(legCnt*25)+60;
				yRange=chartHeight;
				maxLegendHeight=legVal;
				if((xLabel != undefined && (xLabel.indexOf('MM') > -1 ) || xLabel == '' )){
					margin_bottom=legVal+70;
				}
				else
					margin_bottom=legVal+50;
				LegendPosition='left';
				legendWidth=null;
				chartHeight='';
				margin_top=null;
				var leg_Container=Ext.getCmp('legend_'+container_Id);
				var leg_div=document.getElementById('legend_'+container_Id);
				var leg_window=document.getElementById(container_Id+'_legend');
				var leg_panel=Ext.getCmp(container_Id+'_legendPanel');
				if(leg_Container != undefined || (leg_div != null && leg_div != undefined) || (leg_window != null && leg_window != undefined)|| (leg_panel != null && leg_panel != undefined)){
					margin_bottom=null;
				}
			}
		}
		var cursorStyle='';
		if(enableSeriesClick)
			cursorStyle='pointer';
		if(drilDown!=null && (drilDown=='sametab'||drilDown=='newtab'))
			cursorStyle='pointer';

		var spacing;
		var yValue= -10;
		var isShartPointReport = jsonData['fromSharePointReport'];
		if(isShartPointReport!=undefined || isShartPointReport!='undefined' && isShartPointReport == 'true')
		{
			//yValue = -20;
			spacing = [10, 30, 20, 0];
		}

		var isSharePointContentReport = jsonData['isSharePointContentReport'];
		if(isSharePointContentReport!=undefined || isSharePointContentReport!='undefined' && isSharePointContentReport == 'true')
		{
			//yValue = -20;
			spacing = [10, 30, 20, 0];
		}
		var enableMarker=false;
		if(jsonData['enableMarker'] != undefined && jsonData['enableMarker']=='true')
			enableMarker=true;
		var xAxisrotation = 270;
		if(chartType == 'bar')
			xAxisrotation = 0;
		var chartingOptions = {
			chart:{
				type : chartType,
				ignoreHiddenSeries: true,//..chart resize while clicking legend
				tableFormatLegend:chartLegendDatas,
				showLegendTable:jsonData['showLegendTable'],
				spacing:spacing,
				events: {
					load: function(event) {
						if(LegendValues != undefined ){//event.target.pointer
							//alert('===LegendValues==>>'+LegendValues);
							create_new_legend(event,true,container_Id);
						}
						else{
							$('.highcharts-legend-item rect').attr('height', '8').attr('y', '6');
							$('.highcharts-legend-item rect').attr('width', '8').attr('x', '10');
						}
					}
				}
			},
			title: {
				 text:chartTitle,
				 align: 'center',
				 verticalAlign: piechartTitleVAlign,
				 y:piechartTitleY
			},
			tooltip: {
					enabled:tooltipEnable,
					//pointFormat: strpointFormat,
					valueDecimals: 4,
					useHTML	: true,
					//shared:isSharedToolTip,
					shared:true,
					//split: true, //is working since highchart version 5
					formatter: function() {
						var val = Highcharts.numberFormat (this.y,4, '.','');
						if(tooltipPercent)
							val = Highcharts.numberFormat (this.percentage,2, '.','');
						
						val = (parseFloat(val));
						//if(val ==0)
						//	return false;
						var s ='';						
						//if(this.x == "" || this.x == 'null' || this.x == 'undefined' || this.x == undefined)
						if(this.x == "" || this.x == " " || this.x == 'null' || this.x == 'undefined' || this.x == undefined)//..
						{						
							if(strSkin=='Dark' || strSkin=='dark')
							{
								if(tooltipPercent)
									s += '<span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:white">'+val+' %</span>';
								else
									s += '<span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:white">'+val+'</span>';
							}
							else
							{
								if(tooltipPercent)
									s += '<span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:#2a292a">'+val+' %</span>';
								else
									s += '<span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:#2a292a">'+val+'</span>';
							}
						}else{
							if(strSkin=='Dark' || strSkin=='dark')
							{
								if(tooltipPercent)
									s += '<span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:white">'+ this.x +'  :  '+val+' %</span></b>';
								else
								{
									//s += '<b><span style="color:white">'+ this.x +'  :  '+val+'</span></b>';
									s+='<span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;">'+this.x+'</span>';
									s +='<table>'
									+'<tbody>';
									$.each(this.points,function(i,point){
										var seriesName=point.series.name;
										if(seriesName == undefined || seriesName == 'Series 1')
										{
											if(yaxisTitle==undefined)
												yaxisTitle='';
											seriesName=yaxisTitle;
										}
										s+='<tr><td style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;padding-top: 10px;color: '+point.series.color+'">'+seriesName+': </td>'
										+ '<td style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;padding-top: 10px;">'+point.y+'</td></tr>'
									});							
									s+='</tbody></table>';
									return s;
								}
							}else
							{
								if(tooltipPercent)
									s += '<b><span style="color:#2a292a">'+ this.x +'  :  '+val+' %</span></b>';
								else
								{
									s+='<span style="font-size: 12px;">'+this.x+'</span>';
									s +='<table>'
									+'<tbody>';
									$.each(this.points,function(i,point){									
										var seriesName=point.series.name;
										if(seriesName == undefined || seriesName == 'Series 1')
										{
											if(yaxisTitle==undefined)
												yaxisTitle='';
												//yaxisTitle=jsonData['yAxisLabel']; // commented because of same yAxisLabel is setinng all the chart.
											seriesName=yaxisTitle;
										}
										s+='<tr><td nowrap style="font-size: 12px;padding-top: 10px;color: '+point.series.color+'">'+seriesName+'&nbsp;: </td>'
										+ '<td nowrap style="font-size: 12px;padding-top: 10px;padding-left:5px">'+point.y+'</td></tr>'
									});							
									s+='</tbody></table>';
									return s;
								}
							}
						}
						return s;
					}
				},
			yAxis: {
					min: 0,
					max:ymax,
					tickWidth:0,
					tickmarkPlacement: 'on',
					tickLength: 5,
					allowDecimals:allowDecimalInterval,//..
					lineWidth:yaixlinewidth,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					endOnTick:setendOnTick,
					lineWidth:1,
					labels: {
						 style: {
								color : '#636363',
								fontWeight: 'Normal',
								fontFamily: 'LucidaGrandeRegular',
								fontSize: '10px',
							}
						},
					title: {
						text: yaxisTitle,
						enabled: YtitleEnable,
						margin:20,
						style: {
							color : '#636363',
							fontWeight: 'bold',
							fontFamily:'LucidaGrandeBold',
							fontSize: '11px',
							},
						},
				},
				xAxis: {
					min: 0,
					tickmarkPlacement: 'on',
					tickWidth:xtickwidth,
					tickLength: ticklength,
					categories: xLabel,
					gridLineWidth: xlinewidth,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					lineWidth:1,
					labels: {
						 rotation:xAxisrotation,
						// x:xval,
						 //y:yVal,
						 style: {
								color : '#636363',
								fontWeight: 'Normal',
								fontFamily: 'Lucida Grande',
								fontSize: '10px',
							},
							formatter: function() {
								var val=this.value;
								var val2=val.toString();
								if(val!=null && val.length>32)
								{
									var val2=val.substring(32);
									if(val2.length>3)
										val=(val.substring(0,32))+'...'
								}
								//..
								if(isHourWise && val != null && val.trim().indexOf(" ") != -1)
								{
									val = val.substring(val.lastIndexOf(" ")+1);

								}

								if(jsonData['needToAdjustXlabel']!=undefined && jsonData['needToAdjustXlabel'] == 'true')
								{
									val = val.substring(0, 15)+"...";
								}
								//..
								return val;
							}
						},
					title: {
						enabled: titleEnable,
						text:xLabelText,
						margin:20,
						style: {
							color : '#636363',
							fontWeight: 'bold',
							fontFamily:'LucidaGrandeBold',
							fontSize: '11px',
							},
						},
				},
			plotOptions: {
					 pie: {
						shadow: false,
						borderWidth: 0, // border color control
						size: pieSize,
						innerSize:pieInnerSize,
						allowPointSelect: true,
						cursor: setCursor,
						dataLabels: {
							format:formatForPieChart,
							crop: false,
							overflow: 'none',
							connectorColor: connColor,
							softConnector: false,
							distance:15
						},
						point: {
							events: {
							   click: function() {
										var QString=this.options.url;
										if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
										{
										}
										else if(chartType!=null && chartType=='pie')
										{
											if(drilDown!=null && drilDown=='sametab')
											{
										       document.location.href=QString;
											}
											else if(drilDown!=null && drilDown=='newtab')
											{
												openInNewWin(QString);
											}
										}
								   }
							},
						}
					 },
					bar:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
					//	pointWidth:setPointWidth,
						dataLabels:{
							enabled: tempDataLabelEnable,
							crop: false,
							overflow: 'none',
							style:{
								fontWeight:'normal',
								textShadow: false,
								textOutline: false 
								},
							/*filter: {
								property: 'percentage',
								operator: '>',
								value: 0
							}*/
						},
						point: {
							events: {
								click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='bar')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
											document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
									}
								}
							}
						}
					 },
					column:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						//pointWidth:setPointWidth,
						point: {
							events: {
							   click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='column')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
											document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
										/*if(QString.indexOf("/")>-1)
										{
											document.location.href=QString;
										}
										else
										{
											openInNewWin(QString);
										}*/
								   }
							   }
							}
						}
					 },
					line:{
						shadow: false,
						cursor: setCursor,
						marker: {
							   enabled:false,
								fillColor: '#FFFFFF',
								lineWidth: 0.5,
								lineColor: null ,
								symbol:'circle'
                                },
						point: {
							events: {
							   click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='line')
									{
										if(QString.indexOf("/")>-1)
										{
										  document.location.href=QString;
										}
										else
										{
											openInNewWin(QString);
										}
									}
								}
							}
						}
					 },
					series: {
							shadow: false,
							turboThreshold:100000,
							//stacking: 'normal', 
							stacking: setStacking, 
							borderWidth: 0,
							depth: 0,
							pointWidth:setPointWidth,
						//	groupPadding:setGroupPadding,
							//pointPadding:setPointPadding,
							dataLabels: {
								enabled: isDataLabelEnable,
								crop: false,
								overflow: 'none',
								inside:insidePos,
								rotation:rotateDegree,
								overflow:'none',
								x:3,
								formatter: function() {
									var val = Highcharts.numberFormat (this.y,4, '.','');
									val = (parseFloat(val));
									return val;
								},
								color:dataLabelColor,
								style: {
									color : dataLabelColor,
									fontFamily: fontfamily,
									fontSize: fontsize,
									fontWeight:'normal',
									textShadow: false,
									textOutline: false 
								}
							},
							states: {
								hover: {
									enabled: false
								}
							},
						//	minPointLength:setMinPointLength,
							maxPointWidth:18,
								//..
							cursor: cursorStyle,
							point: {
								events: {
									click: function (e) {
										if(enableSeriesClick && enableChartPopup && popUpSeriesClickUrl != '' && popUpSeriesClickUrl != undefined)
										{
											var getValu ='';
											var appName = data[0].appName;
											if (appName!=undefined && appName!=' '&& appName=='SharePoint Content Database')
											{
												if(data != null)
												{
													for(var d=0;d<data.length;d++)
													{
														var eachObj=data[d]; 
														var dataArry=eachObj.data;
														if(dataArry.length > 0)
														{
															var getWidget = popUpSeriesClickUrl.substring(popUpSeriesClickUrl.indexOf("&widget=")+8);
															getWidget = getWidget.substring(0,getWidget.indexOf("&"));
															if (getWidget!=undefined && getWidget!= '' && getWidget=='widgetInfo2')
															{
																getValu = dataArry[this.x].date
															}
															else
															{
																getValu = dataArry[this.x].name
															}
														} 
													}
												}
											}
											parent.maximizeWindowLightBox(popUpSeriesClickUrl+'&popupWindow=true&clickValue='+getValu);
										}
										//---sharepoint end
										if(enableSeriesClick && !enableChartPopup)
										{
											var mainContentText='';
											if(data != null && data.length>0)
											{
												mainContentText +='<table style="width:100%;"><tbody>'
												for(var d=0;d<data.length;d++)
												{
													var eachObj=data[d];
													var dataArry=eachObj.data;
													if(dataArry.length > 0)
													{
														mainContentText+='<tr><td nowrap style="font-weight:500;font-family:Arial;font-size:12px;padding:4px 5px 4px 5px;color: '+eachObj.color+'">'+eachObj.name+': </td>'
															+ '<td nowrap style="font-weight:500;font-family:Arial;font-size:12px;padding:4px 5px 4px 5px;width:40px;">'+dataArry[this.x]+'</td>';
														var url=eachObj.url;
														if(url != undefined)
														{
															if(xAxisLabelDDArry != undefined)
																url+=xAxisLabelDDArry[this.x];
															mainContentText+='<td  width=10% style="padding:4px 5px 4px 5px;"><div class=\'iconDiagnosis\'><a href="javascript:void(0);"	onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'\',\'Detail\');">&nbsp;&nbsp;&nbsp;</a></div></td></tr>';
														}
														else
															mainContentText+='</tr>';
													}
												}
												mainContentText+='</tbody></table>';
											}
											
											hs.allowMultipleInstances = false;
											hs.htmlExpand(null, {
												pageOrigin: {
													x: e.pageX || e.clientX,
													y: e.pageY || e.clientY
												},
												headingText: '<div style="color:#2a292a;margin-top:5px;margin-left:5px">'+this.category +"</div>",
												
												maincontentText:mainContentText,
												width: 160
											});
										}
										else
										{
											var QString=this.options.url;
											if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
											{
											}
											else if(chartType!=null && (chartType=='pie' || chartType=='bar'))
											{
												if(drilDown!=null && drilDown=='sametab')
												{
												   document.location.href=QString;
												}
												else if(drilDown!=null && drilDown=='newtab')
												{
													openInNewWin(QString);
												}
											}
										}
									}
								}
							},
							marker: { //..
								enabled: enableMarker,
								symbol: 'circle',
								radius: pointRadius
							}
								//..
							/* marker: {
								enabled: false,
								symbol: 'circle',
								radius: pointRadius
							}*/
						},
				},
			legend: {
					verticalAlign: 'top',
					//x: calx,
					x:5,
					//y: -10,
					y:yValue,
					itemDistance:5,
					enabled: showLegends,
					symbolPadding:10,
					//width:legendWidth,
					align:'center',
					//itemMarginBottom: 4,
					//maxHeight :maxLegendHeight,
					itemStyle: {
						fontFamily:'LucidaGrandeRegular',
					},
					useHTML: enableHtmlforLegend,
					labelFormatter: function() {
						var retrunvar = this.name;
						if(retrunvar.length>28 && needLegendFormat == 'true')
						{
							c=0;
							strval=''
							while(c<retrunvar.length)
							{
								strval+=retrunvar.substring(c,c+28)+'<br>';
								c=c+28;
							}
						retrunvar= strval;
						}
						return retrunvar;
					},
				}
			};
		var myhtml = '<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>';
		var chartContObj=document.getElementById(container_Id);
		this.highchart= jQuery.extend(true, this.defaults, chartingOptions);
		var chartData=[];
		if(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined)
		{
			drawChart = false;
			if(chartContObj!=null)
			{
				chartContObj.innerHTML=myhtml;
				$('#showLegend-inputEl').click(function () {
					var leg_window=document.getElementById(container_Id+'_legend');
					if(leg_window != null && leg_window != undefined){
						var isShowLegendEnable=Ext.getCmp("showLegend").getValue();
						showLegendChangeEvent(container_Id,isShowLegendEnable);
					}
				});				
			}
		}else{
			this.highchart.series=jsonData['DataSet'];
			this.highchart.chart.renderTo = container_Id;
		}
	},

	drawChart: function() {	
		if(drawChart)
		{
			Highcharts.setOptions({
				lang: {
						thousandsSep: ''
					}
			});
			Highcharts.setOptions({
				global: {
					useUTC: true,
					timezoneOffset: timezoneOffsetValue
				}
			});
			this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin));
			new Highcharts.Chart(this.highchart,function(chart){
				$('#showLegend-inputEl').click(function () {
					var leg_window=document.getElementById(container_Id+'_legend');
					var leg_panel=Ext.getCmp(container_Id+'_legendPanel');
					if((leg_window != null && leg_window != undefined) || (leg_panel != null && leg_panel != undefined)){
						var isShowLegendEnable=Ext.getCmp("showLegend").getValue();
						showLegendChangeEvent(container_Id,isShowLegendEnable);
					}
					else if(chart.options.legend.useHTML){						
						var isShowLegendEnable=Ext.getCmp("showLegend").getValue();
						create_new_legend(chart,isShowLegendEnable,container_Id) 
					}
					else
					{
						chart.legendToggle(); 
					}
	          });
	        });
			if(isDoNut)
			{
				donutChartTitle= {
				   title: {
					   useHTML:true,
						floating: true,
						offset: '',
						margin: 0,
						style: {
							color : (strSkin=='Dark' || strSkin=='dark') ? '#c0c0c0':'#2a292a',
							fontFamily:'Roboto-Bold',
							fontSize: '16px',
						}
				   }
				}
				this.highchart= jQuery.extend(true, this.highchart, donutChartTitle);
			}
			Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
			new Highcharts.Chart(this.highchart);
		}
	}

};
return ErHighStockChart;
}
 (function (H) {
          H.Chart.prototype.reflow = function () {
				
				var task = new Ext.util.DelayedTask(function(){
					 var clientWidth=renderTo.clientWidth; 
					 var clientHeight=renderTo.clientHeight; 
					 chart.setSize(clientWidth, clientHeight, false);
  				});

				var chart = this,
				renderTo = chart.renderTo;
 				Ext.EventManager.onWindowResize(function () {
					var initialClientWidth=renderTo.clientWidth; 
					if (initialClientWidth!=0)
					task.delay(100);
				});
      };
    }(Highcharts));



