<%
/*******************************************************************************
* File name	: ErCtxLogonSimulatorPRINT.jsp
* Purpose	: Logon Simulator Print, PDF
* Author	: Vensar
*******************************************************************************/

%>
	<!DOCTYPE html>
	<%@ include file = "ErTracker.jsp" %>
	<%@ page import = "com.eg.EgConfigInfo"%>
	<%@ page import = "com.eg.EgDbInfo" %>
	<%@ page import = "com.eg.EgMappingInfo"%>
	<%@ page import = "com.eg.EgReportInfo"%>
	<%@ page import = "com.egurkha.util.DateUtil"%>
	<%@ page import =  "net.sf.json.*"%>
	<%@ page import = "egurkha.reporter.ErUtils" %>

	<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
	<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
	<%@ page import="com.egurkha.util.StringUtils"%>

	<%
		String titleToDisplay = request.getParameter("er_RmDispName");
	try
	{
		String strManagerURL = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort();
		EgDbInfo dbInfo = new EgDbInfo("manager");
		com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
		EgReportInfo reportInfo = new EgReportInfo("manager");
		String isHighChartEnable=reportInfo.getValue("MISC","isHighChartExportEnable");
		ErUtils erUtils = new ErUtils();
		ErUtils utils = new ErUtils();

		String BLANK_SPACE = " ";
		String COMA = ",";
		String COLON = ":";
		String UTF_8 = "UTF-8";
		
		EgTimeZoneConverter timeZoneConverterStart = null;
		EgTimeZoneConverter timeZoneConverterEnd = null;
		String startDateForDisplay = null;
		String startHourForDisplay = null;
		String endDateForDisplay = null;
		String endHourForDisplay = null;
		String startMinForDisplay = null;
		String endMinForDisplay = null;

		User userName=UserRegistry.getInstance().getUser(session.getId());

		List selectedApplication = new ArrayList();
		String s_st_time = request.getParameter("startdate");
		String s_en_time = request.getParameter("enddate");
		String s_st_hr = request.getParameter("starthr");
		String s_en_hr = request.getParameter("endhr");
		String strmin = request.getParameter("startmin");
		String enmin = request.getParameter("endmin");
		String frompdf = request.getParameter("pdf");
		String s_farmserver = request.getParameter("er_zone");
		String s_compType = request.getParameter("er_compType");
		String[] s_application = request.getParameterValues("er_applicationX");
		String er_application = request.getParameter("er_applicationX");
		String[] selectedCompArray = request.getParameterValues("er_component");
		String pdfPrint = request.getParameter("pdfPrint");
		String sample = request.getParameter("sample");
		String drilldownenabled = request.getParameter("drilldownenabled");
		String timefrom = request.getParameter("timefrom");
		String minfrom = request.getParameter("minfrom");
		String timeto = request.getParameter("timeto");
		String minto = request.getParameter("minto");
		String iniDate = request.getParameter("inidate");
		String s_option = "graph";
		String chartApplication = request.getParameter("chartApplication");
		String strShowLegend = request.getParameter("showLegend");
		String er_trgttype = request.getParameter("er_trgttype");
		String er_location = request.getParameter("er_location");
		String printPageIdentify = request.getParameter("printPageIdentify");
		String er_option =request.getParameter("er_option");
		String er_site = request.getParameter("er_site");
		String selectedLoc = request.getParameter("selectedLoc");
		String selectedApp = request.getParameter("selectedApp");
		String selectedCompnt = request.getParameter("selectedCompnt");
		String commonPage = request.getParameter("commonPage");
		String enumerationComponents=reportInfo.getValue("CITRIX_LOGON_SIMULATOR","ExcludeEnumueration");
		String ICAEnabledType=reportInfo.getValue("CITRIX_LOGON_SIMULATOR","ICAEnabledType");
		boolean enableEnumulation=isEnumerationNeeded(s_compType,enumerationComponents);
		boolean enableICAFile=isICAenabled(s_compType,ICAEnabledType);
		String headerKeyName="";
		ArrayList singleSelection = new ArrayList();
		ArrayList singleColors = new ArrayList();
		EgMappingInfo intlmap = null;
		if(thisuser !=null)
		{
			intlmap = new EgMappingInfo(thisuser.getLanguage());
		}
		if(er_option!=null && er_option.equalsIgnoreCase("Segment"))
		{
			headerKeyName=er_option+" : "+er_site;
		}
		else if(er_option!=null && er_option.equalsIgnoreCase("Service"))
		{
			headerKeyName=er_option+" : "+er_site;
		}
		else if(er_option!=null && er_option.equalsIgnoreCase("Component"))
		{
			if(request.getParameter("er_compType")!=null)
			{
				
				headerKeyName=er_option+" : "+intlmap.getComponentTypeDescription(request.getParameter("er_compType"));
			}
			else if(request.getParameter("er_server")!=null)
			{
				headerKeyName=er_option+" : "+request.getParameter("er_server");
			}
			else
			{
				headerKeyName=er_option;
			}
		}
		else
		{
			headerKeyName="Zone"+" : "+request.getParameter("er_zone");
		}
		if(strShowLegend==null)
			strShowLegend = "false";
		String s_st_time_graph = null;
		if(s_st_time != null)
		{
			s_st_time_graph = new String(s_st_time);
		}
		String s_en_time_graph = null;
		if(s_en_time != null)
		{
			s_en_time_graph = new String(s_en_time);
		}


		Map resultMap = (Map) session.getAttribute("CITRIX_SIMULATOR_REPORT");
		
		String uiFile = "eg_ui.ini";
		String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";	
		com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
		String currentDateFormat = strUserDateFormat;
		String fontStyleDblSingl = "";
		if((dbInfo.doubleByteEnabled || !thisuser.getLanguage().equals("en_US")) && !(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes") || (sample != null && !sample.equalsIgnoreCase("yes") && drilldownenabled !=null && drilldownenabled.equalsIgnoreCase("yes"))))
		{
			fontStyleDblSingl = "multi_font";
		}
		else
		{
			fontStyleDblSingl = "";
		}
		if(s_application != null)
			selectedApplication = Arrays.asList(s_application);
	%>
	<!Doctype html>
	<head>
	<%
		if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
		{
	%>
		<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
		&nbsp; &nbsp; <egui:intnl text="reporter.common.Print" /> &nbsp;</title>
	<%
		}
		else
		{
	%>
		<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
		&nbsp; &nbsp;</title>
	<%
		}
	%>
	<meta name="Author" content="">
	<meta  charset="UTF-8">

	<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
	<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
	<link rel="stylesheet" type="text/css" href="/final/styles/componentsLight.css" />
	<style>

	@media print {body {-webkit-print-color-adjust: exact;}}

.iconTotalSimulations{background-position:0px -100px !important; width:15px; height:24px;}

.printHeaderBoxLogo{
	float:left;
	height:80px;
	z-index:100;
	background-repeat:no-repeat;
}
.printPdfHeaderBoxLogo{
	float:left;
	height:80px;
	z-index:100;
	background-repeat:no-repeat;
}

	.widgetBorder{
		border: 0px solid #d1d1d1 !important;
		background: #ffffff !important;
		-webkit-box-shadow: 0px 0px 0px 0px rgba(0,0,0,0);
		-moz-box-shadow: 0px 0px 0px 0px rgba(0,0,0,0);
		box-shadow: 0px 0px px 0px rgba(0,0,0,0);
		margin-bottom: 15px;
		-moz-border-radius: 0px 0px 0px 0px;
		-webkit-border-radius: 0px 0px 0px 0px;
		border-radius: 0px 0px 0px 0px;
		-ms-border-radius: 0px 0px 0px 0px;
		-o-border-radius: 0px 0px 0px 0px;
	}


.iconExclamation{ background-position:0 -200px !important; width:32px !important; height:32px !important; } 
.plainTableReporter{border:0px solid #cdcdcd;}
.plainTableReporter table{border:1px solid #cdcdcd;}
.plainTableReporter table tbody tr:nth-child(even) {background-color:#f9f9f9}
.plainTableReporter table tbody tr:nth-child(odd) {background-color:#ffffff}
.plainTableReporter table thead tr th {border:1px solid #cdcdcd;padding:4px 10px 2px 10px;font-size:11px;
background-color:#e6e6e6;text-transform:uppercase;}
.plainTableReporter table thead tr th.subHeader{background-color:#f5f5f5;text-align:center}
.plainTableReporter table tbody tr td {border-bottom:1px solid #cdcdcd;padding:3px 10px 3px 10px;font-size:11px;
}

.stateBgValue_HIGH,.stateBgValue_INTERMEDIATE,.stateBgValue_LOW,.stateBgValue_GOOD,.stateBgValue_UNKNOWN, .stateBgValue_GRAY{
	display:block;
	width:68px;
	height:14px;
	-moz-border-radius: 0.2em;
	-webkit-border-radius: 0.2em;
	-khtml-border-radius: 0.2em;
	border-radius: 0.2em;
	color:#fff;
	font-size:11px;
	text-align:center;
	line-height:16px
}

.stateBgValue_HIGH{background:#cd0f0f}
.stateBgValue_INTERMEDIATE{background:#fa9d1c}
.stateBgValue_LOW{background:#ccc100}
.stateBgValue_GOOD{background:#0c9a12}
.stateBgValue_UNKNOWN{background:#30a1d9}
.stateBgValue_GRAY{background:#8b8b8b}

.stateBox_HIGH,.stateBox_INTERMEDIATE,.stateBox_LOW,.stateBox_GOOD,.stateBox_UNKNOWN, .stateBox_GRAY{
		display:block;
		width:68px;
		height:14px;
		-moz-border-radius: 0.2em;
		-webkit-border-radius: 0.2em;
		-khtml-border-radius: 0.2em;
		border-radius: 0.2em;
		float:right;
		color:#fff;
		font-size:11px;
		text-align:center;
		line-height:16px
	}

	.stateBox_HIGH{background:#cd0f0f}
	.stateBox_INTERMEDIATE{background:#fa9d1c}
	.stateBox_LOW{background:#ccc100}
	.stateBox_GOOD{background:#0c9a12}
	.stateBox_UNKNOWN{background:#30a1d9}
	.stateBox_GRAY{background:#8b8b8b}

/* Reporter - GPU Overview page icons - start here  */
.iconServerGray, .iconServerGreen, .iconServerRed, .iconUpGreen, .iconDownRed, .iconWebLogIn, .iconClientIP, .iconClientName, .iconXenAppServer, .iconUniqueApp, .iconTimeGray, .iconTimeActive, .iconTimeIdle, .iconTotalSimulations, .iconSuccessfulSimulations, .iconFailedSimulations, .iconAppEnumeration, .iconAppLaunch, .iconFailedEnumeration, .iconLogonFailed, .iconIcaFileDownload{
	background : url('/final/images/Light/newReporterIcons.png') no-repeat top left;
}

.iconServerGray{background-position:0px 0px !important; width:24px; height:24px;}
.iconServerGreen{background-position:-24px 0px !important; width:24px; height:24px;}
.iconServerRed{background-position:-48px 0px !important; width:24px; height:24px;}
.iconUpGreen{background-position:-72px 0px !important; width:24px; height:24px;}
.iconDownRed{background-position:-96px 0px !important; width:24px; height:24px;}
.iconWebLogIn{background-position:0px -50px !important; width:24px; height:24px;}
.iconClientIP{background-position:-24px -50px !important; width:24px; height:24px;}
.iconClientName{background-position:-48px -50px !important; width:24px; height:24px;}
.iconXenAppServer{background-position:-72px -50px !important; width:24px; height:24px;}
.iconUniqueApp{background-position:-96px -50px !important; width:24px; height:24px;}
.iconTimeGray{background-position:-120px -50px !important; width:24px; height:24px;}
.iconTimeActive{background-position:-144px -50px !important; width:24px; height:24px;}
.iconTimeIdle{background-position:-168px -50px !important; width:24px; height:24px;}

.iconTotalSimulations{background-position:0px -100px !important; width:24px; height:24px;}
.iconSuccessfulSimulations{background-position:-24px -100px !important; width:24px; height:24px;}
.iconFailedSimulations{background-position:-48px -100px !important; width:24px; height:24px;}
.iconAppEnumeration{background-position:-72px -100px !important; width:24px; height:24px;}
.iconAppLaunch{background-position:-96px -100px !important; width:24px; height:24px;}
.iconFailedEnumeration{background-position:-120px -100px !important; width:24px; height:24px;}
.iconLogonFailed{background-position:-144px -100px !important; width:24px; height:24px;}
.iconIcaFileDownload{background-position:-48px -472px !important; width:24px; height:24px;}

.stateSymbol_12_HIGH, .stateSymbol_12_INTERMEDIATE, .stateSymbol_12_LOW, .stateSymbol_12_GOOD{
	background : url('/final/images/Light/newReporterIcons.png') no-repeat top left;
}

.stateSymbol_12_HIGH{background-position:0px -150px !important; width:12px; height:12px;}
.stateSymbol_12_INTERMEDIATE{background-position:-12px -150px !important; width:12px; height:12px;}
.stateSymbol_12_LOW{background-position:-24px -150px !important; width:12px; height:12px;}
.stateSymbol_12_GOOD{background-position:-36px -150px !important; width:12px; height:12px;}

.newFont_bold28{
	font-size: 28px !important;
	font-weight:500;
}
.newFont_bold15{
	font-size: 15px !important;
	font-weight:500;
}
.newFont_bold13{
	font-size: 13px !important;
	font-weight:500;
}
.newFont_normal13{
	font-size: 13px !important;
}

.graphSeperatorLineBottomRight{
	border-top-width:0px;border-right-width:1px;border-bottom-width:1px;border-left-width:0px; border-color:#f2f2f2;border-style:solid
}
.graphSeperatorLineRight{
	border-top-width:0px;border-right-width:1px;border-bottom-width:0px;border-left-width:0px; border-color:#f2f2f2;border-style:solid
}
.graphSeperatorLineBottom{
	border-top-width:0px;border-right-width:0px;border-bottom-width:1px;border-left-width:0px; border-color:#f2f2f2;border-style:solid
}

	</style>

	<style type="text/css" media="print">
	#printbt{ display:none}
	</style>

	</head>
	<body marginwidth="20" marginheight="20" bgcolor="#FFFFFF">
<%
	String strLogCls = "printHeaderBoxLogo";
	if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
		strLogCls = "printPdfHeaderBoxLogo"; 
	else
		strLogCls = "printHeaderBoxLogo";

%>
		<%
			if(frompdf !=null && frompdf.equalsIgnoreCase("no"))
			{
		%>
			<div class="<%=strLogCls%>" style="padding:10px"><img src="<%=imageName%>" border="0" /></div>
		<%
			}
			else
			{
		%>
			<div class="<%=strLogCls%>"><img src="<%=imageName%>" border="0" /></div>
		<%
			}
		%>
		<div class="printHeaderBox" >
<%
		if (!StringUtils.isNull(titleToDisplay))
		{
%>
			<div class="printHeaderBoxTitle"><%= titleToDisplay %>&nbsp;For <%=headerKeyName%>&nbsp;</div>
<%
		}
		else
		{
%>
			<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.Logon Simulator -"/>&nbsp;<%=headerKeyName%></div>
<%
		}
		//if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
		if(frompdf !=null && frompdf.equalsIgnoreCase("no"))
		{
%>
			<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrinter mouse" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0"  onClick="javascript:print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
		}
		String dispStart="";
		String dispEnd="";
		dispStart = s_st_time + " " + s_st_hr+COLON+strmin ;
		dispEnd = s_en_time + " " + s_en_hr+COLON+enmin ;
		timeZoneConverterStart = new EgTimeZoneConverter(dispStart ,userName);
		startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
		startHourForDisplay = timeZoneConverterStart.getHour();
		startMinForDisplay = timeZoneConverterStart.getMinute();

		timeZoneConverterEnd = new EgTimeZoneConverter(dispEnd ,userName);
		endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
		endHourForDisplay = timeZoneConverterEnd.getHour();
		endMinForDisplay = timeZoneConverterEnd.getMinute();

		String pdfStartDate=startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
		String pdfEndDate = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;
		Vector dvec = new Vector();
		String stimefmt = pdfStartDate+" "+ trackerMappingInfo.getTextDescription("reporter.common.hrs");
		String etimefmt = pdfEndDate+" "+ trackerMappingInfo.getTextDescription("reporter.common.hrs");
%>
	</div>
	<div class="printOuterBoxNoBorder"  style="display:initial">
<%
		if(er_trgttype!=null && er_trgttype.equalsIgnoreCase("locationBased"))
		{
			if (selectedLoc!=null)
			{
				if(selectedLoc.equalsIgnoreCase("all"))
				{
					selectedLoc = selectedLoc.toUpperCase();
				}
%>
		<div class="printSelectionFields"><%=trackerMappingInfo.getTextDescription("reporter.common.External Agent")%> - <span class="bold"><%=selectedLoc%></span></div>
<%
			}
		}
		else
		{
			if(selectedApp!=null)
			{
				if(selectedApp.equalsIgnoreCase("all"))
				{
					selectedApp = selectedApp.toUpperCase();
				}
%>
		<div class="printSelectionFields"><%=trackerMappingInfo.getTextDescription("reporter.common.Application")%> - <span class="bold"><%=selectedApp%></span></div>
<%
			}
		}
		if(s_compType != null)
		{
			%>
				<div class="printSelectionFields"><%=trackerMappingInfo.getTextDescription("reporter.common.Component Type")%> - <span class="bold"><%=intlmap.getComponentTypeDescription(s_compType)%></span></div>
			<%
		}
		if (timefrom!=null && minfrom!=null && timeto!=null && minto!=null)
		{
			String displayTimePeriod = timefrom+":"+minfrom+" to "+timeto+":"+minto;
%>
		<div class="printSelectionFields"><egui:intnl text="reporter.common.Time Period" /> - <span class="bold"><egui:intnl text="<%=displayTimePeriod%>" /></span></div>
<%
		}
%>
		<div class="printSelectionFields"><%=trackerMappingInfo.getTextDescription("reporter.common.Timeline")%> - <span class="bold"><%=stimefmt%>&nbsp;<%=trackerMappingInfo.getTextDescription("reporter.common.to")%>&nbsp; <%=etimefmt%>&nbsp;</span></div>
	</div>
	<div class="clearDiv">&nbsp;</div>
<%
		String mngrIP = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
		mngrIP="";
		String servlet = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&inidate="+com.eg.EgURLEncoder.encode(currentDateFormat,UTF_8)+"&startdate="+com.eg.EgURLEncoder.encode(s_st_time,UTF_8)+"&enddate="+com.eg.EgURLEncoder.encode(s_en_time,UTF_8)+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&startmin="+strmin+"&endmin="+enmin+"&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto+"&er_compType="+s_compType+"&showLegend="+com.eg.EgURLEncoder.encode(strShowLegend,UTF_8);

		String pageNo = request.getParameter("pageNo");
		JSONObject compObj = new JSONObject();
		Map dataList=null;
		if(er_trgttype!=null && er_trgttype.equalsIgnoreCase("locationBased"))
		{
			if(resultMap!=null && resultMap.containsKey("dataList"))
			{
				dataList= (Map)resultMap.get("dataList");
			}
		}
		else if(er_trgttype!=null && er_trgttype.equalsIgnoreCase("applicationBased"))
		{
			if(resultMap!=null && resultMap.containsKey("dataListForApp"))
			{
				dataList= (Map)resultMap.get("dataListForApp");
			}
		}
		if(dataList!=null && dataList.size()>0)
		{
			Set dataSet = (Set) dataList.entrySet();
			Iterator data_itr = dataSet.iterator();
			while (data_itr.hasNext())
			{
				Map.Entry mapEntry = (Map.Entry) data_itr.next();
				String key = (String) mapEntry.getKey();
				ArrayList values = (ArrayList) mapEntry.getValue();
				compObj.put(key+"#"+values.size(),values);
			}
		}
		String legdHeight = "6px";
		String legdWidth = "6px";
		JSONObject sessionValues =(JSONObject) session.getAttribute("printSessionData");
		System.out.println("er_trgttype --<--p->-- "+er_trgttype);
		System.out.println("er_location -->--p---- "+er_location);
		System.out.println("er_application -->--p---- "+er_application);
		System.out.println("printPageIdentify -->--p---- "+printPageIdentify);
		System.out.println("commonPage ->---p---- "+commonPage);
		if(printPageIdentify!=null && (printPageIdentify.equalsIgnoreCase("appMainTable") || printPageIdentify.equalsIgnoreCase("locMainTable")) && compObj!=null && compObj.size()>0 && er_trgttype!=null && (er_location!= null && er_location.equalsIgnoreCase("all") || er_application!= null && er_application.equalsIgnoreCase("all")))
		{
%> 
		<div class="printOuterBox">
			<div class="newTable">
				<table align="center" valign="middle" width="100%" cellpadding="0" cellspacing="0">
					<thead>
						<tr>
							<th align="center" rowspan="2">SIMULATION</th> 
<%
			if(er_trgttype!=null && er_trgttype.equalsIgnoreCase("locationBased"))
			{
%>
							<th align="center" rowspan="2">EXTERNAL AGENT</th>
<%
			}
			else if(er_trgttype!=null && er_trgttype.equalsIgnoreCase("applicationBased"))
			{
%>
							<th align="center" rowspan="2">APPLICATION/DESKTOP</th>
<%
			}
%>
							<th align="center" colspan="2">WEB LOGON</th>
<%
			if(enableEnumulation){
%>
							<th align="center" colspan="2">APPLICATION/DESKTOP ENUMERATION</th>
<%
			}
			if(enableICAFile){
%>
							<th align="center" colspan="2">ICA FILE DOWNLOAD</th>
<%
			}
%>
							<th align="center" colspan="2">APPLICATION/DESKTOP LAUNCH</th>
						</tr>
						<tr>
							<th class="subHeader">Availability (%)</th>
							<th class="subHeader">Duration (Secs)</th>
<%
			if(enableEnumulation){
%>
							<th class="subHeader">Availability (%)</th>
							<th class="subHeader">Duration (Secs)</th>
<%
			}
			if(enableICAFile){
%>
							<th class="subHeader">Availability (%)</th>
							<th class="subHeader">Duration (Secs)</th>
<%
			}
%>
							<th class="subHeader">Availability (%)</th>
							<th class="subHeader">Duration (Secs)</th>
						</tr>
					</thead>
					<tbody>
<%
			JSONArray componentsList=new JSONArray();
			JSONArray sepRow = new JSONArray();
			Iterator itr = compObj.entrySet().iterator();
			int d_count=1;
			while (itr.hasNext())
			{
				
				Map.Entry mapEntry = (Map.Entry) itr.next();
				String key = (String) mapEntry.getKey();
				componentsList = (JSONArray) mapEntry.getValue();
				String components = key.substring(0, key.indexOf('#'));
				String rowspan = key.substring(key.indexOf('#')+1,key.length());
				String className="alterColor1";
				if(d_count%2==0)
					className="alterColor2";
				else
					className="alterColor1";
				d_count=d_count+1;
%>
						<tr>
							<td class="<%=className%>" rowspan='<%=rowspan%>'> <%=components%></td>
<%
				for(int i=0;i<componentsList.size();i++)
				{
					if(i!=0)
					{
%>
						</tr>
						<tr>
<%
					}
					sepRow = (JSONArray)componentsList.get(i);
					for(int j=0;j<sepRow.size();j++)
					{
						String tdata = (String)sepRow.get(j);
%>
							<td class="<%=className%>"><%=tdata%></td>
<%
					}
				}
			}
%>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
<%
	}
	else if(commonPage !=null && commonPage.equals("yes"))
	{
		String fromAppLaunchIcon = request.getParameter("fromAppLaunchIcon");
		String checkFull = request.getParameter("checkFull");
		String byName = request.getParameter("byName");
		String servlet2 ="";
		resultMap = (Map) session.getAttribute("locationLogon_Details");
		String totalLogon = (String)resultMap.get("totalLogon");
		String successLogon = (String)resultMap.get("successLogon");
		String failLogon = (String)resultMap.get("failLogon");
		String failedEnum ="";
		if(enableEnumulation)
			failedEnum = (String)resultMap.get("failedEnum");
		String failedSimu = (String)resultMap.get("failedSimu");
		String failedApp = (String)resultMap.get("failedApp");
		//
		Double kq = new Double(0);
		kq = (Double.parseDouble((String)resultMap.get("successLogon"))/ Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String succPerc = utils.round(kq, 3);
		kq = (Double.parseDouble((String)resultMap.get("failLogon"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String failPerc = utils.round(kq, 3);
		String failedEnumPerc ="";
		if(enableEnumulation){
			kq = (Double.parseDouble((String)resultMap.get("failedEnum"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
			failedEnumPerc = utils.round(kq, 3);
		}
		kq = (Double.parseDouble((String)resultMap.get("failedSimu"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String failedSimuPerc = utils.round(kq, 3);
		kq = (Double.parseDouble((String)resultMap.get("failedApp"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String failedAppPerc = utils.round(kq, 3);
		//
		resultMap = (Map) session.getAttribute("logon_Details");
		servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey=donutChartforApp&height=150&width=150";
%>
			<div class="printOuterBox">
			<!--<div class="widgetBorder" style="display:inline-block;width:100%;">
			<p class="newFont_bold15" style="margin:20px 10px 10px 10px">Overview of the Simulation - <%=selectedCompnt%> from Simulator Agent - <%=selectedLoc%></p>-->
			<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Overview of Simulations")%><span class="newFont_normal13">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(<%=trackerMappingInfo.getTextDescription("reporter.common.Simulator")%> : <%=selectedCompnt%>, <%=trackerMappingInfo.getTextDescription("reporter.common.External Agent")%> : <%=selectedLoc%>)</span></div>
				<table valign="middle" width="100%">
					<tr>
						<td align="center" >
					<table>
						<tbody>
							<tr>
								<td align="right"><div style="border-right:1px solid #FFFFFF;" class="iconTotalSimulations"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=totalLogon%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Total Simulations")%></td>
							</tr>
						</tbody>
					</table>
				</td>
				<td align="center" >
					<table>
						<tbody>
							<tr>
								<td align="right"><div style="border-right:1px solid #FFFFFF;" class="iconSuccessfulSimulations"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=successLogon%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Successful Simulations")%> </td>
							</tr>
						</tbody>
					</table>
				</td>
				<td align="center" >
					<table>
						<tbody>
							<tr>
								<td align="right"><div style="border-left:1px solid #FFFFFF;" class="iconFailedSimulations"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failedSimu%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Simulations")%> </td>
							</tr>
						</tbody>
					</table>
				</td>
				<td rowspan="2" style="width:25%" valign="top">
					<div>
						<table align="left"><!--align="left"-->
							<tr>
								<td align="left"><!--align="left"-->
<%
				if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
				{
					servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey=donutChartforApp&height=150&width=150";
%>
											<div align="center" style="position:relative; width:160px; height:160px">
												<div><img src="<%= mngrIP + servlet2 %>"  /></div>
<%
													if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
													<div style="border:8px solid #ffffff;width:10px;height:10px;top:50%;position:absolute;left:50%;margin-top: 90px;margin-left: 85px;background-color:#ffffff;">
													</div>
<%
													}
%>
											</div>
<%
				}
				else
				{
					servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey=donutChartforApp&height=150&width=150";
%>
									<div align="center" style="position:relative; width:160px; height:160px">
									<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
<%
										if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
										<div style="border:0px solid red;width:25px;height:25px;top:50%;position:absolute;left:50%;margin-top: -15px;margin-left: -10px;background-color:#ffffff;">
										
										</div>
<%
										}
%>
								</div>
<%
		}
%>
								</td>
								</tr>
							
<%
	int succ_lg = Integer.parseInt(successLogon);
	int fail_lg = Integer.parseInt(failLogon);
	int total_lg = Integer.parseInt(totalLogon);
	int failEnum_lg = 0;
	if(enableEnumulation)
		failEnum_lg = Integer.parseInt(failedEnum);
	int failedSimu_lg = Integer.parseInt(failedSimu);
	int failedApp_lg = Integer.parseInt(failedApp);
	if(total_lg>0)
	{
%>
							<tr>
								<td align="left">
									<table align="left" cellpadding="0" cellspacing="0" border="0" style="padding: 20px 0px 25px 0px;">
										<tbody>
											<tr>
											<td align="left" valign="middle">
<%
		if(succ_lg>0)
		{
%>
												<div style="float:left">
												<table><tr><td valign="top" style="padding:3px"><div style="background-color:#32B395;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div></td><td nowrap style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top"><%=trackerMappingInfo.getTextDescription("reporter.common.Successful Simulations")%> (<%=succPerc%>%)</td></tr></table></div>
<%
		}
		if(fail_lg>0)
		{
%>
												<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#EF7672;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div></td><td nowrap style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Logons")%> (<%=failPerc%>%)</td></tr></table></div>
<%
		}
		if(failEnum_lg>0 && enableEnumulation)
		{
%>
												<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#F8ABA7;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div></td><td nowrap style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Enumerations")%> (<%=failedEnumPerc%>%)</td></tr></table></div>
<%
		}
		if(failedSimu_lg>0)
		{
%>
												<!--  <div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#DE4640;height:<%=legdHeight%>;width:<%=legdWidth%>;">
												</div></td><td nowrap style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">Failure Simulations (<%=failedSimuPerc%>%)</td></tr></table></div>-->
<%
		}
		if(failedApp_lg>0) 
		{
%>
												<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#F7BD42;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div></td><td nowrap style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Applications")%> (<%=failedAppPerc%>%)</td></tr></table></div>
<%
		}
%>
										</td>
										</tr>
										</tbody>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
					</div>
				</td>
			</tr>
			<tr>
				<td align="center">
					<table>
						<tbody>
							<tr>
								<td align="right"><div class="iconLogonFailed"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failLogon%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break: break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Logons")%></td>
							</tr>
						</tbody>
					</table>
				</td>
			<%
				if(enableEnumulation){
			%>
				<td align="center">
					<table>
						<tbody>
							<tr>
								<td align="right"><div class="iconFailedEnumeration"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failedEnum%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Enumerations")%></td>
							</tr>
						</tbody>
					</table>
				</td>
			<%
				}
			%>
				<td align="center">
					<table>
						<tbody>
							<tr>
								<td align="right"><div style="border-left:1px solid #FFFFFF;" class="iconFailedAppLaunch"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failedApp%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Applications")%></td>
							</tr>
						</tbody>
					</table>
				</td>
			</tr>
		</tbody>
	</table>
</div>
<div class="clearDiv">&nbsp;</div>
<%
List totGraphs = new ArrayList();
List foundDataLst = new ArrayList();
//if(!fromAppLaunchIcon.equals("yes"))
System.out.println("checkFull ---------- "+checkFull);
System.out.println("byName ---------- "+byName);
if (checkFull!=null && byName!=null && (checkFull.equals("full")||byName.equals("fromLogon")) || checkFull.equals("fromLogon"))
{
		resultMap = (Map) session.getAttribute("locationResults");
		
		totGraphs.add("appLogonAvail");
		totGraphs.add("appLogonDura");
		totGraphs.add("logonDonutHealth");
		
		for(int i=0;i<totGraphs.size();i++)
		{
			String f_key = (String)totGraphs.get(i);
			JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
			if(foundKeys==null || foundKeys.size()==0)
			{
				foundDataLst.add("dummy");
				continue;
			}
			foundDataLst.add(f_key);
		}
%>
		<div class="printOuterBox">
		<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Logon Details")%></div>
		<!--  <div class="widgetBorder" style="display:inline-block;width:100%;">
		<p class="newFont_bold15" style="margin:20px 10px 10px 10px">Logon Details</p>-->
			<table valign="middle" width="100%">
				<tr class="newimg">
<%
		for(int i=0;i<foundDataLst.size();i++)
		{
			String getKy = (String)foundDataLst.get(i);
			servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
			if(getKy.equalsIgnoreCase("appLogonAvail"))
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
							<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
							</div>
					</td>
<%
			}
			else if (i==0)
			{
%>
				<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
					</td>
<%
			}
			if(getKy.equalsIgnoreCase("appLogonDura"))
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
							<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
							</div>
					</td>
				</tr>
<%
			}
			else if (i==1)
			{
%>
				<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
					</td>
				</tr>
<%
			}
			if(getKy.equalsIgnoreCase("logonDonutHealth"))
			{
				servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=350&width=350";
%>
				<tr>
					<td width="50%" align="center" class="graphSeperatorLineRight">
					<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Logon Health")%>(%)</div>
						<div>
						<table width="100%" ><col width="70%"><col width="30%">
							<tr class="newimg">
								<td align="right">
<%
								if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
								{
%>
									<div align="center" style="position:relative; width:220px; height:220px">
										<div><img src="<%= mngrIP + servlet2 %>" /></div>
<%
										if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
											<div style="border:15px solid #ffffff;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: 160px;margin-left: 150px;background-color:#ffffff;">
											</div>
<% 
											}
%>
									</div>
<%
								}
								else
								{
									servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=200&width=400";
%>
									<div align="center" style="position:relative; width:220px; height:220px">
										<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
<%
											if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
											<div style="border:0px solid green;position:absolute;width:60px;height:60px;top:50%;left:50%;margin-top: -30px;margin-left: -30px;background:#ffffff;">
											</div>
<%
											}
%>
									</div>
<%
								}
%>
								</td>
								<td>
									<table align="center" cellpadding="0" cellspacing="0" border="0">
										<tbody>
<%
						ArrayList lg_legends= (ArrayList)resultMap.get("logonDonutHealthLegends");
						if(lg_legends!=null && lg_legends.size()>0)
						{
							String stageColor = "";
							Iterator data_itr = lg_legends.iterator();
							while (data_itr.hasNext())
							{
								String values = (String) data_itr.next();
								if(values!=null)
								{
									if(values.startsWith("Critical"))
									{
										stageColor = "#CC0000";
									}
									else if(values.startsWith("Major"))
									{
										stageColor = "#FA9D1C";
									}
									else if(values.startsWith("Minor"))
									{
										stageColor = "#CCC100";
									}
									else if(values.startsWith("Normal"))
									{
										stageColor = "#457E08";
									}
									else
									{
										stageColor = "#49909F";  
									}
								}
%>
											<tr>
												<td>
													<div style="background-color:<%=stageColor%>;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
													</div>
												</td>
												<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=values%>
												</td>
											</tr>
<%
							}
						}
%>
										</tbody>
									</table>
								</td>
							</tr>
						</table>
						</div>
					</td>
				</tr>
<%
			}
			else if (i==2)
			{
%>
				<tr>
					<td width="50%" align="center" class="graphSeperatorLineRight">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Logon Health")%>(%)</div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
					</td>
				</tr>
<%
			}

		}
%>
			</table>
		</div>
		<div class="clearDiv">&nbsp;</div>
<%
		}
		if (enableEnumulation && checkFull!=null && byName!=null && (checkFull.equals("full")||byName.equals("fromEnum") || checkFull.equals("fromEnum")))
		{
			/////---Enumeration
			resultMap = (Map) session.getAttribute("locationResults");
			totGraphs = new ArrayList();
			totGraphs.add("appEnumAvail");
			totGraphs.add("appEnumDura");
			totGraphs.add("enumDonutHealth");
			foundDataLst = new ArrayList();
			for(int i=0;i<totGraphs.size();i++)
			{
				String f_key = (String)totGraphs.get(i);
				JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
				if(foundKeys==null || foundKeys.size()==0)
				{
					foundDataLst.add("dummy");
					continue;
				}
				foundDataLst.add(f_key);
			}
%>
<%
		if(frompdf!=null && frompdf.equalsIgnoreCase("no"))
		{
%>
		<div class="printOuterBox newimg">
<%
		}
		else
		{
%>
		<div class="printOuterBox newimg" style="margin-top:10px; !important">
<%
		}
%>
		<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Enumeration Details")%></div>
				<table valign="middle" width="100%">
					<tr class="newimg">
<%
			for(int i=0;i<foundDataLst.size();i++)
			{
				String getKy = (String)foundDataLst.get(i);
				servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
				if(getKy.equalsIgnoreCase("appEnumAvail"))
				{
%>
						<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
							<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
							</div>
						</td>
<%
				}
				else if (i==0)
				{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
<%
				}
				if(getKy.equalsIgnoreCase("appEnumDura"))
				{
%>
						<td width="50%" align="center" class="graphSeperatorLineBottom">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
							<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
							</div>
						</td>
					</tr>
<%
				}
				else if (i==1)
				{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
					</tr>
<%
				}
				if(getKy.equalsIgnoreCase("enumDonutHealth"))
				{
					servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=350&width=350";
%>
					<tr>
						<td width="50%" align="center" class="graphSeperatorLineRight">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Enumeration Health")%>(%)</div>
							<div>
								<table width="100%" ><col width="70%"><col width="30%">
									<tr class="newimg">
										<td align="right">
<%
									if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
									{
%>
											<div align="center" style="position:relative; width:220px; height:220px">
												<div><img src="<%= mngrIP + servlet2 %>" /></div>
												<div style="border:0px solid #FFFFFF;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: 220px;margin-left: 150px;background-color:#ffffff;">
											</div>
										</div>
<%
									}
									else
									{
										servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=200&width=400";
%>
											<div align="center" style="position:relative; width:220px; height:220px">
												<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
<%
													if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
													<div style="border:0px solid green;position:absolute;width:60px;height:60px;top:50%;left:50%;margin-top: -30px;margin-left: -30px;background:#ffffff;">
													</div>
<%
													}
%>
											</div>
<%
									}
%>
										</td>
										<td>
											<table align="center" cellpadding="0" cellspacing="0" border="0">
												<tbody>
<%
							ArrayList lg_legends= (ArrayList)resultMap.get("enumDonutHealthLegends");
							if(lg_legends!=null && lg_legends.size()>0)
							{
								String stageColor = "";
								Iterator data_itr = lg_legends.iterator();
								while (data_itr.hasNext())
								{
									String values = (String) data_itr.next();
									if(values!=null)
									{
										if(values.startsWith("Critical"))
										{
											stageColor = "#CC0000";
										}
										else if(values.startsWith("Major"))
										{
											stageColor = "#FA9D1C";
										}
										else if(values.startsWith("Minor"))
										{
											stageColor = "#CCC100";
										}
										else if(values.startsWith("Normal"))
										{
											stageColor = "#457E08";
										}
										else
										{
											stageColor = "#49909F";  
										}
									}
%>
													<tr>
														<td>
															<div style="background-color:<%=stageColor%>;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;"></div>
														</td>
														<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=values%></td>
													</tr>
<%
								}
							}

%>
												</tbody>
											</table>
										</td>
									</tr>
								</table>
							</div>
						</td>
					</tr>
<%
				}
				else if (i==2)
				{
%>
					<tr>
						<td width="50%" align="center" class="graphSeperatorLineRight">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Enumeration Health")%>(%)</div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
					</tr>
<%
				}
			}
%>
				</table>
		</div>
		<div class="clearDiv">&nbsp;</div>
<%
	}
	if (enableICAFile && checkFull!=null && byName!=null && (checkFull.equals("full")||byName.equals("fromicafile") || checkFull.equals("fromicafile")))
	{
			/////---ICA
			resultMap = (Map) session.getAttribute("locationResults");
			totGraphs = new ArrayList();
			totGraphs.add("ICAFileAvail");
			totGraphs.add("ICAFileDura");
			totGraphs.add("icafileDonutHealth");
			foundDataLst = new ArrayList();
			for(int i=0;i<totGraphs.size();i++)
			{
				String f_key = (String)totGraphs.get(i);
				JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
				if(foundKeys==null || foundKeys.size()==0)
				{
					foundDataLst.add("dummy");
					continue;
				}
				foundDataLst.add(f_key);
			}
%>
<%
		if(frompdf!=null && frompdf.equalsIgnoreCase("no"))
		{
%>
		<div class="printOuterBox newimg">
<%
		}
		else
		{
%>
		<div class="printOuterBox newimg" style="margin-top:10px; !important">
<%
		}
%>
		<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.ICA File Download")%></div>
				<table valign="middle" width="100%">
					<tr class="newimg">
<%
			for(int i=0;i<foundDataLst.size();i++)
			{
				String getKy = (String)foundDataLst.get(i);
				servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
				if(getKy.equalsIgnoreCase("ICAFileAvail"))
				{
%>
						<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
							<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
							</div>
						</td>
<%
				}
				else if (i==0)
				{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
<%
				}
				if(getKy.equalsIgnoreCase("ICAFileDura"))
				{
%>
						<td width="50%" align="center" class="graphSeperatorLineBottom">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
							<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
							</div>
						</td>
					</tr>
<%
				}
				else if (i==1)
				{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
					</tr>
<%
				}
				if(getKy.equalsIgnoreCase("icafileDonutHealth"))
				{
					servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=350&width=350";
%>
					<tr>
						<td width="50%" align="center" class="graphSeperatorLineRight">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.ICA File Download Health")%>(%)</div>
							<div>
								<table width="100%" ><col width="70%"><col width="30%">
									<tr class="newimg">
										<td align="right">
<%
									if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
									{
%>
											<div align="center" style="position:relative; width:220px; height:220px">
												<div><img src="<%= mngrIP + servlet2 %>" /></div>
												<div style="border:0px solid #FFFFFF;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: 220px;margin-left: 150px;background-color:#ffffff;">
											</div>
										</div>
<%
									}
									else
									{
										servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=200&width=400";
%>
											<div align="center" style="position:relative; width:220px; height:220px">
												<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
<%
													if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
													<div style="border:0px solid green;position:absolute;width:60px;height:60px;top:50%;left:50%;margin-top: -30px;margin-left: -30px;background:#ffffff;">
													</div>
<%
													}
%>
											</div>
<%
									}
%>
										</td>
										<td>
											<table align="center" cellpadding="0" cellspacing="0" border="0">
												<tbody>
<%
							ArrayList lg_legends= (ArrayList)resultMap.get("ICAFileDonutHealthLegends");
							if(lg_legends!=null && lg_legends.size()>0)
							{
								String stageColor = "";
								Iterator data_itr = lg_legends.iterator();
								while (data_itr.hasNext())
								{
									String values = (String) data_itr.next();
									if(values!=null)
									{
										if(values.startsWith("Critical"))
										{
											stageColor = "#CC0000";
										}
										else if(values.startsWith("Major"))
										{
											stageColor = "#FA9D1C";
										}
										else if(values.startsWith("Minor"))
										{
											stageColor = "#CCC100";
										}
										else if(values.startsWith("Normal"))
										{
											stageColor = "#457E08";
										}
										else
										{
											stageColor = "#49909F";  
										}
									}
%>
													<tr>
														<td>
															<div style="background-color:<%=stageColor%>;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;"></div>
														</td>
														<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=values%></td>
													</tr>
<%
								}
							}

%>
												</tbody>
											</table>
										</td>
									</tr>
								</table>
							</div>
						</td>
					</tr>
<%
				}
				else if (i==2)
				{
%>
					<tr>
						<td width="50%" align="center" class="graphSeperatorLineRight">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.ICA File Download Health")%>(%)</div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
					</tr>
<%
				}
			}
%>
				</table>
		</div>
		<div class="clearDiv">&nbsp;</div>
<%
	}
	if (checkFull!=null && byName!=null && (checkFull.equals("full")||byName.equals("fromApp") || checkFull.equals("fromApp")))
	{
		////----Application
		resultMap = (Map) session.getAttribute("locationResults");
		totGraphs = new ArrayList();
		totGraphs.add("totalAppAvail");
		totGraphs.add("totalAppDura");
		totGraphs.add("total_appLaunchDonutHealth");
		foundDataLst = new ArrayList();
		for(int i=0;i<totGraphs.size();i++)
		{
			String f_key = (String)totGraphs.get(i);
			JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
			if(foundKeys==null || foundKeys.size()==0)
			{
				foundDataLst.add("dummy");
				continue;
			}
			foundDataLst.add(f_key);
		}
%>
	<div class="printOuterBox">
		<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Application Details")%></div>
	<!--  <div class="widgetBorder" style="display:inline-block;width:100%;">
		<p class="newFont_bold15" style="margin:20px 10px 10px 10px">Application Details</p>-->
			<table border = "0" valign="middle" width="100%">
				<tr class="newimg">
<%
		for(int i=0;i<foundDataLst.size();i++)
		{
			String getKy = (String)foundDataLst.get(i);
			servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
			if(getKy.equals("totalAppAvail"))
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
							<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
							</div>
					</td>
<%
			}
			else if(i==0)
			{
%>
				<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
							<img src='/final/images/Light/nomeasures_custom.png' />
						</div>
					</td>
<%
			}
			if(getKy.equals("totalAppDura"))
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
							<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
							</div>
					</td>
				</tr>
<%
			}
			else if (i==1)
			{
%>
				<td width="50%" align="center" class="graphSeperatorLineBottom">
					<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
						<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
						</div>
				</td>
<%
			}
			if(getKy.equals("total_appLaunchDonutHealth"))
			{
				servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=220&width=400";
%>
				<tr >
					<td width="50%" align="center" class="graphSeperatorLineRight">
					<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Application Health")%>(%)</div>
						<div>
							<table width="100%" ><col width="70%"><col width="30%">
								<tr class="newimg">
									<td align="right">
<%
								if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
								{
%>
										<div align="center" style="position:relative; width:220px; height:220px">
											<div><img src="<%= mngrIP + servlet2 %>" /></div>
<%
										if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
											<div style="border:15px solid blue;position:absolute;width:30px;height:30px;top:50%;left:50%;margin-top:494px;margin-left: 150px;background-color:#ffffff;">
										</div>
<%
										}
%>
									</div>
<%
								}
								else
								{
									servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=200&width=400";
%>
										<div align="center" style="position:relative; width:220px; height:220px">
											<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
<%
												if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
												<div style="border:0px solid green;position:absolute;width:60px;height:60px;top:50%;left:50%;margin-top: -30px;margin-left: -30px;background:#ffffff;">
												</div>
<%
												}
%>
										</div>
<%
								}
%>
									</td>
									<td>
<%
									if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
									{
%>
										<table align="center" cellpadding="0" cellspacing="0" border="0">
<%
									}
									else
									{
%>
										<table align="center" cellpadding="0" cellspacing="0" border="0">
<%
									}
%>
											<tbody>
<%
						ArrayList lg_legends= (ArrayList)resultMap.get("total_appDonutHealthLegends");
						if(lg_legends!=null && lg_legends.size()>0)
						{
							String stageColor = "";
							Iterator data_itr = lg_legends.iterator();
							while (data_itr.hasNext())
							{
								String values = (String) data_itr.next();
								if(values!=null)
								{
									if(values.startsWith("Critical"))
									{
										stageColor = "#CC0000";
									}
									else if(values.startsWith("Major"))
									{
										stageColor = "#FA9D1C";
									}
									else if(values.startsWith("Minor"))
									{
										stageColor = "#CCC100";
									}
									else if(values.startsWith("Normal"))
									{
										stageColor = "#457E08";
									}
									else
									{
										stageColor = "#49909F";  
									}
								}
%>
												<tr>
													<td >
														<div style="background-color:<%=stageColor%>;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;"></div>
													</td>
													<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=values%></td>
												</tr>
<%
							}
						}

%>
											</tbody>
										</table>
									</td>
								</tr>
							</table>
						</div>
					</td>
				</tr>
<%
			}
			else if (i==2)
			{
%>
				<tr class = "newimg">
					<td width="50%" align="center" class="graphSeperatorLineRight">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Application Health")%>(%)</div>
						<div style="width:100%;overflow:auto;padding:70px;height:300px">
							<img src='/final/images/Light/nomeasures_custom.png' />
						</div>
					</td>
				</tr>
<%
			}

		}
	}
%>
			</table>
	</div>
<%
	}
	else if(er_trgttype!=null && er_trgttype.equalsIgnoreCase("locationBased") && printPageIdentify!=null && printPageIdentify.equalsIgnoreCase("locFirstPage"))
	{
		resultMap = (Map) session.getAttribute("logon_Details");
		String totalLogon = (String)resultMap.get("totalLogon");
		String successLogon = (String)resultMap.get("successLogon");
		String failLogon = (String)resultMap.get("failLogon");
		String servlet2 ="";
		//
		Double kq = new Double(0);
		kq = (Double.parseDouble((String)resultMap.get("successLogon"))/ Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String succPerc = utils.round(kq, 3);
		kq = (Double.parseDouble((String)resultMap.get("failLogon"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String failPerc = utils.round(kq, 3);
		//
%>
		<div class="printOuterBox" style="height:160px">
			<!-- <div class="widgetBorder" style="display:inline-block;width:100%;"> -->
			<!--<p class="newFont_bold15" style="margin:20px 10px 10px 10px">Overview of the Simulation - <%=selectedCompnt%> from Simulator Agent - <%=selectedLoc%></p> -->
			<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Overview of Simulations")%><span class="newFont_normal13">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(<%=trackerMappingInfo.getTextDescription("reporter.common.Simulator")%> : <%=selectedCompnt%>, <%=trackerMappingInfo.getTextDescription("reporter.common.External Agent")%> : <%=selectedLoc%>)</span></div>
				<table valign="middle" width="100%" cellpadding="0px" cellspacing="0px">
					<tr>
						<td align="center" width="22%">
							<table cellpadding="0px" cellspacing="0px">
								<tbody>
									<tr> 
										<td><div style="border-right:1px solid #FFFFFF;" class="iconTotalSimulations" /></td>
										<td align="center" style="padding:5px"><span class="newFont_bold28"><%=totalLogon%></span></td>
									</tr>
									<tr>
										<td>&nbsp;</td>
										<td align="center" style="padding:7px"><span class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Total")%></span></td>
									</tr>
								</tbody>
							</table>
						</td>
						<td align="center" width="22%">
							<table>
								<tbody>
									<tr>
										<td><div style="border-right:1px solid #FFFFFF;" class="iconSuccessfulSimulations"/></td>
										<td align="center" style="padding:5px"><span class="newFont_bold28"><%=successLogon%></span></td>
									</tr>
									<tr>
										<td>&nbsp;</td>
										<td align="center" style="padding:7px"><span class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Success")%> </span></td>
									</tr>
								</tbody>
							</table>
						</td>
						<td align="center" width="22%">
							<table>
								<tbody>
									<tr>
										<td><div style="border-left:1px solid #FFFFFF;" class="iconFailedSimulations"/></td>
										<td align="center" style="padding:5px"><span class="newFont_bold28"><%=failLogon%></span></td>
									</tr>
									<tr>
										<td>&nbsp;</td>
										<td align="center" style="padding:7px"><span class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Failure")%></span></td>
									</tr>
								</tbody>
							</table>
						</td>
<%
		resultMap = (Map) session.getAttribute("locationResults");
		String avgLogonAvail = (String)resultMap.get("avgLogonAvail");
		String avgEnumAvail ="";
		if(enableEnumulation)
			avgEnumAvail = (String)resultMap.get("avgEnumAvail");
		String avgAppLaunchAvail = (String)resultMap.get("avgAppLaunchAvail");
		String avgICAFileAvail = (String)resultMap.get("avgICAFileAvail");
		servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey=donutChart&height=150&width=150";
%>
						<td>
							<div>
								<table align="center" width="36%">
									<tr>
										<td> 
<%
				if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
				{
					servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey=donutChart&height=150&width=200";
%>
											<div>
												<div><img src="<%= mngrIP + servlet2 %>"/></div>
<%
													if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
													<div style="border:10px solid #FFFFFF;width:6px;height:6px;top:50%;position:absolute;left:50%;margin-top: 90px;margin-left: 85px;background-color:#ffffff;">
													</div>
<%
													}
%>
											</div>
<%
				}
		else
		{
%>
											<div align="center" style="position:relative; width:100px; height:100px">
												<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
<%
													if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
													<div style="border:0px solid red;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: -15px;margin-left: -15px;background-color:#ffffff;">
														<div class='donutChartMiddle' style="background:#ffffff;">&nbsp;</div>
													</div>
<%
													}
%>
											</div>
<%
		}
%>
										</td>
<%
	int succ_lg = Integer.parseInt(successLogon);
	int fail_lg = Integer.parseInt(failLogon);
	int total_lg = Integer.parseInt(totalLogon);
	if(total_lg>0)
	{
%>
										<td align="left">
											<table align="left" cellpadding="0" cellspacing="0" border="0">
												<tbody>
<%
		if(succ_lg>0)
		{
%>
													<tr> 
														<td><div style="background-color:#33B297;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;"></div></td>
														<td nowrap align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=trackerMappingInfo.getTextDescription("reporter.common.Success")%> (<%=succPerc%>%)</td>
<%
		}
		if(fail_lg>0)
		{
%>
													<tr>
														<td><div style="background-color:#EC7672;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;"></div></td>
														<td nowrap align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=trackerMappingInfo.getTextDescription("reporter.common.Failure")%> (<%=failPerc%>%)</td>
<%
		}
%>

													</tr>
												</tbody>
											</table>
										</td>
<%
	}
%>
									</tr>
								</table>
							</div>
						</td>
					</tr>
				</table>
			</div>
			<div class="clearDiv">&nbsp;</div>

<%
		List totGraphs = new ArrayList();
		totGraphs.add("logonAvaiStBar");
		totGraphs.add("enumAvai_graphMap");
		totGraphs.add("ICAFileAvai_graphMap");
		totGraphs.add("appSuFaAvg");
		List foundDataLst = new ArrayList();
		for(int i=0;i<totGraphs.size();i++)
		{
			String f_key = (String)totGraphs.get(i);
			JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
			if(foundKeys==null || foundKeys.size()==0)
			{
				foundDataLst.add("dummy");
				continue;
			}
			foundDataLst.add(f_key);
		}
%>
			<div class="printOuterBox">
			<!--  <div class="widgetBorder" style="display:inline-block;width:100%;">
			<p class="newFont_bold15" style="margin:20px 10px 10px 10px">Availability</p>-->
			<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
				<table border = "0" align="center" valign="middle" width="100%">
					<tr>
<%

		for(int i=0;i<foundDataLst.size();i++)
		{
			String getKy = (String)foundDataLst.get(i);
			servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=250";
			if(enableEnumulation || enableICAFile)
			{
				if(getKy.equalsIgnoreCase("appSuFaAvg"))
					servlet2+="&width=320";//servlet2+="&width=270";
				else
					servlet2+="&width=270";
			}
			else
			{
				servlet2+="&width=400";
			}
			if(i==0 && getKy.equalsIgnoreCase("logonAvaiStBar")) 
			{
%>
						<td width="33%" align="center" class="lineright">
							<table>
								<tbody>
									<tr>
										<td align="right"><div class="iconWebLogIn"></td>
										<td align="left" style="padding:5px"><span class="newFont_bold28"><%=avgLogonAvail%>%</span></td>
									</tr>
									<tr>
										<!--padding:7px--><td align="center" style="padding:7px 0px 20px 0px" colspan="2"><span class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Web Logon")%></span></td>
									</tr>
								</tbody>
							</table>
							
							<table border = "0" valign="middle" width="100%" align="center">
								<tr>
									<td align="center" class="graphSeperatorLineRight">
									<div style="width:100%;overflow:auto;padding:0px">
										<img src="<%= mngrIP + servlet2 %>"/>
									</div>
									</td>
								</tr>
							</table>
						</td>
<%
			}
			if(enableEnumulation && i==1 && getKy.equalsIgnoreCase("enumAvai_graphMap"))
			{
%>
						<td width="33%" align="center" class="lineright">
							<table>
								<tbody>
									<tr>
										<td align="right"><div class="iconAppEnumeration"></td>
										<td align="left" style="padding:5px"><span class="newFont_bold28"><%=avgEnumAvail%>%</span></td>
									</tr>
									<tr>
										<!--padding:7px--><td align="center" style="padding:7px 0px 20px 0px" colspan="2"><span class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Application/Desktop Enumeration")%></span></td>
									</tr>
								</tbody>
							</table>
							
							<table border = "0" align="left" valign="middle" width="100%" align="center">
								<tr>
									<td align="center" class="graphSeperatorLineRight">
									<div style="width:100%;overflow:auto;padding:0px">
										<img src="<%= mngrIP + servlet2 %>"/>
									</div>
									</td>
								</tr>
							</table>
						</td>
<%
			}
			if(enableICAFile && getKy.equalsIgnoreCase("ICAFileAvai_graphMap"))
			{
				if(enableEnumulation)
				{
%>
					</tr></tr>
<%
				}
%>
				<td width="33%" align="center">
							<table>
								<tbody>
									<tr>
										<td align="right"><div class="iconIcaFileDownload"></td>
										<td align="left" style="padding:5px"><span class="newFont_bold28"><%=avgICAFileAvail%>%</span></td>
									</tr>
									<tr>
										<td align="center" style="padding:7px" colspan="2"><span class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.ICA File Download")%></span></td>
									</tr>
								</tbody>
							</table>
							
							<table border = "0" align="left" valign="middle" width="100%" align="center">
								<tr>
									<td align="center" >
										<div style="width:100%;overflow:auto;padding:0px">
										<img src="<%= mngrIP + servlet2 %>"/>
									</div>
									</td>
								</tr>
							</table>
						</td>
<%
			}
			if(getKy.equalsIgnoreCase("appSuFaAvg"))
			{
%>
						<td width="33%" align="center">
							<table>
								<tbody>
									<tr>
										<td align="right"><div class="iconAppLaunch"></td>
										<td align="left" style="padding:5px"><span class="newFont_bold28"><%=avgAppLaunchAvail%>%</span></td>
									</tr>
									<tr>
										<!--padding:7px--><td align="center" style="padding:7px 0px 20px 0px" colspan="2"><span class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Application/Desktop Launch")%></span></td>
									</tr>
								</tbody>
							</table>
							
							<table border = "0" align="left" valign="middle" width="100%" align="center">
								<tr>
									<td align="center" >
										<div style="width:100%;overflow:auto;padding:0px">
										<img src="<%= mngrIP + servlet2 %>"/>
									</div>
									</td>
								</tr>
							</table>
						</td>
<%
			}
		}
%>
					</tr>
				</table><br/>
			</div>
			<div class="clearDiv">&nbsp;</div>
<%
		List totGraphs_2 = new ArrayList();
		totGraphs_2.add("avgDurationPie");
		totGraphs_2.add("timlinSuccFailAvg");
		totGraphs_2.add("applicationLaunchTime");
		totGraphs_2.add("diffAppDuratn");
		List foundDataLst_2 = new ArrayList();
%>
		<div class="printOuterBox"> 
			<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Performance")%></div>
		<!--<div class="widgetBorder" style="display:inline-block;width:100%;">
				<p class="newFont_bold15" style="margin:20px 10px 10px 10px">Performance</p>-->
				<table border = "0" align="center" valign="middle" width="100%" style="border-collapse:collapse;page-break-inside: auto !important">
					<tr class="newimg">
<%
		for(int i=0;i<totGraphs_2.size();i++)
		{
			String f_key = (String)totGraphs_2.get(i);
			JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
			if(foundKeys==null || foundKeys.size()==0)
			{
				foundDataLst_2.add("nomeasure");
				continue;
			}
			foundDataLst_2.add(f_key);
		}
		for(int i=0;i<=3;i++)
		{
			String getKy = (String)foundDataLst_2.get(i);
			servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
			if(getKy.equalsIgnoreCase("avgDurationPie"))
			{
%>
						<td width="50%" align="center" class="graphSeperatorLineBottomRight">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Response Distribution by Stage")%></div>
								<div style="width:100%;overflow:auto;padding:0px">
									<img src="<%= mngrIP + servlet2 %>"/>
							</div>
						</td>
<%
			}
			else if(i==0 )
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottomRight">
					<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Response Distribution by Stage")%></div>
						<table width="100%" height="100%" style="height:100%;" border="0px" >
							<tr>
								<td align='center' valign='middle' ><div align='center' style="height:285px;"><div style="width:100%;overflow:auto;padding:0px"><img style='margin-top:100px;' src='/final/images/Light/nomeasures_custom.png' /></div></div>
								</td>
							</tr>
						</table>
					</td>
<%
			}
			String logonTitle="Web Logon Duration";
			if(enableEnumulation)
				logonTitle="Web Logon & Enumeration Duration";
			if(getKy.equalsIgnoreCase("timlinSuccFailAvg"))
			{
%>
						<td width="50%" align="center" class="graphSeperatorLineBottom">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common."+logonTitle)%></div>
								<div style="width:100%;overflow:auto;padding:0px">
									<img src="<%= mngrIP + servlet2 %>"/>
							</div>
						</td>
					</tr>
<%
			}
			else if (i==1)
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
					<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Logon & Enumeration Duration")%></div>
						<table width="100%" height="100%" style="height:100%;" border="0px" >
							<tr>
								<td align='center' valign='middle' ><div align='center' style="height:285px;"><div style="width:100%;overflow:auto;padding:0px"><img style='margin-top:100px;' src='/final/images/Light/nomeasures_custom.png' /></div></div>
								</td>
							</tr>
						</table>
					</td>
<%
					
			}
			if(getKy.equalsIgnoreCase("applicationLaunchTime"))
			{
				String appLaunchTimeUrl=mngrIP+"/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=370&width=400";
%>
					<tr class="newimg">
						<td width="50%" align="center" class="graphSeperatorLineRight" style="vertical-align:top;">
							<div class="printOuterBoxHeader" style="padding-top:10px;"><%=trackerMappingInfo.getTextDescription("reporter.common.Application Launch Time")%></div>
								<div style="width:100%;overflow:auto;padding:0px;">
									<img src="<%= appLaunchTimeUrl %>"/>
							</div>
						</td>
<%
			}
			else if(i==2)
			{
%>
					<tr class="newimg">
						<td width="50%" align="center" class="graphSeperatorLineRight" style="padding-top:10px">
						<div class="printOuterBoxHeader" style="padding-top:10px;"><%=trackerMappingInfo.getTextDescription("reporter.common.Application Launch Time")%></div>
							<table width="100%" height="100%" style="height:100%;" border="0px" >
								<tr>
									<td align='center' valign='middle'><div align='center' style="height:285px;"><div style="width:100%;overflow:auto;padding:0px"><img style='margin-top:100px;' src='/final/images/Light/nomeasures_custom.png' /></div></div>
									</td>
								</tr>
							</table>
						</td>
<%
			}
			if(getKy.equalsIgnoreCase("diffAppDuratn"))
			{
%>
						<td width="50%" align="center" class="graphSeperatorLineBottom" >
							<div class="printOuterBoxHeader" style="padding-top:10px;"><%=trackerMappingInfo.getTextDescription("reporter.common.Application Launch Time Analysis")%></div>
								<div style="width:100%;overflow:auto;padding:0px">
									<img src="<%= mngrIP + servlet2 %>"/>
							</div>
						</td>
<%
			}
			else if(i==3)
			{
%>
					<td width="50%" align="center" style="padding-top:10px">
						<div class="printOuterBoxHeader" style="padding-top:10px;"><%=trackerMappingInfo.getTextDescription("reporter.common.Application Launch Time Analysis")%></div>
							<table width="100%" height="100%" style="height:100%;" border="0px" >
								<tr>
									<td align='center' valign='middle' ><div align='center' style="height:285px;"><div style="width:100%;overflow:auto;padding:0px"><img style='margin-top:100px;' src='/final/images/Light/nomeasures_custom.png' /></div></div>
									</td>
								</tr>
							</table>
						</td>
				</tr>
<%
				
			}
		}
	}
	else if(er_trgttype!=null && er_trgttype.equalsIgnoreCase("locationBased") && printPageIdentify!=null && printPageIdentify.equalsIgnoreCase("locSecondPage"))
	{
		String servlet2 ="";
		resultMap = (Map) session.getAttribute("locationLogon_Details");
		String totalLogon = (String)resultMap.get("totalLogon");
		String successLogon = (String)resultMap.get("successLogon");
		String failLogon = (String)resultMap.get("failLogon");
		String avgAppLaunchAvail = (String)resultMap.get("failedApp");
		
		String failedEnum = "";
		if(enableEnumulation)
			failedEnum = (String)resultMap.get("failedEnum");
		Double kq = new Double(0);
		kq = (Double.parseDouble((String)resultMap.get("successLogon"))/ Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String succPerc = utils.round(kq, 2);
		kq = (Double.parseDouble((String)resultMap.get("failLogon"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String failPerc = utils.round(kq, 2);
		//
		kq = (Double.parseDouble((String)resultMap.get("failedApp"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String failedAppPerc = utils.round(kq, 2);

		//
		String failedEnumPerc ="";
		if(enableEnumulation){
			kq = (Double.parseDouble((String)resultMap.get("failedEnum"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
			failedEnumPerc = utils.round(kq, 2);
		}
		//
		resultMap = (Map) session.getAttribute("logon_Details");
		servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey=donutChartforApp&height=150&width=150";
		
%>
			<div class="printOuterBox">
			<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Overview of Simulations")%><span class="newFont_normal13">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(<%=trackerMappingInfo.getTextDescription("reporter.common.Simulator")%> : <%=selectedCompnt%>, <%=trackerMappingInfo.getTextDescription("reporter.common.External Agent")%> : <%=selectedLoc%>)</span></div>
			<!-- <div class="widgetBorder" style="display:inline-block;width:100%;">
			<p class="newFont_bold15" style="margin:20px 10px 10px 10px">Overview of the Simulation - <%=selectedCompnt%> from Simulator Agent - <%=selectedLoc%></p> -->
				<table valign="middle" width="100%">
					<tr>
						<td align="center">
							<table>
								<tbody>
									<tr>
										<td align="right"><div style="border-right:1px solid #FFFFFF;" class="iconTotalSimulations"></div></td>
										<td align="left" style="padding:5px"><span class="newFont_bold28"><%=totalLogon%></span></td>
									</tr>
									<tr>
										<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Total")%><br> <%=trackerMappingInfo.getTextDescription("reporter.common.Simulations")%></td>
									</tr>
								</tbody>
							</table>
						</td>
						<td align="center">
							<table>
								<tbody>
									<tr>
										<td align="right"><div style="border-right:1px solid #FFFFFF;" class="iconSuccessfulSimulations"></div></td>
										<td align="left" style="padding:5px"><span class="newFont_bold28"><%=successLogon%></span></td>
									</tr>
									<tr>
										<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Successful")%><br> <%=trackerMappingInfo.getTextDescription("reporter.common.Simulations")%></td>
									</tr>
								</tbody>
							</table>
						</td>
					<%
						if(enableEnumulation)
						{
					%>
						<td align="center">
							<table>
								<tbody>
									<tr>
										<td align="right"><div class="iconFailedEnumeration"></div></td>
										<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failedEnum%></span></td></tr><tr><td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed")%><br> <%=trackerMappingInfo.getTextDescription("reporter.common.Enumerations")%></td>
									</tr>
								</tbody>
							</table>
						</td>
					<%
						}
					%>
					<%
						if(enableICAFile)
						{
					%>
						<td align="center">
							<table>
								<tbody>
									<tr>
										<td align="right"><div class="iconFailedEnumeration"></div></td>
										<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failedEnum%></span></td></tr><tr><td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed")%><br> <%=trackerMappingInfo.getTextDescription("reporter.common.ICA File Download")%></td>
									</tr>
								</tbody>
							</table>
						</td>
					<%
						}
					%>

						<td align="center">
							<table>
								<tbody>
									<tr>
										<td align="right"><div class="iconLogonFailed"></div></td><td align="left" style="padding:5px"><span class="newFont_bold28"><%=failLogon%></span></td>
									</tr>
									<tr>
										<td align="center" style="padding:7px;word-break: break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed")%> <br><%=trackerMappingInfo.getTextDescription("reporter.common.Logons")%></td>
									</tr>
								</tbody>
							</table>
						</td>
						<!--for Application/Desktop Launch-->
						<td align="center">
							<table>
								<tbody>
									<tr>
										<td align="right"><div class="iconAppLaunch"></td>
										<td align="left" style="padding:5px"><span class="newFont_bold28"><%=avgAppLaunchAvail%></span></td>
									</tr>
									<tr>
										<td align="center" style="padding:7px;word-break: break-word"  colspan="2"><span class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Application/Desktop Launch")%></span></td>
									</tr>
								</tbody>
							</table>
						</td>

						<td>
							<div>
							<table align="left" width="36%"><!--align="center"-->
								<tr>
									<td>
<%
				if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
				{
					servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey=donutChartforApp&height=150&width=150";
%>
											<div align="center" style="position:relative; width:160px; height:160px">
												<div><img src="<%= mngrIP + servlet2 %>"  /></div>
<%
													if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
													<div style="border:8px solid #ffffff;width:10px;height:10px;top:50%;position:absolute;left:50%;margin-top: 90px;margin-left: 85px;background-color:#ffffff;">
													</div>
<%
													}
%>
											</div>
<%
				}
				else
				{
%>
										<div align="center" style="position:relative; width:100px; height:100px">
												<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
<%
													if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
													<div style="border:0px solid red;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: -15px;margin-left: -15px;background-color:#ffffff;">
													</div>
<%
													}
%>
										</div>
<%
				}
%>
									</td>
<%
	int succ_lg = Integer.parseInt(successLogon);
	int fail_lg = Integer.parseInt(failLogon);
	int total_lg = Integer.parseInt(totalLogon);
	int failedapp_lg = Integer.parseInt(avgAppLaunchAvail);
	int failEnum_lg = 0;
	if(enableEnumulation)
		failEnum_lg = Integer.parseInt(failedEnum);
	if(total_lg>0)
	{
%>
									<td align="left">
										<table align="center" cellpadding="0" cellspacing="0" border="0">
											<tbody>
<%
		if(succ_lg>0)
		{
%>
												<tr>
													<td>
														<div style="background-color:#33B297;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
														</div>
													</td>
													<td nowrap align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=trackerMappingInfo.getTextDescription("reporter.common.Successful Simulations")%> (<%=succPerc%>%)
													</td>
												</tr>
<%
		}
		if(enableEnumulation && failEnum_lg>0) 
		{
%>
												<tr>
													<td>
														<div style="background-color:#F8ABA7;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
														</div>
													</td>
													<td nowrap align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Enumerations")%> (<%=failedEnumPerc%>%)
													</td>
												</tr>
<%
		}
		if(fail_lg>0)
		{
%>
												<tr>
													<td>
														<div style="background-color:#EF7773;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
														</div>
													</td>
													<td nowrap align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Logons")%> (<%=failPerc%>%)
													</td>
												</tr>
<%
		}
		if(failedapp_lg>0)
		{
%>
												<tr>
													<td>
														<div style="background-color:#F7BD42;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
														</div>
													</td>
													<td nowrap align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Applications")%> (<%=failedAppPerc%>%)
													</td>
												</tr>
<%
		}
%>
											</tbody>
										</table>
									</td>
<%
	}
%>
								</tr>
							</table>
							</div>
						</td>
					</tr>
				</table>
			</div>
			<div class="clearDiv">&nbsp;</div>
<%
		resultMap = (Map) session.getAttribute("locationResults");
		List totGraphs = new ArrayList();
		totGraphs.add("appLogonAvail");
		totGraphs.add("appLogonDura");
		totGraphs.add("logonDonutHealth");
		List foundDataLst = new ArrayList();
		for(int i=0;i<totGraphs.size();i++)
		{
			String f_key = (String)totGraphs.get(i);
			JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
			if(foundKeys==null || foundKeys.size()==0)
			{
				foundDataLst.add("dummy");
				continue;
			}
			foundDataLst.add(f_key);
		}
%>
		<div class="printOuterBox">
			<div class="printOuterBoxHeader" ><%=trackerMappingInfo.getTextDescription("reporter.common.Logon Details")%></div>
		<!--<div class="widgetBorder" style="display:inline-block;width:100%;">
		<p class="newFont_bold15" style="margin:20px 10px 10px 10px">Logon Details</p>  -->
			<table border = "0" align="center" valign="middle" width="100%">
				<tr>
<%
		for(int i=0;i<foundDataLst.size();i++)
		{
			String getKy = (String)foundDataLst.get(i);
			servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
			if(i==0 && getKy.equalsIgnoreCase("appLogonAvail"))
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
						<div style="width:100%;overflow:auto;padding:0px">
							<img src="<%= mngrIP + servlet2 %>"/>
						</div>
					</td>
<%
			}
			else if (i==0)
			{
%>
				<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
							<img src='/final/images/Light/nomeasures_custom.png' />
						</div>
					</td>
<%
			}
			if(i==1 && getKy.equalsIgnoreCase("appLogonDura"))
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
						<div style="width:100%;overflow:auto;padding:0px">
							<img src="<%= mngrIP + servlet2 %>"/>
						</div>
					</td>
				</tr>
<%
			}
			else if (i==1)
			{
%>
				<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
							<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
					</td>
				</tr>
<%
			}
			if(i==2 && getKy.equalsIgnoreCase("logonDonutHealth"))
			{
				servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=350&width=350";
%>
				<tr>
					<td width="50%" align="center" class="graphSeperatorLineRight">
					<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Logon Health")%>(%)</div>
						<div>
						<table width="100%" ><col width="70%"><col width="30%">
							<tr>
								<td align="right">
<%
								if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
								{
%>
									<div align="center" style="position:relative; width:220px; height:220px">
										<div><img src="<%= mngrIP + servlet2 %>" /></div>
<%
										if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
										<div style="border:15px solid #ffffff;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: 160px;margin-left: 150px;background-color:#ffffff;">
										</div>
<%
										}
%>
									</div>
<%
								}
								else
								{
									servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=200&width=400";
%>
									<div align="center" style="position:relative; width:220px; height:220px">
										<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
<%
											if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
											<div style="border:0px solid green;position:absolute;width:60px;height:60px;top:50%;left:50%;margin-top: -30px;margin-left: -30px;background:#ffffff;">
											</div>
<%
											}
%>
									</div>
<%
								}
%>
								</td>
								<td>
									<table align="left" cellpadding="0" cellspacing="0" border="0">
										<tbody>
<%
						ArrayList lg_legends= (ArrayList)resultMap.get("logonDonutHealthLegends");
						if(lg_legends!=null && lg_legends.size()>0)
						{
							String stageColor = "";
							Iterator data_itr = lg_legends.iterator();
							while (data_itr.hasNext())
							{
								String values = (String) data_itr.next();
								if(values!=null)
								{
									if(values.startsWith("Critical"))
									{
										stageColor = "#CC0000";
									}
									else if(values.startsWith("Major"))
									{
										stageColor = "#FA9D1C";
									}
									else if(values.startsWith("Minor"))
									{
										stageColor = "#CCC100";
									}
									else if(values.startsWith("Normal"))
									{
										stageColor = "#457E08";
									}
									else
									{
										stageColor = "#49909F";  
									}
								}
%>
											<tr>
												<td>
													<div style="background-color:<%=stageColor%>;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
													</div>
												</td>
												<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=values%>
												</td>
											</tr>
<%
							}
						}
%>
										</tbody>
									</table>
								</td>
							</tr>
						</table>
						</div>
					</td>
				</tr>
<%
			}
			else if (i==2)
			{
%>
				<tr>
					<td width="50%" align="center" class="graphSeperatorLineRight">
						<div class="printOuterBoxHeader">Logon Health(%)</div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
							<img src='/final/images/Light/nomeasures_custom.png' />
						</div>
					</td>
				</tr>
<%
			}
		}
%>
			</table>
		</div>
		<div class="clearDiv">&nbsp;</div>
<%
	}
	else if(er_trgttype!=null && er_trgttype.equalsIgnoreCase("locationBased") && printPageIdentify!=null && printPageIdentify.equalsIgnoreCase("locThirdPage"))
	{
		String servlet2 ="";
		resultMap = (Map) session.getAttribute("locationLogon_Details");
		String totalLogon = (String)resultMap.get("totalLogon");
		String successLogon = (String)resultMap.get("successLogon");
		String failLogon = (String)resultMap.get("failLogon");
		String failedEnum = (String)resultMap.get("failedEnum");
		//
		Double kq = new Double(0);
		kq = (Double.parseDouble((String)resultMap.get("successLogon"))/ Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String succPerc = utils.round(kq, 2);
		kq = (Double.parseDouble((String)resultMap.get("failLogon"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String failPerc = utils.round(kq, 2);
		kq = (Double.parseDouble((String)resultMap.get("failedEnum"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String failedEnumPerc = utils.round(kq, 2);
		//
		resultMap = (Map) session.getAttribute("logon_Details");
		servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey=donutChartforApp&height=150&width=150";
		
%>
		<div class="printOuterBox">
			<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Overview of Simulations")%>	<span class="newFont_normal13">	(<%=trackerMappingInfo.getTextDescription("reporter.common.Simulator")%> : <%=selectedCompnt%>, <%=trackerMappingInfo.getTextDescription("reporter.common.External Agent")%> : <%=selectedLoc%>)</span></div>
		<table valign="middle" width="100%">
			<tr>
				<td align="center">
					<table>
						<tbody>
							<tr>
								<td align="right"><div style="border-right:1px solid #FFFFFF;" class="iconTotalSimulations"></div></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=totalLogon%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Total")%><br> <%=trackerMappingInfo.getTextDescription("reporter.common.Simulations")%></td>
							</tr>
						</tbody>
					</table>
				</td>
				<td align="center">
					<table>
						<tbody>
							<tr>
								<td align="right"><div style="border-right:1px solid #FFFFFF;" class="iconSuccessfulSimulations"></div></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=successLogon%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Successful")%><br> <%=trackerMappingInfo.getTextDescription("reporter.common.Simulations")%></td>
							</tr>
						</tbody>
					</table>
				</td>
				<td align="center">
					<table>
						<tbody>
							<tr>
								<td align="right"><div class="iconFailedEnumeration"></div></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failedEnum%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed")%><br> <%=trackerMappingInfo.getTextDescription("reporter.common.Enumerations")%></td>
							</tr>
						</tbody>
					</table>
				</td>
				<td align="center">
					<table>
						<tbody>
							<tr>
								<td align="right"><div class="iconLogonFailed"></div></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failLogon%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break: break-all" colspan="2" class="newFont_normal13"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed")%> <br><%=trackerMappingInfo.getTextDescription("reporter.common.Logons")%></td>
							</tr>
						</tbody>
					</table>
				</td>
				<td>
				<div>
					<table align="left" width="36%"><!--align="center"-->
						<tr>
							<td>
				<%
				if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
				{
					servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey=donutChartforApp&height=150&width=150";
%>
											<div align="center" style="position:relative; width:160px; height:160px">
												<div><img src="<%= mngrIP + servlet2 %>"  /></div>
<%
													if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
													<div style="border:10px solid #ffffff;width:10px;height:10px;top:50%;position:absolute;left:50%;margin-top: 90px;margin-left: 85px;background-color:#ffffff;">
													</div>
<%
													}
%>
											</div>
<%
				}
				else
				{
%>
								<div align="center" style="position:relative; width:110px; height:110px">
									<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
<%
										if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
										<div style="border:0px solid red;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: -15px;margin-left: -15px;background-color:#ffffff;">
										</div>
<%
										}
%>
								</div>
<%
				}
%>
							</td>
<%
	int succ_lg = Integer.parseInt(successLogon);
	int fail_lg = Integer.parseInt(failLogon);
	int total_lg = Integer.parseInt(totalLogon);
	int failEnum_lg = Integer.parseInt(failedEnum);
	if(total_lg>0)
	{
%>
							<td align="left">
								<table align="left" cellpadding="0" cellspacing="0" border="0">
									<tbody>
<%
		if(succ_lg>0)
		{
%>
										<tr>
											<td>
												<div style="background-color:#33B297;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div>
											</td>
											<td nowrap align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=trackerMappingInfo.getTextDescription("reporter.common.Successful Simulations")%> (<%=succPerc%>%)
											</td>
										</tr>
<%
		}
		if(fail_lg>0)
		{
%>
										<tr>
											<td>
												<div style="background-color:#EF7773;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div>
											</td>
											<td nowrap align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Logons")%> (<%=failPerc%>%)
											</td>
										</tr>
<%
		}
		if(failEnum_lg>0)
		{
%>
										<tr>
											<td>
												<div style="background-color:#F8ABA7;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div>
											</td>
											<td nowrap align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Enumerations")%> (<%=failedEnumPerc%>%)
											</td>
										</tr>
<%
		}
%>
										
									</tbody>
								</table>
							</td>
<%
	}
%>
						</tr>
					</table>
				</div>
				</td>
			</tr>
		</table>
	</div>
	<div class="clearDiv">&nbsp;</div>
<%
		resultMap = (Map) session.getAttribute("locationResults");
		List totGraphs = new ArrayList();
		totGraphs.add("appEnumAvail");
		totGraphs.add("appEnumDura");
		totGraphs.add("enumDonutHealth");
		List foundDataLst = new ArrayList();
		for(int i=0;i<totGraphs.size();i++)
		{
			String f_key = (String)totGraphs.get(i);
			JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
			if(foundKeys==null || foundKeys.size()==0)
			{
				foundDataLst.add("dummy");
				continue;
			}
			foundDataLst.add(f_key);
		}
%>
		<div class="printOuterBox">
			<div class="printOuterBoxHeader" ><%=trackerMappingInfo.getTextDescription("reporter.common.Enumeration Details")%></div>
			<table valign ="middle" width="100%">
				<tr>
<%
		for(int i=0;i<foundDataLst.size();i++)
		{
			String getKy = (String)foundDataLst.get(i);
			servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
			if(i==0 && getKy.equalsIgnoreCase("appEnumAvail"))
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
							<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
							</div>
					</td>
<%
			}
			else if (i==0)
			{
%>
				<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
							<img src='/final/images/Light/nomeasures_custom.png' />
						</div>
					</td>
<%
			}
			if(i==1 && getKy.equalsIgnoreCase("appEnumDura"))
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
							<div style="width:100%;overflow:auto;padding:0px">
							<img src="<%= mngrIP + servlet2 %>"/>
						</div>
					</td>
				</tr>
<%
			}
			else if (i==1)
			{
%>
				<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
							<img src='/final/images/Light/nomeasures_custom.png' />
						</div>
					</td>
				</tr>
<%
			}
			if(i==2 && getKy.equalsIgnoreCase("enumDonutHealth")) 
			{
				servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=350&width=350";
%>
				<tr>
					<td width="50%" align="center" class="graphSeperatorLineRight">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Enumeration Health")%>(%)</div>
						<div>
							<table width="100%" ><col width="70%"><col width="30%">
								<tr>
									<td align="right">
		<%
								if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
								{
		%>
										<div align="center" style="position:relative; width:220px; height:220px">
											<div><img src="<%= mngrIP + servlet2 %>" /></div>
<%
												if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
												<div style="border:15px solid	#ffffff;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: 160px;margin-left: 150px;background-color:#ffffff;">
												</div>
<%
												}
%>
									</div>
<%
								}
								else
								{
									servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=200&width=400";
%>
										<div align="center" style="position:relative; width:220px; height:220px">
											<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
<%
												if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
												<div style="border:0px solid green;position:absolute;width:60px;height:60px;top:50%;left:50%;margin-top: -30px;margin-left: -30px;background:#ffffff;">
												</div>
<%
												}
%>
										</div>
<%
								}
%>
									</td>
									<td>
										<table align="left" cellpadding="0" cellspacing="0" border="0">
											<tbody>
<%
						ArrayList lg_legends= (ArrayList)resultMap.get("enumDonutHealthLegends");
						if(lg_legends!=null && lg_legends.size()>0)
						{
							String stageColor = "";
							Iterator data_itr = lg_legends.iterator();
							while (data_itr.hasNext())
							{
								String values = (String) data_itr.next();
								if(values!=null)
								{
									if(values.startsWith("Critical"))
									{
										stageColor = "#CC0000";
									}
									else if(values.startsWith("Major"))
									{
										stageColor = "#FA9D1C";
									}
									else if(values.startsWith("Minor"))
									{
										stageColor = "#CCC100";
									}
									else if(values.startsWith("Normal"))
									{
										stageColor = "#457E08";
									}
									else
									{
										stageColor = "#49909F";  
									}
								}
%>
												<tr>
													<td>
														<div style="background-color:<%=stageColor%>;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;"></div>
													</td>
													<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=values%></td>
												</tr>
<%
							}
						}

%>
											</tbody>
										</table>
									</td>
								</tr>
							</table>
						</div>
					</td>
				</tr>
<%
			}
			else if (i==2)
			{
%>
				<tr>
					<td width="50%" align="center" class="graphSeperatorLineRight">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Enumeration Health")%>(%)</div>
							<div style="width:100%;overflow:auto;padding:70px;height:300px">
							<img src='/final/images/Light/nomeasures_custom.png' />
						</div>
					</td>
				</tr>
<%
			}
		}
%>
			</table>
		</div>
		<div class="clearDiv">&nbsp;</div>
<%
	}
	else if(er_trgttype!=null && er_trgttype.equalsIgnoreCase("applicationBased") && printPageIdentify!=null && printPageIdentify.equalsIgnoreCase("appSecondPage"))
	{
		System.out.println("resultMap -----appSecondPage-------- ");
		resultMap = (Map) session.getAttribute("locationLogon_Details");
		String totalLogon = (String)resultMap.get("totalLogon");
		String successLogon = (String)resultMap.get("successLogon");
		String failLogon = (String)resultMap.get("failLogon");
		String failedEnum = "";
		if(enableEnumulation)
			failedEnum = (String)resultMap.get("failedEnum");
		String failedSimu = (String)resultMap.get("failedSimu");
		String failedApp = (String)resultMap.get("failedApp");
		String servlet2 ="";
		//
		Double kq = new Double(0);
		kq = (Double.parseDouble((String)resultMap.get("successLogon"))/ Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String succPerc = utils.round(kq, 2);
		kq = (Double.parseDouble((String)resultMap.get("failLogon"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String failPerc = utils.round(kq, 2);
		String failedEnumPerc = "";
		if(enableEnumulation){
			kq = (Double.parseDouble((String)resultMap.get("failedEnum"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
			failedEnumPerc = utils.round(kq, 2);
		}
		kq = (Double.parseDouble((String)resultMap.get("failedSimu"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String failedSimuPerc = utils.round(kq, 2);
		kq = (Double.parseDouble((String)resultMap.get("failedApp"))/Double.parseDouble((String)resultMap.get("totalLogon")))*100;
		String failedAppPerc = utils.round(kq, 2);
		//
		System.out.println("resultMap -----1-------- "+resultMap);
		resultMap = (Map) session.getAttribute("logon_Details");
		System.out.println("resultMap ----21-------- "+resultMap);

		JSONObject compObj_summ = new JSONObject();
		Map summaryTableApp=null;
		if(er_trgttype!=null && er_trgttype.equalsIgnoreCase("applicationBased"))
		{
			summaryTableApp = (Map) session.getAttribute("summaryTableApp");
		}
		if(summaryTableApp!=null && summaryTableApp.size()>0)
		{
			Set dataSet = (Set) summaryTableApp.entrySet();
			Iterator data_itr = dataSet.iterator();
			while (data_itr.hasNext())
			{
				Map.Entry mapEntry = (Map.Entry) data_itr.next();
				String key = (String) mapEntry.getKey();
				ArrayList values = (ArrayList) mapEntry.getValue();
				compObj_summ.put(key,values);
			}
		}
		
%>
		<div class="printOuterBox">
			<div class="printOuterBoxHeader" ><%=trackerMappingInfo.getTextDescription("reporter.common.Simulation for Application")%> - <%=selectedApp%></div>
	<!--<div class="widgetBorder" style="display:inline-block;width:100%;">
		<p class="newFont_bold15" style="margin:20px 10px 10px 10px">Simulation for the Application - <%=selectedApp%></p>-->
		<table valign="middle" width="100%">
			<tr>
<%
	String fromLoc = request.getParameter("fromLoc");
	if (fromLoc!=null && fromLoc.equals("yes"))
	{
%>
				<td align="center" >
					<table>
						<tbody>
							<tr>
								<td align="right"><div style="border-right:1px solid #FFFFFF;" class="iconTotalSimulations"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=totalLogon%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13">Total<br> Simulations</td>
							</tr>
						</tbody>
					</table>
				</td>
				<td align="center" >
					<table>
						<tbody>
							<tr>
								<td align="right"><div style="border-right:1px solid #FFFFFF;" class="iconSuccessfulSimulations"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=successLogon%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13">Successful<br> Simulations</td>
							</tr>
						</tbody>
					</table>
				</td>
				<td align="center" >
					<table>
						<tbody>
							<tr>
								<td align="right"><div style="border-right:1px solid #FFFFFF;" class="iconFailedSimulations"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failedSimu%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13">Failed<br> Simulations</td>
							</tr>
						</tbody>
					</table>
				</td>
				<td rowspan="2" style="width:35%" valign="top">
					<div>
						<table align="left"><!--align="center"-->
							<tr>
								<td align="left"><!--align="center"-->
<%
				if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
				{
					servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey=donutChartforApp&height=150&width=150";
%>
											<div align="center" style="position:relative; width:160px; height:160px">
												<div><img src="<%= mngrIP + servlet2 %>"  /></div>
<%
					if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false")))
					{
%>
												<div style="border:8px solid #ffffff;width:10px;height:10px;top:50%;position:absolute;left:50%;margin-top: 90px;margin-left: 85px;background-color:#ffffff;">
												</div>
<%
					}
%>
											</div>
		<%
				}
		else
		{
			servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey=donutChartforApp&height=150&width=150";
%>
									<div align="center" style="position:relative; width:160px; height:160px">
									<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
<%
										if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
%>
										<div style="border:0px solid red;width:25px;height:25px;top:50%;position:absolute;left:50%;margin-top: -15px;margin-left: -10px;background-color:#ffffff;">
										
										</div>
<%
										}
%>
								</div>
<%
		}
%>
								</td>
								</tr>
<%
	int succ_lg = Integer.parseInt(successLogon);
	int fail_lg = Integer.parseInt(failLogon);
	int total_lg = Integer.parseInt(totalLogon);
	int failEnum_lg = 0;
	if(enableEnumulation)
		failEnum_lg = Integer.parseInt(failedEnum);
	int failedSimu_lg = Integer.parseInt(failedSimu);
	int failedApp_lg = Integer.parseInt(failedApp);
	if(total_lg>0)
	{
%>							<tr>
								<td align="left">
									<table align="left" cellpadding="0" cellspacing="0" border="0" style="padding: 20px 0px 25px 0px;">
										<tbody>
											<tr>
											<td align="left" valign="middle">
<%
		if(succ_lg>0)
		{
%>
												<div style="float:left">
												<table><tr><td valign="top" style="padding:3px"><div style="background-color:#32B395;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div></td><td nowrap style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">Successful Simulations (<%=succPerc%>%) </td></tr></table></div>
<%
		}
		if(fail_lg>0)
		{
%>
												<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#EF7672;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div></td><td nowrap style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">Failed Logons (<%=failPerc%>%)</td></tr></table></div>
<%
		}
		if(failEnum_lg>0 && enableEnumulation)
		{
%>
												<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#F8ABA7;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div></td><td nowrap style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">Failed Enumerations (<%=failedEnumPerc%>%)</td></tr></table></div>
<%
		}
		if(failedSimu_lg>0)
		{
%>
												<!-- <div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#DE4640;height:<%=legdHeight%>;width:<%=legdWidth%>;">
												</div></td><td nowrap style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">Failure Simulations (<%=failedSimuPerc%>%)</td></tr></table></div>-->
<%
		}
		if(failedApp_lg>0) 
		{
%>
												<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#F7BD42;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div></td><td nowrap style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">Failed Applications (<%=failedAppPerc%>%)</td></tr></table></div>
<%
		}
%>
										</td>
										</tr>
										</tbody>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
					</div>
				</td>
			</tr>
			<tr>
				<td align="center" >
					<table>
						<tbody>
							<tr>
								<td align="right"><div class="iconLogonFailed"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failLogon%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break: break-all" colspan="2" class="newFont_normal13">Failed <br>Logons</td>
							</tr>
						</tbody>
					</table>
				</td>
				<td align="center" >
					<table>
						<tbody>
							<tr>
								<td align="right"><div class="iconFailedEnumeration"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failedEnum%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13">Failed<br> Enumerations</td>
							</tr>
						</tbody>
					</table>
				</td>
				<td align="center" >
					<table cellpadding="0px" cellspacing="0px">
						<tbody>
							<tr>
								<td align="right"><div style="border-left:1px solid #FFFFFF;" class="iconFailedAppLaunch"></td>
								<td align="left" style="padding:5px"><span class="newFont_bold28"><%=failedApp%></span></td>
							</tr>
							<tr>
								<td align="center" style="padding:7px;word-break:break-all" colspan="2" class="newFont_normal13">Failed<br> Applications</td>
							</tr>
						</tbody>
					</table>
				</td>
			</tr>
		</table>
	</div>
			<div class="clearDiv">&nbsp;</div>
<%
//
		resultMap = (Map) session.getAttribute("locationResults");
		List totGraphs = new ArrayList();
		totGraphs.add("appLaunchAvailLocation");
		totGraphs.add("appLaunchDurationLocation");
		totGraphs.add("appLaunchDonutHealth");
		List foundDataLst = new ArrayList();
%>
		<div class="printOuterBox">
				<div class="printOuterBoxHeader" >Application Details</div>
			<table valign="middle" width="100%" style="border-collapse:collapse;">
				<tr class="newimg">
<%
		for(int i=0;i<totGraphs.size();i++)
		{
			String f_key = (String)totGraphs.get(i);
			JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
			if(foundKeys==null || foundKeys.size()==0)
			{
				foundDataLst.add("dummy");
				continue;
			}
			foundDataLst.add(f_key);
		}
		for(int i=0;i<foundDataLst.size();i++)
		{
			String getKy = (String)foundDataLst.get(i);
			servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
			if( getKy.equals("appLaunchAvailLocation"))
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottomRight">
						<p class="newFont_bold13">Availability</p>
							<img src="<%= mngrIP + servlet2 %>"/>
					</td>
<%
			}
			else if(i==0 )
			{
%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
					<p class="newFont_bold13">Availability</p>
						<table width="100%" height="100%" style="height:100%;" border="0px" >
							<tr>
								<td align='center' valign='middle' ><div align='center' style="height:285px;"><img style='margin-top:100px;' src='/final/images/Light/nomeasures_custom.png' /></div>
								</td>
							</tr>
						</table>
				</td>
<%
			}
			if(getKy.equals("appLaunchDurationLocation"))
			{
%>
				<td width="50%" align="center" class="graphSeperatorLineBottom">
					<p class="newFont_bold13">Duration</p>
						<img src="<%= mngrIP + servlet2 %>"/>
				</td>
			</tr>
<%
			}
			else if (i==1 )
			{
%>
				<td width="50%" align="center" class="graphSeperatorLineBottom">
					<p class="newFont_bold13">Duration</p>
						<table width="100%" height="100%" style="height:100%;" border="0px" >
							<tr>
								<td align='center' valign='middle' ><div align='center' style="height:285px;"><img style='margin-top:100px;' src='/final/images/Light/nomeasures_custom.png' /></div>
								</td>
							</tr>
						</table>
				</td>
<%
				
			}
			if(getKy.equals("appLaunchDonutHealth"))
			{
				servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=200&width=400";
%>
			<tr>
				<td width="50%" align="center" class="graphSeperatorLineRight">
					<p class="newFont_bold13">Application Health(%)</p>
					<div>
					<table width="100%" ><col width="70%"><col width="30%">
						<tr>
							<td align="right">
								<%
								if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
								{
%>
									<div align="center" style="position:relative; width:220px; height:220px">
											<div><img src="<%= mngrIP + servlet2 %>" /></div>
									<%
										if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
									%>
											<div style="border:15px solid #ffffff;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: 160px;margin-left: 150px;background-color:#ffffff;">
										</div>
									<%
										}
									%>
									</div>
<%
								}
								else
								{
%>
									<div align="center" style="position:relative; width:220px; height:220px">
										<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
									<%
										if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
									%>
										<div style="border:0px solid green;position:absolute;width:60px;height:60px;top:50%;left:50%;margin-top: -30px;margin-left: -30px;background:#ffffff;">
										</div>
									<%
										}
									%>
									</div>
<%
								}
%>
							</td>
							<td>
								<table align="left" cellpadding="0" cellspacing="0" border="0">
									<tbody>
<%
						ArrayList lg_legends= (ArrayList)resultMap.get("appDonutHealthLegends");
						if(lg_legends!=null && lg_legends.size()>0)
						{
							String stageColor = "";
							Iterator data_itr = lg_legends.iterator();
							while (data_itr.hasNext())
							{
								String values = (String) data_itr.next();
								if(values!=null)
								{
									if(values.startsWith("Critical"))
									{
										stageColor = "#CC0000";
									}
									else if(values.startsWith("Major"))
									{
										stageColor = "#FA9D1C";
									}
									else if(values.startsWith("Minor"))
									{
										stageColor = "#CCC100";
									}
									else if(values.startsWith("Normal"))
									{
										stageColor = "#457E08";
									}
									else
									{
										stageColor = "#49909F";  
									}
								}
%>
										<tr>
											<td>
												<div style="background-color:<%=stageColor%>;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
												</div>
											</td>
											<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=values%></td>
										</tr>
<%
							}
						}
%>
									</tbody>
								</table>
							</td>
						</tr>
					</table>
					</div>
				</td>
			</tr>
<%
			}
			else if (i==2)
			{
%>
				<tr>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
					<p class="newFont_bold13">Application Health(%)</p>
						<table width="100%" height="100%" style="height:100%;" border="0px" >
							<tr>
								<td align='center' valign='middle' ><div align='center' style="height:285px;"><img style='margin-top:100px;' src='/final/images/Light/nomeasures_custom.png' /></div>
								</td>
							</tr>
						</table>
				</td>
				</tr>
<%
			}
		}
//
	}
	else
	{
%>
			<tr>
				<td style="width:100%;padding:10px">
					<div class="plainTableReporter">
						<table align="center" valign="middle" width="100%" cellpadding="0" cellspacing="0" style="border-collapse:collapse">
							<thead>
								<tr>
									<th rowspan="2"><%=trackerMappingInfo.getTextDescription("reporter.common.External Agent")%></th>
									<th colspan="3" style="text-align:center"><%=trackerMappingInfo.getTextDescription("reporter.common.Simulation")%></th>
									<th style="text-align:center;" rowspan="2"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Logons")%></th>
							<%
								if(enableEnumulation){
							%>
									<th style="text-align:center;" rowspan="2"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed Enumerations")%></th>
							<%
								}
							
								if(enableICAFile){
							%>		<th style="text-align:center;" rowspan="2"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed ICA File Download")%>
							<%
								}
							%>
							</th>
									<th style="text-align:center;" rowspan="2"><%=trackerMappingInfo.getTextDescription("reporter.common.Failed application/Desktop Launches")%></th>
								</tr>
								<tr>
									<th colspan="1" class="subHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Total")%></th>
									<th colspan="1" class="subHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Successful")%></th>
									<th colspan="1" class="subHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Failure")%></th>
								</tr>
							</thead> 
							<tbody>
<%
			JSONArray locList=new JSONArray();
			Iterator itr = compObj_summ.entrySet().iterator();
			while (itr.hasNext())
			{
				Map.Entry mapEntry = (Map.Entry) itr.next();
				String key = (String) mapEntry.getKey();
				locList = (JSONArray) mapEntry.getValue();
%>
								<tr>
									<td><%=key%>
									</td>
<%
				for(int k=0;k<locList.size();k++)
				{
%>
									<td style="text-align:center"><%=locList.get(k)%>
									</td>
<%
				}
%>
								</tr>
<%
			}
%>
							</tbody>
						</table>
					</div>
				</td>
			</tr>
<%
	}
	
%>
			</tr>
		</table>
	</div>
	<div class="clearDiv">&nbsp;</div>
<%
		if (fromLoc!=null && !fromLoc.equals("yes"))
		{
			resultMap = (Map) session.getAttribute("locationResults");
			List totGraphs = new ArrayList();
			totGraphs.add("appLogonAvail");
			totGraphs.add("appLogonDura");
			List foundDataLst = new ArrayList();
	%>
			<div class="printOuterBox">
				<div class="printOuterBoxHeader" ><%=trackerMappingInfo.getTextDescription("reporter.common.Logon Details")%></div>
			<table valign="middle" width="100%" style="border-collapse:collapse;">
				<tr class="newimg">
	<%
			for(int i=0;i<totGraphs.size();i++)
			{
				String f_key = (String)totGraphs.get(i);
				JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
				if(foundKeys==null || foundKeys.size()==0)
				{
					foundDataLst.add("dummy");
					continue;
				}
				foundDataLst.add(f_key);
			}
			for(int i=0;i<foundDataLst.size();i++)
			{
				String getKy = (String)foundDataLst.get(i);
				servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
				if( getKy.equalsIgnoreCase("appLogonAvail"))
				{
	%>
						<td width="50%" align="center" class="graphSeperatorLineBottomRight">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
								<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
						</td>
	<%
				}
				else if (i==0)
				{
	%>
					<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
								<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
	<%
				}
				if(getKy.equalsIgnoreCase("appLogonDura"))
				{
	%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
								<div style="width:100%;overflow:auto;padding:0px">
							<img src="<%= mngrIP + servlet2 %>"/>
					</td>
	<%
				}
				else if (i==1 )
				{
	%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
								<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
	<%
					
				}
			}
	%>
				</tr>
			</table>
		</div>
		<div class="clearDiv">&nbsp;</div>
	<%
		if(enableEnumulation)
		{
	%>
			<div class="printOuterBox">
			<div class="printOuterBoxHeader" ><%=trackerMappingInfo.getTextDescription("reporter.common.Enumeration Details")%></div>
				<table valign="middle" width="100%" style="border-collapse:collapse;">
					<tr class="newimg">
	<%
			totGraphs = new ArrayList();
			totGraphs.add("appEnumAvail");
			totGraphs.add("appEnumDura");
			foundDataLst = new ArrayList();
			for(int i=0;i<totGraphs.size();i++)
			{
				String f_key = (String)totGraphs.get(i);
				JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
				if(foundKeys==null || foundKeys.size()==0)
				{
					foundDataLst.add("dummy");
					continue;
				}
				foundDataLst.add(f_key);
			}
			for(int i=0;i<foundDataLst.size();i++)
			{
				String getKy = (String)foundDataLst.get(i);
				servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
				if( getKy.equalsIgnoreCase("appEnumAvail"))
				{
	%>
						<td width="50%" align="center" class="graphSeperatorLineBottomRight">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
								<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
						</td>
	<%
				}
				else if (i==0)
				{
	%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
								<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
	<%
					
				} 
				if( getKy.equalsIgnoreCase("appEnumDura"))
				{
	%>
						<td width="50%" align="center" class="graphSeperatorLineBottom">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
								<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
						</td>
	<%
				}
				else if (i==1)
				{
	%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
								<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
	<%
					
				}
			}
	%>
					</tr>
				</table>
			</div>
		<div class="clearDiv">&nbsp;</div>
	<%
			}
			if(enableICAFile)
			{
	%>
			<div class="printOuterBox">
			<div class="printOuterBoxHeader" ><%=trackerMappingInfo.getTextDescription("reporter.common.ICA File Download")%></div>
				<table valign="middle" width="100%" style="border-collapse:collapse;">
					<tr class="newimg">
	<%
			totGraphs = new ArrayList();
			totGraphs.add("ICAFileAvail");
			totGraphs.add("ICAFileDura");
			foundDataLst = new ArrayList();
			for(int i=0;i<totGraphs.size();i++)
			{
				String f_key = (String)totGraphs.get(i);
				JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
				if(foundKeys==null || foundKeys.size()==0)
				{
					foundDataLst.add("dummy");
					continue;
				}
				foundDataLst.add(f_key);
			}
			for(int i=0;i<foundDataLst.size();i++)
			{
				String getKy = (String)foundDataLst.get(i);
				servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
				if( getKy.equalsIgnoreCase("ICAFileAvail"))
				{
	%>
						<td width="50%" align="center" class="graphSeperatorLineBottomRight">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
								<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
						</td>
	<%
				}
				else if (i==0)
				{
	%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
								<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
	<%
					
				} 
				if( getKy.equalsIgnoreCase("ICAFileDura"))
				{
	%>
						<td width="50%" align="center" class="graphSeperatorLineBottom">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
								<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
						</td>
	<%
				}
				else if (i==1)
				{
	%>
					<td width="50%" align="center" class="graphSeperatorLineBottom">
						<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
								<div style="width:100%;overflow:auto;padding:70px;height:300px">
								<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
	<%
					
				}
			}
	%>
					</tr>
				</table>
			</div>
		<div class="clearDiv">&nbsp;</div>
	<%
			}
			if(frompdf!=null && frompdf.equalsIgnoreCase("no"))
			{
	%>
			<div class="printOuterBox newimg">
	<%
			}
			else
			{
	%>
			<div class="printOuterBox newimg" style="margin-top:10px; !important">
	<%
			}
	%>
			<div class="printOuterBoxHeader" ><%=trackerMappingInfo.getTextDescription("reporter.common.Application Launch Details")%></div>
				<table valign="middle" width="100%" style="border-collapse:collapse;">
					<tr class="newimg">
	<%
				totGraphs = new ArrayList();
				totGraphs.add("appLaunchAvailLocation");
				totGraphs.add("appLaunchDurationLocation");
				foundDataLst = new ArrayList();
				for(int i=0;i<totGraphs.size();i++)
				{
					String f_key = (String)totGraphs.get(i);
					JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
					if(foundKeys==null || foundKeys.size()==0)
					{
						foundDataLst.add("dummy");
						continue;
					}
					foundDataLst.add(f_key);
				}
				for(int i=0;i<foundDataLst.size();i++)
				{
					String getKy = (String)foundDataLst.get(i);
					servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
					if( getKy.equalsIgnoreCase("appLaunchAvailLocation"))
					{
	%>
							<td width="50%" align="center" class="graphSeperatorLineBottomRight">
								<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
									<div style="width:100%;overflow:auto;padding:0px">
									<img src="<%= mngrIP + servlet2 %>"/>
							</td>
	<%
					}
					else if (i==0)
					{
	%>
						<td width="50%" align="center" class="graphSeperatorLineBottomRight" >
								<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Availability")%></div>
									<div style="width:100%;overflow:auto;padding:70px;height:300px">
									<img src='/final/images/Light/nomeasures_custom.png' />
								</div>
							</td>
	<%
					}
					if(getKy.equalsIgnoreCase("appLaunchDurationLocation"))
					{
	%>
						<td width="50%" align="center" class="graphSeperatorLineBottom">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
									<div style="width:100%;overflow:auto;padding:0px">
								<img src="<%= mngrIP + servlet2 %>"/>
						</td>
	<%
					}
					else if (i==1)
					{
	%>
						<td width="50%" align="center" class="graphSeperatorLineBottom">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Duration")%></div>
								<div style="width:100%;overflow:auto;padding:70px;height:300px">
									<img src='/final/images/Light/nomeasures_custom.png' />
							</div>
						</td>
	<%
					}
				}
	%>
				</tr>
				</table>
			</div>
		<div class="clearDiv">&nbsp;</div>
			<div class="printOuterBox">
			<div class="printOuterBoxHeader" ><%=trackerMappingInfo.getTextDescription("reporter.common.Health")%> (%)</div>
				<table valign="middle" width="100%" style="border-collapse:collapse;">
					<tr>
	<%
				totGraphs = new ArrayList();
				totGraphs.add("logonDonutHealth");
				totGraphs.add("enumDonutHealth");
				totGraphs.add("icafileDonutHealth");
				totGraphs.add("appLaunchDonutHealth");
				foundDataLst = new ArrayList();
				for(int i=0;i<totGraphs.size();i++)
				{
					String f_key = (String)totGraphs.get(i);
					JSONObject foundKeys =(JSONObject)sessionValues.get(f_key);
					if(foundKeys==null || foundKeys.size()==0)
					{
						foundDataLst.add("dummy");
						continue;
					}
					foundDataLst.add(f_key);
				}
				for(int i=0;i<foundDataLst.size();i++)
				{
					String getKy = (String)foundDataLst.get(i);
					servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=300&width=400";
					if(getKy.equalsIgnoreCase("logonDonutHealth"))
					{
						servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=200&width=400";
		%>
					<tr>
						<td width="50%" align="center" class="graphSeperatorLineBottomRight">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Logon")%></div>
							<div>
							<table width="100%" ><col width="70%"><col width="30%">
								<tr class="newimg">
									<td align="right">
		<%
										if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
										{
											servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=350&width=400";
		%>
											<div align="center" style="position:relative; width:220px; height:220px">
													<div><img src="<%= mngrIP + servlet2 %>" /></div>
		<%
												if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
		%>
													<div style="border:15px solid #ffffff;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: 160px;margin-left: 150px;background-color:#ffffff;">
												</div>
		<%
												}
		%>
											</div>
		<%
										}
										else
										{
		%>
											<div align="center" style="position:relative; width:220px; height:220px">
												<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
		<%
												if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
		%>
												<div style="border:0px solid green;position:absolute;width:60px;height:60px;top:50%;left:50%;margin-top: -30px;margin-left: -30px;background:#ffffff;">
												</div>
		<%
												}
		%>
											</div>
		<%
										}
		%>
									</td>
									<td>
										<table align="left" cellpadding="0" cellspacing="0" border="0">
											<tbody>
		<%
								ArrayList lg_legends= (ArrayList)resultMap.get("logonDonutHealthLegends");
								if(lg_legends!=null && lg_legends.size()>0)
								{
									String stageColor = "";
									Iterator data_itr = lg_legends.iterator();
									while (data_itr.hasNext())
									{
										String values = (String) data_itr.next();
										if(values!=null)
										{
											if(values.startsWith("Critical"))
											{
												stageColor = "#CC0000";
											}
											else if(values.startsWith("Major"))
											{
												stageColor = "#FA9D1C";
											}
											else if(values.startsWith("Minor"))
											{
												stageColor = "#CCC100";
											}
											else if(values.startsWith("Normal"))
											{
												stageColor = "#457E08";
											}
											else
											{
												stageColor = "#49909F";  
											}
										}
		%>
												<tr>
													<td>
														<div style="background-color:<%=stageColor%>;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
														</div>
													</td>
													<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=values%></td>
												</tr>
		<%
									}
								}
		%>
											</tbody>
										</table>
									</td>
								</tr>
							</table>
							</div>
						</td>
					
		<%
					}
					else if (i==0)
					{
		%>
						<tr>
							<td width="50%" align="center" class="graphSeperatorLineBottomRight">
								<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Logon")%></div>
									<div style="width:100%;overflow:auto;padding:70px;height:200px">
									<img src='/final/images/Light/nomeasures_custom.png' />
								</div>
							</td>
						
		<%
					}
					if(getKy.equalsIgnoreCase("enumDonutHealth") && enableEnumulation)
					{
						servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=200&width=400";
		%>
					
						<td width="50%" align="center" class="graphSeperatorLineBottom">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Enumeration")%></div>
							<div>
							<table width="100%" ><col width="70%"><col width="30%">
								<tr class="newimg">
									<td align="right">
		<%
										if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
										{
											servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=350&width=400";
		%>
											<div align="center" style="position:relative; width:220px; height:220px">
													<div><img src="<%= mngrIP + servlet2 %>" /></div>
		<%
												if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
		%>
													<div style="border:15px solid #ffffff;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: 160px;margin-left: 150px;background-color:#ffffff;">
												</div>
		<%
												}
		%>
											</div>
		<%
										}
										else
										{
		%>
											<div align="center" style="position:relative; width:220px; height:220px">
												<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
		<%
												if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
		%>
												<div style="border:0px solid green;position:absolute;width:60px;height:60px;top:50%;left:50%;margin-top: -30px;margin-left: -30px;background:#ffffff;">
												</div>
		<%
												}
		%>
											</div>
		<%
										}
		%>
									</td>
									<td>
										<table align="left" cellpadding="0" cellspacing="0" border="0">
											<tbody>
		<%
								ArrayList lg_legends= (ArrayList)resultMap.get("enumDonutHealthLegends");
								if(lg_legends!=null && lg_legends.size()>0)
								{
									String stageColor = "";
									Iterator data_itr = lg_legends.iterator();
									while (data_itr.hasNext())
									{
										String values = (String) data_itr.next();
										if(values!=null)
										{
											if(values.startsWith("Critical"))
											{
												stageColor = "#CC0000";
											}
											else if(values.startsWith("Major"))
											{
												stageColor = "#FA9D1C";
											}
											else if(values.startsWith("Minor"))
											{
												stageColor = "#CCC100";
											}
											else if(values.startsWith("Normal"))
											{
												stageColor = "#457E08";
											}
											else
											{
												stageColor = "#49909F";  
											}
										}
		%>
												<tr>
													<td>
														<div style="background-color:<%=stageColor%>;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
														</div>
													</td>
													<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=values%></td>
												</tr>
		<%
									}
								}
		%>
											</tbody>
										</table>
									</td>
								</tr>
							</table>
							</div>
						</td>
					</tr>
		<%
					}
					else if (i==1 && enableEnumulation)
					{
		%>
							<td width="50%" align="center" class="graphSeperatorLineBottom">
								<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Enumeration")%></div>
									<div style="width:100%;overflow:auto;padding:70px;height:200px">
									<img src='/final/images/Light/nomeasures_custom.png' />
								</div>
							</td>
						</tr>
		<%
					}
					if(getKy.equalsIgnoreCase("icafileDonutHealth") && enableICAFile)
					{
						servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=200&width=400";
						String tdCls="graphSeperatorLineBottom";
						if(enableEnumulation){
							tdCls="graphSeperatorLineRight";
		%>
					<tr>
		<%
					}
		%>
						<td width="50%" align="center" class="<%=tdCls%>">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common. ICA File Download")%></div>
							<div>
							<table width="100%" ><col width="70%"><col width="30%">
								<tr class="newimg">
									<td align="right">
		<%
										if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
										{
											servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=350&width=400";
		%>
											<div align="center" style="position:relative; width:220px; height:220px">
													<div><img src="<%= mngrIP + servlet2 %>" /></div>
		<%
												if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
		%>
													<div style="border:15px solid #ffffff;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: 160px;margin-left: 150px;background-color:#ffffff;">
												</div>
		<%
												}
		%>
											</div>
		<%
										}
										else
										{
		%>
											<div align="center" style="position:relative; width:220px; height:220px">
												<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
		<%
												if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
		%>
												<div style="border:0px solid green;position:absolute;width:60px;height:60px;top:50%;left:50%;margin-top: -30px;margin-left: -30px;background:#ffffff;">
												</div>
		<%
												}
		%>
											</div>
		<%
										}
		%>
									</td>
									<td>
										<table align="left" cellpadding="0" cellspacing="0" border="0">
											<tbody>
		<%
								ArrayList lg_legends= (ArrayList)resultMap.get("ICAFileDonutHealthLegends");
								if(lg_legends!=null && lg_legends.size()>0)
								{
									String stageColor = "";
									Iterator data_itr = lg_legends.iterator();
									while (data_itr.hasNext())
									{
										String values = (String) data_itr.next();
										if(values!=null)
										{
											if(values.startsWith("Critical"))
											{
												stageColor = "#CC0000";
											}
											else if(values.startsWith("Major"))
											{
												stageColor = "#FA9D1C";
											}
											else if(values.startsWith("Minor"))
											{
												stageColor = "#CCC100";
											}
											else if(values.startsWith("Normal"))
											{
												stageColor = "#457E08";
											}
											else
											{
												stageColor = "#49909F";  
											}
										}
		%>
												<tr>
													<td>
														<div style="background-color:<%=stageColor%>;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
														</div>
													</td>
													<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=values%></td>
												</tr>
		<%
									}
								}
		%>
											</tbody>
										</table>
									</td>
								</tr>
							</table>
							</div>
						</td>
		<%
					}
					else if (i==2 && enableICAFile)
					{
		%>
						<tr>
							<td width="50%" align="center" class="graphSeperatorLineBottom">
								<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common. ICA File Download")%></div>
									<div style="width:100%;overflow:auto;padding:70px;height:200px">
									<img src='/final/images/Light/nomeasures_custom.png' />
								</div>
							</td>
		<%
					}
					if(getKy.equalsIgnoreCase("appLaunchDonutHealth"))
					{
						servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=200&width=400";
						String tdCls="graphSeperatorLineBottom";
						if(!enableICAFile){
							tdCls="graphSeperatorLineRight";
		%>
					<tr>
		<%
					}
		%>
						<td width="50%" align="center" class="<%=tdCls%>">
							<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Application Launch")%></div>
							<div>
							<table width="100%" ><col width="70%"><col width="30%">
								<tr class="newimg">
									<td align="right">
		<%
										if(frompdf != null && frompdf.equalsIgnoreCase("yes"))
										{
											servlet2 = "/final/servlet/com.eg.ErCtxLogonSimulator;jsessionid=" + session.getId() + "?options=graph&resultMapKey="+getKy+"&height=350&width=400";
		%>
											<div align="center" style="position:relative; width:220px; height:220px">
													<div><img src="<%= mngrIP + servlet2 %>" /></div>
		<%
												if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
		%>
													<div style="border:15px solid #ffffff;width:30px;height:30px;top:50%;position:absolute;left:50%;margin-top: 160px;margin-left: 150px;background-color:#ffffff;">
												</div>
		<%
												}
		%>
											</div>
		<%
										}
										else
										{
		%>
											<div align="center" style="position:relative; width:220px; height:220px">
												<div><img width="100%" height="100%" src="<%= mngrIP + servlet2 %>" /></div>
		<%
												if(isHighChartEnable != null && (isHighChartEnable.equalsIgnoreCase("No") || isHighChartEnable.equalsIgnoreCase("false"))){
		%>
												<div style="border:0px solid green;position:absolute;width:60px;height:60px;top:50%;left:50%;margin-top: -30px;margin-left: -30px;background:#ffffff;">
												</div>
		<%
												}
		%>
											</div>
		<%
										}
		%>
									</td>
									<td>
										<table align="left" cellpadding="0" cellspacing="0" border="0">
											<tbody>
		<%
								ArrayList lg_legends= (ArrayList)resultMap.get("appDonutHealthLegends");
								if(lg_legends!=null && lg_legends.size()>0)
								{
									String stageColor = "";
									Iterator data_itr = lg_legends.iterator();
									while (data_itr.hasNext())
									{
										String values = (String) data_itr.next();
										if(values!=null)
										{
											if(values.startsWith("Critical"))
											{
												stageColor = "#CC0000";
											}
											else if(values.startsWith("Major"))
											{
												stageColor = "#FA9D1C";
											}
											else if(values.startsWith("Minor"))
											{
												stageColor = "#CCC100";
											}
											else if(values.startsWith("Normal"))
											{
												stageColor = "#457E08";
											}
											else
											{
												stageColor = "#49909F";  
											}
										}
		%>
												<tr>
													<td>
														<div style="background-color:<%=stageColor%>;height:<%=legdHeight%>;width:<%=legdWidth%>;border-radius: 4px;">
														</div>
													</td>
													<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=values%></td>
												</tr>
		<%
									}
								}
		%>
											</tbody>
										</table>
									</td>
								</tr>
							</table>
							</div>
						</td>
					</tr>
		<%
					}
					else if (i==3)
					{
		%>
						<tr>
							<td width="50%" align="center" class="graphSeperatorLineBottom">
								<div class="printOuterBoxHeader"><%=trackerMappingInfo.getTextDescription("reporter.common.Application Launch")%></div>
									<div style="width:100%;overflow:auto;padding:70px;height:200px">
									<img src='/final/images/Light/nomeasures_custom.png' />
								</div>
							</td>
						</tr>
		<%
					}
				}
			}
%>
		</table>
	</div>
	<div class="clearDiv">&nbsp;</div>
<%
	}
	else
	{
%>
		<table width="100%" height="100%" style="height:100%;">
			<tr>
				<td align='center' valign='middle'>
					<div style="width:100%;overflow:auto;padding:70px;height:300px">
						<img src='/final/images/Light/nomeasures_custom.png' />
					</div>
				</td>
			</tr>
		</table> 
		<div >
<%
	}
	}
	catch(Throwable t)
	{
		t.printStackTrace();
	}
%>
		</body>
	</html>
	<%@ include file = "ErRemoveUser.jsp" %>
<%
	if(titleToDisplay!=null && !titleToDisplay.isEmpty())
	{
		//For Setting the PDf File Name
		String reportFileName=customReplaceAll(titleToDisplay," ","_");
		HashMap paramVal =new HashMap();
		paramVal.put("fileName",reportFileName);
		session.setAttribute("parameters", paramVal);
	}
%>
<%!
	public String customReplaceAll(String source,String toReplace,String replacement)
	{
		int idx = source.lastIndexOf(toReplace);
		if (idx != -1) {
			StringBuffer ret = new StringBuffer(source);
			ret.replace(idx, idx + toReplace.length(), replacement);
			while ((idx = source.lastIndexOf(toReplace, idx - 1)) != -1)
			{
				ret.replace(idx, idx + toReplace.length(), replacement);
			}
			source = ret.toString();
		}
		return source;
	}
	public boolean isEnumerationNeeded(String CompName,String enumerationComponents){
	boolean needEnumeration=true;
		try{
			if(enumerationComponents != null && CompName != null && enumerationComponents.indexOf(CompName) > -1)
				needEnumeration=false;
		}catch(Exception ee){}
		return needEnumeration;
	}
	public boolean isICAenabled(String CompName,String ICAcomponents)
	{
		boolean enableICAFile=false;
		try{
			if(ICAcomponents != null && CompName != null && ICAcomponents.indexOf(CompName) > -1)
				enableICAFile=true;
		}catch(Exception ee){
			ee.printStackTrace();
		}
		return enableICAFile;
	}
%>
