function parallaxAnimation() {
	var parallaxBox = document.getElementById('mainCon');

	var c1left = document.getElementById('pa1').offsetLeft;
	var c1top = document.getElementById('pa1').offsetTop;
	var c2left = document.getElementById('pa2').offsetLeft;
	var c2top = document.getElementById('pa2').offsetTop;
	parallaxBox.onmousemove = function (event) {
		event = event || window.event;
		var x = event.clientX - parallaxBox.offsetLeft,
			y = event.clientY - parallaxBox.offsetTop;

		mouseParallax('pa1', c1left, c1top, x, y, 20);
		mouseParallax('pa2', c2left, c2top, x, y, 45);
	}
}

function mouseParallax(id, left, top, mouseX, mouseY, speed) {
	var obj = document.getElementById(id);

	var parentObj = obj.parentNode;
	var containerWidth = parseInt(parentObj.offsetWidth);
	var containerHeight = parseInt(parentObj.offsetHeight);

	obj.style.left = left - (((mouseX - (parseInt(obj.offsetWidth) / 2 + left)) / containerWidth) * speed) + 'px';
	obj.style.top = top - (((mouseY - (parseInt(obj.offsetHeight) / 2 + top)) / containerHeight) * speed) + 'px';
}

Ext.define('PortalLogin.view.CitrixView', {
	extend: 'Ext.form.Panel',
	alias: 'widget.CitrixView',
	layout: {
		type: 'fit',
		align: 'stretch',
		pack: 'start',
	},
	id: 'CitrixView',
	requires: [
		'PortalLogin.view.RegFormCS',
		'PortalLogin.view.LoginFormCS',
		'PortalLogin.view.ForgetPasswordCS',
		'PortalLogin.view.TwoFACS'
	],
	items: [
		{
			xtype: 'container',
			id: 'mainCon',
			padding: 0,
			margin: 0,
			width: '100%',
			//cls : 'ls_login-frame',
			layout: {
				type: 'vbox',
				align: 'stretch',
				pack:'center'
			},
			items: [
				
				{
					xtype: 'container',
					width: '100%',
					flex: 1,
					layout: {
						type: 'fit',
						align: 'stretch',
						pack: 'center'
					},
					margin:'0 0 0 0',
					cls: 'cs_parentContainerForFlex',
					items: [
						{
							xtype: 'container',
							id: 'pa1',
							cls: 'cs_parallax_signin1',
							style: { 'z-index': '1','width': '100%', 'height': '100%'},
						}, {
							xtype: 'container',
							id: 'pa2',
							cls: 'cs_parallax_signin2',
							style: { 'z-index': '2','width': '100%', 'height': '100%'},
						}, 
						{
							xtype: 'container',
							padding: 0,
							margin:'0 0 0 0',
							scroll: false,
							autoScroll: false,
							width: '100%',
							style: { 'z-index': '4', 'position': 'absolute', 'width': '100%', 'height': '100%' },
							layout: {
								type: 'vbox',
								align: 'center',
								pack: 'start'
							},
							items: [
								//  With High light text design
								// {
								// 	xtype: 'container',
								// 	margin: '0 0 0 0',
								// 	width: '100%',
								// 	html: '<div class="cs_signInHeaderText">eG Enterprise Cloud </div><div class="cs_signInSubHeaderText">Converged Application and Infrastructure Monitoring as a Service.</div><div style="border-bottom:1px solid #e5e5e5;position:relative">&nbsp;<div class="loginHighlightBg">SAFE.<br/>SECURE.<br/>100% Web-based<br/>SaaS Solution.</div></div>'
								// },
								{
									xtype: 'container',
									padding: 0,
									layout: {
										type: 'vbox',
										align: 'center',
									},
									style: { 'z-index': '6'},
									margin: 0,
									height:90,
									items:[{
										xtype:'container',
										width:1100,
										html: '<div style="text-align:left;width:200px;"><a href="'+strLoginLogoHref+'" target="_blank" style="text-decoration:none">' + loginLogoImage + '</a></div>',
									}]
								},
								{
									xtype: 'container',
									margin: '-20 0 20 0',
									width: '100%',
									html: '<div class="cs_signInHeaderText">'+loginTitle+'</div><div class="cs_signInSubHeaderText">Converged Application and Infrastructure Monitoring as a Service</div>'
								},
								{
									xtype: 'container',
									border:true,
									id: 'errorState',
									bodyPadding:'0px',
									margin:'10 0 10 0',
									width: 450,
									hidden: true,
									cls:'cs_loginErrorMsgContainer',
									html:'<div class="cs_loginErrorMsg">Saas for Monitoring</div><div style="float:right"><img src="/final/images/spacer.gif" class="errorClose" id="errorClose"></div>',
								},
								{
									xtype:'container',
									id:'custom_msg_container',
									html:'<div id="custom_msg_div" class="cs_captionText"></div>',
									margin:'10px 10px 20px 10px',
									hidden: false
								},
								{
									xtype: 'container',
									id: 'mainContainer',
									width: 470,
									margin: '10 0 0 0',
									frame: false,
									bodyPadding: 0,
									cls: 'cs_loginpanel',
									items: [
										{
											xtype: 'container',
											id:'changeShade',
											cls:'loginShade',
										},
										{
											xtype: 'container',
											id: 'signin',
											margin: '0 0 -1 0',
											padding: '0 10 0 10',
											items: [
												{
													xtype: 'container',
													margin: '5 30 0 30',
													html: '<div id="loginHeader"><div style="z-index:4"><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="right" width="50%" style="cursor:default;"><div class="cs_signInButtonOuter"><div class="cs_signIn_Register_Text_selected">SIGN IN</div><div class="cs_tabButtonShadeSignIn"></div></div></td><td align="left" style="cursor:pointer;" width="50%"><div class="cs_signIn_Register_Text" onclick="javascript:thisController.goToSignUp();">REGISTER</div></td></tr></table></div></div>'
												}
											]
										},
										{
											xtype: 'LoginFormCS',
											id: 'LoginForm',
											align: 'center',
											height:228,
											cls: 'cs_portalLoginPanelInner',
											autoHeight: true,
											padding: '20 20 10 20',
										},
										{
											xtype: 'container',
											id: 'signup',
											margin: '0 0 -1 0',
											padding: '0 10 0 10',
											items: [
												{
													xtype: 'container',
													margin: '5 30 0 30',
													html: '<div id="loginHeader"><div style="z-index:4"><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="right" style="cursor:pointer;" width="50%"><div class="cs_signIn_Register_Text" onclick="javascript:thisController.goToSignIn();" >SIGN IN</div></td><td align="left" width="50%" style="cursor:default;"><div class="cs_registerButtonOuter"><div class="cs_tabButtonShadeRegister"></div><div class="cs_signIn_Register_Text_selected" >REGISTER</div></div></td></tr></table></div></div>'
												}
											]
										},
										{
											xtype: 'RegFormCS',
											id: 'RegForm',
											align: 'center',
											cls: 'cs_portalLoginPanelInner',
											autoHeight: true,
											height:338,
											padding: '10 20 10 20'
										},
										{
											xtype: 'container',
											id: 'forgotpwd',
											margin: '0 0 -1 0',
											padding: '0 10 0 10',
											items: [
												{
													xtype: 'container',
													margin: '5 30 0 30',
													html: '<div id="loginHeader"><div style="z-index:4"><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="right" style="cursor:pointer;" width="50%"><div class="cs_signInButtonOuter"><div class="cs_signIn_Register_Text_selected" onclick="javascript:thisController.goToSignIn();">SIGN IN</div><div class="cs_tabButtonShadeSignIn"></div></div></td><td align="left" style="cursor:pointer;" width="50%"><div class="cs_signIn_Register_Text" onclick="javascript:thisController.goToSignUp();">REGISTER</div></td></tr></table></div></div>'
												}
											]
										},
										{
											xtype: 'ForgetPasswordCS',
											id: 'ForgetPassword',
											align: 'center',
											height:228,
											cls: 'cs_portalLoginPanelInner',
											autoHeight: true,
											padding: '10 20 10 20'
										},
										{
											xtype: 'container',
											id: 'auth',
											margin: '0 0 -1 0',
											padding: '0 10 0 10',
											items: [
												{
													xtype: 'container',
													margin: '5 30 0 30',
													html: ''
													//html: '<div id="loginHeader"><div style="z-index:4"><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="right" width="50%"><div class="cs_signInButtonOuter"><div class="cs_signIn_Register_Text_selected" onclick="javascript:thisController.goToSignIn();">SIGN IN</div><div class="cs_tabButtonShadeSignIn"></div></div></td><td align="left" style="cursor:pointer;" width="50%"><div class="cs_signIn_Register_Text" onclick="javascript:thisController.goToSignUp();">REGISTER</div></td></tr></table></div></div>'
												}
											]
										},
										{
											xtype: 'TwoFACS',
											id: 'TwoFA',
											align: 'center',
											height:228,
											cls: 'cs_portalLoginPanelInner',
											autoHeight: true,
											padding: '10 20 10 20'
										},
										{
											xtype:'container',
											width : 470,
											id:"cs_upgradeInfo",
											hidden:hideUpgradeInfo,
											align:'left',
											padding:'0 10 10 10',
											items:[
												{
													xtype:'container',
													html:'<div class="cs_upgrade"><div class="cs_upgradeInner"><img src="/final/images/exclamationYellow.png" height="24px" style="margin-right:5px;">This eG Manager has been recently upgraded. If you are logging in for the 1st time, please clear your browser cache once.</div></div>'
												}
											]
										}
									]
								},
								{
									xtype: 'container',
									html: '<div class="cs_copyrights" style="display:block">'+strLoginFooterText+'.</div>'+termsAndConditions,
									padding: 0,
									margin: 0,
									height: 20,
									width: '100%',
								},
								// ,{
								// 	xtype: 'container',
								// 	border:true,
								// 	cls:'cs_footerTextContainer',
								// 	style:{'border':'1px solid red'},
								// 	margin: 5,
								// 	html: '<div class="cs_signInFooterText">Manage and Monitor Citrix<sup>*</sup></div>'
								// }
							]
						}
					],
					listeners: {
						afterrender: function () {
							parallaxAnimation()
						}
					}
				}, 
			]
		}
	]
});



