var currentPageNo = 1;
var filterForm = null;
var publicJson1 = {"hiddenParams":[{"userID":""}]};
Ext.define('EgCorAlarm.controller.MetricsController', {
	extend: 'Ext.app.Controller',
	views:['history.view.*'],
	refs:[{
    	ref:'main',
    	selector:'main'
    },{
    	ref:'historyfilters',
    	selector:'historyfilters'
    },{
    	ref:'HistorySummary',
    	selector:'historysummary'
    },{
    	ref:'submitButton',
    	selector:'historyfilters button[action=Show Alarms]'
    },{
		ref:'gridColumn',
		selector:'historysummary gridcolumn'
	},{
		ref:'historyfilterscategory',
		selector:'historyfilterscategory'
	},{
		ref:'HistoryFiltersTimeline',
		selector:'historyfilterstimeline'
	},{
    	ref:'DetailsGrid',
    	selector:'detailsgrid'
    }],
	init: function () {
		this.control({
			'historysummary' : {
				'itemmouseenter' : this.showToolTip,
				'itemmouseleave' : this.destroyToolTip,
				'render' : this.loadHistorySummaryData
			},
			'historysummary button[action=first]' :{
				click : this.hsummaryFirstButton				
			},
			'historysummary button[action=previous]' :{
				click : this.hsummaryPreviousButton				
			},
			'historysummary textfield[name="goToPage"]' :{
				'keyup' : this.goToPage				
			},				
			'historysummary button[action=next]' :{
				click : this.hsummaryNextButton				
			},
			'historysummary button[action=last]' :{
				click : this.hsummaryLastButton				
			},
			'historysummary gridcolumn[name="graph"]':{
				click : this.clickGraph,
			},											// Prem
			'historysummary gridcolumn[name="fixhistory"]':{
				click : this.clickFixHistory,
			},											
			'historysummary gridcolumn[name="detailedDiagnosis"]':{
				click : this.clickDetailedDiagnosis,
			},
			'historyfilters button[action=Save CSV]':{
				click : this.saveInCSVFormat
			},
			'historyfilters button[action=Save PDF]' : {
				click : this.saveInPDFFormat
			},
			'historyfilters combo' : {
				'boxready'	: this.loadComboFieldSelectedVal,
				'select'	: this.loadFields
			},
			'historyfilters button[action=back]' :{
				click : this.backButton				
			},
			'historyfilters button[action=Show Alarms]' : {
				click : this.showAlarms
			},
			'historymorefilters button[action=UpdateSettings]' : {
				click : this.showAlarms
			},
			'textfield[name="gridsearch"]':{
				//'keyup' : this.searchGrid,
				'keypress' : function(textfield,eventObject){
					if (eventObject.getCharCode() == Ext.EventObject.ENTER) {
						var triggerId= Ext.getCmp('triggerId').getValue();
						var moreFiltersForm = Ext.getCmp('more-filter-options-panel').getForm();
							moreFiltersForm.findField('infosearch').setValue(triggerId);
						currentPageNo = 1;
						var disp = Ext.getCmp("displayInfo");
						var endInx = parseInt(pageCount)*parseInt(currentPageNo);
						var startInx = endInx- parseInt(pageCount);
						if(recCount<endInx)
							endInx = recCount;
						var msg = historyDockedDisplaying+" "+(startInx+1)+"-"+endInx+" "+historyDockedOf+" "+recCount;
						disp.setText(msg);
						
						var first = Ext.getCmp("pfirst");
						var prev = Ext.getCmp("pprev");
						first.disabled=true;
						prev.disabled=true;
						if(parseInt(totalRecords)>currentPageNo)
						{
							var next = Ext.getCmp("pnext");
							var last = Ext.getCmp("plast");
							next.disabled=false;
							last.disabled=false;
						}
						this.showAlarms(this.getSubmitButton(),'','');						
					}
				}				
			},
			'historyfilterstimeline combo[id="eg_timeline"]': {
				"select": this.changeTimeline
			},
			'historymorefilters radio[id="current"]':{
				"afterrender":this.changeFilters,
				"change":this.changeFilters
			},
			'acknowledgementpanel button[id="submitBtn"]': {
                'click': this.alarmAckSubmit
            },
			'acknowledgementpanel button[id="unAckBtn"]':{
				'click' : this.goToUnAcknowledge
			},
			'acknowledgementpanel button[id="clearBtn"]':{
				'click' : this.clearAckDescription
			},
		});
	},
	showDetails:function(event,popupVal,rowIndex){
		//var detailsPopup = Ext.create('history.view.HistoryDetails');
		//detailsPopup.show();
		//this.getDetailsGrid().getStore().getProxy().url='/final/servlet/com.egurkha.monitor.alarms.AlarmHistoryServlet?forTransition=true&info='+popupVal+'&showEventHistory='+showEventHistory+"&ddTimeAlt=true";
		//this.getDetailsGrid().getStore().load();
		Ext.create('Ext.window.Window', {
			cls:'history-window',
			ghost:false,
			title:'Alarm transitions',
			width:885,
			height:400,
			layout:'border',
			modal:true,
			closeAction:'destroy',
			margin:'0px 0px 0px 0px',
			padding:'5 10 10 10',		
			constrain: true,
			border: false,
			frame: false,
			tools:[
			{
				xtype : 'button',
				iconCls : 'iconHelp',									
				//tooltip : '<b>New Window</b>',
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',										
							trackMouse: true,
							html: 'Help'
						});
					}
				},
				style : {
					'background' : 'none',
					'border' : '0px',
					'margin':'0 10 0 0',
				},
				handler : function()
				{
					HelpWin();
				}
			}],
			listeners: {
				show: function (win) {
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						for (var y = 0; y < dom.length; y++) {
							var el = Ext.fly(dom[y]);
						   
						}
					 el.addCls('windowModal');
					}
				},
				hide: function (win) {
					var dom = Ext.dom.Query.select('.x-mask');
					if (this.modal) {

						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
				},
				afterrender: function () {
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			items: [{
				xtype: 'grid',
				alias : 'widget.detailsgrid',
				region:'center',
				border: false,
				frame: false,
				title:'No of transitions found : -',
				forceFit:true,
				margin:'10 0 10 10',
				ui:'newGridPanel newGridPanelBorder',
				store:Ext.create('Ext.data.Store',{
					autoLoad : false,
					fields: ['rowHref','state','compType','compName','service','test','description','startTime','endTime','duration','split'],
					proxy: {
						type: 'ajax',
						reader: {
							type: 'json',
							root:'alarmDetailJson'
						}
					}
				}),
				header:{
					padding:'5 10',
					style:{'font-size':'12px','font-weight':'500'}
				},
				//border:true,
				viewConfig: {
					emptyText: '<div style="height:98%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconExclamation" style="margin:0px auto"></div><div style="text-align:center">No transitions found!</div></div></div>',
					deferEmptyText: false
				},
				listeners:{
					afterRender:function(){
						this.getStore().on('load',this.storeLoadHandler,this);
						this.getStore().getProxy().url='/final/servlet/com.egurkha.monitor.alarms.AlarmHistoryServlet?forTransition=true&info='+popupVal+'&showEventHistory='+showEventHistory+"&ddTimeAlt=true";
						this.getStore().load();
					},		
				},
				storeLoadHandler:function(store){
					if(store.getCount()>0){
						this.setTitle('No of transitions found : '+store.getCount());
						//set the chart for first record
						var record=store.getAt(0);
						showTransitionDistribution(record.get("split"),false);
					}
				},
				columns:[{
					text:'',
					dataIndex:'state',
					hideable : false,
					sortable:false,
					resizable:false,
					enableColumnHide : true,
					filter: false,
					menuDisabled : true,
					width:30,
					bodyStyle:{'padding':'0px','margin':'0px'},
					baseStyle:{'padding':'0px','margin':'0px'},
					style:{'padding':'0px','margin':'0px'},
					margin:0,
					padding:0,
					renderer:function(state,metaData,record,rowIndex){
							if (state=='LOW')
							{
								state='Minor';
							}
							if (state=='INTERMEDIATE')
							{
								state='Major';
							}
							if (state=='HIGH')
							{
								state='Critical';
							}
							var returnState = '<img style="width: 16px;" src="/final/images/clear.png" class="alarm'+state+'" />';
							if(typeof showFlashingIcon != 'undefined' && showFlashingIcon && state == "critical")
								returnState = '<img src=/final/images/utility_Light_loader.gif>';
							return returnState;
							
					}
				},{
					text:'Comp Type',
					menuDisabled:true,
					dataIndex:'compType',
					renderer:function(value,metaData,record,rowIndex){
						//alert(value);
						var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
						return returnValue;
					}
				},{
					text:'Comp Name',
					menuDisabled:true,
					dataIndex:'compName',
					renderer:function(value,metaData,record,rowIndex){
						var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
						return returnValue;
					}
				},{
					text:'Test',
					menuDisabled:true,
					dataIndex:'test',
					renderer:function(value,metaData,record,rowIndex){
						var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
						return returnValue;
					}
				},{
					text:'Description',
					menuDisabled:true,						
					dataIndex:'description',
					renderer:function(value,metaData,record,rowIndex){
						var decode_Val=value.replace('|hash|', '#')
						var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ Ext.String.htmlDecode(decode_Val) +'</a>';
						return returnValue;
					}
				},{
					text:'Start Time',
					menuDisabled:true,
					width:110,
					dataIndex:'startTime',
					renderer:function(value,metaData,record,rowIndex){
						var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
						return returnValue;
					}
				},{
					text:'End Time',
					menuDisabled:true,								
					width:110,
					dataIndex:'endTime',
					renderer:function(value,metaData,record,rowIndex){
						var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
						return returnValue;
					}
				},{
					text:'Duration',
					menuDisabled:true,
					width:70,
					dataIndex:'duration',
					renderer:function(value,metaData,record,rowIndex){
						var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
						return returnValue;
					}
				}]
			},{
				width: 300,
				layout:{
					type:'vbox',
					align:'stretch'
				},
				items:[{
					xtype:'panel',
					flex:1,
					id:'distibutionChart',
					html:'<b>Transitions distribution</b>',
					cls:'datapanel',
					margin:'10 10 10 5',
					header:{
						padding:'5 5 2 5',
						style:{'font-size':'12px','font-weight':'400'}
					},
					hideCollapseTool:true
				}],
				header:false,
				region:'east',
				collapsed: true,
				border: 0,
				ui:'empty',
				frame: false,
				split: true,
				collapseMode :'mini',
				collapsible: true
			}]
		}).show();
	},
	showTransitionDistribution:function(split,expand){
		Ext.Ajax.request({
			url : '/final/monitor/TransitionDistribution.jsp?from=Dashboard&split='+split,
			scope:this,
			async:true,
			timeout:300000,
		    success: function(response){
		        var jsonText = response.responseText;
		        var jsonData=Ext.decode(jsonText);
				
				var cdId="alarmTransPanelId";
				var cfId="alarmTransChartId";

				var htmlstring='<div style=" margin:18% auto;"><div id="'+cdId+'" style="height:100%;"></div></div>';
				
				var chartPanel=Ext.getCmp('distibutionChart');
				//chartPanel.update(chartHtml);
				chartPanel.update(htmlstring);
				if(expand){
					chartPanel.expand();
				}
				chartPanel.setTitle(jsonData.screenLabels["monitor.home.Transitions distribution"]);
				var newPanel = {					
					xtype:'container',
					//cls:'componentnetworkseperator dfsf',
					flex:.25,
					margin:'5px 0 0 0',
					height:200,
					html:htmlstring,
					listeners : {
					'afterrender' : function() {
						var formdata = jsonData.chartData;
						formdata['unit'] = '%';
						var pieChart = {};
						pieChart = jQuery.extend(true, {}, createBar(cdId,200,250), pieChart);
						pieChart.setData(formdata,'','','pie');
						pieChart.drawChart();
					}
				 }
				};
				chartPanel.add(newPanel);				
		    }
		});
	},
	updateQueryString: function(objId) {
        var des = Ext.getCmp('textaraObj').getValue();
        var QStr = ''; // "&compsearch="+searchText+"&selectedSearchByOption="+searchByCombo;
        //QStr += 'alarmType=CurrentAlarms&userID=admin&alarmID='+queryReqParams.alarmId+'&isDelAlarms=true&ackAlarmDbDelete=Delete%20Alarm&isFromDashBoard=false&desc='+des;
        QStr += 'alarmType=CurrentAlarms';

        var hidQstr = '';
        var hiddenParams = publicJson1['hiddenParams'];
        for (var hid in hiddenParams) {
            var hidVal = hiddenParams[hid];
			if(typeof hidVal != "function" && typeof hidVal != "object"){
				if (hidVal != null)
					hidQstr = hidQstr + '&' + hid + '=' + encodeURIComponent(hidVal);
				else
					hidQstr = hidQstr + '&' + hid + '=' + hidVal;
			}
        }
        QStr = QStr + hidQstr;

        return QStr;
    },
	checkSpecialCharacter: function(name) {
        var splChar = "=\"";
        for (var i = 0; i < name.length; i++) {
            check_char = splChar.indexOf(name.charAt(i))
            //Returns value 1 if the special character listed in splChar is found
            if (check_char >= 0) {
                return true;
            }
        }
        return false;
    },
	goToUnAcknowledge : function()
	{
		var des = Ext.getCmp('textaraObj').getValue();

		if(!checkblankVal(des))
		{
			Ext.MessageBox.show({
				title: 'Alert',
				//msg: unAckAlertMsg,
				msg: unAckDescriptionAlert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		else
		{
			Ext.MessageBox.confirm('Confirm', unAckDeleteConfirmAlert,this.unAcknowledgeAlarm,this);
		}
	},
	unAcknowledgeAlarm : function(btn)
	{
		if(btn=="yes")
		{
			var view_obj = Ext.getCmp('dashmenu_model_id');
			var view_name='';
			try
			{
				view_name=view_obj.selModel.selected.items[0].data.id;
			}
			catch (ere)
			{
			}
			var des = Ext.getCmp('textaraObj').getValue();
			/*var ackAlarmIDs = alarmAckHiddenParams['ackAlarmIDs'];

			if(ackAlarmIDs.indexOf("#")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.substring(ackAlarmIDs.indexOf("#")+1);
			}

			if(ackAlarmIDs.indexOf("#")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.substring(ackAlarmIDs.indexOf("#")+1);
			}
		//	EgAckForm.hiddesc.value=des;
			while(ackAlarmIDs.indexOf("+")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("+","|plus|");
			}
			while(ackAlarmIDs.indexOf("&")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("&","|amp|");
			}
			while(ackAlarmIDs.indexOf("%")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("%","|pct|");
			}*/
			var userAck = alarmAckHiddenParams['userAck'];
			var alarmId = alarmAckHiddenParams['alarmId'];
			var vmfromAlarm = alarmAckHiddenParams['vmfromAlarm'];
			var ackAlarmDB = "Unacknowledge";
			try
			{
				des = window.opener.filterEncode(des);
			}
			catch (e)
			{
				des = parent.filterEncode(des);
			}
			//var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=" +encodeURIComponent(userId) + "&alarmID=" + alarmId+ "&userAck=" + userAck + "&ackAlarmIDs=" +encodeURI(ackAlarmIDs)+ "&ackAlarmDB="+ackAlarmDB;
			var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=" + userId + "&alarmID=" + alarmId+ "&userAck=" + userAck + "&ackAlarmDB="+ackAlarmDB+"&ackAlarmIDs="+encodeURIComponent(vmfromAlarm);
			var winObj = Ext.getCmp('ackWindowObj');
			var dess = winObj.selectedAlarm;
			/*dess = dess.substring(dess.indexOf("~")+1);
			dess = dess.substring(dess.indexOf("~")+1);
			dess = dess.substring(dess.indexOf("~")+1);
			dess = dess.substring(0,dess.indexOf("~"));*/
			//NETWORK~NULL|+|NetworkTest|Pkt_loss_pct|172.16.14.111
			//dess = dess.substring(dess.indexOf("~")+1);
			if(!Ext.isEmpty(dess))
				QStr += "&deleteSelectedInfos="+encodeURIComponent(parent.filterEncode(dess));

			Ext.getCmp('ackWindowObj').destroy();
			var meController = this;
			var emtText = Ext.get("emptyTextTb");
			try
			{
				if(emtText != null)
				Ext.get("emptyTextTb").hide();
			}
			catch (e)
			{
			}
			alarmLoadMask.show();
			var browser=get_browser_info();
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgCurrentAlarmsC',
				method : 'POST',
				timeout:300000,
				params: QStr+'&doAlarmAcknowledgementEvent=true&acknowledgementEvent=unAcknowledge&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+"&isFromQuickLink="+isFromQuickLink,
				scope:this,
				success: function(response)
				{
					//var jsonText = response.responseText;
					//console.log(jsonText);
					//var jsonData=Ext.decode(jsonText);
					var jsonData = JSON.parse( response.responseText );
					var acknowledge = jsonData['unacknowledge'];

					alarmLoadMask.hide();
					if(ttIntegrationenabled!=null && ttIntegrationenabled=="Yes" || ttIntegrationenabled=="true")
					{
						var queryStr = "sendTTAcknowledgement=true&desc="+encodeURIComponent(des)+"&alarm_Id=" + alarmId;
						Ext.Ajax.request({
							url : '/final/servlet/com.eg.EgCurrentAlarmsC',
							method : 'POST',
							timeout:300000,
							params: queryStr,
							scope:this,
							success: function(response)
							{
								var jsonData = JSON.parse( response.responseText );
							}
						});
					}
					if(view_name != null && view_name=='corr_View')
					{
						var showCombo = Ext.getCmp('showCombo');
					  EgCorAlarm.app.getController('CorrelatedController').loadAlarms(showCombo);
					}
					else if(view_name != null && view_name=='metrics_view')
					  EgCorAlarm.app.getController('Main').goToMetricsPage();
				}
			});
		}
		else
		{
			return false;
		}
	},
	alarmAckSubmit: function(buttonObj) {
        var alarmAckEvent = alarmAckHiddenParams['alarmAckEvent'];
        if (alarmAckEvent != null) {
            if (alarmAckEvent == "Delete_Alarm") {
                this.alarmDelete(buttonObj);
            } else if (alarmAckEvent == "AckOrUnack") {
                this.alarmAcknowledge(buttonObj);
            }
        }
    },
	alarmAcknowledge: function(button) {
		var des = Ext.getCmp('textaraObj').getValue();
		var winObj = Ext.getCmp('ackWindowObj');
        var description = true;
		var view_obj = Ext.getCmp('dashmenu_model_id');
		var view_name='';
		try
		{
			view_name=view_obj.selModel.selected.items[0].data.id;
		}
		catch (ere)
		{
		}
        if (isDoubleByteEnabled == "false")
            description = validateSingleByte(des);


        if (this.checkSpecialCharacter(des)) {
            Ext.Msg.show({
                title: "Alert",
                msg: ackDescriptionSplCharAlert,
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        } else if (!description) {
            Ext.MessageBox.show({
                title: 'Alert',
                msg: ackdbyteAlert,
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return false;
        } else {
            if (isDoubleByteEnabled && isOracleDB) {
                if (des != null && des != '' && des.length > 1024) {
                    Ext.MessageBox.show({
                        title: 'Alert',
                        msg: maxAcknowledgeDescForDByte,
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.WARNING
                    });
                    return false;
                }
            } else if (des != null && des != '' && des.length > 2048) {
                Ext.MessageBox.show({
                    title: 'Alert',
                    msg: maxAcknowledgeDescForSByte,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return false;
            }

            if (des == null || des == '')
                des = "-";

            try {
                des = window.opener.filterEncode(des);
            } catch (e) {
                des = parent.filterEncode(des);
            }
		}
		//var QStr = "selectedSubFilterOption=HIGH%7Camp%7CINTERMEDIATE%7Camp%7CLOW";
		//QStr += "&showAlarms=HIGH%7Camp%7CINTERMEDIATE%7Camp%7CLOW";
		//QStr += "&alarmType=CurrentAlarms";
		//QStr += "&selectedFilterOption=States";
		//QStr += "&requestFrom=null";
		//QStr += "&dashBoard=";
		//QStr += "&homePage=null";
		//QStr += "&zoneName=null";
		//QStr += "&isDelAlarms=true";
		//QStr += "&selectedOption=null";
		//QStr += "&fromPage=";
		//QStr += "&delAlarmIDs=";
		//QStr += "&userID=admin";
		//QStr += "&desc="+encodeURIComponent(des);
		//QStr += "&ackAlarmDbDelete=Delete%20Alarm";
		//QStr += "&alarmID="+alarmAckHiddenParams['alarmId'];
		//QStr += "&dispAtMainWin=null";
		//QStr += "&stateTab=null";
		//QStr += "&maxDurationAlarmIds=null";
		//QStr += "&maintainLongestAlarms=false";
		//QStr += "&deleteOptions=Selected";

		var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=admin&alarmID="+alarmAckHiddenParams['alarmId']+"&userAck=&ackAlarmDB=Acknowledge&doAlarmAcknowledgementEvent=true&acknowledgementEvent=acknowledge&screenWidth=998&screenHeight=499&isBro=Chrome&isFromQuickLink=false";
		
		//console.log('winObj--1->',winObj)
		var dess = winObj.selectedAlarm;
		//console.log('alarmAckHiddenParams--1->',alarmAckHiddenParams)
		
		//172.16.14.86:7077:NULL~eG_Manager~EG HELPER PROCESS~NULL|+egmon|EgHelperProcessTest|process_count|172.16.14.86~03/17/2022~!~1647494528653~@~INTERMEDIATE

		//false$windows_22:NULL:~Host_system~NETWORK~NULL|+|NetworkTest|Pkt_loss_pct|172.16.14.111~Mar 07, 2022 17:00$@$HIGH
		
		//NETWORK~NULL|+|NetworkTest|Pkt_loss_pct|172.16.14.111
		//dess = dess.substring(dess.indexOf("~")+1);
		//console.log('dess-1-->',dess)
		if(!Ext.isEmpty(dess))
			QStr += "&deleteSelectedInfos="+encodeURIComponent(parent.filterEncode(dess));
		QStr += "&isFromDashBoard=false";
		QStr += "&screenWidth=998";
		QStr += "&screenHeight=499";
		QStr += "&isBro=Chrome";
		QStr += "&isFromQuickLink=false";
		var browser = get_browser_info();
		 Ext.getCmp('ackWindowObj').destroy();
		 Ext.Ajax.request({
                url: '/final/servlet/com.eg.EgCurrentAlarmsC',
                method: 'POST',
				timeout:300000,
                params: QStr,
                scope: this,
                success: function(response) {
                    //var jsonText = response.responseText;
                    //var jsonData=Ext.decode(jsonText);
                    var jsonData = JSON.parse(response.responseText);
                    publicJson1 = jsonData;
                    alarmLoadMask.hide();
                    if (ttIntegrationenabled != null && ttIntegrationenabled == "Yes" || ttIntegrationenabled == "true") {
                        var alarmId = alarmAckHiddenParams['alarmId'];
                        var queryStr = "sendTTAcknowledgement=true&desc=" + encodeURIComponent(des) + "&alarm_Id=" + alarmId;
                        Ext.Ajax.request({
                            url: '/final/servlet/com.eg.EgCurrentAlarmsC',
                            method: 'POST',
							timeout:300000,
                            params: queryStr,
                            scope: this,
                            success: function(response) {
                                var jsonData = JSON.parse(response.responseText);
                            }
                        });
                    }

                    //meController.loadDefaults(true);
					if(view_name != null && view_name=='corr_View')
					{
						var showCombo = Ext.getCmp('showCombo');
					  EgCorAlarm.app.getController('CorrelatedController').loadAlarms(showCombo);
					}
					else if(view_name != null && view_name=='metrics_view')
					  EgCorAlarm.app.getController('Main').goToMetricsPage();
				}
		 });
	},
    alarmDelete: function(button) {
		alarmLoadMask.show();
		var des = Ext.getCmp('textaraObj').getValue();
		var winObj = Ext.getCmp('ackWindowObj');
		//console.log('winObj--->',winObj)
		//console.log('winObj.selectedAlarm--->',winObj.selectedAlarm)
        var description = true;
		var view_obj = Ext.getCmp('dashmenu_model_id');
		var view_name='';
		try
		{
			view_name=view_obj.selModel.selected.items[0].data.id;
		}
		catch (ere)
		{
		}
        if (isDoubleByteEnabled == "false")
            description = validateSingleByte(des);


        if (this.checkSpecialCharacter(des)) {
            Ext.Msg.show({
                title: "Alert",
                msg: ackDescriptionSplCharAlert,
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        } else if (!description) {
            Ext.MessageBox.show({
                title: 'Alert',
                msg: ackdbyteAlert,
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return false;
        } else {
            if (isDoubleByteEnabled && isOracleDB) {
                if (des != null && des != '' && des.length > 1024) {
                    Ext.MessageBox.show({
                        title: 'Alert',
                        msg: maxAcknowledgeDescForDByte,
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.WARNING
                    });
                    return false;
                }
            } else if (des != null && des != '' && des.length > 2048) {
                Ext.MessageBox.show({
                    title: 'Alert',
                    msg: maxAcknowledgeDescForSByte,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return false;
            }

            if (des == null || des == '')
                des = "-";

            try {
                des = window.opener.filterEncode(des);
            } catch (e) {
                des = parent.filterEncode(des);
            }
		}
		//console.log("button-==-=->>",Ext.getCmp('ackWindowObj').qStrParams1)
		//console.log("alarmAckHiddenParams------",alarmAckHiddenParams)
		var QStr = "selectedSubFilterOption=HIGH%7Camp%7CINTERMEDIATE%7Camp%7CLOW";
		QStr += "&showAlarms=HIGH%7Camp%7CINTERMEDIATE%7Camp%7CLOW";
		QStr += "&alarmType=CurrentAlarms";
		QStr += "&selectedFilterOption=States";
		QStr += "&requestFrom=null";
		QStr += "&dashBoard=";
		QStr += "&homePage=null";
		QStr += "&zoneName=null";
		QStr += "&isDelAlarms=true";
		QStr += "&selectedOption=null";
		QStr += "&fromPage=";
		QStr += "&delAlarmIDs=";
		QStr += "&userID=admin";
		QStr += "&desc="+encodeURIComponent(des);
		QStr += "&ackAlarmDbDelete=Delete%20Alarm";
		QStr += "&alarmID="+alarmAckHiddenParams['alarmId'];
		QStr += "&dispAtMainWin=null";
		QStr += "&stateTab=null";
		QStr += "&maxDurationAlarmIds=null";
		QStr += "&maintainLongestAlarms=false";
		

		var dess = winObj.selectedAlarm;
		
		//172.16.14.86:7077:NULL~eG_Manager~EG HELPER PROCESS~NULL|+egmon|EgHelperProcessTest|process_count|172.16.14.86~03/17/2022~!~1647494528653~@~INTERMEDIATE

		//false$windows_22:NULL:~Host_system~NETWORK~NULL|+|NetworkTest|Pkt_loss_pct|172.16.14.111~Mar 07, 2022 17:00$@$HIGH
		/*dess = dess.substring(dess.indexOf("~")+1);
		dess = dess.substring(dess.indexOf("~")+1);
		dess = dess.substring(dess.indexOf("~")+1);
		//Host_system~NETWORK~NULL|+|NetworkTest|Pkt_loss_pct|172.16.14.111
		dess = dess.substring(0,dess.indexOf("~"));*/
		//NETWORK~NULL|+|NetworkTest|Pkt_loss_pct|172.16.14.111
		//dess = dess.substring(dess.indexOf("~")+1);
		//console.log('dess-1-->',dess)
		var view_obj = Ext.getCmp('dashmenu_model_id');
		var view_name='';
		try
		{
			view_name=view_obj.selModel.selected.items[0].data.id;
		}
		catch (ere)
		{
		}
		if(view_name != null && view_name=='corr_View')
		  QStr += "&deleteOptions=all";
		else if(view_name != null && view_name=='metrics_view')
		{
			QStr += "&deleteOptions=Selected";
			if(!Ext.isEmpty(dess))
		 		QStr += "&deleteSelectedInfos="+encodeURIComponent(parent.filterEncode(dess));
		}
		QStr += "&isFromDashBoard=false";
		QStr += "&screenWidth=998";
		QStr += "&screenHeight=499";
		QStr += "&isBro=Chrome";
		QStr += "&isFromQuickLink=false";
		var browser = get_browser_info();
		 Ext.getCmp('ackWindowObj').destroy();
		 Ext.Ajax.request({
                url: '/final/servlet/com.eg.EgCurrentAlarmsC',
                method: 'POST',
				timeout:300000,
                params: QStr + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height) + '&isBro=' + browser.name + "&isFromQuickLink=" + isFromQuickLink,
                scope: this,
                success: function(response) {
                    //var jsonText = response.responseText;
                    //var jsonData=Ext.decode(jsonText);
                    var jsonData = JSON.parse(response.responseText);
                    publicJson1 = jsonData;
                    if (ttIntegrationenabled != null && ttIntegrationenabled == "Yes" || ttIntegrationenabled == "true") {
                        var alarmId = alarmAckHiddenParams['alarmId'];
                        var queryStr = "sendTTAcknowledgement=true&desc=" + encodeURIComponent(des) + "&alarm_Id=" + alarmId;
                        Ext.Ajax.request({
                            url: '/final/servlet/com.eg.EgCurrentAlarmsC',
                            method: 'POST',
							timeout:300000,
                            params: queryStr,
                            scope: this,
                            success: function(response) {
                                var jsonData = JSON.parse(response.responseText);
                            }
                        });
                    }

                    //meController.loadDefaults(true);
					//Ext.defer(function(){
						if(view_name != null && view_name=='corr_View')
						{
							  var showCombo = Ext.getCmp('showCombo');
						  EgCorAlarm.app.getController('CorrelatedController').loadAlarms(showCombo);
						}
						else if(view_name != null && view_name=='metrics_view')
						  EgCorAlarm.app.getController('Main').goToMetricsPage();
						alarmLoadMask.hide();
					//},5000);                    
				}
		 });
	},
	changeFilters : function(e){
		if(e.checked){
			Ext.getCmp('eg_timeline').setDisabled(true);
			if(Ext.getCmp('eg_timeline').getValue() == "Any"){
				Ext.getCmp('eg_stdate').setDisabled(true);
				Ext.getCmp('starthr').setDisabled(true);
				Ext.getCmp('eg_enddate').setDisabled(true);
				Ext.getCmp('endhr').setDisabled(true);
			}
		}else{
			Ext.getCmp('eg_timeline').setDisabled(false);
			if(Ext.getCmp('eg_timeline').getValue() == "Any"){
				Ext.getCmp('eg_stdate').setDisabled(false);
				Ext.getCmp('starthr').setDisabled(false);
				Ext.getCmp('eg_enddate').setDisabled(false);
				Ext.getCmp('endhr').setDisabled(false);
			}
		}
	},
	changeTimeline : function(obj) {
		var getTimelineVal = Ext.getCmp('eg_timeline').getValue();
		var stDateObj = Ext.getCmp('eg_stdate');
		var endDateObj = Ext.getCmp('eg_enddate');
		var stHrObj = Ext.getCmp('starthr');
		var endHrObj = Ext.getCmp('endhr');
		
		if (getTimelineVal == 'Any') {
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
		} else {
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
		}
		if(getTimelineVal!='Any')
		{
    		var strtdt = Ext.Date.dateFormat(stDateObj.getValue(), mgrDateFormat);
    		var enddt = Ext.Date.dateFormat(endDateObj.getValue(), mgrDateFormat);
    		if (!Ext.isEmpty(obj)) {
    			var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getTime&P0='
    					+ getTimelineVal
    					+ '&P1='
    					+ encodeURIComponent(strtdt)
    					+ '&P2='
    					+ encodeURIComponent(enddt)
    					+ '&P3='
    					+ stHrObj.getValue()
    					+ '&P4='
    					+ endHrObj.getValue()
    					+ '&P5=' + encodeURIComponent(currentDateFormat);
    			var me = this;
    			Ext.Ajax.request({
					url : '/final/servlet/com.eg.RemoteScriptingServlet',
					params : param,
					timeout:300000,
					success : function(response) {
					var formdata = Ext.decode(response.responseText);
					/*stDateObj.setValue(formdata[0]);
					endDateObj.setValue(formdata[1]);
					stHrObj.setValue(formdata[2]);
					endHrObj.setValue(formdata[3]);*/

					stDateObj.dataArray = formdata[0];
					endDateObj.dataArray = formdata[1];
					stHrObj.dataArray = formdata[2];
					endHrObj.dataArray = formdata[3];

					stDateObj.setValue(formdata[6]);
					endDateObj.setValue(formdata[7]);
					stHrObj.setValue(formdata[8]);
					endHrObj.setValue(formdata[9]);
					//params = form.findField('eg_timeline').getValue();
					//alert(params);
					Ext.Ajax.request({
						url : '/final/monitor/EgTimeSelect.jsp?time_line='+getTimelineVal,
						timeout:300000,
						success : function(response) {
							var formdata = Ext.decode(response.responseText);
							me.dbStartDate = formdata.hiddenFields.dbstrtdate;
							me.dbEndDate = formdata.hiddenFields.dbenddate;
						}
					});
					}
				});
    		}
		}
	},
	reloadComboStore:function(fieldName,data){
		var formField = filterForm.findField(fieldName);
		if(!Ext.isEmpty(data))
		{
			formField.getStore().getProxy().data = data;
			formField.getStore().load();
		}
		this.loadComboField(formField);
		return formField;
	},
	loadComboField:function(thisObj){															// Prem
		var value = thisObj.getStore().data;
		thisObj.setValue(value.first());
	},
	loadFields:function(thisObj,records){		
		var me = this;
		var filterPanel = thisObj.up('historyfilters');
		filterForm = filterPanel.getForm();
		var moreFilterForm = Ext.getCmp('more-filter-options-panel');
		var moreFiltersForm = Ext.getCmp('more-filter-options-panel').getForm();
    	if(thisObj.name == 'compTypeList' || thisObj.name =='compNameList')
    	{
    		moreFiltersForm.findField('layers').setVisible(false);
    	}
		var requestParams = Ext.Object.merge(filterForm.getValues(),moreFilterForm.getValues());
		var requestURL = 'EgAlarmHistoryFrame.jsp';
		if(thisObj.name == 'eventfor' && records[0].data.displayField == 'Component'){
			requestURL = 'EgAlarmHistoryFrame.jsp?newAlarms=true&eg_tbound=Fixed';
			requestParams = null;
			filterForm.findField('event_select').setDisabled(true);
			filterForm.findField('event_select').setVisible(false);
		}
		if(thisObj.name == 'eventfor' && records[0].data.displayField != 'Zone'){
			filterForm.findField('includeSubZone').setDisabled(true);
			filterForm.findField('includeSubZone').setVisible(false);
		}
		if(!Ext.isEmpty(monitor.HistorySummary.filterData) || thisObj.name == 'compNameList' || thisObj.name == 'state')
			return;
		Ext.Ajax.request({
			url:requestURL,
			timeout:300000,
			async:true,
			params:requestParams,
			success:function(response){
				var json = Ext.decode(response.responseText);
				if(!Ext.isEmpty(requestParams)){
					if(thisObj.name == 'eventfor' && json.event_select_Ind == 'true'){
						var subEventField = me.reloadComboStore('event_select',json);
						subEventField.setDisabled(false);
						subEventField.setVisible(true);
						if(json.includeSubZone_Ind == "true"){
							var includeZoneField = filterForm.findField('includeSubZone');
							includeZoneField.setDisabled(false);
							includeZoneField.setVisible(true);
						}
						me.reloadComboStore('compTypeList',json);
					}
					else if(thisObj.name == 'event_select'){
						me.reloadComboStore('compTypeList',json);
					}
					else if (thisObj.name == 'includeSubZone' && filterForm.findField('includeSubZone').getValue() != null)
					{
						me.reloadComboStore('compTypeList',json);
					}
				}
				else{
					me.reloadComboStore('eventfor',json);
					me.reloadComboStore('compTypeList',json);
				}
				me.reloadComboStore('compNameList',json);
				filterPanel.updateLabels(json.screenLabels);
				if(thisObj.getValue() == 'Zone')
				{
					var includeZoneField = filterForm.findField('includeSubZone');
					includeZoneField.setValue('Yes');
				}
				var dashboardcomptype = filterForm.findField("compTypeList").getValue();
				var dashboardcompname = filterForm.findField("compNameList").getValue();
				moreFiltersForm.findField('dashboardcomptype').setValue(dashboardcomptype);
				moreFiltersForm.findField('dashboardcompname').setValue(dashboardcompname);
			}
		});
	},
	loadComboFieldSelectedVal: function(btn, e, opts)
	{
		var me = this;
		var filterPanel = btn.up('historyfilters');
		var jsonData = monitor.HistorySummary.filterData;
		if(!Ext.isEmpty(jsonData))
		{
			var thisForm = btn.up('form').getForm();
			var compName = jsonData.compNameList_value;
			if(compName != null && compName != 'undefined' && compName.indexOf(':NULL')>0)
			{
				compName = compName.substring(0,compName.indexOf(':NULL'));
			}
			me.setValueWithOptionInList(thisForm, 'compTypeList', jsonData.compTypeList, jsonData.compTypeList_value);
			me.setValueWithOptionInList(thisForm, 'compNameList', jsonData.compNameList, compName);
			me.setValueWithOptionInList(thisForm, 'state', jsonData.state, jsonData.state_value);
			me.setValueWithOptionInList(thisForm, 'eventfor', jsonData.eventfor, jsonData.eventfor_value);
			if(!Ext.isEmpty(jsonData.includeSubZone_value))
				me.setValueWithOptionInList(thisForm, 'includeSubZone', jsonData.includeSubZone, jsonData.includeSubZone_value);
			if(!Ext.isEmpty(jsonData.event_select_value))
				me.setValueWithOptionInList(thisForm, 'event_select', jsonData.event_select, jsonData.event_select_value);

			if(startTimeUrl != null && endTimeUrl != null && startTimeUrl != "null" && endTimeUrl != "null")
			{
				var startDate = startTimeUrl.substring(0,startTimeUrl.lastIndexOf(" "));
				var startTime = startTimeUrl.substring(startTimeUrl.lastIndexOf(" ")+1);
				var endDate = endTimeUrl.substring(0,endTimeUrl.lastIndexOf(" "));
				var endTime = endTimeUrl.substring(endTimeUrl.lastIndexOf(" ")+1);
				var moreFilterForm = Ext.getCmp('more-filter-options-panel').getForm();
				moreFilterForm.findField('eg_timeline').setValue("Any");
				moreFilterForm.findField('eg_stdate').setValue(startDate);
				moreFilterForm.findField('eg_stdate').enable();
				moreFilterForm.findField('eg_enddate').setValue(endDate);
				moreFilterForm.findField('eg_enddate').enable();
				var startHr = startTime.substring(0,startTime.indexOf(":"));
				var startMin = startTime.substring(startTime.indexOf(":")+1,startTime.lastIndexOf(":"));
				if(startHr.indexOf(0) == 0)
					startHr = startHr.substring(1);
				if(startMin.indexOf(0) == 0)
					startMin = startMin.substring(1);
				moreFilterForm.findField('starthr').setValue(startHr);
				moreFilterForm.findField('starthr').enable();
				var endHr = endTime.substring(0,endTime.indexOf(":"));
				var endMin = endTime.substring(endTime.indexOf(":")+1,endTime.lastIndexOf(":"));
				if(endHr.indexOf(0) == 0)
					endHr = endHr.substring(1);
				if(endMin.indexOf(0) == 0)
					endMin = endMin.substring(1);
				moreFilterForm.findField('endhr').setValue(endHr);
				moreFilterForm.findField('endhr').enable();
				moreFilterForm.findField('startmin').setValue(startMin);
				moreFilterForm.findField('startmin').enable();
				moreFilterForm.findField('endmin').setValue(endMin);
				moreFilterForm.findField('endmin').enable();
			}
			filterPanel.updateLabels(jsonData.screenLabels);
		}		
	},
	saveInPDFFormat:function(btn, e, opts)
	{
		var moreFiltersForm = Ext.getCmp('more-filter-options-panel').getForm();
		var me = this;
		var historySummary = this.getHistorySummary();
		var thisForm = btn.up('form').getForm();
		var v_event = thisForm.findField('eventfor').getValue();
		var subevent=null;
		var selectedsubzone=null;

		if(v_event!=null && v_event!="" && (v_event=='Service' || v_event=='Zone' || v_event=='Segment'))
			subevent=thisForm.findField('event_select').getValue();
		if(subevent!=null && subevent!="" && v_event=='Zone')
			selectedsubzone = thisForm.findField('includeSubZone').getValue();
		var ctype = thisForm.findField('compTypeList').getValue();
		var cname = thisForm.findField('compNameList').getValue();
		var st = thisForm.findField('state').getValue();
		var dur = moreFiltersForm.findField('duration').getValue();
		var ts = moreFiltersForm.findField('timeselect').getValue();
		var cond = moreFiltersForm.findField('glduration').getValue();
		var tline = moreFiltersForm.findField('eg_timeline').getValue();
		var stdate = moreFiltersForm.findField('eg_stdate').getRawValue();
		var enddate = moreFiltersForm.findField('eg_enddate').getRawValue();
		var sthr = moreFiltersForm.findField('starthr').getValue();
		var endhr = moreFiltersForm.findField('endhr').getValue();
		var showCurrentStr = Ext.getCmp('current').checked;

		var stmin = "00";
		try
		{
			stmin = moreFiltersForm.findField('startmin').getValue();
		}
		catch (e)
		{
			stmin = "00";
		}
			
		var endmin ="00"; 
		try
		{
			endmin = moreFiltersForm.findField('endmin').getValue();
		}
		catch (e)
		{
			endmin ="00"; 
		}

		var arrAlarms = moreFiltersForm.findField('sortBy').getValue();
		//var arrAlarms = null;
		var ackValue= moreFiltersForm.findField('showacknowledge').getValue();
		var eventsPerPage = moreFiltersForm.findField('eventsPerPage').getValue();
		
		var profileName = moreFiltersForm.findField('profileName').getValue();
		var fromDashBoard = moreFiltersForm.findField('fromDashBoard').getValue();
		var selectedLayer = moreFiltersForm.findField('selectedLayer').getValue();
		var tab = moreFiltersForm.findField('tab').getValue();
		var dashboardcomptype = moreFiltersForm.findField('dashboardcomptype').getValue();
		var dashboardcompname = moreFiltersForm.findField('dashboardcompname').getValue();
		var from_page = moreFiltersForm.findField('from_page').getValue();
		var insideview_info = moreFiltersForm.findField('insideview_info').getValue();
		var Layer = moreFiltersForm.findField('Layer').getValue();
		var NoComponentsSelected = moreFiltersForm.findField('NoComponentsSelected').getValue();
		//var infosearch = moreFiltersForm.findField('infosearch').getValue();
		var infosearch="";
		var infosearchDes = moreFiltersForm.findField('infosearch').getValue();
		var triggerId= Ext.getCmp('triggerId').getValue();
		if(triggerId!=null && triggerId!=undefined && triggerId!="" && triggerId!="null")
			infosearch=triggerId;
		else if(infosearchDes!=null && infosearchDes!=undefined && infosearchDes!="" && infosearchDes!="null")
			infosearch=infosearchDes;
		
		var compsearch = moreFiltersForm.findField('compsearch').getValue();
		var showUsers = "";

        if (moreFiltersForm.showuser != null && moreFiltersForm.showuser != 'undefined' && moreFiltersForm.showuser != undefined) showUsers = moreFiltersForm.showuser.value;
			showUsers = moreFiltersForm.findField('showuser').getValue();				// Prem
		
		if(cond!=null && cond=='<')
		{
			dur = -dur;
		} else if(cond)
		{
			dur = "0" + dur;
		}
		if(cname!=null && cname!=undefined && cname.length>0)
		{
			cname=cname.replace('&','|amp|');
		}
		var paramValue=null;
		if(selectedArrangeOption!=null)
			arrAlarms = selectedArrangeOption;

		paramValue="newAlarms=true&v_event="+v_event+"&subevent="+subevent+"&selectedsubzone="+selectedsubzone+"&compTypeList="+encodeURI(ctype)+"&compNameList="+encodeURI(cname)+"&state="+st+"&duration="+dur+"&timeselect="+ts+"&eg_timeline="+tline+"&showacknowledge="+ackValue+"&showuser="+showUsers;
		if(tline == "Any")
		{
			//paramValue = paramValue + "&eg_stdate=" + stdate + "&eg_enddate=" + enddate + "&starthr=" + sthr + "&endhr=" + endhr + "&startmin=" + stmin +"&endmin=" + endmin + "&glduration=" + cond;

			paramValue = paramValue + "&eg_stdate=" + stdate + "&eg_enddate=" + enddate + "&starthr=" + sthr + "&endhr=" + endhr + "&startmin=00&endmin=00&glduration=" + cond;
		}
		paramValue=paramValue+"&profileName="+profileName
					+"&fromDashBoard="+fromDashBoard
					+"&selectedLayer="+selectedLayer
					+"&tab="+tab
					+"&dashboardcomptype="+dashboardcomptype
					+"&dashboardcompname="+dashboardcompname
					+"&from_page="+from_page
					+"&insideview_info="+encodeURIComponent(parent.filterEncode(insideview_info))
					+"&Layer="+Layer
					+"&NoComponentsSelected="+NoComponentsSelected
					+"&infosearch="+infosearch										// Prem
					+"&compsearch="+compsearch									// Prem
					+"&searchAll=true";										
		if(eventsPerPage == 'All')													// Prem
			eventsPerPage = me.getHistorySummaryStore().totalCount;					// Prem

		paramValue += '&limit='+eventsPerPage;
		if(!Ext.isEmpty(alertTest) && alertTest != null && alertTest != undefined)
			paramValue += "&alertTest="+alertTest;

		if(selectedArrangeOption!=null)
		{
			paramValue += '&arrangeAlarms='+selectedArrangeOption;
			if(orderBy!=null)
				paramValue += '&orderby='+orderBy;
		}
		paramValue += '&showEventHistory='+showEventHistory;
		if(showCurrentStr)
			paramValue += '&showCurrent='+showCurrentStr;
		urlForPDF = paramValue ;

		//var	win=null;
		if(this.getHistorySummary().getStore().getCount() > 0 || (!showEventHistory && this.getHistorySummary().getStore().getRootNode().childNodes.length > 0))
		{
			var	blankPage =	"";
			var s_qryString = "/final/servlet/com.eg.EgPdfDownloadC?from=histAlarm";
			if(urlForPDF!=null)
				s_qryString= s_qryString +"&"+urlForPDF;

			var progressBar = Ext.MessageBox.progress({
								title: 'Downloading',
								value: 5,
								width: 350,
								increment: 15,
								closable: false,
								progressText: 'Connecting..',
								wait: true,
								waitConfig: {
									interval: 200
								},
								msg: '<b>Downloading, please wait...</b>',
								scope: this,
								handler: function () {
									this.updateText('Done!');
								}
							//	buttons: Ext.MessageBox.CANCEL
							});
										
				var iFrameExists = Ext.query("#pdfIframe");

				if(Ext.isEmpty(iFrameExists))
				{
					Ext.DomHelper.append(document.body, {
						tag: 'iframe',
						frameBorder: 0,
						width: 0,
						height: 0,
						css: 'display:none;visibility:hidden;height:1px;',
						src: s_qryString,
						id: 'pdfIframe'
					});
				}
				else
				{
					Ext.select('#pdfIframe').set( { src :  s_qryString });
				}

				Ext.Ajax.request(
				{
					url : '/final/monitor/EgSaveStatus.jsp?downloadFile=true',
					scope:this,
					timeout:300000,
					success: function(response){
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData))
						{
							var downloadStatus = jsonData.downloadStatus;
							try
							{
								if(downloadStatus=='DONE' || downloadStatus == 'done' || downloadStatus=='Done')
								{
									progressBar.hide();
								}
							}
							catch (e)
							{
								progressBar.hide();
							}
							
						}
					},
					failure:function(response){
						progressBar.hide();
					}
				});																	// Prem
		}
		else
		{
			Ext.MessageBox.show({
							title: 'ALERT',
							msg: "No Alarm Found",
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
			return false;
		}
	},
	showAlarms : function(btn, e, opts){
		
		if(!Ext.isEmpty(btn) && btn.id=="UpdateSettings"){
			btn = this.getHistoryfilterscategory();
			//Ext.get('configMod').animate({duration: 500,to: {y: -350}});
		}

		if(e!='')
		{
			currentPageNo = 1;
			var disp = Ext.getCmp("displayInfo");
			var endInx = parseInt(pageCount)*parseInt(currentPageNo);
			var startInx = endInx- parseInt(pageCount);
			if(recCount<endInx)
				endInx = recCount;
			var msg = historyDockedDisplaying+" "+(startInx+1)+"-"+endInx+" "+historyDockedOf+" "+recCount;
			disp.setText(msg);
			
			var first = Ext.getCmp("pfirst");
			var prev = Ext.getCmp("pprev");
			first.disabled=true;
			prev.disabled=true;
			if(parseInt(totalRecords)>currentPageNo)
			{
				var next = Ext.getCmp("pnext");
				var last = Ext.getCmp("plast");
				next.disabled=false;
				last.disabled=false;
			}
		}

		var reloadGrid = Ext.getCmp('historysummary');
		reloadGrid.store.sorters.clear();
		reloadGrid.view.refresh();
		orderBy = null;
		selectedArrangeOption = null;
		var moreFiltersForm = Ext.getCmp('more-filter-options-panel').getForm();
		var me = this;
		var historySummary = this.getHistorySummary();
		//var loader = new Ext.LoadMask(Ext.getCmp('main'),{msg:'Loading...'});
		var loader = new Ext.LoadMask(Ext.getBody(),{msg:'Loading...'});
		//loader.show();
		//me.getHistoryFilters().findComponents('EgAlarmHistoryFrame.jsp', 'Post', btn.up('form').getForm(), false);
		
		var thisForm = btn.up('form').getForm();
		
		var v_event = thisForm.findField('eventfor').getValue();
		var subevent=null;
		var selectedsubzone=null;

		if(v_event!=null && v_event!="" && (v_event=='Service' || v_event=='Zone' || v_event=='Segment'))
			subevent=thisForm.findField('event_select').getValue();
		if(subevent!=null && subevent!="" && v_event=='Zone')
			selectedsubzone = thisForm.findField('includeSubZone').getValue();
		var ctype = thisForm.findField('compTypeList').getValue();
		var cname = thisForm.findField('compNameList').getValue();
		var st = thisForm.findField('state').getValue();
		var dur = moreFiltersForm.findField('duration').getValue();
		var ts = moreFiltersForm.findField('timeselect').getValue();
		var cond = moreFiltersForm.findField('glduration').getValue();
		var tline = moreFiltersForm.findField('eg_timeline').getValue();
		var stdate = moreFiltersForm.findField('eg_stdate').getRawValue();
		var real_stdate = moreFiltersForm.findField('eg_stdate').dataArray;
		var enddate = moreFiltersForm.findField('eg_enddate').getRawValue();
		var real_enddate = moreFiltersForm.findField('eg_enddate').dataArray;
		var sthr = moreFiltersForm.findField('starthr').getValue();
		var real_sthr = moreFiltersForm.findField('starthr').dataArray;
		var stmin = moreFiltersForm.findField('startmin').getValue();
		var real_stmin = moreFiltersForm.findField('startmin').dataArray;
		var endhr = moreFiltersForm.findField('endhr').getValue();
		var real_endhr = moreFiltersForm.findField('endhr').dataArray;
		var endmin = moreFiltersForm.findField('endmin').getValue();
		var real_endmin = moreFiltersForm.findField('endmin').dataArray;
		var ackValue= moreFiltersForm.findField('showacknowledge').getValue();
		var eventsPerPage = moreFiltersForm.findField('eventsPerPage').getValue();
		
		var profileName = moreFiltersForm.findField('profileName').getValue();
		var fromDashBoard = moreFiltersForm.findField('fromDashBoard').getValue();
		var selectedLayer = moreFiltersForm.findField('selectedLayer').getValue();
		var tab = moreFiltersForm.findField('tab').getValue();
		var dashboardcomptype = moreFiltersForm.findField('dashboardcomptype').getValue();
		var dashboardcompname = moreFiltersForm.findField('dashboardcompname').getValue();
		var from_page = moreFiltersForm.findField('from_page').getValue();
		var insideview_info = moreFiltersForm.findField('insideview_info').getValue();
		var Layer = moreFiltersForm.findField('layers').getValue();
		var NoComponentsSelected = moreFiltersForm.findField('NoComponentsSelected').getValue();
		showCurrent = Ext.getCmp('current').checked;
		
		var infosearch="";
		var infosearchDes = moreFiltersForm.findField('infosearch').getValue();
		Ext.getCmp('triggerId').setValue(infosearchDes);
		var triggerId= Ext.getCmp('triggerId').getValue();
		if(triggerId!=null && triggerId!=undefined && triggerId!="" && triggerId!="null")
			infosearch=triggerId;
		else if(infosearchDes!=null && infosearchDes!=undefined && infosearchDes!="" && infosearchDes!="null")
			infosearch=infosearchDes;
		
		var compsearch = moreFiltersForm.findField('compsearch').getValue();
		var showUsers = "";
		selectedArrangeOption = moreFiltersForm.findField('sortBy').getValue();
        if (moreFiltersForm.showuser != null && moreFiltersForm.showuser != 'undefined' && moreFiltersForm.showuser != undefined) showUsers = moreFiltersForm.showuser.value;
			showUsers = moreFiltersForm.findField('showuser').getValue();

		// Fix to validate duration text box
		if( dur == null || dur == undefined || dur.trim() == "" || dur % 1 != 0 || dur < 0 ) 
		{
			Ext.MessageBox.show({
				title : 'Alert',
				msg : 'Invalid value for Duration',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
				});
			return false;
		}
		
		var filterPanel = btn.up('historyfilters');
		filterForm = filterPanel.getForm();
		
		var cTypelen = 0;
		if(filterForm!=null && filterForm!=undefined && filterForm!="null" && filterForm!="undefined")
			cTypelen = filterForm.findField('compTypeList').getStore().getCount();
		
		if(cTypelen == 1 && (ctype=='-1' || ctype=='Component type (Optional)'))
		{
			Ext.MessageBox.show({
			title: 'Alert',
			msg: "No Components found",
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		
		if(cond!=null && cond=='<')
		{
			dur = -dur;
		} else if(cond)
		{
			dur = "0" + dur;
		}
		if(cname!=null && cname!=undefined && cname.length>0)
		{
			cname=cname.replace('&','|amp|');
		}
		var paramValue=null;
		
		if(showUsers==null || showUsers=="null")
			showUsers="";

		
	
		paramValue="newAlarms=true&v_event="+v_event+"&subevent="+subevent+"&selectedsubzone="+selectedsubzone+"&compTypeList="+encodeURI(ctype)+"&compNameList="+encodeURI(parent.filterEncode(cname))+"&state="+st+"&duration="+dur+"&timeselect="+ts+"&eg_timeline="+tline+"&showacknowledge="+ackValue+"&showuser="+showUsers;
		paramValue+="&pageNo="+currentPageNo+"&sortby="+selectedArrangeOption;

		
		if(tline == "Any")
		{
			var start_time = Ext.getCmp('eg_stdate').value;
			var end_time = Ext.getCmp('eg_enddate').value;
			var start_hr = parseInt(Ext.getCmp('starthr').value);
			var end_hr = parseInt(Ext.getCmp('endhr').value);
			start_time = Ext.Date.format(start_time, 'm/d/Y');
			end_time = Ext.Date.format(end_time, 'm/d/Y');
			
			if(start_time != null && start_time != "" && end_time != null && end_time != "" && new Date(start_time) > new Date(end_time))
			{
				
				Ext.MessageBox.show({
				title: 'Alert',
				msg: "Start date should be lesser than end date",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(start_time != null && start_time != "" && end_time != null && end_time != "" && new Date(start_time) >= new Date(end_time) && start_hr != null && start_hr != "" && end_hr != null && end_hr != "" && start_hr >= end_hr)
			{
				Ext.MessageBox.show({
				title: 'Alert',
				msg: "Start hour should be lesser than end hour",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			
			//paramValue = paramValue + "&eg_stdate=" +  stdate + "&eg_enddate=" + enddate + "&starthr=" + sthr + "&startmin=" + stmin +"&endmin=" + endmin +"&endhr=" + endhr + "&glduration=" + cond;

			paramValue = paramValue + "&eg_stdate=" +  stdate + "&eg_enddate=" + enddate + "&starthr=" + sthr + "&startmin=00&endmin=00&endhr=" + endhr + "&glduration=" + cond;
		}
		
		var VWidth = Ext.Element.getViewportWidth( );
		var container=Ext.getCmp('configMod');
		var containerPosition = VWidth - (container.width + 15);
		Ext.create('Ext.fx.Anim', {
			target: container,
			duration: 500,
			from: {
				left:containerPosition,
				top:40
			},
			to: {
			   top:-500,
			   left: containerPosition
			},
			callback: function(){
				container.hide();
			}
		});

		var infoRandomNo ;
	
			infoRandomNo = Math.random();
			paramValue = paramValue+"&infoRandom="+infoRandomNo;

			 
		infosearch = parent.filterEncode(infosearch);
		infosearch = encodeURIComponent(infosearch);

		loader.show();
		paramValue=paramValue+"&profileName="+profileName
					+"&fromDashBoard="+fromDashBoard
					+"&selectedLayer="+Layer
					+"&tab="+tab
					+"&dashboardcomptype="+dashboardcomptype
					+"&dashboardcompname="+dashboardcompname
					+"&from_page="+from_page
					+"&insideview_info="+encodeURIComponent(parent.filterEncode(insideview_info))
					+"&Layer="+Layer
					+"&NoComponentsSelected="+NoComponentsSelected
					+"&infosearch="+infosearch
					+"&compsearch="+compsearch
					+"&arrangeAlarms="+selectedArrangeOption
					+'&showEventHistory='+showEventHistory
					+'&searchAll=true';
		if(eventsPerPage == 'All')
			eventsPerPage = me.getHistorySummary().getStore().totalCount;
		paramValue += '&limit='+eventsPerPage;
		if(showCurrent)
			paramValue +='&showCurrent='+showCurrent;
		Ext.Ajax.request({
			url : '/final/servlet/com.egurkha.monitor.alarms.AlarmHistoryServlet?'+paramValue+"&ddTimeAlt=true&dontSetSession=true",
			timeout:300000,
			async:true,
			//scope:this.getHistorySummary(),
		    success: function(response){


		//Ajax Request For Count TotalRecords...

		Ext.Ajax.request
		(
			{
				url : '/final/servlet/com.egurkha.monitor.alarms.AlarmHistoryServlet?'+paramValue+"&count=true&ddTimeAlt=true&dontSetSession=true",
				async:true,
				success: function(response)
					{
					var jsonText = response.responseText;	
					var ttlPages;
					jsonText = jsonText.substring(0,jsonText.indexOf("|"));								
					if(jsonText.indexOf("^")>=0)
						{
						pageCount = jsonText.substring(0,jsonText.indexOf("^"));						
						ttlPages = jsonText.substring((jsonText.indexOf("^")+1),jsonText.lastIndexOf("^")).trim();						
						recCount = jsonText.substring((jsonText.lastIndexOf("^")+1)).trim();
						}
						else
							ttlPages = jsonText.trim();
					totalRecords = ttlPages;
					//var comp = Ext.getCmp("paginationTotals");					
					var ptot = Ext.getCmp("paginationTotals");
					var comp = Ext.getCmp("totalPg");
					ptot.setValue(currentPageNo);
					totalRecords = ttlPages; 
					if(parseInt(totalRecords)==currentPageNo)
					{
						var next = Ext.getCmp("pnext");
						var last = Ext.getCmp("plast");
						next.disabled=true;
						last.disabled=true;
					}
					else
					{
						var next = Ext.getCmp("pnext");
						var last = Ext.getCmp("plast");
						next.disabled=false;
						last.disabled=false;
					}					
					var displayInfo = Ext.getCmp("displayInfo");
					comp.setText(" "+historyDockedOf+" "+ttlPages);
					if(totalRecords==0)
					{					
						displayInfo.setText(" ");
						var dPage= Ext.getCmp("dockedPagnation");
						dPage.setVisible(false);					
					}
					else
					{			
						var endInx = parseInt(pageCount)*parseInt(currentPageNo);
						var startInx = endInx- parseInt(pageCount);
						if(recCount<endInx)
							endInx = recCount;
						var msg = historyDockedDisplaying+" "+(startInx+1)+"-"+endInx+" "+historyDockedOf+" "+recCount;
						displayInfo.setText(msg);
						var dPage= Ext.getCmp("dockedPagnation");
						dPage.setVisible(true);					
					}					
					}
			}
		);


				//
			
		        var jsonText = response.responseText;
		        var jsonData=Ext.decode(jsonText);
				me.dataArray = jsonData;
				var noAlaramFound = jsonData.history.length;
				//if(noAlaramFound==0)
					//Ext.getCmp('triggerId').hide();
				//else
				Ext.getCmp('triggerId').show();
				me.getHistorySummary().getStore().pageSize = jsonData.eventsPerPage;
		        me.getHistorySummary().getStore().getProxy().data = jsonData;
				me.getHistorySummary().getStore().load();
				
				//me.getHistorySummary().getStore().loadPage(1);
		
				if(!showEventHistory && (!hasVMs || hasVMs == 'false'))
				{
					me.getHistorySummary().getStore().getProxy().data = jsonData.history;
					me.getHistorySummary().suspendEvents();
					me.getHistorySummary().setRootNode(jsonData.history);
					me.getHistorySummary().resumeEvents();
					me.getHistorySummary().view.refresh();
				}
				var showCurrent = Ext.getCmp('current').checked;
				if(Ext.isEmpty(jsonData.history))
				{
					//Ext.getCmp('errorpanel').show();
					//Ext.getCmp('historysummary').hide();
					
				}
				else
				{
					loader.hide();
					if(!Ext.isEmpty(showEventIdFlag) && !showEventIdFlag){
						if(jsonData.enableDD == 'false')
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.hideSpecificColumn("ddparams");
						}
						else
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.showSpecificColumn("ddparams");
						}
						if(jsonData.enableUser == 'false')
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.hideSpecificColumn("users");
						}
						else
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.showSpecificColumn("users");
						}
						if(jsonData.enableLogon == 'false')
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.hideSpecificColumn("Logon_Details_Support");
						}
						else
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.showSpecificColumn("Logon_Details_Support");
						}
						if(jsonData.enableConfig == 'false')
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.hideSpecificColumn("COLUMN_Config_url");
						}
						else
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.showSpecificColumn("COLUMN_Config_url");
						}
						if(jsonData.enableScreenShot == 'false')
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.hideSpecificColumn("screenshot");
						}
						else
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.showSpecificColumn("screenshot");
						}
						if(jsonData.isShowZones == 'false')
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.hideSpecificColumn("ZoneName");
						}
						else
						{
							Ext.getCmp('historysummary').show();
							//Ext.getCmp('errorpanel').hide();
							me.showSpecificColumn("ZoneName");
						}
						if(jsonData.isSuperManager) {
							me.showSpecificColumn("mgrid");
						}
						else {
							me.hideSpecificColumn("mgrid");
						}
					}
					else{
						if(typeof showSeverityColumn != 'undefined' && showSeverityColumn){
							if(jsonData.enableDD == 'false')
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.hideSpecificColumn("ddparams");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.showSpecificColumn("ddparams");
							}
							if(jsonData.enableUser == 'false')
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.hideSpecificColumn("users");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.showSpecificColumn("users");
							}
							if(jsonData.enableLogon == 'false')
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.hideSpecificColumn("Logon_Details_Support");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.showSpecificColumn("Logon_Details_Support");
							}
							if(jsonData.enableConfig == 'false')
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.hideSpecificColumn("COLUMN_Config_url");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.showSpecificColumn("COLUMN_Config_url");
							}
							if(jsonData.enableScreenShot == 'false')
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.hideSpecificColumn("screenshot");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.showSpecificColumn("screenshot");
							}
							if(jsonData.isShowZones == 'false')
							{
								Ext.getCmp('historysummary').show();
								me.hideSpecificColumn("ZoneName");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								me.showSpecificColumn("ZoneName");
							}
							if(jsonData.isSuperManager) {
								me.showSpecificColumn("mgrid");
							}
							else {
								me.hideSpecificColumn("mgrid");
							}
						}else{
							if(jsonData.enableDD == 'false')
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.hideSpecificColumn("ddparams");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.showSpecificColumn("ddparams");
							}
							if(jsonData.enableUser == 'false')
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.hideSpecificColumn("users");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.showSpecificColumn("users");
							}
							if(jsonData.enableLogon == 'false')
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.hideSpecificColumn("Logon_Details_Support");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.showSpecificColumn("Logon_Details_Support");
							}
							if(jsonData.enableConfig == 'false')
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.hideSpecificColumn("COLUMN_Config_url");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.showSpecificColumn("COLUMN_Config_url");
							}
							if(jsonData.enableScreenShot == 'false')
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.hideSpecificColumn("screenshot");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								//Ext.getCmp('errorpanel').hide();
								me.showSpecificColumn("screenshot");
							}
							if(jsonData.isShowZones == 'false')
							{
								Ext.getCmp('historysummary').show();
								me.hideSpecificColumn("ZoneName");
							}
							else
							{
								Ext.getCmp('historysummary').show();
								me.showSpecificColumn("ZoneName");
							}
							if(jsonData.isSuperManager) {
								me.showSpecificColumn("mgrid");
							}
							else {
								me.hideSpecificColumn("mgrid");
							}
						}
					}
					if(jsonData.showServicesColumn == 'false'){
						Ext.getCmp('historysummary').show();
						me.hideSpecificColumn("services");
					}else{
						Ext.getCmp('historysummary').show();
						me.showSpecificColumn("services");
					}
					if(!showCurrent || !isAllowAckDeleteAlarms){
						me.getHistorySummary().columns[0].hide();
						Ext.ComponentQuery.query('[itemId="ackDelToolbar"]')[0].hide();
					}else {
						me.getHistorySummary().columns[0].show();
						Ext.ComponentQuery.query('[itemId="ackDelToolbar"]')[0].show();
						Ext.ComponentQuery.query('[itemId="metricsAcknowledge"]')[0].hide();
						Ext.ComponentQuery.query('[itemId="metricsDelete"]')[0].hide();
						if(isAcknowledgeAllowed)
							Ext.ComponentQuery.query('[itemId="metricsAcknowledge"]')[0].show();
						if(isDeleteAllowed)
							Ext.ComponentQuery.query('[itemId="metricsDelete"]')[0].show();
					}
				}
				
				var screenLabels=jsonData.screenLabels;
				if(!Ext.isEmpty(jsonData.screenLabels)){
					this.screenLabels=jsonData.screenLabels;
					//me.getHistorySummary().updateLabels(screenLabels);
				}
				loader.hide();
				me.getHistorySummary().doLayout();
				Ext.ComponentQuery.query('[itemId="metricsLabel"]')[0].setText((showCurrent)?"<span class='iconFullTime' style='margin-right: 5px;display: inline-block;'></span>Showing Current Events":"<span class='iconFullTime' style='margin-right: 5px;display: inline-block;'></span>Showing Last "+tline,false);
		    }
		});
		
		setSession(activeView,showCurrent);
		//me.getHistorySummary().getStore().getProxy().url = '/final/servlet/com.egurkha.monitor.alarms.AlarmHistoryServlet?'+paramValue;
		//me.getHistorySummary().getStore().load();
	},
	clickDetailedDiagnosis:function(grid,cellElement,rowIndex,columnIndex,event,record){
		if(!Ext.isEmpty(record.get("ddparams"))){
			var parameters = record.get("ddparams").url;
			parameters += '&popup=true&fromPage=eveHist&newWindow=true';
			var subParam = record.get("ddparams").subParam;
			var popUp = record.get("ddparams").popup_selection;
			/*Ext.Ajax.request({
				url:'/final/monitor/EgDiagnosis.jsp',
				params:parameters,
				success:function(response){
					Ext.create('Ext.window.Window',{
						title:'Detailed Diagnosis',
						html:response.responseText,
						width:1012,
						height:603,
						modal:true,
						closeAction:'destroy',
						cls:'history-window'
					}).show();
				},
				failure:function(responseCode){
				}
			});*/
			//var jsp = "/final/monitor/EgDiagnosis.jsp?";
			//var jsp = "/final/monitor/EventsGraph.jsp?pageToShow=diagnosis&url=EgDiagnosis.jsp?";
			var title = "DIAGNOSIS";

			//var winPopup = window.open(jsp + parameters + "&popup=true&fromPage=eveHist&newWindow=true", title, 'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
			var winPopup = window.openWindow(parameters + "&popup=true&fromPage=eveHist&newWindow=true", title, 'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
		}
	},
	clickGraph:function(grid,cellElement,rowIndex,columnIndex,event,record){
		var jsp = '';
		var title = "GRAPHS";
		var parameters = record.get("graphParams").url;
		if(record.get("graphParams").subParam != 'vmgraph')
		{
			//jsp = "/final/monitor/EgGraphGenerator.jsp?";
			//jsp = "/final/monitor/EventsGraph.jsp?pageToShow=graph&url=EgGraphs.jsp?";

			if(!Ext.isEmpty(parameters))
				parameters += '&popup=true&fromPage=eveHist&newWindow=true';
			else
				parameters = 'popup=true&fromPage=eveHist&newWindow=true';
		}
		var subParam = record.get("graphParams").subParam;
		var popUp = record.get("graphParams").popup_selection;

		

		//var winPopup = window.open(jsp + parameters, title, 'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
		var winPopup = window.openWindow(parameters, title, 'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=yes');

		/*Ext.Ajax.request({
				url:'/final/monitor/EgGraphGenerator.jsp',
				params:parameters,
				success:function(response){
					Ext.create('Ext.window.Window',{
						title:'Graph',
						html:response.responseText,
						width:1012,
						height:603,
						modal:true,
						closeAction:'destroy',
						cls:'history-window',
						autoScroll:true
					}).show()
				},
				failure:function(responseCode){
				}
			});
		/*function popup(thisQuery,type,check)
		{
			var newWindow = check;
			var jsp = "";
			var title = "";
			if(type == 'data')
			{
				jsp = "/final/monitor/EgGraphGenerator.jsp?";
				title = "GRAPHS";
			}
			else
			{
				jsp = "/final/monitor/EgDiagnosis.jsp?";
				title = "DIAGNOSIS";
			}
			if(newWindow!=null && newWindow!='undefined' && newWindow)
			{
				if(popwin==null)
				{
				popwin=parent.openWindow(jsp + thisQuery + "&popup=true&fromPage=eveHist&newWindow=true", title, 'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
				}
				else
				{
					if(popwin!=null)popwin.close();
					popwin=null;
					popwin=parent.openWindow(jsp + thisQuery + "&popup=true&fromPage=eveHist&newWindow=true", title, 'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
				}
			}
			else
			{
				window.location.href = jsp+thisQuery+"&fromPage=eveHist&newWindow=false";
			}

		}*/
	},
	clickFixHistory:function(grid,cellElement,rowIndex,columnIndex,event,record){
		var jsp = '';
		var title = "Fix History";
		var parameters = record.get("graphParams").url;
		if(record.get("graphParams").subParam != 'vmgraph')
		{
			if(!Ext.isEmpty(parameters))
				parameters += '&popup=true&fromPage=eveHist&newWindow=true';
			else
				parameters = 'popup=true&fromPage=eveHist&newWindow=true';
		}
		parameters = parameters.replace('&clicked=graph','&clicked=history');
		parameters += "&directClick=true";
		var subParam = record.get("graphParams").subParam;
		var popUp = record.get("graphParams").popup_selection;
		var winPopup = window.openWindow(parameters, title, 'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
	},
	goToPage:function(field,event)
	{
		if(event.button==12)
		{			
			var pNo = Ext.String.trim(field.value+"");
			if(isNaN(pNo))
			{
				Ext.Msg.alert("Validation Message","Please Enter Valid No")
				return;
			}
			else
			{				
				var disp = Ext.getCmp("displayInfo");
				currentPageNo=parseInt(pNo.trim());
				if(parseInt(totalRecords)<currentPageNo)
				{
					Ext.Msg.alert("Validation Message","Page number  should not exceed total pages");
					return;
				}
				this.showAlarms(this.getSubmitButton(),'','');
				var endInx = parseInt(pageCount)*parseInt(currentPageNo);
				var startInx = endInx- parseInt(pageCount);
				if(recCount<endInx)
					endInx = recCount;
				var msg = historyDockedDisplaying+" "+(startInx+1)+"-"+endInx+" "+historyDockedOf+" "+recCount;
				disp.setText(msg);			
			if(currentPageNo==1)
			{
				var prev = Ext.getCmp("pprev");
				var firs = Ext.getCmp("pfirst");
				prev.disabled=true;
				firs.disabled=true;
			}
			else if(currentPageNo>1)
			{
				var prev = Ext.getCmp("pprev");
				var firs = Ext.getCmp("pfirst");
				prev.disabled=false;
				firs.disabled=false;
			}
			if(parseInt(totalRecords)==currentPageNo)
			{
				var next = Ext.getCmp("pnext");
				var last = Ext.getCmp("plast");
				next.disabled=true;
				last.disabled=true;
			}
			else if(parseInt(totalRecords)>currentPageNo)
			{
				var next = Ext.getCmp("pnext");
				var last = Ext.getCmp("plast");
				next.disabled=false;
				last.disabled=false;
			}
			}
		}	
	},
	loadHistorySummaryData:function(thisObj,store,opts){										// Prem
		var me =this;
		var historySummaryGrid = this.getHistorySummary();
		if(fildata == ''){
			historySummaryGrid.hide();
			Ext.getCmp('triggerId').hide();
		}
		// Fix to show alarms if only one component type/name is managed
		var componentType = "",componentName = "",limitvalue = "",eventselectvalue = "",eventforvalue = "",state="";
		if(monitor.HistorySummary.filterData != null && monitor.HistorySummary.filterData != "" && monitor.HistorySummary.filterData != 'undefined')
		{
			componentType = monitor.HistorySummary.filterData.compTypeList_value;
			componentName = monitor.HistorySummary.filterData.compNameList_value;
			if(Ext.isEmpty(componentType)||(componentType=='undefined'||componentType==undefined||componentType=='Component type (Optional)'))
				componentType = '-1';
			if(Ext.isEmpty(componentName)||componentType==undefined||componentType=='undefined'||componentName=='Component name (Optional)')
				componentName = '-1';
			eventselectvalue = monitor.HistorySummary.filterData.event_select_value;
			eventforvalue = monitor.HistorySummary.filterData.eventfor_value;
			limitvalue = monitor.HistorySummary.filterData.eventsPerPage_value;
			state = monitor.HistorySummary.filterData.state_value;
		}
		var defaultqs ="";
		if(componentType != undefined && componentType != null)
			defaultqs += '&compTypeList='+componentType;
		
		if(componentName != undefined && componentName != null)
			defaultqs += '&compNameList='+encodeURI(componentName);
		
		if(state != undefined && state != null)		
			defaultqs += '&state='+state;
				
		if(eventforvalue != undefined && eventforvalue != null)	
			defaultqs += '&v_event='+eventforvalue;
		
		if(eventselectvalue != undefined && eventselectvalue != null)
			defaultqs +='&subevent='+eventselectvalue;
		
		if(limitvalue != undefined && limitvalue != null)
			defaultqs +='&limit='+limitvalue;
		if(showCurrent)
			defaultqs +='&showCurrent='+showCurrent;

		defaultqs +='&showacknowledge=yes';

		var queryString="";
		if(qSfromDashboard!="null")
		{
			queryString='/final/servlet/com.egurkha.monitor.alarms.AlarmHistoryServlet?newAlarms=true&eg_stdate=&eg_enddate=&'+qSfromDashboard+'&showEventHistory='+showEventHistory+"&ddTimeAlt=true";
		}
		else if(defaultqs != null)
		{
			if(startTimeUrl != null && endTimeUrl != null && startTimeUrl != "null" && endTimeUrl != "null")
			{
				var startDate = startTimeUrl.substring(0,startTimeUrl.lastIndexOf(" "));
				var startTime = startTimeUrl.substring(startTimeUrl.lastIndexOf(" ")+1);
				var endDate = endTimeUrl.substring(0,endTimeUrl.lastIndexOf(" "));
				var endTime = endTimeUrl.substring(endTimeUrl.lastIndexOf(" ")+1);
				defaultqs+="&eg_timeline=Any&eg_stdate="+startDate+"&eg_enddate="+endDate+"&starthr=0&startmin=0&endmin=59&endhr=23";
				queryString='/final/servlet/com.egurkha.monitor.alarms.AlarmHistoryServlet?newAlarms=true'+defaultqs+'&showEventHistory='+showEventHistory+"&ddTimeAlt=true";
			}
			else
				queryString='/final/servlet/com.egurkha.monitor.alarms.AlarmHistoryServlet?newAlarms=true&eg_stdate=&eg_enddate='+defaultqs+'&showEventHistory='+showEventHistory+"&ddTimeAlt=true";
		}
		else
		{
			queryString='/final/servlet/com.egurkha.monitor.alarms.AlarmHistoryServlet?newAlarms=true&eg_stdate=&eg_enddate=&showEventHistory='+showEventHistory+"&ddTimeAlt=true";
		}
		//end
		var loader = new Ext.LoadMask(historySummaryGrid,{msg:"Loading..."});
		loader.show();

		
		var infoRandomNo ;
		infoRandomNo = Math.random();
		queryString = queryString+"&infoRandom="+encodeURIComponent(infoRandomNo);
		if(!Ext.isEmpty(alertTest) && alertTest != null && alertTest != undefined)
			queryString += "&alertTest="+alertTest;

		
		Ext.Ajax.request({
			url : queryString+"&arrangeAlarms=-1&dontSetSession=true",
			scope:this,
			async:true,
			timeout:300000,
		    success: function(response){
				try
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var noAlaramFound = jsonData.history.length;
					//if(noAlaramFound==0)
						//Ext.getCmp('triggerId').hide();
					//else
					Ext.getCmp('triggerId').show();
					this.getHistorySummary().getStore().pageSize = parseInt(jsonData.eventsPerPage);
					this.getHistorySummary().getStore().getProxy().data = jsonData;
					this.getHistorySummary().getStore().load();
					if(!showEventHistory && (!hasVMs || hasVMs == 'false'))
					{
						this.getHistorySummary().getStore().getProxy().data = jsonData.history;
						this.getHistorySummary().suspendEvents();
						this.getHistorySummary().setRootNode(jsonData.history);
						this.getHistorySummary().resumeEvents();
						this.getHistorySummary().view.refresh();
					}
					if(!Ext.isEmpty(showEventIdFlag) && !showEventIdFlag){
						if(jsonData.enableDD == 'false')
								this.hideSpecificColumn("ddparams");
						if(jsonData.enableUser == 'false')
								this.hideSpecificColumn("users");
						if(jsonData.enableLogon == 'false')
								this.hideSpecificColumn("Logon_Details_Support");
						if(jsonData.enableConfig == 'false')
								this.hideSpecificColumn("COLUMN_Config_url");
						if(jsonData.isShowZones == 'false')
								this.hideSpecificColumn("ZoneName");
						if(jsonData.enableScreenShot == 'false')
								this.hideSpecificColumn("screenshot");
						if(jsonData.isSuperManager)
							this.showSpecificColumn("mgrid");
						else
							this.hideSpecificColumn("mgrid");
					}
					else{
						if(typeof showSeverityColumn != 'undefined' && showSeverityColumn){
							if(jsonData.enableDD == 'false')
								this.hideSpecificColumn("ddparams");
							if(jsonData.enableUser == 'false')
								this.hideSpecificColumn("users");
							if(jsonData.enableLogon == 'false')
								this.hideSpecificColumn("Logon_Details_Support");
							if(jsonData.enableConfig == 'false')
								this.hideSpecificColumn("COLUMN_Config_url");
							if(jsonData.enableScreenShot == 'false')
								this.hideSpecificColumn("screenshot");
							if(jsonData.isShowZones == 'false')
								this.hideSpecificColumn("ZoneName");
							if(jsonData.isSuperManager)
								this.showSpecificColumn("mgrid");
							else
								this.hideSpecificColumn("mgrid");
							
						}else{
							if(jsonData.enableDD == 'false')
								this.hideSpecificColumn("ddparams");
							if(jsonData.enableUser == 'false')
								this.hideSpecificColumn("users");
							if(jsonData.enableLogon == 'false')
								this.hideSpecificColumn("Logon_Details_Support");
							if(jsonData.enableConfig == 'false')
								this.hideSpecificColumn("COLUMN_Config_url");
							if(jsonData.isShowZones == 'false')
								this.hideSpecificColumn("ZoneName");
							if(jsonData.enableScreenShot == 'false')
								this.hideSpecificColumn("screenshot");
							if(jsonData.isSuperManager)
								this.showSpecificColumn("mgrid");
							else
								this.hideSpecificColumn("mgrid");
						}
					}
					if(jsonData.showServicesColumn == 'false')
						this.hideSpecificColumn("services");
					
					var screenLabels = jsonData.screenLabels;
					if(thisObj != null && thisObj != undefined)
					{
						thisObj.screenLabels = jsonData.screenLabels;
						thisObj.dataArray = jsonData;
						//thisObj.updateLabels(screenLabels);
						thisObj.doLayout();
					}
				  loader.hide();
					monitor.HistorySummary.filterData = null;
					if(!showCurrent || !isAllowAckDeleteAlarms){
						this.getHistorySummary().columns[0].hide();
						Ext.ComponentQuery.query('[itemId="ackDelToolbar"]')[0].hide();
					}else{
						this.getHistorySummary().columns[0].show();
						Ext.ComponentQuery.query('[itemId="ackDelToolbar"]')[0].show();
						Ext.ComponentQuery.query('[itemId="metricsAcknowledge"]')[0].hide();
						Ext.ComponentQuery.query('[itemId="metricsDelete"]')[0].hide();
						if(isAcknowledgeAllowed)
							Ext.ComponentQuery.query('[itemId="metricsAcknowledge"]')[0].show();
						if(isDeleteAllowed)
							Ext.ComponentQuery.query('[itemId="metricsDelete"]')[0].show();
					}
					//Ajax Request For Count TotalRecords...
					Ext.Ajax.request({
							url : queryString+"&count=true&dontSetSession=true",
							async:false,
							timeout:300000,
							success: function(response){
								var jsonText = response.responseText;
								//totalRecords=30;
								var ttlPages;
								jsonText = jsonText.substring(0,jsonText.indexOf("|"));
											
								if(jsonText.indexOf("^")>=0)
									{
									pageCount = jsonText.substring(0,jsonText.indexOf("^"));						
									ttlPages = jsonText.substring((jsonText.indexOf("^")+1),jsonText.lastIndexOf("^")).trim();						
									recCount = jsonText.substring((jsonText.lastIndexOf("^")+1)).trim();
									}
									else
										ttlPages = jsonText.trim();
								totalRecords = ttlPages;
								//var comp = Ext.getCmp("paginationTotals");					
								var ptot = Ext.getCmp("paginationTotals");
								var comp = Ext.getCmp("totalPg");
								ptot.setValue(currentPageNo);
								totalRecords = ttlPages; 
								if(parseInt(totalRecords)==currentPageNo)
								{
									var next = Ext.getCmp("pnext");
									var last = Ext.getCmp("plast");
									next.disabled=true;
									last.disabled=true;
								}
								else
								{
									var next = Ext.getCmp("pnext");
									var last = Ext.getCmp("plast");
									next.disabled=false;
									last.disabled=false;
								}					
								var displayInfo = Ext.getCmp("displayInfo");
								comp.setText(" "+historyDockedOf+" "+ttlPages);
								if(totalRecords==0)
								{					
									displayInfo.setText(" ");
									var dPage= Ext.getCmp("dockedPagnation");
									dPage.setVisible(false);					
								}
								else
								{			
									var endInx = parseInt(pageCount)*parseInt(currentPageNo);
									var startInx = endInx- parseInt(pageCount);
									if(recCount<endInx)
										endInx = recCount;
									
									var msg = historyDockedDisplaying+" "+(startInx+1)+"-"+endInx+" "+historyDockedOf+" "+recCount;
									displayInfo.setText(msg);
									var dPage= Ext.getCmp("dockedPagnation");
									dPage.setVisible(true);					
									var disp = Ext.getCmp("displayInfo");
									
									if(Ext.isEmpty(pageCount))
										disp.setText("");
									else
									{
										msg = historyDockedDisplaying+" "+(startInx+1)+"-"+endInx+" "+historyDockedOf+" "+recCount;
										disp.setText(msg);		
									}
									
								}
								//validate..
								var first = Ext.getCmp("pfirst");
								var prev = Ext.getCmp("pprev");
								first.disabled=true;
								prev.disabled=true;
								if(parseInt(totalRecords)==1)
								{
									var next = Ext.getCmp("pnext");
									var last = Ext.getCmp("plast");
									next.disabled=true;
									last.disabled=true;
								}
							}
					});
				}
				catch (e)
				{
					loader.hide();
				}
		    }
		});
	},
	showToolTip:function(grid,record,item, index, e, eOpts){						// Prem
		var header = record.get('acknowledgeHeader');
		var tipGrid = grid.tip;

		if(!Ext.isEmpty(header))
		{
			tipGrid.setTarget(grid.el);
			tipGrid.delegate = grid.itemSelector;
			ackData = record.get("acknowledgeData");
			ackData.unique();
			var gridHtml = '<div class="x-table"><table width="100%" class="x-grid-table x-grid-table-resizer" cellspacing="0" cellpadding="0" border="0">'
							   +'<colgroup>'
								+'<col width="20%"/>'
							   +'<col width="33%"/>'
							   +'<col width="25%"/>'
							   +'<col width="22%"/>'
							   +'</colgroup>'
							   +'<thead>'
							   +'<tr class="x-grid-row">'
										  +'<th class=" x-grid-cell x-grid-cell-first">'
											 +'<div class="x-grid-cell-inner">User</div>'
										  +'</th>'
										  +'<th class=" x-grid-cell">'
											 +'<div class="x-grid-cell-inner">Description</div>'
										  +'</th>'
										  +'<th class=" x-grid-cell" >'
											 +'<div class="x-grid-cell-inner">Action</div>'
										  +'</th>'
										  +'<th class=" x-grid-cell">'
											 +'<div class="x-grid-cell-inner">Time</div>'
										  +'</th>'
									   +'</tr>'
							   +'</thead>'
							   +'<tbody>';
		   for(i=0;i<ackData.length;i++)
			{
			   gridHtml +='<tr class="x-grid-row">'
						  +'<td class=" x-grid-cell x-grid-cell-first">'
							 +'<div  class="x-grid-cell-inner">'+ackData[i].user+'</div>'
						  +'</td>'
						  +'<td class=" x-grid-cell">'
							 +'<div class="x-grid-cell-inner" >'+ackData[i].ackDetail+'</div>'
						  +'</td>'
						  +'<td class=" x-grid-cell" >'
							 +'<div  class="x-grid-cell-inner" >'+ackData[i].action+'</div>'
						  +'</td>'
						  +'<td class=" x-grid-cell">'
							 +'<div class="x-grid-cell-inner">'+ackData[i].time+'</div>'
						  +'</td>'
					   +'</tr>';
					//tipGrid.data = record.get('acknowledgeData');
			}
			gridHtml += '</tbody></table></div>';
			tipGrid.update(gridHtml);
		}
		else
		{
			tipGrid.update("");
		}
	},
	destroyToolTip: function(grid){
		grid.tip.update("");
	},
	saveInCSVFormat:function()
	{
		if(this.getHistorySummary().getStore().getCount()>0 || (!showEventHistory && this.getHistorySummary().getStore().getRootNode().childNodes.length > 0))
		{
			var moreFiltersForm = Ext.getCmp('more-filter-options-panel').getForm();
			selectedArrangeOption = moreFiltersForm.findField('sortBy').getValue();
			orderBy='desc';
			if(!showCurrent)
				showCurrent = null;
			if(selectedArrangeOption!=null && orderBy!=null)
			{
				window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?alarmhistory=Yes&arrangeAlarms="+selectedArrangeOption+"&orderby="+orderBy+"&showEventHistory="+showEventHistory+'&showCurrent='+showCurrent,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
			}
			else
			{
				window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?alarmhistory=Yes"+"&showEventHistory="+showEventHistory+'&showCurrent='+showCurrent,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
			}
		}
		else
		{
			Ext.MessageBox.show({
							title: 'ALERT',
							msg: "No Alarm Found",
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
			return false;
		}
	},

	hsummaryFirstButton:function()
	{
		var disp = Ext.getCmp("displayInfo");
		currentPageNo=1;		
		this.showAlarms(this.getSubmitButton(),'','');
			//
		var endInx = parseInt(pageCount)*parseInt(currentPageNo);
		var startInx = endInx- parseInt(pageCount);
		if(recCount<endInx)
			endInx = recCount;
		var msg = historyDockedDisplaying+" "+(startInx+1)+"-"+endInx+" "+historyDockedOf+" "+recCount;
		disp.setText(msg);		
		var first = Ext.getCmp("pfirst");
		var prev = Ext.getCmp("pprev");
		first.disabled=true;
		prev.disabled=true;
		if(parseInt(totalRecords)>currentPageNo)
		{
			var next = Ext.getCmp("pnext");
			var last = Ext.getCmp("plast");
			next.disabled=false;
			last.disabled=false;
		}		
	},
	hsummaryPreviousButton:function()
	{
		var disp = Ext.getCmp("displayInfo");
		currentPageNo=currentPageNo-1;		
		this.showAlarms(this.getSubmitButton(),'','');
			//
		var endInx = parseInt(pageCount)*parseInt(currentPageNo);
		var startInx = endInx- parseInt(pageCount);
		if(recCount<endInx)
			endInx = recCount;
		var msg = historyDockedDisplaying+" "+(startInx+1)+"-"+endInx+" "+historyDockedOf+" "+recCount;
		disp.setText(msg);
		if(currentPageNo==1)
		{
			var first = Ext.getCmp("pfirst");
			var prev = Ext.getCmp("pprev");
			first.disabled=true;
			prev.disabled=true;
		}
		if(parseInt(totalRecords)>currentPageNo)
		{
			var next = Ext.getCmp("pnext");
			var last = Ext.getCmp("plast");
			next.disabled=false;
			last.disabled=false;
		}
	},
	hsummaryNextButton:function()
	{		
		var disp = Ext.getCmp("displayInfo");
		currentPageNo=currentPageNo+1;
		this.showAlarms(this.getSubmitButton(),'','');
		//
		var endInx = parseInt(pageCount)*parseInt(currentPageNo);
		var startInx = endInx- parseInt(pageCount);
		if(recCount<endInx)
			endInx = recCount;
		var msg = historyDockedDisplaying+" "+(startInx+1)+"-"+endInx+" "+historyDockedOf+" "+recCount;
		disp.setText(msg);		
		//		
		if(currentPageNo>1)
		{
			var first = Ext.getCmp("pfirst");
			var prev = Ext.getCmp("pprev");
			first.disabled=false;
			prev.disabled=false;
		}
		if(parseInt(totalRecords)==currentPageNo)
		{
			var next = Ext.getCmp("pnext");
			var last = Ext.getCmp("plast");
			next.disabled=true;
			last.disabled=true;
		}		
	},
	hsummaryLastButton:function()
	{
		var comp = Ext.getCmp("paginationTotals");
		var disp = Ext.getCmp("displayInfo");
		var val = comp.getValue();
		if(val!=null && val!="" && val!="undefined")
		{			
			currentPageNo =parseInt(totalRecords.trim());
		}		
		this.showAlarms(this.getSubmitButton(),'','');
			//
		var endInx = parseInt(pageCount)*parseInt(currentPageNo);
		var startInx = endInx- parseInt(pageCount);
		if(recCount<endInx)
			endInx = recCount;
		var msg = historyDockedDisplaying+" "+(startInx+1)+"-"+endInx+" "+historyDockedOf+" "+recCount;
		disp.setText(msg);
		if(currentPageNo>1)
		{
			var first = Ext.getCmp("pfirst");
			var prev = Ext.getCmp("pprev");
			first.disabled=false;
			prev.disabled=false;
		}
		if(parseInt(totalRecords)==currentPageNo)
		{
			var next = Ext.getCmp("pnext");
			var last = Ext.getCmp("plast");
			next.disabled=true;
			last.disabled=true;
		}		
	},
	setValueWithOptionInList: function(form, fieldName, list, value) {
        form.findField(fieldName).getStore().loadRawData(list);
        form.findField(fieldName).suspendEvents(false);
        var valueAssigned = false;
        for (var listCounter = 0; listCounter < list.length; listCounter++) {
            if (list[listCounter].valueField == value && value != "" && value != null) {
                form.findField(fieldName).setValue(value);
                valueAssigned = true;
            }
        }
        if (!valueAssigned) {
            form.findField(fieldName).setValue(list[0].valueField);
        }
        form.findField(fieldName).resumeEvents();
    },
	loadComboFieldSelectedVal: function(btn, e, opts)
	{
		var me = this;
		var filterPanel = btn.up('historyfilters');
		var jsonData = monitor.HistorySummary.filterData;
		if(!Ext.isEmpty(jsonData))
		{
			var thisForm = btn.up('form').getForm();
			var compName = jsonData.compNameList_value;
			if(compName != null && compName != 'undefined' && compName.indexOf(':NULL')>0)
			{
				compName = compName.substring(0,compName.indexOf(':NULL'));
			}
			me.setValueWithOptionInList(thisForm, 'compTypeList', jsonData.compTypeList, jsonData.compTypeList_value);
			me.setValueWithOptionInList(thisForm, 'compNameList', jsonData.compNameList, compName);
			me.setValueWithOptionInList(thisForm, 'state', jsonData.state, jsonData.state_value);
			me.setValueWithOptionInList(thisForm, 'eventfor', jsonData.eventfor, jsonData.eventfor_value);
			if(!Ext.isEmpty(jsonData.includeSubZone_value))
				me.setValueWithOptionInList(thisForm, 'includeSubZone', jsonData.includeSubZone, jsonData.includeSubZone_value);
			if(!Ext.isEmpty(jsonData.event_select_value))
				me.setValueWithOptionInList(thisForm, 'event_select', jsonData.event_select, jsonData.event_select_value);

			if(startTimeUrl != null && endTimeUrl != null && startTimeUrl != "null" && endTimeUrl != "null")
			{
				var startDate = startTimeUrl.substring(0,startTimeUrl.lastIndexOf(" "));
				var startTime = startTimeUrl.substring(startTimeUrl.lastIndexOf(" ")+1);
				var endDate = endTimeUrl.substring(0,endTimeUrl.lastIndexOf(" "));
				var endTime = endTimeUrl.substring(endTimeUrl.lastIndexOf(" ")+1);
				var moreFilterForm = Ext.getCmp('more-filter-options-panel').getForm();
				moreFilterForm.findField('eg_timeline').setValue("Any");
				moreFilterForm.findField('eg_stdate').setValue(startDate);
				moreFilterForm.findField('eg_stdate').enable();
				moreFilterForm.findField('eg_enddate').setValue(endDate);
				moreFilterForm.findField('eg_enddate').enable();
				var startHr = startTime.substring(0,startTime.indexOf(":"));
				var startMin = startTime.substring(startTime.indexOf(":")+1,startTime.lastIndexOf(":"));
				if(startHr.indexOf(0) == 0)
					startHr = startHr.substring(1);
				if(startMin.indexOf(0) == 0)
					startMin = startMin.substring(1);
				moreFilterForm.findField('starthr').setValue(startHr);
				moreFilterForm.findField('starthr').enable();
				var endHr = endTime.substring(0,endTime.indexOf(":"));
				var endMin = endTime.substring(endTime.indexOf(":")+1,endTime.lastIndexOf(":"));
				if(endHr.indexOf(0) == 0)
					endHr = endHr.substring(1);
				if(endMin.indexOf(0) == 0)
					endMin = endMin.substring(1);
				moreFilterForm.findField('endhr').setValue(endHr);
				moreFilterForm.findField('endhr').enable();
				moreFilterForm.findField('startmin').setValue(startMin);
				moreFilterForm.findField('startmin').enable();
				moreFilterForm.findField('endmin').setValue(endMin);
				moreFilterForm.findField('endmin').enable();
			}
			filterPanel.updateLabels(jsonData.screenLabels);
		}		
	},
	loadFields:function(thisObj,records){
			
		var me = this;
		var filterPanel = thisObj.up('historyfilters');
		filterForm = filterPanel.getForm();
		var moreFilterForm = Ext.getCmp('more-filter-options-panel');
		var moreFiltersForm = Ext.getCmp('more-filter-options-panel').getForm();
    	if(thisObj.name == 'compTypeList' || thisObj.name =='compNameList')
    	{
    		moreFiltersForm.findField('layers').setVisible(false);
    	}
		var requestParams = Ext.Object.merge(filterForm.getValues(),moreFilterForm.getValues());
		var requestURL = 'EgAlarmHistoryFrame.jsp';
		if(thisObj.name == 'eventfor' && records[0].data.displayField == 'Component'){
			requestURL = 'EgAlarmHistoryFrame.jsp?newAlarms=true&eg_tbound=Fixed';
			requestParams = null;
			filterForm.findField('event_select').setDisabled(true);
			filterForm.findField('event_select').setVisible(false);
		}
		if(thisObj.name == 'eventfor' && records[0].data.displayField != 'Zone'){
			filterForm.findField('includeSubZone').setDisabled(true);
			filterForm.findField('includeSubZone').setVisible(false);
		}
		if(!Ext.isEmpty(monitor.HistorySummary.filterData) || thisObj.name == 'compNameList' || thisObj.name == 'state')
			return;
		Ext.Ajax.request({
			url:requestURL,
			async:true,
			params:requestParams,
			timeout:300000,
			success:function(response){
				var json = Ext.decode(response.responseText);
				if(!Ext.isEmpty(requestParams)){
					if(thisObj.name == 'eventfor' && json.event_select_Ind == 'true'){
						var subEventField = me.reloadComboStore('event_select',json);
						subEventField.setDisabled(false);
						subEventField.setVisible(true);
						if(json.includeSubZone_Ind == "true"){
							var includeZoneField = filterForm.findField('includeSubZone');
							includeZoneField.setDisabled(false);
							includeZoneField.setVisible(true);
						}
						me.reloadComboStore('compTypeList',json);
					}
					else if(thisObj.name == 'event_select'){
						me.reloadComboStore('compTypeList',json);
					}
					else if (thisObj.name == 'includeSubZone' && filterForm.findField('includeSubZone').getValue() != null)
					{
						me.reloadComboStore('compTypeList',json);
					}
				}
				else{
					me.reloadComboStore('eventfor',json);
					me.reloadComboStore('compTypeList',json);
				}
				me.reloadComboStore('compNameList',json);
				filterPanel.updateLabels(json.screenLabels);
				if(thisObj.getValue() == 'Zone')
				{
					var includeZoneField = filterForm.findField('includeSubZone');
					includeZoneField.setValue('Yes');
				}
				var dashboardcomptype = filterForm.findField("compTypeList").getValue();
				var dashboardcompname = filterForm.findField("compNameList").getValue();
				moreFiltersForm.findField('dashboardcomptype').setValue(dashboardcomptype);
				moreFiltersForm.findField('dashboardcompname').setValue(dashboardcompname);
			}
		});
	},
	hideSpecificColumn:function(value){
		var ddd = "";
		var gridColumns = this.getHistorySummary().columns;
		var index=-1;
		for(var i = 0;i<gridColumns.length;i++){
			ddd += " "+gridColumns[i].dataIndex;
			if(gridColumns[i].hasOwnProperty("dataIndex") && gridColumns[i].dataIndex == value){
				index = i;
				break;
			}else if(gridColumns[i].hasOwnProperty("name") && gridColumns[i].name == value){
				index = i;
				break;
			}
		}
		if(index != -1)
			gridColumns[index].hide();
		return;
	},
	showSpecificColumn:function(value){
		var ddd = "";
		var gridColumns = this.getHistorySummary().columns;
		var index=-1;
		for(var i = 0;i<gridColumns.length;i++){
			ddd += " "+gridColumns[i].dataIndex;
			if(gridColumns[i].hasOwnProperty("dataIndex") && gridColumns[i].dataIndex == value){
				index = i;
				break;
			}else if(gridColumns[i].hasOwnProperty("name") && gridColumns[i].name == value){
				index = i;
				break;
			}
		}
		if(index != -1)
			gridColumns[index].show();
		return;
	}
});