Ext.define('EgCorAlarm.controller.CorrelatedController', {
	extend: 'Ext.app.Controller',
	views:['EgCorAlarm.view.Layers.Alarms.*'],
	requires: [],
	refs:[{
    	ref:'alarmsfilter',
    	selector:'alarmsfilter'
    },{
    	ref:'alarmsgroupedview',
    	selector:'alarmsgroupedview'
    }],
	init: function () {
		this.control({
	   		'alarmsfilter':{
				afterrender:this.loadCombos
			},
			'alarmsfilter combo[name="showCombo"]':
			{
				'select' : this.loadAlarms
			},
			'alarmsfilter combo[name="filterCombo"]':
			{
				'select' : this.loadAlarms
			},
			'alarmsfilter combo[name="subFilterCombo"]':
			{
				'select' : this.loadAlarms
			},
			'alarmsfilter combo[name="searchByCombo"]':
			{
				'select' : this.loadAlarms
			},
			'alarmsfilter textfield[name="searchTextBox"]':
			{
				'keyup' : this.searchAlarms,
				'ontriggerclick': this.searchAlarms
			},
			'alarmsfilter button[action=Save CSV]':{
				click : this.saveInCSVFormat
			},
			'alarmsfilter button[action=Save PDF]' : {
				click : this.saveInPDFFormat
			}
		});
	},
	collapseExpand:function(isExpand){
			if(isExpand){
				this.getAlarmsgroupedview().expandAll();
			}else{
				this.getAlarmsgroupedview().collapseAll();
			}
	},
	searchAlarms:function(field, event ){
		var isTrigger = false;
		if(!Ext.isEmpty(event) && !Ext.isEmpty(event.type) && event.type!=null && event.type!=undefined && event.type=='click')
			isTrigger = true;
		else if(!Ext.isEmpty(event) && event=='fire')
			isTrigger = true;
		if( isTrigger || event.getKey() == event.ENTER  ){
			var jsonSearchData = null;
			var showCombo = Ext.getCmp('showCombo').getValue();
			field.value = field.value.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
			var regex = RegExp(field.value.toLowerCase(),'i');
			var searchGridData = [];
			if(!Ext.isEmpty(field.value)){
				var kk=0;
				publicJson.gridJson.gridData.map(function(value){
					var groupSearch ={};
					var parentMatch = false;
					var parent = JSON.parse(JSON.stringify(value));
					
					parentMatch = parentMatch || regex.test(String(parent.COLUMN_2.toLowerCase())) || regex.test(String(parent.COLUMN_3.toLowerCase())) || regex.test(String(parseWrdfrHtml(parent.COLUMN_4.toLowerCase()))) || regex.test(String(parent.COLUMN_5.toLowerCase()));
					if(!Ext.isEmpty(parent.ACCESS_EVENT_ID) && parent.ACCESS_EVENT_ID != null)
						parentMatch = parentMatch || regex.test(String(parent.ACCESS_EVENT_ID.toLowerCase()));
					if(!parentMatch)
					{
						try
						{
							var sub_data = publicJson.gridJson.eventDetails[kk][1];
							if(!Ext.isEmpty(sub_data)){
								for (var aa in sub_data )
								{
									var child1 = JSON.parse(JSON.stringify(sub_data[aa]));
									parentMatch = parentMatch || regex.test(String(child1.event_seq_no.toLowerCase())) || regex.test(String(child1.msmtHost.toLowerCase())) || regex.test(String(child1.test.toLowerCase())) || regex.test(String(parseWrdfrHtml(child1.description.toLowerCase()))) || regex.test(String(child1.service.toLowerCase()));
									if(parentMatch)
										break;
								}
							}
						}
						catch (ee)
						{
							//console.log(ee)
						}
					}
					var children1 = null;
					if(!Ext.isEmpty(parent.children)){
						children1 = JSON.parse(JSON.stringify(parent.children));
					}
					groupSearch = JSON.parse(JSON.stringify(value));
					groupSearch.isSearchFound = false;
					if(parentMatch){
						groupSearch.isSearchFound = true;
						parent.children = [];
						//searchGridData.push(parent);
					}
					if(!Ext.isEmpty(children1)){
						children1.map(function(value1,child1Index){
							var child1Match = false;
							var child1 = JSON.parse(JSON.stringify(value1));
							child1Match = child1Match || regex.test(String(child1.COLUMN_2.toLowerCase())) || regex.test(String(child1.COLUMN_3.toLowerCase())) || regex.test(String(parseWrdfrHtml(child1.COLUMN_4.toLowerCase()))) || regex.test(String(child1.COLUMN_5.toLowerCase()));
							if(!Ext.isEmpty(child1.ACCESS_EVENT_ID) && child1.ACCESS_EVENT_ID != null)
								child1Match = child1Match || regex.test(String(child1.ACCESS_EVENT_ID.toLowerCase()));
							var children2 = null;
							if(!Ext.isEmpty(child1.children)){
								children2 = JSON.parse(JSON.stringify(child1.children));
							}
							groupSearch.children[child1Index].isSearchFound = false;
							if(child1Match){
								groupSearch.isSearchFound = true;
								groupSearch.children[child1Index].isSearchFound = true;
								child1.children = [];
								//searchGridData.push(child1);
							}
							if(!Ext.isEmpty(children2)){
								children2.map(function(value2,child2Index){
									var child2Match = false;
									var child2 = JSON.parse(JSON.stringify(value2));
									child2Match = child2Match || regex.test(String(child2.COLUMN_2.toLowerCase())) || regex.test(String(child2.COLUMN_3.toLowerCase())) || regex.test(String(parseWrdfrHtml(child2.COLUMN_4.toLowerCase()))) || regex.test(String(child2.COLUMN_5.toLowerCase()));
									if(!Ext.isEmpty(child2.ACCESS_EVENT_ID))
										child2Match = child2Match || regex.test(String(child2.ACCESS_EVENT_ID.toLowerCase()));
									groupSearch.children[child1Index].children[child2Index].isSearchFound = false;
									if(child2Match){
										groupSearch.isSearchFound = true;
										groupSearch.children[child1Index].isSearchFound = true;
										groupSearch.children[child1Index].children[child2Index].isSearchFound = true;
										//searchGridData.push(child2);
									}
								});
							}
						});
					}
					var searchData = JSON.parse(JSON.stringify(groupSearch));
					searchData = removeSearchNotFound(searchData);
					if(!Ext.isEmpty(searchData))
						searchGridData.push(searchData);
					kk++;
				});
				jsonSearchData ={gridJson:{gridData:searchGridData}};
				jsonSearchData = processDataforGrid(jsonSearchData);
			}else{
				jsonSearchData = publicJson;
			}
			this.getAlarmsgroupedview().updateGrid(jsonSearchData);
		}
		field.focus();
	},
	saveInCSVFormat : function()
	{
		if(!Ext.isEmpty(this.getAlarmsgroupedview()) && this.getAlarmsgroupedview().getStore().getRootNode().childNodes.length>0){
			try{
				var searchValue = "";
				var s_qryString = "";
				var showCombo = Ext.getCmp("showCombo");
				var filterCombo = Ext.getCmp("filterCombo");
				var subFilterCombo = Ext.getCmp("subFilterCombo");
				var equals = encodeURIComponent("|eq|");
				if(!Ext.isEmpty(showCombo))
					s_qryString += "&filterValue3="+showCombo.getRawValue();
				if(!Ext.isEmpty(filterCombo))
					s_qryString += "&filterValue2="+filterCombo.getFieldLabel()+equals+filterCombo.getRawValue();
				if(!Ext.isEmpty(subFilterCombo)){
					var subFilterComboValue = subFilterCombo.getRawValue();
					try{
						subFilterComboValue = parent.filterEncode(subFilterComboValue);
					}
					catch (e){
						try{
							subFilterComboValue = window.opener.filterEncode(subFilterComboValue);
						}
						catch (e){
							subFilterComboValue = parent.parent.filterEncode(subFilterComboValue);
						}
					}
					s_qryString += "&filterValue1="+subFilterCombo.getFieldLabel()+equals+encodeURIComponent(subFilterComboValue);
				}
				var searchField = Ext.getCmp('searchTextBox');
				if(!Ext.isEmpty(searchField) && !Ext.isEmpty(searchField.getValue())){
					searchValue = searchField.getValue();
					try{
						searchValue = parent.filterEncode(searchValue);
					}
					catch (e){
						try{
							searchValue = window.opener.filterEncode(searchValue);
						}
						catch (e){
							searchValue = parent.parent.filterEncode(searchValue);
						}
					}
					s_qryString += "&searchValue="+encodeURIComponent(searchValue);
				}
				var soringItems = this.getAlarmsgroupedview().getStore().sorters.items;
				if(!Ext.isEmpty(soringItems)){
					var prop = soringItems[0].property;
					var index= parseInt(prop.substring(prop.length-1));
					var columnsDataIndex = [];
					this.getAlarmsgroupedview().columns.map(function(item,i){
						var allow = (item.hasOwnProperty("hidden") && item.hidden)?false:true; 
						if(item.hasOwnProperty("dataIndex") && !Ext.isEmpty(item.dataIndex) && allow){
							columnsDataIndex.push(item.dataIndex);
						}
					});
					index = columnsDataIndex.indexOf(prop)+1;
					s_qryString += "&sortingDirection="+soringItems[0].direction+"&sortingColumn="+index;
				}
				if(!Ext.isEmpty(searchValue) || !Ext.isEmpty(soringItems) || showCombo.getValue() == 'CorrelatedAlarms'){
					Ext.Ajax.request({
						url : '/final/monitor/currentAlarmsPdf.jsp?loadCSV=true'+s_qryString,
						scope:this,
						success: function(response){
							var jsonText = response.responseText;
							window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes&searchSorting=true"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
						},
						failure:function(){
							window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
						}
					});
				}
				else
					window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
			}
			catch (e){
				window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
			}
		}
		else
		{
			Ext.MessageBox.show({
				title: 'ALERT',
				msg: "No Alarm Found",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
	},
	saveInPDFFormat : function()
	{
		var s_qryString = "/final/servlet/com.eg.EgPdfDownloadC?from=currentAlarm";
		if(!Ext.isEmpty(this.getAlarmsgroupedview()) && this.getAlarmsgroupedview().getStore().getRootNode().childNodes.length>0)
		{
			try
			{
				var showCombo = Ext.getCmp("showCombo");
				var filterCombo = Ext.getCmp("filterCombo");
				var subFilterCombo = Ext.getCmp("subFilterCombo");
				if(!Ext.isEmpty(showCombo))
					s_qryString += "&filterValue3="+showCombo.getRawValue();
				if(!Ext.isEmpty(filterCombo))
					s_qryString += "&filterValue2="+filterCombo.getFieldLabel()+" : "+filterCombo.getRawValue();
				if(!Ext.isEmpty(subFilterCombo)){
					var subFilterComboValue = subFilterCombo.getRawValue();
					try{
						subFilterComboValue = parent.filterEncode(subFilterComboValue);
					}
					catch (e){
						try{
							subFilterComboValue = window.opener.filterEncode(subFilterComboValue);
						}
						catch (e){
							subFilterComboValue = parent.parent.filterEncode(subFilterComboValue);
						}
					}
					s_qryString += "&filterValue1="+subFilterCombo.getFieldLabel()+" : "+encodeURIComponent(subFilterComboValue);
				}
				var searchField = Ext.getCmp('searchTextBox');
				var searchValue = "";
				if(!Ext.isEmpty(searchField) && !Ext.isEmpty(searchField.getValue()))
				{
					searchValue = searchField.getValue();
					try{
						searchValue = parent.filterEncode(searchValue);
					}
					catch (e){
						try{
							searchValue = window.opener.filterEncode(searchValue);
						}
						catch (e){
							searchValue = parent.parent.filterEncode(searchValue);
						}
					}
					s_qryString += "&searchValue="+encodeURIComponent(searchValue);
				}
				var soringItems = this.getAlarmsgroupedview().getStore().sorters.items;
				if(!Ext.isEmpty(soringItems))
				{
					var prop = soringItems[0].property;
					var index = parseInt(prop.substring(prop.length-1));
					var showCombo = Ext.getCmp("showCombo").getValue();
					var columnsDataIndex = [];
					this.getAlarmsgroupedview().columns.map(function(item,i){
						var allow = (item.hasOwnProperty("hidden") && item.hidden)?false:true; 
						if(item.hasOwnProperty("dataIndex") && !Ext.isEmpty(item.dataIndex) && allow){
							columnsDataIndex.push(item.dataIndex);
						}
					});
					index = columnsDataIndex.indexOf(prop)+1;
					//if(!Ext.isEmpty(showCombo) && showCombo == "CurrentUnknown")
						  //index += 1;
					s_qryString += "&sortingDirection="+soringItems[0].direction+"&sortingColumn="+index;
				}
				var  progressBar= Ext.MessageBox.progress({
					title: 'Downloading',
					value: 5,
					width: 350,
					increment: 15,
					closable: false,
					progressText: 'Connecting..',
					wait: true,
					waitConfig: {
						interval: 200
					},
					msg: '<b>Downloading, please wait...</b>',
					scope: this,
					handler: function () {
						this.updateText('Done!');
					}
				});
				var iFrameExists = Ext.query("#pdfIframe");
				if(Ext.isEmpty(iFrameExists))
				{
					Ext.DomHelper.append(document.body, {
						tag: 'iframe',
						frameBorder: 0,
						width: 0,
						height: 0,
						css: 'display:none;visibility:hidden;height:1px;',
						src: s_qryString,
						id: 'pdfIframe'
					});
				}
				else
				{
					Ext.select('#pdfIframe').set( { src :  s_qryString });
				}
				Ext.Ajax.request({
					url : '/final/monitor/EgSaveStatus.jsp?downloadFile=true',
					scope:this,
					//timeout:5000,
					success: function(response){
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData))
						{
							var downloadStatus = jsonData.downloadStatus;
							try
							{
								if(downloadStatus.toUpperCase() == 'DONE')
								{
									progressBar.hide();
								}
							}
							catch (e)
							{
								progressBar.hide();
							}
						}
					},
					failure:function(response){
						progressBar.hide();
					}
				});
			}
			catch (e)
			{
				//progressBar.hide();
				console.log(e)
			}
		}
		else
		{
			Ext.MessageBox.show({
				title: 'ALERT',
				msg: "No Alarm Found",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
	},
	updateQueryString : function(objId)
	{
		var filterCombo = Ext.getCmp('filterCombo').getValue();
		var showCombo = Ext.getCmp('showCombo').getValue();
		var subFilterCombo = Ext.getCmp('subFilterCombo').getValue();
	//	var searchByCombo = Ext.getCmp('searchByCombo').getValue();
	//	var searchText = Ext.getCmp('searchTextBox').getValue();

		var QStr = '';// "&compsearch="+searchText+"&selectedSearchByOption="+searchByCombo;


		/* if(filterCombo!=null && filterCombo=='componentTypes')
		{
		console.log('--');
			//Ext.getCmp('subFilterCombo').setWidth(250);
			Ext.getCmp('subFilterCombo').labelWidth= 150;
			Ext.getCmp('subFilterCombo').setWidth(250);
		} */

		var defaultAllAlarmsVal=publicJson['pageParams']['AllAlarmsOptVal'];
		if(defaultAllAlarmsVal!=null && !Ext.isEmpty(defaultAllAlarmsVal))
		{
			while (defaultAllAlarmsVal.indexOf("&")>-1)
			{
				defaultAllAlarmsVal=defaultAllAlarmsVal.replace('&','|amp|');
			}
		}
		/*if(defaultAllAlarmsVal!=null && (defaultAllAlarmsVal=='' || defaultAllAlarmsVal=='undefined' || defaultAllAlarmsVal=='null'))
		{
			defaultAllAlarmsVal='HIGH|amp|INTERMEDIATE|amp|LOW';
		}
		if((Ext.isEmpty(defaultAllAlarmsVal) || defaultAllAlarmsVal==undefined || defaultAllAlarmsVal=='undefined' || defaultAllAlarmsVal == null || defaultAllAlarmsVal=='null') && filterCombo!=null && (filterCombo=='componentTypes' || filterCombo=='services' || filterCombo=='segments' || filterCombo=='zones' || filterCombo=='States'))
		{
			defaultAllAlarmsVal='HIGH|amp|INTERMEDIATE|amp|LOW';
		}*/
		if(objId!=null && objId!='filterCombo') // if clicked combo is not filtercombo box
		{
			if((filterCombo!=null && filterCombo=='States')) // if priority is selected in filter combo box
			{
				if(objId!=null && objId=='subFilterCombo')  // if clicked combo is subfilter combo
				{
					showAlarms = subFilterCombo; // set priority value for alarms
					do{
						showAlarms=showAlarms.replace('&','|amp|');
					}
					while(showAlarms.indexOf('&')>0);
					QStr = QStr+"&selectedSubFilterOption="+encodeURIComponent(showAlarms);	// encode and add subfilter combo value to query string
				}
				else if(objId!=null && objId=='searchByCombo') // if clicked combo is searchby combo
				{
					showAlarms = defaultAllAlarmsVal; // change priority value to all by default
					QStr = QStr+"&selectedSubFilterOption="+encodeURIComponent(showAlarms);	 	// encode and add subfilter combo value to query string
				}
				else
				{
					//QStr = QStr+"&selectedSubFilterOption="+subFilterCombo; // add selected subfilter combo value to query string
					showAlarms = subFilterCombo; // set priority value for alarms
					do {
						showAlarms = showAlarms.replace('&','|amp|');
					}
					while(showAlarms.indexOf('&') > 0);
					QStr = QStr + "&selectedSubFilterOption=" + encodeURIComponent(showAlarms);
				
				}
			}
			else
			{
				QStr = QStr+"&selectedSubFilterOption="+subFilterCombo;	 // add selected subfilter combo value to query string
			}
		}
		else // if clicked combo is filter combo, then don't send subfiltercombo value
		{
			showAlarms = defaultAllAlarmsVal;
			QStr = QStr+"&selectedSubFilterOption="; // add empty value for subfilter combo in query string
		}
		if(showCombo!=null && ( showCombo=='CurrentAlarms' || showCombo=='CorrelatedAlarms' || showCombo=='Acknowledged' || showCombo=='unAcknowledged' ) )
		{
			QStr = QStr + "&showAlarms="+encodeURIComponent(showAlarms); // encode and add priority value to query string
		}

		QStr = QStr +'&alarmType='+showCombo;


		var hidQstr = '';
		var hiddenParams = publicJson['hiddenParams'];
		for(var hid in hiddenParams)
		{
			var hidVal = hiddenParams[hid];

			if(!Ext.isEmpty(showCombo) && showCombo !='CorrelatedAlarms' && (hid == 'loadAlertDetails' || hid == 'fromPage'))
				continue;
			if(hidVal!=null)
				hidQstr = hidQstr+'&'+hid+'='+encodeURIComponent(hidVal);
			else
				hidQstr = hidQstr+'&'+hid+'='+hidVal;
		}
		QStr = QStr+"&selectedFilterOption="+filterCombo+hidQstr;
		QStr = QStr+"&isFromDashBoard="+!hideBackButton;

		return QStr;
	},
	loadAlarms: function(combo){		
		var combId = '';
		//var mainView1 = this.getMain();
		if(combo!=null)
			combId = combo.getId();
		resetTooltip();
		var QStr = this.updateQueryString(combId);
		var currentAlmsGrid=this.getAlarmsgroupedview();
		var showCombo = Ext.getCmp('showCombo');
		var tmpQStr = '';
		if(!Ext.isEmpty(QStr) && QStr!=null && QStr!=undefined && QStr.indexOf('zoneDashboard')!=-1 && QStr.indexOf('zoneName')!=-1)
			tmpQStr = QStr;
		if(combId!=null && combId=='showCombo')
		{
			if((!Ext.isEmpty(showCombo) && showCombo!=null && showCombo!=undefined && (showCombo.getValue()=='CurrentAlarms' || showCombo.getValue()=='CorrelatedAlarms')))
			{
				QStr='currentMainPage=NotAlarms&alarmType='+showCombo.getValue();
				if(!Ext.isEmpty(tmpQStr))
					QStr+=tmpQStr;
			}
		}
		if((!Ext.isEmpty(showCombo) && showCombo!=null && showCombo!=undefined) && showCombo.getValue()!='CurrentAlarms' && showCombo.getValue()!='CorrelatedAlarms' && (isPopupWindow!=null && isPopupWindow=="true"))
		{
			QStr +="&isPopupWindow="+true;
		}
		if(!Ext.isEmpty(longestAlarms) && longestAlarms!=null && longestAlarms!=undefined)
			QStr +="&maxDurationAlarmIds="+longestAlarms;
		
		var emtText = Ext.get("emptyTextTb");
		try
		{
			if(emtText != null)
			Ext.get("emptyTextTb").hide();
		}
		catch (e)
		{
		}

		try
		{
			if(isCitrix)
			{
				if(loadUnknown)
					QStr = ctx_defaultParams+"&state=UNKNOWN";
				else{
					var state_sel = Ext.getCmp('subFilterCombo').getValue();
					if(!Ext.isEmpty(state_sel) && state_sel!=null && state_sel!=undefined && state_sel.indexOf('&')!=-1)
						state_sel= state_sel.replace(/&/g, '|amp|');
					QStr = ctx_defaultParams+"&state="+encodeURIComponent(state_sel);
				}
			}
		}
		catch (ee)
		{
		}
		alarmLoadMask.show();
		var browser=get_browser_info();
		if(QStr.startsWith('&'))
			QStr = QStr.substring(1);
		if(!Ext.isEmpty(showCombo) && showCombo.getValue() =='CorrelatedAlarms'){
			currentAlmsGrid.columns[1].width=65;
			$("#collapseExpand").css("display","block");
			QStr+="&loadAlertDetails=true&fromPage=SAASHome";
		}else{
			$("#collapseExpand").css("display","none");
			currentAlmsGrid.columns[1].width=45;
		}
		QStr+='&showEventIdFlag='+showEventIdFlag;
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgCurrentAlarmsC',
			method : 'POST',
			timeout:300000,
			params: QStr+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name + '&isFromICMPage=true',
			scope:this,
			success: function(response)
			{
				try
				{
					//var jsonText = response.responseText;
					//console.log(jsonText);
					//var jsonData=Ext.decode(jsonText);
					var jsonData = JSON.parse( response.responseText );
					jsonData = processDataforGrid(jsonData);
					jsonData.showOptionsJson = jsonData.showOptionsJson.slice(0,jsonData.showOptionsJson.length-1);
					publicJson = jsonData;
					alarmLoadMask.hide();
					var meApp = this;
					if(isPopupWindow!=null && isPopupWindow=="true")
					{
						AlarmsMainTitle='';
					}
					metaRefreshUrl = publicJson['pageParams']['metaRefreshUrl'];
					metaRefreshUrl = urlParamReplace(metaRefreshUrl);
					var pageParams = publicJson['pageParams'];
					var showCombo = Ext.getCmp('showCombo');
					showCombo.getStore().loadRawData();
					publicJson['showOptionsJson'].shift();
					publicJson['showOptionsJson'].unshift({displayField: 'All Alarms', valueField: 'CurrentAlarms'},{displayField: 'All Alarms with Correlation', valueField: 'CorrelatedAlarms'});
					showCombo.getStore().loadRawData(publicJson['showOptionsJson']);
					showCombo.setValue(pageParams['selectedShowOption']);
					var filterCombo = Ext.getCmp('filterCombo');
					filterCombo.getStore().loadRawData();
					filterCombo.getStore().loadRawData(publicJson['filterOptions']);
					filterCombo.setValue(pageParams['selectedFilterOption']);
					var subFilterCombo = Ext.getCmp('subFilterCombo');
					subFilterCombo.getStore().loadRawData();
					subFilterCombo.getStore().loadRawData(publicJson['optionsForFilterSelection']);
					var totalCount = subFilterCombo.getStore().getCount();
					var lastVal = subFilterCombo.getStore().getAt(totalCount-1).get('valueField');
					if(combId!=null && combId !='subFilterCombo'){
						if(pageParams.hasOwnProperty('selectedSubFilterOption') && !Ext.isEmpty(pageParams['selectedSubFilterOption']))
							subFilterCombo.setValue(pageParams['selectedSubFilterOption']);
						else
							subFilterCombo.setValue(lastVal);
					}else{
						subFilterCombo.setValue(pageParams['selectedSubFilterOption']);
					}
					if(!Ext.isEmpty(subFilterCombo) && Ext.isEmpty(subFilterCombo.getValue()) || subFilterCombo.getValue()==undefined || subFilterCombo.getValue()==null)
					{
						subFilterCombo.setValue(subFilterCombo.getStore().getAt(0).get('valueField'));
					}
					subFilterCombo.setFieldLabel(filterCombo.getRawValue());
					var zoneNameTxt = publicJson['hiddenParams']['zoneName'];
					var isZoneDash = false;
					if(!Ext.isEmpty(zoneNameTxt)&& zoneNameTxt!=null && zoneNameTxt!=undefined && zoneNameTxt!='null' && zoneNameTxt!='undefined')
						isZoneDash = true;
					if((publicJson['pageParams']['alarmType']!='longestAlarms'))
					{
						if(!isZoneDash)
						{
							if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
								Ext.getCmp('filterCombo').show();
							if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
								Ext.getCmp('subFilterCombo').show();
							if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
								Ext.getCmp('searchTextBox').hide();
						}
						else
						{
							if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
								Ext.getCmp('filterCombo').hide();
							if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
								Ext.getCmp('subFilterCombo').hide();
							if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
								Ext.getCmp('searchTextBox').hide();
						}
					}
					else if(publicJson['pageParams']['alarmType']=='longestAlarms')
					{
						if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
							Ext.getCmp('filterCombo').hide();
						if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
							Ext.getCmp('subFilterCombo').hide();
						if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
							Ext.getCmp('searchTextBox').hide();
						disablerefresh = true;
					}
					var dataAvailable = publicJson['dataAvailable'];
					var showDeleteBtn = pageParams['showDeleteBtn'];
					var showAcknowledgeBtn = pageParams['showAcknowledgeBtn'];
					//var showDeleteBtn = pageParams['showDeleteBtn'];
					//var showAcknowledgeBtn = pageParams['showAcknowledgeBtn'];
					//if((showDeleteBtn!=null && showDeleteBtn=='true') || (showAcknowledgeBtn!=null && showAcknowledgeBtn=='true'))
					//{
					//	//Ext.getCmp('ackOptionsContainer').show();
					//}
					//if(showDeleteBtn!=null && showDeleteBtn=='true' && showCombo.getValue()!="CurrentUnknown")
					//{						
					//	if(Ext.isEmpty(Ext.getCmp('ackOptionsid')))
					//	{							
					//		//mainView1.add({xtype:'acknowledgementoptions'});							
					//	}
					//	Ext.getCmp('ackOptionsid').show();	
					//	Ext.getCmp('AlarmDeleteBtn').show();
					//}
					//else if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')) && showCombo.getValue()=="CurrentUnknown")
					//{	
					//	Ext.getCmp('ackOptionsid').hide();						
					//}
					//if(showAcknowledgeBtn!=null && showAcknowledgeBtn=='true' && showCombo.getValue()!="CurrentUnknown")
					//{
					//	if(Ext.isEmpty(Ext.getCmp('ackOptionsid')))
					//	{							
					//		//mainView1.add({xtype:'acknowledgementoptions'});
					//	}
					//	Ext.getCmp('ackOptionsid').show();	
					//	Ext.getCmp('AlarmAcknowledgeBtn').show();
					//}
					//else if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')) && showCombo.getValue()=="CurrentUnknown")
					//{
					//	Ext.getCmp('ackOptionsid').hide();						
					//}
					currentAlmsGrid.updateGrid(publicJson);
					var searchField = Ext.getCmp('searchTextBox');					
					//if(searchAck)
					if(true)
					{
						if(!Ext.isEmpty(searchField.getValue())){
							searchField.setValue('');
						}
					}				
					
					get_row = document.getElementsByClassName('x-grid-row');								//autoscroll hide/show functionality
					row_hei = Math.round(get_row.length * $('.x-grid-row').height());
					if(row_hei > $('#currentAlarmsGrid-body').height()){
						//Ext.getCmp('iconAutomaticScrollRun').show();
						Ext.getCmp('removeLineForTvMode').show();
						//Ext.getCmp('iconAutomaticScrollJumpToTop').show();
					}else{
						Ext.getCmp('iconAutomaticScrollRun').hide();
						Ext.getCmp('removeLineForTvMode').hide();
						Ext.getCmp('iconAutomaticScrollJumpToTop').hide()
					}				
					Ext.getCmp('iconAutomaticScrollStop').hide();
					clearTimeout(scrolldelay);
				}
				catch (e)
				{
					alarmLoadMask.hide();
				}
			}
		});
		//document.location = '/final/monitor/EgAlarms.jsp?'+QStr+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height);

	},
	loadCombos: function(e){			
		var screenLabels = e.jsonData['screenLabels'];
		var pageParams = e.jsonData['pageParams'];
		var showCombo = Ext.getCmp('showCombo');
		e.jsonData['showOptionsJson'].shift();
		e.jsonData['showOptionsJson'].unshift({displayField: 'All Alarms', valueField: 'CurrentAlarms'},{displayField: 'All Alarms with Correlation', valueField: 'CorrelatedAlarms'});
		showCombo.getStore().loadRawData(e.jsonData['showOptionsJson']);
		showCombo.setValue(pageParams['selectedShowOption']);
		showCombo.setFieldLabel(screenLabels['monitor.common.Show']);

		var filterCombo = Ext.getCmp('filterCombo');
		filterCombo.getStore().loadRawData(e.jsonData['filterOptions']);
		filterCombo.setValue(pageParams['selectedFilterOption']);
		filterCombo.setFieldLabel(screenLabels['monitor.currentAlarms.Filter by']);

		var subFilterCombo = Ext.getCmp('subFilterCombo');
		subFilterCombo.getStore().loadRawData(e.jsonData['optionsForFilterSelection']);
		subFilterCombo.setValue(pageParams['selectedSubFilterOption']);
		subFilterCombo.setFieldLabel(pageParams['subFilterLabel']);
		var zoneNameTxt = e.jsonData['hiddenParams']['zoneName'];
		var isZoneDash = false;
		if(!Ext.isEmpty(zoneNameTxt)&& zoneNameTxt!=null && zoneNameTxt!=undefined && zoneNameTxt!='null' && zoneNameTxt!='undefined')
		isZoneDash = true;

		if(e.jsonData['pageParams']['alarmType']=='longestAlarms')
		{
			if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
				Ext.getCmp('filterCombo').hide();
			if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
				Ext.getCmp('subFilterCombo').hide();
			if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
				Ext.getCmp('searchTextBox').hide();
		}
		else if(e.jsonData['pageParams']['alarmType']!='longestAlarms')
		{
			if(!isZoneDash)
			{
				if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
					Ext.getCmp('filterCombo').show();
				if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
					Ext.getCmp('subFilterCombo').show();
				if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
					Ext.getCmp('searchTextBox').hide();
			}
			else
			{
				if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
					Ext.getCmp('filterCombo').hide();
				if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
					Ext.getCmp('subFilterCombo').hide();
				if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
					Ext.getCmp('searchTextBox').hide();
			}
		}

		var dataAvailable = e.jsonData['dataAvailable'];
		if(dataAvailable!=null && dataAvailable=="true"){
			Ext.getCmp('searchTextBox').show();
		}else
			Ext.getCmp('searchTextBox').hide();

		/*	var searchByCombo = Ext.getCmp('searchByCombo');
		searchByCombo.getStore().loadRawData(e.jsonData['searchComboOpts']);
		searchByCombo.setValue(pageParams['selectedSearchOption']);
		searchByCombo.setFieldLabel(screenLabels['monitor.common.Search by']);*/
	}
});