Ext.define('SpecificThreshold.view.ViewThresholds', {
	extend: 'Ext.form.Panel',
	//extend:'utilities.OuterPanel',
	alias: 'widget.viewthresholds',
	id: 'specificViewThresholdId',
	ui:'simplePanel simplePanelHeaderBorder',
	autoScroll: true,

	//cls:'outerpanel',
	title: homeTitle,
	margin: '8 8 0 8',
	//frame: true,

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	requires : [
		'utilities.ScrollCombo',
		'utilities.CustomGrid',
		'utilities.ScrollTabPanel'
	],

	/*dockedItems: [
		{
			xtype: 'toolbar',
			dock: 'top',
			id: 'viewDock',
			cls:'adminHeadInfoText',
			height: 25,
			padding: 3,
			border:true,
			layout:{pack:'center'},
			items: [
				{
					xtype: 'component',
					html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDesc1+'.</center>',
				}
			]
		}
	],*/

	items: [
		{
			xtype: 'component',
			id: 'hostTestMsgComponent',
			html: '<center>'+hostTestMsg+'<center>',
			margin: '10 0 0 0',
			hidden: true
		},
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			margin: 10,
			items: [
				{
					xtype: 'fieldset',
					cls:'fieldset',
					id: 'fieldTitleId',
					title: '',
					margin: 10,
					flex: 1,
					hidden: true,
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					items: [
						{
							xtype: 'container',
							id: 'displayContainer',
							layout: {
								type: 'hbox',
								pack: 'start',
							},
							width: 947,
							margin: '0 0 15 0',
							items: [
								{
									xtype: 'displayfield',
									id: 'compTypeDisplayField',
									fieldLabel: label1,
									value: '',
									labelAlign: 'top',
									labelSeparator: ' ',
									width: 250
								},
								{
									xtype: 'displayfield',
									id: 'compNameDisplayField',
									fieldLabel: label5,
									value: '',
									labelAlign: 'top',
									labelSeparator: ' ',
									width: 250,
									margin: '0 0 0 20'
								},
								{
									xtype: 'displayfield',
									id: 'pattNameDisplayField',
									fieldLabel: pattrenLabel,
									value: '',
									labelAlign: 'top',
									labelSeparator: ' ',
									width: 250,
									hidden: true,
									margin: '0 0 0 20'
								}
							]
						},
						{
							xtype: 'component',
							id: 'patternMsgComponent',
							html: '<center>'+patternDescMsg+'<center>',
							margin: '10 0 10 0',
							hidden: true
						},
						{
							xtype: 'customgrid',
							ui:'newGridPanel whiteHeader',
							border:true,
							id: 'measureGrid',
							title: titleGrid1,
							hidden: true,
							store:new Ext.data.Store(
							{
								fields: ['Measure','Threshold','AlarmPolicy','isToolTip'],
								data: []
							}),
							autoScroll: true,
							hideHeaders: true,
							columns: {
								defaults: {
									sortable: false,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items: [
									{
										text: measureText,
										dataIndex: 'Measure',
										width: 245
									},
									{
										text: thresholdText,
										dataIndex: 'Threshold',
										width: 550,
										renderer : function(value, metaData, record, row, col, store, gridView) {
											metaData.tdCls ="threshold_tdcls";
											//value = "Min|-|2|-#Max|99|90|80" - For reference
											var measures = value.split("#");
											var measuresLen = measures.length;
											var result = "";
											var toolTipMsg = record.data.isToolTip;
											var critMsg = '';
											var majorMsg = '';
											if (toolTipMsg)
											{
												critMsg = '<img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>';
												majorMsg = '<img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>';
											}
											else
											{
												critMsg = '';
												majorMsg = '';
											}
											if (measuresLen == 1)
											{
												var vals = measures[0].split("|");
												result = '<table border="0" cellspacing="0" cellpadding="0" class="font_normal11 threshold_table"><tr><td width="70" height="20" class="font_bold11" valign="top">'+vals[0]+'</td><td width="160" height="20" valign="middle" >'+vals[1]+' '+critMsg+'</td><td width="160" height="20" valign="top">'+vals[2]+' '+majorMsg+'</td><td width="160" height="20" valign="top">'+vals[3]+'</td></tr></table>'
											}
											else
											{
												var val0 = measures[0].split("|");
												var val1 = measures[1].split("|");
												result = '<table border="0" width="550" cellspacing="0" cellpadding="0" class="font_normal11 threshold_table"><tr><td style="width:70px !important;padding:0px;" height="20" class="font_bold11" valign="top">'+val0[0]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val0[1]+' '+critMsg+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val0[2]+' '+majorMsg+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val0[3]+'</td></tr><tr><td style="width:70px !important;padding:0px;" height="20" class="font_bold11" valign="top">'+val1[0]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val1[1]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val1[2]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val1[3]+'</td></tr></table>'
											}
											return result;
										}
									},
									{
										text: alarmPolText,
										dataIndex: 'AlarmPolicy',
										width: 114
									},
									{
										xtype: 'actioncolumn',
										//cls: 'tasks-icon-column-header tasks-edit-column-header',
										width: 36,
										//icon: '../../../../resources/images/edit_task.png',
										iconCls: 'iconModify',
										//tooltip: 'Modify',
										sortable: false,
										handler: function(view, rowIndex, colIndex, column, e) {
											me.handleEditIconClick(view, rowIndex, colIndex, column, e);
										},
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
										}
									}
								]
							},
							dockedItems: [
								{
									xtype: 'toolbar',
									dock: 'top',
									height: 25,
									padding: 0,
									items: [
										{
											xtype: 'label',
											text: measureText,
											width: 245,
											height: 25,
											cls:'gridlabelheader'
										},
										{
											xtype: 'label',
											text: maxminText,
											width: 70,
											height: 25,
											cls:'gridlabelheader',
											margin: '0 0 0 -2'
										},
										{
											xtype: 'label',
											text: criticalText,
											width: 160,
											height: 25,
											cls:'gridlabelheader'
										},
										{
											xtype: 'label',
											text: majorText,
											width: 160,
											height: 25,
											cls:'gridlabelheader',
											margin: '0 0 0 -2'
										},
										{
											xtype: 'label',
											text: minorText,
											width: 160,
											height: 25,
											cls:'gridlabelheader'
										},
										{
											xtype: 'label',
											text: alarmPolText,
											width: 114,
											height: 25,
											cls:'gridlabelheader',
											margin: '0 0 0 -2'
										},
										{
											xtype: 'label',
											text: '',
											width: 36,
											cls:'gridlabelheader',
											height: 25
										}
									]
								}
							]
						},
						{
							xtype: 'customgrid',
							ui:'newGridPanel whiteHeader',
							border:true,
							id: 'noMeasureGrid',
							title: titleGrid2,
							hidden: true,
							frame:false,
							store:new Ext.data.Store(
							{
								fields: ['Measure1','Measure2','Measure3'],
								data: []
							}),
							autoScroll: true,
							hideHeaders: true,
							selModel: {
								selType: 'cellmodel',
								mode: 'SINGLE'
							},
							width: 947,
							columns: {
								defaults: {
									sortable: false,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items: [
									{
										text: '',
										dataIndex: 'Measure1',
										flex: 1,
										renderer:function( val,metadata ) {
											if (val != null || val != '')
												val = '<div style="cursor:pointer;">'+val+'</div>';
											metadata.style = 'white-space: normal;';
											return val;
										}
									},
									{
										text: '',
										dataIndex: 'Measure2',
										flex: 1,
										renderer:function( val,metadata ) {
											if (val != null || val != '')
												val = '<div style="cursor:pointer;">'+val+'</div>';
											metadata.style = 'white-space: normal;';
											return val;
										}
									},
									{
										text: '',
										dataIndex: 'Measure3',
										flex: 1,
										renderer:function( val,metadata ) {
											if (val != null || val != '')
												val = '<div style="cursor:pointer;">'+val+'</div>';
											metadata.style = 'white-space: normal;';
											return val;
										}
									}
								]
							},
							margin: '10 5 5 5'
						},
						{
							xtype: 'container',
							id: 'deleteBtnContainer',
							hidden: true,
							frame: true,
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: '10 0 0 0',
							items: [
								{
									xtype: 'button',
									id: 'deleteBtn',
									text: delText,
									ui:'newButtonSmall',
									width: 80
								},
								{
									xtype: 'button',
									id: 'applyToOtherCompBtn',
									text: label10,
									ui:'newButtonSmall',
									width: 180,
									margin: '0 0 0 10'
								}
							]
						}
					]
				},
				{
					xtype: 'scrolltabPanel',
					ui:'newTabPanelBasic whiteHeader',
					border:true,
					frame: false,
					id: 'specificDescTab',
					hidden: true,
					plain: true,
					tabPosition: 'top',
					width: 980,
					margin: 10,
					items: [
						{
							title: tabMsg1,
							flex: 1,
							items: [
								{
									xtype: 'grid',
									border:true,
									ui:'newGridPanel whiteHeader',
									id: 'specificDescriptorGrid',
									store: new  Ext.data.Store({
										fields: ['Test1', 'Test2', 'Test3'],
										data: []
									}),
									hideHeaders: true,
									columns: {
										defaults: {
											sortable: false,
											hideable: false,
											menuDisabled: true,
											draggable: false,
											resizable: false
										},
										items: [
											{
												text: '',
												dataIndex: 'Test1',
												flex: 1,
												renderer:function( val,metadata ) {
													metadata.style = 'white-space: normal;';
													return val;
												}
											},
											{
												text: '',
												dataIndex: 'Test2',
												flex: 1,
												renderer:function( val,metadata ) {
													metadata.style = 'white-space: normal;';
													return val;
												}
											},
											{
												text: '',
												dataIndex: 'Test3',
												flex: 1,
												renderer:function( val,metadata ) {
													metadata.style = 'white-space: normal;';
													return val;
												}
											}
										]
									},
									margin: 5
								}
							]
						}
					]
				}
			]
		}
	],

	tools: [
		{
			xtype : 'button',
			id: 'viewThreshBackBtn',
			text : btnText1,
			iconCls:'iconBack',
			cls:'backbutton'
		}
	],
	listeners: {
		boxready: function() 
		{
			new Ext.ToolTip({
				target: document.getElementById('homeTitle'),
				//id: 'homeTip',
				anchor: 'top',
				//anchortoTarget: true,
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: pageDesc1,
				cls: "adminInfoTooltip"
			});
		}
	}


});



