<%
/*****************************************************************
*	Author			:		T.Thirumal Azhagan
*	Name            :       EgAssociateThreshPolicy.jsp
*	Version			:		4.0
*	Purpose         :     
******************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.eg.EgServerGroupBean" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import ="egurkha.EgDbAdapterUI"%>
<%@ page import ="com.eg.EgDbAdapterTypeUI"%>
<%@ page import="java.sql.*" %>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject hiddenObj = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	String pfmanage = "";
	String strHiddenVal = "";
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	EgServerGroupBean descGrpp = new EgServerGroupBean();
	EgSpecsInfo specInfo = new EgSpecsInfo("manager");
	List listManagedComponents = ri.getAllServers();
	boolean isCompManaged = (listManagedComponents != null && !listManagedComponents.isEmpty());


	//String ServerType = request.getParameter("ServerType");
	String ServerType = (String)session.getAttribute("ServerType");
	String serv=request.getParameter("serv");
	rootJson.put("ServerType",ServerType);

	if(serv==null)
		serv="";
	String testcon=request.getParameter("test");
	if (ServerType != null && ServerType.equals("null"))
	{
		ServerType = "Groups";
	}
	String subject = "THRESHOLDPOLICIES";
	String subject1 = "THRESH_POLICY_MAPPING";
	String s_policy = request.getParameter("policyN");
	String s_testName = (String) session.getAttribute("TestName");	//1/30/2006
	Vector value2=new Vector();
	String s_val="";
	String serverNameForGrp="";
	String strCompType="";

	String rulE = request.getParameter("rulE");
	if (rulE == null)
		rulE = "All";

	String fromUI = request.getParameter("fromUI");
	String action = request.getParameter("action");
	if(!StringUtils.isNull(action))
	{
		action = StringUtils.decodeSecurityChar(action);
	}

	Vector vec_serverGroup = new Vector();
	Vector server = null;

	String testName = "";
	String serverType = "";
	boolean compare = false;
	
	String[] serverGroups = descGrpp.getServerGroups();
	if((!StringUtils.isNull(s_policy) && !s_policy.equals("-1")) && serverGroups != null && serverGroups.length > 0)
	{
		testName = descGrpp.getTestNameForPolicy(s_policy);
		for(int i=0;i<serverGroups.length;i++)
		{
			if(!serverGroups[i].equals(subject))
			{
				serverType = descGrpp.getServerType(serverGroups[i]);
				compare = specInfo.isTestRelevantForServer(serverType,testName);
				if(compare)
				{
					vec_serverGroup.add(serverGroups[i]);
				}
			}
		}
		Vector vecc = descGrpp.getServerGroupForPolicy(s_policy);
		TreeSet t_set = new TreeSet();
		if(vecc != null && vecc.size() > 0)
		{
			for(int z=0;z<vecc.size();z++)
			{
				String serGrp = (String) vecc.get(z);
				serverType = descGrpp.getServerType(serGrp);
				if(specInfo.isTestRelevantForServer(serverType,testName))
				{
					t_set.add(serGrp);
				}
			}
			//vec_serverGroup.removeAll(t_set);
		}
	}

	ArrayList containsTestsAl = new ArrayList();
	ArrayList startsWithTestsAl = new ArrayList();
	ArrayList endsWithTestsAl = new ArrayList();
	ArrayList wildCardDescList  = new ArrayList();
	Hashtable containsWildCards = new Hashtable();
	Hashtable startsWithWildCards = new Hashtable();
	Hashtable endsWithWildCards = new Hashtable();

	Vector v_vec_pol = descGrpp.getAllPolicyName(subject);
	Vector vec_pol = new Vector();
	if (!StringUtils.isNull(s_policy) && !s_policy.equals("-1"))
	{
		Vector v_Var = descGrpp.getVariablesForPolicyName(subject1,s_policy);
		TreeSet ee = descGrpp.getManagedInfosForPolicy(s_policy);
		TreeSet groupSet = new TreeSet();
		if (ee != null && ee.size() > 0)
		{
			server = descGrpp.getServerGroupForPolicy(s_policy);
			if(!StringUtils.isNull(fromUI))
			{
				ArrayList actualDescriptors = getTestLiveDescriptorsForComponent(vec_serverGroup, s_policy, testName);
				JSONArray existInfoComboArr = new JSONArray();
				JSONObject existInfoComboObj = new JSONObject();
				JSONArray existInfoArr = new JSONArray();
				
				Iterator it = ee.iterator(); // Iterator interface
				while (it.hasNext()) 
				{
					String info = (String) it.next();
					existInfoArr.add(info);
					System.out.println(info);

					if (!StringUtils.isNull(info) && (!actualDescriptors.isEmpty() && actualDescriptors.contains(info)) )
					{
						continue;
					}

					existInfoComboObj.put("displayField",info);
					existInfoComboObj.put("valueField",info);
					existInfoComboArr.add(existInfoComboObj);					

					if (info != null && info.indexOf("*") != -1)
					{
						wildCardDescList.add(info);
					}

					String matchVar = s_policy;
					if (info.startsWith("*") && info.endsWith("*"))
					{
						int index = containsTestsAl.indexOf(matchVar);
						if(index >= 0)
						{
							ArrayList temp = (ArrayList) containsWildCards.get(matchVar);
							temp.add(info);
							containsWildCards.put(matchVar, temp);
							continue;
						}
						else
						{
							ArrayList temp = new ArrayList();
							temp.add(info);
							containsWildCards.put(matchVar, temp);
						}
						containsTestsAl.add(matchVar);
					}
					else if (!info.startsWith("*") && info.endsWith("*"))
					{
						int index = startsWithTestsAl.indexOf(matchVar);
						if(index >= 0)
						{
							ArrayList temp = (ArrayList) startsWithWildCards.get(matchVar);
							temp.add(info);
							startsWithWildCards.put(matchVar, temp);
							continue;
						}
						else
						{
							ArrayList temp = new ArrayList();
							temp.add(info);
							startsWithWildCards.put(matchVar, temp);
						}
						startsWithTestsAl.add(matchVar);
					}
					else if (info.startsWith("*") && !info.endsWith("*"))
					{
						int index = endsWithTestsAl.indexOf(matchVar);
						if(index >= 0)
						{
							ArrayList temp = (ArrayList) endsWithWildCards.get(matchVar);
							temp.add(info);
							endsWithWildCards.put(matchVar, temp);
							continue;
						}
						else
						{
							ArrayList temp = new ArrayList();
							temp.add(info);
							endsWithWildCards.put(matchVar, temp);
						}
						endsWithTestsAl.add(matchVar);
					}
				}
				rootJson.put("existInfoArr",existInfoArr);
				rootJson.put("wildCardDescList",wildCardDescList);
				rootJson.put("existInfoComboArr",existInfoComboArr);
				if (existInfoComboArr != null && existInfoComboArr.size() > 0)
				{
					rootJson.put("isExistPatterns",true);
				}
				else
				{
					rootJson.put("isExistPatterns",false);
				}

				if (containsWildCards != null && !containsWildCards.isEmpty())
				{
					rootJson.put("containsWildCardPatterns",getWildCardPatternsForTests(containsWildCards, "contains"));
				}

				if (startsWithWildCards != null && !startsWithWildCards.isEmpty())
				{
					rootJson.put("startsWithWildCardPatterns",getWildCardPatternsForTests(startsWithWildCards, "startswith"));
				}

				if (endsWithWildCards != null && !endsWithWildCards.isEmpty())
				{
					rootJson.put("endsWithWildCardPatterns", getWildCardPatternsForTests(endsWithWildCards, "endswith"));
				}
			}
			for(int j=0;j<v_Var.size();j++)
			{
				String _var = (String)v_Var.get(j);
				StringTokenizer st = new StringTokenizer(_var,"#");
				boolean isAll = (st.countTokens() == 2);
				if(rulE.equalsIgnoreCase("All"))
				{
					String group = st.nextToken();
					if(isAll && server.contains(group))
					{
						groupSet.add(group);
					}
				}
				else if(rulE.equalsIgnoreCase("Specific"))
				{
					String group = st.nextToken();

					if(!isAll && server.contains(group))
					{
						st.nextToken();
						String info = st.nextToken();
						if (info.indexOf("*") != -1)
						{
							continue;
						}
						groupSet.add(group);
					}
				}
				else if(rulE.equalsIgnoreCase("descpattern"))
				{
					String group = st.nextToken();

					if(!isAll && server.contains(group))
					{
						st.nextToken();
						String info = st.nextToken();
						if (!StringUtils.isNull(action) && !action.equalsIgnoreCase(info))
						{
							continue;
						}
						groupSet.add(group);
					}
				}
				/*else 
				{
					String group = st.nextToken();

					if(!isAll && server.contains(group))
					{
						groupSet.add(group);
					}
				}*/
			}
			server = new Vector(groupSet);
		}
		else
		{
			if (rulE != null && rulE.equalsIgnoreCase("All"))
			{
				server = descGrpp.getServerGroupForPolicy(s_policy);
			}
			//rulE = request.getParameter("rulE");
			//if (rulE != null && rulE.equals("specific"))
			//{
			//	server = null;
			//}
		}
	}

	if(!StringUtils.isNull(rulE) && rulE.equals("descpattern") && !StringUtils.isNull(action) && action.equalsIgnoreCase("-1"))
	{
		server = null;
	}
	String spolicy;
	String stestName;
	ArrayList ruleTests = new ArrayList();
	if (v_vec_pol != null && v_vec_pol.size() > 0)
	{
		for (int y=0;y<v_vec_pol.size();y++)
		{
			spolicy = (String) v_vec_pol.get(y);
			stestName = descGrpp.getTestNameForPolicy(spolicy);
			ruleTests.add(stestName);
			if (stestName.equalsIgnoreCase(s_testName))
			{
				vec_pol.add(spolicy);
			}
		}
	}
	if (ServerType == null || ServerType.equals("Groups"))
	{
		vec_pol = v_vec_pol;
	}

	ArrayList associatedGroupTest = new ArrayList(); //filter unassociated rules
	if (ruleTests != null && ruleTests.size() > 0)
	{
		String tempPrevServer = null;
		for(int i=0;i<ruleTests.size();i++)
		{
			String ruleTest = (String) ruleTests.get(i);
			for(int j=0;j<listManagedComponents.size();j++)
			{
				String tmpManagedComp =(String)listManagedComponents.get(j);
				tmpManagedComp = tmpManagedComp.substring(0,tmpManagedComp.indexOf(":"));
				if (j == 0)
				{
					tempPrevServer = tmpManagedComp;
				}
				else
				{
					if(!StringUtils.isNull(tempPrevServer) && tempPrevServer.equals(tmpManagedComp))
					{
						tempPrevServer = tmpManagedComp;
						continue;
					}
					tempPrevServer = tmpManagedComp;
				}
				String[] tempArrTests = specInfo.getTestsForServer(tmpManagedComp);
				if (tempArrTests != null && tempArrTests.length > 0)
				{
					ArrayList managedTestList = new ArrayList(Arrays.asList(tempArrTests));
					if (managedTestList != null && managedTestList.size() > 0 && managedTestList.contains(ruleTest))
					{
						associatedGroupTest.add(ruleTest);
						break;
					}
				}
			}
		}

		if (associatedGroupTest != null && associatedGroupTest.size() > 0)
		{
			Vector tmpVector = new Vector();
			for(int i=0;i<vec_pol.size();i++)
			{
				String aa = (String) vec_pol.get(i);
				String test = descGrpp.getTestNameForPolicy(aa);
				if(associatedGroupTest.contains(test))
				{
					tmpVector.add(aa);
				}
			}
			vec_pol = tmpVector;
		}
	}

	session.setAttribute("egPageDesc","EgAssociateThreshPolicy.jsp");

	hiddenObj.put("serv",serv);
	hiddenObj.put("testcon",testcon);
	hiddenObj.put("policy",s_policy);
	hiddenObj.put("rule",rulE);
	screenLabels.put("title","Associate / Disassociate Threshold Component Groups");
	if (isCompManaged)
	{
		if(vec_pol != null && vec_pol.size() > 0)
		{
			Collections.sort(vec_pol,String.CASE_INSENSITIVE_ORDER);
			String policy = "";
			rootJson.put("isNoData",false);

			screenLabels.put("rule_Label",_mapping.getTextDescription("admin.threshold.Choose rule to associate/disassociate threshold component group"));
			JSONArray grpThreshPolicyArr = new JSONArray();
			JSONObject grpThreshPolicyObj = new JSONObject();
			grpThreshPolicyObj.put("displayField",_mapping.getTextDescription("admin.common.Choose One"));
			grpThreshPolicyObj.put("valueField","-1");
			grpThreshPolicyArr.add(grpThreshPolicyObj);

			if(vec_pol != null && vec_pol.size() > 0)
			{
				for(int i=0;i<vec_pol.size();i++)
				{
					grpThreshPolicyObj = new JSONObject();
					policy = (String) vec_pol.get(i);
					grpThreshPolicyObj.put("displayField",policy);
					grpThreshPolicyObj.put("valueField",policy);
					grpThreshPolicyArr.add(grpThreshPolicyObj);
					if(s_policy != null)
					{
						if(s_policy.equals(policy))
						{
							rootJson.put("selectedPolicyName",policy);
						}
					}
				}
			}
			rootJson.put("grpThreshPolicyArr",grpThreshPolicyArr);
			screenLabels.put("apply_rule_label",_mapping.getTextDescription("admin.threshold.Apply this rule to"));

			JSONArray grpThreshPolicyTypeArr = new JSONArray();
			if (rulE == null || rulE.length() == 0)
			{
				JSONObject grpThreshPolicyTypeObj = new JSONObject();
				grpThreshPolicyTypeObj.put("displayField",_mapping.getTextDescription("admin.threshold.All descriptors"));
				grpThreshPolicyTypeObj.put("valueField","All");
				grpThreshPolicyTypeArr.add(grpThreshPolicyTypeObj);

				grpThreshPolicyTypeObj = new JSONObject();
				grpThreshPolicyTypeObj.put("displayField",_mapping.getTextDescription("admin.threshold.Specific descriptors"));
				grpThreshPolicyTypeObj.put("valueField","specific");
				grpThreshPolicyTypeArr.add(grpThreshPolicyTypeObj);

				grpThreshPolicyTypeObj = new JSONObject();
				grpThreshPolicyTypeObj.put("displayField",_mapping.getTextDescription("admin.threshold.Specific descriptor pattern"));
				grpThreshPolicyTypeObj.put("valueField","descpattern");
				grpThreshPolicyTypeArr.add(grpThreshPolicyTypeObj);
			}
			else
			{
				JSONObject grpThreshPolicyTypeObj = new JSONObject();
				grpThreshPolicyTypeObj.put("displayField",_mapping.getTextDescription("admin.threshold.All descriptors"));
				grpThreshPolicyTypeObj.put("valueField","All");
				grpThreshPolicyTypeArr.add(grpThreshPolicyTypeObj);

				grpThreshPolicyTypeObj = new JSONObject();
				grpThreshPolicyTypeObj.put("displayField",_mapping.getTextDescription("admin.threshold.Specific descriptors"));
				grpThreshPolicyTypeObj.put("valueField","specific");
				grpThreshPolicyTypeArr.add(grpThreshPolicyTypeObj);

				grpThreshPolicyTypeObj = new JSONObject();
				grpThreshPolicyTypeObj.put("displayField",_mapping.getTextDescription("admin.threshold.Specific descriptor pattern"));
				grpThreshPolicyTypeObj.put("valueField","descpattern");
				grpThreshPolicyTypeArr.add(grpThreshPolicyTypeObj);

				if (rulE.equals("All"))
				{
					rootJson.put("selectedType","All");
				}
				else if (rulE.equals("specific"))
				{
					rootJson.put("selectedType","specific");
				}
			}
			rootJson.put("grpThreshPolicyTypeArr",grpThreshPolicyTypeArr);
			rootJson.put("admin.threshold.Associated Component Group(s)",_mapping.getTextDescription("admin.threshold.Associated Component Group(s)"));
			JSONArray grpAssoCompGroupsArr = new JSONArray();

			if(server != null && server.size() > 0)
			{
				Collections.sort(server,String.CASE_INSENSITIVE_ORDER);
				for(int x=0;x<server.size();x++)
				{
					JSONObject grpAssoCompGroupsObj = new JSONObject();
					s_val = (String) server.get(x);
					Vector allManagedGrpComps = descGrpp.getComponentNames(s_val);
					Vector allManGrpCompWithType =new Vector();
					serverNameForGrp = descGrpp.getServerType(s_val);
					if(allManagedGrpComps != null && allManagedGrpComps.size() > 0)
					{
						for(int c= 0;c<allManagedGrpComps.size();c++)
						{
							String strManComp = (String) allManagedGrpComps.get(c);
							strCompType = serverNameForGrp+":"+strManComp;
							if(!allManGrpCompWithType.contains(strCompType))
							{
								allManGrpCompWithType.add(strCompType);
							}
						}
					}

					if(!listManagedComponents.containsAll(allManGrpCompWithType))
					{
						strHiddenVal +=","+s_val;
						continue;
					}
					value2.add(s_val);
					pfmanage += s_val +",";
					grpAssoCompGroupsObj.put("displayField",s_val);
					grpAssoCompGroupsObj.put("valueField",s_val);
					grpAssoCompGroupsArr.add(grpAssoCompGroupsObj);
				}
			}
			rootJson.put("grpAssoCompGroupsArr",grpAssoCompGroupsArr);
			rootJson.put("admin.threshold.Disassociated Component Group(s)",_mapping.getTextDescription("admin.threshold.Disassociated Component Group(s)"));
			JSONArray grpDisAssoCompGroupsArr = new JSONArray();

			if (vec_serverGroup.size() > 0)
			{
				Collections.sort(vec_serverGroup,String.CASE_INSENSITIVE_ORDER);
				for(int z=0;z<vec_serverGroup.size();z++)
				{
					JSONObject grpDisAssoCompGroupsObj = new JSONObject();
					String value = (String) vec_serverGroup.get(z);
					if(server != null && server.contains(value))
					{
						continue;
					}

					Vector allUnManagedGrpComps = descGrpp.getComponentNames(value);
					Vector allUnManGrpCompWithType =new Vector();
					serverNameForGrp = descGrpp.getServerType(value);
					if(allUnManagedGrpComps != null && allUnManagedGrpComps.size() > 0)
					{
						for(int c= 0;c<allUnManagedGrpComps.size();c++)
						{
							String strUnManComp = (String) allUnManagedGrpComps.get(c);
							strCompType = serverNameForGrp+":"+strUnManComp;
							if(!allUnManGrpCompWithType.contains(strCompType))
							{
								allUnManGrpCompWithType.add(strCompType);
							}
						}
					}
					if(!listManagedComponents.containsAll(allUnManGrpCompWithType))
					{
						continue;
					}
					grpDisAssoCompGroupsObj.put("displayField",value);
					grpDisAssoCompGroupsObj.put("valueField",value);
					grpDisAssoCompGroupsArr.add(grpDisAssoCompGroupsObj);
				}
				rootJson.put("grpDisAssoCompGroupsArr",grpDisAssoCompGroupsArr);
			}
		}
		else
		{
			rootJson.put("isNoData",true);
			rootJson.put("No_data",_mapping.getTextDescription("admin.threshold.No policies currently available"));
		}
	}
	else
	{
		rootJson.put("isNoData",true);
		rootJson.put("No_data",_mapping.getTextDescription("admin.threshold.No policies currently available"));
	}

	if(pfmanage != null && pfmanage.length()>0 && pfmanage.indexOf(",") != -1)
	{
		pfmanage = pfmanage.substring(0,pfmanage.lastIndexOf(","));
	}
	session.setAttribute("pfmanage",pfmanage);
	hiddenObj.put("pfmanage",pfmanage);
	hiddenObj.put("strHiddenVal",strHiddenVal);
	hiddenObj.put("value2",value2);
	hiddenObj.put("value3",value2);


//if(request.getQueryString()!=null)
//session.setAttribute("adminLastAccessedURL","/final/admin/EgGroupThreshold.jsp?"+request.getQueryString());
//else session.setAttribute("adminLastAccessedURL","/final/admin/EgGroupThreshold.jsp");


rootJson.put("screenLabels",screenLabels);
rootJson.put("hiddenObj",hiddenObj);
out.println(rootJson.toString());

%>

<%!

	private JSONObject getWildCardPatternsForTests(Hashtable wildCards, String wildCardType)
	{
		ArrayList testsList =  new ArrayList();
		JSONObject wildCardPattObj = new JSONObject();
		Iterator iterAll = wildCards.keySet().iterator();
		while(iterAll.hasNext())
		{
			String test = (String) iterAll.next();
			testsList.add(test);
		}

		for(int t=0;t<testsList.size();t++)
		{
			String strTest = (String) testsList.get(t);
			ArrayList pattList =  (ArrayList) wildCards.get(strTest);
			JSONArray wildCardPattArr = new JSONArray();

			for(int i=0;i<pattList.size();i++)
			{
				String strOuterPattName = (String) pattList.get(i);
				String outerPattNameOnly = strOuterPattName;
				if (wildCardType != null && wildCardType.equalsIgnoreCase("contains"))
				{
					outerPattNameOnly = strOuterPattName.substring(1, strOuterPattName.length() -1);
				}
				else if (wildCardType != null && wildCardType.equalsIgnoreCase("startswith"))
				{
					outerPattNameOnly = strOuterPattName.substring(0, strOuterPattName.length() -1);
				}
				else if (wildCardType != null && wildCardType.equalsIgnoreCase("endsWith"))
				{
					outerPattNameOnly = strOuterPattName.substring(1);
				}
				//int outerPattLength = outerPattNameOnly.length();
				wildCardPattArr.add(outerPattNameOnly);
			}

			if (wildCardPattArr != null && wildCardPattArr.size() > 0) 
			{
				wildCardPattObj.put(strTest,wildCardPattArr);
			}
		}

		return wildCardPattObj;
	}

	private ArrayList getTestLiveDescriptorsForComponent(Vector serverGroupList, String policyName, String testName) throws SQLException
	{
		ArrayList result = new ArrayList();
		ArrayList hostLevelTestsList = new ArrayList();
		EgDbAdapterUI egDb;
		EgTestInfo testInfo = new EgTestInfo("manager");
		EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
		IniFile iniobj=new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini",false);
		String compType=null;
		Vector vec_comp=null;
		Hashtable ht = new Hashtable();
		ResultSet rs = null;

		String[] hostTests = specsInfo.getDefaultTestsForServer("Host_system");
		if (hostTests != null)
		{
			hostLevelTestsList = new ArrayList(Arrays.asList(hostTests));
		}

		if(serverGroupList != null && serverGroupList.size() != 0)
		{
			EgServerGroupBean descGrpp = new EgServerGroupBean();

			Hashtable compInfoHash = new Hashtable();
			Vector compNamesInGrps = new Vector();
			int sizOfal = serverGroupList.size();
			for(int q=0; q<sizOfal ; q++)
			{
				String serverGroup = (String)serverGroupList.get(q);
				//testName = descGrpp.getTestNameForPolicy(policyName);
				compType = descGrpp.getServerType(serverGroup);
				vec_comp = descGrpp.getComponentNames(serverGroup);
				if(vec_comp != null && vec_comp.size() > 0)
				{
					compNamesInGrps.addAll(vec_comp);
				}

				//compName = (String) vec_comp.get(x);
				egDb=EgDbAdapterTypeUI.getObject();
				try
				{
					boolean isConnected = false;
					String status = egDb.setConnection();
					if(status.equals("CONNECTED"))
						isConnected = true;
					if(isConnected)
					{
						//String query = egDb.getInfosForDescGroup(compName,compType,testName);
						String query;
						if(EgDbInfo.isSqlAdapter)
						{
							query = "SELECT comp_name, info FROM metatest with (NOLOCK) WHERE " + 
							"test_name='" + testName + "'  AND " +
							"(comp_type='" + compType + "' OR comp_type='Host_system')";
						}
						else
						{
							query = "SELECT comp_name, info FROM metatest WHERE " + 
							"test_name='" + testName + "' AND " +
							"(comp_type='" + compType + "' OR comp_type='Host_system')";
						}
						rs=egDb.SelectExec(query);
						while(rs.next())
						{
							String comp_name = rs.getString("comp_name");
							String inf = rs.getString("info");
							if(!inf.equals("+"))
							{
								String info = inf.substring(inf.indexOf("+")+1);

								HashSet compInfosSet = (HashSet) compInfoHash.get(comp_name);
								if(compInfosSet != null)
								{
									compInfosSet.add(info);
								}
								else
								{
									compInfosSet = new HashSet();
									compInfosSet.add(info);
									compInfoHash.put(comp_name,compInfosSet);
								}
							}
						}
					}
					rs.close();
					egDb.releaseConnection(false);
					EgDbAdapterTypeUI.releaseObject(egDb);
				}
				catch(SQLException e)
				{
					if(rs != null)
						rs.close();
					egDb.releaseConnection(true);
					EgDbAdapterTypeUI.releaseObject(egDb);
				}
			}

			if (compInfoHash.size() > 0)
			{
				Enumeration ee = compInfoHash.keys();
				HashSet tmpInfosLst = new HashSet();
				while (ee.hasMoreElements())
				{
					String key = (String) ee.nextElement();
					HashSet vars = (HashSet)compInfoHash.get(key);
					if(compNamesInGrps != null && compNamesInGrps.contains(key))
					{
						tmpInfosLst.addAll(vars);
					}
				}
				
				result = new ArrayList();
				result.addAll(tmpInfosLst);
			}
		}
		return result;
	}


%>


