<!DOCTYPE html>

<%@ include file = "EgTrackerA.jsp" %>

<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import ="com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "net.sf.json.JSONArray"%>
<%@ page import = "net.sf.json.JSONObject"%>

<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	JSONArray resultAgentsArr = new JSONArray();
	JSONObject resultAgentObj = new JSONObject();

	UserRegistry registry1 = UserRegistry.getInstance();
	User user = registry1.getUser(session.getId());

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("default"))
	{
		userDateFormat = currentDateFormat;
	}

	// If user date format is set, assign it to current date format.
	if (userDateFormat != null)
	{
		currentDateFormat = userDateFormat;
	}

%>

<html>
<head>
	<meta charset="utf-8">

	<egui:skin ui="admin"/>

	<title>REST CLIENT</title>
	<script language="JavaScript1.2" src="/final/scripts/eg_DateUtil.js"></script>
	<script language="JavaScript" src="eg_scripts/validate.js"></script>
	<script language="JavaScript" src="../scripts/utilities/EncodeDecodeParams.js"></script>
	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<script language="JavaScript1.2">

		var apiMainJSON="";
		var paramsJson="";
		var prevParamValue="";

		var csrfToken = '<%=strCsrfToken%>';
		var mgrDateFormat = getExtjsDateFormat('<%=userDateFormat%>');
		var PageTitle = '<egui:intnl text="admin.title.REST API CLIENT"/>';
		var pageName = '<egui:intnl text="admin.title.REST API CLIENT"/>';
		var PageDesc = '<egui:intnl text="This page enables the administrator to execute REST API"/>';

		var invalidDateTime = '<egui:intnl text="From date should not be greater than To date"/>';

		var executeBtnLabel = '<egui:intnl text="admin.restclient.Execute"/>';
		var restClientHeader = '<egui:intnl text="admin.restclient.REST Client using HTTP Method"/>';
		var apiTypeLabel = '<egui:intnl text="admin.restclient.API Type"/>';
		var bulkOperationLabel = '<egui:intnl text="admin.restclient.Bulk Operation"/>';
		var apiNamelabel = '<egui:intnl text="admin.restclient.API Name"/>';
		var restUrlLabel = '<egui:intnl text="admin.restclient.API Endpoint URL"/>';
		var httpMethodLabel ='<egui:intnl text="admin.restclient.HTTP Method"/>';
		var authReqLabel ='<egui:intnl text="admin.restclient.Authentication Required"/>';
		var basicAuthLabel ='<egui:intnl text="admin.restclient.Basic Authentication"/>';
		var httpLabel = '<egui:intnl text="admin.restclient.HTTP"/>';
		var toolDeleteAll= '<egui:intnl text="admin.restclient.Delete All"/>';
		var toolDelete= '<egui:intnl text="admin.restclient.Delete"/>';
		var paramsRequiredLabel = '<egui:intnl text="admin.restclient.Params Required"/>';
		var paramsNameSelectLabel = '<egui:intnl text="admin.restclient.Select Parameter"/>';
		var paramsNameLabel = '<egui:intnl text="admin.restclient.Body Params"/>';
		var paramsValueLabel= '<egui:intnl text="admin.restclient.Value"/>';
		var downloadlinkLabel = '<egui:intnl text="admin.restclient.Download sample CSV"/>';
		var reponseLabel='<egui:intnl text="admin.restclient.Response"/>';
	
		var apiNameErrMsg='<egui:intnl text="admin.error.Select API Name"/>.';
		var paramValueErrMsg='<egui:intnl text="admin.error.Provide value for the parameter"/>.';
		var formDataValueErrMsg='<egui:intnl text="admin.error.Please select valid csv file"/>.';
		var componentTypeErrMsg='<egui:intnl text="admin.error.Please add Component Type param"/>.';		
		var componentNameErrMsg='<egui:intnl text="admin.error.Please add Component name param"/>';
		var testErrMsg='<egui:intnl text="admin.error.Please add Test param"/>';
		var filterByErrMsg='<egui:intnl text="admin.error.Please add filterBy param "/>';
		var paramreqErrMsg='<egui:intnl text="admin.error.Parameters required for this API. Please add required parameters "/>';
		var pwErrMsg='<egui:intnl text="admin.error.Please enter the password."/>';
		
		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';
		var spaceLbl='<egui:intnl text="admin.common.Spaces are not allowed for the file name"/>';


		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut +'.',
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage +'.',
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});

	</script>

	<!-- Application folder -->
	<style>
		
		.x-fieldset-header .x-fieldset-header-text,
		.labelbg,
		.x-form-item-label,
		.x-form-cb-label-after {
			font-size: 13px;
		}
		.x-form-checkboxgroup-body {
			padding: 1px 0px 1px 0px;
		}
		.x-form-text,
		.x-boundlist-item{
			font-size: 12px;
		}
		.x-btn-newButtonSmall-toolbar-small .x-btn-inner, 
		.x-btn-newButtonSmall-small .x-btn-inner {
			font-size: 16px;
			font-weight: normal;
		}
		.restApiUrl input{
			/*display: block;
			text-overflow: ellipsis;
			overflow: hidden;*/
			/*width: 250px !important*/

		}
	</style>
	<script type="text/javascript" src="EgRESTAPIClient/app/app.js"></script>
</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>

</html>

<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgRESTAPIClient.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgRESTAPIClient.jsp");
	}
%>



