<%
/***********************************************************************************
*	Name			:EgCustomizeMenu.jsp
***********************************************************************************/
%>

<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import ="com.egurkha.util.FileUtils"%>
<%@ page import = "com.eg.EgConMonHelper"%>
<%@ page import="com.egurkha.admin.EgToolKitInfo"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.Vector"%>
<%@ page import="java.util.Iterator"%>
<%@ page import="java.util.Hashtable"%>
<%@ page import="java.util.LinkedHashMap"%>
<%@ page import="java.util.StringTokenizer"%>
<%@ page import="com.egurkha.admin.EgToolKitInfo"%>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	EgToolKitInfo tkinfo = new EgToolKitInfo();
	if (!tkinfo.isToolkitAccessEnabled)
	{
		return;
	}

	String sessionInUse = request.getParameter("sessionInUse");
	String pwd = request.getParameter("pwd");
	String authenticated = (String)session.getAttribute("authenticated");
	
	if (authenticated == null)
	{
		// Direct access from the browser address bar or from inside the toolkit via the tool
		if (pwd == null)
		{
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=ConfigProfile");
				return;
			}
			else
			{
	%>
				<script>
					window.parent.location.href ="/final/toolkitlogin";
				</script>
	<%
				return;
			}
		}
		else
		{
			// Direct access from the browser address bar
			if (!pwd.equals(EgConMonHelper.executePwd))
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=ConfigProfile");
				return;
			}
			else
			{
				session.setAttribute("reqFromForTk","ConfigProfile");
				String redirectURL = request.getContextPath()+"/toolkit";
				response.sendRedirect(redirectURL);
				return;
			}
		}
	}
	else
	{
		// Direct access from the browser address bar and session in use
		if (sessionInUse == null)
		{
			response.sendRedirect(request.getContextPath()+"/toolkit");
			return;
		}
	}
	session.setAttribute("reqFromForTk","ConfigProfile");
	String comeFrom = request.getParameter("comeFrom");
	if (!StringUtils.isNull(comeFrom) && comeFrom.equals("ConfigProfile"))
	{
		session.setAttribute("treeViewSrc","ConfigProfile");
	}
	
	String resultMsg = request.getParameter("resultMsg");
	resultMsg = resultMsg == null || resultMsg.equalsIgnoreCase("null") ? "" : resultMsg;
	String defaultSelection = "No user password found";
	
	EgToolKitInfo tkInfo = new EgToolKitInfo();
	Vector u_profList = tkInfo.getProfileList();
	Vector u_passList = tkInfo.getUserPwdList();

	StringBuffer prof_buf = new StringBuffer();
	if(u_profList != null && !u_profList.isEmpty())
	{
		defaultSelection = "Select a profile";
		for(int i=0;i<u_profList.size();i++)
		{
			prof_buf.append((String)u_profList.get(i));
			prof_buf.append(",");
		}
	}
		
	StringBuffer cred_buf = new StringBuffer();
	if(u_passList != null && !u_passList.isEmpty())
	{
		for(int i=0;i<u_passList.size();i++)
		{
			cred_buf.append(com.eg.EgCrypt.decrypt((String)u_passList.get(i)));
			cred_buf.append(",");
		}
	}
	cred_buf.append(com.eg.EgCrypt.decrypt(tkInfo.defaultTkPwd));

	String profileType = "NotApplicable";
	StringBuffer menu_buf = new StringBuffer();
	String selProfileName = request.getParameter("s_profile_name");
	selProfileName = selProfileName == null ? "-1" : egurkha.EgUIUtils.decodeSecurityChar(selProfileName);
	String s_option = request.getParameter("s_option");
	s_option = s_option == null ? "add" : s_option;
	
	if(s_option.equalsIgnoreCase("modify") && !selProfileName.equals("-1"))
	{
		profileType = tkInfo.getProfileType(selProfileName);
		if(profileType.equalsIgnoreCase("Custom"))
		{
			menu_buf = tkInfo.getCustomProfileMenuItems(selProfileName,true);
		}
	}
	ArrayList excludeMenus = StringUtils.egTokenizer("ConfigProfile,ChangeProfilePwd",",");
	LinkedHashMap menuDynamicMap = tkInfo.getDynamicMenuMap(excludeMenus,true);
	
	int pass_length = 0;
	int pwdComplexityCount = 0;
	boolean isDouble = com.eg.EgDbInfo.doubleByteEnabled;

	IniFile egUI = new IniFile(com.eg.EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	String pwdLength = egUI.getValue("MISC_ARGS","PwdMinLen");
	if(pwdLength != null && pwdLength.trim().length()>0)
	{
		pass_length = Integer.parseInt(pwdLength); 
	}
	
	String pwdComplexity = egUI.getValue("MISC_ARGS","PwdComplexity");
	if(pwdComplexity != null && pwdComplexity.length()>0)
	{
		StringTokenizer pwdComplexStrTknzr = new StringTokenizer(pwdComplexity,",");
		pwdComplexityCount = pwdComplexStrTknzr.countTokens();
	}
	if (pass_length < 2)
	{
		pass_length = 8;
	}
	else if(pass_length < pwdComplexityCount)
	{
		pass_length = pwdComplexityCount;
	}
%>
<html>
<title>Customize Toolkit Menu</title>
<head>
<style>
.iconTooltipHelp{
	background : url('/final/images/Dark/eG_Icons.png') no-repeat top left;
	background-position: -80px -1140px; width: 16px; height: 16px;
}

.tooltip {
	position: relative;
	display: inline-block;
}

.tooltip .tooltiptext {
	visibility: hidden;
	width: 250px;
	background-color: #FBFBD3;
	color: black;
	text-align: center;
	border-radius: 6px;
	padding: 5px 0;
	position: absolute;
	z-index: 1;
	bottom: 125%;
	left: 30px;
	margin-left: -150px;
	padding-right: 20px;
	opacity: 0;
	transition: opacity 0.3s;
	word-break:break;
}

.tooltip .tooltiptext::after {
	content: "";
	position: absolute;
	top: 100%;
	left: 49%;
	margin-left: -5px;
	border-width: 5px;
	border-style: solid;
	border-color: #FBFBD3 transparent transparent transparent;
}

.tooltip:hover .tooltiptext {
	visibility: visible;
	opacity: 1;
}
</style>
<link REL = "StyleSheet" href = "/final/admin/eg_styles/adminstyle_blue.css"/>
<script src="/final/scripts/utilities/EncodeDecodeParams.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
<script language="javascript1.2" src="eg_scripts/validate.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/common.js"></script>
<script src="/final/jquery/jquery.js"></script>

<script>
document.onscroll = function()
{
	clearTimeout(time);
	time = setTimeout(logout,timeoutTime);
}
</script>
<script language="javascript">
var pass_length = parseInt('<%=pass_length%>');
var pass_CompCount = parseInt('<%=pwdComplexityCount%>');
var focusOnNewPwd = true;

var passLabel1 = 'Password should contain atleast';
var complexityLC = 'a lowercase alphabet';
var complexityUC = 'an uppercase alphabet';
var complexityNum = 'a number';
var complexitySplChars = 'a special character other than double quotes';
var complexityGeneralMsg = 'Password policy requirements are not satisfied';
var dblByteMsg = "is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte";

function pwdComplexityCheck(newPassword)
{
	var _start = "^";
	var _mid = "";
	var _end = ".+$";
	var result = "";
	var dot = ".";
	var brk = "\n";
	var pwdComplexity = '<%=pwdComplexity%>';
	if(pwdComplexity != null && pwdComplexity != undefined)
	{
		if(pwdComplexity.indexOf(",") > -1)
		{
			result = "false#";
			var pwdComplexVal = pwdComplexity.split(",");
			for(var k=0; k<pwdComplexVal.length; k++)
			{
				var temp = pwdComplexVal[k].toLowerCase().trim();
				if(temp == "lc")
				{
					_mid += "(?=.*[a-z])";
					result += brk+(k+1)+dot+" "+complexityLC;
				}
				else if(temp == "uc")
				{
					_mid += "(?=.*[A-Z])";
					result += brk+(k+1)+dot+" "+complexityUC;
				}
				else if(temp == "dg")
				{
					_mid += "(?=.*[0-9])";
					result += brk+(k+1)+dot+" "+complexityNum;
				}
				else if(temp == "sp")
				{
					_mid += "(?=.*[^0-9a-zA-Z])";
					result += brk+(k+1)+dot+" "+complexitySplChars;
				}
			}
		}
		else
		{
			result = "false#";
			var temp = pwdComplexity.toString().toLowerCase().trim();
			if(temp == "lc")
			{
				_mid += "(?=.*[a-z])";
				result +=  complexityLC;
			}
			else if(temp == "uc")
			{
				_mid += "(?=.*[A-Z])";
				result +=  complexityUC;
			}
			else if(temp == "dg")
			{
				_mid += "(?=.*[0-9])";
				result +=  complexityNum;
			}
			else if(temp == "sp")
			{
				_mid += "(?=.*[^0-9a-zA-Z])";
				result +=  complexitySplChars;
			}
		}
		var regExp = new RegExp(_start + _mid + _end);
		if(regExp.test(newPassword))
		{
			result = "true";
		}
	}
	return result;
}

function isEmpty(val)
{
	return (val == null || val =='null' || val == '' || val.trim().length == 0);
}

function passStrength(value)
{
	var regExp = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[^\da-zA-Z]).+$/;
	var regExp2 = /^(?=.*\d)(?=.*[a-zA-Z])(?=.*[^\da-zA-Z]).+$/;
	var regExp3 = /^(?=.*\d)(?=.*[a-zA-Z]).+$/;
	var msg = "";
	var result = true;
	if (isEmpty(value))
	{
		msg = '<span style="color:red">Should not be blank!</span>';
		result = false;
	}
	else if (value.length >= pass_length && regExp.test(value))
	{
		msg = 'Strength : <span style="color:green">Strong</span>';
	}
	else if(value.length >= pass_length && value.match(regExp2))
	{
		msg = 'Strength :  <span style="color:green">Good</span>';
	}
	else if(value.length >= pass_length && value.match(regExp3))
	{
		msg = 'Strength : <span style="color:#D35400">Fair</span>';
	}
	else
	{
		msg = 'Strength : <span style="color:red">Weak</span>';
		result = false;
	}
	$("#label_newpwd").css('color','black');
	$("#label_newpwd").html(msg);
	return result;
}

function matchPassword(value)
{
	var newPassword = $("#newPassword").val();
	if(isEmpty(newPassword) || isEmpty(value))
	{
		$("#label_conpwd").css('color','red');
		$("#label_conpwd").html('Should not be blank!');
		return;
	}
	if(newPassword != value)
	{
		$("#label_conpwd").css('color','red');
		$("#label_conpwd").html('Not matched!');
		return;
	}
	else
	{
		$("#label_conpwd").css('color','green');
		$("#label_conpwd").html('Matched');
		return true;
	}
}

function lengthPassword(value)
{
	if(value == undefined)
	{
		value = $("#newPassword").val();
	}
	if(value.length >= pass_length)
	{
		$("#label_newpwd").html('');
		return;
	}
	var msg = pass_length+' chars required.';
	if(isEmpty(value))
		msg = 'Should not be blank!';
	$("#label_newpwd").css('color','red');
	$("#label_newpwd").html(msg);
}

function changeOption(option)
{
	if(option == 'add')
	{
		document.getElementById('new-temp').style.display = '';
		document.getElementById('new-pass').style.display = '';
		document.getElementById('con-pass').style.display = '';
		document.getElementById('menu-opt').style.display = '';
		document.getElementById('menu-list').style.display = '';
		document.getElementById('user-temp-list').style.display = 'none';
		if(document.getElementById('eg_back').disabled);
		{
			document.getElementById('eg_back').disabled = false;
		}
		var s_menu_opt = document.querySelector('input[type=radio][name=selMenuOpt]:checked').value;
		var user_pass = document.getElementById('userProfileCombo').value;
		
		if (user_pass != '-1')
		{
			var inputs = document.getElementsByTagName('input');
			for(var i in inputs)
			{
				if(inputs[i].type == 'checkbox' && document.getElementById(inputs[i].id).checked) 
				{
					document.getElementById(inputs[i].id).checked = false;
				}
			}
			if (s_menu_opt == 'all')
			{
				document.getElementById('selMenu-custom').checked = true;
			}
		}
	}
	else
	{
		document.getElementById('new-temp').style.display = 'none';
		document.getElementById('new-pass').style.display = 'none';
		document.getElementById('con-pass').style.display = 'none';
		document.getElementById('menu-opt').style.display = 'none';
		document.getElementById('menu-list').style.display = 'none';
		document.getElementById('user-temp-list').style.display = '';
		document.getElementById('eg_back').disabled = true;
	}
	var option_disp = option.substring(0,1).toUpperCase()+option.substring(1);
	document.getElementById('eg_back').value = option_disp;
	document.getElementById('userProfileCombo').value = "-1";
}

function changeMenuOption(menu_opt)
{
	if(menu_opt == 'custom')
	{
		document.getElementById('menu-list').style.display = '';
	}
	else
	{
		document.getElementById('menu-list').style.display = 'none';
	}
}

function changeProfile(profile_name)
{	
	document.getElementById('eg_back').disabled = false;
	var s_opt = document.querySelector('input[type=radio][name=option]:checked').value;
	window.location.href = 'EgConfigureProfile.jsp?sessionInUse=true&s_profile_name='+encodeURIComponent(filterEncode(profile_name))+'&s_option='+s_opt;
}

function submitAct()
{
	var s_opt = document.querySelector('input[type=radio][name=option]:checked').value;
	if(s_opt == 'delete')
	{
		var profile = document.getElementById('userProfileCombo').value;
		var res = confirm("Are you sure you want to delete the profile '" + profile + "'?");
		if(!res)
		{
			return;
		}
	}
	var thisForm = document.menuform;
	var result = validateForm();
	if(!result[0])
	{
		alert(result[1]);
		return;
	}
	if(s_opt == 'add')
	{
		$('#newPassword').val(encryptText($('#newPassword').val()));
	}
	thisForm.action = "EgConfigureProfilep.jsp";
	thisForm.submit();
}

function isMenuOptChecked()
{
	var inputs = document.getElementsByTagName('input');
	for(var i in inputs)
	{
		if(inputs[i].type == 'checkbox' && document.getElementById(inputs[i].id).checked)
		{
			return true;
		}
	}
	return false;
}

function validateForm()
{
	var result = new Array();
	var s_opt = document.querySelector('input[type=radio][name=option]:checked').value;
	var s_menu_opt = document.querySelector('input[type=radio][name=selMenuOpt]:checked').value;
	var error = '';
	if(s_opt == 'add')
	{
		var profile_name = document.getElementById('profileName').value;
		var new_pass = document.getElementById('newPassword').value;
		var con_pass = document.getElementById('confirmPassword').value;
		var pwdComplexity = pwdComplexityCheck(new_pass);
		var checkSplAndSpace;
		
		var profileList = '<%=prof_buf.toString()%>'.split(',');
		var userPassList = '<%=cred_buf.toString()%>'.split(',');
	
		if(profile_name.trim().length == 0)
		{
			error = "Profile name can't be empty";
		}
		else if(profileList.includes(profile_name))
		{
			error = "Profile name already exists";
		}		
		else if(profile_name.toLowerCase() == 'default')
		{
			error = "Not allowed 'default' keyword in profile name";
		}
		else if(profile_name.toLowerCase() == new_pass.toLowerCase())
		{
			error = "Password can't be same as profile name";
		}
		else if(profile_name.length > 32)
		{
			error = "Profile name should not be exceed 32 characters";
		}
		else if ('<%=isDouble%>' == "false" && !validateSingleByte(profile_name))
		{
			error = "Profile name is "+dblByteMsg;
		}
		else if(!(checkSplAndSpace = checkSplCharsAndSpace(profile_name))[0])
		{
			error = checkSplAndSpace[1];
		}
		else if(new_pass.trim().length == 0)
		{
			error = "New password can't be empty";
		}
		else if(con_pass.trim().length == 0)
		{
			error = "Confirm password can't be empty";
		}
		else if(userPassList.includes(new_pass))
		{
			error = "New password can't be same as other existing profile password";
		}
		else if(new_pass != con_pass)
		{
			error = "Passwords do not match";
		}
		else if(new_pass.length < pass_length)
		{
			error = 'Password should contain at least '+pass_length+' characters';
		}
		else if(new_pass.length > 16)
		{
			error = "Maximum password length should not be greater than 16";
		}
		else if(pwdComplexity.indexOf("false") > -1)
		{
			var resMsg = pwdComplexity.substring(pwdComplexity.indexOf("false#")+6);
			error = complexityGeneralMsg+". "+passLabel1+" "+resMsg+".";
		}
		else if(new_pass.indexOf("\"") >-1)
		{
			error = "Double quotes not allowed";
		}
		else if ('<%=isDouble%>' == "false" && !validateSingleByte(new_pass))
		{
			error = "Password is "+dblByteMsg;
		}
		else if(s_menu_opt == 'custom' && !isMenuOptChecked())
		{
			error = "No menu items included. Please include menu items";
		}
		if(error.length == 0)
		{
			result.push(true);
		}
		else
		{
			result.push(false,error);
		}
	}
	else if(s_opt == 'modify')
	{
		if(s_menu_opt == 'custom')
		{
			if(!isMenuOptChecked())
			{
				error = "No menu items included. Please include menu items";
			}
			else
			{
				var customMenuList = '<%=menu_buf.toString()%>'.split(',');
				var inputs = document.getElementsByTagName('input');
				var isIncludedMenu = false;
				for(var i in inputs)
				{
					if(inputs[i].type == 'checkbox' && document.getElementById(inputs[i].id).checked) 
					{
						if(!customMenuList.includes(inputs[i].id))
						{
							isIncludedMenu = true;
							break;
						}
					}
				}
				var isExcludedMenu = false;
				for(var i in inputs)
				{
					if(inputs[i].type == 'checkbox' && !document.getElementById(inputs[i].id).checked) 
					{
						if(customMenuList.includes(inputs[i].id))
						{
							isExcludedMenu = true;
							break;
						}
					}
				}
				if(!isIncludedMenu && !isExcludedMenu)
				{
					error = "Please include or exclude menu items";
				}
			}
		}
	}
	if(error.length == 0)
	{
		result.push(true);
	}
	else
	{
		result.push(false,error);
	}
	return result;
}

function checkSplCharsAndSpace(text)
{
	var result = new Array();
	if(text.indexOf(" ") >-1)
	{
		result.push(false,"Space not allowed in profile name");
	}
	else
	{
		var splChars = "~`!@#$%^&*()\{}[]\:;/.,<>*+=\"|\'";
		for(var i in text)
		{
			if(splChars.indexOf(text.charAt(i)) >-1)
			{
				result.push(false,"Special characters are not allowed in profile name");
				break;
			}
		}
	}
	if(result.length ==0)
	{
		result.push(true);
	}
	return result;
}

window.onload = function()
{
	var helpMsg = '<li>Password should contain at least '+pass_length+' characters</li>';
	helpMsg += '<li>Password should contain';
	var pwdComp = '<%=pwdComplexity%>'.split(",");
	for(var i in pwdComp)
	{
		if(pwdComp[i] == 'LC')
			helpMsg += ' Lowercase alphabets,';
		else if(pwdComp[i] == 'UC')
			helpMsg += ' Uppercase alphabets,';
		else if(pwdComp[i] == 'DG')
			helpMsg += ' Numbers,';
		else if(pwdComp[i] == 'SP')
			helpMsg += ' Special characters,';
	}
	helpMsg = helpMsg.substring(0,helpMsg.length-1);
	helpMsg += '</li>';
	$('#pwd_help_label').html('<ol>'+helpMsg+'</ol>');
}
</script>
</head>
<body >
<form name="menuform" method="POST" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<tr>
		<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
	</tr>
	<tr>
		<td width="100%" height="24" id="eg_title" align="center"> &nbsp;Profile</td>
	</tr>
	<tr>
		<td height="20" align="center">
			<table align="center" width="85%" cellspacing="0" cellpadding="4" border="0">
				<tr>
					<td height="24" nowrap align="right" width="30%" class="eg_cellbglits"><img src="/final/admin/eg_images/info2.gif"> </td>
					<td height="24" nowrap align="left" class="eg_cellbglits">This page enables the administrator to add/modify/delete profile</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<table style="margin-top:10px;margin-bottom:10px" border="0" align="center" cellspacing="0" cellpadding="0" width="85%" class="eg_cellbglits">
	<tr>
		<th class="form_border"  nowrap width="50%">
			<egui:intnl text="admin.common.Choose the option to proceed"/>&nbsp;
		</th>
		<td class="form_border"  nowrap width="4%"> &nbsp;:</td>
		<td class="form_border" nowrap width="50%">
			<table  width="70%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td class="eg_subcontent" width="35%">
						<input type="radio" class="eg_input" id="option-add" value="add" checked name="option" onchange="javascript:changeOption(this.value)">
						<egui:intnl text="admin.common.Add"/>
					</td>
					<td class="eg_subcontent" width="35%">
						<input type="radio" class="eg_input" id="option-modify" value="modify" name="option" onchange="javascript:changeOption(this.value)">
						<egui:intnl text="admin.common.Modify"/>
					</td>
					<td class="eg_subcontent" width="35%">
						<input type="radio" class="eg_input" id="option-delete" value="delete" name="option" onchange="javascript:changeOption(this.value)">
						<egui:intnl text="admin.common.Delete"/>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr id="new-temp">
		<th class="form_border"  nowrap width="50%">
			<egui:intnl text="admin.common.Profile name"/>&nbsp;
		</th>
		<td class="form_border"  nowrap width="4%"> &nbsp;:</td>
		<td class="form_border" nowrap width="0%">
			<table  width="75%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td width="100%">
						<input type="text" style="width:100%" id="profileName" name="profileName" autocomplete="off">
					</td>
					<td>
						<div class="tooltip" style="padding-left:5px">
							<canvas class="iconTooltipHelp"></canvas>
							<span class="tooltiptext">Only alphabets, numeric and special symbols (Underscore and Hyphen) are allowed</span>
						</div>
					</td>
				</tr>
				</tr>
			</table>
		</td>
	</tr>
	<tr id="new-pass">
		<th class="form_border"  nowrap width="50%">
			<egui:intnl text="admin.common.New password"/>&nbsp;
		</th>
		<td class="form_border"  nowrap width="4%"> &nbsp;:</td>
		<td class="form_border" nowrap width="0%">
			<table  width="100%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td width="70%">
						<input type="password" style="width:100%" id="newPassword" name="newPassword"  placeholder="" oninput="javascript:passStrength(this.value)" onchange="javascript:lengthPassword(this.value)">
					</td>
					<td width="5%">
						<div class="tooltip"  style="padding-left:5px">
							<canvas class="iconTooltipHelp"></canvas>
							<span class="tooltiptext" id="pwd_help_label"></span>
						</div>
					</td>
					<td><span style="border:0px solid green" id="label_newpwd"></td>
				</tr>				
			</table>
		</td>
	</tr>
	<tr id="con-pass">
		<th class="form_border"  nowrap width="50%">
			<egui:intnl text="admin.common.Confirm new password"/>&nbsp;
		</th>
		<td class="form_border"  nowrap width="4%"> &nbsp;:</td>
		<td class="form_border" nowrap width="50%">
			<table  width="100%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td  width="55%">
						<input type="password" style="width:70%" id="confirmPassword" name="confirmPassword" oninput="javascript:matchPassword(this.value)">
						<label style="border:0px solid green" id="label_conpwd">
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr id="user-temp-list" style="display:none">
		<th class="form_border"  nowrap width="50%">
			<egui:intnl text="admin.common.Select a profile name"/>&nbsp;
		</th>
		<td class="form_border"  nowrap width="4%"> &nbsp;:</td>
		<td class="form_border" nowrap width="50%">
			<table  width="70%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td  width="55%">
						<select id="userProfileCombo" name="userProfileCombo" onchange="javascript:changeProfile(this.value)" style="width:100%;">
							<%=FileUtils.selectOptionList(defaultSelection,u_profList,selProfileName,true)%>
						</select>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr id="menu-opt">
		<th class="form_border"  nowrap width="50%">
			<egui:intnl text="admin.common.Select menu items for this profile"/>&nbsp;
		</th>
		<td class="form_border"  nowrap width="4%"> &nbsp;:</td>
		<td class="form_border" nowrap width="50%">
			<table  width="70%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td class="eg_subcontent" width="35%">
						<input type="radio" class="eg_input" id="selMenu-custom" value="custom" checked name="selMenuOpt" onchange="javascript:changeMenuOption(this.value)">
						<egui:intnl text="admin.common.Customize"/>
					</td>
					<td class="eg_subcontent" width="35%">
						<input type="radio" class="eg_input" id="selMenu-all" value="all" name="selMenuOpt" onchange="javascript:changeMenuOption(this.value)">
						<egui:intnl text="admin.common.All"/>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr id="menu-list">
		<td colspan="4">
			<table width="100%" align ="center" class="eg_cellbglits">
<%
	Iterator menuItr = menuDynamicMap.keySet().iterator();
	while(menuItr.hasNext())
	{
		String header = (String)menuItr.next();
		ArrayList list = (ArrayList)menuDynamicMap.get(header);
		String sub_menu = (String)list.get(0);
		String[] tokens = tkInfo.getNodeURLTokens(header);
		if(tokens == null || tokens.length <=1)
		{
			continue;
		}
		String display_menu = tokens[0];
		String menu_URL = tokens[1];
		
		if(header.equalsIgnoreCase(sub_menu))
		{
%>
			<tr>
				<td colspan="4">
					<div style="margin-top:5px;margin-bottom:5px;display:" id="dispDiv" align="center">
						<fieldset align="left">
							<legend><%=display_menu%></legend>
							<table width="100%" border="0" cellspacing="2" cellpadding="2" align="center">
								<tr>
									<td align="left" style="padding:3px 5px 3px 5px">
										<input type="checkbox" id="<%=header%>" name="<%=header%>" value="<%=header%>">
										<label for="<%=header%>"><%=display_menu%></label>
									</td>
								</tr>
							</table>
						</fieldset>
					</div>
				</td>
			</tr>
<%
		}
		else
		{
%>
			<tr>
				<td colspan="4">
					<div style="margin-top:5px;margin-bottom:5px;display:" id="dispDiv" align="center">
						<fieldset align="left">
							<legend><%=display_menu%></legend>
							<table width="100%" border="0" cellspacing="2" cellpadding="2" align="center">
				
<%
			int list_size = list.size();
			if(list_size > 3)
			{
				int loop_count = 3;
				int j;
				for(int i=0;i<list.size();i++)
				{
					list_size -= 3;
%>
								<tr>
<%
					for(j=i;j<loop_count;j++)
					{
						sub_menu = (String)list.get(j);
						tokens = tkInfo.getNodeURLTokens(sub_menu);
						if(tokens == null || tokens.length <=1)
						{
							continue;
						}
						display_menu = tokens[0];
						menu_URL = tokens[1];
%>
									<td align="left" width="35%" style="padding:3px 5px 3px 5px">
										<input type="checkbox" id="<%=sub_menu%>" name="<%=sub_menu%>" value="<%=sub_menu%>">
										<label for="<%=sub_menu%>"><%=display_menu%></label>
									</td>
<%
					}
					i = j-1;
					loop_count += list_size > 3 ? 3 : list_size;
%>
								</tr>
<%
				}
			}
			else
			{
%>
								<tr>
<%
				for(int i=0;i<list_size;i++)
				{
					sub_menu = (String)list.get(i);
					tokens = tkInfo.getNodeURLTokens(sub_menu);
					if(tokens == null || tokens.length <=1)
					{
						continue;
					}
					display_menu = tokens[0];
					menu_URL = tokens[1];
%>
									<td align="left" width="35%" style="padding:3px 5px 3px 5px">
										<input type="checkbox" id="<%=sub_menu%>" name="<%=sub_menu%>" value="<%=sub_menu%>">
										<label for="<%=sub_menu%>"><%=display_menu%></label>
									</td>
<%
				}
				if(list_size == 2)
				{
%>
									<td><div width="35%" align="left" style="padding:3px 5px 3px 5px"></div></td>
<%
				}
%>
								</tr>
<%
			}
%>
							</table>
						</fieldset>
					</div>
				</td>
			</tr>
<%
		}
	}
%>
		</table>
	</td>
	</tr>
	<tr>
		<td align="center" colspan="3">
			<table align="center" style="padding-bottom:10px" cellspacing="0" cellpadding="2" width="100%" border="0"><br>
				<tr>
					<td colspan="3" align="center" nowrap>
						<input type="button" value='<egui:intnl text="admin.common.Add"/>' name="update" style="width:85px;" id="eg_back" onclick="javascript:submitAct()">
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<script language="javascript">
var resultMsg = '<%=resultMsg%>';
if(resultMsg.length >0)
{
	alert(resultMsg);
}
var s_option = '<%=s_option%>';
if(s_option == 'modify' || s_option == 'delete')
{
	var option_disp = s_option.substring(0,1).toUpperCase()+s_option.substring(1);
	document.getElementById('eg_back').value = option_disp;
	
	document.getElementById('new-temp').style.display = 'none';
	document.getElementById('new-pass').style.display = 'none';
	document.getElementById('con-pass').style.display = 'none';
	document.getElementById('user-temp-list').style.display = '';
	var profileType = '<%=profileType%>';
	
	if(profileType == 'NotApplicable')
	{
		document.getElementById('menu-opt').style.display = 'none';
		document.getElementById('menu-list').style.display = 'none';
		if(s_option == 'modify')
		{
			document.getElementById('option-modify').checked = true;
		}
		else if(s_option == 'delete')
		{
			document.getElementById('option-delete').checked = true;
		}
		if(document.getElementById('userProfileCombo').value == '-1')
		{
			document.getElementById('eg_back').disabled = true;
		}
	}
	else
	{
		document.getElementById('eg_back').disabled = false;
		document.getElementById('option-modify').checked = true;
		if(profileType == 'All')
		{
			document.getElementById('selMenu-all').checked = true;
			document.getElementById('menu-list').style.display = 'none';
		}
		else
		{
			var customMenuList = '<%=menu_buf.toString()%>'.split(',');
			var inputs = document.getElementsByTagName('input');
			for(var i in inputs)
			{
				if(inputs[i].type == 'checkbox' && customMenuList.includes(inputs[i].id))
				{
					document.getElementById(inputs[i].id).checked = true;
				}
			}
		}
	}
}
</script>
</html>



