Ext.define('ConfigureTrapPriority.controller.Main',{
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'ConfigureTrapsPriority'
	],
	refs : [
		{ selector : 'main', ref : 'main' },
		{ selector : 'ConfigureTrapsPriority', ref : 'ConfigureTrapsPriority' }
	],

	init : function()
	{
		appCnt = this;
		this.control({
			'main button[id="configureTrapsId"]':
			{
				'click': this.showConfigureTrapsPriority
			},
			'ConfigureTrapsPriority combo[id="selectMIBId"]':
			{
				'select':this.loadMibFileData
			}
		});
	},
	
	showConfigureTrapsPriority: function(from)
	{
		var mainViewId = Ext.getCmp('mainView');
		Ext.getCmp('main').hide();
		mainViewId.add({ xtype: 'ConfigureTrapsPriority'});
		
		Ext.getCmp('ConfigureTrapsPriority').setTitle('<div><a href="javascript:void(0)" onclick="javascript:appCnt.gotoToBack()"> <img src="/final/images/spacer.gif" class="aIconBackArrow" /> </a>'+pageTitle+'</div>');
		
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		
		Ext.Ajax.request({
			url : 'ConfigureTrapPriority/data/EgConfigureTrapPriorityJson.jsp',
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				
				var selectedMibFile = publicJSON.selectedMibFile;
				var allMibFiles = publicJSON.allMibFiles;
				
				Ext.getCmp('selectMIBId').getStore().loadRawData(allMibFiles);
				
				Ext.getCmp('selectMIBId').setValue(selectedMibFile);
				
				Ext.getCmp('NoDataPattern1').hide();
				Ext.getCmp('addBtn').hide();
				Ext.getCmp('updateBtn').hide();
				Ext.getCmp('clearBtn').hide();
				Ext.getCmp('deleteBtn').hide();
				myMask.hide();
			},
			failure: function(response)
			{
				myMask.hide();
			}
		});
	},
	
	loadMibFileData: function(obj)
	{
		var mibFile = obj.getValue();
		
		var mainViewId = Ext.getCmp('mainView');

		if (!Ext.isEmpty(mainViewId))
		{
			mainViewId.removeAll();
		}
		mainViewId.add({ xtype: 'ConfigureTrapsPriority'});
		
		if (!Ext.isEmpty(mibFile) && mibFile == 'enteramib')
		{
			Ext.getCmp('ConfigureTrapsPriority').setTitle('<div><a href="javascript:void(0)" onclick="javascript:appCnt.gotoToBack()"> <img src="/final/images/spacer.gif" class="aIconBackArrow" /> </a>'+pageTitle+'</div>');
			Ext.getCmp('enterMibId').show();
			Ext.getCmp('selectMIBId').setValue('enteramib');
			Ext.getCmp('NoDataPattern1').hide();
			Ext.getCmp('addBtn').setText('Specify Trap and Set Priority');
			Ext.getCmp('addBtn').hide();
			Ext.getCmp('updateBtn').hide();
			Ext.getCmp('clearBtn').hide();
		}
		else
		{
			var myMask = new Ext.LoadMask(Ext.getCmp('ConfigureTrapsPriority'), {msg: 'Retrieving and rendering data may take few minutes... Please wait!'});
			myMask.show();
			Ext.getCmp('enterMibId').hide();
			Ext.Ajax.request({
				url : 'ConfigureTrapPriority/data/EgConfigureTrapPriorityJson.jsp?mibFile='+mibFile,
				method : 'POST',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					
					var selectedMibFile = publicJSON.selectedMibFile;
					var allMibFiles = publicJSON.allMibFiles;
					
					Ext.getCmp('selectMIBId').getStore().loadRawData(allMibFiles);
					
					Ext.getCmp('selectMIBId').setValue(selectedMibFile);
					Ext.getCmp('addBtn').setText(buttonText2);
					var listConfigTraps = publicJSON.listConfigTraps;
					var listConfigTrapObjs = publicJSON.listConfigTrapObjs;
					
					Ext.getCmp('ConfigureTrapsPriority').setTitle('<div><a href="javascript:void(0)" onclick="javascript:appCnt.gotoToBack()"> <img src="/final/images/spacer.gif" class="aIconBackArrow" /> </a>'+pageTitle+'</div>');
					
					if (listConfigTraps != null && listConfigTraps.length > 0)
					{
						Ext.getCmp('addBtn').hide();
						Ext.getCmp('updateBtn').hide();
						Ext.getCmp('clearBtn').hide();
						Ext.getCmp('deleteBtn').hide();
						uiTimeout = '';
						var trap_len = listConfigTraps.length;
						for (var x=0; x<trap_len; x++)
						{
							function loadUI(xx)
							{
								if (xx == trap_len-1)
								{
									myMask.hide();
									Ext.getCmp('NoDataPattern1').hide();
									Ext.getCmp('addBtn').show();
									Ext.getCmp('updateBtn').show();
									Ext.getCmp('clearBtn').show();
									Ext.getCmp('deleteBtn').show();
									clearTimeout(uiTimeout);
								}
								
								Ext.getCmp('resultContainer').suspendEvents(true);
								var trapOidStr = listConfigTraps[xx];
								var sep_idx = trapOidStr.indexOf('#@#');
								if (sep_idx != -1)
								{
									var trapOid = trapOidStr.substring(0,sep_idx);
									var trapPriority = trapOidStr.substring(sep_idx+3);
									var trapConId = appCnt.addTrapTypeContainer();
									Ext.getCmp('trapType_'+trapConId).setValue(trapOid);
									Ext.getCmp('priorityStatus'+trapConId).setValue(trapPriority);
									var trapTypeObjs = publicJSON[trapOid];
									if (trapTypeObjs != null && trapTypeObjs.length > 0)
									{
										Ext.getCmp('addTrapType_'+trapConId).show();
									}
									else
									{
										Ext.getCmp('addTrapType_'+trapConId).hide();
									}
								}
								else
								{
									var trapConId = appCnt.addTrapTypeContainer();
									Ext.getCmp('trapType_'+trapConId).setValue(trapOidStr);
									Ext.getCmp('addTrapType_'+trapConId).show();
									var trapObjsList =listConfigTrapObjs[trapOidStr];
									var fs_len = trapObjsList.length;
									for (var y=0; y<fs_len; y++)
									{
										var fsConId = appCnt.addTrapObjectsContainer(trapConId);
										var objVariable = trapObjsList[y];
										
										var objVar_idx = objVariable.indexOf('#@#');
										var objVariableStr = objVariable.substring(0,objVar_idx);
										var objPrioirty = objVariable.substring(objVar_idx+3);
										Ext.getCmp('objPriorityStatus'+trapConId+'_'+fsConId).setValue(objPrioirty);
										
										var objValArr = objVariableStr.split('$#$');
										var obj_len = objValArr.length;
										for (var z=0; z<obj_len; z++)
										{
											var objValStr = objValArr[z];
											var objectArr = objValStr.split('^#^');
											
											var objOid = '';
											var condition = '';
											var value = '';
											var objValLen = objectArr.length;
											for (var m=0; m<objValLen; m++)
											{
												var valStr = objectArr[m];
												if (m == 0)
												{
													objOid = objectArr[0];
												}
												
												if (m == 1)
												{
													condition = objectArr[1];
												}
												
												if (m == 2)
												{
													value = objectArr[2];
												}
												
												if (m > 2)
												{
													value += '^#^'+objectArr[m];
												}
											}
											var dispValArr = value.split('#^#');
											
											if (z == 0)
											{
												Ext.getCmp('object'+trapConId+'_'+fsConId+'_1').setValue(objOid);
												Ext.getCmp('condition'+trapConId+'_'+fsConId+'_1').setValue(condition);
												if (dispValArr != null && dispValArr.length > 1)
												{
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setValue(dispValArr[0]);
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setReadOnly(true);
												}
												else
												{
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setValue(value);
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setReadOnly(false);
												}
												Ext.getCmp('$objectValue'+trapConId+'_'+fsConId+'_1').setValue(value);
											}
											else
											{
												var objConId = appCnt.addObjectsContainer(trapConId,fsConId,trapConId+'_'+fsConId);
												Ext.getCmp('object'+objConId).setValue(objOid);
												Ext.getCmp('condition'+objConId).setValue(condition);
												if (dispValArr != null && dispValArr.length > 1)
												{
													Ext.getCmp('objectValue'+objConId).setValue(dispValArr[0]);
													Ext.getCmp('objectValue'+objConId).setReadOnly(true);
												}
												else
												{
													Ext.getCmp('objectValue'+objConId).setValue(value);
													Ext.getCmp('objectValue'+objConId).setReadOnly(false);
												}
												Ext.getCmp('$objectValue'+objConId).setValue(value);
											}
										}
									}
								}
							}
							(function(x)
							{
								uiTimeout = setTimeout(function() {
									loadUI(x);
								}, x * 1);
							})(x);
						}
					}
					else
					{
						myMask.hide();
						var allTraps = publicJSON.allTraps;
						Ext.getCmp('deleteBtn').hide();
						if (allTraps != null && allTraps.length > 1)
						{
							Ext.getCmp('NoDataPattern1').show();
							Ext.getCmp('addBtn').show();
							Ext.getCmp('updateBtn').show();
							Ext.getCmp('clearBtn').show();
							Ext.getCmp('updateBtn').disable();
							Ext.getCmp('clearBtn').disable();
						}
						else
						{
							Ext.getCmp('NoDataPattern1').hide();
							Ext.getCmp('addBtn').hide();
							Ext.getCmp('updateBtn').hide();
							Ext.getCmp('clearBtn').hide();
						}
					}
				},
				failure: function(response)
				{
					myMask.hide();
				}
			});
		}
	},
	
	loadSelectedMib: function(mibFile, isUploadedFile, fromConfigUI)
	{
		var mainViewId = Ext.getCmp('mainView');

		if (!Ext.isEmpty(mainViewId))
		{
			mainViewId.removeAll();
		}
		mainViewId.add({ xtype: 'ConfigureTrapsPriority'});
		
		if (!Ext.isEmpty(isUploadedFile) && isUploadedFile == 'false')
		{
			Ext.getCmp('enterMibId').show();
		}
		else
		{
			Ext.getCmp('enterMibId').hide();
		}
		
		if (!Ext.isEmpty(fromConfigUI) && fromConfigUI == 'configui')
		{
			Ext.getCmp('configuredMIBNameId').show();
			Ext.getCmp('configuredMIBNameId').setValue(mibFile);
			Ext.getCmp('selectMIBId').hide();
			Ext.getCmp('selectMIBFileId').hide();
			Ext.getCmp('loadContId').hide();
		}
		else
		{
			Ext.getCmp('configuredMIBNameId').hide();
			Ext.getCmp('selectMIBId').show();
			Ext.getCmp('selectMIBFileId').show();
			Ext.getCmp('loadContId').show();
		}
		
		var myMask = new Ext.LoadMask(Ext.getCmp('ConfigureTrapsPriority'), {msg: 'Retrieving and rendering data may take few minutes... Please wait!'});
		myMask.show();
		
		Ext.Ajax.request({
			url : 'ConfigureTrapPriority/data/EgConfigureTrapPriorityJson.jsp?mibFile='+mibFile,
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				
				var selectedMibFile = publicJSON.selectedMibFile;
				var allMibFiles = publicJSON.allMibFiles;
				
				Ext.getCmp('selectMIBId').getStore().loadRawData(allMibFiles);
				
				if (!Ext.isEmpty(isUploadedFile) && isUploadedFile == 'true')
				{
					Ext.getCmp('selectMIBId').setValue(selectedMibFile);
				}
				else
				{
					Ext.getCmp('selectMIBId').setValue('enteramib');
					Ext.getCmp('selectMIBFileId').setValue(mibFile);
				}
				
				Ext.getCmp('ConfigureTrapsPriority').setTitle('<div><a href="javascript:void(0)" onclick="javascript:appCnt.gotoToBack()"> <img src="/final/images/spacer.gif" class="aIconBackArrow" /> </a>'+pageTitle+'</div>');
				
				var listConfigTraps = publicJSON.listConfigTraps;
				var listConfigTrapObjs = publicJSON.listConfigTrapObjs;
				
				if (listConfigTraps != null && listConfigTraps.length > 0)
				{
					if (!Ext.isEmpty(isUploadedFile) && isUploadedFile == 'true')
					{
						Ext.getCmp('addBtn').disable();
						Ext.getCmp('updateBtn').disable();
						Ext.getCmp('clearBtn').disable();
						Ext.getCmp('addBtn').setText(buttonText2);
						Ext.getCmp('deleteBtn').show();
						Ext.getCmp('deleteBtn').disable();
						uiTimeout = '';
						var trap_len = listConfigTraps.length;
						for (var x=0; x<trap_len; x++)
						{
							function loadUI(xx)
							{
								if (xx == trap_len-1)
								{
									myMask.hide();
									Ext.getCmp('addBtn').enable();
									Ext.getCmp('updateBtn').enable();
									Ext.getCmp('clearBtn').enable();
									Ext.getCmp('deleteBtn').enable();
									clearTimeout(uiTimeout);
								}
								
								Ext.getCmp('resultContainer').suspendEvents(true);
								var trapOidStr = listConfigTraps[xx];
								var sep_idx = trapOidStr.indexOf('#@#');
								if (sep_idx != -1)
								{
									var trapOid = trapOidStr.substring(0,sep_idx);
									var trapPriority = trapOidStr.substring(sep_idx+3);
									var trapConId = appCnt.addTrapTypeContainer();
									Ext.getCmp('trapType_'+trapConId).setValue(trapOid);
									Ext.getCmp('priorityStatus'+trapConId).setValue(trapPriority);
									var trapTypeObjs = publicJSON[trapOid];
									if (trapTypeObjs != null && trapTypeObjs.length > 0)
									{
										Ext.getCmp('addTrapType_'+trapConId).show();
									}
									else
									{
										Ext.getCmp('addTrapType_'+trapConId).hide();
									}
								}
								else
								{
									var trapConId = appCnt.addTrapTypeContainer();
									Ext.getCmp('trapType_'+trapConId).setValue(trapOidStr);
									Ext.getCmp('addTrapType_'+trapConId).show();
									var trapObjsList =listConfigTrapObjs[trapOidStr];
									var fs_len = trapObjsList.length;
									for (var y=0; y<fs_len; y++)
									{
										var fsConId = appCnt.addTrapObjectsContainer(trapConId);
										var objVariable = trapObjsList[y];
										
										var objVar_idx = objVariable.indexOf('#@#');
										var objVariableStr = objVariable.substring(0,objVar_idx);
										var objPrioirty = objVariable.substring(objVar_idx+3);
										Ext.getCmp('objPriorityStatus'+trapConId+'_'+fsConId).setValue(objPrioirty);
										
										var objValArr = objVariableStr.split('$#$');
										var obj_len = objValArr.length;
										for (var z=0; z<obj_len; z++)
										{
											var objValStr = objValArr[z];
											var objectArr = objValStr.split('^#^');
											var objOid = '';
											var condition = '';
											var value = '';
											var objValLen = objectArr.length;
											for (var m=0; m<objValLen; m++)
											{
												var valStr = objectArr[m];
												if (m == 0)
												{
													objOid = objectArr[0];
												}
												
												if (m == 1)
												{
													condition = objectArr[1];
												}
												
												if (m == 2)
												{
													value = objectArr[2];
												}
												
												if (m > 2)
												{
													value += '^#^'+objectArr[m];
												}
											}
											var dispValArr = value.split('#^#');
											if (z == 0)
											{
												Ext.getCmp('object'+trapConId+'_'+fsConId+'_1').setValue(objOid);
												Ext.getCmp('condition'+trapConId+'_'+fsConId+'_1').setValue(condition);
												if (dispValArr != null && dispValArr.length > 1)
												{
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setValue(dispValArr[0]);
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setReadOnly(true);
												}
												else
												{
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setValue(value);
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setReadOnly(false);
												}
												Ext.getCmp('$objectValue'+trapConId+'_'+fsConId+'_1').setValue(value);
											}
											else
											{
												var objConId = appCnt.addObjectsContainer(trapConId,fsConId,trapConId+'_'+fsConId);
												Ext.getCmp('object'+objConId).setValue(objOid);
												Ext.getCmp('condition'+objConId).setValue(condition);
												if (dispValArr != null && dispValArr.length > 1)
												{
													Ext.getCmp('objectValue'+objConId).setValue(dispValArr[0]);
													Ext.getCmp('objectValue'+objConId).setReadOnly(true);
												}
												else
												{
													Ext.getCmp('objectValue'+objConId).setValue(value);
													Ext.getCmp('objectValue'+objConId).setReadOnly(false);
												}
												Ext.getCmp('$objectValue'+objConId).setValue(value);
											}
										}
									}
								}
								Ext.getCmp('resultContainer').resumeEvents();
							}
							(function(x)
							{
								uiTimeout = setTimeout(function() {
									loadUI(x);
								}, x * 1);
							})(x);
						}
					}
					else
					{
						Ext.getCmp('addBtn').disable();
						Ext.getCmp('updateBtn').disable();
						Ext.getCmp('clearBtn').disable();
						Ext.getCmp('addBtn').setText(buttonText6);
						Ext.getCmp('selectMIBFileId').setValue(mibFile);
						Ext.getCmp('deleteBtn').show();
						Ext.getCmp('deleteBtn').disable();
						uiTimeout = '';
						var oidNameMap = publicJSON.oidNameMap;
						var objectOidNameMap = publicJSON.objectOidNameMap;
						var trap_len = listConfigTraps.length;
						for (var x=0; x<trap_len; x++)
						{
							function loadUI(xx)
							{
								if (xx == trap_len-1)
								{
									myMask.hide();
									Ext.getCmp('addBtn').enable();
									Ext.getCmp('updateBtn').enable();
									Ext.getCmp('clearBtn').enable();
									Ext.getCmp('deleteBtn').enable();
									clearTimeout(uiTimeout);
								}
								
								Ext.getCmp('resultContainer').suspendEvents(true);
								var trapOidStr = listConfigTraps[xx];
								var sep_idx = trapOidStr.indexOf('#@#');
								if (sep_idx != -1)
								{
									var trapOid = trapOidStr.substring(0,sep_idx);
									var trapName = oidNameMap[0][trapOid];
									var trapPriority = trapOidStr.substring(sep_idx+3);
									var trapConId = appCnt.addCustomTrapTypeContainer();
									Ext.getCmp('trapType_'+trapConId).setValue(trapOid);
									Ext.getCmp('trapTypeName_'+trapConId).setValue(trapName);
									Ext.getCmp('priorityStatus'+trapConId).setValue(trapPriority);
									Ext.getCmp('addTrapType_'+trapConId).show();
								}
								else
								{
									var trapName = oidNameMap[0][trapOidStr];
									
									var trapConId = appCnt.addCustomTrapTypeContainer();
									Ext.getCmp('trapType_'+trapConId).setValue(trapOidStr);
									Ext.getCmp('trapTypeName_'+trapConId).setValue(trapName);
									Ext.getCmp('addTrapType_'+trapConId).show();
									var trapObjsList =listConfigTrapObjs[trapOidStr];
									var fs_len = trapObjsList.length;
									for (var y=0; y<fs_len; y++)
									{
										var fsConId = appCnt.addCustomTrapObjectsContainer(trapConId);
										var objVariable = trapObjsList[y];
										
										var objVar_idx = objVariable.indexOf('#@#');
										var objVariableStr = objVariable.substring(0,objVar_idx);
										var objPrioirty = objVariable.substring(objVar_idx+3);
										Ext.getCmp('objPriorityStatus'+trapConId+'_'+fsConId).setValue(objPrioirty);
										
										var objValArr = objVariableStr.split('$#$');
										var obj_len = objValArr.length;
										for (var z=0; z<obj_len; z++)
										{
											var objValStr = objValArr[z];
											var objectArr = objValStr.split('^#^');
											var objOid = objectArr[0];
											var objName = objectOidNameMap[0][objOid];
											var condition = objectArr[1];
											var value = objectArr[2];
											var dispValArr = value.split('#^#');
											if (z == 0)
											{
												Ext.getCmp('object'+trapConId+'_'+fsConId+'_1').setValue(objOid);
												Ext.getCmp('objectName'+trapConId+'_'+fsConId+'_1').setValue(objName);
												Ext.getCmp('condition'+trapConId+'_'+fsConId+'_1').setValue(condition);
												if (dispValArr != null && dispValArr.length > 1)
												{
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setValue(dispValArr[0]);
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setReadOnly(true);
												}
												else
												{
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setValue(value);
													Ext.getCmp('objectValue'+trapConId+'_'+fsConId+'_1').setReadOnly(false);
												}
												Ext.getCmp('$objectValue'+trapConId+'_'+fsConId+'_1').setValue(value);
											}
											else
											{
												var objConId = appCnt.addCustomObjectsContainer(trapConId,fsConId,trapConId+'_'+fsConId);
												Ext.getCmp('object'+objConId).setValue(objOid);
												Ext.getCmp('objectName'+objConId).setValue(objName);
												Ext.getCmp('condition'+objConId).setValue(condition);
												if (dispValArr != null && dispValArr.length > 1)
												{
													Ext.getCmp('objectValue'+objConId).setValue(dispValArr[0]);
													Ext.getCmp('objectValue'+objConId).setReadOnly(true);
												}
												else
												{
													Ext.getCmp('objectValue'+objConId).setValue(value);
													Ext.getCmp('objectValue'+objConId).setReadOnly(false);
												}
												Ext.getCmp('$objectValue'+objConId).setValue(value);
											}
										}
									}
								}
							}
							(function(x)
							{
								uiTimeout = setTimeout(function() {
									loadUI(x);
								}, x * 1);
							})(x);
						}
					}
				}
				else if (!Ext.isEmpty(isUploadedFile) && isUploadedFile == 'false')
				{
					myMask.hide();
					Ext.getCmp('addBtn').setText(buttonText6);
					Ext.getCmp('deleteBtn').hide();
					Ext.getCmp('NoDataPattern1').hide();
					Ext.getCmp('addBtn').show();
					Ext.getCmp('updateBtn').show();
					Ext.getCmp('clearBtn').show();
					appCnt.addCustomTrapTypeContainer();
				}
				else
				{
					myMask.hide();
					Ext.getCmp('deleteBtn').hide();
					var allTraps = publicJSON.allTraps;
					if (allTraps != null && allTraps.length > 1)
					{
						Ext.getCmp('addBtn').setText(buttonText2);
						Ext.getCmp('NoDataPattern1').show();
						Ext.getCmp('addBtn').show();
						Ext.getCmp('updateBtn').show();
						Ext.getCmp('clearBtn').show();
						Ext.getCmp('updateBtn').disable();
						Ext.getCmp('clearBtn').disable();
					}
					else
					{
						Ext.getCmp('NoDataPattern1').show();
						Ext.getCmp('addBtn').hide();
						Ext.getCmp('updateBtn').hide();
						Ext.getCmp('clearBtn').hide();
					}
				}
			},
			failure: function(response)
			{
				myMask.hide();
			}
		});
	},

	addTrapTypeContainer: function()
	{
		var mainForm = Ext.getCmp('ConfigureTrapsPriority');
		var resultContainer = Ext.getCmp('resultContainer');

		var conIdMulti = "mainfieldset_"+trapInputsCount;
		var currentTrapConID = trapInputsCount;
		var currentTrapObjectsConId = trapObjInputsCount;
		var currentID = trapInputsCount+'_'+trapObjInputsCount;
		
		var tmpContainer = {
			xtype : 'fieldset',
			title: '<b>'+fsTitle1+'</b>',
			id: conIdMulti,
			style: {
				'background' : '#ffffff',
				'border' : '1px solid lightGrey',
				'box-shadow':'none'
			},
			width: 978,
			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'stretch'
			},
			margin: '5 10 10 10',
			items: [
				{
					xtype: 'container',
					border: false,
					style: 'border: 1px solid red',
					id: 'trapTypes_'+trapInputsCount,
					defaults: {
						labelSeparator:' ',
						labelWidth: 100
					},
					layout : {
						type : 'hbox',
						pack : 'start'
					},
					items:[
						{
							xtype: "scrollcombo",
							cls: "dropdown",
							id: 'trapType_'+trapInputsCount,
							name: 'trapType_'+trapInputsCount,
							fieldLabel: labelMsg3,
							labelSeparator:'',
							labelAlign: 'top',
							prevValue: '',
							valueField: "valueField",
							displayField: "displayField",
							queryMode: "local",
							editable: false,
							width: 250,
							store: new Ext.data.Store({
								fields: ["displayField", "valueField"],
								data: []
							}),
							listeners: {
								select: function(obj)
								{
									var conId = obj.getId();
									var conIdx = conId.substring(conId.indexOf('_')+1);
									
									var trapOid = obj.getValue();
									var prevVal = obj.prevValue;
									obj.prevValue = trapOid;
									
									if (!Ext.isEmpty(trapOid) && trapOid != '-1')
									{
										var trapObjects = publicJSON[trapOid];
										if (trapObjects != null && trapObjects.length > 0)
										{
											Ext.getCmp('addTrapType_'+conIdx).show();
										}
										else
										{
											Ext.getCmp('addTrapType_'+conIdx).hide();
										}
									}
									else
									{	
										Ext.getCmp('addTrapType_'+conIdx).hide();
									}
									
									var resultContainer = Ext.getCmp('resultContainer');
									var resultContItemsLen = resultContainer.items.length;
									var trapsWithObjsArr = new Array();
									var trapsArr = new Array();
									for (var x=0; x<resultContItemsLen; x++)
									{
										var conId = resultContainer.items.keys[x];
										var conIdx = conId.substring(conId.indexOf('_')+1);
										var trapTypeObj = Ext.getCmp('trapType_'+conIdx);
										var value = trapTypeObj.getValue();
										
										if (value == '-1')
										{
											continue;
										}
										
										if (trapsArr.indexOf(value) != -1)
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: validateMsg1,
												buttons: Ext.Msg.OK,
												icon: 'gen-warning size32 color-warning',
												fn: function() {
													var resultObjContainer = Ext.getCmp('resultObjContainer'+conIdx);
													if (!Ext.isEmpty(resultObjContainer))
													{
														resultObjContainer.removeAll();
													}
													Ext.getCmp('addTrapType_'+conIdx).hide();
													Ext.getCmp('trapType_'+conIdx).setValue('-1');
													Ext.getCmp('trapType_'+conIdx).focus();
												}
											});
											return false;
										}
										else
										{
											trapsArr.push(value);
										}
									}
								}
							}
						},
						{
							xtype: "scrollcombo",
							cls: "dropdown",
							id: 'priorityStatus'+trapInputsCount,
							name: 'priorityStatus'+trapInputsCount,
							fieldLabel: labelMsg4,
							labelSeparator:'',
							labelAlign: 'top',
							prevValue: '',
							valueField: "valueField",
							displayField: "displayField",
							queryMode: "local",
							editable: false,
							value: 'Minor',
							width: 80,
							margin: '0 0 0 20',
							store: new Ext.data.Store({
								fields: ["displayField", "valueField"],
								data: [{"displayField":"Critical", "valueField":"Critical"},{"displayField":"Major", "valueField":"Major"},{"displayField":"Minor", "valueField":"Minor"}]
							}),
						}
					]
				},
				{
					xtype: 'container',
					id: 'resultObjFieldset'+trapInputsCount+'_1',
					layout: {
						type: 'vbox',
						pack: 'start',
						align: 'stretch'
					},
					margin: '10 0 0 0'
				},
				{
					xtype: 'container',
					border: false,
					style: 'border: 1px solid blue',
					layout : {
						type : 'hbox',
						pack : 'end'
					},
					items : [
						{
							xtype: 'button',
							tooltip: buttonText8,
							style : {
								background : 'none',
								border : '0px'
							},
							iconCls: 'iconLibraryPlus',
							id: 'addTrapType_'+trapInputsCount,
							listeners: {
								click: function() {
									appCnt.addTrapObjectsContainer(currentTrapConID);
								}
							}
						},
						{
							xtype: 'button',
							tooltip: buttonText7,
							iconCls: 'iconDelete',
							style : {
								background : 'none',
								border : '0px'
							},
							id: 'removeTrapType_'+trapInputsCount,
							margin: '0 0 0 10',
							handler: function()
							{
								appCnt.removeMainContainer(conIdMulti);
							}
						}
					]
				}
			]
		}
		
		resultContainer.add(tmpContainer);
		mainForm.doLayout();
		
		var allTraps = publicJSON.allTraps;
		if (allTraps != null && allTraps.length > 1)
		{
			Ext.getCmp('NoDataPattern1').hide();
			Ext.getCmp('mainfieldset_'+currentTrapConID).show();
			Ext.getCmp('trapType_'+currentTrapConID).getStore().loadRawData(allTraps);
			Ext.getCmp('trapType_'+currentTrapConID).setValue("-1");
			
			Ext.getCmp('updateBtn').enable();
			Ext.getCmp('clearBtn').enable();
		}
		Ext.getCmp('addTrapType_'+currentTrapConID).hide();
		trapInputsCount++;
		return currentTrapConID;
	},

	addTrapObjectsContainer: function(trapConId)
	{
		var mainForm = Ext.getCmp('ConfigureTrapsPriority');
		var resultObjFieldset = Ext.getCmp('resultObjFieldset'+trapConId+'_1');
		var currentID = trapConId+'_'+trapObjInputsCount;
		var objCurrentID = trapObjInputsCount;
		var conIdMulti = 'mainobjectContfieldset_'+trapConId+'_'+trapObjInputsCount;
		var tmpObjContainer = {
			xtype: 'container',
			id: conIdMulti,
			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'stretch'
			},
			border: false,
			style: 'border: 1px solid yellow',
			items: [
				{
					xtype: 'fieldset',
					title: '<b>'+fsTitle2+'</b>',
					id: 'mainobjfieldset'+currentID,
					style: {
						'background' : '#ffffff',
						'border' : '1px solid lightGrey',
						'box-shadow':'none'
					},
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								pack: 'start',
								align: 'stretch'
							},
							id: 'mainobjconatiner'+currentID,
							border: false,
							style: 'border: 1px solid blue',
							items: [
								{
									xtype: 'container',
									id: 'resultObjContainer'+currentID+'_1',
									layout: {
										type: 'vbox',
										pack: 'start',
										align: 'stretch'
									},
									items: [
										{
											xtype: 'container',
											id: 'trapContObjects_'+currentID+'_1',
											layout: {
												type: 'vbox',
												pack: 'start',
												align: 'stretch'
											},
											border: false,
											style: 'border: 1px solid brown',
											items: [
												{
													xtype: 'fieldcontainer',
													layout: 'column',
													border: false,
													style: 'border: 1px solid red',
													id: 'trapObjects'+currentID+'_1',
													defaults: {
														labelSeparator:' '
													},
													margin: '0 0 10 0',
													columnWidth: 1,
													items:[
														{
															xtype: "scrollcombo",
															cls: "dropdown",
															id: 'object'+currentID+'_1',
															name: 'object'+currentID+'_1',
															fieldLabel: labelMsg5,
															labelAlign: 'top',
															labelSeparator:'',
															valueField: "valueField",
															displayField: "displayField",
															queryMode: "local",
															editable: false,
															columnWidth: 0.42,
															store: new Ext.data.Store({
																fields: ["displayField", "valueField"],
																data: []
															})
														},
														{
															xtype: "scrollcombo",
															cls: "dropdown",
															id: 'condition'+currentID+'_1',
															name: 'condition'+currentID+'_1',
															fieldLabel: labelMsg6,
															labelAlign: 'top',
															labelSeparator:'',
															valueField: "valueField",
															displayField: "displayField",
															queryMode: "local",
															editable: false,
															margin: '0 0 0 10',
															columnWidth: 0.15,
															value: 'eq',
															store: new Ext.data.Store({
																fields: ["displayField", "valueField"],
																data: [
																	{displayField:'=',valueField:'eq'},
																	{displayField:'!=',valueField:'ne'},
																	{displayField:'>',valueField:'gt'},
																	{displayField:'<',valueField:'lt'},
																	{displayField:'>=',valueField:'ge'},
																	{displayField:'<=',valueField:'le'},
																	{displayField:'matches',valueField:'mc'},
																	{displayField:'not matches',valueField:'nm'}
																]
															})
														},
														{
															xtype: 'textfield',
															cls: 'aTextbox',
															fieldLabel: labelMsg7,
															labelAlign: 'top',
															id:'objectValue'+currentID+'_1',
															name: 'objectValue'+currentID+'_1',
															value: '',
															margin: '0 0 0 10',
															columnWidth: 0.40,
															fieldHelp: 'Click on the service icon to configure multiple values',
															listeners: {
																scope: this,
																focus: onFieldFocus,
																blur: onFieldBlur
															}
														},
														{
															xtype: 'hidden',
															id:'$objectValue'+currentID+'_1',
															name: '$objectValue'+currentID+'_1',
															value: ''
														},
														{
															xtype: 'button',
															columnWidth: 0.03,
															tooltip: 'Configure values',
															id: 'configObjectValue'+currentID+'_1',
															iconCls : 'iconService',
															style : {
																background : 'none',
																border : '0px'
															},
															margin: '22 0 0 2',
															listeners: {
																click: function() {
																	var resId = this.getId().replace("configObjectValue","$objectValue");
																	var objId = this.getId().replace("configObjectValue","object");
																	var optId = this.getId().replace("configObjectValue","condition");
																	appCnt.getPopUpView(resId, objId, optId);
																}
															}
														},
														{
															xtype: 'button',
															tooltip: 'Delete',
															id: 'removeObj'+currentID+'_1',
															iconCls : 'iconMinus',
															style : {
																background : 'none',
																border : '0px'
															},
															margin: '22 0 0 20',
															listeners: {
																click: function() {
																	appCnt.removeObjContainer(trapConId, objCurrentID, 'trapContObjects_'+currentID+'_1');
																}
															}
														}
													]
												},
												{
													xtype: 'label',
													id: 'orLabel'+currentID+'_1',
													hidden: true,
													margin: '5 0 20 0',
													html: '<div style="text-align:center;border-bottom:lightgrey 1px solid"><b><span style="background-color:white;padding: 0 5px; position:relative;top:8px;">AND</span></b></div>'
												}
											]
										}
									]
								},
								{
									xtype: 'container',
									border: false,
									style: 'border: 1px solid blue',
									margin: '10 0 0 0',
									layout : {
										type : 'hbox',
										pack : 'start'
									},
									items : [
										{
											xtype: "scrollcombo",
											cls: "dropdown",
											id: 'objPriorityStatus'+currentID,
											name: 'objPriorityStatus'+currentID,
											fieldLabel: labelMsg4,
											labelSeparator:'',
											labelAlign: 'top',
											prevValue: '',
											valueField: "valueField",
											displayField: "displayField",
											queryMode: "local",
											editable: false,
											value: 'Minor',
											width: 80,
											store: new Ext.data.Store({
												fields: ["displayField", "valueField"],
												data: [{"displayField":"Critical", "valueField":"Critical"},{"displayField":"Major", "valueField":"Major"},{"displayField":"Minor", "valueField":"Minor"}]
											}),
										},
										{
											xtype: 'container',
											border: false,
											style: 'border: 1px solid green',
											layout : {
												type : 'hbox',
												pack : 'end'
											},
											flex: 1,
											items : [
												{
													xtype: 'button',
													tooltip: buttonText9,
													style : {
														background : 'none',
														border : '0px'
													},
													iconCls: 'iconPlus',
													id: 'addTrapObjType'+currentID,
													margin: '20 0 0 0',
													listeners: {
														click: function() {
															appCnt.addObjectsContainer(trapConId, objCurrentID, currentID);
														}
													}
												},
												{
													xtype: 'button',
													tooltip: buttonText7,
													iconCls: 'iconDelete',
													style : {
														background : 'none',
														border : '0px'
													},
													id: 'removeTrapObj'+currentID,
													margin: '20 0 0 10',
													handler: function()
													{
														appCnt.removeTrapObjContainer(trapConId, conIdMulti);
													}
												}
											]
										}
									]
								}
							]
						}
					]
				},
				{
					xtype: 'label',
					id: 'orLabel'+currentID,
					hidden: false,
					margin: '5 0 20 0',
					html: '<div style="text-align:center;border-bottom:lightgrey 1px solid"><b><span style="background-color:white;padding: 0 5px; position:relative;top:8px;">OR</span></b></div>'
				}
			]
		}
		
		resultObjFieldset.add(tmpObjContainer);
		mainForm.doLayout();
		
		var trapOid = Ext.getCmp('trapType_'+trapConId).getValue();
		var trapObjects = publicJSON[trapOid];
		
		if (trapObjects != null && trapObjects.length > 0)
		{
			Ext.getCmp('trapObjects'+currentID+'_1').show();
			Ext.getCmp('object'+currentID+'_1').getStore().loadRawData(trapObjects);
			Ext.getCmp('object'+currentID+'_1').setValue(trapObjects[0].valueField);
		}
		
		Ext.getCmp('trapType_'+trapConId).disable();
		Ext.getCmp('priorityStatus'+trapConId).hide();
		
		var resultObjFieldset = Ext.getCmp('resultObjFieldset'+trapConId+'_1');
		var resultObjFieldSetItemsLen = resultObjFieldset.items.length;
		
		for (var z=0; z<resultObjFieldSetItemsLen; z++)
		{
			var objConId = resultObjFieldset.items.keys[z];
			var objConIdx = objConId.substring(objConId.indexOf('_')+1);
			if (resultObjFieldSetItemsLen == 1)
			{
				Ext.getCmp('orLabel'+objConIdx).hide();
			}
			else
			{
				if (z == resultObjFieldSetItemsLen-2)
				{
					Ext.getCmp('orLabel'+objConIdx).show();
				}
				if (z == resultObjFieldSetItemsLen-1)
				{
					Ext.getCmp('orLabel'+objConIdx).hide();
				}
			}
		}
		
		trapObjInputsCount++;
		return objCurrentID;
	},
	
	addObjectsContainer: function(trapConId, objCurrentID, conId)
	{
		var mainForm = Ext.getCmp('ConfigureTrapsPriority');
		var resultObjContainer = Ext.getCmp('resultObjContainer'+conId+'_1');
		var currentID = conId+'_'+objInputsCount;
		var conIdMulti = 'trapContObjects_'+conId+'_'+objInputsCount;
		var tmpObjContainer = {
			xtype: 'container',
			id: conIdMulti,
			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'stretch'
			},
			border: false,
			style: 'border: 1px solid green',
			items: [
				{
					xtype: 'fieldcontainer',
					layout: 'column',
					border: false,
					style: 'border: 1px solid red',
					id: 'trapObjects'+currentID,
					defaults: {
						labelSeparator:' '
					},
					margin: '0 0 10 0',
					columnWidth: 1,
					items:[
						{
							xtype: "scrollcombo",
							cls: "dropdown",
							id: 'object'+currentID,
							name: 'object'+currentID,
							fieldLabel: labelMsg5,
							labelAlign: 'top',
							labelSeparator:'',
							valueField: "valueField",
							displayField: "displayField",
							queryMode: "local",
							editable: false,
							columnWidth: 0.42,
							store: new Ext.data.Store({
								fields: ["displayField", "valueField"],
								data: []
							})
						},
						{
							xtype: "scrollcombo",
							cls: "dropdown",
							id: 'condition'+currentID,
							name: 'condition'+currentID,
							fieldLabel: labelMsg6,
							labelAlign: 'top',
							labelSeparator:'',
							valueField: "valueField",
							displayField: "displayField",
							queryMode: "local",
							editable: false,
							margin: '0 0 0 10',
							columnWidth: 0.15,
							value: 'eq',
							store: new Ext.data.Store({
								fields: ["displayField", "valueField"],
								data: [
									{displayField:'=',valueField:'eq'},
									{displayField:'!=',valueField:'ne'},
									{displayField:'>',valueField:'gt'},
									{displayField:'<',valueField:'lt'},
									{displayField:'>=',valueField:'ge'},
									{displayField:'<=',valueField:'le'},
									{displayField:'matches',valueField:'mc'},
									{displayField:'not matches',valueField:'nm'}
								]
							})
						},
						{
							xtype: 'textfield',
							cls: 'aTextbox',
							fieldLabel: labelMsg7,
							labelAlign: 'top',
							id:'objectValue'+currentID,
							name: 'objectValue'+currentID,
							value: '',
							margin: '0 0 0 10',
							columnWidth: 0.40,
							fieldHelp: 'Click on the service icon to configure multiple values',
							listeners: {
								scope: this,
								focus: onFieldFocus,
								blur: onFieldBlur
							}
						},
						{
							xtype: 'hidden',
							id:'$objectValue'+currentID,
							name: '$objectValue'+currentID,
							value: ''
						},
						{
							xtype: 'button',
							columnWidth: 0.03,
							tooltip: 'Configure values',
							id: 'configObjectValue'+currentID,
							iconCls : 'iconService',
							style : {
								background : 'none',
								border : '0px'
							},
							margin: '22 0 0 2',
							listeners: {
								click: function() {
									var resId = this.getId().replace("configObjectValue","$objectValue");
									var objId = this.getId().replace("configObjectValue","object");
									var optId = this.getId().replace("configObjectValue","condition");
									appCnt.getPopUpView(resId, objId, optId);
								}
							}
						},
						{
							xtype: 'button',
							tooltip: 'Delete',
							id: 'removeObj'+currentID,
							iconCls : 'iconMinus',
							style : {
								background : 'none',
								border : '0px'
							},
							margin: '22 0 0 20',
							listeners: {
								click: function() {
									appCnt.removeObjContainer(trapConId, objCurrentID, conIdMulti);
								}
							}
						}
					]
				},
				{
					xtype: 'label',
					id: 'orLabel'+currentID,
					hidden: false,
					margin: '5 0 20 0',
					html: '<div style="text-align:center;border-bottom:lightgrey 1px solid"><b><span style="background-color:white;padding: 0 5px; position:relative;top:8px;">AND</span></b></div>'
				}
			]
		}
		
		resultObjContainer.add(tmpObjContainer);
		mainForm.doLayout();
		
		var trapOid = Ext.getCmp('trapType_'+trapConId).getValue();
		var trapObjects = publicJSON[trapOid];
		
		if (trapObjects != null && trapObjects.length > 0)
		{
			Ext.getCmp('trapObjects'+currentID).show();
			Ext.getCmp('object'+currentID).getStore().loadRawData(trapObjects);
			Ext.getCmp('object'+currentID).setValue(trapObjects[0].valueField);
		}
		
		var resultObjContainer = Ext.getCmp('resultObjContainer'+conId+'_1');
		var resultObjContItemsLen = resultObjContainer.items.length;
		
		for (var z=0; z<resultObjContItemsLen; z++)
		{
			var objConId = resultObjContainer.items.keys[z];
			var objConIdx = objConId.substring(objConId.indexOf('_')+1);
			if (resultObjContItemsLen == 1)
			{
				Ext.getCmp('orLabel'+objConIdx).hide();
			}
			else
			{
				if (z == resultObjContItemsLen-2)
				{
					Ext.getCmp('orLabel'+objConIdx).show();
				}
				if (z == resultObjContItemsLen-1)
				{
					Ext.getCmp('orLabel'+objConIdx).hide();
				}
			}
		}
		
		objInputsCount++;
		return currentID;
	},

	removeMainContainer: function(containerID)
	{
		var mainForm = Ext.getCmp('ConfigureTrapsPriority');
		var resultContainer = Ext.getCmp('resultContainer');
		resultContainer.remove(containerID);
		
		var mainObj = Ext.getCmp('mainconatiner_1');
		if (Ext.isEmpty(mainObj))
		{
			var resultContItemsLen = resultContainer.items.length;
			if (resultContItemsLen == 0)
			{
				Ext.getCmp('NoDataPattern1').show();
				Ext.getCmp('updateBtn').disable();
				Ext.getCmp('clearBtn').disable();
			}
		}
	},
	
	removeTrapObjContainer: function(containerID, removeConID)
	{
		var resultObjFieldset = Ext.getCmp('resultObjFieldset'+containerID+'_1');
		resultObjFieldset.remove(removeConID);
		var resultObjFieldSetItemsLen = resultObjFieldset.items.length;
		
		for (var z=0; z<resultObjFieldSetItemsLen; z++)
		{
			var objConId = resultObjFieldset.items.keys[z];
			var objConIdx = objConId.substring(objConId.indexOf('_')+1);
			if (resultObjFieldSetItemsLen == 1)
			{
				Ext.getCmp('orLabel'+objConIdx).hide();
			}
			else
			{
				if (z == resultObjFieldSetItemsLen-2)
				{
					Ext.getCmp('orLabel'+objConIdx).show();
				}
				if (z == resultObjFieldSetItemsLen-1)
				{
					Ext.getCmp('orLabel'+objConIdx).hide();
				}
			}
		}
		
		if (resultObjFieldSetItemsLen == 0)
		{
			Ext.getCmp('trapType_'+containerID).enable();
			Ext.getCmp('addTrapType_'+containerID).show();
			Ext.getCmp('priorityStatus'+containerID).show();
		}
	},

	removeObjContainer: function(containerID, currentObjID, removeConID)
	{
		var resultObjContainer = Ext.getCmp('resultObjContainer'+containerID+'_'+currentObjID+'_1');
		resultObjContainer.remove(removeConID);
		var resultObjContItemsLen = resultObjContainer.items.length;
		for (var z=0; z<resultObjContItemsLen; z++)
		{
			var objConId = resultObjContainer.items.keys[z];
			var objConIdx = objConId.substring(objConId.indexOf('_')+1);
			if (resultObjContItemsLen == 1)
			{
				Ext.getCmp('orLabel'+objConIdx).hide();
			}
			else
			{
				if (z == resultObjContItemsLen-2)
				{
					Ext.getCmp('orLabel'+objConIdx).show();
				}
				if (z == resultObjContItemsLen-1)
				{
					Ext.getCmp('orLabel'+objConIdx).hide();
				}
			}
		}
		
		if (resultObjContItemsLen == 0)
		{
			appCnt.removeTrapObjContainer(containerID, 'mainobjectContfieldset_'+containerID+'_'+currentObjID);
		}
	},

	clearTrapContainer: function()
	{
		var resultContainer = Ext.getCmp('resultContainer');
		resultContainer.removeAll();
		trapInputsCount = 1;
		
		Ext.getCmp('NoDataPattern1').show();
		Ext.getCmp('updateBtn').disable();
		Ext.getCmp('clearBtn').disable();
		Ext.getCmp('deleteBtn').hide();
	},
	
	updateTrapsContainer: function()
	{
		var mibFile = Ext.getCmp('selectMIBId').getValue();
		
		var isText = true;
		if (!Ext.isEmpty(mibFile) && mibFile != '-1' && mibFile != 'enteramib')
		{
			isText = false;
		}
		else
		{
			mibFile = Ext.getCmp('selectMIBFileId').getValue();
		}
		
		var finalContainer = Ext.getCmp('resultContainer');
		var finalContItemsLen = finalContainer.items.length;
		var finalConfigValue = "";
		var trapTypeArr = new Array();
		var trapTypeNameArr = new Array();
		for (var x=0; x<finalContItemsLen; x++)
		{
			var conId = finalContainer.items.keys[x];
			var conIdx = conId.substring(conId.indexOf('_')+1);
			var trapTypeObj = Ext.getCmp('trapType_'+conIdx);
			var trapOId = trapTypeObj.getValue();
			var trapTypeName = '';
			if (isText)
			{
				var trapTypeNameObj = Ext.getCmp('trapTypeName_'+conIdx);
				trapTypeName = trapTypeNameObj.getValue();
			}
			else
			{
				trapTypeName = trapTypeObj.getRawValue();
			}
			finalConfigValue += trapOId+'@@@'+trapTypeName+'###';
			
			if (isText)
			{
				if (Ext.isEmpty(trapTypeName) || trapTypeName == '')
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validateMsg2,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp('trapTypeName_'+conIdx).focus();
						}
					});
					return false;
				}
				if(!checkSpecial(trapTypeName,"=\"/\\:*?<>|[]+,;%&#()`~!@$^_{}'."))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validateMsg3,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp('trapTypeName_'+conIdx).focus();
						}
					});
					return false;
				}
				
				if (trapTypeNameArr.includes(trapTypeName))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validateMsg4+' '+validateMsg5,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp('trapTypeName_'+conIdx).focus();
						}
					});
					return false;
				}
				else
				{
					trapTypeNameArr.push(trapTypeName);
				}
				
				if (Ext.isEmpty(trapOId) || trapOId == '')
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validateMsg6,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp('trapType_'+conIdx).focus();
						}
					});
					return false;
				}
				
				if (!trapOId.startsWith('.'))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validateMsg7+'(.)',
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp('trapType_'+conIdx).focus();
						}
					});
					return false;
				}
				
				if (trapOId.endsWith('.'))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validateMsg8+'(.)',
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp('trapType_'+conIdx).focus();
						}
					});
					return false;
				}
				
				if (trapOId.indexOf('..') != -1)
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validateMsg9,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp('trapType_'+conIdx).focus();
						}
					});
					return false;
				}
				
				var oidArr = trapOId.split('.');
				for (var a=1; a<oidArr.length; a++)
				{
					var num = parseInt(oidArr[a]);
					if (num < 0)
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: validateMsg10,
							buttons: Ext.Msg.OK,
							icon: 'gen-warning size32 color-warning',
							fn: function() {
								Ext.getCmp('trapType_'+conIdx).focus();
							}
						});
						return false;
					}
					else if (isNaN(num))
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: validateMsg11,
							buttons: Ext.Msg.OK,
							icon: 'gen-warning size32 color-warning',
							fn: function() {
								Ext.getCmp('trapType_'+conIdx).focus();
							}
						});
						return false;
					}
				}
				
				if (trapTypeArr.includes(trapOId))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validateMsg12+' '+validateMsg13,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp('trapType_'+conIdx).focus();
						}
					});
					return false;
				}
				else
				{
					trapTypeArr.push(trapOId);
				}
			}
			else
			{
				if (Ext.isEmpty(trapOId) || trapOId == '-1')
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validateMsg14,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp('trapType_'+conIdx).focus();
						}
					});
					return false;
				}
			}
			
			var finalFieldSetContainer = Ext.getCmp('resultObjFieldset'+conIdx+'_1');
			if (!Ext.isEmpty(finalFieldSetContainer))
			{
				var finalFSItemsLen = finalFieldSetContainer.items.length;
				
				if (finalFSItemsLen > 0)
				{
					var finalObjValue = "";
					for (var y=0; y<finalFSItemsLen; y++)
					{
						var dataArr = new Array();
						var fsConId = finalFieldSetContainer.items.keys[y];
						var fsConIdx = fsConId.substring(fsConId.lastIndexOf('_')+1);
						
						var finalObjContainer = Ext.getCmp('resultObjContainer'+conIdx+'_'+fsConIdx+'_1');
						var finalObjContItemsLen = finalObjContainer.items.length;
						for (var z=0; z<finalObjContItemsLen; z++)
						{
							var objConId = finalObjContainer.items.keys[z];
							var objConIdx = objConId.substring(objConId.lastIndexOf('_')+1);
							var trapObject = Ext.getCmp('object'+conIdx+'_'+fsConIdx+'_'+objConIdx);
							var objectOid = Ext.getCmp('object'+conIdx+'_'+fsConIdx+'_'+objConIdx).getValue();
							
							var trapObjectName = '';
							if (isText)
							{
								var trapObjectTxt = Ext.getCmp('objectName'+conIdx+'_'+fsConIdx+'_'+objConIdx);
								trapObjectName = trapObjectTxt.getValue();
							}
							else
							{
								trapObjectName = trapObject.getRawValue();
							}
							
							var condition = Ext.getCmp('condition'+conIdx+'_'+fsConIdx+'_'+objConIdx).getValue();
							var objValue = Ext.getCmp('objectValue'+conIdx+'_'+fsConIdx+'_'+objConIdx).getValue();
							if (isText)
							{
								if (Ext.isEmpty(trapObjectName) || trapObjectName == '')
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: validateMsg25,
										buttons: Ext.Msg.OK,
										icon: 'gen-warning size32 color-warning',
										fn: function() {
											Ext.getCmp('objectName'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
										}
									});
									return false;
								}
								
								if (!checkSpecial(trapObjectName,"=\"/\\:*?<>|[]+,;%&#()`~!@$^_{}'."))
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: validateMsg3,
										buttons: Ext.Msg.OK,
										icon: 'gen-warning size32 color-warning',
										fn: function() {
											Ext.getCmp('objectName'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
										}
									});
									return false;
								}
								
								if (Ext.isEmpty(objectOid) || objectOid == '')
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: validateMsg24,
										buttons: Ext.Msg.OK,
										icon: 'gen-warning size32 color-warning',
										fn: function() {
											Ext.getCmp('object'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
										}
									});
									return false;
								}
								
								if (!objectOid.startsWith('.'))
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: validateMsg22+'(.)',
										buttons: Ext.Msg.OK,
										icon: 'gen-warning size32 color-warning',
										fn: function() {
											Ext.getCmp('object'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
										}
									});
									return false;
								}
								
								if (objectOid.endsWith('.'))
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: validateMsg23+'(.)',
										buttons: Ext.Msg.OK,
										icon: 'gen-warning size32 color-warning',
										fn: function() {
											Ext.getCmp('object'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
										}
									});
									return false;
								}
								
								if (objectOid.indexOf('..') != -1)
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: validateMsg9,
										buttons: Ext.Msg.OK,
										icon: 'gen-warning size32 color-warning',
										fn: function() {
											Ext.getCmp('object'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
										}
									});
									return false;
								}
								
								var objOIDArr = objectOid.split('.');
								for (var b=1; b<objOIDArr.length; b++)
								{
									var num = parseInt(objOIDArr[b]);
									if (num < 0)
									{
										Ext.Msg.show({
											title: pageTitle,
											msg: validateMsg10,
											buttons: Ext.Msg.OK,
											icon: 'gen-warning size32 color-warning',
											fn: function() {
												Ext.getCmp('object'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
											}
										});
										return false;
									}
									else if (isNaN(num))
									{
										Ext.Msg.show({
											title: pageTitle,
											msg: validateMsg11,
											buttons: Ext.Msg.OK,
											icon: 'gen-warning size32 color-warning',
											fn: function() {
												Ext.getCmp('object'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
											}
										});
										return false;
									}
								}
							}
							else
							{
								if (Ext.isEmpty(objectOid) || objectOid == '-1')
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: validateMsg15,
										buttons: Ext.Msg.OK,
										icon: 'gen-warning size32 color-warning',
										fn: function() {
											Ext.getCmp('object'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
										}
									});
									return false;
								}
							}
							
							if (Ext.isEmpty(objValue))
							{
								Ext.Msg.show({
									title: pageTitle,
									msg: validateMsg16,
									buttons: Ext.Msg.OK,
									icon: 'gen-warning size32 color-warning',
									fn: function() {
										Ext.getCmp('objectValue'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
									}
								});
								return false;
							}
							
							if (condition == 'eq' || condition == 'ne')
							{
								if (objValue.indexOf("*") != -1)
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: validateMsg17,
										buttons: Ext.Msg.OK,
										icon: 'gen-warning size32 color-warning',
										fn: function() {
											Ext.getCmp('objectValue'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
										}
									});
									return false;
								}
							}
							else if (condition == 'gt' || condition == 'le' ||
							condition == 'lt' || condition == 'ge')
							{
								if (isNaN(objValue))
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: validateMsg18,
										buttons: Ext.Msg.OK,
										icon: 'gen-warning size32 color-warning',
										fn: function() {
											Ext.getCmp('objectValue'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
										}
									});
									return false;
								}
							}
							else if (condition == 'mc' || condition == 'nm')
							{
								if (objValue.indexOf("**") != -1)
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: validateMsg26,
										buttons: Ext.Msg.OK,
										icon: 'gen-warning size32 color-warning',
										fn: function() {
											Ext.getCmp('objectValue'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
										}
									});
									return false;
								}
							}
							
							var orgObjValue = Ext.getCmp('$objectValue'+conIdx+'_'+fsConIdx+'_'+objConIdx).getValue();
							
							if (Ext.isEmpty(orgObjValue) || orgObjValue == '')
							{
								orgObjValue = objValue;
							}
							else
							{
								var idx = orgObjValue.indexOf('#^#');
								if (idx != -1)
								{
									var subObjVal = orgObjValue.substring(idx+3);
									orgObjValue = objValue+'#^#'+subObjVal;
								}
								else
								{
									orgObjValue = objValue;
								}
							}
							
							if (dataArr.includes(objectOid+'^#^'+condition+'^#^'+orgObjValue))
							{
								Ext.Msg.show({
									title: pageTitle,
									msg: validateMsg19,
									buttons: Ext.Msg.OK,
									icon: 'gen-warning size32 color-warning',
									fn: function() {
										Ext.getCmp('objectValue'+conIdx+'_'+fsConIdx+'_'+objConIdx).focus();
									}
								});
								return false;
							}
							dataArr.push(objectOid+'^#^'+condition+'^#^'+orgObjValue);
							
							finalObjValue += trapObjectName+"@$@"+objectOid+'^#^'+condition+'^#^'+orgObjValue+'$#$';
						}
						finalObjValue = finalObjValue.substring(0,finalObjValue.lastIndexOf('$#$'));
						var objPriorityVal = Ext.getCmp('objPriorityStatus'+conIdx+'_'+fsConIdx).getValue();
						finalObjValue += '#@#'+objPriorityVal+'#$#';
					}
					finalObjValue = finalObjValue.substring(0,finalObjValue.lastIndexOf('#$#'));
					finalConfigValue += finalObjValue+'$$$';
				}
				else
				{
					var priorityVal = Ext.getCmp('priorityStatus'+conIdx).getValue();
					finalConfigValue += trapOId+'#@#'+priorityVal+'$$$';
				}
			}
		}
		
		finalConfigValue = finalConfigValue.substring(0,finalConfigValue.lastIndexOf('$$$'));
		
		if (!Ext.isEmpty(finalConfigValue) && finalConfigValue.length > 0)
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			Ext.Ajax.request({
				url : 'ConfigureTrapPriority/data/EgConfigureTrapPriorityJsonp.jsp',
				method : 'POST',
				params: {
					'mibFile': mibFile,
					'finalValue': filterEncode(finalConfigValue)
				},
				async: false,
				success: function(response)
				{
					myMask.hide();
					var jsonText = response.responseText;
					var pubJson = Ext.decode(jsonText);
					Ext.getCmp('deleteBtn').show();
					Ext.getCmp('ConfigureTrapsPriority').setTitle('<div><a href="javascript:void(0)" onclick="javascript:appCnt.gotoToBack()"> <img src="/final/images/spacer.gif" class="aIconBackArrow" /> </a>'+pageTitle+'</div>');
					Ext.Msg.show({
						title: pageTitle,
						msg: successMsg1,
						buttons: Ext.Msg.OK,
						icon: 'gen-info size32 color-info'
					});
				},
				failure: function(respone)
				{
					myMask.hide();
				}
			});
		}
	},
	
	deleteAllConfiguredTraps: function()
	{
		var isUploadedFile = 'true';
		var mibFileObj = Ext.getCmp('selectMIBId');
		var mibFile = mibFileObj.getValue();
		if (!Ext.isEmpty(mibFile) && mibFile == 'enteramib')
		{
			isUploadedFile = 'false';
			mibFile = Ext.getCmp('selectMIBFileId').getValue();
		}
		
		Ext.Msg.show({
			title: pageTitle,
			msg: successMsg2+' '+mibFile+'?',
			buttons: Ext.Msg.YESNO,
			icon: 'gen-question size32 color-question',
			fn: function(btn)
			{
				if (btn == 'yes')
				{
					Ext.Ajax.request({
						url : 'ConfigureTrapPriority/data/EgConfigureTrapPriorityJsonp.jsp',
						method : 'POST',
						params: {
							'fromAction': "delete",
							'mibFile': mibFile
						},
						async: false,
						success: function(response)
						{
							var jsonText = response.responseText;
							var pubJson = Ext.decode(jsonText);
							var isConfiguredFilesExist = pubJson.isConfiguredFilesExist;
							Ext.Msg.show({
								title: pageTitle,
								msg: successMsg3,
								buttons: Ext.Msg.OK,
								icon: 'gen-info size32 color-info',
								fn: function()
								{
									Ext.getCmp('deleteBtn').hide();
									if (isConfiguredFilesExist)
									{
										appCnt.loadSelectedMib(mibFile, isUploadedFile);
									}
									else
									{
										appCnt.loadMibFileData(mibFileObj);
									}
								}
							});
						},
						failure: function(respone)
						{
							myMask.hide();
						}
					});
				}
			}
		});
	},
	
	deleteConfiguredTrapsForMib: function(mibFile,isUploadedFile)
	{
		Ext.Msg.show({
			title: mainTitle,
			msg: successMsg2+' '+mibFile+'?',
			buttons: Ext.Msg.YESNO,
			icon: 'gen-question size32 color-question',
			fn: function(btn)
			{
				if (btn == 'yes')
				{
					Ext.Ajax.request({
						url : 'ConfigureTrapPriority/data/EgConfigureTrapPriorityJsonp.jsp',
						method : 'POST',
						params: {
							'fromAction': "delete",
							'mibFile': mibFile
						},
						async: false,
						success: function(response)
						{
							var jsonText = response.responseText;
							var pubJson = Ext.decode(jsonText);
							var isConfiguredFilesExist = pubJson.isConfiguredFilesExist;
							Ext.Msg.show({
								title: mainTitle,
								msg: successMsg3,
								buttons: Ext.Msg.OK,
								icon: 'gen-info size32 color-info',
								fn: function()
								{
									var mainViewId = Ext.getCmp('mainView');

									if (!Ext.isEmpty(mainViewId))
									{
										mainViewId.removeAll();
									}
									mainViewId.add({ xtype: 'main'});
								}
							});
						},
						failure: function(respone)
						{
							myMask.hide();
						}
					});
				}
			}
		});
	},
	
	getPopUpView : function(ResourceId, objId, optId)
	{
		if (Ext.getCmp('configureValues') != undefined)
		{
			Ext.getCmp('configureValues').removeAll();
			Ext.getCmp('backupmultirescontainer').removeAll();
			Ext.getCmp('backupmultirescontainer').doLayout();
		}
		var objectStr = Ext.getCmp(objId).getValue();
		var objectName = Ext.getCmp(objId).rawValue;
		if (!Ext.isEmpty(objectStr) && objectStr == '-1')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: validateMsg20,
				buttons: Ext.Msg.OK,
				icon: 'gen-warning size32 color-warning',
				fn: function() {
					Ext.getCmp(objId).focus();
				}
			});
			return false;
		}
		var conditionName = Ext.getCmp(optId).rawValue;
		
		var trapId = ResourceId.substring(ResourceId.indexOf('_')-1, ResourceId.indexOf('_'));
		
		var trapName = Ext.getCmp('trapType_'+trapId).rawValue;
		var resource_id = ResourceId.substring(1);
		var resValue = Ext.getCmp(ResourceId).getValue();
		var resObjValue = Ext.getCmp(resource_id).getValue();
		inputs = 1;
		popUpWin = Ext.create('Ext.Window', {
			layout: 'fit',
			border: false,
			ghost:false,
			closeAction:'destroy',
			padding:'5 10 10 10',
			bodyPadding:'0 0 10 0',
			header:{
				margin:'5 5 5 5',
			},
			title: pageTitle1,
			id: 'configureValues',
			width: 700,
			height: 350,
			autoScroll: true,
			modal: true,
			layout: {
				type: 'auto',
				pack: 'start',
				align: 'stretch'
			},
			dockedItems: [
				{
					dock: 'bottom',
					xtype:'toolbar',
					layout:{
						type:'hbox',
						align:'stretch',
						pack:'center'
					},
					ui:'toolbarBgWithTopBorder',
					border:false,
					padding : '10 0 10 0',
					items: [
						{
							xtype: 'button',
							ui: 'aButtonSmall',
							id: 'addMultiresbtn',
							width: 80,
							text: buttonText10,
							listeners : 
							{
								'click' : function()
								{
									appCnt.addMultiResourceContact();
								}
							}
						},
						{
							xtype: 'button',
							ui: 'aButtonSmall',
							text: buttonText3,
							width: 80,
							id: 'updateMultires',
							name: 'updateMultires',
							margin: '0 0 0 10',
							listeners : 
							{
								'click' : function()
								{
									appCnt.updateMultiResourceContact(ResourceId, optId);
								}
							}
						},
						{
							xtype: 'button',
							ui: 'aButtonSmall',
							text: buttonText4,
							width: 80,
							id: 'clearMultires',
							name: 'clearMultires',
							margin: '0 0 0 10',
							listeners : 
							{
								'click' : function()
								{
									appCnt.clearMultiResourceContact();
								}
							}
						}
					]
				}
			],
			items: [
				{
					xtype: 'container',
					html: '<div style="border:1px solid lightGrey;padding-top: 10px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px;"><b>Trap</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+trapName+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>Object</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+objectName+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>Condition  </b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; '+conditionName+'</div>',
					margin: 10
				},
				{
					xtype: 'container',
					id: 'backupmultirescontainer',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'stretch'
					}
				},
				{
					xtype: 'container',
					id: 'NoMultiResPattern',
					hidden: true,
					layout: {
						type: 'hbox',
						pack: 'center',
						align: 'center'
					},
					border:true,
					margin: '5 10 5 10',
					flex:1,
					columnWidth:1,
					items: [
						{
							xtype: 'label',
							html: '<table border="0px" height="160"><tr><td align="center"><table><tr><td align="center"><div class="gen-info size32 color-info"></div><div class="commonErrorMsgText">'+descMsg2+'</div></td></tr></table></td></tr></table>'
						}
					]
				}
			]
		});
		popUpWin.show();
		
		if (Ext.isEmpty(resValue))
		{
			appCnt.addMultiResourceContact();
			Ext.getCmp('value1').setValue(resObjValue);
		}
		else
		{
			var multidom = '';
			var splitresValue = resValue.split("#^#");
			if (resValue != null || resValue != undefined)
			{
				var val = splitresValue.length-1;
				for (var k =0;k<=splitresValue.length-1;k++ )
				{
					appCnt.addMultiResourceContact();
				}
				for (multidom=1;multidom<splitresValue.length+1;multidom++)
				{
					var val = splitresValue[multidom-1];
					if (multidom == 1)
					{
						Ext.getCmp('value'+multidom).setValue(resObjValue);
					}
					else
					{
						Ext.getCmp('value'+multidom).setValue(val);
					}
				}
			}
		}
	},
	
	addMultiResourceContact: function()
	{
		var mainForm = Ext.getCmp('configureValues');
		var backupmulticontainer = Ext.getCmp('backupmultirescontainer');
		var currentID = inputs;
		var conIdRes = "containerRes_"+inputs
		var tmpMultiContainer = {
			xtype: 'container',
			id: conIdRes,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'stretch'
			},
			border: false,
			style: 'border: 1px solid green',
			items: [
				{
					xtype : 'fieldset',
					id : 'conRes_'+inputs,
					style: {
						'background' : '#ffffff',
						'border' : '1px solid lightGrey',
						'box-shadow':'none'
					},
					padding:'10 0 10 10',
					margin: '10 10 0 10',
					items: [
						{
							xtype: 'container',
							layout: 'column',
							defaults: {
								labelSeparator:' ',
								labelWidth:150
							},
							items: [
								{
									xtype: 'fieldcontainer',
									layout: 'column',
									columnWidth: 1,
									defaults: {
										labelSeparator:' '
									},
									items: [
										{
											xtype: 'textfield',
											cls: 'aTextbox',
											style:{'white-space':'nowrap'},
											id:'value'+inputs,
											fieldLabel: labelMsg7,
											value: '',
											columnWidth: 0.97
										}
									]
								},
								{
									xtype: 'container',
									style:{
										'position':'absolute',
										'top':'2px',
										'right':'2px',
										'width':'20px',
										'height':'20px'
									},
									margin: '12 10 0 0',
									items : [
										{
											xtype: 'button',
											tooltip: 'Delete',
											id: 'removeVal'+inputs,
											iconCls : 'iconMinus',
											style : {
												background : 'none',
												border : '0px'
											},
											handler: function()
											{
												appCnt.removeMultiResource(conIdRes);
											}
										}
									]
								}
							]
						}
					]
				},
				{
					xtype: 'label',
					id: 'orLabel'+currentID,
					hidden: false,
					margin: 10,
					html: '<div style="text-align:center;border-bottom:lightgrey 1px solid"><b><span style="background-color:white;padding: 0 5px; position:relative;top:8px;">OR</span></b></div>'
				}
			]
		}
		backupmulticontainer.add(tmpMultiContainer);
		mainForm.doLayout();

		Ext.getCmp('addMultiresbtn').setText(buttonText10);
		Ext.getCmp('updateMultires').enable();
		Ext.getCmp('clearMultires').enable();
		Ext.getCmp('NoMultiResPattern').hide();
		
		var backupcontainer = Ext.getCmp('backupmultirescontainer');
		var bckitemsmultiLen = backupcontainer.items.length;
		
		for (var z=0; z<bckitemsmultiLen; z++)
		{
			var objConId = backupcontainer.items.keys[z];
			var objConIdx = objConId.substring(objConId.indexOf('_')+1);
			if (bckitemsmultiLen == 1)
			{
				Ext.getCmp('orLabel'+objConIdx).hide();
			}
			else
			{
				if (z == bckitemsmultiLen-2)
				{
					Ext.getCmp('orLabel'+objConIdx).show();
				}
				if (z == bckitemsmultiLen-1)
				{
					Ext.getCmp('orLabel'+objConIdx).hide();
				}
			}
		}

		inputs++;
	},
	
	clearMultiResourceContact: function()
	{
		var backupmulticontainer = Ext.getCmp('backupmultirescontainer');
		backupmulticontainer.removeAll();
		inputs = 1;
		appCnt.addMultiResourceContact();
	},
	
	removeMultiResource: function(containerID)
	{
		var backupcontainer = Ext.getCmp('backupmultirescontainer');
		backupcontainer.remove(containerID);
		var bckitemsmultiLen = backupcontainer.items.length;
		for (var z=0; z<bckitemsmultiLen; z++)
		{
			var objConId = backupcontainer.items.keys[z];
			var objConIdx = objConId.substring(objConId.indexOf('_')+1);
			if (bckitemsmultiLen == 1)
			{
				Ext.getCmp('orLabel'+objConIdx).hide();
			}
			else
			{
				if (z == bckitemsmultiLen-2)
				{
					Ext.getCmp('orLabel'+objConIdx).show();
				}
				if (z == bckitemsmultiLen-1)
				{
					Ext.getCmp('orLabel'+objConIdx).hide();
				}
			}
		}
		if (bckitemsmultiLen == 0)
		{
			inputs = 1;
			Ext.getCmp('NoMultiResPattern').show();
			Ext.getCmp('updateMultires').disable();
			Ext.getCmp('clearMultires').disable();
			Ext.getCmp('addMultiresbtn').setText('Add');
		}
	},
	
	updateMultiResourceContact: function(resourceId, optId)
	{
		var conditionVal = Ext.getCmp(optId).getValue();
		var resource_id = resourceId.substring(1);
		var multiinputs = inputs;
		var finalValue = "";
		var count = 0;
		for (var mul=1;mul<=multiinputs-1;mul++)
		{
			if (Ext.getCmp('value'+mul) == undefined)
			{
				continue;
			}
			var valueStr = Ext.getCmp('value'+mul).getValue();
			if (valueStr == '')
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: validateMsg16,
					buttons: Ext.Msg.OK,
					icon: 'gen-warning size32 color-warning',
					fn: function() {
						Ext.getCmp('value'+mul).focus();
					}
				});
				return false;
			}
			if (conditionVal == 'eq' || conditionVal == 'ne')
			{
				if (valueStr.indexOf("*") != -1)
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: validateMsg17,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp('value'+mul).focus();
						}
					});
					return false;
				}
			}
			else if (conditionVal == 'gt' || conditionVal == 'le' ||
			conditionVal == 'lt' || conditionVal == 'ge')
			{
				if (isNaN(valueStr))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: validateMsg18,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp('value'+mul).focus();
						}
					});
					return false;
				}
			}
			
			if (!Ext.isEmpty(valueStr))
			{
				finalValue += valueStr + "#^#";
				count++;
			}
		}
		finalValue = finalValue.substring(0,finalValue.lastIndexOf("#^#"));
		var finalUIVal = "";
		if (count > 1)
		{
			finalUIVal = finalValue.substring(0, finalValue.indexOf("#^#"));
			
			finalUIVal = finalUIVal;
			Ext.getCmp(resource_id).setReadOnly(true);
		}
		else
		{
			finalUIVal = finalValue;
			Ext.getCmp(resource_id).setReadOnly(false);
		}
		Ext.getCmp(resourceId).setValue(finalValue);
		Ext.getCmp(resource_id).setValue(finalUIVal);
		Ext.getCmp('configureValues').close();
	},
	
	gotoToBack: function()
	{
		var mainViewId = Ext.getCmp('mainView');

		if (!Ext.isEmpty(mainViewId))
		{
			mainViewId.removeAll();
		}
		mainViewId.add({ xtype: 'main'});
	},
	
	gotoConfiguredTrapPriority: function()
	{
		Ext.Ajax.request({
			url : 'ConfigureTrapPriority/data/EgConfigureTrapPriorityJson.jsp',
			method : 'POST',
			params: {
				'fromAction': "configFiles"
			},
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				var userMibFiles = publicJSON.userMibFiles;
				if (userMibFiles != null && userMibFiles.length > 0)
				{
					Ext.getCmp('userMibFilesId').getStore().clearFilter();
					Ext.getCmp('userMibFilesId').getStore().loadRawData(userMibFiles);
				}
				else
				{
					Ext.getCmp('searchMIB').hide();
					Ext.getCmp('trapDescId').hide();
					Ext.getCmp('userMibFilesId').hide();
					Ext.getCmp("emptyMIBMsg").show();
					Ext.getCmp('emptyMIBMsg').update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+descMsg4+'<br/></div></div>');
				}
			}
		});
	},
	
	// manual
	loadCustomMibFileData: function()
	{
		var mibFile = Ext.getCmp('selectMIBFileId').getValue();
		
		if (Ext.isEmpty(mibFile) || mibFile == '')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: validateMsg21,
				buttons: Ext.Msg.OK,
				icon: 'gen-warning size32 color-warning',
				fn: function() {
					Ext.getCmp('selectMIBFileId').focus();
					Ext.getCmp('selectMIBId').setDisabled(false);
					appCnt.clearTrapContainer1();
				}
			});
			return false;
		}
		else if(!checkSpecial(mibFile,"\\/:*?\"<>|"))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: validateMsg3,
				buttons: Ext.Msg.OK,
				icon: 'gen-warning size32 color-warning',
				fn: function() {
					Ext.getCmp('selectMIBFileId').focus();
				}
			});
			return false;
		}
		
		var myMask = new Ext.LoadMask(Ext.getCmp('ConfigureTrapsPriority'), {msg: 'Loading...'});
		myMask.show();
		Ext.Ajax.request({
			url : 'ConfigureTrapPriority/data/EgConfigureTrapPriorityJson.jsp?fromAction=checkFileUploaded&mibFile='+mibFile,
			method : 'POST',
			async: false,
			success: function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				
				var isFileUploaded = publicJSON.isFileUploaded;
				if (isFileUploaded)
				{
					Ext.getCmp('selectMIBFileId').setValue('');
					appCnt.loadSelectedMib(mibFile, 'true');
				}
				else
				{
					appCnt.loadSelectedMib(mibFile, 'false');
				}
			}
		});
	},
	
	addCustomTrapTypeContainer: function()
	{
		var mainForm = Ext.getCmp('ConfigureTrapsPriority');
		var resultContainer = Ext.getCmp('resultContainer');

		var conIdMulti = "mainfieldset_"+trapInputsCount;
		var currentTrapConID = trapInputsCount;
		var currentTrapObjectsConId = trapObjInputsCount;
		var currentID = trapInputsCount+'_'+trapObjInputsCount;
		
		var tmpContainer = {

			xtype : 'fieldset',
			title: '<b>'+fsTitle1+'</b>',
			id: conIdMulti,
			style: {
				'background' : '#ffffff',
				'border' : '1px solid lightGrey',
				'box-shadow':'none'
			},
			width: 978,
			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'stretch'
			},
			margin: '5 10 10 10',
			items: [
				{
					xtype: 'container',
					border: false,
					style: 'border: 1px solid red',
					id: 'trapTypes_'+trapInputsCount,
					defaults: {
						labelSeparator:' ',
						labelWidth: 100
					},
					layout : {
						type : 'hbox',
						pack : 'start'
					},
					items:[
						{
							xtype: 'textfield',
							cls: 'aTextbox',
							fieldLabel: labelMsg8,
							id: 'trapTypeName_'+trapInputsCount,
							name: 'trapTypeName_'+trapInputsCount,
							labelSeparator: '',
							labelAlign: 'top',
							width: 250,
							value: ''
						},
						{
							xtype: 'textfield',
							cls: 'aTextbox',
							fieldLabel: labelMsg9,
							id: 'trapType_'+trapInputsCount,
							name: 'trapType_'+trapInputsCount,
							labelSeparator: '',
							labelAlign: 'top',
							width: 250,
							value: '',
							margin: '0 0 0 20'
						},
						{
							xtype: "scrollcombo",
							cls: "dropdown",
							id: 'priorityStatus'+trapInputsCount,
							name: 'priorityStatus'+trapInputsCount,
							fieldLabel: labelMsg4,
							labelSeparator:'',
							labelAlign: 'top',
							prevValue: '',
							valueField: "valueField",
							displayField: "displayField",
							queryMode: "local",
							editable: false,
							value: 'Minor',
							width: 80,
							margin: '0 0 0 20',
							store: new Ext.data.Store({
								fields: ["displayField", "valueField"],
								data: [{"displayField":"Critical", "valueField":"Critical"},{"displayField":"Major", "valueField":"Major"},{"displayField":"Minor", "valueField":"Minor"}]
							}),
						}
					]
				},
				{
					xtype: 'container',
					id: 'resultObjFieldset'+trapInputsCount+'_1',
					layout: {
						type: 'vbox',
						pack: 'start',
						align: 'stretch'
					},
					margin: '10 0 0 0'
				},
				{
					xtype: 'container',
					border: false,
					style: 'border: 1px solid blue',
					layout : {
						type : 'hbox',
						pack : 'end'
					},
					items : [
						{
							xtype: 'button',
							tooltip: buttonText11,
							iconCls: 'iconLibraryPlus',
							style : {
								background : 'none',
								border : '0px'
							},
							id: 'addTrapType_'+trapInputsCount,
							listeners: {
								click: function() {
									appCnt.addCustomTrapObjectsContainer(currentTrapConID);
								}
							}
						},
						{
							xtype: 'button',
							tooltip: buttonText7,
							iconCls: 'iconDelete',
							style : {
								background : 'none',
								border : '0px'
							},
							id: 'removeTrapType_'+trapInputsCount,
							margin: '0 0 0 10',
							handler: function()
							{
								appCnt.removeMainContainer(conIdMulti);
							}
						}
					]
				}
			]
		}
		
		resultContainer.add(tmpContainer);
		mainForm.doLayout();
		
		Ext.getCmp('addBtn').setText(buttonText6);
		Ext.getCmp('NoDataPattern1').hide();
		
		trapInputsCount++;
		return currentTrapConID;
	},
	
	addCustomTrapObjectsContainer: function(trapConId)
	{
		var mainForm = Ext.getCmp('ConfigureTrapsPriority');
		var resultObjFieldset = Ext.getCmp('resultObjFieldset'+trapConId+'_1');
		var currentID = trapConId+'_'+trapObjInputsCount;
		var objCurrentID = trapObjInputsCount;
		var conIdMulti = 'mainobjectContfieldset_'+trapConId+'_'+trapObjInputsCount;
		var tmpObjContainer = {
			xtype: 'container',
			id: conIdMulti,
			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'stretch'
			},
			border: false,
			style: 'border: 1px solid yellow',
			items: [
				{
					xtype: 'fieldset',
					title: '<b>'+fsTitle2+'</b>',
					id: 'mainobjfieldset'+currentID,
					style: {
						'background' : '#ffffff',
						'border' : '1px solid lightGrey',
						'box-shadow':'none'
					},
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								pack: 'start',
								align: 'stretch'
							},
							id: 'mainobjconatiner'+currentID,
							border: false,
							style: 'border: 1px solid blue',
							items: [
								{
									xtype: 'container',
									id: 'resultObjContainer'+currentID+'_1',
									layout: {
										type: 'vbox',
										pack: 'start',
										align: 'stretch'
									},
									items: [
										{
											xtype: 'container',
											id: 'trapContObjects_'+currentID+'_1',
											layout: {
												type: 'vbox',
												pack: 'start',
												align: 'stretch'
											},
											border: false,
											style: 'border: 1px solid brown',
											items: [
												{
													xtype: 'fieldcontainer',
													layout: 'column',
													border: false,
													style: 'border: 1px solid red',
													id: 'trapObjects'+currentID+'_1',
													defaults: {
														labelSeparator:' '
													},
													margin: '0 0 10 0',
													columnWidth: 1,
													items:[
														{
															xtype: 'textfield',
															cls: 'aTextbox',
															fieldLabel: labelMsg10,
															id: 'objectName'+currentID+'_1',
															name: 'objectName'+currentID+'_1',
															labelAlign: 'top',
															labelSeparator:'',
															columnWidth: 0.21,
															value: '',
														},
														{
															xtype: 'textfield',
															cls: 'aTextbox',
															fieldLabel: labelMsg11,
															id: 'object'+currentID+'_1',
															name: 'object'+currentID+'_1',
															labelAlign: 'top',
															labelSeparator:'',
															margin: '0 0 0 10',
															columnWidth: 0.21,
															value: ''
														},
														{
															xtype: "scrollcombo",
															cls: "dropdown",
															id: 'condition'+currentID+'_1',
															name: 'condition'+currentID+'_1',
															fieldLabel: labelMsg6,
															labelAlign: 'top',
															labelSeparator:'',
															valueField: "valueField",
															displayField: "displayField",
															queryMode: "local",
															editable: false,
															margin: '0 0 0 10',
															columnWidth: 0.15,
															value: 'eq',
															store: new Ext.data.Store({
																fields: ["displayField", "valueField"],
																data: [
																	{displayField:'=',valueField:'eq'},
																	{displayField:'!=',valueField:'ne'},
																	{displayField:'>',valueField:'gt'},
																	{displayField:'<',valueField:'lt'},
																	{displayField:'>=',valueField:'ge'},
																	{displayField:'<=',valueField:'le'},
																	{displayField:'matches',valueField:'mc'},
																	{displayField:'not matches',valueField:'nm'}
																]
															})
														},
														{
															xtype: 'textfield',
															cls: 'aTextbox',
															fieldLabel: labelMsg7,
															labelAlign: 'top',
															id:'objectValue'+currentID+'_1',
															name: 'objectValue'+currentID+'_1',
															value: '',
															margin: '0 0 0 10',
															columnWidth: 0.40,
															fieldHelp: 'Click on the service icon to configure multiple values',
															listeners: {
																scope: this,
																focus: onFieldFocus,
																blur: onFieldBlur
															}
														},
														{
															xtype: 'hidden',
															id:'$objectValue'+currentID+'_1',
															name: '$objectValue'+currentID+'_1',
															value: ''
														},
														{
															xtype: 'button',
															columnWidth: 0.03,
															tooltip: 'Configure values',
															id: 'configObjectValue'+currentID+'_1',
															iconCls : 'iconService',
															style : {
																background : 'none',
																border : '0px'
															},
															margin: '22 0 0 2',
															listeners: {
																click: function() {
																	var resId = this.getId().replace("configObjectValue","$objectValue");
																	var objId = this.getId().replace("configObjectValue","object");
																	var optId = this.getId().replace("configObjectValue","condition");
																	appCnt.getPopUpView(resId, objId, optId);
																}
															}
														},
														{
															xtype: 'button',
															tooltip: 'Delete',
															id: 'removeObj'+currentID+'_1',
															iconCls : 'iconMinus',
															style : {
																background : 'none',
																border : '0px'
															},
															margin: '22 0 0 20',
															listeners: {
																click: function() {
																	appCnt.removeObjContainer(trapConId, objCurrentID, 'trapContObjects_'+currentID+'_1');
																}
															}
														}
													]
												},
												{
													xtype: 'label',
													id: 'orLabel'+currentID+'_1',
													hidden: true,
													margin: '5 0 20 0',
													html: '<div style="text-align:center;border-bottom:lightgrey 1px solid"><b><span style="background-color:white;padding: 0 5px; position:relative;top:8px;">AND</span></b></div>'
												}
											]
										}
									]
								},
								{
									xtype: 'container',
									border: false,
									style: 'border: 1px solid blue',
									margin: '10 0 0 0',
									layout : {
										type : 'hbox',
										pack : 'end'
									},
									items : [
										{
											xtype: "scrollcombo",
											cls: "dropdown",
											id: 'objPriorityStatus'+currentID,
											name: 'objPriorityStatus'+currentID,
											fieldLabel: labelMsg4,
											labelSeparator:'',
											labelAlign: 'top',
											prevValue: '',
											valueField: "valueField",
											displayField: "displayField",
											queryMode: "local",
											editable: false,
											value: 'Minor',
											width: 80,
											store: new Ext.data.Store({
												fields: ["displayField", "valueField"],
												data: [{"displayField":"Critical", "valueField":"Critical"},{"displayField":"Major", "valueField":"Major"},{"displayField":"Minor", "valueField":"Minor"}]
											}),
										},
										{
											xtype: 'container',
											border: false,
											style: 'border: 1px solid blue',
											layout : {
												type : 'hbox',
												pack : 'end'
											},
											flex: 1,
											items : [
												{
													xtype: 'button',
													tooltip: buttonText12,
													iconCls: 'iconPlus',
													style : {
														background : 'none',
														border : '0px'
													},
													id: 'addTrapObjType'+currentID,
													margin: '20 0 0 0',
													listeners: {
														click: function() {
															appCnt.addCustomObjectsContainer(trapConId, objCurrentID, currentID);
														}
													}
												},
												{
													xtype: 'button',
													tooltip: buttonText7,
													iconCls: 'iconDelete',
													style : {
														background : 'none',
														border : '0px'
													},
													id: 'removeTrapObj'+currentID,
													margin: '20 0 0 10',
													handler: function()
													{
														appCnt.removeCustomTrapObjContainer(trapConId, conIdMulti);
													}
												}
											]
										}
									]
								}
							]
						}
					]
				},
				{
					xtype: 'label',
					id: 'orLabel'+currentID,
					hidden: false,
					margin: '5 0 20 0',
					html: '<div style="text-align:center;border-bottom:lightgrey 1px solid"><b><span style="background-color:white;padding: 0 5px; position:relative;top:8px;">OR</span></b></div>'
				}
			]
		}
		
		resultObjFieldset.add(tmpObjContainer);
		mainForm.doLayout();
		
		var trapOid = Ext.getCmp('trapType_'+trapConId).getValue();
		var trapObjects = publicJSON[trapOid];
		
		if (trapObjects != null && trapObjects.length > 0)
		{
			Ext.getCmp('trapObjects'+currentID+'_1').show();
			Ext.getCmp('object'+currentID+'_1').getStore().loadRawData(trapObjects);
			Ext.getCmp('object'+currentID+'_1').setValue(trapObjects[0].valueField);
		}
		
		Ext.getCmp('priorityStatus'+trapConId).hide();
		
		var resultObjFieldset = Ext.getCmp('resultObjFieldset'+trapConId+'_1');
		var resultObjFieldSetItemsLen = resultObjFieldset.items.length;
		
		for (var z=0; z<resultObjFieldSetItemsLen; z++)
		{
			var objConId = resultObjFieldset.items.keys[z];
			var objConIdx = objConId.substring(objConId.indexOf('_')+1);
			if (resultObjFieldSetItemsLen == 1)
			{
				Ext.getCmp('orLabel'+objConIdx).hide();
			}
			else
			{
				if (z == resultObjFieldSetItemsLen-2)
				{
					Ext.getCmp('orLabel'+objConIdx).show();
				}
				if (z == resultObjFieldSetItemsLen-1)
				{
					Ext.getCmp('orLabel'+objConIdx).hide();
				}
			}
		}
		trapObjInputsCount++;
		return objCurrentID;
	},
	
	addCustomObjectsContainer: function(trapConId, objCurrentID, conId)
	{
		var mainForm = Ext.getCmp('ConfigureTrapsPriority');
		var resultObjContainer = Ext.getCmp('resultObjContainer'+conId+'_1');
		var currentID = conId+'_'+objInputsCount;
		var conIdMulti = 'trapContObjects_'+conId+'_'+objInputsCount;
		var tmpObjContainer = {
			xtype: 'container',
			id: conIdMulti,
			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'stretch'
			},
			border: false,
			style: 'border: 1px solid green',
			items: [
				{
					xtype: 'fieldcontainer',
					layout: 'column',
					border: false,
					style: 'border: 1px solid red',
					id: 'trapObjects'+currentID,
					defaults: {
						labelSeparator:' '
					},
					margin: '0 0 10 0',
					columnWidth: 1,
					items:[
						{
							xtype: 'textfield',
							cls: 'aTextbox',
							fieldLabel: labelMsg10,
							id: 'objectName'+currentID,
							name: 'objectName'+currentID,
							labelAlign: 'top',
							labelSeparator:'',
							columnWidth: 0.21,
							value: '',
						},
						{
							xtype: 'textfield',
							cls: 'aTextbox',
							fieldLabel: labelMsg11,
							id: 'object'+currentID,
							name: 'object'+currentID,
							labelAlign: 'top',
							labelSeparator:'',
							margin: '0 0 0 10',
							columnWidth: 0.21,
							value: ''
						},
						{
							xtype: "scrollcombo",
							cls: "dropdown",
							id: 'condition'+currentID,
							name: 'condition'+currentID,
							fieldLabel: labelMsg6,
							labelAlign: 'top',
							labelSeparator:'',
							valueField: "valueField",
							displayField: "displayField",
							queryMode: "local",
							editable: false,
							margin: '0 0 0 10',
							columnWidth: 0.15,
							value: 'eq',
							store: new Ext.data.Store({
								fields: ["displayField", "valueField"],
								data: [
									{displayField:'=',valueField:'eq'},
									{displayField:'!=',valueField:'ne'},
									{displayField:'>',valueField:'gt'},
									{displayField:'<',valueField:'lt'},
									{displayField:'>=',valueField:'ge'},
									{displayField:'<=',valueField:'le'},
									{displayField:'matches',valueField:'mc'},
									{displayField:'not matches',valueField:'nm'}
								]
							})
						},
						{
							xtype: 'textfield',
							cls: 'aTextbox',
							fieldLabel: labelMsg7,
							labelAlign: 'top',
							id:'objectValue'+currentID,
							name: 'objectValue'+currentID,
							value: '',
							margin: '0 0 0 10',
							columnWidth: 0.40,
							fieldHelp: 'Click on the service icon to configure multiple values',
							listeners: {
								scope: this,
								focus: onFieldFocus,
								blur: onFieldBlur
							}
						},
						{
							xtype: 'hidden',
							id:'$objectValue'+currentID,
							name: '$objectValue'+currentID,
							value: ''
						},
						{
							xtype: 'button',
							columnWidth: 0.03,
							tooltip: 'Configure values',
							id: 'configObjectValue'+currentID,
							iconCls : 'iconService',
							style : {
								background : 'none',
								border : '0px'
							},
							margin: '22 0 0 2',
							listeners: {
								click: function() {
									var resId = this.getId().replace("configObjectValue","$objectValue");
									var objId = this.getId().replace("configObjectValue","object");
									var optId = this.getId().replace("configObjectValue","condition");
									appCnt.getPopUpView(resId, objId, optId);
								}
							}
						},
						{
							xtype: 'button',
							tooltip: 'Delete',
							id: 'removeObj'+currentID,
							iconCls : 'iconMinus',
							style : {
								background : 'none',
								border : '0px'
							},
							margin: '22 0 0 20',
							listeners: {
								click: function() {
									appCnt.removeCustomObjContainer(trapConId, objCurrentID, conIdMulti);
								}
							}
						}
					]
				},
				{
					xtype: 'label',
					id: 'orLabel'+currentID,
					hidden: false,
					margin: '5 0 20 0',
					html: '<div style="text-align:center;border-bottom:lightgrey 1px solid"><b><span style="background-color:white;padding: 0 5px; position:relative;top:8px;">AND</span></b></div>'
				}
			]
		}
		
		resultObjContainer.add(tmpObjContainer);
		mainForm.doLayout();
		
		var trapOid = Ext.getCmp('trapType_'+trapConId).getValue();
		var trapObjects = publicJSON[trapOid];
		
		if (trapObjects != null && trapObjects.length > 0)
		{
			Ext.getCmp('trapObjects'+currentID).show();
			Ext.getCmp('object'+currentID).getStore().loadRawData(trapObjects);
			Ext.getCmp('object'+currentID).setValue(trapObjects[0].valueField);
		}
		
		var resultObjContainer = Ext.getCmp('resultObjContainer'+conId+'_1');
		var resultObjContItemsLen = resultObjContainer.items.length;
		
		for (var z=0; z<resultObjContItemsLen; z++)
		{
			var objConId = resultObjContainer.items.keys[z];
			var objConIdx = objConId.substring(objConId.indexOf('_')+1);
			if (resultObjContItemsLen == 1)
			{
				Ext.getCmp('orLabel'+objConIdx).hide();
			}
			else
			{
				if (z == resultObjContItemsLen-2)
				{
					Ext.getCmp('orLabel'+objConIdx).show();
				}
				if (z == resultObjContItemsLen-1)
				{
					Ext.getCmp('orLabel'+objConIdx).hide();
				}
			}
		}
		
		objInputsCount++;
		return currentID;
	},

	removeCustomMainContainer: function(containerID)
	{
		var mainForm = Ext.getCmp('ConfigureTrapsPriority');
		var resultContainer = Ext.getCmp('resultContainer');
		resultContainer.remove(containerID);
		
		var mainObj = Ext.getCmp('mainconatiner_1');
		if (Ext.isEmpty(mainObj))
		{
			var resultContItemsLen = resultContainer.items.length;
			if (resultContItemsLen == 0)
			{
				Ext.getCmp('NoDataPattern1').show();
				Ext.getCmp('updateBtn').disable();
				Ext.getCmp('clearBtn').disable();
			}
		}
	},
	
	removeCustomTrapObjContainer: function(containerID, removeConID)
	{
		var resultObjFieldset = Ext.getCmp('resultObjFieldset'+containerID+'_1');
		resultObjFieldset.remove(removeConID);
		var resultObjFieldSetItemsLen = resultObjFieldset.items.length;
		
		for (var z=0; z<resultObjFieldSetItemsLen; z++)
		{
			var objConId = resultObjFieldset.items.keys[z];
			var objConIdx = objConId.substring(objConId.indexOf('_')+1);
			if (resultObjFieldSetItemsLen == 1)
			{
				Ext.getCmp('orLabel'+objConIdx).hide();
			}
			else
			{
				if (z == resultObjFieldSetItemsLen-2)
				{
					Ext.getCmp('orLabel'+objConIdx).show();
				}
				if (z == resultObjFieldSetItemsLen-1)
				{
					Ext.getCmp('orLabel'+objConIdx).hide();
				}
			}
		}
		
		if (resultObjFieldSetItemsLen == 0)
		{
			Ext.getCmp('trapType_'+containerID).enable();
			Ext.getCmp('addTrapType_'+containerID).show();
			Ext.getCmp('priorityStatus'+containerID).show();
		}
	},

	removeCustomObjContainer: function(containerID, currentObjID, removeConID)
	{
		var resultObjContainer = Ext.getCmp('resultObjContainer'+containerID+'_'+currentObjID+'_1');
		resultObjContainer.remove(removeConID);
		var resultObjContItemsLen = resultObjContainer.items.length;
		for (var z=0; z<resultObjContItemsLen; z++)
		{
			var objConId = resultObjContainer.items.keys[z];
			var objConIdx = objConId.substring(objConId.indexOf('_')+1);
			if (resultObjContItemsLen == 1)
			{
				Ext.getCmp('orLabel'+objConIdx).hide();
			}
			else
			{
				if (z == resultObjContItemsLen-2)
				{
					Ext.getCmp('orLabel'+objConIdx).show();
				}
				if (z == resultObjContItemsLen-1)
				{
					Ext.getCmp('orLabel'+objConIdx).hide();
				}
			}
		}
		
		if (resultObjContItemsLen == 0)
		{
			appCnt.removeCustomTrapObjContainer(containerID, 'mainobjectContfieldset_'+containerID+'_'+currentObjID);
		}
	},

	clearTrapContainer1: function()
	{
		var resultContainer = Ext.getCmp('resultContainer');
		resultContainer.removeAll();
		trapInputsCount = 1;
		
		Ext.getCmp('NoDataPattern1').hide();
		Ext.getCmp('updateBtn').hide();
		Ext.getCmp('clearBtn').hide();
		Ext.getCmp('deleteBtn').hide();
	},
	
	showFileUploadWindow: function()
	{
		var url = 'SnmpUploadMIB/data/EgFileUploadMib.jsp?page=EgUploadMIB';
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJsonData = jsonData;
					Ext.widget('window', {
						title: mainTitle,
						width: 350,
						id: 'file',
						padding:'5 10 10 10',
						name: 'file',
						resizable: 'false',
						items: [{
							xtype: 'form',
							id: 'uploadform',
							name: 'uploadform',
							url: '../servlet/com.eg.EgUploadServlet',
							items: [{
								xtype: 'fileuploadfield',
								ui: 'aButtonSmall',
								id: 'file1',
								name: 'file1',
								labelSeparator: '',
								emptyText: emptyMsg,
								fieldLabel: 'MIB file to upload',
								labelAlign: 'top',
								width: 290,
								buttonText: 'Browse',
								margin: '15 0 15 15',
							}],
							dockedItems:[{
								xtype:'toolbar',
								dock:'bottom',
								ui:'toolbarBgWithTopBorder',
								layout:{
									type:'hbox',
									pack:'center',
								},
								padding:10,
								items:[
									{
										xtype: 'button',
										text: label5,
										id: 'upload',
										name: 'upload',
										action: 'upload',
										ui:'aButtonSmall',
										align: 'center',
										handler: function (button, e)
										{
											var form = Ext.getCmp('uploadform').getForm().findField('file1').getValue();
											var fileExtMib = ".mib";
											var fileExtTxt = ".txt";
											var fileExtMy = ".my";
											var upload_MIB = publicJsonData['uploadMIB'];
											var isUpload = false;
											
											var isFileExt = true;
											if ((form.toLowerCase().indexOf(fileExtMib) == -1) &&
												(form.toLowerCase().indexOf(fileExtTxt) == -1) &&
												(form.toLowerCase().indexOf(fileExtMy) == -1))
											{
												isFileExt = false;
											}

											if (!isFileExt)
											{
												Ext.Msg.show({
													title: mainTitle,
													msg: fileexten,
													width: fileexten.length * 7,
													buttons: Ext.Msg.OK,
													icon: 'gen-warning size32 color-warning'
												});
												return false;
											}

											if (form.length > 0)
											{
												isUpload = true;
											}
											
											if (isUpload)
											{
												if(upload_MIB == "true")
												{
													filename="";
													if(form.indexOf("\\")> -1)
														filename = form.substring(form.lastIndexOf("\\")+1,form.length);
													else if(form.indexOf("/")> -1)
														filename = form.substring(form.lastIndexOf("/")+1,form.length);
													else
														filename = form;

													var exten_str="";
													var exten_idx = filename.lastIndexOf(".");
													if(exten_idx > 0)
														exten_str = filename.substring(exten_idx);
													exten_str = exten_str.toLowerCase();
													if(exten_str != ".txt" && 
														exten_str != ".mib" && 
														exten_str != ".my")
													{
														Ext.Msg.show({
															title: mainTitle,
															msg: fileexten,
															width: fileexten.length * 7,
															buttons: Ext.Msg.OK,
															icon: 'gen-warning size32 color-warning'
														});
															return false;
													}
													
													var existingFileNames=publicJsonData['ExistingFiles'];
													var uploadformObj = Ext.getCmp('uploadform').getForm();
													if (uploadformObj.isValid())
													{
														uploadformObj.submit({
															method: 'POST',
															success: function (form, action) {
																var jsonText = action.response.responseText;
																publicJson = Ext.decode(jsonText);
																if (!Ext.isEmpty(publicJson.uploadStatus) && publicJson.uploadStatus == 'true')
																{
																	Ext.Msg.show({
																		title: mainTitle,
																		msg: alert2,
																		width: 350,
																		buttons: Ext.Msg.OK,
																		icon: 'gen-info size32 color-info'
																	});
																	button.up('.window').close();
																}
																else
																{
																	Ext.Msg.show({
																		title: mainTitle,
																		msg: publicJson.statusMsg,
																		buttons: Ext.Msg.OK,
																		icon: 'gen-warning size32 color-warning'
																	});
																}
															},
															failure: function (form, action) {
																Ext.Msg.show({
																	title: mainTitle,
																	width: 350,
																	msg: action.errorMessage,
																	buttons: Ext.Msg.OK,
																	icon: 'gen-warning size32 color-warning'
																});
															}
														});
													}
												}
												else
												{
													var uploadform = Ext.getCmp('uploadform').getForm();
													if (uploadform.isValid())
													{
														uploadform.submit({
															success: function (form, action) 
															{
																var jsonText = action.response.responseText;
																var tmpResult = Ext.decode(jsonText);

																if (!Ext.isEmpty(tmpResult.uploadStatus) && tmpResult.uploadStatus == 'true')
																{
																	button.up('.window').close();

																	Ext.Msg.show({
																		title: mainTitle,
																		msg: alert2,
																		width: 350,
																		buttons: Ext.Msg.OK,
																		icon: 'gen-info size32 color-info'
																	});
																}
																else
																{
																	Ext.Msg.show({
																		title: mainTitle,
																		msg: tmpResult.statusMsg,
																		buttons: Ext.Msg.OK,
																		icon: 'gen-warning size32 color-warning'
																	});
																}
															},
															failure: function (form, action) 
															{
																Ext.Msg.show({
																	title: mainTitle,
																	msg: action.errorMessage,
																	buttons: Ext.Msg.OK,
																	icon: 'gen-warning size32 color-warning'
																});
															}
														});
													}
												}
											}
											else
											{
												Ext.Msg.show({
													title: mainTitle,
													msg: nofileselect,
													buttons: Ext.Msg.OK,
													icon: 'gen-warning size32 color-warning'
												});
												return false;
											}
										}
									}
								]
							}],
							listeners: {
                                afterrender: function () {
                                    appCnt.windowupload();
                                },
                            }
						}]
					}).show()
				}
			}
		});
	},
	
	windowupload: function () {
		var me = Ext.getCmp('uploadform');
		var a = me.getForm();
		var hiddenParams = publicJsonData.hiddenParams;
		for (var hiddenParam in hiddenParams) {
			if (!a.findField("'" + hiddenParam + "'")) {
				me.add({
					xtype: 'hidden',
					name: hiddenParam,
					value: hiddenParams[hiddenParam]
				});
			} else {
				a.findField("'" + hiddenParam + "'")
					.setValue(hiddenParams[hiddenParam]);
			}
		}
	},
	
	searchMIB : function()
	{
		var gridObj = Ext.getCmp('userMibFilesId');
		var gridsearch = Ext.getCmp('searchMIB').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		if (gridsearch == "" || gridsearch.length == 0)
		{
			gridObj.store.clearFilter();
		}
		else
		{
			gridObj.store.clearFilter();
			var filterLogic = new Ext.util.Filter({
				filterFn: function(item) {
					var dispName = item.get('displayField');
					if (dispName.toLowerCase().indexOf(gridsearch.toLowerCase()) != -1)
					{
						return true
					}
				}
			});
			gridObj.store.filter(filterLogic);
		}

		if (Ext.isEmpty(gridObj.getStore().data.items))
		{
			Ext.getCmp('emptyMIBMsg').update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+searchEmptyMsg+'.</div></div>');
			Ext.getCmp('emptyMIBMsg').show();
			Ext.getCmp('trapDescId').hide();
			Ext.getCmp('userMibFilesId').hide();
		}
		else
		{
			Ext.getCmp('emptyMIBMsg').hide();
			Ext.getCmp('trapDescId').show();
			Ext.getCmp('userMibFilesId').show();
		}
	},
});

function checkSpecial(obj_val,s_spl)
{
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}

function onFieldFocus (view) 
{
	var text = view.fieldHelp;
	if (typeof text !== "undefined") 
	{
		var tip = Ext.create('Ext.tip.ToolTip', {
			id: 'fieldtoolTip',
			ui: 'infobox',
			iconCls: 'iconSimulatorInfo',
			title: 'Help',
			target: view.el,
			trackMouse: false,
			anchor: 'bottom',
			constrainPosition :false,
			autoShow: true,
			html: text,
			renderTo: Ext.getBody()
		});
	}
}

function onFieldBlur (el) 
{
	var fieldtoolTip = Ext.getCmp('fieldtoolTip');
	if (fieldtoolTip.isVisible()) 
	{
		fieldtoolTip.destroy();
	}
}



