/*
 * Decompiled with CFR 0.152.
 */
package com.eg.cli;

import com.eg.cli.CLIConfigInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CLIValidator {
    private String action = "";
    private String rootNode = "";
    private String invalidKey = "";
    private String invalidBooleanVal = "";
    private ArrayList argsList = null;
    private ArrayList argsKeyList = new ArrayList();
    private ArrayList xmlFileArgList = new ArrayList();
    private ArrayList booleanArgList = new ArrayList();
    private ArrayList classWithLessArg = new ArrayList();
    private ArrayList noArgsValidationCmds = new ArrayList();
    private HashMap commandsMap = new HashMap();
    DocumentBuilderFactory dbf = null;
    DocumentBuilder db = null;
    Document doc = null;
    private Element rootElement;
    private StringTokenizer st = null;

    public CLIValidator() {
        this.initXMLParser();
        this.populateCommandsMap();
        this.classWithLessArg.add("AddAccount");
        this.classWithLessArg.add("ShowAccounts");
        this.classWithLessArg.add("ModifyAccount");
        this.classWithLessArg.add("DeleteAccount");
        this.classWithLessArg.add("ShowRemoteAgents");
        this.classWithLessArg.add("ShowExternalAgents");
        this.classWithLessArg.add("ShowMaintenancePolicyNames");
        this.classWithLessArg.add("ShowMaintenancePolicyDetails");
        this.classWithLessArg.add("ShowTestsDetails");
        this.noArgsValidationCmds.add("SpecificTestConfiguration");
    }

    public ArrayList getClassWithLessArg() {
        return this.classWithLessArg;
    }

    public ArrayList getNoArgsValidationList() {
        return this.noArgsValidationCmds;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public void setArgs(String[] stringArray) {
        this.argsList = new ArrayList<String>(Arrays.asList(stringArray));
    }

    public String getInvalidKey() {
        return this.invalidKey;
    }

    public String getInvalidBooleanVal() {
        return this.invalidBooleanVal;
    }

    public boolean isValidCLIArgs(String[] stringArray) {
        this.setArgs(stringArray);
        this.setArgsKey();
        this.setAction(stringArray[0]);
        this.setXmlFileArgs();
        if (this.argsKeyList != null && this.xmlFileArgList != null) {
            int n;
            for (n = 0; n < this.argsKeyList.size(); ++n) {
                if (this.xmlFileArgList.contains(this.argsKeyList.get(n))) continue;
                this.invalidKey = this.argsKeyList.get(n).toString();
                this.invalidBooleanVal = "";
                return false;
            }
            n = this.isBooleanVal(this.argsKeyList) ? 1 : 0;
            if (n == 0) {
                return false;
            }
        }
        return true;
    }

    private void setArgsKey() {
        String string = "";
        String string2 = "";
        if (this.argsList != null && this.argsList.size() > 0) {
            for (int i = 1; i < this.argsList.size(); ++i) {
                string = (String)this.argsList.get(i);
                if (!string.startsWith("-")) continue;
                this.st = new StringTokenizer(string, "-");
                if (!this.st.hasMoreTokens()) continue;
                this.argsKeyList.add(this.st.nextToken().trim().toLowerCase());
            }
        }
    }

    private void initXMLParser() {
        try {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.db = this.dbf.newDocumentBuilder();
            this.doc = this.db.parse(CLIConfigInfo.CLI_Install_Dir + CLIConfigInfo.separator + "lib" + CLIConfigInfo.separator + "validator.xml");
            this.rootElement = this.doc.getDocumentElement();
        }
        catch (Exception exception) {
            System.out.println("Problem while initializing xml parser object for validator.xml");
        }
    }

    private void populateCommandsMap() {
        this.commandsMap.put("addaccount", "AddAccount");
        this.commandsMap.put("help", "Help");
        NodeList nodeList = this.rootElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (string.equalsIgnoreCase("#text")) continue;
            this.commandsMap.put(string.toLowerCase(), string);
        }
    }

    public String getRealCommand(String string) {
        String string2 = (String)this.commandsMap.get(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private void setXmlFileArgs() {
        try {
            String string = "";
            NodeList nodeList = this.rootElement.getElementsByTagName(this.action);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                NodeList nodeList2 = element.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    String string2 = nodeList2.item(j).getNodeName();
                    if (string2.equalsIgnoreCase("#text")) continue;
                    NodeList nodeList3 = element.getElementsByTagName(string2);
                    NodeList nodeList4 = nodeList3.item(0).getChildNodes();
                    String string3 = nodeList4.item(0).getNodeValue();
                    if (string2.equalsIgnoreCase("params")) {
                        this.st = new StringTokenizer(string3.trim(), ",");
                        while (this.st.hasMoreTokens()) {
                            this.xmlFileArgList.add(this.st.nextToken().trim().toLowerCase());
                        }
                    }
                    if (!string2.equalsIgnoreCase("boolean")) continue;
                    this.st = new StringTokenizer(string3.trim(), ",");
                    while (this.st.hasMoreTokens()) {
                        this.booleanArgList.add(this.st.nextToken().trim().toLowerCase());
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Problem while parsing validator.xml");
        }
    }

    private boolean isBooleanVal(ArrayList arrayList) {
        String string = "";
        if (this.booleanArgList != null && this.booleanArgList.size() > 0) {
            for (int i = 0; i < this.booleanArgList.size(); ++i) {
                if (!arrayList.contains(this.booleanArgList.get(i))) continue;
                this.invalidBooleanVal = "";
                this.invalidKey = this.booleanArgList.get(i).toString();
                int n = this.argsList.indexOf("-" + this.booleanArgList.get(i));
                if (this.argsList.size() <= n + 1) {
                    return false;
                }
                string = (String)this.argsList.get(n + 1);
                if (string.trim().length() <= 0) {
                    return true;
                }
                if (string.trim().length() >= 1 && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("no"))) continue;
                this.invalidBooleanVal = string;
                return false;
            }
        }
        return true;
    }

    public boolean isCommandAvailable(String[] stringArray) {
        Object object;
        boolean bl = false;
        String string = "";
        String string2 = CLIConfigInfo.CLI_Install_Dir + CLIConfigInfo.separator + "lib" + CLIConfigInfo.separator + "help.xml";
        Document document = null;
        Element element = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(string2);
        }
        catch (Exception exception) {
            System.out.println("Problem while parsing help.xml");
        }
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("Help")) {
            string = "commands";
        } else if (stringArray.length == 1 && !stringArray[0].equalsIgnoreCase("Help")) {
            string = stringArray[0];
        } else if (stringArray.length == 2 && stringArray[0].equalsIgnoreCase("Help")) {
            string = stringArray[1];
        } else if (stringArray.length > 1 && !stringArray[0].equalsIgnoreCase("Help")) {
            string = stringArray[0];
        }
        element = document.getDocumentElement();
        object = element.getElementsByTagName(string);
        if (object != null) {
            String string3 = "";
            bl = object.getLength() > 0;
        } else {
            bl = false;
        }
        return bl;
    }

    public void showInCSVFormat(ArrayList arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            String string = (String)arrayList.get(0);
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            arrayList2.addAll(this.egTokenizer(string, "~Hash~"));
            String string2 = "";
            for (int i = 0; i < arrayList2.size(); ++i) {
                string2 = string2 + (String)arrayList2.get(i) + ",";
            }
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            System.out.println(string2);
            String string3 = "";
            for (int i = 1; i < arrayList.size(); ++i) {
                string2 = "";
                String string4 = (String)arrayList.get(i);
                arrayList3.addAll(this.egTokenizer(string4, "~Hash~"));
                for (int j = 0; j < arrayList3.size(); ++j) {
                    string3 = (String)arrayList3.get(j);
                    int n = string3.indexOf(",");
                    if (n != -1) {
                        string3 = "\"" + string3 + "\"";
                    }
                    if (string3.equals("newLine") || string3.equals("newLine_CSV") || string3.equals("dash")) {
                        string3 = " ";
                    }
                    string2 = string2 + string3 + ",";
                }
                if (string2.endsWith(",")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                System.out.println(string2);
                arrayList3.clear();
            }
        }
    }

    public void showInTabularFormat(ArrayList arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            Integer[] integerArray;
            Object object;
            int n;
            Object var2_2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList arrayList2 = new ArrayList();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList arrayList4 = new ArrayList();
            String string = (String)arrayList.get(0);
            arrayList2.addAll(this.egTokenizer(string, "~Hash~"));
            if (string.indexOf("Component name : ") > -1) {
                arrayList3 = arrayList2;
            } else {
                for (n = 0; n < arrayList2.size(); ++n) {
                    String string2 = (String)arrayList2.get(n);
                    arrayList3.add(string2);
                    if (string2 != null && !string2.trim().equals("")) continue;
                    arrayList3.remove(n);
                }
            }
            n = arrayList3.size();
            for (int i = 1; i < arrayList.size(); ++i) {
                object = (String)arrayList.get(i);
                arrayList4.addAll(this.egTokenizer((String)object, "~Hash~"));
            }
            ArrayList<String> arrayList5 = new ArrayList<String>();
            object = new ArrayList();
            ArrayList arrayList6 = new ArrayList();
            for (int i = 0; i < arrayList3.size(); ++i) {
                String string3 = (String)arrayList3.get(i);
                for (int j = i; j < arrayList4.size(); j += n) {
                    arrayList6.add(arrayList4.get(j));
                }
                String string4 = this.getAlignmentMetricsForTableFormat(string3, arrayList6);
                if (string4.indexOf("$") != -1) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, "$");
                    if (stringTokenizer.countTokens() == 2) {
                        arrayList5.add(stringTokenizer.nextToken());
                        ((ArrayList)object).add(Integer.valueOf(stringTokenizer.nextToken()));
                    } else if (stringTokenizer.countTokens() == 1) {
                        arrayList5.add("");
                        ((ArrayList)object).add(Integer.valueOf(stringTokenizer.nextToken()));
                    }
                }
                arrayList6.clear();
            }
            String string5 = "";
            if (string.indexOf("Policy Name   :") > -1 || string.indexOf("Component name : ") > -1) {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    stringBuffer.append(arrayList3.get(i));
                    stringBuffer.append(arrayList5.get(i));
                    stringBuffer.append(" ");
                }
                integerArray = stringBuffer.toString();
                System.out.println();
                System.out.println((String)integerArray);
                stringBuffer.delete(0, stringBuffer.length());
            } else {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    stringBuffer.append(arrayList3.get(i));
                    stringBuffer.append(arrayList5.get(i));
                    stringBuffer.append(" ");
                }
                integerArray = stringBuffer.toString();
                System.out.println();
                System.out.println((String)integerArray);
                int n2 = integerArray.length();
                stringBuffer.delete(0, stringBuffer.length());
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append("-");
                    string5 = string5 + "-";
                }
                System.out.println(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
            }
            integerArray = ((ArrayList)object).toArray(new Integer[0]);
            int n3 = 0;
            while (n3 < arrayList4.size()) {
                int n4 = 0;
                while (n4 != n) {
                    String string6 = (String)arrayList4.get(n3);
                    if (string.indexOf("Policy Name   :") > -1 && (string6 == null || string6.trim().length() < 1)) {
                        string6 = " ";
                    } else if (string.indexOf("Component name : ") > -1 && (string6 == null || string6.trim().length() < 1)) {
                        string6 = " ";
                    } else if (string6 == null || string6.trim().length() < 1) {
                        string6 = "-";
                    }
                    if (string6.equals("newLine")) {
                        string6 = "\n";
                    }
                    if (string6.equals("dash")) {
                        string6 = string5;
                    }
                    if (string6.equals("newLine_CSV")) {
                        ++n4;
                        ++n3;
                        break;
                    }
                    stringBuffer.append(string6);
                    int n5 = integerArray[n4];
                    int n6 = n5 - string6.length();
                    for (int i = 0; i < n6; ++i) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(" ");
                    ++n4;
                    ++n3;
                }
                if (stringBuffer.length() == 0) continue;
                System.out.println(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
            }
        }
    }

    private String getAlignmentMetricsForTableFormat(String string, ArrayList arrayList) {
        int n = string.length();
        if (arrayList.size() != 0) {
            try {
                int n2;
                int n3;
                String string2 = (String)arrayList.get(0);
                int n4 = n3 = string2.trim().length();
                for (n2 = 1; n2 < arrayList.size(); ++n2) {
                    String string3 = (String)arrayList.get(n2);
                    int n5 = string3.trim().length();
                    if (n5 <= n4) continue;
                    n4 = n5;
                }
                n2 = n4;
                int n6 = n2 > n ? n2 : n;
                String string4 = "";
                if (n6 != n) {
                    int n7 = n6 - n;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n7; ++i) {
                        stringBuffer.append(" ");
                    }
                    string4 = stringBuffer.toString();
                }
                return string4 + "$" + n6;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "$" + n;
    }

    public ArrayList egTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = string2.length();
        int n2 = 0;
        int n3 = string.indexOf(string2);
        while (n3 >= 0) {
            string3 = string.substring(n2, n3);
            arrayList.add(string3);
            n2 = n3 + n;
            n3 = string.indexOf(string2, n2);
        }
        string3 = string.substring(n2);
        arrayList.add(string3);
        return arrayList;
    }

    public static void main(String[] stringArray) {
    }
}

