/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgDbInfo;
import com.eg.EgDbaseInfo;
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class EgTableCreation
extends EgConfigInfo {
    static String entity = "setup_manager";
    String domain = null;
    private EgConfigInfo configInfo = new EgConfigInfo("manager");
    public File file;
    public Connection conn = null;
    public Statement stmt = null;
    public String host;
    public String sid;
    public String port;
    public String url;
    public String user;
    public String password;
    public String pathDir;
    public String ntlmV2;
    public String errorMsg = " ";
    public static IniFile iniFile;
    public static IniFile iniDBFile;
    public String dbDriver;
    public String dbUrl;
    private static boolean isOraAdapter;

    public static void main(String[] stringArray) {
        block8: {
            PrintStream printStream = null;
            try {
                String string;
                System.setProperty("jsse.enableCBCProtection", "false");
                printStream = new PrintStream(new FileOutputStream(egMgrErrorFile, true));
                PrintStream printStream2 = System.out;
                System.setOut(printStream);
                System.setErr(printStream);
                System.out.println("==============EgTableCreation starts==============");
                if (stringArray.length != 14) {
                    System.out.println("Please pass 14 arguments to execute ...! ");
                    return;
                }
                if (!(stringArray[0].equals("-host") && stringArray[2].equals("-port") && stringArray[4].equals("-sid") && stringArray[6].equals("-user") && stringArray[8].equals("-password") && stringArray[10].equals("-dir") && stringArray[12].equals("-ntlmv2"))) {
                    System.out.println("Usage java EgTableCreation -host <hostname>  -port <portNo> -sid<Database Instance Name> -user <DbUser>  -password <UserPasswd> -dir <source dir of SQL Files> -ntlmv2 <true / false> ");
                    return;
                }
                System.out.println("To create tables " + new Date());
                EgTableCreation egTableCreation = new EgTableCreation(stringArray);
                String string2 = egTableCreation.createTables();
                System.out.println("After create tables! " + new Date());
                iniFile.setValue("CHECK TABLE CREATE", "Creation", string2);
                iniFile.saveFile();
                System.out.println("After save file " + new Date());
                if (printStream != null) {
                    System.out.println("==============EgTableCreation ends==============");
                    printStream.close();
                }
                if ((string = System.getProperty("os.name")) != null && string.toLowerCase().indexOf("win") < 0) {
                    System.setOut(printStream2);
                    if (string2.equalsIgnoreCase("0")) {
                        System.out.println("TRUE");
                    } else {
                        System.out.println(egTableCreation.errorMsg);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (printStream == null) break block8;
                System.out.println("==============EgTableCreation ends==============");
                printStream.close();
            }
        }
    }

    public void createSetupFile() {
        iniFile = new IniFile(this.configInfo.getSetupFile(), true);
        iniDBFile = new IniFile(this.configInfo.getDbFile(), true);
    }

    public EgTableCreation(String[] stringArray) {
        this.host = stringArray[1];
        this.port = stringArray[3];
        this.sid = stringArray[5];
        this.user = stringArray[7];
        int n = this.user.indexOf("\\");
        if (n < 0) {
            n = this.user.indexOf("/");
        }
        if (n > 0) {
            this.domain = this.user.substring(0, n);
            this.user = this.user.substring(n + 1);
        }
        this.password = stringArray[9];
        this.pathDir = stringArray[11];
        this.ntlmV2 = stringArray[13];
        this.file = new File(this.pathDir);
        if (!EgDbInfo.initialized) {
            EgDbInfo egDbInfo = new EgDbInfo("manager");
            egDbInfo = null;
        }
        this.createSetupFile();
    }

    public String createTables() {
        System.out.println("EgTableCreation connect() ");
        if (!this.connect()) {
            return "1";
        }
        try {
            this.stmt = this.conn.createStatement();
            File[] fileArray = this.file.listFiles();
            if (fileArray.length == 0) {
                this.logToErrorFile(entity, this.pathDir + " doesn't have any .sql files");
                this.errorMsg = this.pathDir + "doesn't have any .sql files";
                System.out.println("EgTableCreation closeConnect() ");
                this.closeConnection();
                return "2";
            }
            for (int i = 0; i < fileArray.length; ++i) {
                Vector vector;
                String string = fileArray[i].getPath();
                if (string.endsWith("total.sql") && (vector = EgTableCreation.getDrop(string)) != null && vector.size() > 0) {
                    try {
                        for (int j = 0; j < vector.size(); ++j) {
                            String string2 = (String)vector.get(j);
                            string2 = string2.trim();
                            if (EgDbInfo.doubleByteEnabled) {
                                string2 = EgDbInfo.checkForVarChar(string2);
                            }
                            try {
                                this.stmt.execute(string2);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!string.endsWith(".sql")) continue;
                vector = this.getData(string);
                if (vector == null) {
                    this.logToErrorFile(entity, this.pathDir + string + " doesn't exist ..");
                    this.errorMsg = this.errorMsg + string + " doesn't exist ..";
                    return "3";
                }
                int n = vector.size();
                for (int j = 0; j < n; ++j) {
                    Object object;
                    String string3;
                    String string4 = (String)vector.get(j);
                    if (EgDbInfo.doubleByteEnabled) {
                        string4 = EgDbInfo.checkForVarChar(string4);
                        if (isOraAdapter) {
                            string4 = EgTableCreation.replace(string4, "(2048)", "(1024)");
                            string4 = EgTableCreation.replace(string4, "(4000)", "(2000)");
                        }
                    }
                    try {
                        boolean bl = this.stmt.execute(string4);
                        if (!bl || isOraAdapter) continue;
                        string3 = string4;
                        if ((string3 = string3.toUpperCase()) == null || string3.indexOf("ALTER TABLE MEASURE_LAST") <= -1) continue;
                        object = null;
                        ResultSet resultSet = this.stmt.executeQuery("select @@version");
                        if (resultSet != null && resultSet.next()) {
                            object = resultSet.getString(1);
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        String string5 = null;
                        if (object != null && ((String)object).startsWith("Microsoft SQL Server  2000")) {
                            string5 = " SP_INDEXOPTION 'measure_last.pk_measure_last', 'DISALLOWPAGELOCKS', TRUE ";
                            this.stmt.execute(string5);
                            string5 = " SP_INDEXOPTION 'measure_last.pk_measure_last', 'ALLOWROWLOCKS', TRUE ";
                            this.stmt.execute(string5);
                            continue;
                        }
                        string5 = "ALTER INDEX PK_MEASURE_LAST ON MEASURE_LAST SET ( ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON)";
                        this.stmt.execute(string5);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        string4 = string4.trim();
                        if (string4.startsWith("DROP")) continue;
                        string3 = sQLException.getMessage();
                        if (string3.indexOf("ORA-01658") >= 0) {
                            this.errorMsg = "Error while creating tables. Table creation failed due to insufficient space! ";
                            return "4";
                        }
                        object = sQLException;
                        System.out.println("Error while creating tables!");
                        System.out.println(sQLException.toString());
                        System.out.println("Query was " + string4);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.errorMsg = "Error when building the query ...";
            return "5";
        }
        System.out.println("EgTableCreation closeConnection() " + new Date());
        this.closeConnection();
        return "0";
    }

    public void closeConnection() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            this.errorMsg = "Error when closing the database connection ...";
            return;
        }
    }

    public void getInfo() {
        try {
            this.dbDriver = iniDBFile.getValue("DB_PROPERTIES", "sql.driver");
            this.dbUrl = iniDBFile.getValue("DB_PROPERTIES", "sql.url");
            String string = iniDBFile.getValue("DB_PROPERTIES", "DB_Server_Type");
            if (!string.equals("EgMsSqlAdapter")) {
                isOraAdapter = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean connect() {
        try {
            this.getInfo();
            Class.forName(this.dbDriver).newInstance();
            if (this.password.equals("NULL") || this.password.equals("null") || this.password.equals("none") || this.password.equals("NONE")) {
                this.password = "";
            }
            System.out.println(this.dbUrl + " " + this.user + " ****");
            if (this.domain == null || this.domain.equals("none")) {
                this.conn = DriverManager.getConnection(this.dbUrl, this.user, this.password);
            } else {
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                if (this.ntlmV2 != null && this.ntlmV2.equals("true")) {
                    properties.put("useNTLMv2", this.ntlmV2);
                }
                this.conn = DriverManager.getConnection(this.dbUrl, properties);
            }
        }
        catch (Exception exception) {
            this.errorMsg = "Database connection failed ...";
            return false;
        }
        return true;
    }

    public Vector getData(String string) {
        int n;
        Object object;
        BufferedReader bufferedReader = null;
        Object var3_3 = null;
        boolean bl = true;
        String string2 = " Null";
        String string3 = "";
        boolean bl2 = false;
        Vector<Object> vector = new Vector<Object>();
        boolean bl3 = false;
        String[] stringArray = null;
        if (string.endsWith("total.sql")) {
            bl3 = true;
            object = new EgDbaseInfo("manager");
            stringArray = ((EgDbaseInfo)object).getDefaultTables();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i].toLowerCase();
                }
            }
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || (string3 = string3 + " " + string2).indexOf(";") == -1) continue;
                object = string3.replace(';', ' ');
                if (!bl3) {
                    vector.addElement(object);
                } else if (stringArray != null) {
                    String string4 = ((String)object).toLowerCase();
                    for (n = 0; n < stringArray.length; ++n) {
                        String string5;
                        int n2 = string4.indexOf("table");
                        if (n2 >= 0) {
                            string5 = string4.substring(n2 + 5);
                            if (!(string5 = string5.trim()).equals(stringArray[n]) && !string5.startsWith(stringArray[n] + " ") && !string5.startsWith(stringArray[n] + "_") && !string5.startsWith(stringArray[n] + "(")) continue;
                            vector.addElement(object);
                            continue;
                        }
                        if (string4.indexOf("sequence") != -1 && string4.indexOf(stringArray[n]) != -1) {
                            vector.addElement(object);
                            continue;
                        }
                        n2 = string4.indexOf(" on ");
                        if (n2 >= 0) {
                            string5 = string4.substring(n2 + 3);
                            if (string5.indexOf(" " + stringArray[n] + "_") < 0 && string5.indexOf(" " + stringArray[n] + " ") < 0 && string5.indexOf(" " + stringArray[n] + "(") < 0) continue;
                            vector.addElement(object);
                            continue;
                        }
                        n2 = string4.indexOf(" into ");
                        if (n2 < 0 || (string5 = string4.substring(n2 + 5)).indexOf(" " + stringArray[n] + " ") < 0 && string5.indexOf(" " + stringArray[n] + "(") < 0) continue;
                        vector.addElement(object);
                    }
                }
                string3 = "";
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new Vector();
        String string6 = "";
        for (n = 0; n < vector.size(); ++n) {
            string6 = (String)vector.elementAt(n);
            if (((Vector)object).contains(string6 = string6.trim())) continue;
            ((Vector)object).add(string6);
        }
        return object;
    }

    public static Vector getDrop(String string) {
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        String string2 = " Null";
        Vector<String> vector = new Vector<String>();
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        try {
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.toUpperCase().startsWith("DROP ")) {
                    if (string2.indexOf(";") != -1) {
                        string2 = string2.replace(';', ' ');
                    }
                    vector.add(string2.trim());
                }
                string2 = bufferedReader.readLine();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return vector;
    }

    private static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    static {
        isOraAdapter = false;
    }
}

