Ext.define('TemplateReportApp.view.UserLatencyByVendorResult',{
	extend:'Ext.container.Container',
	alias:'widget.userlatencybyvendorresult',
	layout:'column',
	columnWidth:1.0,
	id:'userlatencybyvendorresult_id',
	margin: '10 0 10 0',
	totalAjaxCount:7,
	currentAjaxCount:0,
	items:[],
	listeners:
	{
		afterrender:function(obj)
		{
			this.setData(this.data);
		}
	},
	setData:function(resultJson)
	{
		this.removeAll();
		var me = this;
		var mainDivWidth=document.getElementById("templatereportmain").offsetWidth;
		var thisWidth=mainDivWidth-52;
		var params = this.params;
		try
		{
			if(resultJson!=undefined&& resultJson.RESULTS!=undefined)
			{
				var datas = resultJson.RESULTS;
				var summaryDataList = datas.summaryDataList;
				var summaryGridCol = datas.summaryGridCol;
				var summaryDataVendorList = datas.summaryDataVendorList;
				var summaryVendorCol = datas.summaryVendorCol;
				var gridData = datas.gridData;
				var gridColumn = datas.gridColumn;
				var summaryDataMap = datas.summaryDataMap;
				var summaryDataMapCount = datas.summaryDataMapCount;
				var summaryDataAry = new Array();
				if(summaryDataMap!=undefined)
				{
					var colWidth = 1/summaryDataMapCount;
					if(colWidth<0.2)
					{
						colWidth = 0.2;
					}
					for(var key in summaryDataMap)
					{
						var summaryVal = summaryDataMap[key];
						var html = '<table width="100%" align="center"><tbody>';
						html+='<tr><td align="center" style="padding:5px"><span class="newFont_bold28">'+summaryVal+'</span></td></tr>';
						html+='<tr><td align="center" colspan="2" style="padding:10px 0px 5px 0px"><span class="newFont_normal13">'+key+'</span></td></tr>';
						html+='</tbody></table>';
						summaryDataAry.push(
						{
							xtype:'container',
							bodyPadding:'0 10 10 10',
							columnWidth:colWidth,
							layout:'fit',
							html:html
						});
					}
					this.add(
					{
						xtype:'panel',
						ui:'newGraphPanel',
						title:'Summary',
						columnWidth:1,
						layout:'column',
						items:summaryDataAry
					});
				}
				if(summaryVendorCol!=undefined)
				{
					var mainColArray=new Array();
					var fieldsToStore=new Array();
					var keyCount = 0;
					for (var key in summaryVendorCol)
					{
						var align = 'center';
						
						if(key=='vendor_Name' || key=='Connection_strength')
						{
							align = 'left';
						}
						fieldsToStore.push(keyCount+'');
						mainColArray.push({
							header: summaryVendorCol[key],
							sortable: true,
							resizable :true,
							align:align,
							dataIndex: keyCount+'',
							renderer :function(value, metaData, record, row, col, store, gridView)
							{
								if(value!=undefined && value.indexOf("~")>-1)
								{
									var colors = value.substring(value.indexOf("~")+1);
									value = value.substring(0,value.indexOf("~"));
									metaData.tdAttr = 'data-qtip="' + value + '"';
									value = '<div  align="center" style="width:60%;border-radius: 2px;background-color: '+colors+';color: #fff;display: inline-block;z-index: 9;line-height: 140%;margin: 2px 0 0 0;">'+value+'</div>';
								}
								else
								{	
									metaData.tdAttr = 'data-qtip="' + value + '"';
								}
								return value;
							},
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
										{
											var tmp = v1.substring(0, v1.lastIndexOf(' '));

											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
										}
										if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
										{
											var tmp = v2.substring(0, v2.lastIndexOf(' '));
											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
										}
										if(!isNaN(v1) && !isNaN(v2))
										{
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
										v1= isNaN(v1) ? 0 : v1;

										v2= isNaN(v2) ? 0 : v2;
											}
										}
										else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
										{
											v2=new Date(v2).getTime(); 
											v1=new Date(v1).getTime(); 
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							},
						});
						keyCount++;
						if(key=='Latency_avg' || key=='ICA_nwlatency')
						{
							mainColArray[mainColArray.length-1].minWidth = 120;
							mainColArray[mainColArray.length-1].flex=1;
						}
						if(key=='Connection_strength')
						{
							mainColArray[mainColArray.length-1].minWidth = 220;
							mainColArray[mainColArray.length-1].flex=1.5;
						}
						if(key=='Last_recd_latency')
						{
							mainColArray[mainColArray.length-1].minWidth = 180;
							mainColArray[mainColArray.length-1].flex=1.2;
						}
						if(key=='country_Name' || key=='city_Name' || key=='USER')
						{
							mainColArray[mainColArray.length-1].maxWidth = 120;
						}
						if(key=='vendor_Name')
						{
							mainColArray[mainColArray.length-1].maxWidth = 150;
						}
						if(key=='Output_line_speed' || key=='Input_session_bandwidth' || key=='Output_session_bandwidth' || key=='Output_se_line_speed' || key=='Input_se_line_speed')
						{
							mainColArray[mainColArray.length-1].minWidth = 120;
							mainColArray[mainColArray.length-1].flex=1;
						}
					}
					var isPagingHidden=false;
					var gridPageSize=10;
					 if (summaryDataVendorList!=undefined && summaryDataVendorList.length<=gridPageSize)
						isPagingHidden=true;
					else
						isPagingHidden=false;
					
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'array', root : 'data', totalProperty : 'total'
							},
							data : summaryDataVendorList,
						},
						sorters: { property: fieldsToStore[4], direction : 'ASC' },
						//pageSize:gridPageSize,
						remoteSort:true,
						autoLoad : true,
					});
					isPagingHidden = true;
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						columnWidth:1.0,
						title:'Vendor Summary',
						margin:'10 0 0 0',
						items:[{
							xtype:'customgrid',
							store:storeObj,
							forceFit:true,
							columnWidth:1.0,
							margin:'0 10 10 10',
							sortableColumns:true,
							ui:'newGridPanel',
							border:true,
							id:'vendorgrid_id',
							columns:mainColArray,
							style:
							{
								'box-shadow':'none !important',
							},
							scroll:true,
							autoScroll:true,
							dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{
										if(!Ext.isEmpty(params))
											activePage = params.currentPage;
										else
											activePage=1;
									}
								}
							}],
							listeners:
							{
								render:function(obj)
								{
									Ext.defer(function() 
									{
										if(!Ext.isEmpty(obj.columns[1]))
										{
											obj.columns[4].doSort('DESC');
										}
									},100);
								}
							}
						}]
					});
				}
				if(summaryGridCol!=undefined)
				{
					var mainColArray=new Array();
					var fieldsToStore=new Array();
					var keyCount = 0;
					for (var key in summaryGridCol)
					{
						var align = 'center';
						
						if(key=='vendor_Name' || key=='country_Name' || key=='city_Name' || key=='Connection_strength')
						{
							align = 'left';
						}
						fieldsToStore.push(keyCount+'');
						mainColArray.push({
							header: summaryGridCol[key],
							sortable: true,
							resizable :true,
							align:align,
							dataIndex: keyCount+'',
							renderer :function(value, metaData, record, row, col, store, gridView)
							{
								if(value!=undefined && value.indexOf("~")>-1)
								{
									var colors = value.substring(value.indexOf("~")+1);
									value = value.substring(0,value.indexOf("~"));
									metaData.tdAttr = 'data-qtip="' + value + '"';
									value = '<div  align="center" style="width:60%;border-radius: 2px;background-color: '+colors+';color: #fff;display: inline-block;z-index: 9;line-height: 140%;margin: 2px 0 0 0;">'+value+'</div>';
								}
								else
								{	
									metaData.tdAttr = 'data-qtip="' + value + '"';
								}
								return value;
							},
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
										{
											var tmp = v1.substring(0, v1.lastIndexOf(' '));

											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
										}
										if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
										{
											var tmp = v2.substring(0, v2.lastIndexOf(' '));
											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
										}
										if(!isNaN(v1) && !isNaN(v2))
										{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;

												v2= isNaN(v2) ? 0 : v2;
											}
										}
										else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
										{
											v2=new Date(v2).getTime(); 
											v1=new Date(v1).getTime(); 
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							}
						});
						keyCount++;
						if(key=='Latency_avg')
						{
							mainColArray[mainColArray.length-1].minWidth = 150;
							mainColArray[mainColArray.length-1].flex=1;
						}
						if(key=='Connection_strength')
						{
							mainColArray[mainColArray.length-1].minWidth = 220;
							mainColArray[mainColArray.length-1].flex=1.5;
						}
						if(key=='Last_recd_latency')
						{
							mainColArray[mainColArray.length-1].minWidth = 210;
							mainColArray[mainColArray.length-1].flex=1.3;
						}
						if(key=='country_Name' || key=='city_Name' || key=='USER')
						{
							mainColArray[mainColArray.length-1].maxWidth = 120;
						}
						if(key=='vendor_Name')
						{
							mainColArray[mainColArray.length-1].minWidth = 150;
							mainColArray[mainColArray.length-1].flex=1;
						}
						if(key=='Output_line_speed' || key=='Input_session_bandwidth' || key=='Output_session_bandwidth' || key=='ICA_nwlatency' || key=='Output_se_line_speed' || key=='Input_se_line_speed')
						{
							mainColArray[mainColArray.length-1].minWidth = 180;
							mainColArray[mainColArray.length-1].flex=1.2;
						}
					}
					var isPagingHidden=false;
					var gridPageSize=10;
					 if (summaryDataList!=undefined && summaryDataList.length<=gridPageSize)
						isPagingHidden=true;
					else
						isPagingHidden=false;
					
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'array', root : 'data', totalProperty : 'total'
							},
							data : summaryDataList,
						},
						sorters: { property: fieldsToStore[4], direction : 'ASC' },
						//pageSize:gridPageSize,
						remoteSort:true,
						autoLoad : true,
					});
					isPagingHidden = true;
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						columnWidth:1.0,
						title:'Summary by Cities',
						margin:'10 0 0 0',
						items:[{
							xtype:'customgrid',
							store:storeObj,
							columnWidth:1.0,
							margin:'0 10 10 10',
							sortableColumns:true,
							ui:'newGridPanel',
							border:true,
							forceFit:false,
							needtoFixColumn:true,
							id:'citygrid_id',
							columns:mainColArray,
							style:
							{
								'box-shadow':'none !important',
							},
							scroll:true,
							autoScroll:true,
							dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{
										if(!Ext.isEmpty(params))
											activePage = params.currentPage;
										else
											activePage=1;
									}
								}
							}],
							listeners:
							{
								render:function(obj)
								{
									Ext.defer(function() 
									{
										if(!Ext.isEmpty(obj.columns[1]))
										{
											obj.columns[4].doSort('DESC');
										}
									},100);
								}
							}
						}]
					});
				}
				if(gridColumn!=undefined)
				{
					var mainColArray=new Array();
					var fieldsToStore=new Array();
					var count = 0;
					for (var key in gridColumn)
					{
						var align = 'left';
						var colName = gridColumn[key];
						if (colName instanceof Array)
						{
							var subColumnArray = new Array();
							for (var k in colName)
							{
								fieldsToStore.push(count+'');
								subColumnArray.push({
									header: colName[k],
									sortable: true,
									align:'center',
									dataIndex:count+'',
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										if(value!=undefined && value.indexOf("~")>-1)
										{
											var colors = value.substring(value.indexOf("~")+1);
											value = value.substring(0,value.indexOf("~"));
											metaData.tdAttr = 'data-qtip="' + value + '"';
											value = '<div  align="center" style="width:60%;border-radius: 2px;background-color: '+colors+';color: #fff;display: inline-block;z-index: 9;line-height: 140%;margin: 2px 0 0 0;">'+value+'</div>';
										}
										else
										{	
											metaData.tdAttr = 'data-qtip="' + value + '"';
										}
										return value;
									},
									doSort: function(state) 
									{
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2)
											{
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
														v1= isNaN(v1) ? 0 : v1;
														v2= isNaN(v2) ? 0 : v2;
													}
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									},
								});
								count++;
							}
							mainColArray.push({
								header: key,
								sortable: true,
								width:110,
								columns:subColumnArray
							});
						}
						else
						{
							fieldsToStore.push(count+'');
							mainColArray.push({
								header: colName,
								sortable: true,
								resizable :true,
								flex:1,
								align:align,
								dataIndex: count+'',
								minWidth:130,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
									return value;
								},
								doSort: function(state) 
								{
									var ds = this.up('grid').store;
									var field = this.getSortParam();
									ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2)
										{
											v1 = v1.get(field);
											v2 = v2.get(field);
											
											if(!isNaN(v1) && !isNaN(v2))
											{
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
												v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
												if (state=='ASC')
												{
													v1= isNaN(v1) ? 999999 : v1;
													v2= isNaN(v2) ? 999999 : v2;
												}
												else
												{
													v1= isNaN(v1) ? 0 : v1;
													v2= isNaN(v2) ? 0 : v2;
												}
											}
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
							});
							count++;
						}
					}
					var isPagingHidden=false;
					var gridPageSize=10;
					 if (gridData!=undefined && gridData.length<=gridPageSize)
						isPagingHidden=true;
					else
						isPagingHidden=false;
					
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'array', root : 'data', totalProperty : 'total'
							},
							data : gridData,
						},
						//sorters: { property: fieldsToStore[3], direction : 'ASC' },
						pageSize:gridPageSize,
						autoLoad : true,
						remoteSort:true,
					});
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'10 0 10 0',
						columnWidth:1.0,
						title:'User Details',
						items:[{
							xtype:'customgrid',
							store:storeObj,
							margin:'0 10 10 10',
							sortableColumns:true,
							ui:'newGridPanel',
							border:true,
							forceFit:false,
							needtoFixColumn:true,
							id:'useratency_id',
							columns:mainColArray,
							style:
							{
								'box-shadow':'none !important',
							},
							scroll:true,
							autoScroll:true,
							dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{
										if(!Ext.isEmpty(params))
											activePage = params.currentPage;
										else
											activePage=1;
									}
								}
							}],
							listeners:
							{
								render:function(obj)
								{
									Ext.defer(function() 
									{
										if(!Ext.isEmpty(obj.columns[1]))
										{
											obj.columns[9].items.items[0].doSort('DESC');
										}
									},100);
								}
							}
						}]
					});
				}
			}
			else
			{
				this.add(this.getNoMeasure(150,'iconInformation','No Measures Available'));
			}
		}
		catch(e)
		{
			console.log(e);
		}
	},
	getNoMeasure:function(height,icon,msg)
	{
		return {
			xtype:'container',
			columnWidth:1.0,
			margin:10,
			height:height,
			html:'<div class="egFlexCenterByColumnWise" style="height:100%"> <div class="'+icon+'"></div> <div class="commonErrorMsgText">'+msg+'!</div> </div>'
		}
	}
});


