Ext.define('TemplateReportApp.view.GroupLatencyResult',{
	extend:'Ext.container.Container',
	alias:'widget.grouplatencyresult',
	layout:'column',
	columnWidth:1.0,
	id:'grouplatencyresult_id',
	margin: '10 0 10 0',
	totalAjaxCount:7,
	currentAjaxCount:0,
	items:[],
	listeners:
	{
		afterrender:function(obj)
		{
			this.setData(this.data);
		}
	},
	setData:function(resultJson)
	{
		this.removeAll();
		var me = this;
		var mainDivWidth=document.getElementById("templatereportmain").offsetWidth;
		var thisWidth=mainDivWidth-52;
		var params = this.params;
		try
		{
			if(resultJson!=undefined&& resultJson.RESULTS!=undefined)
			{
				var datas = resultJson.RESULTS;
				var geoDataList = datas.geoDataList;
				var GEOgridColumn = datas.GEOgridColumn;
				var GEOgridTitle = datas.GEOgridTitle;
				var gridData = datas.gridData;
				var gridColumn = datas.gridColumn;
				var summaryDataMap = datas.summaryDataMap;
				var summaryDataMapCount = datas.summaryDataMapCount;
				var userExpMapByGroup = datas.userExpMapByGroup;
				var dayWiseLatency = datas.dayWiseLatency;
				var dayWiseUniqueUser = datas.dayWiseUniqueUser;
				var recomemdationColumn = datas.recomemdationColumn;
				var recomemdationData = datas.recomemdationData;
				var barChatLst = datas.barChatLst;
				var groupHtml = '';
				var groupHtmlHeader = '';
				var recomemtationStr = '';

				
				if(userExpMapByGroup!=undefined)
				{
					var DataSet= userExpMapByGroup.DataSet;
					var dataSetObj = DataSet[0];
					var dataAry = dataSetObj.data;
					groupHtmlHeader+='<div class="f14-bold" style="margin:20px 0px 0px 20px">User Experience</div>';
					for(var i=0;i<dataAry.length;i++)
					{
						var smileyCls;
						var smileyText;
						var smileyColor;
						var total;
						var valuezz;
						var percent;
						var dataObj = dataAry[i];

						var name = dataObj['name'];
						if(name!=undefined && userExpMapByGroup[name]!=undefined)
						{
							var values = userExpMapByGroup[name];
							smileyCls = values['smileyCls'];
							smileyText = values['smileyText'];
							smileyColor= values['smileyColor'];
							total = values['total'];
							percent = values['percent'];
						}

							/* smileyText = dataObj['name'];
						 smileyColor= dataObj['color'];
						 valuezz= dataObj['y'];

						if(smileyText == "Poor"){
							smileyCls = "gen-no"
						}else if(smileyText == "Acceptable"){
							smileyCls = "gen-yes"
						}else{
							smileyCls = "gen-great"
						}*/
						//groupHtml+='<tr><td><div style="background-color:'+dataObj.color+';width:6px;height:6px;border-radius:3px;">&nbsp;</div></td><td style="padding:5px;" class="font_normal10">'+dataObj.name+' ('+dataObj.y+')</td></tr>';

						groupHtml+='<div class="egFlexCenterByColumnWise borderRightForFlexBox" style="padding:0px 10px 0px 10px;margin:20px 0px 20px 0px;flex-grow:1"><div class="'+smileyCls+' size24" style="color:'+smileyColor+';margin:0px 5px 5px 5px"></div><div style="margin:0px;text-align:center" class="f11-normal">'+smileyText+'</div><div style="margin:5px" class="f28-normal">'+percent+'<span class="f18-normal">%</span></div><div class="f14-normal">'+total+'</div></div>';
					}
				}
				if(recomemdationColumn!=undefined)
				{
					recomemtationStr+='<div class="newTableWithoutBorder"><table width="100%" align="center"><thead><tr>';
					for(var col in recomemdationColumn)
					{
						if(col!=0)
						{
							recomemtationStr+='<th style="font-size:11px">'+recomemdationColumn[col]+'</th>'

						}
					}
					recomemtationStr+='</tr></theaad><tbody>';
					for(var col in recomemdationData)
					{
						var rec_data = recomemdationData[col];
						recomemtationStr+='<tr>';

						for(var ind in rec_data)
						{
							var indData = rec_data[ind];
							var colorLine;
							if((indData.indexOf("#")>-1) && (ind == 0))
							{
								colorLine = indData;
								recomemtationStr+='';
							}
							if(ind == 1){
								recomemtationStr+='<td ><div style="background-color:'+colorLine+';width:2px;height:14px;float:left;margin:3px 10px 0px 0px">&nbsp;</div><div style="float:left">'+indData+'</div></td>';
							}
							else if(ind!=0){
									recomemtationStr+='<td >'+indData+'</td>';
							}

						}
						recomemtationStr+='</tr>';
					}
					recomemtationStr+='</tbody></table></div>';
				}
				var summaryDataAry = new Array();
				var colWidth = 1/summaryDataMapCount;
				if(colWidth<0.2)
				{
					//colWidth = 0.2;
				}
				for(var key in summaryDataMap)
				{
					var summaryVal = summaryDataMap[key];
					var unit = '';
					if(key.indexOf('(')>-1)
					{
						unit = key.substring(key.indexOf('(')+1,key.indexOf(')'));
						key = key.substring(0,key.indexOf('('));
						unit = '<span class="newFont_normal13">'+unit+'</span>';
					}
					if(summaryVal.indexOf('#')>-1)
					{
						icon = summaryVal.substring(summaryVal.indexOf('#')+1);
						summaryVal = summaryVal.substring(0,summaryVal.indexOf('#'));
					}
					var html = '<table width="100%" align="center"><tbody>';
					html+='<tr><td align="center" style="padding:10px 5px 0px 5px"><img src="/final/images/spacer.gif" class="'+icon+'"></td></tr>';
					html+='<tr><td align="center" style="padding:5px 5px 0px 5px"><span class="f36-light">'+summaryVal+'</span></td></tr>';
					if(unit.length>0)
					{
						html+='<tr><td align="center" colspan="2" style="padding:10px 5px 5px 5px"><span class="newFont_normal13">'+key+' ('+unit+')</span></td></tr>';
					}
					else
					{
						html+='<tr><td align="center" colspan="2" style="padding:10px 5px 5px 5px"><span class="newFont_normal13">'+key+'</span></td></tr>';
					}
					html+='</tbody></table>';

					if(summaryDataAry.length != (summaryDataMapCount-1)*2)
					{
						summaryDataAry.push(
						{
							xtype:'container',
							bodyPadding:'0 10 10 10',
							columnWidth:colWidth,
							margin:'0 0 10 0',
							cls:'',
							layout:'fit',
							html:html
						},{
							xtype:'container',
							height:125,
							width:1,
							cls:'borderRightForFlexBox',
							margin:'0 0 15 5',
						});
					}else{
						summaryDataAry.push(
						{
							xtype:'container',
							bodyPadding:'0 10 10 10',
							columnWidth:colWidth,
							margin:'0 0 10 0',
							cls:'',
							layout:'fit',
							html:html
						},{
							xtype:'container',
							height:125,
							width:1,
							cls:'borderRightForFlexBox last',
							margin:'0 0 15 5',						
						});
					}
					
				}
				this.add(
				{
					xtype:'panel',
					ui:'newGraphPanel',
					title:'Summary',
					columnWidth:1,
					layout:'column',
					margin:'0 2 0 0',
					header:{
						style:{
							"padding":"13px 0px 15px 18px"
						}
					},
					items:summaryDataAry
				});
				this.add(
				{
					xtype:'panel',
					ui:'newGraphPanel',
					margin:'10 2 0 0',
					title:'Daywise Distribution by Latency',
					columnWidth:1.0,
					header:{
						style:{
							"padding":"13px 0px 0px 18px"
						}
					},
					layout:'column',
					items:[
					{
						xtype:'container',
						columnWidth:1.0,
						height:260,
						margin:'15 10 10 0',
						html:'<div id="dayWiseLatency" style="height:260px"></div>',
						listeners:
						{
							boxready:function()
							{
								if(dayWiseLatency!=null && dayWiseLatency!=undefined && dayWiseLatency!='null')
								{
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('dayWiseLatency',"230","200"), lineChart);
									lineChart.setData(dayWiseLatency,appConstants.currentDateFormat,'');
									lineChart.drawChart();
								}
							}
						}
					}]
				});
				this.add(
				{
					xtype:'panel',
					ui:'newGraphPanel',
					margin:'10 2 0 0',
					title:'Daywise Distribution by Unique Users',
					columnWidth:1.0,
					header:{
						style:{
							"padding":"13px 0px 0px 18px"
						}
					},
					layout:'column',
					items:[
					{
						xtype:'container',
						columnWidth:1.0,
						height:260,
						margin:'15 10 10 0',
						html:'<div id="dayWiseUniqueUser" style="height:260px"></div>',
						listeners:
						{
							boxready:function()
							{
								if(dayWiseUniqueUser!=null && dayWiseUniqueUser!=undefined && dayWiseUniqueUser!='null')
								{
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('dayWiseUniqueUser',"230","200"), lineChart);
									lineChart.setData(dayWiseUniqueUser,appConstants.currentDateFormat,'');
									lineChart.drawChart();
								}
							}
						}
					}]
				});
				var userExpMapArr = new Array();
				if(userExpMapByGroup!=undefined)
				{
					userExpMapArr.push(
						{
							xtype:'panel',
							ui:'newGraphPanel noShadow',
							margin:'0 0 10 10',
							//title:userExpMap.TITLE,
							columnWidth:0.55,
							layout:'column',
							items:[
							{
								xtype:'container',
								columnWidth:0.35,
								maxWidth:185,
								height:152,
								userExpMapByGroup:userExpMapByGroup,
								id:'donutSingleId',
								margin:'0 10 0 0',
								html:'<div id="groupUserExp" style="height:182px;text-align:left"></div>',
								listeners:
								{
									boxready:function()
									{
									try
									{
										if(userExpMapByGroup!=null && userExpMapByGroup!=undefined && userExpMapByGroup!='null')
										{
											var lineChart = {};
											lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('groupUserExp',"160","160"), lineChart);
											lineChart.setData(userExpMapByGroup,appConstants.currentDateFormat,'');
											lineChart.drawChart();
										}
									}
									catch(e)
									{
										console.log(e);
									}
									}
								}
							},
							{
								xtype:'container',
								columnWidth:0.65,
								cls:'greenBorderContainer',
								html: groupHtmlHeader +'<div class="egFlexCenterByRowWise" >'+groupHtml+'</div>',
								margin:'0 0 0 0',
								//html:'<div><table valign="middle" align="center" cellpadding="0" cellspacing="0" border="0" style="margin:10px"><tbody>'+groupHtml+'</tbody></table></div>'
							}]
						});

						userExpMapArr.push({
							xtype:'panel',
							ui:'newGraphPanel noShadow',
							margin:'0 10 10 10',
							columnWidth:0.45,
							title:"User Experience Criteria",
							layout:'column',
							items:[
							{
								xtype:'container',
								columnWidth:1.0,
								margin:'10 10 10 5',
								html:recomemtationStr
							}]
						});

					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'10 2 0 0',
						title:userExpMapByGroup.TITLE,
						columnWidth:1,
						header:{
							style:{
								"padding":"13px 20px 20px 18px"
							}
						},
						layout:'column',
						items:userExpMapArr
					})
				}
				if(barChatLst!=undefined)
				{
					var barChart = [];
					for(var ind in barChatLst)
					{
						var chatObj = barChatLst[ind];
						var margin = '8 0 10 8';
						var borderRight = "borderRightForFlexBox";
						if(ind == 2)
						{
							borderRight = " ";
						}
						barChart.push(
						{
							xtype:'panel',
							ui:'newGraphPanel noShadow '+ borderRight,
							margin:margin,
							title:chatObj.chartTitle,
							columnWidth:0.33,
							header:{
								style:{
									'padding':'0px 5px 5px 5px'
								}
							},
							layout:'column',
							items:[
							{
								xtype:'container',
								columnWidth:1.0,
								height:362,
								cls:borderRight,
								chatObj:chatObj,
								divId:'barId_'+ind,
								html:'<div id="barId_'+ind+'" style="height:362px"></div>',
								listeners:
								{
									boxready:function()
									{
										if(this.chatObj!=null && this.chatObj!=undefined && this.chatObj!='null')
										{
											var lineChart = {};
											lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(this.divId,"230","200"), lineChart);
											lineChart.setData(this.chatObj,appConstants.currentDateFormat,'');
											lineChart.drawChart();
										}
									}
								}
							},
							{
								xtype:'container',
								padding:'0 10 10 10',
								cls:borderRight,
								columnWidth:1.0,
								//hidden:true,
								html:'<div style="font-style:italic;">'+chatObj.measureTitle+'</div>'
							}]
						});
					}

					this.add(
						{
							xtype:'panel',
							ui:'newGraphPanel',
							margin:'10 2 0 0',
							padding:'5 0 5 0',
							columnWidth:1,
							layout:'column',
							items:barChart
						});
				}
				if(GEOgridColumn!=undefined)
				{
					var mainColArray=new Array();
					var fieldsToStore=new Array();
					var keyCount = 0;
					for (var key in GEOgridColumn)
					{
						var align = 'center';
						
						if(key=='GEO_NAME' || key=='Connection_strength')
						{
							align = 'left';
						}
						fieldsToStore.push(keyCount+'');
						mainColArray.push({
							header: GEOgridColumn[key],
							sortable: true,
							resizable :true,
							align:align,
							dataIndex: keyCount+'',
							/*renderer :function(value, metaData, record, row, col, store, gridView)
							{
								if(value=='good')
								{
									metaData.tdAttr = 'data-qtip="Great User Experience"';
									value = '<div style="width:16px;color:#8bc34a" class="gen-great size18"></div>';
								}
								else if(value=='acceptable')
								{
									metaData.tdAttr = 'data-qtip="Acceptable User Experience"';
									value = '<div style="width:16px;color:#aed581" class="gen-yes size18"></div>';
								}
								else if(value=='degraded')
								{
									metaData.tdAttr = 'data-qtip="Degraded User Experience"';
									value = '<div style="width:16px;color:#ee223b" class="gen-no size18"></div>';
								}
								else
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
								}
								return value;
							},*/
							
							renderer :function(value, metaData, record, row, col, store, gridView)
							{
									var tmpValue = value;
									if(tmpValue!=null && tmpValue.indexOf("#")>-1)
									{
										tmpValue = tmpValue.substring(0,tmpValue.indexOf("#"));
										value = value.substring(value.indexOf("#")+1);
									}
									if(tmpValue=='good')
									{
										metaData.tdAttr = 'data-qtip="' + value + '" style="border-left:3px solid #8bc34a"';
										//value = '<div style="width:16px;"><img src="/final/images/clear.png" class="btm_rum_dd_icons_healthy"></div>';
										//value = '<div><span style="color:#8bc34a;margin-right:5px"  class="gen-great size16"></span>'+value+'</div>';
									}
									else if(tmpValue=='acceptable')
									{
										metaData.tdAttr = 'data-qtip="' + value + ' style="border-left:3px solid #aed581"';
										//value = '<div style="width:16px;"><img src="/final/images/clear.png" class="btm_rum_dd_icons_stalled"></div>';
										//value = '<div><span style="color:#aed581;margin-right:5px" class="gen-yes size16"></span>'+value+'</div>';
									}
									else if(tmpValue=='degraded')
									{
										metaData.tdAttr = 'data-qtip="' + value + '" style="border-left:3px solid #ee223b"';
										//value = '<div style="width:16px;"><img src="/final/images/clear.png" class="btm_rum_dd_icons_slow"></div>';
										//value = '<div><span style="color:#ee223b;margin-right:5px" class="gen-no size16"></span>'+value+'</div>';
									}
									else
									{
										metaData.tdAttsr = 'data-qtip="' + value + '"';
									}
									return value;
							},

							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
										{
											var tmp = v1.substring(0, v1.lastIndexOf(' '));

											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
										}
										if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
										{
											var tmp = v2.substring(0, v2.lastIndexOf(' '));
											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
										}
										if(!isNaN(v1) && !isNaN(v2))
										{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;
												v2= isNaN(v2) ? 0 : v2;
											}
										}
										else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
										{
											v2=new Date(v2).getTime(); 
											v1=new Date(v1).getTime(); 
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							}
						});
						keyCount++;
						if(key=='Latency_avg' || key=='ICA_nwlatency')
						{
							mainColArray[mainColArray.length-1].minWidth = 120;
							mainColArray[mainColArray.length-1].flex=1;
						}
						if(key=='Connection_strength')
						{
							mainColArray[mainColArray.length-1].minWidth = 130;
							mainColArray[mainColArray.length-1].flex=1;
						}
						if(key=='Last_recd_latency')
						{
							mainColArray[mainColArray.length-1].minWidth = 140;
							mainColArray[mainColArray.length-1].flex=1;
						}
						if(key=='GEO_NAME' || key=='USER')
						{
							mainColArray[mainColArray.length-1].maxWidth = 120;
						}
						if(key=='Output_line_speed' || key=='Input_session_bandwidth' || key=='Output_session_bandwidth')
						{
							mainColArray[mainColArray.length-1].minWidth = 120;
							mainColArray[mainColArray.length-1].flex=1;
						}
						if(key=='state')
						{
							mainColArray[mainColArray.length-1].maxWidth = 35;
						}
					}
					var isPagingHidden=false;
					var gridPageSize=10;
					 if (geoDataList!=undefined && geoDataList.length<=gridPageSize)
						isPagingHidden=true;
					else
						isPagingHidden=false;
					
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'array', root : 'data', totalProperty : 'total'
							},
							data : geoDataList,
						},
						sorters: { property: fieldsToStore[4], direction : 'ASC' },
						pageSize:gridPageSize,
						remoteSort:true,
						autoLoad : true
					});
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						columnWidth:1.0,
						title:GEOgridTitle,
						margin:'10 2 0 0',
						header:{
							style:{
								"padding":"13px 20px 12px 18px"
							}
						},
						items:[{
							xtype:'customgrid',
							store:storeObj,
							forceFit:true,
							columnWidth:1.0,
							margin:'0 20 20 20',
							sortableColumns:true,
							ui:'newGridPanel height30 upperCase',
							border:true,
							id:'geogrid_id',
							columns:mainColArray,
							popUpData:false,
							style:
							{
								'box-shadow':'none !important',
							},
							scroll:true,
							autoScroll:true,
							dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: 
								{
									change : function(thisd, params)
									{
										if(!Ext.isEmpty(params))
											activePage = params.currentPage;
										else
											activePage=1;
									}
								}
							}],
							listeners:
							{
								render:function(obj)
								{
									Ext.defer(function() 
									{
										if(!Ext.isEmpty(obj.columns[1]))
										{
											obj.columns[(obj.columns.length)-1].doSort('DESC');
										}
									},100);
								}
							}
						}]
					});
				}
				if(gridColumn!=undefined)
				{
					var mainColArray=new Array();
					var fieldsToStore=new Array();
					var count = 0;
					for (var key in gridColumn)
					{
						var align = 'left';
						var colName = gridColumn[key];
						if (colName instanceof Array)
						{
							var subColumnArray = new Array();
							for (var k in colName)
							{
								fieldsToStore.push(count+'');
								subColumnArray.push({
									header: colName[k],
									sortable: true,
									align:'center',
									dataIndex:count+'',
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
										return value;
									},
									doSort: function(state) 
									{
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2)
											{
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
														v1= isNaN(v1) ? 0 : v1;
														v2= isNaN(v2) ? 0 : v2;
													}
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									},
								});
								count++;
							}
							mainColArray.push({
								header: key,
								sortable: true,
								width:110,
								columns:subColumnArray
							});
						}
						else
						{
							fieldsToStore.push(count+'');
							if(key=='GEO_NAME' || key=='User Name')
							{
								align = 'left';
							}
							else
							{
								align = 'center';
							}
							mainColArray.push({
								header: colName,
								sortable: true,
								resizable :true,
								align:align,
								dataIndex: count+'',
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									/*if(value=='good')
									{
										metaData.tdAttr = 'data-qtip="Great User Experience"';
										value = '<div style="width:16px;color:#8bc34a" class="gen-great size18"></div>';
									}
									else if(value=='acceptable')
									{
										metaData.tdAttr = 'data-qtip="Acceptable User Experience"';
										value = '<div style="width:16px;color:#aed581" class="gen-yes size18"></div>';
									}
									else if(value=='degraded')
									{
										metaData.tdAttr = 'data-qtip="Degraded User Experience"';
										value = '<div style="width:16px;color:#ee223b" class="gen-no size18"></div>';
									}
									else
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
									}
									return value;*/
									var tmpValue = value;
									if(tmpValue!=null && tmpValue.indexOf("#")>-1)
									{
										tmpValue = tmpValue.substring(0,tmpValue.indexOf("#"));
										value = value.substring(value.indexOf("#")+1);
									}
									if(tmpValue=='good')
									{
										metaData.tdAttr = 'data-qtip="' + value + '" style="border-left:3px solid #8bc34a"';
										//value = '<div style="width:16px;"><img src="/final/images/clear.png" class="btm_rum_dd_icons_healthy"></div>';
										//value = '<div><span style="color:#8bc34a;margin-right:5px"  class="gen-great size16"></span>'+value+'</div>';
									}
									else if(tmpValue=='acceptable')
									{
										metaData.tdAttr = 'data-qtip="' + value + '" style="border-left:3px solid #aed581"';
										//value = '<div style="width:16px;"><img src="/final/images/clear.png" class="btm_rum_dd_icons_stalled"></div>';
										//value = '<div><span style="color:#aed581;margin-right:5px" class="gen-yes size16"></span>'+value+'</div>';
									}
									else if(tmpValue=='degraded')
									{
										metaData.tdAttr = 'data-qtip="' + value + '" style="border-left:3px solid #ee223b"';
										//value = '<div style="width:16px;"><img src="/final/images/clear.png" class="btm_rum_dd_icons_slow"></div>';
										//value = '<div><span style="color:#ee223b;margin-right:5px" class="gen-no size16"></span>'+value+'</div>';
									}
									else
									{
										metaData.tdAttsr = 'data-qtip="' + value + '"';
									}
									return value;
								},
								doSort: function(state) 
								{
									var ds = this.up('grid').store;
									var field = this.getSortParam();
									ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2)
										{
											v1 = v1.get(field);
											v2 = v2.get(field);
											
											if(!isNaN(v1) && !isNaN(v2))
											{
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
												v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
												if (state=='ASC')
												{
													v1= isNaN(v1) ? 999999 : v1;
													v2= isNaN(v2) ? 999999 : v2;
												}
												else
												{
													v1= isNaN(v1) ? 0 : v1;
													v2= isNaN(v2) ? 0 : v2;
												}
											}
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
							});
								console.log(key +" , "+colName)
							if(key=='state')
							{
								mainColArray[mainColArray.length-1].maxWidth = 35;
							}
							else if(key=='GEO_NAME')
							{
								mainColArray[mainColArray.length-1].maxWidth = 90;
							}
							else if(key=='User Name')
							{
								mainColArray[mainColArray.length-1].minWidth = 110;
								mainColArray[mainColArray.length-1].flex=1;
							}
							else if(key=='Time in Session')
							{
								mainColArray[mainColArray.length-1].maxWidth = 110;
							}
							else if(key=='Session bandwidth input'||key=='Session bandwidth output'||key=='Client network latency'||key=='Screen refresh latency - last')
							{
								mainColArray[mainColArray.length-1].minWidth = 200;
								mainColArray[mainColArray.length-1].flex=1;
							}
							else
							{
								mainColArray[mainColArray.length-1].minWidth = 123;
								mainColArray[mainColArray.length-1].flex=1;
							}
							count++;
						}
					}
					var isPagingHidden=false;
					var gridPageSize=10;
					 if (gridData!=undefined && gridData.length<=gridPageSize)
						isPagingHidden=true;
					else
						isPagingHidden=false;
					
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'array', root : 'data', totalProperty : 'total'
							},
							data : gridData,
						},
						//sorters: { property: fieldsToStore[3], direction : 'ASC' },
						pageSize:gridPageSize,
						autoLoad : true,
						remoteSort:true,
					});
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'10 2 0 0',
						header:{
							style:{
								"padding":"13px 20px 12px 18px"
							}
						},
						columnWidth:1.0,
						title:'User Details',
						items:[{
							xtype:'customgrid',
							store:storeObj,
							margin:'0 20 20 20',
							sortableColumns:true,
							ui:'newGridPanel height30 uppercase',
							border:true,
							forceFit:false,
							needtoFixColumn:true,
							popUpData:false,
							id:'useratency_id',
							columns:mainColArray,
							style:
							{
								'box-shadow':'none !important',
							},
							scroll:true,
							autoScroll:true,
							dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{
										if(!Ext.isEmpty(params))
											activePage = params.currentPage;
										else
											activePage=1;
									}
								}
							}],
							listeners:
							{
								render:function(obj)
								{
									Ext.defer(function() 
									{
										if(!Ext.isEmpty(obj.columns[1]))
										{
											//console.log('obj.columns  ',obj.columns);
											//obj.columns[7].items.items[0].doSort('DESC');
										}
									},100);
								}
							}
						}]
					});
				}
			}
			else
			{
				this.add(this.getNoMeasure(150,'iconInformation','No Measures Available'));
			}
		}
		catch(e)
		{
			console.log(e);
		}
	},
	getNoMeasure:function(height,icon,msg)
	{
		return {
			xtype:'container',
			columnWidth:1.0,
			margin:10,
			height:height,
			html:'<div class="egFlexCenterByColumnWise" style="height:100%"> <div class="'+icon+'"></div> <div class="commonErrorMsgText">'+msg+'!</div> </div>'
		}
	}
});


