var rTBelementClickedId = '';
var boxElemntClickedId = '';
Ext.define('RumAppFlow.controller.Main', {
    extend: 'Ext.app.Controller',
    requires: [
        'RumAppFlow.view.Main',
        'RumAppFlow.view.OverviewDetails',
        'RumAppFlow.view.OverviewWidgets',
        'RumAppFlow.view.AppFlowMenu',
        'RumAppFlow.view.ChartParentPanel',
        'RumAppFlow.view.GeoPanel',
        'RumAppFlow.view.GeoStaticPanel',
        'RumAppFlow.view.ResponseTimePiechart',
        'RumAppFlow.view.GeoMapDetails',
        'RumAppFlow.view.OmniChannelMainPanel',
        'RumAppFlow.view.PageView',
		'RumAppFlow.view.DonutChart',
		'RumAppFlow.view.ErrorView',
		'RumAppFlow.view.GeoMapControls',
		'RumAppFlow.view.ChartPanelNew',
		'RumAppFlow.view.TransactionGridPanel',
		'RumAppFlow.view.TransactionsChartPanel',
		'RumAppFlow.view.Paging',
		'sessionSimulation.view.SessionSimulation',
		'RumAppFlow.view.ConfigWindow'
    ],
	transactionMeasuresChartURL:"/final/servlet/com.egurkha.TransactionMeasures",
    refs: [
		{
            ref: 'main',
            selector: 'main'
        },
        {
            ref: 'overviewdetails',
            selector: 'overviewdetails'
        },
        {
            ref: 'overviewwidgets',
            selector: 'overviewwidgets'
        },
        {
            ref: 'appflowmenu',
            selector: 'appflowmenu'
        },
		{
            ref: 'chartpanel',
            selector: 'chartpanel'
        },
		{
			ref:'transactiongridpanel',
			selector: 'transactiongridpanel'
		},
		{
			ref:'transactionschartpanel',
			selector: 'transactionschartpanel'
		},
		{
			ref:'myTimeWindow',
			selector:'floatingContainer'
		},
		{
			ref:'myTimelinePanel',
			selector:'floatingContainer > panel'
		},
		{
			ref : 'transactionComboMode',
			selector : 'floatingContainer > panel > combo[itemId= "mode"]'
		},
		{
			ref : 'transactionComboTimeline',
			selector : 'floatingContainer > panel > combo[itemId= "timeline"]'
		},
		{
			ref : 'transactionComboFromhr',
			selector : 'floatingContainer > panel > combo[itemId= "fromhr"]'
		},
		{
			ref : 'transactionComboTohr',
			selector : 'floatingContainer > panel > combo[itemId= "tohr"]'
		},
		{
			ref : 'transactionComboFrommin',
			selector : 'floatingContainer > panel > combo[itemId= "frommin"]'
		},
		{
			ref : 'transactionComboTomin',
			selector : 'floatingContainer > panel > combo[itemId= "tomin"]'
		},
		{
			ref : 'transactionFromDate',
			selector : 'floatingContainer > panel > datefield[itemId= "from"]'
		},
		{
			ref : 'transactionToDate',
			selector : 'floatingContainer > panel > datefield[itemId= "to"]'
		},
		{
			ref:'transactionsPanelToolbar',
			selector:'floatingContainer > panel'
		},
		{
			ref:'configWindow',
			selector:'configwindow'
		},
		{
			ref:'configWindowForm',
			selector:'configwindow > form'
		}
    ],
    init: function() {
		RumAppFlow.app=this
		setInterval(this.refresh,refreshFrequency);
		this.control(
		{            
            'overviewdetails': {
                afterrender: this.overviewdetailsRender,				
            },
            'button[id="backButton"]': {
				click:this.backButtonHandler
			},
            'button[itemId="overviewtoggle"]': {
                toggle: this.toggleOverView
            },
			'combo[itemId="loadmapcombo"]':{
				select:this.loadMapDetails
			},
			'combo[itemId="appflowBy"]':{
				select:this.changeView	
			},
			'geomapcontrols combo[id="countryComboId"]':
			{
				'select': this.geoComboOnChange
			},
			'geomapcontrols combo[id="regionComboId"]':
			{
				'select': this.geoComboOnChange
			},
			'generalMeasuresGridPanel combo[id="filterByCombo"]':{
				'select':this.compFilterByComboOnChange
			},
			'generalMeasuresGridPanel combo[id="subFilterCombo"]':{
				change:this.compSubFilterComboOnChange
			},
			'generalMeasuresGridPanel combo[id="componentTypCombo"]':{
				change:this.componentTypeComboOnChange
			},
			'dashboardgeneralmeasuresgridpanel[itemId="system"] > panel > toolbar > combobox':{
       				change:this.systemsComboChange
       			},
			'dashboardgeneralmeasuresgridpanel[itemId="system"] > toolbar > combobox':{
       				change:this.systemsComboChange
       			},
			'generalMeasuresGridPanel combo[id="sortByCombo"]':{
				'select':this.componentsmeasureComboChange
			},
			'generalMeasuresGridPanel textfield[id="nickName"]':{
				specialkey: function(field, e){
					if (e.getKey() == e.ENTER) {
						this.compSubmitButtonClicked();
					}
				}
			},
			'transactionschartpanel button[id= "settingBt"]':{
				click:this.settingClick
			},			  
			'transactionschartpanel':{
				'afterrender':this.onChartsPanelRender
			},			  
			'floatingContainer > panel > combo[itemId= "timeline"]':{
				select:this.timelineChangeHandler // Date 
			},
			'floatingContainer > panel > button[action = "transactionGraphBtn"]':{
				click:this.displayGraph
			},
			'main button[action="configsetting"]':{
				scope : this,
				click : this.openConfigWindow
			},
			'configwindow':{
				'render': this.itemset,
				 'close':this.refreshcall
			},
			'configwindow > form > combo':{
				'select':this.combo
			},
			'configwindow > form > radiogroup':{
				'change':this.radio
			},
			'configwindow > toolbar > button[action="submit"]':{
				click:this.buttonclick
			}
		});
    },
	itemset:function(window,e){
		window.add(window.setData("",""));
	},			
	combo:function(combo,newvalue,opt){
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
		var testfun='';
		//if(descMeasureUnit=='Yes')
		testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		var name=combo.getName();
		var val=combo.getValue();
		var componentType;
		
		if(selectedTab=='Component' || selectedTab=='Aggregate' || selectedTab=='System')
			componentType=this.getConfigWindowForm().getForm().getValues()['serviceComp'];
		
		if(name=='serviceComp')
		{
			this.getConfigWindow().setData(selectedTab,perform,componentType,"","","",descMeasureUnit,testfun,"", name, val);
		}
		if(name=='compLayer')
		{
			var compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,"","",descMeasureUnit,testfun,"", name, val);
		}
		else if(name=='serviceTest')
		{
			var compname;
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			else
				compname='';
			var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,"",descMeasureUnit,testfun,"", name, val);
		}
		else if(name=='serviceMeasure')
		{
			var compname;
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			else
				compname='';
			var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			var measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
			var dispName=newvalue[0].data.name;
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName, name, val);
		}
		else{}
	},
	radio:function(radio,newvalue,oldvalue,opts){
		var name='';
		var componentType='';
		var compname='';
		var testName='';
		var measureName='';
		var dispName='';
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit='';
		var testfun='';
		if(perform=='Add')
		{
			//descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
			//if(descMeasureUnit=='Yes')
			testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		}
		if(radio.getName()=='Does the Test have Descriptors ?'||radio.getName()=='Function')
		{
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			if(selectedTab=='Component' || selectedTab=='Aggregate')
				componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
				testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
				measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
				dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
				name=radio.name;
		}
		this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
	},
	buttonclick:function(button,e,opts)
	{
		var flag=false;
		var me=this;
		var url='/final/monitor/serviceDashboardConfigP.jsp';
		var params='selectType=Update';
		var json=this.getConfigWindow().jsonData.Window.fields;
		var labels=this.getConfigWindow().jsonData.Window.screenlabels[0];
		for(var i=0;i<json.length;i++)
		{
			if(json[i].type=='combo')
			{
				var name=json[i].name;
				if(this.getConfigWindowForm().getForm().findField(name).getValue()==-1)
				{
					Ext.Msg.alert("",labels[name]);
					flag=true;
					break;
				}
				else
				{
					if(name=='serviceTest')
						name='testName';
					params+='&'+name+'='+json[i].selected;
				}
			}
			else
			{
				if(json[i].type=='textfield')
				{
					var dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
					flag=true;

					// Changes For ?,',- and Numbers charcters Support - Starts Here
					while(true){
						if(dispName.indexOf("?") != -1)
							dispName = dispName.replace('?','qqsstt');
						if(dispName.indexOf("'") != -1)
							dispName = dispName.replace("'","sinCour");
						if(dispName.indexOf("-") != -1)
							dispName = dispName.replace("-","minSym");

						if(dispName.indexOf("?") == -1 && dispName.indexOf("'") == -1 && dispName.indexOf("'") == -1)
							break;
					}

					if(dispName.length<1)
						Ext.Msg.alert("","Please enter display name");
					//else if(this.hasNumbers(dispName))
					//	Ext.Msg.alert("","Number not allowed");
					else if(this.hasSpecialCharacters(dispName))
					{
						if(this.hasNumbers(dispName)){
							params+='&'+json[i].name+'='+dispName;
							flag=false;
						}
						else
							Ext.Msg.alert("","Special characters not allowed");
					}
					else
					{
						params+='&'+json[i].name+'='+dispName;
						flag=false;
					}

					// Changes For ?,',- and Numbers charcters Support - Ends Here
				}
				else
				{
					if(json[i].selected=='Component')
						json[i].selected='Application';
					params+='&'+json[i].name+'='+json[i].selected;
				}
			}
		}
		if(flag==false)
		{
			Ext.Ajax.request({
				url: url,
				params:params,
				method : 'POST',
				scope:this,
				success: function(response){
					var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
					var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
					var dispName="";
					var measureName=-1;
					var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
					var compname='';
					var componentType='';
					var descMeasureUnit='';
					var testfun='';
					if(perform=='Add')
					{
						//descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
						//if(descMeasureUnit=='Yes')
						testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
						compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
						Ext.Msg.alert("","Measure Added Successfully");
					}
					else if(perform=='Delete')
					{
						Ext.Msg.alert("","Measure Deleted Successfully");
					}
					if(selectedTab=='Component' || selectedTab=='Aggregate')
						componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
					this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
				},
				failure:function(){
					window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		if(flag==false)
		{
			Ext.Function.defer(function(){
				me.setValues(flag);
			},350);
		}
	},
	setValues:function(flag){
		if(flag==false)
		{
			var json1=this.getConfigWindow().jsonData.Window.fields;
			var f=false;
			for(var i=0;i<json1.length;i++)
			{
				if(json1[i].type=='combo')
				{
					if(json1[i].selected!='Not Applicable!')
							f=true;
					if(!f && this.getConfigWindowForm().getForm().getValues()['perform']=='Delete')
						this.getConfigWindowForm().getForm().findField(json1[i].name).setValue(-1);
				}
				f=false;
			}
		}
	},
	hasNumbers:function(t)
	{
		var regex = /\d/g;
		return regex.test(t);
	},
	hasSpecialCharacters:function(t)
	{
		var charAr = t.split('');
		if(charAr != null && charAr != undefined && charAr.length > 0)
		{
			for(var p=0;p<charAr.length;p++)
			{
				var c = charAr[p];
				if(!(c ==' ' || c ==')' || c =='(' || c =='_' || c.match(/^[-'a-z\u4e00-\u9eff]{1,20}$/i)))
					return true;
			}
			return false;
		}
	},
	openConfigWindow : function()
	{
		var VWidth = Ext.Element.getViewportWidth( );
		try
		{
			var backButtonExist = Ext.getCmp('back').hidden;
			var popUparrowaxis = '135px';
			if(backButtonExist != undefined && backButtonExist != null && !backButtonExist)
				popUparrowaxis = '105px';				
		}
		catch (e)
		{
			popUparrowaxis = '105px';
		}
		if(!this.getConfigWindow())
		{
			var win=Ext.create('RumAppFlow.view.ConfigWindow');
			win.show();

			container = Ext.create('Ext.container.Container',{
				padding:10,
				floating:true,
				frame:true,
				width:510,
				hidden:true,
				//height:500,
				floatable:true,
				//id:'configMod',
				cls:'configMode_popup',
				items:[
					{
						xtype:'container',
						cls:'alarmTooltipArrow1',
						style:{'top':'-17px','left':popUparrowaxis}
					},
					{
						xtype:'container',
						margin:'-4px 0px 0px 4px',
						html:'<div class="settingsfont" style="float:left;color:#f7f7f7text-transform:uppercase;margin-top: -5px;">Settings</div><div style="text-align:right;float:right;margin-top:-7px;"><div class="iconClose3"></div></div>',
					},
						win
				]
			});
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
				   top:40,
					left: VWidth -615
				}
			});

			container.showAt(VWidth -615,5000);
			Ext.select('.iconClose3').on('click',function(){
					Ext.create('Ext.fx.Anim', {
						target: container,
						duration: 500,
						from: {
						left: VWidth -615,
							top:40
						},
						to: {
						   top:-500,
						left: VWidth -615
						},
						callback: function(){
							container.hide();
							RumAppFlow.app.getController("Main").metricRefresh();
						}
					});
			},this);

			Ext.getBody().on('click',function(event){
					var tarid = event.target.id;
					if((tarid != undefined && tarid != null && ((tarid.toLowerCase().indexOf("gridview") != -1) || (tarid.toLowerCase().indexOf("toolbar") != -1) || (tarid.toLowerCase().indexOf("filter") != -1) || (tarid.toLowerCase().indexOf("listbutid") != -1) || (tarid.toLowerCase().indexOf("centerp") != -1))))
					{
						container.hide();
					}
			});
		}
		else if(container.isHidden())
		{
			var win=this.getConfigWindow();
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
					top:40,
					left: VWidth -615
				}
			});
			container.showAt(VWidth -615,5000);
		}
		else
		{
			container.hide();
			RumAppFlow.app.getController("Main").metricRefresh();
		}
	},
	metricRefresh:function()
	{
		selected_CompType_st ='';
		var selected_dash = '';
		if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
			selected_dash = Ext.getCmp('dashListComId').getValue();
		
		var menuObj = Ext.getCmp('rumappmenu_view_id');

		var store_data=menuObj.getStore();
		var forceKey=menuObj.forceClickKey;
		var selected_view_name="";
		for(var k=0;k<store_data.getCount();k++)
		{
			var caption_value=store_data.getAt(k).data.caption;
			if(requestParams.activeViewIndex==k)
			{
				selected_view_name=store_data.getAt(k).data.name;
				break;
			}
		}

		var comboValues = Ext.getCmp('comboValue');
		SysComponentType = "";
		if(!Ext.isEmpty(comboValues))
			SysComponentType = comboValues.getValue();
		
		var systemView_containerObj =  Ext.getCmp('systemViewMeasuresgridpanel');
		var urlt = "/final/monitor/serviceSystem.jsp?treeTitle=services&selectNode=Service$cap$"+encodeURIComponent(requestParams.filterBy)+"&selectedParam="+encodeURIComponent(requestParams.filterBy)+"&componentType="+encodeURI(SysComponentType)+"&currentTab=Systems&isSite=true&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&refresh=true&action=Systems&topoSegment="+encodeURIComponent(requestParams.filterBy)+'&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&hasRUM=true&dashboard_name=RUM_Dashboard&view_name=systems_View&fromServiceHomePage=true&isFromZone='+backParams.isFromZone+"&iszoneName="+encodeURIComponent(backParams.iszoneName)+"&parentZone="+backParams.parentZone+"&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;

		systemView_containerObj.loadTab(urlt,'rumAppFlowSystem');
		
	},
	onChartsPanelRender:function(panel){
		this.displayGraphInitially(panel.jsonData);
	},
	settingClick:function(image){
		var timlinePos=Ext.getCmp("settingBt").getPosition();
		var winObj = Ext.getCmp('timeWindow');
		winObj.showAt([timlinePos[0]-680,timlinePos[1]+20]);
		//winObj.show();
		//winObj.setPosition(image.x+50-winObj.getWidth(),image.y+320);

	},
	createDivforHighChart:function(size){
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		var imgDiv = '';
		//if(this.tab=='emulated')
		tmp_div_size_of_td=size;
		//else
		//tmp_div_size_of_td=(size/2);
		var inc = 0;
		var chartPane = '',legendPanel = '';
		chartPanel.removeAll();
		var scrollPanel=Ext.create('utilities.ScrollPanel',{
		layout:{type:'vbox',align:'stretch'},
		padding:'0 15 15 15',
		//height:80,
		items:[
				{
					xtype:'container',
					id:'legends'
				},
				{
					xtype : 'container',
					//height:525,
					border:true,
					layout:'column',
					id:'midid',
					defaults:{
						columnWidth:.33,
						//height: 250
					},
					items:this.getItems(size)
				}]
		});
		chartPanel.add(scrollPanel);
		/*--Adding Legend--*/
		/* var chartToolbar=this.getTransactionsChartPanel().getDockedItems()[1];
		chartToolbar.remove(Ext.getCmp('legends'));
		chartToolbar.add('->',{xtype:'container',id:'legends'});*/

	},
	getItems:function(size){
		var skinBg="";
		var items=[];
		for(var y=1;y<size+1;y++){
			i = y-1;
			var borderright="";
			var borderbottom="";
			if (strSkin=="Dark")
			{
				skinBg="#404040";
				borderright="1px solid #515151 !important";
				borderbottom="1px solid #515151 !important";
			}
			else if (strSkin=="Light")
			{
				skinBg="#ffffff";
				borderright="1px solid #f2f2f2 !important";
				borderbottom="1px solid #f2f2f2 !important";
			}
			var idName ='transchart'+i; 
			if(size % 2 === 0){
				if (y != 0 && y%3 === 0)
				{
					borderright="0px solid #f2f2f2 !important";				
				}
			}else{
				if (y != 0 && y === size+1)
				{
					borderright="0px solid #f2f2f2 !important";				
				}
			}

			items.push({
				xtype: 'panel',
				ui:'newPlainPanel',
				height:280,
				style:{background: skinBg+'!important',borderRight:borderright, borderBottom: borderbottom},
				
				/*tools:[
				{
					xtype:'toolbar',
					ui:'footer',
					items:[
					{
						xtype:'button',
						border:0,
						id:'highMax'+i,
						cls:'iconMaximize showgraph',
						handler:function(){
							var idStr = this.getId();
							idStr = idStr.substring(7);
							showGraph('event',idStr);
						}
					}	
					]
				}	 
				],*/
				//margin:'5 10',
				frame:true,
				border:true,
				padding:'10 0 10 0',
				title:'',
				id:idName
			})
		}
		return items;
	},
	timelineChangeHandler:function(combo){
		var timelineValue=combo.getValue();
		if(timelineValue=="Any"){
		this.enableDisableDateFields(true);
		}else{
		this.enableDisableDateFields(false);
		}
		var chartToolbar=this.getTransactionsPanelToolbar();
		//var chartPanel=this.getTransactionsChartPanel();
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		var remoteURL=chartPanel.jsonData.HiddenFields.remoteURL;
		var format=chartPanel.jsonData.HiddenFields.currentDateFormat;

		var starttime="";
		var startTimeField=chartToolbar.getComponent("from");
		if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(startTimeField.getValue())){
			starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
		}

		var endtime="";
		var endTimeField=chartToolbar.getComponent("to");
		if(!Ext.isEmpty(endTimeField) && !Ext.isEmpty(endTimeField.getValue())){
			endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
		}

		var startHr="";
		var fromCombo=chartToolbar.getComponent("fromhr");
		if(!Ext.isEmpty(fromCombo) && !Ext.isEmpty(fromCombo.getValue())){
			startHr=fromCombo.getValue();
		}			  

		var endHr="";
		var toCombo=chartToolbar.getComponent("tohr");
		if(!Ext.isEmpty(toCombo) && !Ext.isEmpty(toCombo.getValue())){
			endHr=toCombo.getValue();
		}

		//Get Minutes
		var startMin="";
		var fromMinCombo=chartToolbar.getComponent("frommin");
		if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo.getValue())){
			startMin=fromMinCombo.getValue();
		}			

		var endMin="";
		var toMinCombo=chartToolbar.getComponent("tomin");
		if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo.getValue())){
			endMin=toMinCombo.getValue();
		}
		var paramValues='F=getTimeJSON&P0=['+timelineValue+']&P1=['+starttime+']&P2=['+endtime+']&P3=['+startHr+']&P4=['+endHr+']&P5=['+format+']&P6=['+startMin+']&P7=['+endMin+']&C=1&calljson=true';

		Ext.Ajax.request({
			url: remoteURL,
			scope:this,
			method: 'POST',
			params: paramValues,
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				this.setTime(jsonData.getTime,timelineValue);
				}
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
		//jsrsExecute(remoteURL,this.setTime,"getTime",new Array(""+timelineValue,""+starttime,""+endtime,""+startHr,""+endHr,""+format));
	},
	setTime:function(timeVal,timelineValue){	
		var arrOptions = timeVal.split('\t');
		var frHr="",toHr="";
		var frMin="",toMin="";
		time_line_obj=new Object();
		time_line_obj.starttime=arrOptions[0];
		var startdt ="",enddt="";
		//var mgr_dateFormat = 'M d, Y';
		if(timelineValue=="Any"){
			startdt = Ext.Date.format(arrOptions[6],mgrDateFormat);
			enddt = Ext.Date.format(arrOptions[7],mgrDateFormat);
		}
		else
		{
			startdt = new Date(arrOptions[6]);
			enddt = new Date(arrOptions[7]);
			startdt = Ext.Date.format(arrOptions[6],mgrDateFormat);
			enddt = Ext.Date.format(arrOptions[7],mgrDateFormat);
		}
		if(startdt == "Invalid Date" || startdt =="" )
			startdt = arrOptions[6];
		//enddt = new Date(arrOptions[7]);
		if(enddt == "Invalid Date" || enddt =="" )
			enddt = arrOptions[7];
		var tmp_start_date="",tmp_end_date="";
		tmp_start_date= Ext.Date.format(startdt,mgrDateFormat);
		tmp_end_date = Ext.Date.format(enddt,mgrDateFormat);
		startdt = (tmp_start_date == "")?startdt:tmp_start_date;
		enddt = (tmp_end_date == "")?enddt:tmp_end_date;
		this.getTransactionsPanelToolbar().getComponent("from").setValue(startdt);

		time_line_obj.endtime=arrOptions[1];
		this.getTransactionsPanelToolbar().getComponent("to").setValue(enddt);
		time_line_obj.starthr=arrOptions[2];
		if(timelineValue=="Any"){
			//frHr = arrOptions[2];
			//toHr = arrOptions[3];
			frHr = arrOptions[8];
			toHr = arrOptions[9];
		}
		else
		{
			frHr = arrOptions[8];
			toHr = arrOptions[9];
		}

		//set Min
		frMin = arrOptions[10];
		toMin = arrOptions[11];
		this.getTransactionsPanelToolbar().getComponent("frommin").setValue(frMin);
		this.getTransactionsPanelToolbar().getComponent("tomin").setValue(toMin);			
		this.getTransactionsPanelToolbar().getComponent("fromhr").setValue(frHr);
		time_line_obj.endhr=arrOptions[3];
		this.getTransactionsPanelToolbar().getComponent("tohr").setValue(toHr);
		var chartToolbar=this.getTransactionsPanelToolbar();
	},
	enableDisableDateFields:function(enable){
		//  var chartToolbar=this.getTransactionsChartPanelToolbar();
		var chartToolbar=this.getTransactionsPanelToolbar();
		var startTimeField=chartToolbar.getComponent("from");
		var endTimeField=chartToolbar.getComponent("to");
		var fromCombo=chartToolbar.getComponent("fromhr");
		var toCombo=chartToolbar.getComponent("tohr");

		if(enable){
			startTimeField.setDisabled(false);
			endTimeField.setDisabled(false);
			fromCombo.setDisabled(false);
			toCombo.setDisabled(false);
		}else{
			startTimeField.setDisabled(true);
			endTimeField.setDisabled(true);
			fromCombo.setDisabled(true);
			toCombo.setDisabled(true);
		}
	},
	createHighStockChart:function(url,param){
		var seriesOptions = [],
		yAxisOptions = [],
		seriesCounter = 0;
		var title = "";
		var colors = "";
		var fmts = "";
		var axisTitle = "";
		var min = "";
		var max = "";
		var xmax = "";
		var xmin = "";
		var lineWidth = "";
		var TotalTd = 0;
		var cell_count=0;
		var itemsArray=[];
		var tdValues="";
		//var chartPanel=this.getTransactionsChartPanel();
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		var measures=chartPanel.jsonData.HiddenFields.measurelst;
		var measure_list_value=measures.split(",");
		var tab="Web";

		var firstCmp = Ext.getCmp('firstid');
		var midCmp = Ext.getCmp('midid');
		var lastCmp = Ext.getCmp('lastid');

		if(!Ext.isEmpty(errorPanel) && errorPanel==true)
		{
			chartPanel.update("");
			if(!Ext.isEmpty(firstCmp))
			chartPanel.remove(firstCmp);
			if(!Ext.isEmpty(midCmp))
			chartPanel.remove(midCmp);
			if(!Ext.isEmpty(lastCmp))
			chartPanel.remove(lastCmp);
		}
		var me = this;
		//var chartPnl=this.getTransactionsChartPanel();
		var chartPnl=Ext.getCmp('transactionschartpanelid');
		//chartPnl.setLoading(true,true);
		Ext.Ajax.request(
		{
			url : url,
			params:param,
			scope:this,
			timeout:6000000,
			success: function(response) 
			{	
				if(response.status == 200 && !Ext.isEmpty(response))
				{
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var data=Ext.decode(jsonText);
						if(!Ext.isEmpty(data))
						{
							var chartData=[];
							var htmlStr1='';
							var htmlStr2='';
							var htmlStrMid='';
							var itemsArray=[];
							var highChartUrls = new Array();
							var highChartIds = new Array();
							var highChartFmts = new Array();
							var highChartXmax = new Array();
							var highChartXmin = new Array();
							var highChartMax = new Array();
							var highChartAxislabel = new Array();
							var highChartSeriesOptions = new Array();
							var highChartTotalTd = new Array();
							var highChartColor = new Array();
							var highChartTitle = new Array();
							var size = 0;
							var tmp_div_size_of_td = 0;
							var itemInc = 0;
							for(var inc in data)
							{
								if(inc.indexOf("chart") > -1)
								size = size+1;
							}
							var graphPanel = Ext.getCmp("transactionschartpanelid");
							if(graphPanel != null && graphPanel != undefined && !Ext.isEmpty(graphPanel))
							{
								var graphEndRow = size%3;
								var graphRows =Math.floor(size/3); 
								var graphTotalRows = graphRows;
								if(graphEndRow >0)
									graphTotalRows = graphRows + 1;
								var graphHight = graphTotalRows * 300;
								graphPanel.setHeight(graphHight);
							}
							me.createDivforHighChart(size);
							if(size > 0 )
							{
								var styleAttrbs=new Object();
								styleAttrbs['fontFamily']='Arial';
								styleAttrbs['fontSize']='11px';
								
								styleAttrbs['axisLabelGridColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisLabelColor']= ( strSkin == 'Light' )?'#969696':'#c6c6c6';
								styleAttrbs['axisLabelFontFmy']='Arial';
								styleAttrbs['axisLabelFontSize']='11px';
								styleAttrbs['axisLabelLineColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisLabelMinorGrid']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisLabelTickColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisTitleColor']= ( strSkin == 'Light' )?'#606060':'#c0c0c0';
								styleAttrbs['axisTitleFontFmy']='Arial';
								styleAttrbs['axisTitleFontSize']='11px';


								styleAttrbs['TooltipFontFmy']='Arial';
								styleAttrbs['TooltipFontSize']='11px';
								styleAttrbs['TooltipBgColor']= ( strSkin == 'Light' )?'white':'#161616';
								styleAttrbs['TooltipBorderColor']= ( strSkin == 'Light' )?'black':'#0c0c0c';

								styleAttrbs['legendFontFmy']='Arial';
								styleAttrbs['legendFontSize']='12px';
								styleAttrbs['legendColor']= ( strSkin == 'Light' )?'#2a292a':'#c6c6c6';
								styleAttrbs['titleFontClr']=( strSkin == 'Light' )?'#2a292a':'#c6c6c6';
								styleAttrbs['titleFontFmy']='Roboto-Bold';
								styleAttrbs['titleFontSize']='13px';
								styleAttrbs['lineThickness']='2';

								var styleObj = data["styles"];
								/*if(!Ext.isEmpty(styleObj['axisLabelStyle']))
								{
								styleAttrbs['capFontClr'] = styleObj['axisLabelStyle'].COLOR;
								styleAttrbs['capFontFmy'] = styleObj['axisLabelStyle'].FAMILY;
								styleAttrbs['capFontSize'] = styleObj['axisLabelStyle'].SIZE;
								styleAttrbs['capFontWgt'] = styleObj['axisLabelStyle'].WEIGHT;
								}

								if(!Ext.isEmpty(styleObj['timeLabelStyle']))
								{
								styleAttrbs['xlabelfontClr'] = styleObj['timeLabelStyle'].COLOR;
								styleAttrbs['xlabelfontFmy'] = styleObj['timeLabelStyle'].FAMILY;
								styleAttrbs['xlabelfontSize'] = styleObj['timeLabelStyle'].SIZE;
								styleAttrbs['xlabelfontWgt'] = styleObj['timeLabelStyle'].WEIGHT;
								}
								if(!Ext.isEmpty(styleObj['panelLineStyle']))
								{
								styleAttrbs['plotPanelColor']=styleObj['panelLineStyle'].COLOR;
								styleAttrbs['lineThickness']=styleObj['panelLineStyle'].LINETHICKNESS;
								}*/

								for(var mainKey in data)
								{
									var dataOfKey = data[mainKey];
									if( mainKey != "styles" && mainKey != 'chartKey' && dataOfKey.indexOf("^eg^") == -1)
									{
										for ( var key in dataOfKey )
										{
											if(!isNaN(key))
											{
												title = dataOfKey[key]['title'];
												fmts = dataOfKey[key]['fmts'];
												axisTitle = dataOfKey[key]['axislabel'];
												xmax = dataOfKey[key]['xmax'];
												xmin = dataOfKey[key]['xmin'];
												max = dataOfKey[key]['max'];
												colors = dataOfKey[key]['color'],
												lineWidth = dataOfKey[key]['lineWidth'],
												seriesOptions[key] =
												{
													name: dataOfKey[key]['name'],
													data: dataOfKey[key]['data'],
													color: dataOfKey[key]['color'],
													dataGrouping: {
													enabled: false
													}
												};
											}
											highChartColor.push(colors);
										}
										highChartTitle.push(title);
										highChartFmts.push(fmts);
										highChartXmax.push(xmax);
										highChartXmin.push(xmin);
										highChartMax.push(max);
										highChartAxislabel.push(axisTitle);
										highChartSeriesOptions.push(seriesOptions);
										highChartTotalTd.push(TotalTd);
										//highChartColor.push(colors);
										//if(TotalTd == 3)
										if(TotalTd == 3 || (this.tab=="emulated" && TotalTd ==1) ) //fix for emulated legends
										{
											var Legend_Total = seriesOptions.length;
											var tdValues="<table align='right'style='margin-top:-10px;'><tr>";
											var padRight="";
											if(Legend_Total!=null && Legend_Total!='')
											{
												//console.log("Legend_Total-------------"+Legend_Total)
												for(var z=0;z<Legend_Total;z++)
												{
													console.log("Legend_Total-------------"+z)
													if (z!=(Legend_Total-1))
													{
														padRight="15px";
													}
													else
													{
														padRight="0px";
													}
													
	
													var LegendTdName    =seriesOptions[z].name;
													if(LegendTdName!=null && LegendTdName.indexOf("^")>-1)
													{
														var trans_name_temp=LegendTdName.substring(0,LegendTdName.lastIndexOf("^"));
														//var color_code_temp=LegendTdName.substring(LegendTdName.lastIndexOf("^")+1);
														tdValues=tdValues+"<td width='10' height='10' align='center'>";
														tdValues=tdValues+"<table cellpadding='0' cellspacing='1' border='0'>";
														tdValues=tdValues+"<tr>";
														//tdValues=tdValues+"<td width = '10' style='background:#"+color_code_temp+"' class='linesquare_white' height='10'><img src = '/final/monitor/eg_images/spacer.gif' width = '10' height = '10' border = '0'></td></tr></table></td>";
														tdValues=tdValues+"<td nowrap style='width:40px;padding-right:10px; height:10px' >"+trans_name_temp+"</td>";
													}
													else
													{
														tdValues=tdValues+"<td width='10' height='10' align='center'>";
														tdValues=tdValues+"<table cellpadding='0' cellspacing='1' border='0'>";
														tdValues=tdValues+"<tr>";
														tdValues=tdValues+"<td width = '10' style='vetical-align:top' class='linesquare_white' height='5'><div style='background:"+highChartColor[z]+";height:8px;width:8px' ><div></td></tr></table></td>";
														tdValues=tdValues+"<td nowrap class='font_normal11' style='padding-left:5px;padding-right:"+padRight+"; height:35px' >"+LegendTdName+"</td>";
													}
												}
											}
											tdValues = tdValues+"</tr></table>";
											var legContainer = Ext.get('legends');
											if(!Ext.isEmpty(legContainer))
											{
											Ext.getCmp('legends').update(tdValues);
											}
										}
										if(!Ext.isEmpty(chartPnl.isNotAreaChart))
											loadTransHCGrap(seriesOptions,TotalTd,axisTitle,fmts,'',max,xmax,xmin,lineWidth,styleAttrbs,true);
										else
											loadTransHCGrap(seriesOptions,TotalTd,axisTitle,fmts,'',max,xmax,xmin,lineWidth,styleAttrbs);
										Ext.getCmp('transchart'+TotalTd).setTitle('<span style="margin-top:20px;display:block;text-align:center" class="font_bold13 fontStyleRobot">'+title+'</span>');
										TotalTd = TotalTd+1;
										itemInc = itemInc+1;
										if(!Ext.isEmpty(chartPanel.getEl()) && chartPanel.getEl() != null && chartPanel.getEl() != 'undefined')
										{
											chartPanel.getEl().unmask();
											//chartPnl.setLoading(false);
										}
									}
									else
									{
										if(  mainKey != "styles" && mainKey != 'chartKey' && dataOfKey.indexOf("^eg^") > -1 )
										{
											var myImgHtml = '<div style="margin:7% 20% auto 30%"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></div>';
											if( itemInc < size )
											{
												var timTitle = dataOfKey.substring(4);
												Ext.getCmp('transchart'+itemInc).setTitle('<span style="margin-top:20px;display:block;text-align:center" class="font_bold13 fontStyleRobot">'+timTitle+'</span>');
												Ext.getCmp('transchart'+itemInc).update(myImgHtml);
												itemInc = itemInc+1;
												TotalTd = TotalTd+1;
											}
										}
										//chartPnl.setLoading(false);
									}
								}
								errorPanel = false;
							}
							else
							{
							this.displayErrorMsg();
							}
							errorPanel = false;
						}
						else
						{
						this.displayErrorMsg();
						}
						errorPanel = false;
					}
					else
					{
						this.displayErrorMsg();
					}
				}
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	displayErrorMsg:function(){
		errorPanel = true;
		//var chartPanel=this.getTransactionsChartPanel();
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		
		var htmlStr='<table width="100%" height="100%"><tr style="text-align:center;" width="100%" height="100%"><td width="100%" height="100%">';
		//htmlStr+='<img hspace = "0" vspace = "0" border = "0" align = "center" valign="middle" src="/final/monitor/eg_images/'+chartPanel.jsonData.HiddenFields.monitorSkin+'/nographformeasure.gif">';
		htmlStr+='<div style="text-align:center"><div class="iconInformation" style="margin:0px auto"></div><div class="font_normal11">No measure available for the current selection</div></div>'
		htmlStr+='</td></tr></table>';
		chartPanel.setHeight(screen.height-465);
		chartPanel.setLoading(false);
		chartPanel.removeAll();
		//chartPanel.setHeight(Ext.getBody().getViewSize().height-280);
		var errPanel=Ext.create('Ext.panel.Panel',
			{
				//height:180,
				layout:'fit',
				//id:'errID',
				//height:Ext.getBody().getViewSize().height-330,
				html:htmlStr
		});
		chartPanel.add(errPanel);
		//chartPanel.update(htmlStr);
	},
	getCurrentDateTime:function(){
		var endHr="";
		var startHr="";
		var starttime="";
		var endtime="";
		var time_line ="";
		var retDate = "";
		//var chartToolbar=this.getTransactionsChartPanelToolbar();
		var chartToolbar=this.getTransactionsPanelToolbar();
		var timelineCombo=chartToolbar.getComponent("timeline");
		if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
			  time_line=timelineCombo.getValue();
		  }
		 var startTimeField=chartToolbar.getComponent("from");
		  if(!Ext.isEmpty(startTimeField)){
			  if(!startTimeField.isDisabled()  && !Ext.isEmpty(startTimeField.getValue())){
				  starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  starttime=time_line_obj.starttime;
				  }else{
					  starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
				  }
			  }
		  }
		  
		  var endTimeField=chartToolbar.getComponent("to");
		  if(!Ext.isEmpty(endTimeField)){
			  if(!endTimeField.isDisabled()  && !Ext.isEmpty(endTimeField.getValue())){
			  endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  endtime=time_line_obj.endtime;
				  }else{
					  endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
				  }
			  }
		  }
		
		var fromCombo=chartToolbar.getComponent("fromhr");
		if(!Ext.isEmpty(fromCombo))
			{
			  if(!fromCombo.isDisabled() && !Ext.isEmpty(fromCombo.getValue())){
				startHr=fromCombo.getValue();
				 
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  startHr=time_line_obj.starthr;
					   
				  }else{
						startHr=fromCombo.getValue();
					}
			}
		}

		  var toCombo=chartToolbar.getComponent("tohr");
		  if(!Ext.isEmpty(toCombo)){
			  if(!toCombo.isDisabled() && !Ext.isEmpty(toCombo.getValue())){
				  endHr=toCombo.getValue();
			}else{
				  if(!Ext.isEmpty(time_line_obj)){
						endHr=time_line_obj.endhr;
				  }else{
						endHr=toCombo.getValue();
				  }
			  }
		  }
		if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(endTimeField)){
			starttime = Ext.Date.dateFormat(startTimeField.getValue(), 'm/d/Y');
			endtime = Ext.Date.dateFormat(endTimeField.getValue(), 'm/d/Y');
			retDate = time_line+":"+starttime+":"+startHr+":"+endtime+":"+endHr;
		}
		return retDate;
	},
	displayGraph:function(){
		var cdate = this.getCurrentDateTime();
		var chartOption = "highcharts";
		if(chartOption.indexOf("highchart") > -1)
		{
			//this.getTransactionChartComboMode().hide();
			this.getTransactionComboMode().hide();
		}
		else
		{
			//this.getTransactionChartComboMode().hide();
			this.getTransactionComboMode().hide();
		}
		//var chartPanel=this.getTransactionsChartPanel();
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		if(!Ext.isEmpty(chartPanel) && !Ext.isEmpty(chartPanel.jsonData)){
			var jsonData=chartPanel.jsonData;
			var mode="";
			var starttime="";
			var endtime="";
			var startHr="";
			var startMin="";
			var endHr="";
			var endMin="";
			var time_line="";
			var dateError = '';
			//  var chartToolbar=this.getTransactionsChartPanelToolbar();
			var chartToolbar=this.getTransactionsPanelToolbar();
			var modeCombo=chartToolbar.getComponent("mode");
			if(!Ext.isEmpty(modeCombo) && !Ext.isEmpty(modeCombo.getValue())){
				mode=modeCombo.getValue();
			}
			var startTimeField=chartToolbar.getComponent("from");
			if(!Ext.isEmpty(startTimeField)){
				if(!startTimeField.isDisabled()  && !Ext.isEmpty(startTimeField.getValue())){
				starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						starttime=time_line_obj.starttime;
					}else{
						starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
					}
				}
			}

			var endTimeField=chartToolbar.getComponent("to");
			if(!Ext.isEmpty(endTimeField)){
				if(!endTimeField.isDisabled()  && !Ext.isEmpty(endTimeField.getValue())){
				endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						endtime=time_line_obj.endtime;
					}else{
						endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
					}
				}
			}

			var fromCombo=chartToolbar.getComponent("fromhr");
			if(!Ext.isEmpty(fromCombo)){
				if(!fromCombo.isDisabled() && !Ext.isEmpty(fromCombo.getValue())){
					startHr=fromCombo.getValue();
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						startHr=time_line_obj.starthr;
					}else{
						startHr=fromCombo.getValue();
					}
				}
			}

			var toCombo=chartToolbar.getComponent("tohr");
			if(!Ext.isEmpty(toCombo)){
				if(!toCombo.isDisabled() && !Ext.isEmpty(toCombo.getValue())){
					endHr=toCombo.getValue();
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						endHr=time_line_obj.endhr;
					}else{
						endHr=toCombo.getValue();
					}
				}
			}			

			//Get Minutes
			var startMin="";
			var fromMinCombo=chartToolbar.getComponent("frommin");
			if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo.getValue())){
				startMin=fromMinCombo.getValue();
			}			

			var endMin="";
			var toMinCombo=chartToolbar.getComponent("tomin");
			if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo.getValue())){
				endMin=toMinCombo.getValue();
			}

			//

			// var timeLineCombo=this.getTransactionChartComboTimeline();
			var timeLineCombo=this.getTransactionComboTimeline();
			if(timeLineCombo.getValue() =="Any"){
				var dateError = startTimeField.getName();
				var currentDateError = endTimeField.getName()
				var startTime = startTimeField.getValue();
				var endTime = endTimeField.getValue();
				var curTime = curDateTime;
				var currentMgrDate = new Date(curTime);

				var starttime= formatDate(startTime, "MM/dd/yyyy");
				var endtime= formatDate(endTime, "MM/dd/yyyy");

				if(dateValidation(starttime,endtime,parseInt(startHr),parseInt(endHr),0,0)==-1)
				{
					//var msg ="From date should be lesser than to date";
					Ext.Msg.alert('Error', dateError);
					return;
				}


				/*if((startTime > currentMgrDate )|| (endTime > currentMgrDate)){
				Ext.Msg.alert('Error', currentDateError);
				return;
				}
				if(startTimeField.getValue() > endTimeField.getValue()){
				Ext.Msg.alert('Error', dateError);
				return;
				}
				else if(startTimeField.getValue().getDate()==endTimeField.getValue().getDate()&&startTimeField.getValue().getMonth()==endTimeField.getValue().getMonth()&&startTimeField.getValue().getFullYear()==endTimeField.getValue().getFullYear()){
				if(startHr>=endHr){
				Ext.Msg.alert('Error', dateError);
				return;
				}
				}*/
			}

			this.anyStartTime=starttime;
			this.anyEndTime=endtime;
			this.anyStartHr=startHr;
			this.anyEndHr=endHr;
			var timelineCombo=chartToolbar.getComponent("timeline");
			if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
				time_line=timelineCombo.getValue();
			}
			//var chartPanel=this.getTransactionsChartPanel();
			var chartPanel=Ext.getCmp('transactionschartpanelid');

			var cdate = this.getCurrentDateTime();
			var chartOption = "highcharts";
			//var mgr_dateFormat = 'M d, Y';
			this.transactionMeasuresParam={
				startTrans:'',
				site:jsonData.HiddenFields.siteName,
				comp:jsonData.HiddenFields.compName,
				test:jsonData.HiddenFields.testForTab,
				measure:jsonData.HiddenFields.measurelst,
				gformat:"graph",
				chartType:chartOption,
				GraphSize:"true",
				monitorSkin:jsonData.HiddenFields.monitorSkin,
				mode:'2D',
				starttime:startTimeField.getRawValue(),
				endtime:endTimeField.getRawValue(),
				starthr:startHr,
				endhr:endHr,
				startmin:startMin,
				endmin:endMin,
				time_line:time_line,
				all_trans_names:jsonData.HiddenFields.all_trans_names,
				msmt_host:jsonData.HiddenFields.mHost,
				endTrans:'',
				//isAreaChart:true,
				isAreaChart:isAreaChart,
				isLogonType:isLogonType
			};

			// this.getTransactionChartComboMode().show();
			if(chartOption.indexOf("highchart") > -1)
			{
				this.createHighStockChart(this.transactionMeasuresChartURL,this.transactionMeasuresParam);
				// this.getTransactionChartComboMode().hide();
				this.getTransactionComboMode().hide();
			}
			else
			{
				// this.getTransactionChartComboMode().hide();
				this.getTransactionComboMode().hide();
				chartPanel.getEl().mask("Loading...");
					Ext.Ajax.request({
					url : this.transactionMeasuresChartURL,
					params: this.transactionMeasuresParam,
					method:'get',
					scope:this,
					success: function(response){
						var chartPnl=Ext.getCmp('transactionschartpanelid');
						chartPnl.getEl().unmask();
						this.createGraphs(response);
					},
					failure:function(){
						var chartPnl=Ext.getCmp('transactionschartpanelid');
						chartPnl.getEl().unmask();
					}
				});
			}
		}
	},
	displayGraphInitially:function(jsonData){	    	  
		var  mode=jsonData.HiddenFields.mode
		var  starttime=jsonData.HiddenFields.starttime
		var  endtime=jsonData.HiddenFields.endtime
		var  starthr=jsonData.HiddenFields.startHr
		var  endhr=jsonData.HiddenFields.endHr
		var  time_line=jsonData.HiddenFields.timeline
		var  startmin = jsonData.HiddenFields.startMin
		var  endmin = 	 jsonData.HiddenFields.endMin
		var cdate = this.getCurrentDateTime();
		var chartOption = "highcharts";

		if(requestParams.refresh==true){
			mode=requestParams.mode
			starttime=jsonData.HiddenFields.starttime
			endtime=jsonData.HiddenFields.endtime
			starthr=jsonData.HiddenFields.startHr
			endhr=jsonData.HiddenFields.endHr
			startmin = jsonData.HiddenFields.startMin
			endmin=jsonData.HiddenFields.endMin
			time_line=requestParams.timeline
		}
		if(isRefreshing)
		{
			if(timeLineValueForRefresh != null && timeLineValueForRefresh != '' && timeLineValueForRefresh != undefined)
			{
				if(timeLineValueForRefresh != 'Any')
					time_line = timeLineValueForRefresh;
				else if(timeLineValueForRefresh == 'Any')
				{	
					time_line = timeLineValueForRefresh;

					if(fromDateValueForRefresh != null && fromDateValueForRefresh != '' && fromDateValueForRefresh != undefined)
						starttime = fromDateValueForRefresh;
					
					if(toDateValueForRefresh != null && toDateValueForRefresh != '' && toDateValueForRefresh != undefined)
						endtime = toDateValueForRefresh;
					
					if(fromHrValueForRefresh != null && fromHrValueForRefresh != '' && fromHrValueForRefresh != undefined)
						starthr = fromHrValueForRefresh;

					if(toHrValueForRefresh != null && toHrValueForRefresh != '' && toHrValueForRefresh != undefined)
						endhr = toHrValueForRefresh;

					if(fromMinValueForRefresh != null && fromMinValueForRefresh != '' && fromMinValueForRefresh != undefined)
						startmin = fromMinValueForRefresh;

					if(toMinValueForRefresh != null && toMinValueForRefresh != '' && toMinValueForRefresh != undefined)
						endmin = toMinValueForRefresh;
				}
			}
		}
		if(!Ext.isEmpty(starttime) && !Ext.isEmpty(endtime))
		{
			starttime=Ext.Date.format(new Date(starttime),mgrDateFormat);
			endtime=Ext.Date.format(new Date(endtime),mgrDateFormat);	
		}
		this.transactionMeasuresParam={
			site:jsonData.HiddenFields.siteName,
			comp:jsonData.HiddenFields.compName,
			test:jsonData.HiddenFields.testForTab,
			measure:jsonData.HiddenFields.measurelst,
			gformat:"graph",
			GraphSize:"true",
			monitorSkin:jsonData.HiddenFields.monitorSkin,
			mode:'2D',
			starttime:starttime,
			endtime:endtime,
			starthr:starthr,
			startmin:startmin,

			//starthr:startHr,
			endhr:endhr,
			endmin:endmin,
			time_line:time_line,
			all_trans_names:jsonData.HiddenFields.all_trans_names,
			msmt_host:jsonData.HiddenFields.mHost,
			//isAreaChart:true,
			isAreaChart:isAreaChart,
			isLogonType:isLogonType
		};
		if(!Ext.isEmpty(jsonData.HiddenFields)){
			var cdate = this.getCurrentDateTime();
			//  this.getTransactionChartComboMode().hide();
			var chartOption = "highcharts";
			if(chartOption != null){
				if(chartOption.indexOf("highchart") > -1)
				{
					// this.getTransactionChartComboMode().hide();
					this.getTransactionComboMode().hide();
					this.createHighStockChart(this.transactionMeasuresChartURL,this.transactionMeasuresParam);
				}
				else
				{
				//  this.getTransactionChartComboMode().hide();
				this.getTransactionComboMode().hide();
				var chartPnl=this.getTransactionsChartPanel();
				//chartPnl.setLoading(true,true);
				Ext.Ajax.request({
					url : this.transactionMeasuresChartURL,
					params:this.transactionMeasuresParam,
					scope:this,
					success: function(response){
						this.createGraphs(response);
						//chartPnl.setLoading(false);
					},
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});
				}
			}
		}
	},
	compFilterByComboOnChange:function(combo){
		var userName=requestParams.userName;		
		var selectedRum = titleApplies;
				if(rumPageParams.serviceCombo[0].rumcomboNeeded)
					selectedRum = rumPageParams.serviceCombo[0].selectedRum;
		//var hostType=combo.getValue();
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}
		if(selectedCompType != null && selectedCompType !='null' && selectedCompType !=undefined && selectedCompType !='undefined' && selectedCompType != '')
		{
			componentTypeVal = selectedCompType;
		}
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=Ext.getCmp('perPanel').itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&isRumComp=true";
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
		}

		url=url+"&filterBy="+filterByComboVal;

		if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
			url=url+"&timeline="+timeline;
		
		var subFilterComboObj = Ext.getCmp('subFilterCombo');
		var isOthers=false;

		url=url+"&isfromCitrix=&isfromRum=true&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;

		if(filterByComboVal=='Component' || filterByComboVal=='System' ||  filterByComboVal=='Network')
		{
			subFilterComboObj.hide();
			isOthers = true;
		}
		else
		{
			//subFilterComboObj.show();
		}

		sortState="";
		DirProperty="";
		
		if(isOthers)
		{
			Ext.getCmp('perPanel').loadTab(url,'','','','','','rumAppFlowComponent');
			Refurl=url;
		}
		else
		{
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					subFilterComboObj.getStore().loadRawData(jsonData.subFilterOptions);
					subFilterComboObj.setValue(jsonData.pageParams.selectedSubFilterOption);
					subFilterComboObj.setFieldLabel(jsonData.pageParams.subFilterLabel);
					subFilterComboObj.show();
				}
			});
		}
	},	
	compSubFilterComboOnChange:function(combo){
		var userName=requestParams.userName;
		
		var selectedRum = titleApplies;
			if(rumPageParams.serviceCombo[0].rumcomboNeeded)
				selectedRum = rumPageParams.serviceCombo[0].selectedRum;
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}
		
		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}
		if(selectedCompType != null && selectedCompType !='null' && selectedCompType !=undefined && selectedCompType !='undefined' && selectedCompType != '')
		{
			componentTypeVal = selectedCompType;
		}
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=Ext.getCmp('perPanel').itemId;
		
		sortState="";
		DirProperty="";
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal);
			var url = url;
			url=url+"&isfromCitrix=&isfromRum=true&appliesTo="+requestParams.appliesTo;
			Refurl=url;
			Ext.getCmp('perPanel').loadTab(url,'','','','','','rumAppFlow');
		}
		else if(itemIdVal=='components' || itemIdVal=='Components' )
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal);
			if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
				url=url+"&timeline="+encodeURIComponent(timeline);
			url=url+"&isfromCitrix=&isfromRum=true&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone+"&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&isRumComp=true";
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var componentTypCombo = Ext.getCmp('componentTypCombo');
					componentTypCombo.getStore().loadRawData(jsonData.componentTypeOptions);
					if(selectedCompType != null && selectedCompType !='null' && selectedCompType !=undefined && selectedCompType !='undefined' && selectedCompType != '')
					{
						 componentTypCombo.setValue(selectedCompType);
					}
					else
					{
						componentTypCombo.setValue(jsonData.componentTypeOptions.selectedComponentType);
					}
					componentTypCombo.setFieldLabel(jsonData.componentTypeOptions.componentTypeLabel);
				}
			});
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal);
			if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
				url=url+"&timeline="+encodeURIComponent(timeline);
			url=url+"&isfromCitrix=&isfromRum=true&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var componentTypCombo = Ext.getCmp('componentTypCombo');
					componentTypCombo.getStore().loadRawData(jsonData.componentTypeOptions);
					if(selectedCompType != null && selectedCompType !='null' && selectedCompType !=undefined && selectedCompType !='undefined' && selectedCompType != '')
					{
						 componentTypCombo.setValue(selectedCompType);
					}
					else
					{
						componentTypCombo.setValue(jsonData.componentTypeOptions.selectedComponentType);
					}
					componentTypCombo.setFieldLabel(jsonData.componentTypeOptions.componentTypeLabel);
				}
			});
		}
	},
	componentTypeComboOnChange:function(combo)
	{
		var selectedRum = titleApplies;
		if(rumPageParams.serviceCombo[0].rumcomboNeeded)
			selectedRum = rumPageParams.serviceCombo[0].selectedRum;
		var treeFlag_SBD=requestParams.treeFlag_SBD;
		var outsideService_SBD=requestParams.outsideService_SBD;
		var titleText_SBD = requestParams.titleText_SBD;
		var selectNode_SBD = requestParams.selectNode_SBD;
		var isEmulTrans_SBD = requestParams.isEmulTrans_SBD;
		var serviceState_SBD = requestParams.serviceState_SBD;
		var serviceName = requestParams.serviceName;
		var serviceState = requestParams.serviceState;
		var isServiceBusiDash = requestParams.isServiceBusiDash;

		var userName=requestParams.userName;
		var stateName=requestParams.stateName;
		stateName=(stateName==null || stateName==undefined || stateName=='null')?"":stateName;
		var fromPageView=requestParams.fromPageView;
		var componentTypeVal=combo.getValue();
			compListType=componentTypeVal;
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined)
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined)
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}
		
		var menuObj = Ext.getCmp('rumappmenu_view_id');
		var filterr = requestParams.filter;
		if(filterr == "Service")
			filterr = "services";

		var store_data=menuObj.getStore();
		var forceKey=menuObj.forceClickKey;
		var selected_view_name="";
		for(var k=0;k<store_data.getCount();k++)
		{
			var caption_value=store_data.getAt(k).data.caption;
			if(requestParams.activeViewIndex==k)
			{
				selected_view_name=store_data.getAt(k).data.name;
				break;
			}
		}

		var url="";
		var itemIdVal=Ext.getCmp('perPanel').itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			//url="/final/monitor/comparisonComponent.jsp?treeTitle=Component&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&isRumComp=true";
			url = '/final/monitor/comparisonComponent.jsp?treeTitle=rumcomponents&selectedState=&componentNameSearch=&fromPageView=CitrixDashboard&viewPageTitle=Components&action=component&fromHomepage=&userName='+requestParams.user_name+'&filterBy='+filterr+'&subFilter='+requestParams.filterBy+'&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+"&dashboard_name=rum_Dashboard&view_name=metrics_View&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&isFromZone="+backParams.isFromZone+"&iszoneName="+encodeURIComponent(backParams.iszoneName)+"&parentZone="+encodeURIComponent(backParams.parentZone)+"&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&isRumComp=true";
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network&isfromCitrix=false&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=rum_Dashboard&view_name=metrics_View&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&isFromZone="+backParams.isFromZone+"&iszoneName="+encodeURIComponent(backParams.iszoneName)+"&parentZone="+encodeURIComponent(backParams.parentZone);
		}

		//url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentType="+encodeURIComponent(componentTypeVal)+"&componentNameSearch="+nickNameVal+"&fromPageView="+fromPageView;

		url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURI(subFilterComboVal)+"&componentType="+encodeURI(componentTypeVal)+"&componentNameSearch=&fromPageView="+fromPageView+"&userName="+encodeURI(userName)+"&selectedState="+stateName;
		sortState="";
		DirProperty="";
		if(!Ext.isEmpty(requestParams.isServiceBusiDetails) && requestParams.isServiceBusiDetails!=undefined && requestParams.isServiceBusiDetails!=null)
			url = url +"&isServiceBusiViewMetrics="+requestParams.isServiceBusiDetails + '&treeFlag_SBD='+treeFlag_SBD+'&outsideService_SBD='+outsideService_SBD+'&titleText_SBD='+titleText_SBD+'&selectNode_SBD='+selectNode_SBD+'&serviceFromZone='+serviceName+'&isEmulTrans_SBD='+isEmulTrans_SBD+'&serviceName='+serviceName+'&serviceState_SBD='+serviceState_SBD+'&isServiceBusiDash='+isServiceBusiDash;

		if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
			url=url+"&timeline="+encodeURIComponent(timeline);
		
		var selected_dash = '';
		if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
			selected_dash = Ext.getCmp('dashListComId').getValue();

		//url=url+"&isfromCitrix=true&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=rum_Dashboard&view_name=metrics_View&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;

		Refurl=url;
		Ext.getCmp('perPanel').loadTab(url,'','','','','','rumAppFlowComponent');
	},
	systemsComboChange:function(combo)
	{	
		var systemView_containerObj = Ext.getCmp('systemViewMeasuresgridpanel');
		var filterr = requestParams.filter;
		if(filterr == "Service")
			filterr = "services";

		SysComponentType = combo.getValue(); 

		var selectedRum = titleApplies;
		if(rumPageParams.serviceCombo[0].rumcomboNeeded)
			selectedRum = rumPageParams.serviceCombo[0].selectedRum;

		var urlt = "/final/monitor/serviceSystem.jsp?treeTitle=services&selectNode=Service$cap$"+encodeURIComponent(requestParams.filterBy)+"&selectedParam="+encodeURIComponent(requestParams.filterBy)+"&componentType="+encodeURI(SysComponentType)+"&currentTab=Systems&isSite=true&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&refresh=true&action=Systems&topoSegment="+encodeURIComponent(requestParams.filterBy)+'&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&hasRUM=true&dashboard_name=RUM_Dashboard&view_name=systems_View&fromServiceHomePage=true&isFromZone='+backParams.isFromZone+"&iszoneName="+encodeURIComponent(backParams.iszoneName)+"&parentZone="+encodeURIComponent(backParams.parentZone)+"&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;

		systemView_containerObj.loadTab(urlt,'rumAppFlowSystem');		
	},
	compSubmitButtonClicked:function()
	{
		componentNameSearch = "";
		var selectedRum = titleApplies;
			if(rumPageParams.serviceCombo[0].rumcomboNeeded)
				selectedRum = rumPageParams.serviceCombo[0].selectedRum;
		var fromPageView=requestParams.fromPageView;
		var userName=requestParams.userName;
		var stateName=requestParams.stateName;
		stateName=(stateName==null || stateName==undefined || stateName=='null')?"":stateName;
		if(stateName==null || stateName==undefined || stateName=='')
		{
			stateName = requestParams.selectedState;
		}
		stateName=(stateName==null || stateName==undefined || stateName=='null')?"":stateName;
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined)
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}
		if(selectedCompType != null && selectedCompType !='null' && selectedCompType !=undefined && selectedCompType !='undefined' && selectedCompType != '')
		{
			componentTypeVal = selectedCompType;
		}
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}
		var sortByComboVal="";
		if(Ext.getCmp('sortByCombo')!=null && Ext.getCmp('sortByCombo')!=undefined && Ext.getCmp('sortByCombo').getValue()!=null && Ext.getCmp('sortByCombo').getValue()!='null')
		{
			sortByComboVal = Ext.getCmp('sortByCombo').getValue();
		}
		var url="";
		var itemIdVal=Ext.getCmp('perPanel').itemId;

		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&viewPageTitle="+encodeURIComponent(requestParams.viewPageTitle);
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentType="+encodeURIComponent(componentTypeVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&fromPageView="+fromPageView+"&userName="+encodeURIComponent(userName)+"&selectedState="+stateName+"&viewPageTitle="+encodeURIComponent(requestParams.viewPageTitle)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+encodeURIComponent(backParams.iszoneName)+"&parentZone="+encodeURIComponent(backParams.parentZone)+"&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&isRumComp=true";
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentType="+encodeURIComponent(componentTypeVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&fromPageView="+fromPageView+"&userName="+encodeURIComponent(userName)+"&selectedState="+stateName+"&viewPageTitle="+encodeURIComponent(requestParams.viewPageTitle);
		}

		/*if(!Ext.isEmpty(isServiceBusiViewMetrics) && isServiceBusiViewMetrics!=null && isServiceBusiViewMetrics!=undefined && (isServiceBusiViewMetrics=='true'||isServiceBusiViewMetrics==true))
			url = url +"&isServiceBusiViewMetrics="+isServiceBusiViewMetrics;*/

		if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
			url=url+"&timeline="+encodeURIComponent(timeline);
		
		var url = url;

		var selected_dash = '';
		if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
			selected_dash = Ext.getCmp('dashListComId').getValue();
		
		var menuObj = Ext.getCmp('rumappmenu_view_id');

		var store_data=menuObj.getStore();
		var forceKey=menuObj.forceClickKey;
		var selected_view_name="";
		for(var k=0;k<store_data.getCount();k++)
		{
			var caption_value=store_data.getAt(k).data.caption;
			if(requestParams.activeViewIndex==k)
			{
				selected_view_name=store_data.getAt(k).data.name;
				break;
			}
		}

		url=url+"&isfromCitrix=&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=rum_Dashboard&view_name=metrics_View&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&isFromZone="+backParams.isFromZone+"&iszoneName="+encodeURIComponent(backParams.iszoneName)+"&parentZone="+encodeURIComponent(backParams.parentZone);
		Refurl=url;
		Ext.getCmp('perPanel').loadTab(url,'','','','','','rumAppFlowComponent');
	},
	backButtonHandler:function(){
		try
		{	
			var parentZone = backParams.parentZone;
			var iszoneName = backParams.iszoneName;
			var treeTitle = backParams.treeTitle;
			var monitorsBy = backParams.monitorsBy;
			var ltest = backParams.ltest;
			var fromHomepage = backParams.fromHomepage;
			var tempLogonType = backParams.tempLogonType;
			if(!Ext.isEmpty(backParams) && backParams != undefined && backParams != null)
			{
				var isBackFromRUM = false;
				var isFromZone = false;
				
				if(isFromLayerModel && isFromZoneMenu)
				{
					document.location="/final/monitor/zoneDash.jsp?&selectNode=Zone$cap$"+encodeURIComponent(iszoneName)+"&selectedParam="+encodeURIComponent(iszoneName)+"&currentTab=details&zoneName="+encodeURIComponent(iszoneName)+"&iszoneName="+encodeURIComponent(iszoneName)+"&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage="+fromHomepage+"&parentZone="+encodeURIComponent(parentZone)+"&fromPageView=&fromZoneMenu="+isFromZoneMenu;
					return;
				}
				else if(isFromLayerModel && tempLogonType!= null && (tempLogonType=='true' || tempLogonType=='false'))
				{
					document.location="/final/monitor/comparisonDashboard.jsp?treeTitle="+treeTitle+"&isFromMenu=true&isLogonType="+tempLogonType+"&monitorsBy="+monitorsBy+"&ltest="+ltest;
					return;
				}
				else if(isFromLayerModel && fromHomepage!= null && fromHomepage == "true")
				{
					if(iszoneName!= null && iszoneName!='null' && !Ext.isEmpty(iszoneName))
					{
						document.location="/final/monitor/zoneDash.jsp?&selectNode=Zone$cap$"+encodeURIComponent(iszoneName)+"&selectedParam="+encodeURIComponent(iszoneName)+"&currentTab=details&zoneName="+encodeURIComponent(iszoneName)+"&iszoneName="+encodeURIComponent(iszoneName)+"&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage="+fromHomepage+"&parentZone="+encodeURIComponent(parentZone)+"&fromPageView=&fromZoneMenu="+isFromZoneMenu;
						return;
					}
					else
					{
						document.location="/final/servlet/com.eg.EgMonitorController?monCmd=dashboard";
						return;
					}
				}
				else if(isFromLayerModel && isFromServiceMenu)
				{
					document.location= "/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true";
					return;
				}
				else if(isFromLayerModel && isFromServiceGroup)
				{
					document.location="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=serviceGroup&isFromMenu=true";	
					return;
				}
				
				if(backParams.isBackFromRUM != undefined && backParams.isBackFromRUM != null && backParams.isBackFromRUM == "true")
					isBackFromRUM = true;				
				
				if(backParams.isFromZone != undefined && backParams.isFromZone != null && backParams.isFromZone == "true")
					isFromZone = true;
				
				if((isFromZone && !isFromZoneMain) || (isFromZone && !isFromZoneMain && ((parentZone !=null && parentZone != 'null' && parentZone != undefined && parentZone != 'undefined' && parentZone !='') ||(iszoneName !=null && iszoneName != 'null' && iszoneName != undefined && iszoneName != 'undefined' && iszoneName !=''))))
				{
					document.location='/final/monitor/zoneDash.jsp?&selectNode=Zone$cap$'+encodeURIComponent(backParams.iszoneName)+'&selectedParam='+encodeURIComponent(backParams.iszoneName)+'&currentTab=details&zoneName='+encodeURIComponent(backParams.iszoneName)+'&iszoneName='+encodeURIComponent(backParams.iszoneName)+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage=true&parentZone='+encodeURIComponent(backParams.parentZone)+'&fromZoneMenu='+isFromZoneMenu;
				}
				else if(isBackFromRUM && !isFromServiceMenu && !isFromZoneMain && !isFromServiceGroup)
				{
					document.location="/final/monitor/realUserMonitorsDashboard.jsp";
				}
				else if(isFromServiceMenu && !isFromZoneMain)
				{
					document.location="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true";					
				}
				else if(isFromZoneMain)
				{
					document.location="/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true";					
				}
				else if(isFromServiceGroup)
				{
					document.location="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=serviceGroup&isFromMenu=true";	
				}
				else if(isFromCompDetailsWin)
				{
					 window.location.href="/final/servlet/com.eg.EgDashboardController?site=NULL&from=list&comptype="+hostType+"&host="+hostName+"&tab=LayerModel&fromHomepage=true";
				}
				else
				{
					document.location="/final/servlet/com.eg.EgMonitorController?monCmd=dashboard";
				}
			}
		}
		catch (w)
		{
		}
	},
	onComponentTypeChange:function(combo,activeTab,siteName,componentType,selected_view_name){
		var selCompType='';
		var selSimulation = '';
		var selAgent='';
		var temLogonParam = '';
		var selSimulOrg = '';
		var comboVal = '';

		if(combo != null && combo != '' && combo != undefined)
		{
			comboVal = combo.getValue();
		}
		else if(singleComponentTypeValue != '' && singleComponentTypeValue != null && singleComponentTypeValue != undefined)
		{
			comboVal = singleComponentTypeValue;
		}
		if(activeTab != null && activeTab == 'logonSim')
		{
			var d_url = '/final/monitor/transactions.jsp?componentType='+comboVal+'&treeTitle=services&selectNode=Service$cap$'+encodeURIComponent(requestParams.filterBy)+'&selectedParam='+encodeURIComponent(requestParams.filterBy)+'&currentTab=logon&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&site='+encodeURIComponent(requestParams.filterBy)+'&isSite=true&serviceName='+encodeURIComponent(requestParams.filterBy)+'&fromLayer=false&selectNode='+encodeURIComponent(requestParams.filterBy)+'&currentTab=logon&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(requestParams.filterBy)+'&isfromCitrix=&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&dashboard_name=rum_Dashboard&view_name=Logon_Sub_View&fromServiceHomePage=true&fromSerComboChange=true&appliesTo='+requestParams.appliesTo+'&filterBy='+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;
			Ext.Ajax.request({
				url:d_url,
				scope:this,
				timeout:280000,
				//async:true,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						var externalAgentList = jsonData.externalAgents;
						var logonComponentList = jsonData.logonComponentList;
						var componentListObj = jsonData.componentListObj;
						 selCompType=componentListObj.selectedValue;
						 selSimulation = '';
						 selAgent=externalAgentList.selectedValue;

						 temLogonParam = jsonData.logonParam;
						var compCombo = Ext.getCmp('componentCombo');
						if(!Ext.isEmpty(compCombo))
							compCombo.setVisible(true);
						var simulationCombo = Ext.getCmp('simulationCombo');
						if(!Ext.isEmpty(simulationCombo))
							simulationCombo.setVisible(true);

						var compTypecombo = Ext.getCmp('compTypeCombo');
						if(!Ext.isEmpty(compTypecombo))
							compTypecombo.setVisible(true);
						
						if(!Ext.isEmpty(compTypecombo) && componentListObj!=null && componentListObj!=undefined)
						{
							selectedCompType=componentListObj.selectedValue;
						}

						if(!Ext.isEmpty(compCombo) && externalAgentList!=null && externalAgentList!=undefined)
						{
							selectedExtAgent = externalAgentList.selectedValue;
							//simulation combo data set start
							if(!Ext.isEmpty(simulationCombo) && logonComponentList!=null && logonComponentList!=undefined)
							{
								extSimData = logonComponentList;
								logonComponentList = logonComponentList[selectedExtAgent];

								selectedSimulation = logonComponentList.selectedValue;
								selSimulation = logonComponentList.selectedValue;
								selSimulOrg = logonComponentList.selectedOrgValue;

								if(!Ext.isEmpty(simulationCombo.getValue()))
								{
									simulationCombo.getStore().removeAll();
									simulationCombo.getStore().loadRawData('');
									simulationCombo.getStore().loadRawData(logonComponentList);
									simulationCombo.setFieldLabel(logonComponentList.label);
									simulationCombo.setValue(logonComponentList.selectedValue);
								}
								else
								{
									var simcomboStore = Ext.create('Ext.data.Store',{
										fields:['value', 'name', 'comptype'],
										proxy:{
											type: 'memory',
											reader: {
												type: 'json',
												root:'options'
											}
										},
										data:logonComponentList
									});
									simulationCombo.bindStore(simcomboStore);
									simulationCombo.setFieldLabel(logonComponentList.label);
									simulationCombo.setValue(logonComponentList.selectedValue);
								}
							}
							//simulation combo data set end

							if(!Ext.isEmpty(compCombo.getValue()))
							{
								compCombo.getStore().removeAll();
								compCombo.getStore().loadRawData('');
								compCombo.getStore().loadRawData(externalAgentList);
								compCombo.setFieldLabel(externalAgentList.label);
								compCombo.setValue(externalAgentList.selectedValue);
							}
							else
							{
								var comboAgentStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'options'
										}
									},
									data:externalAgentList
								});
								compCombo.bindStore(comboAgentStore);
								compCombo.setFieldLabel(externalAgentList.label);
								compCombo.setValue(externalAgentList.selectedValue);
							}
						}

						var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
						var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	

						var selected_dash = '';
						if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
							selected_dash = Ext.getCmp('dashListComId').getValue();
						
						//if(siteName != null)
							//fromServiceDashboard = true;
						var simulationSelectedOrgValue1 = "";
						if(selSimulation != null && selSimulation.indexOf(":NULL") > -1)
							simulationSelectedOrgValue1 = selSimulation.substring(0,selSimulation.indexOf(":NULL"));
						else
							simulationSelectedOrgValue1 = selSimulation;

						var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?treeTitle=LogonSimulation&monitorsBy=LogonSimulator&componentType="+selCompType+"&selectedState=&simulationName="+selSimulation+"&externalAgent="+selAgent+"&isfromCitrix=&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=Rum_Dashboard&view_name="+selected_view_name+"&fromServiceDashboard=false&servicename="+siteName+"&fromSerComboChange=true&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&componentNameService="+selSimulOrg+"&isLogonType=true&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;

						if(temLogonParam != null && temLogonParam != '' && temLogonParam != undefined)
							perf_url = "/final/monitor/comparisonLogonSimulator.jsp?"+temLogonParam+"&componentType="+selCompType+"&selectedState=&simulationName="+selSimulation+"&externalAgent="+selAgent+"&isfromCitrix=&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=Rum_Dashboard&view_name="+selected_view_name+"&fromServiceDashboard=false&servicename="+siteName+"&fromSerComboChange=true&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&componentNameService="+selSimulOrg+"&isLogonType=true&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;

						var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selAgent+"&simulationName="+selSimulation+"&componentNameService="+selSimulOrg;

						
						Ext.Ajax.request({
							url : transurl,
							scope:this,
							//async:true,
							success: function(response){
								var jsonText = response.responseText;
								//var panelArr = new Array();
								if(!Ext.isEmpty(jsonText))
								{
									var jsondata1 = Ext.decode(jsonText);
									if(jsondata1 != null && jsondata1 != undefined)
									{
										if(!Ext.isEmpty(dashboard_grid_containerObj))
											dashboard_grid_containerObj.removeAll(true);

										dashboard_grid_containerObj.add({
											xtype:'generalMeasuresGridPanel',
											//title:titlesys,
											cls:'gridHeadercenter iconGrid',
											//itemId:itemIdforsysandcom,
											itemId:'logonSimualtion',
											searchBoxCombo:false,
											margin:0,
											padding:0,
											id:'perPanel',
											height:185,
											frame:false,
											border:true,
											layout:{type:'vbox',align:'stretch'},
											flex:1,
											screenLabelPath:"monitor.Dashboard",
											url:perf_url,
											listeners: {
												'afterrender': function (obj) {
													this.loadTab(obj.url,null,null,null,null,true,'rumAppFlow');
												}
											}
										});

										if(!Ext.isEmpty(dashboard_chart_containerObj))
											dashboard_chart_containerObj.removeAll(true);

										//panelArr.push({
										dashboard_chart_containerObj.add({
											xtype:'transactionschartpanel',
											id:'transactionschartpanelid',
											//animCollapse:true,
											//columnWidth:1.0,
											//height:255,
											//height:(Ext.getBody().getViewSize().height - 225),
											//flex:1,
											jsonData:jsondata1,
											minHeight:265,
											margin:'10 1 0 0',
											//margin:'5 0 0 0',
											padding:0,
											//flex:0.57,
											border:true,
											isNotAreaChart:false
										});
									
										//curViewPort.add(panelArr);
										//curViewPort.doLayout();
									}
								}
							  },
							failure:function(){
								//window.parent.location.href="/final/servlet/com.egurkha.Logout";
							}
						});
					}
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
					var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	

					var selected_dash = '';
					if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
						selected_dash = Ext.getCmp('dashListComId').getValue();
					
					//if(siteName != null)
						//fromServiceDashboard = true;
					var simulationSelectedOrgValue1 = "";
					if(selSimulation != null && selSimulation.indexOf(":NULL") > -1)
						simulationSelectedOrgValue1 = selSimulation.substring(0,selSimulation.indexOf(":NULL"));
					else
						simulationSelectedOrgValue1 = selSimulation;

					var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?treeTitle=LogonSimulation&monitorsBy=LogonSimulator&componentType="+selCompType+"&selectedState=&simulationName="+selSimulation+"&externalAgent="+selAgent+"&isfromCitrix=&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=Rum_Dashboard&view_name="+selected_view_name+"&fromServiceDashboard=false&servicename="+siteName+"&fromSerComboChange=true&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&componentNameService="+selSimulOrg+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;

					if(temLogonParam != null && temLogonParam != '' && temLogonParam != undefined)
						perf_url = "/final/monitor/comparisonLogonSimulator.jsp?"+temLogonParam+"&componentType="+selCompType+"&selectedState=&simulationName="+selSimulation+"&externalAgent="+selAgent+"&isfromCitrix=&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=Rum_Dashboard&view_name="+selected_view_name+"&fromServiceDashboard=false&servicename="+siteName+"&fromSerComboChange=true&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&componentNameService="+selSimulOrg+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;

					var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selAgent+"&simulationName="+selSimulation+"&componentNameService="+selSimulOrg;
					
					Ext.Ajax.request({
						url : transurl,
						scope:this,
						//async:true,
						success: function(response){
							var jsonText = response.responseText;
							//var panelArr = new Array();
							if(!Ext.isEmpty(jsonText))
							{
								var jsondata1 = Ext.decode(jsonText);
								if(jsondata1 != null && jsondata1 != undefined)
								{
									if(!Ext.isEmpty(dashboard_grid_containerObj))
										dashboard_grid_containerObj.removeAll(true);

									dashboard_grid_containerObj.add({
										xtype:'generalMeasuresGridPanel',
										//title:titlesys,
										//title:perf_disp_name+" --Man At Work--",
										cls:'gridHeadercenter iconGrid',
										//itemId:itemIdforsysandcom,
										itemId:'logonSimualtion',
										searchBoxCombo:false,
										margin:0,
										padding:0,
										id:'perPanel',
										height:185,
										frame:false,
										border:true,
										layout:{type:'vbox',align:'stretch'},
										flex:1,
										screenLabelPath:"monitor.Dashboard",
										url:perf_url,
										listeners: {
											'afterrender': function (obj) {
												this.loadTab(obj.url,null,null,null,null,true,'rumAppFlow');
											}
										}
									});

									if(!Ext.isEmpty(dashboard_chart_containerObj))
										dashboard_chart_containerObj.removeAll(true);

									//panelArr.push({
									dashboard_chart_containerObj.add({
										xtype:'transactionschartpanel',
										id:'transactionschartpanelid',
										//animCollapse:true,
										//columnWidth:1.0,
										//height:255,
										//height:(Ext.getBody().getViewSize().height - 225),
										//flex:1,
										jsonData:jsondata1,
										minHeight:265,
										margin:'10 1 0 0',
										//margin:'5 0 0 0',
										padding:0,
										//flex:0.57,
										border:true,
										isNotAreaChart:false
									});
								
									//curViewPort.add(panelArr);
									//curViewPort.doLayout();
								}
							}
						  },
						failure:function(){
							//window.parent.location.href="/final/servlet/com.egurkha.Logout";
						}
					});
				}
			});
			return;
		}
		var service = siteName;
		if(service==null || service==undefined || service=='null')
			return;
		var fromLayer = false;
		var url= '/final/monitor/serviceDashHelper.jsp?&site='+encodeURI(service)+'&isSite=true&serviceName='+encodeURI(service)+'&fromLayer='+fromLayer;
		
    	  
	    	/*  var timeLineCombo=this.getTransactionChartComboTimeline();
	    	  var fromHrCombo=this.getTransactionChartComboFromhr();
	    	  var toHrCombo=this.getTransactionChartComboTohr();
	    	  var modeCombo=this.getTransactionChartComboMode();
	    	  var fromDateCombo=this.getTransactionChartFromDate();
	    	  var toDateCombo=this.getTransactionChartToDate();*/

		  var timeLineCombo=this.getTransactionComboTimeline();
	    	  var fromHrCombo=this.getTransactionComboFromhr();
	    	  var toHrCombo=this.getTransactionComboTohr();
	    	  var modeCombo=this.getTransactionComboMode();
	    	  var fromDateCombo=this.getTransactionFromDate();
	    	  var toDateCombo=this.getTransactionToDate();
	    	  
	    	  if(!Ext.isEmpty(combo)){
	    		  url+="&transComp="+combo.getValue();
	    	  }
			  if(this.tab=="emulated"){
				  url+="&selectedTab=EmulatedClients&from=emulated";
			  }
			  else
			  {
				  url+="&selectedTab="+this.tab;
			  }
	    	  if(!Ext.isEmpty(timeLineCombo)){
	    		  url+="&time_line="+timeLineCombo.getValue();
				  if(timeLineCombo.getValue()=='Any')
				  {
						 if(!Ext.isEmpty(fromHrCombo)){
	    					 url+="&starthr="+fromHrCombo.getValue();
						  }
						  if(!Ext.isEmpty(toHrCombo)){
							  url+="&endhr="+toHrCombo.getValue();
						  }
						  if(!Ext.isEmpty(modeCombo)){
							  url+="&mode="+modeCombo.getValue();
						  }
						  if(!Ext.isEmpty(fromDateCombo)){
							  tempstarttime=Ext.Date.format(fromDateCombo.getValue(),mgr_dateFormat);
							  url+="&starttime="+tempstarttime;
						  }
						  if(!Ext.isEmpty(toDateCombo)){
							  tempendtime=Ext.Date.format(toDateCombo.getValue(),mgr_dateFormat);
							  url+="&endtime="+tempendtime;
						  }
				  }
	    	  }
	    	 
			  
		
		// url=this.getTransactionsMainPanel().url;
		Ext.Ajax.request({
			url :url,
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(jsonData.HiddenFields!=null && jsonData.HiddenFields.siteName!=undefined)
				{
					this.siteName = jsonData.HiddenFields.siteName;
				}
				RumAppFlow.app.getController('Main').showTransactionGridPanelData(jsonData.GridScreenLabels,jsonData);
				//this.loadTransaction(jsonData);
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	onComponentChange:function(combo,activeTab,siteName,simulationSelectedOrgValue,selected_view_name){
		//added because when component changes the chart was not being displayed properly
		refreshSimulation="";
		var comboVal = combo.getValue();
		if(activeTab != null && activeTab == 'logonSim')
		{
			var logonComponentList = extSimData[comboVal];
			var compCombo = Ext.getCmp('simulationCombo');
			compCombo.getStore().removeAll();
			compCombo.getStore().loadRawData('');
			compCombo.getStore().loadRawData(logonComponentList);
			compCombo.setValue(logonComponentList.selectedValue);
			compCombo.setFieldLabel(logonComponentList.label);	
			
			var compComboValue = logonComponentList.selectedValue;

			var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
			var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	
			selectedVal = comboVal;
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			
			//if(siteName != null)
				//fromServiceDashboard = true;
			var simulationSelectedOrgValue1 = "";
			if(compComboValue != null && compComboValue.indexOf(":NULL") > -1)
				simulationSelectedOrgValue1 = compComboValue.substring(0,compComboValue.indexOf(":NULL"));
			else
			{
				simulationSelectedOrgValue1 = compComboValue;
				compComboValue = compComboValue+":NULL";
			}
			var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?treeTitle=LogonSimulation&monitorsBy=LogonSimulator&componentType=&selectedState=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedVal+"&isfromCitrix=&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=Rum_Dashboard&view_name="+selected_view_name+"&fromServiceDashboard=false&servicename="+siteName+"&fromSerComboChange=true&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&componentNameService="+compComboValue+"&isLogonType=true&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;

			var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selectedVal+"&simulationName="+simulationSelectedOrgValue1+"&componentNameService="+compComboValue;
			
			Ext.Ajax.request({
				url : transurl,
				scope:this,
				async:true,
				success: function(response){
					var jsonText = response.responseText;
					//var panelArr = new Array();
					if(!Ext.isEmpty(jsonText))
					{
						var jsondata1 = Ext.decode(jsonText);
						if(jsondata1 != null && jsondata1 != undefined)
						{
							if(!Ext.isEmpty(dashboard_grid_containerObj))
								dashboard_grid_containerObj.removeAll(true);

							dashboard_grid_containerObj.add({
								xtype:'generalMeasuresGridPanel',
								//title:titlesys,
								//title:perf_disp_name+" --Man At Work--",
								cls:'gridHeadercenter iconGrid',
								//itemId:itemIdforsysandcom,
								itemId:'logonSimualtion',
								searchBoxCombo:false,
								margin:0,
								padding:0,
								id:'perPanel',
								height:185,
								frame:false,
								border:true,
								layout:{type:'vbox',align:'stretch'},
								flex:1,
								screenLabelPath:"monitor.Dashboard",
								url:perf_url,
								listeners: {
									'afterrender': function (obj) {
										this.loadTab(obj.url,null,null,null,null,true,'rumAppFlow');
									}
								}
							});

							if(!Ext.isEmpty(dashboard_chart_containerObj))
								dashboard_chart_containerObj.removeAll(true);

							//panelArr.push({
							dashboard_chart_containerObj.add({
								xtype:'transactionschartpanel',
								id:'transactionschartpanelid',
								//animCollapse:true,
								//columnWidth:1.0,
								//height:255,
								//height:(Ext.getBody().getViewSize().height - 225),
								//flex:1,
								jsonData:jsondata1,
								minHeight:265,
								margin:'10 1 0 0',
								//margin:'5 0 0 0',
								padding:0,
								//flex:0.57,
								border:true,
								isNotAreaChart:false
							});
						
							//curViewPort.add(panelArr);
							//curViewPort.doLayout();
						}
					}
				  },
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
			return;
		}
		var service = siteName;
		if(service==null || service==undefined || service=='null')
			return;
		var fromLayer = false;
		var url= '/final/monitor/serviceDashHelper.jsp?&site='+encodeURI(service)+'&isSite=true&serviceName='+encodeURI(service)+'&fromLayer='+fromLayer;
		
    	  
	    	/*  var timeLineCombo=this.getTransactionChartComboTimeline();
	    	  var fromHrCombo=this.getTransactionChartComboFromhr();
	    	  var toHrCombo=this.getTransactionChartComboTohr();
	    	  var modeCombo=this.getTransactionChartComboMode();
	    	  var fromDateCombo=this.getTransactionChartFromDate();
	    	  var toDateCombo=this.getTransactionChartToDate();*/

		  var timeLineCombo=this.getTransactionComboTimeline();
	    	  var fromHrCombo=this.getTransactionComboFromhr();
	    	  var toHrCombo=this.getTransactionComboTohr();
	    	  var modeCombo=this.getTransactionComboMode();
	    	  var fromDateCombo=this.getTransactionFromDate();
	    	  var toDateCombo=this.getTransactionToDate();
	    	  
	    	  if(!Ext.isEmpty(combo)){
	    		  url+="&transComp="+combo.getValue();
	    	  }
			  if(this.tab=="emulated"){
				  url+="&selectedTab=EmulatedClients&from=emulated";
			  }
			  else
			  {
				  url+="&selectedTab="+this.tab;
			  }
	    	  if(!Ext.isEmpty(timeLineCombo)){
	    		  url+="&time_line="+timeLineCombo.getValue();
				  if(timeLineCombo.getValue()=='Any')
				  {
						 if(!Ext.isEmpty(fromHrCombo)){
	    					 url+="&starthr="+fromHrCombo.getValue();
						  }
						  if(!Ext.isEmpty(toHrCombo)){
							  url+="&endhr="+toHrCombo.getValue();
						  }
						  if(!Ext.isEmpty(modeCombo)){
							  url+="&mode="+modeCombo.getValue();
						  }
						  if(!Ext.isEmpty(fromDateCombo)){
							  tempstarttime=Ext.Date.format(fromDateCombo.getValue(),mgr_dateFormat);
							  url+="&starttime="+tempstarttime;
						  }
						  if(!Ext.isEmpty(toDateCombo)){
							  tempendtime=Ext.Date.format(toDateCombo.getValue(),mgr_dateFormat);
							  url+="&endtime="+tempendtime;
						  }
				  }
	    	  }
	    	 
			  
		
		// url=this.getTransactionsMainPanel().url;
		Ext.Ajax.request({
			url :url,
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(jsonData.HiddenFields!=null && jsonData.HiddenFields.siteName!=undefined)
				{
					this.siteName = jsonData.HiddenFields.siteName;
				}
				RumAppFlow.app.getController('Main').showTransactionGridPanelData(jsonData.GridScreenLabels,jsonData);
				//this.loadTransaction(jsonData);
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	showTransactionGridPanelData:function(screenLabels ,jsonData){
		var tabPanelAll = Ext.getCmp('tabAll');
		var selectedTabProp = new Object();
		
		var hideConfigIcon = true;
		selectedTabProp['title'] = screenLabels["emulBtnLabel"];
		selectedTabProp['itemId'] = 'serviceToolbarEmulatedButton';
		selectedTabProp['dataUrl'] = screenLabels["emulBtnURL"];
		var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
		
		var compCombo22 = Ext.getCmp('componentCombo');
		var ComponentList = jsonData.ComponentList;
		var siteName = jsonData.HiddenFields.siteName;
		//if(siteName!=null && siteName!=undefined)
			//services.app.getController("ServicesTransactions").siteName=siteName;
		var label='',selectedVal='';
		var defalutHide = true;
		var comboStore;
		if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined)
		{
			defalutHide = false;
		}
		if(!Ext.isEmpty(compCombo22)){
			if(defalutHide == false || defalutHide == 'false'){
				try{
					compCombo22.suspendEvents(true);
					compCombo22.getStore().removeAll();
					compCombo22.getStore().loadRawData('');
					compCombo22.getStore().loadRawData(ComponentList);
					compCombo22.setValue(ComponentList.selectedValue);
					compCombo22.setFieldLabel(ComponentList.label);
					compCombo22.resumeEvents();
				}catch(e){
					alert(e)
				}
			}else{
				compCombo22.setVisible(false);
			}
		}

		if (strSkin=="Dark")
		{
			skinBg="#444444";
		}
		else if (strSkin=="Light")
		{
			skinBg="#ffffff";
		}
		
		var dashboard_view_container_gridObj = Ext.getCmp('dashboard_view_container_grid');	
		var dashboard_view_container_chartObj = Ext.getCmp('dashboard_view_container_chart');	

		var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
		var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	

		var dashboard_grid_emu_containerObj = Ext.getCmp('dashboard_container_Emu_Grid');	
		var dashboard__chart_emu_containerObj = Ext.getCmp('dashboard_container_Emu_Chart');
		
		var grid_container;
		var chart_container;
		if(!Ext.isEmpty(dashboard_view_container_gridObj) && !Ext.isEmpty(dashboard_view_container_chartObj)){
			grid_container = dashboard_view_container_gridObj;
			chart_container = dashboard_view_container_chartObj;
		}else if(!Ext.isEmpty(dashboard_grid_containerObj) && !Ext.isEmpty(dashboard_chart_containerObj)){
			grid_container = dashboard_grid_containerObj;
			chart_container = dashboard_chart_containerObj;
		}else if(!Ext.isEmpty(dashboard_grid_emu_containerObj) && !Ext.isEmpty(dashboard__chart_emu_containerObj)){
			grid_container = dashboard_grid_emu_containerObj;
			chart_container = dashboard__chart_emu_containerObj;
		}
		
		grid_container.removeAll();
		chart_container.removeAll();
		grid_container.add({
			xtype:'transactiongridpanel',
			id:'transactiongridpanelid',
			ui:'newGridPanel',
			//title:'<span class="font_bold12">Transactions-&&&</span>',
			//columnWidth:1.0,
			jsonData:jsonData,
			isEmuEnabled:isEmuEnabled,
			margin:'0 0 0 0',
			padding:0,
			height:185,
			autoScroll:false,
			scroll:false,
			border:true
			
		});
		chart_container.add({
			xtype:'transactionschartpanel',
			id:'transactionschartpanelid',
			//title:'Graphs',
			columnWidth:1.0,
			//height:500,
			jsonData:jsonData,
			margin:'10 0 0 0',
			padding:0,
			//flex:0.57,
			border:false,
			layout:{type:'fit'},
			//style:{'overflow':'auto'}
				
		});	
	},
	onSimulationChange:function(combo,activeTab,siteName,simulationSelectedOrgValue,selected_view_name){
		//var tabPanelAll = this.getTransactionsMainTabPanelAll();
		//var activeTab = tabPanelAll.getActiveTab();
		var comboVal = combo.getValue();
		if(activeTab != null && activeTab == 'logonSim')
		{			
			var servicename = siteName;
			if(Ext.isEmpty(servicename) || servicename == null || servicename == undefined)
				servicename = curServiceName;

			/*var componentVal = comboVal;
			if(!Ext.isEmpty(componentVal) && componentVal != null && componentVal.indexOf(":") > 0)
			{
				componentVal = componentVal.substring(0,componentVal.indexOf(":"));
			}*/

			//var externalAgentList = extAgentData[componentVal];
			var compCombo = Ext.getCmp('componentCombo');
			/*compCombo.getStore().removeAll();
			compCombo.getStore().loadRawData('');
			compCombo.getStore().loadRawData(externalAgentList);
			compCombo.setValue(externalAgentList.selectedValue);
			compCombo.setFieldLabel(extAgentData.label);
			selectedExtAgent = externalAgentList.selectedValue;*/ 
			selectedExtAgent = compCombo.getValue(); 
			var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
			var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	
			selectedVal = comboVal;
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();

			//if(siteName != null)
				//fromServiceDashboard = true;
			var simulationSelectedOrgValue1 = "";
			if(selectedVal != null && selectedVal.indexOf(":NULL") > -1)
				simulationSelectedOrgValue1 = selectedVal.substring(0,selectedVal.indexOf(":NULL"));
			else
				simulationSelectedOrgValue1 = selectedVal;
			var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?treeTitle=LogonSimulation&monitorsBy=LogonSimulator&componentType=&selectedState=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedExtAgent+"&isfromCitrix=&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=Rum_Dashboard&view_name="+selected_view_name+"&fromServiceDashboard=false&servicename="+siteName+"&fromSerComboChange=true&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&componentNameService="+selectedVal+"&isLogonType=true&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;

			var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selectedExtAgent+"&simulationName="+simulationSelectedOrgValue+"&componentNameService="+selectedVal;

			Ext.Ajax.request({
				url : transurl,
				scope:this,
				async : true,
				success: function(response){
					var jsonText = response.responseText;
					//var panelArr = new Array();
					if(!Ext.isEmpty(jsonText))
					{
						var jsondata1 = Ext.decode(jsonText);
						if(jsondata1 != null && jsondata1 != undefined)
						{
							if(!Ext.isEmpty(dashboard_grid_containerObj))
								dashboard_grid_containerObj.removeAll(true);

							dashboard_grid_containerObj.add({
								xtype:'generalMeasuresGridPanel',
								//title:titlesys,
								//title:perf_disp_name+" --Man At Work--",
								cls:'gridHeadercenter iconGrid',
								//itemId:itemIdforsysandcom,
								itemId:'logonSimualtion',
								searchBoxCombo:false,
								margin:0,
								padding:0,
								id:'perPanel',
								height:185,
								frame:false,
								border:true,
								layout:{type:'vbox',align:'stretch'},
								flex:1,
								screenLabelPath:"monitor.Dashboard",
								url:perf_url,
								listeners: {
									'afterrender': function (obj) {
										this.loadTab(obj.url,null,null,null,null,true,'rumAppFlow');
									}
								}
							});

							if(!Ext.isEmpty(dashboard_chart_containerObj))
								dashboard_chart_containerObj.removeAll(true);

							//panelArr.push({
							dashboard_chart_containerObj.add({
								xtype:'transactionschartpanel',
								id:'transactionschartpanelid',
								//animCollapse:true,
								//columnWidth:1.0,
								//height:255,
								//height:(Ext.getBody().getViewSize().height - 225),
								//flex:1,
								jsonData:jsondata1,
								minHeight:265,
								margin:'10 1 10 0',
								//margin:'5 0 0 0',
								padding:0,
								//flex:0.57,
								border:true,
								isNotAreaChart:false
							});
						
							//curViewPort.add(panelArr);
							//curViewPort.doLayout();
						}
					}
				  },
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
			selectedSimulation = comboVal;
			return;
		}
	},
	showDDPopup:function(url)
	{
		/*try
		{
			if(!Ext.isEmpty(url))
			{	
				Ext.create('Ext.window.Window', {
					resizable:false,
					width:'95%',
					draggable: true,
					ghost:false,
					flex:1,
					layout:{
							type:'fit',
							align:'stretch'
					},
					modal:true,
					constrain:true,
					renderTo:Ext.getBody(),
					height:'95%',
					items:[ {
									xtype: 'component',
									//minWidth : 1024,
									flex:1,
									autoEl: {
										tag: 'iframe',
										scrolling:"no",
										height:'100%',
										width:'100%',
										frameBorder:0,
										style: 'height: 100%; width: 100%; border: none;',
										src: url
									}
								}],
					listeners:
					{
						show: function(win)
						{
							if (this.modal)
							{
								var dom = Ext.dom.Query.select('.x-mask');								
								var el = Ext.fly(dom[dom.length-1]);								
								el.addCls('windowModal');
							}
						},
						hide: function(win)
						{
							if (this.modal)
							{
								var dom = Ext.dom.Query.select('.x-mask');
								var el = Ext.fly(dom[dom.length-1]);
								el.removeCls('windowModal');
							}
						},
						afterrender: function()
						{
							Ext.EventManager.onWindowResize(function()
							{
								var me = this;
								me.center();
							}, this);
						}
					}
				}).show();
			}
		}
		catch (e)
		{
		}*/
		var wName = '';
		if(dd==null)
		{
			//dd=window.open(encodeURI(url+"&newWindow=true"),wName,'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,scrollbars=no,resizable=no');
			try{
				dd=parent.openWindow((url+"&newWindow=true"),wName,'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,scrollbars=yes,resizable=no');
			}catch(eex){
				dd=parent.parent.openWindow((url+"&newWindow=true"),wName,'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,scrollbars=yes,resizable=no');
			}
			if(dd!=null && dd!='' && dd!="undefined")
				dd.focus();
		}
		else
		{
			if(dd!=null && dd!='' && dd!="undefined") 
				dd.close();
			dd=null;
			//dd=window.open(encodeURI(url+"&newWindow=true"),wName,'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,scrollbars=no,resizable=no');
			try{
				dd=parent.openWindow((url+"&newWindow=true"),wName,'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,scrollbars=yes,resizable=no');
			}catch(eex){
				dd=parent.parent.openWindow((url+"&newWindow=true"),wName,'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,scrollbars=yes,resizable=no');
			}
			if(dd!=null && dd!='' && dd!="undefined")
				dd.focus();
		}
		
	},
	geoComboOnChange:function(combo){
		try
		{
			var countryComboIdObj = Ext.getCmp('countryComboId');
			var regionComboIdObj = Ext.getCmp('regionComboId');
			if(combo != undefined && combo != null )
			{
				var currId = combo.id;
				var value = combo.getValue();
				var rawvalue = combo.getRawValue();
				var value = combo.getValue();
				var viewName='';
				if(currId == 'countryComboId')
				{
					if(value == 'World')
						viewName ='country';
					else
						viewName ='region';
				}
				else
				{
					if(value == 'AllRegion')
					{
						viewName ='region';
						rawvalue = countryComboIdObj.getRawValue();
						value = countryComboIdObj.getValue();
					}
					else
						viewName ='city';
				}

				var params = this.getDefaultParams();
				params +='&action=mapAction';
				params +='&viewName='+viewName;
				params +='&filterNameRaw='+rawvalue;
				params +='&filterName='+value;
				
				var tabUrl = "/final/servlet/com.eg.EgCommonDashboardController?"+params;
				Ext.getBody().mask('Loading...');
				Ext.Ajax.request({
					url : tabUrl,
					method : 'POST',
					scope:this,
					timeout:280000,
					success : function(response, opts)
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.geo))
						{
							var geo = jsonData.geo;
							Ext.getCmp('overview_map_id').updateData(geo[0]);
							Ext.getCmp('geo_id_mapdetails').updateData(geo[0]);
							Ext.getCmp('responsetimepiechart_Geo').updateData(geo[1]);
							Ext.getCmp('gridSlowpagegroups_Geo_view').setTitle(geo[2][0].title);
							Ext.getCmp('gridSlowpagegroups_Geo_view').updateData(geo[2]);

							
							if(viewName == 'region')
							{
								regionComboIdObj.getStore().loadRawData(geo[0].regionArray);
								regionComboIdObj.setValue(geo[0].selectedRegion);
								regionComboIdObj.show();
							}
							else if(viewName == 'country')
								regionComboIdObj.hide();
						}
						Ext.getBody().unmask();
					},
					failure:function(){
						Ext.getBody().unmask();
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});
			}
		}
		catch (e)
		{
		}
	},
	changeOmniCombo:function(comboVal){
		var params = this.getDefaultParams();
		params +='&action=changeOmniView';
		params +='&combo='+comboVal;
			
		var tabUrl = "/final/servlet/com.eg.EgCommonDashboardController?"+params;
		Ext.getBody().mask('Loading...');
		Ext.Ajax.request({
			url : tabUrl,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				Ext.getCmp('omnichannelID').loadChart(jsonData.omni);
				Ext.getBody().unmask();
			},
			failure:function(){
				Ext.getBody().unmask();
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});

	},
	doPageViewAction:function(uriBox){
		try
		{
			var uri = 'all';
			var isAll = true;
			var selection = Ext.getCmp('pageuriBox_Id').selection;
			var selected =[],rawURL =[];
			var urlList='';
			if(selection != undefined && selection.length > 0)
			{
				Ext.each(selection,function(record){
					selected.push({"url" : record.data.url});
					rawURL.push(record.data.url);
					urlList += ","+record.data.url;
				});
			}
			
			if(rawURL != null && rawURL != undefined && rawURL.length > 0)
			{
				if(rawURL.indexOf('All Urls') != -1)
					uri = 'all';
				else
				{
					isAll = false;
					urlList = urlList.substring(1);
					uri = urlList;
				}
			}

			var params = this.getDefaultParams();
			params +='&action=doPageViewAction';
			params +='&uri='+encodeURIComponent(uri);
				
			var tabUrl = "/final/servlet/com.eg.EgCommonDashboardController?"+params;
			Ext.getBody().mask('Loading...');
			Ext.Ajax.request({
				url : tabUrl,
				method : 'POST',
				//params:params,
				scope:this,
				timeout:280000,
				success : function(response, opts)
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if(!isAll && selected != undefined && selected.length > 0)
					{
						if(uriBox != undefined && uriBox != null )
						{
							uriBox.selectedURL = rawURL;
							//updating the value in the field
							if(uriBox.selectedURL.length == 1 && uriBox.selectedURL[0].trim().toLowerCase() == "allurls")
								uriBox.setNumberURL(0);
							else	
								uriBox.setNumberURL(uriBox.selectedURL.length,uriBox.data);
						}
					}
					else if(isAll)
					{
						if(rawURL.indexOf('All Urls') != -1)
								uriBox.setNumberURL(0);
					}
					Ext.getCmp('pageviewpanel_PaView_Id').data=jsonData.page_view.data;
					Ext.getCmp('pageviewpanel_PaView_Id').fullData=jsonData.page_view;
					Ext.getCmp('pageviewpanel_PaView_Id').updatePVpanel(jsonData.page_view,false);
					Ext.getBody().unmask();
				},
				failure:function(){
					Ext.getBody().unmask();
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		catch (e)
		{
			//console.log('e------->',e)
		}
	},
	changeTopologyEx:function(uriBox){
		try
		{
			var comboObj = Ext.getCmp('appflowCombo_IdE');
			var comboValue = comboObj.getValue();
			var uri = 'all';
			var isAll = true;
			var selection = Ext.getCmp('appuriBox_IdE').selection;
			var selected =[],rawURL =[];
			var urlList='';
			if(selection != undefined && selection.length > 0)
			{
				Ext.each(selection,function(record){
					selected.push({"url" : record.data.url});
					rawURL.push(record.data.url);
					urlList += ","+record.data.url;
				});
			}
			
			if(rawURL != null && rawURL != undefined && rawURL.length > 0)
			{
				if(rawURL.indexOf('All Urls') != -1)
					uri = 'all';
				else
				{
					isAll = false;
					urlList = urlList.substring(1);
					uri = urlList;
				}
			}

			//var params = this.getDefaultParams();

			var params='';
			if(requestParams != null && requestParams != undefined )
			{
				try
				{
					params='isFrom=rumAppFlow';
					for (var key in requestParams)
					{
						if(key == 'selectedTab')
							params +='&selectedTab=overview_view';
						else
							params +='&'+key+'='+requestParams[key];
					}
				}
				catch (e)
				{
					params='';
				}
			}
			params +='&action=changeTopologyView';
			params +='&uri='+encodeURIComponent(uri);
			params +='&combo='+comboValue;
				
			var tabUrl = "/final/servlet/com.eg.EgCommonDashboardController?"+params;
			Ext.getBody().mask('Loading...');
			Ext.Ajax.request({
				url : tabUrl,
				method : 'POST',
				//params:params,
				scope:this,
				timeout:280000,
				success : function(response, opts)
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if(!isAll && selected != undefined && selected.length > 0)
					{
						jsonData.topo.url=selected;
						if(uriBox != undefined && uriBox != null )
						{
							uriBox.selectedURL = rawURL;
							//updating the value in the field
							uriBox.setNumberURL(uriBox.selectedURL.length,uriBox.data);
						}
					}
					else if(isAll)
					{
						if(rawURL.indexOf('All Urls') != -1)
								uriBox.setNumberURL(0);
					}
					Ext.getCmp('appflowTopology_idE').updateData(jsonData.topo);						
					Ext.getBody().unmask();
				},
				failure:function(){
					Ext.getBody().unmask();
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		catch (e)
		{
		}
	},
	changeTopology:function(uriBox){
		try
		{
			var comboObj = Ext.getCmp('appflowCombo_Id');
			var comboValue = comboObj.getValue();
			var uri = 'all';
			var isAll = true;
			var selection = Ext.getCmp('appuriBox_Id').selection;
			var selected =[],rawURL =[];
			var urlList='';
			if(selection != undefined && selection.length > 0)
			{
				Ext.each(selection,function(record){
					selected.push({"url" : record.data.url});
					rawURL.push(record.data.url);
					urlList += ","+record.data.url;
				});
			}
			
			if(rawURL != null && rawURL != undefined && rawURL.length > 0)
			{
				if(rawURL.indexOf('All Urls') != -1)
					uri = 'all';
				else
				{
					isAll = false;
					urlList = urlList.substring(1);
					uri = urlList;
				}
			}

			var params = this.getDefaultParams();
			params +='&action=changeTopologyView';
			params +='&uri='+encodeURIComponent(uri);
			params +='&combo='+comboValue;
				
			var tabUrl = "/final/servlet/com.eg.EgCommonDashboardController?"+params;
			Ext.getBody().mask('Loading...');
			Ext.Ajax.request({
				url : tabUrl,
				method : 'POST',
				//params:params,
				scope:this,
				timeout:280000,
				success : function(response, opts)
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if(!isAll && selected != undefined && selected.length > 0)
					{
						jsonData.topo.url=selected;
						if(uriBox != undefined && uriBox != null )
						{
							uriBox.selectedURL = rawURL;
							//updating the value in the field
							uriBox.setNumberURL(uriBox.selectedURL.length,uriBox.data);
						}
					}
					else if(isAll)
					{
						if(rawURL.indexOf('All Urls') != -1)
								uriBox.setNumberURL(0);
					}
					Ext.getCmp('appflowTopology_id').updateData(jsonData.topo);
					try
					{
						var appflowbreakupIDObj = Ext.getCmp('appflowbreakupID');						
						if(!Ext.isEmpty(rTBelementClickedId) && rTBelementClickedId != '' && !Ext.isEmpty(appflowbreakupIDObj) && appflowbreakupIDObj != undefined && appflowbreakupIDObj != null)
						{
							if(rTBelementClickedId == 'network_connection')
							{
								try
								{
									var network_connectionObj = Ext.get('network_connection');
									if(!Ext.isEmpty(network_connectionObj))
										network_connectionObj.addCls('select');								
								}
								catch (er){}
								appflowbreakupIDObj.updateDetails(jsonData.topo.networkData);
							}
							else if(rTBelementClickedId == 'content_download')
							{
								try
								{
									var network_connectionObj = Ext.get('content_download');
									if(!Ext.isEmpty(network_connectionObj))
										network_connectionObj.addCls('select');								
								}
								catch (er){}
								appflowbreakupIDObj.updateDetails(jsonData.topo.contentData);
							}
							else
							{
								appflowbreakupIDObj.updateDetails(jsonData.topo.defaultdata);
							}
						}
						else if(!Ext.isEmpty(appflowbreakupIDObj) && appflowbreakupIDObj != undefined && appflowbreakupIDObj != null)
						{
							appflowbreakupIDObj.updateDetails(jsonData.topo.defaultdata);
						}
					}
					catch (er)
					{
						//console.log("er-==->",er)
					}			
					Ext.getBody().unmask();
				},
				failure:function(){
					Ext.getBody().unmask();
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		catch (e)
		{
			//console.log('e------->',e)
		}
	},
	refresh:function()
	{
		var me = this;
		isRefreshing = true;
		
		Ext.getCmp('settingIconId').hide();

		try
		{
			var isSessionWindowOpen = document.getElementById('isSessionWindowOpen').value;	
			if(isSessionWindowOpen == 'true' || isSessionWindowOpen == true)
				return;
			
		}
		catch (e)
		{
		}
		var params='';
		if(requestParams != null && requestParams != undefined )
		{
			try
			{
				params='isFrom=rumAppFlow';
				for (var key in requestParams)
					params +='&'+key+'='+requestParams[key];
			}
			catch (e)
			{
				params='';
			}
		}
		params +='&action=loadViewData';
		params +='&isRefresh=true';
		

		if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "omni_channel")
		{
			var comboVal = Ext.getCmp('omni_combo').getValue();
			params +='&combo='+comboVal;
		}
		else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "geo_view")
		{
			var filterNameRaw='';
			var filterName='';
			var viewName='country';
			try
			{
				var countryComboIdObj = Ext.getCmp('countryComboId');
				var regionComboIdObj = Ext.getCmp('regionComboId');
				var combo1 = countryComboIdObj.getValue();
				var combo2 = regionComboIdObj.getValue();
				if(countryComboIdObj.isVisible())
				{
					if(combo1 == 'World')
					{
						viewName ='country';
					}
					else
					{
						if(combo2 == 'AllRegion')
						{
							viewName ='region';
							filterNameRaw = countryComboIdObj.getRawValue();
							filterName = countryComboIdObj.getValue();
						}
						else
						{
							viewName ='city';
							filterNameRaw = regionComboIdObj.getRawValue();
							filterName = regionComboIdObj.getValue();
						}
					}
				}
			}
			catch (e)
			{
			}
			

			params +='&viewName='+viewName;
			params +='&filterNameRaw='+filterNameRaw;
			params +='&filterName='+filterName;
			
		}
		else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "page_views")
		{
			var uri = 'all';
			var isAll = true;
			var selection = Ext.getCmp('pageuriBox_Id').selection;
			var selected =[],rawURL =[];
			var urlList='';
			if(selection != undefined && selection.length > 0)
			{
				Ext.each(selection,function(record){
					selected.push({"url" : record.data.url});
					rawURL.push(record.data.url);
					urlList += ","+record.data.url;
				});
			}
			
			if(rawURL != null && rawURL != undefined && rawURL.length > 0)
			{
				if(rawURL.indexOf('All Urls') != -1)
					uri = 'all';
				else
				{
					isAll = false;
					urlList = urlList.substring(1);
					uri = urlList;
				}
			}

			params +='&uri='+encodeURIComponent(uri);
		}
		else if(!Ext.isEmpty(requestParams.selectedTab) && (requestParams.selectedTab == "overview_view" || requestParams.selectedTab == "response_time_breakup_view" ))
		{
			var comboObj = Ext.getCmp('appflowCombo_Id');
			var comboValue = comboObj.getValue();
			var uri = 'all';
			var isAll = true;
			var selection = Ext.getCmp('appuriBox_Id').selection;
			var selected =[],rawURL =[];
			var urlList='';
			if(selection != undefined && selection.length > 0)
			{
				Ext.each(selection,function(record){
					selected.push({"url" : record.data.url});
					rawURL.push(record.data.url);
					urlList += ","+record.data.url;
				});
			}
			
			if(rawURL != null && rawURL != undefined && rawURL.length > 0)
			{
				if(rawURL.indexOf('All Urls') != -1)
					uri = 'all';
				else
				{
					isAll = false;
					urlList = urlList.substring(1);
					uri = urlList;
				}
			}

			params +='&uri='+encodeURIComponent(uri);
			params +='&combo='+comboValue;
		}

		var tabUrl = "/final/servlet/com.eg.EgCommonDashboardController?"+params;
		Ext.getBody().mask('Loading...');
		Ext.Ajax.request({
			url : tabUrl,
			method : 'POST',
			//params:params,
			async:false,
			scope:this,
			timeout:280000,
			success : function(response, opts)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "overview_view")
				{					
					Ext.getCmp('overviewdetails_Overview_view').update(jsonData.loadViewDetails);
					Ext.getCmp('appflowCombo_Id').getStore().loadRawData(jsonData.loadViewDetails[1].Application_Block_1_Value[0].comboObj.combo_arr);
					Ext.getCmp('appuriBox_Id').data = jsonData.loadViewDetails[1].Application_Block_1_Value[0].uriArray;
					if(!Ext.isEmpty(jsonData.loadViewDetails[1].Application_Block_1_Value[0].refreshUriList) && jsonData.loadViewDetails[1].Application_Block_1_Value[0].refreshUriList != undefined && jsonData.loadViewDetails[1].Application_Block_1_Value[0].refreshUriList != null && jsonData.loadViewDetails[1].Application_Block_1_Value[0].refreshUriList.length > 0)
					{
						var uriBox = Ext.getCmp('appuriBox_Id')
						jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo.url=selected;
						uriBox.selectedURL = jsonData.loadViewDetails[1].Application_Block_1_Value[0].refreshUriList;
						//updating the value in the field
						if(uriBox.selectedURL.length == 1 && uriBox.selectedURL[0].trim().toLowerCase() == "allurls")
							uriBox.setNumberURL(0);
						else
							uriBox.setNumberURL(uriBox.selectedURL.length,uriBox.data);
					}					
					Ext.getCmp('appflowTopology_id').updateData(jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo);
					Ext.getCmp('gridSlowCountries_Overview_view').updateData(jsonData.loadViewDetails[2].Application_Block_2_Value);
					Ext.getCmp('gridSlowpageGroups_Overview_view').updateData(jsonData.loadViewDetails[3].Application_Block_3_Value);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "usage")
				{
					Ext.getCmp('overviewdetails_Usage_view').update(jsonData.loadViewDetails);
					var jsonDetailsfrCPP = [];
					var jsonDetails = jsonData.loadViewDetails;
					for (var i =1; i<jsonDetails.length;i++) 
					{
						jsonDetailsfrCPP[i-1]=jsonDetails[i];
					}
					Ext.getCmp('chartparentpanel_Usage_view').updateChartData(jsonDetailsfrCPP);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "errors")
				{
					Ext.getCmp('overviewdetails_Errors_view').update(jsonData.loadViewDetails);
					Ext.getCmp('page_Errors_view').updateData(jsonData.loadViewDetails);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "omni_channel")
				{
					Ext.getCmp('overviewdetails_Omni_view').update(jsonData.loadViewDetails);
					Ext.getCmp('omnichannelmainpanel_omni_Id').updateData(jsonData.loadViewDetails[1].Application_Block_1_Value[0]);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "page_views")
				{
					Ext.getCmp('overviewdetails_PaView_view').update(jsonData.loadViewDetails);
					Ext.getCmp('pageviewpanel_PaView_Id').data=jsonData.loadViewDetails[1].Application_Block_1_Value[0].data;
					Ext.getCmp('pageviewpanel_PaView_Id').fullData=jsonData.loadViewDetails[1].Application_Block_1_Value[0];
					Ext.getCmp('pageviewpanel_PaView_Id').updatePVpanel(jsonData.loadViewDetails);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "overview_geo_view"){
					Ext.getCmp('overviewdetails_Static_Geo_view').update(jsonData.loadViewDetails);
					Ext.getCmp('overview_Static_map_id').updateData(jsonData.loadViewDetails[1].Application_Block_1_Value[0][0]);
					//Ext.getCmp('static_geo_id_mapdetails').updateData(jsonData.loadViewDetails[1].Application_Block_1_Value[0][0]);
					Ext.getCmp('responsetimepiechart_Static_Geo').updateData(jsonData.loadViewDetails[1].Application_Block_1_Value[0][1]);
					Ext.getCmp('gridSlowpagegroups_Static_Geo_view').updateData(jsonData.loadViewDetails[1].Application_Block_1_Value[0][2]);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "geo_view"){
					Ext.getCmp('overviewdetails_Geo_view').update(jsonData.loadViewDetails);
					Ext.getCmp('overview_map_id').updateData(jsonData.loadViewDetails[1].Application_Block_1_Value[0][0]);
					Ext.getCmp('geo_id_mapdetails').updateData(jsonData.loadViewDetails[1].Application_Block_1_Value[0][0]);
					Ext.getCmp('responsetimepiechart_Geo').updateData(jsonData.loadViewDetails[1].Application_Block_1_Value[0][1]);
					Ext.getCmp('gridSlowpagegroups_Geo_view').setTitle(jsonData.loadViewDetails[1].Application_Block_1_Value[0][2][0].title);
					Ext.getCmp('gridSlowpagegroups_Geo_view').updateData(jsonData.loadViewDetails[1].Application_Block_1_Value[0][2]);					
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "response_time_breakup_view")
				{
					Ext.getCmp('overviewdetails_Rtb_view').update(jsonData.loadViewDetails);
					Ext.getCmp('appflowCombo_Id').getStore().loadRawData(jsonData.loadViewDetails[1].Application_Block_1_Value[0].comboObj.combo_arr);
					Ext.getCmp('appuriBox_Id').data = jsonData.loadViewDetails[1].Application_Block_1_Value[0].uriArray;
					if(!Ext.isEmpty(jsonData.loadViewDetails[1].Application_Block_1_Value[0].refreshUriList) && jsonData.loadViewDetails[1].Application_Block_1_Value[0].refreshUriList != undefined && jsonData.loadViewDetails[1].Application_Block_1_Value[0].refreshUriList != null && jsonData.loadViewDetails[1].Application_Block_1_Value[0].refreshUriList.length > 0)
					{
						var uriBox = Ext.getCmp('appuriBox_Id')
						jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo.url=selected;
						uriBox.selectedURL = jsonData.loadViewDetails[1].Application_Block_1_Value[0].refreshUriList;
						//updating the value in the field
						if(uriBox.selectedURL.length == 1 && uriBox.selectedURL[0].trim().toLowerCase() == "allurls")
							uriBox.setNumberURL(0);
						else
							uriBox.setNumberURL(uriBox.selectedURL.length,uriBox.data);
					}
					Ext.getCmp('appflowTopology_id').updateData(jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo);
					if(!Ext.isEmpty(rTBelementClickedId) && rTBelementClickedId != '')
					{
						if(rTBelementClickedId == 'network_connection'){
							try
							{
								var network_connectionObj = Ext.get('network_connection');
								if(!Ext.isEmpty(network_connectionObj))
									network_connectionObj.addCls('select');								
							}
							catch (er){}							
							Ext.getCmp('appflowbreakupID').updateDetails(jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo.networkData);
						}else if(rTBelementClickedId == 'content_download'){
							try
							{
								var content_downloadObj = Ext.get('content_download');
								if(!Ext.isEmpty(content_downloadObj))
									content_downloadObj.addCls('select');								
							}
							catch (er){}							
							Ext.getCmp('appflowbreakupID').updateDetails(jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo.contentData);
						}else{
							Ext.getCmp('appflowbreakupID').updateDetails(jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo.defaultdata);
						}
					}
					else
					{
						Ext.getCmp('appflowbreakupID').updateDetails(jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo.defaultdata);
					}
					Ext.getCmp('responsetimepiechart_Rtb').updateData(jsonData.loadViewDetails[2].Application_Block_4_Value[0]);
					Ext.getCmp('gridSlowpagegroups_rtb_view').updateData(jsonData.loadViewDetails[3].Application_Block_5_Value);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "topology_view" )
				{
					Ext.getBody().unmask();
					return;
					var record = '';
					try
					{
						record = Ext.getCmp('stateCombo').getValue();	
						if(!Ext.isEmpty(selectedSegmentName) && selectedSegmentName != null && selectedSegmentName != undefined && selectedSegmentName != 'null' && selectedSegmentName != 'undefined')
						{
							record = selectedSegmentName;
						}
					}
					catch (er)
					{
						record = ifAssSeg;
					}
					var selectedRum = titleApplies;
					if(rumPageParams.serviceCombo[0].rumcomboNeeded)
						selectedRum = rumPageParams.serviceCombo[0].selectedRum;

					var turl = '/final/monitor/EgServiceTopologyD3JS.jsp?physical_topology=0&type=monitor&fromHomepage=&serviceGroup=null&isFromZone='+backParams.isFromZone+'&iszoneName='+encodeURIComponent(backParams.iszoneName)+'&parentZone='+encodeURIComponent(backParams.parentZone)+'&action=service&serviceState=service20New_'+ifAssSegState+'&service='+requestParams.filterBy+'&segment='+record+'&site='+requestParams.filterBy+"&isfromRum=true&dashboard_name=rum_Dashboard&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&activeView=topology";
					Ext.get('serTopologyMainCon').dom.src=turl;
					//me.addTopologyPage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "metrics_View" )
				{
					var compTypeName = Ext.getCmp('componentTypCombo').getValue();
					if(selectedCompType != null && selectedCompType !='null' && selectedCompType !=undefined && selectedCompType !='undefined' && selectedCompType != '')
					{
						compTypeName = selectedCompType;
					}
					var metrics_containerObj = Ext.getCmp('metrics_container');
					metrics_containerObj.removeAll(true);
					var filterr = requestParams.filter;
					if(filterr == "Service")
						filterr = "services";

					var nickNameVal="";
					if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
					{
						nickNameVal = Ext.getCmp('nickName').getValue();
					}
					if(componentNameSearch != null && componentNameSearch !='null' && componentNameSearch != undefined &&  componentNameSearch != 'undefined')
					{
						nickNameVal = componentNameSearch;
					}
					var metricsURL = '/final/monitor/comparisonComponent.jsp?treeTitle=rumcomponents&selectedState=&componentNameSearch='+nickNameVal+'&fromPageView=CitrixDashboard&viewPageTitle=Components&action=component&fromHomepage=&userName=&filterBy='+filterr+'&subFilter='+requestParams.filterBy+'&timeline=null&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+"&dashboard_name=rum_Dashboard&view_name=metrics_View&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone+"&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&isRumComp=true&componentType="+compTypeName;

					var compTypeComboFlag = false;
					if(requestParams.filter.toLowerCase().indexOf("component") > -1)
						compTypeComboFlag = true;
					metrics_containerObj.add({
						xtype:'generalMeasuresGridPanel',
						id:'perPanel',
						//cls:'gridHeadercenter',
						//ui:'eg-x-panel',
						itemId:"components",
						margin:'0 0 0 0',
						padding:'0 0 0 0',
						frame:false,
						//height:250,
						border:true,
						style:{'z-index':'0'},
						layout:{type:'vbox',align:'stretch'},
						//flex:1,
						disableCombo:true,
						disableCompTypeCombo:compTypeComboFlag,
						screenLabelPath:"monitor.CitrixDashboard",
						url:metricsURL,
						listeners: {
							'afterrender': function (obj) {
								this.loadTab(obj.url,'','','','','','rumAppFlowComponent');
							},
							'resize':function(panel){
									//alert(panel.height);
									panel.setHeight(Ext.getBody().getViewSize().height-80);
							}
						}
					});							
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "systems_View" )
				{
					var system_containerObj = Ext.getCmp('system_container');
					system_containerObj.removeAll(true);

					Ext.getCmp('settingIconId').show();

					var filterr = requestParams.filter;
					if(filterr == "Service")
						filterr = "services";

					var selectedRum = titleApplies;
					if(rumPageParams.serviceCombo[0].rumcomboNeeded)
						selectedRum = rumPageParams.serviceCombo[0].selectedRum;
					
					system_containerObj.add({
						xtype:'dashboardgeneralmeasuresgridpanel',
						id:'systemViewMeasuresgridpanel',
						layout:'fit',
						cls:'gridHeadercenter',
						itemId:'system',
						margin:'0 0 0 0',
						padding:10,
						frame:false,
						border:true,
						screenLabelPath:"monitor.serviceDashboard",
						url:"/final/monitor/serviceSystem.jsp?treeTitle=services&selectNode=Service$cap$"+encodeURIComponent(requestParams.filterBy)+"&selectedParam="+encodeURIComponent(requestParams.filterBy)+"&componentType="+encodeURI(SysComponentType)+"&currentTab=Systems&isSite=true&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&refresh=true&action=Systems&topoSegment="+encodeURIComponent(requestParams.filterBy)+'&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&hasRUM=true&dashboard_name=RUM_Dashboard&view_name=systems_View&fromServiceHomePage=true&isFromZone='+backParams.isFromZone+"&iszoneName="+encodeURIComponent(backParams.iszoneName)+"&parentZone="+backParams.parentZone+"&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup,
						listeners:{
							'resize':function(panel){
									panel.setHeight(Ext.getBody().getViewSize().height-75);
							},
							'afterrender': function (obj) {
								this.loadTab(obj.url,'rumAppFlowSystem');
							}
						}
					});							
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "aggregates_View" )
				{
					var aggregate_containerObj = Ext.getCmp('aggregate_container');
					aggregate_containerObj.removeAll(true);
					var filterr = requestParams.filter;
					if(filterr == "Service")
						filterr = "services";

					var selectedRum = titleApplies;
					if(rumPageParams.serviceCombo[0].rumcomboNeeded)
						selectedRum = rumPageParams.serviceCombo[0].selectedRum;

					aggregate_containerObj.add({
						xtype:'dashboardgeneralmeasuresaggregatepanel',
						id:'systemViewAggregatesgridpanel',
						cls:'gridHeadercenter',
						itemId:'aggregates',
						margin:'10 0 0 0',
						padding:0,
						frame:false,
						border:false,
						//layout:{type:'vbox',align:'stretch'},
						//height:300,
						//style:{'overflow':'auto'},
						scroll:true,
						autoScroll:true,
						height:'100%',
						style:{'overflow':'auto','background':'#fff'},
						//height:200
						screenLabelPath:"monitor.serviceDashboard",
						url:"/final/monitor/serviceAggregate.jsp?treeTitle=rumaggregate&selectNode=Service$cap$"+encodeURIComponent(requestParams.filterBy)+"&selectedParam="+encodeURIComponent(requestParams.filterBy)+"&currentTab=Aggregates&isSite=true&aggregateTab=true&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&refresh=true&action=Aggregates&topoSegment="+encodeURIComponent(requestParams.filterBy)+'&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&dashboard_name=rum_Dashboard&view_name=aggregates_View&fromServiceHomePage=true&isFromZone='+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone+"&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup,
						listeners:{
							'resize':function(panel){
									panel.setHeight(Ext.getBody().getViewSize().height-65);
							},
							'afterrender': function (obj) {
								this.loadTab(obj.url,'rumAppFlowAggregate');
							},
						}
					});							
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "Web_Transaction_Sub_View" )
				{
					var chartToolbar=Ext.getCmp("timeWindow");
				
					var timeline=Ext.ComponentQuery.query('floatingContainer > panel > combo[itemId= "timeline"]');
										
					if(!Ext.isEmpty(timeline) && !Ext.isEmpty(timeline[0].value)){
						//starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
						timeLineValueForRefresh=timeline[0].value;
					}
			
					var startTimeField=Ext.ComponentQuery.query('floatingContainer > panel > datefield[itemId= "from"]');
					if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(startTimeField[0].value)){
						//starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
						fromDateValueForRefresh=startTimeField[0].value;
					}
					
					var endTimeField=Ext.ComponentQuery.query('floatingContainer > panel > datefield[itemId= "to"]');
					if(!Ext.isEmpty(endTimeField) && !Ext.isEmpty(endTimeField[0].value)){
						//endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
						toDateValueForRefresh=endTimeField[0].value;
					}

					var fromCombo=Ext.ComponentQuery.query('floatingContainer > panel > combo[itemId= "fromhr"]');
					if(!Ext.isEmpty(fromCombo) && !Ext.isEmpty(fromCombo[0].value)){
						fromHrValueForRefresh=fromCombo[0].value;
					}			  

					var toCombo=Ext.ComponentQuery.query('floatingContainer > panel > combo[itemId= "tohr"]');
					if(!Ext.isEmpty(toCombo) && !Ext.isEmpty(toCombo[0].value)){
						toHrValueForRefresh=toCombo[0].value;
					}

					//Get Minutes
					var fromMinCombo=Ext.ComponentQuery.query('floatingContainer > panel > combo[itemId= "frommin"]');
					if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo[0].value)){
						fromMinValueForRefresh=fromMinCombo[0].value;
					}			

					var toMinCombo=Ext.ComponentQuery.query('floatingContainer > panel > combo[itemId= "tomin"]');
					if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo[0].value)){
						toMinValueForRefresh=toMinCombo[0].value;
					}

					var dashboard_view_container_gridObj = Ext.getCmp('dashboard_view_container_grid');	
					var dashboard_view_container_chartObj = Ext.getCmp('dashboard_view_container_chart');	
					var dashboard_view_header_idObj = Ext.getCmp('dashboard_view_header_id');
					if(!Ext.isEmpty(dashboard_view_container_gridObj))
						dashboard_view_container_gridObj.removeAll(true);
					if(!Ext.isEmpty(dashboard_view_container_chartObj))
						dashboard_view_container_chartObj.removeAll(true);
					if(!Ext.isEmpty(dashboard_view_header_idObj))
						dashboard_view_header_idObj.removeAll(true);
					if(!Ext.isEmpty(Ext.getCmp('tabBarHeader1')))
						Ext.getCmp('tabBarHeader1').removeAll(true);
					var selected_dash = '';
					if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
						selected_dash = Ext.getCmp('dashListComId').getValue();
					var d_url = '/final/monitor/transactions.jsp?treeTitle=services&1=1&selectNode=Service$cap$'+encodeURIComponent(requestParams.filterBy)+'&selectedParam='+encodeURIComponent(requestParams.filterBy)+'&currentTab=transactions&isSite=true&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&site='+encodeURIComponent(requestParams.filterBy)+'&isSite=true&serviceName='+encodeURIComponent(requestParams.filterBy)+'&fromLzayer=false&selectNode='+encodeURIComponent(requestParams.filterBy)+'&currentTab=transactions&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(requestParams.filterBy)+'&isfromCitrix=&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&dashboard_name=rum_Dashboard&view_name=Web_Transaction_Sub_View&fromServiceHomePage=true&fromSerComboChange=true&appliesTo='+requestParams.appliesTo+'&filterBy='+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;
					Ext.Ajax.request({
						  url : d_url,
						  timeout:280000,
						  //scope:this,
						  success: function(response){
							var jsonText = response.responseText;
							if(!Ext.isEmpty(jsonText))
							{
								var jsonData = Ext.decode(jsonText);
								this.siteName = jsonData.HiddenFields.siteName;
								  //after refresh the tab value needs to be retained for layout of graphs
								 // if(!Ext.isEmpty(requestParams.selectedTab)){
								  /*if(!Ext.isEmpty(jsonData.HiddenFields.selectedTab)){
									  if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){								 
										  this.tab="emulated";
									  }else{
										  this.tab="web";
									  }
								  }*/
								//this.loadTransaction(jsonData);
								//this.getTransactionsMainPanel().showTransactionGridPanel(jsonData.GridScreenLabels,jsonData);
								var screenLabels = jsonData.GridScreenLabels;
								var compType = jsonData.HiddenFields.compType;
								var compName = jsonData.HiddenFields.compName;
								var siteName = jsonData.HiddenFields.siteName;
								var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
								var isTransEnabled = ( !Ext.isEmpty(screenLabels["webBtnLabel"]) )?true:false;
								var isTabChanged = ( !Ext.isEmpty(jsonData['isTabChanged']) )?true:false;
								var isFromRefresh = ( !Ext.isEmpty(jsonData['fromRefresh']) )?true:false;
								var isLogonEnabled = jsonData.HiddenFields.isLogonSimul;
								var refreshing = jsonData.HiddenFields.Refreshing;
								var innerActiveTab = jsonData.HiddenFields.innerActiveTab;
								var graphParam = jsonData.HiddenFields.timelineParam;

								if(!Ext.isEmpty(jsonData.HiddenFields))
								{
									serviceRefSortByLogon = jsonData.HiddenFields.serviceRefSortByLogon;
									serviceRefSortByLogonType = jsonData.HiddenFields.serviceRefSortByLogonType;
									serviceRefSortByLogonId = jsonData.HiddenFields.serviceRefSortByLogonId;
								}

								var ComponentList = jsonData.ComponentList;
								var externalAgentsList = jsonData.externalAgents;
								var logonComponentList = jsonData.logonComponentList;
								var componentListObj = jsonData.componentListObj;
								var isSingleCompType = false;
								if(jsonData.componentListObj != null && jsonData.componentListObj['options'].length==1)
								{
									isSingleCompType = true;
									singleComponentTypeValue = jsonData.componentListObj['options'][0].value;
									singleComponentTypeName = jsonData.componentListObj['options'][0].name;
								}
								var label='',selectedVal='',simLabel='',compLabel='',simulationSelectedVal='',compSelectedVal='',simulationSelectedOrgValue = '';
								var defalutHide = false;
								var isComponentType = true;
								var comboStore,simulationComboStore,compStroe;

								/*if(!Ext.isEmpty(componentListObj) && componentListObj!=null && componentListObj!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled)))
								{
									isComponentType = false;
									compStroe = Ext.create('Ext.data.Store',{
										fields:['value', 'name', 'url'],
										proxy:{
											type: 'memory',
											reader: {
												type: 'json',
												root:'options'
											}
										},
										data:componentListObj
									});
									compLabel = componentListObj.label;
									compSelectedVal = componentListObj.selectedValue;
									selectedCompType =componentListObj.selectedValue;
								}*/

								
								if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
									comboStore = Ext.create('Ext.data.Store',{
										fields:['value', 'name', 'comptype'],
										proxy:{
											type: 'memory',
											reader: {
												type: 'json',
												root:'options'
											}
										},
										data:ComponentList
									});
									defalutHide = false;
									label = ComponentList.label;
									selectedVal = ComponentList.selectedValue;
								}
								else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
									extAgentData = externalAgentsList;
									//externalAgentsList = externalAgentsList[simulationSelectedVal];
									comboStore = Ext.create('Ext.data.Store',{
										fields:['value', 'name'],
										proxy:{
											type: 'memory',
											reader: {
												type: 'json',
												root:'options'
											}
										},
										data:externalAgentsList
									});
									defalutHide = false;
									label = extAgentData.label;
									selectedVal = externalAgentsList.selectedValue;
								}
								else
									defalutHide = true;
								
								/*if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined)
								{
									logonComponentList = logonComponentList[selectedVal];
									simulationComboStore = Ext.create('Ext.data.Store',{
										fields:['value', 'name', 'comptype'],
										proxy:{
											type: 'memory',
											reader: {
												type: 'json',
												root:'options'
											}
										},
										data:logonComponentList
									});
									simLabel = logonComponentList.label;
									simulationSelectedVal = logonComponentList.selectedValue;
									simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
								}*/
								var serviceState = "GOOD";
								serviceState=jsonData.GridScreenLabels.siteState;
								var simulationComboHide = true;
								if(!Ext.isEmpty(innerActiveTab) && innerActiveTab != null && innerActiveTab != undefined && innerActiveTab == 'logonSim')
									simulationComboHide = false;
								curViewTab = innerActiveTab;
								if(singleComponentTypeName != '' && singleComponentTypeName != null && singleComponentTypeName != undefined)
								{
									singleComponentTypeName = singleComponentTypeName.toUpperCase();
									dashboard_view_header_idObj.setTitle("USER EXPERIENCE - "+singleComponentTypeName+" <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' data-qtip='Layer Model' class='iconLayerstack mouse' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','WebTransactions','Web_Transaction_Sub_View','"+requestParams.iniName+"','"+requestParams.user_name+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('topology_view')\"/>");
								}
								else
								{
									dashboard_view_header_idObj.setTitle("USER EXPERIENCE - WEB TRANSACTIONS <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' data-qtip='Layer Model' class='iconLayerstack mouse' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','WebTransactions','Web_Transaction_Sub_View','"+requestParams.iniName+"','"+requestParams.user_name+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('topology_view')\"/>");
								}
								//dashboard_view_header_idObj.setTitle("USER EXPERIENCE - WEB TRANSACTIONS");
								dashboard_view_header_idObj.addTool(
								{
									xtype:'container',
									id:'tabBarHeader1',
									layout:{type:'hbox',align:'right'},
									margin:'10 0 0 0',
									style:{'float':'right'},
									items:[
									/*{
										xtype:'label',
										cls:"service20_"+serviceState,
										border:0,
										margin:'0 0 0 0'
									},{
										xtype:'label',
										margin:'2 0 0 0',
										html:'&nbsp;<span class="font_bold13 fontStyleRobot" >SITE :</span> <span style="margin-right:6px;" class="font_normal13 fontStyleRobot">'+screenLabels["Title"]+'</span>'		
									},
									{xtype:'tbseparator',height:21,style:{'width':'1px !important','background-position':'right top !important'}},
									{
										xtype:'button',
										tooltip:'Layer Model',
										style:{'border':'none'},
										margin:'3 0 0 0',
										cls:'iconLayerstack',
										handler: function() {
											DashboardToLayers(compName,compType,siteName,'WebTransactions','Web_Transaction_Sub_View',requestParams.iniName,requestParams.user_name);
										}
									},
									{xtype:'tbseparator',height:21,style:{'width':'1px !important','background-position':'right top !important'}},
									{
										xtype:'button',
										tooltip:'Topology',
										style:{'border':'none','top':'3px !important'},
										cls:'iconTopology',
										margin:'3 0 0 0',
										handler: function() {
											//DashboardToTopology();
											loadView('topology_view');
										}
									},*/
									/*{
										xtype:'combo',
										id:'compTypeCombo',
										itemId:'compTypeCombo',
										labelAlign : 'left',
										editable : false,
										store:compStroe,
										hidden:isComponentType,
										labelSeparator:'',
										cls : 'dropdown',
										displayField: 'name',
										valueField: 'value',
											url:'url',
										trigerAction:'all',
										fieldLabel:compLabel+':',
										labelWidth:60,
										width:250,
										queryMode: 'local',
										margin:'0 0 0 20',
										value:compSelectedVal,
										listeners:{
											'change':function(e){
												RumAppFlow.app.getController('Main').onComponentTypeChange(this,'logonSim',siteName,compSelectedVal,selected_view_name);
											}
										}
									},*/
									{
										xtype:'combo',
										id:'componentCombo',
										itemId:'componentCombo',
										editable : false,
										labelWidth:75,
										margin:'0 0 0 10',
										hidden:defalutHide,
										store:comboStore,
										cls : 'dropdown',
										width:290,
										displayField:'name',
										valueField:'value',
										trigerAction:'all',
										fieldLabel:''+label,
										value:selectedVal,
										queryMode : 'local',
										listeners:{
											'change':function(e){
												RumAppFlow.app.getController('Main').onComponentChange(this,'webTrans',siteName);
											}	
										}
									}
									/*,
									{
										xtype:'combo',
										id:'simulationCombo',
										itemId:'simulationCombo',
										editable : false,
										margin:'0 0 0 20',
										width:290,
										hidden:simulationComboHide,
										store:simulationComboStore,
										cls : 'dropdown',
										displayField:'name',
										valueField:'value',
										trigerAction:'all',
										fieldLabel:''+simLabel,
										labelWidth:80,
										value:simulationSelectedOrgValue,
										queryMode : 'local',
										listeners:{
											'change':function(e){
												RumAppFlow.app.getController('Main').onSimulationChange(this,'logonSim',siteName);
											}	
										}
									},*/
									/*{
										xtype:'combo',
										id:'simulationCombo',
										itemId:'simulationCombo',
										editable : false,
										margin:'0 0 0 10',
										width:290,
										hidden:simulationComboHide,
										store:simulationComboStore,
										cls : 'dropdown',
										displayField:'name',
										valueField:'value',
										trigerAction:'all',
										fieldLabel:''+simLabel,
										labelWidth:80,
										value:simulationSelectedOrgValue,
										queryMode : 'local'
									}*/
									]
									}
								);
								dashboard_view_container_gridObj.add([{
									xtype:'container',
									ui:'eg-container',
									margin:'0 0 0 0',
									padding:'0 10 10 10',
									items:[{
										xtype:'transactiongridpanel',
										ui:'newGridPanel',
										id:'transactiongridpanelid',
										//title:'<span class="font_bold12">Transactions</span>',
										//columnWidth:1.0,
										jsonData:jsonData,
										isEmuEnabled:isEmuEnabled,								
										//bodyPadding:10,
										id:'transGrid1',
										height:185,
										//flex:0.43,
										border:true
									}]
								
								}]);
								try
								{
									dashboard_view_container_chartObj.add([{
									xtype:'container',
									//ui:'eg-container',
									margin:'10 2 0 0',
									//padding:10,
									//height:220,
									items:[{
										xtype:'transactionschartpanel',
										id:'transactionschartpanelid',
										//height:500,
										//minHeight:250,
										//title:'Graphs',
										//columnWidth:1.0,
										jsonData:jsonData,								
										padding:0,
										//flex:0.57,
										border:false,
										layout:{type:'fit'},
										//style:{'overflow':'auto'}
										
									}]
									}]);
									
								}
								catch (e1)
								{
								}
						   }
						  },
						failure:function(){
							  //window.parent.location.href="/final/servlet/com.egurkha.Logout";
						}
					  });
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "Emulated_Transaction_Sub_View" )
				{
					var d_url = '/final/monitor/transactions.jsp?treeTitle=services&1=1&selectNode=Service$cap$'+encodeURIComponent(requestParams.filterBy)+'&selectedParam='+encodeURIComponent(requestParams.filterBy)+'&currentTab=transactions&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=true&fromHomepage=&hasLogonSimulations=false&site='+encodeURIComponent(requestParams.filterBy)+'&isSite=true&serviceName='+encodeURIComponent(requestParams.filterBy)+'&fromLayer=false&selectNode='+encodeURIComponent(requestParams.filterBy)+'&selectedParam='+encodeURIComponent(requestParams.filterBy)+'&currentTab=transactions&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(requestParams.filterBy)+'&isfromCitrix=&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&dashboard_name=Rum_Dashboard&view_name=Emulated_Transaction_Sub_View&fromServiceHomePage=true&fromSerComboChange=true&appliesTo='+requestParams.appliesTo+'&filterBy='+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;
					Ext.Ajax.request({
					  url : d_url,
					  timeout:280000,
					  //scope:this,
					  success: function(response){
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							var jsonData = Ext.decode(jsonText);
							this.siteName = jsonData.HiddenFields.siteName;
							var compType = jsonData.HiddenFields.compType;
							var compName = jsonData.HiddenFields.compName;
							var siteName = jsonData.HiddenFields.siteName;
							var isWebTrans = jsonData.HiddenFields.isWebTrans;
							
							if(!Ext.isEmpty(sess_sim_compType))
							compType=sess_sim_compType;

							if(!Ext.isEmpty(sess_sim_comp))
								compName=sess_sim_comp;

							var script = selectedScript;
							if(!Ext.isEmpty(sess_sim_script))
								script=sess_sim_script;
						
							var siteBasedWeb = "NULL";
							if(isWebTrans=='true')
							 siteBasedWeb = requestParams.filterBy;
						
						Ext.get('sessionSimTopology').dom.src="/final/monitor/sessionSimulation.jsp?scriptName="+script+"&compName="+compName+"&site="+siteBasedWeb+"&compType="+compType+"&serviceName="+requestParams.filterBy+"&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&appliesTo="+requestParams.appliesTo+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone+"&isRum=true";
						//Ext.get('sessionSimTopology').dom.src="/final/monitor/sessionSimulation.jsp?compName="+compName+"&site=NULL&compType="+compType;
						}
					  }
					});
							
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "Logon_Sub_View" )
				{
										
					var chartToolbar=Ext.getCmp("timeWindow");
				
					var timeline=Ext.ComponentQuery.query('floatingContainer > panel > combo[itemId= "timeline"]');
										
					if(!Ext.isEmpty(timeline) && !Ext.isEmpty(timeline[0].value)){
						//starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
						timeLineValueForRefresh=timeline[0].value;
					}
			
					var startTimeField=Ext.ComponentQuery.query('floatingContainer > panel > datefield[itemId= "from"]');
					if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(startTimeField[0].value)){
						//starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
						fromDateValueForRefresh=startTimeField[0].value;
					}
					
					var endTimeField=Ext.ComponentQuery.query('floatingContainer > panel > datefield[itemId= "to"]');
					if(!Ext.isEmpty(endTimeField) && !Ext.isEmpty(endTimeField[0].value)){
						//endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
						toDateValueForRefresh=endTimeField[0].value;
					}

					var fromCombo=Ext.ComponentQuery.query('floatingContainer > panel > combo[itemId= "fromhr"]');
					if(!Ext.isEmpty(fromCombo) && !Ext.isEmpty(fromCombo[0].value)){
						fromHrValueForRefresh=fromCombo[0].value;
					}			  

					var toCombo=Ext.ComponentQuery.query('floatingContainer > panel > combo[itemId= "tohr"]');
					if(!Ext.isEmpty(toCombo) && !Ext.isEmpty(toCombo[0].value)){
						toHrValueForRefresh=toCombo[0].value;
					}

					//Get Minutes
					var fromMinCombo=Ext.ComponentQuery.query('floatingContainer > panel > combo[itemId= "frommin"]');
					if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo[0].value)){
						fromMinValueForRefresh=fromMinCombo[0].value;
					}			

					var toMinCombo=Ext.ComponentQuery.query('floatingContainer > panel > combo[itemId= "tomin"]');
					if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo[0].value)){
						toMinValueForRefresh=toMinCombo[0].value;
					}

					var selected_view_name = "Logon_Sub_View";
					var compObj = Ext.getCmp('compTypeCombo');
					var compValue ='';
					if(!Ext.isEmpty(compObj) && compObj !=null && compObj != undefined)
					{
						compValue = compObj.getValue();
					}
					else if(singleComponentTypeValue != '' && singleComponentTypeValue != null && singleComponentTypeValue != undefined)
					{
						compValue = singleComponentTypeValue;
					}

					var extMonitorObj = Ext.getCmp('componentCombo');
					var extMonitorValue = extMonitorObj.getValue();
				
					var simObj = Ext.getCmp('simulationCombo');
					refreshSimulation = simObj.getValue();
					var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
					var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	
					var dashboard_header_idObj = Ext.getCmp('dashboard_view_header_id');
					if(!Ext.isEmpty(dashboard_grid_containerObj))
						dashboard_grid_containerObj.removeAll(true);
					if(!Ext.isEmpty(dashboard_chart_containerObj))
						dashboard_chart_containerObj.removeAll(true);
					if(!Ext.isEmpty(dashboard_header_idObj))
						dashboard_header_idObj.removeAll(true);
					if(!Ext.isEmpty(Ext.getCmp('tabBarHeader1')))
						Ext.getCmp('tabBarHeader1').removeAll(true);
					var selected_dash = '';
					if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
						selected_dash = Ext.getCmp('dashListComId').getValue();
					
					var appliesToValue = '';
					if(requestParams.appliesTo != null && requestParams.appliesTo !='null' && requestParams.appliesTo != '' && requestParams.appliesTo!= undefined && requestParams.appliesTo != 'undefined')
					{
							appliesToValue = requestParams.appliesTo;
					}
					else
					{
						if(!Ext.isEmpty(Ext.getCmp("componentsDropDown1")))
							appliesToValue = Ext.getCmp("componentsDropDown1").getValue();
					}

					var d_url = '/final/monitor/transactions.jsp?componentType='+compValue+'&treeTitle=services&selectNode=Service$cap$'+encodeURIComponent(requestParams.filterBy)+'&selectedParam='+encodeURIComponent(requestParams.filterBy)+'&currentTab=logon&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&site='+encodeURIComponent(requestParams.filterBy)+'&isSite=true&serviceName='+encodeURIComponent(requestParams.filterBy)+'&fromLayer=false&selectNode='+encodeURIComponent(requestParams.filterBy)+'&currentTab=logon&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(requestParams.filterBy)+'&isfromCitrix=&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&dashboard_name=rum_Dashboard&view_name=Logon_Sub_View&fromServiceHomePage=true&fromSerComboChange=true&appliesTo='+appliesToValue+'&filterBy='+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;
					Ext.Ajax.request({
						url : d_url,
						timeout:280000,
						success: function(response){
							var jsonText = response.responseText;
							if(!Ext.isEmpty(jsonText))
							{
								var jsonData = Ext.decode(jsonText);
								this.siteName = jsonData.HiddenFields.siteName;
								//after refresh the tab value needs to be retained for layout of graphs
								// if(!Ext.isEmpty(requestParams.selectedTab)){
								/*if(!Ext.isEmpty(jsonData.HiddenFields.selectedTab)){
								if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){								 
								this.tab="emulated";
								}else{
								this.tab="web";
								}
								}*/
								//this.loadTransaction(jsonData);
								//this.getTransactionsMainPanel().showTransactionGridPanel(jsonData.GridScreenLabels,jsonData);
								var screenLabels = jsonData.GridScreenLabels;
								var compType = jsonData.HiddenFields.compType;
								var compName = jsonData.HiddenFields.compName;
								var siteName = jsonData.HiddenFields.siteName;
								gLogonParam = jsonData.logonParam;
								var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
								var isTransEnabled = ( !Ext.isEmpty(screenLabels["webBtnLabel"]) )?true:false;
								var isTabChanged = ( !Ext.isEmpty(jsonData['isTabChanged']) )?true:false;
								var isFromRefresh = ( !Ext.isEmpty(jsonData['fromRefresh']) )?true:false;
								var isLogonEnabled = jsonData.HiddenFields.isLogonSimul;
								var refreshing = jsonData.HiddenFields.Refreshing;
								var innerActiveTab = jsonData.HiddenFields.innerActiveTab;
								//var graphParam = jsonData.HiddenFields.timelineParam;
								var graphParam = jsonData.HiddenFields.timelineParam;
								var timelineUrl = '';
								if(!Ext.isEmpty(graphParam) && graphParam != null && graphParam != undefined)
								{
									timelineUrl = '&mode='+graphParam.mode+'&time_line='+graphParam.time_line+'&starthr='+graphParam.starthr+'&endhr='+graphParam.endhr+'&starttime='+graphParam.starttime+'&endtime='+graphParam.endtime+'&startmin='+graphParam.startmin+'&endmin='+graphParam.endmin;
								}
								innerActiveTab = "logonSim";
								if(!Ext.isEmpty(jsonData.HiddenFields))
								{
								serviceRefSortByLogon = jsonData.HiddenFields.serviceRefSortByLogon;
								serviceRefSortByLogonType = jsonData.HiddenFields.serviceRefSortByLogonType;
								serviceRefSortByLogonId = jsonData.HiddenFields.serviceRefSortByLogonId;
								}

								var ComponentList = jsonData.ComponentList;
								var externalAgentsList = jsonData.externalAgents;
								var logonComponentList = jsonData.logonComponentList;
								var componentListObj = jsonData.componentListObj;
								var isSingleCompType = false;
								if(jsonData.componentListObj != null && jsonData.componentListObj['options'].length==1)
								{
									isSingleCompType = true;
									singleComponentTypeValue = jsonData.componentListObj['options'][0].value;
									singleComponentTypeName = jsonData.componentListObj['options'][0].name;
								}
								var label='',compLabel='',selectedVal='',simLabel='',simulationSelectedVal='',simulationSelectedOrgValue = '',compSelectedVal='';
								var isComponentType = true;
								var defalutHide = false;
								var comboStore,simulationComboStore,compStroe;
								
								if(!Ext.isEmpty(componentListObj) && componentListObj!=null && componentListObj!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled)))
								{
									isComponentType = false;
									compStroe = Ext.create('Ext.data.Store',{
										fields:['value', 'name', 'url'],
										proxy:{
											type: 'memory',
											reader: {
												type: 'json',
												root:'options'
											}
										},
										data:componentListObj
									});
									compLabel = componentListObj.label;
									compSelectedVal = componentListObj.selectedValue;
									selectedCompType =componentListObj.selectedValue;
								}
								if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
									comboStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name', 'comptype'],
									proxy:{
									type: 'memory',
									reader: {
									type: 'json',
									root:'options'
									}
									},
									data:ComponentList
									});
									defalutHide = false;
									label = ComponentList.label;
									selectedVal = ComponentList.selectedValue;
								}
								else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
									extAgentData = externalAgentsList;
									//externalAgentsList = externalAgentsList[simulationSelectedVal];
									comboStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name'],
									proxy:{
									type: 'memory',
									reader: {
									type: 'json',
									root:'options'
									}
									},
									data:externalAgentsList
									});
									defalutHide = false;
									label = extAgentData.label;
									if(!Ext.isEmpty(extMonitorValue) && extMonitorValue != null)
									{
										selectedVal = extMonitorValue;
									}
									else
									{
										selectedVal = externalAgentsList.selectedValue;
									}
								}
								else
								defalutHide = true;
								
								if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined)
								{
									logonComponentList = logonComponentList[selectedVal];
									simulationComboStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name', 'comptype'],
									proxy:{
									type: 'memory',
									reader: {
									type: 'json',
									root:'options'
									}
									},
									data:logonComponentList
									});
									simLabel = logonComponentList.label;
									simulationSelectedVal = logonComponentList.selectedValue;
									
									if(!Ext.isEmpty(refreshSimulation) && refreshSimulation != null)
									{
										if(refreshSimulation.indexOf(":")>-1)
										{
											var componentVal = refreshSimulation;
											componentVal = componentVal.substring(0,componentVal.indexOf(":"));
											selectedSimulation = componentVal;
										}
										simulationSelectedOrgValue = refreshSimulation;
									}
									else
									{
										selectedSimulation = logonComponentList.selectedValue;
										simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
									}
								}

								if(isSingleCompType)
								{
									isComponentType = true;
								}
								var serviceState = "GOOD";
								serviceState=jsonData.GridScreenLabels.siteState;
								var simulationComboHide = true;
								if(!Ext.isEmpty(innerActiveTab) && innerActiveTab != null && innerActiveTab != undefined && innerActiveTab == 'logonSim')
								simulationComboHide = false;
								curViewTab = innerActiveTab;
								if(singleComponentTypeName != '' && singleComponentTypeName != null && singleComponentTypeName != undefined)
								{
									singleComponentTypeName = singleComponentTypeName.toUpperCase();
									dashboard_header_idObj.setTitle("USER EXPERIENCE - "+singleComponentTypeName+" <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' data-qtip='Layer Model' class='iconLayerstack mouse' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','logonSim','Logon_Sub_View','"+requestParams.iniName+"','"+requestParams.user_name+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('topology_view')\"/>");
								}
								else
								{
									dashboard_header_idObj.setTitle("USER EXPERIENCE - LOGON SIMULATIONS <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' data-qtip='Layer Model' class='iconLayerstack mouse' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','logonSim','Logon_Sub_View','"+requestParams.iniName+"','"+requestParams.user_name+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('topology_view')\"/>");
								}
								//dashboard_header_idObj.setTitle("USER EXPERIENCE - LOGON SIMULATIONS");
								dashboard_header_idObj.addTool(
									{
										xtype:'container',
										id:'tabBarHeader1',
										layout:{type:'hbox',align:'right'},
										margin:'10 0 0 0',
										style:{'float':'right','border':'none !important'},
										items:[
										/*{
											xtype:'label',
											cls:"service20_"+serviceState,
											border:0,
											margin:'1 0 0 0'
										},{
											xtype:'label',
											margin:'2 0 0 0',
											html:'&nbsp;<span style="margin-right:6px;" class="font_normal13 fontStyleRobot">'+screenLabels["Title"]+'</span>'		
										},
										{xtype:'tbseparator',height:20,style:{'width':'1px !important','background-position':'right top !important'}},
										{
											xtype:'button',
											tooltip:'Layer Model',
											style:{'border':'none'},
											cls:'iconLayerstack',
											margin:'3 0 0 0',
											handler: function() {
												DashboardToLayers(compName,compType,siteName,'logonSim','Logon_Sub_View',requestParams.iniName,requestParams.user_name);
											}
										},
										{xtype:'tbseparator',height:20,style:{'width':'1px !important','background-position':'right top !important'}},
										{
											xtype:'button',
											tooltip:'Topology',
											style:{'border':'none'},
											cls:'iconTopology',
											margin:'3 0 0 0',
											handler: function() {
												//DashboardToTopology();
												loadView('topology_view');
											}
										},*/
										{
											xtype:'combo',
											id:'compTypeCombo',
											itemId:'compTypeCombo',
											labelAlign : 'left',
											editable : false,
											store:compStroe,
											hidden:isComponentType,
											labelSeparator:'',
											cls : 'dropdown',
											displayField: 'name',
											valueField: 'value',
												url:'url',
											trigerAction:'all',
											fieldLabel:compLabel+':',
											labelWidth:100,
											width:290,
											queryMode: 'local',
											margin:'0 0 0 20',
											value:compSelectedVal,
											listeners:{
												'change':function(e){
													RumAppFlow.app.getController('Main').onComponentTypeChange(this,'logonSim',siteName,compSelectedVal,selected_view_name);
												}
											}
										},
										{
											xtype:'combo',
											id:'componentCombo',
											itemId:'componentCombo',
											editable : false,
											margin:'0 0 0 20',
											hidden:defalutHide,
											store:comboStore,
											cls : 'dropdown',
											width:290,
											displayField:'name',
											valueField:'value',
											trigerAction:'all',
											fieldLabel:''+label,
											labelWidth:100,
											value:selectedVal,
											queryMode : 'local',
											listeners:{
												'change':function(e){
													RumAppFlow.app.getController('Main').onComponentChange(this,'logonSim',siteName,simulationSelectedOrgValue,selected_view_name);
												}	
											}
										},
										{
											xtype:'combo',
											id:'simulationCombo',
											itemId:'simulationCombo',
											editable : false,
											margin:'0 0 0 20',
											width:270,
											hidden:simulationComboHide,
											store:simulationComboStore,
											cls : 'dropdown',
											displayField:'name',
											valueField:'value',
											trigerAction:'all',
											fieldLabel:''+simLabel,
											labelWidth:70,
											value:simulationSelectedOrgValue,
											queryMode : 'local',
											listeners:{
												'change':function(e){
													RumAppFlow.app.getController('Main').onSimulationChange(this,'logonSim',siteName,simulationSelectedOrgValue,selected_view_name);
												}	
											}
										}
										]
									}
								);
								var selected_dash = '';
								if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
									selected_dash = Ext.getCmp('dashListComId').getValue();
								
								//if(siteName != null)
									//fromServiceDashboard = true;
								var simulationSelectedOrgValue1 = "";
								if(simulationSelectedOrgValue != null && simulationSelectedOrgValue.indexOf(":NULL") > -1)
									simulationSelectedOrgValue1 = simulationSelectedOrgValue.substring(0,simulationSelectedOrgValue.indexOf(":NULL"));
								else
									simulationSelectedOrgValue1 = simulationSelectedOrgValue;


								var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?treeTitle=LogonSimulation&monitorsBy=LogonSimulator&componentType=&selectedState=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedVal+"&isfromCitrix=&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=Rum_Dashboard&view_name="+selected_view_name+"&fromServiceDashboard=false&servicename="+siteName+"&fromSerComboChange=true&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&isLogonType=true";
								
								if(gLogonParam != null && gLogonParam != '' && gLogonParam != undefined)
									perf_url = 		"/final/monitor/comparisonLogonSimulator.jsp?"+gLogonParam+"&componentType=&selectedState=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedVal+"&isfromCitrix=&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=Rum_Dashboard&view_name="+selected_view_name+"&fromServiceDashboard=false&servicename="+siteName+"&fromSerComboChange=true&fromServiceHomePage=true&appliesTo="+appliesToValue+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone+"&isLogonType=true";

								var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selectedVal+"&simulationName="+simulationSelectedOrgValue;
								
								Ext.Ajax.request({
									url : transurl,
									scope:this,
									success: function(response){
										var jsonText = response.responseText;
										//var panelArr = new Array();
										if(!Ext.isEmpty(jsonText))
										{
											var jsondata1 = Ext.decode(jsonText);
											if(jsondata1 != null && jsondata1 != undefined)
											{
												dashboard_grid_containerObj.add({
													xtype:'generalMeasuresGridPanel',
													//title:titlesys,
													//title:perf_disp_name+" --Man At Work--",
													cls:'gridHeadercenter iconGrid',
													//itemId:itemIdforsysandcom,
													itemId:'logonSimualtion',
													searchBoxCombo:false,
													margin:0,
													padding:3,
													id:'perPanel',
													height:185,
													frame:false,
													border:true,
													layout:{type:'vbox',align:'stretch'},
													flex:1,
													screenLabelPath:"monitor.Dashboard",
													url:perf_url,
													listeners: {
														'afterrender': function (obj) {
															this.loadTab(obj.url,null,null,null,null,true,'rumAppFlow');
														}
													}
												});
												//panelArr.push({
												dashboard_chart_containerObj.add({
													xtype:'transactionschartpanel',
													id:'transactionschartpanelid',
													//animCollapse:true,
													//columnWidth:1.0,
													//height:255,
													height:(Ext.getBody().getViewSize().height-287),
													//flex:1,
													jsonData:jsondata1,
													//minHeight:265,
													margin:'10 1 0 0',
													//margin:'5 0 0 0',
													padding:0,
													//flex:0.57,
													border:false,
													isNotAreaChart:false
												});
											
												//curViewPort.add(panelArr);
												//curViewPort.doLayout();
											}
										}
									  },
									failure:function(){
										//window.parent.location.href="/final/servlet/com.egurkha.Logout";
									}
								});
							}
						},
						failure:function(){
							//window.parent.location.href="/final/servlet/com.egurkha.Logout";
						}
					});
				}
				RumAppFlow.app.getController('Main').overviewdetailsRenderforRefresh();
				Ext.getBody().unmask();
			},
			failure:function(){
				Ext.getBody().unmask();
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});		
	},
	getDefaultParams:function(){
		var params='';
		if(requestParams != null && requestParams != undefined )
		{
			try
			{
				params='isFrom=rumAppFlow';
				for (var key in requestParams)
					params +='&'+key+'='+requestParams[key];
			}
			catch (e)
			{
				params='';
			}
		}

		return params;
	},
	addGeoPage: function(jsonData,cardObj){
		var me = this,
		card = Ext.getCmp('appflow_ground');
		card.add({
			xtype: 'container',
			id: "cardID",
			//flex: 1,
			//layout: {
			//	type: 'vbox',
			//	align: 'stretch'
			//},
			listeners:{
				'afterrender':function(e){
					var me = this;
					var jsonDetails = jsonData.loadViewDetails;
					me.add(
					{
						xtype: 'overviewdetails',
						id:'overviewdetails_Geo_view',
						data:jsonDetails,
						margin: '0 2 2 0',
						collapsible: false
					},
					{
						xtype: 'container',
						flex: 1,
						height:512,
						margin:'10 2 10 0',
						layout: {
							type: 'hbox',
							align: 'stretch'
						},
						listeners:{
							'afterrender':function(e){
								var me = this;
								me.add({
									xtype: 'container',
									cls:'geopan-border',
									ui:'eg-container',
									margin: '0 2 2 0',
									flex: 0.75,
									layout: {
										type: 'hbox',
										align: 'stretch'
									},
									listeners:{
										'afterrender':function(e){
											var me = this;
											me.add({
												xtype:'panel',												
												flex:0.78,
												layout: {
													type: 'vbox',
													align: 'stretch'
												},
												items:[
													{
														xtype:'header',
														id:'geo_map_header_id',
														//style:{'border':'1px solid pink !important'},
														padding:'0 5 5 0',
														height:35,
													},
													{
														xtype: 'geopanel',
														mapStyle:strRumSkin == "Dark"?'dark':'light', //light,dark,default
														jsonData:jsonData.loadViewDetails[1].Application_Block_1_Value[0][0],
														id:'overview_map_id',
														flex: 0.5,
														//ui:'eg-x-panel',
														margin: '0 10 10 10',
														zoom: 2,
														width: 200,
														height: 500,
														//id: 'maps',
														//gmapType: 'map',
														mapType: 'styled_map', //'roadmap', 'satellite', 'hybrid', 'terrain', 'styled_map',
														center: {
															lat: 40.3780, // Marker latitude
															lng:10.4359 // Marker longitude
														},
														infoBoxArray:[],
														markerArray:[],
														feauturesArray:[],
														stateArray:[],
													}
												]
											},{
												xtype:'geomapdetails',
												id:'geo_id_mapdetails',
												flex: 0.22,											
												jsonData:jsonData.loadViewDetails[1].Application_Block_1_Value[0][0],
											});
										}
									},
									items: []
								}
								);
							}						
						},
						items: []
					},{
						xtype:'container',
						padding:0,
						margin:0,
						height:235,
						layout: {
							 type: 'hbox',
							 align: 'stretch'
						},
						listeners:{
							'afterrender':function(e){
								var me = this;
								me.add(
								{
									xtype: 'responsetimepiechart',
									id:'responsetimepiechart_Geo',
									legendPosition: 'right', // top,left, bottom and right
									legendLayout:'horizontal',
									flex: 1,
									chartMarginTop:10,
									chartMarginRight:10,
									chartMarginLeft:-350,
									chartMarginBottom:10,
									chartLegendUseHTML:true,
									legendOffset:15,
									legendWidth:185,
									legendContainerWidth:370,
									Jdata:jsonData.loadViewDetails[1].Application_Block_1_Value[0][1]
								}, 
								{
									xtype:'rumappflowgrid',									
									id:'gridSlowpagegroups_Geo_view',
									gridData:jsonData.loadViewDetails[1].Application_Block_1_Value[0][2],
									title:jsonData.loadViewDetails[1].Application_Block_1_Value[0][2][0].title
								});
							}
						},
						items: []
					});
				}			
			},
			items: []
		});		
	},
	addwebTransPage: function(jsonData,cardObj){
		var me = this,
		card = Ext.getCmp('appflow_ground');
		card.add({
			xtype: 'container',
			id: "cardID",
			//flex: 1,
			//layout: {
			//	type: 'vbox',
			//	align: 'stretch'
			//},
			listeners:{
				'afterrender':function(e){
					var me = this;
					var d_url = '/final/monitor/transactions.jsp?treeTitle=services&1=1&&selectNode=Service$cap$'+encodeURIComponent(requestParams.filterBy)+'&selectedParam='+encodeURIComponent(requestParams.filterBy)+'&currentTab=transactions&isSite=true&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&site='+encodeURIComponent(requestParams.filterBy)+'&isSite=true&serviceName='+encodeURIComponent(requestParams.filterBy)+'&fromLzayer=false&selectNode='+encodeURIComponent(requestParams.filterBy)+'&currentTab=transactions&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(requestParams.filterBy)+'&isfromCitrix=&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&dashboard_name=rum_Dashboard&view_name=Web_Transaction_Sub_View&fromServiceHomePage=true&fromSerComboChange=true&appliesTo='+requestParams.appliesTo+'&filterBy='+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;
					Ext.Ajax.request({
					  url : d_url,
					  timeout:280000,
					  //scope:this,
					  success: function(response){
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							var jsonData = Ext.decode(jsonText);
							this.siteName = jsonData.HiddenFields.siteName;
							//after refresh the tab value needs to be retained for layout of graphs
							 // if(!Ext.isEmpty(requestParams.selectedTab)){
							  /*if(!Ext.isEmpty(jsonData.HiddenFields.selectedTab)){
								  if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){								 
									  this.tab="emulated";
								  }else{
									  this.tab="web";
								  }
							  }*/
							//this.loadTransaction(jsonData);
							//this.getTransactionsMainPanel().showTransactionGridPanel(jsonData.GridScreenLabels,jsonData);
							var screenLabels = jsonData.GridScreenLabels;
							var compType = jsonData.HiddenFields.compType;
							var compName = jsonData.HiddenFields.compName;
							var siteName = jsonData.HiddenFields.siteName;
							var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
							var isTransEnabled = ( !Ext.isEmpty(screenLabels["webBtnLabel"]) )?true:false;
							var isTabChanged = ( !Ext.isEmpty(jsonData['isTabChanged']) )?true:false;
							var isFromRefresh = ( !Ext.isEmpty(jsonData['fromRefresh']) )?true:false;
							var isLogonEnabled = jsonData.HiddenFields.isLogonSimul;
							var refreshing = jsonData.HiddenFields.Refreshing;
							var innerActiveTab = jsonData.HiddenFields.innerActiveTab;
							var graphParam = jsonData.HiddenFields.timelineParam;

							if(!Ext.isEmpty(jsonData.HiddenFields))
							{
								serviceRefSortByLogon = jsonData.HiddenFields.serviceRefSortByLogon;
								serviceRefSortByLogonType = jsonData.HiddenFields.serviceRefSortByLogonType;
								serviceRefSortByLogonId = jsonData.HiddenFields.serviceRefSortByLogonId;
							}

							var ComponentList = jsonData.ComponentList;
							var externalAgentsList = jsonData.externalAgents;
							var logonComponentList = jsonData.logonComponentList;
							var componentListObj = jsonData.componentListObj;

							var label='',selectedVal='',simLabel='',compLabel='',simulationSelectedVal='',compSelectedVal='',simulationSelectedOrgValue = '';
							var defalutHide = false;
							var isComponentType = true;
							var comboStore,simulationComboStore,compStroe;

							if(!Ext.isEmpty(componentListObj) && componentListObj!=null && componentListObj!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled)))
							{
								isComponentType = false;
								compStroe = Ext.create('Ext.data.Store',{
									fields:['value', 'name', 'url'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'options'
										}
									},
									data:componentListObj
								});
								compLabel = componentListObj.label;
								compSelectedVal = componentListObj.selectedValue;
								selectedCompType =componentListObj.selectedValue;
							}
							if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
								comboStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name', 'comptype'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'options'
										}
									},
									data:ComponentList
								});
								defalutHide = false;
								label = ComponentList.label;
								selectedVal = ComponentList.selectedValue;
							}
							else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
								extAgentData = externalAgentsList;
								externalAgentsList = externalAgentsList[simulationSelectedVal];
								comboStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'options'
										}
									},
									data:externalAgentsList
								});
								defalutHide = false;
								label = extAgentData.label;
								selectedVal = externalAgentsList.selectedValue;
							}
							else
								defalutHide = true;
							
							var serviceState = "GOOD";
							serviceState=jsonData.GridScreenLabels.siteState;
							var simulationComboHide = true;
							if(!Ext.isEmpty(innerActiveTab) && innerActiveTab != null && innerActiveTab != undefined && innerActiveTab == 'logonSim')
								simulationComboHide = false;
							curViewTab = innerActiveTab;
							me.add({
								xtype:'panel',
								ui: 'eg-x-panel sepHeader',
								border: false,
								//height:38,
								cls:'font_normal13 fontStyleRobot',
								style:{'background-color':'transparent !important','border':'none !important','box-shadow':'none'},
								id:'dashboard_view_header_id',
								title : "USER EXPERIENCE - WEB TRANSACTIONS <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' data-qtip='Layer Model' class='iconLayerstack mouse' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','WebTransactions','Web_Transaction_Sub_View','"+requestParams.iniName+"','"+requestParams.user_name+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('topology_view')\"/>",
								//title:'USER EXPERIENCE - WEB TRANSACTIONS',
								listeners:{
									'afterrender':function(e){
										var me = this;
										me.addTool({
											xtype:'container',
											id:'tabBarHeader1',
											layout:{type:'hbox',align:'right'},
											margin:'10 0 0 0',
											style:{'float':'right'},
											items:[
											/*{
												xtype:'label',
												cls:"service20_"+serviceState,
												border:0,
												margin:'1 0 0 0'
											},{
												xtype:'label',
												margin:'2 0 0 0',
												html:'&nbsp;<span class="font_bold13 fontStyleRobot" >SITE :</span> <span style="margin-right:6px;" class="font_normal13 fontStyleRobot">'+screenLabels["Title"]+'</span>'		
											},
											{xtype:'tbseparator',height:21,style:{'width':'1px !important','background-position':'right top !important'}},
											{
												xtype:'button',
												tooltip:'Layer Model',
												style:{'border':'none'},
												margin:'3 0 0 0',
												cls:'iconLayerstack',
												handler: function() {
													DashboardToLayers(compName,compType,siteName,'WebTransactions','Web_Transaction_Sub_View',requestParams.iniName,requestParams.user_name);
												}
											},
											{xtype:'tbseparator',height:21,style:{'width':'1px !important','background-position':'right top !important'}},
											{
												xtype:'button',
												tooltip:'Topology',
												style:{'border':'none','top':'3px !important'},
												cls:'iconTopology',
												margin:'3 0 0 0',
												handler: function() {
													//DashboardToTopology();
													loadView('topology_view');
												}
											},*/
											{
												xtype:'combo',
												id:'compTypeCombo',
												itemId:'compTypeCombo',
												labelAlign : 'left',
												editable : false,
												store:compStroe,
												hidden:isComponentType,
												labelSeparator:'',
												cls : 'dropdown',
												displayField: 'name',
												valueField: 'value',
													url:'url',
												trigerAction:'all',
												fieldLabel:compLabel+':',
												labelWidth:60,
												width:250,
												queryMode: 'local',
												margin:'0 0 0 20',
												value:compSelectedVal,
												listeners:{
													'change':function(e){
														RumAppFlow.app.getController('Main').onComponentTypeChange(this,'logonSim',siteName,compSelectedVal,selected_view_name);
													}
												}
											},
											{
												xtype:'combo',
												id:'componentCombo',
												itemId:'componentCombo',
												editable : false,
												labelWidth:75,
												margin:'0 0 0 20',
												hidden:defalutHide,
												store:comboStore,
												cls : 'dropdown',
												width:290,
												displayField:'name',
												valueField:'value',
												trigerAction:'all',
												fieldLabel:''+label,
												value:selectedVal,
												queryMode : 'local',
												listeners:{
													'change':function(e){
														RumAppFlow.app.getController('Main').onComponentChange(this,'webTrans',siteName);
													}	
												}
											},
											{
												xtype:'combo',
												id:'simulationCombo',
												itemId:'simulationCombo',
												editable : false,
												margin:'0 0 0 20',
												width:290,
												hidden:simulationComboHide,
												store:simulationComboStore,
												cls : 'dropdown',
												displayField:'name',
												valueField:'value',
												trigerAction:'all',
												fieldLabel:''+simLabel,
												labelWidth:80,
												value:simulationSelectedOrgValue,
												queryMode : 'local'
											}
											]
										});
									}								
								}
							},{
								xtype : 'container',
								ui:'eg-container',
								margin : 0,
								id : 'dashboard_view_container_grid',
								bodyPadding :0,
								padding:0,
								border : false,
								frame : false,	
								listeners:{
									'afterrender':function(e){
										var me = this;
										me.add([{
											xtype:'container',
											ui:'eg-container',
											margin:'0 0 0 0',
											padding:'0 10 10 10',
											items:[{
												xtype:'transactiongridpanel',
												ui:'newGridPanel',
												id:'transactiongridpanelid',
												//title:'<span class="font_bold12">Transactions</span>',
												//columnWidth:1.0,
												jsonData:jsonData,
												isEmuEnabled:isEmuEnabled,								
												//bodyPadding:10,
												id:'transGrid1',
												height:185,
												//flex:0.43,
												border:true
											}]
										
										}]);
									}
								}
							},{
								xtype : 'container',
								//ui:'eg-container',
								margin :'0 0 0 0',
								id : 'dashboard_view_container_chart',
								bodyPadding :0,
								padding:0,
								//height:1000,
								layout:'fit',
								border : false,
								frame : false,	
								listeners:{
									'afterrender':function(e){
										var me = this;
										me.add([{
											xtype:'container',
											//ui:'eg-container',
											margin:'10 2 0 0',
											//padding:10,
											//height:220,
											items:[{
												xtype:'transactionschartpanel',
												id:'transactionschartpanelid',
												//height:500,
												//minHeight:250,
												//title:'Graphs',
												//columnWidth:1.0,
												jsonData:jsonData,								
												padding:0,
												//flex:0.57,
												border:false,
												layout:{type:'fit'},
												//style:{'overflow':'auto'}
												
											}]
										}]);
									}
								}
							});
						}
					},
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				  });
				}
			}
		});
	},
	addlogonTransPage: function(jsonData,cardObj){

		isRefreshing = false;
		var me = this,
		card = Ext.getCmp('appflow_ground');
		card.add({
			xtype: 'container',
			id: "cardID",
			//flex: 1,
			//layout: {
			//	type: 'vbox',
			//	align: 'stretch'
			//},
			listeners:{
				'afterrender':function(e){
					var me = this;
					var appliesToValue = '';
					if(requestParams.appliesTo != null && requestParams.appliesTo !='null' && requestParams.appliesTo != '' && requestParams.appliesTo!= undefined && requestParams.appliesTo != 'undefined')
					{
							appliesToValue = requestParams.appliesTo;
					}
					else
					{
						if(!Ext.isEmpty(Ext.getCmp("componentsDropDown1")))
							appliesToValue = Ext.getCmp("componentsDropDown1").getValue();
					}

					var d_url = '/final/monitor/transactions.jsp?treeTitle=services&selectNode=Service$cap$'+encodeURIComponent(requestParams.filterBy)+'&selectedParam='+encodeURIComponent(requestParams.filterBy)+'&currentTab=logon&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&site='+encodeURIComponent(requestParams.filterBy)+'&isSite=true&serviceName='+encodeURIComponent(requestParams.filterBy)+'&fromLayer=false&selectNode='+encodeURIComponent(requestParams.filterBy)+'&currentTab=logon&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(requestParams.filterBy)+'&isfromCitrix=&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&dashboard_name=rum_Dashboard&view_name=Logon_Sub_View&fromServiceHomePage=true&fromSerComboChange=true&appliesTo='+appliesToValue+'&filterBy='+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;
					Ext.Ajax.request({
					  url : d_url,
					  timeout:280000,
					  //scope:this,
					  success: function(response){
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							var jsonData = Ext.decode(jsonText);
							this.siteName = jsonData.HiddenFields.siteName;
							//after refresh the tab value needs to be retained for layout of graphs
							// if(!Ext.isEmpty(requestParams.selectedTab)){
							/*if(!Ext.isEmpty(jsonData.HiddenFields.selectedTab)){
							if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){								 
							this.tab="emulated";
							}else{
							this.tab="web";
							}
							}*/
							//this.loadTransaction(jsonData);
							//this.getTransactionsMainPanel().showTransactionGridPanel(jsonData.GridScreenLabels,jsonData);
							var selected_view_name = "Logon_Sub_View";
							var screenLabels = jsonData.GridScreenLabels;
							var compType = jsonData.HiddenFields.compType;
							var compName = jsonData.HiddenFields.compName;
							var siteName = jsonData.HiddenFields.siteName;
							gLogonParam = jsonData.logonParam;
							var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
							var isTransEnabled = ( !Ext.isEmpty(screenLabels["webBtnLabel"]) )?true:false;
							var isTabChanged = ( !Ext.isEmpty(jsonData['isTabChanged']) )?true:false;
							var isFromRefresh = ( !Ext.isEmpty(jsonData['fromRefresh']) )?true:false;
							var isLogonEnabled = jsonData.HiddenFields.isLogonSimul;
							var refreshing = jsonData.HiddenFields.Refreshing;
							var innerActiveTab = jsonData.HiddenFields.innerActiveTab;
							//var graphParam = jsonData.HiddenFields.timelineParam;
							var graphParam = jsonData.HiddenFields.timelineParam;
							var timelineUrl = '';
							if(!Ext.isEmpty(graphParam) && graphParam != null && graphParam != undefined)
							{
								timelineUrl = '&mode='+graphParam.mode+'&time_line='+graphParam.time_line+'&starthr='+graphParam.starthr+'&endhr='+graphParam.endhr+'&starttime='+graphParam.starttime+'&endtime='+graphParam.endtime+'&startmin='+graphParam.startmin+'&endmin='+graphParam.endmin;
							}
							innerActiveTab = "logonSim";
							if(!Ext.isEmpty(jsonData.HiddenFields))
							{
							serviceRefSortByLogon = jsonData.HiddenFields.serviceRefSortByLogon;
							serviceRefSortByLogonType = jsonData.HiddenFields.serviceRefSortByLogonType;
							serviceRefSortByLogonId = jsonData.HiddenFields.serviceRefSortByLogonId;
							}

							var ComponentList = jsonData.ComponentList;
							var externalAgentsList = jsonData.externalAgents;
							var componentListObj = jsonData.componentListObj;
							var logonComponentList = jsonData.logonComponentList;
							var componentListObj = jsonData.componentListObj;
							
							var isSingleCompType = false;
							if(jsonData.componentListObj != null && jsonData.componentListObj['options'].length==1)
							{
								isSingleCompType = true;
								singleComponentTypeValue = jsonData.componentListObj['options'][0].value;
								singleComponentTypeName = jsonData.componentListObj['options'][0].name;
							}
							var label='',selectedVal='',simLabel='',compLabel='',simulationSelectedVal='',compSelectedVal='',simulationSelectedOrgValue = '';
							var defalutHide = false;
							var isComponentType = true;
							var comboStore,simulationComboStore,compStroe;

							if(!Ext.isEmpty(componentListObj) && componentListObj!=null && componentListObj!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled)))
							{
								isComponentType = false;
								compStroe = Ext.create('Ext.data.Store',{
									fields:['value', 'name', 'url'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'options'
										}
									},
									data:componentListObj
								});
								compLabel = componentListObj.label;
								compSelectedVal = componentListObj.selectedValue;
								selectedCompType =componentListObj.selectedValue;
							}
							if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
								comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
								type: 'memory',
								reader: {
								type: 'json',
								root:'options'
								}
								},
								data:ComponentList
								});
								defalutHide = false;
								label = ComponentList.label;
								selectedVal = ComponentList.selectedValue;
							}
							else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
								extAgentData = externalAgentsList;
								//externalAgentsList = externalAgentsList[simulationSelectedVal];
								comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name'],
								proxy:{
								type: 'memory',
								reader: {
								type: 'json',
								root:'options'
								}
								},
								data:externalAgentsList
								});
								defalutHide = false;
								label = extAgentData.label;
								selectedVal = externalAgentsList.selectedValue;
								selectedExtAgent = externalAgentsList.selectedValue;
							}
							else
								defalutHide = true;

							/*if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined)
							{
								simulationComboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
								type: 'memory',
								reader: {
								type: 'json',
								root:'options'
								}
								},
								data:logonComponentList
								});
								simLabel = logonComponentList.label;
								simulationSelectedVal = logonComponentList.selectedValue;
								simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
							}*/
							if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled)))
							{
								extSimData = logonComponentList;
								logonComponentList = logonComponentList[selectedExtAgent];
								simulationComboStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name', 'comptype'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'options'
										}
									},
									data:logonComponentList
								});
								simLabel = logonComponentList.label;

								simulationSelectedVal = logonComponentList.selectedValue;
								simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
								refreshSimulation = "";
								/*if(!Ext.isEmpty(refreshSimulation) && refreshSimulation != null)
								{
									if(refreshSimulation.indexOf(":")>-1)
									{
										var componentVal = refreshSimulation;
										componentVal = componentVal.substring(0,componentVal.indexOf(":"));
										selectedSimulation = componentVal;
									}
									simulationSelectedOrgValue = refreshSimulation;
								}
								else
								{
									selectedSimulation = logonComponentList.selectedValue;
									simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
								}*/
							}

							if(isSingleCompType)
							{
								isComponentType = true;
							}
							

							var serviceState = "GOOD";
							serviceState=jsonData.GridScreenLabels.siteState;
							var simulationComboHide = true;
							if(!Ext.isEmpty(innerActiveTab) && innerActiveTab != null && innerActiveTab != undefined && innerActiveTab == 'logonSim')
							simulationComboHide = false;
							var title= "USER EXPERIENCE - LOGON SIMULATIONS";
							if(singleComponentTypeName != '' && singleComponentTypeName != null && singleComponentTypeName !=undefined)
							{
								singleComponentTypeName = singleComponentTypeName.toUpperCase();
								title = "USER EXPERIENCE - "+singleComponentTypeName+" <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' data-qtip='Layer Model' class='iconLayerstack mouse' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','logonSim','Logon_Sub_View','"+requestParams.iniName+"','"+requestParams.user_name+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('topology_view')\"/>";
							}
							else
							{
								title = "USER EXPERIENCE - LOGON SIMULATIONS <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' data-qtip='Layer Model' class='iconLayerstack mouse' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','logonSim','Logon_Sub_View','"+requestParams.iniName+"','"+requestParams.user_name+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('topology_view')\"/>";
							}
							curViewTab = innerActiveTab;
							me.add({
								xtype:'panel',
								ui: 'eg-x-panel sepHeader',
								border: false,
								//height:38,
								cls:'font_normal13 fontStyleRobot',
								style:{'background-color':'transparent !important','border':'none !important','box-shadow':'none'},
								id:'dashboard_view_header_id',
								title: title,
								listeners:{
									'afterrender':function(e){
										var me = this;
										me.addTool({
											xtype:'container',
											id:'tabBarHeader1',
											layout:{type:'hbox',align:'right'},
											margin:'10 0 0 0',
											style:{'float':'right','border':'none !important'},
											items:[
											/*{
												xtype:'label',
												cls:"service20_"+serviceState,
												border:0,
												margin:'1 0 0 0'
											},{
												xtype:'label',
												margin:'2 0 0 0',
												html:'&nbsp;<span style="margin-right:6px;" class="font_normal13 fontStyleRobot">'+screenLabels["Title"]+'</span>'		
											},
											{xtype:'tbseparator',height:20,style:{'width':'1px !important','background-position':'right top !important'}},
											{
												xtype:'button',
												tooltip:'Layer Model',
												style:{'border':'none'},
												cls:'iconLayerstack',
												margin:'3 0 0 0',
												handler: function() {
													DashboardToLayers(compName,compType,siteName,'logonSim','Logon_Sub_View',requestParams.iniName,requestParams.user_name);
												}
											},
											{xtype:'tbseparator',height:20,style:{'width':'1px !important','background-position':'right top !important'}},
											{
												xtype:'button',
												tooltip:'Topology',
												style:{'border':'none'},
												cls:'iconTopology',
												margin:'3 0 0 0',
												handler: function() {
													//DashboardToTopology();
													loadView('topology_view');
												}
											},*/
											{
												xtype:'combo',
												id:'compTypeCombo',
												itemId:'compTypeCombo',
												labelAlign : 'left',
												editable : false,
												store:compStroe,
												hidden:isComponentType,
												labelSeparator:'',
												cls : 'dropdown',
												displayField: 'name',
												valueField: 'value',
													url:'url',
												trigerAction:'all',
												fieldLabel:compLabel+':',
												labelWidth:100,
												width:290,
												queryMode: 'local',
												margin:'0 0 0 20',
												value:compSelectedVal,
												listeners:{
													'change':function(e){
														RumAppFlow.app.getController('Main').onComponentTypeChange(this,'logonSim',siteName,compSelectedVal,selected_view_name);
													}
												}
											},
											{
												xtype:'combo',
												id:'componentCombo',
												itemId:'componentCombo',
												editable : false,
												margin:'0 0 0 20',
												hidden:defalutHide,
												store:comboStore,
												cls : 'dropdown',
												width:290,
												displayField:'name',
												valueField:'value',
												trigerAction:'all',
												fieldLabel:''+label,
												labelWidth:100,
												value:selectedVal,
												queryMode : 'local',
												listeners:{
													'change':function(e){
														RumAppFlow.app.getController('Main').onComponentChange(this,'logonSim',siteName,simulationSelectedOrgValue,selected_view_name);
													}	
												}
											},
											{
												xtype:'combo',
												id:'simulationCombo',
												itemId:'simulationCombo',
												editable : false,
												margin:'0 0 0 20',
												width:270,
												hidden:simulationComboHide,
												store:simulationComboStore,
												cls : 'dropdown',
												displayField:'name',
												valueField:'value',
												trigerAction:'all',
												fieldLabel:''+simLabel,
												labelWidth:70,
												value:simulationSelectedOrgValue,
												queryMode : 'local',
												listeners:{
													'change':function(e){
														RumAppFlow.app.getController('Main').onSimulationChange(this,'logonSim',siteName,simulationSelectedOrgValue,selected_view_name);
													}	
												}
											},
											
											]
										});
									}								
								}
							});
							var simulationSelectedOrgValue1 = "";
							if(simulationSelectedOrgValue != null && simulationSelectedOrgValue.indexOf(":NULL") > -1)
								simulationSelectedOrgValue1 = simulationSelectedOrgValue.substring(0,simulationSelectedOrgValue.indexOf(":NULL"));
							else
								simulationSelectedOrgValue1 = simulationSelectedOrgValue;
							
							

							var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?treeTitle=LogonSimulation&monitorsBy=LogonSimulator&componentType=&selectedState=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedVal+"&isfromCitrix=&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=Rum_Dashboard&view_name="+selected_view_name+"&fromServiceDashboard=false&servicename="+siteName+"&fromSerComboChange=true&fromServiceHomePage=true&appliesTo="+appliesToValue+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone+"&isLogonType=true";
							if(gLogonParam != null && gLogonParam != '' && gLogonParam != undefined)
								perf_url = 		"/final/monitor/comparisonLogonSimulator.jsp?"+gLogonParam+"&componentType=&selectedState=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedVal+"&isfromCitrix=&isfromRum=true&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&dashboard_name=Rum_Dashboard&view_name="+selected_view_name+"&fromServiceDashboard=false&servicename="+siteName+"&fromSerComboChange=true&fromServiceHomePage=true&appliesTo="+appliesToValue+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone+"&isLogonType=true";

							var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selectedVal+"&simulationName="+simulationSelectedOrgValue;
							
							Ext.Ajax.request({
								url : transurl,
								scope:this,
								success: function(response){
									var jsonText = response.responseText;
									//var panelArr = new Array();
									if(!Ext.isEmpty(jsonText))
									{
										var jsondata1 = Ext.decode(jsonText);
										if(jsondata1 != null && jsondata1 != undefined)
										{
											me.add({
												xtype : 'container',
												//ui:'eg-container',
												margin : 0,
												id : 'dashboard_container_grid',
												bodyPadding :0,
												padding:0,
												border : false,
												frame : false,	
												listeners:{
													'afterrender':function(e){
														var me = this;
														me.add({
															xtype:'generalMeasuresGridPanel',
															//title:titlesys,
															//title:perf_disp_name+" --Man At Work--",
															cls:'gridHeadercenter iconGrid',
															//itemId:itemIdforsysandcom,
															itemId:'logonSimualtion',
															searchBoxCombo:false,
															margin:0,
															padding:3,
															id:'perPanel',
															height:185,
															frame:false,
															border:true,
															layout:{type:'vbox',align:'stretch'},
															flex:1,
															screenLabelPath:"monitor.Dashboard",
															url:perf_url,
															listeners: {
																'afterrender': function (obj) {
																	this.loadTab(obj.url,null,null,null,null,true,'rumAppFlow');
																}
															}
														});
													}
												}
											},{
												xtype : 'container',
												//ui:'eg-container',
												margin :'0 0 0 0',
												id : 'dashboard_container_chart',
												bodyPadding :0,
												padding:0,
												//height:1000,
												layout:'fit',
												border : false,
												frame : false,
												listeners:{
													'afterrender':function(e){
														var me = this;
														me.add({
															xtype:'transactionschartpanel',
															id:'transactionschartpanelid',
															//animCollapse:true,
															//columnWidth:1.0,
															//height:255,
															height:(Ext.getBody().getViewSize().height-287),
															//flex:1,
															jsonData:jsondata1,
															//minHeight:265,
															margin:'10 1 0 0',
															//margin:'5 0 0 0',
															padding:0,
															//flex:0.57,
															border:false,
															isNotAreaChart:false
														});
													}
												}
											});
										}
									}
								  },
								failure:function(){
									//window.parent.location.href="/final/servlet/com.egurkha.Logout";
								}
							});
						}
					},
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				  });
				}
			}
		});
	},
	addemuTransPage: function(jsonData,cardObj){
		var me = this,
		card = Ext.getCmp('appflow_ground');
		card.add({
			xtype: 'container',
			id: "cardID",
			//flex: 1,
			//layout: {
			//	type: 'vbox',
			//	align: 'stretch'
			//},
			layout:'fit',
			listeners:{
				'afterrender':function(e){
					var me = this;
					var d_url = '/final/monitor/transactions.jsp?treeTitle=services&1=1&&selectNode=Service$cap$'+encodeURIComponent(requestParams.filterBy)+'&selectedParam='+encodeURIComponent(requestParams.filterBy)+'&currentTab=transactions&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=true&fromHomepage=&hasLogonSimulations=false&site='+encodeURIComponent(requestParams.filterBy)+'&isSite=true&serviceName='+encodeURIComponent(requestParams.filterBy)+'&fromLayer=false&selectNode='+encodeURIComponent(requestParams.filterBy)+'&selectedParam='+encodeURIComponent(requestParams.filterBy)+'&currentTab=transactions&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(requestParams.filterBy)+'&isfromCitrix=&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&dashboard_name=Rum_Dashboard&view_name=Emulated_Transaction_Sub_View&fromServiceHomePage=true&fromSerComboChange=true&appliesTo='+requestParams.appliesTo+'&filterBy='+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;
					Ext.Ajax.request({
					  url : d_url,
					  timeout:280000,
					  //scope:this,
					  success: function(response){
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							var jsonData = Ext.decode(jsonText);
							this.siteName = jsonData.HiddenFields.siteName;
							var compType = jsonData.HiddenFields.compType;
							var compName = jsonData.HiddenFields.compName;
							var siteName = jsonData.HiddenFields.siteName;
							var isWebTrans = jsonData.HiddenFields.isWebTrans;
						
							var siteBasedWeb = "NULL";
							if(isWebTrans=='true')
							{
								siteBasedWeb = requestParams.filterBy;
							}

							me.add({
									xtype:'panel',
									ui: 'eg-x-panel sepHeader',
									border: false,
									//height:38,
									style:{'background-color':'transparent !important','border':'none !important','box-shadow':'none'},
									id:'EnumHeader',
									layout:'fit',
									title:"<p style='font-size:13px'>USER EXPERIENCE - FULL SESSION SIMULATION <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' data-qtip='Layer Model' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','emulated','Emulated_Transaction_Sub_View','"+requestParams.iniName+"','"+requestParams.user_name+"')\" class='iconLayerstack mouse'/> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('topology_view')\"/></p>",
									listeners:{
									'afterrender':function(e){
										var me = this;
										/*me.addTool({
											xtype:'container',
											id:'tabBarHeader1',
											layout:{type:'hbox',align:'right'},
											margin:'0 0 0 0',
											style:{'float':'right'},
											items:[{
												xtype:'button',
												tooltip:'Topology',
												style:{'border':'none'},
												cls:'iconTopology',
												margin:'0 0 0 0',
												handler: function() {
													Ext.get('sessionSimTopology').dom.src="/final/monitor/sessionSimulation.jsp";
												}
											},
											{xtype:'tbseparator',height:20,style:{'width':'1px !important','background-position':'right top !important'}},
											{
												xtype:'button',
												tooltip:'Garph',
												style:{'border':'none'},
												cls:'iconLineChart',
												margin:'0 0 0 0',
												/*handler: function() {
													//DashboardToTopology();
													loadView('topology_view');
												}*/
											//}]
										//});
										me.add({
										xtype : 'container',
										margin : 0,
										id : 'sessionSimTopology',
										bodyPadding :0,
										padding:0,
										autoScroll:false,
										scroll:false,
										border : false,
										frame : false,
										layout:'fit',
										height : '100%',
										listeners:{
											"resize":function(panel){
													panel.setHeight(Ext.getBody().getViewSize().height-70)
											},
											'afterrender':function(e)
											{
												Ext.EventManager.onWindowResize(function(){
													try
													{
														var srcData = Ext.get('sessionSimTopology').dom.src;
														Ext.get('sessionSimTopology').dom.src=srcData;	
													}
													catch (e1)
													{
													}
												});						
											}
										},
										autoEl : {
											tag : 'iframe',
											name : 'perMainIframe',
											id:'sessionSimTopologyIframe',
											frameborder : '0',
											style:{'top':'0px','left':'0px'},
											marginLeft:0,
											marginTop:0,
											height : '100%',
											src:"/final/monitor/sessionSimulation.jsp?compName="+compName+"&site="+siteBasedWeb+"&compType="+compType+"&serviceName="+requestParams.filterBy+"&iniName="+requestParams.iniName+"&user_name="+requestParams.user_name+"&appliesTo="+requestParams.appliesTo+"&filterBy="+encodeURIComponent(requestParams.filterBy)+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone+"&isRum=true"
											//src:"/final/monitor/sessionSimulation.jsp?compName="+compName+"&site=NULL&compType="+compType
										}
									});
									}
								}
							});
						}
					}
				});
			}
		}
	});
	},
	addMetricsPage: function(jsonData,cardObj){
		var me = this,
		card = Ext.getCmp('appflow_ground');
		var selectedRum = titleApplies;
		if(rumPageParams.serviceCombo[0].rumcomboNeeded)
			selectedRum = rumPageParams.serviceCombo[0].selectedRum;
	
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}
		if(componentNameSearch != null && componentNameSearch !='null' && componentNameSearch != undefined &&  componentNameSearch != 'undefined')
		{
			nickNameVal = componentNameSearch;
		}
		card.add({
			xtype: 'container',
			id: "cardID",
			//flex: 1,
			//layout: {
			//	type: 'vbox',
			//	align: 'stretch'
			//},
			listeners:{
				'afterrender':function(e){
					var me = this;
					//var jsonDetails = jsonData.loadViewDetails;
					me.add({
						xtype : 'container',
						ui:'eg-container',
						margin : '0 0 0 0',
						id : 'metrics_container',
						bodyPadding :0,
						padding:2,
						autoScroll:false,
						scroll:false,
						border : false,
						frame : false,
						//layout:'fit',
						//height:515,
						listeners:{
							'afterrender':function(e){
								var me = this;
								var filterr = requestParams.filter;
								if(filterr == "Service")
									filterr = "services";
								var metricsURL = '/final/monitor/comparisonComponent.jsp?treeTitle=rumcomponents&selectedState=&componentNameSearch='+nickNameVal+'&fromPageView=CitrixDashboard&viewPageTitle=Components&action=component&fromHomepage=&userName=&filterBy='+filterr+'&subFilter='+requestParams.filterBy+'&timeline=null&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+"&dashboard_name=rum_Dashboard&view_name=metrics_View&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&isFromZone="+backParams.isFromZone+"&iszoneName="+encodeURIComponent(backParams.iszoneName)+"&parentZone="+encodeURIComponent(backParams.parentZone)+"&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&isRumComp=true";

								if(selectedCompType != null && selectedCompType !='null' && selectedCompType !=undefined && selectedCompType !='undefined' && selectedCompType != '')
								{
									metricsURL = metricsURL + "&componentType="+selectedCompType;
								}

								var compTypeComboFlag = false;
								if(requestParams.filter.toLowerCase().indexOf("component") > -1)
									compTypeComboFlag = true;

								me.add({
									xtype:'generalMeasuresGridPanel',
									id:'perPanel',
									//cls:'gridHeadercenter',
									//ui:'eg-x-panel',
									itemId:"components",
									margin:'0 0 0 0',
									padding:'0 0 0 0',
									frame:false,
									//height:250,
									border:true,
									style:{'z-index':'0'},
									layout:{type:'vbox',align:'stretch'},
									//flex:1,
									disableCombo:true,
									disableCompTypeCombo:compTypeComboFlag,
									screenLabelPath:"monitor.CitrixDashboard",
									url:metricsURL,
									listeners: {
										'afterrender': function (obj) {
											this.loadTab(obj.url,'','','','','','rumAppFlowComponent');
										},
										'resize':function(panel){
												//alert(panel.height);
												panel.setHeight(Ext.getBody().getViewSize().height-70);
										}
									}
								});
							}
						}
					});
				}
			}
		});
	},
	addaggregatesPage: function(jsonData,cardObj){
		var me = this,
		card = Ext.getCmp('appflow_ground');
		var selectedRum = titleApplies;
		if(rumPageParams.serviceCombo[0].rumcomboNeeded)
			selectedRum = rumPageParams.serviceCombo[0].selectedRum  

		card.add({
			xtype: 'container',
			id: "cardID",
				listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype : 'container',
						ui:'eg-container',
						margin : '-10 0 0 0',
						id : 'aggregate_container',
						bodyPadding :0,
						//padding:2,
						autoScroll:false,
						scroll:false,
						border : false,
						frame : false,
						listeners:{
							'afterrender':function(e){
								me.add({
										xtype:'dashboardgeneralmeasuresaggregatepanel',
										id:'systemViewAggregatesgridpanel',
										cls:'gridHeadercenter',
										itemId:'aggregates',
										margin:'10 0 0 0',
										padding:0,
										frame:false,
										border:false,
										//layout:{type:'vbox',align:'stretch'},
										//height:300,
										//style:{'overflow':'auto'},
										scroll:true,
										autoScroll:true,
										height:'100%',
										style:{'overflow':'auto','background':'#fff'},
										//height:200
										screenLabelPath:"monitor.serviceDashboard",
										url:"/final/monitor/serviceAggregate.jsp?treeTitle=rumaggregate&selectNode=Service$cap$"+encodeURIComponent(requestParams.filterBy)+"&selectedParam="+encodeURIComponent(requestParams.filterBy)+"&currentTab=Aggregates&isSite=true&aggregateTab=true&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&refresh=true&action=Aggregates&topoSegment="+encodeURIComponent(requestParams.filterBy)+'&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+'&dashboard_name=rum_Dashboard&view_name=aggregates_View&fromServiceHomePage=true&isFromZone='+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone+"&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup,
										listeners:{
											'resize':function(panel){
													panel.setHeight(Ext.getBody().getViewSize().height-65);
											},
											'afterrender': function (obj) {
												this.loadTab(obj.url,'rumAppFlowAggregate');
											},
										}
								});
							}
						}
					});
				}
			}
		});
	},
	addsystemsPage: function(jsonData,cardObj){
		SysComponentType = '';
		var me = this,
		card = Ext.getCmp('appflow_ground');
		card.add({
			xtype: 'container',
			id: "cardID",
			//flex: 1,
			//layout: {
			//	type: 'vbox',
			//	align: 'stretch'
			//},
			listeners:{
				'afterrender':function(e){
					var me = this;
					//var jsonDetails = jsonData.loadViewDetails;
					me.add({
						xtype : 'container',
						ui:'eg-container',
						margin : '0 0 0 0',
						id : 'system_container',
						bodyPadding :0,
						//padding:2,
						autoScroll:false,
						scroll:false,
						border : false,
						frame : false,
						//layout:'fit',
						//height:515,
						listeners:{
							'afterrender':function(e){
								var me = this;
								var filterr = requestParams.filter;
								if(filterr == "Service")
									filterr = "services";
								//var metricsURL = '/final/monitor/comparisonComponent.jsp?treeTitle=rumcomponents&selectedState=&componentNameSearch=&fromPageView=CitrixDashboard&viewPageTitle=Components&action=Aggregates&fromHomepage=&userName=&filterBy='+filterr+'&subFilter='+requestParams.filterBy+'&timeline=null&isfromCitrix=true&isfromRum=true&iniName='+requestParams.iniName+'&user_name='+requestParams.user_name+"&dashboard_name=rum_Dashboard&view_name=metrics_View&fromServiceHomePage=true&appliesTo="+requestParams.appliesTo+"&isFromZone="+backParams.isFromZone+"&iszoneName="+backParams.iszoneName+"&parentZone="+backParams.parentZone;

								var compTypeComboFlag = false;
								if(requestParams.filter.toLowerCase().indexOf("component") > -1)
									compTypeComboFlag = true;

								var selectedRum = titleApplies;
								if(rumPageParams.serviceCombo[0].rumcomboNeeded)
									selectedRum = rumPageParams.serviceCombo[0].selectedRum  
								me.add({
									xtype:'dashboardgeneralmeasuresgridpanel',
									id:'systemViewMeasuresgridpanel',
									layout:'fit',
									cls:'gridHeadercenter',
									itemId:'system',
									margin:'0 0 0 0',
									padding:10,
									frame:false,
									border:true,
									screenLabelPath:"monitor.serviceDashboard",
									url:"/final/monitor/serviceSystem.jsp?treeTitle=services&selectNode=Service$cap$"+encodeURIComponent(requestParams.filterBy)+"&selectedParam="+encodeURIComponent(requestParams.filterBy)+"&currentTab=Systems&isSite=true&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&refresh=true&action=Systems&topoSegment="+encodeURIComponent(requestParams.filterBy)+'&isfromRum=true&iniName='+requestParams.iniName+'&hasRUM=true&user_name='+requestParams.user_name+'&dashboard_name=RUM_Dashboard&view_name=systems_View&fromServiceHomePage=true&isFromZone='+backParams.isFromZone+"&iszoneName="+encodeURIComponent(backParams.iszoneName)+"&parentZone="+encodeURIComponent(backParams.parentZone)+"&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&appliesTo="+selectedRum+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&componentType="+selectedSystemCompType,
									listeners:{
										'resize':function(panel){
												panel.setHeight(Ext.getBody().getViewSize().height-75);
										},
										'afterrender': function (obj) {
											this.loadTab(obj.url,'rumAppFlowSystem');
										}
									}
								});
							}
						}
					});
				}
			}
		});
	},
	addTopologyPage: function(jsonData,cardObj){
		var me = this,
		card = Ext.getCmp('appflow_ground');
		var selectedRum = titleApplies;
		if(rumPageParams.serviceCombo[0].rumcomboNeeded)
			selectedRum = rumPageParams.serviceCombo[0].selectedRum;
		card.add({
			xtype: 'container',
			id: "cardID",
			//flex: 1,
			//layout: {
			//	type: 'vbox',
			//	align: 'stretch'
			//},
			listeners:{
				'afterrender':function(e){
					var me = this;
					//var jsonDetails = jsonData.loadViewDetails;
					me.add({
						xtype:'panel',
						ui: 'eg-x-panel sepHeader',
						border: false,
						//height:38,
						style:{'background-color':'transparent !important','box-shadow':'none !important'},
						id:'topology_header_id',
					    title:'<p style="font-size:13px;position:relative;top:-2px">Topology</p>',
						listeners:{
							'afterrender':function(e){
								var me = this;
								var serName = ""; 
								var assSegArray = [];
								var isSerComboNeed = false;
								var segName = "";
								if(!Ext.isEmpty(ifAssSeg) && ifAssSeg != null && ifAssSeg != undefined){
									
									if(ifAssSeg.indexOf(",") > 0){
										ifAssSeg = ifAssSeg.trim();
										isSerComboNeed = true;
										assSeg = ifAssSeg.split(',');
										for(var t=0;t<assSeg.length;t++){
											var disp = assSeg[t];
											if(assSeg[t].toLowerCase() == "independent_servers")
												disp = "Independent Servers";
											assSegArray[t] = {"state":segsWithState[t].state,"name":disp,"value":assSeg[t]};
										}
										segName = ifAssSeg.substring(0,ifAssSeg.indexOf(","));									
									}else if(!Ext.isEmpty(ifAssSeg) && ifAssSeg != null && ifAssSeg != undefined){
										segName = ifAssSeg;
									}
								}
								if(!Ext.isEmpty(selectedSegmentName) && selectedSegmentName != null && selectedSegmentName != undefined && selectedSegmentName != 'null' && selectedSegmentName != 'undefined')
								{
									segName = selectedSegmentName;
								}
								if(isSerComboNeed){
									me.addTool({
										xtype:'combo',
										cls:'dropdown',
										id:'stateCombo',
										name:'stateCombo',
										store:Ext.create('Ext.data.Store',{
											fields:['state','name','value'],
											data:assSegArray
										}),
										editable:false,
										labelWidth:60,
										width:305,
										margin:'0 47 0 15',
										displayField:'name',
										valueField:'value',
										value:segName,
										fieldLabel:'Segment',
										listeners:{
											'render':function(){
												$('#stateCombo-inputEl').addClass('state_'+ifAssSegState);
											},
											'change':function(combo,record){
												var turl = '/final/monitor/EgServiceTopologyD3JS.jsp?physical_topology=0&type=monitor&treeFlag=null&zoneName=&currentTab=null&aggregateTab=null&openNode=null&treeFlag=null&fromHomepage=&serviceGroup=null&action=service&serviceState=service20New_'+ifAssSegState+'&service='+requestParams.filterBy+'&segment='+record+'&site='+requestParams.filterBy+"&isfromRum=true&dashboard_name=rum_Dashboard&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&activeView=topology&isFromZone="+backParams.isFromZone+"&iszoneName="+encodeURIComponent(backParams.iszoneName)+"&parentZone="+encodeURIComponent(backParams.parentZone);
												Ext.get('serTopologyMainCon').dom.src=turl;

												for(var k=0;k<segsWithState.length;k++){
													var selectedSeg = segsWithState[k].name;
													console.log('selectedSeg rum -> ',selectedSeg);
													if(selectedSeg == record){
														$('#stateCombo-inputEl').removeClass('state_GOOD');
														$('#stateCombo-inputEl').removeClass('state_HIGH');
														$('#stateCombo-inputEl').removeClass('state_INTERMEDIATE');
														$('#stateCombo-inputEl').removeClass('state_LOW');
														$('#stateCombo-inputEl').removeClass('state_UNKNOWN');
														$('#stateCombo-inputEl').addClass('state_'+segsWithState[k].state);
														break;
													}
												}
											}
										},
										tpl: Ext.create('Ext.XTemplate',
											'<ul style="white-space:nowrap">',
											'<tpl for=".">',
												'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{name}</li>',
											'</tpl>',
											'</ul>'
										)
									});
								}
							}
						}
					},{
						xtype : 'container',
						ui:'eg-container',
						margin : 0,
						id : 'topology_container',
						bodyPadding :0,
						padding:0,
						border : false,
						frame : false,
						layout:'fit',
						height:506,
						listeners:{
							'resize':function(panel){
								//alert(panel.height);
								panel.setHeight(Ext.getBody().getViewSize().height-85);
							},
							'afterrender':function(e){
								var me = this;
								var segName = "";
								if(ifAssSeg.indexOf(",") > -1)
									segName = ifAssSeg.substring(0,ifAssSeg.indexOf(","));
								else
									segName = ifAssSeg;
								if(!Ext.isEmpty(selectedSegmentName) && selectedSegmentName != null && selectedSegmentName != undefined && selectedSegmentName != 'null' && selectedSegmentName != 'undefined')
								{
									segName = selectedSegmentName;
								}
								var top_url = '/final/monitor/EgServiceTopologyD3JS.jsp?physical_topology=0&type=monitor&treeFlag=null&zoneName=&currentTab=null&aggregateTab=null&openNode=null&treeFlag=null&fromHomepage=&serviceGroup=null&iszoneName=&isFromZone=null&parentZone=null&action=service&serviceState=service20New_'+ifAssSegState+'&service='+requestParams.filterBy+'&segment='+segName+'&site='+requestParams.filterBy+"&isfromRum=true&dashboard_name=rum_Dashboard&filter=service&filterBy="+encodeURIComponent(requestParams.filterBy)+"&selectedRum="+selectedRum+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&activeView=topology&isFromZone="+backParams.isFromZone+"&iszoneName="+encodeURIComponent(backParams.iszoneName)+"&parentZone="+encodeURIComponent(backParams.parentZone);

								me.add({
									xtype : 'container',
									margin : 0,
									id : 'serTopologyMainCon',
									bodyPadding :0,
									padding:0,
									autoScroll:false,
									scroll:false,
									border : false,
									frame : false,
									layout:'fit',
									autoEl : {
										tag : 'iframe',
										name : 'perMainIframe',
										id:'serTopologyIframe',
										frameborder : '0',
										style:{'top':'0px','left':'0px'},
										marginLeft:0,
										marginTop:0,
										height : '100%',
										src:top_url
									}
								});
							}
						}
					});
				}			
			},
			items: []
		});		
	},
	addOverviewGeoPage: function(jsonData,cardObj){
		var me = this,
		card = Ext.getCmp('appflow_ground');	
		card.add({
			xtype: 'container',
			id: "cardID",
			//flex: 1,
			//layout: {
			//	type: 'vbox',
			//	align: 'stretch'
			//},
			listeners:{
				'afterrender':function(e){
					var me = this;
					var jsonDetails = jsonData.loadViewDetails;
					me.add(
					{
						xtype: 'overviewdetails',
						id:'overviewdetails_Static_Geo_view',
						data:jsonDetails,
						margin: '0 2 2 0',
						collapsible: true
					},
					{
						xtype: 'container',
						flex: 1,
						height:450,
						margin:'10 2 10 0',
						//style:{'border':'1px solid red !important'},
						layout: {
							type: 'hbox',
							align: 'stretch'
						},
						listeners:{
							'afterrender':function(e){
								var me = this;
								me.add({
									xtype: 'container',
									cls:'geopan-border',
									ui:'eg-container',
									margin: '0 10 2 0',
									flex: 0.75,
									layout: {
										type: 'hbox',
										align: 'stretch'
									},
									listeners:{
										'afterrender':function(e){
											var me = this;
											me.add({
												xtype:'panel',												
												flex:0.7,
												layout: {
													type: 'vbox',
													align: 'stretch'
												},
												items:[
													{
														xtype:'header',
														id:'geo_map_header_id',
														//style:{'border':'1px solid pink !important'},
														padding:'0 5 5 0',
														height:35,
													},
													{
														xtype: 'geostaticpanel',
														mapStyle:strRumSkin == "Dark"?'dark':'light', //light,dark,default
														jsonData:jsonData.loadViewDetails[1].Application_Block_1_Value[0][0],
														id:'overview_Static_map_id',
														flex: 0.5,
														//ui:'eg-x-panel',
														margin: '0 1 1 0',
														zoom: 2,
														width: 200,
														height: 500,
														mapType: 'styled_map', //'roadmap', 'satellite', 'hybrid', 'terrain', 'styled_map',
														center: {
															lat: 40.3780, // Marker latitude
															lng:10.4359 // Marker longitude
														},
														infoBoxArray:[],
														markerArray:[],
														feauturesArray:[],
														stateArray:[],
													}
												]
											},{
												xtype:'geomapdetails',
												id:'static_geo_id_mapdetails',
												hidden:true,
												flex: 0.3,											
												jsonData:jsonData.loadViewDetails[1].Application_Block_1_Value[0][0],
												//jsonData1:JsonMapData1
											});
										}
									},
									items: []
								},
								{
									xtype: 'container',
									layout: {
										type: 'vbox',
										align: 'stretch'
									},
									width:300,
									listeners:{
										'afterrender':function(e){
											var me = this;
											me.add(
											{
												xtype: 'responsetimepiechart',
												id:'responsetimepiechart_Static_Geo',
												margin: '0 2 2 0',
												legendPosition: 'bottom', // top,left, bottom and right
												legendLayout : 'horizontal' ,// 'horizontal' or 'vertical''
												height:235,
												chartMarginTop:0,
												chartMarginLeft:0,
												chartMarginBottom:50,
												chartMarginRight:0,
												legendOffset:-10,
												chartLegendUseHTML:true,
												formatLegend:18,
												legendContainerWidth:300,
												Jdata:jsonData.loadViewDetails[1].Application_Block_1_Value[0][1]
											}, 
											{
												xtype:'rumappflowgrid',
												margin: '8 2 2 0',
												flex: 1,
												id:'gridSlowpagegroups_Static_Geo_view',
												gridData:jsonData.loadViewDetails[1].Application_Block_1_Value[0][2]
											});
										}
									},
									items: []
								});
							}						
						},
						items: []
					});
				}			
			},
			items: []
		});
	},
	addPageViewsPage: function(jsonData,cardObj) {
		var me = this,
		card = Ext.getCmp('appflow_ground');
		card.add({
                xtype: 'container',
                id: "cardID",
				layout:{
					type:'vbox',
					align:'stretch'
				},
				listeners:{
					'afterrender':function(e){
						var me = this;
						var jsonDetails = jsonData.loadViewDetails;
						me.add(
						{
							xtype: 'overviewdetails',
							id:'overviewdetails_PaView_view',
							data:jsonDetails,
							margin: '0 2 2 0',
							collapsible: false
						},
						{
							xtype: "pageviewpanel",
							id: "pageviewpanel_PaView_Id",
							margin: '10 2 2 0',
							flex:1,
							data:jsonDetails[1].Application_Block_1_Value[0].data,
							fullData:jsonDetails[1].Application_Block_1_Value[0],
							layout:{
								type:'vbox',
								align:'stretch'
							},
							scroll:true,
							autoScroll:true
						}
						);
					}
				},
                items: []
		});
	},
	addOmniChannelPage: function(jsonData,cardObj) {
		var me = this,
		card = Ext.getCmp('appflow_ground');		
		card.add({
			xtype: 'container',
			id: "cardID",
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			listeners:{
				'afterrender':function(e){
					var jsonDetails = jsonData.loadViewDetails;
					var me = this;
					me.add(
					{
						xtype: 'overviewdetails',
						id:'overviewdetails_Omni_view',
						data:jsonDetails,
						margin: '0 2 2 0',
						collapsible: false
					},
					{
						xtype: "omnichannelmainpanel",
						id: "omnichannelmainpanel_omni_Id",
						data:jsonDetails[1].Application_Block_1_Value[0],
						margin: '10 2 2 0'
					}
					);
				}
			},
			items: []
		});

	},
	addResponseTBPage: function(jsonData,cardObj) {
		var me = this,
		card = Ext.getCmp('appflow_ground');		
		card.add({
			xtype: 'container',
			id: "cardID",
			listeners:{
				'afterrender':function(e){
					var jsonDetails = jsonData.loadViewDetails;
					var me = this;
					me.add(
					{
						xtype: 'overviewdetails',
						id:'overviewdetails_Rtb_view',
						data:jsonDetails,
						collapsible: false
					},
					{
						xtype:'appflowindetail',
						margin:'10 2 10 0',
						showDetails:true,
						height:470,
						listeners:{
							'afterrender':function(e){
								var me = this;
								me.add(
								{
									xtype:'container',
									layout:{type:'hbox',align:'stretch'},
									items:[
									{
										xtype:'container',
										flex:1,
										layout:{type:'hbox'},
										items:[
												{  
													xtype: 'label',  
													margin:'2 10 0 0',
													cls:'b_label',
													text: 'Response Time Breakup'
												},
												{	
													xtype:'combo',
													id:'appflowCombo_Id',
													cls:'dropdown',
													width:115,
													margin:'0 10 0 0',
													displayField : 'name',
													valueField : 'value',
													queryMode : 'local',
													store:Ext.create('Ext.data.Store',{
														data :jsonData.loadViewDetails[1].Application_Block_1_Value[0].comboObj.combo_arr,
														fields:['name','value'],
													}),
													value:jsonData.loadViewDetails[1].Application_Block_1_Value[0].comboObj.selectedValue,
													listeners:{
														select:function(){
															RumAppFlow.app.getController("Main").changeTopology();
														}
													},
												},
												{	
													xtype:'uribox',
													id:'appuriBox_Id',
													data:jsonData.loadViewDetails[1].Application_Block_1_Value[0].uriArray
												}
											]
									},
									{
										xtype:'container',
										flex:1,
										padding:'0 15 10 0',
										layout:{type:'hbox',pack:'end'},
										items:[{
											xtype:'button',
											id:'maxButton',
											cls:'iconMaximize',
											style:{'border':'none !important','margin':'4px 0px 0px 10px !important'},
											hidden:false,
											listeners:{
												'click':function(){
													var bgColor = 'none';
													if(strRumSkin == "Dark")
														bgColor = '#404040';
													var appFlowTopologyObj = Ext.create('RumAppFlow.view.AppFlowTopology',{
														id:'appflowTopology_idE',
														ifRTB:false,
														style:{'padding-left':'5px !important','background':bgColor},
														expandedL:true,
														topoData:jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo,
														store:Ext.create('Ext.data.Store', {
															//autoLoad:true,
															fields:[ 
																{ name:'devices' },
																{ name:'url' },
																{ name:'group_url' },
																{ name:'browser'},
																{ name:'request'},
																{ name:'response'},
																{ name:'network_connection'},
																{ name:'content_download'},
																{ name:'server_time'},
																{ name:'showError'},
															],
															data:jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo
														})
													});
													var itemContainer = {
														xtype:'container',
														layout: 'hbox',
														items:[
															{	
																xtype:'combo',
																id:'appflowCombo_IdE',
																cls:'dropdown',
																width:115,
																margin:'5 10 5 0',
																displayField : 'name',
																valueField : 'value',
																queryMode : 'local',
																store:Ext.create('Ext.data.Store',{
																	data :jsonData.loadViewDetails[1].Application_Block_1_Value[0].comboObj.combo_arr,
																	fields:['name','value'],
																}),
																value:jsonData.loadViewDetails[1].Application_Block_1_Value[0].comboObj.selectedValue,
																listeners:{
																	select:function(){
																		RumAppFlow.app.getController("Main").changeTopologyEx();
																	}
																},
															},
															{	
																xtype:'uribox',
																id:'appuriBox_IdE',
																margin:'5 10 5 0',
																expandedL:true,
																data:jsonData.loadViewDetails[1].Application_Block_1_Value[0].uriArray
															}
														]
													};															
													var windowEl= 	Ext.create('Ext.window.Window', {
														id:'expanded',
														resizable:false,
														width:'95%',
														draggable: true,
														ghost:false,
														flex:1,
														layout:{
															type:'fit',
															align:'stretch'
														},
														modal:true,
														constrain:true,
														renderTo:Ext.getBody(),
														height:'95%',
														//style:{'padding-left':'10px'},
														//ui:'eg-new-window',
														autoDestroy:true,
														closeAction:'destroy',
														//bodyPadding:'0 10 0 0',
														draggable:false,
														//dockedItems:[itemContainer],
														header: {
															items: [
																{
																	xtype:'container',
																	html:'Response Time Breakup',
																	cls:'f14-bold header',
																	style:{
																		'margin':'0px 10px 0px 0px',
																		//'font-family': 'LucidaGrandeBold !important',
																		//'font-size':'14px',
																		//'font-weight':'500',
																		//'color':'#f7f7f7',
																		'line-height':'1.5em',
																		'text-transform':'uppercase',
																	}
																},
																itemContainer,
															]
														},
														items:[appFlowTopologyObj],
														listeners:
														{
															show: function(win)
															{
																if (this.modal)
																{
																	var dom = Ext.dom.Query.select('.x-mask');								
																	var el = Ext.fly(dom[dom.length-1]);								
																	el.addCls('windowModal');
																}
															},
															hide: function(win)
															{
																if (this.modal)
																{
																	var dom = Ext.dom.Query.select('.x-mask');
																	var el = Ext.fly(dom[dom.length-1]);
																	el.removeCls('windowModal');
																}
															},
															afterrender: function()
															{
																Ext.EventManager.onWindowResize(function()
																{
																	var me = this;
																	me.center();
																}, this);
															}
														}
													}).show();
												}
											}
										}]
									}
									
																
									]
								},
								{
									xtype:'container',
									id:'appflowtopology_ground',
									listeners:{
										afterrender:function(c){
											if(!this.findParentByType('container').showDetails){
												 var appflowbreakup = c.down("#appflowbreakup");
												 c.remove(appflowbreakup,false);
											}
											var me = this;
											me.add({
												xtype:'appflowtopology',
												id:'appflowTopology_id',
												padding:'15 0 15 0',
												ifRTB:true,
												store:Ext.create('Ext.data.Store', {
													fields:[ 
														{ name:'devices' },
														{ name:'url' },
														{ name:'group_url' },
														{ name:'browser'},
														{ name:'request'},
														{ name:'response'},
														{ name:'contentData'},
														{ name:'defaultdata'},
														{ name:'networkData'},
														{ name:'network_connection'},
														{ name:'content_download'},
														{ name:'server_time'},
														{ name:'showError'},
													],
													data:jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo
												}
											)										
											},
											{
												xtype:'appflowbreakup',
												itemId:'appflowbreakup',
												id:'appflowbreakupID',
												flex:0.3,
												listeners:{
													afterrender:function(c){
														var me = this;
														me.updateDetails(jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo.defaultdata);
													}
												}
											});
										}
									},
									flex:1,
									layout:{
										type:'hbox',
										align:'stretch'
									},
									items:[]
								});
							}
						},
						items:[]
					},
					{
						xtype:'container',
						padding:0,
						margin:0,
						height:235,
						 layout: {
							 type: 'hbox',
							 align: 'stretch'
						},
						listeners:{
							'afterrender':function(c){
								var me = this;
								me.add(
								{
									xtype:'responsetimepiechart',
									id:'responsetimepiechart_Rtb',
									legendPosition: 'right', // top,left, bottom and right
									legendLayout:'horizontal',
									flex: 1,
									chartMarginTop:10,
									chartMarginRight:10,
									chartMarginLeft:-350,
									chartMarginBottom:10,
									chartLegendUseHTML:true,
									legendOffset:15,
									legendWidth:185,
									legendContainerWidth:370,
									Jdata:jsonData.loadViewDetails[2].Application_Block_4_Value[0]
								},
								{
									xtype: 'rumappflowgrid',
									id:'gridSlowpagegroups_rtb_view',
									gridData:jsonData.loadViewDetails[3].Application_Block_5_Value
								});

							}
						},
						items:[]
					});
				}
			},
			items: []
		});
		card.doLayout();
	},
	addErrorsPage: function(jsonData,cardObj) {
		var me = this,
		card = Ext.getCmp('appflow_ground');
		card.add({
			xtype: 'container',				
			id: "cardID",
			listeners:{
				'afterrender':function(e){
					var jsonDetails = jsonData.loadViewDetails;
					var me = this;
					me.add(
					{
						xtype: 'overviewdetails',
						id:'overviewdetails_Errors_view',
						data:jsonDetails,
						collapsible: false
					},
					{
						xtype:'errorview',
						id:'page_Errors_view',
						margin:'10 0 0 0',
						data:jsonDetails
					});
					if (!Ext.isEmpty(window.parent.isTvMode)) {
						Ext.getCmp('page_Errors_view').setHeight(1000);
					}
				}
			},
			items: []
		});			
	},
	addUsagePage: function(jsonData,cardObj) {
		var me = this,
		card = Ext.getCmp('appflow_ground');
		card.add({
                xtype: 'container',
                id: "cardID",
				listeners:{
					'afterrender':function(e){
						var jsonDetails = jsonData.loadViewDetails;
						var jsonDetailsfrCPP = [];
						for (var i =1; i<jsonDetails.length;i++) 
						{
							jsonDetailsfrCPP[i-1]=jsonDetails[i];
						}
						var me = this;
						me.add(
						{
							xtype: 'overviewdetails',
							id:'overviewdetails_Usage_view',
							data:jsonDetails,
							collapsible: false
						},
						{
							xtype: 'chartparentpanel',
							id:'chartparentpanel_Usage_view',
							data:jsonDetailsfrCPP,	
						}
						);
						if (!Ext.isEmpty(window.parent.isTvMode)) {
							Ext.getCmp('chartparentpanel_Usage_view').setHeight(1000);
						}
					}
				},
                items: []
            });
	},
    addOverviewPage: function(jsonData,cardObj) {
		var me = this,
		card = Ext.getCmp('appflow_ground');
        // @ destroy all the objects in the card
        //for (var i = 0; i < card.items.items[0].items.items.length; i++) {
            //Ext.destroy(card.items.items[0].items.items[i])
        //}
        //card.removeAll(true);	
		if(!Ext.isEmpty(me.getOverviewdetails())){
			Ext.get(me.getOverviewdetails().getEl().id).stopAnimation();
		}
		card.add({
			xtype: 'container',
			id: "cardID",
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add(
					{
						xtype: 'overviewdetails',
						id:'overviewdetails_Overview_view',
						collapsible: false,
						data:jsonData.loadViewDetails
					},
					{
						xtype: 'container',
						flex: 1,
						margin: '10 0 0 0',
						padding: '0 0 0 0',
						layout: {
							type: 'hbox',
							align: 'stretch'
						},
						listeners:{
							'afterrender':function(e){
								var me = this;
								me.add(
								{
									xtype: 'appflowindetail',
									showDetails:false, // check to remove or add details
									margin: '0 0 2 0',
									items:[
									{
											xtype:'container',
											layout:{type:'hbox',align:'stretch'},
											items:[
												{	
													xtype:'container',
													flex:1,
													layout:{type:'hbox'},
													items:[{  
													xtype: 'label',  
													margin:'2 10 0 0',
													cls:'b_label',
													text: 'Response Time Breakup',
												},
												{	
													xtype:'combo',
													id:'appflowCombo_Id',
													cls:'dropdown',
													width:115,
													margin:'0 10 0 0',
													displayField : 'name',
													valueField : 'value',
													queryMode : 'local',
													store:Ext.create('Ext.data.Store',{
														data :jsonData.loadViewDetails[1].Application_Block_1_Value[0].comboObj.combo_arr,
														fields:['name','value'],
													}),
													value:jsonData.loadViewDetails[1].Application_Block_1_Value[0].comboObj.selectedValue,
													listeners:{
														select:function(){
															RumAppFlow.app.getController("Main").changeTopology();
														}
													},
												},
												{	
													xtype:'uribox',
													id:'appuriBox_Id',
													data:jsonData.loadViewDetails[1].Application_Block_1_Value[0].uriArray
												}]
												},
												{	
													xtype:'container',
													flex:0.5,
													padding:'0 15 10 0',
													layout:{type:'hbox',pack:'end'},
													items:[{
														xtype:'button',
														id:'maxButton',
														cls:'iconMaximize',
														style:{'border':'none !important','margin':'4px 0px 0px 10px !important'},
														hidden:false,
														listeners:{
															'click':function(){
																var bgColor = 'none';
																if(strRumSkin == "Dark")
																	bgColor = '#404040';
																var appFlowTopologyObj = Ext.create('RumAppFlow.view.AppFlowTopology',{
																	id:'appflowTopology_idE',
																	ifRTB:false,
																	style:{'padding-left':'5px !important','background':bgColor},
																	expandedL:true,
																	topoData:jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo,
																	store:Ext.create('Ext.data.Store', {
																		//autoLoad:true,
																		fields:[ 
																			{ name:'devices' },
																			{ name:'url' },
																			{ name:'group_url' },
																			{ name:'browser'},
																			{ name:'request'},
																			{ name:'response'},
																			{ name:'network_connection'},
																			{ name:'content_download'},
																			{ name:'server_time'},
																			{ name:'showError'},
																		],
																		data:jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo
																	})
																});
																var itemContainer = {
																	xtype:'container',
																	layout: 'hbox',
																	items:[
																		{	
																			xtype:'combo',
																			id:'appflowCombo_IdE',
																			cls:'dropdown',
																			width:115,
																			margin:'5 10 5 0',
																			displayField : 'name',
																			valueField : 'value',
																			queryMode : 'local',
																			store:Ext.create('Ext.data.Store',{
																				data :jsonData.loadViewDetails[1].Application_Block_1_Value[0].comboObj.combo_arr,
																				fields:['name','value'],
																			}),
																			value:jsonData.loadViewDetails[1].Application_Block_1_Value[0].comboObj.selectedValue,
																			listeners:{
																				select:function(){
																					RumAppFlow.app.getController("Main").changeTopologyEx();
																				}
																			},
																		},
																		{	
																			xtype:'uribox',
																			id:'appuriBox_IdE',
																			margin:'5 10 5 0',
																			expandedL:true,
																			data:jsonData.loadViewDetails[1].Application_Block_1_Value[0].uriArray
																		}
																	]
																};															
																var windowEl= 	Ext.create('Ext.window.Window', {
																	id:'expanded',
																	resizable:false,
																	width:'95%',
																	draggable: true,
																	ghost:false,
																	flex:1,
																	layout:{
																		type:'fit',
																		align:'stretch'
																	},
																	modal:true,
																	constrain:true,
																	renderTo:Ext.getBody(),
																	height:'95%',
																	//style:{'padding-left':'10px'},
																	//ui:'eg-new-window',
																	autoDestroy:true,
																	closeAction:'destroy',
																	//bodyPadding:'0 10 0 0',
																	draggable:false,
																	//dockedItems:[itemContainer],
																	header: {
																		items: [
																			{
																				xtype:'container',
																				html:'Response Time Breakup',
																				cls:'f14-bold header',
																				style:{
																					'margin':'0px 10px 0px 0px',
																					//'font-family': 'LucidaGrandeBold !important',
																					//'font-size':'14px',
																					//'font-weight':'500',
																					//'color':'#f7f7f7',
																					'line-height':'1.5em',
																					'text-transform':'uppercase',
																				}
																			},
																			itemContainer,
																		]
																	},
																	items:[appFlowTopologyObj],
																	listeners:
																	{
																		show: function(win)
																		{
																			if (this.modal)
																			{
																				var dom = Ext.dom.Query.select('.x-mask');								
																				var el = Ext.fly(dom[dom.length-1]);								
																				el.addCls('windowModal');
																			}
																		},
																		hide: function(win)
																		{
																			if (this.modal)
																			{
																				var dom = Ext.dom.Query.select('.x-mask');
																				var el = Ext.fly(dom[dom.length-1]);
																				el.removeCls('windowModal');
																			}
																		},
																		afterrender: function()
																		{
																			Ext.EventManager.onWindowResize(function()
																			{
																				var me = this;
																				me.center();
																			}, this);
																		}
																	}
																}).show();
															}
														}
													}]
												}
												
												
											]
									},
									{
										xtype:'appflowtopology',
										id:'appflowTopology_id',
										padding:'0 5 0 0',
										topoData:jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo,
										store:Ext.create('Ext.data.Store', {
											//autoLoad:true,
											fields:[ 
												{ name:'devices' },
												{ name:'url' },
												{ name:'group_url' },
												{ name:'browser'},
												{ name:'request'},
												{ name:'response'},
												{ name:'network_connection'},
												{ name:'content_download'},
												{ name:'server_time'},
												{ name:'showError'},
											],
											data:jsonData.loadViewDetails[1].Application_Block_1_Value[0].topo
										}
									)										
									}
									],
									flex: 1,
								},
								{
									xtype: 'container',
									margin: '0 0 0 0',
									layout: {
										type: 'vbox',
										align: 'stretch'
									},
									//width: 408,
									width: 380,
									margin: '0 0 0 10',
									listeners:{
									'afterrender':function(e){
											var me = this;
											me.add({
												xtype: 'frontendbackendgrid',
												id:'gridTopSlowURL_Frontend_Backend_view',
												title: topSlowURL,
												gridData:jsonData.loadViewDetails[5].Application_Block_6_Value,
												margin: '0 2 10 0',
												flex: 1
											}, {
												xtype: 'rumappflowgrid',
												id:'gridSlowCountries_Overview_view',
												flex: 1,
												margin: '0 2 10 0',
												//title: 'Top 5 Slow Countries',
												title: jsonData.loadViewDetails[2].Application_Block_2_Value[0].title,
												gridData:jsonData.loadViewDetails[2].Application_Block_2_Value
											},{
												xtype: 'rumappflowgrid',
												id:'gridSlowpageGroups_Overview_view',
												//title:'Top 5 Slow Page Groups',
												title:jsonData.loadViewDetails[3].Application_Block_3_Value[0].title,
												gridData:jsonData.loadViewDetails[3].Application_Block_3_Value,
												margin: '0 2 2 0',
												flex: 1
											});
											if(requestParams.btmEnabled=='true'){
												Ext.getCmp("gridTopSlowURL_Frontend_Backend_view").show();
												Ext.getCmp("gridSlowCountries_Overview_view").hide();
											}else{
												Ext.getCmp("gridSlowCountries_Overview_view").show();
												Ext.getCmp("gridTopSlowURL_Frontend_Backend_view").hide();
											}
										}
									}
								});
							}
						},
						items: []
					});					
				}
			},				
		});
		card.doLayout();
	},
	 addPage: function(menuItem) {
		var me = this,
		card = Ext.getCmp('appflow_ground');

		Ext.getCmp('settingIconId').hide();
        // @ destroy all the objects in the card
        for (var i = 0; i < Ext.getCmp('appflow_ground').items.items[0].items.items.length; i++) {
            Ext.destroy(card.items.items[0].items.items[i])
        }
        card.removeAll(true);
		var params = this.getDefaultParams();
		params +='&action=loadViewData';
		
		
		var menuObj = Ext.getCmp('rumappmenu_view_id');
		var forceClickKey ;
		var dispInfo ;
		var cnCombo ;
		var isFromForceClick = false;
		if(menuObj != undefined && menuObj != null )
		{
			forceClickKey = menuObj.forceClickKey;
			dispInfo = menuObj.dispInfo;
			cnCombo = menuObj.cnCombo;
			if(forceClickKey != undefined && forceClickKey != null && cnCombo != undefined && cnCombo != null )
			{
				params +='&isRefresh=true';
				params +='&viewName=region';
				params +='&filterNameRaw='+dispInfo;
				params +='&filterName='+forceClickKey;
				isFromForceClick = true;
			}
		}
		var tabUrl = "/final/servlet/com.eg.EgCommonDashboardController?"+params;
		Ext.getBody().mask('Loading...');
		Ext.Ajax.request({
			url : tabUrl,
			method : 'POST',
			//params:params,
			scope:this,
			timeout:280000,
			success : function(response, opts)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "overview_geo_view" )
				{
					me.addOverviewGeoPage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "overview_view" )
				{
					me.addOverviewPage(jsonData,card);					
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "usage")
				{
					me.addUsagePage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "errors" )
				{
					me.addErrorsPage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "response_time_breakup_view" )
				{
					me.addResponseTBPage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "omni_channel" )
				{
					me.addOmniChannelPage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "page_views" )
				{
					me.addPageViewsPage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "geo_view" )
				{
					me.addGeoPage(jsonData,card);
					if(isFromForceClick)
					{
						var countryComboObj = Ext.getCmp('countryComboId');
						var regionComboObj = Ext.getCmp('regionComboId');
						countryComboObj.getStore().loadRawData(cnCombo);
						countryComboObj.setValue(forceClickKey);
						countryComboObj.show();
						
						var reg_arr = jsonData.loadViewDetails[1].Application_Block_1_Value[0][0].regionArray;
						var selectedRegion = jsonData.loadViewDetails[1].Application_Block_1_Value[0][0].selectedRegion;
						regionComboObj.getStore().loadRawData(reg_arr);
						regionComboObj.setValue(selectedRegion);
						regionComboObj.show();

						menuObj.dispInfo=null;
						menuObj.forceClickKey=null;
						menuObj.cnCombo=null;
					}
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "topology_view" )
				{
					me.addTopologyPage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "metrics_View" )
				{
					me.addMetricsPage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "Web_Transaction_Sub_View" )
				{
					me.addwebTransPage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "Emulated_Transaction_Sub_View" )
				{
					me.addemuTransPage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "Logon_Sub_View" )
				{
					me.addlogonTransPage(jsonData,card);
				}
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "aggregates_View" )
				{
					me.addaggregatesPage(jsonData,card);
				}		
				else if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab == "systems_View" )
				{
					Ext.getCmp('settingIconId').show();
					me.addsystemsPage(jsonData,card);
				}				
				Ext.getBody().unmask();
				me.autoScrollTvMode('appflow_ground');
				//requestParams.selectedTab=-=-=-> errors
			},
			failure:function(){
				Ext.getBody().unmask();
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		}); 
		
		//return;        
        //card.doLayout();
		//TVMODE Scroll
			
    },
	autoScrollTvMode:function(domID){
			if (!Ext.isEmpty(window.parent.isTvMode)) {
				//has scroll plugin
				$.fn.hasScrollBar = function() {
					return this.get(0).scrollHeight - 40 > this.height();
				}
				if (window.parent.isTvMode) {
					
					var ifScrollt = window.parent.Ext.getCmp('playBtn').ifScroll = true;
					var totalScrollLength = Ext.get(domID).dom.scrollHeight - Ext.get(domID).dom.offsetHeight;
					var scrollHeightx = totalScrollLength * 100;
					var scrollHeightDurationx = totalScrollLength * 70;
					var ifPageHasScroll = $('#'+domID).hasScrollBar();
					var ClickActionPause=false;
					var clearTimeOut="";
					var getTvModePlayAction = function () {
							var silderAction = window.parent.Ext.getCmp('tvmode').sliderAction;
							if(silderAction == "pause"){
									Ext.get(domID).getActiveAnimation().paused = false;
									ClickActionPause = true;
								
								}
								else{
									clearTimeout( clearTimeOut );
									Ext.get(domID).getActiveAnimation().paused = true;
									window.parent.Ext.getCmp('tvmode').sliderObj.pause();
									ClickActionPause = false;
								}
					};
					if(ifPageHasScroll){
						var sc = Ext.get(domID).getActiveAnimation().paused = true;
						window.parent.Ext.getCmp('tvmode').sliderObj.pause();
						Ext.get(domID).scroll("b",
						scrollHeightx, {
							duration: scrollHeightDurationx,
							listeners: {
								beforeanimate: function (el, eOpts) {
									isKioskModeScrollInProgress = true;
								},
								afteranimate: function (el, startTime, eOpts) {
									Ext.get(domID).stopAnimation();
									Ext.defer(function () {
										isKioskModeScrollInProgress = false;
											window.parent.Ext.getCmp('tvmode').sliderObj.play();
											if (!Ext.isEmpty(runner)) {
												runner.destroy();
											}
									}, 1000);
									window.parent.Ext.getCmp('playBtn').ifScroll = false;
								}
							}
						}, {
							scope: Ext.get(domID)
						});
					}else{
						window.parent.Ext.getCmp('playBtn').ifScroll = false;
						window.parent.Ext.getCmp('tvmode').sliderObj.pause();
						if(ClickActionPause == true){
							clearTimeout( clearTimeOut );
							window.parent.Ext.getCmp('tvmode').sliderObj.pause();
							
						}
						else{
						clearTimeOut = Ext.defer(function(){
								window.parent.Ext.getCmp('tvmode').sliderObj.play();  
								},window.parent.Ext.getCmp('tvmode').getTimeFrequency);  
						}
					}
					var runner = new Ext.util.TaskRunner();
					var task = runner.start({
												run: getTvModePlayAction,
												interval: 1000
											});

					
				
				}
			}
			
	},
    /*
     *sidebar menu load
     */
	doClick:function(sm, record){
		//console.log(sm);
	},        
    overviewdetailsRender: function() {
		var me = this;
        var button = Ext.ComponentQuery.query('button[itemId="overviewtoggle"]')[0];
        if (me.getOverviewdetails().collapsible) {
            button.pressed = true;
            Ext.defer(function() {
				me.toggleOverView(button, true);
            }, 500);

        } else {
            button.pressed = false;
			me.toggleOverView(button, false);
        }
    },
    /*
     * overview toggle button
     */
    toggleOverView: function(btn, pressed, eOpts) {
		var me = this,
		toggleOuterEl = Ext.get(me.getOverviewdetails().el.id),
		toggleIn = 60,
		toggleOut = 160,
		toggleDuration = 250,
		sbox = Ext.get(me.getOverviewdetails().el.id).select('.s_box'),
		bbox = Ext.get(me.getOverviewdetails().el.id).select('.b_box');
		if (pressed) {
          //  btn.setText("<b>+</b>");
          btn.setIconCls('toggle_p');
            me.getOverviewdetails().suspendLayouts();
            bbox.setStyle('display', 'none');
            sbox.setStyle('display', 'block');
            toggleOuterEl.animate({
                duration: toggleDuration,
                to: {
                    height: toggleIn
                },
                listeners: {
                    beforeanimate: function() {
						bbox.animate({
							duration: 200,
                            to: {
								opacity:0
                            }
                        });
                        sbox.animate({
							 duration: 300,
                            to: {
								opacity:1
                            }
                        });
                    },
                    afteranimate: function() {
                        me.getOverviewdetails().setHeight(toggleIn);
						sbox.stopAnimation();
						bbox.stopAnimation();
                        //me.getOverviewdetails().doLayout();
                    }
                }
            });
            me.getOverviewdetails().resumeLayouts(true);
        } else {

           // btn.setText("<b>-</b>");
            btn.setIconCls('toggle_m');
			 me.getOverviewdetails().suspendLayouts();
				bbox.setStyle('display', 'block');
			 sbox.setStyle('display', 'none');
            toggleOuterEl.animate({
                duration: toggleDuration,
                to: {
                    height: toggleOut
                },
                listeners: {
                    beforeanimate: function() {
                        sbox.animate({
							duration: 300,
                            to: {
								opacity:0
                            }
                        });
                        bbox.animate({
							 duration: 200,
                            to: {
								opacity:1
                            }
                        });
						me.getOverviewdetails().setHeight(toggleOut);
                    },
                    afteranimate: function() {
						me.getOverviewdetails().setHeight(toggleOut);
						sbox.stopAnimation();
						bbox.stopAnimation();
                        //me.getOverviewdetails().doLayout();
                    }
                }
            });
			me.getOverviewdetails().resumeLayouts(true);
        }
		  
		this.getMain().doComponentLayout();
    },

	overviewdetailsRenderforRefresh: function() {
		var me = this;
        var button = Ext.ComponentQuery.query('button[itemId="overviewtoggle"]')[0];
		try
		{
			if(Ext.isEmpty(button.pressed))
				button.pressed = true;

			me.toggleOverViewRefresh(button, button.pressed);      			
		}
		catch (e)
		{
		}		
    },

	toggleOverViewRefresh: function(btn, pressed, eOpts) {
		var me = this,
		toggleOuterEl = Ext.get(me.getOverviewdetails().el.id),
		toggleIn = 60,
		toggleOut = 160,
		toggleDuration = 0,
		sbox = Ext.get(me.getOverviewdetails().el.id).select('.s_box'),
		bbox = Ext.get(me.getOverviewdetails().el.id).select('.b_box');
		if (pressed) {
          //btn.setText("<b>+</b>");
          btn.setIconCls('toggle_p');
          me.getOverviewdetails().suspendLayouts();
          bbox.setStyle('display', 'none');
          sbox.setStyle('display', 'block');
          toggleOuterEl.animate({
                duration: toggleDuration,
                to: {
                    height: toggleIn
                },
                listeners: {
                    beforeanimate: function() {
						sbox.setStyle('top', '0');
                        /*sbox.animate({
                            to: {
                                top: 0
                            }
                        });*/
                    },
                    afteranimate: function() {
                        me.getOverviewdetails().setHeight(toggleIn);
                        //me.getOverviewdetails().doLayout();
                    }
                }
            });
            me.getOverviewdetails().resumeLayouts(true);
        } else {

           // btn.setText("<b>-</b>");
            btn.setIconCls('toggle_m');
			me.getOverviewdetails().suspendLayouts();
            bbox.setStyle('display', 'block');
            toggleOuterEl.animate({
                duration: toggleDuration,
                to: {
                    height: toggleOut
                },
                listeners: {
                    beforeanimate: function() {
                        me.getOverviewdetails().setHeight(toggleOut);
						sbox.setStyle('top', '500');
                        /*sbox.animate({
                            to: {
                                top: 500
                            }
                        });*/
                        sbox.setStyle('display', 'none');
                    },
                    afteranimate: function() {
                        //me.getOverviewdetails().doLayout();
                    }
                }
            });
			me.getOverviewdetails().resumeLayouts(true);
        }
		  
		this.getMain().doComponentLayout();		
	},
});

