Ext.define('EgCorAlarm.controller.Main', {
    extend: 'Ext.app.Controller',
    requires: [
        'EgCorAlarm.view.Main',
        'EgCorAlarm.view.Alarms.AlarmsFilter',
        'EgCorAlarm.view.Alarms.AlarmsGroupedView',
        'EgCorAlarm.view.Alarms.AlarmsTreeView',
        'EgCorAlarm.view.Alarms.AcknowledgementPanel',
        'EgCorAlarm.view.Alarms.AcknowledgementOptions',
        'currentAlarms.view.AlarmFilters',
        'currentAlarms.view.CurrentAlarmsSummary',
        'history.view.HistoryFilters',
        'history.view.HistorySummary',
        'history.model.*',
        'history.store.*'
    ],
    refs: [{
            ref: 'main',
            selector: 'main',
        },
        {
            selector: 'acknowledgementpanel',
            ref: 'acknowledgementpanel'
        },
        {
            selector: 'currentalarmssummary',
            ref: 'currentalarmssummary'
        }
    ],
    init: function() {
        timerId=window.setInterval("executee()",refreshFrequency);
        //timerId=window.setInterval("executee()",10000);
        this.control({
            'main': {
                //afterrender: this.onLoad
            },
            'button[id="MetricBackButton"]': {
                'click': this.goBack
            },
        });
    },
    checkSpecialCharacter: function(name) {
        var splChar = "=\"";
        for (var i = 0; i < name.length; i++) {
            check_char = splChar.indexOf(name.charAt(i))
            //Returns value 1 if the special character listed in splChar is found
            if (check_char >= 0) {
                return true;
            }
        }
        return false;
    },
    alarmAckSubmit: function(buttonObj) {
        var alarmAckEvent = alarmAckHiddenParams['alarmAckEvent'];

        if (alarmAckEvent != null) {
            if (alarmAckEvent == "Delete_Alarm") {
                this.alarmDelete(buttonObj);
            } else if (alarmAckEvent == "AckOrUnack") {
                this.alarmAcknowledge(buttonObj);
            }
        }
    },
    alarmAcknowledge: function(buttonObj) {
        var des = Ext.getCmp('textaraObj').getValue();
        var description = true;
        if (isDoubleByteEnabled == "false")
            description = validateSingleByte(des);
        if (!checkblankVal(des)) {
            Ext.MessageBox.show({
                title: 'Alert',
                msg: ackDescriptionAlert,
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return false;
        } else if (this.checkSpecialCharacter(des)) {
            Ext.Msg.show({
                title: "Alert",
                msg: ackDescriptionSplCharAlert,
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        } else if (!description) {
            Ext.MessageBox.show({
                title: 'Alert',
                msg: ackdbyteAlert,
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return false;
        } else {
            if (isDoubleByteEnabled && isOracleDB) {
                if (des != null && des != '' && des.length > 1024) {
                    Ext.MessageBox.show({
                        title: 'Alert',
                        msg: maxAcknowledgeDescForDByte,
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.WARNING
                    });
                    return false;
                }
            } else if (des != null && des != '' && des.length > 2048) {
                Ext.MessageBox.show({
                    title: 'Alert',
                    msg: maxAcknowledgeDescForSByte,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return false;
            }

            if (des == null || des == '')
                des = "-";

            /*var ackAlarmIDs = alarmAckHiddenParams['ackAlarmIDs'];

			if(ackAlarmIDs.indexOf("#")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.substring(ackAlarmIDs.indexOf("#")+1);
			}
		//	EgAckForm.hiddesc.value=des;
			while(ackAlarmIDs.indexOf("+")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("+","|plus|");
			}
			while(ackAlarmIDs.indexOf("&")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("&","|amp|");
			}
			while(ackAlarmIDs.indexOf("%")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("%","|pct|");
			}*/
            var userAck = alarmAckHiddenParams['userAck'];
            var alarmId = alarmAckHiddenParams['alarmId'];
            var ackAlarmDB = alarmAckHiddenParams['ackAlarmDB'];

            try {
                des = window.opener.filterEncode(des);
            } catch (e) {
                des = parent.filterEncode(des);
            }

            //var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=" +encodeURIComponent(userId) + "&alarmID=" + alarmId+ "&userAck=" + userAck + "&ackAlarmIDs=" +encodeURI(ackAlarmIDs)+ "&ackAlarmDB="+ackAlarmDB;
            var QStr = "desc=" + encodeURIComponent(des) + "&hiddesc=" + encodeURIComponent(des) + "&userID=" + userId + "&alarmID=" + alarmId + "&userAck=" + userAck + "&ackAlarmDB=" + ackAlarmDB;
            Ext.getCmp('ackWindowObj').destroy();
            var meController = this;
            var emtText = Ext.get("emptyTextTb");
            try {
                if (emtText != null)
                    Ext.get("emptyTextTb").hide();
            } catch (e) {}
            alarmLoadMask.show();

            var browser = get_browser_info();
            Ext.Ajax.request({
                url: '/final/servlet/com.eg.EgCurrentAlarmsC',
                method: 'POST',
				timeout:300000,
                params: QStr + '&doAlarmAcknowledgementEvent=true&acknowledgementEvent=acknowledge&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height) + '&isBro=' + browser.name + "&isFromQuickLink=" + isFromQuickLink + '&isFromICMPage=true',
                scope: this,
                success: function(response) {
                    //var jsonText = response.responseText;
                    //console.log(jsonText);
                    //var jsonData=Ext.decode(jsonText);
                    var jsonData = JSON.parse(response.responseText);
                    var acknowledge = jsonData['acknowledge'];
                    alarmLoadMask.hide();
                    if (ttIntegrationenabled != null && ttIntegrationenabled == "Yes" || ttIntegrationenabled == "true") {
                        var queryStr = "sendTTAcknowledgement=true&desc=" + encodeURIComponent(des) + "&alarm_Id=" + alarmId;
                        Ext.Ajax.request({
                            url: '/final/servlet/com.eg.EgCurrentAlarmsC',
                            method: 'POST',
							timeout:300000,
                            params: queryStr,
                            scope: this,
                            success: function(response) {
                                var jsonData = JSON.parse(response.responseText);
                            }
                        });
                    }
                    this.goToAlarmsPage();
                    /*meController.loadAlarms(buttonObj);
                    var searchField = Ext.getCmp('searchTextBox');
                    if(!Ext.isEmpty(searchField.getValue()))
                    {
                    	this.searchAlarms(searchField,'fire');
                    }
                    else
                    {
                    	searchField.setValue('');
                    	meController.loadAlarms(buttonObj);
                    }*/
                }
            });
        }
    },
    alarmDelete: function(button) {
        var des = Ext.getCmp('textaraObj').getValue();

        var description = true;

        if (isDoubleByteEnabled == "false")
            description = validateSingleByte(des);


        if (this.checkSpecialCharacter(des)) {
            Ext.Msg.show({
                title: "Alert",
                msg: ackDescriptionSplCharAlert,
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        } else if (!description) {
            Ext.MessageBox.show({
                title: 'Alert',
                msg: ackdbyteAlert,
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return false;
        } else {
            if (isDoubleByteEnabled && isOracleDB) {
                if (des != null && des != '' && des.length > 1024) {
                    Ext.MessageBox.show({
                        title: 'Alert',
                        msg: maxAcknowledgeDescForDByte,
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.WARNING
                    });
                    return false;
                }
            } else if (des != null && des != '' && des.length > 2048) {
                Ext.MessageBox.show({
                    title: 'Alert',
                    msg: maxAcknowledgeDescForSByte,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return false;
            }

            if (des == null || des == '')
                des = "-";

            try {
                des = window.opener.filterEncode(des);
            } catch (e) {
                des = parent.filterEncode(des);
            }
            publicJson['hiddenParams']['userID'] = alarmAckHiddenParams['userId'];
            publicJson['hiddenParams']['alarmID'] = alarmAckHiddenParams['alarmId'];
            publicJson['hiddenParams']['desc'] = des;
            //publicJson['hiddenParams']['delAlarmIDs'] = alarmAckHiddenParams['ackAlarmIDs'];
            publicJson['hiddenParams']['isDelAlarms'] = "true";
            publicJson['hiddenParams']['ackAlarmDbDelete'] = alarmAckHiddenParams['ackdelAlarmDb'];
            publicJson['hiddenParams']['delAlarmIDs'] = '';
            var strDeleteView = alarmAckHiddenParams['ackdelAlarmDb'];
            if (eventDeleteFlag && !Ext.isEmpty(strDeleteView) && strDeleteView != undefined && strDeleteView != 'undefined' && strDeleteView == 'Delete Alarm') {
                var optionVal = Ext.getCmp('option').getValue();
                if (!Ext.isEmpty(optionVal) && optionVal != undefined && optionVal == 'All') {
                    publicJson['hiddenParams']['deleteOptions'] = optionVal;
                } else if (!Ext.isEmpty(optionVal) && optionVal != undefined && optionVal == 'Selected') {
                    publicJson['hiddenParams']['deleteOptions'] = optionVal;

                    var selectedInfos = '';
                    var descriptorsObj = null;
                    if (eventGrpDeleteFlag) {
                        descriptorsObj = Ext.getCmp('selEventDescriptors');
                    } else {
                        descriptorsObj = Ext.getCmp('selDescriptors');
                    }

                    if (!Ext.isEmpty(descriptorsObj)) {
                        var splitDescriptorsNames = descriptorsObj.getValue();
                        var store_data = descriptorsObj.getStore();
                        if (!Ext.isEmpty(store_data) && !Ext.isEmpty(splitDescriptorsNames)) {
                            for (var m = 0; m < splitDescriptorsNames.length; m++) {
                                var selected_info = splitDescriptorsNames[m];
                                for (var k = 0; k < store_data.getCount(); k++) {
                                    var store_info = store_data.getAt(k).data.value;
                                    if (store_info == selected_info) {
                                        if (selectedInfos == "") {
                                            selectedInfos = selected_info;
                                        } else {
                                            selectedInfos = selectedInfos + "~!~" + selected_info;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    publicJson['hiddenParams']['deleteSelectedInfos'] = selectedInfos;
                }
            }

            var QStr = this.updateQueryString(button.getId());
            Ext.getCmp('ackWindowObj').destroy();
            var meController = this;
            var emtText = Ext.get("emptyTextTb");
            try {
                if (emtText != null)
                    Ext.get("emptyTextTb").hide();
            } catch (e) {}
            alarmLoadMask.show();
            var browser = get_browser_info();
            Ext.Ajax.request({
                url: '/final/servlet/com.eg.EgCurrentAlarmsC',
                method: 'POST',
				timeout:300000,
                params: QStr + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height) + '&isBro=' + browser.name + "&isFromQuickLink=" + isFromQuickLink + '&isFromICMPage=true',
                scope: this,
                success: function(response) {
                    //var jsonText = response.responseText;
                    //var jsonData=Ext.decode(jsonText);
                    var jsonData = JSON.parse(response.responseText);
                    publicJson = jsonData;
                    alarmLoadMask.hide();
                    if (ttIntegrationenabled != null && ttIntegrationenabled == "Yes" || ttIntegrationenabled == "true") {
                        var alarmId = alarmAckHiddenParams['alarmId'];
                        var queryStr = "sendTTAcknowledgement=true&desc=" + encodeURIComponent(des) + "&alarm_Id=" + alarmId;
                        Ext.Ajax.request({
                            url: '/final/servlet/com.eg.EgCurrentAlarmsC',
                            method: 'POST',
							timeout:300000,
                            params: queryStr,
                            scope: this,
                            success: function(response) {
                                var jsonData = JSON.parse(response.responseText);
                            }
                        });
                    }

                    //meController.loadDefaults(true);
                    this.goToAlarmsPage();
                    publicJson['hiddenParams']['alarmID'] = '';
                    publicJson['hiddenParams']['desc'] = '';
                    publicJson['hiddenParams']['delAlarmIDs'] = '';
                    publicJson['hiddenParams']['isDelAlarms'] = "false";
                    publicJson['hiddenParams']['ackAlarmDbDelete'] = '';
                    publicJson['hiddenParams']['deleteOptions'] = '';
                    publicJson['hiddenParams']['deleteSelectedInfos'] = '';
                }
            });
        }
    },

    updateQueryString: function(objId) {
        var des = Ext.getCmp('textaraObj').getValue();
        var QStr = ''; // "&compsearch="+searchText+"&selectedSearchByOption="+searchByCombo;
        //QStr += 'alarmType=CurrentAlarms&userID=admin&alarmID='+queryReqParams.alarmId+'&isDelAlarms=true&ackAlarmDbDelete=Delete%20Alarm&isFromDashBoard=false&desc='+des;
        QStr += 'alarmType=CurrentAlarms';

        var hidQstr = '';
        var hiddenParams = publicJson['hiddenParams'];
        for (var hid in hiddenParams) {
            var hidVal = hiddenParams[hid];

            if (hidVal != null)
                hidQstr = hidQstr + '&' + hid + '=' + encodeURIComponent(hidVal);
            else
                hidQstr = hidQstr + '&' + hid + '=' + hidVal;
        }
        QStr = QStr + hidQstr;

        return QStr;
    },
    updatePage: function(newValue) {
        //Ext.getCmp('latencytopview').updatePage();
        //Ext.getCmp('alarmstreeview').updatePage();
		var view_obj = Ext.getCmp('dashmenu_model_id');
		var view_name='';
		try
		{
			view_name=view_obj.selModel.selected.items[0].data.id;
		}
		catch (ere)
		{
		}
		//console.log("view_name   >",view_name);
		if (view_name == "corr_View")
		   EgCorAlarm.app.getController('CorrelatedController').loadAlarms();
        else if (view_name == "unknown_View")
            EgCorAlarm.app.getController('UnknownController').loadAlarms();
        else if (view_name == "metrics_view")
		{
            var metricsController = EgCorAlarm.app.getController("EgCorAlarm.controller.MetricsController");
			metricsController.showAlarms(metricsController.getSubmitButton(), '', '');
		}
        else
            EgCorAlarm.app.getController('CorrelatedController').loadAlarms();
		
    },
    onLoad: function(caption) {
        var me = this;
        var me = this,
            card = Ext.getCmp('home_ground');
        // @ destroy all the objects in the card
        for (var i = 0; i < Ext.getCmp('home_ground').items.items[0].items.items.length; i++) {
            Ext.destroy(card.items.items[0].items.items[i])
        }
        card.removeAll(true);
        if (caption === "corr_View")
            me.goToAlarmsPage();
        else if (caption === "unknown_View")
            me.goToUnknownPage();
        else if (caption === "metrics_view")
            me.goToMetricsPage();
        else
            me.goToAlarmsPage();
		if(!Ext.isEmpty(Ext.getCmp('metricsToolBar'))){
			Ext.getCmp('metricsToolBar').removeAll();
		}
    },
    closeConfig: function(destroy) {
        if (Ext.isEmpty(destroy)) destroy = true;
        var VWidth = Ext.Element.getViewportWidth();
        var container = Ext.getCmp('configMod');
        if (!Ext.isEmpty(container)) {
            var containerPosition = VWidth - (container.width + 15);
            Ext.create('Ext.fx.Anim', {
                target: container,
                duration: 500,
                from: {
                    left: containerPosition,
                    top: 40
                },
                to: {
                    top: -500,
                    left: containerPosition
                },
                callback: function() {
                    container.hide();
                    //componentsList.app.getController("Main").metricRefresh();
                }
            });
            if (destroy)
                container.destroy();
        }

        var container1 = Ext.getCmp('configModUnknown');
        if (!Ext.isEmpty(container1)) {
            var containerPosition1 = VWidth - (container1.width + 15);
            Ext.create('Ext.fx.Anim', {
                target: container1,
                duration: 500,
                from: {
                    left: containerPosition1,
                    top: 40
                },
                to: {
                    top: -500,
                    left: containerPosition1
                },
                callback: function() {
                    container1.hide();
                    //componentsList.app.getController("Main").metricRefresh();
                }
            });
            if (destroy)
                container1.destroy();
        }
    },
    goToMetricsPage: function() {
        var me = this,
        card = Ext.getCmp('home_ground');
		Ext.getBody().mask("Loading...");
        if (card.hasOwnProperty("tools")) {
            for (var t = 0; t < card.tools.length; t++) {
                Ext.destroy(card.tools[t]);
            }
        }
		window.clearInterval(timerId);
        timerId=window.setInterval("executee()",refreshFrequency);

        this.closeConfig();

        card.removeAll(true);
        card.suspendLayouts();

        Ext.getCmp('settingIconId').hide();

        var queryString = "";
        if (qSfromDashboard != "null") {
            queryString = 'EgAlarmHistoryFrame.jsp?loadStaticData=yes&' + qSfromDashboard;
        } else {
            queryString = 'EgAlarmHistoryFrame.jsp?newAlarms=true&eg_tbound=Fixed&loadStaticData=yes';
        }

        if (compstate == 'null')
            compstate = 'All';
        if (analysisBy != 'null' && analysis != 'null') {
            if (analysisBy == 'Service')
                queryString += "&eventfor=" + encodeURIComponent(analysisBy) + "&event_select=" + encodeURIComponent(subevent) + "&compTypeList=" + encodeURIComponent(analysis) + "&state=" + encodeURIComponent(compstate) + "&compNameList=" + encodeURIComponent(hostName);
            else if (analysisBy == 'Segment')
                queryString += "&eventfor=" + encodeURIComponent(analysisBy) + "&event_select=" + encodeURIComponent(subevent) + "&compTypeList=" + encodeURIComponent(analysis) + "&state=" + encodeURIComponent(compstate) + "&compNameList=" + encodeURIComponent(hostName);
            else if (analysisBy == 'Zone')
                queryString += "&eventfor=" + encodeURIComponent(analysisBy) + "&event_select=" + encodeURIComponent(subevent) + "&compTypeList=" + encodeURIComponent(analysis) + "&state=" + encodeURIComponent(compstate) + "&compNameList=" + encodeURIComponent(hostName) + "&selectedsubzone=" + encodeURIComponent(selectedsubzone);
            else if (analysisBy == 'Component')
                queryString += "&eventfor=" + encodeURIComponent(analysisBy) + "&compTypeList=" + encodeURIComponent(analysis) + "&state=" + encodeURIComponent(compstate) + "&compNameList=" + encodeURIComponent(hostName);
            else
                queryString += "&compTypeList=" + encodeURIComponent(analysis) + "&state=" + encodeURIComponent(compstate) + "&compNameList=" + encodeURIComponent(hostName);
        }
        Ext.Ajax.request({
            url: queryString,
			timeout:300000,
            async: true,
            success: function(response) {
                monitor.HistorySummary.filterData = Ext.decode(response.responseText);
				monitor.HistorySummary.filterData.showacknowledge_value = "Yes";
				var toolbarItems=[{
						xtype: 'trigger',
						cls: 'incidentMgmt whitedropdown_search',
						emptyText: Search,
						margin:'1 0 0 0',
						id: 'triggerId',
						name: 'gridsearch',
						enableKeyEvents: true,
						onTriggerClick: function() {
							var triggerId = Ext.getCmp('triggerId').getValue();
							var moreFiltersForm = Ext.getCmp('more-filter-options-panel').getForm();
							moreFiltersForm.findField('infosearch').setValue(triggerId);
							currentPageNo = 1;
							var disp = Ext.getCmp("displayInfo");
							var endInx = parseInt(pageCount) * parseInt(currentPageNo);
							var startInx = endInx - parseInt(pageCount);
							var msg = "Displaying " + (startInx + 1) + "-" + endInx + " of " + recCount;
							disp.setText(msg);
							var first = Ext.getCmp("pfirst");
							var prev = Ext.getCmp("pprev");
							first.disabled = true;
							prev.disabled = true;
							if (parseInt(totalRecords) > currentPageNo) {
								var next = Ext.getCmp("pnext");
								var last = Ext.getCmp("plast");
								next.disabled = false;
								last.disabled = false;
							}
							var metricsController = EgCorAlarm.app.getController("EgCorAlarm.controller.MetricsController");
							metricsController.showAlarms(metricsController.getSubmitButton(), '', '');
						}	
					},{
						xtype: 'tbseparator',
						margin: '6 7 0 7',
					}, {
						xtype: 'label',
						itemId: "metricsLabel",
						margin: '5 0 0 0',
						style: {
							"display": "flex",
							"align-items": "center"
						},
						html: (showCurrent) ? "<span class='iconFullTime' style='margin-right: 5px;display: inline-block;'></span>Showing Current Events" : "<span class='iconFullTime' style='margin-right: 5px;display: inline-block;'></span>Showing Last " + monitor.HistorySummary.filterData.eg_timeline_value
					}, {
						xtype: 'tbseparator',
						margin: '6 7 0 7',
					},{
                        xtype: 'button',
                        iconCls: 'iconSettings',
                        id: 'settingIconIdMetrics',
                        margin: '5 0 0 0',
						padding:0,
                        listeners: {
                            afterrender: function() {
                                Ext.create('Ext.tip.ToolTip', {
                                    target: this.id,
                                    anchor: 'top',
                                    cls: 'yellowTip',
                                    trackMouse: true,
                                    html: settings
                                });
                            }
                        },
                        style: {
                            background: 'none',
                            border: '0px'
                        },
                        handler: function(event, toolEl, panel) {
                            if (Ext.getCmp('configMod').items.items.length == 3) {
                                Ext.getCmp('configMod').items.items[0].destroy();
                            }
                            var VWidth = Ext.Element.getViewportWidth();
							var moreFiltersForm = Ext.getCmp('more-filter-options-panel').getForm();
							if(!Ext.isEmpty(moreFiltersForm)){
								moreFiltersForm.findField('infosearch').hide();
								moreFiltersForm.findField('compsearch').hide();
							}
                            var container = Ext.getCmp('configMod');

                            var containerPosition = VWidth - (container.width + 15);

                            Ext.create('Ext.fx.Anim', {
                                target: container,
                                duration: 500,
                                from: {
                                    left: containerPosition,
                                    top: -500
                                },
                                to: {
                                    top: 40,
                                    left: containerPosition
                                }
                            });

                            container.showAt(containerPosition, 5000);

                            Ext.select('.iconClose3').on('click', function() {
                                Ext.create('Ext.fx.Anim', {
                                    target: container,
                                    duration: 500,
                                    from: {
                                        left: containerPosition,
                                        top: 40
                                    },
                                    to: {
                                        top: -500,
                                        left: containerPosition
                                    },
                                    callback: function() {
                                        container.hide();
                                        //componentsList.app.getController("Main").metricRefresh();
                                    }
                                });
                            }, this);
                        }
					},{
						xtype: 'container',
						width:26,
						id:'settingIconPadding',
						hidden:enableBackbutton
					},{
						xtype: 'tbseparator',
						margin: '6 7 0 7',
						id:'MetricBackButtonSeparator',
						hidden:!enableBackbutton
					},{
						xtype: 'button',
						id: 'MetricBackButton',
						action:'goback',
						margin:'2 10 0 0',
						height:22,
						padding:'3 2',
						cls: 'backbutton',
						iconCls: 'iconBack',
						text: 'Back',
						hidden:!enableBackbutton
				}];
				Ext.getCmp('mainview_tbar_Id').add({
					xtype: 'container',
					height:27,
					id:'metricsToolBar',
					layout: {
						type: 'hbox',
						pack:'center',
					},
					items:toolbarItems
				});
				enableBackbutton = false;
				var store = Ext.create('Ext.data.Store', {
					data: [],
					fields: ['LayerModelURL', 'type', 'name', 'services', 'test', 'stdate', 'duration', 'users', 'description', 'popupVal', 'graphParams', 'priority', 'acknowledgeHeader', 'acknowledgeData', 'ddparams', 'mgrid', 'Logon_Details_Support', 'isShowZones', 'ZoneName','severity'],
					autoLoad: false,
					remoteSort: true,
					proxy: {
						type: 'pagingmemory',
						reader: {
							type: 'json',
							totalProperty: 'totalCount',
							root: 'history'
						}
					}
				});
				var className = null;
				if(!showEventHistory && (!hasVMs || hasVMs == 'false')){
					className = 'metrics alarmTree';
					store = Ext.create('Ext.data.TreeStore', {
					 //extend: 'Ext.data.TreeStore',
					//alias:'widget.historysummarystore',
					//requires:['history.model.HistorySummary', 'Ext.ux.data.PagingMemoryProxy', 'Ext.ux.grid.FiltersFeature'],
					//model: 'history.model.HistorySummary',
					pageSize : 15,
					autoLoad : false,
					remoteSort:true,
					hasFilter:false,
					batchUpdateMode:'complete',
					fields:['LayerModelURL','type','name','services','test','stdate','duration','users','description','popupVal','graphParams','priority','acknowledgeHeader','acknowledgeData','ddparams','mgrid','Logon_Details_Support','isShowZones','ZoneName'],
					proxy: {
						type: 'pagingmemory',
						reader: {
							type: 'json',
							totalProperty: 'totalCount',
						}
					},
					folderSort: true,
					});
				}
                card.add([{
                    xtype: 'panel',
                    //ui:'eg-x-panel',
                    bodyPadding: 0,
                    margin: 0,
                    flex: 1,
                    layout: {
                        type: 'vbox',
                        align: 'stretch'
                    },
                    items: [{
                        xtype: 'panel',
                        ui: 'eg-x-panel',
                        //height:65,
                        margin: '0 1 8 0',
                        items: [{
                            xtype: 'historyfilters',
                            title: '',
							layout:'fit',
							margin:0,
							padding:0,
                            tools: [],
                            items: [{
                                xtype: 'historyfilterscategory',
                                parent: this,
                                flex: 1,
                                items: [{
                                    xtype: 'panel',
                                    //cls:'formOuter',
                                    margin:'5 10 5 10',
									layout:{
										type:'hbox',
										align:'stretch'
									},
                                    items: [{
                                        xtype: 'panel',
                                        layout: 'column',
                                        header: false,
                                        border: false,
                                        frame: false,
										flex:1,
                                        defaults: {
                                            labelAlign: 'left',
                                            labelWidth: '',
                                            labelStyle: 'white-space: nowrap;',
                                            labelSeparator: ''
                                        },
                                        //flex:2,
                                        items: [{
                                                xtype: 'scrollcombo',
                                                margin: '10px 10px',
                                                fieldLabel: 'Analysis By',
                                                editable: false,
                                                name: 'eventfor',
                                                cls: 'dropdown',
												width:180+62,
												labelWidth:62,
                                                displayField: 'displayField',
                                                valueField: 'valueField',
                                                queryMode: 'local',
                                                store: new Ext.data.Store({
                                                    fields: ['displayField', 'valueField'],
                                                    proxy: {
                                                        type: 'memory',
                                                        reader: {
                                                            type: 'json',
                                                            root: 'eventfor'
                                                        }
                                                    }
                                                })
                                            },
                                            {
                                                xtype: 'scrollcombo',
                                                fieldLabel: 'SubEvent',
                                                editable: false,
                                                margin: '10px 10px',
                                                cls: 'dropdown',
												labelWidth:40,
												width:180+40,
                                                name: 'event_select',
                                                displayField: 'displayField',
                                                valueField: 'valueField',
                                                queryMode: 'local',
                                                store: new Ext.data.Store({
                                                    fields: ['displayField', 'valueField'],
                                                    proxy: {
                                                        type: 'memory',
                                                        reader: {
                                                            type: 'json',
                                                            root: 'event_select'
                                                        }
                                                    }
                                                }),
                                                listeners: {
                                                    /*change : function(combo, newValue, oldValue, eOpts) {
                                                    	var subevent = null;
                                                    	var v_event = combo.up('form').getForm()
                                                    			.findField('eventfor').getValue();
                                                    	if (v_event != null && v_event != "")
                                                    		subevent = newValue;
                                                    	if (v_event != null
                                                    			&& (v_event == 'Service'
                                                    					|| v_event == 'Segment' || v_event == 'Zone')) {
                                                    		subevent = newValue;
                                                    		if (v_event != null
                                                    				&& v_event == 'Service'
                                                    				&& (subevent == null	
                                                    						|| subevent == 'Please choose a Service'
                                                    						|| subevent == ""
                                                    						|| subevent == "undefined" || subevent == "-1")) {
                                                    			return;
                                                    		} else if (v_event != null
                                                    				&& v_event == 'Segment'
                                                    				&& (subevent == null
                                                    						|| subevent == 'Please choose a Segment'
                                                    						|| subevent == ""
                                                    						|| subevent == "undefined" || subevent == "-1")) {
                                                    			return;
                                                    		} else if (v_event != null
                                                    				&& v_event == 'Zone'
                                                    				&& (subevent == null
                                                    						|| subevent == 'Please choose a Zone'
                                                    						|| subevent == ""
                                                    						|| subevent == "undefined" || subevent == "-1")) {
                                                    			return;
                                                    		}
                                                    	}
                                                    	var paramValue = "v_event=" + v_event + "&subevent="
                                                    			+ subevent;
                                                    	combo.up('form').loadFields('EgAlarmHistoryFrame.jsp',paramValue);
                                                    }*/
                                                }
                                            }, {
                                                xtype: 'scrollcombo',
                                                labelStyle: 'white-space:nowrap;',
                                                fieldLabel: 'Include Subzones',
                                                margin: '10px 10px',
                                                defaultListConfig: {
                                                    loadingHeight: 70,
                                                    minWidth: 50,
                                                    maxHeight: 300,
                                                    shadow: 'sides'
                                                },
                                                editable: false,
                                                hidden: true,
												labelWidth:95,
												width:180+95,
                                                cls: 'dropdown',
                                                name: 'includeSubZone',
                                                displayField: 'displayField',
                                                valueField: 'valueField',
                                                queryMode: 'local',
                                                store: new Ext.data.Store({
                                                    fields: ['displayField', 'valueField']
                                                }),
                                                listeners: {
                                                    /*change : function(combo, newValue, oldValue, eOpts) {
                                                    	var subevent = null;
                                                    	var v_event = combo.up('form').getForm()
                                                    			.findField('eventfor').getValue();
                                                    	if (v_event != null && v_event != "")
                                                    		subevent = combo.up('form').getForm()
                                                    				.findField('event_select').getValue();
                                                    	var selectedsubzone = newValue;
                                                    	var paramValue = "v_event=" + v_event + "&subevent="
                                                    			+ subevent + "&selectedsubzone="
                                                    			+ selectedsubzone;
                                                    	combo.up('form').loadFields('EgAlarmHistoryFrame.jsp',paramValue);
                                                    }*/
                                                }
                                            }, {
                                                xtype: 'scrollcombo',
                                                fieldLabel: 'Type',
                                                editable: true,
                                                margin: '10px 10px',
                                                cls: 'dropdown',
												width:180+26,
												labelWidth:26,
                                                name: 'compTypeList',
                                                displayField: 'displayField',
                                                valueField: 'valueField',
                                                queryMode: 'local',
                                                store: new Ext.data.Store({
                                                    fields: ['displayField', 'valueField'],
                                                    proxy: {
                                                        type: 'memory',
                                                        reader: {
                                                            type: 'json',
                                                            root: 'compTypeList'
                                                        }
                                                    }
                                                }),
                                                listeners: {
                                                    /*change : function(combo, newValue, oldValue, eOpts) {
                                                    	combo.up('form').findComponents('EgAlarmHistoryFrame.jsp',
                                                    			'Type', combo.up('form').getForm(), false);
                                                    }*/
                                                }
                                            }, {
                                                xtype: 'scrollcombo',
                                                fieldLabel: 'Component',
                                                editable: true,
                                                margin: '10px 10px',
                                                cls: 'dropdown',
                                                name: 'compNameList',
												width:180+63,
												labelWidth:63,
                                                displayField: 'displayField',
                                                valueField: 'valueField',
                                                queryMode: 'local',
                                                store: new Ext.data.Store({
                                                    fields: ['displayField', 'valueField'],
                                                    proxy: {
                                                        type: 'memory',
                                                        reader: {
                                                            type: 'json',
                                                            root: 'compNameList'
                                                        }
                                                    }
                                                }),
                                                listeners: {
                                                    /*select : function(combo, newValue, oldValue, eOpts) {
                                                    	combo.up('form').findComponents('EgAlarmHistoryFrame.jsp',
                                                    			'Name', combo.up('form').getForm(), false);
                                                    }*/
                                                }
                                            }, {
                                                xtype: 'scrollcombo',
                                                fieldLabel: 'Priority',
                                                editable: false,
                                                cls: 'dropdown',
                                                name: 'state',
												width:180+39,
												labelWidth:39,
                                                displayField: 'displayField',
                                                valueField: 'valueField',
                                                queryMode: 'local',
                                                margin: '10px 10px',
                                                store: new Ext.data.Store({
                                                    fields: ['displayField', 'valueField'],
                                                })
                                            },
                                            {
                                                xtype: 'button',
                                                //text: showAlarms,
												height:21,
                                                text: "Submit",
                                                cls: 'button20',
												 margin: '10px 10px',
                                                //margin: '31px 0px 0px 10px',
                                                action: 'Show Alarms'
                                            }
                                        ]
                                    },{
										xtype: 'panel',
										layout: {
											type:'hbox',
											pack:'center',
											align:'middle'
										},
										items:[{
											xtype: 'container',
											margin: '10px 5px',
											id: 'saveTool',
											cls: 'iconBg',
											//disabled: true,
											items: [{
												xtype: 'button',
												iconCls: 'iconPdf',
												 listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: save
																});
															}
														},
													style:{
														background:'none',border:'0px'
														},           
												action: 'Save PDF',          
											}]
										}, {
											xtype: 'tbseparator',
											margin: '13px 0px'
										}, {
											xtype: 'container',
											margin: '10px 5px',
											cls: 'iconBg',
											id: 'csvTool',
											//disabled: true,
											items: [{
												xtype: 'button',
												iconCls: 'iconCsv',
												 action: 'Save CSV',
												listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: csv
																});
															}
														},
													style:{
													background:'none',border:'0px'
													},  
											}]
										}]
									}]
                                }]
                            }]
                        }]
                    }, {
                        xtype: 'panel',
                        ui: 'eg-x-panel',
                        flex: 1,
                        bodyPadding: 10,
                        margin: '0 1px 1px 0',
                        layout: {
                            type: 'vbox',
                            align: 'stretch'
                        },
                        items: [ {
                            xtype: 'historysummary',
							selModel: new Ext.selection.CheckboxModel({
								checkOnly: true,
								showHeaderCheckbox : false,
								mode: 'MULTI',
								headerWidth: 30
							}),
							EgCorAlarms:true,
                            selType: 'checkboxmodel',
							cls:className,
							showCurrent:showCurrent,
                            flex: 1,
                            //margin: '0 10 5 10',
							store:store,
                            /*store: Ext.create('Ext.data.Store', {
                                data: [],
                                fields: ['LayerModelURL', 'type', 'name', 'services', 'test', 'stdate', 'duration', 'users', 'description', 'popupVal', 'graphParams', 'priority', 'acknowledgeHeader', 'acknowledgeData', 'ddparams', 'mgrid', 'Logon_Details_Support', 'isShowZones', 'ZoneName','severity'],
                                autoLoad: false,
                                remoteSort: true,
                                proxy: {
                                    type: 'pagingmemory',
                                    reader: {
                                        type: 'json',
                                        totalProperty: 'totalCount',
                                        root: 'history'
                                    }
                                }
                            })*/
							/*store: Ext.create('Ext.data.TreeStore', {
							 //extend: 'Ext.data.TreeStore',
							//alias:'widget.historysummarystore',
							//requires:['history.model.HistorySummary', 'Ext.ux.data.PagingMemoryProxy', 'Ext.ux.grid.FiltersFeature'],
							//model: 'history.model.HistorySummary',
							pageSize : 15,
							autoLoad : false,
							remoteSort:true,
							hasFilter:false,
							batchUpdateMode:'complete',
							fields:['LayerModelURL','type','name','services','test','stdate','duration','users','description','popupVal','graphParams','priority','acknowledgeHeader','acknowledgeData','ddparams','mgrid','Logon_Details_Support','isShowZones','ZoneName'],
							proxy: {
								type: 'pagingmemory',
								reader: {
									type: 'json',
									totalProperty: 'totalCount',
								}
							},
							folderSort: true,
							})*/
                            emptyText : '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div class="noData">No alarms found</div></div></div>'
                        }]
                    },{
						xtype: 'panel',
						ui: 'eg-x-panel',
						itemId: 'ackDelToolbar',
						hidden: true,
						height: 55,
						layout:'fit',
						margin: '10px 1px 1px 0',
						items: [{
							xtype: 'toolbar',
							dock: 'bottom',
							border: false,
							ui: 'plaintoolbar',
							padding: '10 0 10 0',
							buttonAlign: 'center',
							items: ['->', {
								xtype: 'toolbar',
								ui: 'footer',
								items: [{
										xtype: 'button',
										//ui:'newButtonMediumBlue-medium ',
										cls: 'buttonNewBig',
										itemId: 'metricsDelete',
										text:(showEventIdFlag)?'Close Alarm':'Delete Alarm',
										//width: 60,
										listeners: {
											'click': function() {
												try {
													var meGrid = Ext.getCmp('historysummary');
													var meGridStore = meGrid.getStore();


													var noOfrecords = meGridStore.getCount();
													var selectionModelObj = meGrid.getView().getSelectionModel();
													var all_desc="";
													if (true) {
														var alarmId = "";
														var ackdelAlarmDb = "Delete Alarm";
														var priority = "";
														var isVM = "";
														var result = "";
														var toConsider = "";

														var selected = selectionModelObj.getSelection();
														if (selected.length == 0) {
															Ext.MessageBox.show({
																title: 'Alert',
																msg: alarmSelectionAlert,
																buttons: Ext.MessageBox.OK,
																icon: Ext.MessageBox.WARNING
															});
															return false;
														} else if (selected.length > 0) {
															/*if (selected.length > 1) {
																Ext.MessageBox.show({
																	title: 'Alert',
																	msg: maxEventDeleteAlert,
																	buttons: Ext.MessageBox.OK,
																	icon: Ext.MessageBox.WARNING
																});
																return false;
															}*/
															//	meGrid.suspendEvents(true);
															//meGridStore.relayEvents(meGridStore, ['datachanged','store','clear','remove']);
															//meGridStore.suspendEvents(true);
															meGridStore.removeListener('datachanged', this);
															for (var i = 0; i < selected.length; i++) {
																var recOrg = selected[i];
																var alarm = recOrg.raw['COLUMN_1_ChkBoxVal'];
																isVM = alarm.substring(0, alarm.indexOf("$"));
																alarm = alarm.substring(alarm.indexOf("$") + 1);
																/*toConsider = alarm.substring(0, alarm.indexOf("~!~"));
																//result += toConsider + "#";
																do
																{
																	if (toConsider.indexOf("#")>-1)
																		toConsider=toConsider.replace('#','|hash|');
																} while(toConsider.indexOf("#")>-1);

																result += isVM + "$" + toConsider + "#";*/

																if (alarm.indexOf("~!~") > -1 && alarm.indexOf("~@~") > -1) {
																	alarmId = alarmId + "," + alarm.substring(alarm.indexOf("~!~") + 3, alarm.indexOf("~@~"));
																}
																if (alarm.indexOf("~@~") > -1) {
																	priority = priority + "," + alarm.substring(alarm.indexOf("~@~") + 3);
																}
																var dess = alarm;
																dess = dess.substring(dess.indexOf("~")+1);
																dess = dess.substring(dess.indexOf("~")+1);
																dess = dess.substring(dess.indexOf("~")+1);
																dess = dess.substring(0,dess.indexOf("~"));
																all_desc += "^^"+dess;
															}
														}
														if (alarmId.indexOf(",") > -1) {
															alarmId = alarmId.substring(alarmId.indexOf(",") + 1);
														}
														if (alarmId == "") {
															Ext.Msg.show({
																title: 'Alert',
																msg: 'Please select a alarm',
																buttons: Ext.Msg.OK,
																icon: Ext.Msg.WARNING
															});
															return;
														}
														/*if (priority.indexOf(",") > - 1)
														{
															priority = priority.substring(priority.indexOf(",")+1);
														}
														if (result.indexOf("#") > - 1)
														{
															result = result.substring(0, result.lastIndexOf("#"));
														}
														result = result + "$@$" + priority;
														try
														{
															result=window.opener.filterEncode(result);	
														}
														catch (e)
														{
															result=parent.filterEncode(result);
														}*/

														var height = Ext.getBody().getViewSize().height - 20;
														if (selected.length > 1) {
															height = Ext.getBody().getViewSize().height - 150;
														}

														//var qStrParams1 = "doAlarmAcknowledgementEvent=true&acknowledgementEvent=loadAcknowledgementUI&userID=" +userId + "&alarmID=" + alarmId + "&ackAlarmIDs=" + encodeURIComponent(result)+ "&ackdelAlarmDb="+encodeURIComponent(ackdelAlarmDb)+"&ackorDelTitle=Delete Alarm&isVM="+encodeURI(isVM);
														var qStrParams1 = "doAlarmAcknowledgementEvent=true&acknowledgementEvent=loadAcknowledgementUI&userID=" + userId + "&alarmID=" + alarmId + "&ackdelAlarmDb=" + encodeURIComponent(ackdelAlarmDb) + "&ackorDelTitle=Delete Alarm&isVM=" + encodeURI(isVM)+ "&deleteSelectedInfos="+encodeURIComponent(parent.filterEncode(all_desc));
														Ext.widget('window', {
															title: (showEventIdFlag)?'Close Alarm':'Delete Alarm',
															height: height,
															width: 500,
															modal: true,
															qStrParams1:qStrParams1,
															//scroll:true,
															//autoScroll:true,
															padding: '0 10 10 10',
															shadow: 'sides',
															cls: 'lightbox',
															layout: 'fit',
															bodyCls: 'alarmsbg',
															id: 'ackWindowObj',
															name: 'ackWindowObj',
															closeAction: 'destroy',
															selectedAlarm:all_desc,
															items: [{
																xtype: 'acknowledgementpanel',
																//layout:'fit',
																scroll: true,
																autoScroll: true,
																qStrParams: qStrParams1,
																len: selected.length
															}],
															listeners: {
																show: function(win) {
																	if (this.modal) {
																		var dom = Ext.dom.Query.select('.x-mask');
																		var el = Ext.get(dom[0]);
																		el.addCls('windowModal');
																	}
																},
																hide: function(win) {
																	if (this.modal) {
																		var dom = Ext.dom.Query.select('.x-mask');
																		var el = Ext.get(dom[0]);
																		el.removeCls('windowModal');
																	}
																}
															}
															//	closeAction: 'destory'
														}).show();
														//	window.open("EgAcknowledge.jsp?userID=" +userId + "&alarmID=" + alarmId + "&ackAlarmIDs=" + encodeURIComponent(result)+ "&ackdelAlarmDb="+encodeURIComponent(ackdelAlarmDb)+"&ackorDelTitle=Delete Alarm&isVM="+encodeURI(isVM), "DELETEALARM", ",toolbar=no,menubar=no,location=no,status=no,width=580,height=320,left=250,top=250,right=250,bottom=250,screenx=0,screeny=0,resizable=no,scrollbars=yes");
													} else {
														Ext.MessageBox.show({
															title: 'Alert',
															msg: alarmSelectionAlert,
															buttons: Ext.MessageBox.OK,
															icon: Ext.MessageBox.WARNING
														});
														return false;
													}
												} catch (ex) {
													//console.log(ex);
												}
											}
										}
									},
									{
										xtype: 'button',
										//ui:'newButtonMediumBlue-medium ',
										itemId: 'metricsAcknowledge',
										cls: 'buttonNewBig',
										text: 'Acknowledge',
										width: 85,
										listeners: {
											'click': function() {
												var meGrid = Ext.getCmp('historysummary');
												var meGridStore = meGrid.getStore();
												//var noOfrecords = meGridStore.getCount();
												var selectionModelObj = meGrid.getView().getSelectionModel();
												if (false) {
													Ext.MessageBox.show({
														title: 'Alert',
														msg: alarmSelectionAlert,
														buttons: Ext.MessageBox.OK,
														icon: Ext.MessageBox.WARNING
													});
													return false;
												} else {
													var alarm = "";
													var alarmId = "";
													var result = "";
													var toConsider = "";
													var ackAlarmDb = "Acknowledge";
													var priority = "";
													var isVM = "";
													var all_desc= "";

													var selected = selectionModelObj.getSelection();
													if (selected.length == 0) {
														Ext.MessageBox.show({
															title: 'Alert',
															msg: alarmSelectionAlert,
															buttons: Ext.MessageBox.OK,
															icon: Ext.MessageBox.WARNING
														});
														return false;
													}
													/*else if (selected.length > 5)
													{
														Ext.MessageBox.show({
															title: 'Alert',
															msg: maxAlarmSelectionAlert,
															buttons: Ext.MessageBox.OK,
															icon: Ext.MessageBox.WARNING
														});
														return false;
													}*/
													else if (selected.length > 0) {
														/*if (selected.length > 1) {
															Ext.MessageBox.show({
																title: 'Alert',
																msg: maxEventAcknowledgeAlert,
																buttons: Ext.MessageBox.OK,
																icon: Ext.MessageBox.WARNING
															});
															return false;
														}*/
														for (var i = 0; i < selected.length; i++) {
															var recOrg = selected[i];
															var alarm = recOrg.raw['COLUMN_1_ChkBoxVal'];
															//isVM = alarm.substring(0,alarm.indexOf("$"));
															alarm = alarm.substring(alarm.indexOf("$") + 1);
															//toConsider = alarm.substring(0, alarm.indexOf("~!~"));
															//result += toConsider + "#";

															/*do
															{
																if (toConsider.indexOf("#")>-1)
																	toConsider=toConsider.replace('#','|hash|');
															} while(toConsider.indexOf("#")>-1);*/



															if (alarm.indexOf("~!~") > -1 && alarm.indexOf("~@~") > -1) {
																alarmId += "^^" + alarm.substring(alarm.indexOf("~!~") + 3, alarm.indexOf("~@~"));
															}
															/*if (alarm.indexOf("~@~") > - 1)
															{
																priority = alarm.substring(alarm.indexOf("~@~")+3);
															}
															result += "^^"+ isVM + "$" + toConsider + "$@$" + priority;*/
															var dess = alarm;
															dess = dess.substring(dess.indexOf("~")+1);
															dess = dess.substring(dess.indexOf("~")+1);
															dess = dess.substring(dess.indexOf("~")+1);
															dess = dess.substring(0,dess.indexOf("~"));
															console.log('dess---',dess)
															all_desc += "^^"+dess;
														}
													}
													if (alarmId.indexOf("^^") == 0) {
														alarmId = alarmId.substring(2);
													}
													if (all_desc.indexOf("^^") == 0) {
														all_desc = all_desc.substring(2);
													}
													/*if (result.indexOf("^^") == 0)
													{
														result = result.substring(2);
													}
													if (result.indexOf("#") > - 1)
													{
														result = result.substring(0, result.lastIndexOf("#"));
													}
													result = result + "$@$" + priority;
													try
													{
														result=window.opener.filterEncode(result);	
													}
													catch (e)
													{
														result=parent.filterEncode(result);
													}*/
													var height = Ext.getBody().getViewSize().height - 20;
													if (selected.length > 1) {
														height = Ext.getBody().getViewSize().height - 150;
													}
													var qStrParams1 ="doAlarmAcknowledgementEvent=true&acknowledgementEvent=loadAcknowledgementUI&userID=" + userId + "&alarmID=" + alarmId + "&ackAlarmIDs=" + encodeURIComponent(result) + "&ackAlarmDB="+encodeURI(ackAlarmDb)+"&ackorDelTitle=Acknowledge&isForAck=true";

													/*var dess = alarm;
													dess = dess.substring(dess.indexOf("~")+1);
													dess = dess.substring(dess.indexOf("~")+1);
													dess = dess.substring(dess.indexOf("~")+1);
													dess = dess.substring(0,dess.indexOf("~"));*/
													qStrParams1 += "&deleteSelectedInfos="+encodeURIComponent(parent.filterEncode(all_desc));
													var ackdelAlarmDb = "Acknowledge Alarm";
													//var qStrParams1 = "doAlarmAcknowledgementEvent=true&acknowledgementEvent=loadAcknowledgementUI&userID=" + userId + "&alarmID=" + alarmId + "&ackdelAlarmDb=" + encodeURIComponent(ackdelAlarmDb) + "&ackorDelTitle=Acknowledge&isVM=" + encodeURI(isVM)+ "&deleteSelectedInfos="+alarm;
													Ext.widget('window', {
														title: 'Acknowledge Alarm',
														height: height,
														width: 550,
														shadow: 'sides',
														cls: 'lightbox',
														padding: '0 10 10 10',
														modal: true,
														autoScroll: true,
														layout: 'fit',
														bodyCls: 'alarmsbg',
														id: 'ackWindowObj',
														qStrParams1:qStrParams1,
														name: 'ackWindowObj',
														selectedAlarm:all_desc,
														closeAction: 'destroy',
														items: [{
															xtype: 'acknowledgementpanel',
															scroll: true,
															autoScroll: true,
															//layout:'fit',
															qStrParams: qStrParams1,
															len: selected.length

														}],
														listeners: {
															show: function(win) {
																if (this.modal) {
																	var dom = Ext.dom.Query.select('.x-mask');
																	var el = Ext.get(dom[0]);
																	el.addCls('windowModal');
																}
															},
															hide: function(win) {
																if (this.modal) {
																	var dom = Ext.dom.Query.select('.x-mask');
																	var el = Ext.get(dom[0]);
																	el.removeCls('windowModal');
																}
															}
														}
														//closeAction: 'destory'
													}).show();
												}
											}
										}
									}
								]
							}, '->']
						}]
					}]
                }]);

                card.doComponentLayout();
                card.resumeLayouts(true);
				Ext.getBody().unmask();
                try {
                    if (showCurrent)
                        Ext.getCmp('current').setValue(true);
                    else
                        Ext.getCmp('history').setValue(true);
                } catch (e) {}
            }
        });
    },
    openUnknownConfig: function() {
        //Ext.get('configMod').animate({to: {y: 41},listeners:{ afteranimate:function(){  //Ext.get('configMod').setStyle('left', '');}}}).show();
        if (Ext.getCmp('configModUnknown').items.items.length == 3) {
            Ext.getCmp('configModUnknown').items.items[0].destroy();
        }
        var VWidth = Ext.Element.getViewportWidth();

        var container = Ext.getCmp('configModUnknown');

        var containerPosition = VWidth - (container.width + 15);

        Ext.create('Ext.fx.Anim', {
            target: container,
            duration: 500,
            from: {
                left: containerPosition,
                top: -500
            },
            to: {
                top: 40,
                left: containerPosition
            }
        });

        container.showAt(containerPosition, 5000);

        Ext.select('.iconClose3').on('click', function() {
            Ext.create('Ext.fx.Anim', {
                target: container,
                duration: 500,
                from: {
                    left: containerPosition,
                    top: 40
                },
                to: {
                    top: -500,
                    left: containerPosition
                },
                callback: function() {
                    container.hide();
                    //componentsList.app.getController("Main").metricRefresh();
                }
            });
        }, this);
    },
    getUnknownFilter: function(dummyJson) {
        dummyJson.sortBy.splice(0, 1, {
            displayField: "Component Type",
            valueField: "comp_type"
        }, {
            displayField: "Start Time",
            valueField: "st_time"
        });

        return [{
            xtype: 'panel',
            maxHeight: 50,
            layout: {
                type: 'column',
                align: 'stretch'
            },
            defaults: {
                labelAlign: 'top',
                style: {
                    'margin': '0px 0px 5px 10px'
                }
            },
            items: [{
                columnWidth: '.3',
                labelWidth: 70,
                xtype: 'combo',
                editable: false,
                cls: 'dropdown',
                hideEmptyLabel: false,
                fieldLabel: dummyJson.screenLabels['monitor.history.Duration is '],
                name: 'glduration',
                displayField: 'displayField',
                valueField: 'valueField',
                queryMode: 'local',
                value: (!Ext.isEmpty(dummyJson.glduration_value)) ? dummyJson.glduration_value : dummyJson.glduration[0].valueField,
                store: new Ext.data.Store({
                    fields: ['displayField', 'valueField'],
                    data: dummyJson.glduration
                })
            }, {
                columnWidth: '.12',
                xtype: 'textfield',
                value: dummyJson.duration,
                hideEmptyLabel: false,
                fieldLabel: "",
                margin: '17 5 0 5',
                cls: 'textbox',
                name: 'duration',
                enforceMaxLength: true,
                maxLength: '4'
            }, {
                columnWidth: '.2',
                xtype: 'combo',
                editable: false,
                cls: 'dropdown',
                margin: '17 5 0 5',
                hideEmptyLabel: false,
                value: (!Ext.isEmpty(dummyJson.timeselect_value)) ? dummyJson.timeselect_value : dummyJson.timeselect[0].valueField,
                fieldLabel: "",
                name: 'timeselect',
                displayField: 'displayField',
                valueField: 'valueField',
                queryMode: 'local',
                store: new Ext.data.Store({
                    fields: ['displayField', 'valueField'],
                    data: dummyJson.timeselect
                })
            }]
        }, {
            xtype: 'container',
            layout: 'hbox',
            height: 1,
            margin: '3 0 5 0',
            cls: 'monitorsettingsborder'
        }, {
            xtype: 'radiogroup',
            columns: 2,
            vertical: true,
            hidden: false,
            width: 170,
            maxWidth: 170,
            style: {
                'white-space': 'nowrap',
                'margin-bottom': '5px'
            },
            id: 'radiogroup',
            name: 'radiogroup',
            labelSeparator: '',
            fieldLabel: '',
            listeners: {
                afterrender: function(e) {
                    try {
                        if (showCurrentUnk)
                            Ext.getCmp('current1').setValue(true);
                        else
                            Ext.getCmp('history1').setValue(true);
                    } catch (e) {}
                }
            },
            items: [{
                boxLabel: 'Current',
                cls: 'radiobt fontnormal_css',
                name: 'type',
                id: 'current1',
                checked: true
            }, {
                boxLabel: 'History',
                cls: 'radiobt fontnormal_css',
                name: 'type',
                id: 'history1'
            }]

        }, {
            xtype: 'panel',
            maxHeight: 100,
            layout: {
                type: 'column',
                align: 'stretch'
            },
            defaults: {
                labelAlign: 'top',
                style: {
                    'margin': '0px 0px 5px 10px'
                }
            },
            items: [{
                columnWidth: '.2',
                xtype: 'combo',
                labelWidth: 80,
                editable: false,
                cls: 'dropdown',
                fieldLabel: 'Timeline',
                name: 'eg_timeline',
                id: 'eg_timeline',
                displayField: 'displayField',
                valueField: 'valueField',
                queryMode: 'local',
                defaultListConfig: {
                    loadingHeight: 70,
                    minWidth: 50,
                    maxHeight: 200,
                    shadow: 'sides'
                },
                value: dummyJson.eg_timeline_value,
                store: new Ext.data.Store({
                    fields: ['displayField', 'valueField'],
                    data: dummyJson.eg_timeline
                })
            }, {
                columnWidth: '.25',
                xtype: 'datefield',
                fieldLabel: 'From',
                name: 'eg_stdate',
                id: 'eg_stdate',
                labelWidth: 30,
                editable: false,
                //format:'M d, Y',
                format: mgrDateFormat,
                cls: 'datepicker',
                value: dummyJson.eg_stdate,
                dataArray: dummyJson.real_eg_stdate
            }, {
                columnWidth: '.13',
                xtype: 'combo',
                fieldLabel: 'Hr',
                editable: false,
                cls: 'dropdown',
                name: 'starthr',
                id: 'starthr',
                labelWidth: 20,
                displayField: 'displayField',
                valueField: 'valueField',
                queryMode: 'local',
                width: 50,
                value: dummyJson.real_starthr_value,
                dataArray: dummyJson.real_starthr_value,
                listeners: {
                    'expand': function() {
                        //  fleXenv.initByClass("x-boundlist-list-ct"); //loades fancy scroll 
                    }
                },
                defaultListConfig: {
                    loadingHeight: 70,
                    minWidth: 50,
                    maxHeight: 200,
                    shadow: 'sides'
                },
                store: new Ext.data.Store({
                    fields: ['displayField', 'valueField'],
                    data: dummyJson.real_starthr_value
                })
            }, {
                columnWidth: '.13',
                xtype: 'combo',
                fieldLabel: 'Min',
                editable: false,
                cls: 'dropdown',
                name: 'startmin',
                id: 'startmin',
                labelWidth: 20,
                displayField: 'displayField',
                valueField: 'valueField',
                queryMode: 'local',
                width: 50,
                value: dummyJson.startmin_value,
                dataArray: dummyJson.real_startmin_value,
                listeners: {
                    'expand': function() {
                        //  fleXenv.initByClass("x-boundlist-list-ct"); //loades fancy scroll 
                    }
                },
                defaultListConfig: {
                    loadingHeight: 70,
                    minWidth: 50,
                    maxHeight: 200,
                    shadow: 'sides'
                },
                store: new Ext.data.Store({
                    fields: ['displayField', 'valueField'],
                    data: dummyJson.real_startmin_value
                })
            }, {
                columnWidth: '.25',
                xtype: 'datefield',
                fieldLabel: 'To',
                name: 'eg_enddate',
                id: 'eg_enddate',
                labelWidth: 30,
                editable: false,
                //format:'M d, Y',
                format: mgrDateFormat,
                cls: 'datepicker',
                value: dummyJson.eg_enddate,
                dataArray: dummyJson.real_eg_enddate
            }, {
                columnWidth: '.13',
                xtype: 'combo',
                fieldLabel: 'Hr',
                editable: false,
                cls: 'dropdown',
                name: 'endhr',
                id: 'endhr',
                labelWidth: 20,
                width: 50,
                value: dummyJson.endhr_value,
                dataArray: dummyJson.real_endhr_value,
                defaultListConfig: {
                    loadingHeight: 70,
                    minWidth: 50,
                    maxHeight: 200,
                    shadow: 'sides'
                },
                listeners: {
                    'expand': function() {
                        //  fleXenv.initByClass("x-boundlist-list-ct"); //loades fancy scroll 
                    }
                },
                displayField: 'displayField',
                valueField: 'valueField',
                queryMode: 'local',
                store: new Ext.data.Store({
                    fields: ['displayField', 'valueField'],
                    data: dummyJson.real_endhr_value
                })
            }, {
                columnWidth: '.13',
                xtype: 'combo',
                fieldLabel: 'Min',
                editable: false,
                cls: 'dropdown',
                name: 'endmin',
                id: 'endmin',
                labelWidth: 20,
                displayField: 'displayField',
                valueField: 'valueField',
                queryMode: 'local',
                width: 50,
                value: dummyJson.endmin_value,
                dataArray: dummyJson.real_endmin_value,
                listeners: {
                    'expand': function() {
                        //  fleXenv.initByClass("x-boundlist-list-ct"); //loades fancy scroll 
                    }
                },
                defaultListConfig: {
                    loadingHeight: 70,
                    minWidth: 50,
                    maxHeight: 200,
                    shadow: 'sides'
                },
                store: new Ext.data.Store({
                    fields: ['displayField', 'valueField'],
                    data: dummyJson.real_endmin_value
                })
            }]
        }, {
            xtype: 'container',
            layout: 'hbox',
            height: 1,
            margin: '3 0 10 0',
            cls: 'monitorsettingsborder'
        }, {
            xtype: 'panel',
            maxHeight: 100,
            layout: {
                type: 'column',
                align: 'stretch'
            },
            defaults: {
                labelAlign: 'top',
                style: {
                    'margin': '0px 0px 5px 10px'
                }
            },
            items: [{
                    xtype: 'combo',
                    fieldLabel: 'Sort By',
                    //columnWidth : '.33',
                    width: 130, // Prem
                    //labelWidth : 150,
                    editable: false,
                    cls: 'dropdown',
                    name: 'sortBy',
                    displayField: 'displayField',
                    valueField: 'valueField',
                    queryMode: 'local',
                    value: "st_time",
                    store: new Ext.data.Store({
                        fields: ['displayField', 'valueField'],
                        data: dummyJson.sortBy
                    })
                },
                {
                    xtype: 'scrollcombo',
                    editable: false,
                    cls: 'dropdown',
                    //width : 100,
                    labelWidth: 100,
                    //hidden:true,
                    //columnWidth : '.22',
                    fieldLabel: 'Events per page',
                    width: 100,
                    defaultListConfig: {
                        loadingHeight: 70,
                        minWidth: 50,
                        maxHeight: 300,
                        shadow: 'sides'
                    },
                    name: 'eventsPerPage',
                    displayField: 'displayField',
                    valueField: 'valueField',
                    queryMode: 'local',
                    value: dummyJson.eventsPerPage_value,
                    store: new Ext.data.Store({
                        fields: ['displayField', 'valueField'],
                        data: dummyJson.eventsPerPage
                    })
                }
            ]
        }, {
            xtype: 'container',
            layout: 'hbox',
            height: 1,
            margin: '3 0 10 0',
            cls: 'monitorsettingsborder',
            hidden: true,
        }, {
            xtype: 'panel',
            maxHeight: 100,
            layout: {
                type: 'column',
                align: 'stretch'
            },
            hidden: true,
            defaults: {
                labelAlign: 'top',
                style: {
                    'margin': '0px 0px 5px 10px'
                }
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: compSearch,
                enableKeyEvents: true,
                //margin : '5 5 5 10',
                name: 'compsearch',
                cls: 'textbox historyappsearch',
                width: '200'
            }, {
                xtype: 'textfield',
                fieldLabel: descriptionSearch,
                enableKeyEvents: true,
                name: 'infosearch',
                //margin : '5 5 5 10',
                cls: 'textbox historyappsearch',
                width: '200'
            }]
        }, {
            xtype: 'button',
            text: update,
            id: 'UpdateSettings1',
            action: 'UpdateSettings1',
            cls: 'button20',
            maxWidth: 100,
            margin: '10px 10px 10px 210px'
        }];
    },
    goToUnknownPage: function() {
        var me = this,
            card = Ext.getCmp('home_ground');

        if (!Ext.isEmpty(Ext.getCmp('settingIconIdMetrics')))
            Ext.getCmp('settingIconIdMetrics').hide();

        this.closeConfig();

        Ext.getCmp('settingIconId').show();
        Ext.getCmp('settingIconId').on('click', function() {
            me.openUnknownConfig();
        });
        window.clearInterval(timerId);
        timerId=window.setInterval("executee()",refreshFrequency);

        //for (var i = 0; i < Ext.getCmp('home_ground').items.length; i++) {
        //	Ext.destroy(card.items.items[0].items.items[i]);
        //}

        //if(card.hasOwnProperty("tools")){
        //	for (var t = 0; t < card.tools.length; t++) {
        //		Ext.destroy(card.tools[t]);
        //	}
        //}

        card.removeAll(true);
        card.suspendLayouts();
        Ext.getBody().mask("Loading...");
        var defaultParams = "currentMainPage=NotAlarms&newWindowAlarm=true&alarmType=CurrentUnknown";
        var browser = get_browser_info();

        var queryString = "";
        if (qSfromDashboard != "null") {
            queryString = 'EgAlarmHistoryFrame.jsp?loadStaticData=yes&' + qSfromDashboard;
        } else {
            queryString = 'EgAlarmHistoryFrame.jsp?newAlarms=true&eg_tbound=Fixed&loadStaticData=yes';
        }

        if (compstate == 'null')
            compstate = 'All';
        if (analysisBy != 'null' && analysis != 'null') {
            if (analysisBy == 'Service')
                queryString += "&eventfor=" + encodeURIComponent(analysisBy) + "&event_select=" + encodeURIComponent(subevent) + "&compTypeList=" + encodeURIComponent(analysis) + "&state=" + encodeURIComponent(compstate) + "&compNameList=" + encodeURIComponent(hostName);
            else if (analysisBy == 'Segment')
                queryString += "&eventfor=" + encodeURIComponent(analysisBy) + "&event_select=" + encodeURIComponent(subevent) + "&compTypeList=" + encodeURIComponent(analysis) + "&state=" + encodeURIComponent(compstate) + "&compNameList=" + encodeURIComponent(hostName);
            else if (analysisBy == 'Zone')
                queryString += "&eventfor=" + encodeURIComponent(analysisBy) + "&event_select=" + encodeURIComponent(subevent) + "&compTypeList=" + encodeURIComponent(analysis) + "&state=" + encodeURIComponent(compstate) + "&compNameList=" + encodeURIComponent(hostName) + "&selectedsubzone=" + encodeURIComponent(selectedsubzone);
            else if (analysisBy == 'Component')
                queryString += "&eventfor=" + encodeURIComponent(analysisBy) + "&compTypeList=" + encodeURIComponent(analysis) + "&state=" + encodeURIComponent(compstate) + "&compNameList=" + encodeURIComponent(hostName);
            else
                queryString += "&compTypeList=" + encodeURIComponent(analysis) + "&state=" + encodeURIComponent(compstate) + "&compNameList=" + encodeURIComponent(hostName);
        }
        Ext.Ajax.request({
            url: queryString,
			timeout:300000,
            async: true,
            success: function(response) {
                monitor.HistorySummary.filterData = Ext.decode(response.responseText);
                var dummyJson = monitor.HistorySummary.filterData;
				var showCurrentUnk=false;
				try
				{
					showCurrentUnk= Ext.getCmp('current1').checked;
				}
				catch (e)
				{
				}
                var paramsD = "&eg_timeline=" + dummyJson.eg_timeline_value + "&eg_stdate=" + dummyJson.eg_stdate + "&eg_enddate=" + dummyJson.eg_enddate + "&starthr=" + dummyJson.real_starthr_value + "&startmin=" + dummyJson.startmin_value + "&endmin=" + dummyJson.endmin_value + "&endhr=" + dummyJson.endhr_value + "&arrangeUnknown=st_time&isForCurrent="+showCurrentUnk;
                Ext.Ajax.request({
                    url: '/final/servlet/com.eg.EgCurrentAlarmsC',
                    method: 'POST',
                    params: defaultParams + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height) + '&isBro=' + browser.name + "&maxDurationAlarmIds=" + maxDurationAlarmIds + "&isFromQuickLink=" + isFromQuickLink + "&getdiffTest=UNKNOWN_HISTORY" + paramsD + '&isFromICMPage=true',
                    scope: this,
                    success: function(response) {
                        var jsonData = JSON.parse(response.responseText);
                        publicJson = jsonData;
                        publicJson['DefaultPageSize'] = 15;
                        publicJson.showOptionsJson = [{
                            displayField: 'Unknowns',
                            valueField: 'CurrentUnknown'
                        }];

                        if (publicJson['pageParams']['alarmType'] == 'longestAlarms')
                            longestAlarms = publicJson['pageParams']['selectedShowOption'];

                        var fullData = JSON.parse(JSON.stringify(publicJson));
                        try {
							publicJson.gridJson.fullData = JSON.parse(JSON.stringify(publicJson.gridJson.gridData));
                            if (showCurrentUnk) {
                                if (publicJson.hasOwnProperty("gridJson") && publicJson.gridJson.hasOwnProperty("gridData")) {
                                    publicJson.gridJson.gridData = publicJson.gridJson.gridData.filter(function(columnData){ return columnData["COLUMN_8"] === "Current"});
                                }
                            }/* else {
                                if (publicJson.hasOwnProperty("gridJson") && publicJson.gridJson.hasOwnProperty("gridData")) {
                                    publicJson.gridJson.gridData = publicJson.gridJson.gridData.filter(function(columnData){return columnData["COLUMN_8"] !== "Current"});
                                }
                            }*/
                        } catch (e) {}
                        card.add({
                            xtype: 'panel',
                            //ui:'eg-x-panel',
                            bodyPadding: 0,
                            margin: 0,
                            flex: 1,
                            layout: {
                                type: 'vbox',
                                align: 'stretch'
                            },
                            items: [{
                                xtype: 'panel',
                                ui: 'eg-x-panel',
                                height: 57,
								padding:0,
								margin:0,
                                margin: '0 1px 8px 0',
                                items: [{
                                    xtype: "alarmfilters",
									margin:0,
									padding:8,
                                    cls: ""
                                }]
                            }, {
                                xtype: 'panel',
                                ui: 'eg-x-panel',
                                flex: 1,
                                bodyPadding: '0px 10px 10px 10px',
                                margin: '0 1px 1px 0',
                                layout: {
                                    type: 'vbox',
                                    align: 'stretch'
                                },
                                header: {
                                    style: {
                                        padding: '10px 20px 0px 5px',
                                        margin: 0
                                    }
                                },
                                tools: [{
                                    xtype: 'label',
                                    itemId: "unknownLabel",
                                    //margin : '8 5 5 10',
                                    style: {
                                        "display": "flex",
                                        "align-items": "center"
                                    },
                                    html: (showCurrentUnk) ? "<span class='iconFullTime' style='margin-right: 5px;display: inline-block;'></span>Showing Current Unknowns" : "<span class='iconFullTime' style='margin-right: 5px;display: inline-block;'></span>Showing Last " + dummyJson.eg_timeline_value
                                }],
                                listeners: {
                                    afterrender: function(e) {
                                        var leftPos = "";
                                        if (backHidden != true) {
                                            leftPos = "355px";
                                        } else {
                                            leftPos = "430px";
                                        }

                                        var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px;" class="settingsfont""><b>' + settings + '</b></div><div style="text-align:right;float:right;"><div class="iconClose3" id="close"></div></div>');

                                        var VWidth = Ext.Element.getViewportWidth();

                                        function targetPosition(totalwidth, targetID, popupwidth) {
                                            var left = totalwidth - Ext.getCmp(targetID).getPosition()[0],
                                                targetWidth = Ext.getCmp(targetID).getWidth() / 2 + 1,
                                                targetPosition = (popupwidth + targetWidth) - left;
                                            return targetPosition;
                                        }

                                        var left = targetPosition(VWidth, 'settingIconId', 490);

                                        me.moreFiltersWindow = new Ext.Container({
                                            width: 520,
                                            padding: 5,
                                            id: 'configModUnknown',
                                            ui: 'configOuterContainer',
                                            //html:tpl.apply(),
                                            listeners: {
                                                'boxready': function(e) {
                                                    if (dummyJson.eg_timeline_value == "Any") {
                                                        Ext.getCmp('starthr').setDisabled(false);
                                                        Ext.getCmp('endhr').setDisabled(false);
                                                        Ext.getCmp('eg_stdate').setDisabled(false);
                                                        Ext.getCmp('eg_enddate').setDisabled(false);
                                                        Ext.getCmp('startmin').setDisabled(false);
                                                        Ext.getCmp('endmin').setDisabled(false);
                                                    } else {
                                                        Ext.getCmp('starthr').setDisabled(true);
                                                        Ext.getCmp('endhr').setDisabled(true);
                                                        Ext.getCmp('eg_stdate').setDisabled(true);
                                                        Ext.getCmp('eg_enddate').setDisabled(true);
                                                        Ext.getCmp('startmin').setDisabled(true);
                                                        Ext.getCmp('endmin').setDisabled(true);
                                                    }
                                                }
                                            },
                                            items: [{
                                                xtype: 'container',
                                                html: tpl.apply(),
                                                id: 'configMode_header1',
                                                cls: 'configMode_header',
                                                padding: '10 0 5 0',
                                                style: {
                                                    'top': '0px',
                                                    'margin': '0px 2px 2px 2px'
                                                }
                                            }, {
                                                xtype: 'form',
                                                layout: {
                                                    type: 'vbox',
                                                    align: 'stretch'
                                                },
                                                items: me.getUnknownFilter(dummyJson)
                                            }],
                                            renderTo: Ext.getBody(),
                                            floatable: true,
                                            floating: true,
                                            hidden: true
                                        });

                                        var container = me.moreFiltersWindow;
                                        //This is to avoid empty window to be visible on the screen while loading.
                                        //me.moreFiltersWindow.setPosition(-500, -500);

                                        var containerPosition = VWidth - (container.width + 15);

                                        Ext.create('Ext.fx.Anim', {
                                            target: container,
                                            duration: 500,
                                            from: {

                                                left: containerPosition,
                                                top: -500
                                            },
                                            to: {
                                                top: 40,
                                                left: containerPosition
                                            }
                                        });

                                        container.showAt(containerPosition, 5000);

                                        Ext.select('.iconClose3').on('click', function() {
                                            Ext.create('Ext.fx.Anim', {
                                                target: container,
                                                duration: 500,
                                                from: {
                                                    left: containerPosition,
                                                    top: 40
                                                },
                                                to: {
                                                    top: -500,
                                                    left: containerPosition
                                                },
                                                callback: function() {
                                                    container.hide();
                                                    //componentsList.app.getController("Main").metricRefresh();
                                                }
                                            });
                                        }, this);

                                        if (container.isHidden()) {
                                            //var win=this.getConfigWindow();

                                            //var VWidth = Ext.getBody().getViewSize().width;

                                            //var containerPosition = VWidth - (container.width + 15);
                                            Ext.create('Ext.fx.Anim', {
                                                target: container,
                                                duration: 500,
                                                from: {

                                                    left: containerPosition,
                                                    top: -500
                                                },
                                                to: {
                                                    top: 40,
                                                    left: containerPosition
                                                }
                                            });
                                            container.showAt(containerPosition, 5000);
                                        } else {
                                            container.hide();
                                            //componentsList.app.getController("Main").metricRefresh();
                                        }
                                    }
                                },
                                items: [{
                                    xtype: 'currentalarmssummary',
                                    fullData: fullData,
                                    height: "100%",
                                    emptyText: '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconNoalarms" style="margin:0px auto"></div><div style="text-align:center;" class="noData">No unknowns found</div></div></div>'
                                }]
                            }]
                        });
                        me.getCurrentalarmssummary().loadData();
                        Ext.getBody().unmask();
                        card.doComponentLayout();
                        card.resumeLayouts(true);
                    }
                });
            }
        });
    },
    goToAlarmsPage: function() {
        if (!Ext.isEmpty(Ext.getCmp('settingIconIdMetrics')))
            Ext.getCmp('settingIconIdMetrics').hide();
		window.clearInterval(timerId);
        timerId=window.setInterval("executee()",refreshFrequency);
        this.closeConfig();

        var me = this,
            card = Ext.getCmp('home_ground');

        if (card.hasOwnProperty("tools")) {
            for (var t = 0; t < card.tools.length; t++) {
                Ext.destroy(card.tools[t]);
            }
        }

        card.removeAll(true);
        card.suspendLayouts();

        Ext.getCmp('settingIconId').hide();

        var header = ['COLUMN_2', 'COLUMN_3', 'COLUMN_4', 'COLUMN_5', 'COLUMN_6'];
        var storeHeader = Ext.create('Ext.data.Store', {
            fields: header,
            data: []
        });


        var browser = get_browser_info();
        //var param_qstr = 'showAlarms=HIGH%7Camp%7CINTERMEDIATE%7Camp%7CLOW&alarmType=CurrentAlarms&selectedFilterOption=zones&selectedSubFilterOption='+queryReqParams.zoneName+'&fromPage=SAASHome&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+'&isFromQuickLink=false';
        param_qstr = 'showAlarms=HIGH%7Camp%7CINTERMEDIATE%7Camp%7CLOW&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height) + '&isBro=' + browser.name + '&isFromQuickLink=false&showEventIdFlag='+showEventIdFlag + '&isFromICMPage=true';
		
		if(isCorrelatedAlarmsAsDefault){
			param_qstr += "&alarmType=CorrelatedAlarms&fromPage=SAASHome&loadAlertDetails=true";
			
		}else{
			param_qstr += "&alarmType=CurrentAlarms";
		}

        //var param_qstr='showAlarms=HIGH%7Camp%7CINTERMEDIATE%7Camp%7CLOW&alarmType=CurrentAlarms&selectedFilterOption=zones&selectedSubFilterOption=bala%40egindia.com&fromPage=SAASHome&screenWidth=1366&screenHeight=580&isBro=Chrome&isFromQuickLink=false&loadAlertDetails=true';

        card.add([{
            xtype: 'panel',
            //ui:'eg-x-panel',
            bodyPadding: 0,
            margin: 0,
            flex: 1,
            layout: {
                type: 'vbox',
                align: 'stretch'
            },
            items: [],
            listeners: {
                afterrender: function(e) {
                    var alarmLoadMask = new Ext.LoadMask(Ext.getBody(), {
                        msg: "Loading ..."
                    });
                    alarmLoadMask.show();

                    try {
                        Ext.Ajax.request({
                            url: '/final/servlet/com.eg.EgCurrentAlarmsC',
                            method: 'POST',
							timeout:300000,
                            params: param_qstr,
                            scope: this,
                            success: function(response) {
                                var jsonText = response.responseText;
                                var jsonData = JSON.parse(jsonText);
                                jsonData = processDataforGrid(jsonData);
                                jsonData.showOptionsJson = jsonData.showOptionsJson.slice(0, jsonData.showOptionsJson.length - 1);
                                publicJson = jsonData;
                                e.add({
                                    xtype: 'panel',
                                    ui: 'eg-x-panel',
                                    //height: 65,
                                    margin: '0 1px 8px 0',
                                    items: [{
                                        xtype: 'alarmsfilter',
                                        id: 'alarmsfilter',
                                        //ui:'borderContainer',
                                        //width:1200,
                                        //height: 65,
                                        padding:'8 8 8 8',
                                        //hidden:true,
                                        //margin: 10,
                                        jsonData: jsonData
                                    }]
                                }, {
                                    xtype: 'panel',
                                    ui: 'eg-x-panel',
                                    flex: 1,
                                    bodyPadding: 10,
                                    margin: '0 1px 1px 0',
                                    layout: {
                                        type: 'vbox',
                                        align: 'stretch'
                                    },
                                    items: [{
                                        xtype: 'alarmsgroupedview',
                                        selModel: new Ext.selection.CheckboxModel({
											checkOnly: true,
											mode: 'MULTI',
											headerWidth: 35,
											showHeaderCheckbox: false
										}),
                                        selType: 'checkboxmodel',
                                        //width:1200,
                                        id: 'alarmsgroupedview',
										emptyText:'<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div class="noData">No alarms found</div></div></div>',
                                        param_qstr: param_qstr,
                                        jsonData: jsonData,
                                        flex: 1,
                                    }]
                                }, {
                                    xtype: 'panel',
                                    ui: 'eg-x-panel',
                                    id: 'AlarmTabAckDelToolbar',
                                    hidden: true,
                                    height: 55,
                                    margin: '8px 1px 1px 0',
									layout:'fit',
                                    items: [{
                                        xtype: 'toolbar',
                                        hidden: false,
                                        dock: 'bottom',
                                        border: false,
                                        ui: 'plaintoolbar',
                                        padding: '10 0 10 0',
                                        buttonAlign: 'center',
                                        items: ['->', {
                                            xtype: 'toolbar',
                                            ui: 'footer',
                                            items: [{
                                                    xtype: 'button',
                                                    //ui:'newButtonMediumBlue-medium ',
                                                    cls: 'buttonNewBig',
													id:'alarmTabDelteBtn',
                                                    text:(showEventIdFlag)?'Close Alarm':'Delete Alarm',
                                                    listeners: {
                                                        'click': function() {
                                                            try {
                                                                var meGrid = Ext.getCmp('alarmsgroupedview');
                                                                var meGridStore = meGrid.getStore();

                                                                console.log('meGridStore-->', meGridStore)

                                                                var noOfrecords = meGridStore.getCount();
                                                                var selectionModelObj = meGrid.getView().getSelectionModel();

                                                                if (true) {
                                                                    var alarmId = "";
                                                                    var ackdelAlarmDb = "Delete Alarm";
                                                                    var priority = "";
                                                                    var isVM = "";
                                                                    var result = "";
                                                                    var toConsider = "";

                                                                    var selected = selectionModelObj.getSelection();
                                                                    if (selected.length == 0) {
                                                                        Ext.MessageBox.show({
                                                                            title: 'Alert',
                                                                            msg: alarmSelectionAlert,
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.WARNING
                                                                        });
                                                                        return false;
                                                                    } else if (selected.length > 0) {
                                                                        /*if (selected.length > 1) {
                                                                            Ext.MessageBox.show({
                                                                                title: 'Alert',
                                                                                msg: maxEventDeleteAlert,
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.WARNING
                                                                            });
                                                                            return false;
                                                                        }*/
                                                                        //	meGrid.suspendEvents(true);
                                                                        //meGridStore.relayEvents(meGridStore, ['datachanged','store','clear','remove']);
                                                                        //meGridStore.suspendEvents(true);
                                                                        meGridStore.removeListener('datachanged', this);
                                                                        for (var i = 0; i < selected.length; i++) {
                                                                            var recOrg = selected[i];
                                                                            var alarm = recOrg.get('COLUMN_1_ChkBoxVal');
                                                                            isVM = alarm.substring(0, alarm.indexOf("$"));
                                                                            alarm = alarm.substring(alarm.indexOf("$") + 1);
                                                                            /*toConsider = alarm.substring(0, alarm.indexOf("~!~"));
                                                                            //result += toConsider + "#";
                                                                            do
                                                                            {
                                                                            	if (toConsider.indexOf("#")>-1)
                                                                            		toConsider=toConsider.replace('#','|hash|');
                                                                            } while(toConsider.indexOf("#")>-1);

                                                                            result += isVM + "$" + toConsider + "#";*/

                                                                            if (alarm.indexOf("~!~") > -1 && alarm.indexOf("~@~") > -1) {
                                                                                alarmId = alarmId + "," + alarm.substring(alarm.indexOf("~!~") + 3, alarm.indexOf("~@~"));
                                                                            }
                                                                            if (alarm.indexOf("~@~") > -1) {
                                                                                priority = priority + "," + alarm.substring(alarm.indexOf("~@~") + 3);
                                                                            }
                                                                        }
                                                                    }
                                                                    if (alarmId.indexOf(",") > -1) {
                                                                        alarmId = alarmId.substring(alarmId.indexOf(",") + 1);
                                                                    }
                                                                    if (alarmId == "") {
                                                                        Ext.Msg.show({
                                                                            title: 'Alert',
                                                                            msg: 'Please select a alarm',
                                                                            buttons: Ext.Msg.OK,
                                                                            icon: Ext.Msg.WARNING
                                                                        });
                                                                        return;
                                                                    }
                                                                    /*if (priority.indexOf(",") > - 1)
                                                                    {
                                                                    	priority = priority.substring(priority.indexOf(",")+1);
                                                                    }
                                                                    if (result.indexOf("#") > - 1)
                                                                    {
                                                                    	result = result.substring(0, result.lastIndexOf("#"));
                                                                    }
                                                                    result = result + "$@$" + priority;
                                                                    try
                                                                    {
                                                                    	result=window.opener.filterEncode(result);	
                                                                    }
                                                                    catch (e)
                                                                    {
                                                                    	result=parent.filterEncode(result);
                                                                    }*/

                                                                    var height = Ext.getBody().getViewSize().height - 20;
                                                                    if (selected.length > 1) {
                                                                        height = Ext.getBody().getViewSize().height - 150;
                                                                    }

                                                                    //var qStrParams1 = "doAlarmAcknowledgementEvent=true&acknowledgementEvent=loadAcknowledgementUI&userID=" +userId + "&alarmID=" + alarmId + "&ackAlarmIDs=" + encodeURIComponent(result)+ "&ackdelAlarmDb="+encodeURIComponent(ackdelAlarmDb)+"&ackorDelTitle=Delete Alarm&isVM="+encodeURI(isVM);
                                                                    var qStrParams1 = "doAlarmAcknowledgementEvent=true&acknowledgementEvent=loadAcknowledgementUI&userID=" + userId + "&alarmID=" + alarmId + "&ackdelAlarmDb=" + encodeURIComponent(ackdelAlarmDb) + "&ackorDelTitle=Delete Alarm&isVM=" + encodeURI(isVM);
                                                                    Ext.widget('window', {
                                                                        title: (showEventIdFlag)?'Close Alarm':'Delete Alarm',
                                                                        height: height,
                                                                        width: 500,
                                                                        modal: true,
                                                                        //scroll:true,
                                                                        //autoScroll:true,
                                                                        padding: '0 10 10 10',
                                                                        shadow: 'sides',
                                                                        cls: 'lightbox',
                                                                        layout: 'fit',
                                                                        bodyCls: 'alarmsbg',
                                                                        id: 'ackWindowObj',
                                                                        name: 'ackWindowObj',
                                                                        closeAction: 'destroy',
                                                                        items: [{
                                                                            xtype: 'acknowledgementpanel',
                                                                            //layout:'fit',
                                                                            scroll: true,
                                                                            autoScroll: true,
                                                                            qStrParams: qStrParams1,
                                                                            len: selected.length
                                                                        }],
                                                                        listeners: {
                                                                            show: function(win) {
                                                                                if (this.modal) {
                                                                                    var dom = Ext.dom.Query.select('.x-mask');
                                                                                    var el = Ext.get(dom[0]);
                                                                                    el.addCls('windowModal');
                                                                                }
                                                                            },
                                                                            hide: function(win) {
                                                                                if (this.modal) {
                                                                                    var dom = Ext.dom.Query.select('.x-mask');
                                                                                    var el = Ext.get(dom[0]);
                                                                                    el.removeCls('windowModal');
                                                                                }
                                                                            }
                                                                        }
                                                                        //	closeAction: 'destory'
                                                                    }).show();
                                                                    //	window.open("EgAcknowledge.jsp?userID=" +userId + "&alarmID=" + alarmId + "&ackAlarmIDs=" + encodeURIComponent(result)+ "&ackdelAlarmDb="+encodeURIComponent(ackdelAlarmDb)+"&ackorDelTitle=Delete Alarm&isVM="+encodeURI(isVM), "DELETEALARM", ",toolbar=no,menubar=no,location=no,status=no,width=580,height=320,left=250,top=250,right=250,bottom=250,screenx=0,screeny=0,resizable=no,scrollbars=yes");
                                                                } else {
                                                                    Ext.MessageBox.show({
                                                                        title: 'Alert',
                                                                        msg: alarmSelectionAlert,
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.WARNING
                                                                    });
                                                                    return false;
                                                                }
                                                            } catch (ex) {
                                                                console.log(ex);
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'button',
                                                    //ui:'newButtonMediumBlue-medium ',
                                                    cls: 'buttonNewBig',
													id:'alarmTabAckBtn',
                                                    text: 'Acknowledge',
                                                    listeners: {
                                                        'click': function() {
                                                            var meGrid = Ext.getCmp('alarmsgroupedview');
                                                            var meGridStore = meGrid.getStore();
                                                            //var noOfrecords = meGridStore.getCount();
                                                            var selectionModelObj = meGrid.getView().getSelectionModel();
                                                            if (false) {
                                                                Ext.MessageBox.show({
                                                                    title: 'Alert',
                                                                    msg: alarmSelectionAlert,
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.WARNING
                                                                });
                                                                return false;
                                                            } else {
                                                                var alarm = "";
                                                                var alarmId = "";
                                                                var result = "";
                                                                var toConsider = "";
                                                                var ackAlarmDb = "Acknowledge";
                                                                var priority = "";
                                                                var isVM = "";

                                                                var selected = selectionModelObj.getSelection();
                                                                if (selected.length == 0) {
                                                                    Ext.MessageBox.show({
                                                                        title: 'Alert',
                                                                        msg: alarmSelectionAlert,
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.WARNING
                                                                    });
                                                                    return false;
                                                                }
                                                                /*else if (selected.length > 5)
                                                                {
                                                                	Ext.MessageBox.show({
                                                                		title: 'Alert',
                                                                		msg: maxAlarmSelectionAlert,
                                                                		buttons: Ext.MessageBox.OK,
                                                                		icon: Ext.MessageBox.WARNING
                                                                	});
                                                                	return false;
                                                                }*/
                                                                else if (selected.length > 0) {
                                                                    for (var i = 0; i < selected.length; i++) {
                                                                        var recOrg = selected[i];
                                                                        var alarm = recOrg.get('COLUMN_1_ChkBoxVal');
                                                                        //isVM = alarm.substring(0,alarm.indexOf("$"));
                                                                        alarm = alarm.substring(alarm.indexOf("$") + 1);
                                                                        //toConsider = alarm.substring(0, alarm.indexOf("~!~"));
                                                                        //result += toConsider + "#";

                                                                        /*do
                                                                        {
                                                                        	if (toConsider.indexOf("#")>-1)
                                                                        		toConsider=toConsider.replace('#','|hash|');
                                                                        } while(toConsider.indexOf("#")>-1);*/



                                                                        if (alarm.indexOf("~!~") > -1 && alarm.indexOf("~@~") > -1) {
                                                                            alarmId += "^^" + alarm.substring(alarm.indexOf("~!~") + 3, alarm.indexOf("~@~"));
                                                                        }
                                                                        /*if (alarm.indexOf("~@~") > - 1)
                                                                        {
                                                                        	priority = alarm.substring(alarm.indexOf("~@~")+3);
                                                                        }
                                                                        result += "^^"+ isVM + "$" + toConsider + "$@$" + priority;*/
                                                                    }
                                                                }
                                                                if (alarmId.indexOf("^^") == 0) {
                                                                    alarmId = alarmId.substring(2);
                                                                }
                                                                /*if (result.indexOf("^^") == 0)
                                                                {
                                                                	result = result.substring(2);
                                                                }
                                                                if (result.indexOf("#") > - 1)
                                                                {
                                                                	result = result.substring(0, result.lastIndexOf("#"));
                                                                }
                                                                result = result + "$@$" + priority;
                                                                try
                                                                {
                                                                	result=window.opener.filterEncode(result);	
                                                                }
                                                                catch (e)
                                                                {
                                                                	result=parent.filterEncode(result);
                                                                }*/
                                                                var height = Ext.getBody().getViewSize().height - 20;
                                                                if (selected.length > 1) {
                                                                    height = Ext.getBody().getViewSize().height - 150;
                                                                }
                                                                //var qStrParams1 ="doAlarmAcknowledgementEvent=true&acknowledgementEvent=loadAcknowledgementUI&userID=" + userId + "&alarmID=" + alarmId + "&ackAlarmIDs=" + encodeURIComponent(result) + "&ackAlarmDB="+encodeURI(ackAlarmDb)+"&ackorDelTitle=Acknowledge&isForAck=true";
                                                                var qStrParams1 = "doAlarmAcknowledgementEvent=true&acknowledgementEvent=loadAcknowledgementUI&userID=" + userId + "&alarmID=" + alarmId + "&ackAlarmDB=" + encodeURI(ackAlarmDb) + "&ackorDelTitle=Acknowledge&isForAck=true";
                                                                Ext.widget('window', {
                                                                    title: '',
                                                                    height: height,
                                                                    width: 550,
                                                                    shadow: 'sides',
                                                                    cls: 'lightbox',
                                                                    padding: '0 10 10 10',
                                                                    modal: true,
                                                                    autoScroll: true,
                                                                    layout: 'fit',
                                                                    bodyCls: 'alarmsbg',
                                                                    id: 'ackWindowObj',
                                                                    name: 'ackWindowObj',
                                                                    closeAction: 'destroy',
                                                                    items: [{
                                                                        xtype: 'acknowledgementpanel',
                                                                        scroll: true,
                                                                        autoScroll: true,
                                                                        //layout:'fit',
                                                                        qStrParams: qStrParams1,
                                                                        len: selected.length

                                                                    }],
                                                                    listeners: {
                                                                        show: function(win) {
                                                                            if (this.modal) {
                                                                                var dom = Ext.dom.Query.select('.x-mask');
                                                                                var el = Ext.get(dom[0]);
                                                                                el.addCls('windowModal');
                                                                            }
                                                                        },
                                                                        hide: function(win) {
                                                                            if (this.modal) {
                                                                                var dom = Ext.dom.Query.select('.x-mask');
                                                                                var el = Ext.get(dom[0]);
                                                                                el.removeCls('windowModal');
                                                                            }
                                                                        }
                                                                    }
                                                                    //closeAction: 'destory'
                                                                }).show();
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        }, '->']
                                    }]
                                });

                                alarmLoadMask.hide();
                            }
                        });
                    } catch (e) {
                        alarmLoadMask.hide();
                    }
                }
            }
        }]);
        card.doComponentLayout();
        card.resumeLayouts(true);
    },
	goBack:function(){
			window.history.go(-1);
	}
});