<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file = "EgMonitorTracker.jsp"%>
<%@ page import="com.egurkha.monitor.EgServerDashboardModel" %>
<%@ page import="com.egurkha.monitor.EgServerDashBoardDAO" %>
<%@ page import="com.egurkha.monitor.MonitorDAOFactory" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgDisableInfo" %>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.monitor.EgFusionChartUtil" %>
<%@ page import="com.egurkha.monitor.EgGraphsUtil" %>
<%@ page import="java.text.SimpleDateFormat" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.supermanager.*"%>
<%@ page import="net.sf.json.*"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-Cache");
	response.setDateHeader("Expires",-1);
%>

<%
try
{
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		ArrayList managerIds=null;
		String hostname = request.getParameter("hostName");
		if(hostname != null && hostname.trim().length()>0)
		{
			if(hostname.indexOf(":")>-1)
			{
				hostname = hostname.substring(0,hostname.indexOf(":"));
			}
			managerIds = EgElementInfo.getInstance().getManagerIDs("component",hostname);
		}
		if(managerIds != null && !managerIds.isEmpty())
		{
			SmSessionData smsData = new SmSessionData(session.getId(),managerIds);
			EgThreadLocal egtl = new EgThreadLocal();
			egtl.set(smsData);
		}
	}
	JSONObject rootJson = new JSONObject();
	JSONObject hiddens = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject dialChartValues = new JSONObject();
	JSONObject GridValues = new JSONObject();

	String compType=request.getParameter("compType");
	String compName=request.getParameter("hostName");
	String tab=request.getParameter("tab");
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	String blockType = request.getParameter("blockType");
	String ciscoSelectedType = request.getParameter("ciscoSelectedType");
	String options[] = {"overview", "protocols", "flows"}, dispVal = "";
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}

	EgUserRole userRole = u_ser.getUserRole();
	long perm = EgUserPermission.ADMIN;
	boolean adminPermission = userRole.hasAdminRole(perm);
	String hostName="";
	String portNo="";
	String sid="";
	String site="";
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
		{
			portNo=st.nextToken();
		}

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniobj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	String defaultPieGraphDuration=iniobj.getValue("Default_PieGraph_Duration","duration");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgServerDashboardModel model=new EgServerDashboardModel();
	
	MonitorDAOFactory monitorfactory=MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorfactory.getServerDashBoardDAO();
	dashboardDAO.setUserObj(session.getId());
	ErUtils  erutils=new  ErUtils();

	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgDisableInfo disableInfo = new EgDisableInfo("manager");
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	EgGraphsUtil graphUtil=new EgGraphsUtil(trackerLanguage);
	
	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);
	Vector runingTestList=model.getRunningTest(compName,compType,tab);
	ArrayList getExcludedTest = disableInfo.getExcludedTestsForComponent(compName, compType);

%>
<%
	JSONObject overviewObj = new JSONObject();

	String overviewDialGraphs=iniobj.getValue(compType,"Network_Overview_DialGraphs");
	
	Vector dialGraphtests=model.getTokensAsVector(overviewDialGraphs,",");
	double defaultDialGraphWidth=200;  // default dial graph width for calculation
	double defaultDialGraphHeight=125;  // default dial graph height for calculation
	double dialGraphWidth=240;  
	double dialGraphHeight=125;
	double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1024;
	double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;
	double defaultGauageOuterRadius=69; // default dial graph width for calculation
	double defaultGaugeXPos=90; // default dial graph Gauge X position for calculation
	double defaultGaugeYPos=93; // default dial graph Gauge Y position for calculation 
	String gauageOuterRadius="50";
	String gaugeXPos="90";
	String gaugeYPos="93";
	dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
	dialGraphWidth=MathUtils.round(dialGraphWidth,0);
	dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
	dialGraphHeight=MathUtils.round(dialGraphHeight,0);
	double gauageOutRadiusToDefaultWidthInPercent=defaultGauageOuterRadius/defaultDialGraphWidth;
	double gauageOuterRadiusInDouble=dialGraphWidth*gauageOutRadiusToDefaultWidthInPercent;
	gauageOuterRadius=erutils.round(gauageOuterRadiusInDouble,0);
	double gauageXPosToDefaultWidthInPercent=defaultGaugeXPos/defaultDialGraphWidth;
	double gauageYPosToDefaultHeightInPercent=defaultGaugeYPos/defaultDialGraphHeight;
	double gaugeXPosInDouble=dialGraphWidth*gauageXPosToDefaultWidthInPercent;
	gaugeXPos=erutils.round(gaugeXPosInDouble,0);
	double gaugeYPosInDouble=dialGraphHeight*gauageYPosToDefaultHeightInPercent;
	gaugeYPos=erutils.round(gaugeYPosInDouble,0);
	double defaultLedGraphWidth=140;  // default led graph width for calculation
	double defaultLedGraphHeight=85;  // default led graph height for calculation
	double ledGraphWidth=140;  
	double ledGraphHeight=95;
	double ledGraphWidthTo1024PxInPercent=defaultLedGraphWidth/1024;
	double ledGraphHeightToDefaultWidthInPercent=defaultLedGraphHeight/defaultLedGraphWidth;
	double defaultLedGap=1; // default led graph gap for calculation
	double defaultLedSize=1; // default led graph size for calculation
	String ledGap="1";
	String ledSize="1";
	ledGraphWidth=screenWidthInDouble*ledGraphWidthTo1024PxInPercent;
	ledGraphWidth=MathUtils.round(ledGraphWidth,0);
	ledGraphHeight=dialGraphWidth*ledGraphHeightToDefaultWidthInPercent;
	ledGraphHeight=MathUtils.round(ledGraphHeight,0);
	double ledGapToDefaultWidthInPercent=defaultLedGap/defaultLedGraphWidth;
	double ledGapInDouble=ledGraphWidth*ledGapToDefaultWidthInPercent;
	ledGap=erutils.round(ledGapInDouble,0);
	double ledSizeToDefaultWidthInPercent=defaultLedSize/defaultLedGraphWidth;
	double ledSizeInDouble=ledGraphWidth*ledSizeToDefaultWidthInPercent;
	ledSize=erutils.round(ledSizeInDouble,0);
	double defaultChartLeftMargin=42;
	double defaultChartRightMargin=25;
	String chartLeftMargin="42";
	String chartRightMargin="25";
	double chartLeftMarginToDefaultWidthInPercent=defaultChartLeftMargin/defaultLedGraphWidth;
	double ledLeftMarginInDouble=ledGraphWidth*chartLeftMarginToDefaultWidthInPercent;
	chartLeftMargin=erutils.round(ledLeftMarginInDouble,0);
	double chartRightMarginToDefaultWidthInPercent=defaultChartRightMargin/defaultLedGraphWidth;
	double ledRightMarginInDouble=ledGraphWidth*chartRightMarginToDefaultWidthInPercent;
	chartRightMargin=erutils.round(ledRightMarginInDouble,0);
	double pieChartDivHeight = dialGraphHeight+30;
	
	dialChartValues.put("pieChartDivHeight",pieChartDivHeight);
	int dialChartNoMeasuresCount=0;
	String iniEntries = iniobj.getValue(compType,"Netflow_dial");
	
	ArrayList colorCodes = new ArrayList();
	String dialColor = iniobj.getValue("Dashboard_Graph_colors","Netflow_Dial_colors");
	StringTokenizer stT=new StringTokenizer(dialColor,",");
	while(stT.hasMoreTokens())
	{
		String colorCode=stT.nextToken();			
		colorCodes.add(colorCode);
	}
		
	JSONArray ciscoArray =new JSONArray();
	boolean isAnyTestExcludedOrDisabledForDial = false;
	if(iniEntries != null && iniEntries.length() > 0)
	{
		String isDialNeeded=iniobj.getValue("Dashboard_Settings","UseDial");
		String isThresholdNeed=iniobj.getValue("Dashboard_Settings","ApplyThreshold");

		StringTokenizer st=new StringTokenizer(iniEntries,",");
		int dialChartCount=0;
		int i=0;
		ArrayList dialmeasuresNAList = new ArrayList();
		while(st.hasMoreTokens())
		{
			JSONObject ciscoObj=new JSONObject();
			String testWithMeasure=st.nextToken();
			String d_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
			String d_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
			if(enabledTests!=null && !enabledTests.contains(d_test)) {
				isAnyTestExcludedOrDisabledForDial = true;
				continue;
			}
			if(getExcludedTest != null && getExcludedTest.contains(d_test)) {
				isAnyTestExcludedOrDisabledForDial = true;
				continue;
			}
			String msmtHost=(String)allMsmtHosts.get(d_test);
			String measureValue="";
			String measureForDB=dbInfo.getColumnForMeasure(d_test,d_measure);

			String dial_measureMapping=iniobj.getValue("Dashboard_Dial_mapping",testWithMeasure);

			if(dial_measureMapping==null || dial_measureMapping.trim().equals(""))
				dial_measureMapping=mappingInfo.getMeasureDescription(d_test,d_measure);

			String tooltip=dial_measureMapping;

			String unit=tablesInfo.getUnitForMeasure(d_test,d_measure);
			if((unit!=null) && (unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage")))
				unit="%";
			long stime=System.currentTimeMillis();
			Vector testInfos=dashboardDAO.getDescriptorsForTest(compName,compType,d_test,tab);
			long ltime=System.currentTimeMillis();
			String key=compName+":"+portNo+":"+d_test+":"+msmtHost;
			String oneMsmtTime=dashboardDAO.getMeasureLastMsmtTime(key);
			
			if(msmtHost==null)
				msmtHost="";

			boolean isFullView=false;
			Vector infos=(Vector)allTestInfos.get(d_test);
			Vector infosForCutOffFactor = new Vector();
			if(model.isTestHasCutOffFactor(d_test))
			{
				if(infos!=null && !infos.isEmpty())
				{
					for(int d=0;d<infos.size();d++)
					{
						String infoForDial=(String)infos.get(d);
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,d_test,msmtHost,infoForDial);
						if(!isTestExceededCutOffFactor)
						{
							if(infosForCutOffFactor!=null && !infosForCutOffFactor.contains(infoForDial))
							{
								infosForCutOffFactor.add(infoForDial);
							}
						}
					}
				}
				if(infosForCutOffFactor!=null && !infosForCutOffFactor.isEmpty())
				{
					infos=infosForCutOffFactor;
				}
			}
			if(infos!=null && !infos.isEmpty() && infos.size()>1)
			{
				isFullView=true;
			}
			String info=fusionChart.getInfoForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed);

			if(info!=null && info.indexOf("+")!=-1)
				info=info.substring(info.indexOf("+")+1);
			info=StringUtils.replace(info, "+", "|plus|");

			Vector dialChartAttributes=new Vector();
			dialChartAttributes.add("clickURL='javascript:wayToLayerModel(&apos;dialUrl"+dialChartCount+"&apos;)'");  // To avoid drilldown url problem in Doublebyte. We have to create one HIDDEN element and the url to be stored there
			dialChartAttributes.add("fillAngle='60'");
			dialChartAttributes.add("majorTMNumber='6'");
			dialChartAttributes.add("majorTMHeight='8'");
			dialChartAttributes.add("majorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMHeight='4'");
			dialChartAttributes.add("minorTMNumber='6'");
			dialChartAttributes.add("majorTMThickness='1'");
			dialChartAttributes.add("markerRadius='30'");
			dialChartAttributes.add("showGaugeBorder='0'");
			dialChartAttributes.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
			dialChartAttributes.add("gaugeOriginX='"+gaugeXPos+"'");
			dialChartAttributes.add("gaugeOriginY='"+gaugeYPos+"'");
			dialChartAttributes.add("gaugeInnerRadius='0'");
			dialChartAttributes.add("formatNumberScale='0'");
			dialChartAttributes.add("displayValueDistance='0'");
			dialChartAttributes.add("decimalPrecision='2'");
			dialChartAttributes.add("tickMarkDecimalPrecision='2'");
			dialChartAttributes.add("tickValueDistance='14'");
			dialChartAttributes.add("pivotRadius='6'");
			dialChartAttributes.add("showPivotBorder='1'");
			dialChartAttributes.add("pivotBorderColor='000000'");
			dialChartAttributes.add("pivotBorderThickness='5'");
			dialChartAttributes.add("pivotFillMix='FFFFFF,000000'");
			dialChartAttributes.add("paletteThemeColor='ffffff'");
			dialChartAttributes.add("pivotFillType='linear'");
			dialChartAttributes.add("showToolTip='1'");
			dialChartAttributes.add("chartLeftMargin='0'");
			dialChartAttributes.add("chartRightMargin='0'");
			dialChartAttributes.add("chartBottomMargin='0'");
			dialChartAttributes.add("baseFontColor='000000'");
			dialChartAttributes.add("adjustTM='0'");
			dialChartAttributes.add("chartTopMargin='0'");
			dialChartAttributes.add("borderAlpha='0'");
			dialChartAttributes.add("bgAlpha='_alpha'");

			dialChartAttributes.add("showToolTipShadow='1'");
			dialChartAttributes.add("toolTipBgColor='ffffff'");
			dialChartAttributes.add("toolTipBorderColor='555555'");
			dialChartAttributes.add("exportEnabled='0'");
			dialChartAttributes.add("exportAction='download'");
			dialChartAttributes.add("exportAtClient='0'");
			dialChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			
			String layerName=dashboardDAO.getLayerForTest(compType,d_test,d_measure);

			String compTypeForAlarm=compType;
			if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
				compTypeForAlarm="Host_system";

			String measureState=model.getTestMeasureState(compName,compTypeForAlarm,layerName,d_test+"-"+info,d_measure);

			String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=cisco_Dashboard&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+d_test+"-"+info+"&tstate="+measureState+"&msmt_host=&backNav=cmpDashboard";

			String dialXMLData="";
			String colorCode = "";
			if(compType!=null && compType.equals("NetflowDevice") && colorCodes!=null && colorCodes.size()>0)
			{
				colorCode = (String)colorCodes.get(i);
			}
			if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("Yes"))
			{
				dialXMLData=graphUtil.getXMLDataForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,dialChartAttributes,"000000",true,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight,layerPageUrl,colorCode);
			}
			else if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("No"))
			{
				Vector jvmChartAttributes=new Vector();
				jvmChartAttributes.add("clickURL='javascript:wayToLayerModel(&apos;dialUrl"+dialChartCount+"&apos;)'");
				jvmChartAttributes.add("upperLimit='100'");
				jvmChartAttributes.add("bgColor='99CCFF,FFFFFF'");
				jvmChartAttributes.add("bgAlpha='0,0'");
				jvmChartAttributes.add("showBorder='0'");
				jvmChartAttributes.add("adjustTM='0'");
				jvmChartAttributes.add("lowerLimit='0'");
				jvmChartAttributes.add("decimals='2'");
				jvmChartAttributes.add("showValue='0'");
				jvmChartAttributes.add("majorTMNumber='5'");
				jvmChartAttributes.add("majorTMColor='000000'");
				jvmChartAttributes.add("majorTMHeight='5'");
				jvmChartAttributes.add("minorTMNumber='2'");
				jvmChartAttributes.add("minorTMColor='000000'");
				jvmChartAttributes.add("minorTMHeight='2'");
				jvmChartAttributes.add("majorTMThickness='1'");
				jvmChartAttributes.add("decimalPrecision='0'");
				jvmChartAttributes.add("ledGap='"+ledGap+"'");
				jvmChartAttributes.add("ledSize='"+ledSize+"'");
				jvmChartAttributes.add("tickValueDistance='2'");
				jvmChartAttributes.add("tickMarkDistance='1'");
				jvmChartAttributes.add("tickValueStep='1'");
				jvmChartAttributes.add("tickValueDecimals='8'");
				jvmChartAttributes.add("chartLeftMargin='"+chartLeftMargin+"'");
				jvmChartAttributes.add("chartRightMargin='"+chartRightMargin+"'");
				jvmChartAttributes.add("chartTopMargin='21'");
				jvmChartAttributes.add("chartBottomMargin='20'");
				jvmChartAttributes.add("baseFontSize ='9'");
				jvmChartAttributes.add("showToolTip='1'");
				jvmChartAttributes.add("baseFontColor  ='000000'");
				jvmChartAttributes.add("annRenderDelay='1.7'");
				jvmChartAttributes.add("exportEnabled='0'");
				jvmChartAttributes.add("exportAction='download'");
				jvmChartAttributes.add("exportAtClient='0'");
				jvmChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

				dialXMLData=graphUtil.getXMLDataForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,jvmChartAttributes,"000000",true,ledGraphWidth,ledGraphHeight,defaultLedGraphWidth,defaultLedGraphHeight,layerPageUrl,"");
			}
			if(dialXMLData !=null && !dialXMLData.equals(""))
			{
				String moreDescriptorUrl=response.encodeURL("/final/monitor/EgMoreInfosDial.jsp?")+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+d_test+"&measure="+d_measure+"&msmtHost="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&tab="+tab;

				String unitMapping = graphUtil.getUnitMapping(unit);
				ciscoObj.put("tooltip",tooltip);
				ciscoObj.put("unit",unitMapping);
				ciscoObj.put("dial_measureMapping",dial_measureMapping);
				if(isFullView)
				{
					ciscoObj.put("moreDescriptorUrl",moreDescriptorUrl);
				}
				if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("Yes"))
				{
					ciscoObj.put("dialXMLData",dialXMLData);
					ciscoObj.put("dialGraphWidth",dialGraphWidth);
					ciscoObj.put("dialGraphHeight",dialGraphHeight);
					ciscoObj.put("moreDescriptorUrl",moreDescriptorUrl);
					ciscoObj.put("FusionChartsURL","/final/FusionCharts/swf/AngularGauge.swf");
				}
				else if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("No"))
				{
					ciscoObj.put("dialXMLData",dialXMLData);
					ciscoObj.put("dialGraphHeight",ledGraphHeight);
					ciscoObj.put("dialGraphWidth",ledGraphWidth);
					ciscoObj.put("dialGraphHeight",dialGraphHeight);
					ciscoObj.put("dialGraphHeight",dialGraphHeight);
					ciscoObj.put("FusionChartsURL","/final/FusionCharts/swf/VLED.swf");
				}
				hiddens.put("dialUrl"+dialChartCount, layerPageUrl);
				dialChartCount++;
				ciscoArray.add(ciscoObj);
			}
			i++;
			
		}
		dialChartValues.put("dialChartValues",ciscoArray);
		for (int na=1;na < dialmeasuresNAList.size()+1;na++)
		{
			if(dialmeasuresNAList.size()==i)
			{
				String NAlistdata = (String)dialmeasuresNAList.get(na-1);
				String dial_measureMapping = NAlistdata.substring(0,NAlistdata.indexOf("#"));
				String unit = NAlistdata.substring(NAlistdata.indexOf("#")+1,NAlistdata.indexOf("$"));
				String tooltip = NAlistdata.substring(NAlistdata.indexOf("$")+1);
				int temCount=(++dialChartCount)%5;
				dialChartCount--;

				rootJson.put("DIAL_TITLE",mappingInfo.getTextDescription("monitor.dashboard.Dial Graph"));
				rootJson.put("NoMeasure",mappingInfo.getTextDescription("monitor.dashboard.No measures available!"));
				dialChartNoMeasuresCount++;
					int tempCount=(++dialChartCount)%5;
					dialChartCount--;
					break;
				}
			}
		}
		double defaultTableWidth=950;
		double tableWidth=920;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);

		String interfaceEntries = iniobj.getValue(compType,"Netflow_Interface");
		boolean isTestEnabledOrIncluded = false;
		if(interfaceEntries!=null && interfaceEntries.length() > 0)
		{
			StringTokenizer stoken=new StringTokenizer(interfaceEntries,",");
			StringBuffer infosToAreaChart=new StringBuffer();
			Map mapData=new HashMap();
			ArrayList units=new ArrayList();
			units.add("-");
			String comparisonTableFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&blockType=CiscoComparisionTable&tab=Network";
			StringBuffer measureColumn=new StringBuffer();
			String fullviewTest="";
			String fullviewMsmtHost="";
			String interfaceCount_fullview="";
			String selectedTimeline=request.getParameter("selectedTimeline");

			if(StringUtils.isNull(selectedTimeline))
				selectedTimeline="30 mins";
			int imgcnt=0;
			int stColPos=1;
			int endColPos=5;
			List headers=new ArrayList();
			headers.add("Interface");
			while(stoken.hasMoreTokens())
			{
				String testMeasure=stoken.nextToken();
				String interface_test=testMeasure.substring(0,testMeasure.indexOf(":"));
				String interface_measure=testMeasure.substring(testMeasure.indexOf(":")+1);
				String measureForDB=dbInfo.getColumnForMeasure(interface_test,interface_measure);
				String msmthost=(String)allMsmtHosts.get(interface_test);
				String excludedInfos=iniobj.getValue("INFOS_TO_BE_OMITTED",testMeasure);
				String interfaces_Count=iniobj.getValue("Interfaces","MaxInterfaces");
				String iniheader=iniobj.getValue(compType,testMeasure);
				headers.add(iniheader);
				fullviewTest=interface_test;
				fullviewMsmtHost=msmthost;
				interfaceCount_fullview=interfaces_Count;
				measureColumn.append(measureForDB);
				if(stoken.hasMoreTokens())
					measureColumn.append(",");
				//newly added
				
				StringTokenizer infos=new StringTokenizer(excludedInfos,",");
				Vector excluded_infos=new Vector();
				
				if(enabledTests!=null && !enabledTests.contains(interface_test))
					continue;
				if(getExcludedTest != null && getExcludedTest.contains(interface_test))
					continue;
				isTestEnabledOrIncluded = true;
				while(infos.hasMoreTokens())
				{
						excluded_infos.add("+"+infos.nextToken());
				}
				Vector filtered_infos=new Vector();
				Vector currentValues = null;
					
				if(measureForDB.equalsIgnoreCase("AVAILABILITY")){
					currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,interface_test,measureForDB,msmthost,"",true,interfaces_Count);//newly added

				}
				else {
					currentValues=(Vector)dashboardDAO.getInfosForInterfaceTest(hostName,portNo,interface_test,measureForDB,msmthost,"",true,selectedTimeline,"",interfaces_Count);//newly added
				}
				String tableName = iniobj.getValue("Dashboard_GraphTitle_Mapping",testMeasure);
				String defaultInfo="";
				String unit=tablesInfo.getUnitForMeasure(interface_test,interface_measure);
				
				units.add(unit);

				if(currentValues!=null && currentValues.size()>0)
				{
					for(int i=0;i<currentValues.size();i=i+2)
					{
						String interfaceInfo=(String)currentValues.get(i);
						String value=(String)currentValues.get(i+1);
						if(!excluded_infos.contains(interfaceInfo))
						{
								filtered_infos.add(interfaceInfo);
								filtered_infos.add(value);
						}
					}
				}
				if(filtered_infos!=null && filtered_infos.size()>0)
				{
					for(int i=0;i<filtered_infos.size();i=i+2)
					{
						String interfaceInfo=(String)filtered_infos.get(i);
						String value=(String)filtered_infos.get(i+1);
						if(mapData!=null && mapData.containsKey(interfaceInfo))
						{
							ArrayList existingList=(ArrayList)mapData.get(interfaceInfo);
							existingList.add(value);
							mapData.put(interfaceInfo,existingList);
						}
						else
						{
							ArrayList valueList=new ArrayList();
							valueList.add(value);
							mapData.put(interfaceInfo,valueList);
						}
					}
				}
			}

			comparisonTableFullViewURL+="&test="+fullviewTest+"&measure="+measureColumn.toString()+"&msmtHost="+fullviewMsmtHost+"&interfaces_Count="+interfaceCount_fullview+"&fromInterface=true&headerList="+headers+"&inilookup=Cisco_Interface";

			String Interfaces = mappingInfo.getTextDescription("monitor.title.Network Interfaces Summary");
			GridValues.put("MAIN_TITLE",Interfaces);
			GridValues.put("comparisonTableFullViewURL",comparisonTableFullViewURL);
			if(adminPermission==true)
			{
				GridValues.put("comparisonTableFullViewURL",comparisonTableFullViewURL);
			}		
			JSONObject gridColumns=new JSONObject();
			if(mapData!=null && !mapData.isEmpty())
			{			
				endColPos=headers.size();
				for(int j=0;j<headers.size();j++)
				{
					String h_unit=(String)units.get(j);
					if(h_unit.equals("-"))
						h_unit="";
					if(j==0)
					{
						gridColumns.put("COLUMNam_"+j,mappingInfo.getTextDescription("monitor.dashboard."+(String)headers.get(j)));
					}
					else
					{
						String unitMapping = graphUtil.getUnitMapping(h_unit);
						gridColumns.put("COLUMNam_"+j,mappingInfo.getTextDescription("monitor.dashboard."+(String)headers.get(j))+"  ("+unitMapping+")");
					}
					imgcnt++;
				}
				Iterator itr=mapData.keySet().iterator();
				endColPos=5;

				int k=0;
				JSONArray  stateJson=new JSONArray();
				while(itr.hasNext())
				{
					String info=(String)itr.next();
					infosToAreaChart.append(info);
					if(itr.hasNext())
						infosToAreaChart.append(",");
					String text =StringUtils.replace(info, "+", "");
					text = text.substring(0, text.length() - 1);

					ArrayList values=(ArrayList)mapData.get(info);
					JSONObject jsonObj=new JSONObject();
					if(values!=null && values.size()>0)
					{
						jsonObj.put("COLUMN_0",text);
						for(int i=0;i<values.size();i++)
						{
							String val=(String)values.get(i);
							if(val.startsWith("-"))
								val="-";
							if(i==0)
							{
								String measVal = dbInfo.formatValue(val);
								String img="";
								if(measVal.equals("100"))
								{
									img = "iconRight";
								}
								else
								{
									img="iconWrong";
								}
								jsonObj.put("COLUMN_"+(i+1),img);
								}
							else
							{
								jsonObj.put("COLUMN_"+(i+1),val);
							}
						}
						stateJson.add(jsonObj);	
					}				
					k++;
				}
				GridValues.put("STATE_VALUES",stateJson);			
			}
			else
			{
				gridColumns.put("Interface_NOMes",mappingInfo.getTextDescription("monitor.common.No measures available!"));
			}
			GridValues.put("COLUMN_VALUES",gridColumns);

			String passingInfo=infosToAreaChart.toString();
			passingInfo = StringUtils.encodeSecurityChar(passingInfo);
			//String url="/final/monitor/EgNetflowDashHelperJSON.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&mappingName=abc&blockType=areaChart&infosToArea="+infosToAreaChart;
			String defaultAreaGraphDuration=iniobj.getValue("Default_AreaGraph_Duration","duration");
			String areaChartURL = "/final/monitor/EgNetflowDashHelperJSON.jsp?hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+EgURLEncoder.encode(compType,"UTF-8")+"&tab="+tab+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&blockType=areaChart&infosToArea="+EgURLEncoder.encode(passingInfo,"UTF-8")+"&ciscoSelectedType="+ciscoSelectedType+"&timeline="+EgURLEncoder.encode(defaultAreaGraphDuration,"UTF-8");
			
			
			String protocolsURL = "/final/monitor/EgNetflowDashHelperJSON.jsp?hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+EgURLEncoder.encode(compType,"UTF-8")+"&tab="+tab+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&blockType=Protocols&infosToArea="+EgURLEncoder.encode(passingInfo,"UTF-8")+"&ciscoSelectedType="+ciscoSelectedType+"&timeline="+EgURLEncoder.encode(defaultPieGraphDuration,"UTF-8");

			String interFace_view = request.getParameter("interfaceToView");
			//String infosToArea=request.getParameter("infosToArea");			

			String flowsURL = "/final/monitor/EgNetflowDashHelperJSON.jsp?hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+EgURLEncoder.encode(compType,"UTF-8")+"&tab="+tab+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&blockType=Flows&infosToArea="+EgURLEncoder.encode(passingInfo,"UTF-8")+"&ciscoSelectedType="+ciscoSelectedType;

			if(interFace_view!=null && interFace_view!=""){
				interFace_view = StringUtils.encodeSecurityChar(interFace_view);
				flowsURL += "&interfaceToView="+EgURLEncoder.encode(interFace_view,"UTF-8");
				protocolsURL += "&interfaceToView="+EgURLEncoder.encode(interFace_view,"UTF-8");
			}
			
			String timeline = request.getParameter("timeline");			
			if(StringUtils.isNull(timeline))
				timeline = defaultPieGraphDuration;
			flowsURL +="&timeline="+timeline;
			
			ErReportHelper er_helper = new ErReportHelper();
			int maxInfo = er_helper.getMaxInfos("INFOS","Showtop");
			String showVal = request.getParameter("show");			
			if(StringUtils.isNull(showVal))
			showVal = "TOP - "+maxInfo;
			flowsURL +="&show="+showVal;
			JSONArray selectedTimelineArray = new JSONArray();
			String[] dateChoice={"30 mins","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","Any"};
			List datelist=Arrays.asList(dateChoice);
			JSONArray timelineJson=new JSONArray();
			for(int i=0;i<datelist.size();i++)
			{
				JSONObject tmJson=new JSONObject();
				String element=(String)datelist.get(i);
				String selected="";
				if(element.equals("30 mins"))
					selected="selected";
				tmJson.put("displayField",element);
				tmJson.put("valueField",element);
				timelineJson.add(tmJson);		
			}
			
			if(StringUtils.isNull(selectedTimeline))
				selectedTimeline="30 mins";
			selectedTimelineArray.add(selectedTimeline);
			rootJson.put("TIMELINE_VALUES",timelineJson);
			rootJson.put("selectedTimeline",selectedTimelineArray);
			rootJson.put("GRID_DATA",GridValues);
			rootJson.put("AREACHART_URL",areaChartURL);
			rootJson.put("protocolsURL",protocolsURL);
			rootJson.put("flowsURL",flowsURL);
		}
	
		String requestData = ErUtils.prepareQueryString(request.getParameterMap());		
		if(requestData!=null)
		{
			if(session!=null)
			{
				session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+requestData+"&comptype="+request.getParameter("compType")+"&host="+request.getParameter("hostName")+"&tab="+tab+"&graphType=&toDashBoardLayer=true");
				session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
			}
		}
		else
		{
			if(session!=null)
			{
				session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab="+tab+"&toDashBoardLayer=true&ciscoSelectedType="+ciscoSelectedType);
				session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
			}
		}
		rootJson.put("hiddens", hiddens);
		rootJson.put("OVERVIEW", overviewObj);	
		rootJson.put("FUSION-CHART",dialChartValues);	
		if(isAnyTestExcludedOrDisabledForDial){
			rootJson.put("DIAL_MSG", mappingInfo.getTextDescription("monitor.dashboard.The test has been excluded or disabled")+"!");
		}
		rootJson.put("NET_TAB_NoGraphTitle", mappingInfo.getTextDescription("monitor.dashboard.Availability/Network Traffic"));

		out.println(rootJson.toString());
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}

%>