<%@ page language="java" contentType="application/json;charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="EgMonitorTracker.jsp" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="java.text.SimpleDateFormat" %>
<%@ page import="com.egurkha.monitor.MonitorDAOFactory" %>
<%@ page import="com.egurkha.monitor.EgServerDashBoardDAO" %>
<%@ page import="com.egurkha.monitor.EgServerDashboardModel" %>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import="com.eg.*" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgDisableInfo"%>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="java.util.Date"%>
<%@ page import="net.sf.json.*"%>
<%@ page import="com.egurkha.HighChartTimeline" %>
<%@ page import="com.egurkha.monitor.EgFusionChartUtil" %>
<%@ page import="com.egurkha.monitor.EgGraphsUtil" %>
<%@ page import="com.egurkha.util.MathUtils"%>
<%
	response.setHeader("Cache-Control","no-Store");
	response.setHeader("Pragma","no-Cache");
	response.setDateHeader("Expires",-1);
try
{
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String userFormat = user.getUserDateFormat();
	IniUI iniUI = IniUI.getInstance();
	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);
	EgServerDashboardModel model=new EgServerDashboardModel();
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONArray chartArr=new JSONArray();

	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String tab=request.getParameter("tab");
	String blockType=request.getParameter("blockType");
	String ciscoSelectedType=request.getParameter("ciscoSelectedType");
	String test=request.getParameter("testName");
	String measure=request.getParameter("measureName");
	String defaultInfo=request.getParameter("defaultInfo");
	String selectedDate=request.getParameter("selectedDate");
	String selectedInterface=request.getParameter("interfaceToView");
	selectedInterface = StringUtils.decodeSecurityChar(selectedInterface);	

	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	String startGridIndex=request.getParameter("start");
	String limitIndex=request.getParameter("limit");
	int startIndex = 0;
	int limit = 0;
	String fromGridPage=request.getParameter("isFromGridPage");
	boolean isFromGridPage = false;
	boolean allowGrid = false;
	if(fromGridPage!=null && fromGridPage.equalsIgnoreCase("true"))
		isFromGridPage = true;
	if(startGridIndex == null){
		allowGrid = true;
		startGridIndex = "0";
		limitIndex = "10";
	}
	startIndex = Integer.parseInt(startGridIndex);
	limit = Integer.parseInt(limitIndex);
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}
	if(EgInstallInfo.isSuperManager)
	{
		if(compName != null && compName.indexOf(":")>-1)
		{
			ArrayList managerIds = EgElementInfo.getInstance().getManagerIDs("component",compName.substring(0,compName.indexOf(":")));
			if(managerIds != null && !managerIds.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(session.getId(),managerIds);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
			}
		}
	}
	
	IniUI iniui = IniUI.getInstance();
	EgDbInfo dbinfo=new EgDbInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgTesterInfo testInfo = new EgTesterInfo("manager");
	EgDisableInfo disableInfo = new EgDisableInfo("manager");
	EgDateInfo edi = new EgDateInfo();
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniobj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	MonitorDAOFactory factory=MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=factory.getServerDashBoardDAO();
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	EgGraphsUtil graphUtil=new EgGraphsUtil(trackerLanguage);
	EgSummaryChartUtil summaryChart=new EgSummaryChartUtil();
	dashboardDAO.setUserObj(session.getId());

	EgUserRole userRole = u_ser.getUserRole();
	long perm = EgUserPermission.ADMIN;
	boolean adminPermission = userRole.hasAdminRole(perm);
	String defaultMGraphDuration=iniobj.getValue("Default_MeasureGraph_Duration","duration");
	String defaultPieGraphDuration=iniobj.getValue("Default_PieGraph_Duration","duration");
	String defaultAreaGraphDuration=iniobj.getValue("Default_AreaGraph_Duration","duration");
	String includedNetflowDevice = iniobj.getValue("Included_NetflowDevice",compType);
	String excludedNetflowDevice = iniobj.getValue("Excluded_NetflowDevice",compType);
	String chartType = iniobj.getValue("Dashboard_Settings","NetflowChartType");
	String showInterfaces = iniobj.getValue(compType,"showInterfaces");
	IniFile uiIniobj = new IniFile(s_iniFile_dir+"eg_ui.ini");
	boolean isIncludedNetflowDeviceAvailable = false;
	if(includedNetflowDevice!=null && includedNetflowDevice.equalsIgnoreCase("yes"))
	{
		isIncludedNetflowDeviceAvailable = true;
	}
	boolean isExcludedNetflowDeviceAvailable = false;
	if(excludedNetflowDevice!=null && excludedNetflowDevice.equalsIgnoreCase("yes"))
	{
		isExcludedNetflowDeviceAvailable = true;
	}
	String FullViewPriority="TOP+-+10";
	String hostName="";
	String portNo="";
	String sid="";
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
		{
			portNo=st.nextToken();
		}

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);
	ArrayList getExcludedTest = disableInfo.getExcludedTestsForComponent(compName, compType);
	Vector runningTests = dashboardDAO.getRunningTestsForServer(compName, compType, tab);
	
	/*String maxRecordsLimit=iniobj.getValue("Dashboard_Settings","MaxRecordsLimit");
	String maxRecordsIncrement=iniobj.getValue("Dashboard_Settings","MaxRecordsIncrement");
	int incrementVal = Integer.parseInt(maxRecordsIncrement);
	int comboMaxLimit = Integer.parseInt(maxRecordsLimit);
	int arraySize = comboMaxLimit/incrementVal;
	String[] eventsPerPage_options = new String[arraySize+1];
	int tmpIncrementVal = incrementVal;
	int l=0;
	while(tmpIncrementVal<=comboMaxLimit)
	{
		eventsPerPage_options[l] = String.valueOf(tmpIncrementVal);
		tmpIncrementVal += incrementVal;
		l++;
	}*/

	/*JSONArray eventsPerPageArray = new JSONArray();	
	JSONObject eventsPerPageComboObj = new JSONObject();
	String eventsPerPageVal = request.getParameter("eventsPerPage");	
	for(int n=0;n<eventsPerPage_options.length;n++)
	{
		JSONObject eventsCombo = new JSONObject();
		String tmpEvents = (String)eventsPerPage_options[n];
		eventsCombo.put("displayField",tmpEvents);
		eventsCombo.put("valueField",tmpEvents);
		eventsPerPageArray.add(eventsCombo);
	}
	eventsPerPageComboObj.put("selectedEventsPerPage",eventsPerPageVal);
	eventsPerPageComboObj.put("eventsPerPageArray",eventsPerPageArray);
	rootJson.put("eventsPerPageCombo",eventsPerPageComboObj);*/
	
	String[] show_options =new String[] {"TOP - 2","TOP - 5","TOP - 10"};//,"LAST - 10","LAST - 5","LAST - 2"};
	String flows_Count=iniobj.getValue("Interfaces","flows");
	int maxInfo = Integer.parseInt(flows_Count);
	JSONArray showComboArray = new JSONArray();
	JSONArray selectedShowArray = new JSONArray();
	JSONObject showComboObj = new JSONObject();
	Vector v_show=new Vector();
	v_show.add("TOP - " +maxInfo/4);
	v_show.add("TOP - " +maxInfo/2);
	v_show.add("TOP - " +maxInfo);
	/*v_show.add("ALL");
	v_show.add("LAST - " +maxInfo);
	v_show.add("LAST - " +maxInfo/2);
	v_show.add("LAST - " +maxInfo/4);*/
	String showVal = request.getParameter("show");	
	if(StringUtils.isNull(showVal))
		showVal = "TOP - "+maxInfo;
	String showTitle = "";
	if(showVal.equalsIgnoreCase("TOP - 2")){
		showTitle = "Top 2";
	}
	else if(showVal.equalsIgnoreCase("TOP - 5")){
		showTitle = "Top 5";
	}
	else if(showVal.equalsIgnoreCase("TOP - 10")){
		showTitle = "Top 10";
	}
	/*else if(showVal.equalsIgnoreCase("ALL")){
		showTitle = "All";
	}
	else if(showVal.equalsIgnoreCase("LAST - 10")){
		showTitle = "Last 10";
	}
	else if(showVal.equalsIgnoreCase("LAST - 5")){
		showTitle = "Last 5";
	}
	else if(showVal.equalsIgnoreCase("LAST - 2")){
		showTitle = "Last 2";
	}*/
	for(int n=0;n<v_show.size();n++)
	{
		JSONObject showCombo = new JSONObject();
		String tmpShow = (String)v_show.get(n);
		showCombo.put("displayField",mappingInfo.getTextDescription("monitor.dashboard."+tmpShow));
		showCombo.put("valueField",tmpShow);
		showComboArray.add(showCombo);
	}
	showComboObj.put("selectedShowCombo",showVal);
	showComboObj.put("showComboArray",showComboArray);
	rootJson.put("showCombo",showComboObj);

	if(blockType!=null && blockType.equals("areaChart"))
	{
		SimpleDateFormat sdf=new SimpleDateFormat("MM/dd/yyyy HH:mm");
		int[] timeFormat={1000*60*60,1000*60*60*24*7,1000*60*60*24*30};
		int passValue=1000*60*60;
		String title="";
		String startDateTime="";
		String endDateTime="";
		String s_en_time="";
		String s_st_time="";
		String s_st_hr = "";
		String s_en_hr="";
		String s_st_min="";
		String s_en_min="";
		String timeSelect="";
		JSONArray selectedTimelineArray = new JSONArray();
		
		if(selectedDate!=null && !selectedDate.equals(""))
		{
			timeSelect=selectedDate.toLowerCase();
			int blankSpaceIndex = selectedDate.indexOf(DateTimeTokenizer.BLANK_SPACE);
			if (blankSpaceIndex > 0)
			{
				if(timeSelect.indexOf("any")>-1){
					startDateTime = timeSelect.substring(timeSelect.indexOf(" ")+1,timeSelect.indexOf("|"));
					//startDateTime = startDateTime.substring(0,startDateTime.lastIndexOf(":"));
					
					endDateTime = timeSelect.substring(timeSelect.indexOf("|")+1);
					//endDateTime = endDateTime.substring(0,endDateTime.lastIndexOf(":"));
					timeSelect = timeSelect.substring(0, timeSelect.indexOf(" "));
				}
				else {
					String titletmp=selectedDate;
					java.util.Date today = edi.egetRealDate();
					endDateTime=sdf.format(today);
					int value = Integer.parseInt(selectedDate.substring(0, blankSpaceIndex));
					String timelineUnit = selectedDate.substring(blankSpaceIndex+1).toLowerCase();
					if (timelineUnit.startsWith("h"))
					{//hours
						value *= 3600;
						title=titletmp;
					}
					else if (timelineUnit.startsWith("d"))
					{//days
						value *= (24 * 3600);
						title=titletmp;
					}
					else if (timelineUnit.startsWith("w"))
					{//weeks
						value *= (7 * 24 * 3600);
						title=titletmp;
					}
					else if (timelineUnit.startsWith("mo"))
					{//months
						//value *= (30 * 24 * 3600);
						value *=(24*(ErUtils.getMaxDaysInMonth()) * 3600);
						title=titletmp;
					}
					else if (timelineUnit.startsWith("mins"))
					{
						value *= 60;
						title=titletmp;
					}
					long longValue=value;
					java.util.Date start = edi.egetRealDate();
					start.setTime(today.getTime() - (longValue * 1000));
					startDateTime = sdf.format(start);
				}
					
				if ((startDateTime != null) && (endDateTime != null))
				{
					int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
					int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
					s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
					s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
					s_st_hr = startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":"));//String.valueOf(shr);
					s_en_hr = endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":"));//String.valueOf(en_hr);
					s_st_min = startDateTime.substring(startDateTime.lastIndexOf(":")+1);
					s_en_min = startDateTime.substring(endDateTime.lastIndexOf(":")+1);
				}
				
				if(timeSelect.indexOf("any")>-1){
					String tmpStartDate = DateUtil.changeDateFormat(s_st_time,"MM/dd/yyyy",userFormat);
					String tmpEndDate = DateUtil.changeDateFormat(s_en_time,"MM/dd/yyyy",userFormat);
					JSONObject tmpJsonObj=new JSONObject();
					tmpJsonObj.put("anyStartDate", tmpStartDate);
					tmpJsonObj.put("anyStartHr", s_st_hr);
					tmpJsonObj.put("anyEndDate", tmpEndDate);
					tmpJsonObj.put("anyEndHr", s_en_hr);
					tmpJsonObj.put("anyStartMin", s_st_min);
					tmpJsonObj.put("anyEndMin", s_en_min);
					selectedTimelineArray.add("Any");
					selectedTimelineArray.add(tmpJsonObj);
				}
				else {
					selectedTimelineArray.add(timeSelect);
				}
			}
		}
		else
		{
			timeSelect="30 mins";
			java.util.Date endDate=edi.egetRealDate();
			endDateTime=sdf.format(endDate);
			java.util.Date startDate=edi.egetRealDate();
			if (timeSelect.endsWith("mins"))
			{
				startDate.setTime(endDate.getTime() - (30 * 60 * 1000));
			}
			else
			{
				startDate.setTime(endDate.getTime() - (3600 * 1000));
			}
			
			startDateTime=sdf.format(startDate);
			if ((startDateTime != null) && (endDateTime != null))
			{
				int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
				int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
				s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_hr = String.valueOf(shr);
				s_en_hr = String.valueOf(en_hr);
				s_st_min = startDateTime.substring(startDateTime.lastIndexOf(":")+1);
				s_en_min = endDateTime.substring(endDateTime.lastIndexOf(":")+1);
			}
			title="30 mins";
		}
		String timelineTitle = mappingInfo.getTextDescription("monitor.dashboard.Showing data for");	
				
		if(!(timeSelect.indexOf("any")>-1))
			timelineTitle += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeSelect;
		else {
			timelineTitle += mappingInfo.getTextDescription("monitor.dashboard.From");
			timelineTitle += " "+selectedDate.substring(selectedDate.indexOf(" ")+1,selectedDate.indexOf("|"));
			timelineTitle += " "+mappingInfo.getTextDescription("monitor.dashboard.To");
			timelineTitle += " "+selectedDate.substring(selectedDate.indexOf("|")+1)+"'";
		}
		rootJson.put("timelineTitle",timelineTitle);
		String interfaceEntries = iniobj.getValue(compType,"Netflow_Interface_Linecharts");
		
		if(interfaceEntries!=null && interfaceEntries.length() > 0)
		{
			String infosToArea=request.getParameter("infosToArea");
			infosToArea = StringUtils.decodeSecurityChar(infosToArea);
			StringBuffer tmpBuffer=new StringBuffer();
			if(infosToArea!=null && !infosToArea.equals(""))
			{
				StringTokenizer stt=new StringTokenizer(infosToArea,",");
				
				while(stt.hasMoreTokens())
				{
					String tok=stt.nextToken();
					tok=tok.trim();
					if(!tok.startsWith("+"))
						tok="+"+tok;
					tmpBuffer.append(tok);
					if(stt.hasMoreTokens())
						tmpBuffer.append(",");
				}
			}
			infosToArea=tmpBuffer.toString();
			StringTokenizer stoken=new StringTokenizer(interfaceEntries,",");
			double defaultTableWidth=940;
			double tableWidth=910;
			double tableWidth1024PxInPercent=defaultTableWidth/1024;
			tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
			tableWidth=MathUtils.round(tableWidth,0);
			String tblWidth=Double.toString(tableWidth);
			int cnt=0; 
			boolean isFullView=false;
			boolean isDisabled=false;
			ArrayList pieChartNAList = new ArrayList();

			while(stoken.hasMoreTokens())
			{		
				JSONObject chartObj=new JSONObject();
				String testMeasure=stoken.nextToken();
				String interface_test="";
				String interface_measure="";
				String msmthost="";
				String unit="";
				String mappingName="";
				boolean isExcludedTest = false;
				if(testMeasure!=null && testMeasure.indexOf("&")>0)
				{
					StringTokenizer token = new StringTokenizer(testMeasure,"&");
					while(token.hasMoreTokens())
					{
						String testAndMeasure = (String)token.nextToken();
						interface_test=testAndMeasure.substring(0,testAndMeasure.indexOf(":"));
						
						if(getExcludedTest != null && getExcludedTest.contains(interface_test))
							isExcludedTest = true;

						interface_measure +=testAndMeasure.substring(testAndMeasure.indexOf(":")+1)+",";

						unit=tablesInfo.getUnitForMeasure(interface_test,(testAndMeasure.substring(testAndMeasure.indexOf(":")+1)));
						mappingName += iniobj.getValue("Dashboard_TableColumn_mapping",testAndMeasure)+"/";
					}
				}
				else
				{
					interface_test=testMeasure.substring(0,testMeasure.indexOf(":"));
					interface_measure=testMeasure.substring(testMeasure.indexOf(":")+1);

					if(getExcludedTest != null && getExcludedTest.contains(interface_test))
						isExcludedTest = true;

					unit=tablesInfo.getUnitForMeasure(interface_test,interface_measure);
				
					mappingName = iniobj.getValue("Dashboard_TableColumn_mapping",testMeasure);
					
					if(mappingName!=null && mappingName.equals(""))
					{
						mappingName="Band Width Usage";
					}
				}
				if(interface_measure!=null && interface_measure.lastIndexOf(",")>0)
				{
					interface_measure = interface_measure.substring(0,interface_measure.lastIndexOf(","));
				}
				if(mappingName!=null && mappingName.lastIndexOf("/")>0)
				{
					mappingName = mappingName.substring(0,mappingName.lastIndexOf("/"));
				}
				
				
				String s_start_time = s_st_time+" "+ s_st_hr+":"+s_st_min+":00";
				String s_end_time = s_en_time+" "+ s_en_hr+":"+s_en_min+":00";
				String tline = null;				
				String graphFormat = HighChartTimeline.getChartOption(tline,"MM/dd/yyyy HH:mm:ss",s_start_time,s_end_time);
				String TimePeriod = s_st_time+" "+s_st_hr+":"+s_st_min+"|"+s_en_time+" "+s_en_hr+":"+s_en_min;
				String unitMapping = graphUtil.getUnitMapping(unit);
				String titleVal = mappingInfo.getTextDescription("monitor.dashboard."+mappingName);
				if(interface_measure!=null && !interface_measure.equalsIgnoreCase("Availability"))
				{
					titleVal += " ("+unitMapping+")";
				}
				String tmpStartDate = DateUtil.changeDateFormat(s_st_time,"MM/dd/yyyy",userFormat);
				String tmpEndDate = DateUtil.changeDateFormat(s_en_time,"MM/dd/yyyy",userFormat);
				chartObj.put("mappingName",titleVal);
				chartObj.put("Title",titleVal);
				chartObj.put("GRAPH_FORMAT", graphFormat);
				if(timeSelect.indexOf("any")>-1){
					timeSelect = "Any";
				}
				JSONObject tmpObj=new JSONObject();
				tmpObj.put("displayField",timeSelect);
				tmpObj.put("valueField",timeSelect);
				
				chartObj.put("Timeline",tmpObj);
				chartObj.put("startDate", tmpStartDate);
				chartObj.put("startHr", s_st_hr);
				chartObj.put("endDate", tmpEndDate);
				chartObj.put("endHr", s_en_hr);
				chartObj.put("startMin", s_st_min);
				chartObj.put("endMin", s_en_min);
				if(enabledTests!=null && enabledTests.contains(interface_test) && !isExcludedTest )
				{	
					String compTypewithNameAndPort = compType+":"+compName;					
					infosToArea = StringUtils.encodeSecurityChar(infosToArea);	
					String encodeTitleVal = StringUtils.encodeSecurityChar(titleVal);
					String areaChartURL = "/final/servlet/com.egurkha.monitor.CustomTimelineMeasures?chartType="+chartType+"&host="+EgURLEncoder.encode(compName, "UTF-8")+"&comptype="+EgURLEncoder.encode(compType, "UTF-8")+"&descriptors="+EgURLEncoder.encode(infosToArea,"UTF-8")+"&fromDashboard=true&test="+interface_test+"&measure="+interface_measure+"&Timeline="+EgURLEncoder.encode(timeSelect, "UTF-8")+"&TimePeriod="+EgURLEncoder.encode(TimePeriod, "UTF-8")+"&components="+EgURLEncoder.encode(compTypewithNameAndPort, "UTF-8")+"&Title="+EgURLEncoder.encode(encodeTitleVal,"UTF-8")+"&gtype=1&graphFormat="+graphFormat;					
					
					if(areaChartURL!=null && !areaChartURL.equals(""))
					{		
						if(unit.equals("percent"))
							unit="%";
						chartObj.put("Type","area_chart");
						chartObj.put("areaChartURL",areaChartURL);
					}
					else
					{
						pieChartNAList.add(titleVal);					
					}	
					chartObj.put("NoTestMsg","-");
				}
				else
				{
					isDisabled=true;				
					chartObj.put("NoTestMsg",mappingInfo.getTextDescription("monitor.common.Test has been excluded or disabled"+"!"));
					//break;
				}
				cnt++;
				chartArr.add(chartObj);
			}	
			if(!isDisabled && pieChartNAList.size()==cnt)
			{
				String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
				rootJson.put("NoMeasureMsg",NoMeasure);
			}			
		}
		rootJson.put("selectedTimeline",selectedTimelineArray);
		rootJson.put("AREACHART_DATA",chartArr);
	}
	else if(blockType!=null && blockType.equals("Protocols"))
	{
		int interfaceCnt=Integer.parseInt(showInterfaces);
		boolean isfromInterfaceComboChange = false;
		String interfaceToView = request.getParameter("interfaceToView");
		interfaceToView = StringUtils.decodeSecurityChar(interfaceToView);	
		if(interfaceToView == null)
			 interfaceToView = "All";
		String fromInterfaceSeletion = request.getParameter("interfaceSelection");
		if(fromInterfaceSeletion == null)
			fromInterfaceSeletion = "false";
		if(fromInterfaceSeletion!=null && fromInterfaceSeletion.equals("true"))
		{
			if(interfaceToView!=null && !interfaceToView.equals("All"))
			{
				isfromInterfaceComboChange = true;
			}
		}
		ErUtils erutils=new  ErUtils();
		Vector networkInterfaceTestInfos = (Vector)dashboardDAO.getDescriptorsForTest(compName,compType,"NetworkInterfaceTest","custom");
		String timeline = request.getParameter("timeline");		
		if(StringUtils.isNull(timeline))
			timeline = defaultPieGraphDuration;
		String[] timeline_options =new String[] {"30 mins","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","Any"};		
		JSONObject timelineObj = new JSONObject();
		JSONArray timelineArray = new JSONArray();
		timelineObj.put("monitor.dashboard.TimeLine",egMappingInfo.getTextDescription("monitor.dashboard.Timeline"));
		timelineObj.put("method","timelineOnchange");
		JSONArray selectedTimelineArray = new JSONArray();
		for(int e_ctr=0; e_ctr < timeline_options.length;e_ctr++)
		{
			JSONObject timelineCombo = new JSONObject();
			if(timeline!=null && timeline.equals((String)timeline_options[e_ctr]))
			{
				String tempOptions="";
				String tempOptions2="";

				if(timeline.indexOf(" ")>-1)
				{
					tempOptions2=timeline.substring(0,timeline.indexOf(" "))+" ";
					tempOptions=timeline.substring(timeline.indexOf(" ")+1);
				}
				else
				{
					tempOptions=timeline;
				}
				timelineCombo.put("displayField",tempOptions2+egMappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineCombo.put("valueField",timeline);
				selectedTimelineArray.add(timeline);
				timelineArray.add(timelineCombo);
			}
			else
			{
				String tempOptions="";
				String tempOptions2="";

				if(timeline_options[e_ctr].indexOf(" ")>-1)
				{
					tempOptions2=timeline_options[e_ctr].substring(0,timeline_options[e_ctr].indexOf(" "))+" "; tempOptions=timeline_options[e_ctr].substring(timeline_options[e_ctr].indexOf(" ")+1);
				}
				else
				{
					tempOptions=timeline_options[e_ctr];
				}
				timelineCombo.put("displayField",tempOptions2+egMappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineCombo.put("valueField",timeline_options[e_ctr]);
				if(timeline_options[e_ctr].equalsIgnoreCase("Any") && timeline.startsWith("Any")){
					JSONObject selectedTimelineObj = new JSONObject();
					
					String s_st_time = timeline.substring(timeline.indexOf(" ")+1,timeline.indexOf("|")); 
					String stTime = s_st_time.substring(s_st_time.indexOf(" ")+1); 
					s_st_time = s_st_time.substring(0,s_st_time.indexOf(" ")); 
					String[] stTokens = StringUtils.getTokens(stTime, ":");
					if(stTokens.length >0){
						selectedTimelineObj.put("anyStartHr",stTokens[0]);
						selectedTimelineObj.put("anyStartMin",stTokens[1]);
						selectedTimelineObj.put("anyStartSec",stTokens[2]);
					}

					String s_end_time = timeline.substring(timeline.indexOf("|")+1); 
					String endTime = s_end_time.substring(s_end_time.indexOf(" ")+1); 
					s_end_time = s_end_time.substring(0,s_end_time.indexOf(" ")); 
					String[] endTokens = StringUtils.getTokens(endTime, ":");
					if(endTokens.length >0){
						selectedTimelineObj.put("anyEndHr",endTokens[0]);
						selectedTimelineObj.put("anyEndMin",endTokens[1]);
						selectedTimelineObj.put("anyEndSec",endTokens[2]);
					}
					String tmpStartDate = DateUtil.changeDateFormat(s_st_time,"MM/dd/yyyy",userFormat);
					String tmpEndDate = DateUtil.changeDateFormat(s_end_time,"MM/dd/yyyy",userFormat);
					selectedTimelineObj.put("anyStartDate",tmpStartDate);
					selectedTimelineObj.put("anyEndDate",tmpEndDate);
					selectedTimelineArray.add("Any");
					selectedTimelineArray.add(selectedTimelineObj);
					
				}
				timelineArray.add(timelineCombo);
			}			
		}
		timelineObj.put("selectedTimelineCombo",selectedTimelineArray);
				
		timelineObj.put("protocolTimelineComboArray",timelineArray);
		rootJson.put("protocolTimelineCombo",timelineObj);
		
		String timelineTitle = mappingInfo.getTextDescription("monitor.dashboard.Showing data for");	
		if(!(timeline.indexOf("Any")>-1))
			timelineTitle += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline;
		else {
			timelineTitle += mappingInfo.getTextDescription("monitor.dashboard.From");
			timelineTitle += " "+timeline.substring(timeline.indexOf(" ")+1,timeline.indexOf("|"));
			timelineTitle += " "+mappingInfo.getTextDescription("monitor.dashboard.To ");
			timelineTitle += " "+timeline.substring(timeline.indexOf("|")+1)+"'";
		}
		rootJson.put("timelineTitle",timelineTitle);
		String pieTitle = "";	
		ArrayList interfaceToViewList = new ArrayList();
		JSONObject protocolObj=new JSONObject();
		JSONArray protocalArr=new JSONArray();
		JSONArray protocolsInterfaceCombo = new JSONArray();
		double defaultTableWidth=940;
		double tableWidth=910;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);
		String iniData=(String)iniobj.getValue(compType,"Netflow_Protocol_piechart");
		String pieChartConfig=(String)iniobj.getValue(compType,"Netflow_Protocol_piechart_config");
		List pieChartConfigList=new ArrayList();
		if(!StringUtils.isNull(pieChartConfig))
		{
			StringTokenizer stToks = new StringTokenizer(pieChartConfig,",");				
			while(stToks.hasMoreTokens())
			{
				String pieChartMetric=stToks.nextToken();
				pieChartConfigList.add(pieChartMetric);
			}
		}
		//newly added
		String infosToArea=request.getParameter("infosToArea");	
		infosToArea = StringUtils.decodeSecurityChar(infosToArea);
		StringBuffer tmpBuffer=new StringBuffer();
		if(infosToArea!=null && !infosToArea.equals(""))
		{
			StringTokenizer stt=new StringTokenizer(infosToArea,",");			
			while(stt.hasMoreTokens())
			{
				String tok=stt.nextToken();
				tok=tok.trim();
				tok="+"+tok;
				tmpBuffer.append(tok);
				if(stt.hasMoreTokens())
					tmpBuffer.append(",");
			}
		}
		String testWithMeasure ="";
		infosToArea=tmpBuffer.toString();			
			
		if(interfaceToView!=null)
		{
			StringTokenizer stTokens = new StringTokenizer(interfaceToView,",");				
			while(stTokens.hasMoreTokens())
			{
				String token = (String)stTokens.nextToken();
				token = token.trim();
				if(token.equalsIgnoreCase("All"))
					continue;
				interfaceToViewList.add(token);
			}
		}
		String s_test="";
		if(iniData!=null){
			s_test=iniData.substring(0,iniData.indexOf(":"));
		}
		JSONObject gridJson = new JSONObject();
		String infosArea = "";
		
		JSONObject protocolsComboObj = new JSONObject();
		protocolsComboObj.put("displayField",mappingInfo.getTextDescription("monitor.dashboard.All"));
		protocolsComboObj.put("valueField","All");
		protocolsInterfaceCombo.add(protocolsComboObj);

		if(enabledTests!=null && enabledTests.contains(s_test))
		{	
			String protocolTestSeperator = uiIniobj.getValue("TEST_PANEL_SUBTREE",s_test);
			if(iniData!=null)
			{
				StringTokenizer st1=new StringTokenizer(iniData,",");
				while(st1.hasMoreTokens())
				{				
					testWithMeasure=st1.nextToken();	
		
					String msmthost=(String)allMsmtHosts.get(s_test);
					String s_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);

					JSONArray colArr = new JSONArray();
					JSONArray protocolsArr = new JSONArray();					
					Vector testInfos=(Vector)dashboardDAO.getDescriptorsForTest(compName,compType,s_test,"custom");
					if(testInfos!=null)
					{
						TreeSet interfaceSet=new TreeSet();
						Map interfaceSubInfo=new HashMap();
						
						if(interfaceToView!=null && !interfaceToView.equals("All"))
						{
							isfromInterfaceComboChange = true;
						}						

						for(int i=0;i<testInfos.size();i++)
						{
							String interfaces =(String)testInfos.get(i);
							String tmpInterface=interfaces;
							String tmpSubInfo = "";
							if(interfaces!=null && interfaces.indexOf(protocolTestSeperator)>0)
							{
								tmpInterface=interfaces.substring(0,interfaces.indexOf(protocolTestSeperator));
								tmpSubInfo = interfaces;
							}
							if(interfaceSubInfo!=null && interfaceSubInfo.containsKey(tmpInterface))
							{
								List existingList=(ArrayList)interfaceSubInfo.get(tmpInterface);
								existingList.add(tmpSubInfo);
								interfaceSubInfo.put(tmpInterface,existingList);
							}
							else
							{
								List valueList=new ArrayList();
								valueList.add(tmpSubInfo);
								if(tmpSubInfo != null && !tmpSubInfo.equals("")){
									interfaceSubInfo.put(tmpInterface,valueList);
								}
								else{
									continue;
								}
							}
							if(interfaceSet.contains(tmpInterface))
								continue;
							/*boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,s_test,msmthost,interfaces);
							if(isTestExceededCutOffFactor)
							{
								continue;
							}*/
							interfaceSet.add(tmpInterface);	
							
							protocolsComboObj = new JSONObject();
							protocolsComboObj.put("displayField",com.egurkha.util.StringUtils.replace(tmpInterface, "+", ""));
							protocolsComboObj.put("valueField",com.egurkha.util.StringUtils.replace(tmpInterface, "+", ""));
							protocolsInterfaceCombo.add(protocolsComboObj);							
						}	
						
						if(interfaceToView!=null)
						{
							rootJson.put("selectedInterfaceCombo",com.egurkha.util.StringUtils.replace(interfaceToView, "+", ""));	
						}
						else
						{
							rootJson.put("selectedInterfaceCombo","All");
						}
						
						rootJson.put("isfromInterfaceComboChange",isfromInterfaceComboChange);
						if(interfaceSet.size()>interfaceCnt)
							rootJson.put("isInterfaceCountExceeded","true");
						else
							rootJson.put("isInterfaceCountExceeded","false");
						boolean isSummaryView = false;						
						if(interfaceToView!=null && interfaceToView.equals("All") && interfaceSet.size()>interfaceCnt)
						{
							isSummaryView = true;	
							rootJson.put("showChart","false");

							String SummaryViewEntries=(String)iniobj.getValue(compType,"Netflow_Protocols_Summary_view");
							Object summaryViewDatas[] = dashboardDAO.getSummaryViewForNetflow(hostName,portNo,SummaryViewEntries,msmthost,showVal,timeline,"protocols");			
						
							if(summaryViewDatas!=null && summaryViewDatas.length>0)
							{
								Double totalBytesVal = (Double)summaryViewDatas[0];
								Double totalPacketsVal = (Double)summaryViewDatas[1];
								Double totalInOctectsVal = (Double)summaryViewDatas[2];
								Double totalOutOctectsVal = (Double)summaryViewDatas[3];
								Hashtable protocolData = (Hashtable)summaryViewDatas[4];
								List pieChartList = (ArrayList)summaryViewDatas[5];

								Hashtable valueTable = new Hashtable();

								Vector internalHeaderName=new Vector();
								internalHeaderName.add("Protocols");
								internalHeaderName.add("BYTES");
								internalHeaderName.add("PACKETS");
								//IN_BW=0.01, OUT_TRAFFIC=0.03, TRAFFICRATE=0.06, BYTES=778.18, PACKETS=950, IN_TRAFFIC=0.03, BWUTILIZED=0.02, OUT_BW=0.01
							//	internalHeaderName.add("TRAFFICRATE");
								internalHeaderName.add("IN_TRAFFIC");
								internalHeaderName.add("OUT_TRAFFIC");
								internalHeaderName.add("IN_BW");
								internalHeaderName.add("OUT_BW");
							//	internalHeaderName.add("BWUTILIZED");
								//internalHeaderName.add("In traffic %");
								//internalHeaderName.add("Out traffic %");	

								JSONArray tableColumns = new JSONArray();
								tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.Protocols"));
								tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.Data Flow(GB)"));
								tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.Packets"));
							//	tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.% Traffic"));
								tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.In Traffic"));
								tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.Out Traffic"));
								tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.In Bandwidth"));
								tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.Out Bandwidth"));
							//	tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.Bandwidth"));
								
								if(!isFromGridPage)
								{
									JSONArray tableValArr = new JSONArray();
									Iterator iter=protocolData.keySet().iterator();
									ArrayList comparisonViewData = new ArrayList();
									TreeMap valueMap=new TreeMap();
									while(iter.hasNext())								
									{
										JSONObject rowJson = new JSONObject();
										int colIdx = 0;
										String protocol=(String)iter.next();										
										
										valueTable = (Hashtable)protocolData.get(protocol);
										rowJson.put("COLUMVal_0",protocol);

				
										//Iterator iterVal=valueTable.keySet().iterator();									
										for(int k=1;k<internalHeaderName.size();k++)
										{
											String keyVal = (String)internalHeaderName.get(k);
											//String keyVal = (String)valueTable.get();
											if(keyVal!=null && keyVal.equalsIgnoreCase("Protocols"))
											{
												continue;
											}
											String value = (String)valueTable.get(keyVal);										
											
											if(value!=null && value.startsWith("-"))
											{
												value=iniui.getValue("MEASURE_LOOKUP",value);
												if(value!=null && value.indexOf(":")>0)
												{
													value=value.substring(value.indexOf(":")+1,value.length());
												}
											}
											if(value!=null && (value.equalsIgnoreCase("NS") || value.equalsIgnoreCase("NAP") || value.equalsIgnoreCase("UN") || value.equalsIgnoreCase("UL")))
											{
												value="NA";
											}
											//String value = "";
											if(keyVal!=null && keyVal.equalsIgnoreCase("BYTES"))
											{
												value = (String)valueTable.get("BYTES");											
												double bytesInGB = Double.parseDouble(value)/(1024*1024);
												value = String.valueOf(bytesInGB);
												value = erutils.round (Double.parseDouble(value),4);
												comparisonViewData.add(protocol);
												comparisonViewData.add(value);
											}
											if(value==null)
											{
												value="NA";
											}

											/*else if(k == 3)
											{		
												String Bytesvalue = (String)valueTable.get("BYTES");											
												if(totalBytesVal!=null){
													double trafficPercent = (Double.parseDouble(Bytesvalue)/totalBytesVal)*100;
													value = String.valueOf(trafficPercent);
													value=erutils.round (Double.parseDouble(value),4);
												}
												else {
													value = "-";
												}
											}*/
											/*else if(k == 4)
											{
												String inOctectsVal = (String)valueTable.get("INOCTETS");											
												if(totalInOctectsVal!=null){
													double percentInTraffic = (Double.parseDouble(inOctectsVal)/totalInOctectsVal)*100;
													value = String.valueOf(percentInTraffic);
													value=erutils.round (Double.parseDouble(value),4);
												}
												else {
													value = "-";
												}
											}
											else if(k == 5)
											{
												String outOctectsVal = (String)valueTable.get("OUTOCTETS");											
												if(totalOutOctectsVal!=null){
													double percentOutTraffic = (Double.parseDouble(outOctectsVal)/totalOutOctectsVal)*100;
													value = String.valueOf(percentOutTraffic);
													value=erutils.round (Double.parseDouble(value),4);
												}
												else {
													value = "-";
												}
											}*/
											
											rowJson.put("COLUMVal_"+k,value);

											if(keyVal!=null && (keyVal.equalsIgnoreCase("IN_TRAFFIC") || keyVal.equalsIgnoreCase("OUT_TRAFFIC")))
											{
												if(value!=null && value.startsWith("-"))
												{
													value=iniui.getValue("MEASURE_LOOKUP",value);
													if(value!=null && value.indexOf(":")>0)
													{
														value=value.substring(value.indexOf(":")+1,value.length());
													}
												}
												if(value!=null && (value.equalsIgnoreCase("NS") || value.equalsIgnoreCase("NAP") || value.equalsIgnoreCase("UN") || value.equalsIgnoreCase("UL")))
												{
													value="NA";
												}
												if(value !=null &&!value.equalsIgnoreCase("NA") && value.length()>0){
													List valueList=(ArrayList)valueMap.get(keyVal);
													if(valueList==null)
													{
														valueList=new ArrayList();
														valueList.add(protocol);
														valueList.add(value);
														valueMap.put(keyVal,valueList);
													}
													else
													{
														valueList.add(protocol);
														valueList.add(value);
														valueMap.put(keyVal,valueList);
													}
												}
											}
										}
										tableValArr.add(rowJson);
									}

									JSONObject tableDataObj = new JSONObject();
									if(tableValArr!=null && tableValArr.size()>0)
									{
										JSONArray sortedJsonArray = new JSONArray();
										Collections.sort( tableValArr, new Comparator<JSONObject>() {
																					
											public int compare(JSONObject a, JSONObject b) {
												double valA =0.0;
												double valB =0.0;

												try {
													String value1 = (String) a.get("COLUMVal_1");
													String value2 = (String) b.get("COLUMVal_1");
													if(!value1.equals("-") && !value1.equals("NA")){
														valA = Double.parseDouble(value1);
													}
													if(!value2.equals("-") && !value2.equals("NA")){
														valB = Double.parseDouble(value2);
													}
												} 
												catch (JSONException e) {
													//do something
												}
												return Double.compare(valA, valB);
											}
										});
										Collections.sort( tableValArr, new Comparator<JSONObject>() {
																		
											public int compare(JSONObject a, JSONObject b) {
												double valA =0.0;
												double valB =0.0;

												try {
													String value1 = (String) a.get("COLUMVal_3");
													String value2 = (String) b.get("COLUMVal_3");
													if(!value1.equals("-") && !value1.equals("NA")){
														valA = Double.parseDouble(value1);
													}
													if(!value2.equals("-") && !value2.equals("NA")){
														valB = Double.parseDouble(value2);
													}
												} 
												catch (JSONException e) {
													//do something
												}
												return Double.compare(valA, valB);
											}
										});
										for (int i = tableValArr.size()-1; i > -1 ; i--) {
											sortedJsonArray.add(tableValArr.get(i));
											if(!showVal.equalsIgnoreCase("All")){
												String tempPriority=showVal.substring(showVal.indexOf("-")+2);
												int priority = Integer.parseInt(tempPriority);
												if(sortedJsonArray.size()== priority){
													break;
												}
											}
										}										
										tableDataObj.put("tableValues",sortedJsonArray);
										/*tableData.put("errorMsg","-");
										tableData.put("start",20);
										if(showVal.equalsIgnoreCase("All")){
											tableData.put("totalCount",totalRecCount);
										}else{
											tableData.put("totalCount",sortedJsonArray.size());
										}*/
										if(sortedJsonArray!= null){
											if(showVal.equalsIgnoreCase("All")){
												tableDataObj.put("tableValues",sortedJsonArray); 
											}
											else {
												JSONArray sortedJsonArray1 = new JSONArray();
												if(startGridIndex !=null && limitIndex!=null){
													for (int i = startIndex; i < startIndex+limit ; i++) {
														sortedJsonArray1.add(sortedJsonArray.getJSONObject(i));
														if(i+2> sortedJsonArray.size()){
															break;
														}
													}
													tableDataObj.put("tableValues",sortedJsonArray1); 
												}
											}
										}
									}

									JSONArray protocolsSummaryViewArr = new JSONArray();

									if(valueMap!=null && !valueMap.isEmpty())
									{	
										JSONArray protocolsMeasArr = new JSONArray();
										Iterator itr=valueMap.entrySet().iterator();
										while(itr.hasNext())
										{
											Map.Entry mp=(Map.Entry)itr.next();
											if(mp!=null)
											{
												String s_measName=(String)mp.getKey();
												List measValList=(ArrayList)mp.getValue();
												
												if(measValList!=null && !measValList.isEmpty())
												{
													Vector chartAttributes=new Vector();
																					
													chartAttributes.add("decimals='2'");
													chartAttributes.add("enableRotation='1'");
													chartAttributes.add("bgColor='99CCFF,FFFFFF'");
													chartAttributes.add("bgAlpha='0,0'");								
													chartAttributes.add("bgAngle='360'");
													chartAttributes.add("showBorder='0'");
													chartAttributes.add("startingAngle='80'");
													chartAttributes.add("chartLeftMargin ='0'");
													chartAttributes.add("chartTopMargin ='0'");
													chartAttributes.add("chartBottomMargin ='0'");
													chartAttributes.add("chartRightMargin ='0'");
													chartAttributes.add("showToolTipShadow ='1'");
													chartAttributes.add("pieSliceDepth='7'");
													chartAttributes.add("numberSuffix='%'");
													chartAttributes.add("showToolTipShadow ='1'");
													chartAttributes.add("pieOuterFaceAlpha  ='75'");
													chartAttributes.add("pieInnerFaceAlpha  ='100'");
													chartAttributes.add("pieYScale  ='49'");
													chartAttributes.add("smartLineColor  ='BABABA'");
													chartAttributes.add("smartLabelClearance  ='2'");
													chartAttributes.add("captionPadding  ='0'");
													chartAttributes.add("bgSWFAlpha  ='0'");
													chartAttributes.add("enableSmartLabels='1'");
													chartAttributes.add("pieRadius='80'");
													chartAttributes.add("labelDistance='3'");
													chartAttributes.add("isSmartLineSlanted='1'");
													chartAttributes.add("exportEnabled='0'");
													chartAttributes.add("exportAction='download'");
													chartAttributes.add("exportAtClient='0'");
													chartAttributes.add("showPlotBorder='1'");
													chartAttributes.add("plotBorderColor='000000'");
													chartAttributes.add("skipOverlapLabels='0'");
													chartAttributes.add("legendPosition='RIGHT'");
													chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
															
													String layerName=dashboardDAO.getLayerForTest(compType,s_test,s_measName);
													String compTypeForAlarm=compType;
													if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
														compTypeForAlarm="Host_system";
												//	String measureState=model.getTestMeasureState(compName,compTypeForAlarm,layerName,s_test+"-"+key,s_measName);
													ArrayList compList = new ArrayList();
													compList.add(compName);
													compList.add(compType);
													compList.add(compTypeForAlarm);
													compList.add(layerName);
													compList.add("");
													compList.add(s_test);
													compList.add(s_measName);
													compList.add(msmthost);
													String xml=(String)graphUtil.getXMLtoProtocol(measValList,chartAttributes);
														//xml="";
													JSONObject protocolsDataObj=new JSONObject();
													if(xml!=null && !xml.equals(""))
													{									
													//	protocolsDataObj.put("Interface",com.egurkha.util.StringUtils.replace(key, "+", ""));
														protocolsDataObj.put("XML_DATA",xml);							
														protocolsDataObj.put("width","400");
														protocolsDataObj.put("height","140"); 
														protocolsDataObj.put("SWF_PATH","/final/FusionCharts/swf/Pie3D.swf");
													}
													//protocolsDataObj.put("Measure_Name",s_measName);
													String dispKey=mappingInfo.getMeasureDescription(s_test,s_measName);
													protocolsDataObj.put("TITLE",dispKey);
													protocolsMeasArr.add(protocolsDataObj);
												}
											}
										}
										protocolsSummaryViewArr=protocolsMeasArr;
									}
									
									tableDataObj.put("tableColumns",tableColumns);
									//tableData.put("tableValues",tableValArr);	
									rootJson.put("tableData",tableDataObj);
								
									
									if(protocolsSummaryViewArr!= null && protocolsSummaryViewArr.size() == 0)
									{
										JSONObject protocolsObj=new JSONObject();
										String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
										if(!(timeline.indexOf("Any")>-1)){
											NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for ");
											NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
										}
										protocolsObj.put("NOMSG",NoMeasure);
										protocolsSummaryViewArr.add(protocolsObj);
									}
									rootJson.put("pieChart",protocolsSummaryViewArr);
									String tmpInterfaceToView = interfaceToView;
									if(tmpInterfaceToView.equalsIgnoreCase("all")){
										tmpInterfaceToView = mappingInfo.getTextDescription("monitor.dashboard.All interfaces");
									}
									rootJson.put("pieTitle",(showTitle+" "+mappingInfo.getTextDescription("monitor.dashboard.Applications by % of Traffic")+" - "+ tmpInterfaceToView));
									rootJson.put("barTitle",(showTitle+" "+mappingInfo.getTextDescription("monitor.dashboard.Applications by Data Flow(GB)")+" - "+ tmpInterfaceToView));
									
									rootJson.put("TABLE_TITLE",(mappingInfo.getTextDescription("monitor.dashboard.Details of")+" "+showTitle+" "+mappingInfo.getTextDescription("monitor.dashboard.Application/Protocols by Data Flow (GB)")+" - "+ tmpInterfaceToView));
									rootJson.put("Data","true");
									rootJson.put("fromView","SummaryView");
									
									String fontForLanguage="verdana";
									String fontSize="7.5";
									boolean isNonEnglishLanguage=((EgDbInfo.doubleByteEnabled && !trackerLanguage.equals("en_US")) || !trackerLanguage.equals("en_US"));

									if(isNonEnglishLanguage)
									{
											fontForLanguage=iniUI.getFontName();
											fontSize="12";
									}

									Vector comparionChartAttribute=new Vector();
									//comparionChartAttribute.add("caption='"+EgURLEncoder.encode(measureMapping+"("+unit+")","UTF-8")+"'");
									//comparionChartAttribute.add("caption='"+measureMapping+" ("+unit+")"+"'");
									comparionChartAttribute.add("palette='2'");
									comparionChartAttribute.add("showValues='1'");
									comparionChartAttribute.add("showLabels='1'");
									comparionChartAttribute.add("showYAxisValues='0'");
									comparionChartAttribute.add("formatNumberScale='0'");
									comparionChartAttribute.add("useRoundEdges='1'");
									//comparionChartAttribute.add("clickURL='javascript:comparisionBarOnclick(&apos;bar"+i+"&apos;)'");	
									//comparionChartAttribute.add("clickURL='javascript:comparisionBarOnclick(&apos;bar"+i+"&apos;)'");	
									comparionChartAttribute.add("bgColor='ffffff'");
									comparionChartAttribute.add("showToolTipShadow='1'");
									comparionChartAttribute.add("chartLeftMargin='8'");
									comparionChartAttribute.add("chartRightMargin='8'");
									comparionChartAttribute.add("chartTopMargin='8'");
									comparionChartAttribute.add("chartBottomMargin='8'");
									comparionChartAttribute.add("exportEnabled='0'");
									comparionChartAttribute.add("exportAction='download'");
									comparionChartAttribute.add("exportAtClient='0'");
									comparionChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
								//	comparionChartAttribute.add("outCnvBaseFontSize='"+fontSize+"'");
									if(!isNonEnglishLanguage)
									{
										comparionChartAttribute.add("outCnvBaseFontSize='"+fontSize+"'");
										comparionChartAttribute.add("outCnvBaseFontColor ='000000'");
									}
									comparionChartAttribute.add("showBorder ='0'");
									comparionChartAttribute.add("canvasBorderColor  ='000000'");
									comparionChartAttribute.add("plotSpacePercent  ='40'");
									comparionChartAttribute.add("baseFont  ='"+fontForLanguage+"'");
									comparionChartAttribute.add("adjustDiv='1'");
									comparionChartAttribute.add("yAxisValueDecimals='2'");
									comparionChartAttribute.add("decimals='4'");
									comparionChartAttribute.add("placeValuesInside='0'");

									Map comparisonMap = new TreeMap();
									for(int i=0;i<comparisonViewData.size();i+=2)
									{
										String protocol = (String)comparisonViewData.get(i);
										String value = (String)comparisonViewData.get(i+1);
										comparisonMap.put(protocol,new Double(value));
									}
									comparisonMap=sortByValues(comparisonMap);
									String comparisonXml="";									
									comparisonXml=(String)graphUtil.getXMLforNetflowComparison(comparionChartAttribute,comparisonMap);
									
									JSONObject comparisonChartsObj = new JSONObject();
									if(comparisonMap!=null && comparisonMap.size()>0)
									{
										if(comparisonXml!=null && comparisonXml.trim().length()>0)
										{
											comparisonChartsObj.put("SWF_PATH", "/final/FusionCharts/swf/Bar2D.swf");
											comparisonChartsObj.put("XML_DATA", comparisonXml);
										}
										else
										{
											String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
											if(!(timeline.indexOf("Any")>-1)){
												NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for ");
												NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
											}
											comparisonChartsObj.put("NoMeasure",NoMeasure);
										}
									}
									else
									{
										String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
										if(!(timeline.indexOf("Any")>-1)){
											NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for ");
											NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
										}
										comparisonChartsObj.put("NoMeasure",NoMeasure);
									}
									rootJson.put("comparisonCharts",comparisonChartsObj);
								}
								if(isFromGridPage)
								{
									Integer totalRecCount = new Integer(0);
									List<JSONObject> jsonValues = new ArrayList<JSONObject>();
									Iterator iter=protocolData.keySet().iterator();
									while(iter.hasNext())								
									{
										JSONObject rowJson = new JSONObject();
										int colIdx = 0;
										String protocol=(String)iter.next();
										valueTable = (Hashtable)protocolData.get(protocol);
										rowJson.put("COLUMVal_"+(colIdx++),protocol);
										
										Iterator iterVal=valueTable.keySet().iterator();									
										for(int k=1;k<internalHeaderName.size();k++)
										{
											String value = "";
											
											if(k == 1)
											{
												value = (String)valueTable.get("BYTES");											
												double bytesInGB = Double.parseDouble(value)/(1024*1024);
												value = String.valueOf(bytesInGB);
												value = erutils.round (Double.parseDouble(value),4);
											}
											else if(k == 2)
											{
												value = (String)valueTable.get("PACKETS");
											}
											else
											{
												String colNam=(String)internalHeaderName.get(k);
												value = (String)valueTable.get(colNam);
											}
										/*	else if(k == 3)
											{		
												String Bytesvalue = (String)valueTable.get("BYTES");											
												if(totalBytesVal!=null){
													double trafficPercent = (Double.parseDouble(Bytesvalue)/totalBytesVal)*100;
													value = String.valueOf(trafficPercent);
													value=erutils.round (Double.parseDouble(value),4);
												}
												else {
													value = "-";
												}
											}*/
											rowJson.put("COLUMVal_"+(colIdx++),value);	
										}
										jsonValues.add(rowJson);
									}
									if(jsonValues!=null && jsonValues.size()>0)
									{
										JSONArray sortedJsonArray = new JSONArray();
										Collections.sort( jsonValues, new Comparator<JSONObject>() {
																					
											public int compare(JSONObject a, JSONObject b) {
												double valA =0.0;
												double valB =0.0;

												try {
													String value1 = (String) a.get("COLUMVal_1");
													String value2 = (String) b.get("COLUMVal_1");
													if(!value1.equals("-") && !value1.equals("NA")){
														valA = Double.parseDouble(value1);
													}
													if(!value2.equals("-") && !value2.equals("NA")){
														valB = Double.parseDouble(value2);
													}
												} 
												catch (JSONException e) {
													//do something
												}
												return Double.compare(valA, valB);
											}
										});
										Collections.sort( jsonValues, new Comparator<JSONObject>() {
																		
											public int compare(JSONObject a, JSONObject b) {
												double valA =0.0;
												double valB =0.0;

												try {
													String value1 = (String) a.get("COLUMVal_3");
													String value2 = (String) b.get("COLUMVal_3");
													if(!value1.equals("-") && !value1.equals("NA")){
														valA = Double.parseDouble(value1);
													}
													if(!value2.equals("-") && !value2.equals("NA")){
														valB = Double.parseDouble(value2);
													}
												} 
												catch (JSONException e) {
													//do something
												}
												return Double.compare(valA, valB);
											}
										});
										for (int i = jsonValues.size()-1; i > -1 ; i--) {
											sortedJsonArray.add(jsonValues.get(i));
											if(!showVal.equalsIgnoreCase("All")){
												String tempPriority=showVal.substring(showVal.indexOf("-")+2);
												int priority = Integer.parseInt(tempPriority);
												if(sortedJsonArray.size()== priority){
													break;
												}
											}
										}
										gridJson.put("tableColumns",colArr);
										rootJson.put("gridValues",sortedJsonArray);
										gridJson.put("errorMsg","-");
										rootJson.put("start",20);
										if(showVal.equalsIgnoreCase("All")){
											rootJson.put("totalCount",totalRecCount);
										}else{
											rootJson.put("totalCount",sortedJsonArray.size());
										}
										if(sortedJsonArray!= null){
											if(showVal.equalsIgnoreCase("All")){
												rootJson.put("gridValues",sortedJsonArray); 
											}
											else {
												JSONArray sortedJsonArray1 = new JSONArray();
												if(startGridIndex !=null && limitIndex!=null){
													for (int i = startIndex; i < startIndex+limit ; i++) {
														sortedJsonArray1.add(sortedJsonArray.getJSONObject(i));
														if(i+2> sortedJsonArray.size()){
															break;
														}
													}
													rootJson.put("gridValues",sortedJsonArray1); 
												}
											}
										}
									}
									String tmpInterfaceToView = interfaceToView;
									if(tmpInterfaceToView.equalsIgnoreCase("all")){
										tmpInterfaceToView = mappingInfo.getTextDescription("monitor.dashboard.All interfaces");
									}
							
									rootJson.put("TABLE_TITLE",(mappingInfo.getTextDescription("monitor.dashboard.Details of")+" "+showTitle+mappingInfo.getTextDescription("monitor.dashboard.Application/Protocols by Data Flow (GB)")+" - "+ tmpInterfaceToView));
								}
							}
							else
							{
								String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
								
								if(!(timeline.indexOf("Any")>-1)){
									NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for");
									NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
								}
								rootJson.put("Data","false");
								rootJson.put("NoMeasureMsg",NoMeasure);
							}
						}
						else
						{														
							if(interfaceSet!=null && !interfaceSet.isEmpty())
							{
								//----------------> grid start---------------------------
								String iniTables=(String)iniobj.getValue(compType,"Netflow_Protocol_table");
								List<JSONObject> jsonValues = new ArrayList<JSONObject>();
								if(iniTables!=null && iniTables.length()>0)
								{										
									ArrayList testWithMeasuresList=new ArrayList();
									ArrayList measuresList=new ArrayList();
									Vector header=new Vector();
									Vector internalHeaderName=new Vector();
									Vector units=new Vector();
									//--------------> table header start -------------------->
									StringTokenizer st=new StringTokenizer(iniTables,",");
									String[] names={mappingInfo.getTextDescription("monitor.dashboard.Application/Protocols")};
									units.add("-");
									StringBuffer measureColumn=new StringBuffer();
									String fullviewTest="";
									String fullviewMsmtHost="";
									String interfaceCount_fullview="";
									int tableCount=0;
									int headerCount=0;
									int j=0;
									while(st.hasMoreTokens())
									{	
										String testMeasures=(String)st.nextToken();	
										String headerName=(String)iniobj.getValue("Dashboard_TableColumn_mapping",testMeasures);
										String testname=testMeasures.substring(0,testMeasures.indexOf(":"));
										String measurename=testMeasures.substring(testMeasures.indexOf(":")+1);
										String measureForDB=dbinfo.getColumnForMeasure(testname,measurename);
										String unit=tablesInfo.getUnitForMeasure(testname,measurename);
										String msmt_host=(String)allMsmtHosts.get(testname);
										
										testWithMeasuresList.add(testMeasures);
										measuresList.add(measurename);
										fullviewTest=testname;
										fullviewMsmtHost=msmt_host;
										measureColumn.append(measureForDB);
										if(st.hasMoreTokens())
											measureColumn.append(",");																	
										if(tableCount==0)
										{
											header.add(names[j]);
											internalHeaderName.add(names[j]);
										}
										header.add(headerName);	
										units.add(unit);
										internalHeaderName.add(measurename);									
										tableCount++;
										headerCount++;
										j++;
									}
									
									JSONObject ColObj = new JSONObject();
								
									for(int k=0;k<header.size();k++)
									{
										ColObj = new JSONObject();
										String h_unit=(String)units.get(k);
										if(h_unit.equals("-"))
											h_unit="";
										
										String colVal = (String)header.get(k);
										if(k==0)
										{
											colArr.add(colVal.toUpperCase());
											colArr.add(mappingInfo.getTextDescription("monitor.dashboard.INTERFACE"));
											String title = mappingInfo.getTextDescription("monitor.dashboard.Details of")+" "+showTitle+" "+colVal+" "+mappingInfo.getTextDescription("monitor.dashboard.by Data Flow (GB)");
											pieTitle = showTitle+" "+colVal+" "+mappingInfo.getTextDescription("monitor.dashboard.by % of Traffic");	
											String tmpInterfaceToView = interfaceToView;
											if(tmpInterfaceToView!=null && tmpInterfaceToView.equalsIgnoreCase("all")){
												tmpInterfaceToView = mappingInfo.getTextDescription("monitor.dashboard.All interfaces");
											}
											if(tmpInterfaceToView!=null){
												title +=" - "+ tmpInterfaceToView;
												pieTitle +=" - "+ tmpInterfaceToView;
											}
											else {
												title +=" - "+mappingInfo.getTextDescription("monitor.dashboard.All interfaces");
												pieTitle +=" - "+mappingInfo.getTextDescription("monitor.dashboard.All interfaces");
											}
											gridJson.put("TABLE_TITLE",title);
										}
										else if(k==1)
										{
											colArr.add(mappingInfo.getTextDescription("monitor.dashboard."+(String)header.get(k))+" ("+mappingInfo.getTextDescription("monitor.dashboard.GB")+")");
										}
										else
										{
											String unitMapping = graphUtil.getUnitMapping(h_unit);
											colArr.add(mappingInfo.getTextDescription("monitor.dashboard."+(String)header.get(k))+" ("+unitMapping+")");
										}					
									}
									//--------------> table header end-----------------------------
									
									Iterator iterator = interfaceSet.iterator();
									String testMeasure = (String)testWithMeasuresList.get(0);
									String testForUnit = testMeasure.substring(0,testMeasure.indexOf(":"));
									String measureForUnit = testMeasure.substring(testMeasure.indexOf(":")+1);
									String unit=tablesInfo.getUnitForMeasure(testForUnit,measureForUnit);
									boolean allowNegativeValues=testInfo.getAllowNegativeValues(testForUnit,measureForUnit);
									if(!isFromGridPage){
										Object currentValuesForinfos[] = new Object[3];
										Hashtable currentValues= new Hashtable();
										ArrayList infosList= new ArrayList();
										while (iterator.hasNext())
										{							
											String infoToPie=(String)iterator.next();
											if(interfaceToViewList!=null && !interfaceToViewList.isEmpty())
											{
												String tmpinfoToPie = infoToPie;
												tmpinfoToPie =tmpinfoToPie.substring(1);;
												if(!interfaceToViewList.contains(tmpinfoToPie))
													continue;
											}

											ArrayList subInfo1 = (ArrayList)interfaceSubInfo.get(infoToPie);
											if(subInfo1==null ){
												continue;
											}
											currentValuesForinfos = dashboardDAO.getTopInfosForTest(hostName,portNo,testWithMeasuresList,msmthost,infoToPie,showVal,timeline,"protocols",true);
											currentValues=(Hashtable)currentValuesForinfos[0];			
											infosList=(ArrayList)currentValuesForinfos[1];
											
											Double totalBytes=(Double)currentValuesForinfos[2];
											TreeMap valueMap=new TreeMap();	
											double BWMaxValue = 0.0;
											if(currentValues!=null && !currentValues.isEmpty() && infosList!=null && infosList.size()>0)
											{	
												String comboInfo = (String)infosList.get(0);
												if(comboInfo != null && protocolTestSeperator != null && comboInfo.indexOf(protocolTestSeperator)>0){
													comboInfo = comboInfo.substring(comboInfo.indexOf("+")+1,comboInfo.indexOf(protocolTestSeperator));
												}
												if(interfaceToViewList!=null && !interfaceToViewList.isEmpty())
												{
													if(!interfaceToViewList.contains(comboInfo))
														continue;
												}
												Iterator iter=infosList.iterator();												
												int m=0;	
												Hashtable valueTable = new Hashtable();
												while(iter.hasNext())
												{
													String key=(String)iter.next();	
													valueTable = (Hashtable)currentValues.get(key);

													String info ="", subInfo = "";
													if(key != null && protocolTestSeperator !=null && key.indexOf(protocolTestSeperator)>0)
													{
														info = key.substring(0,key.indexOf(protocolTestSeperator));
														subInfo = key.substring(key.indexOf(protocolTestSeperator)+1);	
													}
													if(subInfo!=null && subInfo.indexOf(protocolTestSeperator)>-1)
													{
														subInfo = subInfo.substring(subInfo.indexOf(protocolTestSeperator)+1);
													}
													/* if(valueMap!=null && valueMap.containsKey(info))
													{
														List existingList=(ArrayList)valueMap.get(info);
														//if(existingList.size()>1800)
														//	break;
													}*/
													//String InterfaceSpeedVal = (String)dashboardDAO.getCurrentMeasure(hostName,portNo,info,"NetworkInterfaceTest","Speed",msmthost,"","");
													for(int k=1;k<internalHeaderName.size();k++)
													{
														boolean isMeasureExists = false;
														String columnName = (String)internalHeaderName.get(k);
														if(valueMap!=null && valueMap.containsKey(info))
														{
														        Hashtable measMap=(Hashtable)valueMap.get(info);
															if(measMap!=null && !measMap.isEmpty())
															{
																List existingList=(ArrayList)measMap.get(columnName);
																if(existingList!=null && existingList.size()>1800)
																	break;
															}
														}

														String value = (String)valueTable.get(columnName);
														
														if(k==1 && pieChartConfigList.contains((s_test+":"+columnName)))
														{
															if(value!=null){
																isMeasureExists = true;
																double bytesInGB = Double.parseDouble(value)/(1024*1024);
																value = String.valueOf(bytesInGB);
																value = erutils.round (Double.parseDouble(value),4);
															}
														}
													/*	else if(k==3 && s_measure.equalsIgnoreCase(columnName))
														{
															isMeasureExists = true;
															columnName = (String)internalHeaderName.get(1);
															value = (String)valueTable.get(columnName);
															if(value!=null)
															{
																if(totalBytes!=null){
																	double trafficPercent = (Double.parseDouble(value)/totalBytes)*100;
																	value = String.valueOf(trafficPercent);
																	value=erutils.round (Double.parseDouble(value),4);
																}
																else {
																	value = "-";
																}
															}
														}
														else if(k==4 && s_measure.equalsIgnoreCase(columnName))
														{
															isMeasureExists = true;
															columnName = (String)internalHeaderName.get(1);
															value = (String)valueTable.get(columnName);
																												
															double kilobits = Double.parseDouble(value)*8;	
															long timelineInSec = (long) dashboardDAO.getTimelineInSeconds(timeline);
															double kilobitsPerSec = kilobits/timelineInSec;	
															if(networkInterfaceTestInfos!=null && networkInterfaceTestInfos.contains(info))
															{
																if(!InterfaceSpeedVal.isEmpty())
																{
																	double interfaceVal = Double.parseDouble(InterfaceSpeedVal)*1000;
																	if(value!=null && interfaceVal>0.0)
																	{
																		double BWPercent = (kilobitsPerSec/interfaceVal)*100;
																		value = String.valueOf(BWPercent);
																		value=erutils.round (Double.parseDouble(value),4);
																		if(Double.parseDouble(value)>BWMaxValue)
																			BWMaxValue = Double.parseDouble(value);
																	}
																	else
																		value = "-";
																}
																else
																	value = "-";
															}
															else
																value = "-";
															
														}*/
														else if(pieChartConfigList.contains((s_test+":"+columnName)))
														{
															isMeasureExists = true;
														}
														if(isMeasureExists){
															if(value!=null && value.startsWith("-") && !allowNegativeValues)
															{
																value=iniui.getValue("MEASURE_LOOKUP",value);
																if(value!=null && value.indexOf(":")>0)
																{
																	value=value.substring(value.indexOf(":")+1,value.length());
																}
															}
															if(value!=null && (value.equalsIgnoreCase("NS") || value.equalsIgnoreCase("NAP") || value.equalsIgnoreCase("UN") || value.equalsIgnoreCase("UL")))
															{
																value="NA";
															}
															if(value !=null &&!value.equalsIgnoreCase("NA") && value.length()>0){
																Hashtable measureMap=(Hashtable)valueMap.get(info);
																if(measureMap==null)
																{
																	measureMap=new Hashtable();
																	List valueList=new ArrayList();
																	valueList.add(subInfo);
																	valueList.add(value);
																	measureMap.put(columnName,valueList);
																	valueMap.put(info,measureMap);
																}
																else
																{
																	List measValueList=(ArrayList)measureMap.get(columnName);
																	if(measValueList==null)
																	{
																		measValueList=new ArrayList();
																	}
																	measValueList.add(subInfo);
																	measValueList.add(value);
																	measureMap.put(columnName,measValueList);
																	valueMap.put(info,measureMap);
																}
															}
														}
													}
												}
											}
											if(valueMap!=null && !valueMap.isEmpty())
											{	
												Iterator itr=valueMap.entrySet().iterator();
												while(itr.hasNext())
												{
													Map.Entry mp=(Map.Entry)itr.next();
													if(mp!=null)
													{
														String key=(String)mp.getKey();
														Hashtable measValMap=(Hashtable)mp.getValue();
														JSONObject protocolsObj = new JSONObject();
														if(measValMap!=null && !measValMap.isEmpty())
														{
															Vector chartAttributes=new Vector();
															
																	
															String interFaceName=com.egurkha.util.StringUtils.replace(key, "+", "");
															if(StringUtils.isNull(selectedInterface))
															{
																selectedInterface = "All";	
															}
																							
															chartAttributes.add("decimals='2'");
															chartAttributes.add("enableRotation='1'");
															chartAttributes.add("bgColor='99CCFF,FFFFFF'");
															chartAttributes.add("bgAlpha='0,0'");								
															chartAttributes.add("bgAngle='360'");
															chartAttributes.add("showBorder='0'");
															chartAttributes.add("startingAngle='80'");
															chartAttributes.add("chartLeftMargin ='0'");
															chartAttributes.add("chartTopMargin ='0'");
															chartAttributes.add("chartBottomMargin ='0'");
															chartAttributes.add("chartRightMargin ='0'");
															chartAttributes.add("showToolTipShadow ='1'");
															chartAttributes.add("pieSliceDepth='7'");
															chartAttributes.add("numberSuffix='%'");
															chartAttributes.add("showToolTipShadow ='1'");
															chartAttributes.add("pieOuterFaceAlpha  ='75'");
															chartAttributes.add("pieInnerFaceAlpha  ='100'");
															chartAttributes.add("pieYScale  ='49'");
															chartAttributes.add("smartLineColor  ='BABABA'");
															chartAttributes.add("smartLabelClearance  ='2'");
															chartAttributes.add("captionPadding  ='0'");
															chartAttributes.add("bgSWFAlpha  ='0'");
															chartAttributes.add("enableSmartLabels='1'");
															chartAttributes.add("pieRadius='80'");
															chartAttributes.add("labelDistance='3'");
															chartAttributes.add("isSmartLineSlanted='1'");
															chartAttributes.add("exportEnabled='0'");
															chartAttributes.add("exportAction='download'");
															chartAttributes.add("exportAtClient='0'");
															chartAttributes.add("showPlotBorder='1'");
															chartAttributes.add("plotBorderColor='000000'");
															chartAttributes.add("skipOverlapLabels='0'");
															chartAttributes.add("legendPosition='RIGHT'");
															chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
															Iterator itrMeasValMap=measValMap.entrySet().iterator();
															while(itrMeasValMap.hasNext())
															{
																Map.Entry measMPEntry=(Map.Entry)itrMeasValMap.next();
																if(measMPEntry!=null)
																{
																	String s_measName=(String)measMPEntry.getKey();
																	JSONObject protocolsDataObj = new JSONObject();
																	if(selectedInterface!=null && (interfaceToViewList.contains(interFaceName)))
																	{
																		List valList=(ArrayList)measValMap.get(s_measName);					
																		for(int i=0;i<valList.size();i=i+2)
																		{   
																			String protocol=(String)valList.get(i);
																			for(int m=0;m<testInfos.size();m++)
																			{
																				String interfaces =(String)testInfos.get(m);
																				if(interfaces.indexOf(protocol)>-1 && interfaces.indexOf(key)>-1){
																					infosArea+=interfaces+",";
																				}
																			}
																		}
																	}
																	
																	String layerName=dashboardDAO.getLayerForTest(compType,s_test,s_measName);
																	String compTypeForAlarm=compType;
																	if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
																		compTypeForAlarm="Host_system";
																	String measureState=model.getTestMeasureState(compName,compTypeForAlarm,layerName,s_test+"-"+key,s_measName);
																	ArrayList compList = new ArrayList();
																	compList.add(compName);
																	compList.add(compType);
																	compList.add(compTypeForAlarm);
																	compList.add(layerName);
																	compList.add("");
																	compList.add(s_test);
																	compList.add(s_measName);
																	compList.add(msmthost);
																	String xml=(String)graphUtil.getXMLtoProtocol(s_measName,measValMap,chartAttributes,compList);
																		//xml="";									
																	if(xml!=null && !xml.equals(""))
																	{									
																		protocolsDataObj.put("Interface",com.egurkha.util.StringUtils.replace(key, "+", ""));
																		protocolsDataObj.put("XML_DATA",xml);							
																		protocolsDataObj.put("width","400");
																		protocolsDataObj.put("height","140"); 
																		protocolsDataObj.put("SWF_PATH","/final/FusionCharts/swf/Pie3D.swf");
																	}
																	protocolsObj.put(s_measName,protocolsDataObj);
																	String dispKey=key;
																	if(dispKey!=null && dispKey.indexOf("+")==0)
																	{
																		dispKey=dispKey.substring(1);
																	}
																	protocolsObj.put("info",dispKey);
																}
															}
														}
														protocolsArr.add(protocolsObj);
													}
												}
											}
										}
										if(infosArea!=null && infosArea.indexOf(",")>0)
										{
											infosArea = infosArea.substring(0,infosArea.lastIndexOf(","));	
										}
										if(protocolsArr!= null && protocolsArr.size() == 0){
											JSONObject protocolsObj = new JSONObject();
											String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
											if(!(timeline.indexOf("Any")>-1)){
												NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for");
												NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
											}
											protocolsObj.put("NOMSG",NoMeasure);
											protocolsArr.add(protocolsObj);
											rootJson.put("Data","false");
										}
										else{
											rootJson.put("Data","true");
										}
										rootJson.put("pieChart",protocolsArr);
										rootJson.put("pieTitle",pieTitle);
									}
							
									//---------------->final grid values starting---------------------------
									if(isFromGridPage || allowGrid){
										Integer totalRecCount = new Integer(0);
										ArrayList comparisonViewData = new ArrayList();
										if(showVal.indexOf("TOP")>-1 || showVal.indexOf("LAST")>-1){
											Iterator iterator1 = interfaceSet.iterator();
											
											Object currentValuesForinfos[] = new Object[3];
											Hashtable currentValues= new Hashtable();
											ArrayList infosList= new ArrayList();
											while (iterator1.hasNext())
											{							
												String infoToPie = (String)iterator1.next();
												if(interfaceToViewList!=null && !interfaceToViewList.isEmpty())
												{
													String tmpinfoToPie = infoToPie;
													tmpinfoToPie =tmpinfoToPie.substring(1);;
													if(!interfaceToViewList.contains(tmpinfoToPie))
														continue;
												}
												ArrayList subInfo1 = (ArrayList)interfaceSubInfo.get(infoToPie);
												if(subInfo1 == null){
													continue;
												}												

												currentValuesForinfos = dashboardDAO.getTopInfosForTest(hostName,portNo,testWithMeasuresList,msmthost,infoToPie,showVal,timeline,"protocols",false);

												currentValues=(Hashtable)currentValuesForinfos[0];			
												infosList=(ArrayList)currentValuesForinfos[1];
												
												Double totalBytes=(Double)currentValuesForinfos[2];
												TreeMap valueMap=new TreeMap();	
												double BWMaxValue = 0.0;
												if(currentValues!=null && !currentValues.isEmpty() && infosList!=null && infosList.size()>0)
												{		
													String comboInfo = (String)infosList.get(0);
													if(comboInfo != null && protocolTestSeperator != null && comboInfo.indexOf(protocolTestSeperator)>0){
														comboInfo = comboInfo.substring(comboInfo.indexOf("+")+1,comboInfo.indexOf(protocolTestSeperator));
													}
													if(interfaceToViewList!=null && !interfaceToViewList.isEmpty())
													{
														if(!interfaceToViewList.contains(comboInfo))
															continue;
													}
													Iterator iter=infosList.iterator();
													int m=0;	
													while(iter.hasNext())
													{
														int colIdx = 0;
														JSONObject rowJson = new JSONObject();
														String key=(String)iter.next();												
														Hashtable valueTable = (Hashtable)currentValues.get(key);
														String info ="", subInfo = "";
														if(key != null && protocolTestSeperator !=null && key.indexOf(protocolTestSeperator)>0)
														{
															info = key.substring(0,key.indexOf(protocolTestSeperator));
															subInfo = key.substring(key.indexOf(protocolTestSeperator)+1);	
														}
														if(subInfo!=null && subInfo.indexOf(protocolTestSeperator)>-1)
														{
															subInfo = subInfo.substring(subInfo.indexOf(protocolTestSeperator)+1);
														}
														//infosArea+=info+"!"+subInfo+",";
													
														rowJson.put("COLUMVal_"+(colIdx++),subInfo);
														rowJson.put("COLUMVal_"+(colIdx++),com.egurkha.util.StringUtils.replace(info, "+", ""));
														String InterfaceSpeedVal = (String)dashboardDAO.getCurrentMeasure(hostName,portNo,info,"NetworkInterfaceTest","Speed",msmthost,"","");
														for(int k=1;k<internalHeaderName.size();k++)
														{
															String columnName = (String)internalHeaderName.get(k);
															
															String tmpName =columnName;
															String value = (String)valueTable.get(columnName);
															if(k==1){																
																if(value!=null)
																{
																	double bytesInGB = Double.parseDouble(value)/(1024*1024);
																	value = String.valueOf(bytesInGB);
																	value = erutils.round (Double.parseDouble(value),4);

																	comparisonViewData.add(subInfo);
																	comparisonViewData.add(value);
																}
															}
															/* else if(k==3)
															{
																columnName = (String)internalHeaderName.get(1);
																value = (String)valueTable.get(columnName);
																if(value!=null)
																{
																	if(totalBytes!=null){
																		double trafficPercent = (Double.parseDouble(value)/totalBytes)*100;
																		value = String.valueOf(trafficPercent);
																		value=erutils.round (Double.parseDouble(value),4);
																	}
																	else {
																		value = "-";
																	}
																}
															} */
															if(value!=null && value.startsWith("-") && !allowNegativeValues)
															{
																value=iniui.getValue("MEASURE_LOOKUP",value);
																if(value!=null && value.indexOf(":")>0)
																{
																	value=value.substring(value.indexOf(":")+1,value.length());
																}
																if(value!=null && (value.equalsIgnoreCase("NS") || value.equalsIgnoreCase("NAP") || value.equalsIgnoreCase("UN") || value.equalsIgnoreCase("UL")))
																{
																	value="NA";
																}
															}
														/*	if(k==8)
															{
																System.out.println("k==8---columnName----->"+columnName);
																columnName = (String)internalHeaderName.get(1);
																value = (String)valueTable.get(columnName);
																double kilobits = Double.parseDouble(value)*8;	
																long timelineInSec = (long) dashboardDAO.getTimelineInSeconds(timeline);
																double kilobitsPerSec = kilobits/timelineInSec;	
																if(networkInterfaceTestInfos!=null && networkInterfaceTestInfos.contains(info))
																{
																	if(!InterfaceSpeedVal.isEmpty())
																	{
																		double interfaceVal = Double.parseDouble(InterfaceSpeedVal)*1000;
																		if(value!=null && interfaceVal>0.0)
																		{
																			double BWPercent = (kilobitsPerSec/interfaceVal)*100;
																			value = String.valueOf(BWPercent);
																			value=erutils.round (Double.parseDouble(value),4);
																			if(Double.parseDouble(value)>BWMaxValue)
																				BWMaxValue = Double.parseDouble(value);
																		}
																		else
																			value = "-";
																	}
																	else
																		value = "-";
																}
																else
																	value = "-";
															} */
															if(value!=null){
																rowJson.put("COLUMVal_"+(colIdx++),value);
															}
															else{
																rowJson.put("COLUMVal_"+(colIdx++),"-");
															}
														}
														jsonValues.add(rowJson);
													}											
												}
											}
										}
										/*else{
											ArrayList infoViewList = new ArrayList();
											if(interfaceToViewList!=null && interfaceToViewList.size()>0){
												for(int i=0;i<interfaceToViewList.size();i++)
												{
													String tmpInfo = (String)interfaceToViewList.get(i);
													infoViewList.add("+"+tmpInfo);
												}
											}
											else{
												Iterator iterator1 = interfaceSet.iterator();
												while (iterator1.hasNext())
												{							
													String tmpInfo = (String)iterator1.next();
													infoViewList.add(tmpInfo);
												}
											}
											Object currentValuesForinfos[] = dashboardDAO.getInfosForGrid(hostName,portNo,testWithMeasuresList,msmthost,infoViewList,showVal,timeline,"protocols",startIndex+1,startIndex+limit);
											Hashtable currentValues=(Hashtable)currentValuesForinfos[0];			
											ArrayList infosList=(ArrayList)currentValuesForinfos[1];
											HashMap totalBytesInfo = (HashMap)currentValuesForinfos[2];
											totalRecCount = (Integer)currentValuesForinfos[3];
											double BWMaxValue = 0.0;
											if(currentValues!=null && !currentValues.isEmpty() && infosList!=null && infosList.size()>0)
											{		
												String comboInfo = (String)infosList.get(0);
												if(comboInfo != null && protocolTestSeperator != null && comboInfo.indexOf(protocolTestSeperator)>0){
													comboInfo = comboInfo.substring(comboInfo.indexOf("+")+1,comboInfo.indexOf(protocolTestSeperator));
												}
												Iterator iter=infosList.iterator();
												int m=0;	
												while(iter.hasNext())
												{
													int colIdx = 0;
													JSONObject rowJson = new JSONObject();
													String key=(String)iter.next();												
													Hashtable valueTable = (Hashtable)currentValues.get(key);
													String info ="", subInfo = "";
													if(key != null && protocolTestSeperator !=null && key.indexOf(protocolTestSeperator)>0)
													{
														info = key.substring(0,key.indexOf(protocolTestSeperator));
														subInfo = key.substring(key.indexOf(protocolTestSeperator)+1);	
													}
													if(subInfo!=null && subInfo.indexOf(protocolTestSeperator)>-1)
													{
														subInfo = subInfo.substring(subInfo.indexOf(protocolTestSeperator)+1);
													}
													rowJson.put("COLUMVal_"+(colIdx++),subInfo);
													rowJson.put("COLUMVal_"+(colIdx++),com.egurkha.util.StringUtils.replace(info, "+", ""));
													
													String InterfaceSpeedVal = (String)dashboardDAO.getCurrentMeasure(hostName,portNo,info,"NetworkInterfaceTest","Speed",msmthost,"","");
													for(int k=1;k<internalHeaderName.size();k++)
													{
														String columnName = (String)internalHeaderName.get(k);
														String value = (String)valueTable.get(columnName);
														if(k==1){
															if(value!=null){
																double bytesInGB = Double.parseDouble(value)/(1024*1024);
																value = String.valueOf(bytesInGB);
																value = erutils.round (Double.parseDouble(value),4);
															}
														}
														else if(k==3)
														{
															columnName = (String)internalHeaderName.get(1);
															value = (String)valueTable.get(columnName);
															if(value!=null)
															{
																String total = (String) totalBytesInfo.get(info);
																if(total!=null){
																	double totalBytes= Double.parseDouble(total);
																	double trafficPercent = (Double.parseDouble(value)/totalBytes)*100;
																	value = String.valueOf(trafficPercent);
																	value=erutils.round (Double.parseDouble(value),4);
																}
																else {
																	value = "-";
																}
															}
														}
														if(value!=null && value.startsWith("-") && !allowNegativeValues)
														{
															value=iniui.getValue("MEASURE_LOOKUP",value);
															if(value!=null && value.indexOf(":")>0)
															{
																value=value.substring(value.indexOf(":")+1,value.length());
															}
														}
														if(k==4)
														{
															columnName = (String)internalHeaderName.get(1);
															value = (String)valueTable.get(columnName);
																												
															double kilobits = Double.parseDouble(value)*8;	
															long timelineInSec = (long) dashboardDAO.getTimelineInSeconds(timeline);
															double kilobitsPerSec = kilobits/timelineInSec;	
															if(networkInterfaceTestInfos!=null && networkInterfaceTestInfos.contains(info))
															{
																if(!InterfaceSpeedVal.isEmpty())
																{
																	double interfaceVal = Double.parseDouble(InterfaceSpeedVal)*1000;
																	if(value!=null && interfaceVal>0.0)
																	{
																		double BWPercent = (kilobitsPerSec/interfaceVal)*100;
																		value = String.valueOf(BWPercent);
																		value=erutils.round (Double.parseDouble(value),4);
																		if(Double.parseDouble(value)>BWMaxValue)
																			BWMaxValue = Double.parseDouble(value);
																	}
																	else
																		value = "-";
																}
																else
																	value = "-";
															}
															else
																value = "-";
														}
														if(value!=null){
															rowJson.put("COLUMVal_"+(colIdx++),value);
														}
														else{
															rowJson.put("COLUMVal_"+(colIdx++),"-");
														}
													}
													jsonValues.add(rowJson);
												}											
											}
										}*/
										
										if(jsonValues!=null && jsonValues.size()>0)
										{
											JSONArray sortedJsonArray = new JSONArray();
											Collections.sort( jsonValues, new Comparator<JSONObject>() {
																						
												public int compare(JSONObject a, JSONObject b) {
													double valA =0.0;
													double valB =0.0;

													try {
														String value1 = (String) a.get("COLUMVal_2");
														String value2 = (String) b.get("COLUMVal_2");
														if(!value1.equals("-") && !value1.equals("NA")){
															valA = Double.parseDouble(value1);
														}
														if(!value2.equals("-") && !value2.equals("NA")){
															valB = Double.parseDouble(value2);
														}
													} 
													catch (JSONException e) {
														//do something
													}
													return Double.compare(valA, valB);
												}
											});
											Collections.sort( jsonValues, new Comparator<JSONObject>() {
																			
												public int compare(JSONObject a, JSONObject b) {
													double valA =0.0;
													double valB =0.0;

													try {
														String value1 = (String) a.get("COLUMVal_5");
														String value2 = (String) b.get("COLUMVal_5");
														if(!value1.equals("-") && !value1.equals("NA")){
															valA = Double.parseDouble(value1);
														}
														if(!value2.equals("-") && !value2.equals("NA")){
															valB = Double.parseDouble(value2);
														}
													} 
													catch (JSONException e) {
														//do something
													}
													String subInfoVal = (String) a.get("COLUMVal_1");
													String subInfoVal1 = (String) b.get("COLUMVal_1");
													if(subInfoVal.equalsIgnoreCase("Others") || subInfoVal1.equalsIgnoreCase("Others")){
														if(!subInfoVal.equalsIgnoreCase("Others") && subInfoVal1.equalsIgnoreCase("Others")){
															return 1;
														}
														else if(subInfoVal.equalsIgnoreCase("Others") && !subInfoVal1.equalsIgnoreCase("Others")){
															return -1;
														}
														else{
															return Double.compare(valA, valB);
														}
													}
													else {
														return Double.compare(valA, valB);
													}
												}
											});
											for (int i = jsonValues.size()-1; i > -1 ; i--) {
												sortedJsonArray.add(jsonValues.get(i));
												if(!showVal.equalsIgnoreCase("All")){
													String tempPriority=showVal.substring(showVal.indexOf("-")+2);
													int priority = Integer.parseInt(tempPriority);
													if(sortedJsonArray.size()== priority){
														break;
													}
												}
											}
											gridJson.put("tableColumns",colArr);
											rootJson.put("gridValues",sortedJsonArray);
											gridJson.put("errorMsg","-");
											rootJson.put("start",20);
											if(showVal.equalsIgnoreCase("All")){
												rootJson.put("totalCount",totalRecCount);
											}else{
												rootJson.put("totalCount",sortedJsonArray.size());
											}
											if(sortedJsonArray!= null){
												if(showVal.equalsIgnoreCase("All")){
													rootJson.put("gridValues",sortedJsonArray); 
												}
												else {
													JSONArray sortedJsonArray1 = new JSONArray();
													if(startGridIndex !=null && limitIndex!=null){
														for (int i = startIndex; i < startIndex+limit ; i++) {
															sortedJsonArray1.add(sortedJsonArray.getJSONObject(i));
															if(i+2> sortedJsonArray.size()){
																break;
															}
														}
														rootJson.put("gridValues",sortedJsonArray1); 
													}
												}
											}
										}
										String fontForLanguage="verdana";
										String fontSize="7.5";
										boolean isNonEnglishLanguage=((EgDbInfo.doubleByteEnabled && !trackerLanguage.equals("en_US")) || !trackerLanguage.equals("en_US"));

										if(isNonEnglishLanguage)
										{
												fontForLanguage=iniUI.getFontName();
												fontSize="12";
										}

										Vector comparionChartAttribute=new Vector();
										//comparionChartAttribute.add("caption='"+EgURLEncoder.encode(measureMapping+"("+unit+")","UTF-8")+"'");
										//comparionChartAttribute.add("caption='"+measureMapping+" ("+unit+")"+"'");
										comparionChartAttribute.add("palette='2'");
										comparionChartAttribute.add("showValues='1'");
										comparionChartAttribute.add("showLabels='1'");
										comparionChartAttribute.add("showYAxisValues='0'");
										comparionChartAttribute.add("formatNumberScale='0'");
										comparionChartAttribute.add("useRoundEdges='1'");
										//comparionChartAttribute.add("clickURL='javascript:comparisionBarOnclick(&apos;bar"+i+"&apos;)'");	
										//comparionChartAttribute.add("clickURL='javascript:comparisionBarOnclick(&apos;bar"+i+"&apos;)'");	
										comparionChartAttribute.add("bgColor='ffffff'");
										comparionChartAttribute.add("showToolTipShadow='1'");
										comparionChartAttribute.add("chartLeftMargin='8'");
										comparionChartAttribute.add("chartRightMargin='8'");
										comparionChartAttribute.add("chartTopMargin='8'");
										comparionChartAttribute.add("chartBottomMargin='8'");
										comparionChartAttribute.add("exportEnabled='0'");
										comparionChartAttribute.add("exportAction='download'");
										comparionChartAttribute.add("exportAtClient='0'");
										comparionChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
									//	comparionChartAttribute.add("outCnvBaseFontSize='"+fontSize+"'");
										if(!isNonEnglishLanguage)
										{
											comparionChartAttribute.add("outCnvBaseFontSize='"+fontSize+"'");
											comparionChartAttribute.add("outCnvBaseFontColor ='000000'");
										}
										comparionChartAttribute.add("showBorder ='0'");
										comparionChartAttribute.add("canvasBorderColor  ='000000'");
										comparionChartAttribute.add("plotSpacePercent  ='40'");
										comparionChartAttribute.add("baseFont  ='"+fontForLanguage+"'");
										comparionChartAttribute.add("adjustDiv='1'");
										comparionChartAttribute.add("yAxisValueDecimals='2'");
										comparionChartAttribute.add("decimals='4'");
										comparionChartAttribute.add("placeValuesInside='0'");

										Map comparisonMap = new TreeMap();
										for(int i=0;i<comparisonViewData.size();i+=2)
										{
											String protocol = (String)comparisonViewData.get(i);
											String value = (String)comparisonViewData.get(i+1);
											comparisonMap.put(protocol,new Double(value));
										}
										comparisonMap=sortByValues(comparisonMap);
										String comparisonXml="";									
										comparisonXml=(String)graphUtil.getXMLforNetflowComparison(comparionChartAttribute,comparisonMap);
										
										JSONObject comparisonChartsObj = new JSONObject();
										if(comparisonMap!=null && comparisonMap.size()>0)
										{
											if(comparisonXml!=null && comparisonXml.trim().length()>0)
											{
												comparisonChartsObj.put("SWF_PATH", "/final/FusionCharts/swf/Bar2D.swf");
												comparisonChartsObj.put("XML_DATA", comparisonXml);
											}
											else
											{
												String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
												if(!(timeline.indexOf("Any")>-1)){
													NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for");
													NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
												}
												comparisonChartsObj.put("NoMeasure",NoMeasure);
											}
										}
										else
										{
											String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
											if(!(timeline.indexOf("Any")>-1)){
												NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for");
												NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
											}
											comparisonChartsObj.put("NoMeasure",NoMeasure);
										}
										rootJson.put("comparisonCharts",comparisonChartsObj);
										rootJson.put("barTitle",(showTitle+" "+mappingInfo.getTextDescription("monitor.dashboard.Applications by Data Flow(GB)")+" - "+ interfaceToView));

									}
									if(isfromInterfaceComboChange)
									{
										rootJson.put("showChart","true");
										StringTokenizer stToken = new StringTokenizer(infosArea,",");
										if(!isFromGridPage){
											//---------------->line chart starting ---------------------
											String iniData1=(String)iniobj.getValue(compType,"Netflow_Protocol");
											if(iniData1!=null)
											{
												StringTokenizer st11=new StringTokenizer(iniData1,",");
												while(st11.hasMoreTokens())
												{				
													testWithMeasure=st11.nextToken();
													String st_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
													String st_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
													
													String st_msmthost=(String)allMsmtHosts.get(st_test);
													String url="/final/monitor/EgNetflowDashHelperJSON.jsp?tab="+tab+"&hostName="+hostName+"&compType="+compType+"&subsystem=Overview&blockType=Protocols";						
													String TITLE = showTitle+" "+mappingInfo.getTextDescription("monitor.dashboard.Application/ Protocols by Bandwidth usage (%) distribution");
													if(interfaceToView!=null){
														TITLE +=" - "+ interfaceToView;														
													}
														
													String Interface_TITLE = mappingInfo.getTextDescription("monitor.common.Interface");
													
													protocolObj.put("TITLE",TITLE);
													protocolObj.put("COLUMNAM_0",Interface_TITLE);
													
													String mappingName = iniobj.getValue("Dashboard_TableColumn_mapping",testWithMeasure);	
													int cnt=4;
													String Title=mappingInfo.getTextDescription("monitor.dashboard.Protocol distribution by bandwidth usage ");
													SimpleDateFormat sdf=new SimpleDateFormat("MM/dd/yyyy HH:mm");
													String timePeriod = "";
													String startDateTime="";
													String endDateTime="";
													String s_en_time="";
													String s_st_time="";
													String s_st_hr = "";
													String s_en_hr="";
													String s_st_min="";
													String s_en_min="";
													String timeSelect="";
													if(timeline!=null && !timeline.equals(""))
													{
														if(timeline.indexOf("Any")>-1){
															timePeriod = timeline.substring(timeline.indexOf(" ")+1);
															timeline = timeline.substring(0, timeline.indexOf(" "));		
														}
														else {
															timeline=timeline.toLowerCase();
															timeSelect=timeline.toLowerCase();
															int blankSpaceIndex = timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
															if (blankSpaceIndex > 0)
															{
																String titletmp=timeline;
																java.util.Date today = edi.egetRealDate();
																endDateTime=sdf.format(today);
																int value = Integer.parseInt(timeline.substring(0, blankSpaceIndex));
																String timelineUnit = timeline.substring(blankSpaceIndex+1).toLowerCase();
																if (timelineUnit.startsWith("min"))
																{
																	value *= 60;
																}
																else if (timelineUnit.startsWith("h"))
																{//hours
																	value *= 3600;
																	
																}
																else if (timelineUnit.startsWith("d"))
																{//days
																	value *= (24 * 3600);
																	
																}
																else if (timelineUnit.startsWith("w"))
																{//weeks
																	value *= (7 * 24 * 3600);
																
																}
																else if (timelineUnit.startsWith("mo"))
																{//months
																	//value *= (30 * 24 * 3600);
																	value *=(24*(ErUtils.getMaxDaysInMonth()) * 3600);
																	
																}
																long longValue=value;
																java.util.Date start = edi.egetRealDate();
																start.setTime(today.getTime() - (longValue * 1000));
																startDateTime = sdf.format(start);
																if ((startDateTime != null) && (endDateTime != null))
																{
																	int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
																	int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
																	s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
																	s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
																	s_st_hr = String.valueOf(shr);
																	s_en_hr = String.valueOf(en_hr);
																	s_st_min = startDateTime.substring(startDateTime.lastIndexOf(":")+1);
																	s_en_min = startDateTime.substring(endDateTime.lastIndexOf(":")+1);
																}
															}
														}
													}
													else
													{
														timeSelect="1 hour";
														java.util.Date endDate=edi.egetRealDate();
														endDateTime=sdf.format(endDate);
														java.util.Date startDate=edi.egetRealDate();
														startDate.setTime(endDate.getTime() - (3600 * 1000));
														startDateTime=sdf.format(startDate);
														if ((startDateTime != null) && (endDateTime != null))
														{
															int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
															int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
															s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
															s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
															s_st_hr = String.valueOf(shr);
															s_en_hr = String.valueOf(en_hr);
															s_st_min = startDateTime.substring(startDateTime.lastIndexOf(":")+1);
															s_en_min = startDateTime.substring(endDateTime.lastIndexOf(":")+1);
														}												
													}
													if(timeline != null && timeline.equalsIgnoreCase("30 mins")){
														timeline = "Any";
														timePeriod = startDateTime+"|"+endDateTime;
													}
													String tmpStartDate = DateUtil.changeDateFormat(s_st_time,"MM/dd/yyyy",userFormat);
													String tmpEndDate = DateUtil.changeDateFormat(s_en_time,"MM/dd/yyyy",userFormat);
													String allowInterfacesInLegends = "false";
													String selectedInterfaceCombo = (String)rootJson.get("selectedInterfaceCombo");
													if(selectedInterfaceCombo != null && selectedInterfaceCombo.indexOf(",")>-1 || selectedInterfaceCombo == "All interfaces"){
														allowInterfacesInLegends = "true";
													}
													String compTypewithNameAndPort = compType+":"+compName;
					
													infosArea = StringUtils.encodeSecurityChar(infosArea);	
													String encodeTitleVal = StringUtils.encodeSecurityChar(TITLE);
													String areaChartURL = "chartType="+chartType+"&host="+EgURLEncoder.encode(compName, "UTF-8")+"&comptype="+EgURLEncoder.encode(compType, "UTF-8")+"&msmt_host="+EgURLEncoder.encode(st_msmthost, "UTF-8")+"&descriptors="+EgURLEncoder.encode(infosArea,"UTF-8")+"&fromDashboard=true&test="+st_test+"&measure="+st_measure+"&Timeline="+EgURLEncoder.encode(timeline, "UTF-8")+"&TimePeriod="+EgURLEncoder.encode(timePeriod,"UTF-8")+"&components="+EgURLEncoder.encode(compTypewithNameAndPort, "UTF-8")+"&Title="+EgURLEncoder.encode(encodeTitleVal,"UTF-8")+"&gtype=1&graphFormat=highcharts&allowInterfacesInLegends="+allowInterfacesInLegends;
														
													if(areaChartURL!=null && !areaChartURL.equals(""))
													{
														protocolObj.put("Title",mappingInfo.getTextDescription("monitor.dashboard."+mappingName));
														protocolObj.put("Type","area_chart");
														protocolObj.put("areaChartURL",areaChartURL);					
														protocolObj.put("GRAPH_FORMAT", "highchart");
														
														JSONObject tmpObj=new JSONObject();
														tmpObj.put("displayField",mappingInfo.getTextDescription("monitor.dashboard."+timeSelect));
														tmpObj.put("valueField",timeSelect);
														
														protocolObj.put("Timeline",tmpObj);
														protocolObj.put("startDate", tmpStartDate);
														protocolObj.put("startHr", s_st_hr);
														protocolObj.put("endDate", tmpEndDate);
														protocolObj.put("endHr", s_en_hr);
														protocolObj.put("startMin", s_st_min);
														protocolObj.put("endMin", s_en_min);
													}											
													
													protocalArr.add(protocolObj);
												}
											}
										//----------------------->Line chart ending----------------------
										}
									}
									else
									{
										rootJson.put("showChart","false");
									}
								}
								//---------------->grid end----------------------
								
							}
							else
							{
								String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
								
								if(!(timeline.indexOf("Any")>-1)){
									NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for");
									NoMeasure +=" "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
								}
								gridJson.put("errorMsg",NoMeasure);
								rootJson.put("Data","false");
								rootJson.put("NoMeasureMsg",NoMeasure);
							}
						}
					}
					else
					{
						String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
						if(!(timeline.indexOf("Any")>-1)){
							NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for");
							NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline;
						}
						gridJson.put("errorMsg",NoMeasure);
						rootJson.put("NoMeasureMsg",NoMeasure);
					}
				}				
				rootJson.put("CHARTNTABLE_DATA",protocalArr);
			}
		}
		else
		{
			String testMeasure = mappingInfo.getTextDescription("monitor.common.Test has been excluded or disabled"+"!");
			gridJson.put("errorMsg",testMeasure);
			rootJson.put("NoMeasureMsg",testMeasure);
		}
		rootJson.put("protocolInterfaceCombo",protocolsInterfaceCombo);
		rootJson.put("PROTOCOLSTABLE",gridJson);
	}
	else if(blockType!=null && blockType.equals("Flows"))
	{
		int interface_Cnt=Integer.parseInt(showInterfaces);
		boolean isfromInterfaceComboChange = false;
		String interfaceToView = request.getParameter("interfaceToView");
		interfaceToView = StringUtils.decodeSecurityChar(interfaceToView);	
		if(interfaceToView == null)
			interfaceToView = "All";
		String fromInterfaceSeletion = request.getParameter("interfaceSelection");
		if(fromInterfaceSeletion == null)
			fromInterfaceSeletion = "false";
		if(fromInterfaceSeletion!=null && fromInterfaceSeletion.equals("true"))
		{
			if(interfaceToView!=null && !interfaceToView.equals("All"))
			{
				isfromInterfaceComboChange = true;
			}
		}

		ErUtils erutils=new  ErUtils();
		String timeline = request.getParameter("timeline");
		String flowsTest = request.getParameter("flowsTest");	
		if(StringUtils.isNull(timeline))
			timeline = defaultPieGraphDuration;
		String[] timeline_options =new String[] {"30 mins","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","Any"};		
		JSONObject timelineObj = new JSONObject();
		JSONArray timelineArray = new JSONArray();
		JSONArray selectedTimelineArray = new JSONArray();
		timelineObj.put("monitor.dashboard.TimeLine",egMappingInfo.getTextDescription("monitor.dashboard.Timeline"));
		timelineObj.put("method","timelineOnchange");
		String DefaultTimeDuration=iniobj.getValue("Default_DashboardGraph_Duration", "duration");
		for(int e_ctr=0; e_ctr < timeline_options.length;e_ctr++)
		{
			JSONObject timelineCombo = new JSONObject();
			if(timeline!=null && timeline.equals((String)timeline_options[e_ctr]))
			{
				String tempOptions="";
				String tempOptions2="";

				if(timeline.indexOf(" ")>-1)
				{
					tempOptions2=timeline.substring(0,timeline.indexOf(" "))+" ";
					tempOptions=timeline.substring(timeline.indexOf(" ")+1);
				}
				else
				{
					tempOptions=timeline;
				}
				timelineCombo.put("displayField",tempOptions2+egMappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineCombo.put("valueField",timeline);
				selectedTimelineArray.add(timeline);
				timelineArray.add(timelineCombo);
			}
			else
			{
				String tempOptions="";
				String tempOptions2="";

				if(timeline_options[e_ctr].indexOf(" ")>-1)
				{
					tempOptions2=timeline_options[e_ctr].substring(0,timeline_options[e_ctr].indexOf(" "))+" "; tempOptions=timeline_options[e_ctr].substring(timeline_options[e_ctr].indexOf(" ")+1);
				}
				else
				{
					tempOptions=timeline_options[e_ctr];
				}
				timelineCombo.put("displayField",tempOptions2+egMappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineCombo.put("valueField",timeline_options[e_ctr]);
				if(timeline_options[e_ctr].equalsIgnoreCase("Any") && timeline.startsWith("Any")){
					JSONObject selectedTimelineObj = new JSONObject();
					
					String s_st_time = timeline.substring(timeline.indexOf(" ")+1,timeline.indexOf("|")); 
					String stTime = s_st_time.substring(s_st_time.indexOf(" ")+1); 
					s_st_time = s_st_time.substring(0,s_st_time.indexOf(" ")); 
					String[] stTokens = StringUtils.getTokens(stTime, ":");
					
					if(stTokens.length >0){
						selectedTimelineObj.put("anyStartHr",stTokens[0]);
						selectedTimelineObj.put("anyStartMin",stTokens[1]);
						selectedTimelineObj.put("anyStartSec",stTokens[2]);
					}
					String s_end_time = timeline.substring(timeline.indexOf("|")+1); 
					String endTime = s_end_time.substring(s_end_time.indexOf(" ")+1); 
					s_end_time = s_end_time.substring(0,s_end_time.indexOf(" ")); 
					String[] endTokens = StringUtils.getTokens(endTime, ":");
					if(endTokens.length >0){
						selectedTimelineObj.put("anyEndHr",endTokens[0]);
						selectedTimelineObj.put("anyEndMin",endTokens[1]);
						selectedTimelineObj.put("anyEndSec",endTokens[2]);
					}
					String tmpStartDate = DateUtil.changeDateFormat(s_st_time,"MM/dd/yyyy",userFormat);
					String tmpEndDate = DateUtil.changeDateFormat(s_end_time,"MM/dd/yyyy",userFormat);
					selectedTimelineObj.put("anyStartDate",tmpStartDate);
					selectedTimelineObj.put("anyEndDate",tmpEndDate);
					selectedTimelineArray.add("Any");
					selectedTimelineArray.add(selectedTimelineObj);
					
				}
				timelineArray.add(timelineCombo);
			}			
		}
		timelineObj.put("selectedTimelineCombo",selectedTimelineArray);
		timelineObj.put("timelineComboArray",timelineArray);
		rootJson.put("timelineCombo",timelineObj);
				
		String timelineTitle = mappingInfo.getTextDescription("monitor.dashboard.Showing data for");	
		if(!(timeline.indexOf("Any")>-1))
			timelineTitle += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline;
		else {
			timelineTitle += mappingInfo.getTextDescription("monitor.dashboard.From");
			timelineTitle += " "+timeline.substring(timeline.indexOf(" ")+1,timeline.indexOf("|"));
			timelineTitle += " "+mappingInfo.getTextDescription("monitor.dashboard.To");
			timelineTitle += " "+timeline.substring(timeline.indexOf("|")+1)+"'";
		}
		rootJson.put("timelineTitle",timelineTitle);
		
		JSONArray flowsInterfaceCombo = new JSONArray();
		JSONObject flowsComboObj = new JSONObject();
		flowsComboObj.put("displayField",mappingInfo.getTextDescription("monitor.dashboard.All"));
		flowsComboObj.put("valueField","All");
		flowsInterfaceCombo.add(flowsComboObj);
							
		if(isIncludedNetflowDeviceAvailable)		
		{
			Vector networkInterfaceTestInfos = (Vector)dashboardDAO.getDescriptorsForTest(compName,compType,"NetworkInterfaceTest","custom");
			Hashtable allTableInfos = new Hashtable();
			ArrayList interfaceToViewList = new ArrayList();
			if(interfaceToView!=null)
			{
				StringTokenizer stTokens = new StringTokenizer(interfaceToView,",");				
				while(stTokens.hasMoreTokens())
				{
					String token = (String)stTokens.nextToken();
					token = token.trim();
					if(token.equalsIgnoreCase("All"))
						continue;
					interfaceToViewList.add(token);
				}
			}
			double defaultTableWidth=920;
			double tableWidth=920;
			double tableWidth1024PxInPercent=defaultTableWidth/1024;
			tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
			tableWidth=MathUtils.round(tableWidth,0);
			String tblWidth=Double.toString(tableWidth);

			double defaultChartWidth=200;
			double chartWidth=200;
			double chartWith1024PxInPercent=defaultTableWidth/1024;
			chartWidth=screenWidthInDouble*chartWith1024PxInPercent;
			chartWidth=MathUtils.round(chartWidth,0);
			String iniVal=(String)iniobj.getValue(compType,"Netflow_Flows_piechart");			
			if(iniVal!=null )
			{
				JSONArray flowsPieArr = new JSONArray();
				StringTokenizer stoken=new StringTokenizer(iniVal,",");
				int j=0;
				int tmpCount = 0;
				Map tableData=new HashMap();
				String align="left";
				String px="padding-left:20px;";
				
				while(stoken.hasMoreTokens())
				{
					int interfaceCnt = 0;
					JSONObject flowsPieData = new JSONObject();
					JSONObject gridJson = new JSONObject();
					JSONObject flowInterfaceObj = new JSONObject();					
					JSONArray gridJsons = new JSONArray();

					String testWithMeasure=stoken.nextToken();
					String s_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));	
					if(!flowsTest.equals(s_test)){
						tmpCount++;
						continue;
					}
					String tableTitle=(String)iniobj.getValue("Dashboard_Comparison_TableTitle",s_test);
					StringBuffer sb=new StringBuffer();
					sb.append(tableTitle);
					if(enabledTests!=null && enabledTests.contains(s_test))
					{					
						String flowsTestSeperator = uiIniobj.getValue("TEST_PANEL_SUBTREE",s_test);
						String s_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1,testWithMeasure.indexOf("$"));
						String tableId=testWithMeasure.substring(testWithMeasure.indexOf("$")+1);	
						String msmthost=(String)allMsmtHosts.get(s_test);
						Vector testInfos=(Vector)dashboardDAO.getDescriptorsForTest(compName,compType,s_test,"custom");
						if(testInfos!=null && !testInfos.contains("+"))
						{
							TreeSet interfaceSet=new TreeSet(String.CASE_INSENSITIVE_ORDER);
							Map interfaceSubInfo=new HashMap();							
							
							if(interfaceToView!=null && !interfaceToView.equals("All"))
							{
								isfromInterfaceComboChange = true;
							}
							
							for(int i=0;i<testInfos.size();i++)
							{
								String interfaces =(String)testInfos.get(i);
								String tmpInterface="";
								String tmpSubInfo = "";
								if(interfaces != null && flowsTestSeperator!= null && interfaces.indexOf(flowsTestSeperator)>0){
									tmpInterface = interfaces.substring(0,interfaces.indexOf(flowsTestSeperator));
									tmpSubInfo = interfaces;
								}
								if(interfaceSubInfo!=null && interfaceSubInfo.containsKey(tmpInterface))
								{
									List existingList=(ArrayList)interfaceSubInfo.get(tmpInterface);
									existingList.add(tmpSubInfo);
									interfaceSubInfo.put(tmpInterface,existingList);
								}
								else
								{
									List valueList=new ArrayList();
									valueList.add(tmpSubInfo);
									if(tmpSubInfo != null && !tmpSubInfo.equals("")){
										interfaceSubInfo.put(tmpInterface,valueList);
									}
									else{
										continue;
									}
								}
								if(interfaceSet.contains(tmpInterface))
									continue;

								/*boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,s_test,msmthost,interfaces);
								if(isTestExceededCutOffFactor)
								{
									continue;
								}*/
								flowsComboObj = new JSONObject();
								flowsComboObj.put("displayField",com.egurkha.util.StringUtils.replace(tmpInterface, "+", ""));
								flowsComboObj.put("valueField",com.egurkha.util.StringUtils.replace(tmpInterface, "+", ""));
								flowsInterfaceCombo.add(flowsComboObj);
								interfaceSet.add(tmpInterface);
							}
							if(interfaceToView!=null)
							{
								rootJson.put("flowsInterfaceSelectedCombo",com.egurkha.util.StringUtils.replace(interfaceToView, "+", ""));	
							}
							else{
								rootJson.put("flowsInterfaceSelectedCombo","All");								
							}
							
							rootJson.put("isfromInterfaceComboChange",isfromInterfaceComboChange);
							if(interfaceSet.size()>interface_Cnt)
								rootJson.put("isInterfaceCountExceeded","true");
							else
								rootJson.put("isInterfaceCountExceeded","false");
							
							//rootJson.put("flowsInterfaceSelectedComboArray",flowsSelectedArr);
							

							boolean isSummaryView = false;						
							if((interfaceToView!=null && interfaceToView.equals("All")) && interfaceSet.size()>interface_Cnt)
							{
								isSummaryView = true;	
								rootJson.put("showChart","false");

								String SummaryViewEntries=(String)iniobj.getValue(compType,"Netflow_"+s_test+"_Summary_view");
								Object summaryViewDatas[] = dashboardDAO.getSummaryViewForNetflow(hostName,portNo,SummaryViewEntries,msmthost,showVal,timeline,"flows");	
							
								if(summaryViewDatas!=null && summaryViewDatas.length>0)
								{
									Double totalBytesVal = (Double)summaryViewDatas[0];
									Double totalPacketsVal = (Double)summaryViewDatas[1];
									Double totalInOctectsVal = (Double)summaryViewDatas[2];
									Double totalOutOctectsVal = (Double)summaryViewDatas[3];
									Hashtable protocolData = (Hashtable)summaryViewDatas[4];
									List pieChartList = (ArrayList)summaryViewDatas[5];

									Hashtable valueTable = new Hashtable();

									Vector internalHeaderName=new Vector();
									String testNameMapping = "";
									if(s_test.equals("TopSourceTest"))
									{
										testNameMapping = mappingInfo.getTextDescription("monitor.dashboard.Sources");
										internalHeaderName.add("Sources");
									}
									else if(s_test.equals("TopDestTest"))
									{
										testNameMapping = mappingInfo.getTextDescription("monitor.dashboard.Destinations");
										internalHeaderName.add("Destinations");
									}
									else if(s_test.equals("TopConverTest"))
									{
										testNameMapping = mappingInfo.getTextDescription("monitor.dashboard.Conversations");
										internalHeaderName.add("Conversations");
									}

									internalHeaderName.add("BYTES");
									internalHeaderName.add("PACKETS");
								//	internalHeaderName.add("TRAFFICRATE");
									internalHeaderName.add("IN_TRAFFIC");
									internalHeaderName.add("OUT_TRAFFIC");
									internalHeaderName.add("IN_BW");
									internalHeaderName.add("OUT_BW");
								//	internalHeaderName.add("BWUTILIZED");
									//internalHeaderName.add("In traffic %");
									//internalHeaderName.add("Out traffic %");	

									JSONArray tableColumns = new JSONArray();
									tableColumns.add(testNameMapping);
									tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.Data Flow(GB)"));
									tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.Packets"));
								//	tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.% Traffic"));
									tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.In Traffic"));
									tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.Out Traffic"));
									tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.In Bandwidth"));
									tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.Out Bandwidth"));
								//	tableColumns.add(mappingInfo.getTextDescription("monitor.dashboard.Bandwidth"));
	
									JSONArray tableValArr = new JSONArray();
									TreeMap valueMap=new TreeMap();
									Iterator iter=protocolData.keySet().iterator();
									if(!isFromGridPage)
									{									
										ArrayList comparisonViewData = new ArrayList();
										while(iter.hasNext())								
										{
											JSONObject rowJson = new JSONObject();
											int colIdx = 0;
											String protocol=(String)iter.next();
											valueTable = (Hashtable)protocolData.get(protocol);
											
											rowJson.put("COLUMVal_"+(colIdx++),protocol);
											
											//Iterator iterVal=valueTable.keySet().iterator();									
											for(int k=1;k<internalHeaderName.size();k++)
											{
												String keyVal = (String)internalHeaderName.get(k);
												//String keyVal = (String)valueTable.get();
												if(keyVal!=null && keyVal.equalsIgnoreCase("Protocols"))
												{
													continue;
												}
												String value = (String)valueTable.get(keyVal);										
												
												if(value!=null && value.startsWith("-"))
												{
													value=iniui.getValue("MEASURE_LOOKUP",value);
													if(value!=null && value.indexOf(":")>0)
													{
														value=value.substring(value.indexOf(":")+1,value.length());
													}
													if(value!=null && (value.equalsIgnoreCase("NS") || value.equalsIgnoreCase("NAP") || value.equalsIgnoreCase("UN") || value.equalsIgnoreCase("UL")))
													{
														value="NA";
													}
												}
												//String value = "";
												if(keyVal!=null && keyVal.equalsIgnoreCase("BYTES"))
												{
													value = (String)valueTable.get("BYTES");											
													double bytesInGB = Double.parseDouble(value)/(1024*1024);
													value = String.valueOf(bytesInGB);
													value = erutils.round (Double.parseDouble(value),4);
													comparisonViewData.add(protocol);
													comparisonViewData.add(value);
												}
												if(value==null)
												{
													value="NA";
												}

												/*else if(k == 3)
												{		
													String Bytesvalue = (String)valueTable.get("BYTES");											
													if(totalBytesVal!=null){
														double trafficPercent = (Double.parseDouble(Bytesvalue)/totalBytesVal)*100;
														value = String.valueOf(trafficPercent);
														value=erutils.round (Double.parseDouble(value),4);
													}
													else {
														value = "-";
													}
												}*/
												/*else if(k == 4)
												{
													String inOctectsVal = (String)valueTable.get("INOCTETS");											
													if(totalInOctectsVal!=null){
														double percentInTraffic = (Double.parseDouble(inOctectsVal)/totalInOctectsVal)*100;
														value = String.valueOf(percentInTraffic);
														value=erutils.round (Double.parseDouble(value),4);
													}
													else {
														value = "-";
													}
												}
												else if(k == 5)
												{
													String outOctectsVal = (String)valueTable.get("OUTOCTETS");											
													if(totalOutOctectsVal!=null){
														double percentOutTraffic = (Double.parseDouble(outOctectsVal)/totalOutOctectsVal)*100;
														value = String.valueOf(percentOutTraffic);
														value=erutils.round (Double.parseDouble(value),4);
													}
													else {
														value = "-";
													}
												}*/
												
												rowJson.put("COLUMVal_"+k,value);

												if(keyVal!=null && (keyVal.equalsIgnoreCase("IN_TRAFFIC") || keyVal.equalsIgnoreCase("OUT_TRAFFIC")))
												{
													if(value!=null && value.startsWith("-"))
													{
														value=iniui.getValue("MEASURE_LOOKUP",value);
														if(value!=null && value.indexOf(":")>0)
														{
															value=value.substring(value.indexOf(":")+1,value.length());
														}
													}
													if(value!=null && (value.equalsIgnoreCase("NS") || value.equalsIgnoreCase("NAP") || value.equalsIgnoreCase("UN") || value.equalsIgnoreCase("UL")))
													{
														value="NA";
													}
													if(value !=null &&!value.equalsIgnoreCase("NA") && value.length()>0){
														List valueList=(ArrayList)valueMap.get(keyVal);
														if(valueList==null)
														{
															valueList=new ArrayList();
															valueList.add(protocol);
															valueList.add(value);
															valueMap.put(keyVal,valueList);
														}
														else
														{
															valueList.add(protocol);
															valueList.add(value);
															valueMap.put(keyVal,valueList);
														}
													}
												}
											}
											tableValArr.add(rowJson);
										}
										JSONObject tableDataObj = new JSONObject();
										if(tableValArr!=null && tableValArr.size()>0)
										{
											JSONArray sortedJsonArray = new JSONArray();
											Collections.sort( tableValArr, new Comparator<JSONObject>() {
																						
												public int compare(JSONObject a, JSONObject b) {
													double valA =0.0;
													double valB =0.0;

													try {
														String value1 = (String) a.get("COLUMVal_1");
														String value2 = (String) b.get("COLUMVal_1");
														if(!value1.equals("-") && !value1.equals("NA")){
															valA = Double.parseDouble(value1);
														}
														if(!value2.equals("-") && !value2.equals("NA")){
															valB = Double.parseDouble(value2);
														}
													} 
													catch (JSONException e) {
														//do something
													}
													return Double.compare(valA, valB);
												}
											});
											Collections.sort( tableValArr, new Comparator<JSONObject>() {
																			
												public int compare(JSONObject a, JSONObject b) {
													double valA =0.0;
													double valB =0.0;

													try {
														String value1 = (String) a.get("COLUMVal_3");
														String value2 = (String) b.get("COLUMVal_3");
														if(!value1.equals("-") && !value1.equals("NA")){
															valA = Double.parseDouble(value1);
														}
														if(!value2.equals("-") && !value2.equals("NA")){
															valB = Double.parseDouble(value2);
														}
													} 
													catch (JSONException e) {
														//do something
													}
													return Double.compare(valA, valB);
												}
											});
											for (int i = tableValArr.size()-1; i > -1 ; i--) {
												sortedJsonArray.add(tableValArr.get(i));
												if(!showVal.equalsIgnoreCase("All")){
													String tempPriority=showVal.substring(showVal.indexOf("-")+2);
													int priority = Integer.parseInt(tempPriority);
													if(sortedJsonArray.size()== priority){
														break;
													}
												}
											}										
											tableDataObj.put("tableValues",sortedJsonArray);
											/*tableData.put("errorMsg","-");
											tableData.put("start",20);
											if(showVal.equalsIgnoreCase("All")){
												tableData.put("totalCount",totalRecCount);
											}else{
												tableData.put("totalCount",sortedJsonArray.size());
											}*/
											if(sortedJsonArray!= null){
												if(showVal.equalsIgnoreCase("All")){
													tableDataObj.put("tableValues",sortedJsonArray); 
												}
												else {
													JSONArray sortedJsonArray1 = new JSONArray();
													if(startGridIndex !=null && limitIndex!=null){
														for (int i = startIndex; i < startIndex+limit ; i++) {
															sortedJsonArray1.add(sortedJsonArray.getJSONObject(i));
															if(i+2> sortedJsonArray.size()){
																break;
															}
														}
														tableDataObj.put("tableValues",sortedJsonArray1); 
													}
												}
											}
										}									
										tableDataObj.put("tableColumns",tableColumns);
										//tableData.put("tableValues",tableValArr);	
										rootJson.put("tableData",tableDataObj);
										JSONArray protocolsSummaryViewArr=new JSONArray();
										
										if(valueMap!=null && !valueMap.isEmpty())
										{	
											JSONArray protocolsMeasArr = new JSONArray();
											Iterator itr=valueMap.entrySet().iterator();
											while(itr.hasNext())
											{
												Map.Entry mp=(Map.Entry)itr.next();
												if(mp!=null)
												{
													String s_measName=(String)mp.getKey();
													List measValList=(ArrayList)mp.getValue();
													
													if(measValList!=null && !measValList.isEmpty())
													{
														Vector chartAttributes=new Vector();
																						
														chartAttributes.add("decimals='2'");
														chartAttributes.add("enableRotation='1'");
														chartAttributes.add("bgColor='99CCFF,FFFFFF'");
														chartAttributes.add("bgAlpha='0,0'");								
														chartAttributes.add("bgAngle='360'");
														chartAttributes.add("showBorder='0'");
														chartAttributes.add("startingAngle='80'");
														chartAttributes.add("chartLeftMargin ='0'");
														chartAttributes.add("chartTopMargin ='0'");
														chartAttributes.add("chartBottomMargin ='0'");
														chartAttributes.add("chartRightMargin ='0'");
														chartAttributes.add("showToolTipShadow ='1'");
														chartAttributes.add("pieSliceDepth='7'");
														chartAttributes.add("numberSuffix='%'");
														chartAttributes.add("showToolTipShadow ='1'");
														chartAttributes.add("pieOuterFaceAlpha  ='75'");
														chartAttributes.add("pieInnerFaceAlpha  ='100'");
														chartAttributes.add("pieYScale  ='49'");
														chartAttributes.add("smartLineColor  ='BABABA'");
														chartAttributes.add("smartLabelClearance  ='2'");
														chartAttributes.add("captionPadding  ='0'");
														chartAttributes.add("bgSWFAlpha  ='0'");
														chartAttributes.add("enableSmartLabels='1'");
														chartAttributes.add("pieRadius='80'");
														chartAttributes.add("labelDistance='3'");
														chartAttributes.add("isSmartLineSlanted='1'");
														chartAttributes.add("exportEnabled='0'");
														chartAttributes.add("exportAction='download'");
														chartAttributes.add("exportAtClient='0'");
														chartAttributes.add("showPlotBorder='1'");
														chartAttributes.add("plotBorderColor='000000'");
														chartAttributes.add("skipOverlapLabels='0'");
														chartAttributes.add("legendPosition='RIGHT'");
														chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
																
														String layerName=dashboardDAO.getLayerForTest(compType,s_test,s_measName);
														String compTypeForAlarm=compType;
														if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
															compTypeForAlarm="Host_system";
													//	String measureState=model.getTestMeasureState(compName,compTypeForAlarm,layerName,s_test+"-"+key,s_measName);
														ArrayList compList = new ArrayList();
														compList.add(compName);
														compList.add(compType);
														compList.add(compTypeForAlarm);
														compList.add(layerName);
														compList.add("");
														compList.add(s_test);
														compList.add(s_measName);
														compList.add(msmthost);
														String xml=(String)graphUtil.getXMLtoProtocol(measValList,chartAttributes);
															//xml="";
														JSONObject protocolsDataObj=new JSONObject();
														if(xml!=null && !xml.equals(""))
														{									
														//	protocolsDataObj.put("Interface",com.egurkha.util.StringUtils.replace(key, "+", ""));
															protocolsDataObj.put("XML_DATA",xml);							
															protocolsDataObj.put("width","400");
															protocolsDataObj.put("height","140"); 
															protocolsDataObj.put("SWF_PATH","/final/FusionCharts/swf/Pie3D.swf");
														}
														//protocolsDataObj.put("Measure_Name",s_measName);
														String dispKey=mappingInfo.getMeasureDescription(s_test,s_measName);
														protocolsDataObj.put("TITLE",dispKey);
														protocolsMeasArr.add(protocolsDataObj);
													}
												}
											}
											protocolsSummaryViewArr=protocolsMeasArr;
										}
										if(protocolsSummaryViewArr!= null && protocolsSummaryViewArr.size() == 0)
										{
											JSONObject protocolsObj=new JSONObject();
											String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
											if(!(timeline.indexOf("Any")>-1)){
												NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for ");
												NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+ " "+timeline+"!";
											}
											protocolsObj.put("NOMSG",NoMeasure);
											protocolsSummaryViewArr.add(protocolsObj);
										}
										rootJson.put("pieChart",protocolsSummaryViewArr);
										
										String tmpInterfaceToView = interfaceToView;
										if(tmpInterfaceToView.equalsIgnoreCase("all")){
											tmpInterfaceToView = mappingInfo.getTextDescription("monitor.dashboard.All interfaces");
										}
										rootJson.put("pieTitle",(showTitle+" "+testNameMapping+" "+mappingInfo.getTextDescription("monitor.dashboard.by % of Traffic")+" - "+ tmpInterfaceToView));
										rootJson.put("barTitle",(showTitle+" "+testNameMapping+" "+mappingInfo.getTextDescription("monitor.dashboard.by Data Flow(GB)")+" - "+ tmpInterfaceToView));
										
										rootJson.put("TABLE_TITLE",(mappingInfo.getTextDescription("monitor.dashboard.Details of")+" "+showTitle+" "+testNameMapping+" "+mappingInfo.getTextDescription("monitor.dashboard.by Data Flow (GB)")+" - "+ tmpInterfaceToView));
										rootJson.put("Data","true");
										rootJson.put("fromView","SummaryView");
										
										String fontForLanguage="verdana";
										String fontSize="7.5";
										boolean isNonEnglishLanguage=((EgDbInfo.doubleByteEnabled && !trackerLanguage.equals("en_US")) || !trackerLanguage.equals("en_US"));

										if(isNonEnglishLanguage)
										{
												fontForLanguage=iniUI.getFontName();
												fontSize="12";
										}

										Vector comparionChartAttribute=new Vector();
										//comparionChartAttribute.add("caption='"+EgURLEncoder.encode(measureMapping+"("+unit+")","UTF-8")+"'");
										//comparionChartAttribute.add("caption='"+measureMapping+" ("+unit+")"+"'");
										comparionChartAttribute.add("palette='2'");
										comparionChartAttribute.add("showValues='1'");
										comparionChartAttribute.add("showLabels='1'");
										comparionChartAttribute.add("showYAxisValues='0'");
										comparionChartAttribute.add("formatNumberScale='0'");
										comparionChartAttribute.add("useRoundEdges='1'");
										//comparionChartAttribute.add("clickURL='javascript:comparisionBarOnclick(&apos;bar"+i+"&apos;)'");	
										//comparionChartAttribute.add("clickURL='javascript:comparisionBarOnclick(&apos;bar"+i+"&apos;)'");	
										comparionChartAttribute.add("bgColor='ffffff'");
										comparionChartAttribute.add("showToolTipShadow='1'");
										comparionChartAttribute.add("chartLeftMargin='8'");
										comparionChartAttribute.add("chartRightMargin='8'");
										comparionChartAttribute.add("chartTopMargin='8'");
										comparionChartAttribute.add("chartBottomMargin='8'");
										comparionChartAttribute.add("exportEnabled='0'");
										comparionChartAttribute.add("exportAction='download'");
										comparionChartAttribute.add("exportAtClient='0'");
										comparionChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
									//	comparionChartAttribute.add("outCnvBaseFontSize='"+fontSize+"'");
										if(!isNonEnglishLanguage)
										{
											comparionChartAttribute.add("outCnvBaseFontSize='"+fontSize+"'");
											comparionChartAttribute.add("outCnvBaseFontColor ='000000'");
										}
										comparionChartAttribute.add("showBorder ='0'");
										comparionChartAttribute.add("canvasBorderColor  ='000000'");
										comparionChartAttribute.add("plotSpacePercent  ='40'");
										comparionChartAttribute.add("baseFont  ='"+fontForLanguage+"'");
										comparionChartAttribute.add("adjustDiv='1'");
										comparionChartAttribute.add("yAxisValueDecimals='2'");
										comparionChartAttribute.add("decimals='4'");
										comparionChartAttribute.add("placeValuesInside='0'");

										Map comparisonMap = new TreeMap();
										for(int i=0;i<comparisonViewData.size();i+=2)
										{
											String protocol = (String)comparisonViewData.get(i);
											String value = (String)comparisonViewData.get(i+1);
											comparisonMap.put(protocol,new Double(value));
										}
										comparisonMap=sortByValues(comparisonMap);
										
										String comparisonXml="";									
										comparisonXml=(String)graphUtil.getXMLforNetflowComparison(comparionChartAttribute,comparisonMap);
										
										JSONObject comparisonChartsObj = new JSONObject();
										if(comparisonMap!=null && comparisonMap.size()>0)
										{										
											if(comparisonXml!=null && comparisonXml.trim().length()>0)
											{
												comparisonChartsObj.put("SWF_PATH", "/final/FusionCharts/swf/Bar2D.swf");
												comparisonChartsObj.put("XML_DATA", comparisonXml);
											}
											else
											{
												String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
												if(!(timeline.indexOf("Any")>-1)){
													NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for ");
													NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
												}
												comparisonChartsObj.put("NoMeasure",NoMeasure);
											}
										}
										else
										{
											String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
											if(!(timeline.indexOf("Any")>-1)){
												NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for ");
												NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
											}
											comparisonChartsObj.put("NoMeasure",NoMeasure);
										}
										rootJson.put("comparisonCharts",comparisonChartsObj);
									}
									if(isFromGridPage)
									{
										Integer totalRecCount = new Integer(0);
										ArrayList comparisonViewData = new ArrayList();
										List<JSONObject> jsonValues = new ArrayList<JSONObject>();
										while(iter.hasNext())								
										{
											JSONObject rowJson = new JSONObject();
											int colIdx = 0;
											String protocol=(String)iter.next();
											valueTable = (Hashtable)protocolData.get(protocol);
											
											rowJson.put("COLUMVal_"+(colIdx++),protocol);
											
											Iterator iterVal=valueTable.keySet().iterator();									
											for(int k=1;k<internalHeaderName.size();k++)
											{
												//String value = "";
												String keyVal = (String)internalHeaderName.get(k);
												String value = (String)valueTable.get(keyVal);

												if(value!=null && value.startsWith("-"))
												{
													value=iniui.getValue("MEASURE_LOOKUP",value);
													if(value!=null && value.indexOf(":")>0)
													{
														value=value.substring(value.indexOf(":")+1,value.length());
													}
													if(value!=null && (value.equalsIgnoreCase("NS") || value.equalsIgnoreCase("NAP") || value.equalsIgnoreCase("UN") || value.equalsIgnoreCase("UL")))
													{
														value="NA";
													}
												}

												if(keyVal!=null && keyVal.equalsIgnoreCase("BYTES"))
												{
													value = (String)valueTable.get("BYTES");											
													double bytesInGB = Double.parseDouble(value)/(1024*1024);
													value = String.valueOf(bytesInGB);
													value = erutils.round (Double.parseDouble(value),4);
													comparisonViewData.add(protocol);
													comparisonViewData.add(value);
												}							
											/*	else if(k == 3)
												{		
													String Bytesvalue = (String)valueTable.get("BYTES");											
													if(totalBytesVal!=null){
														double trafficPercent = (Double.parseDouble(Bytesvalue)/totalBytesVal)*100;
														value = String.valueOf(trafficPercent);
														value=erutils.round (Double.parseDouble(value),4);
													}
													else {
														value = "-";
													}
												
												}*/
												if(value==null)
												{
													value="NA";
												}
												rowJson.put("COLUMVal_"+(colIdx++),value);	
											}
											jsonValues.add(rowJson);
										}
										JSONArray colArr = new JSONArray();
										if(jsonValues!=null && jsonValues.size()>0)
										{
											JSONArray sortedJsonArray = new JSONArray();
											Collections.sort( jsonValues, new Comparator<JSONObject>() {
																						
												public int compare(JSONObject a, JSONObject b) {
													double valA =0.0;
													double valB =0.0;

													try {
														String value1 = (String) a.get("COLUMVal_1");
														String value2 = (String) b.get("COLUMVal_1");
														if(!value1.equals("-") && !value1.equals("NA")){
															valA = Double.parseDouble(value1);
														}
														if(!value2.equals("-") && !value2.equals("NA")){
															valB = Double.parseDouble(value2);
														}
													} 
													catch (JSONException e) {
														//do something
													}
													return Double.compare(valA, valB);
												}
											});
											Collections.sort( jsonValues, new Comparator<JSONObject>() {
																			
												public int compare(JSONObject a, JSONObject b) {
													double valA =0.0;
													double valB =0.0;

													try {
														String value1 = (String) a.get("COLUMVal_3");
														String value2 = (String) b.get("COLUMVal_3");
														if(!value1.equals("-") && !value1.equals("NA")){
															valA = Double.parseDouble(value1);
														}
														if(!value2.equals("-") && !value2.equals("NA")){
															valB = Double.parseDouble(value2);
														}
													} 
													catch (JSONException e) {
														//do something
													}
													return Double.compare(valA, valB);
												}
											});
											for (int i = jsonValues.size()-1; i > -1 ; i--) {
												sortedJsonArray.add(jsonValues.get(i));
												if(!showVal.equalsIgnoreCase("All")){
													String tempPriority=showVal.substring(showVal.indexOf("-")+2);
													int priority = Integer.parseInt(tempPriority);
													if(sortedJsonArray.size()== priority){
														break;
													}
												}
											}
											gridJson.put("tableColumns",colArr);
											rootJson.put("gridValues",sortedJsonArray);
											gridJson.put("errorMsg","-");
											rootJson.put("start",20);
											if(showVal.equalsIgnoreCase("All")){
												rootJson.put("totalCount",totalRecCount);
											}else{
												rootJson.put("totalCount",sortedJsonArray.size());
											}
											if(sortedJsonArray!= null){
												if(showVal.equalsIgnoreCase("All")){
													rootJson.put("gridValues",sortedJsonArray); 
												}
												else {
													JSONArray sortedJsonArray1 = new JSONArray();
													if(startGridIndex !=null && limitIndex!=null){
														for (int i = startIndex; i < startIndex+limit ; i++) {
															sortedJsonArray1.add(sortedJsonArray.getJSONObject(i));
															if(i+2> sortedJsonArray.size()){
																break;
															}
														}
														rootJson.put("gridValues",sortedJsonArray1); 
													}
												}
											}
										}
									}
								}
								else
								{
									String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
									
									if(!(timeline.indexOf("Any")>-1)){
										NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for");
										NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
									}
									rootJson.put("Data","false");
									rootJson.put("NoMeasureMsg",NoMeasure);
								}
							}
							else
							{
								if(interfaceSet!=null && !interfaceSet.isEmpty())
								{	
									List<JSONObject> jsonValues = new ArrayList<JSONObject>();
									gridJson.put("interfaceCnt",interfaceCnt);

									String iniTables=(String)iniobj.getValue(compType,"Netflow_Flows_"+tableId);
									if(iniTables!=null && iniTables.length()>0)
									{										
										ArrayList testWithMeasuresList=new ArrayList();
										ArrayList measuresList=new ArrayList();
										Vector header=new Vector();
										Vector internalHeaderName=new Vector();
										Vector units=new Vector();
										StringTokenizer st=new StringTokenizer(iniTables,",");
										String[] names={"Sources","Destinations","Conversations"};
										units.add("-");
										String comparisonTableFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&blockType=CiscoComparisionTable&tab=Network";
										StringBuffer measureColumn=new StringBuffer();
										String fullviewTest="";
										String fullviewMsmtHost="";
										String interfaceCount_fullview="";
										int tableCount=0;
										int headerCount=0;
										String pieHeader ="";
										JSONArray gridValues = new JSONArray();
										JSONArray MaxValues = new JSONArray();
										while(st.hasMoreTokens())
										{																   									
											String testMeasures=(String)st.nextToken();	
											String headerName=(String)iniobj.getValue("Dashboard_TableColumn_mapping",testMeasures);
											String testname=testMeasures.substring(0,testMeasures.indexOf(":"));
											String measurename=testMeasures.substring(testMeasures.indexOf(":")+1);
											String measureForDB=dbinfo.getColumnForMeasure(testname,measurename);
											String unit=tablesInfo.getUnitForMeasure(testname,measurename);
											String msmt_host=(String)allMsmtHosts.get(testname);
											testWithMeasuresList.add(testMeasures);

											measuresList.add(measurename);
											fullviewTest=testname;
											fullviewMsmtHost=msmt_host;
											interfaceCount_fullview=flows_Count;
											measureColumn.append(measureForDB);
											if(st.hasMoreTokens())
												measureColumn.append(",");																				
											String key="table"+j;
											if(tableCount==0)
											{
												pieHeader = (String)names[tmpCount];
												header.add(mappingInfo.getTextDescription("monitor.dashboard."+names[tmpCount]));
												internalHeaderName.add(names[tmpCount]);
											}
											header.add(headerName);	
											units.add(unit);
											internalHeaderName.add(measurename);										
											tableCount++;
											headerCount++;
										}
										int imgcnt=0;
										int stColPos=1;
										int endColPos=5;
										if(j<=1)
										{
											endColPos=4;
										}
										String rsTableName="rsTableflows"+j;
										comparisonTableFullViewURL+="&test="+fullviewTest+"&measure="+measureColumn+"&msmtHost="+fullviewMsmtHost+"&interfaces_Count="+interfaceCount_fullview+"&fromInterface=false&headerList="+header+"&inilookup=Cisco_Flows_"+tableId;
									
										JSONArray colArr = new JSONArray();
										JSONObject ColObj = new JSONObject();
										for(int k=0;k<header.size();k++)
										{
											ColObj = new JSONObject();
											String h_unit=(String)units.get(k);
											if(h_unit.equals("-"))
												h_unit="";
											if(k==0)
											{
												String colVal = (String)header.get(k);
												colArr.add(colVal.toUpperCase());
												colArr.add(mappingInfo.getTextDescription("monitor.dashboard.INTERFACE"));
												String title = mappingInfo.getTextDescription("monitor.dashboard.Details of")+" "+showTitle+" "+pieHeader+" "+mappingInfo.getTextDescription("monitor.dashboard.by Data Flow (GB)");
												String pieTitle = showTitle+" "+pieHeader+" "+mappingInfo.getTextDescription("monitor.dashboard.by % of Traffic");
												
												String tmpInterfaceToView = interfaceToView;
												if(interfaceToView.equalsIgnoreCase("all"))
												{
													 tmpInterfaceToView = mappingInfo.getTextDescription("monitor.dashboard.All interfaces");
												}
												if(interfaceCnt == 1)
												{
													title +=mappingInfo.getTextDescription("monitor.dashboard.for")+" - "+ tmpInterfaceToView;
													pieTitle +=mappingInfo.getTextDescription("monitor.dashboard.for")+ " - "+tmpInterfaceToView;
												}

												gridJson.put("TABLE_TITLE",title+" - "+ tmpInterfaceToView);
												flowInterfaceObj.put("PIE_TITLE",pieTitle+ " - "+tmpInterfaceToView);	
												gridJson.put("TABLE_TIMELINE_TITLE",mappingInfo.getTextDescription("monitor.dashboard.Last")+" "+timeline);
											}
											else if(k==1)
											{
												colArr.add(mappingInfo.getTextDescription("monitor.dashboard."+((String)header.get(k)))+" ("+mappingInfo.getTextDescription("monitor.dashboard.GB")+")");
											}
											else
											{
												String unitMapping = graphUtil.getUnitMapping(h_unit);
												colArr.add(mappingInfo.getTextDescription("monitor.dashboard."+((String)header.get(k)))+" ("+unitMapping+")");
											}	
											
											imgcnt++;								
										}
										Iterator iterator = interfaceSet.iterator();
										
										JSONArray flowsArr = new JSONArray();
										String testMeasure = (String)testWithMeasuresList.get(0);
										String testForUnit = testMeasure.substring(0,testMeasure.indexOf(":"));
										String measureForUnit = testMeasure.substring(testMeasure.indexOf(":")+1);
										String unit=tablesInfo.getUnitForMeasure(testForUnit,measureForUnit);
										boolean allowNegativeValues=testInfo.getAllowNegativeValues(testForUnit,measureForUnit);
										
										ArrayList interfaceList = new ArrayList();
										JSONObject MaxJSON = new JSONObject();
										//------------pie chart start---------------------
										if(!isFromGridPage){
											Object currentValuesForinfos[] = new Object[3];
											Hashtable currentValues= new Hashtable();
											ArrayList infosList= new ArrayList();
											while (iterator.hasNext())
											{	
												String infoToPie=(String)iterator.next();
												if(interfaceToViewList!=null && !interfaceToViewList.isEmpty())
												{
													String tmpinfoToPie = infoToPie;
													tmpinfoToPie =tmpinfoToPie.substring(1);;
													if(!interfaceToViewList.contains(tmpinfoToPie))
														continue;
												}

												ArrayList subInfo1 = (ArrayList)interfaceSubInfo.get(infoToPie);
												if(subInfo1==null ){
													continue;
												}
												currentValuesForinfos = dashboardDAO.getTopInfosForTest(hostName,portNo,testWithMeasuresList,msmthost,infoToPie,showVal,timeline,"flows",true);
												currentValues=(Hashtable)currentValuesForinfos[0];			
												infosList=(ArrayList)currentValuesForinfos[1];
												Double totalBytes=(Double)currentValuesForinfos[2];
												TreeMap valueMap=new TreeMap();	
												double BWMaxValue = 0.0;
												
												if(currentValues!=null && !currentValues.isEmpty() && infosList!=null && infosList.size()>0)
												{	
													String comboInfo = (String)infosList.get(0);
													if(comboInfo != null && flowsTestSeperator != null && comboInfo.indexOf(flowsTestSeperator)>0){
														comboInfo = comboInfo.substring(comboInfo.indexOf("+")+1,comboInfo.indexOf(flowsTestSeperator));
													}
													if(interfaceToViewList!=null && !interfaceToViewList.isEmpty())
													{
														if(!interfaceToViewList.contains(comboInfo))
															continue;
													}
													Iterator iter=infosList.iterator();
													int m=0;
													
													while(iter.hasNext())
													{
														String key=(String)iter.next();	
														
														Hashtable valueTable = (Hashtable)currentValues.get(key);
														String info ="", subInfo = "";
														if(key != null && flowsTestSeperator !=null && key.indexOf(flowsTestSeperator)>0)
														{
															info = key.substring(0,key.indexOf(flowsTestSeperator));
															subInfo = key.substring(key.indexOf(flowsTestSeperator)+1);	
														}
														if(subInfo!=null && subInfo.indexOf(flowsTestSeperator)>-1)
														{
															subInfo = subInfo.substring(subInfo.indexOf(flowsTestSeperator)+1);
														}
													/*	if(valueMap!=null && valueMap.containsKey(info))
														{
															List existingList=(ArrayList)valueMap.get(info);
															
															if(existingList.size()>1800)
																break;
														}*/
														//String InterfaceSpeedVal = (String)dashboardDAO.getCurrentMeasure(hostName,portNo,info,"NetworkInterfaceTest","Speed",msmthost,"","");
														for(int k=1;k<internalHeaderName.size();k++)
														{
															boolean isMeasureExists = false;
															String columnName = (String)internalHeaderName.get(k);
															if(valueMap!=null && valueMap.containsKey(info))
															{
															        Hashtable measMap=(Hashtable)valueMap.get(info);
																if(measMap!=null && !measMap.isEmpty())
																{
																	List existingList=(ArrayList)measMap.get(columnName);
																	if(existingList!=null && existingList.size()>1800)
																		break;
																}
															}
															
															String value = (String)valueTable.get(columnName);
															if(k==1 && s_measure.equalsIgnoreCase(columnName)){
																if(value!=null){
																	isMeasureExists = true;
																	double bytesInGB = Double.parseDouble(value)/(1024*1024);
																	value = String.valueOf(bytesInGB);
																	value = erutils.round (Double.parseDouble(value),4);
																}
															}
														/*	else if(k==3 && s_measure.equalsIgnoreCase(columnName))
															{
																isMeasureExists = true;
																columnName = (String)internalHeaderName.get(1);
																value = (String)valueTable.get(columnName);
																if(value!=null)
																{
																	if(totalBytes!=null){
																		double trafficPercent = (Double.parseDouble(value)/totalBytes)*100;
																		value = String.valueOf(trafficPercent);
																		value=erutils.round (Double.parseDouble(value),4);
																	}
																	else {
																		value = "-";
																	}
																}
															}
															else if(k==4 && s_measure.equalsIgnoreCase(columnName))
															{
																isMeasureExists = true;
																columnName = (String)internalHeaderName.get(1);
																value = (String)valueTable.get(columnName);
																													
																double kilobits = Double.parseDouble(value)*8;	
																long timelineInSec = (long) dashboardDAO.getTimelineInSeconds(timeline);
																double kilobitsPerSec = kilobits/timelineInSec;	
																if(networkInterfaceTestInfos!=null && networkInterfaceTestInfos.contains(info))
																{
																	if(!InterfaceSpeedVal.isEmpty())
																	{
																		double interfaceVal = Double.parseDouble(InterfaceSpeedVal)*1000;
																		if(value!=null && interfaceVal>0.0)
																		{
																			double BWPercent = (kilobitsPerSec/interfaceVal)*100;
																			value = String.valueOf(BWPercent);
																			value=erutils.round (Double.parseDouble(value),4);
																			if(Double.parseDouble(value)>BWMaxValue)
																				BWMaxValue = Double.parseDouble(value);
																		}
																		else
																			value = "-";
																	}
																	else
																		value = "-";
																}
																else
																	value = "-";
																
															}*/
															else if((columnName.indexOf("in_traffic")>-1 || columnName.indexOf("out_traffic")>-1)){
																isMeasureExists = true;
															}
															
															if(isMeasureExists){
																if(value!=null && value.startsWith("-") && !allowNegativeValues)
																{
																	value=iniui.getValue("MEASURE_LOOKUP",value);
																	if(value!=null && value.indexOf(":")>0)
																	{
																		value=value.substring(value.indexOf(":")+1,value.length());
																	}
																}
																if(value!=null && (value.equalsIgnoreCase("NS") || value.equalsIgnoreCase("NAP") || value.equalsIgnoreCase("UN") || value.equalsIgnoreCase("UL")))
																{
																	value="NA";
																}
																if(value != null && (value.length()>0 && !value.equalsIgnoreCase("NA") && !value.equalsIgnoreCase("NS")))
																{
																	Hashtable measureMap=(Hashtable)valueMap.get(info);
																	if(measureMap==null)
																	{
																		measureMap=new Hashtable();
																		List valueList=new ArrayList();
																		valueList.add(subInfo);
																		valueList.add(value);
																		measureMap.put(columnName,valueList);
																		valueMap.put(info,measureMap);
																	}
																	else
																	{
																		List measValueList=(ArrayList)measureMap.get(columnName);
																		if(measValueList==null)
																		{
																			measValueList=new ArrayList();
																		}
																		measValueList.add(subInfo);
																		measValueList.add(value);
																		measureMap.put(columnName,measValueList);
																		valueMap.put(info,measureMap);
																	}
																}
															}
														}
													}
												}
												if(valueMap!=null && !valueMap.isEmpty())
												{	
													Iterator itr=valueMap.entrySet().iterator();
													while(itr.hasNext())
													{
														Map.Entry mp=(Map.Entry)itr.next();
														if(mp!=null)
														{
															String key=(String)mp.getKey();
															Hashtable measValMap=(Hashtable)mp.getValue();
															JSONObject flowsObj = new JSONObject();
															if(measValMap!=null && !measValMap.isEmpty())
															{
																Vector chartAttributes=new Vector();
																								
																chartAttributes.add("decimals='2'");
																chartAttributes.add("enableRotation='1'");
																chartAttributes.add("bgColor='99CCFF,FFFFFF'");
																chartAttributes.add("bgAlpha='0,0'");								
																chartAttributes.add("bgAngle='360'");
																chartAttributes.add("showBorder='0'");
																chartAttributes.add("startingAngle='80'");
																chartAttributes.add("chartLeftMargin ='0'");
																chartAttributes.add("chartTopMargin ='0'");
																chartAttributes.add("chartBottomMargin ='0'");
																chartAttributes.add("chartRightMargin ='0'");
																chartAttributes.add("showToolTipShadow ='1'");
																chartAttributes.add("pieSliceDepth='7'");
																chartAttributes.add("numberSuffix='%'");
																chartAttributes.add("showToolTipShadow ='1'");
																chartAttributes.add("pieOuterFaceAlpha  ='75'");
																chartAttributes.add("pieInnerFaceAlpha  ='100'");
																chartAttributes.add("pieYScale  ='49'");
																chartAttributes.add("smartLineColor  ='BABABA'");
																chartAttributes.add("smartLabelClearance  ='2'");
																chartAttributes.add("captionPadding  ='0'");
																chartAttributes.add("bgSWFAlpha  ='0'");
																chartAttributes.add("enableSmartLabels='1'");
																chartAttributes.add("pieRadius='80'");
																chartAttributes.add("labelDistance='3'");
																chartAttributes.add("isSmartLineSlanted='1'");
																chartAttributes.add("exportEnabled='0'");
																chartAttributes.add("exportAction='download'");
																chartAttributes.add("exportAtClient='0'");
																chartAttributes.add("showPlotBorder='1'");
																chartAttributes.add("plotBorderColor='000000'");
																chartAttributes.add("skipOverlapLabels='0'");
																chartAttributes.add("legendPosition='RIGHT'");
																chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
																Iterator itrMeasValMap=measValMap.entrySet().iterator();
																while(itrMeasValMap.hasNext())
																{
																	Map.Entry measMPEntry=(Map.Entry)itrMeasValMap.next();
																	if(measMPEntry!=null)
																	{
																		String s_measName=(String)measMPEntry.getKey();
																		JSONObject flowsDataObj = new JSONObject();
																		
																		String layerName=dashboardDAO.getLayerForTest(compType,s_test,s_measName);
																		String compTypeForAlarm=compType;
																		if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
																			compTypeForAlarm="Host_system";
																		String measureState=model.getTestMeasureState(compName,compTypeForAlarm,layerName,s_test+"-"+key,s_measName);
																		ArrayList compList = new ArrayList();
																		compList.add(compName);
																		compList.add(compType);
																		compList.add(compTypeForAlarm);
																		compList.add(layerName);
																		compList.add("");
																		compList.add(s_test);
																		compList.add(s_measName);
																		compList.add(msmthost);
																		String xml=(String)graphUtil.getXMLtoProtocol(s_measName,measValMap,chartAttributes,compList);
																			//xml="";									
																		if(xml!=null && !xml.equals(""))
																		{									
																			flowsDataObj.put("Interface",com.egurkha.util.StringUtils.replace(key, "+", ""));
																			flowsDataObj.put("XML_DATA",xml);							
																			flowsDataObj.put("width","400");
																			flowsDataObj.put("height","140"); 
																			flowsDataObj.put("SWF_PATH","/final/FusionCharts/swf/Pie3D.swf");
																		}
																		flowsObj.put(s_measName,flowsDataObj);
																		String dispKey=key;
																		if(dispKey!=null && dispKey.indexOf("+")==0)
																		{
																			dispKey=dispKey.substring(1);
																		}
																		flowsObj.put("info",dispKey);
																	}
																}
															}
															flowsArr.add(flowsObj);
														}
													}
												}
												MaxJSON.put(infoToPie.substring(infoToPie.indexOf("+")+1),BWMaxValue);
												flowInterfaceObj.put("MaxJSON",MaxJSON);
											}
										}
										//---------------piechart end-----------------------
										//--------------grid start -------------------------
										JSONArray sortedJsonArray = new JSONArray();
										if(isFromGridPage || allowGrid){
											Integer totalRecCount = new Integer(0);
											ArrayList comparisonViewData = new ArrayList();
											if(showVal.indexOf("TOP")>-1 || showVal.indexOf("LAST")>-1){
												Iterator iterator1 = interfaceSet.iterator();
												Object currentValuesForinfos[] = new Object[3];
												Hashtable currentValues= new Hashtable();
												ArrayList infosList= new ArrayList();
												while (iterator1.hasNext())
												{							
													String infoToPie = (String)iterator1.next();
													if(interfaceToViewList!=null && !interfaceToViewList.isEmpty())
													{
														String tmpinfoToPie = infoToPie;
														tmpinfoToPie =tmpinfoToPie.substring(1);;
														if(!interfaceToViewList.contains(tmpinfoToPie))
															continue;
													}
													ArrayList subInfo1 = (ArrayList)interfaceSubInfo.get(infoToPie);
													if(subInfo1 == null){
														continue;
													}
													currentValuesForinfos = dashboardDAO.getTopInfosForTest(hostName,portNo,testWithMeasuresList,msmthost,infoToPie,showVal,timeline,"flows",false);
													currentValues=(Hashtable)currentValuesForinfos[0];			
													infosList=(ArrayList)currentValuesForinfos[1];
													Double totalBytes=(Double)currentValuesForinfos[2];
													double BWMaxValue = 0.0;
													if(currentValues!=null && !currentValues.isEmpty() && infosList!=null && infosList.size()>0)
													{		
														String comboInfo = (String)infosList.get(0);
														if(comboInfo != null && flowsTestSeperator != null && comboInfo.indexOf(flowsTestSeperator)>0){
															comboInfo = comboInfo.substring(comboInfo.indexOf("+")+1,comboInfo.indexOf(flowsTestSeperator));
														}
														
														if(interfaceToViewList!=null && !interfaceToViewList.isEmpty())
														{
															if(!interfaceToViewList.contains(comboInfo))
																continue;
														}
														Iterator iter=infosList.iterator();
														int m=0;	
														while(iter.hasNext())
														{
															int colIdx = 0;
															JSONObject rowJson = new JSONObject();
															String key=(String)iter.next();												
															Hashtable valueTable = (Hashtable)currentValues.get(key);
															String info ="", subInfo = "";
															if(key != null && flowsTestSeperator !=null && key.indexOf(flowsTestSeperator)>0)
															{
																info = key.substring(0,key.indexOf(flowsTestSeperator));
																subInfo = key.substring(key.indexOf(flowsTestSeperator)+1);	
															}
															if(subInfo!=null && subInfo.indexOf(flowsTestSeperator)>-1)
															{
																subInfo = subInfo.substring(subInfo.indexOf(flowsTestSeperator)+1);
															}
															rowJson.put("COLUMVal_"+(colIdx++),subInfo);
															rowJson.put("COLUMVal_"+(colIdx++),com.egurkha.util.StringUtils.replace(info, "+", ""));
															String InterfaceSpeedVal = (String)dashboardDAO.getCurrentMeasure(hostName,portNo,info,"NetworkInterfaceTest","Speed",msmthost,"","");
															for(int k=1;k<internalHeaderName.size();k++)
															{
																String columnName = (String)internalHeaderName.get(k);
																String tmpName =columnName;
																String value = (String)valueTable.get(columnName);
																if(k==1){
																	if(value!=null)
																	{
																		double bytesInGB = Double.parseDouble(value)/(1024*1024);
																		value = String.valueOf(bytesInGB);
																		value = erutils.round (Double.parseDouble(value),4);
																		comparisonViewData.add(subInfo);
																		comparisonViewData.add(value);
																	}
																}
															/*	else if(k==3)
																{
																	columnName = (String)internalHeaderName.get(1);
																	value = (String)valueTable.get(columnName);
																	if(value!=null)
																	{
																		if(totalBytes != null){
																			double trafficPercent = (Double.parseDouble(value)/totalBytes)*100;
																			value = String.valueOf(trafficPercent);
																			value=erutils.round (Double.parseDouble(value),4);
																		}
																		else{
																			value = "-";
																		}
																	}
																}*/
																if(value!=null && value.startsWith("-") && !allowNegativeValues)
																{
																	value=iniui.getValue("MEASURE_LOOKUP",value);
																	if(value!=null && value.indexOf(":")>0)
																	{
																		value=value.substring(value.indexOf(":")+1,value.length());
																	}
																	if(value!=null && (value.equalsIgnoreCase("NS") || value.equalsIgnoreCase("NAP") || value.equalsIgnoreCase("UN") || value.equalsIgnoreCase("UL")))
																	{
																		value="NA";
																	}
																}
																if(k==9)
																{
																	columnName = (String)internalHeaderName.get(1);
																	value = (String)valueTable.get(columnName);
																	double kilobits = Double.parseDouble(value)*8;	
																	long timelineInSec = (long) dashboardDAO.getTimelineInSeconds(timeline);
																	double kilobitsPerSec = kilobits/timelineInSec;	
																	if(networkInterfaceTestInfos!=null && networkInterfaceTestInfos.contains(info))
																	{
																		if(!InterfaceSpeedVal.isEmpty())
																		{
																			double interfaceVal = Double.parseDouble(InterfaceSpeedVal)*1000;
																			if(value!=null && interfaceVal>0.0)
																			{
																				double BWPercent = (kilobitsPerSec/interfaceVal)*100;
																				value = String.valueOf(BWPercent);
																				value=erutils.round (Double.parseDouble(value),4);
																				if(Double.parseDouble(value)>BWMaxValue)
																					BWMaxValue = Double.parseDouble(value);
																			}
																			else
																				value = "-";
																		}
																		else
																			value = "-";
																	}
																	else
																		value = "-";
																}
																if(value!=null){
																	rowJson.put("COLUMVal_"+(colIdx++),value);
																}
																else{
																	rowJson.put("COLUMVal_"+(colIdx++),"-");
																}
															}
															jsonValues.add(rowJson);
														}											
													}
												}
												rootJson.put("barTitle",(showTitle+" "+pieHeader+" "+mappingInfo.getTextDescription("monitor.dashboard.by Data Flow (GB)")+" - "+ interfaceToView));
												String fontForLanguage="verdana";
												String fontSize="7.5";
												boolean isNonEnglishLanguage=((EgDbInfo.doubleByteEnabled && !trackerLanguage.equals("en_US")) || !trackerLanguage.equals("en_US"));

												if(isNonEnglishLanguage)
												{
														fontForLanguage=iniUI.getFontName();
														fontSize="12";
												}
												Vector comparionChartAttribute=new Vector();
												comparionChartAttribute.add("palette='2'");
												comparionChartAttribute.add("showValues='1'");
												comparionChartAttribute.add("showLabels='1'");
												comparionChartAttribute.add("showYAxisValues='0'");
												comparionChartAttribute.add("formatNumberScale='0'");
												comparionChartAttribute.add("useRoundEdges='1'");
												comparionChartAttribute.add("bgColor='ffffff'");
												comparionChartAttribute.add("showToolTipShadow='1'");
												comparionChartAttribute.add("chartLeftMargin='8'");
												comparionChartAttribute.add("chartRightMargin='8'");
												comparionChartAttribute.add("chartTopMargin='8'");
												comparionChartAttribute.add("chartBottomMargin='8'");
												comparionChartAttribute.add("exportEnabled='0'");
												comparionChartAttribute.add("exportAction='download'");
												comparionChartAttribute.add("exportAtClient='0'");
												comparionChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
												if(!isNonEnglishLanguage)
												{
													comparionChartAttribute.add("outCnvBaseFontSize='"+fontSize+"'");
													comparionChartAttribute.add("outCnvBaseFontColor ='000000'");
												}
												comparionChartAttribute.add("showBorder ='0'");
												comparionChartAttribute.add("canvasBorderColor  ='000000'");
												comparionChartAttribute.add("plotSpacePercent  ='40'");
												comparionChartAttribute.add("baseFont  ='"+fontForLanguage+"'");
												comparionChartAttribute.add("adjustDiv='1'");
												comparionChartAttribute.add("yAxisValueDecimals='2'");
												comparionChartAttribute.add("decimals='4'");
												comparionChartAttribute.add("placeValuesInside='0'");

												Map comparisonMap = new TreeMap();
												for(int i=0;i<comparisonViewData.size();i+=2)
												{
													String protocol = (String)comparisonViewData.get(i);
													String value = (String)comparisonViewData.get(i+1);
													comparisonMap.put(protocol,new Double(value));
												}
												comparisonMap=sortByValues(comparisonMap);
												String comparisonXml="";									
												comparisonXml=(String)graphUtil.getXMLforNetflowComparison(comparionChartAttribute,comparisonMap);

												JSONObject comparisonChartsObj = new JSONObject();
												if(comparisonMap!=null && comparisonMap.size()>0)
												{
													if(comparisonXml!=null && comparisonXml.trim().length()>0)
													{
														comparisonChartsObj.put("SWF_PATH", "/final/FusionCharts/swf/Bar2D.swf");
														comparisonChartsObj.put("XML_DATA", comparisonXml);
													}
													else
													{
														String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
														if(!(timeline.indexOf("Any")>-1)){
															NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for");
															NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
														}
														comparisonChartsObj.put("NoMeasure",NoMeasure);
													}
												}
												else
												{
													String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
													if(!(timeline.indexOf("Any")>-1)){
														NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for");
														NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
													}
													comparisonChartsObj.put("NoMeasure",NoMeasure);
												}
												rootJson.put("comparisonCharts",comparisonChartsObj);

											}
											/*else{
												ArrayList infoViewList = new ArrayList();
												if(interfaceToViewList!=null && interfaceToViewList.size()>0){
													for(int i=0;i<interfaceToViewList.size();i++)
													{
														String tmpInfo = (String)interfaceToViewList.get(i);
														infoViewList.add("+"+tmpInfo);
													}
												}
												else{
													Iterator iterator1 = interfaceSet.iterator();
													while (iterator1.hasNext())
													{							
														String tmpInfo = (String)iterator1.next();
														infoViewList.add(tmpInfo);
													}
												}
												Object currentValuesForinfos[] = dashboardDAO.getInfosForGrid(hostName,portNo,testWithMeasuresList,msmthost,infoViewList,showVal,timeline,"protocols",startIndex+1,startIndex+limit);
												Hashtable currentValues=(Hashtable)currentValuesForinfos[0];			
												ArrayList infosList=(ArrayList)currentValuesForinfos[1];
												HashMap totalBytesInfo = (HashMap)currentValuesForinfos[2];
												totalRecCount = (Integer)currentValuesForinfos[3];
												double BWMaxValue = 0.0;
												if(currentValues!=null && !currentValues.isEmpty() && infosList!=null && infosList.size()>0)
												{		
													String comboInfo = (String)infosList.get(0);
													if(comboInfo != null && flowsTestSeperator != null && comboInfo.indexOf(flowsTestSeperator)>0){
														comboInfo = comboInfo.substring(comboInfo.indexOf("+")+1,comboInfo.indexOf(flowsTestSeperator));
													}
																									
													Iterator iter=infosList.iterator();
													int m=0;	
													while(iter.hasNext())
													{
														int colIdx = 0;
															
														JSONObject rowJson = new JSONObject();
														String key=(String)iter.next();												
														Hashtable valueTable = (Hashtable)currentValues.get(key);
														String info ="", subInfo = "";
														if(key != null && flowsTestSeperator !=null && key.indexOf(flowsTestSeperator)>0)
														{
															info = key.substring(0,key.indexOf(flowsTestSeperator));
															subInfo = key.substring(key.indexOf(flowsTestSeperator)+1);	
														}
														if(subInfo!=null && subInfo.indexOf(flowsTestSeperator)>-1)
														{
															subInfo = subInfo.substring(subInfo.indexOf(flowsTestSeperator)+1);
														}
														rowJson.put("COLUMVal_"+(colIdx++),subInfo);
														rowJson.put("COLUMVal_"+(colIdx++),com.egurkha.util.StringUtils.replace(info, "+", ""));
															
														String InterfaceSpeedVal = (String)dashboardDAO.getCurrentMeasure(hostName,portNo,info,"NetworkInterfaceTest","Speed",msmthost,"","");
															
														for(int k=1;k<internalHeaderName.size();k++)
														{
															String columnName = (String)internalHeaderName.get(k);
															String tmpName =columnName;
															String value = (String)valueTable.get(columnName);
															if(k==1){
																if(value!=null)
																{
																	double bytesInGB = Double.parseDouble(value)/(1024*1024);
																	value = String.valueOf(bytesInGB);
																	value = erutils.round (Double.parseDouble(value),4);
																}
															}
															if(k==3)
															{
																columnName = (String)internalHeaderName.get(1);
																value = (String)valueTable.get(columnName);
																if(value!=null)
																{
																	String total = (String) totalBytesInfo.get(info);
																	if(total != null){
																		double totalBytes= Double.parseDouble(total);
																		double trafficPercent = (Double.parseDouble(value)/totalBytes)*100;
																		value = String.valueOf(trafficPercent);
																		value=erutils.round (Double.parseDouble(value),4);
																	}
																	else {
																		value = "-";
																	}
																}
															}
															if(value!=null && value.startsWith("-") && !allowNegativeValues)
															{
																value=iniui.getValue("MEASURE_LOOKUP",value);
																if(value!=null && value.indexOf(":")>0)
																{
																	value=value.substring(value.indexOf(":")+1,value.length());
																}
															}
															if(k==4)
															{
																columnName = (String)internalHeaderName.get(1);
																value = (String)valueTable.get(columnName);
																double kilobits = Double.parseDouble(value)*8;	
																long timelineInSec = (long) dashboardDAO.getTimelineInSeconds(timeline);
																double kilobitsPerSec = kilobits/timelineInSec;	
																if(networkInterfaceTestInfos!=null && networkInterfaceTestInfos.contains(info))
																{
																	if(!InterfaceSpeedVal.isEmpty())
																	{
																		double interfaceVal = Double.parseDouble(InterfaceSpeedVal)*1000;
																		if(value!=null && interfaceVal>0.0)
																		{
																			double BWPercent = (kilobitsPerSec/interfaceVal)*100;
																			value = String.valueOf(BWPercent);
																			value=erutils.round (Double.parseDouble(value),4);
																			if(Double.parseDouble(value)>BWMaxValue)
																				BWMaxValue = Double.parseDouble(value);
																		}
																		else
																			value = "-";
																	}
																	else
																		value = "-";
																}
																else
																	value = "-";
															}
															if(value!=null){
																rowJson.put("COLUMVal_"+(colIdx++),value);
															}
															else{
																rowJson.put("COLUMVal_"+(colIdx++),"-");
															}
														}
														jsonValues.add(rowJson);
													}											
												}
											}*/
											if(jsonValues!=null && jsonValues.size()>0)
											{
													Collections.sort( jsonValues, new Comparator<JSONObject>() {
																								
														public int compare(JSONObject a, JSONObject b) {
															double valA =0.0;
															double valB =0.0;

															try {
																String value1 = (String) a.get("COLUMVal_2");
																String value2 = (String) b.get("COLUMVal_2");
																if(!value1.equals("-")  && !value1.equals("NA")){
																	valA = Double.parseDouble(value1);
																}
																if(!value2.equals("-") && !value2.equals("NA")){
																	valB = Double.parseDouble(value2);
																}
															} 
															catch (JSONException e) {
																//do something
															}
															return Double.compare(valA, valB);
														}
													});
													Collections.sort( jsonValues, new Comparator<JSONObject>() {
																					
														public int compare(JSONObject a, JSONObject b) {
															double valA =0.0;
															double valB =0.0;

															try {
																String value1 = (String) a.get("COLUMVal_5");
																String value2 = (String) b.get("COLUMVal_5");
																if(!value1.equals("-")  && !value1.equals("NA")){
																	valA = Double.parseDouble(value1);
																}
																if(!value2.equals("-")  && !value2.equals("NA")){
																	valB = Double.parseDouble(value2);
																}
															} 
															catch (JSONException e) {
																//do something
															}
															String subInfoVal = (String) a.get("COLUMVal_1");
															String subInfoVal1 = (String) b.get("COLUMVal_1");
															if(subInfoVal.equalsIgnoreCase("Others") || subInfoVal1.equalsIgnoreCase("Others")){
																if(!subInfoVal.equalsIgnoreCase("Others") && subInfoVal1.equalsIgnoreCase("Others")){
																	return 1;
																}
																else if(subInfoVal.equalsIgnoreCase("Others") && !subInfoVal1.equalsIgnoreCase("Others")){
																	return -1;
																}
																else{
																	return Double.compare(valA, valB);
																}
															}
															else {
																return Double.compare(valA, valB);
															}
														}
													});
													for (int i = jsonValues.size()-1; i > -1 ; i--) {
														sortedJsonArray.add(jsonValues.get(i));
														if(!showVal.equalsIgnoreCase("All")){
															String tempPriority=showVal.substring(showVal.indexOf("-")+2);
															int priority = Integer.parseInt(tempPriority);
															if(sortedJsonArray.size()== priority){
																break;
															}
														}
													}
																			
													gridJson.put("errorMsg","-");
													if(showVal.equalsIgnoreCase("All")){
														rootJson.put("totalCount",totalRecCount);
													}else{
														rootJson.put("totalCount",sortedJsonArray.size());
													}
													if(sortedJsonArray!= null){
														if(showVal.equalsIgnoreCase("All")){
															rootJson.put("gridValues",sortedJsonArray); 
														}
														else {
															JSONArray sortedJsonArray1 = new JSONArray();
															if(startGridIndex !=null && limitIndex!=null){
																for (int i = startIndex; i < startIndex+limit ; i++) {
																	sortedJsonArray1.add(sortedJsonArray.getJSONObject(i));
																	if(i+2> sortedJsonArray.size()){
																		break;
																	}
																}

																rootJson.put("gridValues",sortedJsonArray1); 
															}
														}
													}
												}
											}

										//---------------grid end----------------------
										rootJson.put("flowsInterfaceCombo",flowsInterfaceCombo);
										if(flowsArr!=null )
										{
											flowInterfaceObj.put("pieChart",flowsArr);
											gridJson.put("tableColumns",colArr);
										}
										if(gridJson!=null && !gridJson.isEmpty() && sortedJsonArray.size()>0)
										{
											gridJsons.add(gridJson);	
											flowInterfaceObj.put("Data","true");
											flowInterfaceObj.put("tableData",gridJsons);
										}
										else
										{
											flowInterfaceObj.put("Data","false");
										}
									}	
								}
							}
						}
						flowInterfaceObj.put("mappingName",sb.toString());
						String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
						if(!(timeline.indexOf("Any")>-1)){
							NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No data found for");
							NoMeasure += " "+mappingInfo.getTextDescription("monitor.dashboard.last")+" "+timeline+"!";
						}
						flowInterfaceObj.put("ErrorMsg",NoMeasure);
						
						rootJson.put("NoMeasureMsg",NoMeasure);
						flowsPieData.put("DATA_"+j,flowInterfaceObj);
						flowsPieArr.add(flowsPieData);
						rootJson.put("flowsPieArr",flowsPieArr);
					}
					else
					{			
						flowInterfaceObj.put("Data","false");
						flowInterfaceObj.put("mappingName",sb.toString());
						flowInterfaceObj.put("ErrorMsg",mappingInfo.getTextDescription("monitor.common.The test has been disabled"));
						flowsPieData.put("DATA_"+j,flowInterfaceObj);
						flowsPieArr.add(flowsPieData);
						rootJson.put("flowsPieArr",flowsPieArr);						
					}
					j++;					
				}
			}
		}
		rootJson.put("flowsInterfaceCombo",flowsInterfaceCombo);
	}
	
		
	out.println(rootJson.toString());
	String requestData = ErUtils.prepareQueryString(request.getParameterMap());	
	String beforeInfoStr = "",afterInfoStr="",infos="";
	if(requestData.indexOf("infosToArea=")>0){
		beforeInfoStr=requestData.substring(0,requestData.indexOf("&infosToArea=")+13);
		afterInfoStr=requestData.substring(requestData.indexOf("&infosToArea=")+13);
		infos = afterInfoStr.substring(0,afterInfoStr.indexOf("&")); 
		afterInfoStr = afterInfoStr.substring(afterInfoStr.indexOf("&"));
		requestData=beforeInfoStr+EgURLEncoder.encode(infos,"UTF-8")+afterInfoStr;
	}
	if(requestData.indexOf("interfaceToView=")>0){
		beforeInfoStr=requestData.substring(0,requestData.indexOf("&interfaceToView=")+17);
		afterInfoStr=requestData.substring(requestData.indexOf("&interfaceToView=")+17);
		infos = afterInfoStr.substring(0,afterInfoStr.indexOf("&")); 
		afterInfoStr = afterInfoStr.substring(afterInfoStr.indexOf("&"));
		requestData=beforeInfoStr+EgURLEncoder.encode(infos,"UTF-8")+afterInfoStr;
	}
	if(requestData!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&comptype="+request.getParameter("compType")+"&host="+request.getParameter("hostName")+"&tab="+tab+"&graphType=&toDashBoardLayer=true&"+requestData);
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab="+tab+"&toDashBoardLayer=true&ciscoSelectedType="+ciscoSelectedType);
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
}
catch(Exception e)
{
	e.printStackTrace();
}
%>
<%! 
public HashMap sortByValues(Map map) { 
	   List list = new LinkedList(map.entrySet());
	   // Defined Custom Comparator here
	   Collections.sort(list, new Comparator() {
			public int compare(Object o1, Object o2) {
			   return ((Comparable) ((Map.Entry) (o2)).getValue())
				  .compareTo(((Map.Entry) (o1)).getValue());
			}
	   });

	   // Here I am copying the sorted list in HashMap
	   // using LinkedHashMap to preserve the insertion order
	   HashMap sortedHashMap = new LinkedHashMap();
	   for (Iterator it = list.iterator(); it.hasNext();) {
			  Map.Entry entry = (Map.Entry) it.next();
			  String key = (String)entry.getKey();
			  Double measValDbl=(Double)entry.getValue();
			  String value = measValDbl.toString();
			  sortedHashMap.put(key, value);
	   } 
	   return sortedHashMap;
  }
%> 

