<%
/***********************************************************************************
*		Name					:egUnplannedMaintenancePolicyList.jsp
*		Purpose				:HomePage for unassociated Policies
*		Version					:4.3
*		CreationDate		:12/09/2008
*		Author					:Rajesh
***********************************************************************************/
%>
<%@	taglib prefix =	"egui" uri = "../../../WEB-INF/eg-taglib.tld"	%>
<%@ include file= "../../EgTrackerAJSON.jsp"%>
<%@	page import="com.egurkha.admin.EgMaintenanceUtility"%>
<%@	page import="com.egurkha.admin.EgMaintenanceTree"%>
<%@	page import="java.util.Hashtable"%>
<%@	page import="java.util.Vector"%>
<%@	page import="java.util.*"%>
<%@	page import="com.egurkha.util.*"%>
<%@	page import="com.egurkha.User"%>
<%@ page import="com.eg.EgRoleInfo"%>
<%@	page import="com.eg.*"%>
<%@	page import="net.sf.json.*"%>

<%@	page language="java" contentType="application/json; charset=UTF-8"	pageEncoding="UTF-8" %>

<%
	String uiFile = "eg_ui.ini";
	User usr = UserRegistry.getInstance().getUser(session.getId());
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String userDtFormat = usr.getUserDateFormat();
	if(userDtFormat != null && userDtFormat.length() > 0)
	{
		if(userDtFormat.equalsIgnoreCase("default"))
			userDtFormat = currentDateFormat;
	}

response.setHeader("Cache-Control","no-store");
response.setHeader("Pragma","no-cache");
response.setDateHeader("Expires", -1);
String egTitleSearchStr=request.getParameter("egTitleSearchStr");
String groupNameFromLink=request.getParameter("groupNameFromLink");
String policyToView=request.getParameter("policyToView");
String FromTabWork=request.getParameter("FromTabWork");
String linkFrom=request.getParameter("linkFrom");
String from=request.getParameter("from");
String userName =  usr.getLoginID();//(String)session.getAttribute("sess_userid");

EgRoleInfo roleInfo = EgRoleInfo.getInstance(session.getId(),userName);
String keyForDisplay=null;

if(egTitleSearchStr!=null)
	egTitleSearchStr=egTitleSearchStr.trim();
egTitleSearchStr=StringUtils.decodeSecurityChar(egTitleSearchStr);
boolean	isSearchStrNotFound=true;

EgMaintenanceUtility maintenanceUtil=new EgMaintenanceUtility(sessionID,u_rs);
EgMaintenanceTree	 maintenanceTree=new EgMaintenanceTree();
maintenanceUtil.setUserDateFormat(userDtFormat);

Vector unplannedpolicies=maintenanceTree.getAllUnplannedMaintenancePolicies();
//Vector unplannedpoliciesTimeZoneOptions=maintenanceTree.getAllUnplannedMaintenanceTimeZonePolicies();
boolean isLimitedAdmin = !roleInfo.hasAllComponentAccess();
/*if (isLimitedAdmin) //If limited admin then Show user specific policies alone
{
	if (unplannedpolicies != null && unplannedpolicies.size() > 0)
	{
		ArrayList tempList = new ArrayList();
		for (int t=0; t < unplannedpolicies.size(); t++)
		{
			String policy = (String)unplannedpolicies.get(t);
			int tmpInd  = policy.indexOf("|$|");
			if (tmpInd > -1)
			{
				String policyUser = policy.substring(tmpInd+3);
				if (policyUser.equalsIgnoreCase(userName))
				{
					tempList.add(policy);
				}
			}
		}
		unplannedpolicies.retainAll(tempList);
	}
}*/
if(FromTabWork==null)
{
	FromTabWork="false";
}

if(policyToView!=null && !policyToView.equals("")) 
{
	unplannedpolicies.clear();
	unplannedpolicies.add(policyToView);
}
String pageTitle="Quick Maintenance Policies";

String policyNameToDisplay = policyToView; //Limited admin
policyNameToDisplay = maintenanceUtil.getPolicyDisplayName(policyNameToDisplay,isLimitedAdmin);

if(policyToView!=null && !policyToView.equals("")) 
{
	pageTitle="Policy Details -	"+policyNameToDisplay;	
}

Collections.sort(unplannedpolicies,String.CASE_INSENSITIVE_ORDER);
String pageurl="";
if(policyToView!=null && !policyToView.equals("")) 
{
	pageurl="listSearch.jsp?title="+pageTitle+"&subtitle=true&searchBox=false";
}
else 
{
	pageurl="listSearch.jsp?title="+pageTitle+"&subtitle=true&searchBox=true";
}
	boolean allPolicy=false;
	if(policyToView==null || policyToView.equals(""))
	{
		allPolicy=true;
	}

	int	searchNoOfOccurance=0;
	Iterator groupsItr=unplannedpolicies.iterator();

	for(int	i=0;i<unplannedpolicies.size();i++) 
	{
		String policyName=(String)unplannedpolicies.get(i);
		if(egTitleSearchStr!=null && policyName!=null) 
		{
			StringTokenizer st=new StringTokenizer(egTitleSearchStr," ");
			while(st.hasMoreTokens())
			{
				String searchStr=st.nextToken();
				if(searchStr!=null && policyName!=null && (policyName.toUpperCase()).indexOf(searchStr.toUpperCase())!=-1) 
				{
					searchNoOfOccurance++;
				}
			}
		}
		else if(egTitleSearchStr!=null)
		{
			searchNoOfOccurance++;
		}
	}
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	Iterator policyItr=unplannedpolicies.iterator();
	String display="";
	int	index=0;
	boolean	isPoliciesFound=false;
	int	divId=0;
	screenLabels.put("Policy_Name",_mapping.getTextDescription("admin.mpolicy.Policy Name"));
	screenLabels.put("TimeFrequency",_mapping.getTextDescription("admin.mpolicy.Time Frequency"));
	screenLabels.put("Timeline",_mapping.getTextDescription("admin.mpolicy.Timeline"));
	screenLabels.put("Host",_mapping.getTextDescription("admin.mpolicy.Host"));
	screenLabels.put("Component",_mapping.getTextDescription("admin.mpolicy.Component"));
	screenLabels.put("Test",_mapping.getTextDescription("admin.mpolicy.Test"));
	screenLabels.put("Host_Tests",_mapping.getTextDescription("admin.mpolicy.Host Tests"));
	screenLabels.put("Component_Tests",_mapping.getTextDescription("admin.mpolicy.Component Tests"));
	screenLabels.put("Test_Descriptors",_mapping.getTextDescription("admin.mpolicy.Test Descriptors"));
	screenLabels.put("Component_Descriptors",_mapping.getTextDescription("admin.mpolicy.Component Descriptors"));
	screenLabels.put("AssociatedElements",_mapping.getTextDescription("admin.mpolicy.Associated Elements"));
	if(unplannedpolicies!=null && unplannedpolicies.size()>0)	
	{
		JSONArray policyListData =  new JSONArray();
		while(policyItr.hasNext()) 
		{
			divId++;
			index++;
			isPoliciesFound=true;
			String policyName=(String)policyItr.next();
			String policyToDisplay = policyName; //Limited admin
			policyToDisplay = maintenanceUtil.getPolicyDisplayName(policyToDisplay,isLimitedAdmin);
			
			boolean isPolicyRelatedToCurrentLimitedUser = false;
							
			boolean isPolicyMatchWithSearch=false;
			if(egTitleSearchStr!=null && egTitleSearchStr.length()>0)
			{
				StringTokenizer searchTokenizer=new StringTokenizer(egTitleSearchStr," ");
				while(searchTokenizer.hasMoreTokens())
				{
					String searchToken=searchTokenizer.nextToken();
					if((searchToken!=null) && ((policyName.toUpperCase()).indexOf(searchToken.toUpperCase())!=-1))
					{
						isPolicyMatchWithSearch=true;
						break;
					}
				}
			}
			else if(egTitleSearchStr!=null)
			{
				isPolicyMatchWithSearch=true;
			}
			JSONObject jOpt = new JSONObject();
			if((egTitleSearchStr==null)||(policyName!=null && isPolicyMatchWithSearch))
			{
				isSearchStrNotFound=false;
				jOpt.put("Policyname",policyToDisplay);
				jOpt.put("Internal_Policyname", policyName);

				boolean isToShowTimeZoneIcon = false;
				//if(unplannedpoliciesTimeZoneOptions!=null && unplannedpoliciesTimeZoneOptions.size()>0 && unplannedpoliciesTimeZoneOptions.contains(policyName))
					//isToShowTimeZoneIcon = true;

				jOpt.put("isToShowTimeZoneIcon", isToShowTimeZoneIcon);

				if(divId%2==0)
				{
					jOpt.put("bg","tableTrBgEven");
				}
				else
				{
					jOpt.put("bg","tableTrBgOdd");
				}

				boolean	policyFlag=false;
				int	policyIndex=0;

				Hashtable timeConstraints=maintenanceUtil.getUnplannedMaintenancePolicyTimeLines(policyName);

				Vector timeConsKeys=new Vector();
				timeConsKeys.add("Sunday");
				timeConsKeys.add("Monday");
				timeConsKeys.add("Tuesday");
				timeConsKeys.add("Wednesday");
				timeConsKeys.add("Thursday");
				timeConsKeys.add("Friday");
				timeConsKeys.add("Saturday");
				timeConsKeys.add("Daily");
				timeConsKeys.add("First Day of Month");
				timeConsKeys.add("Last Day of Month");

				Set timeKeyset=timeConstraints.keySet();
				ArrayList keyFrTimeConstaints = new ArrayList(timeKeyset);
				//Collections.sort(keyFrTimeConstaints,new EgMaintenanceUtility());
				timeConsKeys.retainAll(keyFrTimeConstaints);
				Iterator timeKeysetItr=keyFrTimeConstaints.iterator();
				while(timeKeysetItr.hasNext())
				{
					String key=(String)timeKeysetItr.next();
					if(!timeConsKeys.contains(key))
					{
						timeConsKeys.add(key);
					}
				}

				Iterator timeConstraintsKeysItr=timeConsKeys.iterator();
				JSONArray timeFreqArr = new JSONArray();
				JSONArray timePeriodArr = null;
				while(timeConstraintsKeysItr.hasNext())
				{
					String key=(String)timeConstraintsKeysItr.next();
					String timePeriods="";
					String timeConstraintStr="";
					Vector value=(Vector)timeConstraints.get(key);
					timePeriodArr = new JSONArray();
					for(int	i=0;i<value.size();i++)
					{
						timePeriods=(String)value.get(i);
						JSONObject timePeriodOpt = new JSONObject();
						timePeriodOpt.put("timePeriods",timePeriods);
						timePeriodArr.add(timePeriodOpt);
//						timePeriods+="<br>";
					}
					JSONObject timeFreqObj = new JSONObject();
					if(key!=null && key.indexOf("-")>0)
					{
						timeFreqObj.put("date",key);
					}
					else
					{
						timeFreqObj.put("date",_mapping.getTextDescription("admin.mpolicy."+key));
					}
					timeFreqObj.put("time",timePeriodArr);

					timeFreqArr.add(timeFreqObj);
					
				}
				jOpt.put("TimeFrequency",timeFreqArr);
				policyIndex++;
				if(allPolicy)
				{
					policyToView=policyName;
				}
				if(maintenanceUtil.isUnplannedPolicyAssociated(policyToView))
				{
					JSONArray assElementsJson=new JSONArray();
					boolean	hostFlag=false;
					String hostStr="";
					String hostStr1="";
					Vector host=maintenanceUtil.getAssociatedHostsForUnplannedPolicy(policyToView);
					Iterator hostItr=host.iterator();
					if(hostItr.hasNext()) 
					{
						while(hostItr.hasNext())
						{
							String hostName=(String)hostItr.next();
							hostStr1+=hostName;
							hostStr+=hostName;

							if(hostItr.hasNext()) 
							{
								hostStr+="<br>";
								hostStr1+=", ";
							}
						}
					}
					JSONObject assoOpt=null;
					if(!StringUtils.isNull(hostStr1))
					{
						assoOpt=new JSONObject();
						assoOpt.put("AssciatedName",_mapping.getTextDescription("admin.mpolicy.Host"));
						assoOpt.put("AssciatedValue",hostStr1);
						assElementsJson.add(assoOpt);
					}
					boolean	componentFlag=false;
					String componentStr="";
					String componentStr1="";
					Vector component=maintenanceUtil.getAssociatedComponentsForUnplannedPolicy(policyToView);
					Iterator componentItr=component.iterator();
					if(componentItr.hasNext()) 
					{
						while(componentItr.hasNext()) 
						{
							String componentName=(String)componentItr.next();
							if(componentName.indexOf(":NULL")!=-1)
							{
								componentName=componentName.substring(0,componentName.indexOf(":NULL"));
							}
							componentStr+=componentName;
							componentStr1+=componentName;
							if(componentItr.hasNext()) 
							{
								componentStr+="<br>";
								componentStr1+=", ";
							}
						}
					}
					if(!StringUtils.isNull(componentStr1))
					{
						assoOpt=new JSONObject();
						assoOpt.put("AssciatedName",_mapping.getTextDescription("admin.mpolicy.Component"));
						assoOpt.put("AssciatedValue",componentStr1);
						assElementsJson.add(assoOpt);
					}

					boolean	testFlag=false;
					String testStr="";
					String testStr1="";
					Vector test=maintenanceUtil.getAssociatedTestsForUnplannedPolicy(policyToView);
					Iterator testItr=test.iterator();
					if(testItr.hasNext())
					{
						while(testItr.hasNext())
						{
							String testName=(String)testItr.next();
							testStr+=_mapping.getTestDescription(testName);
							testStr1+=_mapping.getTestDescription(testName);
							if(testItr.hasNext()) 
							{
								testStr+="<br>";
								testStr1+=", ";
							}
						}
					}
					if(!StringUtils.isNull(testStr1))
					{
						assoOpt=new JSONObject();
						assoOpt.put("AssciatedName",_mapping.getTextDescription("admin.mpolicy.Test"));
						assoOpt.put("AssciatedValue",testStr1);
						assElementsJson.add(assoOpt);
					}

					boolean	wildcardFlag=false;
					String wildcardStr="";
					String wildcardStr1="";
					HashSet wildcard=maintenanceUtil.getAssociatedWildcardForUnplannedPolicy(policyToView);
						
					Iterator wildcardItr=wildcard.iterator();
					if(wildcardItr.hasNext()) 
					{
						while(wildcardItr.hasNext())
						{
							String wildcardName=(String)wildcardItr.next();
							wildcardStr1+=wildcardName;
							wildcardStr+=wildcardName;

							if(wildcardItr.hasNext()) 
							{
								wildcardStr+="<br>";
								wildcardStr1+=", ";
							}
						}
					}
					if(!StringUtils.isNull(wildcardStr1))
					{
						assoOpt=new JSONObject();
						assoOpt.put("AssciatedName",_mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop - By pattern"));
						assoOpt.put("AssciatedValue",wildcardStr1);
						assElementsJson.add(assoOpt);
					}

					if(assElementsJson!=null && !assElementsJson.isEmpty())
					{
						jOpt.put("AssociatedElements",assElementsJson);
					}
					else
					{
						jOpt.put("AssociatedElements","");
					}
					JSONArray assoElemsForCompTest=new JSONArray();
					int	hostTestIndex=0;
					String hostTestStr="<table width='100%'	height='100%' class='lineborder' style='border-bottom-width:0px'	border='0' cellspacing='0' cellpadding='2' ><tr><td	class='linebottomright linebg'>Test</td><td	class='linebottom linebg'>Host</td></tr>";

					Hashtable hostTest=maintenanceUtil.getAssociatedTestForHostsInUnplannedPolicy(policyToView);
					Vector hostTestVector=new Vector();

					hostTestVector.addAll(hostTest.keySet());
					boolean	hostTestFlag=false;

					if(hostTestVector.size()>0)	
					{
						Collections.sort(hostTestVector,String.CASE_INSENSITIVE_ORDER);

						if(hostTestVector.size()>2)
							hostTestFlag=true;

						JSONObject assoElemOpt=new JSONObject();
						JSONArray hostTestJsonArr=new JSONArray();
						
						for(int	i=0;i<hostTestVector.size();i++) 
						{
							String hostTestsStr="";
							String testname=(String)hostTestVector.get(i);
							hostTestStr+="<tr valign='top'><td class='linebottomright linebg2'>"+_mapping.getTestDescription(testname)+"</td><td class='linebottom linebg2'>";
							Vector hosts=(Vector)hostTest.get(testname);
							if(hosts!=null && hosts.size()>0)
							{
								Collections.sort(hosts,String.CASE_INSENSITIVE_ORDER);
								String hostsInStr="";
								for(int	j=0;j<hosts.size();j++)	
								{
									//hostTestStr+=hosts.get(j)+"<br>";
									hostsInStr+=hosts.get(j);
									if(j<hosts.size()-1)
										hostsInStr+=", ";
								}
								hostTestsStr+=hostsInStr;
								JSONObject jOpt1=new JSONObject();
								String testDispName = _mapping.getTestDescription(testname);
								jOpt1.put("AssciatedName",testDispName);
								jOpt1.put("AssciatedValue",hostsInStr);
								hostTestJsonArr.add(jOpt1);								
							}
							hostTestIndex++;
						}
						if(hostTestJsonArr!=null && !hostTestJsonArr.isEmpty())
						{
							assoElemOpt.put("AssociatedTitle",_mapping.getTextDescription("admin.mpolicy.Host Tests"));
							assoElemOpt.put("AssciatedName1",_mapping.getTextDescription("admin.mpolicy.Test"));
							assoElemOpt.put("AssciatedName2",_mapping.getTextDescription("admin.mpolicy.Host"));
							assoElemOpt.put("AssociateTitleobj",hostTestJsonArr);
						}		
						if(assoElemOpt!=null && !assoElemOpt.isEmpty())
						{
							assoElemsForCompTest.add(assoElemOpt);
						}
					}
					
					int	componentTestIndex=0;
					boolean	componentTestFlag=false;
					String compName="";
					String compTest="";
					Hashtable componentTest=maintenanceUtil.getAssociatedTestForComponentsInUnplannedPolicy(policyToView);
					Vector componetTestVector=new Vector();
					componetTestVector.addAll(componentTest.keySet());
					//String compTestsStr="";
					if(componetTestVector.size()>0)	
					{
						Collections.sort(componetTestVector,String.CASE_INSENSITIVE_ORDER);
						if(componetTestVector.size()>2)
							componentTestFlag=true;

						JSONObject assoElemOpt=new JSONObject();
						
						JSONArray compTestJsonArr=new JSONArray();
						for(int	i=0;i<componetTestVector.size();i++)
						{
							String testname=(String)componetTestVector.get(i);
							Vector components=(Vector)componentTest.get(testname);
							Collections.sort(components,String.CASE_INSENSITIVE_ORDER);
							//String componentsInStr="";
							String tempComp=""; 
							for(int	j=0;j<components.size();j++) 
							{
								tempComp =(String)components.get(j);
								if(tempComp.endsWith(":NULL"))
								{
									tempComp = tempComp.substring(0,tempComp.indexOf(":NULL"));
								}
								JSONObject jOpt1=new JSONObject();
								String testDispName = _mapping.getTestDescription(testname);
								jOpt1.put("AssciatedName",testDispName);
								jOpt1.put("AssciatedValue",tempComp);
								compTestJsonArr.add(jOpt1);

								//componentsInStr+=tempComp;
								//if(j<components.size()-1)
									//componentsInStr+=",	";
							}
							//compTestsStr+=componentsInStr;
						}
						if(compTestJsonArr!=null && !compTestJsonArr.isEmpty())
						{
							assoElemOpt.put("AssociatedTitle",_mapping.getTextDescription("admin.mpolicy.Component Tests"));
							assoElemOpt.put("AssciatedName1",_mapping.getTextDescription("admin.mpolicy.Test"));
							assoElemOpt.put("AssciatedName2",_mapping.getTextDescription("admin.mpolicy.Component"));
							assoElemOpt.put("AssociateTitleobj",compTestJsonArr);
						}	
						if(assoElemOpt!=null && !assoElemOpt.isEmpty())
						{
							assoElemsForCompTest.add(assoElemOpt);
						}
					}
					int	desTestIndex=0;
					boolean	desTestFlag=false;

					Hashtable testDescriptor=maintenanceUtil.getAssociatedTestDescriptorForUnplannedPolicy(policyToView);
					Vector DesTestVector=new Vector();
					DesTestVector.addAll(testDescriptor.keySet());

					if(DesTestVector.size()>0)	
					{
						Collections.sort(DesTestVector,String.CASE_INSENSITIVE_ORDER);
						if(DesTestVector.size()>2)
							desTestFlag=true;

						JSONObject assoElemOpt=new JSONObject();
						
						JSONArray descJsonArr=new JSONArray();
						for(int	i=0;i<DesTestVector.size();i++)
						{
							String testname=(String)DesTestVector.get(i);
							ArrayList desobj=(ArrayList)testDescriptor.get(testname);
							Collections.sort(desobj,String.CASE_INSENSITIVE_ORDER);
							String InfoInStr="";
							for(int	j=0;j<desobj.size();j++) 
							{
								InfoInStr+=desobj.get(j);
								if(j<desobj.size()-1)
									InfoInStr+=",	";
							}
							JSONObject jOpt1=new JSONObject();
							String testDispName = _mapping.getTestDescription(testname);
							jOpt1.put("AssciatedName",testDispName);
							jOpt1.put("AssciatedValue",InfoInStr);
							descJsonArr.add(jOpt1);
						}
						if(descJsonArr!=null && !descJsonArr.isEmpty())
						{
							assoElemOpt.put("AssociatedTitle",_mapping.getTextDescription("admin.mpolicy.Descriptors"));
							assoElemOpt.put("AssciatedName1",_mapping.getTextDescription("admin.mpolicy.Test"));
							assoElemOpt.put("AssciatedName2",_mapping.getTextDescription("admin.mpolicy.Descriptors"));

							assoElemOpt.put("AssociateTitleobj",descJsonArr);
						}	
						if(assoElemOpt!=null && !assoElemOpt.isEmpty())
						{
							assoElemsForCompTest.add(assoElemOpt);
						}
					}
					int	descompIndex=0;
					boolean	descompFlag=false;

					Hashtable compDescriptor=maintenanceUtil.getAssociatedComponentDescriptorForUnplannedPolicy(policyToView);
					Vector DesCompVector=new Vector();
					DesCompVector.addAll(compDescriptor.keySet());

					if(DesCompVector.size()>0)	
					{
						Collections.sort(DesCompVector,String.CASE_INSENSITIVE_ORDER);
						if(DesCompVector.size()>2)
							descompFlag=true;

						JSONObject assoElemOpt=new JSONObject();
						
						JSONArray compDescJsonArr=new JSONArray();
						for(int	i=0;i<DesCompVector.size();i++)
						{
							String compname=(String)DesCompVector.get(i);
							ArrayList desob=(ArrayList)compDescriptor.get(compname);
							if(compname.endsWith(":NULL"))
							{
								compname=compname.substring(0,compname.lastIndexOf(":"));
							}
							Collections.sort(desob,String.CASE_INSENSITIVE_ORDER);
							HashMap descCompMap = new HashMap();
							for(int	j=0;j<desob.size();j++) 
							{
								String info1=(String)desob.get(j);
								String testName = info1.substring(0,info1.indexOf(":"));
								String info2=info1.substring(info1.indexOf(":")+1,info1.length());
								if(descCompMap.containsKey(testName))
								{
									String Descvalue = (String)descCompMap.get(testName);
									descCompMap.put(testName,Descvalue+","+info2);
								}
								else
								{
									descCompMap.put(testName,info2);
								}								
							}							
							Set set=descCompMap.entrySet();  
							Iterator itr=set.iterator();
							while(itr.hasNext())
							{  
								JSONObject jOpt1=new JSONObject();
								jOpt1.put("AssociatedTitle",_mapping.getTextDescription("admin.mpolicy.Descriptors for Component"));
								jOpt1.put("AssciatedName",compname);
								Map.Entry m=(Map.Entry)itr.next();
								String testName = (String)m.getKey();
								String info = (String)m.getValue();
								jOpt1.put("TestName",_mapping.getTestDescription(testName));
								jOpt1.put("AssciatedValue",info);
								compDescJsonArr.add(jOpt1);
							 }
						}
						if(compDescJsonArr!=null && !compDescJsonArr.isEmpty())
						{
							assoElemOpt.put("AssociatedTitle",_mapping.getTextDescription("admin.mpolicy.Descriptors for Component"));
							assoElemOpt.put("AssciatedName1",_mapping.getTextDescription("admin.mpolicy.Component"));
							assoElemOpt.put("AssciatedName3",_mapping.getTextDescription("admin.mpolicy.Test"));
							assoElemOpt.put("AssciatedName2",_mapping.getTextDescription("admin.mpolicy.Descriptors"));
						
							assoElemOpt.put("AssociateTitleobj",compDescJsonArr);
						}
						if(assoElemOpt!=null && !assoElemOpt.isEmpty())
						{
							assoElemsForCompTest.add(assoElemOpt);
						}
					}
					jOpt.put("AssociatedElementsForCompTestDesc",assoElemsForCompTest);
				}
				else
				{
					jOpt.put("AssociatedElements","");
					jOpt.put("AssociatedElementsForCompTestDesc","");
					jOpt.put("AssociatedElementsNoData",_mapping.getTextDescription("admin.mpolicy.No Associated Elements"));
				}
				if(isLimitedAdmin)
				{
					if(policyName!=null && policyName.indexOf("|$|")>0)
					{
						String limitUser = policyName.substring(policyName.indexOf("|$|")+3);						
						if(u_rs!=null && u_rs.equalsIgnoreCase(limitUser))
						{
							isPolicyRelatedToCurrentLimitedUser=true;
						}
					}
				}
				JSONArray iconClassArr=new JSONArray();
				JSONObject cssObj=new JSONObject();
				cssObj.put("icon1","iconModify");
				cssObj.put("icon2","iconWrong");
				cssObj.put("icon3","iconDiskUsageUnavailable");
				cssObj.put("iconPolicyname",policyName);
				iconClassArr.add(cssObj);
				jOpt.put("iconClass",iconClassArr);				
				if(isLimitedAdmin)
				{
					Object assElemsObj=jOpt.get("AssociatedElements");
					Object assElmsForCompTestObj=jOpt.get("AssociatedElementsForCompTestDesc");
					
					if((assElemsObj!=null && assElemsObj instanceof String) && (assElmsForCompTestObj!=null && assElmsForCompTestObj instanceof String)) {
						String assElemsStr=(String)jOpt.get("AssociatedElements");
						String assElmsForCompTestDesc=(String)jOpt.get("AssociatedElementsForCompTestDesc");
						if(StringUtils.isNull(assElemsStr) && StringUtils.isNull(assElmsForCompTestDesc))
						{
							if(!isPolicyRelatedToCurrentLimitedUser)
								continue;
						}
					}
					else if((assElemsObj!=null && assElemsObj instanceof String) && (assElmsForCompTestObj!=null && assElmsForCompTestObj instanceof JSONArray)) {
						String assElemsStr=(String)jOpt.get("AssociatedElements");
						JSONArray assElmsForCompTestDesc=(JSONArray)jOpt.get("AssociatedElementsForCompTestDesc");
						if(StringUtils.isNull(assElemsStr) && (assElmsForCompTestDesc==null || assElmsForCompTestDesc.isEmpty()))
						{
							if(!isPolicyRelatedToCurrentLimitedUser)
								continue;
						}
					}
				}
				if(isLimitedAdmin)
				{
					jOpt.put("allowToEditPolicy",new Boolean(isPolicyRelatedToCurrentLimitedUser));
				}
				else
				{
					jOpt.put("allowToEditPolicy",new Boolean(true));
				}
				policyListData.add(jOpt);
			}
		}
		if(policyListData!=null && !policyListData.isEmpty())
		{
			rootJson.put("policyListData",policyListData);
			rootJson.put("errMsg","-");
		}
		else
		{
			rootJson.put("errMsg",_mapping.getTextDescription("admin.mpolicy.No maintenance policies have been configured"));
		}
	}
	else
	{
		rootJson.put("errMsg",_mapping.getTextDescription("admin.mpolicy.No maintenance policies have been configured"));
	}
	rootJson.put("screenLabels",screenLabels);
	
	String queryString = request.getQueryString();
	String expolicynames1 = request.getParameter("expolicynames");
	String nodePid1 = request.getParameter("nodePid");
	String Qstring="";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
			continue;
			String reqparam =param.substring(0,ind);
			String value = param.substring(ind+1);
			if(reqparam!=null&&reqparam.equals("policyToView"))
			{
			value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8");
			}
			Qstring=Qstring+reqparam+"="+value+"&";
		}
	}
	String polnames=request.getParameter("policyToView");
	if(polnames!=null && !polnames.equals("") )
	{
	//	String treeviewsrc="/final/servlet/com.eg.EgMaintenanceServlet?opt=Tree&comesFrom=Tab&policyToView="+com.eg.EgURLEncoder.encode(polnames,"UTF-8")+"&nodePid="+nodePid1+"&showtree=maintenancetree";
		session.setAttribute("adminLastAccessedURL","/final/admin/QuickMaintenance.jsp?comesFrom=Tab&policyToView="+com.eg.EgURLEncoder.encode(polnames,"UTF-8"));
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/QuickMaintenance.jsp");
	}
	if(unplannedpolicies!=null && unplannedpolicies.size()>0 && isSearchStrNotFound)
	{
		rootJson.put("errMsg",_mapping.getTextDescription("admin.mpolicy.No	policies found for your	current	search"));
	}
	out.println(rootJson.toString());
%>