Ext.override(Ext.Shadow, {

	show: function (target) {

		var me = this,
			index;
		target = Ext.get(target);


		if (!me.el) {
			me.el = Ext.ShadowPool.pull();
			if (me.el.dom.nextSibling != target.dom) {
				me.el.insertBefore(target);
			}
		}
		index = (parseInt(target.getStyle("z-index"), 10) - 1) || 0;
		me.el.setStyle("z-index", me.zIndex || index);
		if (Ext.isIE && !Ext.supports.CSS3BoxShadow) {
			me.el.dom.style.filter = "progid:DXImageTransform.Microsoft.alpha(opacity=" + me.opacity + ") progid:DXImageTransform.Microsoft.Blur(pixelradius=" + (me.offset) + ")";
		}
		me.realign(
			target.getLocalX(),
			target.getLocalY(),
			target.dom.offsetWidth,
			target.dom.offsetHeight
		);

		if (!Ext.isEmpty(Ext.getCmp(target.id).shadowCls)) {
			var cls = Ext.getCmp(target.id).shadowCls,
				opacity = Ext.getCmp(target.id).shadowOpacity;
			me.el.removeCls('x-css-shadow');
			me.el.dom.style.position = "absolute";
			me.el.dom.style.opacity = opacity;
			me.el.addCls(cls);
			opacity = me.opacity;
		}
		me.el.dom.style.display = "block";
	}
})

Ext.define('EgRESTAPIClient.controller.Main',
	{
		extend: 'Ext.app.Controller',
		requires: ['EgRESTAPIClient.view.Main', 'EgRESTAPIClient.view.HttpClient', 'EgRESTAPIClient.view.RawParamsGrid', 'EgRESTAPIClient.view.FormDataFileUpload','EgRESTAPIClient.view.TimeLine'],
		refs: [
			{selector : 'main',ref: 'main'},
			{selector : 'HttpClient',ref: 'HttpClient'},
			{selector : 'RawParamsGrid',ref: 'RawParamsGrid'},
			{selector : 'FormDataFileUpload',ref: 'FormDataFileUpload'}
		],
		init: function () {
			this.loadMainData();
			this.control({
				'main checkbox[id="paramsRequired"]': {
					'change': this.enableParamsRequiredSettings
				},
				'main': {
					'afterrender': this.afterMainRender
				},
				'main radiogroup[id="apiType"]':
				{
					'change': this.getApiList
				},
				'main radiogroup[id="bulkOperation"]':
				{
					'change': this.getBulkOperationApiList
				},
				'main combo[id="apiName"]':
				{
					'select': this.apiSelection
				},
				'main button[id="addParam"]':
				{
					'click': this.validateAddParam
				},
				'main button[id="addParam-timer"]':
				{
					'click': this.validateAddParam
				},
				'main button[id="addParam-query"]':
				{
					'click': this.validateAddParam
				},
				'main combo[id="paramName"]':
				{
					'select': this.showParamValue
				},
				'main button[id="execute"]':
				{
					'click': this.executeApi
				}

			});
		},
		loadMainData: function () {
			var urlStr = '/final/admin/EgRESTAPIClient/data/restApiClientJson.jsp?selectedApiType=analytics';
			this.getData(urlStr);
		},
		afterMainRender: function () {
			var apiNameComboObj = Ext.getCmp('apiName');
			Ext.getCmp('apiType').add(apiMainJSON.apiType);
			apiNameComboObj.getStore().clearFilter(true);
			apiNameComboObj.getStore().loadRawData(apiMainJSON.apiList);
			apiNameComboObj.getStore().sort('valueField', 'ASC');
			apiNameComboObj.setValue("-1");
			Ext.getCmp('paramsRequired').setValue(false);
			Ext.getCmp('paramsRequired').checked = false;
			Ext.getCmp('paramsRequired').setDisabled(true);
			Ext.getCmp('apiUserPW').setValue("");
		},
		getApiList: function (obj) {
			var btn = Ext.getCmp('iconApiInfo');
			btn.tooltipText = "API Description";
			var formValues = this.getHttpClient().getValues();
			var gridObj = this.getRawParamsGrid();
			var paramComboObj = Ext.getCmp('paramName');
			var paramComboStore = paramComboObj.getStore();
			var apiNameComboObj = Ext.getCmp('apiName');
			var apiNameComboStore = apiNameComboObj.getStore();
			var bulkOperationObj = Ext.getCmp('bulkOperation');
			var bulkOperation = bulkOperationObj.getValue().bulkOperation;
			var selectedApiType = obj.getValue().apiType;

			var gridStore = gridObj.getStore();
			gridStore.removeAll();
			this.getHttpClient().getForm().reset();

			Ext.getCmp('apiUserPW').setValue("");
			Ext.getCmp('paramsRequired').setValue('No');
			Ext.getCmp('paramsRequired').setValue(false);
			Ext.getCmp('paramsRequired').disable();
			Ext.getCmp('bulkOperationNo').setValue('no');
			Ext.getCmp('formDataParams').hide();
			Ext.getCmp('restParamsGrid').hide();
			Ext.getCmp('rawParamContainer').hide();
			Ext.getCmp('queryParamView').hide();	
			if (selectedApiType == 'orchestration') {
				bulkOperationObj.show();

				if (bulkOperation == 'Yes') {
					selectedApiType += "/bulk";
				}
			}
			else {

				bulkOperationObj.hide();
			}
			var urlStr = '/final/admin/EgRESTAPIClient/data/restApiClientJson.jsp?selectedApiType=' + selectedApiType;
			this.getData(urlStr);
			apiNameComboStore.loadRawData(apiMainJSON.apiList);
			apiNameComboStore.sort('valueField', 'ASC');
			apiNameComboObj.setValue("-1");
			paramComboObj.enable();
		},
		getBulkOperationApiList: function (obj) {
			Ext.getCmp('apiUserPW').setValue("");
			Ext.getCmp('restApiUrl').setValue("");
			var bulkOperationObj = obj;
			var gridObj = this.getRawParamsGrid();
			var apiNameComboObj = Ext.getCmp('apiName');
			var apiNameComboStore = apiNameComboObj.getStore();
			var selectedApiType = Ext.getCmp('apiType').getValue().apiType;
			var bulkOperation = bulkOperationObj.getValue().bulkOperation;
			var gridStore = gridObj.getStore();
			gridStore.removeAll();
			Ext.getCmp('paramName').getStore().clearFilter(true);
			apiNameComboStore.removeAll();
			apiNameComboStore.clearFilter(true);
			var urlStr = '/final/admin/EgRESTAPIClient/data/restApiClientJson.jsp?selectedApiType=' + selectedApiType;

			if (selectedApiType == 'orchestration' && bulkOperation == 'yes') {
				this.showFormDataBody();
				urlStr += '&bulkOperation=' + bulkOperation;
			}
			else {
				this.showRawDataBody();
			}

			this.getData(urlStr);
			apiNameComboStore.loadRawData(apiMainJSON.apiList);
			apiNameComboStore.sort('valueField', 'ASC');
			apiNameComboObj.setValue('-1');
		},
		apiSelection: function (obj, record) {
			Ext.getCmp('apiUserPW').setValue("");
			var paramValueCombo = Ext.getCmp('paramValueCombo');
			paramValueCombo.getStore().clearFilter(true);
			paramValueCombo.getStore().removeAll();
			paramValueCombo.hide();
			Ext.getCmp('timeline').hide();
			Ext.getCmp('queryParamView').hide();	

			var paramValueCheckcombo = Ext.getCmp('paramValueCheckcombo');
			paramValueCheckcombo.getStore().clearFilter(true);
			paramValueCheckcombo.getStore().removeAll();
			paramValueCheckcombo.hide();
			
			this.getHttpClient().getForm().reset();
			var selectedApi = Ext.getCmp('apiName').getValue();
			var selectedApiType = Ext.getCmp('apiType').getValue().apiType;
			var urlStr = '/final/admin/EgRESTAPIClient/data/restApiClientJson.jsp?selectedApiType=' + selectedApiType + "&selectedApi=" + selectedApi;
			Ext.Ajax.request(
				{
					url: urlStr,
					method: 'POST',
					async: false,
					success: function (response) {
						if (response.responseText != null && !Ext.isEmpty(response.responseText))
						{
							var jsonText = response.responseText;
							paramsJson = Ext.decode(jsonText);
							apiParamJson = Ext.decode(jsonText);
						}
						
					},
					failure: function (response) {

					}
				});

			var gridObj = this.getRawParamsGrid();
			var gridStore = gridObj.getStore();
			gridStore.removeAll();
			if (paramsJson.showPW == 'yes') 
			{
				Ext.getCmp('apiUserPW').show();
			}
			else
			{
				Ext.getCmp('apiUserPW').hide();
			}

			Ext.getCmp('restApiUrl').setValue(record[0].data.endpointUrl);
			var btn = Ext.getCmp('iconApiInfo');
			btn.tooltipText = record[0].data.description;

			var bulkOperationObj = Ext.getCmp('bulkOperation');
			var bulkOperation = bulkOperationObj.getValue().bulkOperation;
			if (bulkOperation == 'yes') {
				Ext.getCmp('downloadCSVHref').update({
					link: '/final/servlet/com.egurkha.admin.RESTClientBulkOperationController?action=downloadCSV&apiName=' + selectedApi,
					label: 'Download Sample CSV'
				});
				Ext.getCmp('downloadCSVHref').show();
				this.showFormDataBody();
			}
			else {
				if (paramsJson.paramsRequired == 'yes') {
					Ext.getCmp('paramsRequired').setValue('Yes');
					Ext.getCmp('paramsRequired').checked = true;
					Ext.getCmp('paramsRequired').setDisabled(true);
					Ext.getCmp('paramName').getStore().clearFilter(true);
					Ext.getCmp('paramName').getStore().loadRawData(paramsJson.apiParamsList);
					Ext.getCmp('paramName').setValue("-1");
					this.showRawDataBody();
				}
				else {
					Ext.getCmp('paramsRequired').setValue('No');
					Ext.getCmp('paramsRequired').setValue(false);
					Ext.getCmp('paramsRequired').disable();
				}
			}
			showStartEndDateView(false);
			Ext.getCmp('addParam').hide();
		},
		enableParamsRequiredSettings: function (radioGrpObj) {
			if (radioGrpObj.checked) {
				var selectedApiType = Ext.getCmp('apiType').getValue().apiType;
				var bulkOperation = Ext.getCmp('bulkOperation').getValue().bulkOperation;
				if (selectedApiType == 'orchestration' && bulkOperation == 'yes') {
					this.showRawDataBody();
				}
				else {
					this.showFormDataBody();
				}
			}
			else {
				Ext.getCmp('rawBodyJson').hide();
				Ext.getCmp('paramName').hide();
				Ext.getCmp('paramValue').hide();
				Ext.getCmp('addParam').hide();
				Ext.getCmp('restParamsGrid').hide();
				Ext.getCmp('formDataParams').hide();
			}
		},
		showParamValue: function (obj, record) {
			var paramValueCombo = Ext.getCmp('paramValueCombo');
			paramValueCombo.getStore().clearFilter(true);
			paramValueCombo.getStore().removeAll();
			Ext.getCmp('paramValueCombo').setValue("");
			var paramValueComboType="";			
      		var addParam=Ext.getCmp('addParam');
			var paramValueCheckcombo = Ext.getCmp('paramValueCheckcombo');
			paramValueCheckcombo.getStore().clearFilter(true);
			paramValueCheckcombo.getStore().removeAll();
			paramValueCheckcombo.setValue("");
			var paramValueTextFiledObj=Ext.getCmp('paramValue');	
			var queryParamView=	Ext.getCmp('queryParamView');	
			var timelineObj=Ext.getCmp('timeline');
			var selectedApiName = Ext.getCmp('apiName').getValue();	
			var selectedApiType = Ext.getCmp('apiType').getValue().apiType;	
			var selectedParamName=record[0].data.valueField;
			var rawBodyJson =  Ext.getCmp('rawBodyJson').getValue();
			var inputJsonData="";
			if(rawBodyJson!=null && !Ext.isEmpty(rawBodyJson) && this.isValidJSON(rawBodyJson))
			{
				inputJsonData = Ext.decode(rawBodyJson);					
			}
			var trendApiFlag = this.isTrendAPI(selectedApiName);

      if(selectedParamName==-1)
      {
           hideParamValueComboView();
				   hideTimelineView();
				   queryParamView.hide();
      }
			else if (record[0].data.defaultValue == 'yes') {
				paramValueCombo.show();
				paramValueCheckcombo.hide();
				paramValueCombo.getStore().loadRawData(record[0].data.paramValueList);
				paramValueCombo.setValue(record[0].data.paramValueList[0].valueField);
				paramValueTextFiledObj.hide();
                hideTimelineView();
                addParam.show();
				queryParamView.hide();
			}
			else if(selectedParamName=="timeline" && selectedApiType=="analytics")
			{
				hideParamValueComboView();
				this.fillTimeLineView(selectedApiName,selectedParamName);				
				timelineObj.show();
				queryParamView.hide();
			}
			else if(selectedParamName=="startDate-endDate" && selectedApiType=="analytics")
			{
				hideParamValueComboView();
				this.fillTimeLineView(selectedApiName,selectedParamName);
				showStartEndDateView(true);
				queryParamView.hide();
			}
			else if(selectedParamName=="info" && trendApiFlag ) 
			{
				if(inputJsonData.componentName==null || inputJsonData.componentName.isEmpty)
				{
					record[0].data.paramValueType="textfield"				
					paramValueTextFiledObj.show();
					addParam.show();
					paramValueCombo.hide();
					paramValueCheckcombo.hide();
					hideTimelineView();
				}
				else
				{
					record[0].data.paramValueType="single_combo"				
					paramValueComboType=record[0].data.paramValueType;
					paramValueCombo.show();
					paramValueCheckcombo.hide();
					paramValueTextFiledObj.hide();
					this.loadParamValueCombo(selectedApiName,selectedParamName,paramValueComboType);							
					hideTimelineView();
					queryParamView.hide();
				}
			}
			else if(record[0].data.paramValueType == 'single_combo')
			{
				paramValueComboType=record[0].data.paramValueType;
				paramValueCombo.show();
				paramValueCheckcombo.hide();
				paramValueTextFiledObj.hide();
				this.loadParamValueCombo(selectedApiName,selectedParamName,paramValueComboType);							
				hideTimelineView();
				queryParamView.hide();
			}			
			else if(record[0].data.paramValueType == 'multiselect_combo')			
			{	
				paramValueComboType=record[0].data.paramValueType;
				paramValueCheckcombo.show();
				paramValueCombo.hide();
				paramValueTextFiledObj.hide();			
				this.loadParamValueCombo(selectedApiName,selectedParamName,paramValueComboType);
				hideTimelineView();
				queryParamView.hide();	
			}			
			else
			{
				if(selectedParamName=='query')
				{
					queryParamView.show();
				}
				else
				{
					paramValueTextFiledObj.show();
					addParam.show();
				}
				paramValueCombo.hide();
				paramValueCheckcombo.hide();
				hideTimelineView();
			}

		},
		loadParamValueCombo : function(selectedApiName,selectedParamName, paramValueComboType )
		{
			var paramValueCombo = Ext.getCmp('paramValueCombo');
			var paramValueCheckcombo = Ext.getCmp('paramValueCheckcombo');
			var urlStr = '/final/admin/EgRESTAPIClient/data/parameterValueJson.jsp?selectedApiName=' + encodeURIComponent(selectedApiName) + "&selectedParamName=" + encodeURIComponent(selectedParamName);
			var inputJsonData = "";
			var componentType = "";
			var componentName = "";
			var test = "";
			var measure = "";
			var info = "";
			var error=false;
			var rawBodyJson = Ext.getCmp('rawBodyJson').getValue();
			var trendApiFlag = this.isTrendAPI(selectedApiName);
			
			if(selectedParamName=='componentType' || selectedParamName=='componentList' || selectedParamName=='service' || selectedParamName=='segment' || selectedParamName=='zone')
			{
				if(selectedApiName == "getConfigurationChangesOverTime")
				{
					if(rawBodyJson!=null && !Ext.isEmpty(rawBodyJson) && this.isValidJSON(rawBodyJson))
					{
						inputJsonData = Ext.decode(rawBodyJson);					
					}
				}

				var filterBy = '';
				if(inputJsonData.filterBy!=null && !Ext.isEmpty(inputJsonData.filterBy))
				{
					filterBy = inputJsonData.filterBy;
				}
				if(selectedApiName == "getConfigurationChangesOverTime" && filterBy!='component')
				{
					var filterValues = '';
					if(filterBy!=null && filterBy == 'zone')
					{
						filterValues = inputJsonData.zone;
					}
					else if(filterBy!=null && filterBy == 'service')
					{
						filterValues = inputJsonData.service;
					}
					else if(filterBy!=null && filterBy == 'segment')
					{
						filterValues = inputJsonData.segment;
					}
					if(filterValues!=null)
					{
						urlStr+="&configfilter="+encodeURIComponent(filterBy)+"&filterValues="+encodeURIComponent(filterValues);
					}
				}
				else
				{
					urlStr=urlStr;
				}
			}
			else
			{
				if(rawBodyJson!=null && !Ext.isEmpty(rawBodyJson) && this.isValidJSON(rawBodyJson))
				{
					inputJsonData = Ext.decode(rawBodyJson);					
				}
				else
				{
					error=true;
				}		
				var paramValueCombo = Ext.getCmp('paramValueCombo').setValue("");
				if(selectedParamName=='componentName' || selectedParamName=='test')
				{
					if(trendApiFlag && (inputJsonData == null || Ext.isEmpty(inputJsonData)) && selectedParamName=='test' )
					{
						error=false;
					}
					else if(inputJsonData.componentType!=null && !Ext.isEmpty(inputJsonData.componentType))
					{
						urlStr+="&componentType="+encodeURIComponent(inputJsonData.componentType);
						error=false;
					}
					else if(trendApiFlag && selectedParamName=='componentName')
					{
						error=false;
						urlStr+="&componentType=All";
					}
					else if(trendApiFlag && selectedParamName=='test')
					{
						if(inputJsonData.componentName!=null && !inputJsonData.componentName.isEmpty)
						{
							urlStr+="&componentName="+encodeURIComponent(inputJsonData.componentName);
						}
						else
						{
							urlStr+="&componentName=All";
						}
						error=false;						
					}
					else if(selectedApiName == "getTestData"  || selectedApiName == "getTrendData" || selectedApiName == "getThresholdData")
					{
						error=false;
						urlStr+="&componentType=All";
					}
					else
					{
						Ext.MessageBox.show({
							title: PageTitle,
							msg: componentTypeErrMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation'
							});
							error=true;
							hideParamValueComboView();
						return false;
					}

				}
				else if( selectedParamName == "measure")
				{
					if(inputJsonData.componentType!=null && !Ext.isEmpty(inputJsonData.componentType))
					{
						urlStr+="&componentType="+encodeURIComponent(inputJsonData.componentType);
					}
					else
					{
						if(!trendApiFlag)
						{
							Ext.MessageBox.show({
								title: PageTitle,
								msg: componentTypeErrMsg,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation'
								});
								error=true;
								hideParamValueComboView();
							return false;
						}
					}
				
					if(inputJsonData.test!=null && !Ext.isEmpty(inputJsonData.test))
					{
						urlStr+="&test="+encodeURIComponent(inputJsonData.test);
					}
					else
					{
						Ext.MessageBox.show({
							title: PageTitle,
							msg: testErrMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation'
							});
							error=true;
							hideParamValueComboView();
						return false;
					}
				}
				else if(selectedParamName == "info")
				{
					if(inputJsonData.componentType!=null && !Ext.isEmpty(inputJsonData.componentType))
					{
						urlStr+="&componentType="+encodeURIComponent(inputJsonData.componentType);
					}
					else
					{
						if(!trendApiFlag)
						{
							Ext.MessageBox.show({
								title: PageTitle,
								msg: componentTypeErrMsg,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation'
								});
								error=true;
								hideParamValueComboView();
							return false;
						}
					}
					
					if(inputJsonData.componentName!=null && !Ext.isEmpty(inputJsonData.componentName))
					{
						urlStr+="&componentName="+encodeURIComponent(inputJsonData.componentName);
					}
					else
					{
						Ext.MessageBox.show({
							title: PageTitle,
							msg: componentNameErrMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation'
							});
							error=true;
							hideParamValueComboView();
						return false;
					}
				
					if(inputJsonData.test!=null && !Ext.isEmpty(inputJsonData.test))
					{
						urlStr+="&test="+encodeURIComponent(inputJsonData.test);
					}
					else
					{
						Ext.MessageBox.show({
							title: PageTitle,
							msg: testErrMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation'
							});
							error=true;
							hideParamValueComboView();
						return false;
					}
				}
				else if(selectedParamName == 'filterValues')
				{
					if(inputJsonData.filterBy!=null && !Ext.isEmpty(inputJsonData.filterBy))
					{
						urlStr+="&filterBy="+encodeURIComponent(inputJsonData.filterBy);
					}
					else
					{
						Ext.MessageBox.show({
							title: PageTitle,
							msg: filterByErrMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation'
							});
							error=true;
							hideParamValueComboView();
						return false;
					}
				}
				else if(selectedParamName == 'vmName')
				{
					error=false;
					if(inputJsonData.componentType!=null && !Ext.isEmpty(inputJsonData.componentType))
					{
						urlStr+="&componentType="+encodeURIComponent(inputJsonData.componentType);
					}
					else						
					{
						urlStr+="&componentType=All";						
					}
					
					if(inputJsonData.componentName!=null && !Ext.isEmpty(inputJsonData.componentName))
					{
						urlStr+="&componentName="+encodeURIComponent(inputJsonData.componentName);
					}
					else
					{
						urlStr+="&componentName=All";
					}
				}
			}	
			if(!error)
			{
				Ext.Ajax.request(
				{
					url: urlStr,
					method: 'POST',
					async: false,
					success: function (response) {
						if (response.responseText != null && !Ext.isEmpty(response.responseText))
						{
							var resultJson = Ext.decode(response.responseText);
							if(!Ext.isEmpty(resultJson.paramValuesArr) && resultJson.paramValuesArr.length>0)
							{
								if(paramValueComboType == 'single_combo')
								{
									paramValueCombo.getStore().loadRawData(resultJson.paramValuesArr);
									paramValueCombo.setValue(resultJson.paramValuesArr[0].valueField);
								}
								else
								{
									if(selectedParamName == "componentName" && selectedApiName == "getLiveMeasure")
									{
										paramValueCheckcombo.addAllSelector=true;
									}
									else if(selectedParamName == "filterValues" && selectedApiName == "getAlerts")
									{
										paramValueCheckcombo.addAllSelector=true;
									}
									else
									{
										paramValueCheckcombo.addAllSelector=false;
									}
									paramValueCheckcombo.getStore().loadRawData(resultJson.paramValuesArr);	
									paramValueCheckcombo.setValue(resultJson.paramValuesArr[0].valueField);								
								}
								Ext.getCmp('addParam').show();
							}
							else
							{
								var emptyText="No data found";
								if(!Ext.isEmpty(resultJson.emptytext))
								{
									emptyText=resultJson.emptytext;
								}
								if(paramValueComboType == 'single_combo')
								{
									paramValueCombo.emptyText = emptyText;
									paramValueCombo.applyEmptyText();
								}
								else
								{
									paramValueCheckcombo.emptyText = emptyText;
									paramValueCheckcombo.addAllSelector=false;
									paramValueCheckcombo.applyEmptyText();
									
								}
								Ext.getCmp('addParam').hide();
							}
						}						
						
					},
					failure : function(response)
					{

					}
				});
			}
			else
			{
				return false;
			}
		},
		fillTimeLineView : function(selectedApiName,selectedParamName)
		{
			var me = this;
			var timelineComboObj = Ext.getCmp('timelineCombo');
			var startDateObj = Ext.getCmp('startDate');
			var startHourObj = Ext.getCmp('startHour');
			var startMinObj = Ext.getCmp('startMin');
			var endDateObj = Ext.getCmp('endDate');
			var endHourObj = Ext.getCmp('endHour');
			var endMinObj = Ext.getCmp('endMin');

			var urlStr = '/final/admin/EgRESTAPIClient/data/parameterTimelineFilterJson.jsp?selectedApiName=' + encodeURIComponent(selectedApiName) + "&selectedParamName=" + encodeURIComponent(selectedParamName);
			Ext.Ajax.request(
			{
				url: urlStr,
				method: 'POST',
				async: false,
				success: function (response) {
					if (response.responseText != null && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var timelineJson = Ext.decode(jsonText);
						if(selectedParamName=="timeline")
						{						
							timelineComboObj.getStore().loadRawData(timelineJson.timelineArr);
							timelineComboObj.setValue(timelineJson.timelineArr[0].valueField);
							if(timelineJson.timelineArr[0].valueField=="Any")
							{
								showStartEndDateView(true);
							}
							else
							{
								showStartEndDateView(false);

							}
						}
						
						startDateObj.setValue(timelineJson.startDate);
						startHourObj.getStore().loadRawData(timelineJson.hoursArr);
						startHourObj.setValue(timelineJson.startHour);

						startMinObj.getStore().loadRawData(timelineJson.minutesArr);
						startMinObj.setValue(timelineJson.startMin);

						// To Date
						endDateObj.setValue(timelineJson.endDate);

						endHourObj.getStore().loadRawData(timelineJson.hoursArr);
						endHourObj.setValue(timelineJson.endHour);

						endMinObj.getStore().loadRawData(timelineJson.minutesArr);
						endMinObj.setValue(timelineJson.endMin);
					}
				},
				failure: function (response) {

				}
			});
		
			
		},
		validateAddParam: function () {
			var selectedApiType = Ext.getCmp('apiType').getValue().apiType;	
			var gridObj = this.getRawParamsGrid();
			var gridStore = gridObj.getStore();
			var nameobj = Ext.getCmp('paramName');
			var valueobj = Ext.getCmp('paramValue');
			var queryParamValueobj = Ext.getCmp('queryParamValue');
			var selectedApiName = Ext.getCmp('apiName').getValue();
			var paramValueCombo = Ext.getCmp('paramValueCombo');
			var paramValueCheckcombo = Ext.getCmp('paramValueCheckcombo');
			var selectedParamValueRecord = "";
			var value = "";
			var name = nameobj.getValue().trim();
			var paramNameObj = Ext.getCmp('paramName');
			var paramName = paramNameObj.getValue()
			var startDate = '';
			var endDate = '';
			var selectedParamNameRecord = nameobj.findRecordByValue(paramName);
			if (selectedParamNameRecord.data.defaultValue == 'yes') 
			{
				selectedParamValueRecord = paramValueCombo.findRecordByValue(Ext.getCmp('paramValueCombo').getValue());
				value = selectedParamValueRecord.data.valueField;
				if (selectedParamNameRecord.data.include == 'yes') {
					
					var addFlag = true;
					if (selectedApiName == 'getConfigurationChanges' && value == 'component') {
						addFlag = false;
					}
					else if (selectedApiName == 'getConfigurationChangesOverTime' && value == 'component') {
						addFlag = false;
					}
					else {
						addFlag = true;
					}
					if (addFlag) {
						paramNameObj.getStore().removeAll();
						paramNameObj.getStore().loadRawData(paramsJson.apiParamsList);
						gridObj.doLayout();
						var paramValueType="";
						if(selectedApiType == "analytics" && (value == 'zone' || value == 'service' || value == 'segment'))
						{
							paramValueType="single_combo";							
						}
						paramNameObj.getStore().add({
							valueField: value,
							displayField: value,
							defaultValue: 'No',
							paramValueType:paramValueType,
							include: 'No'
						});

						var prevParamValue = '';
						gridStore.each(function (record) {
							if (name == record.get('name')) {
								prevParamValue = record.get('value');
							}
							if (record.get('name') == prevParamValue && !Ext.isEmpty(prevParamValue)) {
								gridStore.remove(record);
							}
						});
					}
				}

			}
			else if(selectedParamNameRecord.data.paramValueType == 'single_combo')
			{				
				selectedParamValueRecord = paramValueCombo.findRecordByValue(Ext.getCmp('paramValueCombo').getValue());
				value = selectedParamValueRecord.data.valueField;
			}
			else if(selectedParamNameRecord.data.paramValueType == 'multiselect_combo')
			{
				value = paramValueCheckcombo.getValue();
			}			
			else if(selectedApiType == 'analytics' &&  paramName=='timeline')
			{
				var startDateRecord = gridStore.findRecord('name', "startDate");
				var endDateRecord = gridStore.findRecord('name', "endDate");
				if(startDateRecord!=null)
				{
					gridStore.remove(startDateRecord);
				}
				if(endDateRecord!=null)
				{
					gridStore.remove(endDateRecord);
				}
				
				value = Ext.getCmp('timelineCombo').getValue();
				if (value != null && value == "Any")
				{
					startDate = Ext.Date.dateFormat(Ext.getCmp('startDate').getValue(), "M d, Y");
					endDate = Ext.Date.dateFormat(Ext.getCmp('endDate').getValue(),  "M d, Y");					
					this.addStartEndDateParam(startDate,endDate);
				}				
			}
			else if(selectedApiType == 'analytics' &&  paramName=='startDate-endDate')
			{
				startDate = Ext.Date.dateFormat(Ext.getCmp('startDate').getValue(), "Y-m-d");
				endDate = Ext.Date.dateFormat(Ext.getCmp('endDate').getValue(),  "Y-m-d");					
				this.addStartEndDateParam(startDate,endDate);
			}
			else {
				if(paramName=='query')
				{
					value = queryParamValueobj.getValue().trim();
				}
				else
				{
					value = valueobj.getValue().trim();
				}
			}
			if(paramName=="startDate-endDate" && selectedApiType=="analytics")
			{
				return;
			}			
			else
			{
				this.addParamToBodyJson(name,value);

			}
		},
		addStartEndDateParam: function(startDate,endDate)
		{
			var isValidDate=true;
			var sthr = Ext.getCmp("startHour").getValue();
			var endhr = Ext.getCmp("endHour").getValue();
			var stmin = Ext.getCmp("startMin").getValue();
			var endmin = Ext.getCmp("endMin").getValue();
			if(new Date(startDate) > new Date(endDate))
			{
				isValidDate=false;
				Ext.MessageBox.show({
					title: PageTitle,
					msg: invalidDateTime,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				});
			
				return;
			}
			if(new Date(startDate).valueOf() == new Date(endDate).valueOf())
			{    
				if(sthr > endhr )
				{
					isValidDate=false;
					Ext.Msg.show({
					title: PageTitle,
					msg: invalidDateTime,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
					});				
					return;
				}
				 if(sthr == endhr )
				{
					if(stmin > endmin)
					{
						isValidDate=false;
						Ext.Msg.show({
						title: PageTitle,
						msg: invalidDateTime,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
						});
						return;
					}					
				}
			}
			if(isValidDate)
			{
				startDate=startDate+" "+sthr+":"+stmin+":00";
				endDate=endDate+" "+endhr+":"+endmin+":00";
				this.addParamToBodyJson("startDate",startDate);
				this.addParamToBodyJson("endDate",endDate);
			}
			
		},
		addParamToBodyJson: function (name, value)
		{
			var gridStore = this.getRawParamsGrid().getStore();
			var nameobj = Ext.getCmp('paramName');
			var valueobj = Ext.getCmp('paramValue');
			var isValidParam = true;
			if (Ext.isEmpty(value)) {
				Ext.Msg.show({
					title: PageTitle,
					msg: paramValueErrMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValidParam = false;
				return;
			}
			if (Ext.isEmpty(name) || name == '-1') {
				Ext.Msg.show({
					title: PageTitle,
					msg: paramsNameSelectLabel,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValidParam = false;
				return;
			}

			if(name == 'info' && value == 'Not Applicable')
			{
				isValidParam = false;
				return;	
			}
			
			if (isValidParam) {
				var configuredData = [];
				configuredData.push({
					value: value,
					name: name
				});
				var addData = true;
				for (var i = 0; i < gridStore.getCount(); i++) {
					if (gridStore.getAt(i).get('name') == name) {
						gridStore.removeAt(i);
						break;
					}
				}
				gridStore.add(configuredData);				

				nameobj.reset();
				valueobj.reset();
				valueobj.hide();
				Ext.getCmp('paramValueCheckcombo').hide();
				Ext.getCmp('paramValueCombo').hide();
				Ext.getCmp('timeline').hide();
				showStartEndDateView(false);
				Ext.getCmp('addParam').hide();
				Ext.getCmp('queryParamValue').reset();
				Ext.getCmp('queryParamView').hide();	
				nameobj.setValue("-1");
				this.getJSONArr();
			}
		},
		getData: function (urlStr) {
			Ext.Ajax.request(
				{
					url: urlStr,
					method: 'POST',
					async: false,
					success: function (response) {
						if (response.responseText != null && !Ext.isEmpty(response.responseText))
						{
							var jsonText = response.responseText;
							apiMainJSON = Ext.decode(jsonText);
						}
						
					},
					failure: function (response) {

					}
				});
		},
		windowResize: function (windowID, bool) {
			var me = this;
			//JSON window resize
			Ext.EventManager.onWindowResize(function () {
				var y = Ext.get('apiType').getY() + 30,
					mainWidth = me.getMain().getWidth() - 22,
					mainHeight = me.getMain().getHeight() - y;

				if(!Ext.isEmpty(Ext.getCmp(windowID))){
					if (!bool) {
					Ext.getCmp(windowID).setSize(mainWidth, mainHeight);
					Ext.getCmp(windowID).alignTo('main', 't-t', [0, y]);
				} else {
					mainHeight = me.getMain().getHeight();
					Ext.getCmp(windowID).setSize(mainWidth, mainHeight);
				}
				}
				


			});
		},
		copyText: function (component) {
			var a = document.getElementById(component.getInputId());
			Ext.getCmp('copy').getEl().on("click", function () {
				var c = Ext.create("Ext.window.Window", {
					renderTo: component.id,
					layout: "fit",
					height: component.getHeight() - 18,
					width: component.getWidth(),
					header: false,
					border: false,
					bodyPadding: 0,
					bodyCls: "copiedWindow-body",
					cls: "copiedWindow",
					padding: 0,
					floating: true,
					resizable: false,
					style: { "box-shadow": "none" },
					html: '<div class="info">Copied to Clipboard</div>'
				}).show();
				c.alignTo(component.id, "tr-tr", [0, 0]);
				a.select();

				try {
					var f = document.execCommand("copy");
					var e = f ? "Copied to Clipboard" : ":(";
					Ext.defer(function () {
						Ext.destroy(c);
						a.focus();
						a.select();
					}, 1000);
				}
				catch (d) {
					console.log("Oops, unable to copy");
				}
			});
		},
		showResponse: function (response) {
			var me = this,
				y = Ext.get('apiType').getY() + 30,
				mainWidth = me.getMain().getWidth() - 22,
				mainHeight = me.getMain().getHeight() - y;

			var jsonWindow = Ext.create('Ext.window.Window', {
				height: mainHeight,
				closeAction: 'destroy',
				width: mainWidth,
				renderTo: Ext.getBody(),
				modal: true,
				resizable: false,
				shadow: 'frame',
				shadowOffset: 10,
				bodyPadding: '0 18 20 18',
				padding: 0,
				shadowCls: 'shadowCls',
				shadowOpacity: 0.5,
				draggable: false,
				ui: 'newPopupWindow2',
				animateTarget: Ext.get('execute'),
				title: reponseLabel,
				id: 'responseWindow',
				ghost: false,
				layout: {
					type: 'fit'
				},
				tools: [
					{
						xtype: 'toolbar',
						ui: 'plain',
						items: [{
							xtype: 'button',
							id: 'copy',
							tooltip:'Copy Response',
							iconCls: 'iconCopy'
						}]
					}
				],
				autoScroll: 'true',
				items: [
					{
						xtype: 'container',
						border: false,
						padding: 0,
						margin: 0,
						layout: {
							type: 'vbox',
							align: 'stretch'
						},
						flex: 0.5,


						items: [
							{
								xtype: 'textarea',
								id: 'restApiStatusCode',
								value: response,
								cls: 'textarea withpadding border-t',
								border: false,
								hidden: true,
								margin: '0',
								listeners: {
									boxready: function (b) {
										me.copyText(b);
									}
								}
							},
							{
								xtype: 'textarea',
								border: false,
								flex: 1,
								id: 'restApiResponse',
								cls: 'textarea withpadding border-t',
								value: response,
								readOnly: true,
								spellcheck: false,
								margin: '0',
								listeners: {
									boxready: function (b) {
										me.copyText(b);
									}
								}
							}
						]
					}]
			});


			jsonWindow.alignTo('main', 't-t', [0, y]);
			jsonWindow.show();
			me.windowResize('responseWindow', false);
		},
		executeApi: function () {
			var me = this;
			var rec = Ext.getCmp('paramValueCombo').findRecordByValue(Ext.getCmp('paramValueCombo').getValue());
			var myMask = new Ext.LoadMask(Ext.getBody(), { msg: 'Executing...' });

			var selectedApiNameObj = Ext.getCmp('apiName');
			var selectedApiName = selectedApiNameObj.getValue();
			var restApiUrl = '';
			var httpMethod = '';
			var bodyFieldType = '';
			var rawJsonBody = '';
			var isValid = true;
			var paramsForRestURL = '';
			var apiUserPW = '';

			if (selectedApiName == null || Ext.isEmpty(selectedApiName) || selectedApiName == -1) {
				Ext.Msg.show({
					title: PageTitle,
					msg: apiNameErrMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValid = false;
				return;
			}


			var restApiUrlObj = Ext.getCmp('restApiUrl');
			var httpMethodObj = Ext.getCmp('httpMethod');
			var paramsRequiredObj = Ext.getCmp('paramsRequired');
			var rawBodyJsonObj = Ext.getCmp('rawBodyJson');
			var authenticationRequiredObj = Ext.getCmp('authenticationRequired');

			restApiUrl = restApiUrlObj.getValue();
			httpMethod = httpMethodObj.getValue();
			var selectedApiType = Ext.getCmp('apiType').getValue().apiType;
			var bulkOperation = Ext.getCmp('bulkOperation').getValue().bulkOperation;
			if (selectedApiType == 'orchestration' && bulkOperation == 'yes') {
				bodyFieldType = "form-data";
			}
			else {
				bodyFieldType = "raw";
			}
			
			if (selectedApiType == 'orchestration')
			{
				selectedApiName = selectedApiName.toLowerCase();
			}

			var paramsRequired = paramsRequiredObj.getValue();
			selectedApiName = this.filterEncode(selectedApiName);
			selectedApiType = this.filterEncode(selectedApiType);
			restApiUrl = this.filterEncode(restApiUrl);
			httpMethod = this.filterEncode(httpMethod);
			paramsForRestURL = "apiType="+encodeURIComponent(selectedApiType)+"&apiName=" + encodeURIComponent(selectedApiName) + '&restApiUrl=' + encodeURIComponent(restApiUrl) + '&httpMethod=' + encodeURIComponent(httpMethod);
			
			if(paramsJson.showPW=="yes")
			{
				var apiUserPWObj = Ext.getCmp('apiUserPW');
				apiUserPW = apiUserPWObj.getValue();
				if (Ext.isEmpty(apiUserPW)) 
				{
					Ext.Msg.show({
						title: PageTitle,
						msg: pwErrMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					isValid = false;
					apiUserPWObj.focus(true);
					return;
				}
				else
				{
					apiUserPW = this.filterEncode(btoa(apiUserPW));
					paramsForRestURL += '&apiUserPW='+encodeURIComponent(apiUserPW);
				}
			}

			if (bodyFieldType == 'raw') {
				var rawParamGridStore = this.getRawParamsGrid().getStore();
				if (paramsRequired)  {
					if(rawParamGridStore.getCount()>0)
					{
						rawJsonBody = rawBodyJsonObj.getValue();
						rawJsonBody = this.filterEncode(rawBodyJsonObj.getValue());
						paramsForRestURL += '&rawJsonBody=' + encodeURIComponent(rawJsonBody);
					}
					else
					{
						Ext.Msg.show({
							title: PageTitle,
							msg: "Parameters required for this API. Please add required parameters",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						isValid = false;
						return;
					}
					
				}
				
			}
			bodyFieldType = this.filterEncode(bodyFieldType);
			paramsRequired = this.filterEncode(paramsRequired);
			paramsForRestURL += '&paramsRequired=' + encodeURIComponent(paramsRequired) + '&bodyFieldType=' + encodeURIComponent(bodyFieldType);

			if (isValid) {
				if (bodyFieldType == 'raw') {
					myMask.show();
					Ext.Ajax.request(
						{
							url: '/final/servlet/com.egurkha.admin.RESTClientController?',
							method: 'POST',
							params: paramsForRestURL,
							scope: this,
							success: function (response) {
								myMask.hide();
								var jsonText = "";
								if (selectedApiName == 'getMeasureGraph') {
									if (response.responseText != null && !Ext.isEmpty(response.responseText)) {
										if (this.isValidJSON(response.responseText)) {
											jsonText = response.responseText;
											this.showResponse(jsonText);
										}
										else {

											var y = Ext.get('apiType').getY() + 30,
												mainWidth = me.getMain().getWidth() - 22,
												mainHeight = me.getMain().getHeight(),
												imgWindow = Ext.create('Ext.window.Window', {
													height: mainHeight,
													width: mainWidth,
													modal: true,
													resizable: false,
													shadow: 'frame',
													shadowOffset: 10,
													bodyPadding: '0 18 20 18',
													padding: 0,
													shadowCls: 'shadowCls',
													shadowOpacity: 0.5,
													draggable: false,
													ui: 'newPopupWindow2',
													animateTarget: Ext.get('execute'),
													ghost: false,
													title: reponseLabel,
													id: 'responseWindow',
													layout: {
														type: 'fit'

													},
													autoScroll: true,
													scroll: true,
													items: [
														{
															xtype: 'container',
															border: true,
															style: 'border-top: 1px solid #d6d6d6;text-align:center',

															padding: 10,
															items: [
																{
																	xtype: 'image',
																	id: 'restApiResponse',
																	src: 'data:image/png;base64,' + response.responseText,
																	margin: 20
																}
															]
														}]
												});
											imgWindow.show().center();
											me.windowResize('responseWindow', true);

										}

									}


								}
								else {
									var jsonText = '';
									if (response.responseText != null && !Ext.isEmpty(response.responseText)) {
										jsonText = response.responseText;
									}
									else {
										jsonText = 'No response from Rest API';
									}
									this.showResponse(jsonText);
								}



								/**/
							},
							failure: function (response) {
								myMask.hide();
							}
						});
				}
				else if (bodyFieldType == 'form-data') {
					var thisForm = this.getFormDataFileUpload().getForm();
					var fileUploadobj = Ext.getCmp('fileUpload');
					var fileUploadValue = fileUploadobj.getValue();
					var fileName = fileUploadValue.substring(fileUploadValue.lastIndexOf('.'));
					if (Ext.isEmpty(fileName) || !fileName.endsWith('.csv')) {
						Ext.Msg.show({
							title: PageTitle,
							msg: formDataValueErrMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						isValid = false;
						return;
					}

					myMask.show();
					thisForm.submit(
						{
							url: '/final/servlet/com.egurkha.admin.RESTClientBulkOperationController?' + paramsForRestURL,
							method: 'POST',
							success: function (form, action) {
								myMask.hide();
								var responseText = "";
								if (action.response.responseText != null && !Ext.isEmpty(action.response.responseText)) {
									responseText = action.response.responseText;
								}
								else {
									responseText = "No Response from API";
								}
								restapi.getController('Main').showResponse(responseText);

							},
							failure: function (form, action) // if result page doest not return success:true, this method fires
							{
								myMask.hide();
								var responseText = "";
								if (action.response.responseText != null && !Ext.isEmpty(action.response.responseText)) {
									responseText = action.response.responseText;
								}
								else {
									responseText = "No Reponse from API";
								}
								restapi.getController('Main').showResponse(responseText);
								switch (action.failureType) {
									case Ext.form.action.Action.CLIENT_INVALID:
										Ext.Msg.show({
											title: "Failure",
											msg: "Form fields may be submitted with invalid values.",
											buttons: Ext.Msg.OK,
											icon: 'iconError'
										});
										break;
									case Ext.form.action.Action.CONNECT_FAILURE:
										Ext.Msg.show({
											title: "Failure",
											msg: "Ajax communication failed.",
											buttons: Ext.Msg.OK,
											icon: 'iconError'
										});
										break;
									case Ext.form.action.Action.SERVER_INVALID:

										break;
								}
							}

						});

				}
			}
		},
		getJSONArr: function () {
			var configuredData = [];
			configuredData.push({
				value: value,
				name: name
			});
			var paramsArr = [];

			var jsonObj = {};

			for (var i = 0; i < this.getRawParamsGrid().getStore().getCount(); i++) {
				var key = this.getRawParamsGrid().getStore().getAt(i).get('name');
				var value = this.getRawParamsGrid().getStore().getAt(i).get('value');
				jsonObj[key] = value;
			}
			var rawBodyJson = Ext.getCmp('rawBodyJson');
			rawBodyJson.setValue(JSON.stringify(jsonObj));
			rawBodyJson.show();
		},
		filterEncode: function (text) {
			var filterEncodeChar = ['[', ']', '(', ')', '=', '%', '\'', '&', ';', '"'];
			var filterDecodeText = ['|lsbr|', '|rsbr|', '|lbr|', '|rbr|', '|eq|', '|per|', '|squot|', '|ampsnd|', '|scol|', "|dqt|"];
			try {
				if (text != null && text != undefined && !Ext.isEmpty(text)) {
					for (var a in filterEncodeChar) {
						var encode_char = filterEncodeChar[a];
						var decode_char = filterDecodeText[a];
						do {
							text = text.replace(encode_char, decode_char);
						}
						while (text.indexOf(encode_char) > -1);
					}
				}
			}
			catch (e) {
			}
			return text;
		},
		showFormDataBody: function () {
			Ext.getCmp('formDataParams').show();
			Ext.getCmp('restParamsGrid').hide();
			Ext.getCmp('rawParamContainer').hide();
			Ext.getCmp('rawBodyJson').hide();
			Ext.getCmp('rawBodyJson').hide();
			Ext.getCmp('addParam').hide();
		},
		showRawDataBody: function () {
			Ext.getCmp('formDataParams').hide();
			Ext.getCmp('restParamsGrid').show();
			Ext.getCmp('rawParamContainer').show();
			Ext.getCmp('paramName').show();
			Ext.getCmp('paramValue').hide();
			Ext.getCmp('addParam').hide();
			Ext.getCmp('downloadCSVHref').hide();

		},
		
		isValidJSON: function (payload) {
			var validJson = true;
			try {
				JSON.parse(payload);
			}
			catch (e) {
				return false;
			}
			return true;
		},
		isTrendAPI: function (selectedApiName)
		{
			var trendApi_bl = false;
			var trendApiArr = ['getHourlyTrend', 'getDailyTrend', 'getMonthlyTrend'];
			Ext.Array.each(trendApiArr, function(name, index, trendApi) {
				if (name == selectedApiName) {
					trendApi_bl = true; 
					return false;
				}
			});
			return trendApi_bl;
		}
	});	
	function showStartEndDateView(show)
		{
			var timer = Ext.getCmp('timer'),
			addParamBt = Ext.getCmp('addParam'),
			addParamTimerBt = Ext.getCmp('addParam-timer');
		
			if(show== true)
			{
				timer.show();
				addParamBt.hide();
			}
			else
			{
				timer.hide();
				addParamBt.show();
			}
			
		}
    function hideTimelineView()
    {
        var timeline = Ext.getCmp('timeline');
        var timer = Ext.getCmp('timer');
        timeline.hide();
        timer.hide();
    }
	function hideParamValueComboView()
	{
		Ext.getCmp('paramValueCheckcombo').hide();
		Ext.getCmp('paramValueCombo').hide();
		Ext.getCmp('paramValue').hide();
		Ext.getCmp('addParam').hide();
	}