Ext.Msg.bodyPadding='10 0';
Ext.Msg.cls='adminAlert';
Ext.define('EgDbSettings.controller.Main',{
	extend:'Ext.app.Controller',
	views:['DatabaseSettings','DDDPurgePeriods','DDDPurgePeriodApplyToOtherTests'],
	requires:['EgDbSettings.view.DDDPurgePeriodApplyToOtherTests'],
	refs:[
		{selector:'databasesettings', ref:'databasesettings'},
		{selector:'dddpurgeperiods', ref:'dddpurgeperiods'},
		{selector:'dddpurgeperiodapplytoothertests', ref:'dddpurgeperiodapplytoothertests'}
	],
	init:function(){
		thisController = this;
		searchFlag = 'false';
		click = 0;
		editFieldArray = new Array();
		this.control({
			'databasesettings':
			{
				'afterrender': this.afterMainRender
			},
			'databasesettings button[id="AdvSetBtn"]':
			{
				'click': this.advanceSettings
			},
			'databasesettings button[id="UpdateBtn"]':
			{
				'click': this.update
			},
			'dddpurgeperiods combo[id="testType"]':
			{
				'select': this.testType
			},
			'dddpurgeperiods combo[name="Component_type"]':
			{
				'select': this.typeOnChange
			},
			'dddpurgeperiods button[id="updateInPurge"]':
			{
				'click': this.updateInPurge
			},
			'dddpurgeperiods button[id="backButton"]':
			{
				'click': this.goToMainDbSettings
			},
			'dddpurgeperiods actioncolumn[id="applyToOtherTests"]':
			{
				'click': this.applyToOtherTests
			},
			'dddpurgeperiods gridcolumn[id="periodColumnId"]':
			{
				'click' : this.beforeGridClick
			},
			'dddpurgeperiods trigger[id="searchId"]':
			{
				'change': this.onChangeEvent
			},
			'dddpurgeperiods button[id="print"]':
			{
				'click': this.printPage
			},
			'dddpurgeperiods button[id="save"]':
			{
				'click': this.savePdf
			},
			'dddpurgeperiods button[id="saveCSV"]':
			{
				'click': this.saveInCSVFormat
			},
			'dddpurgeperiodapplytoothertests combo[name="componentTypeInApply"]':
			{
				'select': this.typeOnChangeInApply
			},
			'dddpurgeperiodapplytoothertests button[id="UpdateMoreBtn"]':
			{
				'click': this.updateMore
			},
			'dddpurgeperiodapplytoothertests button[name="updateApply"]':
			{
				'click': this.updateInApply
			},
			'dddpurgeperiodapplytoothertests button[id="backbtn"]':
			{
				'click': this.goToPurge
			},
			'dddpurgeperiodapplytoothertests trigger[id="applyToOtherTestsID"]':
			{
				'change': this.onApplyToOtherTestsEvent
			}

		});
	},

	afterMainRender: function()
	{
		var me = this;
		var mainViewId = Ext.getCmp('mainView');
		var mainGridId = Ext.getCmp('mainGrid');
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		if ((Ext.isEmpty(showOnlyFromSession) || showOnlyFromSession != 'DDDPurge') )
		{
			Ext.Ajax.request({
				url: '/final/admin/EgDbSettings/data/EgDbSettingsJSON.jsp',
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						myMask.hide();
						var jsonText = response.responseText;
						publicJSONDB = Ext.decode( jsonText );

						isAuditLogEnabled = publicJSONDB['isAuditLogEnabled'];
						ddEnabled = publicJSONDB['ddEnabled']
						isConfigEnabled = publicJSONDB['isConfigEnabled']
						var isBillingEnabled = publicJSONDB['isBillingEnabled'];

						Ext.getCmp('initialCon').setValue(publicJSONDB['sql.initconns']);
						Ext.getCmp('maxCon').setValue(publicJSONDB['sql.maxconns']);
						Ext.getCmp('measure_cleanup').setValue(publicJSONDB['MeasurementCleanPeriod']);
						Ext.getCmp('hourly_cleanup').setValue(publicJSONDB['HourlyCleanPeriod']);
						Ext.getCmp('daily_cleanup').setValue(publicJSONDB['DailyCleanPeriod']);
						Ext.getCmp('monthly_cleanup').setValue(publicJSONDB['MonthlyCleanPeriod']);
						Ext.getCmp('alarm_cleanup').setValue(publicJSONDB['EventHistoryCleanPeriod']);
						Ext.getCmp('fix_cleanup').setValue(publicJSONDB['FixHistoryCleanPeriod']);
						if (ddEnabled)
						{
							Ext.getCmp('detailed_diagnosis_cleanup').show();
							Ext.getCmp('detailed_diagnosis_cleanup').setValue(publicJSONDB['DetailedDiagnosisCleanPeriod']);
						}
						else
						{
							Ext.getCmp('detailed_diagnosis_cleanup').hide();
						}

						if (isConfigEnabled)
						{
							Ext.getCmp('configure_data_cleanup').setValue(publicJSONDB['ConfigMeasurementCleanPeriod']);
							Ext.getCmp('configure_change_cleanup').setValue(publicJSONDB['ConfigChangeMasterCleanPeriod']);
							Ext.getCmp('configure_data_cleanup').show();
							Ext.getCmp('configure_change_cleanup').show();
						}
						else
						{
							Ext.getCmp('configure_data_cleanup').hide();
							Ext.getCmp('configure_change_cleanup').hide();

						}
						Ext.getCmp('day-end_activities_start_time').setValue(publicJSONDB['trendStartTime']);
						if (isAuditLogEnabled)
						{
							Ext.getCmp('AuditLog_CleanPeriod').show();
							Ext.getCmp('AuditLog_CleanPeriod').setValue(publicJSONDB['AuditLogCleanPeriod']);
						}
						else
						{
							Ext.getCmp('AuditLog_CleanPeriod').hide();
						}

						if (isBillingEnabled)
						{
							Ext.getCmp('citrixBillingCleanUp').setValue(publicJSONDB['CtxUserBillingCleanPeriod']);
							Ext.getCmp('citrixMonthlyBillingCleanUp').setValue(publicJSONDB['CtxUserMonthlyBillingCleanPeriod']);
							Ext.getCmp('citrixBillingCleanUp').show();
							Ext.getCmp('citrixMonthlyBillingCleanUp').show();
						}
						else
						{
							Ext.getCmp('citrixBillingCleanUp').hide();
							Ext.getCmp('citrixMonthlyBillingCleanUp').hide();
						}
						
						//var cleanCon = Ext.getCmp('cleanUpContainer');

						//if(cleanUp != null && cleanUp.length > 0){
							//for(var i=0;i<cleanUp.length;i++){
								//var objectDisp =  cleanUpDisp[i];
								//var objectvalue =  cleanUp[i];
								//cleanCon.add({
									//fieldLabel: objectDisp.value,
									//cls:'textbox',
									//id: objectDisp.name
								//});
								//Ext.getCmp(objectDisp.name).setValue(objectvalue.value);
							//}
						//}
					}
				},
				failure: function(response)
				{
					myMask.hide();
				}
			});
		}
	},
	printPage : function()
	{
		var compType = Ext.getCmp('compType').getValue();
		var testType = Ext.getCmp('testType').getValue();
		var printPage;
		if ( testType == 'test')
		{
			printPage = "EgDbSettings/data/EgPrintDBPurgePeriodDetails.jsp?print=printpage&com.eg.CSRF_NONCE="+csrfToken;
		}
		else
		{
			printPage = "EgDbSettings/data/EgPrintPurgePeriodDetails.jsp?print=printpage&com.eg.CSRF_NONCE="+csrfToken;
		}
		Ext.widget('print').show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set(
		{
			src :  printPage
		});
	},
	saveInCSVFormat : function()
	{
		var compType = Ext.getCmp('compType').getValue();
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+user_language;
	},
	savePdf : function()
	{
		var getSaveObj = Ext.widget('dddsavepdf');
		getSaveObj.savePDF(pdfURLString);
	},
	update: function(btn)
	{
		flag = true;
		var initconns = Ext.getCmp('initialCon').getValue();
		var maxconns = Ext.getCmp('maxCon').getValue();
		var meas = Ext.getCmp('measure_cleanup').getValue();
		var hour = Ext.getCmp('hourly_cleanup').getValue();
		var daily = Ext.getCmp('daily_cleanup').getValue();
		var monthly = Ext.getCmp('monthly_cleanup').getValue();
		var event = Ext.getCmp('alarm_cleanup').getValue();
		var fixhist = Ext.getCmp('fix_cleanup').getValue();
		var diagnosis = Ext.getCmp('detailed_diagnosis_cleanup').getValue();
		var configMeasure = Ext.getCmp('configure_data_cleanup').getValue();
		var configChangeMaster = Ext.getCmp('configure_change_cleanup').getValue();
		var trendStartTime = Ext.getCmp('day-end_activities_start_time').getValue();
		var auditLogPeriod = Ext.getCmp('AuditLog_CleanPeriod').getValue();
		
		//var appendUrl = "";
		//if(cleanUp != null && cleanUp.length > 0){
			//for(var i=0;i<cleanUp.length;i++){
				//var objectvalue =  cleanUp[i];
				//var objName = objectvalue.name;
				//var objValue =  Ext.getCmp(objectvalue.name).getValue();
				//appendUrl += "&"+objName+"="+objValue;
			//}
		//}

		var valFlag = 'true';

		var citrixBillingReport = '';
		var citrixMonthlyBillingReport = '';
		var citrixBillingStr = '';
		var citrixMonthlyBillingStr = '';

		var citrixBillingReportValue = '';
		var citrixMonthlyBillingReportValue = '';

		trendStartTime = Ext.Date.format(trendStartTime, 'H:i');

		if (isAuditLogEnabled)
		{
			Ext.getCmp('AuditLog_CleanPeriod').show();
		}
		else
		{
			Ext.getCmp('AuditLog_CleanPeriod').hide();
		}

		var initConnsSql = publicJSONDB['sql.initconns'];
		var maxConnsSql = publicJSONDB['sql.maxconns'];
		var measureCleanPeriod = publicJSONDB['MeasurementCleanPeriod'];
		var hourlyCleanPeriod = publicJSONDB['HourlyCleanPeriod'];
		var dailyCleanPeriod = publicJSONDB['DailyCleanPeriod'];
		var monthlyCleanPeriod = publicJSONDB['MonthlyCleanPeriod'];
		var alarmCleanUp = publicJSONDB['EventHistoryCleanPeriod'];
		var fixHistoryCleanUp = publicJSONDB['FixHistoryCleanPeriod'];
		var ddCleanUp = publicJSONDB['DetailedDiagnosisCleanPeriod'];
		var configureDataCleanUp = publicJSONDB['ConfigMeasurementCleanPeriod'];
		var configureChangeCleanUp = publicJSONDB['ConfigChangeMasterCleanPeriod'];
		var trendStartTimeAudit = publicJSONDB['trendStartTime'];
		var auditCleanPeriod = publicJSONDB['AuditLogCleanPeriod'];

		var isBillingEnabled = publicJSONDB['isBillingEnabled'];

		if (isBillingEnabled)
		{
			citrixBillingReportValue = Ext.getCmp('citrixBillingCleanUp').getValue();
			citrixMonthlyBillingReportValue = Ext.getCmp('citrixMonthlyBillingCleanUp').getValue();

			citrixBillingReport = publicJSONDB['CtxUserBillingCleanPeriod'];
			citrixMonthlyBillingReport = publicJSONDB['CtxUserMonthlyBillingCleanPeriod'];
		}
		else
		{
			citrixBillingReport = publicJSONDB['CtxUserBillingCleanPeriod'];
			citrixMonthlyBillingReport = publicJSONDB['CtxUserMonthlyBillingCleanPeriod'];

			citrixBillingReportValue = citrixBillingReport;
			citrixMonthlyBillingReportValue = citrixMonthlyBillingReport;
		}

		var initconnsStr = ('Initial connections$')+initConnsSql;
		var maxconnsStr = ('Maximum connections$')+maxConnsSql;
		var measCleanUpStr = ('Measurement cleanup$')+measureCleanPeriod;
		var hourlyStr = ('Hourly trend cleanup$')+hourlyCleanPeriod;
		var dailyStr = ('Daily trend cleanup$')+dailyCleanPeriod;
		var monthlyStr = ('Monthly trend cleanup$')+monthlyCleanPeriod;
		var eventStr = ('Report history cleanup$')+alarmCleanUp;
		var fixhistStr = ('Fix history cleanup$')+fixHistoryCleanUp;
		var diagnosisStr = ('Detailed diagnosis cleanup$')+ddCleanUp;
		var configMeasureStr = ('Config measurement cleanup$')+configureDataCleanUp;
		var configChangeMasterStr = ('Config change master cleanup$')+configureChangeCleanUp;
		var trendStartTimeStr = ('Scheduled cleanup time at$')+trendStartTimeAudit;
		var auditLogStr = ('Auditlog cleanup$')+auditCleanPeriod;

		citrixBillingStr = 'Citrix User Billing Report Cleanup Period$'+citrixBillingReport;
		citrixMonthlyBillingStr = 'Citrix User Monthly Billing Report Cleanup Period$'+citrixMonthlyBillingReport;

		var changeURL = "/final/admin/EgDbSettings/data/Egdbsettingsp.jsp?";
		updateURL = changeURL+"MeasurementCleanPeriod="+meas+"&HourlyCleanPeriod="+hour+"&DailyCleanPeriod="+daily+"&MonthlyCleanPeriod="+monthly+"&EventHistoryCleanPeriod="+event+"&FixHistoryCleanPeriod="+fixhist+"&Initconns="+initconns+"&Maxconns="+maxconns+"&DailyTrendComputation="+trendStartTime+"&CtxUserBillingCleanPeriod="+citrixBillingReportValue+"&CtxUserMonthlyBillingCleanPeriod="+citrixMonthlyBillingReportValue;
		//updateURL = updateURL + appendUrl;

		if (ddEnabled)
		{
			if (Ext.isEmpty(diagnosis) || diagnosis <= 0)
			{
				Ext.Msg.show({
					title: dbSettingsTitle,
					msg: alertForEmpty,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function()
					{
						Ext.getCmp('detailed_diagnosis_cleanup').focus();
					}
				});
				valFlag = 'false';
				return;
			}
			if (diagnosis > 3650)
			{
				Ext.Msg.show({
					title: dbSettingsTitle,
					msg: alertForLargePeriod,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function()
					{
						Ext.getCmp('detailed_diagnosis_cleanup').focus();
					}
				});
				valFlag = 'false';
				return;
			}
			updateURL +="&DetailedDiagnosisCleanPeriod="+diagnosis;
			Ext.getCmp('$_DetailedDiagnosisCleanPeriod').setValue(diagnosisStr);
		}

		if (isConfigEnabled)
		{
			if (Ext.isEmpty(configMeasure) || Ext.isEmpty(configChangeMaster) || configMeasure <= 0 || configChangeMaster <= 0)
			{
				Ext.Msg.show({
					title: dbSettingsTitle,
					msg: alertForEmpty,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function()
					{
						if (Ext.isEmpty(configMeasure) || configMeasure <= 0)
						{
							Ext.getCmp('configure_data_cleanup').focus();
						}
						else if (Ext.isEmpty(configChangeMaster) || configChangeMaster <= 0)
						{
							Ext.getCmp('configure_change_cleanup').focus();
						}
					}
				});
				valFlag = 'false';
				return;
			}
			if (configMeasure > 3650 || configChangeMaster > 3650)
			{
				Ext.Msg.show({
					title: dbSettingsTitle,
					msg: alertForLargePeriod,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function()
					{
						if (configMeasure  > 3650)
						{
							Ext.getCmp('configure_data_cleanup').focus();
						}
						else if (configChangeMaster  > 3650)
						{
							Ext.getCmp('configure_change_cleanup').focus();
						}
					}
				});
				valFlag = 'false';
				return;
			}
			updateURL +="&ConfigMeasurementCleanPeriod="+configMeasure+"&ConfigChangeMasterCleanPeriod="+configChangeMaster;
			Ext.getCmp('$_ConfigMeasurementCleanPeriod').setValue(configMeasureStr);
			Ext.getCmp('$_ConfigChangeMasterCleanPeriod').setValue(configChangeMasterStr);
		}

		if (isAuditLogEnabled)
		{
			if ( Ext.isEmpty(auditLogPeriod) || auditLogPeriod <= 0 )
			{
				Ext.Msg.show({
					title: dbSettingsTitle,
					msg: alertForEmpty,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function()
					{
						Ext.getCmp('AuditLog_CleanPeriod').focus();
					}
				});
				valFlag = 'false';
				return;
			}
			if (auditLogPeriod > 3650)
			{
				Ext.Msg.show({
					title: dbSettingsTitle,
					msg: alertForLargePeriod,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function()
					{
						Ext.getCmp('AuditLog_CleanPeriod').focus();
					}
				});
				valFlag = 'false';
				return;
			}
			updateURL +="&AuditLogCleanPeriod="+auditLogPeriod;
			Ext.getCmp('$_AuditLogCleanPeriod').setValue(auditLogStr);
		}

		if (Ext.isEmpty(initconns) || 
			Ext.isEmpty(maxconns) || 
			Ext.isEmpty(meas) || 
			Ext.isEmpty(hour) || 
			Ext.isEmpty(daily) || 
			Ext.isEmpty(monthly) || 
			Ext.isEmpty(event) || 
			Ext.isEmpty(fixhist) || 
			initconns <= 0 || 
			maxconns <= 0 || 
			meas <= 0 || 
			hour <= 0 || 
			daily <= 0 || 
			monthly <= 0 || 
			event <= 0 || 
			fixhist <= 0 )
		{
			Ext.Msg.show({
				title: dbSettingsTitle,
				msg: alertForEmpty,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function()
				{
					if (Ext.isEmpty(initconns) || initconns <= 0)
					{
						Ext.getCmp('initialCon').focus();
					}
					else if (Ext.isEmpty(maxconns) || maxconns <= 0)
					{
						Ext.getCmp('maxCon').focus();
					}
					else if (Ext.isEmpty(meas) || meas <= 0)
					{
						Ext.getCmp('measure_cleanup').focus();
					}
					else if (Ext.isEmpty(hour) || hour <= 0)
					{
						Ext.getCmp('hourly_cleanup').focus();
					}
					else if (Ext.isEmpty(daily) || daily <= 0)
					{
						Ext.getCmp('daily_cleanup').focus();
					}
					else if (Ext.isEmpty(monthly) || monthly <= 0)
					{
						Ext.getCmp('monthly_cleanup').focus();
					}
					else if (Ext.isEmpty(event) || event <= 0)
					{
						Ext.getCmp('alarm_cleanup').focus();
					}
					else if (Ext.isEmpty(fixhist) || fixhist <= 0)
					{
						Ext.getCmp('fix_cleanup').focus();
					}
				}
			});
			valFlag = 'false';
		}

		if (meas > 3650 || 
			hour > 3650 || 
			daily > 3650 || 
			monthly > 3650 || 
			event > 3650 || 
			fixhist > 3650)
		{
			Ext.Msg.show({
				title: dbSettingsTitle,
				msg: alertForLargePeriod,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function()
				{
					if (meas > 3650)
					{
						Ext.getCmp('measure_cleanup').focus();
					}
					else if (hour > 3650)
					{
						Ext.getCmp('hourly_cleanup').focus();
					}
					else if (daily > 3650)
					{
						Ext.getCmp('daily_cleanup').focus();
					}
					else if (monthly > 3650)
					{
						Ext.getCmp('monthly_cleanup').focus();
					}
					else if (event > 3650)
					{
						Ext.getCmp('alarm_cleanup').focus();
					}
					else if (fixhist > 3650)
					{
						Ext.getCmp('fix_cleanup').focus();
					}
				}
			});
			valFlag = 'false';
		}

		if (valFlag == 'true')
		{
			Ext.getCmp('$_Initconns').setValue(initconnsStr);
			Ext.getCmp('$_Maxconns').setValue(maxconnsStr);
			Ext.getCmp('$_MeasurementCleanPeriod').setValue(measCleanUpStr);
			Ext.getCmp('$_HourlyCleanPeriod').setValue(hourlyStr);
			Ext.getCmp('$_DailyCleanPeriod').setValue(dailyStr);
			Ext.getCmp('$_MonthlyCleanPeriod').setValue(monthlyStr);
			Ext.getCmp('$_EventHistoryCleanPeriod').setValue(eventStr);
			Ext.getCmp('$_FixHistoryCleanPeriod').setValue(fixhistStr);
			Ext.getCmp('$_DailyTrendComputation').setValue(trendStartTimeStr);
			Ext.getCmp('$_CtxUserBillingCleanPeriod').setValue(citrixBillingStr);
			Ext.getCmp('$_CtxUserMonthlyBillingCleanPeriod').setValue(citrixMonthlyBillingStr);

			var frmMain = this.getDatabasesettings().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (frmMain.isValid())
			{
				this.getDatabasesettings().submit({
					url: updateURL,
					method: 'POST',
					timeout: 9000,
					//standardSubmit: true
					success: function(form, action){
						myMask.hide();
						Ext.Msg.show({
							title: dbSettingsTitle,
							msg: dbSettingsUpdateMsg,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function() {
								Ext.getCmp('$_Initconns').setValue('');
								Ext.getCmp('$_Maxconns').setValue('');
								Ext.getCmp('$_MeasurementCleanPeriod').setValue('');
								Ext.getCmp('$_HourlyCleanPeriod').setValue('');
								Ext.getCmp('$_DailyCleanPeriod').setValue('');
								Ext.getCmp('$_MonthlyCleanPeriod').setValue('');
								Ext.getCmp('$_EventHistoryCleanPeriod').setValue('');
								Ext.getCmp('$_FixHistoryCleanPeriod').setValue('');
								Ext.getCmp('$_DailyTrendComputation').setValue('');
								Ext.getCmp('$_CtxUserBillingCleanPeriod').setValue('');
								Ext.getCmp('$_CtxUserMonthlyBillingCleanPeriod').setValue('');
								Ext.getCmp('$_AuditLogCleanPeriod').setValue('');
								Ext.getCmp('$_ConfigMeasurementCleanPeriod').setValue('');
								Ext.getCmp('$_ConfigChangeMasterCleanPeriod').setValue('');
								Ext.getCmp('$_DetailedDiagnosisCleanPeriod').setValue('');
							}
						});
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
						Ext.Msg.show({
							title: dbSettingsTitle,
							msg: dbSettingsNoUpdateMsg,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('$_Initconns').setValue('');
								Ext.getCmp('$_Maxconns').setValue('');
								Ext.getCmp('$_MeasurementCleanPeriod').setValue('');
								Ext.getCmp('$_HourlyCleanPeriod').setValue('');
								Ext.getCmp('$_DailyCleanPeriod').setValue('');
								Ext.getCmp('$_MonthlyCleanPeriod').setValue('');
								Ext.getCmp('$_EventHistoryCleanPeriod').setValue('');
								Ext.getCmp('$_FixHistoryCleanPeriod').setValue('');
								Ext.getCmp('$_DailyTrendComputation').setValue('');
								Ext.getCmp('$_CtxUserBillingCleanPeriod').setValue('');
								Ext.getCmp('$_CtxUserMonthlyBillingCleanPeriod').setValue('');
								Ext.getCmp('$_AuditLogCleanPeriod').setValue('');
								Ext.getCmp('$_ConfigMeasurementCleanPeriod').setValue('');
								Ext.getCmp('$_ConfigChangeMasterCleanPeriod').setValue('');
								Ext.getCmp('$_DetailedDiagnosisCleanPeriod').setValue('');
							}
						});
					}
				});
			}
		}
	},

	advanceSettings: function()
	{
		var me = this;

		var mainViewId = Ext.getCmp('mainView');

		if (!Ext.isEmpty(mainViewId))
		{
			mainViewId.removeAll();
		}
		mainViewId.add({ xtype: 'dddpurgeperiods'});
		this.testType();

	},

	testType: function()
	{
		var me = this;
		click = 0;
		var testType = Ext.getCmp('testType').getValue();
		var mainGridId = Ext.getCmp('mainGrid');

		var purgePeriodID = Ext.getCmp('purgePeriods');
		var testsID = Ext.getCmp('testsId');
		var updatePurgeObj = Ext.getCmp('updateInPurge');
		var searchObj = Ext.getCmp('searchId');
		searchObj.setValue("");
		var printObj = Ext.getCmp('print');
		var saveCsvObj = Ext.getCmp('saveCSV');
		var saveObj = Ext.getCmp('save');
		var purgeUrl;
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		if ( testType == 'test')
		{
			purgeUrl = '/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp';
		}
		else
		{
			purgeUrl = '/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp';
		}
		Ext.Ajax.request({
				url: purgeUrl,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						myMask.hide();
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );

						var comboCompTypeObj = Ext.getCmp('compType');
						var compTypesFromJson = jsonData.componentList;
						comboCompTypeObj.getStore().loadRawData(compTypesFromJson);
						comboCompTypeObj.setValue(compTypesFromJson[0].valueField);

						var i, len = jsonData.aListTest.length;

						if (!Ext.isEmpty(mainGridId) && mainGridId.getStore().getCount() > 0)
						{
							mainGridId.getStore().clearFilter();
						}

						if (!Ext.isEmpty(jsonData.gridJson))
						{
							var store = Ext.create('Ext.data.Store', {
								fields: ['Test', 'purgePeriod', 'otherTests'],
								data: jsonData.gridJson,
								proxy: {
									type: "pagingmemory",
									reader: {
										type: "json"
									}
								},
								remoteFilter : true,
								remoteSort: true,
								autoLoad: true,
								pageSize : 20,
								simpleSortMode: true
							});
							mainGridId.reconfigure(store);
							Ext.getCmp('pagingtoolbarid').bindStore(store);

							if (!Ext.isEmpty(updatePurgeObj))
							{
								updatePurgeObj.setDisabled(false);
								printObj.setDisabled(false);
								saveCsvObj.setDisabled(false);
								saveObj.setDisabled(false);

							}
							if (!Ext.isEmpty(searchObj))
							{
								searchObj.setDisabled(false);
							}

						}
						else
						{
							Ext.getCmp('pagingtoolbarid').getStore().removeAll();
							Ext.getCmp('pagingtoolbarid').onLoad();
							Ext.getCmp('pagingtoolbarid').down('#refresh').setDisabled(true);

							if (!Ext.isEmpty(updatePurgeObj))
							{
								updatePurgeObj.setDisabled(true);
								printObj.setDisabled(true);
								saveCsvObj.setDisabled(true);
								saveObj.setDisabled(true);
							}
							if (!Ext.isEmpty(searchObj))
							{
								searchObj.setDisabled(true);
							}
						}
					}
				},
				failure: function(response)
				{
					myMask.hide();
				}
			}
		);
	},

	typeOnChange: function()
	{
		click = 0;
		var mainViewId = Ext.getCmp('mainView');
		var mainGridId = Ext.getCmp('mainGrid');
		var saveObj = Ext.getCmp('save');
		var saveCsvObj = Ext.getCmp('saveCSV');
		var printObj = Ext.getCmp('print');
		var updatePurgeObj = Ext.getCmp('updateInPurge');

		var searchObj = Ext.getCmp('searchId');
		var searchVal = searchObj.setValue("");
		var componentType = Ext.getCmp('compType').getValue();
		var me = this;
		var testType = Ext.getCmp('testType').getValue();
		var purgeUrl;
		if ( testType == 'test')
		{
			purgeUrl = '/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp?componentType='+componentType;
		}
		else
		{
			purgeUrl = '/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp?componentType='+componentType;
		}

		Ext.Ajax.request({
			url: purgeUrl,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					mainGridId.getStore().clearFilter();
					if (!Ext.isEmpty(jsonData.gridJson))
					{
						var store = Ext.create('Ext.data.Store', {
							fields: ['Test', 'purgePeriod', 'otherTests'],
							data: jsonData.gridJson,
							proxy: {
								type: "pagingmemory",
								reader: {
									type: "json"
								}
							},
							remoteFilter : true,
							remoteSort: true,
							autoLoad: true,
							pageSize : 20,
							simpleSortMode: true
						});
						mainGridId.reconfigure(store);
						Ext.getCmp('pagingtoolbarid').bindStore(store);

						if (!Ext.isEmpty(updatePurgeObj))
						{
							updatePurgeObj.setDisabled(false);
							printObj.setDisabled(false);
							saveCsvObj.setDisabled(false);
							saveObj.setDisabled(false);
						}
						if (!Ext.isEmpty(searchObj))
						{
							searchObj.setDisabled(false);
						}
					}
					else
					{
						Ext.getCmp('pagingtoolbarid').getStore().removeAll();
						Ext.getCmp('pagingtoolbarid').onLoad();
						Ext.getCmp('pagingtoolbarid').down('#refresh').setDisabled(true);

						if (!Ext.isEmpty(updatePurgeObj))
						{
							updatePurgeObj.setDisabled(true);
							printObj.setDisabled(true);
							saveCsvObj.setDisabled(true);
							saveObj.setDisabled(true);
						}
						if (!Ext.isEmpty(searchObj))
						{
							searchObj.setDisabled(true);
						}
					}
				}
			}
		});
	},

	onMouseOver: function(a, e, t, eOpts)
	{
		var idOfElement = e.id;

		var testName = idOfElement.substring(0,idOfElement.indexOf('_'));
		
		var testType = Ext.getCmp('testType').getValue();
		var url;
		if ( testType == 'test')
		{
			url = "/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}
		else
		{
			url = "/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var i, len = jsonData.aListTest.length;
				var idForImg = '';

				for (i=0; i<len; i++)
				{
					var testActualName = jsonData.aListTest[i].actualName;
					var testLocalName = '';
					var cleanUpValue = '';

					if (testActualName == testName)
					{
						testLocalName = jsonData.aListTest[i].localName;
						cleanUpValue = jsonData.measuresJson[i].dddCleanupValue;
						idForImg = testActualName+'_'+cleanUpValue+'$'+testLocalName;
						Ext.getCmp(idForImg).show();
					}
				}
			}
		});
	},

	onMouseOut: function(a, e, t, eOpts)
	{
		var idOfElement = e.id;

		var testName = idOfElement.substring(0,idOfElement.indexOf('_'));

		var testType = Ext.getCmp('testType').getValue();
		var url;
		if ( testType == 'test')
		{
			url = "/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}
		else
		{
			url = "/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var i, len = jsonData.aListTest.length;
				var idForImg = '';

				for (i=0; i<len; i++)
				{
					var testActualName = jsonData.aListTest[i].actualName;
					var testLocalName = '';
					var cleanUpValue = '';

					if (testActualName == testName)
					{
						testLocalName = jsonData.aListTest[i].localName;
						cleanUpValue = jsonData.measuresJson[i].dddCleanupValue;
						idForImg = testActualName+'_'+cleanUpValue+'$'+testLocalName;
						Ext.getCmp(idForImg).hide();
					}
				}
			}
		});
	},

	onMouseFieldOver: function(aField, eField, tField, eOptsField)
	{
		var idOfElement = e.id;

		var testName = idOfElement.substring(0,idOfElement.indexOf('_'));
		
		var testType = Ext.getCmp('testType').getValue();
		var url;
		if ( testType == 'test')
		{
			url = "/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}
		else
		{
			url = "/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var i, len = jsonData.aListTest.length;
				var idForImg = '';

				for (i=0; i<len; i++)
				{
					var testActualName = jsonData.aListTest[i].actualName;
					var testLocalName = '';
					var cleanUpValue = '';

					if (testActualName == testName)
					{
						testLocalName = jsonData.aListTest[i].localName;
						cleanUpValue = jsonData.measuresJson[i].dddCleanupValue;
						idForImg = testActualName+'_'+cleanUpValue+'$'+testLocalName;
						Ext.getCmp(idForImg).show();
					}
				}
			}
		});
	},

	onMouseFieldOut: function(aField, eField, tField, eOptsField)
	{
		var idOfElement = e.id;

		var testName = idOfElement.substring(0,idOfElement.indexOf('_'));

		var testType = Ext.getCmp('testType').getValue();
		var url;
		if ( testType == 'test')
		{
			url = "/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}
		else
		{
			url = "/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var i, len = jsonData.aListTest.length;
				var idForImg = '';

				for (i=0; i<len; i++)
				{
					var testActualName = jsonData.aListTest[i].actualName;
					var testLocalName = '';
					var cleanUpValue = '';

					if (testActualName == testName)
					{
						testLocalName = jsonData.aListTest[i].localName;
						cleanUpValue = jsonData.measuresJson[i].dddCleanupValue;
						idForImg = testActualName+'_'+cleanUpValue+'$'+testLocalName;
						Ext.getCmp(idForImg).hide();
					}
				}
			}
		});
	},

	typeOnChangeInApply: function()
	{
		var testType = Ext.getCmp('test_type').getValue();
		Ext.getCmp('applyToOtherTestsID').setValue("");
		var url;
		if ( testType == 'test')
		{
			url = "/final/admin/EgDbSettings/data/EgApplyToOtherTestsJSON.jsp?componentType="+Ext.getCmp("compTypeInApply").getValue();
		}
		else
		{
			url = "/final/admin/EgDbSettings/data/EgApplyToOtherTestsDDDJSON.jsp?componentType="+Ext.getCmp("compTypeInApply").getValue();
		}
		var field = '';
		var fieldButton = '';
		var purgePeriodsTest = Ext.getCmp('purgePeriods');
		var testsToApplyObj = Ext.getCmp('testsToApply');
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var testsFromJson = jsonData.testsJson;
				testsToApplyObj.getStore().clearFilter();
				testsToApplyObj.getStore().loadRawData(testsFromJson);
			}
		});
	},

	applyToOtherTests: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var mainViewId = Ext.getCmp('mainView');
		var viewStoreObj = Ext.getCmp('mainGrid');
		var compType = Ext.getCmp('compType').getValue();

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var testName = record.get('Test');
		
		var testType = Ext.getCmp('testType').getValue();
		var url;
		if ( testType == 'test')
		{
			url = "/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}
		else
		{
			url = "/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var i, len = jsonData.aListTest.length;
				var idForImg = '';
				var testLocalName = '';
				var cleanUpValue = '';

				for (i=0; i<len; i++)
				{
					var testDisplayName = jsonData.aListTest[i].localName;

					if (testDisplayName == testName)
					{
						testActualName = jsonData.aListTest[i].actualName;
						cleanUpValue = record.get('purgePeriod');
					}
				}

				var isValueANumber = checkNumber(cleanUpValue);

				if (!isValueANumber)
				{
					Ext.Msg.show({
						title: ddPurgePeriodsTitle,
						msg: alertForBlankPeriod,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function()
						{
							var dataCnt = viewStoreObj.getStore().data.items.length;
							for (var i =0 ; i < dataCnt; i++)
							{
								var data = viewStoreObj.getStore().data.items[i].data.purgePeriod;
								if (!checkNumber(data))
								{
									var rowIndex = viewStoreObj.getStore().find("purgePeriod",data);
									cellEditing.startEdit(rowIndex,1);
									return;
								}
							}
						}
					});
					return;
				}
				
				if (Ext.isEmpty(cleanUpValue) || cleanUpValue == ' ' || Number(cleanUpValue) <= 0)
				{
					Ext.Msg.show({
						title: ddPurgePeriodsTitle,
						msg: alertForBlankPeriod,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function()
						{
							var rowNumber = 0;
							var dataCnt = viewStoreObj.getStore().data.items.length;
							for (var i =0 ; i < dataCnt; i++)
							{
								rowNumber ++;
								var data = viewStoreObj.getStore().data.items[i].data.purgePeriod;
								if (data <= 0 || data == '' || !data)
								{
									cellEditing.startEdit(rowNumber-1,1);
									return;
								}
							}
						}
					});
					return;
				}

				if(cleanUpValue > 3650)
				{
					Ext.Msg.show({
						title: ddPurgePeriodsTitle,
						msg: alertForLargePeriod,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function()
						{
							var dataCnt = viewStoreObj.getStore().data.items.length;
							for (var i =0 ; i < dataCnt; i++)
							{
								var data = viewStoreObj.getStore().data.items[i].data.purgePeriod;
								if (parseInt(data) > 3650)
								{
									var rowIndex = viewStoreObj.getStore().find("purgePeriod",data);
									cellEditing.startEdit(rowIndex,1);
									return;
								}
							}
						}
					});
					return;
				}
				if (!Ext.isEmpty(mainViewId))
				{
					mainViewId.removeAll();
				}
				mainViewId.add({ xtype: 'dddpurgeperiodapplytoothertests'});
				var urlForRender;
				if (testType == 'test')
				{
					urlForRender = "/final/admin/EgDbSettings/data/EgApplyToOtherTestsJSON.jsp?"+'testName='+testActualName+'&testValue='+cleanUpValue+'&componentType='+compType+'&testType='+testType;
				}
				else
				{
					urlForRender = "/final/admin/EgDbSettings/data/EgApplyToOtherTestsDDDJSON.jsp?"+'testName='+testActualName+'&testValue='+cleanUpValue+'&componentType='+compType+'&testType='+testType;
				}
				
				var myMask1 = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
				myMask1.show();

				Ext.Ajax.request({
					url: urlForRender,
					method: 'POST',
					success: function( response )
					{
						myMask1.hide();
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode( jsonText );

							var comboCompTypeObj = Ext.getCmp('compTypeInApply');
							var selectedcompTypes = jsonData.componentType;
							var compTypesFromJson = jsonData.componentList;
							comboCompTypeObj.getStore().loadRawData(compTypesFromJson);

							if ( !Ext.isEmpty(selectedcompTypes) )
							{
								comboCompTypeObj.setValue(selectedcompTypes);
							}
							else
							{
								comboCompTypeObj.setValue(compTypesFromJson[0].valueField);
							}

							var comboCompTypeObj = Ext.getCmp('testsToApply');
							var testsFromJson = jsonData.testsJson;

							var aStore = new Ext.data.Store({
								fields: ['displayField','valueField'],
							});

							for (var i=0; i<testsFromJson.length; i++)
							{
								var aMeasureDisplayField = testsFromJson[i].displayField;
								var aMeasureValueField = testsFromJson[i].valueField;
								aStore.add({'displayField': aMeasureDisplayField, 'valueField': aMeasureValueField});
								comboCompTypeObj.bindStore(aStore);
							}
							var selectedTestObj = Ext.getCmp('test_type');
							var selectedTestTypeJson = jsonData.testType;
							selectedTestObj.setValue(selectedTestTypeJson);

							var selectedTestObj = Ext.getCmp('selected_test');
							var selectedTestFromJson = jsonData.temp_TestnameLabel;
							selectedTestObj.setValue(selectedTestFromJson);

							var selectedTestObj = Ext.getCmp('period_value');
							var selectedValueFromJson = jsonData.temp_Testvalue;
							selectedTestObj.setValue(selectedValueFromJson);
						}
					},
					failure: function(response)
					{
						myMask1.hide();
					}
				});
			},
			failure: function(response)
			{
				myMask.hide();
			}
		});
	},

	onGridEnter: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
				Ext.get(icon).removeCls('x-hidden');
		});
	},

	onGridLeave: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},

	updateMore: function()
	{
		click = 0;
		var testValue = Ext.getCmp("period_value").value;
		var testsValue = Ext.getCmp("testsToApply").getValue();
		var currentTestValue = Ext.getCmp("selected_test").getValue();
		var componentType = Ext.getCmp("compTypeInApply").value;
		var testType = Ext.getCmp("test_type").value;
		var updateURL;
		if (testType == 'test')
		{
			updateURL = "/final/admin/EgDbSettings/data/EgDBPurgeJSONp.jsp?testValue="+testValue+"&currentTestValue="+currentTestValue+"&testsName="+testsValue+"&componentType="+componentType+"&strFromPage="+"EgApplyToOtherTests.jsp";
		}
		else
		{
			updateURL = "/final/admin/EgDbSettings/data/EgDDDPurgeJSONp.jsp?testValue="+testValue+"&currentTestValue="+currentTestValue+"&testsName="+testsValue+"&componentType="+componentType+"&strFromPage="+"EgApplyToOtherTests.jsp";
		}
		
		Ext.Ajax.request(
		{
			url : updateURL,
			scope:this,
			method : 'POST',
			success: function(response){
				Ext.Msg.show({
					title: applyToOtherTestsTitle,
					msg: alertForSuccessUpdate,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation'
				});
			},
			failure: function(response){
				Ext.Msg.show({
					title: applyToOtherTestsTitle,
					msg: alertForFailureUpdate,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			},
		});
	},

	updateInApply: function()
	{
		var mainViewId = Ext.getCmp('mainView');
		click = 0;
		var testValue = Ext.getCmp("period_value").value;
		var testsValue = Ext.getCmp("testsToApply").getValue();
		var currentTestValue = Ext.getCmp("selected_test").getValue();
		var componentType = Ext.getCmp("compTypeInApply").value;
		var me = this;

		var testType = Ext.getCmp("test_type").value;
		
		var updateURL;
		if (testType == 'test')
		{
			updateURL = "/final/admin/EgDbSettings/data/EgDBPurgeJSONp.jsp?testValue="+testValue+"&currentTestValue="+currentTestValue+"&testsName="+testsValue+"&componentType="+componentType+"&strFromPage="+"EgApplyToOtherTests.jsp";
		}
		else
		{
			updateURL = "/final/admin/EgDbSettings/data/EgDDDPurgeJSONp.jsp?testValue="+testValue+"&currentTestValue="+currentTestValue+"&testsName="+testsValue+"&componentType="+componentType+"&strFromPage="+"EgApplyToOtherTests.jsp";
		}
		
		//var applyToOtherTestsForm = this.getDddpurgeperiodapplytoothertests().getForm();
		//if (applyToOtherTestsForm.isValid())
		{
			Ext.Ajax.request({
			url: updateURL,
			method: 'POST',
			success: function(form, action){
				Ext.Msg.show({
					title: applyToOtherTestsTitle,
					msg: alertForSuccessUpdate,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation'
				});
				var testType = Ext.getCmp('test_type').getValue();
				if (!Ext.isEmpty(mainViewId))
				{
					mainViewId.removeAll();
				}
				mainViewId.add({ xtype: 'dddpurgeperiods'});

				var componentTypeInPurge = Ext.getCmp('compType').getValue();

				var mainGridId = Ext.getCmp('mainGrid');
				
				var url;
				if ( testType == 'test')
				{
					url = '/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp?componentType='+componentType+'&testType='+testType;
				}
				else
				{
					url = '/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp?componentType='+componentType+'&testType='+testType;
				}

				Ext.Ajax.request({
					url: url,
					method: 'POST',
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode( jsonText );

							var comboCompTypeObj = Ext.getCmp('compType');
							var compTypesFromJson = jsonData.componentList;
							comboCompTypeObj.getStore().loadRawData(compTypesFromJson);

							Ext.getCmp('compType').setValue(componentType);

							var testTypeObj = Ext.getCmp('testType');
							testTypeObj.setValue(jsonData.testType);

							mainGridId.getStore().clearFilter();
							var store = Ext.create('Ext.data.Store', {
								fields: ['Test', 'purgePeriod', 'otherTests'],
								data: jsonData.gridJson,
								proxy: {
									type: "pagingmemory",
									reader: {
										type: "json"
									}
								},
								remoteFilter : true,
								remoteSort: true,
								autoLoad: true,
								pageSize : 20,
								simpleSortMode: true
							});
							mainGridId.reconfigure(store);
							Ext.getCmp('pagingtoolbarid').bindStore(store);

						}
					}
				});
			},
			failure: function(form, action)
			{
				Ext.Msg.show({
					title: applyToOtherTestsTitle,
					msg: alertForFailureUpdate,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
			});
		}
	},

	goToPurge: function()
	{
		click = 0;
		var mainViewId = Ext.getCmp('mainView');
		var componentType = Ext.getCmp("compTypeInApply").value;
		var testType = Ext.getCmp('test_type').getValue();
		var url;
		if ( testType == 'test')
		{
			url = '/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp?componentType='+componentType+'&testType='+testType;
		}
		else
		{
			url = '/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp?componentType='+componentType+'&testType='+testType;
		}

		var me = this;

		if (!Ext.isEmpty(mainViewId))
		{
			mainViewId.removeAll();
		}
		mainViewId.add({ xtype: 'dddpurgeperiods'});

		var mainGridId = Ext.getCmp('mainGrid');

		Ext.Ajax.request({
			url: url,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );

					var comboCompTypeObj = Ext.getCmp('compType');
					var compTypesFromJson = jsonData.componentList;
					comboCompTypeObj.getStore().loadRawData(compTypesFromJson);
					comboCompTypeObj.setValue(componentType);
					
					var testTypeObj = Ext.getCmp('testType');
					testTypeObj.setValue(jsonData.testType);

					mainGridId.getStore().clearFilter();
					//mainGridId.getStore().loadRawData(jsonData.gridJson);
					var store = Ext.create('Ext.data.Store', {
						fields: ['Test', 'purgePeriod', 'otherTests'],
						data: jsonData.gridJson,
						proxy: {
							type: "pagingmemory",
							reader: {
								type: "json"
							}
						},
						remoteFilter : true,
						remoteSort: true,
						autoLoad: true,
						pageSize : 20,
						simpleSortMode: true
					});
					mainGridId.reconfigure(store);
					Ext.getCmp('pagingtoolbarid').bindStore(store);
				}
			}
		});
	},

	goToMainDbSettings: function()
	{
		var mainViewId = Ext.getCmp('mainView');
		var mainGridId = Ext.getCmp('mainGrid');

		if (!Ext.isEmpty(mainViewId))
		{
			mainViewId.removeAll();
		}
		mainViewId.add({ xtype: 'databasesettings' });

		Ext.Ajax.request({
			url: '/final/admin/EgDbSettings/data/EgDbSettingsJSON.jsp',
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var publicJSONDB = Ext.decode( jsonText );

					Ext.getCmp('initialCon').setValue(publicJSONDB['sql.initconns']);
					Ext.getCmp('maxCon').setValue(publicJSONDB['sql.maxconns']);
					Ext.getCmp('measure_cleanup').setValue(publicJSONDB['MeasurementCleanPeriod']);
					Ext.getCmp('hourly_cleanup').setValue(publicJSONDB['HourlyCleanPeriod']);
					Ext.getCmp('daily_cleanup').setValue(publicJSONDB['DailyCleanPeriod']);
					Ext.getCmp('monthly_cleanup').setValue(publicJSONDB['MonthlyCleanPeriod']);
					Ext.getCmp('alarm_cleanup').setValue(publicJSONDB['EventHistoryCleanPeriod']);
					Ext.getCmp('fix_cleanup').setValue(publicJSONDB['FixHistoryCleanPeriod']);
					if (ddEnabled)
					{
						Ext.getCmp('detailed_diagnosis_cleanup').setValue(publicJSONDB['DetailedDiagnosisCleanPeriod']);
						Ext.getCmp('detailed_diagnosis_cleanup').show();
					}
					else
					{
						Ext.getCmp('detailed_diagnosis_cleanup').hide();
					}

					if (isConfigEnabled)
					{
						Ext.getCmp('configure_data_cleanup').setValue(publicJSONDB['ConfigMeasurementCleanPeriod']);
						Ext.getCmp('configure_change_cleanup').setValue(publicJSONDB['ConfigChangeMasterCleanPeriod']);
						Ext.getCmp('configure_data_cleanup').show();
						Ext.getCmp('configure_change_cleanup').show();
					}
					else
					{
						Ext.getCmp('configure_data_cleanup').hide();
						Ext.getCmp('configure_change_cleanup').hide();
					}

					Ext.getCmp('day-end_activities_start_time').setValue(publicJSONDB['trendStartTime']);
					if (isAuditLogEnabled)
					{
						Ext.getCmp('AuditLog_CleanPeriod').setValue(publicJSONDB['AuditLogCleanPeriod']);
						Ext.getCmp('AuditLog_CleanPeriod').show();
					}
					else
					{
						Ext.getCmp('AuditLog_CleanPeriod').hide();
					}
				}
			}
		}
		);
	},

	onClickTrigger: function()
	{
		var egTitleSearchStr = Ext.getCmp('searchId').getValue();
		var mainGridId = Ext.getCmp('mainGrid');
		
		var testType = Ext.getCmp('testType').getValue();
		var url;
		if ( testType == 'test')
		{
			url = "/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue()+"&egTitleSearchStr="+encodeURIComponent(filterEncode(egTitleSearchStr));
		}
		else
		{
			url = "/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue()+"&egTitleSearchStr="+encodeURIComponent(filterEncode(egTitleSearchStr));
		}

		Ext.Ajax.request({
				url: url,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );

						mainGridId.getStore().loadRawData(jsonData.gridJson);
					}
				}
			}
		);
	},

	onApplyToOtherTestsEvent: function()
	{
		var egTitleSearchStr = Ext.getCmp('applyToOtherTestsID').getValue();

		var comboCompType = Ext.getCmp('compTypeInApply').getValue();

		var testsToApplyValue = Ext.getCmp('testsToApply').getValue();

		var selectedTestValue = Ext.getCmp('selected_test').getValue();

		var periodValue = Ext.getCmp('period_value').getValue();

		var comboCompTypeObj = Ext.getCmp('testsToApply');

		if (egTitleSearchStr == "" || egTitleSearchStr.length == 0)
		{
			Ext.get('MyTriggerApp_0').setStyle('display','none');
			Ext.get('MyTriggerApp_1').setStyle('display','block');
			return;
		}
		else
		{
			Ext.get('MyTriggerApp_1').setStyle('display','none');
			Ext.get('MyTriggerApp_0').setStyle('display','block');
		}

		comboCompTypeObj.getStore().clearFilter();
		var searchList = new Array();
		var searchArr = egTitleSearchStr.split(',');
		for (var x=0; x<searchArr.length; x++)
		{
			var searchStr = searchArr[x].trim();
			if(!Ext.isEmpty(searchStr))
			{
				searchList.push(searchStr);
			}
		}
		var userFilter = new Ext.util.Filter({
			filterFn: function(item) 
			{
				var itemValue = item.get('displayField');

				for(var i=0;i<searchList.length;i++)
				{
					var searchStr = searchList[i];
					if(itemValue.indexOf(searchStr) !=-1 || itemValue.toLowerCase().indexOf(searchStr.toLowerCase()) !=-1)
					{
						return true;
					}
				}
			}
		});
		comboCompTypeObj.getStore().suspendEvents(true);
		comboCompTypeObj.getStore().filter(userFilter);
		comboCompTypeObj.getStore().resumeEvents();
	},

	clearApplyToOtherSearch : function(obj)
	{
		obj.reset();
		var egTitleSearchStr = Ext.getCmp('applyToOtherTestsID').getValue();

		var comboCompTypeObj = Ext.getCmp('testsToApply');

		if (egTitleSearchStr == "" || egTitleSearchStr.length == 0)
		{
			Ext.get('MyTriggerApp_0').setStyle('display','none');
			Ext.get('MyTriggerApp_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTriggerApp_1').setStyle('display','none');
			Ext.get('MyTriggerApp_0').setStyle('display','block');
		}
		comboCompTypeObj.getStore().clearFilter();
	},

	onChangeEvent: function(obj)
	{
		var egTitleSearchStr = "";
		if (Ext.isEmpty(obj))
		{
			egTitleSearchStr = Ext.getCmp('searchId').getValue();
		}
		else
		{
			egTitleSearchStr = obj.getValue();
		}
		var updatePurgeObj = Ext.getCmp('updateInPurge');
		var saveObj = Ext.getCmp('save');
		var saveCsvObj = Ext.getCmp('saveCSV');
		var printObj = Ext.getCmp('print');
		var mainGridId = Ext.getCmp('mainGrid');
		searchFlag = 'true';

		if (egTitleSearchStr == "" || egTitleSearchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
			return;
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		var storeCount = 0;
		mainGridId.getStore().clearFilter();
		var searchList = new Array();
		var searchArr = egTitleSearchStr.split(',');
		for (var x=0; x<searchArr.length; x++)
		{
			var searchStr = searchArr[x].trim();
			if(!Ext.isEmpty(searchStr))
			{
				searchList.push(searchStr);
			}
		}
		var userFilter = new Ext.util.Filter({
			filterFn: function(item) 
			{
				var itemValue = item.get('Test');
				for(var i=0;i<searchList.length;i++)
				{
					var searchStr = searchList[i];
					if(itemValue.indexOf(searchStr) !=-1 || itemValue.toLowerCase().indexOf(searchStr.toLowerCase()) !=-1)
					{
						storeCount++;
						return true;
					}
				}
			}
		});
		mainGridId.getStore().suspendEvents(true);
		mainGridId.getStore().filter(userFilter);
		mainGridId.getStore().resumeEvents();

		if (storeCount > 0)
		{
			updatePurgeObj.setDisabled(false);
			saveObj.setDisabled(false);
			saveCsvObj.setDisabled(false);
			printObj.setDisabled(false);
		}
		else
		{
			mainGridId.getView().emptyText = [ '<div class="egFlexCenterByColumnWise" style="height:98%"><div class="iconInformation"></div><div class="commonErrorMsgText" >'+noSelections+'</div></div>' ];
			updatePurgeObj.setDisabled(true);
			saveObj.setDisabled(true);
			saveCsvObj.setDisabled(true);
			printObj.setDisabled(true);
		}
	},

	clearSearch: function()
	{
		Ext.getCmp('searchId').reset();

		var egTitleSearchStr = Ext.getCmp('searchId').getValue();
		var updatePurgeObj = Ext.getCmp('updateInPurge');
		var saveObj = Ext.getCmp('save');
		var saveCsvObj = Ext.getCmp('saveCSV');
		var printObj = Ext.getCmp('print');
		var mainGridId = Ext.getCmp('mainGrid');
		searchFlag = 'true';

		if (egTitleSearchStr == "" || egTitleSearchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		mainGridId.getStore().clearFilter();

		updatePurgeObj.setDisabled(false);
		saveObj.setDisabled(false);
		saveCsvObj.setDisabled(false);
		printObj.setDisabled(false);

	},

	onClickTriggerForApplyTests: function()
	{
		var egTitleSearchStr = Ext.getCmp('applyToOtherTestsID').getValue();

		var comboCompType = Ext.getCmp('compTypeInApply').getValue();

		var testsToApplyValue = Ext.getCmp('testsToApply').getValue();

		var selectedTestValue = Ext.getCmp('selected_test').getValue();

		var periodValue = Ext.getCmp('period_value').getValue();

		var comboCompTypeObj = Ext.getCmp('testsToApply');
	
		var testType = Ext.getCmp('testType').getValue();
		var urlForRender;
		if ( testType == 'test')
		{
			urlForRender = "/final/admin/EgDbSettings/data/EgApplyToOtherTestsJSON.jsp?"+'testName='+selectedTestValue+'&testValue='+periodValue+'&componentType='+comboCompType+'&egTitleSearchStr='+encodeURIComponent(filterEncode(egTitleSearchStr));
		}
		else
		{
			urlForRender = "/final/admin/EgDbSettings/data/EgApplyToOtherTestsDDDJSON.jsp?"+'testName='+selectedTestValue+'&testValue='+periodValue+'&componentType='+comboCompType+'&egTitleSearchStr='+encodeURIComponent(filterEncode(egTitleSearchStr));
		}

		Ext.Ajax.request({
				url: urlForRender,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );

						var testsFromJson = jsonData.testsJson;
						comboCompTypeObj.getStore().loadRawData(testsFromJson);
					}
				}
			}
		);
	},

	beforeGridClick: function( me, record, item, rownumber, e )
	{
		var mainGridId = Ext.getCmp('mainGrid');
		var pluginEdit = mainGridId.getPlugin('cellEditingPlugin');

		var editField = new Ext.form.field.Text({
			id: 'periodColumnEditor'+click,
			value: item,
		});
		editFieldArray.push(editField);

		Ext.getCmp('periodColumnId').setEditor(editFieldArray);
		click = click + 1;
	},
	encodeFieldParams: function(thisForm){
		var encodeParams = "";
		var fieldsArr = thisForm.getFields().items;
		var encodeParamList = ['ddPurgePeriods','ddPurgePeriodsForAudit'];
		for(var i in fieldsArr)
		{
			var fieldParamName = fieldsArr[i].name;
			var fieldParamValue = fieldsArr[i].value;
			if (!Ext.isEmpty(fieldParamName) && fieldParamName == 'searchId-inputEl')
			{
				Ext.getCmp(fieldsArr[i].id).submitValue = false;
			}
			if(Ext.isEmpty(fieldParamName) || fieldsArr[i].disabled || !thisController.isExistsParam(encodeParamList,fieldParamName))
			{
				continue;
			}
			Ext.getCmp(fieldsArr[i].id).submitValue = false;
			encodeParams += "&"+fieldParamName+"="+encodeURIComponent(filterEncode(fieldParamValue));
		}
		return encodeParams;
	},
	isExistsParam: function(array, item) {
		var i, ln;
		for (i = 0, ln = array.length; i < ln; i++) {
			if (array[i].toLowerCase() === item.toLowerCase()) {
				return true;
			}
		}
		return false;
	},
	updateInPurge: function()
	{
		var mainGridObj = Ext.getCmp('mainGrid');
		var testType = Ext.getCmp('testType').getValue();
		var url;
		if ( testType == 'test')
		{
			url = "/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}
		else
		{
			url = "/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue();
		}
		var compTypeValue = Ext.getCmp("compType").getValue();
		
		var purgePeriodsTest = Ext.getCmp('purgePeriodID');
		var me = this;

		if (searchFlag == 'false')
		{
			var queryStringDDDPurge = '';
			var fullString = '';
			var theTestInJsonForAudit = '';
			var processQueryString = '';
			var queryStringDDDPurgeForIni = '';
			var fullStringForIni = '';
			var processQueryStringForIni = '';
			var prevValueForAudit = '';
			var theFieldforSecondTime = '';
			var thelocalNameforSecondTime = '';
			var theField = '';

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var len = jsonData.aListTest.length;
					for (var i=0; i<click; i++)
					{
						var itemidClicked = 'periodColumnEditor'+i;

						if (!Ext.isEmpty(Ext.getCmp(itemidClicked)))
						{
							var itemClickedRow = Ext.getCmp(itemidClicked).getValue();
							var store = mainGridObj.getStore();
							var record = store.getAt(itemClickedRow);
							var displaytestName = record.get('Test');
							var aValue = record.get('purgePeriod');

							var isValueANumber = checkNumber(aValue);

							if (!isValueANumber)
							{
								Ext.Msg.show({
									title: ddPurgePeriodsTitle,
									msg: alertForBlankPeriod,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn : function()
									{
										var dataCnt = mainGridObj.getStore().data.items.length;
										for (var i =0 ; i < dataCnt; i++)
										{
											var data = mainGridObj.getStore().data.items[i].data.purgePeriod;
											if (!checkNumber(data))
											{
												var rowIndex = mainGridObj.getStore().find("purgePeriod",data);
												cellEditing.startEdit(rowIndex,1);
												return;
											}
										}
									}
								});
								return;
							}

							if (Ext.isEmpty(aValue) || aValue == ' ' || Number(aValue) <= 0)
							{
								Ext.Msg.show({
									title: ddPurgePeriodsTitle,
									msg: alertForBlankPeriod,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn : function()
									{
										var rowNumber = 0;
										var dataCnt = mainGridObj.getStore().data.items.length;
										for (var i =0 ; i < dataCnt; i++)
										{
											rowNumber ++;
											var data = mainGridObj.getStore().data.items[i].data.purgePeriod;
											if (data <= 0 || data == '' || !data)
											{
												cellEditing.startEdit(rowNumber-1,1);
												return;
											}
										}
									}
								});
								return;
							}

							if (Number(aValue) > 3650)
							{
								Ext.Msg.show({
									title: ddPurgePeriodsTitle,
									msg: alertForLargePeriod,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn : function()
									{
										var dataCnt = mainGridObj.getStore().data.items.length;
										for (var i =0 ; i < dataCnt; i++)
										{
											var data = mainGridObj.getStore().data.items[i].data.purgePeriod;
											if (parseInt(data) > 3650)
											{
												var rowIndex = mainGridObj.getStore().find("purgePeriod",data);
												cellEditing.startEdit(rowIndex,1);
												return;
											}
										}
									}
								});
								return;
							}

							for (var j=0; j<len; j++)
							{
								purgePeriodsTest = Ext.getCmp('purgePeriods');

								if (displaytestName == jsonData.gridJson[j].Test)
								{
									theTestInJsonForAudit = jsonData.gridJson[j].Test;
									prevValueForAudit = jsonData.gridJson[j].purgePeriod;
								}

								if (displaytestName == jsonData.aListTest[j].localName)
								{
									theField = jsonData.aListTest[j].localName+'_DDD';
									var theFieldWithActualName = jsonData.aListTest[j].actualName+'_DDD';

									theFieldforSecondTime = "$_"+jsonData.aListTest[j].actualName+'_DDD';
									thelocalNameforSecondTime = jsonData.aListTest[j].localName+"_DDD"+"$"+prevValueForAudit;
								}
							}

							var onlyParam = '';
							var onlyActualParam = '';
							var testlocalValueParam = '';
							var testlocalValueParamForIni = '';
							if (i == len-1)
							{
								onlyParam = theField + '=' + aValue;
								testlocalValueParam = theFieldforSecondTime + '=' + thelocalNameforSecondTime;
							}
							else
							{
								onlyParam = theField + '=' + aValue + '&';
								testlocalValueParam = theFieldforSecondTime + '=' + thelocalNameforSecondTime + '&';
							}

							queryStringDDDPurge += onlyParam;
							fullString += testlocalValueParam;
							processQueryString = queryStringDDDPurge + '&' + fullString;
							
							if (i == len-1)
							{
								onlyActualParam = theFieldWithActualName + '=' + aValue + '&';
								testlocalValueParamForIni = theFieldforSecondTime + '=' + thelocalNameforSecondTime;
							}
							else
							{
								onlyActualParam = theFieldWithActualName + '=' + aValue + '&';
								testlocalValueParamForIni = theFieldforSecondTime + '=' + thelocalNameforSecondTime + '&';
							}

							queryStringDDDPurgeForIni += onlyActualParam;
							fullStringForIni += testlocalValueParamForIni;
							processQueryStringForIni = queryStringDDDPurgeForIni + '&' + fullStringForIni;
						}
					}

					Ext.getCmp('purgePeriodsId').setValue(processQueryStringForIni);
					Ext.getCmp('purgePeriodsIdForAudit').setValue(processQueryString);

					var purgePeriodsForm = this.getDddpurgeperiods().getForm();

					var testType = Ext.getCmp("testType").value;
		
					var updateURL;
					if (testType == 'test')
					{
						updateURL = "/final/admin/EgDbSettings/data/EgDBPurgeJSONp.jsp";
					}
					else
					{
						updateURL = "/final/admin/EgDbSettings/data/EgDDDPurgeJSONp.jsp";
					}

					if (purgePeriodsForm.isValid())
					{
						purgePeriodsForm.submit({
							url: updateURL,
							params: thisController.encodeFieldParams(purgePeriodsForm),
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: ddPurgePeriodsTitle,
									msg: ddPurgePeriodUpdateMsg,
									width: 400,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
								click = 0;
								Ext.Ajax.request(
								{
									url : url,
									scope:this,
									method : 'POST',
									success: function(response){
										var jsonText = response.responseText;
										var jsonData = Ext.decode( jsonText );

										var comboCompTypeObj = Ext.getCmp('compType');
										var compTypesFromJson = jsonData.componentList;
										comboCompTypeObj.getStore().loadRawData(compTypesFromJson);
										comboCompTypeObj.setValue(compTypeValue);

										var store = Ext.create('Ext.data.Store', {
											fields: ['Test', 'purgePeriod', 'otherTests'],
											data: jsonData.gridJson,
											proxy: {
												type: "pagingmemory",
												reader: {
													type: "json"
												}
											},
											remoteFilter : true,
											remoteSort: true,
											autoLoad: true,
											pageSize : 20,
											simpleSortMode: true
										});
										mainGridObj.reconfigure(store);
										Ext.getCmp('pagingtoolbarid').bindStore(store);
									}
								});
							},
							failure: function(response){
								Ext.Msg.show({
									title: ddPurgePeriodsTitle,
									msg: ddPurgePeriodNoUpdateMsg,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							},
						});
					}
				}
			});
		}
		else
		{
			var queryStringDDDPurge = '';
			var fullString = '';
			var processQueryString = '';
			var queryStringDDDPurgeForIni = '';
			var fullStringForIni = '';
			var processQueryStringForIni = '';

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var i, len = jsonData.aListTest.length;
					var lenForGrid = jsonData.gridJson.length;
					// added for search update
					for (var i=0; i<click; i++)
					{
						var itemidClicked = 'periodColumnEditor'+i;

						if (!Ext.isEmpty(Ext.getCmp(itemidClicked)))
						{
							var itemClickedRow = Ext.getCmp(itemidClicked).getValue();
							var store = mainGridObj.getStore();
							var record = store.getAt(itemClickedRow);
							var displayTestName = record.get('Test');
							var aValue = record.get('purgePeriod');

							var isValueANumber = checkNumber(aValue);

							if (!isValueANumber)
							{
								Ext.Msg.show({
									title: ddPurgePeriodsTitle,
									msg: alertForBlankPeriod,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn : function()
									{
										var dataCnt = mainGridObj.getStore().data.items.length;
										for (var i =0 ; i < dataCnt; i++)
										{
											var data = mainGridObj.getStore().data.items[i].data.purgePeriod;
											if (!checkNumber(data))
											{
												var rowIndex = mainGridObj.getStore().find("purgePeriod",data);
												cellEditing.startEdit(rowIndex,1);
												return;
											}
										}
									}
								});
								return;
							}

							if (Ext.isEmpty(aValue) || aValue == ' ' || Number(aValue) <= 0)
							{
								Ext.Msg.show({
									title: ddPurgePeriodsTitle,
									msg: alertForBlankPeriod,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn : function()
									{
										var rowNumber = 0;
										var dataCnt = mainGridObj.getStore().data.items.length;
										for (var i =0 ; i < dataCnt; i++)
										{
											rowNumber ++;
											var data = mainGridObj.getStore().data.items[i].data.purgePeriod;
											if (data <= 0 || data == '' || !data)
											{
												cellEditing.startEdit(rowNumber-1,1);
												return;
											}
										}
									}
								});
								return;
							}

							if (Number(aValue) > 3650)
							{
								Ext.Msg.show({
									title: ddPurgePeriodsTitle,
									msg: alertForLargePeriod,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn : function()
									{
										var dataCnt = mainGridObj.getStore().data.items.length;
										for (var i =0 ; i < dataCnt; i++)
										{
											var data = mainGridObj.getStore().data.items[i].data.purgePeriod;
											if (parseInt(data) > 3650)
											{
												var rowIndex = mainGridObj.getStore().find("purgePeriod",data);
												cellEditing.startEdit(rowIndex,1);
												return;
											}
										}
									}
								});
								return;
							}
							
							for (var j=0; j<lenForGrid; j++)
							{
								var test = jsonData.gridJson[j].Test;

								if (test == displayTestName)
								{
									var theField = jsonData.aListTest[j].localName+'_DDD';
									var theFieldWithActualName = jsonData.aListTest[j].actualName+'_DDD';

									var theTestInJsonForAudit = jsonData.gridJson[j].Test;

									var prevValueForAudit = jsonData.gridJson[j].purgePeriod;

									var theFieldforSecondTime = "$_"+jsonData.aListTest[j].actualName+'_DDD';
									var thelocalNameforSecondTime = jsonData.aListTest[j].localName+"_DDD"+"$"+prevValueForAudit;
									var onlyParam = '';
									var onlyActualParam = '';
									var testlocalValueParam = '';
									var testlocalValueParamForIni = '';

									if (aValue != prevValueForAudit)
									{
										if (i == len-1)
										{
											onlyParam = theField + '=' + aValue;
											testlocalValueParam = theFieldforSecondTime + '=' + thelocalNameforSecondTime;
										}
										else
										{
											onlyParam = theField + '=' + aValue + '&';
											testlocalValueParam = theFieldforSecondTime + '=' + thelocalNameforSecondTime + '&';
										}

										if (i == len-1)
										{
											onlyActualParam = theFieldWithActualName + '=' + aValue + '&';
											testlocalValueParamForIni = theFieldforSecondTime + '=' + thelocalNameforSecondTime;
										}
										else
										{
											onlyActualParam = theFieldWithActualName + '=' + aValue + '&';
											testlocalValueParamForIni = theFieldforSecondTime + '=' + thelocalNameforSecondTime + '&';
										}
									}

									queryStringDDDPurgeForIni += onlyActualParam;
									fullStringForIni += testlocalValueParamForIni;
									processQueryStringForIni = queryStringDDDPurgeForIni + '&' + fullStringForIni;

									queryStringDDDPurge += onlyParam;
									fullString += testlocalValueParam;
									processQueryString = queryStringDDDPurge + '&' + fullString;
								}
							}
						}
					}

					Ext.getCmp('purgePeriodsId').setValue(processQueryStringForIni);
					Ext.getCmp('purgePeriodsIdForAudit').setValue(processQueryString);

					var purgePeriodsForm = this.getDddpurgeperiods().getForm();

					var testType = Ext.getCmp("testType").value;
		
					var updateURL;
					if (testType == 'test')
					{
						updateURL = "/final/admin/EgDbSettings/data/EgDBPurgeJSONp.jsp";
					}
					else
					{
						updateURL = "/final/admin/EgDbSettings/data/EgDDDPurgeJSONp.jsp";
					}

					if (purgePeriodsForm.isValid())
					{
						purgePeriodsForm.submit({
							url: updateURL,
							params: thisController.encodeFieldParams(purgePeriodsForm),
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: ddPurgePeriodsTitle,
									msg: ddPurgePeriodUpdateMsg,
									width: 400,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
								click = 0;
								Ext.Ajax.request(
								{
									url : url,
									scope:this,
									method : 'POST',
									success: function(response){
										var jsonText = response.responseText;
										var jsonData = Ext.decode( jsonText );

										var comboCompTypeObj = Ext.getCmp('compType');
										var compTypesFromJson = jsonData.componentList;
										comboCompTypeObj.getStore().loadRawData(compTypesFromJson);
										comboCompTypeObj.setValue(compTypeValue);

										var store = Ext.create('Ext.data.Store', {
											fields: ['Test', 'purgePeriod', 'otherTests'],
											data: jsonData.gridJson,
											proxy: {
												type: "pagingmemory",
												reader: {
													type: "json"
												}
											},
											remoteFilter : true,
											remoteSort: true,
											autoLoad: true,
											pageSize : 20,
											simpleSortMode: true
										});
										mainGridObj.reconfigure(store);
										Ext.getCmp('pagingtoolbarid').bindStore(store);
									}
								});
							},
							failure: function(response){
								Ext.Msg.show({
									title: ddPurgePeriodsTitle,
									msg: ddPurgePeriodNoUpdateMsg,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							},
						});
					}
				}
			});
		}
	},

	searchTests: function(value)
	{
		var egTitleSearchStr = value;
		var mainGridId = Ext.getCmp('mainGrid');
		var testType = Ext.getCmp('testType').getValue();
		var url;
		if ( testType == 'test')
		{
			url = "/final/admin/EgDbSettings/data/EgDBPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue()+"&egTitleSearchStr="+encodeURIComponent(filterEncode(egTitleSearchStr));
		}
		else
		{
			url = "/final/admin/EgDbSettings/data/EgDDDPurgeJSON.jsp?componentType="+Ext.getCmp("compType").getValue()+"&egTitleSearchStr="+encodeURIComponent(filterEncode(egTitleSearchStr));
		}

		Ext.Ajax.request({
				url: url,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );

						mainGridId.getStore().loadRawData(jsonData.gridJson);

						if (mainGridId.getStore().getCount() == 0)
						{
							updatePurgeObj.setDisabled(true);
						}
						else
						{
							updatePurgeObj.setDisabled(false);
						}
					}
				}
			}
		);
	},

});

function checkNumber(value)
{
	var numbers = "0123456789";
	var hasNonNumericalCharacter = "false";

	for (var i=0;i<value.length;i++)
	{
		var strChar = value.charAt(i);

		if (numbers.indexOf(strChar) == -1)
		{
			hasNonNumericalCharacter = "true";
			break;
		}
	}

	if (hasNonNumericalCharacter == "true")
	{
		return false;
	}
	else
	{
		return true;
	}
}



