<%
/**
*  File         : EgConfigFileEdit.jsp
*  Purpose      : To edit ini entries
*  Version      : 1.0
*  Creation Date: 21/11/2006
*  Author       : Antony, Nagarajan
*/
%>

<%@page import="com.eg.IniFile" %>
<%@page import="com.eg.EgInstallInfo" %>
<%@page import="egurkha.reporter.ErUtils"%>
<%@page import="java.util.*"%>
<%@page import="java.io.*" %>
<%@page import="java.net.URLEncoder" %>
<%@ page import="com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgConMonHelper"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.util.FileUtils"%>
<%@ page import="egurkha.EgUIUtils"%>
<%@ page import="com.egurkha.admin.EgToolKitInfo"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	private String decodeValue(String value)
	{
		try
		{
			value = StringUtils.replace(value,"|fnct|","function");
		}
		catch (Exception e)
		{
		}
		return value;
	}
%>

<%
	EgToolKitInfo tkinfo = new EgToolKitInfo();
	if (!tkinfo.isToolkitAccessEnabled)
	{
		return;
	}

	String sessionInUse = request.getParameter("sessionInUse");
	String pwd = request.getParameter("pwd");
	String authenticated = (String)session.getAttribute("authenticated");

	if (authenticated == null)
	{
		// Direct access from the browser address bar or from inside the toolkit via the tool
		if (pwd == null)
		{
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=ConfigFiles");
				return;
			}
			else
			{
%>
				<script>
					window.parent.location.href ="/final/toolkitlogin";
				</script>
<%
				return;
			}
		}
		else
		{
			// Direct access from the browser address bar
			if (!pwd.equals(EgConMonHelper.executePwd))
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=ConfigFiles");
				return;
			}
			else
			{
				session.setAttribute("reqFromForTk","ConfigFiles");
				String redirectURL = request.getContextPath()+"/toolkit";
				response.sendRedirect(redirectURL);
				return;
			}
		}
	}
	else
	{
		// Direct access from the browser address bar and session in use
		if (sessionInUse == null)
		{
			response.sendRedirect(request.getContextPath()+"/toolkit");
			return;
		}
	}
	session.setAttribute("reqFromForTk","ConfigFiles");

	String comeFrom = request.getParameter("comeFrom");
	if (!StringUtils.isNull(comeFrom) && comeFrom.equals("Config"))
	{
		session.setAttribute("treeViewSrc","ConfigFiles");
	}

	ErUtils erUtils = new ErUtils();
	String s_inifile = request.getParameter("ini_list");
	String s_subject = egurkha.EgUIUtils.decodeSecurityChar(request.getParameter("subject_list"));
	String option = request.getParameter("op");
	String sub = egurkha.EgUIUtils.decodeSecurityChar(request.getParameter("subject"));

	String var = egurkha.EgUIUtils.decodeSecurityChar(request.getParameter("variable"));
	if(var != null)
	{
		var = var.trim();
	}
	String value = request.getParameter("value");

	if(value != null)
	{
		if (s_inifile.equalsIgnoreCase("eg_reportTemplate.ini"))
		{
			value = decodeValue(value);
		}
		value = EgUIUtils.decodeSecurityChar(value.trim());
	}
	String old_var = egurkha.EgUIUtils.decodeSecurityChar(request.getParameter("old_variable"));
	String installdir = EgInstallInfo.getInstallDir();
	Vector v_ini = new Vector(FileUtils.getFileList(new File(installdir+ "/manager/config/"),"configFile"));
	Vector v_subjects = new Vector();
	Vector v_variables = new Vector();
	Vector v_data = new Vector();
	boolean showEntry = false;

	String action = request.getParameter("action");
	String sel_sub = request.getParameter("sel_sub");

	if (s_inifile != null && !s_inifile.equals("-1"))
	{
		if(sel_sub != null && !sel_sub.equals("-1"))
		{
			showEntry = true;
		}
		IniFile fi = EgConfigFilesSync.getInstance(installdir+ "/manager/config/"+s_inifile,true);
		if(option != null)
		{
			if(option.equals("newSubject"))
			{
				Vector v_temp = new Vector();
				Vector v_temp1 = new Vector();
				v_temp.add(var);
				v_temp1.add(value);
				boolean b = fi.addSubject(sub,v_temp,v_temp1);
				fi.saveFile();
				showEntry = true;
				sel_sub = sub;
				s_subject= sub;
			}
			else if(option.equals("deleteSubject"))
			{
				fi.deleteSubject(s_subject);
				fi.saveFile();
			}
			else if(option.equals("delete"))
			{
				fi.deleteValue(s_subject,var);
				fi.saveFile();
			}
			else if(option.equals("addVariable"))
			{
				fi.setValue(s_subject,var,value);
				fi.saveFile();
				showEntry = true;
			}
			else if(option.equals("modify"))
			{
				fi.deleteValue(s_subject,old_var);
				fi.setValue(s_subject,var,value);
				fi.saveFile();
				showEntry = true;
			}
			else if(option.equals("back") && s_subject != null && !s_subject.equals("-1"))
			{
				showEntry = true;
			}
		}
		if(s_inifile != null)
		{
			String[] subjects = fi.getSubjects();
			if(subjects != null)
			{
				for(int j=0;j<subjects.length;j++)
				{
					v_subjects.add(subjects[j]);
				}
			}
		}
		if (v_subjects != null && !v_subjects.isEmpty())
		{
			if(option != null && option.equals("delete") && v_subjects.contains(s_subject))
			{
				showEntry = true;
			}
			Collections.sort(v_subjects,String.CASE_INSENSITIVE_ORDER);
		}
		Object[] variables = fi.getVariables(s_subject);
		if (variables != null && variables.length > 0)
		{
			Arrays.sort(variables);
		}
		String val[] = null;
		if (variables != null)
		{
			val = new String[variables.length];
		}
		else
		{
			val = new String [0];
		}

		for(int k=0;k<variables.length;k++)
		{
			v_data.add(variables[k]);
			String s = (String)variables[k];
			val[k] = fi.getValue(s_subject,s);
			if(!val[k].equals(""))
			{
				v_data.add(val[k]);
			}
			else
			{
				v_data.add("-");
			}
		}
		EgConfigFilesSync.releaseInstance(fi);
	}

	String error_msg = null;
	if (v_data.isEmpty())
	{
		if ((sel_sub != null && !sel_sub.equals("-1")) || (s_subject != null && !s_subject.equals("-1")))
		{
			if((option != null && option.equalsIgnoreCase("back")) || (action != null && (action.equalsIgnoreCase("selSubject") || action.equalsIgnoreCase("refresh"))))
			{
				error_msg = "No entries found for this subject.";
			}
		}
	}
%>
<html>
<head>
	<title>Configuration File Updation</title>
	<meta name="created" content="09/04/2001">
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<Link REL = "StyleSheet" href = "eg_styles\adminstyle_blue.css"/>
	<style>

	#maintitle{padding-top: 3px;padding-left:3px;padding-right:3px;padding-bottom:3px;font-size: 13px; font-family: Arial,  Century Gothic, Verdana; font-weight: bold; color: #ffffff;background-color: #00003C;}

	#innerborder{padding-top: 3px;padding-bottom:3px;border-top-width:1px;border-left-width:1px;border-bottom-width:1px; border-right-width:1px;border-style: solid;border-color:#00003c;font-size: 12px; font-family: Arial, Verdana; font-weight: bold; color: #00003C;background-color: #CFD5E9;}

	#tdborderinner{padding-top: 3px;padding-left:3px;padding-right:3px;padding-bottom:3px; border-top-width:1px;border-left-width:0px;border-bottom-width:0px;border-right-width:1px;border-style:solid; border-color:#EBEEF6;font-size: 12px; font-family: Arial, Verdana ; color: #00003C;background-color: #DFE3EF}

	</style>
	<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
	<script language="JavaScript" src="/final/scripts/utilities/EncodeDecodeParams.js"></script>
	<script>
	document.onscroll = function()
	{
		clearTimeout(time);
		time = setTimeout(logout,timeoutTime);
	}
	</script>
	<script language="JavaScript">
	function goTo(op)
	{
		var thisForm = document.EgConfig;
		if(op=="getSubject")
		{
			thisForm.action="/final/admin/EgConfigFile.jsp?sessionInUse=true&sel_sub=-1";
			thisForm.submit();
		}
		else if(op=="getEntries")
		{
			var subject = thisForm.subject_list.value;
			thisForm.action="/final/admin/EgConfigFile.jsp?sessionInUse=true&action=selSubject&sel_sub="+encodeURIComponent(subject);
			thisForm.submit();
		}
	}

	function del(variable,value,s_inifile,temp)
	{
		var thisForm = document.EgConfig;
		var subject = thisForm.subject_list.value;
		var a = confirm("Are you sure you want to delete the variable '" + temp + "'?");
		if(a)
		{
			thisForm.action = "EgConfigFile.jsp?sessionInUse=true&op=delete&subject_list=" + encodeURIComponent(subject) + "&variable="+encodeURIComponent(variable)+"&ini_list="+s_inifile;
			thisForm.submit();
		}
		else
		{
			return;
		}
	}

	function add(s_inifile)
	{
		var thisForm = document.EgConfig;
		thisForm.op.value = "addVariable";
		thisForm.submit();
	}

	function modify(variable,value,inifile)
	{
		var thisForm = document.EgConfig;
			thisForm.op.value = "modify";
			thisForm.variable.value = filterEncode(variable);
			if (inifile == 'eg_reportTemplate.ini')
			{
				thisForm.value.value = encodeValue(value);
			}
			else
			{
				thisForm.value.value = value;
			}
			thisForm.submit();
	}

	function addSubject(inifile)
	{
		var thisForm = document.EgConfig;
		if (thisForm.ini_list.selectedIndex == 0)
		{
			alert("Please select an INI file");
			thisForm.ini_list.focus();
			return false;
		}
		else
		{
			thisForm.op.value = "newSubject";
			thisForm.submit();
		}
	}

	function deleteSubject(inifile)
	{
		var thisForm = document.EgConfig;
		var subject = thisForm.subject_list.value;
		var a = confirm("Are you sure you want to delete the subject '" + filterDecode(subject) + "'?");
		if(a)
		{
			thisForm.action = "EgConfigFile.jsp?sessionInUse=true&op=deleteSubject&subject_list=" + encodeURIComponent(subject) + "&ini_list="+inifile;
			thisForm.op.value = "deleteSubject";
			thisForm.submit();
		}
		else
		{
			return;
		}
	}

	function refresh(iniFile)
	{
		var thisForm = document.EgConfig;
		var subject = thisForm.subject_list.value;
		thisForm.action = "EgConfigFile.jsp?sessionInUse=true&op=refresh&action=refresh&subject_list=" + encodeURIComponent(subject) + "&ini_list="+iniFile+"&sel_sub="+encodeURIComponent(subject);
		thisForm.op.value = "reresh";
		thisForm.submit();
	}
	
	function encodeValue(value)
	{
		var encodeVal = ['function'];
		var decodeVal = ['|fnct|'];
		try
		{
			if(value != null && value != undefined && value.length > 0)
			{
				for(var a in encodeVal)
				{
					var encode_val = encodeVal[a];
					var decode_val = decodeVal[a];
					do
					{
						value = value.replace(encode_val,decode_val);
					}
					while (value.indexOf(encode_val)>-1);
				}
			}
		}
		catch (e)
		{
		}
		return value;
	}
	</script>
</head>

<body style="overflow:auto" id="space6" >
	<form name="EgConfig" method="post" style="margin:0px" action="EgConfigFileEdit.jsp">
	<input type="hidden" name="op" value="">
	<input type="hidden" name="variable" value="">
	<input type="hidden" name="value" value="">
		<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
			<tr>
				<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
			</tr>
			<tr>
				<td width="100%" height="24" id="eg_title" align="center"> &nbsp; eG CONFIGURATION FILE UPDATION</td>
			</tr>
			<tr>
				<td height="20" align="center" colspan="2">
					<table align="center" width="85%" cellspacing="0" cellpadding="4" border="0">
						<tr>
							<td  height="24" nowrap align="right" width="31%" class="eg_cellbglits"><img src="/final/admin/eg_images/info2.gif"> </td>
							<td  height="24" nowrap align="left" class="eg_cellbglits">
							This page enables the administrator to add/modify/delete entries in an INI file.</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
					<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0">
						<tr>
							<td id="eg_blankspace" height="5" nowrap>&nbsp;</td>
						</tr>
						<tr>
							<td align="center" valign="top">
								<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
									<tr>
										<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
										<td height="6" id="eg_subcontentbg" width="100%" colspan="4"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
										<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									</tr>
									<tr>
										<td class="form_spacing">&nbsp;</td>
										<td align="right" width="15%" class="form_spacing" nowrap> INI File
										</td>
										<td align="left" width="30%" class="form_spacing" nowrap>&nbsp;:&nbsp;<select name="ini_list" onChange="javascript:goTo('getSubject')" style='font-size:11px; border:0;width:175px; font-family:Verdana,Arial;'>
										<%=FileUtils.selectOptionList("Please select an INI file",v_ini,s_inifile,true)%>
										</select>
										</td>
										<td align='right' width='13%' class="form_spacing" nowrap> Subject
										</td>
										<td valign='left' width='30%' class="form_spacing" nowrap>&nbsp;:&nbsp;<select name='subject_list' id='subject_list' onChange="javascript:goTo('getEntries')" style='font-size:11px; border:0; width:250px; font-family:Verdana,Arial;'>
										<%=FileUtils.selectOptionList("Please select a subject",v_subjects,s_subject,true)%> </select>
										</td>
										<td class="form_spacing">&nbsp;</td>
									</tr>
									<tr>
										<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
										<td id="eg_subcontentbg"  width="100%" colspan="4" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
										<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
									</tr>
<%
	if (s_inifile != null && !s_inifile.equals("-1"))
	{
%>
									<tr>
										<td colspan="6" id="eg_blankspace" nowrap height="10" class="eg_whitebg">&nbsp;</td>
									</tr>
									<tr>
										<td colspan="6" id="eg_whitebg" nowrap>
											<table border="0" cellspacing="0" cellpadding="0" align="center">
												<tr>
													<td id="eg_whitebg" nowrap><input type="button" value="Add Subject" id="eg_back" WIDTH="10" onClick="javascript:addSubject('<%=s_inifile%>');"></td>
													<td>&nbsp;&nbsp;<td>
													<td id="eg_whitebg" nowrap><input type="button" value="Refresh" id="eg_back" WIDTH="10" onClick="javascript:refresh('<%=s_inifile%>');"></td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td colspan="6" id="eg_blankspace" nowrap height="10" class="eg_whitebg">&nbsp;</td>
									</tr>
<%
	}
%>
								</table>
							</td>
						</tr>
					</table>
<%
	if(showEntry)
	{
%>
					<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0">
						<tr>
							<td colspan="5" id="maintitle" nowrap>&nbsp;&nbsp;<%=s_inifile%></td>
						</tr>
						<tr>
							<td colspan="5">
								<table align="center" cellspacing="0" cellpadding="3" width="100%" border="0" id="cell_border1">
									<tr>
										<td nowrap>&nbsp;&nbsp;<%=s_subject%></td>
										<td align="right" nowrap><input type ="button" value="Delete Subject" WIDTH="10" id="eg_back" onClick="javascript:deleteSubject('<%=s_inifile%>');">&nbsp;&nbsp;<input type ="button" value=" Add Variable" WIDTH="10" id="eg_back" onClick="javascript:add('<%=s_inifile%>');">&nbsp;&nbsp;</td>
									</tr>
								</table>
							</td>
						</tr>
<%
		if (v_data.size()>0)
		{
%>
						<tr>
							<td colspan="5" id="eg_blankspace" nowrap height="10" class="eg_whitebg">&nbsp;</td>
						</tr>
						<tr>
							<td colspan="5" id="eg_whitebg" class="eg_blankspace" height="15" nowrap>&nbsp;</td>
								<table  align="center" cellspacing="0" cellpadding="0" width="85%" border="0" class="eg_subcontentbg">
									<tr>
										<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
										<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
										<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									</tr>
<%
			for(int h=0;h<v_data.size();h++)
			{
				boolean border=(h+2)<v_data.size();
%>
										<tr>
											<td class="<%=border?"form_border":"form_spacing"%>">&nbsp;</td>
											<td valign="top" width="40%" class="<%=border?"form_border":"form_spacing"%>"><div style="word-break:break-all;"><%=(String)v_data.get(h)%></div></td>
											<td valign="top" width="50%" class="<%=border?"form_border":"form_spacing"%>"><div style="word-break:break-all;padding-left:10px"><%out.print((String)v_data.get(h+1));%></div></td>
											<td valign="top" align="center" width="10%" class="<%=border?"form_border":"form_spacing"%>" nowrap>&nbsp;&nbsp;&nbsp;&nbsp;
												<input type ="button" value="Modify"  class="eg_lightbutton" onClick="javascript:modify('<%=(String)v_data.elementAt(h)%>','<%=EgUIUtils.encodeSecurityChar((String)v_data.elementAt(h+1))%>','<%=s_inifile%>')" >
												<input type ="button" value="Delete" class="eg_lightbutton" onClick="javascript:del('<%=(String)v_data.elementAt(h)%>','<%=EgUIUtils.encodeSecurityChar((String)v_data.elementAt(h+1))%>','<%=s_inifile%>','<%=(String)v_data.elementAt(h)%>')" >
											</td>
											<td class="<%=border?"form_border":"form_spacing"%>">&nbsp;</td>
										</tr>
<%
				h++;
			}
%>
									<tr>
										<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
										<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
										<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
<%
		}
	}
%>
			</td>
		</tr>
		<tr>
			<td colspan="5" id="eg_blankspace" nowrap height="10" class="eg_whitebg">&nbsp;</td>
		</tr>
	</table>
<%
	if(error_msg != null)
	{
%>
	<table cellspacing="0" cellpadding="0" border="0" bordercolor="blue" id="dispTab" width="100%" style="margin-top:150px">
		<tr>
			<td align="center" width="100%" valign="middle">
			<img src="/final/admin/eg_images/blue/exclamation-icon.gif"><br>
				<label style="font-family:Arial Narrow;font-size:15px" id="dispLabel"><%=error_msg%></label>
			</td>
		</tr>
	</table>
<%
	}
%>
</form>
</body>
</html>



