/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import com.egurkha.util.EgUtilities;
import java.io.File;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CertConverter {
    String ipAddress = "";
    String hostId = "";
    String company = "";
    String eMail = "";
    String expiryDate = "";
    String product = "";
    String version = "";
    String totalAgents = "";
    String totalSites = "";
    String totalUsers = "";
    String totalExtAgents = "";
    String totalBasic = "";
    String totalSegments = "";
    String totalMTargets = "";
    String totalNDevices = "";
    String totalApps = "";
    String totalAlBasic = "";
    String totalAlPremium = "";
    String totalDesktop = "";
    String ic = "";
    String tt = "";
    String dd = "";
    String extSuMgr = "";
    String eGSuMgr = "";
    String egRep = "";
    String rca = "";
    String sms = "";
    String cm = "";
    String agg = "";
    String cluster = "";
    String aps = "";
    String clEmu = "";
    String license = "";
    String exesDir = "";
    Map licenseInfoMap = null;
    EgUtilities egUtil = EgUtilities.createInstance();

    public CertConverter(String string, String string2) {
        this.exesDir = string;
        this.version = string2;
    }

    private void getLicenceV4Info() {
        String string = this.exesDir + "\\" + "viewCert4 " + this.license;
        this.licenseInfoMap = new HashMap();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        try {
            arrayList = this.egUtil.getExecOutputLines(string);
            if (arrayList != null) {
                arrayList2 = (ArrayList)arrayList.get(0);
            }
            String string2 = "";
            int n = 0;
            while (n < arrayList2.size()) {
                int n2;
                string2 = (String)arrayList2.get(n);
                if (string2.trim().length() > 0 && (n2 = string2.indexOf(":")) > -1) {
                    String string3 = string2.substring(0, n2).trim();
                    String string4 = string2.substring(n2 + 1).trim();
                    this.licenseInfoMap.put(string3, string4);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in executeCmd for viewCert: " + exception);
            exception.printStackTrace();
        }
    }

    private void initialize() {
        if (this.licenseInfoMap == null) {
            throw new NullPointerException("Sorry..! Can't read 4.x License Info...");
        }
        this.ipAddress = this.getValue("IP Address");
        this.hostId = this.getValue("Host ID");
        this.company = this.getValue("Company Name");
        this.eMail = this.getValue("Email Address");
        this.expiryDate = this.getValue("Expiry Date");
        this.product = this.getValue("Product");
        this.totalAgents = this.getValue("No of Agents");
        this.totalSites = this.getValue("No of Web Sites");
        this.totalUsers = this.getValue("No of Monitor Users");
        this.totalExtAgents = this.getValue("No of External Agents");
        this.totalBasic = this.getValue("No of Basic Agents");
        this.totalSegments = this.getValue("No of Segments");
        this.totalMTargets = this.getValue("No of Monitored Targets");
        this.totalNDevices = this.getValue("No of Network Devices");
        this.totalApps = this.getValue("No of Applications");
        this.totalAlBasic = this.getValue("Agentless Systems-Basic");
        this.totalAlPremium = this.getValue("Agentless Systems-Premium");
        this.totalDesktop = this.getValue("No of Desktop Agents");
        this.ic = this.getValue("Integration Console");
        this.tt = this.getValue("Trouble Ticket Manager");
        this.dd = this.getValue("Detailed Diagnosis");
        this.extSuMgr = this.getValue("External Supermanager");
        this.eGSuMgr = this.getValue("eG Supermanager Support");
        this.egRep = this.getValue("eG Reporter");
        this.rca = this.getValue("Remote Control Activities");
        this.sms = this.getValue("SMS Alerts");
        this.cm = this.getValue("Configuration Management");
        this.agg = this.getValue("Metric Aggregation");
        this.cluster = this.getValue("Cluster Type");
        this.aps = this.getValue("Agent Per System");
        this.clEmu = this.getValue("Client Emulation");
    }

    private String getValue(String string) {
        String string2 = "";
        try {
            string2 = this.licenseInfoMap.get(string).toString().trim();
            if (string2 != null && string2.equals("Not Applicable")) {
                string2 = "-1";
            }
        }
        catch (Exception exception) {
            System.out.println("Problem in collecting license4 information.......");
            exception.printStackTrace();
        }
        return string2;
    }

    private void changeHostID() {
        if (this.hostId.equals("Any Host ID")) {
            this.hostId = "-1";
        }
    }

    private void changeProduct() {
        if (this.product.equals("eG Monitoring Suite - Enterprise")) {
            this.product = "1";
        } else if (this.product.equals("eG Monitoring Suite - Reporter Only")) {
            this.product = "2";
        } else if (this.product.equals("eG Monitoring Suite - Super Manager")) {
            this.product = "3";
        }
    }

    private void changeClusterType() {
        if (this.cluster.equals("Active-Active")) {
            this.cluster = "1";
        } else if (this.cluster.equals("Active-Passive")) {
            this.cluster = "2";
        } else if (this.cluster.equals("Not supported")) {
            this.cluster = "3";
        }
    }

    private void changeBasicAgents() {
        if (!this.totalBasic.equals("-1")) {
            if (this.totalAlBasic.equals("-1")) {
                this.totalBasic = "-1";
            } else {
                int n = Integer.parseInt(this.totalBasic);
                int n2 = Integer.parseInt(this.totalAlBasic);
                this.totalBasic = n + n2 + "";
            }
        }
    }

    private void changeTotalAgents() {
        if (!this.totalAgents.equals("-1")) {
            if (this.totalAlBasic.equals("-1")) {
                this.totalAgents = "-1";
            } else if (this.totalAlPremium.equals("-1")) {
                this.totalAgents = "-1";
            } else {
                int n = Integer.parseInt(this.totalAgents);
                int n2 = Integer.parseInt(this.totalAlBasic);
                int n3 = Integer.parseInt(this.totalAlPremium);
                this.totalAgents = n + n2 + n3 + "";
            }
        }
    }

    private boolean changeExpiryDate() {
        long l;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm:ss");
        Date date = simpleDateFormat.parse(this.expiryDate, new ParsePosition(0));
        Date date2 = new Date();
        long l2 = date.getTime();
        if (l2 <= (l = date2.getTime())) {
            return false;
        }
        long l3 = l2 - l;
        long l4 = l3 / 86400000L;
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        int n = calendar.get(11);
        int n2 = calendar2.get(11);
        int n3 = calendar.get(12);
        int n4 = calendar2.get(12);
        int n5 = calendar.get(13);
        int n6 = calendar.get(13);
        Date date3 = simpleDateFormat2.parse(n + ":" + n3 + ":" + n5, new ParsePosition(0));
        Date date4 = simpleDateFormat2.parse(n2 + ":" + n4 + ":" + n6, new ParsePosition(0));
        if (date3.getTime() < date4.getTime()) {
            ++l4;
        }
        this.expiryDate = l4 + "";
        return true;
    }

    private void genLicense(String string) {
        String string2 = this.exesDir + "\\" + "genCert5 " + string + " -ipAddress " + this.ipAddress + " -hosId " + this.hostId + " -company " + this.company + " -eMail " + this.eMail;
        string2 = string2 + " -product " + this.product + " -version " + this.version + " -expiryDays " + this.expiryDate + " -totalMonitors " + this.totalAgents + " -totalSites " + this.totalSites;
        string2 = string2 + " -monitorUsers " + this.totalUsers + " -extAgents " + this.totalExtAgents + " -basicMonitors " + this.totalBasic + " -segments " + this.totalSegments;
        string2 = string2 + " -monitorTargets " + this.totalMTargets + " -nwDevices " + this.totalNDevices + " -apps " + this.totalApps + " -desktopAgents " + this.totalDesktop;
        string2 = string2 + " -egmanagers 0 -ic " + this.ic + " -tt " + this.tt + " -dd " + this.dd + " -extSuperMgr " + this.extSuMgr + " -egSuperMgr " + this.eGSuMgr + " -reporter " + this.egRep + " -remCtrlActivity " + this.rca;
        string2 = string2 + " -sms " + this.sms + " -configMgmt " + this.cm + " -agg " + this.agg + " -cluster " + this.cluster + " -agentPerSystem " + this.aps + " -clEmulation " + this.clEmu;
        try {
            System.out.print(string + "....");
            this.egUtil.getExecOutputLines(string2);
            System.out.println("....generated successfully");
        }
        catch (Exception exception) {
            System.out.println("Error while generating new license..." + string);
            exception.printStackTrace();
        }
    }

    private void setLicenseName(String string) {
        this.license = string;
    }

    public void doConversion(String string, String string2) {
        this.setLicenseName(string);
        this.getLicenceV4Info();
        this.initialize();
        File file = new File(string);
        String string3 = file.getName();
        if (this.changeExpiryDate()) {
            this.changeHostID();
            this.changeProduct();
            this.changeBasicAgents();
            this.changeTotalAgents();
            this.changeClusterType();
            this.genLicense(string2 + "\\" + string3);
        } else {
            System.out.println("Expiry time is lesser then current time for ...." + string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "Usage > java CertConverter -exe <dir> -src <file|dir> -des <dir> -ver <5.X>";
        String string2 = "-exe\tDirectory path of viewCert4.exe and genCert5.exe";
        String string3 = "-src\tFile or directory path of v4.X license(s)";
        String string4 = "-des\tDirectory path to store the newly generated v5.X license(s)";
        String string5 = "-ver\t<MajorVersion>.<MinorVersion>";
        String string6 = "e.g : java CertConverter -exe c:\\temp -src c:\\license4 -des c:\\license5 -ver 5.1";
        if (stringArray.length < 8 || stringArray[0].equalsIgnoreCase("-usage")) {
            System.out.println("\n" + string);
            System.out.println("\n\t" + string2 + "\n\t" + string3 + "\n\t" + string4 + "\n\t" + string5 + "\n\n" + string6);
            return;
        }
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        if (!stringArray[0].equalsIgnoreCase("-exe")) {
            System.out.println(string);
            return;
        }
        string7 = stringArray[1];
        if (!stringArray[2].equalsIgnoreCase("-src")) {
            System.out.println(string);
            return;
        }
        string8 = stringArray[3];
        if (!stringArray[4].equalsIgnoreCase("-des")) {
            System.out.println(string);
            return;
        }
        string9 = stringArray[5];
        if (!stringArray[6].equalsIgnoreCase("-ver")) {
            System.out.println(string);
            return;
        }
        string10 = stringArray[7];
        File file = new File(string7);
        File file2 = new File(string8);
        File file3 = new File(string9);
        if (!file.isDirectory()) {
            System.out.println("\nThe executables(viewCert4 & genCert5) directory is not exist......");
            return;
        }
        File[] fileArray = file.listFiles();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].getAbsolutePath().endsWith("viewCert4.exe")) {
                bl = true;
            }
            if (fileArray[n].getAbsolutePath().endsWith("genCert5.exe")) {
                bl2 = true;
            }
            ++n;
        }
        if (!bl) {
            System.out.println("\nThe viewCert4 is not available.......");
            return;
        }
        if (!bl2) {
            System.out.println("\nThe genCert5 is not available........");
            return;
        }
        CertConverter certConverter = new CertConverter(string7, string10);
        if (!file3.isDirectory()) {
            file3.mkdirs();
        }
        if (file2.isFile()) {
            certConverter.doConversion(string8, string9);
        } else if (file2.isDirectory()) {
            File[] fileArray2 = file2.listFiles();
            int n2 = 0;
            while (n2 < fileArray2.length) {
                if (fileArray2[n2].isFile()) {
                    certConverter.doConversion(fileArray2[n2].getAbsolutePath(), string9);
                }
                ++n2;
            }
        } else {
            System.out.println(" Source file / folder does not exist .....");
        }
    }
}

