/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EgTextDiff {
    public float Diff_Timeout = 1.0f;
    public short Diff_EditCost = (short)4;
    public float Match_Threshold = 0.5f;
    public int Match_Distance = 1000;
    public float Patch_DeleteThreshold = 0.5f;
    public short Patch_Margin = (short)4;
    private short Match_MaxBits = (short)32;
    private Pattern BLANKLINEEND = Pattern.compile("\\n\\r?\\n\\Z", 32);
    private Pattern BLANKLINESTART = Pattern.compile("\\A\\r?\\n\\r?\\n", 32);

    public LinkedList<Diff> diff_main(String string, String string2) {
        return this.diff_main(string, string2, true);
    }

    public ArrayList getDifference(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        LinkedList<Diff> linkedList = new LinkedList();
        ArrayList<String> arrayList = new ArrayList<String>();
        linkedList = this.diff_main(string, string2, true);
        this.diff_cleanupSemantic(linkedList);
        string3 = this.diff_prettyHtml(linkedList);
        string4 = this.diff_removed(linkedList);
        string5 = this.diff_inserted(linkedList);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        return arrayList;
    }

    public LinkedList<Diff> diff_main(String string, String string2, boolean bl) {
        long l = this.Diff_Timeout <= 0.0f ? Long.MAX_VALUE : System.currentTimeMillis() + (long)(this.Diff_Timeout * 1000.0f);
        return this.diff_main(string, string2, bl, l);
    }

    private LinkedList<Diff> diff_main(String string, String string2, boolean bl, long l) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Null inputs. (diff_main)");
        }
        if (string.equals(string2)) {
            LinkedList<Diff> linkedList = new LinkedList<Diff>();
            if (string.length() != 0) {
                linkedList.add(new Diff(Operation.EQUAL, string));
            }
            return linkedList;
        }
        int n = this.diff_commonPrefix(string, string2);
        String string6 = string.substring(0, n);
        string = string.substring(n);
        string2 = string2.substring(n);
        n = this.diff_commonSuffix(string, string2);
        String string7 = string.substring(string.length() - n);
        string = string.substring(0, string.length() - n);
        string2 = string2.substring(0, string2.length() - n);
        LinkedList<Diff> linkedList = this.diff_compute(string, string2, bl, l);
        if (string6.length() != 0) {
            linkedList.addFirst(new Diff(Operation.EQUAL, string6));
        }
        if (string7.length() != 0) {
            linkedList.addLast(new Diff(Operation.EQUAL, string7));
        }
        this.diff_cleanupMerge(linkedList);
        return linkedList;
    }

    private LinkedList<Diff> diff_compute(String stringArray, String string, boolean bl, long l) {
        String string2;
        String string3;
        LinkedList<Diff> linkedList = new LinkedList<Diff>();
        if (stringArray.length() == 0) {
            linkedList.add(new Diff(Operation.INSERT, string));
            this.diff_cleanupSemantic(linkedList);
            return linkedList;
        }
        if (string.length() == 0) {
            linkedList.add(new Diff(Operation.DELETE, (String)stringArray));
            this.diff_cleanupSemantic(linkedList);
            return linkedList;
        }
        String[] stringArray2 = stringArray;
        String string4 = stringArray2.toLowerCase();
        int n = string4.indexOf(string3 = (string2 = string).toLowerCase());
        if (n != -1) {
            Operation operation = stringArray.length() > string.length() ? Operation.DELETE : Operation.INSERT;
            linkedList.add(new Diff(operation, stringArray2.substring(0, n)));
            linkedList.add(new Diff(Operation.EQUAL, string2));
            linkedList.add(new Diff(operation, stringArray2.substring(n + string2.length())));
            this.diff_cleanupSemantic(linkedList);
            return linkedList;
        }
        if (string2.length() == 1) {
            linkedList.add(new Diff(Operation.DELETE, (String)stringArray));
            linkedList.add(new Diff(Operation.INSERT, string));
            this.diff_cleanupSemantic(linkedList);
            return linkedList;
        }
        stringArray2 = this.diff_halfMatch((String)stringArray, string);
        if (stringArray2 != null) {
            string4 = stringArray2[0];
            string2 = stringArray2[1];
            string3 = stringArray2[2];
            String string5 = stringArray2[3];
            String string6 = stringArray2[4];
            LinkedList<Diff> linkedList2 = this.diff_main(string4, string3, bl, l);
            LinkedList<Diff> linkedList3 = this.diff_main(string2, string5, bl, l);
            linkedList = linkedList2;
            linkedList.add(new Diff(Operation.EQUAL, string6));
            linkedList.addAll(linkedList3);
            this.diff_cleanupSemantic(linkedList);
            return linkedList;
        }
        if (bl && stringArray.length() > 5 && string.length() > 5) {
            this.diff_cleanupSemantic(linkedList);
            return this.diff_lineMode((String)stringArray, string, l);
        }
        this.diff_cleanupSemantic(linkedList);
        return this.diff_bisect((String)stringArray, string, l);
    }

    private LinkedList<Diff> diff_lineMode(String string, String string2, long l) {
        LinesToCharsResult linesToCharsResult = this.diff_linesToChars(string, string2);
        string = linesToCharsResult.chars1;
        string2 = linesToCharsResult.chars2;
        List<String> list = linesToCharsResult.lineArray;
        LinkedList<Diff> linkedList = this.diff_main(string, string2, false, l);
        this.diff_charsToLines(linkedList, list);
        this.diff_cleanupSemantic(linkedList);
        linkedList.add(new Diff(Operation.EQUAL, ""));
        int n = 0;
        int n2 = 0;
        String string3 = "";
        String string4 = "";
        ListIterator<Diff> listIterator = linkedList.listIterator();
        Diff diff = (Diff)listIterator.next();
        while (diff != null) {
            switch (diff.operation) {
                case INSERT: {
                    ++n2;
                    string4 = string4 + diff.text;
                    break;
                }
                case DELETE: {
                    ++n;
                    string3 = string3 + diff.text;
                    break;
                }
                case EQUAL: {
                    if (n >= 1 && n2 >= 1) {
                        listIterator.previous();
                        for (int i = 0; i < n + n2; ++i) {
                            listIterator.previous();
                            listIterator.remove();
                        }
                        for (Diff diff2 : this.diff_main(string3, string4, false, l)) {
                            listIterator.add(diff2);
                        }
                    }
                    n2 = 0;
                    n = 0;
                    string3 = "";
                    string4 = "";
                }
            }
            diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
        linkedList.removeLast();
        return linkedList;
    }

    protected LinkedList<Diff> diff_bisect(String string, String string2, long l) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = n2 = (n3 + n4 + 1) / 2;
        int n6 = 2 * n2;
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        for (n = 0; n < n6; ++n) {
            nArray[n] = -1;
            nArray2[n] = -1;
        }
        nArray[n5 + 1] = 0;
        nArray2[n5 + 1] = 0;
        n = n3 - n4;
        boolean bl = n % 2 != 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < n2 && System.currentTimeMillis() <= l; ++i) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            for (n16 = -i + n7; n16 <= i - n8; n16 += 2) {
                n15 = n5 + n16;
                n14 = n16 == -i || n16 != i && nArray[n15 - 1] < nArray[n15 + 1] ? nArray[n15 + 1] : nArray[n15 - 1] + 1;
                for (n13 = n14 - n16; n14 < n3 && n13 < n4 && string.charAt(n14) == string2.charAt(n13); ++n14, ++n13) {
                }
                nArray[n15] = n14;
                if (n14 > n3) {
                    n8 += 2;
                    continue;
                }
                if (n13 > n4) {
                    n7 += 2;
                    continue;
                }
                if (!bl || (n12 = n5 + n - n16) < 0 || n12 >= n6 || nArray2[n12] == -1 || n14 < (n11 = n3 - nArray2[n12])) continue;
                return this.diff_bisectSplit(string, string2, n14, n13, l);
            }
            for (n16 = -i + n9; n16 <= i - n10; n16 += 2) {
                n15 = n5 + n16;
                n14 = n16 == -i || n16 != i && nArray2[n15 - 1] < nArray2[n15 + 1] ? nArray2[n15 + 1] : nArray2[n15 - 1] + 1;
                for (n13 = n14 - n16; n14 < n3 && n13 < n4 && string.charAt(n3 - n14 - 1) == string2.charAt(n4 - n13 - 1); ++n14, ++n13) {
                }
                nArray2[n15] = n14;
                if (n14 > n3) {
                    n10 += 2;
                    continue;
                }
                if (n13 > n4) {
                    n9 += 2;
                    continue;
                }
                if (bl || (n12 = n5 + n - n16) < 0 || n12 >= n6 || nArray[n12] == -1) continue;
                n11 = nArray[n12];
                int n17 = n5 + n11 - n12;
                if (n11 < (n14 = n3 - n14)) continue;
                return this.diff_bisectSplit(string, string2, n11, n17, l);
            }
        }
        LinkedList<Diff> linkedList = new LinkedList<Diff>();
        linkedList.add(new Diff(Operation.DELETE, string));
        linkedList.add(new Diff(Operation.INSERT, string2));
        return linkedList;
    }

    private LinkedList<Diff> diff_bisectSplit(String string, String string2, int n, int n2, long l) {
        String string3 = string.substring(0, n);
        String string4 = string2.substring(0, n2);
        String string5 = string.substring(n);
        String string6 = string2.substring(n2);
        LinkedList<Diff> linkedList = this.diff_main(string3, string4, false, l);
        LinkedList<Diff> linkedList2 = this.diff_main(string5, string6, false, l);
        linkedList.addAll(linkedList2);
        return linkedList;
    }

    protected LinesToCharsResult diff_linesToChars(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        arrayList.add("");
        String string3 = this.diff_linesToCharsMunge(string, arrayList, hashMap);
        String string4 = this.diff_linesToCharsMunge(string2, arrayList, hashMap);
        return new LinesToCharsResult(string3, string4, arrayList);
    }

    private String diff_linesToCharsMunge(String string, List<String> list, Map<String, Integer> map) {
        int n = 0;
        int n2 = -1;
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 < string.length() - 1) {
            n2 = string.indexOf(10, n);
            if (n2 == -1) {
                n2 = string.length() - 1;
            }
            String string2 = string.substring(n, n2 + 1);
            n = n2 + 1;
            if (map.containsKey(string2)) {
                stringBuilder.append(String.valueOf((char)map.get(string2).intValue()));
                continue;
            }
            list.add(string2);
            map.put(string2, list.size() - 1);
            stringBuilder.append(String.valueOf((char)(list.size() - 1)));
        }
        return stringBuilder.toString();
    }

    protected void diff_charsToLines(LinkedList<Diff> linkedList, List<String> list) {
        for (Diff diff : linkedList) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < diff.text.length(); ++i) {
                stringBuilder.append(list.get(diff.text.charAt(i)));
            }
            diff.text = stringBuilder.toString();
        }
    }

    public int diff_commonPrefix(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public int diff_commonSuffix(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = Math.min(n, n2);
        for (int i = 1; i <= n3; ++i) {
            if (string.charAt(n - i) == string2.charAt(n2 - i)) continue;
            return i - 1;
        }
        return n3;
    }

    protected int diff_commonOverlap(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n > n2) {
            string = string.substring(n - n2);
        } else if (n < n2) {
            string2 = string2.substring(0, n);
        }
        int n3 = Math.min(n, n2);
        if (string.equals(string2)) {
            return n3;
        }
        int n4 = 0;
        int n5 = 1;
        String string3;
        int n6;
        while ((n6 = string2.indexOf(string3 = string.substring(n3 - n5))) != -1) {
            if (n6 != 0 && !string.substring(n3 - (n5 += n6)).equals(string2.substring(0, n5))) continue;
            n4 = n5++;
        }
        return n4;
    }

    protected String[] diff_halfMatch(String string, String string2) {
        String[] stringArray;
        String string3;
        if (this.Diff_Timeout <= 0.0f) {
            return null;
        }
        String string4 = string.length() > string2.length() ? string : string2;
        String string5 = string3 = string.length() > string2.length() ? string2 : string;
        if (string4.length() < 4 || string3.length() * 2 < string4.length()) {
            return null;
        }
        String[] stringArray2 = this.diff_halfMatchI(string4, string3, (string4.length() + 3) / 4);
        String[] stringArray3 = this.diff_halfMatchI(string4, string3, (string4.length() + 1) / 2);
        if (stringArray2 == null && stringArray3 == null) {
            return null;
        }
        if (stringArray3 == null) {
            stringArray = stringArray2;
        } else if (stringArray2 == null) {
            stringArray = stringArray3;
        } else {
            String[] stringArray4 = stringArray = stringArray2[4].length() > stringArray3[4].length() ? stringArray2 : stringArray3;
        }
        if (string.length() > string2.length()) {
            return stringArray;
        }
        return new String[]{stringArray[2], stringArray[3], stringArray[0], stringArray[1], stringArray[4]};
    }

    private String[] diff_halfMatchI(String string, String string2, int n) {
        String string3 = string.substring(n, n + string.length() / 4);
        String string4 = string.substring(n, n + string.length() / 4).toLowerCase();
        String string5 = string2.toLowerCase();
        int n2 = -1;
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        while ((n2 = string5.indexOf(string4, n2 + 1)) != -1) {
            int n3 = this.diff_commonPrefix(string.substring(n), string2.substring(n2));
            int n4 = this.diff_commonSuffix(string.substring(0, n), string2.substring(0, n2));
            if (string6.length() >= n4 + n3) continue;
            string6 = string2.substring(n2 - n4, n2) + string2.substring(n2, n2 + n3);
            string7 = string.substring(0, n - n4);
            string8 = string.substring(n + n3);
            string9 = string2.substring(0, n2 - n4);
            string10 = string2.substring(n2 + n3);
        }
        if (string6.length() * 2 >= string.length()) {
            return new String[]{string7, string8, string9, string10, string6};
        }
        return null;
    }

    public void diff_cleanupSemantic(LinkedList<Diff> linkedList) {
        if (linkedList.isEmpty()) {
            return;
        }
        boolean bl = false;
        Stack<Diff> stack = new Stack<Diff>();
        String string = null;
        ListIterator<Diff> listIterator = linkedList.listIterator();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Diff diff = (Diff)listIterator.next();
        while (diff != null) {
            if (diff.operation == Operation.EQUAL) {
                stack.push(diff);
                n = n3;
                n2 = n4;
                n3 = 0;
                n4 = 0;
                string = diff.text;
            } else {
                if (diff.operation == Operation.INSERT) {
                    n3 += diff.text.length();
                } else {
                    n4 += diff.text.length();
                }
                if (string != null && string.length() <= Math.max(n, n2) && string.length() <= Math.max(n3, n4)) {
                    while (diff != stack.lastElement()) {
                        diff = (Diff)listIterator.previous();
                    }
                    listIterator.next();
                    listIterator.set(new Diff(Operation.DELETE, string));
                    listIterator.add(new Diff(Operation.INSERT, string));
                    stack.pop();
                    if (!stack.empty()) {
                        stack.pop();
                    }
                    if (stack.empty()) {
                        while (listIterator.hasPrevious()) {
                            listIterator.previous();
                        }
                    } else {
                        diff = (Diff)stack.lastElement();
                        while (diff != listIterator.previous()) {
                        }
                    }
                    n = 0;
                    n3 = 0;
                    n2 = 0;
                    n4 = 0;
                    string = null;
                    bl = true;
                }
            }
            diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
        if (bl) {
            this.diff_cleanupMerge(linkedList);
        }
        this.diff_cleanupSemanticLossless(linkedList);
        listIterator = linkedList.listIterator();
        Diff diff2 = null;
        diff = null;
        if (listIterator.hasNext()) {
            diff2 = (Diff)listIterator.next();
            if (listIterator.hasNext()) {
                diff = (Diff)listIterator.next();
            }
        }
        while (diff != null) {
            if (diff2.operation == Operation.DELETE && diff.operation == Operation.INSERT) {
                int n5;
                String string2 = diff2.text;
                String string3 = diff.text;
                int n6 = this.diff_commonOverlap(string2, string3);
                if (n6 >= (n5 = this.diff_commonOverlap(string3, string2))) {
                    if ((double)n6 >= (double)string2.length() / 2.0 || (double)n6 >= (double)string3.length() / 2.0) {
                        listIterator.previous();
                        listIterator.add(new Diff(Operation.EQUAL, string3.substring(0, n6)));
                        diff2.text = string2.substring(0, string2.length() - n6);
                        diff.text = string3.substring(n6);
                    }
                } else if ((double)n5 >= (double)string2.length() / 2.0 || (double)n5 >= (double)string3.length() / 2.0) {
                    listIterator.previous();
                    listIterator.add(new Diff(Operation.EQUAL, string2.substring(0, n5)));
                    diff2.operation = Operation.INSERT;
                    diff2.text = string3.substring(0, string3.length() - n5);
                    diff.operation = Operation.DELETE;
                    diff.text = string2.substring(n5);
                }
                diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
            }
            diff2 = diff;
            diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
    }

    public void diff_cleanupSemanticLossless(LinkedList<Diff> linkedList) {
        Diff diff;
        ListIterator listIterator = linkedList.listIterator();
        Diff diff2 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        Diff diff3 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        Diff diff4 = diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        while (diff != null) {
            if (diff2.operation == Operation.EQUAL && diff.operation == Operation.EQUAL) {
                String string = diff2.text;
                String string2 = diff3.text;
                String string3 = diff.text;
                int n = this.diff_commonSuffix(string, string2);
                if (n != 0) {
                    String string4 = string2.substring(string2.length() - n);
                    string = string.substring(0, string.length() - n);
                    string2 = string4 + string2.substring(0, string2.length() - n);
                    string3 = string4 + string3;
                }
                String string5 = string;
                String string6 = string2;
                String string7 = string3;
                int n2 = this.diff_cleanupSemanticScore(string, string2) + this.diff_cleanupSemanticScore(string2, string3);
                while (string2.length() != 0 && string3.length() != 0 && string2.charAt(0) == string3.charAt(0)) {
                    string = string + string2.charAt(0);
                    string2 = string2.substring(1) + string3.charAt(0);
                    string3 = string3.substring(1);
                    int n3 = this.diff_cleanupSemanticScore(string, string2) + this.diff_cleanupSemanticScore(string2, string3);
                    if (n3 < n2) continue;
                    n2 = n3;
                    string5 = string;
                    string6 = string2;
                    string7 = string3;
                }
                if (!diff2.text.equals(string5)) {
                    if (string5.length() != 0) {
                        diff2.text = string5;
                    } else {
                        listIterator.previous();
                        listIterator.previous();
                        listIterator.previous();
                        listIterator.remove();
                        listIterator.next();
                        listIterator.next();
                    }
                    diff3.text = string6;
                    if (string7.length() != 0) {
                        diff.text = string7;
                    } else {
                        listIterator.remove();
                        diff = diff3;
                        diff3 = diff2;
                    }
                }
            }
            diff2 = diff3;
            diff3 = diff;
            diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
    }

    private int diff_cleanupSemanticScore(String string, String string2) {
        boolean bl;
        if (string.length() == 0 || string2.length() == 0) {
            return 6;
        }
        char c = string.charAt(string.length() - 1);
        char c2 = string2.charAt(0);
        boolean bl2 = !Character.isLetterOrDigit(c);
        boolean bl3 = !Character.isLetterOrDigit(c2);
        boolean bl4 = bl2 && Character.isWhitespace(c);
        boolean bl5 = bl3 && Character.isWhitespace(c2);
        boolean bl6 = bl4 && Character.getType(c) == 15;
        boolean bl7 = bl5 && Character.getType(c2) == 15;
        boolean bl8 = bl6 && this.BLANKLINEEND.matcher(string).find();
        boolean bl9 = bl = bl7 && this.BLANKLINESTART.matcher(string2).find();
        if (bl8 || bl) {
            return 5;
        }
        if (bl6 || bl7) {
            return 4;
        }
        if (bl2 && !bl4 && bl5) {
            return 3;
        }
        if (bl4 || bl5) {
            return 2;
        }
        if (bl2 || bl3) {
            return 1;
        }
        return 0;
    }

    public void diff_cleanupEfficiency(LinkedList<Diff> linkedList) {
        Diff diff;
        if (linkedList.isEmpty()) {
            return;
        }
        boolean bl = false;
        Stack<Diff> stack = new Stack<Diff>();
        String string = null;
        ListIterator<Diff> listIterator = linkedList.listIterator();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Diff diff2 = diff = (Diff)listIterator.next();
        while (diff != null) {
            if (diff.operation == Operation.EQUAL) {
                if (diff.text.length() < this.Diff_EditCost && (bl4 || bl5)) {
                    stack.push(diff);
                    bl2 = bl4;
                    bl3 = bl5;
                    string = diff.text;
                } else {
                    stack.clear();
                    string = null;
                    diff2 = diff;
                }
                bl5 = false;
                bl4 = false;
            } else {
                if (diff.operation == Operation.DELETE) {
                    bl5 = true;
                } else {
                    bl4 = true;
                }
                if (string != null && (bl2 && bl3 && bl4 && bl5 || string.length() < this.Diff_EditCost / 2 && (bl2 ? 1 : 0) + (bl3 ? 1 : 0) + (bl4 ? 1 : 0) + (bl5 ? 1 : 0) == 3)) {
                    while (diff != stack.lastElement()) {
                        diff = (Diff)listIterator.previous();
                    }
                    listIterator.next();
                    listIterator.set(new Diff(Operation.DELETE, string));
                    diff = new Diff(Operation.INSERT, string);
                    listIterator.add(diff);
                    stack.pop();
                    string = null;
                    if (bl2 && bl3) {
                        bl5 = true;
                        bl4 = true;
                        stack.clear();
                        diff2 = diff;
                    } else {
                        if (!stack.empty()) {
                            stack.pop();
                        }
                        diff = stack.empty() ? diff2 : (Diff)stack.lastElement();
                        while (diff != listIterator.previous()) {
                        }
                        bl5 = false;
                        bl4 = false;
                    }
                    bl = true;
                }
            }
            diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
        if (bl) {
            this.diff_cleanupMerge(linkedList);
        }
    }

    public void diff_cleanupMerge(LinkedList<Diff> linkedList) {
        Diff diff;
        boolean bl;
        linkedList.add(new Diff(Operation.EQUAL, ""));
        ListIterator<Diff> listIterator = linkedList.listIterator();
        int n = 0;
        int n2 = 0;
        String string = "";
        String string2 = "";
        Diff diff2 = (Diff)listIterator.next();
        Diff diff3 = null;
        while (diff2 != null) {
            switch (diff2.operation) {
                case INSERT: {
                    ++n2;
                    string2 = string2 + diff2.text;
                    diff3 = null;
                    break;
                }
                case DELETE: {
                    ++n;
                    string = string + diff2.text;
                    diff3 = null;
                    break;
                }
                case EQUAL: {
                    if (n + n2 > 1) {
                        bl = n != 0 && n2 != 0;
                        listIterator.previous();
                        while (n-- > 0) {
                            listIterator.previous();
                            listIterator.remove();
                        }
                        while (n2-- > 0) {
                            listIterator.previous();
                            listIterator.remove();
                        }
                        if (bl) {
                            int n3 = this.diff_commonPrefix(string2, string);
                            if (n3 != 0) {
                                if (listIterator.hasPrevious()) {
                                    diff2 = (Diff)listIterator.previous();
                                    assert (diff2.operation == Operation.EQUAL) : "Previous diff should have been an equality.";
                                    diff2.text = diff2.text + string2.substring(0, n3);
                                    listIterator.next();
                                } else {
                                    listIterator.add(new Diff(Operation.EQUAL, string2.substring(0, n3)));
                                }
                                string2 = string2.substring(n3);
                                string = string.substring(n3);
                            }
                            if ((n3 = this.diff_commonSuffix(string2, string)) != 0) {
                                diff2 = (Diff)listIterator.next();
                                diff2.text = string2.substring(string2.length() - n3) + diff2.text;
                                string2 = string2.substring(0, string2.length() - n3);
                                string = string.substring(0, string.length() - n3);
                                listIterator.previous();
                            }
                        }
                        if (string.length() != 0) {
                            listIterator.add(new Diff(Operation.DELETE, string));
                        }
                        if (string2.length() != 0) {
                            listIterator.add(new Diff(Operation.INSERT, string2));
                        }
                        diff2 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
                    } else if (diff3 != null) {
                        diff3.text = diff3.text + diff2.text;
                        listIterator.remove();
                        diff2 = (Diff)listIterator.previous();
                        listIterator.next();
                    }
                    n2 = 0;
                    n = 0;
                    string = "";
                    string2 = "";
                    diff3 = diff2;
                }
            }
            diff2 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
        if (linkedList.getLast().text.length() == 0) {
            linkedList.removeLast();
        }
        bl = false;
        listIterator = linkedList.listIterator();
        Diff diff4 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        diff2 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        Diff diff5 = diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        while (diff != null) {
            if (diff4.operation == Operation.EQUAL && diff.operation == Operation.EQUAL) {
                if (diff2.text.endsWith(diff4.text)) {
                    diff2.text = diff4.text + diff2.text.substring(0, diff2.text.length() - diff4.text.length());
                    diff.text = diff4.text + diff.text;
                    listIterator.previous();
                    listIterator.previous();
                    listIterator.previous();
                    listIterator.remove();
                    listIterator.next();
                    diff2 = (Diff)listIterator.next();
                    diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
                    bl = true;
                } else if (diff2.text.startsWith(diff.text)) {
                    diff4.text = diff4.text + diff.text;
                    diff2.text = diff2.text.substring(diff.text.length()) + diff.text;
                    listIterator.remove();
                    diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
                    bl = true;
                }
            }
            diff4 = diff2;
            diff2 = diff;
            diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
        if (bl) {
            this.diff_cleanupMerge(linkedList);
        }
    }

    public int diff_xIndex(LinkedList<Diff> linkedList, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Diff diff = null;
        for (Diff diff2 : linkedList) {
            if (diff2.operation != Operation.INSERT) {
                n2 += diff2.text.length();
            }
            if (diff2.operation != Operation.DELETE) {
                n3 += diff2.text.length();
            }
            if (n2 > n) {
                diff = diff2;
                break;
            }
            n4 = n2;
            n5 = n3;
        }
        if (diff != null && diff.operation == Operation.DELETE) {
            return n5;
        }
        return n5 + (n - n4);
    }

    public String diff_prettyHtml(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Diff diff : linkedList) {
            String string = diff.text;
            if (!linkedList.get((int)0).text.startsWith("<?config?>")) {
                string = diff.text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "&para;<br>");
            }
            switch (diff.operation) {
                case INSERT: {
                    stringBuilder.append("<ins>").append("<span class='diff_panel_win'>").append(string).append("</span>").append("</ins>");
                    break;
                }
                case DELETE: {
                    stringBuilder.append("<del>").append("<span class='diff_panel_win'>").append(string).append("</span>").append("</del>");
                    break;
                }
                case EQUAL: {
                    stringBuilder.append("<span>").append(string).append("</span>");
                }
            }
        }
        return stringBuilder.toString();
    }

    public String diff_text1(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Diff diff : linkedList) {
            if (diff.operation != Operation.DELETE) continue;
            stringBuilder2.append("<del class='diff_panel_win'>").append(diff.text).append("</del>");
        }
        return stringBuilder2.toString();
    }

    public String diff_removed(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (Diff diff : linkedList) {
            if (diff.text.length() <= 0 || diff.operation != Operation.DELETE) continue;
            string = string + "<del><span class='diff_panel_win'>" + diff.text + "</span></del>&nbsp&nbsp&nbsp";
        }
        return string;
    }

    public String diff_inserted(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (Diff diff : linkedList) {
            if (diff.text.length() <= 0 || diff.operation != Operation.INSERT) continue;
            string = string + "<ins><span class='diff_panel_win'>" + diff.text + "</span></ins>&nbsp&nbsp&nbsp";
        }
        return string;
    }

    public String diff_text11(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Diff diff : linkedList) {
            if (diff.operation == Operation.INSERT) continue;
            stringBuilder.append(diff.text);
        }
        return stringBuilder.toString();
    }

    public String diff_text12(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Diff diff : linkedList) {
            if (diff.operation == Operation.DELETE) continue;
            stringBuilder.append(diff.text);
        }
        return stringBuilder.toString();
    }

    public String diff_text2(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Diff diff : linkedList) {
            if (diff.operation != Operation.INSERT) continue;
            stringBuilder2.append("<ins class='diff_panel_win'>").append(diff.text).append("</ins>");
        }
        return stringBuilder2.toString();
    }

    public int diff_levenshtein(LinkedList<Diff> linkedList) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Diff diff : linkedList) {
            switch (diff.operation) {
                case INSERT: {
                    n2 += diff.text.length();
                    break;
                }
                case DELETE: {
                    n3 += diff.text.length();
                    break;
                }
                case EQUAL: {
                    n += Math.max(n2, n3);
                    n2 = 0;
                    n3 = 0;
                }
            }
        }
        return n += Math.max(n2, n3);
    }

    public String diff_toDelta(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Diff diff : linkedList) {
            switch (diff.operation) {
                case INSERT: {
                    try {
                        stringBuilder.append("+").append(URLEncoder.encode(diff.text, "UTF-8").replace('+', ' ')).append("\t");
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new Error("This system does not support UTF-8.", unsupportedEncodingException);
                    }
                }
                case DELETE: {
                    stringBuilder.append("-").append(diff.text.length()).append("\t");
                    break;
                }
                case EQUAL: {
                    stringBuilder.append("=").append(diff.text.length()).append("\t");
                }
            }
        }
        Object object = stringBuilder.toString();
        if (((String)object).length() != 0) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
            object = EgTextDiff.unescapeForEncodeUriCompatability((String)object);
        }
        return object;
    }

    public LinkedList<Diff> diff_fromDelta(String string, String string2) throws IllegalArgumentException {
        String[] stringArray;
        LinkedList<Diff> linkedList = new LinkedList<Diff>();
        int n = 0;
        block11: for (String string3 : stringArray = string2.split("\t")) {
            if (string3.length() == 0) continue;
            String string4 = string3.substring(1);
            switch (string3.charAt(0)) {
                case '+': {
                    string4 = string4.replace("+", "%2B");
                    try {
                        string4 = URLDecoder.decode(string4, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new Error("This system does not support UTF-8.", unsupportedEncodingException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalArgumentException("Illegal escape in diff_fromDelta: " + string4, illegalArgumentException);
                    }
                    linkedList.add(new Diff(Operation.INSERT, string4));
                    continue block11;
                }
                case '-': 
                case '=': {
                    String string5;
                    int n2;
                    try {
                        n2 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Invalid number in diff_fromDelta: " + string4, numberFormatException);
                    }
                    if (n2 < 0) {
                        throw new IllegalArgumentException("Negative number in diff_fromDelta: " + string4);
                    }
                    try {
                        string5 = string.substring(n, n += n2);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        throw new IllegalArgumentException("Delta length (" + n + ") larger than source text length (" + string.length() + ").", stringIndexOutOfBoundsException);
                    }
                    if (string3.charAt(0) == '=') {
                        linkedList.add(new Diff(Operation.EQUAL, string5));
                        continue block11;
                    }
                    linkedList.add(new Diff(Operation.DELETE, string5));
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Invalid diff operation in diff_fromDelta: " + string3.charAt(0));
                }
            }
        }
        if (n != string.length()) {
            throw new IllegalArgumentException("Delta length (" + n + ") smaller than source text length (" + string.length() + ").");
        }
        return linkedList;
    }

    public int match_main(String string, String string2, int n) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Null inputs. (match_main)");
        }
        n = Math.max(0, Math.min(n, string.length()));
        if (string.equals(string2)) {
            return 0;
        }
        if (string.length() == 0) {
            return -1;
        }
        if (n + string2.length() <= string.length() && string.substring(n, n + string2.length()).equals(string2)) {
            return n;
        }
        return this.match_bitap(string, string2, n);
    }

    protected int match_bitap(String string, String string2, int n) {
        assert (this.Match_MaxBits == 0 || string2.length() <= this.Match_MaxBits) : "Pattern too long for this application.";
        Map<Character, Integer> map = this.match_alphabet(string2);
        double d = this.Match_Threshold;
        int n2 = string.indexOf(string2, n);
        if (n2 != -1) {
            d = Math.min(this.match_bitapScore(0, n2, n, string2), d);
            n2 = string.lastIndexOf(string2, n + string2.length());
            if (n2 != -1) {
                d = Math.min(this.match_bitapScore(0, n2, n, string2), d);
            }
        }
        int n3 = 1 << string2.length() - 1;
        n2 = -1;
        int n4 = string2.length() + string.length();
        int[] nArray = new int[]{};
        for (int i = 0; i < string2.length(); ++i) {
            int n5 = 0;
            int n6 = n4;
            while (n5 < n6) {
                if (this.match_bitapScore(i, n + n6, n, string2) <= d) {
                    n5 = n6;
                } else {
                    n4 = n6;
                }
                n6 = (n4 - n5) / 2 + n5;
            }
            n4 = n6;
            int n7 = Math.max(1, n - n6 + 1);
            int n8 = Math.min(n + n6, string.length()) + string2.length();
            int[] nArray2 = new int[n8 + 2];
            nArray2[n8 + 1] = (1 << i) - 1;
            for (int j = n8; j >= n7; --j) {
                double d2;
                int n9 = string.length() <= j - 1 || !map.containsKey(Character.valueOf(string.charAt(j - 1))) ? 0 : map.get(Character.valueOf(string.charAt(j - 1)));
                nArray2[j] = i == 0 ? (nArray2[j + 1] << 1 | 1) & n9 : (nArray2[j + 1] << 1 | 1) & n9 | ((nArray[j + 1] | nArray[j]) << 1 | 1) | nArray[j + 1];
                if ((nArray2[j] & n3) == 0 || !((d2 = this.match_bitapScore(i, j - 1, n, string2)) <= d)) continue;
                d = d2;
                n2 = j - 1;
                if (n2 <= n) break;
                n7 = Math.max(1, 2 * n - n2);
            }
            if (this.match_bitapScore(i + 1, n, n, string2) > d) break;
            nArray = nArray2;
        }
        return n2;
    }

    private double match_bitapScore(int n, int n2, int n3, String string) {
        float f = (float)n / (float)string.length();
        int n4 = Math.abs(n3 - n2);
        if (this.Match_Distance == 0) {
            return n4 == 0 ? (double)f : 1.0;
        }
        return f + (float)n4 / (float)this.Match_Distance;
    }

    /*
     * WARNING - void declaration
     */
    protected Map<Character, Integer> match_alphabet(String string) {
        void var7_11;
        char[] cArray;
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        for (char n : cArray = string.toCharArray()) {
            hashMap.put(Character.valueOf(n), 0);
        }
        int n = 0;
        char[] cArray2 = cArray;
        int n2 = cArray2.length;
        boolean bl = false;
        while (var7_11 < n2) {
            char c = cArray2[var7_11];
            hashMap.put(Character.valueOf(c), (Integer)hashMap.get(Character.valueOf(c)) | 1 << string.length() - n - 1);
            ++n;
            ++var7_11;
        }
        return hashMap;
    }

    protected void patch_addContext(Patch patch, String string) {
        String string2;
        if (string.length() == 0) {
            return;
        }
        String string3 = string.substring(patch.start2, patch.start2 + patch.length1);
        int n = 0;
        while (string.indexOf(string3) != string.lastIndexOf(string3) && string3.length() < this.Match_MaxBits - this.Patch_Margin - this.Patch_Margin) {
            string3 = string.substring(Math.max(0, patch.start2 - (n += this.Patch_Margin)), Math.min(string.length(), patch.start2 + patch.length1 + n));
        }
        String string4 = string.substring(Math.max(0, patch.start2 - (n += this.Patch_Margin)), patch.start2);
        if (string4.length() != 0) {
            patch.diffs.addFirst(new Diff(Operation.EQUAL, string4));
        }
        if ((string2 = string.substring(patch.start2 + patch.length1, Math.min(string.length(), patch.start2 + patch.length1 + n))).length() != 0) {
            patch.diffs.addLast(new Diff(Operation.EQUAL, string2));
        }
        patch.start1 -= string4.length();
        patch.start2 -= string4.length();
        patch.length1 += string4.length() + string2.length();
        patch.length2 += string4.length() + string2.length();
    }

    public LinkedList<Patch> patch_make(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Null inputs. (patch_make)");
        }
        LinkedList<Diff> linkedList = this.diff_main(string, string2, true);
        if (linkedList.size() > 2) {
            this.diff_cleanupSemantic(linkedList);
            this.diff_cleanupEfficiency(linkedList);
        }
        return this.patch_make(string, linkedList);
    }

    public LinkedList<Patch> patch_make(LinkedList<Diff> linkedList) {
        if (linkedList == null) {
            throw new IllegalArgumentException("Null inputs. (patch_make)");
        }
        String string = this.diff_text1(linkedList);
        return this.patch_make(string, linkedList);
    }

    public LinkedList<Patch> patch_make(String string, String string2, LinkedList<Diff> linkedList) {
        return this.patch_make(string, linkedList);
    }

    public LinkedList<Patch> patch_make(String string, LinkedList<Diff> linkedList) {
        if (string == null || linkedList == null) {
            throw new IllegalArgumentException("Null inputs. (patch_make)");
        }
        LinkedList<Patch> linkedList2 = new LinkedList<Patch>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        Patch patch = new Patch();
        int n = 0;
        int n2 = 0;
        String string2 = string;
        String string3 = string;
        for (Diff diff : linkedList) {
            if (patch.diffs.isEmpty() && diff.operation != Operation.EQUAL) {
                patch.start1 = n;
                patch.start2 = n2;
            }
            switch (diff.operation) {
                case INSERT: {
                    patch.diffs.add(diff);
                    patch.length2 += diff.text.length();
                    string3 = string3.substring(0, n2) + diff.text + string3.substring(n2);
                    break;
                }
                case DELETE: {
                    patch.length1 += diff.text.length();
                    patch.diffs.add(diff);
                    string3 = string3.substring(0, n2) + string3.substring(n2 + diff.text.length());
                    break;
                }
                case EQUAL: {
                    if (diff.text.length() <= 2 * this.Patch_Margin && !patch.diffs.isEmpty() && diff != linkedList.getLast()) {
                        patch.diffs.add(diff);
                        patch.length1 += diff.text.length();
                        patch.length2 += diff.text.length();
                    }
                    if (diff.text.length() < 2 * this.Patch_Margin || patch.diffs.isEmpty()) break;
                    this.patch_addContext(patch, string2);
                    linkedList2.add(patch);
                    patch = new Patch();
                    string2 = string3;
                    n = n2;
                }
            }
            if (diff.operation != Operation.INSERT) {
                n += diff.text.length();
            }
            if (diff.operation == Operation.DELETE) continue;
            n2 += diff.text.length();
        }
        if (!patch.diffs.isEmpty()) {
            this.patch_addContext(patch, string2);
            linkedList2.add(patch);
        }
        return linkedList2;
    }

    public LinkedList<Patch> patch_deepCopy(LinkedList<Patch> linkedList) {
        LinkedList<Patch> linkedList2 = new LinkedList<Patch>();
        for (Patch patch : linkedList) {
            Patch patch2 = new Patch();
            for (Diff diff : patch.diffs) {
                Diff diff2 = new Diff(diff.operation, diff.text);
                patch2.diffs.add(diff2);
            }
            patch2.start1 = patch.start1;
            patch2.start2 = patch.start2;
            patch2.length1 = patch.length1;
            patch2.length2 = patch.length2;
            linkedList2.add(patch2);
        }
        return linkedList2;
    }

    public Object[] patch_apply(LinkedList<Patch> linkedList, String string) {
        if (linkedList.isEmpty()) {
            return new Object[]{string, new boolean[0]};
        }
        linkedList = this.patch_deepCopy(linkedList);
        String string2 = this.patch_addPadding(linkedList);
        string = string2 + string + string2;
        this.patch_splitMax(linkedList);
        int n = 0;
        int n2 = 0;
        boolean[] blArray = new boolean[linkedList.size()];
        for (Patch patch : linkedList) {
            int n3;
            int n4 = patch.start2 + n2;
            String string3 = this.diff_text1(patch.diffs);
            int n5 = -1;
            if (string3.length() > this.Match_MaxBits) {
                n3 = this.match_main(string, string3.substring(0, this.Match_MaxBits), n4);
                if (n3 != -1 && ((n5 = this.match_main(string, string3.substring(string3.length() - this.Match_MaxBits), n4 + string3.length() - this.Match_MaxBits)) == -1 || n3 >= n5)) {
                    n3 = -1;
                }
            } else {
                n3 = this.match_main(string, string3, n4);
            }
            if (n3 == -1) {
                blArray[n] = false;
                n2 -= patch.length2 - patch.length1;
            } else {
                blArray[n] = true;
                n2 = n3 - n4;
                String string4 = n5 == -1 ? string.substring(n3, Math.min(n3 + string3.length(), string.length())) : string.substring(n3, Math.min(n5 + this.Match_MaxBits, string.length()));
                if (string3.equals(string4)) {
                    string = string.substring(0, n3) + this.diff_text2(patch.diffs) + string.substring(n3 + string3.length());
                } else {
                    LinkedList<Diff> linkedList2 = this.diff_main(string3, string4, false);
                    if (string3.length() > this.Match_MaxBits && (float)this.diff_levenshtein(linkedList2) / (float)string3.length() > this.Patch_DeleteThreshold) {
                        blArray[n] = false;
                    } else {
                        this.diff_cleanupSemanticLossless(linkedList2);
                        int n6 = 0;
                        for (Diff diff : patch.diffs) {
                            if (diff.operation != Operation.EQUAL) {
                                int n7 = this.diff_xIndex(linkedList2, n6);
                                if (diff.operation == Operation.INSERT) {
                                    string = string.substring(0, n3 + n7) + diff.text + string.substring(n3 + n7);
                                } else if (diff.operation == Operation.DELETE) {
                                    string = string.substring(0, n3 + n7) + string.substring(n3 + this.diff_xIndex(linkedList2, n6 + diff.text.length()));
                                }
                            }
                            if (diff.operation == Operation.DELETE) continue;
                            n6 += diff.text.length();
                        }
                    }
                }
            }
            ++n;
        }
        string = string.substring(string2.length(), string.length() - string2.length());
        return new Object[]{string, blArray};
    }

    public String patch_addPadding(LinkedList<Patch> linkedList) {
        int n;
        Diff diff;
        short s = this.Patch_Margin;
        String string = "";
        for (short s2 = 1; s2 <= s; s2 = (short)(s2 + 1)) {
            string = string + String.valueOf((char)s2);
        }
        for (Patch linkedList22 : linkedList) {
            linkedList22.start1 += s;
            linkedList22.start2 += s;
        }
        Object object = linkedList.getFirst();
        LinkedList<Diff> linkedList2 = ((Patch)object).diffs;
        if (linkedList2.isEmpty() || linkedList2.getFirst().operation != Operation.EQUAL) {
            linkedList2.addFirst(new Diff(Operation.EQUAL, string));
            ((Patch)object).start1 -= s;
            ((Patch)object).start2 -= s;
            ((Patch)object).length1 += s;
            ((Patch)object).length2 += s;
        } else if (s > linkedList2.getFirst().text.length()) {
            diff = linkedList2.getFirst();
            n = s - diff.text.length();
            diff.text = string.substring(diff.text.length()) + diff.text;
            ((Patch)object).start1 -= n;
            ((Patch)object).start2 -= n;
            ((Patch)object).length1 += n;
            ((Patch)object).length2 += n;
        }
        object = linkedList.getLast();
        LinkedList<Diff> linkedList3 = ((Patch)object).diffs;
        if (linkedList3.isEmpty() || linkedList3.getLast().operation != Operation.EQUAL) {
            linkedList3.addLast(new Diff(Operation.EQUAL, string));
            ((Patch)object).length1 += s;
            ((Patch)object).length2 += s;
        } else if (s > linkedList3.getLast().text.length()) {
            diff = linkedList3.getLast();
            n = s - diff.text.length();
            diff.text = diff.text + string.substring(0, n);
            ((Patch)object).length1 += n;
            ((Patch)object).length2 += n;
        }
        return string;
    }

    public void patch_splitMax(LinkedList<Patch> linkedList) {
        Patch patch;
        short s = this.Match_MaxBits;
        ListIterator<Patch> listIterator = linkedList.listIterator();
        Patch patch2 = patch = listIterator.hasNext() ? (Patch)listIterator.next() : null;
        while (patch != null) {
            if (patch.length1 <= this.Match_MaxBits) {
                patch = listIterator.hasNext() ? (Patch)listIterator.next() : null;
                continue;
            }
            listIterator.remove();
            int n = patch.start1;
            int n2 = patch.start2;
            String string = "";
            while (!patch.diffs.isEmpty()) {
                Patch patch3 = new Patch();
                boolean bl = true;
                patch3.start1 = n - string.length();
                patch3.start2 = n2 - string.length();
                if (string.length() != 0) {
                    patch3.length1 = patch3.length2 = string.length();
                    patch3.diffs.add(new Diff(Operation.EQUAL, string));
                }
                while (!patch.diffs.isEmpty() && patch3.length1 < s - this.Patch_Margin) {
                    Operation operation = patch.diffs.getFirst().operation;
                    String string2 = patch.diffs.getFirst().text;
                    if (operation == Operation.INSERT) {
                        patch3.length2 += string2.length();
                        n2 += string2.length();
                        patch3.diffs.addLast(patch.diffs.removeFirst());
                        bl = false;
                        continue;
                    }
                    if (operation == Operation.DELETE && patch3.diffs.size() == 1 && patch3.diffs.getFirst().operation == Operation.EQUAL && string2.length() > 2 * s) {
                        patch3.length1 += string2.length();
                        n += string2.length();
                        bl = false;
                        patch3.diffs.add(new Diff(operation, string2));
                        patch.diffs.removeFirst();
                        continue;
                    }
                    string2 = string2.substring(0, Math.min(string2.length(), s - patch3.length1 - this.Patch_Margin));
                    patch3.length1 += string2.length();
                    n += string2.length();
                    if (operation == Operation.EQUAL) {
                        patch3.length2 += string2.length();
                        n2 += string2.length();
                    } else {
                        bl = false;
                    }
                    patch3.diffs.add(new Diff(operation, string2));
                    if (string2.equals(patch.diffs.getFirst().text)) {
                        patch.diffs.removeFirst();
                        continue;
                    }
                    patch.diffs.getFirst().text = patch.diffs.getFirst().text.substring(string2.length());
                }
                string = this.diff_text2(patch3.diffs);
                string = string.substring(Math.max(0, string.length() - this.Patch_Margin));
                String string3 = this.diff_text1(patch.diffs).length() > this.Patch_Margin ? this.diff_text1(patch.diffs).substring(0, this.Patch_Margin) : this.diff_text1(patch.diffs);
                if (string3.length() != 0) {
                    patch3.length1 += string3.length();
                    patch3.length2 += string3.length();
                    if (!patch3.diffs.isEmpty() && patch3.diffs.getLast().operation == Operation.EQUAL) {
                        patch3.diffs.getLast().text = patch3.diffs.getLast().text + string3;
                    } else {
                        patch3.diffs.add(new Diff(Operation.EQUAL, string3));
                    }
                }
                if (bl) continue;
                listIterator.add(patch3);
            }
            patch = listIterator.hasNext() ? (Patch)listIterator.next() : null;
        }
    }

    public String patch_toText(List<Patch> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Patch patch : list) {
            stringBuilder.append(patch);
        }
        return stringBuilder.toString();
    }

    public List<Patch> patch_fromText(String string) throws IllegalArgumentException {
        LinkedList<Patch> linkedList = new LinkedList<Patch>();
        if (string.length() == 0) {
            return linkedList;
        }
        List<String> list = Arrays.asList(string.split("\n"));
        LinkedList<String> linkedList2 = new LinkedList<String>(list);
        Pattern pattern = Pattern.compile("^@@ -(\\d+),?(\\d*) \\+(\\d+),?(\\d*) @@$");
        block5: while (!linkedList2.isEmpty()) {
            Matcher matcher = pattern.matcher(linkedList2.getFirst());
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid patch string: " + linkedList2.getFirst());
            }
            Patch patch = new Patch();
            linkedList.add(patch);
            patch.start1 = Integer.parseInt(matcher.group(1));
            if (matcher.group(2).length() == 0) {
                --patch.start1;
                patch.length1 = 1;
            } else if (matcher.group(2).equals("0")) {
                patch.length1 = 0;
            } else {
                --patch.start1;
                patch.length1 = Integer.parseInt(matcher.group(2));
            }
            patch.start2 = Integer.parseInt(matcher.group(3));
            if (matcher.group(4).length() == 0) {
                --patch.start2;
                patch.length2 = 1;
            } else if (matcher.group(4).equals("0")) {
                patch.length2 = 0;
            } else {
                --patch.start2;
                patch.length2 = Integer.parseInt(matcher.group(4));
            }
            linkedList2.removeFirst();
            while (!linkedList2.isEmpty()) {
                char c;
                try {
                    c = linkedList2.getFirst().charAt(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    linkedList2.removeFirst();
                    continue;
                }
                String string2 = linkedList2.getFirst().substring(1);
                string2 = string2.replace("+", "%2B");
                try {
                    string2 = URLDecoder.decode(string2, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new Error("This system does not support UTF-8.", unsupportedEncodingException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Illegal escape in patch_fromText: " + string2, illegalArgumentException);
                }
                if (c == '-') {
                    patch.diffs.add(new Diff(Operation.DELETE, string2));
                } else if (c == '+') {
                    patch.diffs.add(new Diff(Operation.INSERT, string2));
                } else if (c == ' ') {
                    patch.diffs.add(new Diff(Operation.EQUAL, string2));
                } else {
                    if (c == '@') continue block5;
                    throw new IllegalArgumentException("Invalid patch mode '" + c + "' in: " + string2);
                }
                linkedList2.removeFirst();
            }
        }
        return linkedList;
    }

    private static String unescapeForEncodeUriCompatability(String string) {
        return string.replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%3B", ";").replace("%2F", "/").replace("%3F", "?").replace("%3A", ":").replace("%40", "@").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%2C", ",").replace("%23", "#");
    }

    public static class Patch {
        public LinkedList<Diff> diffs = new LinkedList();
        public int start1;
        public int start2;
        public int length1;
        public int length2;

        public String toString() {
            String string = this.length1 == 0 ? this.start1 + ",0" : (this.length1 == 1 ? Integer.toString(this.start1 + 1) : this.start1 + 1 + "," + this.length1);
            String string2 = this.length2 == 0 ? this.start2 + ",0" : (this.length2 == 1 ? Integer.toString(this.start2 + 1) : this.start2 + 1 + "," + this.length2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("@@ -").append(string).append(" +").append(string2).append(" @@\n");
            for (Diff diff : this.diffs) {
                switch (diff.operation) {
                    case INSERT: {
                        stringBuilder.append('+');
                        break;
                    }
                    case DELETE: {
                        stringBuilder.append('-');
                        break;
                    }
                    case EQUAL: {
                        stringBuilder.append(' ');
                    }
                }
                try {
                    stringBuilder.append(URLEncoder.encode(diff.text, "UTF-8").replace('+', ' ')).append("\n");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new Error("This system does not support UTF-8.", unsupportedEncodingException);
                }
            }
            return EgTextDiff.unescapeForEncodeUriCompatability(stringBuilder.toString());
        }
    }

    public static class Diff {
        public Operation operation;
        public String text;

        public Diff(Operation operation, String string) {
            this.operation = operation;
            this.text = string;
        }

        public String toString() {
            String string = this.text.replace('\n', '\u00b6');
            return "Diff(" + (Object)((Object)this.operation) + ",\"" + string + "\")";
        }

        public int hashCode() {
            int n = this.operation == null ? 0 : this.operation.hashCode();
            return n += 31 * (this.text == null ? 0 : this.text.hashCode());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Diff diff = (Diff)object;
            if (this.operation != diff.operation) {
                return false;
            }
            return !(this.text == null ? diff.text != null : !this.text.equals(diff.text));
        }
    }

    public static enum Operation {
        DELETE,
        INSERT,
        EQUAL;

    }

    protected static class LinesToCharsResult {
        protected String chars1;
        protected String chars2;
        protected List<String> lineArray;

        protected LinesToCharsResult(String string, String string2, List<String> list) {
            this.chars1 = string;
            this.chars2 = string2;
            this.lineArray = list;
        }
    }
}

