'use strict';

var shimmer = require('./shimmer')
var logger = require('../../../logger')
var appendMsg = 'common-timers :'
function wrapTimer(agent) {

    var timers = [
        'setTimeout',
        'setInterval'
    ]

    shimmer.massWrap(
        global,
        timers,
        wrapTimer
    )

    function wrapTimer(fn, name) {
        
        return function () {

            var span = agent.buildSpan();

            if (!span) {
                //Temp commment this becoz mongodb-core function used this setTimeout method frequently
                //debug("span is null")
                return fn.apply(this, arguments);
            }
            var cbName = '';

            if (typeof arguments[0] === 'function') {

                cbName = arguments[0].name || 'anonymous';

                arguments[0] = wrapCallback(arguments[0])

                function wrapCallback(cb) {

                    return function wrappedCallback() {

                        if (span) span.end()

                        return cb.apply(this, arguments)
                    }
                }
            }

            var result = fn.apply(this, arguments)

            if (span) span.start(cbName, 'Timer:' + name)
            span.cbName = cbName
            
            return result;
        }
    }

    logger.info(appendMsg, "wrapped TIMER module")
}

module.exports = wrapTimer;